/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;

public class FlowAnalysisTest
extends AbstractRegressionTest {
    public FlowAnalysisTest(String name) {
        super(name);
    }

    public static Test suite() {
        return FlowAnalysisTest.buildAllCompliancesTestSuite(FlowAnalysisTest.testClass());
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic String foo(int i) {\n\t\tif (true) {\n\t\t\treturn null;\n\t\t}\n\t\tif (i > 0) {\n\t\t\treturn null;\n\t\t}\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic String foo(int i) {\n\t              ^^^^^^^^^^\nThis method must return a result of type String\n----------\n2. WARNING in X.java (at line 6)\n\tif (i > 0) {\n\t\t\treturn null;\n\t\t}\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n");
    }

    public void test002() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test() {\n        int c1, c2;\n        while ((char) (c1 = 0) == 1) {}\n        if (c1 == 0) {} // silent\n        if (c2 == 0) {} // complain\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n", null, true, options);
    }

    public void test003() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test() {\n        int c1, c2;\n        while ((char) (c1 = 0) == 1) ;\n        if (c1 == 0) {} // silent\n        if (c2 == 0) {} // complain\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n", null, true, options);
    }

    public void test004() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test() {\n        int c1, c2;\n        for (;(char) (c1 = 0) == 1;) ;\n        if (c1 == 0) {} // silent\n        if (c2 == 0) {} // complain\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n", null, true, options);
    }

    public void test005() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test() {\n        int c1, c2;\n        do ; while ((char) (c1 = 0) == 1);\n        if (c1 == 0) {} // silent\n        if (c2 == 0) {} // complain\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n", null, true, options);
    }

    public void test006() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n        case 1:\n            System.out.println(1); // complain: possible fall-through\n            break;\n        case 2:\n            System.out.println(3); // silent because of break\n            return;\n        case 3:                            // silent because of return\n        case 4:                            // silent because grouped cases\n        default:\n            System.out.println(\"default\"); //$NON-NLS-1$\n        }\n    }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 6)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test007() {
        if (this.complianceLevel == 0x310000L) {
            Map options = this.getCompilerOptions();
            options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "warning");
            this.runNegativeTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings(\"fallthrough\")\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n        case 1:\n            System.out.println(1); // silent because of SuppressWarnings\n        }\n    }\n    void foo() {\n\t\tZork z;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, options);
        }
    }

    public void test008() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n            if (true) {\n              return;\n            }\n        case 1:\n            System.out.println(1);\n        }\n    }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 9)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test009() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void test(int p, boolean b) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n            if (b) {\n              return;\n            }\n            else {\n              return;\n            }\n        case 1:\n            System.out.println(1);\n        }\n    }\n}"}, "", null, true, null, options, null);
    }

    public void test010() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n    public void test(int p, boolean b) {\n        switch (p) {\n        case 0:\n            System.exit(0);\n        case 1:\n            System.out.println(1);\n        }\n    }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 6)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test011() {
        if (this.complianceLevel == 0x310000L) {
            Map options = this.getCompilerOptions();
            options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "warning");
            this.runNegativeTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings(\"all\")\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n        case 1:\n            System.out.println(1); // silent because of SuppressWarnings\n        }\n    }\n\tZork z;\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, options);
        }
    }

    public void _test012() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n            // on purpose fall-through\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "", null, true, null, options, null);
    }

    public void _test013() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n            // on purpose fall-through\n        default:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "", null, true, null, options, null);
    }

    public void test014() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n        default:\n            System.out.println(1); // complain: possible fall-through\n        }\n    }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 6)\n\tdefault:\n\t^^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test015() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n            // on purpose fall-through\n\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 8)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test016() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n            // on purpose fall-through\n            /* other comment */\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 8)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void _test017() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n// on purpose fall-through\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "", null, true, null, options, null);
    }

    public void _test018() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n            //\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "", null, true, null, options, null);
    }

    public void test019() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n    public void test(int p, boolean b) {\n        switch (p) {\n        case 0:\n            if (b) {\n              break;\n            }\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 8)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n        case 1:\n            System.out.println(1); // silent because default level is ignore\n        }\n    }\n\tZork z;\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test021() {
        if (ProblemReporter.getProblemCategory((int)0, (int)0x200000C2) != 90) {
            FlowAnalysisTest.fail((String)"bad category for fall-through case problem");
        }
    }

    public void test022() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tif (true)\n            ;\n        else\n            ;\n\t}\n}"}, null, options, "----------\n1. ERROR in X.java (at line 4)\n\t;\n\t^\nEmpty control-flow statement\n----------\n2. ERROR in X.java (at line 6)\n\t;\n\t^\nEmpty control-flow statement\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test023() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tfinal X x;\n\t\twhile (true) {\n\t\t\tif (true) {\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tx = new X();\n\t\t}\n\t\tx.foo();\n\t}\n\tpublic void foo() {\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 8)\n\tx = new X();\n\t^^^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 10)\n\tx.foo();\n\t^\nThe local variable x may not have been initialized\n----------\n", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public void foo(boolean b) {\n    final Object l;\n    do {\n      if (b) {\n        l = new Object();\n        break;\n      }\n    } while (false);\n    l.toString();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tl.toString();\n\t^\nThe local variable l may not have been initialized\n----------\n");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"[starting]\");\n\t\tX l = new X();\n\t\tl.testLoop();\n\t\tSystem.out.println(\"[finished]\");\n\t}\n\n\tpublic void testLoop() {\n\t\tint loops = 0;\n\n\t\tdo {\n\t\t\tSystem.out.print(\"[Loop \" + loops + \"]\");\n\t\t\tif (loops > 2) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif (loops < 4) {\n\t\t\t\t++loops;\n\t\t\t\tcontinue; \n\t\t\t}\n\t\t} while (false);\n\t}\n\n}\n"}, "[starting][Loop 0][finished]");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(Object o1) {\n    int a00, a01, a02, a03, a04, a05, a06, a07, a08, a09;\n    int a10, a11, a12, a13, a14, a15, a16, a17, a18, a19;\n    int a20, a21, a22, a23, a24, a25, a26, a27, a28, a29;\n    int a30, a31, a32, a33, a34, a35, a36, a37, a38, a39;\n    int a40, a41, a42, a43, a44, a45, a46, a47, a48, a49;\n    int a50, a51, a52, a53, a54, a55, a56, a57, a58, a59;\n    int a60, a61, a62, a63, a64, a65, a66, a67, a68, a69;\n    String s;\n    Object o2 = o1;\n    if (o2 == null) {\n      s = \"\";\n    }\n    System.out.println(s);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 15)\n\tSystem.out.println(s);\n\t                   ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    String s;\n    if (args.length == 0) {\n      s = \"s\";\n    } else {\n      s = args[0];\n    }\n    System.out.println(s + \"-\" + s + \"-\" + s + \"-\" +\n                       s + \"-\" + s + \"-\" + s + \"-\" +\n                       s + \"-\" + s + \"-\" + s + \"-\" +\n                       s + \"-\" + s + \"-\" + s + \"-\" +\n                       s + \"-\" + s + \"-\" + s + \"-\");\n  }\n}"}, "s-s-s-s-s-s-s-s-s-s-s-s-s-s-s-");
    }

    public void test028() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n   {\n      if (true) throw new NullPointerException();\n   }\n}\n"}, "");
        String expectedOutput = "  public X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [8]\n     4  new java.lang.NullPointerException [10]\n     7  dup\n     8  invokespecial java.lang.NullPointerException() [12]\n    11  athrow\n      Line numbers:\n        [pc: 0, line: 1]\n        [pc: 4, line: 3]\n      Local variable table:\n        [pc: 0, pc: 12] local: this index: 0 type: X\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            FlowAnalysisTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test029() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n   {\n      if (true) throw new NullPointerException();\n   }\n   X() {\n      System.out.println();\n   }\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [8]\n     4  new java.lang.NullPointerException [10]\n     7  dup\n     8  invokespecial java.lang.NullPointerException() [12]\n    11  athrow\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 4, line: 3]\n      Local variable table:\n        [pc: 0, pc: 12] local: this index: 0 type: X\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            FlowAnalysisTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test030() throws Exception {
        this.runConformTest(new String[]{"X.java", "class Y {\n\tY(Object o) {\n\t\tSystem.out.print(o);\n\t}\n}\n\npublic class X extends Y {\n\t{\n\t\tif (true)\n\t\t\tthrow new NullPointerException();\n\t}\n\n\tX() {\n\t\tsuper(new Object() {\n\t\t\tpublic String toString() {\n\t\t\t\treturn \"SUCCESS:\";\n\t\t\t}\n\t\t});\n\t\tSystem.out.println();\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X();\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"caught:NPE\");\n\t\t}\n\t}\n}\n"}, "SUCCESS:caught:NPE");
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 3, Locals: 1\n  X();\n     0  aload_0 [this]\n     1  new X$1 [8]\n     4  dup\n     5  invokespecial X$1() [10]\n     8  invokespecial Y(java.lang.Object) [12]\n    11  new java.lang.NullPointerException [15]\n    14  dup\n    15  invokespecial java.lang.NullPointerException() [17]\n    18  athrow\n      Line numbers:\n        [pc: 0, line: 14]\n        [pc: 11, line: 10]\n      Local variable table:\n        [pc: 0, pc: 19] local: this index: 0 type: X\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            FlowAnalysisTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "class Y {\n\tY(Object o) {\n\t}\n}\n\npublic class X extends Y {\n\tfinal int blank;\n\t{\n\t\tif (true)\n\t\t\tthrow new NullPointerException();\n\t}\n\n\tX() {\n\t\tsuper(new Object() {});\n\t}\n}\n"}, "");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.java", "class Y {\n\tY(int i) {\n\t}\n}\n\npublic class X extends Y {\n\tfinal int blank;\n\t{\n\t\tif (true)\n\t\t\tthrow new NullPointerException();\n\t}\n\n\tX() {\n\t\tsuper(blank = 0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tsuper(blank = 0);\n\t      ^^^^^\nCannot refer to an instance field blank while explicitly invoking a constructor\n----------\n");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "class Y {\n\tY(int i) {\n\t}\n}\npublic class X extends Y {\n\tfinal int blank;\n\t{\n\t\tif (true)\n\t\t\tthrow new NullPointerException();\n\t}\n\tX() {\n\t\tsuper(0);\n\t\tblank = 0;\n\t}\n}\n"}, "");
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo1() {\n    switch (1) {\n    case 0:\n      final int i = 1;\n    case i: // should complain: i not initialized\n      System.out.println(i); // should complain: i not initialized\n    }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase i: // should complain: i not initialized\n\t     ^\nThe local variable i may not have been initialized\n----------\n2. ERROR in X.java (at line 7)\n\tSystem.out.println(i); // should complain: i not initialized\n\t                   ^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo2() {\n    switch (1) {\n    case 0:\n      int j = 0;\n    case 1:\n      System.out.println(j); // should complain: j not initialized\n    }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(j); // should complain: j not initialized\n\t                   ^\nThe local variable j may not have been initialized\n----------\n");
    }

    public void test036() {
        String src = "public class X {\n  void foo3() {\n    switch (1) {\n    case 0:\n      class Local {\n      }\n      ;\n    case 1:\n      new Local();\n    }\n  }\n}";
        if (this.complianceLevel <= 0x2F0000L) {
            this.runConformTest(new String[]{"X.java", src}, "");
        } else {
            this.runNegativeTest(new String[]{"X.java", src}, "----------\n1. ERROR in X.java (at line 9)\n\tnew Local();\n\t    ^^^^^\nLocal cannot be resolved to a type\n----------\n");
        }
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo() {\n    if (false) {\n      String s;\n      System.out.println(s);\n    }\n  }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tif (false) {\n      String s;\n      System.out.println(s);\n    }\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 5)\n\tSystem.out.println(s);\n\t                   ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    String s;\n    if (false) {\n      System.out.println(s);\n    }\n  }\n}"}, "");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo() {\n    if (false) {\n      String s;\n      if (System.out != null) {\n        System.out.println(s);\n      }\n    }\n  }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tif (false) {\n      String s;\n      if (System.out != null) {\n        System.out.println(s);\n      }\n    }\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 6)\n\tSystem.out.println(s);\n\t                   ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo() {\n    final String s = \"\";\n    if (false) {\n      s = \"\";\n    }\n  }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (false) {\n      s = \"\";\n    }\n\t           ^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 5)\n\ts = \"\";\n\t^\nThe final local variable s cannot be assigned. It must be blank and not using a compound assignment\n----------\n");
    }

    public void test041() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    final String s;\n    s = \"\";\n    if (false) {\n      s = \"\";\n    }\n  }\n}"}, "");
    }

    public void test042() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo() {\n    final String s;\n    if (false) {\n      s = \"\";\n    }\n    s = \"\";\n  }\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tif (false) {\n      s = \"\";\n    }\n\t           ^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 7)\n\ts = \"\";\n\t^\nThe final local variable s may already have been assigned\n----------\n");
    }

    public void test043() {
        this.runConformTest(new String[]{"X.java", "public abstract class X {\n  public static void main(String[] args) {\n    for (int i = 0; i < 3; i++) {\n      System.out.print(i);\n      switch (i) {\n        case 1:\n          final int j;\n          j = 1;\n          System.out.println(j);\n          break;\n        case 2:\n          j = 2;\n          System.out.println(j);\n      }\n    }\n  }\n}\n"}, "011\n22");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X {\n  public static void main(String[] args) {\n    for (int i = 0; i < 3; i++) {\n      System.out.print(i);\n      switch (i) {\n        case 1:\n          final int j = 1;\n          System.out.println(j);\n          break;\n        case 2:\n          j = 2;\n          System.out.println(j);\n      }\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tj = 2;\n\t^\nThe final local variable j cannot be assigned. It must be blank and not using a compound assignment\n----------\n");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X {\n  public static void main(String[] args) {\n    switch (args.length) {\n      case 1:\n        final int j = 1;\n      case 2:\n        switch (5) {\n          case j:\n        }\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase j:\n\t     ^\nThe local variable j may not have been initialized\n----------\n");
    }

    public void test046() {
        this.runConformTest(true, new String[]{"X.java", "public abstract class X {\n  public static void main(String args[]) {\n    for (final int i; 0 < (i = 1); i = i + 1) {\n      System.out.println(i);\n      break;\n    }\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tfor (final int i; 0 < (i = 1); i = i + 1) {\n\t                               ^^^^^^^^^\nDead code\n----------\n", "1", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug4660984);
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public void foo() {\n    done: do\n      break done;\n    while (false);\n    System.out.println();\n  }\n}\n"}, "");
    }

    public void test048() {
        this.runTest(new String[]{"X.java", "public class X {\n  private static final boolean b = false;\n  public Object foo() {\n    if (b) {\n      label: while (bar()) {\n      }\n      return null;\n    }\n    return null;\n  }\n  boolean bar() {\n    return false;\n  }\n}\n"}, false, "----------\n1. WARNING in X.java (at line 5)\n\tlabel: while (bar()) {\n\t^^^^^\nThe label label is never explicitly referenced\n----------\n", "", "", false, null, true, null, null, null, true);
    }

    public void test049() {
        this.runTest(new String[]{"X.java", "public class X {\n  private static final boolean b = false;\n  public Object foo() {\n    if (b) {\n      while (bar()) {\n      }\n      return null;\n    }\n    return null;\n  }\n  boolean bar() {\n    return false;\n  }\n}\n"}, false, "", "", "", false, null, true, null, null, null, true);
    }

    public void test050_definite_assigment_and_if_true() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  final int i;\n  X() {\n    if (true) {\n      throw new NullPointerException();\n    }\n  }\n}\n"});
    }

    public void test051_definite_assigment_and_if_true() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  X() {\n    final int i;\n    if (true) {\n      throw new NullPointerException();\n    }\n    System.out.println(i);\n  }\n}\n"});
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(boolean b) {\n\t\tif (b && false) {\n\t\t\tint i = 0; // deadcode\n\t\t\treturn;  // 1\n\t\t}\n\t\treturn;\n\t\treturn;\n\t}\n}\t\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tif (b && false) {\n\t\t\tint i = 0; // deadcode\n\t\t\treturn;  // 1\n\t\t}\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 8)\n\treturn;\n\t^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(boolean b) {\n\t\tif (false && b) {\n\t\t\tint j = 0; // deadcode\n\t\t\treturn; // 2\n\t\t}\n\t\treturn;\n\t\treturn;\n\t}\n}\t\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tif (false && b) {\n\t             ^\nDead code\n----------\n2. WARNING in X.java (at line 3)\n\tif (false && b) {\n\t\t\tint j = 0; // deadcode\n\t\t\treturn; // 2\n\t\t}\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n3. ERROR in X.java (at line 8)\n\treturn;\n\t^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(boolean b) {\n\t\twhile (true) {\n\t\t\tif (true) break;\n\t\t\tint k = 0; // deadcode\n\t\t}\n\t\treturn;\n\t\treturn;\n\t}\n}\t\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tint k = 0; // deadcode\n\t^^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 8)\n\treturn;\n\t^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(boolean b) {\n\t\tif (true || b) {\n\t\t\tint l = 0; // deadcode\n\t\t\treturn; // 2a\n\t\t}\t\t\n\t\treturn;\n\t\treturn;\n\t}\n}\t\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tif (true || b) {\n\t            ^\nDead code\n----------\n2. WARNING in X.java (at line 7)\n\treturn;\n\t^^^^^^^\nDead code\n----------\n3. ERROR in X.java (at line 8)\n\treturn;\n\t^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test056() {
        if (this.complianceLevel < 0x300000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar() {\n\t\treturn;\n\t\t{\n\t\t\treturn; // 3\n\t\t}\n\t}\n\tvoid baz() {\n\t\treturn;\n\t\t{\n\t\t}\n\t}\t\n\tvoid baz2() {\n\t\treturn;\n\t\t; // 4\n\t}\t\n}\t\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t{\n\t\t\treturn; // 3\n\t\t}\n\t^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n2. ERROR in X.java (at line 10)\n\t{\n\t\t}\n\t^^^^^\nUnreachable code\n----------\n");
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar() {\n\t\treturn;\n\t\t{\n\t\t\treturn; // 3\n\t\t}\n\t}\n\tvoid baz() {\n\t\treturn;\n\t\t{\n\t\t}\n\t}\t\n\tvoid baz2() {\n\t\treturn;\n\t\t; // 4\n\t}\t\n}\t\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t{\n\t\t\treturn; // 3\n\t\t}\n\t^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n2. ERROR in X.java (at line 10)\n\t{\n\t\t}\n\t^^^^^\nUnreachable code\n----------\n3. ERROR in X.java (at line 15)\n\t; // 4\n\t^\nUnreachable code\n----------\n");
    }

    public void test057() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(int x, int[] array) {\n\t\tfor (int i = 0; \n\t\t     i < array.length; \n\t\t     i++) {//dead code\n\t\t\tif (x == array[i])\n\t\t\t\treturn;\n\t\t\telse\n\t\t\t\tbreak;\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\ti++) {//dead code\n\t^^^\nDead code\n----------\n2. WARNING in X.java (at line 9)\n\tbreak;\n\t^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n");
    }

    public void test058() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tif (false) {\n\t\t\tclass Local {\n\t\t\t\tint i = 12;\n\t\t\t\t{   i++; }\n\t\t\t\tvoid method() {\n\t\t\t\t\tif (false)\n\t\t\t\t\t\tSystem.out.println();\n\t\t\t\t\treturn;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tif (false) {\n\t\t\tclass Local {\n\t\t\t\tint i = 12;\n\t\t\t\t{   i++; }\n\t\t\t\tvoid method() {\n\t\t\t\t\tif (false)\n\t\t\t\t\t\tSystem.out.println();\n\t\t\t\t\treturn;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. WARNING in X.java (at line 4)\n\tclass Local {\n\t      ^^^^^\nThe type Local is never used locally\n----------\n3. WARNING in X.java (at line 7)\n\tvoid method() {\n\t     ^^^^^^^^\nThe method method() from the type Local is never used locally\n----------\n4. ERROR in X.java (at line 11)\n\treturn;\n\t^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test059() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(boolean b) {\n\t\tint i = false && b ? 0 : 1;\n\t\tif (false) {\n\t\t\tint j = false && b ? 0 : 1;\n\t\t}\n\t\treturn;\n\t\treturn;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tint i = false && b ? 0 : 1;\n\t                 ^\nDead code\n----------\n2. WARNING in X.java (at line 3)\n\tint i = false && b ? 0 : 1;\n\t                     ^\nDead code\n----------\n3. WARNING in X.java (at line 4)\n\tif (false) {\n\t\t\tint j = false && b ? 0 : 1;\n\t\t}\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n4. ERROR in X.java (at line 8)\n\treturn;\n\t^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test060() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic final boolean DEBUG = false;\n\tstatic final int DEBUG_LEVEL = 0;\n\tboolean check() { return true; }\n\tvoid foo(boolean b) {\n\t\tif (DEBUG)\n\t\t\tSystem.out.println(\"fake reachable1\"); //$NON-NLS-1$\n\t\tif (DEBUG && b)\n\t\t\tSystem.out.println(\"fake reachable2\"); //$NON-NLS-1$\n\t\tif (DEBUG && check())\n\t\t\tSystem.out.println(\"fake reachable3\"); //$NON-NLS-1$\n\t\tif (b && DEBUG)\n\t\t\tSystem.out.println(\"fake reachable4\"); //$NON-NLS-1$\n\t\tif (check() && DEBUG)\n\t\t\tSystem.out.println(\"fake reachable5\"); //$NON-NLS-1$\n\t\tif (DEBUG_LEVEL > 1) \n\t\t\tSystem.out.println(\"fake reachable6\"); //$NON-NLS-1$\n\t\treturn;\n\t\treturn;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tif (DEBUG && b)\n\t             ^\nDead code\n----------\n2. WARNING in X.java (at line 9)\n\tSystem.out.println(\"fake reachable2\"); //$NON-NLS-1$\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n3. WARNING in X.java (at line 10)\n\tif (DEBUG && check())\n\t             ^^^^^^^\nDead code\n----------\n4. WARNING in X.java (at line 11)\n\tSystem.out.println(\"fake reachable3\"); //$NON-NLS-1$\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n5. WARNING in X.java (at line 13)\n\tSystem.out.println(\"fake reachable4\"); //$NON-NLS-1$\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n6. WARNING in X.java (at line 15)\n\tSystem.out.println(\"fake reachable5\"); //$NON-NLS-1$\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n7. WARNING in X.java (at line 17)\n\tSystem.out.println(\"fake reachable6\"); //$NON-NLS-1$\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n8. ERROR in X.java (at line 19)\n\treturn;\n\t^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test061() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n        private static final boolean isIS() {\n                return System.currentTimeMillis()<0 ;\n        }\n        public static void main(String[] args) {\n                do {\n                        return;\n                } while(isIS() && false);\n        }\n}\n"}, "");
        String expectedOutput = "  public static void main(java.lang.String[] args);\n    0  return\n      Line numbers:\n        [pc: 0, line: 7]\n      Local variable table:\n        [pc: 0, pc: 1] local: args index: 0 type: java.lang.String[]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            FlowAnalysisTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test062() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        private static final boolean isIS() {\n                return System.currentTimeMillis()<0 ;\n        }\n        public static void main(String[] args) {\n                do {\n                        return;\n                } while(isIS() && false);\n                return;\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\treturn;\n\t^^^^^^^\nUnreachable code\n----------\n");
    }

    public void test063() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   boolean bar() { return false; } \n\tpublic void foo() {\t\tif (bar())\n\t\t\tnew IllegalArgumentException(\"You must not bar!\");\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tnew IllegalArgumentException(\"You must not bar!\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe allocated object is never used\n----------\n", null, true, compilerOptions);
    }

    public void test064() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   boolean bar() { return false; } \n\tpublic void foo() {\t\tif (bar())\n\t\t\tnew String(\"You must not bar!\");\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tnew String(\"You must not bar!\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe allocated object is never used\n----------\n", null, true, compilerOptions);
    }

    public void test065() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "warning");
        this.runConformTest(new String[]{"X.java", "public class X {\n   boolean bar() { return false; }\n   @SuppressWarnings(\"unused\")\n\tpublic void foo() {\t\tif (bar())\n\t\t\tnew IllegalArgumentException(\"You must not bar!\");\n\t}\n}"}, "", null, true, null, compilerOptions, null);
    }

    public void test066() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   boolean bar() { return false; }\n\tpublic void foo() {\t\tif (bar())\n\t\t\tnew IllegalArgumentException(\"You must not bar!\");\n\t}\n}"}, "");
    }

    public void test067() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n   boolean bar() { return false; }\n   Throwable t;\n\tpublic void foo() {\t\tt = new IllegalArgumentException(\"You must not bar!\");\n\t}\n}"}, "", null, true, null, compilerOptions, null);
    }

    public void test068() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n   boolean bar() { return false; }\n\tpublic void foo() {\t\tif (bar())\n\t\t\tnew IllegalArgumentException(\"You must not bar!\").printStackTrace();\n\t}\n}"}, "", null, true, null, compilerOptions, null);
    }

    public void test069() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   boolean bar() { return false; } \n\tpublic void foo() {\t\tif (bar())\n\t\t\tnew Object() {};\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tnew Object() {};\n\t^^^^^^^^^^^^^^^\nThe allocated object is never used\n----------\n", null, true, compilerOptions);
    }

    public void test070() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "error");
        this.runNegativeTest(new String[]{"X.java", "public final class X {\n    private X (){\n        boolean flagSet = true;\n        Object first = true ? null : \"\";        \n        Object second = flagSet || first == null ? null :\n            new Object() {};\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tObject first = true ? null : \"\";        \n\t                             ^^\nDead code\n----------\n", null, true, compilerOptions);
    }

    public void test071() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n  static {\n    try {\n      while(true) {\n          if (true)\n              throw new NumberFormatException();\n          else\n              throw new IOException();\n      }\n    } catch(IOException e ) {\n        // empty\n    } \n  } \n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tthrow new IOException();\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n2. WARNING in X.java (at line 9)\n\tthrow new IOException();\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n");
    }

    public void testBug338234a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        int i;\n        String str = null;\n        if (str != null)\n            i++;    \n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\ti++;    \n\t^^^\nDead code\n----------\n2. ERROR in X.java (at line 6)\n\ti++;    \n\t^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void testBug338234b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        int i;\n        l: {\n\t\t\tif(false)\n\t\t\t\tbreak l;\n        \treturn;\n\t\t }\n        i++;    \n    }\n}\n"}, "");
    }

    public void testBug338234c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public final int field1;\n    {\n        int i;\n        String str = null;\n\t\t if(str != null)\n\t\t\ti = field1;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic final int field1;\n\t                 ^^^^^^\nThe blank final field field1 may not have been initialized\n----------\n2. WARNING in X.java (at line 7)\n\ti = field1;\n\t^^^^^^^^^^\nDead code\n----------\n3. ERROR in X.java (at line 7)\n\ti = field1;\n\t    ^^^^^^\nThe blank final field field1 may not have been initialized\n----------\n");
    }

    public void testBug338234d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    void foo(boolean b) {\n        int i;\n\t\t String str = null;\n        if(b){\n\t\t \tif(str == null)\n\t\t\t\treturn;\n\t\t } else {\n\t\t\ti = 2;\n\t\t }\n\t\t i++;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\ti++;\n\t^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void testCloseable1() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "warning");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file); // not closed\n        char[] in = new char[50];\n        fileReader.read(in);\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tFileReader fileReader = new FileReader(file); // not closed\n\t           ^^^^^^^^^^\nResource leak: 'fileReader' is never closed\n----------\n", null, true, options);
    }

    public void testCloseable2() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "warning");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file); // not closed\n        char[] in = new char[50];\n        fileReader.read(in);\n        fileReader.close();\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void testLocalClassInInitializer1() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static {\n        final int i=4;\n        try {\n            Runnable runner = new Runnable() {\n                public void run() {\n                    switch (i) {                        case 4: break;\n                    }\n                    int j = i;\n                    while (j++ < 10) {\n                        if (j == 2) continue;\n                        if (j == 4) break;\n                        if (j == 6) return;\n                    }\n                }\n            };\n        } catch (RuntimeException re) {}\n    }\n}\n"}, "");
    }

    public void testLocalClassInInitializer2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    void f () {\n        while (true) {\n            class Inner1 {\n                { if (true) break; }\n            }\n            new Inner1();\n        }\n    } \n    void g () {\n        outer: for (int i=1;true;i++) {\n            class Inner2 {\n                int j = 3;\n                void foo () {\n                  if (2 == j) continue outer;\n                  else continue;\n                }\n            }\n            new Inner2().foo();\n        }\n    } \n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t{ if (true) break; }\n\t            ^^^^^^\nbreak cannot be used outside of a loop or a switch\n----------\n2. WARNING in X.java (at line 11)\n\touter: for (int i=1;true;i++) {\n\t^^^^^\nThe label outer is never explicitly referenced\n----------\n3. ERROR in X.java (at line 15)\n\tif (2 == j) continue outer;\n\t            ^^^^^^^^^^^^^^^\nThe label outer is missing\n----------\n4. ERROR in X.java (at line 16)\n\telse continue;\n\t     ^^^^^^^^^\ncontinue cannot be used outside of a loop\n----------\n");
    }

    public void testBug380313() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\npublic void foo() throws Exception {\n        int i = 1;\n        int j = 2;\n        try {\n            if ((bar() == 1)) {\n                if ((i == 1)) {\n                    int n = bar();\n                    if (n == 35) {\n                        j = 2;\n                    } else {\n                        if (bar() > 0)\n                            return;\n                    }\n                } else {\n                    throw new Exception();\n                }\n            } else {\n                throw new Exception();\n            }\n            if (bar() == 0)\n                return;\n        } finally {\n            bar();\n        }\n    }\n\n    private int bar() {\n        return 0;\n    }\n\n    public static void main(String[] args) {\n    }\n}\n"}, "");
    }

    public void testBug380313b() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.io.FileInputStream;\nimport java.io.IOException;\npublic class X {\npublic void foo() throws Exception {\n        int i = 1;\n        try {\n            try (FileInputStream fis = new FileInputStream(\"\")) {\n\t\t\t\t if (i == 2)                \treturn;\n \t\t\t }\n            if (i == 35) \n                return;\n        } catch(IOException e) {\n            bar();\n        } finally {\n            bar();\n        }\n    }\n\n    private int bar() {\n        return 0;\n    }\n\n    public static void main(String[] args) {\n    }\n}\n"}, "");
    }

    public void testBug380750() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(String[] args) {\n\t\tString s0;\n\t\tfor(String s : singleton(s0=\"\")) {\n\t\t\tSystem.out.println(s);\n\t\t}\n\t\tSystem.out.println(s0);\n\t}\n\tString[] singleton(String s) {\n\t\treturn new String[] {s};\n\t}\n}\n"}, "");
    }

    public void testBug391517() {
        this.runConformTest(new String[]{"X.java", "import java.io.PrintWriter;\n\npublic class X {\n\n\tprivate static final int CONSTANT = 0;\n\n\tpublic static void main(String[] args) {\n\t\t// TODO Auto-generated method stub\n\n\t}\n\n\tstatic void addStackTrace(String prefix) {\n\t\tif (CONSTANT == 0) {\n\t\t\treturn;\n\t\t}\n\t\tPrintWriter pw = null;\n\t\tnew Exception().printStackTrace(pw);\n\t\tif (bar() == null) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n\n\tstatic Object bar() {\n\t\treturn null;\n\t}\n}"}, "");
    }

    public void testBug415997a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject o = null;\n\t\tif (o == null)\n\t\t\tif (true)\n\t\t\t\treturn;\n\t}\n}"}, "");
    }

    public void testBug415997b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tObject o = null;\n\t\tif (o == null) {}\n\t\telse\n\t\t\tif (true)\n\t\t\t\treturn;\n\t}\n}"}, "");
    }

    public void testBug415997c() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) throws Exception {\n\t\tSystem.out.println(ParseExpr11());\n\t}\n\tstatic final public Object ParseExpr11() throws Exception {\n\t\tObject expr;\n\t\tObject op = null;\n\t\texpr = ParseVarExpr();\n\t\tif (op == null) {\n\t\t\tif (true)\n\t\t\t\treturn expr;\n\t\t}\n\t\t{\n\t\t\tthrow new Exception(\"++/-- not supported in TUD Bantam Java.\");\n\t\t}\n\t}\n\tprivate static Object ParseVarExpr() {\n\t\t// TODO Auto-generated method stub\n\t\treturn \"test\";\n\t}\n}"}, "test");
    }

    public void testBug499809() {
        this.runConformTest(new String[]{"Foo.java", "public class Foo {\n\tstatic void foo( ) {\n\t\tString _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, a, b,\n\t\tc, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, w, x, y, z, s0, s1, s2, s3, s4, s5, s6, s7;\n\t\tObject ob = new Object();\n\t\tint int1 = 0, int2 = 2, int3, int4;\n\t\tif (ob != null) {\n\t\t\tint4 = 1;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Done\");\n\t}\n}\n"}, "Done");
    }

    public void testBug499809a() {
        this.runConformTest(new String[]{"Foo.java", "public class Foo {\n\tstatic void foo( ) {\n\t\tString _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, a, b,\n\t\tc, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, w, x, y, z, s0, s1, s2, s3, s4, s5, s6, s7;\n\t\tObject ob = new Object();\n\t\tint int1 = 0, int2 = 2, int3, int4;\n\t\tif (ob == null) {\n\t\t\tint1 = 1;\n\t\t} else {\n\t\t\tint4 = 1;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Done\");\n\t}\n}\n"}, "Done");
    }

    public void testBug506315() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runNegativeTest(new String[]{"Test.java", "import java.util.function.Consumer;\npublic class Test {\n    public void test(String method) {\n        String str;\n        if (!method.equals(\"\")) {\n        \tstr = \"String\";\n        \tstr.concat(method);\n        }\n        new Consumer<String>() {\n            public void accept(String s) {\n            \tstr = \"String\";\n            }\n        };\n    }\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in Test.java (at line 11)\n\tstr = \"String\";\n\t^^^\nCannot refer to the non-final local variable str defined in an enclosing scope\n----------\n" : "----------\n1. ERROR in Test.java (at line 11)\n\tstr = \"String\";\n\t^^^\nLocal variable str defined in an enclosing scope must be final or effectively final\n----------\n");
    }

    public static Class testClass() {
        return FlowAnalysisTest.class;
    }
}

