/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class GenericsRegressionTest_1_7
extends AbstractRegressionTest {
    public GenericsRegressionTest_1_7(String name) {
        super(name);
    }

    public static Test suite() {
        return GenericsRegressionTest_1_7.buildMinimalComplianceTestSuite(GenericsRegressionTest_1_7.testClass(), 16);
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>();\n\t\tx.testFunction(\"SUCCESS\");\n\t}\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param);\n\t}\n}"}, "SUCCESS");
    }

    public void test001a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>();\n\t\tx.testFunction(1);\n\t}\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tx.testFunction(1);\n\t  ^^^^^^^^^^^^\nThe method testFunction(String) in the type X<String> is not applicable for the arguments (int)\n----------\n");
    }

    public void test001b() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tjava.util.ArrayList<String> x = new java.util.ArrayList<>();\n\t\tx.add(\"\");\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test001b_1() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tstatic java.util.ArrayList<String> x = new java.util.ArrayList<>();\n\tpublic static void main(String[] args) {\n\t\tX.x.add(\"\");\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test001c() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tjava.util.ArrayList<String> x = new java.util.ArrayList<>();\n\t\tx.add(1);\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tx.add(1);\n\t  ^^^\nThe method add(int, String) in the type ArrayList<String> is not applicable for the arguments (int)\n----------\n");
    }

    public void test001c_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tstatic java.util.ArrayList<String> x = new java.util.ArrayList<>();\n\tpublic static void main(String[] args) {\n\t\tX.x.add(1);\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tX.x.add(1);\n\t    ^^^\nThe method add(int, String) in the type ArrayList<String> is not applicable for the arguments (int)\n----------\n");
    }

    public void test001d() {
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X<T> {\tpublic void ab(ArrayList<String> al){\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>();\n\t\tx.ab(new ArrayList<>());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tx.ab(new ArrayList<>());\n\t  ^^\nThe method ab(ArrayList<String>) in the type X<String> is not applicable for the arguments (ArrayList<Object>)\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X<T> {\tpublic void ab(ArrayList<String> al){\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>();\n\t\tx.ab(new ArrayList<>());\n\t}\n}"}, "SUCCESS");
        }
    }

    public void test001e() {
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X<T> {\tpublic void ab(ArrayList<T> al){\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>();\n\t\tx.ab(new ArrayList<>());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tx.ab(new ArrayList<>());\n\t  ^^\nThe method ab(ArrayList<String>) in the type X<String> is not applicable for the arguments (ArrayList<Object>)\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X<T> {\tpublic void ab(ArrayList<T> al){\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>();\n\t\tx.ab(new ArrayList<>());\n\t}\n}"}, "SUCCESS");
        }
    }

    public void test001f() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<T>{\n\t\tvoid methodx(T param){\n\t\t\tSystem.out.println(param);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String>.X2<String> x = new X<>().new X2<>();\n\t\tx.methodx(\"SUCCESS\");\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 2)\n\tclass X2<T>{\n\t         ^\nThe type parameter T is hiding the type T\n----------\n2. ERROR in X.java (at line 8)\n\tX<String>.X2<String> x = new X<>().new X2<>();\n\t                         ^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.X2<String> to X<String>.X2<String>\n" : "Cannot infer type arguments for X2<>\n") + "----------\n");
    }

    public void test001f_1() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<T>{\n\t\tvoid methodx(T param){\n\t\t\tSystem.out.println(param);\n\t\t}\n\t}\n\tX<String>.X2<String> x;\n\tpublic static void main(String[] args) {\n\t\tX test = new X();\n\t\ttest.x = new X<>().new X2<>();\n\t\ttest.x.methodx(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test001g() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<K>{\n\t\tvoid methodx(T param, K param2){\n\t\t\tSystem.out.println(param);\n\t\t\tSystem.out.println(param2);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String>.X2<Integer> x = new X<>().new X2<>();\n\t\tx.methodx(\"SUCCESS\",1);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tX<String>.X2<Integer> x = new X<>().new X2<>();\n\t                          ^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.X2<Integer> to X<String>.X2<Integer>\n" : "Cannot infer type arguments for X2<>\n") + "----------\n");
    }

    public void test001g_1() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<K>{\n\t\tvoid methodx(T param, K param2){\n\t\t\tSystem.out.println(param);\n\t\t\tSystem.out.println(param2);\n\t\t}\n\t}\n\tX<String>.X2<Integer> x;\n\tpublic static void main(String[] args) {\n\t\tX test = new X();\t\ttest.x = new X<>().new X2<>();\n\t\ttest.x.methodx(\"SUCCESS\",1);\n\t}\n}"}, "SUCCESS\n1");
    }

    public void test001h() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<T>{\n\t\tvoid methodx(T param){\n\t\t\tSystem.out.println(param);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String>.X2<String> x = new X<>().new X2<>();\n\t\tx.methodx(1);\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 2)\n\tclass X2<T>{\n\t         ^\nThe type parameter T is hiding the type T\n----------\n2. ERROR in X.java (at line 8)\n\tX<String>.X2<String> x = new X<>().new X2<>();\n\t                         ^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.X2<String> to X<String>.X2<String>\n" : "Cannot infer type arguments for X2<>\n") + "----------\n" + "3. ERROR in X.java (at line 9)\n" + "\tx.methodx(1);\n" + "\t  ^^^^^^^\n" + "The method methodx(String) in the type X<String>.X2<String> is not applicable for the arguments (int)\n" + "----------\n");
    }

    public void test001h_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<T>{\n\t\tvoid methodx(T param){\n\t\t\tSystem.out.println(param);\n\t\t}\n\t}\n\tX<String>.X2<String> x;\n\tpublic static void main(String[] args) {\n\t\tX test = new X();\n\t\ttest.x = new X<>().new X2<>();\n\t\ttest.x.methodx(1);\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 2)\n\tclass X2<T>{\n\t         ^\nThe type parameter T is hiding the type T\n----------\n2. WARNING in X.java (at line 9)\n\tX test = new X();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 9)\n\tX test = new X();\n\t             ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 10)\n\ttest.x = new X<>().new X2<>();\n\t     ^\nType safety: The field x from the raw type X is assigned a value of type X<Object>.X2<Object>. References to generic type X<T> should be parameterized\n----------\n5. WARNING in X.java (at line 11)\n\ttest.x.methodx(1);\n\t^^^^^^^^^^^^^^^^^\nType safety: The method methodx(Object) belongs to the raw type X.X2. References to generic type X<T>.X2<T> should be parameterized\n----------\n");
    }

    public void test001h_2() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<T>{\n\t\tvoid methodx(T param){\n\t\t\tSystem.out.println(param);\n\t\t}\n\t}\n\tX<String>.X2<String> x;\n\tpublic static void main(String[] args) {\n\t\tX test = new X();\n\t\ttest.x = new X<>().new X2<>();\n\t\ttest.x.methodx(1);\n\t}\n}"}, "1");
    }

    public void test001i() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<K>{\n\t\tclass X22<I>{\n\t\t\tvoid methodx(T param, K param2, I param3){\n\t\t\t\tSystem.out.println(param);\n\t\t\t}\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> test = new X<>();\t\tX<String>.X2<Integer>.X22<X<String>> x = new X<>().new X2<>().new X22<>();\n\t\tx.methodx(\"SUCCESS\", 1, test);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tX<String> test = new X<>();\t\tX<String>.X2<Integer>.X22<X<String>> x = new X<>().new X2<>().new X22<>();\n\t                           \t\t                                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.X2<Object>.X22<X<String>> to X<String>.X2<Integer>.X22<X<String>>\n" : "Cannot infer type arguments for X22<>\n") + "----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tX x = new X<>();\n\t\tx.testFunction(\"SUCCESS\");\n\t}\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param);\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tX x = new X<>();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tx.testFunction(\"SUCCESS\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method testFunction(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tpublic static void main(String[] args) {\n\t\tnew X<>().testFunction(\"SUCCESS\");\n\t}\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param);\n\t}\n}"}, "SUCCESS");
    }

    public void test004b() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<U> {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X<>().new X2<>(){\n\t\t\tvoid newMethod(){\n\t\t\t}\n\t\t};\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tnew X<>().new X2<>(){\n\t              ^^\n'<>' cannot be used with anonymous classes\n----------\n");
    }

    public void test004c() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tclass X2<U> {\n\t\tU f1;\t\tpublic void setF(U a){\n\t\t\tthis.f1 = a;\t\t\tSystem.out.println(this.f1);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X<>().new X2<Integer>(){\n\t\t\tvoid newMethod(){\n\t\t\t}\n\t\t}.setF(1);\n\t}\n}"}, "1");
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "class X1<T> {\n\tint abc = 1;\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param + \"X1\");\n\t}\n}\npublic class X<T> extends X1<T> {\n\tpublic static void main(String[] args) {\n\t\tX1<String> x = new X<>();\n\t\tx.testFunction(\"SUCCESS\");\n\t}\n\tpublic void testFunction(T param){\n\t\tSystem.out.println(param);\n\t}\n}"}, "SUCCESS");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tT field1;\tpublic X(T param){\n\t\tfield1 = param;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX.testFunction(new X<>(\"hello\").getField());\n\t\tX.testFunction(new X(\"hello\").getField());\n\t}\n\tpublic static void testFunction(String param){\n\t\tSystem.out.println(1);\n\t}\n\tpublic static void testFunction(Object param){\n\t\tSystem.out.println(2);\n\t}\n\tpublic T getField(){\n\t\treturn field1;\t}\n}"}, "1\n2");
    }

    public void test007a() {
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic X(){\n\t}\n\tpublic X(T param){\n\t\tSystem.out.println(param);\n\t}\n\tpublic static void testFunction(X<String> param){\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX.testFunction(new X<>());\n\t\tX.testFunction(new X(\"hello\"));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tX.testFunction(new X<>());\n\t  ^^^^^^^^^^^^\nThe method testFunction(X<String>) in the type X is not applicable for the arguments (X<Object>)\n----------\n2. WARNING in X.java (at line 12)\n\tX.testFunction(new X(\"hello\"));\n\t               ^^^^^^^^^^^^^^\nType safety: The constructor X(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 12)\n\tX.testFunction(new X(\"hello\"));\n\t               ^^^^^^^^^^^^^^\nType safety: The expression of type X needs unchecked conversion to conform to X<String>\n----------\n4. WARNING in X.java (at line 12)\n\tX.testFunction(new X(\"hello\"));\n\t                   ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tpublic X(){\n\t}\n\tpublic X(T param){\n\t\tSystem.out.println(param);\n\t}\n\tpublic static void testFunction(X<String> param){\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX.testFunction(new X<>());\n\t\tX.testFunction(new X(\"hello\"));\n\t}\n}"}, "SUCCESS\nhello\nSUCCESS");
        }
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tT field1;\n\tpublic X(T param){\n\t\tfield1 = param;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<?> x1 = new X(1).get(\"\");\n\t\tX<?> x2 = new X<>(1).get(\"\");\n\t}\n\tpublic X<T> get(T t){\n\t\treturn this;\t}\n}"}, "----------\n1. WARNING in X.java (at line 7)\n\tX<?> x1 = new X(1).get(\"\");\n\t          ^^^^^^^^\nType safety: The constructor X(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 7)\n\tX<?> x1 = new X(1).get(\"\");\n\t          ^^^^^^^^^^^^^^^^\nType safety: The method get(Object) belongs to the raw type X. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 7)\n\tX<?> x1 = new X(1).get(\"\");\n\t              ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. ERROR in X.java (at line 8)\n\tX<?> x2 = new X<>(1).get(\"\");\n\t                     ^^^\nThe method get(Integer) in the type X<Integer> is not applicable for the arguments (String)\n----------\n");
    }

    public void test0014() {
        this.runConformTest(new String[]{"X.java", "public class X<J,K> {\n\tpublic static void main(String[] args) {\n\t\tX<String,Integer> x = new X<>();\n\t\tx.testFunction(\"SUCCESS\", 123);\n\t}\n\tpublic void testFunction(J param, K param2){\n\t\tSystem.out.println(param);\n\t\tSystem.out.println(param2);\n\t}\n}"}, "SUCCESS\n123");
    }

    public void test0014a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<J,K> {\n\tpublic static void main(String[] args) {\n\t\tX<String,Integer> x = new X<>();\n\t\tx.testFunction(123, \"SUCCESS\");\n\t}\n\tpublic void testFunction(J param, K param2){\n\t\tSystem.out.println(param);\n\t\tSystem.out.println(param2);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tx.testFunction(123, \"SUCCESS\");\n\t  ^^^^^^^^^^^^\nThe method testFunction(String, Integer) in the type X<String,Integer> is not applicable for the arguments (int, String)\n----------\n");
    }

    public void test0015() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tX(){\n\t\tSystem.out.println(\"const.1\");\n\t}\n\tX (T t) {\n\t\tSystem.out.println(\"const.2\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>();\n\t\tX<String> x2 = new X<>(\"\");\n\t}\n}"}, "const.1\nconst.2");
    }

    public void test0016() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\t<E> X(){\n\t\tSystem.out.println(\"const.1\");\n\t}\n\t<K,J> X (Integer i) {\n\t\tSystem.out.println(\"const.2\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new <String>X<>();\n\t\tX<String> x2 = new <String, Integer>X<>(1);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tX<String> x = new <String>X<>();\n\t                   ^^^^^^\nExplicit type arguments cannot be used with '<>' in an allocation expression\n----------\n2. ERROR in X.java (at line 10)\n\tX<String> x2 = new <String, Integer>X<>(1);\n\t                    ^^^^^^^^^^^^^^^\nExplicit type arguments cannot be used with '<>' in an allocation expression\n----------\n");
    }

    public void test0016a() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\t<E> X(){\n\t\tSystem.out.println(\"const.1\");\n\t}\n\t<K,J> X (Integer i) {\n\t\tSystem.out.println(\"const.2\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>();\n\t\tX<String> x2 = new X<>(1);\n\t}\n}"}, "const.1\nconst.2");
    }

    public void test0016b() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tX<String> x;\n\tX<String> x2;\n\t<E> X(){\n\t\tSystem.out.println(\"const.1\");\n\t}\n\t<K,J> X (Integer i) {\n\t\tSystem.out.println(\"const.2\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<Integer> test = new <String>X<>();\n\t\ttest.x = new <String>X<>();\n\t\ttest.x2 = new <String, Integer>X<>(1);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tX<Integer> test = new <String>X<>();\n\t                       ^^^^^^\nExplicit type arguments cannot be used with '<>' in an allocation expression\n----------\n2. ERROR in X.java (at line 12)\n\ttest.x = new <String>X<>();\n\t              ^^^^^^\nExplicit type arguments cannot be used with '<>' in an allocation expression\n----------\n3. ERROR in X.java (at line 13)\n\ttest.x2 = new <String, Integer>X<>(1);\n\t               ^^^^^^^^^^^^^^^\nExplicit type arguments cannot be used with '<>' in an allocation expression\n----------\n");
    }

    public void test0016c() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tX<String> x;\n\tX<String> x2;\n\t<E> X(){\n\t\tSystem.out.println(\"const.1\");\n\t}\n\t<K,J> X (Integer i) {\n\t\tSystem.out.println(\"const.2\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<Integer> test = new X<>();\n\t\ttest.x = new X<>();\n\t\ttest.x2 = new X<>(1);\n\t}\n}"}, "const.1\nconst.1\nconst.2");
    }

    public void test0017() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tX(int i){\n\t\tSystem.out.println(\"const.1\");\n\t}\n\t<K,J> X (Integer i) {\n\t\tSystem.out.println(\"const.2\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>(1);\n\t\tX<String> x2 = new <String, Integer>X<>(1);\n\t\tInteger i = 1;\n\t\tX<String> x3 = new <String, Integer>X<>(i);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tX<String> x2 = new <String, Integer>X<>(1);\n\t                    ^^^^^^^^^^^^^^^\nExplicit type arguments cannot be used with '<>' in an allocation expression\n----------\n2. ERROR in X.java (at line 12)\n\tX<String> x3 = new <String, Integer>X<>(i);\n\t                    ^^^^^^^^^^^^^^^\nExplicit type arguments cannot be used with '<>' in an allocation expression\n----------\n");
    }

    public void test0017a() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tX(int i){\n\t\tSystem.out.println(\"const.1\");\n\t}\n\t<K,J> X (Integer i) {\n\t\tSystem.out.println(\"const.2\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new X<>(1);\n\t\tX<String> x2 = new X<>(1);\n\t\tInteger i = 1;\n\t\tX<String> x3 = new X<>(i);\n\t}\n}"}, "const.1\nconst.1\nconst.2");
    }

    public void test0018() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tX(T t){\n\t\tSystem.out.println(\"const.1\");\n\t}\n\tX (T t, Integer i) {\n\t\tSystem.out.println(\"const.2\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X<>(\"\");\n\t\tX x2 = new X<>(\"\",1);\n\t}\n}"}, "const.1\nconst.2");
    }

    public void test0018b() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tX f1;\n\tX f2;\n\tX(T t){\n\t\tSystem.out.println(\"const.1\");\n\t}\n\tX (T t, Integer i) {\n\t\tSystem.out.println(\"const.2\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X<>(\"\");\n\t\tx.f1 = new X<>(\"\");\n\t\tx.f2 = new X<>(\"\",1);\n\t}\n}"}, "const.1\nconst.1\nconst.2");
    }

    public void test0019() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   String s = new String<>(\"junk\");\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tString s = new String<>(\"junk\");\n\t               ^^^^^^\nThe type String is not generic; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test0020() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    Zork z;\n    public X(T t) {}\n\t int f(X<String> p) {return 0;}\n\t int x = f(new X<>(\"\"));\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0021() {
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\nclass X<T> {\n  public X(T t) {}\n  int f(List<String> p) {return 0;}\n  int x = f(new ArrayList<>());\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tint x = f(new ArrayList<>());\n\t        ^\nThe method f(List<String>) in the type X<T> is not applicable for the arguments (ArrayList<Object>)\n----------\n");
        } else {
            this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\nclass X<T> {\n  public X(T t) {}\n  int f(List<String> p) {return 0;}\n  int x = f(new ArrayList<>());\n}\n"}, "");
        }
    }

    public void test0022() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\n\nclass StringKeyHashMap<V> extends HashMap<String, V>  {  \n}\n\nclass IntegerValueHashMap<K> extends HashMap<K, Integer>  {  \n}\n\npublic class X {\n    Map<String, Integer> m1 = new StringKeyHashMap<>();\n    Map<String, Integer> m2 = new IntegerValueHashMap<>();\n}\n"}, "");
    }

    public void test0023() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\n\nclass StringKeyHashMap<V> extends HashMap<String, V>  {  \n}\n\nclass IntegerValueHashMap<K> extends HashMap<K, Integer>  {  \n}\n\npublic class X {\n    Map<String, Integer> m1 = new StringKeyHashMap<>(10);\n    Map<String, Integer> m2 = new IntegerValueHashMap<>();\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tclass StringKeyHashMap<V> extends HashMap<String, V>  {  \n\t      ^^^^^^^^^^^^^^^^\nThe serializable class StringKeyHashMap does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 7)\n\tclass IntegerValueHashMap<K> extends HashMap<K, Integer>  {  \n\t      ^^^^^^^^^^^^^^^^^^^\nThe serializable class IntegerValueHashMap does not declare a static final serialVersionUID field of type long\n----------\n3. ERROR in X.java (at line 11)\n\tMap<String, Integer> m1 = new StringKeyHashMap<>(10);\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for StringKeyHashMap<>\n----------\n");
    }

    public void test0024() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\nclass X<T> {\n  public X() {}\n  X<String> f(List<String> p) {return new X<>();}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n");
    }

    public void test0025() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\nclass X<T> {\n  public X() {}\n  void f(List<String> p) { Object o = (X<String>) new X<>();}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tvoid f(List<String> p) { Object o = (X<String>) new X<>();}\n\t                                    ^^^^^^^^^^^^^^^^^^^^^\nCannot cast from X<Object> to X<String>\n----------\n");
    }

    public void test0026() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\npublic class X<T> {\n\tX(T t) {}\n   X(String s) {}\n   X(List<?> l) {}\n   X<T> idem() { return this; }\n   X<Number> x = new X<>(1);\n   X<Integer> x2 = new X<>(1);\n   List<?> list = new ArrayList<>();\n   X<?> x3 = new X<>(1);\n   X<Object> x4 = new X<>(1).idem();\n   X<Object> x5 = new X<>(1);\n   int m(X<String> xs) { return 0; }\n   int i = m(new X<>(\"\"));\n   X<?> x6 = new X<>(list);\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 8)\n\tX<Number> x = new X<>(1);\n\t              ^^^^^^^^^^\nType mismatch: cannot convert from X<Integer> to X<Number>\n----------\n2. ERROR in X.java (at line 12)\n\tX<Object> x4 = new X<>(1).idem();\n\t               ^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from X<Integer> to X<Object>\n----------\n3. ERROR in X.java (at line 13)\n\tX<Object> x5 = new X<>(1);\n\t               ^^^^^^^^^^\nType mismatch: cannot convert from X<Integer> to X<Object>\n----------\n4. ERROR in X.java (at line 15)\n\tint i = m(new X<>(\"\"));\n\t        ^\nThe method m(X<String>) in the type X<T> is not applicable for the arguments (X<Object>)\n----------\n" : "----------\n1. ERROR in X.java (at line 12)\n\tX<Object> x4 = new X<>(1).idem();\n\t               ^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from X<Integer> to X<Object>\n----------\n");
    }

    public void test0027() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n       class Y<U> {\n\t    <K,J> Y (Integer i) {\n\t    }\n\t}\n\n\t<K,J> X (Integer i) {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tX<String> x = new <String, Integer> X<>(1);\n\t\tX<String> x2 = x.new <String, Integer> Y<>(1);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tX<String> x = new <String, Integer> X<>(1);\n\t                   ^^^^^^^^^^^^^^^\nExplicit type arguments cannot be used with '<>' in an allocation expression\n----------\n2. ERROR in X.java (at line 12)\n\tX<String> x2 = x.new <String, Integer> Y<>(1);\n\t                      ^^^^^^^^^^^^^^^\nExplicit type arguments cannot be used with '<>' in an allocation expression\n----------\n");
    }

    public void test0028() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n     X<String> x = new X<> () {}\n;     class Y<U> {\n\t  }\n     X<String>.Y<String> y = x.new Y<>() {};\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tX<String> x = new X<> () {}\n\t                  ^\n'<>' cannot be used with anonymous classes\n----------\n2. ERROR in X.java (at line 5)\n\tX<String>.Y<String> y = x.new Y<>() {};\n\t                              ^\n'<>' cannot be used with anonymous classes\n----------\n");
    }

    public void test0029() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    X(T t) {}\n    X<String> f2 = new X<>(new Y()); \n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX<String> f2 = new X<>(new Y()); \n\t                           ^\nY cannot be resolved to a type\n----------\n");
    }

    public void test0029a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    class I<T> {\n        I(T t) {}\n    }\n    X.I<String> f = new X().new I<>(new Y()); \n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tX.I<String> f = new X().new I<>(new Y()); \n\t                                    ^\nY cannot be resolved to a type\n----------\n");
    }

    public void test0030() {
        this.runNegativeTest(new String[]{"X.java", "class C {}\ninterface I {}\npublic class X<T extends C & I> {\n    X() {}\n    X f = new X<>();\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tX f = new X<>();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test0031() {
        this.runConformTest(new String[]{"X.java", "class C {}\ninterface I {}\npublic class X<T extends C & I> {\n    X() {}\n    X<?> f = new X<>();\n}\n"}, "");
    }

    public void test0032() {
        this.runConformTest(new String[]{"X.java", "class C {}\ninterface I {}\npublic class X<T extends C & I> {\n    static <U extends C & I> X<U> getX() {\n        return null;\n    }\n    X<?> f2 = getX();\n}\n"}, "");
    }

    public void test0033() {
        this.runNegativeTest(new String[]{"X.java", "class C {}\ninterface I {}\npublic class X<T extends C & I> {\n    static <U extends C & I> X<U> getX() {\n        return null;\n    }\n    X f2 = getX();\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tX f2 = getX();\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test0034() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    X(T t) {}\n    X() {}\n    void foo(T a) {\n\t System.out.println(a);\n\t }\n\t class Y<K>{\n\t\tY(T t,K k) {}\n\t }\n    public static void main(String[] args) {\n\t\tX<Integer> x1 = new X<>(1,1);\n\t\tX<Integer> x2 = new X<>(1);\n\t\tX<Integer> x3 = new X<>();\n\t\tX<Integer>.Y<String> y1 = new X<>(1,1).new Y<>();\n\t\tX<Integer>.Y<String> y2 = new X<>(1,1).new Y<>(1);\n\t\tX<Integer>.Y<String> y3 = new X<>(1).new Y<>(1);\n\t\tX<Integer>.Y<String> y4 = new X<>(1).new Y<>(\"\",\"\");\n\t\tX<Integer>.Y<String> y5 = new X<>(1).new Y<>(1,\"\");\n\t\tX<Integer>.Y<String> y6 = new X<>().new Y<>(1,\"\");\n\t\tX<Integer>.Y<String> y7 = new X<>().new Y<>(1,1);\n\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tX<Integer> x1 = new X<>(1,1);\n\t                ^^^^^^^^^^^^\nCannot infer type arguments for X<>\n----------\n2. ERROR in X.java (at line 14)\n\tX<Integer>.Y<String> y1 = new X<>(1,1).new Y<>();\n\t                          ^^^^^^^^^^^^\nCannot infer type arguments for X<>\n----------\n3. ERROR in X.java (at line 15)\n\tX<Integer>.Y<String> y2 = new X<>(1,1).new Y<>(1);\n\t                          ^^^^^^^^^^^^\nCannot infer type arguments for X<>\n----------\n4. ERROR in X.java (at line 16)\n\tX<Integer>.Y<String> y3 = new X<>(1).new Y<>(1);\n\t                          ^^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for Y<>\n----------\n5. ERROR in X.java (at line 17)\n\tX<Integer>.Y<String> y4 = new X<>(1).new Y<>(\"\",\"\");\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for Y<>\n----------\n6. ERROR in X.java (at line 19)\n\tX<Integer>.Y<String> y6 = new X<>().new Y<>(1,\"\");\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.Y<String> to X<Integer>.Y<String>\n" : "Cannot infer type arguments for Y<>\n") + "----------\n" + "7. ERROR in X.java (at line 20)\n" + "\tX<Integer>.Y<String> y7 = new X<>().new Y<>(1,1);\n" + "\t                          ^^^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.Y<Integer> to X<Integer>.Y<String>\n" : "Cannot infer type arguments for Y<>\n") + "----------\n");
    }

    public void test0034b() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    X(T t) {}\n    X() {}\n    void foo(T a) {\n\t System.out.println(a);\n\t }\n\t class Y<K>{\n\t\tY(T t,K k) {}\n\t\tY(K k) {}\n\t }\n    public static void main(String[] args) {\n\t\tX<String>.Y<String> y42 = new X<>(\"\").new Y<>(\"\");\n\t\tX<String>.Y<String> y41 = new X<>(\"\").new Y<>(\"\",\"\");\n\t\tX<Integer>.Y<String> y4 = new X<>(1).new Y<>(\"\",\"\");\n\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tX<Integer>.Y<String> y4 = new X<>(1).new Y<>(\"\",\"\");\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for Y<>\n----------\n");
    }

    public void test0035() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    X(T t) {}\n    X() {}\n\t @SafeVarargs\n    X(String abc, String abc2, T... t) {}\n    void foo(T a) {\n\t System.out.println(a);\n\t }\n\t class Y<K>{\n\t\t@SafeVarargs\n\t\tY(T t,String abc, K... k) {}\n\t }\n    public static void main(String[] args) {\n\t\tX<Integer> x1 = new X<>(1,1);\n\t\tX<Integer> x2 = new X<>(1);\n\t\tX<Integer> x3 = new X<>();\n\t\tX<Integer> x4 = new X<>(\"\",\"\");\n\t\tX<Integer> x5 = new X<>(\"\",\"\",\"\");\n\t\tX<Integer> x6 = new X<>(\"\",\"\",1);\n\t\tX<Integer>.Y<String> y1 = new X<>(1,1).new Y<>();\n\t\tX<Integer>.Y<String> y2 = new X<>(\"\",1).new Y<>(\"\");\n\t\tX<Integer>.Y<String> y3 = new X<>(1).new Y<>(1);\n\t\tX<Integer>.Y<String> y4 = new X<>(1).new Y<>(1,\"\");\n\t\tX<Integer>.Y<String> y5 = new X<>(1).new Y<>(1,\"\",\"\");\n\t\tX<Integer>.Y<String> y6 = new X<>().new Y<>(1,\"\",1);\n\t\tX<Integer>.Y<String> y7 = new X<>().new Y<>(\"\",\"\",1);\n\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tX<Integer> x1 = new X<>(1,1);\n\t                ^^^^^^^^^^^^\nCannot infer type arguments for X<>\n----------\n2. ERROR in X.java (at line 18)\n\tX<Integer> x5 = new X<>(\"\",\"\",\"\");\n\t                ^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<String> to X<Integer>\n" : "Cannot infer type arguments for X<>\n") + "----------\n" + "3. ERROR in X.java (at line 20)\n" + "\tX<Integer>.Y<String> y1 = new X<>(1,1).new Y<>();\n" + "\t                          ^^^^^^^^^^^^\n" + "Cannot infer type arguments for X<>\n" + "----------\n" + "4. ERROR in X.java (at line 21)\n" + "\tX<Integer>.Y<String> y2 = new X<>(\"\",1).new Y<>(\"\");\n" + "\t                          ^^^^^^^^^^^^^\n" + "Cannot infer type arguments for X<>\n" + "----------\n" + "5. ERROR in X.java (at line 22)\n" + "\tX<Integer>.Y<String> y3 = new X<>(1).new Y<>(1);\n" + "\t                          ^^^^^^^^^^^^^^^^^^^^^\n" + "Cannot infer type arguments for Y<>\n" + "----------\n" + "6. ERROR in X.java (at line 25)\n" + "\tX<Integer>.Y<String> y6 = new X<>().new Y<>(1,\"\",1);\n" + "\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.Y<Integer> to X<Integer>.Y<String>\n" : "Cannot infer type arguments for Y<>\n") + "----------\n" + "7. ERROR in X.java (at line 26)\n" + "\tX<Integer>.Y<String> y7 = new X<>().new Y<>(\"\",\"\",1);\n" + "\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.Y<Integer> to X<Integer>.Y<String>\n" : "Cannot infer type arguments for Y<>\n") + "----------\n");
    }

    public void test0036() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    X(T t) {}\n    X() {}\n\t @SafeVarargs\n    X(String abc, String abc2, T... t) {}\n    void foo(T a) {\n\t System.out.println(a);\n\t }\n\t class Y<K>{\n\t\t@SafeVarargs\n\t\tY(T t,String abc, K... k) {}\n\t }\n\tX<Integer> x1 = new X<>(1,1);\n\tX<Integer> x2 = new X<>(1);\n\tX<Integer> x3 = new X<>();\n\tX<Integer> x4 = new X<>(\"\",\"\");\n\tX<Integer> x5 = new X<>(\"\",\"\",\"\");\n\tX<Integer> x6 = new X<>(\"\",\"\",1);\n\tX<Integer>.Y<String> y1 = new X<>(1,1).new Y<>();\n\tX<Integer>.Y<String> y2 = new X<>(\"\",1).new Y<>(\"\");\n\tX<Integer>.Y<String> y3 = new X<>(1).new Y<>(1);\n\tX<Integer>.Y<String> y4 = new X<>(1).new Y<>(1,\"\");\n\tX<Integer>.Y<String> y5 = new X<>(1).new Y<>(1,\"\",\"\");\n\tX<Integer>.Y<String> y6 = new X<>().new Y<>(1,\"\",1);\n\tX<Integer>.Y<String> y7 = new X<>().new Y<>(\"\",\"\",1);\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tX<Integer> x1 = new X<>(1,1);\n\t                ^^^^^^^^^^^^\nCannot infer type arguments for X<>\n----------\n2. ERROR in X.java (at line 17)\n\tX<Integer> x5 = new X<>(\"\",\"\",\"\");\n\t                ^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<String> to X<Integer>\n" : "Cannot infer type arguments for X<>\n") + "----------\n" + "3. ERROR in X.java (at line 19)\n" + "\tX<Integer>.Y<String> y1 = new X<>(1,1).new Y<>();\n" + "\t                          ^^^^^^^^^^^^\n" + "Cannot infer type arguments for X<>\n" + "----------\n" + "4. ERROR in X.java (at line 20)\n" + "\tX<Integer>.Y<String> y2 = new X<>(\"\",1).new Y<>(\"\");\n" + "\t                          ^^^^^^^^^^^^^\n" + "Cannot infer type arguments for X<>\n" + "----------\n" + "5. ERROR in X.java (at line 21)\n" + "\tX<Integer>.Y<String> y3 = new X<>(1).new Y<>(1);\n" + "\t                          ^^^^^^^^^^^^^^^^^^^^^\n" + "Cannot infer type arguments for Y<>\n" + "----------\n" + "6. ERROR in X.java (at line 24)\n" + "\tX<Integer>.Y<String> y6 = new X<>().new Y<>(1,\"\",1);\n" + "\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.Y<Integer> to X<Integer>.Y<String>\n" : "Cannot infer type arguments for Y<>\n") + "----------\n" + "7. ERROR in X.java (at line 25)\n" + "\tX<Integer>.Y<String> y7 = new X<>().new Y<>(\"\",\"\",1);\n" + "\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.Y<Integer> to X<Integer>.Y<String>\n" : "Cannot infer type arguments for Y<>\n") + "----------\n");
    }

    public void test0034a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    X(T t) {}\n    X() {}\n    void foo(T a) {\n\t System.out.println(a);\n\t }\n    public static void main(String[] args) {\n\t\tX<Integer> x1 = new X<>(1,1);\n\t\tX<Integer> x2 = new X<>(1);\n\t\tX<Integer> x3 = new X<>();\n\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tX<Integer> x1 = new X<>(1,1);\n\t                ^^^^^^^^^^^^\nCannot infer type arguments for X<>\n----------\n");
    }

    public void test0035a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    X(T t) {}\n    X() {}\n\t @SafeVarargs\n    X(String abc, String abc2, T... t) {}\n    void foo(T a) {\n\t \tSystem.out.println(a);\n\t }\n    public static void main(String[] args) {\n\t\tX<Integer> x1 = new X<>(1,1);\n\t\tX<Integer> x2 = new X<>(1);\n\t\tX<Integer> x3 = new X<>();\n\t\tX<Integer> x4 = new X<>(\"\",\"\");\n\t\tX<Integer> x5 = new X<>(\"\",\"\",\"\");\n\t\tX<Integer> x6 = new X<>(\"\",\"\",1);\n\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tX<Integer> x1 = new X<>(1,1);\n\t                ^^^^^^^^^^^^\nCannot infer type arguments for X<>\n----------\n2. ERROR in X.java (at line 14)\n\tX<Integer> x5 = new X<>(\"\",\"\",\"\");\n\t                ^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<String> to X<Integer>\n" : "Cannot infer type arguments for X<>\n") + "----------\n");
    }

    public void test0036a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    X(T t) {}\n    X() {}\n\t @SafeVarargs\n    X(String abc, String abc2, T... t) {}\n    void foo(T a) {\n\t System.out.println(a);\n\t }\n\tX<Integer> x1 = new X<>(1,1);\n\tX<Integer> x2 = new X<>(1);\n\tX<Integer> x3 = new X<>();\n\tX<Integer> x4 = new X<>(\"\",\"\");\n\tX<Integer> x5 = new X<>(\"\",\"\",\"\");\n\tX<Integer> x6 = new X<>(\"\",\"\",1);\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tX<Integer> x1 = new X<>(1,1);\n\t                ^^^^^^^^^^^^\nCannot infer type arguments for X<>\n----------\n2. ERROR in X.java (at line 13)\n\tX<Integer> x5 = new X<>(\"\",\"\",\"\");\n\t                ^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<String> to X<Integer>\n" : "Cannot infer type arguments for X<>\n") + "----------\n");
    }

    public void test0037() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T>  {\n    X(T t) {}\n    X() {}\n\t @SafeVarargs\n    X(String abc, String abc2, T... t) {}\n    void foo(T a) {\n\t System.out.println(a);\n\t }\n\t class Y<K>{\n\t\t@SafeVarargs\n\t\tY(T t,String abc, K... k) {}\n\t }\n    public static void main(String[] args) {\n\t\tX<Integer>.Y<String> y1 = new X<>().new Y<>(1);\n\t\tX<Integer>.Y<String> y2 = new X<>(1).new Y<>(1);\n\t\tX<Integer>.Y<String> y3 = new X<>(\"\",\"\",1).new Y<>(1);\n\t\tX<Integer>.Y<String> y4 = new X<>(1,\"\").new Y<>(1,\"\");\n\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tX<Integer>.Y<String> y1 = new X<>().new Y<>(1);\n\t                          ^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for Y<>\n----------\n2. ERROR in X.java (at line 15)\n\tX<Integer>.Y<String> y2 = new X<>(1).new Y<>(1);\n\t                          ^^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for Y<>\n----------\n3. ERROR in X.java (at line 16)\n\tX<Integer>.Y<String> y3 = new X<>(\"\",\"\",1).new Y<>(1);\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for Y<>\n----------\n4. ERROR in X.java (at line 17)\n\tX<Integer>.Y<String> y4 = new X<>(1,\"\").new Y<>(1,\"\");\n\t                          ^^^^^^^^^^^^^\nCannot infer type arguments for X<>\n----------\n");
    }

    public void test0038() {
        this.runConformTest(new String[]{"X.java", "interface A {\n    <T extends B & C> T getaMethod();\n    <T extends B & C> void setaMethod(T param);\n}\nclass B {\n}\ninterface C {\n}\npublic class X {\n    public void someMethod(A aInstance) {\n        aInstance.getaMethod();\n    }\n}\n"}, "");
    }

    public void test0039() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n  public static void main(String[] args) {\n    createObject();\n  }\n  private static <T extends Comparable<?> & Serializable> T createObject() {\n    return null;\n  }\n}\n"}, "");
    }

    public void test0042() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T> {}\npublic class X {\n    <T extends I<T>> void m() { }\n    { m(); } \n}\n"}, "");
    }

    public void test0043() {
        this.runConformTest(new String[]{"X.java", "public class X<T>  {\n    class Y<Z>  {\n        Y(T a, Z b) {\n        }\n    }\n    public static void main(String[] args) {\n        X<String>.Y<String>  x1 = new X<String>().new Y<String>(\"\",\"\");\n        X<String>.Y<String>  x2 = new X<String>().new Y<>(\"\",\"\");\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0044() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    class Y<Z> {\n         Y(T a, Z b) {\n         }\n    }\n    public static void main(String[] args) {\n        X<String>.Y<String> x = new X<>().new Y<>(\"\",\"\");\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tX<String>.Y<String> x = new X<>().new Y<>(\"\",\"\");\n\t                        ^^^^^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Type mismatch: cannot convert from X<Object>.Y<String> to X<String>.Y<String>\n" : "Cannot infer type arguments for Y<>\n") + "----------\n");
    }

    public void test0045() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    class Y<T, Z> {\n         Y(T a, Z b) {\n         }\n    }\n    public static void main(String[] args) {\n        X.Y<String, String> x = new X().new Y<>(\"\",\"\");\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0046() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    class Y<Z> {\n         Y(T a, Z b) { \n         }\n    }\n    public static void main(String[] args) {\n        X<String>.Y<String> x = new X<String>().new Y<>(\"\",\"\");\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0047() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n    class Y<Z> {\n         Y(T a, Z b) {\n         }\n    }\n    public static void main(String[] args) {\n        X<String>.Y<String> x1 = new X<String>().new Y<String>(\"\",\"\"); \n        X<String>.Y<String> x2 = new X<String>().new Y<>(\"\",\"\"); // javac wrong error \n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test0048() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    <T> X(T t) {\n    }\n    X<String> x = new X<>(\"\"); \n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\t<T> X(T t) {\n\t ^\nThe type parameter T is hiding the type T\n----------\n2. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test0049() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n     class Y<Z> {\n          Y(T a, Z b) {\n          }\n     }\n   public static void main(String[] args) {\n       X<Object>.Y<String> x1 = new X<Object>().new Y<String>(new Object(),\"\");\n       X<Object>.Y<String> x2 = new X<>().new Y<String>(new Object(),\"\");\n       X<Object>.Y<String> x3 = new X<Object>().new Y<>(new Object(),\"\");\n       X<Object>.Y<String> x4 = new X<>().new Y<>(new Object(),\"\");\n     }\n}\n"}, "");
    }

    public void test0050() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends Comparable<T>> {\n     class Y<Z> {\n          Y(T a, Z b) {\n          }\n     }\n   public static void main(String[] args) {\n       X<String>.Y<String> x1 = new X<String>().new Y<>(\"\",\"\");\n     }\n}\n"}, "");
    }

    public void test0051() {
        this.runConformTest(new String[]{"X.java", "public class X<T extends Comparable<T>> {\n     class Y<Z> {\n          Y(Integer a, Z b) {\n          }\n          Y(T a, Z b) {\n          }\n     }\n   public static void main(String[] args) {\n       X<String>.Y<String> x1 = new X<String>().new Y<>(\"\",\"\");\n     }\n}\n"}, "");
    }

    public void test0052() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n    X(E e) {}\n    X() {}\n    public static void main(String[] args) {\n        X<Number> x = new X<Number>(1);\n        X<String> x2 = new X<String>(\"SUCCESS\");\n        X<Integer> x3 = new X<Integer>(1);\n        X<AX> x4 = new X<AX>(new AX());\n\t\t X<? extends AX> x5 = new X<AX<String>>(new AX<String>());\n\t\t X<?> x6 = new X<AX<String>>(new AX<String>());\n\t\t X<Class<? extends Object>> x7 = new X<Class<? extends Object>>();\n\t}\n}\nclass AX<T>{}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 6)\n\tX<String> x2 = new X<String>(\"SUCCESS\");\n\t                   ^\nRedundant specification of type arguments <String>\n----------\n2. ERROR in X.java (at line 7)\n\tX<Integer> x3 = new X<Integer>(1);\n\t                    ^\nRedundant specification of type arguments <Integer>\n----------\n3. ERROR in X.java (at line 8)\n\tX<AX> x4 = new X<AX>(new AX());\n\t               ^\nRedundant specification of type arguments <AX>\n----------\n4. ERROR in X.java (at line 9)\n\tX<? extends AX> x5 = new X<AX<String>>(new AX<String>());\n\t                         ^\nRedundant specification of type arguments <AX<String>>\n----------\n5. ERROR in X.java (at line 10)\n\tX<?> x6 = new X<AX<String>>(new AX<String>());\n\t              ^\nRedundant specification of type arguments <AX<String>>\n----------\n6. ERROR in X.java (at line 11)\n\tX<Class<? extends Object>> x7 = new X<Class<? extends Object>>();\n\t                                    ^\nRedundant specification of type arguments <Class<? extends Object>>\n----------\n" : "----------\n1. ERROR in X.java (at line 5)\n\tX<Number> x = new X<Number>(1);\n\t                  ^\nRedundant specification of type arguments <Number>\n----------\n2. ERROR in X.java (at line 6)\n\tX<String> x2 = new X<String>(\"SUCCESS\");\n\t                   ^\nRedundant specification of type arguments <String>\n----------\n3. ERROR in X.java (at line 7)\n\tX<Integer> x3 = new X<Integer>(1);\n\t                    ^\nRedundant specification of type arguments <Integer>\n----------\n4. ERROR in X.java (at line 8)\n\tX<AX> x4 = new X<AX>(new AX());\n\t               ^\nRedundant specification of type arguments <AX>\n----------\n5. ERROR in X.java (at line 9)\n\tX<? extends AX> x5 = new X<AX<String>>(new AX<String>());\n\t                         ^\nRedundant specification of type arguments <AX<String>>\n----------\n6. ERROR in X.java (at line 10)\n\tX<?> x6 = new X<AX<String>>(new AX<String>());\n\t              ^\nRedundant specification of type arguments <AX<String>>\n----------\n7. ERROR in X.java (at line 11)\n\tX<Class<? extends Object>> x7 = new X<Class<? extends Object>>();\n\t                                    ^\nRedundant specification of type arguments <Class<? extends Object>>\n----------\n", null, false, customOptions);
    }

    public void test0052b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n\t E eField;\n\t E get() { return this.eField; }\n    X(E e) {}\n    X(int e, String e2) {}\n    public static void main(String[] args) {\n        X<Number> x = new X<Number>(1);\n        X<String> x2 = new X<String>(\"SUCCESS\");\n        X<String> x22 = new X<String>(1,\"SUCCESS\");\n        X<Integer> x3 = new X<Integer>(1);\n        String s = foo(new X<String>(\"aaa\"));\n        String s2 = foo(new X<String>(1,\"aaa\"));\n\t}\n    static String foo(X<String> x) {\n\t\treturn x.get();\n    }\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 8)\n\tX<String> x2 = new X<String>(\"SUCCESS\");\n\t                   ^\nRedundant specification of type arguments <String>\n----------\n2. ERROR in X.java (at line 9)\n\tX<String> x22 = new X<String>(1,\"SUCCESS\");\n\t                    ^\nRedundant specification of type arguments <String>\n----------\n3. ERROR in X.java (at line 10)\n\tX<Integer> x3 = new X<Integer>(1);\n\t                    ^\nRedundant specification of type arguments <Integer>\n----------\n4. ERROR in X.java (at line 11)\n\tString s = foo(new X<String>(\"aaa\"));\n\t                   ^\nRedundant specification of type arguments <String>\n----------\n" : "----------\n1. ERROR in X.java (at line 7)\n\tX<Number> x = new X<Number>(1);\n\t                  ^\nRedundant specification of type arguments <Number>\n----------\n2. ERROR in X.java (at line 8)\n\tX<String> x2 = new X<String>(\"SUCCESS\");\n\t                   ^\nRedundant specification of type arguments <String>\n----------\n3. ERROR in X.java (at line 9)\n\tX<String> x22 = new X<String>(1,\"SUCCESS\");\n\t                    ^\nRedundant specification of type arguments <String>\n----------\n4. ERROR in X.java (at line 10)\n\tX<Integer> x3 = new X<Integer>(1);\n\t                    ^\nRedundant specification of type arguments <Integer>\n----------\n5. ERROR in X.java (at line 11)\n\tString s = foo(new X<String>(\"aaa\"));\n\t                   ^\nRedundant specification of type arguments <String>\n----------\n", null, false, customOptions);
    }

    public void test0052c() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n\tX(String abc, String def) {}\n\tvoid foo() {\n\t\tX<Integer> x = new X<Integer>(\"\",\"\");\n\t\tfoo3(new X<Integer>(\"\",\"\"));\n\t}\n\tX<Integer> foo2() {\n\t\treturn new X<Integer>(\"\",\"\");\n\t}\n\tvoid foo3(X<Integer> x) {}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tX<Integer> x = new X<Integer>(\"\",\"\");\n\t                   ^\nRedundant specification of type arguments <Integer>\n----------\n2. ERROR in X.java (at line 8)\n\treturn new X<Integer>(\"\",\"\");\n\t           ^\nRedundant specification of type arguments <Integer>\n----------\n", null, false, customOptions);
    }

    public void test0052d() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<E> {\n    X(E e) {}\n    X() {}\n    public static void main(String[] args) {\n        X<Number> x = new X<Number>(1);\n\t}\n}\nclass AX<T>{}\n"}, this.complianceLevel < 0x340000L ? "" : "----------\n1. ERROR in X.java (at line 5)\n\tX<Number> x = new X<Number>(1);\n\t                  ^\nRedundant specification of type arguments <Number>\n----------\n", null, false, customOptions);
    }

    public void test0053() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"Z.java", "public class Z <T extends ZB> { \n    public static void main(String[] args) {\n        foo(new Z<ZB>());\n    }\n    static void foo(Z<ZB> z) {\n    }\n}\nclass ZB {\n}"}, "----------\n1. ERROR in Z.java (at line 3)\n\tfoo(new Z<ZB>());\n\t        ^\nRedundant specification of type arguments <ZB>\n----------\n", null, false, customOptions);
    }

    public void test0054() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"Y.java", "public class Y<V> {\n  public static <W extends ABC> Y<W> make(Class<W> clazz) {\n    return new Y<W>();\n  }\n}\nclass ABC{}\n"}, "----------\n1. ERROR in Y.java (at line 3)\n\treturn new Y<W>();\n\t           ^\nRedundant specification of type arguments <W>\n----------\n", null, false, customOptions);
    }

    public void test0055() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<A> {\n  class Inner<B> { }\n  static class Inner2<C> { }\n\n  void method() {\n    X<String>.Inner<Integer> a= new X<String>().new Inner<Integer>();\n    X<String>.Inner<Integer> a1= new X<String>().new Inner<>();\n    Inner<Integer> b= new X<A>().new Inner<Integer>();\n    Inner<Integer> c= new Inner<Integer>();\n    X<A>.Inner<Integer> e= new X<A>().new Inner<Integer>();\n    X<A>.Inner<Integer> f= new Inner<Integer>();\n    X.Inner2<Integer> d3 = new X.Inner2<Integer>();\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tX<String>.Inner<Integer> a= new X<String>().new Inner<Integer>();\n\t                                                ^^^^^\nRedundant specification of type arguments <Integer>\n----------\n2. ERROR in X.java (at line 8)\n\tInner<Integer> b= new X<A>().new Inner<Integer>();\n\t                                 ^^^^^\nRedundant specification of type arguments <Integer>\n----------\n3. ERROR in X.java (at line 9)\n\tInner<Integer> c= new Inner<Integer>();\n\t                      ^^^^^\nRedundant specification of type arguments <Integer>\n----------\n4. ERROR in X.java (at line 10)\n\tX<A>.Inner<Integer> e= new X<A>().new Inner<Integer>();\n\t                                      ^^^^^\nRedundant specification of type arguments <Integer>\n----------\n5. ERROR in X.java (at line 11)\n\tX<A>.Inner<Integer> f= new Inner<Integer>();\n\t                           ^^^^^\nRedundant specification of type arguments <Integer>\n----------\n6. ERROR in X.java (at line 12)\n\tX.Inner2<Integer> d3 = new X.Inner2<Integer>();\n\t                             ^^^^^^\nRedundant specification of type arguments <Integer>\n----------\n", null, false, customOptions);
    }

    public void test0056() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n\tvoid foo1() {\n\t\tX<String>.Item<Thread> i = new X<Exception>().new Item<Thread>();\n\t}\n\tvoid foo2() {\n\t\tX<Exception>.Item<Thread> j = new X<Exception>.Item<Thread>();\n\t}\n\tclass Item <E> {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tX<String>.Item<Thread> i = new X<Exception>().new Item<Thread>();\n\t                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from X<Exception>.Item<Thread> to X<String>.Item<Thread>\n----------\n2. ERROR in X.java (at line 3)\n\tX<String>.Item<Thread> i = new X<Exception>().new Item<Thread>();\n\t                                                  ^^^^\nRedundant specification of type arguments <Thread>\n----------\n3. ERROR in X.java (at line 6)\n\tX<Exception>.Item<Thread> j = new X<Exception>.Item<Thread>();\n\t                                  ^^^^^^^^^^^^^^^^^\nCannot allocate the member type X<Exception>.Item<Thread> using a parameterized compound name; use its simple name and an enclosing instance of type X<Exception>\n----------\n4. ERROR in X.java (at line 6)\n\tX<Exception>.Item<Thread> j = new X<Exception>.Item<Thread>();\n\t                                               ^^^^\nRedundant specification of type arguments <Thread>\n----------\n", null, false, customOptions);
    }

    public void test0056b() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n\tstatic class X1<Z> {\n\t\tX1(Z z){}\n\t}\n\tX1<Integer> x1 = new X.X1<Integer>(1);\n\tX1<Number> x2 = new X.X1<Number>(1);\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 5)\n\tX1<Integer> x1 = new X.X1<Integer>(1);\n\t                       ^^\nRedundant specification of type arguments <Integer>\n----------\n" : "----------\n1. ERROR in X.java (at line 5)\n\tX1<Integer> x1 = new X.X1<Integer>(1);\n\t                       ^^\nRedundant specification of type arguments <Integer>\n----------\n2. ERROR in X.java (at line 6)\n\tX1<Number> x2 = new X.X1<Number>(1);\n\t                      ^^\nRedundant specification of type arguments <Number>\n----------\n", null, false, customOptions);
    }

    public void test0056c() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X <T> {\n\tX(T t){}\n\tclass X1<Z> {\n\t\tX1(Z z){}\n\t}\n\tX<Integer>.X1<Number> x1 = new X<Integer>(1).new X1<Number>(1);\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 6)\n\tX<Integer>.X1<Number> x1 = new X<Integer>(1).new X1<Number>(1);\n\t                               ^\nRedundant specification of type arguments <Integer>\n----------\n" : "----------\n1. ERROR in X.java (at line 6)\n\tX<Integer>.X1<Number> x1 = new X<Integer>(1).new X1<Number>(1);\n\t                               ^\nRedundant specification of type arguments <Integer>\n----------\n2. ERROR in X.java (at line 6)\n\tX<Integer>.X1<Number> x1 = new X<Integer>(1).new X1<Number>(1);\n\t                                                 ^^\nRedundant specification of type arguments <Number>\n----------\n", null, false, customOptions);
    }

    public void test0057() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test() {\n\t\tPair<Double, Integer> p = new InvertedPair<Integer, Double>();\n\t}\n}\nclass Pair<A, B> {\n}\nclass InvertedPair<A, B> extends Pair<B, A> {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tPair<Double, Integer> p = new InvertedPair<Integer, Double>();\n\t                              ^^^^^^^^^^^^\nRedundant specification of type arguments <Integer, Double>\n----------\n", null, false, customOptions);
    }

    public void test0058() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\n\npublic class X {\n    public void test(boolean param) {\n        ArrayList<?> ls = (param) \n        \t\t? new ArrayList<String>()\n        \t\t: new ArrayList<Object>();\n        \t\t\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\t: new ArrayList<Object>();\n\t      ^^^^^^^^^\nRedundant specification of type arguments <Object>\n----------\n", null, false, customOptions);
    }

    public void test0059() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X<T> {\n\t X(List<? extends T> p) {}\n    Object x = new X<CharSequence>((ArrayList<String>) null);\n}\n"}, "", null, false, customOptions);
    }

    public void test0060() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.source", "1.4");
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\t public void foo() {\n    \tnew ArrayList<>();\n\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tnew ArrayList<>();\n\t    ^^^^^^^^^\n'<>' operator is not allowed for source level below 1.7\n----------\n2. ERROR in X.java (at line 6)\n\tnew ArrayList<>();\n\t    ^^^^^^^^^\nIncorrect number of arguments for type ArrayList<E>; it cannot be parameterized with arguments <>\n----------\n", null, false, customOptions);
    }

    public void test0060a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.source", "1.4");
        this.runNegativeTest(new String[]{"X.java", "\npublic class X {\n\t public void foo() {\n    \tnew java.util.ArrayList<>();\n\t }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tnew java.util.ArrayList<>();\n\t    ^^^^^^^^^^^^^^^^^^^\n'<>' operator is not allowed for source level below 1.7\n----------\n2. ERROR in X.java (at line 4)\n\tnew java.util.ArrayList<>();\n\t    ^^^^^^^^^^^^^^^^^^^\nIncorrect number of arguments for type ArrayList<E>; it cannot be parameterized with arguments <>\n----------\n", null, false, customOptions);
    }

    public void test0061() {
        this.runNegativeTest(new String[]{"X.java", "import java.net.URI;import java.nio.file.FileSystems;import java.util.Collections;\npublic class X {\n\t public static void foo() {\n    \tURI uri = URI.create(\"http://www.eclipse.org\");\n\t\tFileSystems.<String, Object>newFileSystem(uri, Collections.emptyMap());\n\t }\n}\n"}, this.complianceLevel < 0x340000L ? "----------\n1. ERROR in X.java (at line 5)\n\tFileSystems.<String, Object>newFileSystem(uri, Collections.emptyMap());\n\t                            ^^^^^^^^^^^^^\nThe method newFileSystem(URI, Map<String,?>) in the type FileSystems is not applicable for the arguments (URI, Map<Object,Object>)\n----------\n" : "----------\n1. ERROR in X.java (at line 5)\n\tFileSystems.<String, Object>newFileSystem(uri, Collections.emptyMap());\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n2. WARNING in X.java (at line 5)\n\tFileSystems.<String, Object>newFileSystem(uri, Collections.emptyMap());\n\t             ^^^^^^^^^^^^^^\nUnused type arguments for the non generic method newFileSystem(URI, Map<String,?>) of type FileSystems; it should not be parameterized with arguments <String, Object>\n----------\n");
    }

    public void test428220() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runNegativeTest(new String[]{"X.java", "public class HashMap<K, V> {\n\tstatic class Node<K, V> {\n\t\tNode(int hash, K key, V value, Node<K, V> next) {}\n\t}\n\t/** @see #put(Object, Object) */\n\tpublic V put(K key, V value) {\treturn null; }\n\n\tNode<K, V> newNode(int hash, K key, V value, Node<K, V> next) {\n\t\treturn new Node<>(hash, key, value, next); // Error\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class HashMap<K, V> {\n\t             ^^^^^^^\nThe public type HashMap must be defined in its own file\n----------\n", null, true, customOptions);
    }

    public void test428220a() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        this.runNegativeTest(new String[]{"X.java", "public class HashMap<K, V> {\n\tstatic class Node<K, V> {\n\t\tNode(int hash, K key, V value, Node<K, V> next) {}\n\t}\n\t/** @see #put(Object, Object) */\n\tpublic V put(K key, V value) {\treturn null; }\n\n\tNode<K, V> newNode(int hash, K key, V value, Node<K, V> next) {\n\t\treturn new Node<>(hash, key, value, next); // Error\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class HashMap<K, V> {\n\t             ^^^^^^^\nThe public type HashMap must be defined in its own file\n----------\n", null, true, customOptions);
    }

    public void test442929() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tshouldNotThrow();\n\t}\n\tstatic void shouldNotThrow() {\n\t\tfinal String[] array = { \"\" };\n\t\tfinal String[] expected = { \"\" };\n\t\t// throws\n       try {\n\t\t    assertThat(op(array, \"\")).isEqualTo(expected);\n       } catch (ClassCastException c) {\n           System.out.println(\"Expected CCE\");\n       }\n\t}\n\tstatic <T> T[] op(T[] array, T element) {\n\t\treturn asArray(element);\n\t}\n\t@SafeVarargs\n\tstatic <T> T[] asArray(T... elements) {\n\t\treturn elements;\n\t}\n\tstatic <T> ObjectArrayAssert<T> assertThat(T actual) {\n\t\treturn new ObjectArrayAssert<>(actual);\n\t}\n\tstatic class ObjectArrayAssert<T> {\n\t\tObjectArrayAssert(T actual) {\n\t\t}\n\t\tvoid isEqualTo(T expected) {\n\t\t}\n\t}\n}\n"}, "Expected CCE");
    }

    public void test448028() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n  public static interface I {/*empty*/}\n\n  public static class C\n    implements I {/*empty*/}\n\n  public static class W<T extends I>\n    implements I {\n\n    // --- problem is triggered only, when there is a vararg-parameter\n    public W(final T t, final Object... o) {\n      super();\n    }\n  }\n\n  // --- needed to trigger problem\n  public static final <T> T inspect(final T t) {\n    return t;\n  }\n\n  // --- this compiles ok when having JDK Compilance set to 1.7 !\n  public static final W<C> err1() {\n    final C c = new C();\n    final Object o = new Object();\n    return inspect(new W<>(c, o)); // - ERROR: Cannot infer type arguments for W<> F.java\n  }\n\n  public static final W<C> wrn1() {\n    final C c = new C();\n    final Object o = new Object();\n    // --- giving the type-parameter yields a warning\n    // --- comparing that to the error of method err1() it does not make much sense\n    return inspect(new W<C>(c, o)); // - WARNING: Redundant specification of type arguments <F.C> F.java\n  }\n\n  public static final W<C> ok1() {\n    final C c = new C();\n    // --- no extra vararg-paramaeter\n    return inspect(new W<>(c)); // - OK\n  }\n\n  public static final W<C> ok2() {\n    final C c = new C();\n    final Object o = new Object();\n    // --- no check-method\n    return new W<>(c, o); // - OK\n  }\n\n  public static final W<C> ok3() {\n    final C c = new C();\n    // --- no check-method\n    return new W<>(c); // - OK\n  }\n\n  public static final W<C> ok4() {\n    final C c = new C();\n    final Object o = new Object();\n    // --- this also compiles (my solution for now)\n    final W<C> w = new W<>(c, o);\n    return inspect(w);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 34)\n\treturn inspect(new W<C>(c, o)); // - WARNING: Redundant specification of type arguments <F.C> F.java\n\t                   ^\nRedundant specification of type arguments <X.C>\n----------\n", null, false, customOptions);
    }

    public void test449619() {
        String source = "public class X {\n\tpublic class Y<T> {\n\t}\n\tstatic void foo(Y<String> ys) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(new X().new Y<>());\n\t}\n}\n";
        if (this.complianceLevel >= 0x340000L) {
            this.runConformTest(new String[]{"X.java", source}, "");
        } else {
            this.runNegativeTest(new String[]{"X.java", source}, "----------\n1. ERROR in X.java (at line 7)\n\tfoo(new X().new Y<>());\n\t^^^\nThe method foo(X.Y<String>) in the type X is not applicable for the arguments (X.Y<Object>)\n----------\n");
        }
    }

    public void test429733() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttest(new Some<>(1.1d));\n\t}\n\tstatic <S> void test(Option<S> value) {\n\t}\n\tstatic interface Option<T> {\n\t}\n\tstatic class Some<T> implements Option<T> {\n\t\tSome(T value) {\n         System.out.println(value);\n\t\t}\n\t}\n}\n"}, "1.1");
    }

    public void test429733a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttest(new Some<Double>(1.1d));\n\t}\n\tstatic <S> void test(Option<S> value) {\n\t}\n\tstatic interface Option<T> {\n\t}\n\tstatic class Some<T> implements Option<T> {\n\t\tSome(T value) {\n         System.out.println(value);\n\t\t}\n\t}\n}\n"}, "1.1");
    }

    public void test375394a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    B<C, ? extends C<C>, ? extends C<C>> b = new B<>();\n}\nclass B <T, U extends C<T>, V extends U>{}\nclass C<T> {}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tB<C, ? extends C<C>, ? extends C<C>> b = new B<>();\n\t  ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tB<C, ? extends C<C>, ? extends C<C>> b = new B<>();\n\t                 ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n3. WARNING in X.java (at line 2)\n\tB<C, ? extends C<C>, ? extends C<C>> b = new B<>();\n\t                                 ^\nC is a raw type. References to generic type C<T> should be parameterized\n----------\n");
    }

    public void test427728b() {
        this.runConformTest(new String[]{"X.java", "import java.util.Collections;\nimport java.util.LinkedHashMap;\nimport java.util.Map;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t   Map<X, Integer> map = new LinkedHashMap<>();\n\t\t   map.put(null, X.getInt());\n\t\t   map.put(null, X.getint());\n\t\t}\n\t\tprivate static <T> int getInt() {\n\t\t   return 0;\n\t\t}\n\t\tprivate static int getint() {\n\t\t\t   return 0;\n\t\t}\n}\n"}, "");
    }

    public void testBug456508() {
        this.runNegativeTest(new String[]{"QueryAtom.java", "public class QueryAtom<T, P> {\n\tpublic QueryAtom(SingularAttribute<? super T, P> path) {\n\t}\n}\n", "SubqueryIn.java", "public class SubqueryIn<S, P>  {\n\tpublic SubqueryIn(QueryAtom<S, P>... subqueryAtoms) {\n\t}\n}\n", "Test.java", "class PAccount {}\nclass PGroepAccount {}\ninterface SingularAttribute<X, T> {}\n\npublic class Test {\n    public static volatile SingularAttribute<PGroepAccount, PAccount> account;\n\n\tpublic void nietInGroep() {\n\t\trecordFilter(new SubqueryIn<>(new QueryAtom<>(account)));\n\t}\n\n\tprotected <P> void recordFilter(SubqueryIn<?, P> atom) {\n\t}\n}\n"}, "----------\n1. WARNING in SubqueryIn.java (at line 2)\n\tpublic SubqueryIn(QueryAtom<S, P>... subqueryAtoms) {\n\t                                     ^^^^^^^^^^^^^\nType safety: Potential heap pollution via varargs parameter subqueryAtoms\n----------\n----------\n1. WARNING in Test.java (at line 9)\n\trecordFilter(new SubqueryIn<>(new QueryAtom<>(account)));\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: A generic array of QueryAtom<PGroepAccount,PAccount> is created for a varargs parameter\n----------\n");
    }

    public void testBug462083() {
        this.runConformTest(new String[]{"Java8InterfaceTest.java", "public abstract class Java8InterfaceTest\n{\n\tpublic static interface Entity {}\n\n\tpublic static interface Service<T1 extends Entity> {}\n\n    public static interface ServiceLocator<T2 extends Entity> {}\n\n    public static class ConcreteClass<T3 extends Entity, S extends Service<T3>> implements ServiceLocator<T3> {}\n\n    protected abstract <T4 extends Entity> ConcreteClass<T4, ?> getParameterized(T4 entity);\n\n    protected <T5 extends Entity> ServiceLocator<T5> getInterface(T5 entity)\n    {\n    \treturn getParameterized(entity);\n    }\n}\n"});
    }

    public void testBug469653() {
        String codeContent = "import java.util.*;\n\nclass ImmutableList<E> {\n\tstatic <F> ImmutableList<F> copyOf(Iterable<? extends F> in) { return null; }\n\tImmutableList<E> reverse() { return this; }\n\tIterator<E> iterator() { return null; }\n}\npublic class Code {\n  public static void test() {\n      Iterable<? extends String> services = null;\n      Iterator<String> reverseServices = ImmutableList.copyOf(services).reverse().iterator();\n  }\n}";
        if (this.complianceLevel < 0x340000L) {
            this.runConformTest(new String[]{"Code.java", codeContent});
        } else {
            this.runNegativeTest(new String[]{"Code.java", codeContent}, "----------\n1. ERROR in Code.java (at line 11)\n\tIterator<String> reverseServices = ImmutableList.copyOf(services).reverse().iterator();\n\t                                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Iterator<capture#1-of ? extends String> to Iterator<String>\n----------\n");
        }
    }

    public void testBug488649_JDK6791481_ex1() {
        int count = 1;
        this.runNegativeTest(new String[]{"Test.java", "class Test<X> {\n\tX m(Class<X> c) {return null;}\n\tX x = m((Class)String.class);\n}\n"}, "----------\n" + (this.complianceLevel >= 0x340000L ? String.valueOf(count++) + ". ERROR in Test.java (at line 3)\n" + "\tX x = m((Class)String.class);\n" + "\t      ^^^^^^^^^^^^^^^^^^^^^^\n" + "Type mismatch: cannot convert from Object to X\n" + "----------\n" : "") + count++ + ". WARNING in Test.java (at line 3)\n" + "\tX x = m((Class)String.class);\n" + "\t        ^^^^^^^^^^^^^^^^^^^\n" + "Type safety: The expression of type Class needs unchecked conversion to conform to Class<X>\n" + "----------\n" + count++ + ". WARNING in Test.java (at line 3)\n" + "\tX x = m((Class)String.class);\n" + "\t         ^^^^^\n" + "Class is a raw type. References to generic type Class<T> should be parameterized\n" + "----------\n");
    }

    public static Class testClass() {
        return GenericsRegressionTest_1_7.class;
    }
}

