/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class GenericsRegressionTest_1_8
extends AbstractRegressionTest {
    public GenericsRegressionTest_1_8(String name) {
        super(name);
    }

    public static Class testClass() {
        return GenericsRegressionTest_1_8.class;
    }

    public static Test suite() {
        return GenericsRegressionTest_1_8.buildMinimalComplianceTestSuite(GenericsRegressionTest_1_8.testClass(), 32);
    }

    public void testBug423070() {
        this.runConformTest(new String[]{"junk/Junk3.java", "package junk;\n\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.List;\n\nclass ZZObject extends Object {\n}\n\npublic class Junk3 {\n\n    public static final List EMPTY_LIST = new ArrayList<>();\n    public static final <T> List<T> emptyList() {\n        return (List<T>) EMPTY_LIST;\n    }\n    \n    public Junk3(List<ZZObject> list) {\n    }\n    \n    //FAILS - if passed as argument\n    public Junk3() {\n        this(emptyList());\n    }\n    \n\n    //WORKS - if you assign it (and lose type info?)\n    static List works = emptyList();\n    public Junk3(boolean bogus) {\n        this(works);\n    }\n}"});
    }

    public void testConditionalExpression1() {
        this.runConformTest(new String[]{"X.java", "class A {}\nclass B extends A {}\npublic class X {\n\t<T> T combine(T x, T y) { return x; }\n\tA test(A a, B b, boolean flag) {\n\t\treturn combine(flag ? a : b, a);\n\t}\n}\n"});
    }

    public void testConditionalExpression2() {
        this.runConformTest(new String[]{"X.java", "class A{/**/}\nclass B extends A {/**/}\nclass C extends B {/**/}\nclass G<T> {/**/}\n\npublic class X {\nG<A> ga=null;\nG<B> gb=null;\nG<C> gc=null;\nG<? super A> gsa=null;\nG<? super B> gsb=null;\nG<? super C> gsc=null;\n\n@SuppressWarnings(\"unused\")\n    public void test(boolean f) {\n\t\tG<? super B> l1 = (f) ? gsa : gb;\n\t\tG<? super B> l2 = (f) ? gsb : gb;\n       G<? super C> l3 = (f) ? gsc : gb;\n       G<? super B> l4 = (f) ? gsb : gsb;\n\t}\n}"});
    }

    public void testBug423839() {
        this.runConformTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\n\npublic class Test<T> {\n\n    public <T> T randomElement(Collection<T> list) {\n        return randomElement(list instanceof List ? list : new ArrayList<>(list));\n    }\n\n}\n"});
    }

    public void testBug418807() {
        this.runConformTest(new String[]{"Word.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n \npublic class Word {\n\tprivate final String str;\n\n\tpublic Word(String s) {\n\t\tstr = s;\n\t}\n\n\t@Override\n\tpublic String toString() {\n\t\treturn str;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tList<String> names = Arrays.asList(\"Aaron\", \"Jack\", \"Ben\");\n\t\tStream<Word> ws = names.stream().map(Word::new);\n\t\tList<Word> words = ws.collect(Collectors.toList());\n\t\twords.forEach(System.out::println);\n\t}\n}\n"});
    }

    public void testBug414631() {
        this.runConformTest(new String[]{"test/Y.java", "package test;\nimport java.util.function.Supplier;\npublic abstract class Y<E>  {\n  public static <E> Y<E> empty() { return null;}\n  public static <E> Y<E> cons(E head, Supplier<Y<E>> tailFun) {return null;}\n}", "test/X.java", "package test;\nimport static test.Y.*;\npublic class X  {\n  public void foo() {\n    Y<String> generated = cons(\"a\", () -> cons(\"b\", Y::<String>empty));\n  }\n}\n"});
    }

    public void testBug424038() {
        this.runNegativeTest(new String[]{"Foo.java", "import java.util.*;\nimport java.util.function.*;\npublic class Foo<E> {\n\n    public void gather() {\n        StreamLike<E> stream = null;\n        List<Stuff<E>> list1 = stream.gather(() -> new Stuff<>()).toList();\n        List<Consumer<E>> list2 = stream.gather(() -> new Stuff<>()).toList(); // ERROR\n    }\n\n    interface StreamLike<E> {\n        <T extends Consumer<E>> StreamLike<T> gather(Supplier<T> gatherer);\n\n        List<E> toList();\n    }\n\n    static class Stuff<T> implements Consumer<T> {\n        public void accept(T t) {}\n    }\n}\n"}, "----------\n1. ERROR in Foo.java (at line 8)\n\tList<Consumer<E>> list2 = stream.gather(() -> new Stuff<>()).toList(); // ERROR\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Foo.Stuff<E>> to List<Consumer<E>>\n----------\n");
    }

    public void testBug423504() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X  {\n  public static void main(String argv[]) {\n    I<? extends Collection<String>> sorter = (List<String> m) -> { /* sort */ };\n  }\n} \n\ninterface I<T> { \n  public void sort(T col);\n}\n"});
    }

    public void testBug420525() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.concurrent.CompletableFuture;\nimport java.util.concurrent.ExecutionException;\npublic class X {\n\tvoid test(List<CompletableFuture<Integer>> futures) {\n\t\tCompletableFuture.allOf(futures.toArray(new CompletableFuture<?>[]{})).thenApplyAsync( (Void v) -> {\n\t\t\tInteger finalResult = futures.stream().map( (CompletableFuture<Integer> f) -> {\n\t\t\t\ttry {\n\t\t\t\t\treturn f.get();\n\t\t\t\t} catch (InterruptedException | ExecutionException e) {\n\t\t\t\t\treturn 0;\n\t\t\t\t}\n\t\t\t}).reduce(0, Integer::sum);\n\t\t\t\n\t\t\tlog(\"final result is \" + finalResult);\n\t\t\tif (finalResult != 50){\n\t\t\t\tthrow new RuntimeException(\"FAILED\");\n\t\t\t} else{\n\t\t\t\tlog(\"SUCCESS\");\n\t\t\t}\n\t\t\t\n\t\t\treturn null;\n\t\t});\n\n\t}\n\tvoid log(String msg) {}\n}\n"});
    }

    public void testBug420525_mini() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.concurrent.CompletableFuture;\nimport java.util.concurrent.ExecutionException;\npublic class X {\n\tvoid test(List<CompletableFuture<Integer>> futures, boolean b) {\n\t\tInteger finalResult = futures.stream().map( (CompletableFuture<Integer> f) -> {\n\t\t\t\t\tif (b) \n\t\t\t\t\t\treturn 1;\n\t\t\t\t\telse\n\t\t\t\t\t\treturn Integer.valueOf(13);\t\t\t\t}).reduce(0, Integer::sum);\n\t}\n}\n"});
    }

    public void testBug420525a() {
        this.runNegativeTest(new String[]{"Main.java", "interface I<T> {\n    T bold(T t);\n}\n\nclass Main {  \n    public String foo(String x) { return \"<b>\" + x + \"</b>\"; }\n    String bar() {\n        I<? extends String> i = this::foo;\n        return i.bold(\"1\");\n    }  \n}\n"}, "----------\n1. ERROR in Main.java (at line 9)\n\treturn i.bold(\"1\");\n\t         ^^^^\nThe method bold(capture#1-of ? extends String) in the type I<capture#1-of ? extends String> is not applicable for the arguments (String)\n----------\n");
    }

    public void testBug424415() {
        this.runConformTest(new String[]{"X.java", "\nimport java.util.ArrayList;\nimport java.util.Collection;\n\ninterface Functional<T> {\n   T apply();\n}\n\nclass X {\n    void foo(Object o) { }\n\n\t<Q extends Collection<?>> Q goo(Functional<Q> s) {\n\t\treturn null;\n\t} \n\n    void test() {\n        foo(goo(ArrayList<String>::new));\n    }\n}\n"});
    }

    public void testBug424415b() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\n\ninterface Functional<T> {\n   T apply();\n}\n\nclass X {\n    void foo(Object o) { }\n    void foo(String str) {} \n\n    <Q extends Collection<?>> Q goo(Functional<Q> s) {\n        return null;\n    } \n\n    void test() {\n        foo(goo(ArrayList<String>::new));\n    }\n}\n"});
    }

    public void testBug424415c() {
        this.runConformTest(new String[]{"com/example/MyEmployee.java", "package com.example;\nclass MyEmployee {\n\t\n\tpublic enum Gender { MALE, FEMALE, OTHERS }\n\n\tprivate int age = 0;\n\tprivate Gender gender = Gender.MALE;\n\t\n\tpublic MyEmployee(int age, Gender gender) {\n\t\tthis.age = age;\n\t\tthis.gender = gender;\n\t}\t\n\t\n\tpublic int getAge() {\n\t\treturn age;\n\t}\n\t\n\tpublic Gender getGender() {\n\t\treturn gender;\n\t}\n}", "com/example/Test.java", "package com.example;\n\nimport java.util.List;\nimport java.util.concurrent.ConcurrentMap;\nimport java.util.stream.Collectors;\n\npublic class Test {\n\n\tConcurrentMap<MyEmployee.Gender, List<MyEmployee>> test(List<MyEmployee> el) {\n\t\treturn el.parallelStream()\n\t\t\t\t\t.collect(\n\t\t\t\t\t\tCollectors.groupingByConcurrent(MyEmployee::getGender)\n\t\t\t\t\t\t);\n\t}\n\t\n}"});
    }

    public void testBug424631() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\n\ninterface Functional<T> {\n   T apply();\n}\n\nclass X {\n    void foo(Collection<String> o) { }\n\n\t<Q extends Collection<?>> Q goo(Functional<Q> s) {\n\t\treturn null;\n\t} \n\n    void test() { \n        foo(goo(ArrayList<String>::new));\n    }\n}\n"});
    }

    public void testBug424403() {
        this.runConformTest(new String[]{"X.java", "interface Functional { int foo(); }\n\npublic class X {\n    static int bar() {\n        return -1;\n    }\n    static <T> T consume(T t) { return null; }\n\n    public static void main(String[] args) {\n    \tFunctional f = consume(X::bar);\n    }  \n}\n"});
    }

    public void testBug401850a() {
        this.runNegativeTest(false, this.complianceLevel < 0x340000L ? null : AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\npublic class X<T> {\n   X(T t) {}\n   X(String s) {}\n   int m(X<String> xs) { return 0; }\n   int i = m(new X<>(\"\"));\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\timport java.util.List;\n\t       ^^^^^^^^^^^^^^\nThe import java.util.List is never used\n----------\n2. WARNING in X.java (at line 2)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n");
    }

    public void testBug401850b() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.ArrayList;\npublic class X<T> {\n   X(T t) {}\n   X(String s) {}\n   int m(X<String> xs) { return 0; }\n   int i = m(new X<String>(\"\"));\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tint i = m(new X<String>(\"\"));\n\t          ^^^^^^^^^^^^^^^^^\nThe constructor X<String>(String) is ambiguous\n----------\n");
    }

    public void testBug424710() {
        this.runConformTest(new String[]{"MapperTest.java", "import java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.regex.Matcher;\nimport java.util.regex.Pattern;\nimport java.util.stream.Stream;\n\npublic class MapperTest {\n\n    public static void main( String... argv ){\n        List<String> data = Arrays.asList(\"abc\", \"123\", \"1a\", \"?!?\");\n        List<Pattern> patterns = Arrays.asList(Pattern.compile(\"[a-z]+\"), Pattern.compile(\"[0-9]+\"));\n\t\tpatterns.stream()\n\t\t\t\t.flatMap(\n\t\t\t\t\t\tp -> {\n\t\t\t\t\t\t\tStream<Matcher> map = data.stream().map(p::matcher);\n\t\t\t\t\t\t\tStream<Matcher> filter = map.filter(Matcher::find);\n\t\t\t\t\t\t\tFunction<? super Matcher, ? extends Object> mapper = Matcher::group;\n\t\t\t\t\t\t\tmapper = matcher -> matcher.group();\n\t\t\t\t\t\t\treturn filter.map(mapper);\n\t\t\t\t\t\t})\n\t\t\t\t.forEach(System.out::println);\n    }\n}\n"});
    }

    public void testBug424075() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.function.*;\npublic class X {\n    public static void main(String[] args) {\n        Consumer<Object> c = null;\n        Arrays.asList(pred(), c);\n    }\n\n    static <T> Predicate<T> pred() {\n        return null;\n    }\n}\n"});
    }

    public void testBug424205a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid bar(String t);\n}\nclass X<T> implements I {\n\tpublic void bar(String t) {}\n\tX(String x) {}\n\tX(T x) {}\n\tpublic void one(X<I> c){}\n\tpublic void two() {\n\t\tX<I> i = new X<>((String s) -> { });\n\t\tone (i);\n\t}\n}\n"});
    }

    public void testBug424205b() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid bar(String t);\n}\npublic class X<T> implements I {\n\tpublic void bar(String t) {}\n\tX(String x) {}\n\tX(T x) {}\n\tpublic void one(X<I> c){}\n\tpublic void two() {\n\t\tone(new X<>((String s) -> { })); // 1. Three errors\n\t\tX<I> i = new X<>((String s) -> { }); // 2. Error - Comment out the previous line to see this error go away.\n\t\tone (i);\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"main\");\n\t\tnew X<Integer>(\"one\").two();\n\t}\n}\n"}, "main");
    }

    public void testBug424712a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.function.Supplier;\nimport java.util.Set;\n\npublic class X {\n    public static <T, SOURCE extends Collection<T>, DEST extends Collection<T>>\n        DEST foo(SOURCE sourceCollection, DEST collectionFactory) {\n            return null;\n    }  \n    \n    public static void main(String... args) {\n        Set<Y> rosterSet = (Set<Y>) foo(null, Set::new);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tSet<Y> rosterSet = (Set<Y>) foo(null, Set::new);\n\t    ^\nY cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 12)\n\tSet<Y> rosterSet = (Set<Y>) foo(null, Set::new);\n\t                        ^\nY cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 12)\n\tSet<Y> rosterSet = (Set<Y>) foo(null, Set::new);\n\t                                      ^^^\nCannot instantiate the type Set\n----------\n");
    }

    public void testBug424712b() {
        this.runConformTest(new String[]{"X.java", "import java.util.Comparator;\npublic class X {\n\t<T> void test() {\n\t\tComparator<? super T> comparator = (Comparator<? super T>) Comparator.naturalOrder();\n\t\tSystem.out.println(\"OK\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().test();\n\t}\n}\n"}, "OK");
    }

    public void testBug425142_minimal() {
        this.runNegativeTest(new String[]{"SomethingBreaks.java", "import java.io.IOException;\nimport java.nio.file.Files;\nimport java.nio.file.Paths;\nimport java.util.function.Consumer;\n\n@FunctionalInterface interface Use<T, E extends Throwable> {   void accept(T t) throws E; }\n\n@SuppressWarnings(\"unused\") public class SomethingBreaks<T, E extends Throwable> {\n  protected static SomethingBreaks<String, IOException> stream() {     return null;  }\n\n  public void forEach(Consumer<T> use) throws E {}\n\n  public <E2 extends E> void forEach(Use<T, E2> use) throws E, E2 {}\n\n  private static void methodReference(String s) throws IOException {\n    System.out.println(Files.size(Paths.get(s)));\n  }\n  \n  public static void useCase9() throws IOException {\n    stream().forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n  }\n}\n"}, "----------\n1. ERROR in SomethingBreaks.java (at line 20)\n\tstream().forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n\t         ^^^^^^^\nThe method forEach(Consumer<String>) is ambiguous for the type SomethingBreaks<String,IOException>\n----------\n");
    }

    public void testBug425142_full() {
        this.runNegativeTest(new String[]{"SomethingBreaks.java", "import java.io.IOException;\nimport java.nio.file.Files;\nimport java.nio.file.Paths;\nimport java.util.function.Consumer;\n\n@FunctionalInterface interface Use<T, E extends Throwable> {   void accept(T t) throws E; }\n\n@SuppressWarnings(\"unused\") public class SomethingBreaks<T, E extends Throwable> {\n  protected static SomethingBreaks<String, IOException> stream() {     return null;  }\n\n  public void forEach(Consumer<T> use) throws E {}\n\n  public <E2 extends E> void forEach(Use<T, E2> use) throws E, E2 {}\n\n  private static void methodReference(String s) throws IOException {\n    System.out.println(Files.size(Paths.get(s)));\n  }\n  \n  public static void useCase1() throws IOException {\n    Use<String, IOException> c =\n      (String s) -> System.out.println(Files.size(Paths.get(s)));\n    stream().forEach(c);\n  }\n  \n  public static void useCase2() throws IOException {\n    Use<String, IOException> c = SomethingBreaks::methodReference;\n    stream().forEach(c);\n  }\n  \n  public static void useCase3() throws IOException {\n    stream().forEach((Use<String, IOException>) (String s) -> System.out.println(Files.size(Paths.get(s))));\n  }\n  \n  public static void useCase4() throws IOException {\n    stream().forEach((Use<String, IOException>) SomethingBreaks::methodReference);\n  }\n  \n  public static void useCase5() throws IOException {\n    stream().<IOException> forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n  }\n  \n  public static void useCase6() throws IOException {\n    stream().<IOException> forEach(SomethingBreaks::methodReference);\n  }\n  \n  public static void useCase7() throws IOException {\n    stream().<Use<String, IOException>> forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n  }\n  \n  public static void useCase8() throws IOException {\n    stream().<Use<String, IOException>> forEach(SomethingBreaks::methodReference);\n  }\n  \n  public static void useCase9() throws IOException {\n    stream().forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n  }\n  \n  public static void useCase10() throws IOException {\n    stream().forEach(SomethingBreaks::methodReference);\n  }\n}\n"}, "----------\n1. ERROR in SomethingBreaks.java (at line 39)\n\tstream().<IOException> forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n\t                       ^^^^^^^\nThe method forEach(Consumer<String>) is ambiguous for the type SomethingBreaks<String,IOException>\n----------\n2. ERROR in SomethingBreaks.java (at line 43)\n\tstream().<IOException> forEach(SomethingBreaks::methodReference);\n\t                       ^^^^^^^\nThe method forEach(Consumer<String>) is ambiguous for the type SomethingBreaks<String,IOException>\n----------\n3. ERROR in SomethingBreaks.java (at line 43)\n\tstream().<IOException> forEach(SomethingBreaks::methodReference);\n\t                               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n4. ERROR in SomethingBreaks.java (at line 47)\n\tstream().<Use<String, IOException>> forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n\t                                                                             ^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n5. ERROR in SomethingBreaks.java (at line 51)\n\tstream().<Use<String, IOException>> forEach(SomethingBreaks::methodReference);\n\t                                            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n6. ERROR in SomethingBreaks.java (at line 55)\n\tstream().forEach((String s) -> System.out.println(Files.size(Paths.get(s))));\n\t         ^^^^^^^\nThe method forEach(Consumer<String>) is ambiguous for the type SomethingBreaks<String,IOException>\n----------\n7. ERROR in SomethingBreaks.java (at line 59)\n\tstream().forEach(SomethingBreaks::methodReference);\n\t         ^^^^^^^\nThe method forEach(Consumer<String>) is ambiguous for the type SomethingBreaks<String,IOException>\n----------\n8. ERROR in SomethingBreaks.java (at line 59)\n\tstream().forEach(SomethingBreaks::methodReference);\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n");
    }

    public void testBug424195a() {
        this.runNegativeTestMultiResult(new String[]{"NPEOnCollector.java", "import java.io.IOException;\nimport java.nio.file.Path;\nimport java.util.ArrayList;\nimport java.util.function.Function;\nimport java.util.function.Predicate;\nimport java.util.jar.JarEntry;\nimport java.util.jar.JarFile;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\n\npublic class NPEOnCollector {\n  static void processJar(Path plugin) throws IOException {\n    \n    try(JarFile jar = new JarFile(plugin.toFile())) {\n      try(Stream<JarEntry> entries = jar.stream()) {\n        Stream<JarEntry> stream = entries\n          .distinct().collect(Collectors.toCollection(ArrayList::new));\n        \n      }\n    }\n  }\n}\n"}, null, new String[]{"----------\n1. ERROR in NPEOnCollector.java (at line 17)\n\tStream<JarEntry> stream = entries\n          .distinct().collect(Collectors.toCollection(ArrayList::new));\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Collection<JarEntry> to Stream<JarEntry>\n----------\n", "----------\n1. ERROR in NPEOnCollector.java (at line 18)\n\t.distinct().collect(Collectors.toCollection(ArrayList::new));\n\t                                            ^^^^^^^^^^^^^^\nThe constructed object of type ArrayList is incompatible with the descriptor's return type: Stream<JarEntry>&Collection<T#2>&Collection<JarEntry>\n----------\n"});
    }

    public void testBug424195b() {
        this.runConformTest(new String[]{"NPEOnCollector.java", "import java.io.IOException;\nimport java.nio.file.Path;\nimport java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.function.Function;\nimport java.util.function.Predicate;\nimport java.util.jar.JarEntry;\nimport java.util.jar.JarFile;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\n\npublic class NPEOnCollector {\n  static void processJar(Path plugin) throws IOException {\n    \n    try(JarFile jar = new JarFile(plugin.toFile())) {\n      try(Stream<JarEntry> entries = jar.stream()) {\n        Collection<JarEntry> collection = entries\n          .distinct().collect(Collectors.toCollection(ArrayList::new));\n        \n      }\n    }\n  }\n}\n"});
    }

    public void testBug424195_comment2() {
        this.runConformTest(new String[]{"X.java", "import java.io.PrintStream;\nimport java.util.ArrayList;\nimport java.util.stream.Collectors;\nimport java.util.stream.*;\npublic class X  {\n\n    public static void main(String argv[]) {\n        ArrayList<Integer> al = IntStream\n        \t     .range(0, 10_000)\n        \t     .boxed()\n        \t     .collect(Collectors.toCollection(ArrayList::new));\n\n    }\n}\n"});
    }

    public void testBug425153() {
        this.runNegativeTest(new String[]{"Main.java", "class C1 {}\nclass C2 {}\n\ninterface I<P1 extends C1, P2 extends P1> {\n    P2 foo(P1 p1);\n}\n\npublic class Main  {\n\t    public static void main(String argv[]) {\n\t    \tI<?, ?> i = (C1 c1) -> { return new C2(); };\n\t        Object c2 = i.foo(null);\n\t    }\n}\n"}, "----------\n1. ERROR in Main.java (at line 10)\n\tI<?, ?> i = (C1 c1) -> { return new C2(); };\n\t            ^^^^^^^^^^\nThe target type of this expression is not a well formed parameterized type due to bound(s) mismatch\n----------\n");
    }

    public void testBug424845() {
        this.runConformTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\nimport java.util.List;\n\npublic class Test {\n    \n\n    interface Function<K, V>{\n        public V apply(K orig);\n    }\n    \n    \n    static class Ordering<O> {\n\n        public <K> Comparator<K> onResultOf(Function<K, ? extends O> function) {\n            return null;\n        }\n\n        \n    }\n    \n    public static void main(String[] args) {\n        List<Object> list = new ArrayList<>();\n        Function<Object, String> function = new Function<Object, String>() {\n            public String apply(Object arg0) {\n                return arg0.toString();\n            }\n        };\n        Ordering<Comparable<String>> natural = new Ordering<>();\n        Collections.sort(list, natural.onResultOf(function));\n    }\n    \n}\n"});
    }

    public void testBug425278() {
        this.runConformTest(new String[]{"X.java", "interface I<T, S extends X<T>> { \n    T foo(S p);\n}\n\npublic class X<T>  {\n    public void bar() {\n    I<Object, X<Object>> f = (p) -> p; // Error\n    }\n}\n"});
    }

    public void testBug425783() {
        this.runConformTest(new String[]{"Test.java", "class MyType<S extends MyType<S>> {\n\tS myself() { return (S)this; }\n}\npublic class Test {\n\tMyType test() {\n\t\treturn newInstance().myself();\n\t}\n\tMyType test2() {\n\t\treturn newInstance().myself();\n\t}\n\tpublic <T extends MyType> T newInstance() {\n\t\treturn (T) new MyType();\n\t}}\n"});
    }

    public void testBug425798() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\ninterface MyCollector<T, A, R> extends Collector<T, A, R> {\n}\npublic abstract class X {\n\tabstract <T, K, U, M extends Map<K, U>>\n    MyCollector<T, ?, M> toMap(Function<? super T, ? extends K> km,\n                                BinaryOperator<U> mf);\tvoid test(Stream<Annotation> annotations) {\n\t\tannotations\n\t\t\t.collect(toMap(Annotation::annotationType,\n\t\t\t\t (first, second) -> first));\n\t}\n}\n"}, "");
    }

    public void testBug425798a() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\ninterface MyCollector<T, A, R> extends Collector<T, A, R> {\n}\npublic abstract class X {\n\tabstract <T, K, U, M extends Map<K, U>>\n    MyCollector<T, ?, M> toMap(Function<? super T, ? extends K> km,\n                                BinaryOperator<U> mf);\tvoid test(Stream<Annotation> annotations) {\n\t\tannotations\n\t\t\t.collect(toMap(true ? Annotation::annotationType : Annotation::annotationType,\n\t\t\t\t (first, second) -> first));\n\t}\n}\n"}, "");
    }

    public void testBug425798b() {
        this.runConformTest(new String[]{"X.java", "import java.util.Objects;\nimport java.util.PrimitiveIterator;\nimport java.util.Spliterator;\nimport java.util.Spliterator.OfInt;\nimport java.util.function.Consumer;\nimport java.util.function.IntConsumer;\n\nclass IntIteratorSpliterator implements OfInt {\n\tpublic IntIteratorSpliterator(PrimitiveIterator.OfInt arg) { }\n\tpublic void forEachRemaining(IntConsumer action) { }\n\tpublic boolean tryAdvance(Consumer<? super Integer> action) { return false; }\n\tpublic long estimateSize() { return 0; }\n\tpublic int characteristics() { return 0; }\n\tpublic OfInt trySplit() { return null; }\n\tpublic boolean tryAdvance(IntConsumer action) { return false; }\n}\npublic class X {\n\n\tpublic Spliterator.OfInt spliterator(PrimitiveIterator.OfInt iterator) {\n\t\treturn new IntIteratorSpliterator(id(iterator));\n\t}\n\t<T> T id(T e) { return e; }\n}\n"});
    }

    public void testBug425460orig() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n\tfinal Integer[] boom =\n  \t\tArrays.asList(\"1\", \"22\", \"333\")\n  \t\t\t.stream()\n  \t\t\t.map(str -> str.length())\n  \t\t\t.toArray(i -> new Integer[i]);\n}\n"});
    }

    public void testBug425460variant() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n\tfinal Integer[] boom =\n  \t\tArrays.asList(\"1\", \"22\", \"333\")\n  \t\t\t.stream()\n  \t\t\t.map(str -> str.length())\n  \t\t\t.toArray((int i) -> new Integer[i]);\n}\n"});
    }

    public void testBug425951() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.List;\n\npublic class Test {\n\n    public static void main(String[] args) {\n        index(new A().test());\n    }\n\n    public static <X> void index(Iterable<X> collection)\n    {\n    }\n\t\n    public class A<S extends A<S>>\n    {\n        protected A() {}\n\t\t\n        public <T> List<T> test()\n       {\n            return null;\n       }\n    }\n}\n"}, "----------\n1. WARNING in Test.java (at line 6)\n\tindex(new A().test());\n\t^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation index(List) of the generic method index(Iterable<X>) of type Test\n----------\n2. WARNING in Test.java (at line 6)\n\tindex(new A().test());\n\t      ^^^^^^^^^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to Iterable<Object>\n----------\n3. ERROR in Test.java (at line 6)\n\tindex(new A().test());\n\t      ^^^^^^^\nNo enclosing instance of type Test is accessible. Must qualify the allocation with an enclosing instance of type Test (e.g. x.new A() where x is an instance of Test).\n----------\n4. WARNING in Test.java (at line 6)\n\tindex(new A().test());\n\t          ^\nTest.A is a raw type. References to generic type Test.A<S> should be parameterized\n----------\n");
    }

    public void testBug425951a() {
        this.runConformTest(new String[]{"Test.java", "import java.util.List;\n\npublic class Test {\n\n    public void test() {\n        index(new A().test());\n    }\n\n    public static <X> void index(Iterable<X> collection)\n    {\n    }\n\t\n    public class A<S extends A<S>>\n    {\n        protected A() {}\n\t\t\n        public <T> List<T> test()\n       {\n            return null;\n       }\n    }\n}\n"});
    }

    public void testBug424906() {
        this.runConformTest(new String[]{"Main.java", "public class Main {\n\tpublic <T> void test(Result r) {}\n\n\tpublic static void main(String[] args) {\n\t\tnew Main().test(r -> System.out.println(\"Hmmm...\" + r));\n\t}\n}\n\ninterface Result {\n\tpublic void result(Object object);\n}"});
    }

    public void testBug425156() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n    void foo(T t);\n}\npublic class X {\n    void bar(I<?> i) {\n        i.foo(null);\n    }\n    void run() {\n        bar((X x) -> {}); // Incompatible error reported\n    }\n}\n"});
    }

    public void testBug425493() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n    public void addAttributeBogus(Attribute<?> attribute) {\n        addAttribute(java.util.Objects.requireNonNull(attribute, \"\"),\n                attribute.getDefault());\n        addAttribute(attribute, attribute.getDefault());\n    }\n    public <T> void addAttributeOK(Attribute<T> attribute) {\n        addAttribute(java.util.Objects.requireNonNull(attribute, \"\"),\n                attribute.getDefault());\n        addAttribute(attribute, attribute.getDefault());\n    }\n\n    private <T> void addAttribute(Attribute<T> attribute, T defaultValue) {}\n\n    static class Attribute<T> {\n\n        T getDefault() {\n            return null;\n        }\n    }\n}\n"}, "----------\n1. ERROR in Test.java (at line 3)\n\taddAttribute(java.util.Objects.requireNonNull(attribute, \"\"),\n\t^^^^^^^^^^^^\nThe method addAttribute(Test.Attribute<T>, T) in the type Test is not applicable for the arguments (Test.Attribute<capture#1-of ?>, capture#2-of ?)\n----------\n2. ERROR in Test.java (at line 3)\n\taddAttribute(java.util.Objects.requireNonNull(attribute, \"\"),\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Test.Attribute<capture#1-of ?> to Test.Attribute<T>\n----------\n3. ERROR in Test.java (at line 5)\n\taddAttribute(attribute, attribute.getDefault());\n\t^^^^^^^^^^^^\nThe method addAttribute(Test.Attribute<T>, T) in the type Test is not applicable for the arguments (Test.Attribute<capture#3-of ?>, capture#4-of ?)\n----------\n");
    }

    public void testBug426366() {
        this.runConformTest(new String[]{"a/Test.java", "package a;\n\nimport java.util.Collections;\nimport java.util.List;\n\n/**\n * @author tomschindl\n *\n */\npublic class Test {\n\tpublic static class A {\n\t\tpublic A(B newSelectedObject, String editorController) {\n\t    }\n\n\t    public A(List<B> newSelectedObjects, String editorController) {\n\t    }\n\t}\n\t\n\tpublic static class B {\n\t\t\n\t}\n\t\n\tpublic static class C extends A {\n\t\tpublic C() {\n\t\t\tsuper(Collections.emptyList(), \"\");\n\t\t}\n\t}\n}\n"});
    }

    public void testBug426290() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n    public static void main(String argv[]) {\n       goo(foo());\n    }\n\n    static <T extends Number> List<T> foo() {\n        return new ArrayList<T>();\n    }\n\n    static void goo(Object p1) {\n        System.out.println(\"goo(Object)\");\n    }\n\n    static void goo(List<Integer> p1) {\n        System.out.println(\"goo(List<Integer>)\");\n    }\n}\n"}, "goo(List<Integer>)");
    }

    public void testBug425152() {
        this.runConformTest(new String[]{"packDown/SorterNew.java", "package packDown;\n\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\n\npublic class SorterNew {\n\tvoid sort() {\n\t\tCollections.sort(new ArrayList<Person>(),\n\t\t\t\tComparator.comparing((Person p) -> p.getName()));\n\t}\n}\n\nclass Person {\n\tpublic String getName() {\n\t\treturn \"p\";\n\t}\n}\n"});
    }

    public void testBug426048() {
        this.runNegativeTest(new String[]{"MyFunction.java", "import java.lang.annotation.Annotation;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Throws {\n  Class<? extends Throwable>[] value() default Throwable.class;\n  Returns method() default @Returns(Annotation.class);\n}\n\n@Target(ElementType.TYPE_USE)\n@interface Returns {\n  Class<? extends Annotation> value() default Annotation.class;\n}\n\n@FunctionalInterface public interface MyFunction<T, @Returns R> {\n  @Returns  R apply(T t);\n\n  default <V> @Throws(((MyFunction<? super V, ? extends T>) before::apply) @Returns MyFunction<V, @Returns R>\n    compose(MyFunction<? super V, ? extends T> before) {\n\n    return (V v) -> apply(before.apply(v));\n  }\n}\n"}, "----------\n1. ERROR in MyFunction.java (at line 19)\n\tdefault <V> @Throws(((MyFunction<? super V, ? extends T>) before::apply) @Returns MyFunction<V, @Returns R>\n\t          ^\nSyntax error, insert \"Type Identifier (\" to complete MethodHeaderName\n----------\n2. ERROR in MyFunction.java (at line 19)\n\tdefault <V> @Throws(((MyFunction<? super V, ? extends T>) before::apply) @Returns MyFunction<V, @Returns R>\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from MyFunction<capture#1-of ? super V,capture#2-of ? extends T> to Class<? extends Throwable>[]\n----------\n3. ERROR in MyFunction.java (at line 19)\n\tdefault <V> @Throws(((MyFunction<? super V, ? extends T>) before::apply) @Returns MyFunction<V, @Returns R>\n\t                                                          ^^^^^^\nbefore cannot be resolved\n----------\n4. ERROR in MyFunction.java (at line 19)\n\tdefault <V> @Throws(((MyFunction<? super V, ? extends T>) before::apply) @Returns MyFunction<V, @Returns R>\n\t                                                                       ^\nSyntax error, insert \")\" to complete Modifiers\n----------\n5. ERROR in MyFunction.java (at line 20)\n\tcompose(MyFunction<? super V, ? extends T> before) {\n\t       ^\nSyntax error on token \"(\", , expected\n----------\n");
    }

    public void testBug426540() {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.Stream;\nimport java.util.Collections;\nimport static java.util.stream.Collectors.collectingAndThen;\nimport static java.util.stream.Collectors.toList;\npublic class X {\n\tObject o = ((Stream<Integer>) null).collect(collectingAndThen(toList(), Collections::unmodifiableList));\n}\n"});
    }

    public void testBug426671_ok() {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.Stream;\nimport java.util.*;\nimport static java.util.stream.Collectors.collectingAndThen;\nimport static java.util.stream.Collectors.toList;\npublic class X {\n\tvoid test(Stream<List<Integer>> stream) {\n\t\tstream.collect(collectingAndThen(toList(), Collections::<List<Integer>>unmodifiableList))\n\t\t\t.remove(0);\n\t}\n}\n"});
    }

    public void testBug426671_medium() {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.Stream;\nimport java.util.*;\nimport static java.util.stream.Collectors.collectingAndThen;\nimport static java.util.stream.Collectors.toList;\npublic class X {\n\tvoid test(Stream<List<Integer>> stream) {\n\t\tstream.collect(collectingAndThen(toList(), Collections::unmodifiableList))\n\t\t\t.remove(0);\n\t}\n}\n"});
    }

    public void testBug426671_full() {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.Stream;\nimport java.util.*;\nimport static java.util.stream.Collectors.collectingAndThen;\nimport static java.util.stream.Collectors.toList;\npublic class X {\n\tvoid test() {\n\t\tArrays.asList((List<Integer>) null).stream().collect(collectingAndThen(toList(), Collections::unmodifiableList))\n\t\t\t.remove(0);\n\t}\n}\n"});
    }

    public void testBug426671b() {
        this.runNegativeTest(new String[]{"Test.java", "interface I<X,Y> {\n\tY fun(X y);\n}\npublic class Test {\n\tstatic <S> S id(S s) { return s; }\n\tvoid test() {\n        m1(Test::id, \"Hi\");\n        m2(Test::id, \"Hi\").toUpperCase();\n        m3(Test::id, \"Hi\").toUpperCase();\n   }\n\n\t<U,V> void m1(I<V,U> i, U u) { }\n\t<U,V> V m2(I<V,U> i, U u) {\n\t\treturn null;\n\t}\n\t<U,V> V m3(I<U,V> i, U u) {\n\t\treturn null;\n\t}\n}"}, "----------\n1. ERROR in Test.java (at line 8)\n\tm2(Test::id, \"Hi\").toUpperCase();\n\t                   ^^^^^^^^^^^\nThe method toUpperCase() is undefined for the type Object\n----------\n");
    }

    public void testBug426652() {
        this.runConformTest(new String[]{"X.java", "import static java.util.stream.Collectors.toList;\npublic class X {\n\tObject o = toList();\n}\n"});
    }

    public void testBug426778() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid test(List<CourseProviderEmploymentStatistics> result) {\n          Collections.sort( result, \n              Comparator.comparingInt(\n                  (CourseProviderEmploymentStatistics stat) ->  stat.doneTrainingsTotal\n\t\t\t\t)\n              .reversed()\n              .thenComparing(\n                  (CourseProviderEmploymentStatistics stat) -> stat.courseProviderName ) );\n\t}\n}\nclass CourseProviderEmploymentStatistics {\n   int doneTrainingsTotal;\n   String courseProviderName;\n}\n"});
    }

    public void testBug426676() {
        this.runConformTest(new String[]{"Test.java", "import java.util.Arrays;\nimport java.util.function.Supplier;\nimport java.util.stream.Stream;\n\n\npublic class Test {\n    public static void main(String[] args) throws Exception {\n        // Type inference works on map call.\n        Stream<String> s1 =\n        Arrays.stream(new Integer[] { 1, 2 })\n              .map(i -> i.toString());\n        \n        // Type inference doesn't work on map call.\n        Stream<String> s2 =\n        Arrays.stream(new Integer[] { 1, 2 })\n              .map(i -> i.toString())\n              .distinct();\n    }\n}\n"});
    }

    public void testBug424591_comment20() {
        this.runConformTest(new String[]{"MyList.java", "import java.util.Arrays;\npublic class MyList {\n    protected Object[] elements;\n    private int size;\n    @SuppressWarnings(\"unchecked\")\n    public <A> A[] toArray(A[] a) {\n        return (A[]) Arrays.copyOf(elements, size, a.getClass());\n    }\n}\n"});
    }

    public void testBug424591_comment20_variant() {
        this.runNegativeTest(new String[]{"MyList.java", "import java.util.Arrays;\npublic class MyList {\n    protected Object[] elements;\n    private int size;\n    @SuppressWarnings(\"unchecked\")\n    public <A> A[] toArray(A[] a) {\n        return (A[]) Arrays.copyOf(elements, size, getClass());\n    }\n}\n"}, "----------\n1. ERROR in MyList.java (at line 7)\n\treturn (A[]) Arrays.copyOf(elements, size, getClass());\n\t                    ^^^^^^\nThe method copyOf(U[], int, Class<? extends T[]>) in the type Arrays is not applicable for the arguments (Object[], int, Class<capture#1-of ? extends MyList>)\n----------\n");
    }

    public void testBug424591_comment22() {
        this.runConformTest(new String[]{"Test.java", "import java.util.*;\npublic class Test {\n\tpublic static void main(String[] args) {\n        Test.forObject(new HashSet<>());\n\t}\n    public static Test forObject(Object o) {\n        return null;\n    }\n}\n"});
    }

    public void testBug425063() {
        this.runConformTest(new String[]{"ComparatorUse.java", "import java.util.Comparator;\npublic class ComparatorUse {\n   Comparator<String> c =\n           Comparator.comparing((String s)->s.toString())\n           .thenComparing(s -> s.length());\n}\n"});
    }

    public void testBug426764() {
        this.runConformTest(new String[]{"X.java", "interface I {}\nclass C1 implements I {}\nclass C2 implements I {}\npublic class X  {\n    <T > void foo(T p1, I p2) {}\n    <T extends I> void foo(T p1, I p2) {}\n    void bar() {\n        foo(true ? new C1(): new C2(), false ? new C2(): new C1());\n        foo(new C1(), false ? new C2(): new C1());\n    }\n}\n"});
    }

    public void testBug424930a() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayDeque;\nimport java.util.Deque;\nimport java.util.function.Supplier;\n\npublic class X<S, T extends Deque<S>> {\n    private final Supplier<T> supplier;\n\n    public X(Supplier<T> supplier) {\n        this.supplier = supplier;\n    }\n    \n\t int dequeCapacity;\n    public static <S> X<S, Deque<S>> newDefaultMap() {\n        return new X<>(() -> new ArrayDeque<>(13));\n    }\n}\n"});
    }

    public void testBug424930b() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayDeque;\nimport java.util.Deque;\nimport java.util.function.Supplier;\n\npublic class X<S, T extends Deque<S>> {\n    private final Supplier<T> supplier;\n\n    public X(Supplier<T> supplier) {\n        this.supplier = supplier;\n    }\n    \n    public static <S> X<S, Deque<S>> newDefaultMap(int dequeCapacity) {\n        return new X<>(() -> new ArrayDeque<>(dequeCapacity));\n    }\n}\n"});
    }

    public void testBug424930c() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayDeque;\nimport java.util.Deque;\nimport java.util.function.Supplier;\n\npublic class X<S, T extends Deque<S>> {\n    private final Supplier<T> supplier;\n\n    public X(Supplier<T> supplier) {\n        this.supplier = supplier;\n    }\n    \n\t int dequeCapacity;\n    public static <S> X<S, Deque<S>> newDefaultMap() {\n        return new X<>(() -> new ArrayDeque<>(dequeCapacity));\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\treturn new X<>(() -> new ArrayDeque<>(dequeCapacity));\n\t                                      ^^^^^^^^^^^^^\nCannot make a static reference to the non-static field dequeCapacity\n----------\n");
    }

    public void testBug426998a() {
        this.runConformTest(new String[]{"Snippet.java", "public class Snippet {\n\tstatic void call(Class type, long init) {\n\t\tString string = new String();\n\t\tmethod(type, init == 0 ? new String() : string);\n\t}\n\tprivate static void method(Class type, String s) {}\n}\n"});
    }

    public void testBug426998b() {
        this.runConformTest(new String[]{"Snippet.java", "public class Snippet {\n  private static final String PLACEHOLDER_MEMORY = new String();\n\n  static void newInstance(Class type, long init) {\n    method(type, init == 0 ? new String() : PLACEHOLDER_MEMORY);\n  }\n\n  private static void method(Class type, String str) {}\n}\n"});
    }

    public void testBug427164() {
        this.runNegativeTest(new String[]{"NNLambda.java", "import java.util.*;\n\n@FunctionalInterface\ninterface FInter {\n\tString allToString(List<String> input);\n}\n\npublic abstract class NNLambda {\n\tabstract <INP> void printem(FInter conv, INP single);\n\t\n\tvoid test() {\n\t\tprintem((i) -> {\n\t\t\t\tCollections.<String>singletonList(\"const\")\n\t\t\t}, \n\t\t\t\"single\");\n\t}\n}\n"}, "----------\n1. ERROR in NNLambda.java (at line 1)\n\tprintem((i) -> {\n\t^^^^^^^\nThe method printem(FInter, INP) in the type NNLambda is not applicable for the arguments (FInter, String)\n----------\n2. ERROR in NNLambda.java (at line 13)\n\tCollections.<String>singletonList(\"const\")\n\t                                         ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n", true);
    }

    public void testBug427168() {
        this.runNegativeTest(new String[]{"X.java", "interface Producer<T> {\n\t<P> P produce();\n}\npublic class X {\n\t<T> void perform(Producer<T> r) { }\n\tvoid test() {\n\t\tperform(() -> 13); \n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tperform(() -> 13); \n\t^^^^^^^\nThe method perform(Producer<T>) in the type X is not applicable for the arguments (() -> {})\n----------\n2. ERROR in X.java (at line 7)\n\tperform(() -> 13); \n\t        ^^^^^^^^\nIllegal lambda expression: Method produce of type Producer<T> is generic \n----------\n");
    }

    public void testBug427196() {
        this.runConformTest(new String[]{"MainTest.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\nimport java.util.function.Function;\n\npublic class MainTest {\n    public static <T> List<T> copyOf (Collection<T> c) {\n        return new ArrayList<>(c);\n    }\n    \n    public static <T> List<T> copyOf (Iterable<T> c) {\n        return new ArrayList<>();\n    }\n    \n    public static void main (String[] args) {\n        Function<Collection<String>, List<String>> function1 = c -> MainTest.copyOf(c); //OK\n        Function<Collection<String>, List<String>> function2 = MainTest::copyOf;        //error\n    }\n}\n"});
    }

    public void testBug427224() {
        this.runConformTest(new String[]{"Test2.java", "import java.util.*;\npublic class Test2 {\n    public static native <T> T applyToSet(java.util.Set<String> s);\n\n    public static void applyToList(java.util.List<String> s) {\n        applyToSet(new java.util.HashSet<>(s));\n    }\n}\n"});
    }

    public void testBug424637() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString foo(X x, String s2);\n}\n\npublic class X {\n\tString goo(String ...ts) {\n\t\tSystem.out.println(ts[0]);  \n\t\treturn ts[0];\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::goo;\n\t\tString s = i.foo(new X(), \"world\");\n\t\tSystem.out.println(s);     \n\t}\n}\n"}, "world\nworld", options);
    }

    public void test427218_reduced() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n      match(getLast(\"a\"), null);\n   }\n   public static <T> T getLast(T... array) { return null; } // same with T[]\n   public static void match(boolean b, Object foo) { }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tmatch(getLast(\"a\"), null);\n\t^^^^^\nThe method match(boolean, Object) in the type X is not applicable for the arguments (String, null)\n----------\n2. ERROR in X.java (at line 3)\n\tmatch(getLast(\"a\"), null);\n\t      ^^^^^^^^^^^^\nType mismatch: cannot convert from String to boolean\n----------\n3. WARNING in X.java (at line 5)\n\tpublic static <T> T getLast(T... array) { return null; } // same with T[]\n\t                                 ^^^^^\nType safety: Potential heap pollution via varargs parameter array\n----------\n");
    }

    public void test427218() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n      match(getLast(\"a\"), null);\n   }\n   public static <T> T getLast(T... array) { return null; } // same with T[]\n   public static void match(boolean b, Object foo) { }\n   public static <A> void match(Object o, A foo) { }\n}\n"}, "");
    }

    public void testBug427223() {
        this.runConformTest(new String[]{"Test.java", "import java.util.*;\npublic class Test {\n\n\tList<Object> toList(Object o) {\n\t\tif (o instanceof Optional) {\n\t\t\treturn Arrays.asList(((Optional<?>) o).orElse(null));\n\t\t} else {\n\t\t\treturn null;\n\t\t}\n\t}\n\n}\n"});
    }

    public void testBug425183_comment8() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String... args) {\n        java.util.Comparator.reverseOrder().thenComparingLong(X::toLong);\n        System.out.println(\"ok\");\n    }\n    static <T> long toLong(T in) { return 0L; }\n}\n"}, "ok");
    }

    public void testBug427483() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tvoid test() {\n\t\tnew TreeSet<>((String qn1, String qn2) -> {\n   \t\tboolean b = true;\n\t\t\tSystem.out.println(b); // ok\n   \t\tif(b) { }\n\t   \t\treturn qn1.compareTo(qn2);\n\t\t});\n\t}\n}\n"});
    }

    public void testBug427504() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\n\tpublic static <T> Tree<T> model(T o) {\n\t\treturn Node(Leaf(o), Leaf(o));\n\t}\n\t\n\tinterface Tree<T> {}\n\tstatic <T> Tree<T> Node(Tree<T>... children) { return null; }\n\tstatic <T> Tree<T> Leaf(T o) { return null; }\n\t\n}\n"});
    }

    public void testBug427479() {
        this.runConformTest(new String[]{"Bug.java", "import java.util.*;\nimport java.util.function.BinaryOperator; \nimport java.util.stream.*;\n\npublic class Bug {\n \n\tstatic List<String> names = Arrays.asList(\n\t\t\t\"ddd\",\n\t\t\t\"s\",\n\t\t\t\"sdfs\",\n\t\t\t\"sfdf d\"); \n \n\tpublic static void main(String[] args) {\n\t\t\t BinaryOperator<List<String>> merge = (List<String> first, List<String> second) -> {\n\t\t\t\t first.addAll(second);\n\t\t\t\t return first;\n\t\t\t\t };\n\t\t\t\t \n\t\t\tCollector<String,?,Map<Integer,List<String>>> collector= Collectors.toMap(\n\t\t\t\t\ts -> s.length(), \n\t\t\t\t\tArrays::asList,\n\t\t\t\t\tmerge); \n\t\t\tMap<Integer, List<String>> lengthToStrings = names.stream().collect(collector);\n\t\t\t\n\t\t\tlengthToStrings.forEach((Integer i, List<String> l)-> {\n\t\t\t\tSystem.out.println(i + \" : \" + Arrays.deepToString(l.toArray()));\n\t\t\t});\n\n\t}\n\n}\n"});
    }

    public void testBug427479b() {
        this.runNegativeTest(new String[]{"Bug419048.java", "import java.util.List;\nimport java.util.Map;\nimport java.util.stream.Collectors;\n\n\npublic class Bug419048 {\n\tvoid test1(List<Object> roster) {\n        Map<String, Object> map = \n                roster\n                    .stream()\n                    .collect(\n                        Collectors.toMap(\n                            p -> p.getLast(),\n                            p -> p.getLast()\n                        ));\n\t}\n}\n"}, "----------\n1. ERROR in Bug419048.java (at line 9)\n\troster\n                    .stream()\n                    .collect(\n                        Collectors.toMap(\n                            p -> p.getLast(),\n                            p -> p.getLast()\n                        ));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Map<Object,Object> to Map<String,Object>\n----------\n2. ERROR in Bug419048.java (at line 13)\n\tp -> p.getLast(),\n\t       ^^^^^^^\nThe method getLast() is undefined for the type Object\n----------\n3. ERROR in Bug419048.java (at line 14)\n\tp -> p.getLast()\n\t       ^^^^^^^\nThe method getLast() is undefined for the type Object\n----------\n");
    }

    public void testBug427626() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\n\npublic class X {\n\tvoid m() {\n        List<String> ss = Arrays.asList(\"1\", \"2\", \"3\");\n        \n        ss.stream().map(s -> {\n          class L1 {};\n          class L2 {\n            void mm(L1 l) {}\n          }\n          return new L2().mm(new L1());\n        }).forEach(e -> System.out.println(e));\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tss.stream().map(s -> {\n          class L1 {};\n          class L2 {\n            void mm(L1 l) {}\n          }\n          return new L2().mm(new L1());\n        }).forEach(e -> System.out.println(e));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot infer type argument(s) for <R> map(Function<? super T,? extends R>)\n----------\n2. ERROR in X.java (at line 13)\n\treturn new L2().mm(new L1());\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot return a void result\n----------\n");
    }

    public void testBug426542() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n\t\n\t<T extends Comparable & Serializable> void foo(T o1) {\n\t}\n\n\t<T extends Serializable> void foo(T o1) {\n\t}\n\n\tvoid bar() {\n\t\tfoo((Comparable & Serializable)0);\n\t\tfoo(0);\n\t}\n}\n"});
    }

    public void testBug426836() {
        this.runConformTest(new String[]{"ReferenceToGetClass.java", "import java.util.function.Supplier;\n\n\npublic class ReferenceToGetClass {\n\t<T> T extract(Supplier<T> s) {\n\t\treturn s.get();\n\t}\n\tClass<?> test() {\n\t\tClass<? extends ReferenceToGetClass> c = extract(this::getClass);\n\t\treturn c;\n\t}\n}\n"});
    }

    public void testBug428019() {
        this.runConformTest(new String[]{"X.java", "final public class X {\n  static class Obj {}\n  static class Dial<T> {}\n\n  <T> void put(Class<T> clazz, T data) {\n  }\n\n  static <T> Dial<T> wrap(Dial<T> dl) {\n\t  return null;\n  }\n\n  static void foo(Dial<? super Obj> dial, X context) {\n    context.put(Dial.class, wrap(dial));\n  }\n  \n  public static void main(String[] args) {\n\tX.foo(new Dial<Obj>(), new X());\n  }\n}\n"});
    }

    public void testBug428198() {
        this.runConformTest(new String[]{"Snippet.java", "import java.util.*;\ninterface BundleRevision {}\ninterface BundleDescription extends BundleRevision {}\npublic class Snippet {\n  static Collection<BundleRevision> test(BundleDescription[] triggers) {\n    @SuppressWarnings(\"unchecked\")\n    Collection<BundleRevision> triggerRevisions =\n    //Type mismatch: cannot convert from Collection<Object> to Collection<BundleRevision>\n      Collections\n        .unmodifiableCollection(triggers == null ? Collections.EMPTY_LIST\n        : Arrays.asList((BundleRevision[]) triggers));\n    return triggerRevisions;\n  }\n}\n"});
    }

    public void testBug428198b() {
        this.runConformTest(new String[]{"Snippet.java", "import java.util.*;\ninterface BundleRevision {}\ninterface BundleDescription extends BundleRevision {}\npublic class Snippet {\n  static Collection<BundleRevision> test(BundleDescription[] triggers) {\n    @SuppressWarnings(\"unchecked\")\n    Collection<BundleRevision> triggerRevisions =\n      Collections\n        .unmodifiableCollection(triggers == null ? Collections.emptyList()\n        : Arrays.asList((BundleRevision[]) triggers));\n    return triggerRevisions;\n  }\n}\n"});
    }

    public void testBug428264() {
        this.runConformTest(new String[]{"Y.java", "import java.util.function.*;\nimport java.util.Optional;\n\ninterface I<E,F> {}\nclass A<G> implements I<G, Optional<G>> {}\n\npublic class Y<S,T> {\n    Y(T o, Predicate<T> p, Supplier<I<S,T>> s) {}\n\n    static <Z> Y<Z, Optional<Z>> m() {\n        return new Y<>(Optional.empty(), Optional::isPresent, A::new);\n    }\n}\n"});
    }

    public void testBug428294() {
        this.runConformTest(new String[]{"Junk5.java", "import java.util.Collection;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\n\npublic class Junk5 {\n\n    class TestTouchDevice {\n        public Object [] points;\n    }\n    \n    public static List<TestTouchDevice> getTouchDevices() {\n        return null;\n    }\n\n    public static Collection<Object[]> getTouchDeviceParameters2(int minPoints) {\n        Collection c = getTouchDevices().stream()\n                .filter(d -> d.points.length >= minPoints)\n                .map(d -> new Object[] { d })\n                .collect(Collectors.toList());\n         return c;\n    }\n    \n    public static Collection<Object[]> getTouchDeviceParameters3(int minPoints) {\n        return getTouchDevices().stream()\n                .filter(d -> d.points.length >= minPoints)\n                .map(d -> new Object[] { d })\n                .collect(Collectors.toList());\n    }\n}\n"});
    }

    public void testBug428291() {
        this.runConformTest(new String[]{"AC3.java", "import java.util.List;\n\ninterface I0<T> { }\n\ninterface I1 { }\ninterface I1List<E> extends List<E>, I1 {}\ninterface I2<T> extends I1 {\n\tvoid foo(I0<? super T> arg1);\n\tvoid bar(I0<? super T> arg2);\n}\ninterface I3<T> extends I2<T> {}\ninterface I4<T> extends I2<T> { }\ninterface I3List<E> extends I3<I1List<E>>, I1List<E> {}\nabstract class AC1<E> implements I3List<E> { }\n\nabstract class AC2<E>  {\n    public static <E> AC2<E> bork(AC2<E> f1, I3List<E> i3l, I0<? super I1List<E>> i1l) {\n        return null;\n    }\n    public static <E> AC2<E> garp(AC2<E> f2, I0<? super I1List<E>> i1l) {\n        return null;\n    }\n}\n\npublic abstract class AC3<E> extends AC1<E> implements I4<I1List<E>> {\n\n    AC2<E> f = null;\n\n    @Override\n    public void foo(I0<? super I1List<E>> arg1) {\n        f = AC2.bork(f, this, arg1);\n    }\n\n    @Override\n    public void bar(I0<? super I1List<E>> arg2) {\n        f = AC2.garp(f, arg2);\n    }\n}\n"});
    }

    public void testBug428275() {
        this.runConformTest(new String[]{"p1/C1.java", "package p1;\n\nimport java.util.List;\n\npublic class C1<T1> {\n\n\tpublic static class CInner<T2A,T2B> {\n\t\tpublic CInner(T2A a, T2B b) {}\n\t}\n\t\n\tpublic static class CInner2<T3A,T3B> {\n\t\tpublic CInner2(String n, List<CInner<T3A,T3B>> arg) {}\n\t}\n\t\n    public static <E> List<E> getList1(E... items) {\n    \treturn null;\n    }\n}\n", "Test.java", "import java.util.List;\n\nimport p1.C1;\n\npublic class Test {\n\tvoid test2(List<C1.CInner2> l) {\n\t\tl.add(\n\t\t\tnew C1.CInner2<>(\"a\",\n\t\t\t\tC1.getList1(new C1.CInner<>(\"b\", 13))\n\t\t\t)\n\t\t);\n\t}\n}\n"});
    }

    public void test428352() {
        this.runNegativeTest(new String[]{"OperationsPile.java", "import java.util.Collection;\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\nclass OperationsPile<B> {\n  OperationsPile(Function<B, ?> handler) {}\n\n  private static <T> void addAll3(Collection<T> c, T t) {}\n\n  static <S> void adaad3(List<OperationsPile<?>> combined, Consumer<S> handler) {\n    addAll3(combined, new OperationsPile<>(null));\n    addAll3(combined, new OperationsPile<>(handler));\n  }\n}\n"}, "----------\n1. ERROR in OperationsPile.java (at line 13)\n\taddAll3(combined, new OperationsPile<>(handler));\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot infer type arguments for OperationsPile<>\n----------\n");
    }

    public void test428352b() {
        this.runConformTest(new String[]{"OperationsPile.java", "import java.util.Collection;\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class OperationsPile<B> {\n  OperationsPile(Function<B, ?> handler) {}\n\n  private static <T> void addAll3(Collection<T> c, T t) {}\n\n  static <S> void adaad3(List<OperationsPile<?>> combined, Consumer<S> handler) {\n    addAll3(combined, new OperationsPile<>(null));\n  }\n\tpublic static void main(String[] args) {\n\t\tadaad3(null, null);\n\t\tSystem.out.println(13);\n\t}\n}\n"}, "13");
    }

    public void testBug428307() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.function.Function;\nimport java.util.stream.*;\n\ninterface Bar {\n\tClass<? extends Bar> type();\n}\npublic class X {\n \n    <T extends Bar> T[] test(Class<T> barClass, Stream<Bar> bars) {\n        return get(bars.\n                    collect(Collectors.toMap(Bar::type,\n                                             Function.identity(),\n                                             ((first,second) -> first),\n                                             HashMap::new)),\n                            barClass);\n    }\n    \n    <A extends Bar> A[] get(Map<Class<? extends Bar>,Bar> m, Class<A> c) {\n    \treturn null;\n    }\n}\n"});
    }

    public void test428524() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSupplier<WithNoArgConstructor> works = WithNoArgConstructor::new;\n\t\tSystem.out.println(works.get());\n\t\tSupplier<WithoutNoArgConstructor> error = WithoutNoArgConstructor::new;\n\t\tSystem.out.println(error.get());\n\t\t\n\t}\n\tprivate static class WithNoArgConstructor {\n\t\tpublic WithNoArgConstructor() {\n\t\t}\n       public String toString() {\n           return(\"WithNoArgConstructor\");\n       }\n\t}\n\tprivate static class WithoutNoArgConstructor {\n       public String toString() {\n           return(\"WithOutNoArgConstructor\");\n       }\n\t}\n}\n"}, "WithNoArgConstructor\nWithOutNoArgConstructor");
    }

    public void testBug428786() {
        this.runConformTest(new String[]{"Junk9.java", "import java.util.*;\npublic class Junk9 {\n    class Node {\n        public double getLayoutY() {return 12;}\n    }\n    class Node2 extends Node {\n    }\n    void junk() {\n        List<Node2> visibleCells = new ArrayList<>(20);\n        Collections.sort(visibleCells, (Node o1, Node o2) -> Double.compare(o1.getLayoutY(), o2.getLayoutY()));\n    }\n}\n"});
    }

    public void testBug429090_comment1() {
        this.runNegativeTest(new String[]{"Junk10.java", "\npublic class Junk10 {\n    class Observable<T> {}\n    interface InvalidationListener {\n        public void invalidated(Observable<?> observable);\n    }\n    public static abstract class Change<E2> {}\n    interface SetChangeListener<E1> {\n        void onChanged(Change<? extends E1> change);\n    }\n    class SetListenerHelper<T> {}\n    public static <E> SetListenerHelper<E> addListener(\n\t\t\tSetListenerHelper<E> helper, SetChangeListener<? super E> listener) {\n        return helper;\n    }\n    void junk() {\n        addListener(null, (SetChangeListener.Change<?> c) -> {});\n    }\n}\n"}, "----------\n1. ERROR in Junk10.java (at line 17)\n\taddListener(null, (SetChangeListener.Change<?> c) -> {});\n\t^^^^^^^^^^^\nThe method addListener(Junk10.SetListenerHelper<E>, Junk10.SetChangeListener<? super E>) in the type Junk10 is not applicable for the arguments (null, (SetChangeListener.Change<?> c) -> {})\n----------\n2. ERROR in Junk10.java (at line 17)\n\taddListener(null, (SetChangeListener.Change<?> c) -> {});\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^\nSetChangeListener.Change cannot be resolved to a type\n----------\n");
    }

    public void testBug429090() {
        this.runConformTest(new String[]{"Junk10.java", "public class Junk10 {\n    class Observable<T> {}\n    interface InvalidationListener {\n        public void invalidated(Observable observable);\n    }\n    interface SetChangeListener<E> {\n        public static abstract class Change<E> {}\n        void onChanged(Change<? extends E> change);\n    }\n    class SetListenerHelper<T> {}\n    public static <E> SetListenerHelper<E> addListener(SetListenerHelper<E> helper, InvalidationListener listener) {\n        return helper;\n    }\n    public static <E> SetListenerHelper<E> addListener(SetListenerHelper<E> helper, SetChangeListener<? super E> listener) {\n        return helper;\n    }\n    void junk() {\n        addListener(null, new SetChangeListener () {\n            public void onChanged(SetChangeListener.Change change) {}\n        });\n        addListener(null, (SetChangeListener.Change<? extends Object> c) -> {});\n    }\n}\n"});
    }

    public void testBug429490_comment33() {
        this.runConformTest(new String[]{"Junk12.java", "public class Junk12 {\n    class Observable<T> {}\n    class ObservableValue<T> {}\n    interface InvalidationListener {\n        public void invalidated(Observable observable);\n    }\n    public interface ChangeListener<T> {\n        void changed(ObservableValue<? extends T> observable, T oldValue, T newValue);\n    }\n    class ExpressionHelper<T> {}\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, InvalidationListener listener) {\n        return helper;\n    }\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, ChangeListener<? super T> listener) {\n        return helper;\n    }\n    void junk() {\n        addListener(null, null, new ChangeListener () {\n            public void changed(ObservableValue observable, Object oldValue, Object newValue) {\n                throw new RuntimeException();\n            }\n        });\n        addListener(null, null, (value, o1, o2) -> {throw new RuntimeException();});\n    }\n}\n"});
    }

    public void testBug428811() {
        this.runConformTest(new String[]{"MoreCollectors.java", "import java.util.AbstractList;\nimport java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.Collection;\nimport java.util.List;\nimport java.util.stream.Collector;\n\npublic class MoreCollectors {\n    public static void main (String[] args) {\n        ImmutableList<String> list = Arrays.asList(\"a\", \"b\", \"c\").stream().collect(toImmutableList());\n        \n        System.out.println(list);\n    }\n    \n    public static <T> Collector<T, ?, ImmutableList<T>> toImmutableList () {\n        return Collector.of(ArrayList<T>::new,\n                List<T>::add,\n                (left, right) -> { left.addAll(right); return left; },\n                ImmutableList::copyOf);\n    }\n    \n    private static class ImmutableList<T> extends AbstractList<T> {\n        public static <T> ImmutableList<T> copyOf (Collection<T> c) {\n            return new ImmutableList<>(c.toArray());\n        }\n\n        private Object[] array;\n        \n        private ImmutableList (Object[] array) {\n            this.array = array;\n        }\n\n        @Override @SuppressWarnings(\"unchecked\")\n        public T get(int index) {\n            return (T)array[index];\n        }\n\n        @Override\n        public int size() {\n            return array.length;\n        }\n    }\n}\n"}, "[a, b, c]");
    }

    public void testBug429430() {
        this.runConformTest(new String[]{"Main.java", "import java.io.*;\npublic class Main {\n  public static interface Closer<T, X extends Exception> {\n    void closeIt(T it) throws X;\n  }\n\n  public static <T, X extends Exception> void close( Closer<T, X> closer, T it ) throws X {\n    closer.closeIt(it);\n  }\n\n  public static void main(String[] args) throws IOException {\n    InputStream in = new ByteArrayInputStream(\"hello\".getBytes());\n    close( x -> x.close(), in );\n    close( InputStream::close, in );\n    close( (Closer<InputStream, IOException>)InputStream::close, in );\n  }\n}\n"});
    }

    public void testBug429430a() {
        this.runNegativeTest(new String[]{"Main.java", "import java.io.*;\n@SuppressWarnings(\"serial\") class EmptyStream extends Exception {}\npublic class Main {\n  public static interface Closer<T, X extends Exception> {\n    void closeIt(T it) throws X;\n  }\n\n  public static <T, X extends Exception> void close( Closer<T, X> closer, T it ) throws X {\n    closer.closeIt(it);\n  }\n\n  public static void main(String[] args) throws IOException, EmptyStream {\n    InputStream in = new ByteArrayInputStream(\"hello\".getBytes());\n    close( x ->  { if (in.available() == 0) throw new EmptyStream(); x.close(); }, in );\n  }\n}\n"}, "----------\n1. ERROR in Main.java (at line 14)\n\tclose( x ->  { if (in.available() == 0) throw new EmptyStream(); x.close(); }, in );\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type Exception\n----------\n");
    }

    public void testBug429430b() {
        this.runConformTest(new String[]{"Main.java", "import java.io.*;\n@SuppressWarnings(\"serial\") class EmptyStream extends Exception {}\npublic class Main {\n  public static interface Closer<T, X extends Exception> {\n    void closeIt(T it) throws X;\n  }\n\n  public static <T, X extends Exception> void close( Closer<T, X> closer, T it ) throws X {\n    closer.closeIt(it);\n  }\n\n  public static void main(String[] args) throws EmptyStream {\n    InputStream in = new ByteArrayInputStream(\"hello\".getBytes());\n    close( x ->  {\n\t\t\ttry {\n\t\t\t\tx.close();\n\t\t\t} catch (IOException ioex) { throw new EmptyStream(); } \n\t\t},\t\tin);\n  }\n}\n"});
    }

    public void testBug429430b2() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n@SuppressWarnings(\"serial\") class EmptyStream extends Exception {}\npublic class X {\n  public static interface Closer<T, V extends Exception> {\n    void closeIt(T it) throws V;\n  }\n\n  public static void close( Closer<InputStream, EmptyStream> closer, InputStream it ) throws EmptyStream {\n    closer.closeIt(it);\n  }\n\n  public static void main(String[] args) throws EmptyStream {\n    InputStream in = new ByteArrayInputStream(\"hello\".getBytes());\n    close( x ->  {\n\t\t\tif (x == null)\n\t\t\t\tthrow new IOException();\n\t\t\telse \n\t\t\t\tthrow new EmptyStream(); \n\t\t},\n\t\tin);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 16)\n\tthrow new IOException();\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nUnhandled exception type IOException\n----------\n2. WARNING in X.java (at line 18)\n\tthrow new EmptyStream(); \n\t^^^^^^^^^^^^^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n");
    }

    public void testBug429430c() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        this.runConformTest(new String[]{"Main.java", "import java.io.*;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE) @interface Severe {}\npublic class Main {\n  public static interface Closer<T, X extends Exception> {\n    void closeIt(T it) throws X;\n  }\n\n  public static <T, X extends Exception> void close( Closer<T, X> closer, T it ) throws X {\n    closer.closeIt(it);\n  }\n\n  static @Severe IOException getException() { return new IOException(\"severe\"); }\n  public static void main(String[] args) throws IOException {\n    InputStream in = new ByteArrayInputStream(\"hello\".getBytes());\n    close( x -> {\n\t\t\tif (in.available() > 0)\n\t\t\t\tx.close();\n\t\t\telse\n\t\t\t\tthrow getException();\n\t\t},\n\t\tin);\n  }\n}\n"}, options);
    }

    public void testBug429490() {
        this.runConformTest(new String[]{"Junk11.java", "public class Junk11 {\n    class Observable<T> {}\n    class ObservableValue<T> {}\n    interface InvalidationListener {\n        public void invalidated(Observable observable);\n    }\n    public interface ChangeListener<T> {\n        void changed(ObservableValue<? extends T> observable, T oldValue, T newValue);\n    }\n    class ExpressionHelper<T> {}\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, InvalidationListener listener) {\n        return helper;\n    }\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, ChangeListener<? super T> listener) {\n        return helper;\n    }\n    void junk() {\n        addListener(null, null, new InvalidationListener () {\n            public void invalidated(Observable o) {throw new RuntimeException();}\n        });\n        addListener(null, null, (o) -> {throw new RuntimeException();});\n    }\n}\n"});
    }

    public void testBug429424() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public static void main (String[] args) {\n        List<String> list = new ArrayList<>();\n        list.addAll(X.newArrayList());\n        System.out.println(list);\n    }\n    \n    public static <T> List<T> newArrayList () {\n        return new ArrayList<T>();\n    }\n}\n\n"});
    }

    public void testBug426537() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(J[] list, I<J<?>> i) {\n\t\tsort(list, i);\n\t}\n\t\n\t<T> T[] sort(T[] list, I<? super T> i) {\n\t\treturn list;\n\t}\n}\ninterface I<T> {}\ninterface J<T> {}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid foo(J[] list, I<J<?>> i) {\n\t         ^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tsort(list, i);\n\t^^^^\nThe method sort(T[], I<? super T>) in the type X is not applicable for the arguments (J[], I<J<?>>)\n----------\n");
    }

    public void testBug426537b() {
        this.runConformTest(new String[]{"Test.java", "interface C<T, A, R> {}\n\nclass MImpl<K, V> {}\n\ninterface S<T> { T get(); }\n\npublic class Test {\n\tstatic <T, K, D> C<T, ?, MImpl<K, D>> m1() {\n        return m2(MImpl::new);\n    }\n    \n    static <T, K, D, M extends MImpl<K, D>> C<T, ?, M> m2(S<M> s) {\n    \treturn null;\n    }\n}\n\n"});
    }

    public void testBug426537c() {
        this.runConformTest(new String[]{"Ups.java", "public class Ups {\n    static Object innocent(MImpl o) {\n            return o.remove(\"nice\");\n    }\n}\n", "Test.java", "interface S<T> { T get(); }\ninterface F<T, R> { R apply(T t); }\ninterface C<T, A, R> { }\ninterface IM<K,V> {}\nclass MImpl<K,V>  implements IM<K,V> { \n\tpublic V remove(Object key) { return null; } \n}\npublic final class Test {\n\n    static <T, K, A, D>\n    C<T, ?, IM<K, D>> m1(F<? super T, ? extends K> f, C<? super T, A, D> c) {\n        return m2(f, MImpl::new, c);\n    }\n\n    static <T, K, D, A, M extends IM<K, D>>\n    C<T, ?, M> m2(F<? super T, ? extends K> classifier,\n                                  S<M> mapFactory,\n                                  C<? super T, A, D> downstream) {\n    \treturn null;\n    }\n}\n"});
    }

    public void testBug429203() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError, new String[]{"DTest.java", "import java.util.function.Function;\n\n\npublic class DTest<T> {\n\tpublic DTest(Function<T, T> func) { }\n\t\n\tpublic DTest(DTest<Integer> dti) {}\n\tpublic DTest() {}\n\t\n\tpublic static void main(String[] args) {\n\t\tDTest<String> t1 = new DTest<String>(new DTest<Integer>());\n\t}\n}\n"}, "----------\n1. ERROR in DTest.java (at line 11)\n\tDTest<String> t1 = new DTest<String>(new DTest<Integer>());\n\t                       ^^^^^\nRedundant specification of type arguments <String>\n----------\n", null, true, customOptions);
    }

    public void testBug430296() {
        this.runNegativeTest(new String[]{"AnnotationCollector.java", "import java.lang.annotation.*;\nimport java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\n\npublic abstract class AnnotationCollector {\n        \n        Map<String, Person> test2(Stream<Person> persons) {\n                return persons.collect(Collectors.toMap((Person p) -> p.getLastName(),\n                                                                Function::identity,\n                                                        (p1, p2) -> p1));\n        }\n}\n\nclass Person {\n        String getLastName() { return \"\"; }\n}"}, "----------\n1. ERROR in AnnotationCollector.java (at line 9)\n\treturn persons.collect(Collectors.toMap((Person p) -> p.getLastName(),\n\t                                  ^^^^^\nThe method toMap(Function<? super T,? extends K>, Function<? super T,? extends U>, BinaryOperator<U>) in the type Collectors is not applicable for the arguments ((Person p) -> {}, Function::identity, BinaryOperator<U>)\n----------\n2. ERROR in AnnotationCollector.java (at line 9)\n\treturn persons.collect(Collectors.toMap((Person p) -> p.getLastName(),\n\t                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Function<Person,? extends K> to Function<? super T,? extends K>\n----------\n3. ERROR in AnnotationCollector.java (at line 10)\n\tFunction::identity,\n\t^^^^^^^^^^^^^^^^^^\nThe type Function does not define identity(T) that is applicable here\n----------\n");
    }

    public void testBug430759() {
        this.runConformTest(new String[]{"Test.java", "import java.beans.*;\nimport java.util.*;\nimport java.util.function.*;\n\npublic abstract class Test<T,R> implements Function<T,R> {\n\n  public static final <T,R> Test<T,R> getTest() {\n    return new Test<T,R>() {\n      protected final Map<T,ResultSupplier> results = Collections.synchronizedMap(new HashMap<T,ResultSupplier>());\n      @Override\n      public R apply(final T t) {\n        ResultSupplier result = results.get(t);\n        return result.get();\n      }\n      class ResultSupplier implements Supplier<R> {\n        @Override\n        public synchronized R get() {\n          return null;\n        }\n      }\n    };\n  }\n}\n"});
    }

    public void testBug431577() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.Function;\nimport java.util.function.IntFunction;\npublic class Test<R> {\n\tpublic static void main(String[] args) {\n\tnew Test<>().test((Integer i) -> null);\n\t}\n\t<T> void test(Function<T, R> f) {\n\t}\n\tvoid test(int i, IntFunction<R> f) {\n\t\tnew State<>(new Val<>(i));\n\t}\n\tstatic class State<R> {\n\t\tState(Val<?> o) {\n\t\t}\n\t}\n\tstatic class Val<T> {\n\t\tVal(T t) {}\n\t}\n}"});
    }

    public void testBug432110() {
        this.runConformTest(new String[]{"Bug.java", "import java.util.List;\nimport java.util.function.Function;\nimport java.util.stream.Stream;\n\nclass Bug\n{\n    // fully inline\n    // compiles successfully\n    Stream<? extends Integer> flatten1(\n        final Stream<List<Integer>> input)\n    {\n        return input.flatMap(item -> item.stream().map(value -> value));\n    }\n\n    // lambda using braces\n    // compiles with error in eclipse, successfully with javac\n    Stream<? extends Integer> flatten2(\n        final Stream<List<Integer>> input)\n    {\n        return input.flatMap(item -> {\n            return item.stream().map(value -> value);\n        });\n    }\n\n    // without map step\n    // compiles successfully\n    Stream<? extends Integer> flatten3(\n        final Stream<List<Integer>> input)\n    {\n        return input.flatMap(item -> {\n            return item.stream();\n        });\n    }\n\n    // with map step, but not inline\n    // compiles successfully\n    Stream<? extends Integer> flatten4(\n        final Stream<List<Integer>> input)\n    {\n        return input.flatMap(item -> {\n            final Function<? super Integer, ? extends Integer> mapper = value -> value;\n            return item.stream().map(mapper);\n        });\n    }\n\n    // with map step, but outer lambda is not inline\n    // compiles successfully\n    Stream<? extends Integer> flatten5(\n        final Stream<List<Integer>> input)\n    {\n        final Function<? super List<Integer>, ? extends Stream<? extends Integer>> func = item -> {\n            return item.stream().map(value -> value);\n        };\n        return input.flatMap(func);\n    }\n}\n"});
    }

    public void testBug433158() {
        this.runNegativeTest(new String[]{"CollectorsMaps.java", "\nimport java.util.List;\nimport java.util.Map;\nimport static java.util.stream.Collectors.*;\n\npublic class CollectorsMaps {/*Q*/\n\tprivate static class Pair<L, R> {\n\t\tpublic final L lhs; public final R rhs;\n\t\tpublic Pair(L lhs, R rhs) { this.lhs = lhs; this.rhs = rhs; }\n\t\tpublic R rhs() { return rhs; }\n\t\tpublic L lhs() { return lhs; }\n\t\tpublic <N> Pair<N, R> keepingRhs(N newLhs) { return new Pair<>(newLhs, rhs); }\n\t\t/*E*/}\n\n\tstatic Map<String, List<String>> invert(Map<String, List<String>> packages) {\n\t\treturn packages.entrySet().stream().map(e -> new Pair<>(e.getValue(), e.getKey())).flatMap(\n\t\t\t//The method collect(Collector<? super Object,A,R>) in the type Stream<Object>\n\t\t\t//is not applicable for the arguments \n\t\t\t//(Collector<CollectorsMaps.Pair<String,String>,capture#3-of ?,Map<String,List<String>>>)\n\t\t  p -> p.lhs.stream().map(p::keepingRhs)).collect(\n\t\t  groupingBy(Pair<String, String>::lhs, mapping(Pair<String, String>::rhs, toList())));\n\t}\n}\n"}, "");
    }

    public void testBug432626() {
        this.runConformTest(new String[]{"StreamInterface2.java", "import java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.Map;\nimport java.util.function.Function;\nimport java.util.function.Supplier;\nimport java.util.stream.Collector;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\npublic interface StreamInterface2 {\n\n\tstatic <T, E extends Exception, K> Map<K, ArrayList<T>> terminalAsMapToList(\n\t  Function<? super T, ? extends K> classifier,\n\t  Supplier<Stream<T>> supplier,\n\t  Class<E> classOfE) throws E {\n\t\treturn terminalAsCollected(classOfE, Collectors.groupingBy(\n\t\t\t  classifier,\n\t\t\t  //This is OK:\n\t\t\t  //Redundant specification of type arguments <K, ArrayList<T>>\n\t\t\t  () -> new HashMap<K, ArrayList<T>>(),\n\t\t\t  Collector.<T, ArrayList<T>> of(\n\t\t\t    () -> new ArrayList<>(),\n\t\t\t    (left, value) -> left.add(value),\n\t\t\t    (left, right) -> combined(left, right))), supplier);\n\t}\n\tstatic <T, E extends Exception, K> Map<K, ArrayList<T>> terminalAsMapToList2(\n\t  Function<? super T, ? extends K> classifier,\n\t  Supplier<Stream<T>> supplier,\n\t  Class<E> classOfE) throws E {\n\t\t//After removing type arguments, ECJ shows error, javac doesn't:\n\t\t//Type mismatch: cannot convert from HashMap<capture#2-of ? extends K,ArrayList<T>> to Map<K,ArrayList<T>>\n\t\treturn terminalAsCollected(classOfE, Collectors.groupingBy(\n\t\t\t  classifier,\n\t\t\t  () -> new HashMap<>(),\n\t\t\t  Collector.<T, ArrayList<T>> of(\n\t\t\t    () -> new ArrayList<>(),\n\t\t\t    (left, value) -> left.add(value),\n\t\t\t    (left, right) -> combined(left, right))), supplier);\n\t}\n\tstatic <E extends Exception, T, M> M terminalAsCollected(\n\t  Class<E> classOfE,\n\t  Collector<T, ?, M> collector,\n\t  Supplier<Stream<T>> supplier) throws E {\n\t\ttry(Stream<T> s = supplier.get()) {\n\t\t\treturn s.collect(collector);\n\t\t} catch(RuntimeException e) {\n\t\t\tthrow unwrapCause(classOfE, e);\n\t\t}\n\t}\n\tstatic <E extends Exception> E unwrapCause(Class<E> classOfE, RuntimeException e) throws E {\n\t\tThrowable cause = e.getCause();\n\t\tif(classOfE.isInstance(cause) == false) {\n\t\t\tthrow e;\n\t\t}\n\t\tthrow classOfE.cast(cause);\n\t}\n\tstatic <T> ArrayList<T> combined(ArrayList<T> left, ArrayList<T> right) {\n\t\tleft.addAll(right);\n\t\treturn left;\n\t}\n}\n"});
    }

    public void testBug432626_reduced() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.Map;\nimport java.util.function.Function;\nimport java.util.stream.Collector;\nimport java.util.stream.Collectors;\npublic interface X {\n\tstatic <T, K> Map<K, ArrayList<T>> terminalAsMapToList(Function<? super T, ? extends K> classifier)  {\n\t\treturn terminalAsCollected(Collectors.groupingBy(\n\t\t\t  classifier,\n\t\t\t  () -> new HashMap<>(),\n\t\t\t  (Collector<T,ArrayList<T>,ArrayList<T>>) null));\n\t}\n\tstatic <T, M> M terminalAsCollected(Collector<T, ?, M> collector) {\n\t\treturn null;\n\t}\n}\n"});
    }

    public void testBug433825() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\npublic class X {\n  public static void main(String[] args) {\n  }\n  public void bla() {\n    boolean b = Boolean.TRUE.booleanValue();\n    List<String> c1 = new ArrayList<>();\n    new Bar(b ? c1 : new ArrayList<>()); // this line crashes ecj (4.4 I20140429-0800), but not ecj (eclipse 3.8.2) and javac\n  }\n  private static class Bar {\n\t  public Bar(Collection<?> col) { }\n  }\n}"});
    }

    public void testBug433825a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\npublic class X {\n  public static void main(String[] args) {\n  }\n  public void bla() {\n    boolean b = Boolean.TRUE.booleanValue();\n    new Bar(b ? 0 : new ArrayList<>());\n  }\n  private static class Bar {\n\t  public Bar(Collection<String> col) { }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tnew Bar(b ? 0 : new ArrayList<>());\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor X.Bar((b ? 0 : new ArrayList<>())) is undefined\n----------\n2. ERROR in X.java (at line 9)\n\tnew Bar(b ? 0 : new ArrayList<>());\n\t            ^\nType mismatch: cannot convert from int to Collection<String>\n----------\n3. WARNING in X.java (at line 12)\n\tpublic Bar(Collection<String> col) { }\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor X.Bar(Collection<String>) is never used locally\n----------\n");
    }

    public void testBug435462() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\npublic class X {\n  public static void main(String[] args) {\n  }\n  public void bla() {\n    boolean b = Boolean.TRUE.booleanValue();\n    List<String> c1 = new ArrayList<>();\n    new Bar(b ? new ArrayList<>(b ? new ArrayList<>() : c1) : c1);\n  }\n  private static class Bar {\n\t  public Bar(Collection<?> col) { }\n  }\n}"});
    }

    public void testBug437007() {
        this.runConformTest(new String[]{"ExecutorTests.java", "import java.util.*;\n\npublic class ExecutorTests {\n    List<Runnable> tasks = Arrays.asList(\n            () -> {\n                System.out.println(\"task1 start\");\n            }\n    );\n\n    public void executeInSync(){\n        tasks.stream().forEach(Runnable::run);\n    }\n}\n"});
    }

    public void testBug435689() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.*;\nclass Foo<T> {\n  <U> void apply(Function<T, Consumer<U>> bar) {}\n}\n\nclass Bar {\n  void setBar(String bar){}\n}\npublic class Test {\n\tvoid test() {\n\t\tnew Foo<Bar>().apply(bar -> bar::setBar);\n\t}\n}\n"});
    }

    public void testBug433845() {
        this.runNegativeTest(new String[]{"test/Test.java", "package test;\n\n\npublic abstract class Test {\n\tpublic interface MUIElement {\n\t\t\n\t}\n\n\tprivate interface Listener<W extends WWidget<?>> {\n\t\tpublic void call(Event<W> event);\n\t}\n\t\n\tpublic static class Event<W extends WWidget<?>> {\n\t\t\n\t}\n\t\n\tpublic interface WWidget<M extends MUIElement> {\n\t\tpublic void set(Listener<? extends WWidget<M>> handler);\n\t}\n\t\n\tpublic static abstract class A<M extends MUIElement, W extends WWidget<M>> {\n\t\t\n\t\tpublic final W createWidget(final M element) {\n\t\t\tW w = get(); \n\t\t\t// works\n\t\t\tw.set((Event<W>e) -> call(e));\n\t\t\t// fails\n\t\t\tw.set(this::call);\n\t\t\t// fails\n\t\t\tw.set((e) -> call(e));\n\t\t\treturn w;\n\t\t}\n\t\t\n\t\tprivate W get() {\n\t\t\treturn null;\n\t\t}\n\t\t\n\t\tprivate void call(Event<W> event) {\n\t\t\t\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in test\\Test.java (at line 28)\n\tw.set(this::call);\n\t  ^^^\nThe method set(Test.Listener<? extends Test.WWidget<M>>) in the type Test.WWidget<M> is not applicable for the arguments (this::call)\n----------\n2. ERROR in test\\Test.java (at line 28)\n\tw.set(this::call);\n\t      ^^^^^^^^^^\nThe type Test.A<M,W> does not define call(Test.Event<Test.WWidget<M>>) that is applicable here\n----------\n3. ERROR in test\\Test.java (at line 30)\n\tw.set((e) -> call(e));\n\t             ^^^^\nThe method call(Test.Event<W>) in the type Test.A<M,W> is not applicable for the arguments (Test.Event<Test.WWidget<M>>)\n----------\n");
    }

    public void testBug435187() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, new String[]{"ExtractLocalLambda.java", "\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Map.Entry;\nimport java.util.function.Function;\nimport java.util.stream.Collector;\nimport java.util.stream.Stream;\n\npublic class ExtractLocalLambda {\n\tstatic Stream<Entry<List<String>, String>> map;\n\tstatic Collector<Entry<String, String>, ?, Map<String, List<String>>> groupingBy;\n\tprivate static Stream<String> stream(Entry<List<String>, String> p) {\t\treturn null;\t}\n\tprivate static Entry<String, String> keep(Entry<List<String>, String> p, String leftHS2) {\t\treturn null;\t}\n\n\tstatic Map<String, List<String>> beforeRefactoring() {\n\t\t// Extract local variable from the parameter to flatMap:\n\t\treturn map.flatMap(\n\t\t\t\tp -> stream(p).map(leftHS -> {\n\t\t\t\t\tString leftHS2 = leftHS;\n\t\t\t\t\treturn keep(p, leftHS2);\n\t\t\t\t})\n\t\t).collect(groupingBy);\n\t}\n}\n"}, "----------\n1. WARNING in ExtractLocalLambda.java (at line 5)\n\timport java.util.function.Function;\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe import java.util.function.Function is never used\n----------\n");
    }

    public void testBug435767() {
        this.runConformTest(new String[]{"DummyClass.java", "import java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\npublic class DummyClass {\n\n\tpublic void method() {\n\n\t\t// Cases where there is no error\n\t\tfinal Supplier<Set<String>> suppliers = this.memoize(() -> new HashSet<>());\n\n\t\tfinal Supplier<Map<Object, Object>> noMemoize = () -> suppliers.get().stream()\n\t\t\t\t.filter(path -> path.startsWith(\"\"))\n\t\t\t\t.collect(Collectors.toMap(path -> this.getKey(path), path -> this.getValue(path)));\n\n\t\t// Case where there is errors.\n\t\tfinal Supplier<Map<Object, Object>> memoize = this.memoize(() -> suppliers.get().stream()\n\t\t\t\t.filter(path -> path.startsWith(\"\"))\n\t\t\t\t.collect(Collectors.toMap(path -> this.getKey(path), path -> this.getValue(path))));\n\n\t\t// Error message are : Description\n\t\t// Resource\tPath\tLocation\tType\n\t\t// The method getKey(String) in the type DummyClass is not applicable for the arguments (Object)\tDummyClass.java line 23\tJava Problem\n\t\t// The method getValue(String) in the type DummyClass is not applicable for the arguments (Object)\tDummyClass.java line 23\tJava Problem\n\n\t}\n\n\tprivate <T> Supplier<T> memoize(final Supplier<T> delegate) {\n\t\treturn delegate;\n\t}\n\n\tprivate Object getKey(final String path) {\n\t\treturn path;\n\t}\n\n\tprivate Object getValue(final String path) {\n\t\treturn path;\n\t}\n}\n"}, "");
    }

    public void testBug434483() {
        this.runConformTest(new String[]{"Foo.java", "import java.util.*;\npublic class Foo {\n\t\n  // Similar to Guava's newLinkedList()\n  public static <E> LinkedList<E> newLinkedList() {\n    return new LinkedList<E>();\n  }\n\t\n  private final ThreadLocal<Queue<String>> brokenQueue = ThreadLocal.withInitial(Foo::newLinkedList);\n\t\n  private final ThreadLocal<Queue<String>> workingQueue1 = ThreadLocal.withInitial(Foo::<String>newLinkedList);\n\t\n  private final ThreadLocal<Queue<String>> workingQueue2 = ThreadLocal.withInitial(() -> Foo.<String>newLinkedList());\n\n}\n"});
    }

    public void testBug441734() {
        this.runConformTest(new String[]{"Example.java", "import java.util.*;\nimport java.util.function.*;\nclass Example {\n    void foo(Iterable<Number> x) { }\n\n    <T> void bar(Consumer<Iterable<T>> f) { }\n\n    void test() {\n        //call 1: lambda w/argument type - OK\n        bar((Iterable<Number> x) -> foo(x));\n\n        //call 2: lambda w/explicit type - OK\n        this.<Number> bar(x -> foo(x));\n\n        //call 3: method ref w/explicit type - OK\n        this.<Number> bar(this::foo);\n\n        //call 4: lambda w/implicit type - correctly(?) fails*\n        //bar(x -> foo(x));\n\n        //call 5: method ref w/implicit type - BUG!\n        bar(this::foo); // errors!\n    }\n}\n"});
    }

    public void testBug442245() {
        this.runConformTest(new String[]{"test/Pattern.java", "package test;\nimport test.Tuples.Tuple;\nimport test.Tuples.Tuple1;\nimport test.Tuples.Tuple10;\nimport test.Tuples.Tuple11;\nimport test.Tuples.Tuple12;\nimport test.Tuples.Tuple13;\nimport test.Tuples.Tuple2;\nimport test.Tuples.Tuple3;\nimport test.Tuples.Tuple4;\nimport test.Tuples.Tuple5;\nimport test.Tuples.Tuple6;\nimport test.Tuples.Tuple7;\nimport test.Tuples.Tuple8;\nimport test.Tuples.Tuple9;\n\npublic interface Pattern<R extends Tuple> {\n\n\tboolean isApplicable(Object o);\n\n\tR apply(Object o);\n\n\tstatic <T, R extends Tuple> Pattern<R> of(Decomposition<T, R> decomposition, R prototype) {\n\t\treturn null;\n\t}\n\n\tstatic <T, E1> Pattern<Tuple1<E1>> of(Decomposition<T, Tuple1<E1>> decomposition, E1 e1) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1));\n\t}\n\n\tstatic <T, E1, E2> Pattern<Tuple2<E1, E2>> of(Decomposition<T, Tuple2<E1, E2>> decomposition, E1 e1, E2 e2) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2));\n\t}\n\n\tstatic <T, E1, E2, E3> Pattern<Tuple3<E1, E2, E3>> of(Decomposition<T, Tuple3<E1, E2, E3>> decomposition, E1 e1,\n\t\t\tE2 e2, E3 e3) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3));\n\t}\n\n\tstatic <T, E1, E2, E3, E4> Pattern<Tuple4<E1, E2, E3, E4>> of(\n\t\t\tDecomposition<T, Tuple4<E1, E2, E3, E4>> decomposition, E1 e1, E2 e2, E3 e3, E4 e4) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3, e4));\n\t}\n\n\tstatic <T, E1, E2, E3, E4, E5> Pattern<Tuple5<E1, E2, E3, E4, E5>> of(\n\t\t\tDecomposition<T, Tuple5<E1, E2, E3, E4, E5>> decomposition, E1 e1, E2 e2, E3 e3, E4 e4, E5 e5) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3, e4, e5));\n\t}\n\n\tstatic <T, E1, E2, E3, E4, E5, E6> Pattern<Tuple6<E1, E2, E3, E4, E5, E6>> of(\n\t\t\tDecomposition<T, Tuple6<E1, E2, E3, E4, E5, E6>> decomposition, E1 e1, E2 e2, E3 e3, E4 e4, E5 e5, E6 e6) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3, e4, e5, e6));\n\t}\n\n\tstatic <T, E1, E2, E3, E4, E5, E6, E7> Pattern<Tuple7<E1, E2, E3, E4, E5, E6, E7>> of(\n\t\t\tDecomposition<T, Tuple7<E1, E2, E3, E4, E5, E6, E7>> decomposition, E1 e1, E2 e2, E3 e3, E4 e4, E5 e5,\n\t\t\tE6 e6, E7 e7) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3, e4, e5, e6, e7));\n\t}\n\n\tstatic <T, E1, E2, E3, E4, E5, E6, E7, E8> Pattern<Tuple8<E1, E2, E3, E4, E5, E6, E7, E8>> of(\n\t\t\tDecomposition<T, Tuple8<E1, E2, E3, E4, E5, E6, E7, E8>> decomposition, E1 e1, E2 e2, E3 e3, E4 e4, E5 e5,\n\t\t\tE6 e6, E7 e7, E8 e8) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3, e4, e5, e6, e7, e8));\n\t}\n\n\tstatic <T, E1, E2, E3, E4, E5, E6, E7, E8, E9> Pattern<Tuple9<E1, E2, E3, E4, E5, E6, E7, E8, E9>> of(\n\t\t\tDecomposition<T, Tuple9<E1, E2, E3, E4, E5, E6, E7, E8, E9>> decomposition, E1 e1, E2 e2, E3 e3, E4 e4,\n\t\t\tE5 e5, E6 e6, E7 e7, E8 e8, E9 e9) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3, e4, e5, e6, e7, e8, e9));\n\t}\n\n\tstatic <T, E1, E2, E3, E4, E5, E6, E7, E8, E9, E10> Pattern<Tuple10<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10>> of(\n\t\t\tDecomposition<T, Tuple10<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10>> decomposition, E1 e1, E2 e2, E3 e3,\n\t\t\tE4 e4, E5 e5, E6 e6, E7 e7, E8 e8, E9 e9, E10 e10) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10));\n\t}\n\n\tstatic <T, E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, E11> Pattern<Tuple11<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, E11>> of(\n\t\t\tDecomposition<T, Tuple11<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, E11>> decomposition, E1 e1, E2 e2, E3 e3,\n\t\t\tE4 e4, E5 e5, E6 e6, E7 e7, E8 e8, E9 e9, E10 e10, E11 e11) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11));\n\t}\n\n\tstatic <T, E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, E11, E12> Pattern<Tuple12<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, E11, E12>> of(\n\t\t\tDecomposition<T, Tuple12<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, E11, E12>> decomposition, E1 e1, E2 e2,\n\t\t\tE3 e3, E4 e4, E5 e5, E6 e6, E7 e7, E8 e8, E9 e9, E10 e10, E11 e11, E12 e12) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12));\n\t}\n\n\tstatic <T, E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, E11, E12, E13> Pattern<Tuple13<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, E11, E12, E13>> of(\n\t\t\tDecomposition<T, Tuple13<E1, E2, E3, E4, E5, E6, E7, E8, E9, E10, E11, E12, E13>> decomposition, E1 e1,\n\t\t\tE2 e2, E3 e3, E4 e4, E5 e5, E6 e6, E7 e7, E8 e8, E9 e9, E10 e10, E11 e11, E12 e12, E13 e13) {\n\t\treturn Pattern.of(decomposition, Tuples.of(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13));\n\t}\n\n\tstatic interface Decomposition<T, R extends Tuple> {\n\n\t\tR apply(T t);\n\t}\n}\n", "test/Tuples.java", "package test;\n\nimport java.io.Serializable;\nimport java.util.Objects;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\n\npublic final class Tuples {\n\n\tprivate Tuples() {\n\t\tthrow new AssertionError(Tuples.class.getName() + \" is not intended to be instantiated.\");\n\t}\n\n\tpublic static Tuple0 of() {\n\t\treturn Tuple0.instance();\n\t}\n\n\tpublic static <T> Tuple1<T> of(T t) {\n\t\treturn new Tuple1<>(t);\n\t}\n\n\tpublic static <T1, T2> Tuple2<T1, T2> of(T1 t1, T2 t2) {\n\t\treturn new Tuple2<>(t1, t2);\n\t}\n\n\tpublic static <T1, T2, T3> Tuple3<T1, T2, T3> of(T1 t1, T2 t2, T3 t3) {\n\t\treturn new Tuple3<>(t1, t2, t3);\n\t}\n\n\tpublic static <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> of(T1 t1, T2 t2, T3 t3, T4 t4) {\n\t\treturn new Tuple4<>(t1, t2, t3, t4);\n\t}\n\n\tpublic static <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {\n\t\treturn new Tuple5<>(t1, t2, t3, t4, t5);\n\t}\n\n\tpublic static <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6) {\n\t\treturn new Tuple6<>(t1, t2, t3, t4, t5, t6);\n\t}\n\n\tpublic static <T1, T2, T3, T4, T5, T6, T7> Tuple7<T1, T2, T3, T4, T5, T6, T7> of(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5,\n\t\t\tT6 t6, T7 t7) {\n\t\treturn new Tuple7<>(t1, t2, t3, t4, t5, t6, t7);\n\t}\n\n\tpublic static <T1, T2, T3, T4, T5, T6, T7, T8> Tuple8<T1, T2, T3, T4, T5, T6, T7, T8> of(T1 t1, T2 t2, T3 t3,\n\t\t\tT4 t4, T5 t5, T6 t6, T7 t7, T8 t8) {\n\t\treturn new Tuple8<>(t1, t2, t3, t4, t5, t6, t7, t8);\n\t}\n\n\tpublic static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9> of(T1 t1, T2 t2,\n\t\t\tT3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9) {\n\t\treturn new Tuple9<>(t1, t2, t3, t4, t5, t6, t7, t8, t9);\n\t}\n\n\tpublic static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Tuple10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> of(T1 t1,\n\t\t\tT2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9, T10 t10) {\n\t\treturn new Tuple10<>(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10);\n\t}\n\n\tpublic static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Tuple11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> of(\n\t\t\tT1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9, T10 t10, T11 t11) {\n\t\treturn new Tuple11<>(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11);\n\t}\n\n\tpublic static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Tuple12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> of(\n\t\t\tT1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9, T10 t10, T11 t11, T12 t12) {\n\t\treturn new Tuple12<>(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12);\n\t}\n\n\tpublic static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Tuple13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> of(\n\t\t\tT1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9, T10 t10, T11 t11, T12 t12, T13 t13) {\n\t\treturn new Tuple13<>(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13);\n\t}\n\n\tprivate static String stringify(Object... objects) {\n\t\treturn Stream\n\t\t\t\t.of(objects)\n\t\t\t\t.map(o -> (o == null) ? \"null\" : o.toString())\n\t\t\t\t.collect(Collectors.joining(\", \", \"(\", \")\"));\n\t}\n\n\tpublic static final class Tuple0 implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = -8715576573413569748L;\n\n\t\tprivate static final Tuple0 INSTANCE = new Tuple0();\n\n\t\tprivate Tuple0() {\n\t\t}\n\n\t\tpublic static Tuple0 instance() {\n\t\t\treturn INSTANCE;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 0;\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify();\n\t\t}\n\n\t\tprivate Object readResolve() {\n\t\t\treturn INSTANCE;\n\t\t}\n\t}\n\n\tpublic static final class Tuple1<T> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = -8005498887610699234L;\n\n\t\tpublic final T _1;\n\n\t\tpublic Tuple1(T t) {\n\t\t\tthis._1 = t;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 1;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple1)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple1<?> that = (Tuple1<?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1);\n\t\t}\n\t}\n\n\tpublic static final class Tuple2<T1, T2> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = -1359843718617881431L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\n\t\tpublic Tuple2(T1 t1, T2 t2) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 2;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple2)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple2<?, ?> that = (Tuple2<?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1) && Objects.equals(this._2, that._2);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2);\n\t\t}\n\t}\n\n\tpublic static final class Tuple3<T1, T2, T3> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = 1353320010987934190L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\n\t\tpublic Tuple3(T1 t1, T2 t2, T3 t3) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 3;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple3)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple3<?, ?, ?> that = (Tuple3<?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3);\n\t\t}\n\t}\n\n\tpublic static final class Tuple4<T1, T2, T3, T4> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = -835853771811712181L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\n\t\tpublic Tuple4(T1 t1, T2 t2, T3 t3, T4 t4) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 4;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple4)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple4<?, ?, ?, ?> that = (Tuple4<?, ?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3)\n\t\t\t\t\t\t&& Objects.equals(this._4, that._4);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3, _4);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3, _4);\n\t\t}\n\t}\n\n\tpublic static final class Tuple5<T1, T2, T3, T4, T5> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = 8365094604388856720L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\t\tpublic final T5 _5;\n\n\t\tpublic Tuple5(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t\tthis._5 = t5;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 5;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple5)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple5<?, ?, ?, ?, ?> that = (Tuple5<?, ?, ?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3)\n\t\t\t\t\t\t&& Objects.equals(this._4, that._4)\n\t\t\t\t\t\t&& Objects.equals(this._5, that._5);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3, _4, _5);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3, _4, _5);\n\t\t}\n\t}\n\n\tpublic static final class Tuple6<T1, T2, T3, T4, T5, T6> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = -5282391675740552818L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\t\tpublic final T5 _5;\n\t\tpublic final T6 _6;\n\n\t\tpublic Tuple6(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t\tthis._5 = t5;\n\t\t\tthis._6 = t6;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 6;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple6)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple6<?, ?, ?, ?, ?, ?> that = (Tuple6<?, ?, ?, ?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3)\n\t\t\t\t\t\t&& Objects.equals(this._4, that._4)\n\t\t\t\t\t\t&& Objects.equals(this._5, that._5)\n\t\t\t\t\t\t&& Objects.equals(this._6, that._6);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3, _4, _5, _6);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3, _4, _5, _6);\n\t\t}\n\t}\n\n\tpublic static final class Tuple7<T1, T2, T3, T4, T5, T6, T7> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = 6913366542759921153L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\t\tpublic final T5 _5;\n\t\tpublic final T6 _6;\n\t\tpublic final T7 _7;\n\n\t\tpublic Tuple7(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t\tthis._5 = t5;\n\t\t\tthis._6 = t6;\n\t\t\tthis._7 = t7;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 7;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple7)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple7<?, ?, ?, ?, ?, ?, ?> that = (Tuple7<?, ?, ?, ?, ?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3)\n\t\t\t\t\t\t&& Objects.equals(this._4, that._4)\n\t\t\t\t\t\t&& Objects.equals(this._5, that._5)\n\t\t\t\t\t\t&& Objects.equals(this._6, that._6)\n\t\t\t\t\t\t&& Objects.equals(this._7, that._7);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3, _4, _5, _6, _7);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3, _4, _5, _6, _7);\n\t\t}\n\t}\n\n\tpublic static final class Tuple8<T1, T2, T3, T4, T5, T6, T7, T8> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = 117641715065938183L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\t\tpublic final T5 _5;\n\t\tpublic final T6 _6;\n\t\tpublic final T7 _7;\n\t\tpublic final T8 _8;\n\n\t\tpublic Tuple8(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t\tthis._5 = t5;\n\t\t\tthis._6 = t6;\n\t\t\tthis._7 = t7;\n\t\t\tthis._8 = t8;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 8;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple8)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple8<?, ?, ?, ?, ?, ?, ?, ?> that = (Tuple8<?, ?, ?, ?, ?, ?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3)\n\t\t\t\t\t\t&& Objects.equals(this._4, that._4)\n\t\t\t\t\t\t&& Objects.equals(this._5, that._5)\n\t\t\t\t\t\t&& Objects.equals(this._6, that._6)\n\t\t\t\t\t\t&& Objects.equals(this._7, that._7)\n\t\t\t\t\t\t&& Objects.equals(this._8, that._8);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3, _4, _5, _6, _7, _8);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3, _4, _5, _6, _7, _8);\n\t\t}\n\t}\n\n\tpublic static final class Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = -1578540921124551840L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\t\tpublic final T5 _5;\n\t\tpublic final T6 _6;\n\t\tpublic final T7 _7;\n\t\tpublic final T8 _8;\n\t\tpublic final T9 _9;\n\n\t\tpublic Tuple9(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t\tthis._5 = t5;\n\t\t\tthis._6 = t6;\n\t\t\tthis._7 = t7;\n\t\t\tthis._8 = t8;\n\t\t\tthis._9 = t9;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 9;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple9)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple9<?, ?, ?, ?, ?, ?, ?, ?, ?> that = (Tuple9<?, ?, ?, ?, ?, ?, ?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3)\n\t\t\t\t\t\t&& Objects.equals(this._4, that._4)\n\t\t\t\t\t\t&& Objects.equals(this._5, that._5)\n\t\t\t\t\t\t&& Objects.equals(this._6, that._6)\n\t\t\t\t\t\t&& Objects.equals(this._7, that._7)\n\t\t\t\t\t\t&& Objects.equals(this._8, that._8)\n\t\t\t\t\t\t&& Objects.equals(this._9, that._9);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3, _4, _5, _6, _7, _8, _9);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3, _4, _5, _6, _7, _8, _9);\n\t\t}\n\t}\n\n\tpublic static final class Tuple10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = 7991284808329690986L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\t\tpublic final T5 _5;\n\t\tpublic final T6 _6;\n\t\tpublic final T7 _7;\n\t\tpublic final T8 _8;\n\t\tpublic final T9 _9;\n\t\tpublic final T10 _10;\n\n\t\tpublic Tuple10(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9, T10 t10) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t\tthis._5 = t5;\n\t\t\tthis._6 = t6;\n\t\t\tthis._7 = t7;\n\t\t\tthis._8 = t8;\n\t\t\tthis._9 = t9;\n\t\t\tthis._10 = t10;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 10;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple10)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple10<?, ?, ?, ?, ?, ?, ?, ?, ?, ?> that = (Tuple10<?, ?, ?, ?, ?, ?, ?, ?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3)\n\t\t\t\t\t\t&& Objects.equals(this._4, that._4)\n\t\t\t\t\t\t&& Objects.equals(this._5, that._5)\n\t\t\t\t\t\t&& Objects.equals(this._6, that._6)\n\t\t\t\t\t\t&& Objects.equals(this._7, that._7)\n\t\t\t\t\t\t&& Objects.equals(this._8, that._8)\n\t\t\t\t\t\t&& Objects.equals(this._9, that._9)\n\t\t\t\t\t\t&& Objects.equals(this._10, that._10);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10);\n\t\t}\n\t}\n\n\tpublic static final class Tuple11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = 3493688489700741360L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\t\tpublic final T5 _5;\n\t\tpublic final T6 _6;\n\t\tpublic final T7 _7;\n\t\tpublic final T8 _8;\n\t\tpublic final T9 _9;\n\t\tpublic final T10 _10;\n\t\tpublic final T11 _11;\n\n\t\tpublic Tuple11(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9, T10 t10, T11 t11) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t\tthis._5 = t5;\n\t\t\tthis._6 = t6;\n\t\t\tthis._7 = t7;\n\t\t\tthis._8 = t8;\n\t\t\tthis._9 = t9;\n\t\t\tthis._10 = t10;\n\t\t\tthis._11 = t11;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 11;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple11)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple11<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> that = (Tuple11<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3)\n\t\t\t\t\t\t&& Objects.equals(this._4, that._4)\n\t\t\t\t\t\t&& Objects.equals(this._5, that._5)\n\t\t\t\t\t\t&& Objects.equals(this._6, that._6)\n\t\t\t\t\t\t&& Objects.equals(this._7, that._7)\n\t\t\t\t\t\t&& Objects.equals(this._8, that._8)\n\t\t\t\t\t\t&& Objects.equals(this._9, that._9)\n\t\t\t\t\t\t&& Objects.equals(this._10, that._10)\n\t\t\t\t\t\t&& Objects.equals(this._11, that._11);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11);\n\t\t}\n\t}\n\n\tpublic static final class Tuple12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> implements Tuple, Serializable {\n\n\t\tprivate static final long serialVersionUID = -175212910367376967L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\t\tpublic final T5 _5;\n\t\tpublic final T6 _6;\n\t\tpublic final T7 _7;\n\t\tpublic final T8 _8;\n\t\tpublic final T9 _9;\n\t\tpublic final T10 _10;\n\t\tpublic final T11 _11;\n\t\tpublic final T12 _12;\n\n\t\tpublic Tuple12(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9, T10 t10, T11 t11, T12 t12) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t\tthis._5 = t5;\n\t\t\tthis._6 = t6;\n\t\t\tthis._7 = t7;\n\t\t\tthis._8 = t8;\n\t\t\tthis._9 = t9;\n\t\t\tthis._10 = t10;\n\t\t\tthis._11 = t11;\n\t\t\tthis._12 = t12;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 12;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple12)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple12<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> that = (Tuple12<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3)\n\t\t\t\t\t\t&& Objects.equals(this._4, that._4)\n\t\t\t\t\t\t&& Objects.equals(this._5, that._5)\n\t\t\t\t\t\t&& Objects.equals(this._6, that._6)\n\t\t\t\t\t\t&& Objects.equals(this._7, that._7)\n\t\t\t\t\t\t&& Objects.equals(this._8, that._8)\n\t\t\t\t\t\t&& Objects.equals(this._9, that._9)\n\t\t\t\t\t\t&& Objects.equals(this._10, that._10)\n\t\t\t\t\t\t&& Objects.equals(this._11, that._11)\n\t\t\t\t\t\t&& Objects.equals(this._12, that._12);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12);\n\t\t}\n\t}\n\n\tpublic static final class Tuple13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> implements Tuple,\n\t\t\tSerializable {\n\n\t\tprivate static final long serialVersionUID = 2027952127515234777L;\n\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\t\tpublic final T5 _5;\n\t\tpublic final T6 _6;\n\t\tpublic final T7 _7;\n\t\tpublic final T8 _8;\n\t\tpublic final T9 _9;\n\t\tpublic final T10 _10;\n\t\tpublic final T11 _11;\n\t\tpublic final T12 _12;\n\t\tpublic final T13 _13;\n\n\t\tpublic Tuple13(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6, T7 t7, T8 t8, T9 t9, T10 t10, T11 t11, T12 t12, T13 t13) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t\tthis._5 = t5;\n\t\t\tthis._6 = t6;\n\t\t\tthis._7 = t7;\n\t\t\tthis._8 = t8;\n\t\t\tthis._9 = t9;\n\t\t\tthis._10 = t10;\n\t\t\tthis._11 = t11;\n\t\t\tthis._12 = t12;\n\t\t\tthis._13 = t13;\n\t\t}\n\n\t\t@Override\n\t\tpublic int arity() {\n\t\t\treturn 13;\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean equals(Object o) {\n\t\t\tif (o == this) {\n\t\t\t\treturn true;\n\t\t\t} else if (o == null || !(o instanceof Tuple13)) {\n\t\t\t\treturn false;\n\t\t\t} else {\n\t\t\t\tfinal Tuple13<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> that = (Tuple13<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?>) o;\n\t\t\t\treturn Objects.equals(this._1, that._1)\n\t\t\t\t\t\t&& Objects.equals(this._2, that._2)\n\t\t\t\t\t\t&& Objects.equals(this._3, that._3)\n\t\t\t\t\t\t&& Objects.equals(this._4, that._4)\n\t\t\t\t\t\t&& Objects.equals(this._5, that._5)\n\t\t\t\t\t\t&& Objects.equals(this._6, that._6)\n\t\t\t\t\t\t&& Objects.equals(this._7, that._7)\n\t\t\t\t\t\t&& Objects.equals(this._8, that._8)\n\t\t\t\t\t\t&& Objects.equals(this._9, that._9)\n\t\t\t\t\t\t&& Objects.equals(this._10, that._10)\n\t\t\t\t\t\t&& Objects.equals(this._11, that._11)\n\t\t\t\t\t\t&& Objects.equals(this._12, that._12)\n\t\t\t\t\t\t&& Objects.equals(this._13, that._13);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic int hashCode() {\n\t\t\treturn Objects.hash(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13);\n\t\t}\n\n\t\t@Override\n\t\tpublic String toString() {\n\t\t\treturn Tuples.stringify(_1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13);\n\t\t}\n\t}\n\n\tpublic static interface Tuple {\n\n\t\tint arity();\n\n\t\t@Override\n\t\tboolean equals(Object obj);\n\n\t\t@Override\n\t\tint hashCode();\n\n\t\t@Override\n\t\tString toString();\n\t}\n\n}\n"});
    }

    public void test439594() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.function.Predicate;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\npublic class X {\n\tprotected static interface IListEntry {\n\t\tpublic <T> T visitRecordsWithResult(Function<Stream<Record>,T> func);\t\t\n\t}\n\tprotected static final class ImmutableRecord {\n\t\tpublic ImmutableRecord(Record r) { }\n\t}\n\tprotected static final class Record {}\n\tpublic List<ImmutableRecord> compilesWithEclipseAndJavac() \n\t{\n\t\treturn visitEntriesWithResult( stream -> {\n\t\t\treturn stream.map( entry -> {\n\t\t\t\tfinal List<ImmutableRecord> result1 = entry.visitRecordsWithResult( stream2 -> stream2\n\t\t\t\t\t\t.filter( somePredicate() )\n\t\t\t\t\t\t.map( ImmutableRecord::new )\n\t\t\t\t\t\t.collect( Collectors.toList() )\n\t\t\t\t\t);\t\n\t\t\t\treturn result1;\n\t\t\t}).flatMap( List::stream ).collect( Collectors.toCollection( ArrayList::new ) );\n\t\t});\t\t\n\t}\t\t\n\tpublic List<ImmutableRecord> compilesWithJavacButNotEclipse1() \n\t{\n\t\treturn visitEntriesWithResult( stream -> {\n\t\t\treturn stream.map( entry -> {\n\t\t\t\treturn entry.visitRecordsWithResult( stream2 -> stream2\n\t\t\t\t\t\t.filter( somePredicate() )\n\t\t\t\t\t\t.map( ImmutableRecord::new )\n\t\t\t\t\t\t.collect( Collectors.toList() )\n\t\t\t\t\t);\t\n\t\t\t}).flatMap( List::stream ).collect( Collectors.toCollection( ArrayList::new ) );\n\t\t});\t\t\n\t}\t\t\n\tpublic List<ImmutableRecord> compilesWithJavacButNotEclipse2() \n\t{\n\t\treturn visitEntriesWithResult( stream -> {\n\t\t\treturn stream.map( entry -> entry.visitRecordsWithResult( stream2 -> stream2\n\t\t\t\t\t\t.filter( somePredicate() )\n\t\t\t\t\t\t.map( ImmutableRecord::new )\n\t\t\t\t\t\t.collect( Collectors.toList() ) )\n\t\t\t).flatMap( List::stream ).collect( Collectors.toCollection( ArrayList::new ) );\n\t\t});\t\t\n\t}\t\n\tpublic List<ImmutableRecord> compilesWithJavacButNotEclipse3() \n\t{\n\t\treturn visitEntriesWithResult( stream -> stream.map( entry -> entry.visitRecordsWithResult( stream2 -> stream2\n\t\t\t\t\t\t.filter( somePredicate() )\n\t\t\t\t\t\t.map( ImmutableRecord::new )\n\t\t\t\t\t\t.collect( Collectors.toList() ) )\n\t\t\t)\n\t\t\t.flatMap( List::stream )\n\t\t\t.collect( Collectors.toCollection( ArrayList::new ) )\n\t\t);\t\t\n\t}\t\n\tprivate static Predicate<Record> somePredicate() {\n\t\treturn record -> true;\n\t}\t\t\n\tprivate <T> T visitEntriesWithResult(Function<Stream<IListEntry>,T> func) {\n\t\treturn func.apply( new ArrayList<IListEntry>().stream() );\n\t}\n}\n"}, "");
    }

    public void _test439594_small() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.function.Predicate;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\npublic class X {\n\tprotected static interface IListEntry {\n\t\tpublic <T> T visitRecordsWithResult(Function<Stream<Record>,T> func);\t\t\n\t}\n\tprotected static final class ImmutableRecord {\n\t\tpublic ImmutableRecord(Record r) { }\n\t}\n\tprotected static final class Record {}\n\tpublic List<ImmutableRecord> compilesWithJavacButNotEclipse1() \n\t{\n\t\treturn visitEntriesWithResult( stream -> {\n\t\t\treturn stream.map( entry -> {\n\t\t\t\treturn entry.visitRecordsWithResult( stream2 -> stream2\n\t\t\t\t\t\t.filter( somePredicate() )\n\t\t\t\t\t\t.map( ImmutableRecord::new )\n\t\t\t\t\t\t.collect( Collectors.toList() )\n\t\t\t\t\t);\t\n\t\t\t}).flatMap( List::stream ).collect( Collectors.toCollection( ArrayList::new ) );\n\t\t});\t\t\n\t}\t\t\n\tprivate static Predicate<Record> somePredicate() {\n\t\treturn record -> true;\n\t}\t\t\n\tprivate <T> T visitEntriesWithResult(Function<Stream<IListEntry>,T> func) {\n\t\treturn func.apply( new ArrayList<IListEntry>().stream() );\n\t}\n}\n"}, "");
    }

    public void test433852() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Optional;\nimport java.util.function.Function;\nimport java.util.stream.Stream;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(test(Stream.of(Stream.of(\"3\"))));\n\t\tSystem.out.println(test2(Stream.of(Stream.of(\"1\")).skip(1)));\n\t\tSystem.out.println(test31(Stream.of(Stream.of(\"2\")).skip(1)));\n\t}\n\tstatic Optional<Stream<Object>> test(Stream<Stream<String>> s31) {\n\t\treturn s31.map(s2 -> s2.map(s1 -> Integer.parseInt(s1))).findAny();\n\t}\n\tstatic Object test2(Stream<Stream<String>> s3) {\n\t\treturn s3.map(s2 -> s2.map(s1 -> Integer.parseInt(s1))).flatMap(Function.identity()).findAny().orElse(\n\t\t  X.class);\n\t}\n\tstatic Stream<Object> test31(Stream<Stream<String>> s3) {\n\t\treturn s3.map(s2 -> s2.map(s1 -> Integer.parseInt(s1))).findAny().orElse(Stream.of(new Object()));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\treturn s31.map(s2 -> s2.map(s1 -> Integer.parseInt(s1))).findAny();\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Optional<Stream<Integer>> to Optional<Stream<Object>>\n----------\n2. ERROR in X.java (at line 14)\n\treturn s3.map(s2 -> s2.map(s1 -> Integer.parseInt(s1))).flatMap(Function.identity()).findAny().orElse(\n\t                                                                                               ^^^^^^\nThe method orElse(Integer) in the type Optional<Integer> is not applicable for the arguments (Class<X>)\n----------\n3. ERROR in X.java (at line 18)\n\treturn s3.map(s2 -> s2.map(s1 -> Integer.parseInt(s1))).findAny().orElse(Stream.of(new Object()));\n\t                                                                  ^^^^^^\nThe method orElse(Stream<Integer>) in the type Optional<Stream<Integer>> is not applicable for the arguments (Stream<Object>)\n----------\n");
    }

    public void test442916() {
        this.runConformTest(new String[]{"X.java", "import static java.util.concurrent.CompletableFuture.completedFuture;\nimport java.util.Arrays;\nimport java.util.concurrent.CompletableFuture;\npublic class X {\n    public static CompletableFuture<Integer> cf(int value) {\n\t\treturn completedFuture(value);\n    }\n    public static void main(String[] args) {\n\t\tcf(1).thenCompose((xInt) -> cf(2).thenApply((zInt) -> Arrays.asList(xInt, zInt)))\n\t\t.thenAccept((ints) -> {\n\t\t\t/* !!!! ints is incorrectly inferred to be an Object, but it is List<Integer> */\n\t\t\tSystem.out.println(ints.get(0) + ints.get(1)); // should print 3;\n\t\t});\n\t}\n}\n"}, "3");
    }

    public void test442769() {
        this.runConformTest(new String[]{"X.java", "import java.nio.file.Path;\nimport java.nio.file.Paths;\nimport java.util.Arrays;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Map.Entry;\nimport java.util.stream.Collector;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\nimport java.io.Serializable;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tMap<Object, Integer> allocated = new HashMap<>();\n\t\t   Arrays.asList(\"a\", \"b\", \"c\", \"d\", \"e\") // List<String>\n\t          .stream() // Stream<String>\n\t          .map(Paths::get) // Stream<Path>\n\t          .flatMap(path -> allocated.keySet() // Set<Object>\n\t                                    .stream() // Stream<Object>\n\t                                    .map(group -> Pair.of(group, path) /*Pair<Object,Path>*/) // Stream<Pair<Object, Path>>\n\t          ) // Stream<Object> [FAIL]\n\t          .collect(Collectors.toList()) // List<Object>\n\t          .forEach(item -> System.out.println(item.getKey() + \": \" + item.getValue())); // Consumer<? super Object>\n\t    // with explicit type\n\t    Arrays.asList(\"a\", \"b\", \"c\", \"d\", \"e\") // List<String>\n\t          .stream() // Stream<String>\n\t          .map(Paths::get) // Stream<Path>\n\t          .flatMap(path -> allocated.keySet() // Set<Object>\n\t                                    .stream() // Stream<Object>\n\t                                    .<Pair<Object,Path>>map(group -> Pair.of(group, path) /*Pair<Object,Path>*/) // Stream<Pair<Object, Path>>\n\t          ) // Stream<Pair<Object, Path>>\n\t          .collect(Collectors.toList()) // List<Pair<Object, Path>>\n\t          .forEach(item -> System.out.println(item.getKey() + \": \" + item.getValue())); // Consumer<? super Pair<Object, Path>>\n\t}\n}\nabstract class Pair<L, R> implements Map.Entry<L, R>, Comparable<Pair<L, R>>, Serializable {\n    public static <L, R> Pair<L, R> of(final L left, final R right) {\n        return null;\n    }\n    public final L getKey() {\n        return null;\n    }\n    public R getValue() {\n        return null;\n    }\n}\n"}, "");
    }

    public void testAllocationBoxingCompatibility() {
        this.runConformTest(new String[]{"X.java", "public class X  {\n    static <T> int m(T o1, byte o2) {return 1;}       \n    static boolean call() {\n        return m(new Long(12l), new Byte((byte)1)) == 1;\n    }\n\n    public static void main(String argv[]) {\n       System.out.println(call());\n    }\n}\n"}, "true");
    }

    public void test437444_c113() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tfinal List<String>[] ls = Util.cast(new List<>[] { null });\n\t\n}\nclass Util {\n\t@SuppressWarnings(\"unchecked\")\n\tpublic static <T> T cast(Object x) {\n\t\treturn (T) x;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tfinal List<String>[] ls = Util.cast(new List<>[] { null });\n\t                                        ^^^^\nIncorrect number of arguments for type List<E>; it cannot be parameterized with arguments <>\n----------\n");
    }

    public void test437444_c113a() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tfinal List<String>[] ls = Util.cast(new List<?>[] { null });\n\t\n}\nclass Util {\n\t@SuppressWarnings(\"unchecked\")\n\tpublic static <T> T cast(Object x) {\n\t\treturn (T) x;\n\t}\n}\n"}, "");
    }

    public void test434394() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\nimport java.util.List;\npublic class X {\n  public void bla() {\n    boolean b = Boolean.TRUE.booleanValue();\n    List<String> c1 = new ArrayList<>();\n    Collections.sort(c1, new Foo(new State<>((b ? new Val<>(\"AAAA\") : new Val<>(\"BBBB\"))))); // Cannot infer type arguments for State\n    Collections.sort(c1,new Foo(b ? new State<>(new Val<>(\"AAAA\")) : new State<>(new Val<>(\"BBBB\")))); // this is fine\n  }\n  static class Foo implements Comparator<String>{\n\t  public Foo(State<String> st) {\n\t\t  //\n\t  }\n\t@Override\n\tpublic int compare(String o1, String o2) {\n\t\t// TODO Auto-generated method stub\n\t\treturn 0;\n\t}\n  }\n\tstatic class State<R> {\n\t\tState(Val<?> o) {\n\t\t}\n\t}\n\tstatic class Val<T> {\n\t\tVal(T t) {}\n\t}\n}\n"}, "");
    }

    public void test445725() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.Collection;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\npublic class X {\n/**\n   * Takes a collection, applies a mapper to it, and then passes the result into the finishing\n   * function\n   */\n  public static <FROM, TO, RESULT> RESULT mapped(Collection<FROM> collection,\n                                                 Function<? super FROM, ? extends TO> mapper,\n                                                 Function<? super Collection<TO>, RESULT> finisher)\n  {\n    return mapped(collection.stream(), mapper, finisher);\n  }\n  /**\n   * Takes a stream, applies a mapper to it, and then passes the result into the finishing function\n   */\n  public static <FROM, TO, RESULT> RESULT mapped(Stream<FROM> stream,\n                                                 Function<? super FROM, ? extends TO> mapper,\n                                                 Function<? super Collection<TO>, RESULT> finisher)\n  {\n    return finisher.apply(stream.map(mapper).collect(Collectors.toList()));\n  }\n  public static void example()\n  {\n    mapped(Stream.of(\"1, 2, 3\"), Integer::parseInt, ArrayList<Integer>::new);\n    mapped(Arrays.asList(\"1, 2, 3\"), Integer::parseInt, ArrayList<Integer>::new);\n\n    mapped(Stream.of(\"1, 2, 3\"), Integer::parseInt, IntCollection::new);\n    mapped(Arrays.asList(\"1, 2, 3\"), Integer::parseInt, IntCollection::new);\n  }\n  public static class IntCollection extends ArrayList<Integer>\n  {\n    public IntCollection(Collection<Integer> numbers)\n    {\n      super(numbers);\n    }\n  }\n}\n"}, "");
    }

    public void test447767() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid bar(String t);\n}\npublic class X<T> {\n\tX(String x) {}\n\tX(T x) { \n\t\tSystem.out.println(\"Here\");\n\t}\n\tX(T x, String ...strings) {}\n\tpublic void one(X<I> c){}\n\tpublic void two() {\n\t\tone(new X<>((String s) -> { }));\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X(\"\").two();\n\t}\n}\n"}, "Here");
    }

    public void test426633c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t default <T> void foo (T... p) {}\n}\nabstract class A  {\n\tpublic abstract void foo(Object [] p);\n}\nabstract class B extends A implements I {\n}\npublic abstract class X extends B implements I {\n\tpublic static void main(B b) {\n\t\tb.foo(\"hello\", \"world\");\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tdefault <T> void foo (T... p) {}\n\t                           ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n");
    }

    public void test426633d() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t default <T> void foo (T... p) {}\n}\nabstract class A  {\n\tpublic void foo(Object [] p) {}\n}\nabstract class B extends A implements I {\n}\npublic abstract class X extends B implements I {\n\tpublic static void main(B b) {\n\t\tb.foo(\"hello\", \"world\");\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tdefault <T> void foo (T... p) {}\n\t                           ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n2. WARNING in X.java (at line 7)\n\tabstract class B extends A implements I {\n\t               ^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n3. WARNING in X.java (at line 9)\n\tpublic abstract class X extends B implements I {\n\t                      ^\nVarargs methods should only override or be overridden by other varargs methods unlike A.foo(Object[]) and I.foo(Object...)\n----------\n4. ERROR in X.java (at line 11)\n\tb.foo(\"hello\", \"world\");\n\t  ^^^\nThe method foo(T...) of type I cannot be invoked as it is overridden by an inapplicable method\n----------\n");
    }

    public void test426633e() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\t default <T> void foo (T... p) {}\n}\nabstract class A  {\n\tpublic void foo(String [] p) {}\n}\nabstract class B extends A implements I {\n}\npublic abstract class X extends B implements I {\n\tpublic static void main(B b) {\n\t\tb.foo(\"hello\", \"world\");\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tdefault <T> void foo (T... p) {}\n\t                           ^\nType safety: Potential heap pollution via varargs parameter p\n----------\n");
    }

    public void testBug452788a() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.Function;\n\ninterface Test<A> {\n\n\t<B3> Test<B3> create(B3 b);\n\n\t<B2> Test<B2> transform(Function<? extends A, Test<B2>> f);\n\n\tdefault <B1> Test<B1> wrap(Function<? super A, ? extends B1> f) {\n\t\treturn transform(a -> create(f.apply(a)));\n\t}\n}\n"});
    }

    public void testBug452788b() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.Function;\n\ninterface Test<A> {\n\n\t<B3> Test<B3> create(B3 b);\n\n\t<B2> Test<B2> transform(Function<? extends A, Test<B2>> f);\n\n\tdefault <B1> Test<B1> wrap(Function<? super A, ? extends B1> f) {\n\t\treturn transform((A a) -> create(f.apply(a)));\n\t}\n\tdefault <B> Function<? extends A, Test<B>> test1(Function<? super A, ? extends B> f) {\n\t\treturn a -> create(f.apply(a));\n\t}\n\tdefault <B> Function<? extends A, Function<? extends A, Test<B>>> test2(Function<? super A, ? extends B> f) {\n\t\treturn a1 -> a2 -> create(f.apply(a2));\n\t}\n}\n"});
    }

    public void testBug452788c() {
        this.runConformTest(new String[]{"Test2.java", "import java.util.function.Function;\n\n\npublic interface Test2<A> {\n\t<B2> Test2<B2> transform(Function<? extends A, Test2<B2>> f);\n\n\tdefault <B1> Test2<B1> wrap(Function<? super A, ? extends B1> f) {\n\t\treturn transform(a -> new TestImpl<>(f.apply(a)));\n\t}\n}\n\nclass TestImpl<A> implements Test2<A> {\n\n\tpublic TestImpl(A a) { }\n\n\t@Override\n\tpublic <B2> Test2<B2> transform(Function<? extends A, Test2<B2>> f) {\n\t\treturn null;\n\t}\t\n}\n"});
    }

    public void testBug457079() {
        this.runConformTest(new String[]{"Foo.java", "import java.util.Collections;\nimport java.util.Map;\nimport java.util.Set;\nimport java.util.function.Function;\n\nclass Foo {\n    static <K, V> Map<K, V> foo(K value, Function<? super K, V> function) {\n        return null;\n    }\n\n    static void bar(Set<String> set) {\n        Map<String, Set<String>> map = foo(\"\", e -> Collections.emptySet());\n    }\n}\n"});
    }

    public void testBug458396() {
        this.runNegativeTest(new String[]{"Main.java", "import java.util.List;\n\ninterface MyTickContext { }\nabstract class MyEntity {\n\tabstract void tick(MyTickContext ctx);\n}\n\npublic class Main {\n\n\tprotected static final MyTickContext tickContext = new MyTickContext() {\n\t\tpublic void method1(MyEntity e) {\n\t\t\tremoveEntity( e );\n\t\t}\n\t};\n\n\tpublic static final class Game  {\n\t\tpublic void method2(List<MyEntity> ents) {\n\t\t\tents.forEach( e -> e.tick(tickContext) );\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Main.java (at line 12)\n\tremoveEntity( e );\n\t^^^^^^^^^^^^\nThe method removeEntity(MyEntity) is undefined for the type new MyTickContext(){}\n----------\n");
    }

    public void testBug455945() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.BiFunction;\nimport java.util.function.Function;\nimport java.util.function.Predicate;\nimport java.util.stream.Stream;\n\npublic class Test {\n\n    static <T> Tuple2<Seq<T>, Seq<T>> splitAtDoesntCompile(Stream<T> stream, long position) {\n        return seq(stream)\n            .zipWithIndex()\n            .partition(t -> t.v2 < position)\n            .map((v1, v2) -> tuple(\n                v1.map(t -> t.v1),\n                v2.map(t -> t.v1)\n            ));\n    }\n\n    static <T> Tuple2<Seq<T>, Seq<T>> splitAtCompiles(Stream<T> stream, long position) {\n        return seq(stream)\n            .zipWithIndex()\n            .partition(t -> t.v2 < position)\n            .map((v1, v2) -> Test.<Seq<T>, Seq<T>>tuple(\n                v1.map(t -> t.v1),\n                v2.map(t -> t.v1)\n            ));\n    }\n\n    static <T> Seq<T> seq(Stream<T> stream) {\n    \treturn null;\n    }\n\n    static <T1, T2> Tuple2<T1, T2> tuple(T1 v1, T2 v2) {\n    \treturn null;\n    }\n}\n\ninterface I<T> {\n\tT get();\n\t<U> I<U> map(Function<T, U> f);\n}\n\ninterface Seq<T> {\n\tSeq<Tuple2<T, Long>> zipWithIndex();\n\tTuple2<Seq<T>, Seq<T>> partition(Predicate<? super T> predicate);\n\t<R> Seq<R> map(Function<? super T, ? extends R> mapper);\n}\n\nclass Tuple2<T1, T2> {\n\tT1 v1;\n\tT2 v2;\n\t\n\t<R> R map(BiFunction<T1, T2, R> function) {\n\t\treturn null;\n\t}\n}\n"});
    }

    public void testBug445231() {
        this.runConformTest(true, new String[]{"com/n/Bug.java", "package com.n;\npublic class Bug {\n  public static void main(String[] args) {\n    try {\n      new Bug().go();\n      System.err.println(\"Ok\");\n    } catch (IllegalAccessError e) {\n      System.err.println(\"Error\");\n      e.printStackTrace();\n    }\n  }\n  public void go() {\n    Class<?> clazz = Buggered.Foo.class;\n    System.err.println(\"Here we go\");\n    if (clazz.isAnonymousClass()) {\n      System.err.println(\"is anon\");\n    } else {\n      System.err.println(\"not anon\");\n    }\n  }\n}\n", "com/g/Base.java", "package com.g;\nclass Base2{}\nclass Base {\n\tclass A {}\n\tstatic class Builder<B extends Builder<B>> {\n\t\tpublic B setJobName() {\n\t\t\treturn null;\n\t\t}\n\t\tpublic Base2 setJobName2(B b) {\n\t\t\treturn null;\n\t\t}\n\t\tpublic void foo(H<? super H<Base3.A>> h) {\n\t\t\treturn;\n  \t\t}\n\t\tprivate class H<T> {}\n\t}\n   static class Builder2 {\n       public <B extends Builder<B>> B setJobName3() {\n\t        return null;\n       }\n   }\n\tstatic class R {}\n\tpublic static class Builder3<B extends R> {\n\t\tpublic B setJobName() {\n\t\t\treturn null;\n\t\t}\n\t}\n\tpublic static class Builder4<B extends R> {\n\t\tpublic <Q extends R> Builder3<Q> setJobName() {\n\t\t\treturn null;\n\t\t}\n\t}\n\tstatic class Builder5 {\n\t\tpublic <B extends Builder<B>> void  foo(B b) {}\n\t}\n}\nclass Base3 {\n\tstatic class A{}\n}\n", "com/g/Child.java", "package com.g;\nimport com.g.Base.R;\npublic final class Child {\n  public static class Builder<I> extends Base.Builder<Builder<I>> {\n\t  public void setDummyName(){}\n  }\n  public static class Builder2 extends Base.Builder2 {}\n  public static class Builder3<I> extends  Base.Builder3<R> {}\n  public static class Builder4<I> extends  Base.Builder4<R> {}\n  public static class Builder5 extends Base.Builder5 {} \n}\n", "com/n/Buggered.java", "package com.n;\nimport com.g.Child;\nclass Z{}\npublic final class Buggered {\n  public static final class Foo {}\n  void unused() {\n    Child.Builder<Void> c = new Child.Builder<Void>();\n    c.setJobName();\n    c.setJobName2(new Child.Builder<Void>());\n    Child.Builder<Z> cb = new Child.Builder<Z>();\n    cb.setJobName();\n    cb.setJobName2(new Child.Builder<Z>());\n    Child.Builder2 cb2 = new Child.Builder2();\n    cb2.setJobName3();\n    Child.Builder3<Void> cb3 = new Child.Builder3<Void>();\n    cb3.setJobName();\n    Child.Builder4<Void> cb4 = new Child.Builder4<Void>();\n    cb4.setJobName();\n    Child.Builder5 cb5 = new Child.Builder5();\n    cb5.foo(null);\n\tc.foo(null);\n  }\n}\n"}, null, null, "Here we go\nnot anon\nOk", null);
    }

    public void testBug463728() {
        this.runConformTest(new String[]{"Main.java", "import java.util.function.Function;\n\n\nclass Color {\n\t\n}\n\nclass TypeMapper<R> {\n\n\tpublic TypeMapper() {\n\t}\n\tpublic R orElse(R result) {\n\t\treturn result;\n\t}\n}\n\npublic class Main {\n\tColor A;\n\tColor B;\n\n\tpublic static <T, R> TypeMapper<R> mapType(Function<T, R> mapper) {\n\t\treturn new TypeMapper<R>();\n\t}\n\n\tpublic Color getForeground(Object element) {\n\t\treturn mapType(library -> {\n\t\t\t\treturn (element != null ? A : B);\n\t\t\t}).orElse(null);\n\t}\n}\n"});
    }

    public void testBug470942() {
        this.runConformTest(new String[]{"EclipeMarsLamdaIssueWontBuild.java", "import java.util.function.Supplier;\n\npublic class EclipeMarsLamdaIssueWontBuild {\n\tclass MyClass {\n\t\tlong getNumber() {\n\t\t\treturn 0;\n\t\t}\n\t}\n\n\tprivate interface VoidSupplier {\n\t\tvoid perform();\n\t}\n\n\tlong processTxContent() {\n\t\treturn withLogging(() -> new MyClass().getNumber());\n\t}\n\n\tprivate static void withLogging(final VoidSupplier supplier) {\n\t\t// Do some logging\n\t}\n\n\tprivate static <T> T withLogging(final Supplier<T> supplier) {\n\t\t// Do some logging\n\t\treturn null;\n\t}\n}\n"});
    }

    public void testBug468999() {
        this.runConformTest(new String[]{"Main.java", "interface ExceptionAction<T>\n{\n    T run() throws Exception;\n}\n\ninterface Action<U> extends ExceptionAction<U>\n{\n    @Override\n    U run();\n}\n\npublic class Main\n{\n    public static void main(String[] args) {\n        runAction(() -> {                              // ERROR HERE\n            return \"\";\n        });\n    }\n\n    static <V> void runAction(ExceptionAction<V> action) {\n        System.out.println(\"run with exceptions\");\n    }\n\n    static <W> void runAction(Action<W> action) {\n        System.out.println(\"run without exceptions\");\n    }\n}\n"});
    }

    public void testBug470826() {
        this.runConformTest(new String[]{"EcjVsCollect.java", "import java.util.ArrayList;\nimport java.util.stream.Stream;\n\npublic class EcjVsCollect {\n\n  public static void main(String[] args) {\n    try (final Stream<Record<String>> stream = getStream()) {\n      stream.collect(ArrayList::new, ArrayList::add, ArrayList::addAll);\n//      ArrayList<Record<String>> foo = stream.collect(ArrayList::new, ArrayList::add, ArrayList::addAll);\n    }\n  }\n\n  private static <K> Stream<Record<K>> getStream() {\n    return Stream.empty();\n  }\n\n  private interface Record<K> {\n    K getKey();\n  }\n}\n"});
    }

    public void testBug466487() {
        this.runConformTest(new String[]{"C.java", "import java.util.*;\nimport java.util.stream.*;\nimport static java.util.Arrays.asList;\n\npublic class C {\n  static final List<Integer> DIGITS = Collections.unmodifiableList(asList(0,1,2,3,4,5,6,7,8,9));\n    \n    Collection<String> flatMapSolutions(final boolean b) {\n      Collection<String> solutions = \n          DIGITS.stream().flatMap( s -> {\n               return b ? Stream.empty() : Stream.of(\"\");\n          }) .collect(Collectors.toList());\n      return solutions;\n  }\n}\n"});
    }

    public void testBug472426() {
        this.runConformTest(new String[]{"InferenceBug.java", "import java.util.Collections;\nimport java.util.List;\nimport java.util.function.BiFunction;\n\npublic class InferenceBug {\n\n    public static void main(String[] args) {\n\n        // compiles\n        List<String> l = Collections.singletonList(\"foo\");\n        apply(Foo::foo, l);\n\n        // won't compile\n        apply(Foo::foo, Collections.singletonList(\"foo\"));\n    }\n\n    static <T> void apply(BiFunction<Foo, T, Foo> fun, T value) {\n    }\n\n    static class Foo {\n        public Foo foo(List<String> i) {\n            return this;\n        }\n\n        public Foo foo(String... i) {\n            return this;\n        }\n    }\n\n}\n"});
    }

    public void testBug469753() {
        this.runConformTest(new String[]{"LambdaBug.java", "import java.util.AbstractMap;\nimport java.util.Iterator;\nimport java.util.Map.Entry;\nimport java.util.function.Function;\n\npublic class LambdaBug {\n\n    class Item {\n        String foo;\n    }\n\n    public void bug(String catalogKey, Iterator<Item> items) {\n        go(transform(items, i -> pair(i.foo, i)));\n    }\n\n    public static <K, V> Entry<K, V> pair(K key, V value) {\n        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);\n    }\n\n    void go(Iterator<Entry<String, Item>> items) {\n    }\n\n    public static <F, T> Iterator<T> transform(Iterator<F> fromIterator, Function<? super F, ? extends T> function) {\n        return null;\n    }\n\n}\n"});
    }

    public void testBug470958() {
        this.runConformTest(new String[]{"Bug470958.java", "import java.time.*;\nimport java.util.*;\nimport java.util.concurrent.*;\nimport static java.util.concurrent.CompletableFuture.*;\nimport static java.util.stream.Collectors.*;\n\nclass Hotel {}\n\nclass Bug470958 {\n  public Map<String, CompletableFuture<List<Hotel>>> asyncLoadMany(List<String> codes, LocalDate begin, LocalDate end) {\n    return loadMany(codes, begin, end)\n    .entrySet()\n    .stream()\n    .collect(toMap(Map.Entry::getKey, entry -> completedFuture(entry.getValue())));\n  }\n\n  public Map<String, List<Hotel>> loadMany(List<String> codes, LocalDate begin, LocalDate end) {\n    return null;\n  }\n}\n"});
    }

    public void testBug470542() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.Consumer;\n\npublic class X {\n\tvoid test() {\n\t\tprocess(missing::new);\n\t}\n\t\n\t<T> void process(Consumer<T> c) { }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tprocess(missing::new);\n\t        ^^^^^^^\nmissing cannot be resolved\n----------\n");
    }

    public void testBug471280_comment0() {
        this.runConformTest(new String[]{"Test0.java", "import java.util.*;\nimport java.util.function.*;\nimport java.util.concurrent.*;\n\npublic class Test0 {\n  public CompletableFuture<List<String>> does_not_compile() throws Exception {\n    CompletableFuture<List<String>> firstAsync = new CompletableFuture<>();\n    firstAsync.complete(Collections.singletonList(\"test\"));\n    // The following line gives error \"Type mismatch: cannot convert from CompletableFuture<Object> to CompletableFuture<List<String>>\"\n    return transform(firstAsync, first -> Collections.singletonList(first.get(0)));\n  }\n\n  public CompletableFuture<List<String>> does_compile() throws Exception {\n    CompletableFuture<List<String>> firstAsync = new CompletableFuture<>();\n    firstAsync.complete(Collections.singletonList(\"test\"));\n    return transform(firstAsync, first -> {\n      return Collections.singletonList(first.get(0));\n    });\n  }\n\n  public <T, R> CompletableFuture<R> transform(CompletableFuture<T> future, Function<T, R> fun) throws Exception {\n    return future.thenApply(fun);\n  }\n}\n"});
    }

    public void testBug471280_comment3() {
        this.runConformTest(new String[]{"Test3.java", "import java.util.*;\nimport java.util.stream.*;\n\npublic class Test3 {\n    public <T> T generic(T value) {\n        return value;\n    }\n\n    public void mapExample(Map<String, String> input) {\n        // does not compile with ejc: Type mismatch: cannot convert from Map<Object,Object> to Map<String,String>\n        Map<String, String> mapped = input.entrySet()\n            .stream()\n            .collect(Collectors.toMap(e -> e.getKey(), e -> generic(e.getValue())));\n    }\n}\n"});
    }

    public void testBug464496() {
        this.runConformTest(new String[]{"Value.java", "public class Value<V> {\n    private final V value;\n    public Value(V value) {\n        this.value = value;\n    }\n    public V get() {\n        return value;\n    }\n    public static <V> V getValue(Value<V> value) {\n        return value.get();\n    }\n    public static void main(String[] args) {\n        Value<Integer> intValue = new Value<>(42);\n        long longPrimitive = getValue(intValue); // fails in 1.8 compiler \n        System.out.println(longPrimitive);\n    }\n}\n"}, "42");
    }

    public void testBug473657() {
        this.runConformTest(new String[]{"T2.java", "interface I<T> {\n}\n\n@SuppressWarnings({\"unchecked\", \"rawtypes\"})\nabstract class T1<T> implements I<T> {\n    public I<T> t(I<? extends Number> l2) {\n        return T2.m((I) this, (I) l2);\n    }\n    public I<T> t(Number l2) {\n        return T2.m((I) this, (I) T2.t(l2));\n    }\n}\n\npublic abstract class T2 {\n    public static <T> I<T> t(T t) {\n        return null;\n    }\n    public static <T extends Number> I<T> m(I<T> l1, I<? extends Number> l2) {\n        return null;\n    }\n    public static <T extends Number> I<T> m(T l1, Number l2) {\n        return null;\n    }\n}\n"});
    }

    public void testBug478848() {
        this.runConformTest(new String[]{"InferenceBug.java", "import java.util.*;\npublic class InferenceBug {\n    \n    static class Wrapper<T> {\n        T value;\n        public T getValue() {\n            return null;\n        }\n    }\n    \n    static class C1 {\n        //an optional array of String wrappers\n        public Optional<? extends Wrapper<String>[]> optionalArrayOfStringWrappers() {\n            return Optional.empty();\n        }\n    }\n    \n    public static void main(String[] args) {\n        C1 c1 = new C1();\n        try {\n            for (Wrapper<String> attribute: c1.optionalArrayOfStringWrappers().get()) {\n                // error in previous line:\n                // Can only iterate over an array or an instance of java.lang.Iterable\n            }\n        } catch (NoSuchElementException nsee) {\n            System.out.print(\"No such element\");\n        }\n    }\n}\n"}, "No such element");
    }

    public void testBug479167() {
        this.runConformTest(new String[]{"ToArray.java", "import java.io.Serializable;\ninterface ArrayFunction<E> {\n\t<S extends E> E[] apply(@SuppressWarnings(\"unchecked\") S... es);\n}\npublic class ToArray<E extends Cloneable & Serializable> implements ArrayFunction<E> {\n\tpublic final @SafeVarargs @Override <S extends E> E[] apply(S... es) {\n\t\treturn es;\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tArrayFunction<String[]> toArray = new ToArray<>();\n\t\tString[][] array = toArray.apply(args);\n\t\tSystem.out.print(array.getClass().getName());\n\t}\n}\n"}, "[[Ljava.lang.String;");
    }

    public void testBug477751() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.Function;\nclass Test {\n\tpublic static <T, U> U map(T value, Function<T, U> mapper) {\n\t\tif (value != null)\n\t\t\treturn mapper.apply(value);\n\t\treturn null;\n\t}\n\n\tString value;\n\t\n\tvoid test() {\n\t\tmap(map(value, nnVal1 -> nnVal1.toLowerCase()),\n\t\t\t\tnnVal2 -> nnVal2.length());\n\t}\n\n}\n"});
    }

    public void testBug482416() {
        this.runConformTest(new String[]{"CompilerRegression.java", "import java.util.Comparator;\nimport java.util.concurrent.Callable;\n\npublic class CompilerRegression<T> {\n\tprivate ObjectProperty<Comparator<TreeItem<T>>> comparator = new ObjectProperty<Comparator<TreeItem<T>>>();\n\n\tvoid sample() {\n\t\t//Fails in Mars.1 succeeds in Mars.0\n\t\t{\n\t\t\tObjectBinding<Comparator<TreeItem<T>>> b = Bindings.createObjectBinding(() -> {\n\t\t\t\tif (this.comparator.get() == null)\n\t\t\t\t\treturn null;\n\t\t\t\treturn (o1, o2) -> this.comparator.get().compare(o1, o2);\n\t\t\t}, this.comparator);\n\t\t}\n\n\t\t// Succeeds in both\n\t\t{\n\t\t\tObjectBinding<Comparator<TreeItem<T>>> b = Bindings.createObjectBinding(() -> {\n\t\t\t\tif (this.comparator.get() == null)\n\t\t\t\t\treturn null;\n\t\t\t\tComparator<TreeItem<T>> cp = (o1, o2) -> this.comparator.get().compare(o1, o2);\n\t\t\t\treturn cp;\n\t\t\t}, this.comparator);\n\t\t}\n\t}\n}\n\nclass Bindings {\n    public static <X> ObjectBinding<X> createObjectBinding(final Callable<X> func, final Observable... dependencies) { return null; }\n}\nclass ObjectBinding<U> { }\nclass TreeItem<V> { }\nclass ObjectProperty<W> implements Observable  {\n\tW get() { return null; }\n}\ninterface Observable {}\n"});
    }

    public void testBug483019() {
        this.runConformTest(new String[]{"Test.java", "import sub.B;\nimport sub.Marker;\n\npublic class Test {\n  public int test(B b) {\n    return (((B & Marker) b).getValue());\n  }\n  public static void main(String[] args) {\n    System.out.println(new Test().test(new B()));\n  }\n}", "sub/A.java", "package sub;\nclass A {\n  public int getValue() {\n    return 1;\n  }\n}\n", "sub/B.java", "package sub;\npublic class B extends A implements Marker{ }\n", "sub/Marker.java", "package sub;\npublic interface Marker{ }\n"}, "1");
    }

    public void testBug483019a() {
        this.runConformTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.JavacHasErrorsEclipseHasNone, new String[]{"Test.java", "import sub.J;\nimport sub.Marker;\n\npublic class Test {\n  public int test(J j) {\n    return (((Marker & J) j).getValue());\n  }\n  public static void main(String[] args) {\n    System.out.println(new Test().test((J & Marker)() -> 0));\n  }\n}", "sub/I.java", "package sub;\ninterface I {\n  int getValue();\n}\n", "sub/J.java", "package sub;\npublic interface J extends I{ }\n", "sub/Marker.java", "package sub;\npublic interface Marker{ }\n"}, "0");
    }

    public void testBug484448() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runConformTest(new String[]{"test/Test.java", "package test;\n\npublic final class Test {\n\t/**\n\t * @see #g(T, Class)\n\t */\n\tpublic static <T> T f(T t, Class<T> c1) {\n\t\treturn g(t, c1);\n\t}\n\n\tpublic static <U> U g(U u, Class<U> c2) {\n\t\treturn u;\n\t}\n}\n"}, options);
    }

    public void testBug485593() {
        this.runConformTest(new String[]{"Test.java", "import java.util.*;\n\npublic class Test {\n  void test() {\n    double[][] d = new double[][]{{1,2},{3,4},{5,6}};\n    double[][] e = Arrays.stream(d).map(double[]::clone).toArray(double[][]::new);\n  }\n}\n"});
    }

    public void testBug483228a() {
        this.runNegativeTest(new String[]{"X.java", "interface UnaryOp<T> { T apply(T arg); }\ninterface IntegerToNumber { Number apply(Integer arg); }\n\npublic class X {\n\n  <T> void m(UnaryOp<T> f) {}\n  void m(IntegerToNumber f) {}\n\n  void test() {\n    m((Integer i) -> i);\n  } \n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tm((Integer i) -> i);\n\t^\nThe method m(UnaryOp<Integer>) is ambiguous for the type X\n----------\n");
    }

    public void testBug449824a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tinterface FI1<T> {\n\t\tpublic T get(X x, T n);\n\t}\n\tinterface FI2 {\n\t\tpublic Integer get(X x, Integer t);\n\t}\n\tvoid m(FI1<Number> fi) { }\n\tvoid m(FI2 fi) { }\n\tInteger id(Number n) {\n\t\treturn null;\n\t}\n\tvoid test() {\n\t\tm(X::id);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tm(X::id);\n\t^\nThe method m(X.FI1<Number>) is ambiguous for the type X\n----------\n");
    }

    public void testBug449824b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tinterface FI1<T> {\n\t\tpublic T get(T... n);\n\t}\n\tinterface FI2 {\n\t\tpublic Integer get(Integer... t);\n\t}\n\tvoid m(FI1<Number> fi) { }\n\tvoid m(FI2 fi) { }\n\tInteger id(Number[] n) {\n\t\treturn null;\n\t}\n\tvoid test() {\n\t\tm(this::id);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic T get(T... n);\n\t                  ^\nType safety: Potential heap pollution via varargs parameter n\n----------\n2. ERROR in X.java (at line 14)\n\tm(this::id);\n\t^\nThe method m(X.FI1<Number>) is ambiguous for the type X\n----------\n");
    }

    public void testBug487746_comment2() {
        this.runConformTest(new String[]{"Example.java", "\nimport java.time.Instant;\nimport java.util.Comparator;\nimport java.util.stream.Collectors;\n\npublic class Example {\n   public void test1() {\n      // Returns Collector<Something,?,Something> - CORRECT\n      Collectors.collectingAndThen(\n            Collectors.<Something>toList(),\n            list -> list.stream().sorted(Comparator.comparing(Something::getTime)).limit(1).findAny().orElse(null)\n      );\n   }\n   \n   public void test2() {\n         Collectors.collectingAndThen(\n            Collectors.<Something>toList(),\n            list -> list.stream().collect(Collectors.groupingBy(Something::getSize,\n                     // Returns Collector<Something,?,Object> - INCORRECT!\n                     Collectors.collectingAndThen(\n                        Collectors.<Something>toList(),\n                        list2 -> list2.stream().sorted(Comparator.comparing(Something::getTime)).limit(1).findAny().orElse(null)\n                     )\n                  )));\n   }\n   private interface Something {\n      public int getSize();\n      public Instant getTime();\n  }\n}\n"});
    }

    public void _testBug487746_comment9() {
        this.runConformTest(new String[]{"Example.java", "\nimport java.time.Instant;\nimport java.util.Comparator;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\npublic class Example {\n\tpublic void doesntCompile(List<Something> things) {\n   \tthings.stream()\n       \t.filter(thing -> thing.getSize() > 100)\n       \t.collect(Collectors.collectingAndThen(\n        \t \tCollectors.<Something>toList(),\n         \t\tlist -> list.stream().collect(Collectors.groupingBy(Something::getSize,\n           \t       \tCollectors.collectingAndThen(\n               \t      Collectors.<Something>toList(),\n                   \t  list2 -> list2.stream().sorted(Comparator.comparing(Something::getTime)).limit(1).findAny().orElse(null)\n                  \t\t)\n               ))))\n   \t\t.forEach((size, thing) -> {\n       \t\tSystem.out.println(thing.getSize());   // Compile error because Eclipse thinks 'thing' is Object\n   \t\t});\n\t}\n   private interface Something {\n      public int getSize();\n      public Instant getTime();\n  }\n}\n"});
    }

    public void testBug480075() {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.*;\npublic class X {\n\tvoid test() {\n\t\tIntStream.of(42).mapToObj(i -> i > 42 ? \"gt\" : i < 42 ? \"lt\" : \"42\").findFirst();\n\n\t\tStream.generate(Object::new).map(o -> o != null ? o : o == null ? o : o).findAny();\n\n\t}\n}\n"});
    }

    public void testBug488649() {
        this.runNegativeTest(new String[]{"X.java", "class A<T> {}\npublic class X {\n\tstatic <U> U get(A<U> a) { return null; }\n\tvoid test(A a) {\n\t\tget(a).missing();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tvoid test(A a) {\n\t          ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tget(a).missing();\n\t^^^^^^\nType safety: Unchecked invocation get(A) of the generic method get(A<U>) of type X\n----------\n3. WARNING in X.java (at line 5)\n\tget(a).missing();\n\t    ^\nType safety: The expression of type A needs unchecked conversion to conform to A<Object>\n----------\n4. ERROR in X.java (at line 5)\n\tget(a).missing();\n\t       ^^^^^^^\nThe method missing() is undefined for the type Object\n----------\n");
    }

    public void testBug488672() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tvoid foo(Manager manager) {\n\t\tHashSet<String> activeBindings = new HashSet<>(manager.getActiveBindingsDisregardingContextFlat());\n\t}\n}\n\nclass Manager {\n\tCollection getActiveBindingsDisregardingContextFlat() {\n\t\treturn null;\n\t}\n}\n"});
    }

    public void testBug488795() {
        this.runConformTest(new String[]{"X.java", "interface Parameter {}\ninterface Parameters<S extends Parameters<S, T>, T extends Parameter> extends Iterable<T> {\n\tS get();\n}\npublic class X {\n\tvoid test(Parameters<?,?> parameters) {\n\t\tfor(Parameter p : parameters.get())\n\t\t\tSystem.out.println(p);\n\t}\n}\n"});
    }

    public void testBug489976() {
        this.runConformTest(new String[]{"Test.java", "import java.util.*;\nimport static java.util.stream.Collectors.*;\nimport java.util.stream.Collectors;\n\nclass Key {}\nclass Value {}\npublic class Test {\n  void test (List<Map<Key, Value>> maps) {\n    maps.stream().flatMap(s->s.entrySet().stream()).collect(\n        groupingBy(e -> e.getKey(), \n            mapping(e -> e.getValue(),  collectingAndThen(toList(),x->x))\n        )\n    );\n  }\n}\n"});
    }

    public void testBug491934() {
        this.runConformTest(new String[]{"Main.java", "import java.util.Arrays;\nimport java.util.HashSet;\nimport java.util.Set;\n\npublic class Main {\n\n\tpublic static void main(String[] args) {\n\t\t// gives compile error in Neon\n\t\t// was warning \"unchecked\" in Mars\n\t\tSet<String> genericSet = new HashSet<>(oldApiReturningUntypedSet());\n\t}\n\n\t@SuppressWarnings({ \"rawtypes\", \"unchecked\" })\n\tprivate static Set oldApiReturningUntypedSet() {\n\t\tHashSet set = new HashSet();\n\t\tset.add(\"one\");\n\t\treturn set;\n\t}\n\n}\n"});
    }

    public void testBug491485() {
        this.runNegativeTest(new String[]{"Tester.java", "interface SAM<X, Y, Z extends X3> {\n\tZ bar(X a, Y b);\n}\ninterface I<T> {\n\t\n}\nclass X3 {\n\t\n}\npublic class Tester {\n\n\tX3 method(SAM<?, ?, ?> s) {\n\t\treturn s.bar(null, null);\n\t}\n\t\n\tObject foo(Object a, Object b) {\n\t\treturn null;\n\t}\n\tX3 junk() {\n\t\treturn method((SAM<?,?,?> & I <?>) this::foo);\n\t}\n}\n"}, "----------\n1. ERROR in Tester.java (at line 20)\n\treturn method((SAM<?,?,?> & I <?>) this::foo);\n\t                                   ^^^^^^^^^\nThe type of foo(Object, Object) from the type Tester is Object, this is incompatible with the descriptor's return type: X3\n----------\n");
    }

    public void testBug485057() {
        this.runNegativeTest(new String[]{"Task.java", "public class Task {\n\n\tpublic static void main(String[] args) {\n\t\tfoo(rt -> true); // PROBLEM HERE\n\t}\n\n\tpublic static <T extends java.io.Serializable> Task foo(T serialiable) {\n\t\treturn null;\n\t}\n\n\tpublic static Task foo(java.util.function.Predicate<?> predicate) {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in Task.java (at line 4)\n\tfoo(rt -> true); // PROBLEM HERE\n\t^^^\nThe method foo(Serializable) is ambiguous for the type Task\n----------\n2. ERROR in Task.java (at line 4)\n\tfoo(rt -> true); // PROBLEM HERE\n\t    ^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void testBug485373() {
        this.runNegativeTest(new String[]{"TestGenericsFunctional.java", "import java.util.Collection;\nimport java.util.function.Consumer;\n\npublic class TestGenericsFunctional {\n\n\tpublic static void doStuff(String str, Consumer<String> consumer) {\n\t\tconsumer.accept(str);\n\t}\n\t\n\tpublic static <C extends Collection<String>> C doStuff(String str, C collection) {\n\t\tdoStuff(str, st -> collection.add(st));\n\t\treturn collection;\n\t}\n}\n"}, "----------\n1. ERROR in TestGenericsFunctional.java (at line 11)\n\tdoStuff(str, st -> collection.add(st));\n\t^^^^^^^\nThe method doStuff(String, Consumer<String>) is ambiguous for the type TestGenericsFunctional\n----------\n");
    }

    public void testBug487563() {
        this.runNegativeTest(new String[]{"Java8TypeInferenceProblem.java", "\nimport java.util.Iterator;\nimport java.util.List;\n\npublic class Java8TypeInferenceProblem {\n\n\tpublic ValueObjectImpl myTestMethod() {\n\t\treturn copyToValueObject(loadBusinessObject(), ValueObjectImpl.class);\n\t}\n\n\tpublic <T extends ValueObject> T copyToValueObject(BusinessObject param, Class<T> voClass) {\n\t\treturn null;\n\t}\n\n\tpublic <T extends ValueObject> List<T> copyToValueObject(Iterator<BusinessObject> params, Class<T> voClass) {\n\t\treturn null;\n\t}\n\n\tpublic <T extends BusinessObject> T loadBusinessObject() {\n\t\treturn null;\n\t}\n\n\tprivate interface BusinessObject { }\n\n\tprivate interface ValueObject { }\n\n\tprivate class ValueObjectImpl implements ValueObject { }\n\n}\n"}, "----------\n1. ERROR in Java8TypeInferenceProblem.java (at line 8)\n\treturn copyToValueObject(loadBusinessObject(), ValueObjectImpl.class);\n\t       ^^^^^^^^^^^^^^^^^\nThe method copyToValueObject(Java8TypeInferenceProblem.BusinessObject, Class<Java8TypeInferenceProblem.ValueObjectImpl>) is ambiguous for the type Java8TypeInferenceProblem\n----------\n");
    }

    public void testBug492939a() {
        this.runConformTest(new String[]{"EclipseInference.java", "import java.lang.reflect.Type;\nimport java.sql.ResultSet;\nimport java.sql.SQLException;\nimport java.util.List;\nimport java.util.Optional;\nimport java.util.concurrent.ConcurrentHashMap;\nimport java.util.concurrent.CopyOnWriteArrayList;\nimport java.util.function.Supplier;\nimport java.util.stream.Stream;\n\npublic class EclipseInference {\n\n    private final List<RowMapperFactory> rowFactories = new CopyOnWriteArrayList<>();\n    private final ConcurrentHashMap<Type, RowMapper<?>> rowCache = new ConcurrentHashMap<>();\n\n    @SuppressWarnings(\"unchecked\")\n    public Optional<RowMapper<?>> findRowMapperFor(Type type) {\n        return Optional.ofNullable(rowCache.computeIfAbsent(type, t ->\n                findFirstPresent(\n                        () -> rowFactories.stream()\n                                .flatMap(factory -> toStream(factory.build(t)))\n                                .findFirst(),\n                        () -> findColumnMapperFor(t)\n                                .map(SingleColumnMapper::new))\n                        .orElse(null)));\n    }\n\n    private Optional<ColumnMapper<?>> findColumnMapperFor(Type t) {\n        return Optional.empty();\n    }\n\n    @SafeVarargs\n    static <T> Optional<T> findFirstPresent(Supplier<Optional<T>>... suppliers) {\n        return Stream.of(suppliers)\n                .flatMap(supplier -> toStream(supplier.get()))\n                .findFirst();\n    }\n    static <T> Stream<T> toStream(Optional<T> optional) {\n        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();\n    }\n}\n\nclass SingleColumnMapper<T> implements RowMapper<T> {\n    SingleColumnMapper(ColumnMapper<T> mapper) {\n    }\n    @Override\n    public T map(ResultSet r) {\n        return null;\n    }\n}\n\n@FunctionalInterface\ninterface RowMapper<T>\n{\n    T map(ResultSet r);\n}\n\n@FunctionalInterface\ninterface ColumnMapper<T>\n{\n    T map(ResultSet r, int columnNumber) throws SQLException;\n}\n\n@FunctionalInterface\ninterface RowMapperFactory\n{\n    Optional<RowMapper<?>> build(Type type);\n}\n\n@FunctionalInterface\ninterface ColumnMapperFactory\n{\n    Optional<ColumnMapper<?>> build(Type type);\n}\n"});
    }

    public void testBug492939b() {
        this.runConformTest(new String[]{"EclipseInference.java", "import java.lang.reflect.Type;\nimport java.sql.ResultSet;\nimport java.sql.SQLException;\nimport java.util.List;\nimport java.util.Optional;\nimport java.util.concurrent.ConcurrentHashMap;\nimport java.util.concurrent.CopyOnWriteArrayList;\nimport java.util.function.Supplier;\nimport java.util.stream.Stream;\n\npublic class EclipseInference {\n\n    private final List<RowMapperFactory> rowFactories = new CopyOnWriteArrayList<>();\n    private final ConcurrentHashMap<Type, RowMapper<?>> rowCache = new ConcurrentHashMap<>();\n\n    @SuppressWarnings(\"unchecked\")\n    public Optional<RowMapper<?>> findRowMapperFor(Type type) {\n        return Optional.ofNullable(rowCache.computeIfAbsent(type, t ->\n                findFirstPresent(\n                        () -> rowFactories.stream()\n                                .flatMap(factory -> toStream(factory.build(t)))\n                                .findFirst(),\n                        () -> findColumnMapperFor(t)\n                                .map(c -> new SingleColumnMapper<>(c)))\n                        .orElse(null)));\n    }\n\n    private Optional<ColumnMapper<?>> findColumnMapperFor(Type t) {\n        return Optional.empty();\n    }\n\n    @SafeVarargs\n    static <T> Optional<T> findFirstPresent(Supplier<Optional<T>>... suppliers) {\n        return Stream.of(suppliers)\n                .flatMap(supplier -> toStream(supplier.get()))\n                .findFirst();\n    }\n    static <T> Stream<T> toStream(Optional<T> optional) {\n        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();\n    }\n}\n\nclass SingleColumnMapper<T> implements RowMapper<T> {\n    SingleColumnMapper(ColumnMapper<T> mapper) {\n    }\n    @Override\n    public T map(ResultSet r) {\n        return null;\n    }\n}\n\n@FunctionalInterface\ninterface RowMapper<T>\n{\n    T map(ResultSet r);\n}\n\n@FunctionalInterface\ninterface ColumnMapper<T>\n{\n    T map(ResultSet r, int columnNumber) throws SQLException;\n}\n\n@FunctionalInterface\ninterface RowMapperFactory\n{\n    Optional<RowMapper<?>> build(Type type);\n}\n\n@FunctionalInterface\ninterface ColumnMapperFactory\n{\n    Optional<ColumnMapper<?>> build(Type type);\n}\n"});
    }

    public void testBug496942() {
        this.runConformTest(new String[]{"ProductManager.java", "import java.util.Set;\nimport java.util.concurrent.Callable;\nimport java.util.function.Function;\nimport java.util.stream.Stream;\n\nclass Product { }\nclass ItineraryDTO { }\nclass Result<K, V> {\n    public static <T, U> Function<T, ListenableFuture<Result<T, U>>> \n    \t\tasyncCall(Function<T, ListenableFuture<U>> asyncMethod)\n    {\n    \treturn null;\n    }\n}\ninterface ListeningExecutorService {\n\t<T> ListenableFuture<T> submit(Callable<T> c);\n\tListenableFuture<?> submit(Runnable r);\n}\ninterface ListenableFuture<T> {}\n\npublic class ProductManager {\n\tpublic Stream<ListenableFuture<Result<Product, ItineraryDTO>>> \n\t\t\ttest(ListeningExecutorService executor, Set<Product> productsSet)\n\t{\n         return productsSet.stream().map(Result.asyncCall(product ->\n                    executor.submit(() -> new ItineraryDTO()\n                )));\n\t}\n}\n"});
    }

    public void testBug496574() {
        this.runConformTest(new String[]{"EclipseNeonBug.java", "import java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Optional;\nimport java.util.stream.Collectors;\n\npublic class EclipseNeonBug {\n\n\tpublic static void main(String[] args) {\n\t\tList<KeyValueObj> keyValObjs = new ArrayList<>();\n\t\tMap<String, String> mses = Optional.ofNullable(keyValObjs)\n                .filter(ms -> !ms.isEmpty())\n                .map(ms -> ms.stream().collect(Collectors.toMap(\n                    metafield -> metafield.getKey(),\n                    metafield -> metafield.getValue())))\n                .orElseGet(() -> Collections.emptyMap());\n\t}\n\n\tpublic static class KeyValueObj {\n\t\tprivate String key;\n\t\tprivate String value;\n\n\t    public String getKey() {\n\t        return key;\n\t    }\n\n\t    public void setKey(String key) {\n\t        this.key = key;\n\t    }\n\n\t    public String getValue() {\n\t        return value;\n\t    }\n\n\t    public void setValue(String value) {\n\t        this.value = value;\n\t    }\n\t}\n}\n"});
    }

    public void testBug496574_small() {
        this.runConformTest(new String[]{"Small.java", "import java.util.*;\nimport java.util.stream.*;\n\ninterface KeyValueObj {\n    String getKey();\n    String getValue();\n}\n\npublic class Small {\n\n\tpublic void test(Optional<List<KeyValueObj>> optList) {\n\t\tOptional<Map<String, String>> mses = optList\n                .map(ms -> ms.stream().collect(Collectors.toMap(\n                    metafield -> metafield.getKey(),\n                    metafield -> metafield.getValue())));\n\t}\n}\n"});
    }

    public void testBug496579() {
        this.runConformTest(new String[]{"EclipseNeonBug2.java", "import java.util.HashMap;\nimport java.util.Map;\nimport java.util.stream.Collectors;\n\npublic class EclipseNeonBug2 {\n\n\tpublic static void main(String[] args) {\n\t\tMap<String, Map<String, Object>> stuff = new HashMap<>();\n\t\tMap<String, Map<String, Integer>> result = stuff.entrySet().stream()\n\t\t\t.collect(Collectors.toMap(\n\t\t\t\t\tk -> k.getKey(), \n\t\t\t\t\to -> {\n\t\t\t\t\t\tMap<String, Object> child = o.getValue();\n\t\t\t\t\t\treturn child.entrySet().stream().collect(Collectors.toMap(\n\t\t\t\t\t\t\t\tk -> k.getKey(), \n\t\t\t\t\t\t\t\tv -> Integer.parseInt(v.getValue().toString())));\n\t\t\t\t\t}));\n\t}\n\t\n}\n"});
    }

    public void testBug496761() {
        this.runConformTest(new String[]{"RepoCase.java", "import java.util.HashMap;\nimport java.util.Map;\nimport java.util.Map.Entry;\nimport java.util.Optional;\nimport java.util.function.Supplier;\nimport java.util.stream.Collectors;\n\npublic class RepoCase {\n\tprivate Map<String, Supplier<?>> dependencyMap = new HashMap<>();\n\t\n\tvoid compilerNPE() {\n// Leads to NPE in compiler\n\t\tMap<String, Object> map = Optional.ofNullable(this.dependencyMap)\n\t\t\t\t.map(m -> m.entrySet().stream().collect(Collectors.toMap(Entry::getKey, e -> (Object) e.getValue().get())))\n\t\t\t\t.orElse(new HashMap<>());\n\t\t\n// Compiler error (might be the real cause for the above NPE)\t\t\n\t\tOptional<Map<String, Object>> o = Optional.ofNullable(this.dependencyMap)\n\t\t\t.map(m -> m.entrySet().stream().collect(Collectors.toMap(Entry::getKey, e -> (Object) e.getValue().get())));\n\t}\n}\n"});
    }

    public void testBug496624() {
        this.runConformTest(new String[]{"JDTNPETest.java", "import java.util.*;\nimport java.util.stream.Collectors;\n\ninterface HttpSession{\n  Enumeration<String> getAttributeNames();\n  Object getAttribute(String name);\n}\npublic class JDTNPETest {\n    \n    public static void main(String[] args){\n        Map<String, Object> sessionAttributes = Optional.<HttpSession>ofNullable(null)\n            .map(s -> Collections.list(s.getAttributeNames()).stream()\n                .collect(Collectors.toMap(name -> name, name -> s.getAttribute(name))))\n            .orElse(null);\n    }\n\n}\n"});
    }

    public void testBug497193() {
        this.runConformTest(new String[]{"EclipseBug.java", "import java.util.function.Function;\n\npublic class EclipseBug {\n    public static class Class1<K, V > {\n        public Class1( Function<K, V > arg ) {}\n    }\n\n    public static <T, R> R method1( T object, Function<T, R > function ) {\n        return null;\n    }\n\n    public static class Class2 {\n        public static Class2 method1( String arg ) {\n            return null;\n        }\n\n        String method2() {\n            return null;\n        }\n    }\n\n    private final Class1<String, String > member = new Class1<>( arg -> method1( Class2.method1( arg ), class2 -> class2.method2() ) );\n}\n"});
    }

    public void testBug496578() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.BinaryOperator;\nimport java.util.function.Function;\n\npublic class Test {\n\tprivate Long[] v, v_small;\n\tpublic Long method(String[] args) {\n\t\tExecPushFactory alg = new ExecPushFactory();\n        Long value = Id.prj(\n                alg.reduce(0L, Long::sum,\n                        alg.flatMap(x ->\n                                        alg.map(y -> x * y,\n                                                alg.source(v_small)),\n                                alg.source(v)))).value;\n        return value;\n\t}\n}\nclass ExecPushFactory {\n\tpublic <T, R> App<Id.t, R> flatMap(Function<T, App<Id.t, R>> mapper, App<Id.t, T> app) {\n        return null;\n    }\n\tpublic <T> App<Id.t, T> source(T[] array) {\n        return null;\n    }\n\tpublic <T, R> App<Id.t, R> map(Function<T, R> mapper, App<Id.t, T> app) {\n        return null;\n    }\n    public <T> App<Id.t, T> reduce(T identity, BinaryOperator<T> accumulator, App<Id.t, T> app) {\n    \treturn null;\n    }\n}\nclass Id<T> implements App<Id.t, T>{\n   public T value;\n\tpublic static class t {\n\t\t\n\t}\n\tpublic static <A> Id<A> prj(App<Id.t, A> app) {\n        return (Id<A>) app;\n    }\n}\ninterface App<C, T> {\n\t\n}\n"});
    }

    public void testBug496675() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n    public class B<X, Y> {\n        public class C {}\n    }\n    public class D<X> extends B<String, X> {}\n\t\n    /* This fails with an internal ArrayIndexOutOfBoundsException in \n     * ParameterizedTypeBinding.boundCheck. */\n    public class E<X extends D<?>.C> {}\n}\n"});
    }

    public void testBug496675_comment4() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n    public class B<X, Y> {\n        public class C {}\n    }\n    public class D<X extends Number> extends B<String, X> {}\n\t\n    /* This fails with an internal ArrayIndexOutOfBoundsException in \n     * ParameterizedTypeBinding.boundCheck. */\n    public class E<X extends D<String>.C> {}\n}\n"}, "----------\n1. ERROR in Test.java (at line 9)\n\tpublic class E<X extends D<String>.C> {}\n\t                           ^^^^^^\nBound mismatch: The type String is not a valid substitute for the bounded parameter <X extends Number> of the type Test.D<X>\n----------\n");
    }

    public void testBug496675_problem() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n    <X extends wrong.D<?>.C> void m() {}\n}\n"}, "----------\n1. ERROR in Test.java (at line 2)\n\t<X extends wrong.D<?>.C> void m() {}\n\t           ^^^^^\nwrong cannot be resolved to a type\n----------\n");
    }

    public void testBug496886() {
        this.runConformTest(new String[]{"Outer.java", "public interface Outer<E> {\n  public interface Inner<E> {\n  }\n}\n", "SubInterface.java", "public interface SubInterface extends Outer<String> {}\n"});
        this.runConformTest(new String[]{"ProblemClass.java", "class ProblemClass implements SubInterface.Inner<String> {}\n"}, "", null, false, null);
    }

    public void testBug497603() {
        this.runConformTest(new String[]{"InferBug.java", "import java.util.Iterator;\nimport java.util.Map.Entry;\nimport java.util.function.BiPredicate;\nimport java.util.function.Function;\n\npublic class InferBug {\n    public static void main(String[] args) {\n        Iterator<Iterator<Entry<String, String>>> x = null;\n        Iterator<Iterator<String>> p = foo(x, i -> foo(i, Entry::getValue));\n    }\n    static <F, T> Iterator<T> foo(Iterator<F> a, Function<F, T> b) {\n        return null;\n    }\n}\n"});
    }

    public void testBug498113a() {
        this.runConformTest(new String[]{"NPETest.java", "import java.util.*;\npublic class NPETest {\n\n    public void test(\n            final Set<String> set,\n            final List<Dummy<String>> dummies) {\n        set.stream()\n            .map(Dummy::new)\n            .forEach(dummies::add);\n    }\n    \n    class Dummy<T> {\n        \n        public Dummy(T... args) {\n            \n        }\n    }\n}\n"});
    }

    public void testBug498113b() {
        this.runConformTest(new String[]{"NPETest.java", "import java.util.*;\npublic class NPETest {\n\n    public void test(\n            final Set<String[]> set,\n            final List<Dummy<String>> dummies) {\n        set.stream()\n            .map(Dummy::new)\n            .forEach(dummies::add);\n    }\n    \n    class Dummy<T> {\n        \n        public Dummy(T... args) {\n            \n        }\n    }\n}\n"});
    }

    public void testBug498362_comment0() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tstatic final byte[] EMPTY_BYTE_ARRAY = new byte[0];\n\tprivate byte[] stream;\n\tvoid test() {\n\t\tthis.stream = Optional.ofNullable(stream)\n            .map(byte[]::clone)\n            .orElse(EMPTY_BYTE_ARRAY);\t}\n}\n"});
    }

    public void testBug498362_comment5() {
        this.runConformTest(new String[]{"CloneVerifyError.java", "public class CloneVerifyError {\n    public interface PublicCloneable<T> extends Cloneable {\n        public T clone();\n    }\n\n    public static <T> T[] clone0(T[] input) {\n        return input == null ? null : input.clone();\n    }\n\n    public static <T extends PublicCloneable<T>> T clone0(T input) {\n        if (input == null) {\n            return null;\n        } else {\n            return input.clone();\n        }\n    }\n\n    public static void main(String[] args) {\n        Object[] array = null;\n        clone0(array);\n    }\n}\n"});
    }

    public void testBug470667() {
        this.runNegativeTest(new String[]{"Test.java", "import java.math.BigInteger;\nimport java.util.function.Function;\npublic class Test {\n\t\tprotected <T> T m(Class<T> c, String s, Function<String, T> f) {\n\t\t\treturn f.apply(s);\n\t\t}\n\t\tprotected <T> T m(Class<T> c, BigInteger i, Function<BigInteger, T> f) {\n\t\t\treturn f.apply(i);\n\t\t}\n\t\tprotected <T> Data<T> createData() {\n\t\t\treturn new Data<T>() {\n\t\t\t};\n\t\t}\n\t\tprivate <T> Data<T> doA(BigInteger i) {\n\t\t\tString str = \"titi \";\n\t\t\t@SuppressWarnings(\"unchecked\")\n\t\t\tData<T> r = m(Data.class, \"toto \",\n\t\t\t\t(x) -> m(Data.class, str, (y) -> m(Data.class, BigInteger.ZERO, (z) -> createData(i, x, y, z))));\n\t\t\treturn r;\n\t\t}\n}\ninterface Data<T> { }\n"}, "----------\n1. ERROR in Test.java (at line 18)\n\t(x) -> m(Data.class, str, (y) -> m(Data.class, BigInteger.ZERO, (z) -> createData(i, x, y, z))));\n\t                                                                       ^^^^^^^^^^\nThe method createData() in the type Test is not applicable for the arguments (BigInteger, String, String, BigInteger)\n----------\n");
    }

    public void testBug497239() {
        this.runConformTest(new String[]{"FunctionUtils.java", "import java.util.stream.Collector;\nimport java.util.stream.Collectors;\n\npublic class FunctionUtils<InputElement, ResultElement> {\n\tpublic static <T> T[] concat(T[] array1, T[] array2) {\n\t\treturn null;\n\t}\n\n\tpublic static <T> T[] concat(T[][] arrays) {\n\t\treturn null;\n\t}\n\n\tpublic Collector<ResultElement[], ?, ResultElement[]> on(InputElement[] inputElements) {\n\t\treturn Collectors.collectingAndThen(Collectors.reducing(FunctionUtils::concat), r -> r.get());\n\t}\n}\n"});
    }

    public void testBug472851() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.*;\n\npublic class Test {\n    public static void main(String... arg) {\n    List<Integer> l1=Arrays.asList(0, 1, 2);\n    List<String>  l2=Arrays.asList(\"0\", \"1\", \"2\");\n    a(Arrays.asList(l1, l2));\n}\nstatic final void a(List<? extends List<?>> type) {\n    test(type);\n}\nstatic final <Y,L extends List<Y>> void test(List<L> type) {\n    L l1=type.get(0), l2=type.get(1);\n    l2.set(0, l1.get(0));\n}\n}\n"}, "----------\n1. ERROR in Test.java (at line 10)\n\ttest(type);\n\t^^^^\nThe method test(List<L>) in the type Test is not applicable for the arguments (List<capture#1-of ? extends List<?>>)\n----------\n");
    }

    public void testBug502350() {
        this.runNegativeTest(new String[]{"makeCompilerFreeze/EclipseJava8Bug.java", "package makeCompilerFreeze;\n\ninterface Comparable<E> {} \n\ninterface Comparator<A> {\n  public static <B extends Comparable<B>> Comparator<B> naturalOrder() {\n    return null;\n  }\n}\n\n\nclass Stuff {\n  public static <T, S extends T> Object func(Comparator<T> comparator) {\n    return null;\n  }\n}\n\npublic class EclipseJava8Bug {\n  static final Object BORKED =\n      Stuff.func(Comparator.naturalOrder());\n}\n\n"}, "----------\n1. ERROR in makeCompilerFreeze\\EclipseJava8Bug.java (at line 20)\n\tStuff.func(Comparator.naturalOrder());\n\t      ^^^^\nThe method func(Comparator<T>) in the type Stuff is not applicable for the arguments (Comparator<Comparable<Comparable<B>>>)\n----------\n2. ERROR in makeCompilerFreeze\\EclipseJava8Bug.java (at line 20)\n\tStuff.func(Comparator.naturalOrder());\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Comparator<Comparable<Comparable<B>>> to Comparator<T>\n----------\n");
    }

    public void testBug499351() {
        this.runConformTest(new String[]{"Bug.java", "import java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Set;\nimport java.util.stream.Collectors;\n\npublic class Bug {\n    private static final Validator VALIDATOR = new Validator();\n\n    public static void main(String[] args) {\n        Map<String, List<Promotion>> promotions = new HashMap<>();\n\n        Set<ConstraintViolation> cvs = promotions.entrySet().stream()\n            .flatMap(e -> e.getValue().stream()\n                .flatMap(promotion -> VALIDATOR.validate(promotion).stream())\n            )\n            .collect(Collectors.toSet());\n\n        Set<ExtendedConstraintViolation> ecvs = promotions.entrySet().stream()\n                .flatMap(e -> e.getValue().stream()\n                    .map(constraintViolation -> new ExtendedConstraintViolation(\"\", null))\n                )\n                .collect(Collectors.toSet());\n\n        Set<ExtendedConstraintViolation> ecvs2 = promotions.entrySet().stream()\n                .flatMap(e -> e.getValue().stream())\n                .flatMap(promotion -> VALIDATOR.validate(promotion).stream())\n                .map(constraintViolation -> new ExtendedConstraintViolation(\"promotions/2\", constraintViolation))\n                .collect(Collectors.toSet());\n\n        // Below does not compile with 4.7M1, but worked fine in 4.5 (also compiles fine with Oracle/JDK8)\n        //\n        // --> Type mismatch: cannot convert from Set<Object> to Set<Bug.ExtendedConstraintViolation>\n        //\n        Set<ExtendedConstraintViolation> ecvs3 = promotions.entrySet().stream()\n                .flatMap(e -> e.getValue().stream()\n                    .flatMap(promotion -> VALIDATOR.validate(promotion).stream()\n                        .map(constraintViolation -> new ExtendedConstraintViolation(\"promotions/\" + e.getKey(), constraintViolation))\n                    )\n                )\n                .collect(Collectors.toSet());\n    }\n\n    private static class ExtendedConstraintViolation {\n        public ExtendedConstraintViolation(String key, ConstraintViolation cv) {\n        }\n    }\n\n    private static class ConstraintViolation {\n    }\n\n    private static class Promotion {\n    }\n\n    private static class Validator {\n        public Set<ConstraintViolation> validate(Object o) {\n            return null;\n        }\n    }\n}\n"});
    }

    public void _testBug499351_small() {
        this.runConformTest(new String[]{"Small.java", "import java.util.*;\nimport java.util.stream.Collectors;\n\npublic class Small {\n\n    public static void test(Map<String, List<Promotion>> promotions, Validator validator) {\n\n        Set<ExtendedConstraintViolation> ecvs = promotions.entrySet().stream()\n                .flatMap(e -> e.getValue().stream()\n                    .flatMap(promotion -> validator.validate(promotion).stream()\n                        .map(constraintViolation -> new ExtendedConstraintViolation(\"promotions/\" + e.getKey(), constraintViolation))\n                    )\n                )\n                .collect(Collectors.toSet());\n    }\n\n}\nclass ExtendedConstraintViolation {\n    public ExtendedConstraintViolation(String key, ConstraintViolation cv) { }\n}\n\nclass ConstraintViolation { }\nclass Promotion { }\nclass Validator {\n    public Set<ConstraintViolation> validate(Object o) { return null; }\n}\n"});
    }

    public void test499351_extra1() {
        this.runConformTest(new String[]{"Example.java", "import java.util.function.Function;\n\npublic class Example {\n   static <T> T id(T t) { return t; }\n   static <T,X> T f1 (X x) { return null; }\n   \n   String test() {\n\t   return f3(y -> y.f2(Example::f1, id(y)));\n   }\n   <U,V> V f2(Function<U, V> f, U u) {return f.apply(null);}\n   <R> R f3(Function<Example,R> f) { return null; }\n}\n"});
    }

    public void test499351_extra2() {
        this.runConformTest(new String[]{"BadInferenceMars451.java", "import java.util.*;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\npublic class BadInferenceMars451 {\n\tpublic static Map<Object, List<X>> BadInferenceMars451Casus1() {\n\t\tList<X> stuff = new ArrayList<>();\n\t\treturn stuff.stream().collect(Collectors.toMap(Function.identity(), t -> Arrays.asList(t), BadInferenceMars451::sum));\n\t}\n\tpublic static <T> List<T> sum(List<T> l1, List<T> l2) {\n\t\treturn null;\n\t}\n\tpublic static class X {\n\t}\n}"});
    }

    public void testBug501949() {
        this.runConformTest(new String[]{"DefaultClientRequestsV2.java", "import java.io.IOException;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.function.Supplier;\n\n\ninterface Flux<T> extends Publisher<T> {\n\t<R> Flux<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> f);\n\t<V> Flux<V> map(Function<T,V> mapper);\n\tMono<List<T>> collectList();\n}\nabstract class Mono<T> implements Publisher<T> {\n\tabstract T block();\n\tabstract <R> Flux<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> f);\n}\ninterface Publisher<T> {}\ninterface CloudFoundryOperations {\n\tFlux<SpaceSummary> list();\n}\nclass SpaceSummary { }\nclass OrganizationSummary {\n\tString getId() { return \"\"; }\n}\ninterface CFSpace {}\npublic class DefaultClientRequestsV2 {\n\n\tprivate Flux<OrganizationSummary> _orglist;\n\n\tprivate Mono<CloudFoundryOperations> operationsFor(OrganizationSummary org) {\n\t\treturn null;\n\t}\n\n\tpublic List<CFSpace> getSpaces() {\n\t\treturn get(\n\t\t\t_orglist\n\t\t\t.flatMap((OrganizationSummary org) -> {\n\t\t\t\treturn operationsFor(org).flatMap((operations) ->\n\t\t\t\t\toperations\n\t\t\t\t\t.list()\n\t\t\t\t\t.map((space) -> wrap(org, space)\n\t\t\t\t\t)\n\t\t\t\t);\n\t\t\t})\n\t\t\t.collectList()\n\t\t);\n\t}\n\tpublic static <T> T get(Mono<T> mono)  {\n\t\treturn mono.block();\n\t}\n\tpublic static CFSpace wrap(OrganizationSummary org, SpaceSummary space) {\n\t\treturn null;\n\t}\n}\n"});
    }

    public void testBug502568() {
        this.runConformTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Optional;\nimport java.util.UUID;\nimport java.util.concurrent.CompletableFuture;\nimport java.util.function.Function;\n\npublic class Test {\n\tpublic static void main(String[] args) {\n\t}\n\t\n\tpublic CompletableFuture<UUID> test() {\n\t\tUUID id = UUID.randomUUID();\n\t\t\n\t\treturn transaction(conn -> {\n\t\t\treturn query().thenCompose(rs1 -> {\n\t\t\t\treturn query().thenCompose(rs2 -> {\n\t\t\t\t\treturn query();\n\t\t\t\t});\n\t\t\t});\n\t\t})\n\t\t.thenApply(rs -> id);\n\t}\n\t\n\tpublic <T> CompletableFuture<T> transaction(Function<String,CompletableFuture<T>> param1) {\n\t\treturn param1.apply(\"test\");\n\t}\n\t\n\tpublic CompletableFuture<Optional<List<String>>> query() {\n\t\treturn CompletableFuture.completedFuture(Optional.of(new ArrayList<String>()));\n\t}\n}\n"});
    }

    public void testBug499725() {
        this.runConformTest(new String[]{"Try22.java", "import java.rmi.RemoteException;\nimport java.util.Arrays;\nimport java.util.Collection;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\n\n\npublic class Try22 {\n    public static class RemoteExceptionWrapper {\n        @FunctionalInterface\n        public static interface FunctionRemote<T, R> {\n            R apply(T t) throws RemoteException;\n        }\n        \n        public static <T, R> Function<T, R> wrapFunction(FunctionRemote<T, R> f) {\n            return x -> {\n                try {\n                    return f.apply(x);\n                }\n                catch(RemoteException  e) {\n                    throw new RuntimeException(e);\n                }\n            };\n        }\n    }\n\n\n    private static class ThrowingThingy {\n        public Collection<String> listStuff(String in) throws RemoteException {\n            return Collections.emptyList();\n        }\n    }\n\n    \n    public static void main(String[] args) {\n        List<String> stagedNodes = Arrays.asList(\"a\", \"b\", \"c\");\n        ThrowingThingy remoteThing = new ThrowingThingy();  // simulation of a rmi remote, hence the exceptio\n        \n        List<String> resultingStuff = stagedNodes.stream()\n            .flatMap(RemoteExceptionWrapper.wrapFunction(\n                node -> remoteThing.listStuff(node)    // HERE\n                    .stream()\n                    .map(sub -> node + \"/\" + sub)))\n            .collect(Collectors.toList());\n        \n        System.out.println(resultingStuff);\n    }\n}\n"});
    }

    public void testBug499725a() {
        this.runConformTest(new String[]{"Try22.java", "import java.rmi.RemoteException;\nimport java.util.Arrays;\nimport java.util.Collection;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\n\n\npublic class Try22 {\n    public static class RemoteExceptionWrapper {\n        @FunctionalInterface\n        public static interface FunctionRemote<T, R> {\n            R apply(T t) throws RemoteException;\n        }\n        \n        public static <T, R> Function<T, R> wrapFunction(FunctionRemote<T, R> f) {\n            return x -> {\n                try {\n                    return f.apply(x);\n                }\n                catch(RemoteException  e) {\n                    throw new RuntimeException(e);\n                }\n            };\n        }\n    }\n\n\n    private static class ThrowingThingy {\n        public Collection<String> listStuff(String in) throws RemoteException {\n            return Collections.emptyList();\n        }\n    }\n\n    \n    public static void main(String[] args) {\n        List<String> stagedNodes = Arrays.asList(\"a\", \"b\", \"c\");\n        ThrowingThingy remoteThing = new ThrowingThingy();  // simulation of a rmi remote, hence the exceptio\n        \n        List<String> resultingStuff = stagedNodes.stream()\n            .flatMap(RemoteExceptionWrapper.wrapFunction(\n                (String node) -> remoteThing.listStuff(node)    // HERE\n                    .stream()\n                    .map(sub -> node + \"/\" + sub)))\n            .collect(Collectors.toList());\n        \n        System.out.println(resultingStuff);\n    }\n}\n"});
    }

    public void testBug508834() {
        this.runConformTest(new String[]{"FlatMapper.java", "import java.util.stream.Stream;\npublic class FlatMapper {\n\n\tprivate String[] stuff;\n\t\n\tpublic static void main(String[] args) {\n\t    Stream.of(new FlatMapper[]{})\n\t        .flatMap(fl -> Stream.of(fl.stuff)) //\n\t        .filter(st -> !st.isEmpty()); //\n\t}\n}\n"}, "");
    }

    public void testBug508834_comment0() {
        this.runConformTest(new String[]{"test/TypeB.java", "package test;\npublic class TypeB {\n    public String getText() {\n        return \"\";\n    }\n\n}\n", "test/TypeA.java", "package test;\npublic class TypeA {\n    public TypeB[] getArrayOfB() {\n        return null;\n    }\n    public TypeB getB() {\n        return null;\n    }\n}\n", "test/Test1.java", "package test;\nimport java.util.stream.Stream;\npublic class Test1 {\n    private TypeA[] arrayOfType() {\n        return null;\n    }\n    private String[] test1() {\n        return Stream\n                .of(arrayOfType())\n                .filter(a -> a.getB() != null)\n                .flatMap(a -> Stream.of(a.getB()))\n                .map(TypeB::getText)\n                .sorted()\n                .toArray(String[]::new);\n    }\n    private String[] test2() {\n        return Stream\n                .of(arrayOfType())\n                .filter(a -> a.getArrayOfB() != null)\n                .flatMap(a -> Stream.of(a.getArrayOfB()))\n                .map(TypeB::getText)\n                .sorted()\n                .toArray(String[]::new);\n    }\n}\n"}, "");
    }

    public void testBug509694() {
        this.runConformTest(new String[]{"NfaUtil.java", "/*******************************************************************************\n * Copyright (c) 2011 itemis AG (http://www.itemis.eu) and others.\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * which accompanies this distribution, and is available at\n * http://www.eclipse.org/legal/epl-v10.html\n *******************************************************************************/\nimport java.util.*;\n\nclass Lists {\n\tpublic static <E> LinkedList<E> newLinkedList() {\n\t\treturn new LinkedList<E>();\n\t}\n\n\tpublic static <E> LinkedList<E> newLinkedList(Iterable<? extends E> elements) {\n\t\treturn newLinkedList();\n\t}\n}\n\nclass Maps {\n\tpublic static <K, V> HashMap<K, V> newHashMap() {\n\t\treturn new HashMap<K, V>();\n\t}\n\n\tpublic static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {\n\t\treturn new LinkedHashMap<K, V>();\n\t}\n\n\tpublic static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<? extends K, ? extends V> map) {\n\t\treturn new LinkedHashMap<K, V>(map);\n\t}\n}\n\nclass Sets {\n\tpublic static <E> HashSet<E> newHashSet(Iterable<? extends E> elements) {\n\t\treturn new HashSet<E>();\n\t}\n\n\tpublic static <E> HashSet<E> newHashSet(E... elements) {\n\t\tHashSet<E> set = new HashSet<>();\n\t\tCollections.addAll(set, elements);\n\t\treturn set;\n\t}\n}\n\ninterface IAcceptor<T> {\n\tvoid accept(T t);\n}\n\ninterface Nfa<STATE> extends DirectedGraph<STATE> {\n\tSTATE getStop();\n\tSTATE getStart();\n}\ninterface DirectedGraph<NODE> {\n\tIterable<NODE> getFollowers(NODE state);\n}\n\n/**\n * @author Moritz Eysholdt - Initial contribution and API\n */\npublic class NfaUtil {\n\n\tpublic <S> Map<S, Set<S>> findCycles(Nfa<S> nfa) {\n\t\tMap<S, Set<S>> cycles = Maps.newLinkedHashMap();\n\t\tfindCycles(nfa, nfa.getStart(), (List<S> t) -> {\n\t\t\tSet<S> cycle = Sets.newHashSet(t);\n\t\t\tfor (S cycleNode : t) {\n\t\t\t\t// We have two cycles that are connected via at least\n\t\t\t\t// one node. Treat them as one cycle.\n\t\t\t\tSet<S> existingCycle = cycles.get(cycleNode);\n\t\t\t\tif (existingCycle != null) {\n\t\t\t\t\tcycle.addAll(existingCycle);\n\t\t\t\t}\n\t\t\t}\n\t\t\tfor (S n : cycle) {\n\t\t\t\tcycles.put(n, cycle);\n\t\t\t}\n\t\t}, Maps.newHashMap(), Lists.newLinkedList());\n\t\treturn cycles;\n\t}\n\n\tpublic <S> void findCycles(Nfa<S> nfa, IAcceptor<List<S>> cycleAcceptor) {\n\t\tfindCycles(nfa, nfa.getStart(), cycleAcceptor, Maps.newHashMap(), Lists.newLinkedList());\n\t}\n\n\tprivate static final int DFS_VISITED = 1;\n\tprivate static final int DFS_ON_STACK = 2;\n\n\tprotected <S> void findCycles(Nfa<S> nfa, S node, IAcceptor<List<S>> cycleAcceptor, Map<S, Integer> dfsMark,\n\t\t\tLinkedList<S> dfsStack) {\n\t\tdfsStack.push(node);\n\t\tdfsMark.put(node, DFS_ON_STACK);\n\t\tfor (S follower : nfa.getFollowers(node)) {\n\t\t\tInteger followerMark = dfsMark.get(follower);\n\t\t\tif (followerMark == null) {\n\t\t\t\tfindCycles(nfa, follower, cycleAcceptor, dfsMark, dfsStack);\n\t\t\t} else if (followerMark == DFS_ON_STACK) {\n\t\t\t\tLinkedList<S> cycle = Lists.newLinkedList();\n\t\t\t\tIterator<S> stackIter = dfsStack.iterator();\n\t\t\t\tS cycleNode;\n\t\t\t\tdo {\n\t\t\t\t\tcycleNode = stackIter.next();\n\t\t\t\t\tcycle.addFirst(cycleNode);\n\t\t\t\t} while (cycleNode != follower && stackIter.hasNext());\n\t\t\t\tcycleAcceptor.accept(cycle);\n\t\t\t}\n\t\t}\n\t\tdfsStack.pop();\n\t\tdfsMark.put(node, DFS_VISITED);\n\t}\n}\n"});
    }

    public void testBug479802() {
        this.runConformTest(new String[]{"CompilerBugUncheckedCast.java", "public class CompilerBugUncheckedCast {\n    public static void main(String[] args) {\n        Create(true);\n        Create(false);\n    }\n    public interface Base {\n        default String def() { return \"Base\"; }\n    }\n    public interface Intermediate extends Base {\n        @Override default String def() { return \"Intermediate\"; }\n    }\n    public interface Derived extends Intermediate { }\n    public static class MyObject implements Base { }\n    public static final class OldObject extends MyObject implements Derived { }\n    public static final class NewObject extends MyObject implements Derived { }\n    public static <OBJECT extends MyObject & Derived> void Make(OBJECT o) { }\n    public static MyObject Create(boolean old) {\n        MyObject f;\n        if (old) {\n            f = new OldObject();\n        } else {\n            f = new NewObject();\n        }\n        Make(uncheckedCast(f));\n        System.out.println(old);\n        return f;\n    }\n    @SuppressWarnings(\"unchecked\")\n    private static <T extends MyObject & Derived> T uncheckedCast(MyObject f) {\n        return (T) f;\n    }\n}"}, "true\nfalse");
    }

    public void testBug510004_a() {
        this.runConformTest(new String[]{"BrokenTypeInference.java", "import java.util.Optional;\nimport java.util.stream.Stream;\n\npublic class BrokenTypeInference {\n    public static void main(String[] args) {\n        Optional.of(\"42,43\").map(s -> Stream.of(s.split(\",\")));\n    }\n}\n"});
    }

    public void testBug510004_b() {
        this.runConformTest(new String[]{"BrokenTypeInference.java", "import java.util.List;\nimport java.util.Optional;\n\npublic class BrokenTypeInference {\n    public static void main(String[] args) {\n        Optional.of(\"42,43\").map(s -> x(s.split(\",\")));\n    }\n\n    private static <X> List<X> x(X ... xs) {\n        return java.util.Collections.emptyList();\n    }\n\n    private static <X> List<X> x(X x) {\n        return java.util.Collections.emptyList();\n    }\n}\n"});
    }

    public void testBug509324() {
        this.runConformTest(new String[]{"testgenerics/TestGenerics.java", "package testgenerics;\n\nimport java.time.Duration;\nimport java.util.function.Function;\nimport java.util.function.Supplier;\n\ninterface Publisher<T> {}\n\nabstract class Mono<T> implements Publisher<T> {\n\tpublic static <T> Mono<T> just(T data) { return null; }\n\tpublic static <T> Mono<T> empty() { return null; }\n\tpublic final <R> Mono<R> then(Function<? super T, ? extends Mono<? extends R>> transformer) {\n\t\treturn null;\n\t}\n\tpublic T block() { return null; }\n\tpublic final T block(Duration timeout) { return null; }\n}\nclass Info {\n\tpublic String getApplicationSshEndpoint() { return null; }\n}\nclass SshHost {\n\tpublic SshHost(String host, int port, String fingerPrint) { }\n}\n\npublic class TestGenerics {\n\n\tprivate Mono<Info> info = Mono.just(new Info());\n\n\tpublic static <T> T ru_get(Mono<T> mono) throws Exception {\n\t\treturn mono.block();\n\t}\n\n\tpublic SshHost getSshHost() throws Exception {\n\t\treturn ru_get(\n\t\t\tinfo.then((i) -> {\n\t\t\t\tString host = i.getApplicationSshEndpoint();\n\t\t\t\tif (host!=null) {\n\t\t\t\t\treturn Mono.just(new SshHost(host, 0, host));\n\t\t\t\t}\n\t\t\t\treturn Mono.empty();\n\t\t\t})\n\t\t);\n\t}\n}\n"});
    }

    public void testBug469014() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.stream.Stream;\n\npublic class Test {\n    public static <T> Field<T> coalesce(T value, T... values) {\n        return coalesce(field(value), fields(values));\n    }\n    public static <T> Field<T> coalesce(Field<T> field, T value) {\n        return coalesce(field, field(value));\n    }\n\n    public static <T> Field<T> coalesce(Field<T> field, Field<?>... fields) {\n        // irrelevant\n        return null;\n    }\n\n    static <T> Field<T> field(T value) {\n        return new Field<T>(value);\n    }\n\n    static <T> Field<T>[] fields(T... values) {\n        return Stream.of(values).map(Test::field).toArray(Field[]::new);\n    }\n\n    static class Field<T> {\n        public Field(T t) {\n        }\n    }\n}\n"}, "----------\n1. WARNING in Test.java (at line 4)\n\tpublic static <T> Field<T> coalesce(T value, T... values) {\n\t                                                  ^^^^^^\nType safety: Potential heap pollution via varargs parameter values\n----------\n2. ERROR in Test.java (at line 5)\n\treturn coalesce(field(value), fields(values));\n\t       ^^^^^^^^\nThe method coalesce(Test.Field<T>, Test.Field<T>[]) is ambiguous for the type Test\n----------\n3. WARNING in Test.java (at line 20)\n\tstatic <T> Field<T>[] fields(T... values) {\n\t                                  ^^^^^^\nType safety: Potential heap pollution via varargs parameter values\n----------\n4. WARNING in Test.java (at line 21)\n\treturn Stream.of(values).map(Test::field).toArray(Field[]::new);\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type Test.Field[] needs unchecked conversion to conform to Test.Field<T>[]\n----------\n");
    }

    public void testBug511876() {
        this.runConformTest(new String[]{"util/ClasspathScanner.java", "package util;\n\nimport java.io.*;\nimport java.lang.reflect.Method;\nimport java.util.*;\nimport java.util.stream.Stream;\n\nclass ClassPath {\n    public static ClassPath from(ClassLoader classloader) throws IOException {\n        return new ClassPath();\n    }\n    public Set<ClassInfo> getTopLevelClasses() {\n        return Collections.emptySet();\n    }\n}\nclass ClassInfo {\n    public Class<?> load() { return null; }\n    public String getPackageName() { return \"\"; }\n}\n\n/**\n * @see https://blog.jooq.org/2016/04/21/the-parameterless-generic-method-antipattern/\n */\npublic class ClasspathScanner {\n    /**\n     * This will produce all the generic, parameterless methods on your class path.\n     */\n    public static void main(String[] args) throws Exception {\n        ClassPath.from(Thread.currentThread().getContextClassLoader())\n                .getTopLevelClasses()\n                .stream()\n                .filter(info -> !info.getPackageName().startsWith(\"akka\") && !info.getPackageName().startsWith(\"scala\") && !info.getPackageName().startsWith(\"java\"))\n                .flatMap(info -> {\n                    try {\n                        return Stream.of(info.load());\n                    }\n                    catch (Throwable ignore) {\n                        return Stream.empty();\n                    }\n                }).flatMap(c -> {\n                    try {\n                        return Stream.of(c.getMethods());\n                    }\n                    catch (Throwable ignore) {\n                        return Stream.<Method> of();\n                    }\n                })\n                .filter(m -> m.getTypeParameters().length > 0 && m.getParameterCount() == 0)\n                .sorted(Comparator.comparing(Method::toString))\n                .map(Method::toGenericString)\n                .forEach(System.out::println);\n    }\n}\n"});
    }

    public void testBug510111() {
        this.runConformTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\nimport java.util.List;\n\npublic class Test {\n\n        public static final class Entity {\n\n                public int getIndex() {\n                        return 1;\n                }\n        }\n\n        public static void main(String[] args) {\n\n                final List<Entity> list = new ArrayList<>();\n                // Eclipse fails to compile the next line with error\n                // Type mismatch: cannot convert from int to Comparable<? super Comparable<? super U>>\n                Collections.sort( list , Comparator.comparing( a -> a.getIndex() ) ); \n        }\n}"});
    }

    public void testBug511750() {
        this.runConformTest(new String[]{"SomeClass.java", "import java.util.Collections;\nimport java.util.Set;\nimport java.util.stream.Collectors;\n\npublic class SomeClass {\n\n    public static void main(String[] args) {\n        System.out.println(foo().iterator().next().getBaz());\n    }\n\n    public interface Baz {\n        public String getBaz();\n    }\n\n    public static Set<Baz> foo() {\n        Set<String> stringSet = Collections.singleton(\"someString\");\n        return stringSet.stream().map(s -> new Baz() {\n\n            @Override\n            public String getBaz() {\n                return s;\n            }\n\n        }).collect(Collectors.toSet());\n    }\n}\n"});
    }

    public void testBug511071() {
        this.runNegativeTest(new String[]{"test/ATestClass.java", "package test;\n\ninterface Functional<T> {\n\tvoid test(T t);\n}\n\npublic abstract class ATestClass {\n\tabstract void f(Functional<? super ClassWithMethodWithMissingArgType> predicate);\n\n\tpublic void m() {\n\t\tf(e -> e.matches(\"\"));\n\t}\n}\n", "test/ClassWithMethodWithMissingArgType.java", "package test;\n\nimport java.util.List;\n\nimport missing.Type;\n\npublic class ClassWithMethodWithMissingArgType {\n\tpublic void matches(Type arg) {\n\t\targ.hashCode();\n\t}\n}\n"}, "----------\n1. ERROR in test\\ATestClass.java (at line 11)\n\tf(e -> e.matches(\"\"));\n\t         ^^^^^^^\nThe method matches(Type) from the type ClassWithMethodWithMissingArgType refers to the missing type Type\n----------\n----------\n1. ERROR in test\\ClassWithMethodWithMissingArgType.java (at line 5)\n\timport missing.Type;\n\t       ^^^^^^^\nThe import missing cannot be resolved\n----------\n2. ERROR in test\\ClassWithMethodWithMissingArgType.java (at line 8)\n\tpublic void matches(Type arg) {\n\t                    ^^^^\nType cannot be resolved to a type\n----------\n");
    }

    public void testBug511252orig() {
        this.runConformTest(new String[]{"ConfigurationServiceLocator.java", "import java.util.*;\nimport java.util.function.*;\nimport java.util.concurrent.*;\nimport java.net.URI;\npublic class ConfigurationServiceLocator {\n\n  private final Map<String, URI> services = new HashMap<>();\n\n  public <T> CompletionStage<Optional<T>> doWithService(String name, Function<URI, CompletionStage<T>> block) {\n      return Optional.ofNullable(services.get(name))\n              .map(block.andThen(cs -> cs.thenApply(Optional::ofNullable)))\n              .orElse(CompletableFuture.completedFuture(Optional.empty()));\n  }\n\n}\n"});
    }

    public void testBug511252simplified() {
        this.runConformTest(new String[]{"ConfigurationServiceLocator.java", "import java.util.*;\nimport java.util.function.*;\nimport java.util.concurrent.*;\nimport java.net.URI;\npublic class ConfigurationServiceLocator {\n\n  public <T> CompletionStage<Optional<T>> doWithService(Optional<URI> uriopt, Function<URI, CompletionStage<T>> block) {\n      return uriopt\n              .map(block.andThen(cs -> cs.thenApply(Optional::ofNullable)))\n              .orElse(CompletableFuture.completedFuture(Optional.empty()));\n  }\n\n}\n"});
    }

    public void testBug511878() {
        this.runConformTest(new String[]{"SimpleParser.java", "import java.util.function.Function;\n\n\npublic interface SimpleParser<T> {\n\n    static class Tuple<A,B> {\n    }\n    \n    /** the type of the functional interface: Parser<T> :: CharSequence -> Tuple<T, CharSequence>> */\n    abstract Tuple<T, CharSequence> parse(CharSequence cs);\n    \n    default <V> SimpleParser<V> andThenBinding(Function<? super T, SimpleParser<V>> f) {\n        return null;\n    }\n\n    default <W> SimpleParser<W> andThen(SimpleParser<W> p) {\n        return null;\n    }\n   \n    static <X> SimpleParser<X> output(X v) {\n        return null;\n    }\n    \n    static SimpleParser<String> space() {\n        return null;\n    }\n\n    static <Y> SimpleParser<Y> token(SimpleParser<Y> p) {\n        return space().andThen(p.andThenBinding(v -> space().andThen(output(v))));\n    }\n\n}\n"});
    }

    public void testBug506021() {
        this.runConformTest(new String[]{"test/__.java", "package test;\n\ninterface Result {}\n\ninterface Property<V> {}\n\ninterface GraphTraversal<E> {}\n\npublic class __ {\n\tpublic static <E> GraphTraversal<? extends Property<E>> properties2() {\n\t\treturn null;\n\t}\n\tpublic static GraphTraversal<? extends Property<Result>> properties() {\n\t\treturn properties2();\n\t}\n}\n"});
    }

    public void testBug506022() {
        this.runConformTest(new String[]{"test2/Test2.java", "package test2;\n\nabstract class OutputFormat {\n\tpublic abstract int getOutputCommitter();\n}\n\npublic abstract class Test2 {\n\tpublic static <T> T newInstance(Class<T> theClass) {\n\t\treturn null;\n\t}\n\n\tabstract <U> Class<? extends U> getClass(Class<U> xface);\n\n\tint f() {\n\t\treturn newInstance(getClass(OutputFormat.class)).getOutputCommitter();\n\t}\n}\n"});
    }

    public void testBug506022b() {
        this.runNegativeTest(new String[]{"test/Test.java", "package test;\n\ninterface Iterator<A> {\n}\n\ninterface Function<B, C> {\n\tC applyTo(B b);\n}\n\ninterface Property<D> {\n}\n\nclass ComputerProperty<E> implements Property<E> {\n\tpublic ComputerProperty(final Property<E> property) {\n\t}\n}\n\npublic abstract class Test {\n\tpublic abstract <F, G> Iterator<G> map(final Iterator<F> iterator, final Function<F, G> function);\n\n\tpublic abstract <H> Iterator<? extends Property<H>> properties();\n\n\tpublic <I> Iterator<Property<I>> test() {\n\t\treturn map(this.properties(), property -> new ComputerProperty(property));\n\t}\n}\n"}, "----------\n1. WARNING in test\\Test.java (at line 24)\n\treturn map(this.properties(), property -> new ComputerProperty(property));\n\t                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The constructor ComputerProperty(Property) belongs to the raw type ComputerProperty. References to generic type ComputerProperty<E> should be parameterized\n----------\n2. WARNING in test\\Test.java (at line 24)\n\treturn map(this.properties(), property -> new ComputerProperty(property));\n\t                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The expression of type ComputerProperty needs unchecked conversion to conform to Property<I>\n----------\n3. WARNING in test\\Test.java (at line 24)\n\treturn map(this.properties(), property -> new ComputerProperty(property));\n\t                                              ^^^^^^^^^^^^^^^^\nComputerProperty is a raw type. References to generic type ComputerProperty<E> should be parameterized\n----------\n");
    }

    public void testBug514884() {
        this.runConformTest(new String[]{"Minimal.java", "import java.io.*;\npublic class Minimal {\n    public void iCrash() throws IOException {\n        try (Closeable o = consumes(sneaky()::withVarargs)) {\n        }\n    }\n\n    private Minimal sneaky() { return this; }\n\n    private void withVarargs(String... test) {}\n\n    private Closeable consumes(Runnable r) { return null; }\n}\n"});
    }

    public void testBug494733_comment0() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n\tpublic static void main(String[] args) {\n        List<Integer> integerList = new ArrayList<>();\n        Set<List<Number>> numbetListSet = Collections.singleton(toWildcardGeneric(integerList));\n        numbetListSet.iterator().next().add(new Float(1.0));\n        Integer i = integerList.get(0); // Throws ClassCastException\n    }\n    \n    static <T> List<? extends T> toWildcardGeneric(List<T> l) {\n        return l;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tSet<List<Number>> numbetListSet = Collections.singleton(toWildcardGeneric(integerList));\n\t                                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Set<List<Integer>> to Set<List<Number>>\n----------\n");
    }

    public void testBug494733_comment1() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X {\npublic static void main(String[] args) {\n    List<Integer> integerList = new ArrayList<>();\n    List<Object> objectList = id(toWildcardGeneric(integerList));\n    objectList.add(\"Woo?\");\n    Integer i = integerList.get(0);\n}\n\nstatic <T> T id(T o) {\n    return o;\n}\n\nstatic <T> List<? extends T> toWildcardGeneric(List<T> l) {\n    return l;\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tList<Object> objectList = id(toWildcardGeneric(integerList));\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from List<Integer> to List<Object>\n----------\n");
    }

    public void test483952_bare() {
        this.runNegativeTest(new String[]{"test/Test.java", "package test;\nimport java.util.function.Function;\npublic class Test {\n\tvoid test1() {\n\t\tFunction function = x -> x;\n\t\tString [] z = test2(function, \"\");\n\t}\n\t<T> T [] test2(Function<T, T> function, T t) {\n\t\treturn null;\n\t}\n}"}, "----------\n1. WARNING in test\\Test.java (at line 5)\n\tFunction function = x -> x;\n\t^^^^^^^^\nFunction is a raw type. References to generic type Function<T,R> should be parameterized\n----------\n2. WARNING in test\\Test.java (at line 6)\n\tString [] z = test2(function, \"\");\n\t              ^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation test2(Function, String) of the generic method test2(Function<T,T>, T) of type Test\n----------\n3. WARNING in test\\Test.java (at line 6)\n\tString [] z = test2(function, \"\");\n\t                    ^^^^^^^^\nType safety: The expression of type Function needs unchecked conversion to conform to Function<String,String>\n----------\n");
    }
}

