/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class InnerClass15Test
extends AbstractRegressionTest {
    public InnerClass15Test(String name) {
        super(name);
    }

    public static Test suite() {
        return InnerClass15Test.buildMinimalComplianceTestSuite(InnerClass15Test.testClass(), 4);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        return options;
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\t<X> void foo() {\n\t\tclass X {}\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 2)\n\t<X> void foo() {\n\t ^\nThe type parameter X is hiding the type X\n----------\n2. WARNING in X.java (at line 3)\n\tclass X {}\n\t      ^\nThe nested type X is hiding the type parameter X of the generic method foo() of type X\n----------\n3. ERROR in X.java (at line 3)\n\tclass X {}\n\t      ^\nThe nested type X cannot hide an enclosing type\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "class X<X> {\n\tvoid foo() {\n\t\tclass X {}\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 1)\n\tclass X<X> {\n\t        ^\nThe type parameter X is hiding the type X<X>\n----------\n2. WARNING in X.java (at line 3)\n\tclass X {}\n\t      ^\nThe nested type X is hiding the type parameter X of type X<X>\n----------\n3. ERROR in X.java (at line 3)\n\tclass X {}\n\t      ^\nThe nested type X cannot hide an enclosing type\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"Y.java", "class Y {\nclass X {}\n\t<X> void foo() {\n\t\tclass X {}\n\t}\n}"}, "----------\n1. WARNING in Y.java (at line 3)\n\t<X> void foo() {\n\t ^\nThe type parameter X is hiding the type Y.X\n----------\n2. WARNING in Y.java (at line 4)\n\tclass X {}\n\t      ^\nThe nested type X is hiding the type parameter X of the generic method foo() of type Y\n----------\n3. WARNING in Y.java (at line 4)\n\tclass X {}\n\t      ^\nThe type X is never used locally\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"Y.java", "class Y {\nclass X {}\n   void foo() {\n\t\tclass X {}\n\t}\n}"}, "----------\n1. WARNING in Y.java (at line 4)\n\tclass X {}\n\t      ^\nThe type X is hiding the type Y.X\n----------\n2. WARNING in Y.java (at line 4)\n\tclass X {}\n\t      ^\nThe type X is never used locally\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"p1/GreenBox.java", "package p1;\nimport static p1.BrownBox.*;\npublic interface GreenBox {\n    public static class Cat extends Object {}\n}\n", "p1/BrownBox.java", "package p1;\nimport static p1.GreenBox.*;\npublic interface BrownBox {\n    public static class BlackCat extends Cat {}\n}\n"}, "----------\n1. WARNING in p1\\GreenBox.java (at line 2)\n\timport static p1.BrownBox.*;\n\t              ^^^^^^^^^^^\nThe import p1.BrownBox is never used\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"p1/BrownBox.java", "package p1;\nimport static p1.GreenBox.*;\npublic interface BrownBox {\n    public static class BlackCat extends Cat {}\n}\n", "p1/GreenBox.java", "package p1;\nimport static p1.BrownBox.*;\npublic interface GreenBox {\n    public static class Cat extends Object {}\n}\n"}, "----------\n1. WARNING in p1\\GreenBox.java (at line 2)\n\timport static p1.BrownBox.*;\n\t              ^^^^^^^^^^^\nThe import p1.BrownBox is never used\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"p1/BrownBox.java", "package p1;\nimport static p1.GreenBox.*;\npublic interface BrownBox {\n    public static class BlackCat extends Cat {}\n}\n", "p1/GreenBox.java", "package p1;\nimport static p1.BrownBox.*;\npublic interface GreenBox {\n    public static class Cat extends java.lang.Object {}\n}\n"}, "----------\n1. WARNING in p1\\GreenBox.java (at line 2)\n\timport static p1.BrownBox.*;\n\t              ^^^^^^^^^^^\nThe import p1.BrownBox is never used\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"p1/BrownBox.java", "package p1;\nimport static p1.GreenBox.*;\npublic interface BrownBox {\n    public static class BlackCat extends Cat {}\n}\n", "p1/GreenBox.java", "package p1;\nimport static p1.BrownBox.*;\npublic interface GreenBox {\n    public static class Cat extends BlackCat {}\n}\n"}, "----------\n1. ERROR in p1\\BrownBox.java (at line 4)\n\tpublic static class BlackCat extends Cat {}\n\t                    ^^^^^^^^\nThe hierarchy of the type BlackCat is inconsistent\n----------\n----------\n1. ERROR in p1\\GreenBox.java (at line 4)\n\tpublic static class Cat extends BlackCat {}\n\t                                ^^^^^^^^\nCycle detected: a cycle exists in the type hierarchy between GreenBox.Cat and BrownBox.BlackCat\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"p1/GreenBox.java", "package p1;\nimport static p1.BrownBox.*;\npublic interface GreenBox {\n    public static class Cat extends BlackCat {}\n}\n", "p1/BrownBox.java", "package p1;\nimport static p1.GreenBox.*;\npublic interface BrownBox {\n    public static class BlackCat extends Cat {}\n}\n"}, "----------\n1. ERROR in p1\\GreenBox.java (at line 4)\n\tpublic static class Cat extends BlackCat {}\n\t                    ^^^\nThe hierarchy of the type Cat is inconsistent\n----------\n----------\n1. ERROR in p1\\BrownBox.java (at line 4)\n\tpublic static class BlackCat extends Cat {}\n\t                                     ^^^\nCycle detected: a cycle exists in the type hierarchy between BrownBox.BlackCat and GreenBox.Cat\n----------\n");
    }

    public void test0010() {
        this.runNegativeTest(new String[]{"p1/GreenBox.java", "package p1;\nimport static p1.BrownBox.*;\ninterface SuperInterface {\n   public static class Cat extends BlackCat {}\n}\npublic interface GreenBox {\n}\n", "p1/BrownBox.java", "package p1;\nimport static p1.GreenBox.*;\npublic interface BrownBox {\n    public static class BlackCat extends Cat {}\n}\n"}, "----------\n1. ERROR in p1\\GreenBox.java (at line 4)\n\tpublic static class Cat extends BlackCat {}\n\t                    ^^^\nThe hierarchy of the type Cat is inconsistent\n----------\n----------\n1. ERROR in p1\\BrownBox.java (at line 4)\n\tpublic static class BlackCat extends Cat {}\n\t                                     ^^^\nCat cannot be resolved to a type\n----------\n");
    }

    public void test0011() {
        this.runNegativeTest(new String[]{"p1/GreenBox.java", "package p1;\nimport static p1.BrownBox.*;\ninterface SuperInterface {\n   public static class Cat extends BlackCat {}\n}\npublic interface GreenBox extends SuperInterface {\n}\n", "p1/BrownBox.java", "package p1;\nimport static p1.GreenBox.*;\npublic interface BrownBox {\n    public static class BlackCat extends Cat {}\n}\n"}, "----------\n1. ERROR in p1\\GreenBox.java (at line 4)\n\tpublic static class Cat extends BlackCat {}\n\t                    ^^^\nThe hierarchy of the type Cat is inconsistent\n----------\n----------\n1. ERROR in p1\\BrownBox.java (at line 4)\n\tpublic static class BlackCat extends Cat {}\n\t                                     ^^^\nCycle detected: a cycle exists in the type hierarchy between BrownBox.BlackCat and SuperInterface.Cat\n----------\n");
    }

    public void test0012() {
        this.runNegativeTest(new String[]{"p1/GreenBox.java", "package p1;\nimport static p1.BrownBox.*;\ninterface SuperInterface {\n   public static class Cat extends BlackCat {}\n}\npublic interface GreenBox extends SuperInterface {\n}\n", "p1/BrownBox.java", "package p1;\nimport static p1.GreenBox.*;\npublic interface BrownBox {\n    public static class BlackCat extends GreenBox.Cat {}\n}\n"}, "----------\n1. ERROR in p1\\GreenBox.java (at line 4)\n\tpublic static class Cat extends BlackCat {}\n\t                    ^^^\nThe hierarchy of the type Cat is inconsistent\n----------\n----------\n1. ERROR in p1\\BrownBox.java (at line 4)\n\tpublic static class BlackCat extends GreenBox.Cat {}\n\t                                     ^^^^^^^^^^^^\nCycle detected: a cycle exists in the type hierarchy between BrownBox.BlackCat and SuperInterface.Cat\n----------\n");
    }

    public void test0013() {
        this.runNegativeTest(new String[]{"cycle/X.java", "package cycle;\nclass X extends Y {}\nclass Y extends X {}\n"}, "----------\n1. ERROR in cycle\\X.java (at line 2)\n\tclass X extends Y {}\n\t      ^\nThe hierarchy of the type X is inconsistent\n----------\n2. ERROR in cycle\\X.java (at line 3)\n\tclass Y extends X {}\n\t                ^\nCycle detected: a cycle exists in the type hierarchy between Y and X\n----------\n");
    }

    public void test0014() {
        this.runNegativeTest(new String[]{"cycle/X.java", "package cycle;\nclass X extends Y {}\nclass Y extends Z {}\nclass Z extends A {}\nclass A extends B {}\nclass B extends C {}\nclass C extends X {}\n"}, "----------\n1. ERROR in cycle\\X.java (at line 2)\n\tclass X extends Y {}\n\t      ^\nThe hierarchy of the type X is inconsistent\n----------\n2. ERROR in cycle\\X.java (at line 3)\n\tclass Y extends Z {}\n\t      ^\nThe hierarchy of the type Y is inconsistent\n----------\n3. ERROR in cycle\\X.java (at line 4)\n\tclass Z extends A {}\n\t      ^\nThe hierarchy of the type Z is inconsistent\n----------\n4. ERROR in cycle\\X.java (at line 5)\n\tclass A extends B {}\n\t      ^\nThe hierarchy of the type A is inconsistent\n----------\n5. ERROR in cycle\\X.java (at line 6)\n\tclass B extends C {}\n\t      ^\nThe hierarchy of the type B is inconsistent\n----------\n6. ERROR in cycle\\X.java (at line 7)\n\tclass C extends X {}\n\t                ^\nCycle detected: a cycle exists in the type hierarchy between C and X\n----------\n");
    }

    public static Class testClass() {
        return InnerClass15Test.class;
    }
}

