/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.RegressionTestSetup;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.util.Util;

public class InterfaceMethodsTest
extends AbstractComparableTest {
    public static Test suite() {
        return InterfaceMethodsTest.buildMinimalComplianceTestSuite(InterfaceMethodsTest.testClass(), 32);
    }

    public static Test setUpTest(Test test) throws Exception {
        TestCase.setUpTest(test);
        RegressionTestSetup suite = new RegressionTestSetup(0x340000L);
        suite.addTest(test);
        return suite;
    }

    public static Class testClass() {
        return InterfaceMethodsTest.class;
    }

    public InterfaceMethodsTest(String name) {
        super(name);
    }

    public void testModifiers1() {
        this.runConformTest(new String[]{"I.java", "import java.lang.annotation.*;\n@Target(ElementType.METHOD) @interface Annot{}\npublic interface I {\n    default void foo1()  {}\n    public default void foo2() { System.exit(0); }\n    strictfp default void foo3() {}\n    public default strictfp void foo4() {}\n    public default strictfp @Annot void foo5() {}\n}\n"}, "");
    }

    public void testModifiers1a() {
        this.runNegativeTest(new String[]{"I.java", "import java.lang.annotation.*;\n@Target(ElementType.METHOD) @interface Annot{}\npublic interface I {\n    default void foo1()  {}\n    public default synchronized void foo2() { System.exit(0); }\n    strictfp default void foo3() {}\n    public default strictfp synchronized void foo4() {}\n    public default strictfp synchronized @Annot void foo5() {}\n}\n"}, "----------\n1. ERROR in I.java (at line 5)\n\tpublic default synchronized void foo2() { System.exit(0); }\n\t                                 ^^^^^^\nIllegal modifier for the interface method foo2; only public, abstract, default, static and strictfp are permitted\n----------\n2. ERROR in I.java (at line 7)\n\tpublic default strictfp synchronized void foo4() {}\n\t                                          ^^^^^^\nIllegal modifier for the interface method foo4; only public, abstract, default, static and strictfp are permitted\n----------\n3. ERROR in I.java (at line 8)\n\tpublic default strictfp synchronized @Annot void foo5() {}\n\t                                                 ^^^^^^\nIllegal modifier for the interface method foo5; only public, abstract, default, static and strictfp are permitted\n----------\n");
    }

    public void testModifiers1b() {
        this.runNegativeTest(new String[]{"I.java", "import java.lang.annotation.*;\n@Target(ElementType.METHOD) @interface Annot{}\npublic interface I {\n    default void foo1() { System.out.println(3); }\n    public default void foo2() {}\n    stritfp default void foo3() {}\n    default public strictfp void foo4() {}\n    public strictfp  default @Annot void foo5() {}\n    public default <T> T foo6(T t) { return t; }\n}\n"}, "----------\n1. ERROR in I.java (at line 6)\n\tstritfp default void foo3() {}\n\t^^^^^^^\nSyntax error, insert \"Identifier (\" to complete MethodHeaderName\n----------\n2. ERROR in I.java (at line 6)\n\tstritfp default void foo3() {}\n\t^^^^^^^\nSyntax error, insert \")\" to complete MethodDeclaration\n----------\n3. ERROR in I.java (at line 6)\n\tstritfp default void foo3() {}\n\t^^^^^^^\nSyntax error, insert \";\" to complete MethodDeclaration\n----------\n");
    }

    public void testModifiers2() {
        this.runNegativeTest(new String[]{"I.java", "import java.lang.annotation.*;\n@Target(ElementType.METHOD) @interface Annot{}\npublic interface I {\n    void foo1();\n    public synchronized void foo2();\n    strictfp void foo3();\n    public strictfp synchronized void foo4();\n    public strictfp synchronized @Annot void foo5();\n}\n"}, "----------\n1. ERROR in I.java (at line 5)\n\tpublic synchronized void foo2();\n\t                         ^^^^^^\nIllegal modifier for the interface method foo2; only public, abstract, default, static and strictfp are permitted\n----------\n2. ERROR in I.java (at line 6)\n\tstrictfp void foo3();\n\t              ^^^^^^\nstrictfp is not permitted for abstract interface method foo3\n----------\n3. ERROR in I.java (at line 7)\n\tpublic strictfp synchronized void foo4();\n\t                                  ^^^^^^\nstrictfp is not permitted for abstract interface method foo4\n----------\n4. ERROR in I.java (at line 7)\n\tpublic strictfp synchronized void foo4();\n\t                                  ^^^^^^\nIllegal modifier for the interface method foo4; only public, abstract, default, static and strictfp are permitted\n----------\n5. ERROR in I.java (at line 8)\n\tpublic strictfp synchronized @Annot void foo5();\n\t                                         ^^^^^^\nstrictfp is not permitted for abstract interface method foo5\n----------\n6. ERROR in I.java (at line 8)\n\tpublic strictfp synchronized @Annot void foo5();\n\t                                         ^^^^^^\nIllegal modifier for the interface method foo5; only public, abstract, default, static and strictfp are permitted\n----------\n");
    }

    public void testModifiers3() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n    native void foo1();\n    static void foo2();\n    native default void foo3() {}\n    default native void foo4() {}\n    static default void foo5() {}\n    default static void foo6() {}\n}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tnative void foo1();\n\t            ^^^^^^\nIllegal modifier for the interface method foo1; only public, abstract, default, static and strictfp are permitted\n----------\n2. ERROR in I.java (at line 3)\n\tstatic void foo2();\n\t            ^^^^^^\nThis method requires a body instead of a semicolon\n----------\n3. ERROR in I.java (at line 4)\n\tnative default void foo3() {}\n\t                    ^^^^^^\nIllegal modifier for the interface method foo3; only public, abstract, default, static and strictfp are permitted\n----------\n4. ERROR in I.java (at line 5)\n\tdefault native void foo4() {}\n\t                    ^^^^^^\nIllegal modifier for the interface method foo4; only public, abstract, default, static and strictfp are permitted\n----------\n5. ERROR in I.java (at line 6)\n\tstatic default void foo5() {}\n\t                    ^^^^^^\nIllegal combination of modifiers for the interface method foo5; only one of abstract, default, or static permitted\n----------\n6. ERROR in I.java (at line 7)\n\tdefault static void foo6() {}\n\t                    ^^^^^^\nIllegal combination of modifiers for the interface method foo6; only one of abstract, default, or static permitted\n----------\n");
    }

    public void testModifiers4() {
        this.runNegativeTest(new String[]{"I.java", "import java.lang.annotation.*;\npublic interface I {\n    abstract void foo1();\n    public abstract default void foo2() {}\n    default abstract void foo3() {}\n    void foo4() { }\n    abstract static default void foo5() {}\n}\n"}, "----------\n1. ERROR in I.java (at line 4)\n\tpublic abstract default void foo2() {}\n\t                             ^^^^^^\nIllegal combination of modifiers for the interface method foo2; only one of abstract, default, or static permitted\n----------\n2. ERROR in I.java (at line 5)\n\tdefault abstract void foo3() {}\n\t                      ^^^^^^\nIllegal combination of modifiers for the interface method foo3; only one of abstract, default, or static permitted\n----------\n3. ERROR in I.java (at line 6)\n\tvoid foo4() { }\n\t     ^^^^^^\nAbstract methods do not specify a body\n----------\n4. ERROR in I.java (at line 7)\n\tabstract static default void foo5() {}\n\t                             ^^^^^^\nIllegal combination of modifiers for the interface method foo5; only one of abstract, default, or static permitted\n----------\n");
    }

    public void testModifiers5() {
        this.runConformTest(new String[]{"C.java", "public class C implements I {\n    public static void main(String[] args) {\n        new C().foo();\n    }\n}\n", "I.java", "public interface I {\n    default void foo() {\n        System.out.println(\"default\");\n    }\n}\n"}, "default");
    }

    public void testModifiers6() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n    default void foo() {}\n    void bar();\n}\n", "C.java", "public class C implements I {}\n"}, "----------\n1. ERROR in C.java (at line 1)\n\tpublic class C implements I {}\n\t             ^\nThe type C must implement the inherited abstract method I.bar()\n----------\n");
    }

    public void testModifiers7() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n    default void foo();\n    default void bar() {}\n    default void zork() { /* nop */ }\n}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tdefault void foo();\n\t             ^^^^^\nThis method requires a body instead of a semicolon\n----------\n2. ERROR in I.java (at line 3)\n\tdefault void bar() {}\n\t                   ^^\nEmpty block should be documented\n----------\n", null, true, options);
    }

    public void testObjectMethod1() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n    public default String toString () { return \"\";}\n}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tpublic default String toString () { return \"\";}\n\t                      ^^^^^^^^^^^\nA default method cannot override a method from java.lang.Object \n----------\n");
    }

    public void testObjectMethod2() {
        this.runNegativeTest(new String[]{"I.java", "public interface I<T> {\n    public default boolean equals (T other) { return false;}\n}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tpublic default boolean equals (T other) { return false;}\n\t                       ^^^^^^^^^^^^^^^^\nName clash: The method equals(T) of type I<T> has the same erasure as equals(Object) of type Object but does not override it\n----------\n");
    }

    public void testObjectMethod3() {
        this.runNegativeTest(new String[]{"I.java", "public interface I<T> {\n    @Override\n    default public Class<?> getClass() { return null;}\n}\n"}, "----------\n1. ERROR in I.java (at line 3)\n\tdefault public Class<?> getClass() { return null;}\n\t                        ^^^^^^^^^^\nCannot override the final method from Object\n----------\n");
    }

    public void testInheritedDefaultOverrides01() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n\tString foo();\n}\n", "I2.java", "public interface I2 {\n\tdefault String foo() { return \"\"; }\n}\n", "I3.java", "public interface I3 extends I1, I2 {\n}\n"}, "----------\n1. ERROR in I3.java (at line 1)\n\tpublic interface I3 extends I1, I2 {\n\t                 ^^\nThe default method foo() inherited from I2 conflicts with another method inherited from I1\n----------\n");
    }

    public void testInheritedDefaultOverrides02() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n\tString foo();\n}\n", "I2.java", "public interface I2 {\n\tdefault String foo() { return \"\"; }\n}\n", "I1A.java", "public interface I1A extends I1 {\n}\n", "I2A.java", "public interface I2A extends I2 {\n}\n", "I3.java", "public interface I3 extends I1A, I2A {\n}\n"}, "----------\n1. ERROR in I3.java (at line 1)\n\tpublic interface I3 extends I1A, I2A {\n\t                 ^^\nThe default method foo() inherited from I2 conflicts with another method inherited from I1\n----------\n");
    }

    public void testInheritedDefaultOverrides03() {
        this.runNegativeTest(new String[]{"I1.java", "import java.util.List;\npublic interface I1 {\n\tString foo(List<String> l);\n}\n", "I2.java", "import java.util.List;\npublic interface I2 {\n   @SuppressWarnings(\"rawtypes\")\n\tdefault String foo(List l) { return \"\"; }\n}\n", "I3.java", "import java.util.List;\npublic interface I3 extends I1, I2 {\n   @Override\n   String foo(List<String> l);\n}\n"}, "----------\n1. ERROR in I3.java (at line 4)\n\tString foo(List<String> l);\n\t       ^^^^^^^^^^^^^^^^^^^\nName clash: The method foo(List<String>) of type I3 has the same erasure as foo(List) of type I2 but does not override it\n----------\n");
    }

    public void testInheritedDefaultOverrides04() {
        this.runNegativeTest(new String[]{"I1.java", "import java.util.List;\npublic interface I1 {\n\tdefault String foo(List<String> l) { return \"\"; }\n}\n", "I2.java", "import java.util.List;\npublic interface I2 {\n   @SuppressWarnings(\"rawtypes\")\n\tString foo(List l);\n}\n", "I3.java", "import java.util.List;\npublic interface I3 extends I1, I2 {\n   @Override\n   String foo(List<String> l);\n}\n"}, "----------\n1. ERROR in I3.java (at line 4)\n\tString foo(List<String> l);\n\t       ^^^^^^^^^^^^^^^^^^^\nName clash: The method foo(List<String>) of type I3 has the same erasure as foo(List) of type I2 but does not override it\n----------\n");
    }

    public void testDefaultNonclash() {
        this.runNegativeTest(new String[]{"X.java", "public interface X extends Map<String, Object> {\n   Zork z;\n}\n\ninterface Map<K,V> extends MapStream<K, V>  {\n   @Override\n\tdefault Iterable<BiValue<K, V>> asIterable() {\n\t\treturn null;\n\t}\n}\ninterface MapStream<K, V> {\n\tIterable<BiValue<K, V>> asIterable();\n}\n\ninterface BiValue<T, U> {\n    T getKey();\n    U getValue();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void testDefaultNonclash2() {
        this.runNegativeTest(new String[]{"X.java", "public interface X extends Map<String, Object> {\n   Zork z;\n}\n\ninterface Map<K,V> extends MapStream<K, V>  {\n   @Override\n\tIterable<BiValue<K, V>> asIterable();\n}\ninterface MapStream<K, V> {\n\tdefault Iterable<BiValue<K, V>> asIterable() {\n       return null;\n   }\n}\n\ninterface BiValue<T, U> {\n    T getKey();\n    U getValue();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void testDefaultNonclash3() {
        this.runNegativeTest(new String[]{"X.java", "public interface X extends Map<String, Object> {\n   Zork z;\n}\n\ninterface Map<K,V> extends MapStream<K, V>  {\n   @Override\n\tdefault Iterable<BiValue<K, V>> asIterable() {\n       return null;\n   }\n}\ninterface MapStream<K, V> {\n\tdefault Iterable<BiValue<K, V>> asIterable() {\n       return null;\n   }\n}\n\ninterface BiValue<T, U> {\n    T getKey();\n    U getValue();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void testDefaultNonclash4() {
        this.runNegativeTest(new String[]{"X.java", "public interface X extends Map<String, Object> {\n   Zork z;\n}\n\ninterface Map<K,V> extends MapStream<K, V>  {\n   @Override\n\tIterable<BiValue<K, V>> asIterable();\n}\ninterface MapStream<K, V> {\n\tIterable<BiValue<K, V>> asIterable();\n}\n\ninterface BiValue<T, U> {\n    T getKey();\n    U getValue();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void testDefaultNonclash5() {
        this.runConformTest(new String[]{"X.java", "public class X extends G implements I {\n}\n\ninterface I {\n\tdefault int foo (){\n\t\treturn 0;\n\t}\n}\n\nclass G {\n\tpublic int foo() {\n\t\treturn 0;\n\t}\n}\n"});
    }

    public void testInheritedDefaultOverrides05() {
        this.runConformTest(new String[]{"StringList.java", "import java.util.Collection;\npublic abstract class StringList implements Collection<String> {\n}\n"}, "");
    }

    public void testInheritedDefaultOverrides06() {
        this.runConformTest(new String[]{"IterableList.java", "import java.util.*;\npublic interface IterableList<E> extends Iterable<E>, List<E> {}\ninterface ListIterable<E> extends Iterable<E>, List<E> {}\n\n"}, "");
    }

    public void testAbstract01() {
        this.runConformTest(new String[]{"I2.java", "public interface I2 {\n    void test();\n}\n", "I1.java", "public interface I1 extends I2 {\n    default void test() {}\n}\n", "C.java", "public class C implements I1 {\n}\n"});
    }

    public void testAbstract02() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n    void test();\n}\n", "I2.java", "public interface I2 {\n    default void test() {}\n}\n", "C.java", "public class C implements I1, I2 {\n}\n"}, "----------\n1. ERROR in C.java (at line 1)\n\tpublic class C implements I1, I2 {\n\t             ^\nThe default method test() inherited from I2 conflicts with another method inherited from I1\n----------\n");
    }

    public void testAbstract02a() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n    void test();\n}\n", "I2.java", "public interface I2 {\n    default void test() {}\n}\n", "C.java", "public class C implements I2, I1 {\n}\n"}, "----------\n1. ERROR in C.java (at line 1)\n\tpublic class C implements I2, I1 {\n\t             ^\nThe default method test() inherited from I2 conflicts with another method inherited from I1\n----------\n");
    }

    public void testAbstract02b() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n    void test();\n}\n", "I2.java", "public interface I2 {\n    default void test() {}\n}\n", "C.java", "public abstract class C implements I2, I1 {\n}\n"}, "----------\n1. ERROR in C.java (at line 1)\n\tpublic abstract class C implements I2, I1 {\n\t                      ^\nThe default method test() inherited from I2 conflicts with another method inherited from I1\n----------\n");
    }

    public void testAbstract02c() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n    void test();\n}\n", "I2.java", "public interface I2 {\n    default void test() {}\n}\n", "I3.java", "public interface I3 extends I1, I2 {\n}\n"}, "----------\n1. ERROR in I3.java (at line 1)\n\tpublic interface I3 extends I1, I2 {\n\t                 ^^\nThe default method test() inherited from I2 conflicts with another method inherited from I1\n----------\n");
    }

    public void testAbstract03() {
        this.runConformTest(new String[]{"I1.java", "public interface I1 {\n    void test();\n}\n", "I2.java", "public interface I2 extends I1 {\n    @Override\n    default void test() {}\n}\n", "C.java", "public class C implements I1, I2 {\n}\n"});
    }

    public void testAbstract03a() {
        this.runConformTest(new String[]{"I1.java", "public interface I1 {\n    void test();\n}\n", "I2.java", "public interface I2 extends I1 {\n    @Override\n    default void test() {}\n}\n", "C.java", "public class C implements I2, I1 {\n}\n"});
    }

    public void testAbstract04() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n    default void test() {}\n}\n", "I2.java", "public interface I2 extends I1 {\n    @Override\n    void test();\n}\n", "C.java", "public class C implements I2, I1 {\n}\n"}, "----------\n1. ERROR in C.java (at line 1)\n\tpublic class C implements I2, I1 {\n\t             ^\nThe type C must implement the inherited abstract method I2.test()\n----------\n");
    }

    public void testAbstract04a() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n    default void test() {}\n}\n", "I2.java", "public interface I2 extends I1 {\n    @Override\n    void test();\n}\n", "C.java", "public class C implements I2, I1 {\n}\n"}, "----------\n1. ERROR in C.java (at line 1)\n\tpublic class C implements I2, I1 {\n\t             ^\nThe type C must implement the inherited abstract method I2.test()\n----------\n");
    }

    public void testAbstract05() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n\tdefault String value1() { return null; }\n}\n", "I2.java", "public interface I2 {\n\tdefault String value1() { return \"\"; }\n}\n", "C2.java", "public abstract class C2 implements I1, I2 {\n}\n"}, "----------\n1. ERROR in C2.java (at line 1)\n\tpublic abstract class C2 implements I1, I2 {\n\t                      ^^\nDuplicate default methods named value1 with the parameters () and () are inherited from the types I2 and I1\n----------\n");
    }

    public void testAbstract06() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n\tdefault String value1() { return null; }\n}\n", "I2.java", "public interface I2 {\n\tdefault String value1() { return \"\"; }\n}\n", "C1.java", "public abstract class C1 {\n\tabstract Object value1();\n}\n", "C2.java", "public abstract class C2 extends C1 implements I1, I2 {\n}\n", "C3.java", "public class C3 extends C2 {\n\t@Override\n\tpublic Object value1() { return this; } // too week, need a method returning String\n}\n"}, "----------\n1. ERROR in C3.java (at line 3)\n\tpublic Object value1() { return this; } // too week, need a method returning String\n\t       ^^^^^^\nThe return type is incompatible with I1.value1()\n----------\n2. ERROR in C3.java (at line 3)\n\tpublic Object value1() { return this; } // too week, need a method returning String\n\t       ^^^^^^\nThe return type is incompatible with I2.value1()\n----------\n");
    }

    public void testAbstract06a() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n\tdefault String value1() { return null; }\n}\n", "I2.java", "public interface I2 {\n\tString value1();\n}\n", "C1.java", "public abstract class C1 {\n\tabstract Object value1();\n}\n", "C2.java", "public abstract class C2 extends C1 implements I1, I2 {\n}\n", "C3.java", "public class C3 extends C2 {\n\t@Override\n\tpublic Object value1() { return this; } // too week, need a method returning String\n}\n"}, "----------\n1. ERROR in C3.java (at line 3)\n\tpublic Object value1() { return this; } // too week, need a method returning String\n\t       ^^^^^^\nThe return type is incompatible with I2.value1()\n----------\n2. ERROR in C3.java (at line 3)\n\tpublic Object value1() { return this; } // too week, need a method returning String\n\t       ^^^^^^\nThe return type is incompatible with I1.value1()\n----------\n");
    }

    public void testAbstract6b() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n\tdefault String value1() { return null; }\n}\n", "I2.java", "public interface I2 {\n\tdefault String value1() { return \"\"; }\n}\n", "p1/C1.java", "package p1;\npublic abstract class C1 {\n\tabstract Object value1();\n}\n", "C2.java", "public abstract class C2 extends p1.C1 implements I1, I2 {\n}\n"}, "----------\n1. ERROR in C2.java (at line 1)\n\tpublic abstract class C2 extends p1.C1 implements I1, I2 {\n\t                      ^^\nDuplicate default methods named value1 with the parameters () and () are inherited from the types I2 and I1\n----------\n");
    }

    public void testAbstract07() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n\tdefault String value1() { return null; }\n}\n", "C1.java", "public abstract class C1 {\n\tabstract Object value1();\n}\n", "C2.java", "public abstract class C2 extends C1 implements I1 {\n}\n", "C3.java", "public class C3 extends C2 {\n\t@Override\n\tpublic Object value1() { return this; } // too week, need a method returning String\n}\n"}, "----------\n1. ERROR in C3.java (at line 3)\n\tpublic Object value1() { return this; } // too week, need a method returning String\n\t       ^^^^^^\nThe return type is incompatible with I1.value1()\n----------\n");
    }

    public void testAbstract08() {
        this.runNegativeTest(new String[]{"I1.java", "public interface I1 {\n\tdefault String value() { return null; }\n}\n", "C1.java", "public abstract class C1 {\n\tpublic abstract String value();}\n", "C2.java", "public class C2 extends C1 implements I1 {\n}\n"}, "----------\n1. ERROR in C2.java (at line 1)\n\tpublic class C2 extends C1 implements I1 {\n\t             ^^\nThe type C2 must implement the inherited abstract method C1.value()\n----------\n");
    }

    public void testAnnotation1() {
        this.runNegativeTest(new String[]{"I.java", "public @interface I {\n    default String id() { return \"1\"; }\n}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tdefault String id() { return \"1\"; }\n\t^^^^^^^\nSyntax error on token \"default\", @ expected\n----------\n");
    }

    public void testSuperCall1() throws Exception {
        this.runConformTest(new String[]{"OrderedSet.java", "import java.util.*;\nimport java.util.stream.Stream;\npublic interface OrderedSet<E> extends List<E>, Set<E> {\n\t@Override\n\tboolean add(E o);\n\t@Override\n\tdefault Spliterator<E> spliterator() { if (true) return List.super.spliterator(); else return Set.super.spliterator(); }\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #14 ()Ljava/util/Spliterator;\n  // Signature: ()Ljava/util/Spliterator<TE;>;\n  // Stack: 1, Locals: 1\n  public java.util.Spliterator spliterator();\n    0  aload_0 [this]\n    1  invokespecial java.util.List.spliterator() : java.util.Spliterator [17]\n    4  areturn\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "OrderedSet.class", "OrderedSet", expectedOutput);
    }

    public void testSuperCall2() {
        this.runNegativeTest(new String[]{"T.java", "import java.util.*;\nimport java.util.stream.Stream;\npublic abstract class T<E> implements OrderedSet<E> {\n\t@Override\n\tpublic Stream<E> stream() {\n\t\treturn List.super.stream(); // List is not a direct super interface\n\t}\n\t@Override\n\tpublic Stream<E> parallelStream() { return OrderedSet.super.parallelStream();}\n   class Inner {\n\t\tpublic Stream<E> stream() {\n\t\t\treturn OrderedSet.super.stream(); // not a super interface of the direct enclosing class\n\t\t}\n\t}\n\t@Override\n\tpublic boolean add(E o) {\n\t\tOrderedSet.super.add(o); // target not a default method\n\t}\n\tT() {\n\t\tOrderedSet.super(); // not applicable for super ctor call\n\t}\n}\ninterface OrderedSet<E> extends List<E>, Set<E> {\n\t@Override\n\tboolean add(E o);\n\t@Override\n   default Spliterator<E> spliterator() { return List.super.spliterator(); }\n}\n"}, "----------\n1. ERROR in T.java (at line 6)\n\treturn List.super.stream(); // List is not a direct super interface\n\t       ^^^^^^^^^^\nIllegal reference to super type List, cannot bypass the more specific direct super type OrderedSet\n----------\n2. ERROR in T.java (at line 12)\n\treturn OrderedSet.super.stream(); // not a super interface of the direct enclosing class\n\t       ^^^^^^^^^^^^^^^^\nNo enclosing instance of the type OrderedSet<E> is accessible in scope\n----------\n3. ERROR in T.java (at line 17)\n\tOrderedSet.super.add(o); // target not a default method\n\t^^^^^^^^^^^^^^^^^^^^^^^\nCannot directly invoke the abstract method add(E) for the type OrderedSet<E>\n----------\n4. ERROR in T.java (at line 20)\n\tOrderedSet.super(); // not applicable for super ctor call\n\t^^^^^^^^^^\nIllegal enclosing instance specification for type Object\n----------\n");
    }

    public void testSuperCall3() {
        this.runConformTest(new String[]{"X.java", "public class X implements I2 {\n\t@Override\n\tpublic void print() {\n\t\tI2.super.print();\n\t\tSystem.out.print(\"!\");\t}\n\tpublic static void main(String... args) {\n\t\tnew X().print();\n\t}\n}\ninterface I1 {\n\tdefault void print() {\n\t\tSystem.out.print(\"O\");\n\t}\n}\ninterface I2 extends I1 {\n\tdefault void print() {\n\t\tI1.super.print();\n\t\tSystem.out.print(\"K\");\n\t}\n}\n"}, "OK!");
    }

    public void testSuperCall4() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements I2, I1 {\n\t@Override\n\tpublic void print() {\n\t\tI1.super.print(); // illegal attempt to skip I2.print()\n\t\tSystem.out.print(\"!\");\t}\n\tpublic static void main(String... args) {\n\t\tnew X().print();\n\t}\n}\ninterface I1 {\n\tdefault void print() {\n\t\tSystem.out.print(\"O\");\n\t}\n}\ninterface I2 extends I1 {\n\t@Override default void print() {\n\t\tSystem.out.print(\"K\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tI1.super.print(); // illegal attempt to skip I2.print()\n\t^^^^^^^^\nIllegal reference to super type I1, cannot bypass the more specific direct super type I2\n----------\n");
    }

    public void testSuperCall5() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements I2, I1 {\n\t@Override\n\tpublic void print() {\n\t\tI1.super.print(); // illegal attempt to skip I2.print()\n\t\tSystem.out.print(\"!\");\t}\n\tpublic static void main(String... args) {\n\t\tnew X().print();\n\t}\n}\ninterface I1 {\n\tdefault void print() {\n\t\tSystem.out.print(\"O\");\n\t}\n}\ninterface I2 extends I1 {\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tI1.super.print(); // illegal attempt to skip I2.print()\n\t^^^^^^^^\nIllegal reference to super type I1, cannot bypass the more specific direct super type I2\n----------\n");
    }

    public void testSuperCall6() {
        this.runNegativeTest(new String[]{"SuperOverride.java", "interface I0 {\n\tdefault void foo() { System.out.println(\"I0\"); }\n}\n\ninterface IA extends I0 {}\n\ninterface IB extends I0 {\n\t@Override default void foo() {\n\t\tSystem.out.println(\"IB\");\n\t}\n}\ninterface IX extends IA, IB {\n\t@Override default void foo() {\n\t\tIA.super.foo(); // illegal attempt to skip IB.foo()\n\t}\n}\npublic class SuperOverride implements IX {\n\tpublic static void main(String[] args) {\n\t\tnew SuperOverride().foo();\n\t}\n}\n"}, "----------\n1. ERROR in SuperOverride.java (at line 14)\n\tIA.super.foo(); // illegal attempt to skip IB.foo()\n\t^^^^^^^^^^^^^^\nIllegal reference to super method foo() from type I0, cannot bypass the more specific override from type IB\n----------\n");
    }

    public void testThisReference1() {
        this.runConformTest(new String[]{"X.java", "public class X implements I1, I2 {\n\t@Override\n\tpublic String s1() { return \"O\"; }\n\t@Override\n\tpublic String s2() { return \"K\"; }\n\tpublic static void main(String... args) {\n\t\tX x = new X();\n\t\tx.print1();\n\t\tx.print2();\n\t}\n}\ninterface I1 {\n\tString s1();\tdefault void print1() {\n\t\tSystem.out.print(this.s1());\n\t}\n}\ninterface I2 {\n\tString s2();\n\tdefault void print2() {\n\t\tclass Inner {\n\t\t\tString value() { return I2.this.s2(); }\n\t\t}\n\t\tSystem.out.print(new Inner().value());\n\t}\n}\n"}, "OK");
    }

    public void testStaticMethod01() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n\tstatic void foo() {}\n\tstatic void foo1();\n\tpublic static default void foo2 () {};\n\tabstract static void foo3();\n\tabstract static void foo4() {}\n}"}, "----------\n1. ERROR in I.java (at line 3)\n\tstatic void foo1();\n\t            ^^^^^^\nThis method requires a body instead of a semicolon\n----------\n2. ERROR in I.java (at line 4)\n\tpublic static default void foo2 () {};\n\t                           ^^^^^^^\nIllegal combination of modifiers for the interface method foo2; only one of abstract, default, or static permitted\n----------\n3. ERROR in I.java (at line 5)\n\tabstract static void foo3();\n\t                     ^^^^^^\nIllegal combination of modifiers for the interface method foo3; only one of abstract, default, or static permitted\n----------\n4. ERROR in I.java (at line 6)\n\tabstract static void foo4() {}\n\t                     ^^^^^^\nIllegal combination of modifiers for the interface method foo4; only one of abstract, default, or static permitted\n----------\n");
    }

    public void testStaticMethod02() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n\tpublic static void foo() {\n\t\tbar();\n\t\tthis.bar();\n   }\n\tpublic default void bar () {\n\t\tthis.foo();\n\t}\n}\ninterface II extends I{\n\tpublic static void foobar() {\n\t\tsuper.bar();\n   }\n}\n"}, "----------\n1. ERROR in I.java (at line 3)\n\tbar();\n\t^^^\nCannot make a static reference to the non-static method bar() from the type I\n----------\n2. ERROR in I.java (at line 4)\n\tthis.bar();\n\t^^^^\nCannot use this in a static context\n----------\n3. ERROR in I.java (at line 7)\n\tthis.foo();\n\t     ^^^\nThis static method of interface I can only be accessed as I.foo\n----------\n4. ERROR in I.java (at line 12)\n\tsuper.bar();\n\t^^^^^\nCannot use super in a static context\n----------\n");
    }

    public void testStaticMethod03() throws Exception {
        this.runConformTest(new String[]{"C.java", "interface I {\n\tpublic static void foo() {\n\t\tSystem.out.println(\"I#foo() invoked\");\n   }\n}\ninterface J extends I {\n\tpublic static void foo() {\n\t\tSystem.out.println(\"J#foo() invoked\");\n   }\n\tpublic default void bar () {\n\t\tfoo();\n\t}\n}\npublic class C implements J {\n\tpublic static void main(String[] args) {\n\t\tC c = new C();\n\t\tc.bar();\n       J.foo();\n       I.foo();\n\t}\n}"}, "J#foo() invoked\nJ#foo() invoked\nI#foo() invoked");
        String expectedOutput = "  // Method descriptor #17 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  new C [1]\n     3  dup\n     4  invokespecial C() [18]\n     7  astore_1 [c]\n     8  aload_1 [c]\n     9  invokevirtual C.bar() : void [19]\n    12  invokestatic J.foo() : void [22]\n    15  invokestatic I.foo() : void [25]\n    18  return\n      Line numbers:\n        [pc: 0, line: 16]\n        [pc: 8, line: 17]\n        [pc: 12, line: 18]\n        [pc: 15, line: 19]\n        [pc: 18, line: 20]\n      Local variable table:\n        [pc: 0, pc: 19] local: args index: 0 type: java.lang.String[]\n        [pc: 8, pc: 19] local: c index: 1 type: C\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "C.class", "C", expectedOutput);
    }

    public void testStaticMethod04() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements II {\n\t@Override\tpublic void foo() {\n\t\t bar();\n\t\t bar2();\n\t}\n\tpublic static void main(String[] args) {\n\t\tbar();\n\t\tII.bar();\n\t\t(new X()).bar();\n\t\tII.bar();\n\t\tII ii = new X();\n\t\tii.bar();\n\t\tii.bar2();\n\t\tI i = new X();\n\t\ti.bar();\n      new I() {}.foo();\n\t}\n}\ninterface I {\n\tpublic static void bar() {\n\t\tbar2();\n\t}\n\tpublic default void bar2() {\n\t\tbar();\n\t}\n}\ninterface II extends I {\n\tpublic default void foo() {\n\t\tbar();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tbar();\n\t^^^\nThe method bar() is undefined for the type X\n----------\n2. ERROR in X.java (at line 7)\n\tbar();\n\t^^^\nThe method bar() is undefined for the type X\n----------\n3. ERROR in X.java (at line 8)\n\tII.bar();\n\t   ^^^\nThe method bar() is undefined for the type II\n----------\n4. ERROR in X.java (at line 9)\n\t(new X()).bar();\n\t          ^^^\nThe method bar() is undefined for the type X\n----------\n5. ERROR in X.java (at line 10)\n\tII.bar();\n\t   ^^^\nThe method bar() is undefined for the type II\n----------\n6. ERROR in X.java (at line 12)\n\tii.bar();\n\t   ^^^\nThe method bar() is undefined for the type II\n----------\n7. ERROR in X.java (at line 15)\n\ti.bar();\n\t  ^^^\nThis static method of interface I can only be accessed as I.bar\n----------\n8. ERROR in X.java (at line 16)\n\tnew I() {}.foo();\n\t           ^^^\nThe method foo() is undefined for the type new I(){}\n----------\n9. ERROR in X.java (at line 21)\n\tbar2();\n\t^^^^\nCannot make a static reference to the non-static method bar2() from the type I\n----------\n10. ERROR in X.java (at line 29)\n\tbar();\n\t^^^\nThe method bar() is undefined for the type II\n----------\n");
    }

    public void testStaticMethod05() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tstatic void foo(int x) { }\n}\ninterface II extends I {\n\tstatic void goo(int x) {}   \t\t// No Error.\n}\ninterface III extends II {\n\tdefault void foo(int x, int y) {}   // No Error.\n\tdefault void goo() {}   \t\t\t// No Error.\n\tdefault void foo(int x) {}   \t\t// No Error.\n\tdefault void goo(int x) {}   \t\t// No Error.\n}\nclass Y {\n\tstatic void goo(int x) {}\n}\nclass X extends Y {\n\tvoid foo(int x) {}   // No error.\n\tvoid goo() {}   \t // No Error.\n\tvoid goo(int x) {}   // Error.\n}\n"}, "----------\n1. ERROR in X.java (at line 19)\n\tvoid goo(int x) {}   // Error.\n\t     ^^^^^^^^^^\nThis instance method cannot override the static method from Y\n----------\n");
    }

    public void testStaticMethod06() {
        this.runConformTest(new String[]{"C.java", "interface I {\n\tpublic static String CONST = \"CONSTANT\";\n\tpublic static void foo(String[] args) {\n\t\tSystem.out.println(args[0]);\n   }\n \tpublic interface Inner {}\n}\ninterface J extends I {\n\tpublic static void foo() {\n\t\tI.foo(new String[]{CONST});\n   }\n \tpublic interface InnerInner extends Inner {}\n}\npublic class C implements J {\n\tpublic static void main(String[] args) {\n       J.foo();\n       I.foo(new String[]{\"LITERAL\"});\n\t}\n}"}, "CONSTANT\nLITERAL");
    }

    public void testStaticMethod07() {
        this.runNegativeTest(new String[]{"C.java", "interface I <T> {\n\tpublic static T foo(T t) {\n\t\treturn t;   }\n}\n"}, "----------\n1. ERROR in C.java (at line 2)\n\tpublic static T foo(T t) {\n\t              ^\nCannot make a static reference to the non-static type T\n----------\n2. ERROR in C.java (at line 2)\n\tpublic static T foo(T t) {\n\t                    ^\nCannot make a static reference to the non-static type T\n----------\n");
    }

    public void testStaticMethod08() {
        this.runNegativeTest(new String[]{"C.java", "@interface A {\n\tstatic String foo() default \"Blah\";\n}\n"}, "----------\n1. ERROR in C.java (at line 2)\n\tstatic String foo() default \"Blah\";\n\t              ^^^^^\nIllegal modifier for the annotation attribute A.foo; only public & abstract are permitted\n----------\n");
    }

    public void testStaticMethod09() {
        this.runNegativeTest(new String[]{"C.java", "interface A {\n\tstatic void foo() {}\n\tdefault void goo(A a) {\n\t\ta.foo();\n\t}\n}\n"}, "----------\n1. ERROR in C.java (at line 4)\n\ta.foo();\n\t  ^^^\nThis static method of interface A can only be accessed as A.foo\n----------\n");
    }

    public void testStaticMethod10() {
        this.runNegativeTest(new String[]{"C.java", "interface A {\n\tstatic void foo(long x) {}\n\tstatic void foo(int x) {}\n\tdefault void goo(A a) {\n\t\ta.foo(10);\n\t}\n}\n"}, "----------\n1. ERROR in C.java (at line 5)\n\ta.foo(10);\n\t  ^^^\nThis static method of interface A can only be accessed as A.foo\n----------\n");
    }

    public void testStaticMethod11() {
        this.runNegativeTest(new String[]{"C.java", "interface A<X> {\n\tvoid foo(X x);\n}\ninterface B extends A<String> {\n    static void foo(String s) {}\n}\n"}, "----------\n1. ERROR in C.java (at line 5)\n\tstatic void foo(String s) {}\n\t            ^^^^^^^^^^^^^\nThis static method cannot hide the instance method from A<String>\n----------\n");
    }

    public void testStaticMethod12() {
        this.runNegativeTest(new String[]{"C.java", "interface A<X> {\n\tstatic void foo(String x) {}\n}\ninterface B extends A<String> {\n    static void foo(String s) {}\n}\npublic class X {\n}\n"}, "----------\n1. WARNING in C.java (at line 1)\n\tinterface A<X> {\n\t            ^\nThe type parameter X is hiding the type X\n----------\n2. ERROR in C.java (at line 7)\n\tpublic class X {\n\t             ^\nThe public type X must be defined in its own file\n----------\n");
    }

    public void testStaticMethod13() {
        this.runNegativeTest(new String[]{"C.java", "interface A {\n\tstatic void foo(String x) {\n       System.out.println(this);\n       System.out.println(super.hashCode());\n   }\n}\n"}, "----------\n1. ERROR in C.java (at line 3)\n\tSystem.out.println(this);\n\t                   ^^^^\nCannot use this in a static context\n----------\n2. ERROR in C.java (at line 4)\n\tSystem.out.println(super.hashCode());\n\t                   ^^^^^\nCannot use super in a static context\n----------\n");
    }

    public void test406619() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "interface X {\n\tdefault int foo() {\n\t\treturn 10;\n\t}\n}\n"}, "", null, true, compilerOptions);
    }

    public void testSuperAccess01() {
        this.runConformTest(new String[]{"C.java", "interface I {\n    public default void foo() {\n        System.out.println(\"default\");\n    }\n}\npublic class C implements I {\n    public static void main(String[] args) {\n        C c = new C();\n        c.foo();\n    }\n}\n"}, "default");
    }

    public void testSuperAccess02() {
        this.runConformTest(new String[]{"p1/C.java", "package p1;\npublic class C implements p2.J {\n    public static void main(String[] args) {\n        C c = new C();\n        c.foo();\n    }\n}\n", "p2/J.java", "package p2;\ninterface I {\n    public default void foo() {\n        System.out.println(\"default\");\n    }\n}\npublic interface J extends I {}\n"}, "default");
    }

    public void testSuperAccess03() {
        this.runConformTest(new String[]{"X.java", "interface I  {\n    void foo(); \n}\n\ninterface J extends I {\n    default void foo() {\n    }\n}\n\ninterface K extends J {\n}\n\npublic class X implements K {\n\tpublic static void main(String argv[]) {\n\t\tX test = new X();\n\t\t((J)test).foo();\n\t\ttest.foo();\n\t}\n}\n"});
    }

    public void testBridge01() {
        this.runNegativeTest(new String[]{"PurebredCatShopImpl.java", "import java.util.List;\ninterface Pet {}\ninterface Cat extends Pet {}\ninterface PetShop { default List<Pet> getPets() { return null; } }\ninterface CatShop extends PetShop {\n\tdefault <V extends Pet> List<? extends Cat> getPets() { return null; }\n}\ninterface PurebredCatShop extends CatShop {}\nclass CatShopImpl implements CatShop {\n\t@Override public List<Pet> getPets() { return null; }\n}\nclass PurebredCatShopImpl extends CatShopImpl implements PurebredCatShop {}"}, "----------\n1. ERROR in PurebredCatShopImpl.java (at line 6)\n\tdefault <V extends Pet> List<? extends Cat> getPets() { return null; }\n\t                                            ^^^^^^^^^\nName clash: The method getPets() of type CatShop has the same erasure as getPets() of type PetShop but does not override it\n----------\n2. WARNING in PurebredCatShopImpl.java (at line 10)\n\t@Override public List<Pet> getPets() { return null; }\n\t                 ^^^^\nType safety: The return type List<Pet> for getPets() from the type CatShopImpl needs unchecked conversion to conform to List<? extends Cat> from the type CatShop\n----------\n");
    }

    public void testBridge02() {
        this.runConformTest(new String[]{"PurebredCatShopImpl.java", "import java.util.List;\nimport java.util.ArrayList;\ninterface Pet {}\ninterface Cat extends Pet {}\ninterface PetShop { default List<Pet> getPets() { return null; } }\ninterface CatShop extends PetShop {\n\t@Override default ArrayList<Pet> getPets() { return null; }\n}\ninterface PurebredCatShop extends CatShop {}\nclass CatShopImpl implements CatShop {\n\t@Override public ArrayList<Pet> getPets() { return new ArrayList<>(); }\n}\npublic class PurebredCatShopImpl extends CatShopImpl implements PurebredCatShop {\n\tpublic static void main(String... args) {\n\t\tPurebredCatShopImpl pcsi = new PurebredCatShopImpl();\n\t\tSystem.out.print(pcsi.getPets().size());\n\t\tCatShopImpl csi = pcsi;\n\t\tSystem.out.print(csi.getPets().size());\n\t\tCatShop cs = csi;\n\t\tSystem.out.print(cs.getPets().size());\n\t\tPetShop ps = cs;\n\t\tSystem.out.print(ps.getPets().size());\n\t}\n}\n"}, "0000");
    }

    public void _testBridge03() {
        this.runConformTest(new String[]{"C.java", "interface A<ModelType extends D, ValueType> extends\n\t\tI<ModelType, ValueType> {\n\n\t@Override\n\tpublic default void doSet(ModelType valueGetter) {\n\t\tthis.set((ValueType) valueGetter.getObject());\n\t}\n\n\t@Override\n\tpublic default void set(Object object) {\n\t\tSystem.out.println(\"In A.set(Object)\");\n\t}\n}\n\nclass B implements A<E, CharSequence> {\n\n\tpublic void set(CharSequence string) {\n\t\tSystem.out.println(\"In B.set(CharSequence)\");\n\t}\n}\n\npublic class C extends B {\n\n\tstatic public void main(String[] args) {\n\t\tC c = new C();\n\t\tc.run();\n\t}\n\n\tpublic void run() {\n\t\tE e = new E<String>(String.class);\n\t\tthis.doSet(e);\n\t}\n\n}\n\nclass D {\n\tpublic Object getObject() {\n\t\treturn null;\n\t}\n}\n\nclass E<Type extends CharSequence> extends D {\n\n\tprivate Class<Type> typeClass;\n\n\tpublic E(Class<Type> typeClass) {\n\t\tthis.typeClass = typeClass;\n\t}\n\n\t@Override\n\tpublic Type getObject() {\n\t\ttry {\n\t\t\treturn (Type) typeClass.newInstance();\n\t\t} catch (Exception e) {\n\t\t\tthrow new RuntimeException(e);\n\t\t}\n\t}\n\n}\n\ninterface I<ModelType, ValueType> {\n\n\tpublic void doSet(ModelType model);\n\n\tpublic void set(ValueType value);\n\n}\n"}, "In B.set(CharSequence)");
    }

    public void _testBridge04() {
        this.runConformTest(new String[]{"C.java", "interface A<ModelType extends D, ValueType> extends\n       I<ModelType, ValueType> {\n\n   @Override\n   public default void doSet(ModelType valueGetter) {\n       this.set((ValueType) valueGetter.getObject());\n   }\n\n   @Override\n   public default void set(Object object) {\n       System.out.println(\"In A.set(Object)\");\n   }\n}\n\ninterface B extends A<E, CharSequence> {\n\n   public default void set(CharSequence string) {\n       System.out.println(\"In B.set(CharSequence)\");\n   }\n}\n\npublic class C implements B {\n\n   static public void main(String[] args) {\n       C c = new C();\n       c.run();\n   }\n\n   public void run() {\n       E e = new E<String>(String.class);\n       this.doSet(e);\n   }\n\n}\n\nclass D {\n   public Object getObject() {\n       return null;\n   }\n}\n\nclass E<Type extends CharSequence> extends D {\n\n   private Class<Type> typeClass;\n\n   public E(Class<Type> typeClass) {\n       this.typeClass = typeClass;\n   }\n\n   @Override\n   public Type getObject() {\n       try {\n           return (Type) typeClass.newInstance();\n       } catch (Exception e) {\n           throw new RuntimeException(e);\n       }\n   }\n\n}\n\ninterface I<ModelType, ValueType> {\n\n   public void doSet(ModelType model);\n\n   public void set(ValueType value);\n\n}\n"}, "In B.set(CharSequence)");
    }

    public void test400977() {
        this.runNegativeTest(new String[]{"I.java", "public interface I {\n    default abstract void foo();\n    public abstract default strictfp final void bar();}\n"}, "----------\n1. ERROR in I.java (at line 2)\n\tdefault abstract void foo();\n\t                      ^^^^^\nIllegal combination of modifiers for the interface method foo; only one of abstract, default, or static permitted\n----------\n2. ERROR in I.java (at line 3)\n\tpublic abstract default strictfp final void bar();}\n\t                                            ^^^^^\nstrictfp is not permitted for abstract interface method bar\n----------\n3. ERROR in I.java (at line 3)\n\tpublic abstract default strictfp final void bar();}\n\t                                            ^^^^^\nIllegal combination of modifiers for the interface method bar; only one of abstract, default, or static permitted\n----------\n4. ERROR in I.java (at line 3)\n\tpublic abstract default strictfp final void bar();}\n\t                                            ^^^^^\nIllegal modifier for the interface method bar; only public, abstract, default, static and strictfp are permitted\n----------\n");
    }

    public void testBug420084() {
        this.runNegativeTest(new String[]{"p/J.java", "package p;\npublic interface J {\n\tstatic int foo(){return 0;}\n}\n", "I.java", "import static p.J.foo;\npublic interface I {\n\tstatic int call() {\n\t\treturn foo();\n\t}\n}\n"}, "");
    }

    public void testBug421543() {
        this.runNegativeTest(new String[]{"X.java", "interface I  {\n\tdefault void foo() {}\n}\ninterface J extends I {\n\tvoid foo();\n}\npublic class X implements J {\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid foo();\n\t     ^^^^^\nThe method foo() of type J should be tagged with @Override since it actually overrides a superinterface method\n----------\n2. ERROR in X.java (at line 7)\n\tpublic class X implements J {\n\t             ^\nThe type X must implement the inherited abstract method J.foo()\n----------\n");
    }

    public void testBug421543a() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T>  {\n\tdefault void foo(T t) {}\n}\ninterface J extends I<J> {\n\tvoid foo(J t);\n}\npublic class X implements J {\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid foo(J t);\n\t     ^^^^^^^^\nThe method foo(J) of type J should be tagged with @Override since it actually overrides a superinterface method\n----------\n2. ERROR in X.java (at line 7)\n\tpublic class X implements J {\n\t             ^\nThe type X must implement the inherited abstract method J.foo(J)\n----------\n");
    }

    public void testBug421543b() {
        this.runConformTest(new String[]{"X.java", "interface I<T>  {\n\tvoid foo(T t);\n}\n@SuppressWarnings(\"override\")\ninterface J extends I<J> {\n\tdefault void foo(J t) {}\n}\npublic class X implements J {\n}\n"}, "");
    }

    public void testBug421797() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint m(String s, int val);\n\tpublic default int foo(String s, int val) {\n\t\tSystem.out.print(s + \" from I.foo:\");\n\t\treturn val * val; \n\t}\n}\ninterface T extends I {\n\tpublic default int m(String s, int value) { \n\t\tI i = I.super::foo; \n\t\treturn i.foo(s, value);\n\t}\n}\npublic class X {\n\tpublic static void main(String argv[]) {  \n\t\tSystem.out.println(new T(){}.m(\"Hello\", 1234));\n\t}\n}\n"}, "Hello from I.foo:1522756");
    }

    public void test422731() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Base implements I {\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.foo((short)5, (short)10);\n\t\tx.bar((short)5, (short)10);\n\t}\n\tpublic void foo(short s, int i) {} // No error, but should have been\n\tpublic void bar(short s, int i) {} // Correctly reported\n\n}\ninterface I {\n\tpublic default void foo(int i, short s) {}\n}\nclass Base {\n\tpublic void bar(int i, short s) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tx.foo((short)5, (short)10);\n\t  ^^^\nThe method foo(short, int) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 5)\n\tx.bar((short)5, (short)10);\n\t  ^^^\nThe method bar(short, int) is ambiguous for the type X\n----------\n");
    }

    public void test425719() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface I {\n   default void foo(Object obj) {\n\t   System.out.println(\"interface method\");\n   }\n}\nclass Base {\n    public void foo(Object obj) {\n        System.out.println(\"class method\");\n   }\n}\npublic class X extends Base implements I {\n\t public static void main(String argv[]) {\n\t    \tnew X().foo(null);\n\t    }\n}\n"}, "class method");
    }

    public void test425718() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n   default Object clone() { return null; };\n}\npublic class X  {\n    public void foo() {\n        I x = new I(){};\n        System.out.println(x.clone());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tI x = new I(){};\n\t          ^^^\nThe inherited method Object.clone() cannot hide the public abstract method in I\n----------\n2. ERROR in X.java (at line 6)\n\tI x = new I(){};\n\t          ^^^\nException CloneNotSupportedException in throws clause of Object.clone() is not compatible with I.clone()\n----------\n");
    }

    public void test426318() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "abstract class Y { \n    public abstract void foo(Object[] x);\n    public abstract void goo(Object[] x);\n}\ninterface I {\n   default public <T> void foo(T... x) {};\n   public abstract <T> void goo(T ... x);\n}\npublic abstract class X extends Y implements I { \n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tdefault public <T> void foo(T... x) {};\n\t                                 ^\nType safety: Potential heap pollution via varargs parameter x\n----------\n2. WARNING in X.java (at line 7)\n\tpublic abstract <T> void goo(T ... x);\n\t                                   ^\nType safety: Potential heap pollution via varargs parameter x\n----------\n");
    }

    public void test424914() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface A {\n\tString foo();\n\tString b = super.toString();\n\tdefault void fun1() {\n\t\tSystem.out.println((A) super::toString);\n\t\tsuper.toString();\n\t\tObject.super.toString();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tString b = super.toString();\n\t           ^^^^^\nCannot use super in a static context\n----------\n2. ERROR in X.java (at line 5)\n\tSystem.out.println((A) super::toString);\n\t                       ^^^^^\nsuper reference is illegal in interface context\n----------\n3. ERROR in X.java (at line 6)\n\tsuper.toString();\n\t^^^^^\nsuper reference is illegal in interface context\n----------\n4. ERROR in X.java (at line 7)\n\tObject.super.toString();\n\t^^^^^^^^^^^^\nNo enclosing instance of the type Object is accessible in scope\n----------\n");
    }

    public void test424914a() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface B {\n\tdefault void foo() {\n\t\tSystem.out.println(\"B.foo\");\n\t}\n}\ninterface A extends B {\n\tdefault void foo() {\n\t\tSystem.out.println(\"A.foo\");\n\t\tB.super.foo();\n\t}\n}\npublic class X implements A {\n\tpublic static void main(String[] args) {\n\t\tA a = new X();\n\t\ta.foo();\n\t}\n}\n"}, "A.foo\nB.foo");
    }

    public void test427478() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Consumer;\nimport java.util.function.DoubleConsumer;\npublic interface X<T> {\n    default void forEachRemaining(Consumer<? super T> action) {\n    }\n    public interface OfPrimitive<T, T_CONS, T_SPLITR extends OfPrimitive<T, T_CONS, T_SPLITR>> extends X<T> {\n        default void forEachRemaining(T_CONS action) {\n        }\n    }\n    public interface OfDouble extends OfPrimitive<Double, DoubleConsumer, OfDouble> {\n        default void forEachRemaining(Consumer<? super Double> action) {\n        }\n        default void forEachRemaining(DoubleConsumer action) {\n        }\n    }\n}\nabstract class AbstractDoubleSpliterator implements X.OfDouble {\n}\n"}, "");
    }

    public void test427478a() throws Exception {
        this.runConformTest(new String[]{"Spliterator.java", "import java.util.function.Consumer;\nimport java.util.function.DoubleConsumer;\npublic interface Spliterator<T> {\n    default void forEachRemaining(Consumer<? super T> action) {\n    }\n    public interface OfPrimitive<T, T_CONS, T_SPLITR extends OfPrimitive<T, T_CONS, T_SPLITR>>\n            extends Spliterator<T> {\n        // overloads Spliterator#forEachRemaining(Consumer<? super T>)\n        default void forEachRemaining(T_CONS action) {\n        }\n    }\n    public interface OfDouble extends OfPrimitive<Double, DoubleConsumer, OfDouble> {\n        @Override // the method from Spliterator\n        default void forEachRemaining(Consumer<? super Double> action) {\n        }\n        \n        @Override // the method from OfPrimitive\n        default void forEachRemaining(DoubleConsumer action) {\n        }\n    }\n}\nclass Spliterators {\n    /* Error on class: Duplicate default methods named forEachRemaining with\n     * the parameters (Consumer<? super Double>) and (Consumer<? super T>) are\n     * inherited from the types Spliterator.OfDouble and Spliterator<Double>\n     */\n    public abstract static class AbstractDoubleSpliterator implements Spliterator.OfDouble {\n        /* Implementation that prevents the compile error: */\n//        @Override // the method from Spliterator\n//        public void forEachRemaining(Consumer<? super Double> action) {\n//        }\n    }\n}\n"}, "");
    }

    public void test423467() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface I {\n    int foo(String s);\n}\n@FunctionalInterface\ninterface A extends I { // wrong compile error (A *is* a functional interface)\n    @Override\n    default int foo(String s) {\n        return -1;\n    }\n    Integer foo(java.io.Serializable s);\n}\npublic class X {\n    A a = (s) -> 10;\n}\n@FunctionalInterface\ninterface B { // OK\n    default int foo(String s) {\n        return -1;\n    }\n    Integer foo(java.io.Serializable s);\n}\n"}, "");
    }

    public void test438471() throws Exception {
        this.runConformTest(new String[]{"Bar.java", "@FunctionalInterface\npublic interface Bar extends Overridden {\n\tvoid foo();\n\t@Override\n\tdefault void close() {\n\t\tSystem.out.println(\"bar\");\n\t}\n}\n\ninterface Overridden extends AutoCloseable {\n\t// Works without this overridden method\n\t@Override\n\tvoid close();\n}"}, "");
    }

    public void test436350() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n    }\n}\ninterface GenericInterface<T> {\n\tT reduce(Integer i);\n}\ninterface DoubleInterface extends GenericInterface<Double> {\n\tdefault Double reduce(Integer i) {\n\t\treturn 0.0;\n\t}\n\tdouble reduce(String s);\n}\n"}, "");
        String expectedOutput = "  public bridge synthetic java.lang.Object reduce(java.lang.Integer arg0);\n    0  aload_0 [this]\n    1  aload_1 [arg0]\n    2  invokeinterface DoubleInterface.reduce(java.lang.Integer) : java.lang.Double [24] [nargs: 2]\n    7  areturn\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "DoubleInterface.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            InterfaceMethodsTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test436350a() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.Iterator;\nimport java.util.PrimitiveIterator;\nimport java.util.PrimitiveIterator.OfDouble;\n/**\n * @author Tobias Grasl\n */\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tfinal double[] doubles = new double[]{1,2,3};\n\t\tOfDouble doubleIterator = new DoubleArrayIterator(doubles);\n\t\tDouble value = new Reducer<Double>().reduce(doubleIterator, new DoubleInterface() {\n\t\t\t@Override\n\t\t\tpublic double reduce(OfDouble iterator_) {\n\t\t\t\tdouble sum = 0;\n\t\t\t\twhile(iterator_.hasNext()) {\n\t\t\t\t\tsum += iterator_.nextDouble();\n\t\t\t\t}\n\t\t\t\treturn sum;\n\t\t\t}\n\t\t});\n\t\tSystem.out.println(\"Anonymous class value: \"+value);\n\t\tdoubleIterator = new DoubleArrayIterator(doubles);\n\t\tvalue = new Reducer<Double>().reduce(doubleIterator, (DoubleInterface) iterator_ -> {\n\t\t\tdouble sum = 0;\n\t\t\twhile(iterator_.hasNext()) {\n\t\t\t\tsum += iterator_.nextDouble();\n\t\t\t}\n\t\t\treturn sum;\n\t\t});\n\t\tSystem.out.println(\"Lambda expression value: \"+value);\n\t}\n\tprivate static class DoubleArrayIterator implements PrimitiveIterator.OfDouble {\n\t\tint index = 0;\n\t\tprivate double[] _doubles;\n\t\tpublic DoubleArrayIterator(double[] doubles_) {\n\t\t\t_doubles = doubles_;\n\t\t}\n\t\t@Override\n\t\tpublic boolean hasNext() {\n\t\t\treturn index < _doubles.length;\n\t\t}\n\t\t@Override\n\t\tpublic double nextDouble() {\n\t\t\treturn _doubles[index++];\n\t\t}\n\t};\n\tinterface GenericInterface<T> {\n\t\tT reduce(Iterator<T> iterator_);\n\t}\n\tinterface DoubleInterface extends GenericInterface<Double> {\n\t\tdefault Double reduce(Iterator<Double> iterator_) {\n\t\t\tif(iterator_ instanceof PrimitiveIterator.OfDouble) {\n\t\t\t\treturn reduce((PrimitiveIterator.OfDouble)iterator_);\n\t\t\t}\n\t\t\treturn Double.NaN;\n\t\t};\n\t\tdouble reduce(PrimitiveIterator.OfDouble iterator_);\n\t}\n\tstatic class Reducer<T> {\n\t\tT reduce(Iterator<T> iterator_, GenericInterface<T> reduction_) {\n\t\t\treturn reduction_.reduce(iterator_);\n\t\t}\n\t}\n}\n"}, "Anonymous class value: 6.0\nLambda expression value: 6.0");
    }

    public void testBug437522() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface T {\n    int f = 0;\n    void foo();\n    default String def() { return \"T.def\"; }\n}\nclass S {\n    public static final int f = 0;\n}\nclass C extends S implements T {\n    @Override\n    public void foo() {\n        System.out.println(T.super.f); // no error in Java 8 (wrong) without fix\n        System.out.println(T.super.def()); // new JLS8 15.12.1 form (OK)\n        System.out.println(S.super.f); // compile error (correct)\n    }\n}\nclass X {\n    T f = new T() {\n        @Override\n        public void foo() {\n            System.out.println(T.super.f); // no error in Java 8 (wrong) without fix\n        }\n    };\n}\nclass Y { int f = 1;}\nclass Z extends Y {\n\tint foo2() { return super.f;}\n\tstatic int foo() { return super.f;}\n}\ninterface T2 { int f = 0; }\nclass X2  implements T2 {\t\n\tint i = T2.super.f;\n}\ninterface T3 { int f = 0; }\ninterface T4 extends T3 { int f = 0; }\nclass X3  implements T4 {\t\n\tint i = T4.super.f;\n}\ninterface T5 { int f = 0; }\nclass X5 implements T5 {\t\n\tstatic int i = T5.super.f;\n}\ninterface T6 { int f = 0; }\nclass X6 implements T6 {\t\n\tstatic int i = T6.super.f;\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tSystem.out.println(T.super.f); // no error in Java 8 (wrong) without fix\n\t                   ^^^^^^^\nNo enclosing instance of the type T is accessible in scope\n----------\n2. ERROR in X.java (at line 14)\n\tSystem.out.println(S.super.f); // compile error (correct)\n\t                   ^^^^^^^\nNo enclosing instance of the type S is accessible in scope\n----------\n3. ERROR in X.java (at line 21)\n\tSystem.out.println(T.super.f); // no error in Java 8 (wrong) without fix\n\t                   ^^^^^^^\nNo enclosing instance of the type T is accessible in scope\n----------\n4. ERROR in X.java (at line 28)\n\tstatic int foo() { return super.f;}\n\t                          ^^^^^\nCannot use super in a static context\n----------\n5. ERROR in X.java (at line 32)\n\tint i = T2.super.f;\n\t        ^^^^^^^^\nNo enclosing instance of the type T2 is accessible in scope\n----------\n6. ERROR in X.java (at line 37)\n\tint i = T4.super.f;\n\t        ^^^^^^^^\nNo enclosing instance of the type T4 is accessible in scope\n----------\n7. ERROR in X.java (at line 41)\n\tstatic int i = T5.super.f;\n\t               ^^^^^^^^\nCannot use super in a static context\n----------\n8. ERROR in X.java (at line 41)\n\tstatic int i = T5.super.f;\n\t               ^^^^^^^^\nNo enclosing instance of the type T5 is accessible in scope\n----------\n9. ERROR in X.java (at line 45)\n\tstatic int i = T6.super.f;\n\t               ^^^^^^^^\nCannot use super in a static context\n----------\n10. ERROR in X.java (at line 45)\n\tstatic int i = T6.super.f;\n\t               ^^^^^^^^\nNo enclosing instance of the type T6 is accessible in scope\n----------\n");
    }

    public void testBug437522a() throws Exception {
        this.runConformTest(true, new String[]{"X.java", "interface I  { int x = 0; }\nclass T1 implements I { int x = 1; }\nclass T2 extends T1   { int x = 2; }\nclass T3 extends T2 {\n    int x = 3;\n    void test() {\n        System.out.println(\"x= \"          + x);\n        System.out.println(\"super.x= \"    + super.x);\n        System.out.println(\"((T2)this).x= \" + ((T2)this).x);\n        System.out.println(\"((T1)this).x= \" + ((T1)this).x);\n        System.out.println(\"((I)this).x= \"  + ((I)this).x);\n    }\n}\npublic class X {\n    public static void main(String[] args) {\n        new T3().test();\n    }\n}\n"}, null, null, "----------\n1. WARNING in X.java (at line 3)\n\tclass T2 extends T1   { int x = 2; }\n\t                            ^\nThe field T2.x is hiding a field from type T1\n----------\n2. WARNING in X.java (at line 5)\n\tint x = 3;\n\t    ^\nThe field T3.x is hiding a field from type T2\n----------\n3. WARNING in X.java (at line 11)\n\tSystem.out.println(\"((I)this).x= \"  + ((I)this).x);\n\t                                                ^\nThe static field I.x should be accessed in a static way\n----------\n", "x= 3\nsuper.x= 2\n((T2)this).x= 2\n((T1)this).x= 1\n((I)this).x= 0", "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }

    public void test453552() throws Exception {
        this.runConformTest(new String[]{"FunctionalInterface1.java", "@FunctionalInterface\ninterface FunctionalInterface1 {\n    void methodWithoutDefault();\n}\n@FunctionalInterface\ninterface FunctionalInterface2 extends FunctionalInterface1{}\n@FunctionalInterface\ninterface FunctionalInterface3 extends FunctionalInterface1{}\n@FunctionalInterface\ninterface FunctionalInterface4 extends FunctionalInterface2, FunctionalInterface3{}\n@FunctionalInterface\ninterface RunnableFunctionalInterface extends Runnable, FunctionalInterface4{\n\tdefault void methodWithoutDefault(){\n\t\t// implements methodWithoutDefault\n\t}\n}\n"});
    }

    public void test453552_comment2() throws Exception {
        this.runConformTest(new String[]{"FI1.java", "interface FI1<T,R> {\n\tR call(T input);\n}\ninterface FI2<U,V> {\n\tV call(U input);\n}\n@FunctionalInterface\ninterface FI3<X,Y> extends FI1<X,Y>, FI2<X,Y> {\n\tY apply(X input);\n\n   @Override\n   default Y call(X input) {\n       return apply(input);\n   }\n}"});
    }

    public void test477891_comment0() throws Exception {
        this.runNegativeTest(new String[]{"D.java", "interface A {\n    public default void display() {\n        System.out.println(\"Display from A\");\n    }\n}\ninterface B extends A {\n\t@Override\n    public default void display() {\n        System.out.println(\"Display from B\");\n    }\n}\ninterface C extends A {\n\t@Override\n    public void display();\n}\npublic interface D extends B, C {\n}\n"}, "----------\n1. ERROR in D.java (at line 16)\n\tpublic interface D extends B, C {\n\t                 ^\nThe default method display() inherited from B conflicts with another method inherited from C\n----------\n");
    }

    public void test477891_comment0_a() throws Exception {
        this.runNegativeTest(new String[]{"D.java", "interface A {\n    public default void display() {\n        System.out.println(\"Display from A\");\n    }\n}\ninterface B extends A {\n\t@Override\n    public default void display() {\n        System.out.println(\"Display from B\");\n    }\n}\ninterface C extends A {\n\t@Override\n    public void display();\n}\npublic interface D extends C, B {\n}\n"}, "----------\n1. ERROR in D.java (at line 16)\n\tpublic interface D extends C, B {\n\t                 ^\nThe default method display() inherited from B conflicts with another method inherited from C\n----------\n");
    }

    public void test477891_comment3_a() throws Exception {
        this.runNegativeTest(new String[]{"Z.java", "import java.util.*;\ninterface Z<E> extends X<E>, Y<E> {\n}\ninterface Y<E> extends AB<E> {\n\t@Override\n\tdefault Spliterator<E> spliterator() { return null; };\n}\ninterface X<E> extends AB<E> {\n\t@Override\n\tSpliterator<E> spliterator();\n}\ninterface AB<E> {\n\tdefault Spliterator<E> spliterator() { return null; }\n}\n"}, "----------\n1. ERROR in Z.java (at line 2)\n\tinterface Z<E> extends X<E>, Y<E> {\n\t          ^\nThe default method spliterator() inherited from Y<E> conflicts with another method inherited from X<E>\n----------\n");
    }

    public void test477891_comment3_b() throws Exception {
        this.runNegativeTest(new String[]{"Z.java", "import java.util.*;\ninterface Z<E> extends Y<E>, X<E> {\n}\ninterface Y<E> extends AB<E> {\n\t@Override\n\tdefault Spliterator<E> spliterator() { return null; };\n}\ninterface X<E> extends AB<E> {\n\t@Override\n\tSpliterator<E> spliterator();\n}\ninterface AB<E> {\n\tdefault Spliterator<E> spliterator() { return null; }\n}\n"}, "----------\n1. ERROR in Z.java (at line 2)\n\tinterface Z<E> extends Y<E>, X<E> {\n\t          ^\nThe default method spliterator() inherited from Y<E> conflicts with another method inherited from X<E>\n----------\n");
    }

    public void test477891_comment3_c() throws Exception {
        this.runNegativeTest(new String[]{"Z.java", "import java.util.*;\ninterface Z<E> extends X<E>, Y<E> {\n}\ninterface Y<E> extends AB<E> {\n\t@Override\n\tdefault Spliterator<E> spliterator() { return null; };\n}\ninterface X<E> {\n\tSpliterator<E> spliterator();\n}\ninterface AB<E> {\n\tdefault Spliterator<E> spliterator() { return null; }\n}\n"}, "----------\n1. ERROR in Z.java (at line 2)\n\tinterface Z<E> extends X<E>, Y<E> {\n\t          ^\nThe default method spliterator() inherited from Y<E> conflicts with another method inherited from X<E>\n----------\n");
    }

    public void test477891_comment3_d() throws Exception {
        this.runNegativeTest(new String[]{"Z.java", "import java.util.*;\ninterface Z<E> extends Y<E>, X<E> {\n}\ninterface Y<E> extends AB<E> {\n\t@Override\n\tdefault Spliterator<E> spliterator() { return null; };\n}\ninterface X<E> {\n\tSpliterator<E> spliterator();\n}\ninterface AB<E> {\n\tdefault Spliterator<E> spliterator() { return null; }\n}\n"}, "----------\n1. ERROR in Z.java (at line 2)\n\tinterface Z<E> extends Y<E>, X<E> {\n\t          ^\nThe default method spliterator() inherited from Y<E> conflicts with another method inherited from X<E>\n----------\n");
    }
}

