/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;

public class MethodVerifyTest
extends AbstractComparableTest {
    public MethodVerifyTest(String name) {
        super(name);
    }

    public static Test suite() {
        return MethodVerifyTest.buildComparableTestSuite(MethodVerifyTest.testClass());
    }

    public static Class testClass() {
        return MethodVerifyTest.class;
    }

    @Override
    protected Map getCompilerOptions() {
        Map compilerOptions = super.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
        return compilerOptions;
    }

    String mustOverrideMessage(String method, String type) {
        return "The method " + method + " of type " + type + (new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L ? " must override a superclass method\n" : " must override or implement a supertype method\n");
    }

    public void test001() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y<T> extends X<A> { public void foo(T t) {} }\nclass X<U> { public void foo(U u) {} }\nclass A {}\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y<T> extends X<A> { public void foo(T t) {} }\n\t                                             ^^^^^^^^\nName clash: The method foo(T) of type Y<T> has the same erasure as foo(U) of type X<U> but does not override it\n----------\n");
    }

    public void test001a() {
        this.runNegativeTest(new String[]{"J.java", "public class J<T> implements I<A> { public void foo(T t) {} }\ninterface I<U> { public void foo(U u); }\nclass A {}\n"}, "----------\n1. ERROR in J.java (at line 1)\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\n\t             ^\nThe type J<T> must implement the inherited abstract method I<A>.foo(A)\n----------\n2. ERROR in J.java (at line 1)\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\n\t                                                ^^^^^^^^\nName clash: The method foo(T) of type J<T> has the same erasure as foo(U) of type I<U> but does not override it\n----------\n");
    }

    public void test001b() {
        this.runNegativeTest(new String[]{"YY.java", "public class YY<T> extends X { public void foo(T t) {} }\nclass X<U> { public void foo(U u) {} }\n"}, "----------\n1. WARNING in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                           ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n2. ERROR in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                                           ^^^^^^^^\nName clash: The method foo(T) of type YY<T> has the same erasure as foo(Object) of type X but does not override it\n----------\n");
    }

    public void test001c() {
        this.runNegativeTest(new String[]{"JJ.java", "public class JJ<T> implements I { public void foo(T t) {} }\ninterface I<U> { public void foo(U u); }\n"}, "----------\n1. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t             ^^\nThe type JJ<T> must implement the inherited abstract method I.foo(Object)\n----------\n2. WARNING in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                              ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n3. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                                              ^^^^^^^^\nName clash: The method foo(T) of type JJ<T> has the same erasure as foo(Object) of type I but does not override it\n----------\n");
    }

    public void test001d() {
        this.runConformTest(new String[]{"YYY.java", "public class YYY<T> extends X<T> { public void foo(T t) {} }\nclass X<U> { public void foo(U u) {} }\n"}, "");
    }

    public void test001e() {
        this.runConformTest(new String[]{"JJJ.java", "public class JJJ<T> implements I<T> { public void foo(T t) {} }\ninterface I<U> { public void foo(U u); }\n"}, "");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y<T> extends X<A> { public void foo(T t) {} }\nclass A {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y<T> extends X<A> { public void foo(T t) {} }\n\t                                             ^^^^^^^^\nName clash: The method foo(T) of type Y<T> has the same erasure as foo(U) of type X<U> but does not override it\n----------\n");
    }

    public void test002a() {
        this.runNegativeTest(new String[]{"J.java", "public class J<T> implements I<A> { public void foo(T t) {} }\nclass A {}\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "----------\n1. ERROR in J.java (at line 1)\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\n\t             ^\nThe type J<T> must implement the inherited abstract method I<A>.foo(A)\n----------\n2. ERROR in J.java (at line 1)\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\n\t                                                ^^^^^^^^\nName clash: The method foo(T) of type J<T> has the same erasure as foo(U) of type I<U> but does not override it\n----------\n");
    }

    public void test002b() {
        this.runNegativeTest(new String[]{"YY.java", "public class YY<T> extends X { public void foo(T t) {} }\n", "X.java", "class X<U> { public void foo(U u) {} }\n"}, "----------\n1. WARNING in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                           ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n2. ERROR in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                                           ^^^^^^^^\nName clash: The method foo(T) of type YY<T> has the same erasure as foo(Object) of type X but does not override it\n----------\n");
    }

    public void test002c() {
        this.runNegativeTest(new String[]{"JJ.java", "public class JJ<T> implements I { public void foo(T t) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "----------\n1. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t             ^^\nThe type JJ<T> must implement the inherited abstract method I.foo(Object)\n----------\n2. WARNING in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                              ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n3. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                                              ^^^^^^^^\nName clash: The method foo(T) of type JJ<T> has the same erasure as foo(Object) of type I but does not override it\n----------\n");
    }

    public void test002d() {
        this.runConformTest(new String[]{"YYY.java", "public class YYY<T> extends X<T> { public void foo(T t) {} }\n", "X.java", "class X<U> { public void foo(U u) {} }\n"}, "");
    }

    public void test002e() {
        this.runConformTest(new String[]{"JJJ.java", "public class JJJ<T> implements I<T> { public void foo(T t) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
    }

    public void test003() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runNegativeTest(new String[]{"Y.java", "public class Y<T> extends X<A> { public void foo(T t) {} }\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y<T> extends X<A> { public void foo(T t) {} }\n\t                                             ^^^^^^^^\nName clash: The method foo(T) of type Y<T> has the same erasure as foo(U) of type X<U> but does not override it\n----------\n", null, false, null);
    }

    public void test003a() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runNegativeTest(new String[]{"J.java", "public class J<T> implements I<A> { public void foo(T t) {} }\n"}, "----------\n1. ERROR in J.java (at line 1)\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\n\t             ^\nThe type J<T> must implement the inherited abstract method I<A>.foo(A)\n----------\n2. ERROR in J.java (at line 1)\n\tpublic class J<T> implements I<A> { public void foo(T t) {} }\n\t                                                ^^^^^^^^\nName clash: The method foo(T) of type J<T> has the same erasure as foo(U) of type I<U> but does not override it\n----------\n", null, false, null);
    }

    public void test003b() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runNegativeTest(new String[]{"YY.java", "public class YY<T> extends X { public void foo(T t) {} }\n"}, "----------\n1. WARNING in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                           ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n2. ERROR in YY.java (at line 1)\n\tpublic class YY<T> extends X { public void foo(T t) {} }\n\t                                           ^^^^^^^^\nName clash: The method foo(T) of type YY<T> has the same erasure as foo(Object) of type X but does not override it\n----------\n", null, false, null);
    }

    public void test003c() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runNegativeTest(new String[]{"JJ.java", "public class JJ<T> implements I { public void foo(T t) {} }\n"}, "----------\n1. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t             ^^\nThe type JJ<T> must implement the inherited abstract method I.foo(Object)\n----------\n2. WARNING in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                              ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n3. ERROR in JJ.java (at line 1)\n\tpublic class JJ<T> implements I { public void foo(T t) {} }\n\t                                              ^^^^^^^^\nName clash: The method foo(T) of type JJ<T> has the same erasure as foo(Object) of type I but does not override it\n----------\n", null, false, null);
    }

    public void test003d() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runConformTest(new String[]{"YYY.java", "public class YYY<T> extends X<T> { public void foo(T t) {} }\n"}, "", null, false, null);
    }

    public void test003e() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public void foo(U u) {} }\n", "I.java", "interface I<U> { public void foo(U u); }\n"}, "");
        this.runConformTest(new String[]{"JJJ.java", "public class JJJ<T> implements I<T> { public void foo(T t) {} }\n"}, "", null, false, null);
    }

    public void test004() {
        this.runNegativeTest(new String[]{"ALL.java", "class A {}\nclass B {}\nclass X<U> { public U foo() {return null;} }\ninterface I<U> { public U foo(); }\nclass J<T> implements I<B> { public T foo() {return null;} }\nclass K<T> implements I<T> { public T foo() {return null;} }\nclass L<T> implements I { public T foo() {return null;} }\nclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\nclass Z<T> extends X<T> { @Override public T foo() { return super.foo(); } }\nclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n"}, "----------\n1. ERROR in ALL.java (at line 5)\n\tclass J<T> implements I<B> { public T foo() {return null;} }\n\t                                    ^\nThe return type is incompatible with I<B>.foo()\n----------\n2. WARNING in ALL.java (at line 7)\n\tclass L<T> implements I { public T foo() {return null;} }\n\t                      ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n3. ERROR in ALL.java (at line 8)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                           ^\nThe return type is incompatible with X<A>.foo()\n----------\n4. ERROR in ALL.java (at line 8)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                                            ^^^^^^^^^^^\nType mismatch: cannot convert from A to T\n----------\n5. WARNING in ALL.java (at line 10)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                   ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n6. ERROR in ALL.java (at line 10)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                                                         ^^^^^^^^^^^\nType mismatch: cannot convert from Object to T\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public U foo() {return null;} }\n", "I.java", "interface I<U> { public U foo(); }\n", "J.java", "class J<T> implements I<B> { public T foo() {return null;} }\n", "K.java", "class K<T> implements I<T> { public T foo() {return null;} }\n", "L.java", "class L<T> implements I { public T foo() {return null;} }\n", "Y.java", "class Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n", "Z.java", "class Z<T> extends X<T> { @Override public T foo() { return super.foo(); } }\n", "W.java", "class W<T> extends X { @Override public T foo() { return super.foo(); } }\n"}, "----------\n1. ERROR in J.java (at line 1)\n\tclass J<T> implements I<B> { public T foo() {return null;} }\n\t                                    ^\nThe return type is incompatible with I<B>.foo()\n----------\n----------\n1. WARNING in L.java (at line 1)\n\tclass L<T> implements I { public T foo() {return null;} }\n\t                      ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n----------\n1. ERROR in Y.java (at line 1)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                           ^\nThe return type is incompatible with X<A>.foo()\n----------\n2. ERROR in Y.java (at line 1)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                                            ^^^^^^^^^^^\nType mismatch: cannot convert from A to T\n----------\n----------\n1. WARNING in W.java (at line 1)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                   ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n2. ERROR in W.java (at line 1)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                                                         ^^^^^^^^^^^\nType mismatch: cannot convert from Object to T\n----------\n");
    }

    public void test006() {
        this.runConformTest(new String[]{"A.java", "class A {}\n", "B.java", "class B {}\n", "X.java", "class X<U> { public U foo() {return null;} }\n", "I.java", "interface I<U> { public U foo(); }\n"}, "");
        this.runNegativeTest(new String[]{"J.java", "class J<T> implements I<B> { public T foo() {return null;} }\n", "K.java", "class K<T> implements I<T> { public T foo() {return null;} }\n", "L.java", "class L<T> implements I { public T foo() {return null;} }\n", "Y.java", "class Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n", "Z.java", "class Z<T> extends X<T> { @Override public T foo() { return super.foo(); } }\n", "W.java", "class W<T> extends X { @Override public T foo() { return super.foo(); } }\n"}, "----------\n1. ERROR in J.java (at line 1)\n\tclass J<T> implements I<B> { public T foo() {return null;} }\n\t                                    ^\nThe return type is incompatible with I<B>.foo()\n----------\n----------\n1. WARNING in L.java (at line 1)\n\tclass L<T> implements I { public T foo() {return null;} }\n\t                      ^\nI is a raw type. References to generic type I<U> should be parameterized\n----------\n----------\n1. ERROR in Y.java (at line 1)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                           ^\nThe return type is incompatible with X<A>.foo()\n----------\n2. ERROR in Y.java (at line 1)\n\tclass Y<T> extends X<A> { @Override public T foo() { return super.foo(); } }\n\t                                                            ^^^^^^^^^^^\nType mismatch: cannot convert from A to T\n----------\n----------\n1. WARNING in W.java (at line 1)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                   ^\nX is a raw type. References to generic type X<U> should be parameterized\n----------\n2. ERROR in W.java (at line 1)\n\tclass W<T> extends X { @Override public T foo() { return super.foo(); } }\n\t                                                         ^^^^^^^^^^^\nType mismatch: cannot convert from Object to T\n----------\n", null, false, null);
    }

    public void test007() {
        this.runConformTest(new String[]{"A.java", "abstract class A implements I {}\ninterface I extends J { String foo(); }\ninterface J { Object foo(); }\n", "X.java", "abstract class X1 extends A implements J {}\n"}, "");
    }

    public void test007a() {
        this.runNegativeTest(new String[]{"A.java", "abstract class A implements I {}\ninterface I extends J { Object foo(); }\ninterface J { String foo(); }\n", "X.java", "abstract class X2 extends A implements J {}\n"}, "----------\n1. ERROR in A.java (at line 2)\n\tinterface I extends J { Object foo(); }\n\t                        ^^^^^^\nThe return type is incompatible with J.foo()\n----------\n");
    }

    public void test007b() {
        this.runConformTest(new String[]{"A.java", "abstract class A implements I {}\ninterface I { String foo(); }\n", "X.java", "abstract class X3 extends A implements J {}\ninterface J { Object foo(); }\n"}, "");
    }

    public void test007c() {
        this.runConformTest(new String[]{"A.java", "abstract class A implements I {}\ninterface I { Object foo(); }\n", "X.java", "abstract class X4 extends A implements J {}\ninterface J { String foo(); }\n"}, "");
    }

    public void test007d() {
        this.runConformTest(new String[]{"A.java", "class A { public String foo() { return null; } }\ninterface I { Object foo(); }\n", "X.java", "abstract class X5 extends A implements I {}\n"}, "");
    }

    public void test007e() {
        this.runNegativeTest(new String[]{"A.java", "class A { public Object foo() { return null; } }\ninterface I { String foo(); }\n", "X.java", "abstract class X6 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X6 extends A implements I {}\n\t               ^^\nThe type X6 must implement the inherited abstract method I.foo() to override A.foo()\n----------\n");
    }

    public void test007f() {
        this.runNegativeTest(new String[]{"A.java", "class A { int get(short i, short s) { return i; } }\nclass B extends A { @Override short get(short i, short s) {return i; } }\n"}, "----------\n1. ERROR in A.java (at line 2)\n\tclass B extends A { @Override short get(short i, short s) {return i; } }\n\t                              ^^^^^\nThe return type is incompatible with A.get(short, short)\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"ALL.java", "interface I { I foo(); }\nclass A implements I { public A foo() { return null; } }\nclass B extends A { @Override public B foo() { return null; } }\nclass C extends B { @Override public A foo() { return null; } }\nclass D extends B implements I {}\n"}, "----------\n1. ERROR in ALL.java (at line 4)\n\tclass C extends B { @Override public A foo() { return null; } }\n\t                                     ^\nThe return type is incompatible with B.foo()\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"A.java", "class G<T> {}\ninterface I { void foo(G<I> x); }\nabstract class A implements I { void foo(G<A> x) {} }\n"}, "----------\n1. ERROR in A.java (at line 3)\n\tabstract class A implements I { void foo(G<A> x) {} }\n\t                                     ^^^^^^^^^^^\nName clash: The method foo(G<A>) of type A has the same erasure as foo(G<I>) of type I but does not override it\n----------\n");
    }

    public void test009a() {
        this.runNegativeTest(new String[]{"A.java", "class G<T> {}\ninterface I { I foo(G<I> x); }\nabstract class A implements I { I foo(G<A> x) { return null; } }\n"}, "----------\n1. ERROR in A.java (at line 3)\n\tabstract class A implements I { I foo(G<A> x) { return null; } }\n\t                                  ^^^^^^^^^^^\nName clash: The method foo(G<A>) of type A has the same erasure as foo(G<I>) of type I but does not override it\n----------\n");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public X foo() {\n        System.out.println(\"Did NOT add bridge method\");\n        return this;\n    }\n    public static void main(String[] args) throws Exception {\n        X x = new A();\n        x.foo();\n        System.out.print(\" + \");\n        I i = new A();\n        i.foo();\n    }\n}\ninterface I {\n    public I foo();\n}\nclass A extends X implements I {\n    public A foo() {\n        System.out.print(\"Added bridge method\");\n        return this;\n    }\n}\n"}, "Added bridge method + Added bridge method");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T> void foo(T t) {} }\ninterface I { <T> void foo(T t); }\n", "X.java", "abstract class X1 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X1 extends A implements I {}\n\t               ^^\nThe inherited method A.foo(T) cannot hide the public abstract method in I\n----------\n");
    }

    public void test011a() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T, S> void foo(T t) {} }\ninterface I { <T> void foo(T t); }\n", "X.java", "abstract class X2 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X2 extends A implements I {}\n\t               ^^\nName clash: The method foo(T) of type A has the same erasure as foo(T) of type I but does not override it\n----------\n");
    }

    public void test011b() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T> void foo(T t) {} }\ninterface I { <T, S> void foo(T t); }\n", "X.java", "abstract class X3 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X3 extends A implements I {}\n\t               ^^\nName clash: The method foo(T) of type A has the same erasure as foo(T) of type I but does not override it\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"A.java", "class A { public <T> void foo(T s) {} }\nclass Y1 extends A { @Override void foo(Object s) {} }\n"}, "----------\n1. ERROR in A.java (at line 2)\n\tclass Y1 extends A { @Override void foo(Object s) {} }\n\t                                    ^^^^^^^^^^^^^\nCannot reduce the visibility of the inherited method from A\n----------\n");
    }

    public void test012a() {
        this.runNegativeTest(new String[]{"A.java", "class A { public <T> void foo(T[] s) {} }\nclass Y2 extends A { @Override void foo(Object[] s) {} }\n"}, "----------\n1. ERROR in A.java (at line 2)\n\tclass Y2 extends A { @Override void foo(Object[] s) {} }\n\t                                    ^^^^^^^^^^^^^^^\nCannot reduce the visibility of the inherited method from A\n----------\n");
    }

    public void test012b() {
        this.runNegativeTest(new String[]{"A.java", "class A { public void foo(Class<Object> s) {} }\nclass Y3 extends A { @Override void foo(Class<Object> s) {} }\n"}, "----------\n1. ERROR in A.java (at line 2)\n\tclass Y3 extends A { @Override void foo(Class<Object> s) {} }\n\t                                    ^^^^^^^^^^^^^^^^^^^^\nCannot reduce the visibility of the inherited method from A\n----------\n");
    }

    public void test013() {
        this.runConformTest(new String[]{"A.java", "class A { public <T> void foo(Class<T> s) {} }\ninterface I { <T> void foo(Class<T> s); }\n", "X.java", "abstract class X0 extends A implements I {}\n"}, "");
    }

    public void test013a() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T, S> void foo(Class<T> s) {} }\ninterface I { <T> void foo(Class<T> s); }\n", "X.java", "abstract class X1 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X1 extends A implements I {}\n\t               ^^\nName clash: The method foo(Class<T>) of type A has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n");
    }

    public void test013b() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T> void foo(Class<T> s) {} }\ninterface I { <T, S> void foo(Class<T> s); }\n", "X.java", "abstract class X2 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X2 extends A implements I {}\n\t               ^^\nName clash: The method foo(Class<T>) of type A has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n");
    }

    public void test013c() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T, S> S foo(Class<T> s) { return null; } }\ninterface I { <T> Object foo(Class<T> s); }\n", "X.java", "abstract class X3 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X3 extends A implements I {}\n\t               ^^\nName clash: The method foo(Class<T>) of type A has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n");
    }

    public void test013d() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T> Object foo(Class<T> s) { return null; } }\ninterface I { <T, S> S foo(Class<T> s); }\n", "X.java", "abstract class X4 extends A implements I {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X4 extends A implements I {}\n\t               ^^\nName clash: The method foo(Class<T>) of type A has the same erasure as foo(Class<T>) of type I but does not override it\n----------\n");
    }

    public void test013e() {
        this.runNegativeTest(new String[]{"A.java", "class A { public <T, S> void foo(Class<T> s) {} }\ninterface I { <T> void foo(Class<T> s); }\n", "X.java", "class X5 extends A implements I { public <T> void foo(Class<T> s) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X5 extends A implements I { public <T> void foo(Class<T> s) {} }\n\t                                                  ^^^^^^^^^^^^^^^\nName clash: The method foo(Class<T>) of type X5 has the same erasure as foo(Class<T>) of type A but does not override it\n----------\n");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "class X { void foo(A a) {} }\nclass Y extends X { void foo(A a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test014a() {
        this.runConformTest(new String[]{"X.java", "class X { void foo(A[] a) {} }\nclass Y extends X { void foo(A[] a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test014b() {
        this.runConformTest(new String[]{"X.java", "class X { void foo(A<String>[] a) {} }\nclass Y extends X { void foo(A[] a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test014c() {
        this.runConformTest(new String[]{"X.java", "class X { void foo(A<String> a) {} }\nclass Y extends X { void foo(A a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test014d() {
        this.runNegativeTest(new String[]{"X.java", "class X { void foo(A a) {} }\nclass Y extends X { void foo(A<String> a) {} }\nclass A<T> {}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tclass X { void foo(A a) {} }\n\t                   ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tclass Y extends X { void foo(A<String> a) {} }\n\t                         ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type Y has the same erasure as foo(A) of type X but does not override it\n----------\n");
    }

    public void test014e() {
        this.runNegativeTest(new String[]{"X.java", "class X { void foo(A[] a) {} }\nclass Y extends X { void foo(A<String>[] a) {} }\nclass A<T> {}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tclass X { void foo(A[] a) {} }\n\t                   ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tclass Y extends X { void foo(A<String>[] a) {} }\n\t                         ^^^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>[]) of type Y has the same erasure as foo(A[]) of type X but does not override it\n----------\n");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A a); }\nclass Y { public void foo(A a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test015a() {
        this.runConformTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A[] a); }\nclass Y { public void foo(A[] a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test015b() {
        this.runConformTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A<String>[] a); }\nclass Y { public void foo(A[] a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test015c() {
        this.runConformTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A<String> a); }\nclass Y { public void foo(A a) {} }\nclass A<T> {}\n"}, "");
    }

    public void test015d() {
        this.runNegativeTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A a); }\nclass Y { public void foo(A<String> a) {} }\nclass A<T> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X extends Y implements I { }\n\t               ^\nName clash: The method foo(A<String>) of type Y has the same erasure as foo(A) of type I but does not override it\n----------\n2. WARNING in X.java (at line 2)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test015e() {
        this.runNegativeTest(new String[]{"X.java", "abstract class X extends Y implements I { }\ninterface I { void foo(A[] a); }\nclass Y { public void foo(A<String>[] a) {} }\nclass A<T> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tabstract class X extends Y implements I { }\n\t               ^\nName clash: The method foo(A<String>[]) of type Y has the same erasure as foo(A[]) of type I but does not override it\n----------\n2. WARNING in X.java (at line 2)\n\tinterface I { void foo(A[] a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t<E extends A> void m(E e) { System.out.print(\"A=\"+e.getClass()); }\n\t<E extends B> void m(E e) { System.out.print(\"B=\"+e.getClass()); }\n\tpublic static void main(String[] args) {\n\t\tnew X().m(new A());\n\t\tnew X().m(new B());\n\t}\n}\nclass A {}\nclass B extends A {}\n"}, "A=class AB=class B");
    }

    public void test016b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic <E extends A> void m(E e) { System.out.print(\"A=\"+e.getClass()); }\n\tstatic <E extends B> void m(E e) { System.out.print(\"B=\"+e.getClass()); }\n\tpublic static void main(String[] args) {\n\t\tm(new A());\n\t\tm(new B());\n\t}\n}\nclass A {}\nclass B extends A {}\n"}, "A=class AB=class B");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "class X<T> {}\nclass Y { void test(X<? extends Number> a) {} }\nclass Z extends Y { void test(X<Number> a) {} }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tclass Z extends Y { void test(X<Number> a) {} }\n\t                         ^^^^^^^^^^^^^^^^^\nName clash: The method test(X<Number>) of type Z has the same erasure as test(X<? extends Number>) of type Y but does not override it\n----------\n");
    }

    public void test017a() {
        this.runNegativeTest(new String[]{"X.java", "class X<T> {}\nclass Y { void test(X<Number> a) {} }\nclass Z extends Y { void test(X<? extends Number> a) {} }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tclass Z extends Y { void test(X<? extends Number> a) {} }\n\t                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method test(X<? extends Number>) of type Z has the same erasure as test(X<Number>) of type Y but does not override it\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "class X implements Comparable<X> {\n\tpublic int compareTo(Object o) { return 0; }\n\tpublic int compareTo(X o) { return 1; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic int compareTo(Object o) { return 0; }\n\t           ^^^^^^^^^^^^^^^^^^^\nName clash: The method compareTo(Object) of type X has the same erasure as compareTo(T) of type Comparable<T> but does not override it\n----------\n");
    }

    public void test019() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\t<T> T get() { return null; } \n}\nclass B extends A {\n\t<T> T get() { return null; } \n}\n"}, "");
    }

    public void test020() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tpublic static void main(String[] args) {\n\t\tAbstractBase ab = new AbstractBase();\n\t\tDerived d = new Derived();\n\t\tAbstractBase ab2 = new Derived();\n\t\tVisitor<String, String> v = new MyVisitor();\n\t\tSystem.out.print(ab.accept(v, ab.getClass().getName()));\n\t\tSystem.out.print('+');\n\t\tSystem.out.print(d.accept(v, d.getClass().getName()));\n\t\tSystem.out.print('+');\n\t\tSystem.out.print(ab2.accept(v, ab2.getClass().getName()));\n\t}\n\tstatic class MyVisitor implements Visitor<String, String> {\n\t\tpublic String visitBase(AbstractBase ab, String obj) { return \"Visited base: \" + obj; }\n\t\tpublic String visitDerived(Derived d, String obj) { return \"Visited derived: \" + obj; }\n\t}\n}\ninterface Visitor<R, T> {\n\tR visitBase(AbstractBase ab, T obj);\n\tR visitDerived(Derived d, T obj);\n}\ninterface Visitable {\n\t<R, T> R accept(Visitor<R, T> v, T obj);\n}\nclass AbstractBase implements Visitable {\n\tpublic <R, T> R accept(Visitor<R, T> v, T obj) { return v.visitBase(this, obj); }\n}\nclass Derived extends AbstractBase implements Visitable {\n\tpublic <R, T> R accept(Visitor<R, T> v, T obj) { return v.visitDerived(this, obj); }\n}\n"}, "Visited base: AbstractBase+Visited derived: Derived+Visited derived: Derived");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tpublic void foo(java.util.Map<String, Class<?>> m) { } \n}\n", "B.java", "class B extends A {\n\t@Override void foo(java.util.Map<String, Class<?>> m) { } \n}\n"}, "----------\n1. ERROR in B.java (at line 2)\n\t@Override void foo(java.util.Map<String, Class<?>> m) { } \n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot reduce the visibility of the inherited method from A\n----------\n");
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic void foo(java.util.Map<String, Class<?>> m) { } \n}\n"}, "");
        this.runNegativeTest(new String[]{"B.java", "class B extends A {\n\t@Override void foo(java.util.Map<String, Class<?>> m) { } \n}\n"}, "----------\n1. ERROR in B.java (at line 2)\n\t@Override void foo(java.util.Map<String, Class<?>> m) { } \n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot reduce the visibility of the inherited method from A\n----------\n", null, false, null);
    }

    public void test022() {
        this.runConformTest(new String[]{"A.java", "import java.util.*;\nclass A { List getList() { return null; } }\nclass B extends A { @Override List<String> getList() { return null; } }\n"}, "");
    }

    public void test022a() {
        this.runNegativeTest(new String[]{"A.java", "import java.util.*;\nclass A { List<String> getList() { return null; } }\nclass B extends A { @Override List getList() { return null; } }\n"}, "----------\n1. WARNING in A.java (at line 3)\n\tclass B extends A { @Override List getList() { return null; } }\n\t                              ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in A.java (at line 3)\n\tclass B extends A { @Override List getList() { return null; } }\n\t                              ^^^^\nType safety: The return type List for getList() from the type B needs unchecked conversion to conform to List<String> from the type A\n----------\n");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"A.java", "class A<T> {\n\tvoid foo(T t) {}\n\tvoid foo(String i) {}\n}\nclass B extends A<String> {}\n"}, "----------\n1. ERROR in A.java (at line 5)\n\tclass B extends A<String> {}\n\t      ^\nDuplicate methods named foo with the parameters (String) and (T) are defined by the type A<String>\n----------\n");
    }

    public void test024() {
        this.runConformTest(new String[]{"A.java", "class A {\n\tpublic <E extends Object> void m(E e) {}\n}\nclass B extends A {\n\tpublic void m(Object e) {}\n}\n"}, "");
    }

    public void test024a() {
        this.runNegativeTest(new String[]{"A.java", "class A {\n\tpublic void m(Object e) {}\n}\nclass B extends A {\n\tpublic <E extends Object> void m(E e) {}\n}\n"}, "----------\n1. ERROR in A.java (at line 5)\n\tpublic <E extends Object> void m(E e) {}\n\t                               ^^^^^^\nName clash: The method m(E) of type B has the same erasure as m(Object) of type A but does not override it\n----------\n");
    }

    public void test024b() {
        this.runNegativeTest(new String[]{"A.java", "class A {\n\tpublic <E extends Object> void m(E e) {}\n}\nclass B extends A {\n\t@Override public void m(Object e) {}\n}\nclass C extends B {\n\tpublic <E extends Object> void m(E e) {}\n}\n"}, "----------\n1. ERROR in A.java (at line 8)\n\tpublic <E extends Object> void m(E e) {}\n\t                               ^^^^^^\nName clash: The method m(E) of type C has the same erasure as m(Object) of type B but does not override it\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew B().test();\n\t}\n}\nclass A {\n\t<T extends Number> T test() { return null; }\n}\nclass B extends A {\n\t@Override Integer test() { return 1; }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\t@Override Integer test() { return 1; }\n\t          ^^^^^^^\nType safety: The return type Integer for test() from the type B needs unchecked conversion to conform to T from the type A\n----------\n");
    }

    public void test025a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew B().test();\n\t}\n}\nclass A {\n\t<T extends Number> T[] test() { return null; }\n}\nclass B extends A {\n\t@Override Integer[] test() { return new Integer[] {2}; }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\t@Override Integer[] test() { return new Integer[] {2}; }\n\t          ^^^^^^^^^\nType safety: The return type Integer[] for test() from the type B needs unchecked conversion to conform to T[] from the type A\n----------\n");
    }

    public void test025b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new B().<Integer>test(new Integer(1)));\n\t}\n}\nclass A {\n\t<T> T test(T t) { return null; }\n}\nclass B extends A {\n\t@Override <T> T test(T t) { return t; }\n}\n"}, "1");
    }

    public void test025c() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new B().<Number>test(1));\n\t}\n}\nclass A<T> {\n\t<U> T test(U u) { return null; }\n}\nclass B extends A<Integer> {\n\t@Override <U> Integer test(U u) { return 1; }\n}\n"}, "1");
    }

    public void test025d() {
        this.runConformTest(new String[]{"A.java", "import java.util.concurrent.Callable;\npublic class A {\n\tpublic static void main(String[] args) throws Exception {\n\t\tCallable<Integer> integerCallable = new Callable<Integer>() {\n\t\t\tpublic Integer call() { return new Integer(1); }\n\t\t};\n\t\tSystem.out.println(integerCallable.call());\n\t}\n}\n"}, "1");
    }

    public void test025e() {
        this.runConformTest(true, new String[]{"X.java", "interface X<T extends X> { T x(); }\nabstract class Y<S extends X> implements X<S> { public abstract S x(); }\nabstract class Z implements X { public abstract X x(); }\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tinterface X<T extends X> { T x(); }\n\t                      ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tabstract class Y<S extends X> implements X<S> { public abstract S x(); }\n\t                           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X x(); }\n\t                            ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X x(); }\n\t                                                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test025f() {
        this.runConformTest(true, new String[]{"X.java", "interface X<T extends X> { T[] x(); }\nabstract class Y<S extends X> implements X<S> { public abstract S[] x(); }\nabstract class Z implements X { public abstract X[] x(); }\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tinterface X<T extends X> { T[] x(); }\n\t                      ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tabstract class Y<S extends X> implements X<S> { public abstract S[] x(); }\n\t                           ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X[] x(); }\n\t                            ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X[] x(); }\n\t                                                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\n\t\t\tnew B().test().getClass() + \" & \"\n\t\t\t+ new C().test().getClass() + \" & \"\n\t\t\t+ new D().test().getClass());\n\t}\n}\nclass A<T extends Number> {\n\tA<T> test() { return this; }\n}\nclass B extends A {\n\tA test() { return super.test(); }\n}\nclass C extends A<Integer> {\n\tA<Integer> test() { return super.test(); }\n}\nclass D<U, V extends Number> extends A<V> {\n\tA<V> test() { return super.test(); }\n}\n"}, "class B & class C & class D");
    }

    public void test026a() {
        this.runConformTest(new String[]{"A.java", "public abstract class A<E> {\n\tpublic abstract A<E> test();\n}\nclass H<K,V> {\n\tclass M extends A<K> {\n\t\tpublic A<K> test() { return null; }\n\t}\n}\n"}, "");
    }

    public void test026b() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X extends java.util.AbstractMap {\n\tpublic java.util.Set entrySet() { return null; }\n}\n"}, "");
    }

    public void test026c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(new C().test().getClass());\n\t}\n}\nclass A<T extends Number> {\n\tA<T> test() { return this; }\n}\nclass C extends A<Integer> {\n\t@Override A test() { return super.test(); }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\t@Override A test() { return super.test(); }\n\t          ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. WARNING in X.java (at line 10)\n\t@Override A test() { return super.test(); }\n\t          ^\nType safety: The return type A for test() from the type C needs unchecked conversion to conform to A<T> from the type A<T>\n----------\n");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "public class X { <T> void test() {} }\nclass Y extends X { void test() {} }\n"}, "");
    }

    public void test027a() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void test() {} }\nclass Y extends X { <T> void test() {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends X { <T> void test() {} }\n\t                             ^^^^^^\nName clash: The method test() of type Y has the same erasure as test() of type X but does not override it\n----------\n");
    }

    public void test027b() {
        this.runConformTest(new String[]{"X.java", "public class X<T> { void test(T o) {} }\nclass Y<T> extends X<T> { void test(Object o) {} }\n"}, "");
    }

    public void test027c() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> { void test(T o, T t) {} }\nclass Y<T> extends X<T> { void test(Object o, T t) {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y<T> extends X<T> { void test(Object o, T t) {} }\n\t                               ^^^^^^^^^^^^^^^^^^^\nName clash: The method test(Object, T) of type Y<T> has the same erasure as test(T, T) of type X<T> but does not override it\n----------\n");
    }

    public void test027d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test() {\n\t\tPair<Double, Integer> p = new InvertedPair<Integer, Double>();\n\t\tp.setA(new Double(1.1));\n\t}\n}\nclass Pair<A, B> {\n\tpublic void setA(A a) {}\n}\nclass InvertedPair<A, B> extends Pair<B, A> {\n\tpublic void setA(A a) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tpublic void setA(A a) {}\n\t            ^^^^^^^^^\nName clash: The method setA(A) of type InvertedPair<A,B> has the same erasure as setA(A) of type Pair<A,B> but does not override it\n----------\n");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "public class X implements I<X>{\n\tpublic X foo() { return null; }\n}\ninterface I<T extends I> { T foo(); }\n"}, "");
    }

    public void test029() {
        this.runConformTest(new String[]{"I.java", "public interface I {\n\tpublic I clone();\n}\ninterface J extends I {}\n"}, "");
    }

    public void test030() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "1.4");
        this.runConformTest(new String[]{"X.java", "import java.io.OutputStreamWriter;\nimport java.io.PrintWriter;\npublic class X extends PrintWriter implements Runnable {\n\tpublic X(OutputStreamWriter out, boolean flag) { super(out, flag); }\n\tpublic void run() {}\n}\n"}, "", null, false, null, options, null);
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.java", "interface X { long hashCode(); }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tinterface X { long hashCode(); }\n\t              ^^^^\nThe return type is incompatible with Object.hashCode()\n----------\n");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "interface I { Integer foo(); }\ninterface J { Integer foo(); }\npublic class X<T extends I&J> implements I {\n\tpublic Integer foo() { return null; }\n}"}, "");
    }

    public void test032a() {
        this.runNegativeTest(new String[]{"X.java", "interface I { Float foo(); }\ninterface J { Integer foo(); }\npublic class X<T extends I&J> {}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic class X<T extends I&J> {}\n\t               ^\nThe return types are incompatible for the inherited methods I.foo(), J.foo()\n----------\n");
    }

    public void test032b() {
        this.runNegativeTest(new String[]{"X.java", "interface I { String foo(); }\nclass A { public Object foo() { return null; } }\npublic class X<T extends A&I> {}\ninterface J extends I { Object foo(); }\nclass Y<T extends I&J> {}\nclass Z<T extends J&I> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic class X<T extends A&I> {}\n\t               ^\nThe return types are incompatible for the inherited methods I.foo(), A.foo()\n----------\n2. ERROR in X.java (at line 4)\n\tinterface J extends I { Object foo(); }\n\t                        ^^^^^^\nThe return type is incompatible with I.foo()\n----------\n");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "interface I { Number foo(); }\ninterface J { Integer foo(); }\npublic class X implements I, J {\n\tpublic Integer foo() {return 1;}\n\tpublic static void main(String argv[]) {\n\t\tI i = null;\n\t\tJ j = null;\n\t\tSystem.out.print(i instanceof J);\n\t\tSystem.out.print('=');\n\t\tSystem.out.print(j instanceof I);\n\t}\n}\n"}, "false=false");
    }

    public void test033a() {
        this.runConformTest(new String[]{"X.java", "interface I { Number foo(A a); }\ninterface J<T> { Integer foo(A<T> a); }\nclass A<T>{}\npublic class X implements I, J {\n\tpublic Integer foo(A a) {return 1;}\n\tpublic static void main(String argv[]) {\n\t\tI i = null;\n\t\tJ j = null;\n\t\tSystem.out.print(i instanceof J);\n\t\tSystem.out.print('=');\n\t\tSystem.out.print(j instanceof I);\n\t}\n}\n"}, "false=false");
    }

    public void test034() {
        this.runConformTest(new String[]{"B.java", "interface I<E extends Comparable<E>> { void test(E element); }\nclass A implements I<Integer> { public void test(Integer i) {} }\npublic class B extends A { public void test(String i) {} }\n"}, "");
    }

    public void test034a() {
        this.runConformTest(new String[]{"B.java", "interface I<E extends Comparable> { void test(E element); }\nclass A { public void test(Integer i) {} }\npublic class B extends A implements I<Integer> {}\nclass C extends B { public void test(Object i) {} }\n"}, "");
    }

    public void test034b() {
        this.runNegativeTest(new String[]{"B.java", "interface I<E extends Comparable> { void test(E element); }\nclass A { public void test(Integer i) {} }\npublic class B extends A implements I<Integer> { public void test(Comparable i) {} }\n"}, "----------\n1. WARNING in B.java (at line 1)\n\tinterface I<E extends Comparable> { void test(E element); }\n\t                      ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. ERROR in B.java (at line 3)\n\tpublic class B extends A implements I<Integer> { public void test(Comparable i) {} }\n\t                                                             ^^^^^^^^^^^^^^^^^^\nName clash: The method test(Comparable) of type B has the same erasure as test(E) of type I<E> but does not override it\n----------\n3. WARNING in B.java (at line 3)\n\tpublic class B extends A implements I<Integer> { public void test(Comparable i) {} }\n\t                                                                  ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test034c() {
        this.runNegativeTest(new String[]{"B.java", "interface I<E extends Comparable<E>> { void test(E element); }\nclass A implements I<Integer> { public void test(Integer i) {} }\npublic class B extends A { public void test(Comparable i) {} }\n"}, "----------\n1. ERROR in B.java (at line 3)\n\tpublic class B extends A { public void test(Comparable i) {} }\n\t                                       ^^^^^^^^^^^^^^^^^^\nName clash: The method test(Comparable) of type B has the same erasure as test(E) of type I<E> but does not override it\n----------\n2. WARNING in B.java (at line 3)\n\tpublic class B extends A { public void test(Comparable i) {} }\n\t                                            ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test034d() {
        this.runNegativeTest(new String[]{"B.java", "abstract class AA<E extends Comparable> { abstract void test(E element); }\nclass A extends AA<Integer> { @Override public void test(Integer i) {} }\npublic class B extends A { public void test(Comparable i) {} }\n"}, "----------\n1. WARNING in B.java (at line 1)\n\tabstract class AA<E extends Comparable> { abstract void test(E element); }\n\t                            ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n2. ERROR in B.java (at line 3)\n\tpublic class B extends A { public void test(Comparable i) {} }\n\t                                       ^^^^^^^^^^^^^^^^^^\nName clash: The method test(Comparable) of type B has the same erasure as test(E) of type AA<E> but does not override it\n----------\n3. WARNING in B.java (at line 3)\n\tpublic class B extends A { public void test(Comparable i) {} }\n\t                                            ^^^^^^^^^^\nComparable is a raw type. References to generic type Comparable<T> should be parameterized\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"E.java", "interface I<U>{ int compareTo(U o); }\nabstract class F<T extends F<T>> implements I<T>{ public final int compareTo(T o) { return 0; } }\npublic class E extends F<E> { public int compareTo(Object o) { return 0; } }\n"}, "----------\n1. ERROR in E.java (at line 3)\n\tpublic class E extends F<E> { public int compareTo(Object o) { return 0; } }\n\t                                         ^^^^^^^^^^^^^^^^^^^\nName clash: The method compareTo(Object) of type E has the same erasure as compareTo(U) of type I<U> but does not override it\n----------\n");
    }

    public void test035a() {
        this.runNegativeTest(new String[]{"X.java", "public enum X {\n\t;\n\tpublic int compareTo(Object o) { return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic int compareTo(Object o) { return 0; }\n\t           ^^^^^^^^^^^^^^^^^^^\nName clash: The method compareTo(Object) of type X has the same erasure as compareTo(T) of type Comparable<T> but does not override it\n----------\n");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "class X implements Equivalent, EqualityComparable {\n\tpublic boolean equalTo(Object other) { return true; }\n}\nabstract class Y implements Equivalent, EqualityComparable {}\nclass Z extends Y {\n\tpublic boolean equalTo(Object other) { return true; }\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "");
    }

    public void test036a() {
        this.runConformTest(new String[]{"X.java", "class X implements Equivalent, EqualityComparable {\n\tpublic boolean equalTo(Comparable other) { return true; }\n\tpublic boolean equalTo(Number other) { return true; }\n}\nabstract class Y implements Equivalent, EqualityComparable {}\nclass Z extends Y {\n\tpublic boolean equalTo(Comparable other) { return true; }\n\tpublic boolean equalTo(Number other) { return true; }\n}\ninterface Equivalent<T extends Comparable> { boolean equalTo(T other); }\ninterface EqualityComparable<T extends Number> { boolean equalTo(T other); }\n"}, "");
    }

    public void test036b() {
        this.runConformTest(new String[]{"X.java", "class X<S> implements Equivalent<S>, EqualityComparable<S> {\n\tpublic boolean equalTo(S other) { return true; }\n}\nabstract class Y<S> implements Equivalent<S>, EqualityComparable<S> {}\nclass Z<U> extends Y<U> {\n\tpublic boolean equalTo(U other) { return true; }\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "");
    }

    public void test036c() {
        this.runConformTest(new String[]{"X.java", "class X<T extends Comparable, S extends Number> implements Equivalent<T>, EqualityComparable<S> {\n\tpublic boolean equalTo(T other) { return true; }\n\tpublic boolean equalTo(S other) { return true; }\n}\nabstract class Y<T extends Comparable, S extends Number> implements Equivalent<T>, EqualityComparable<S> {}\nclass Z<U extends Comparable, V extends Number> extends Y<U, V> {\n\tpublic boolean equalTo(U other) { return true; }\n\tpublic boolean equalTo(V other) { return true; }\n}\ninterface Equivalent<T extends Comparable> { boolean equalTo(T other); }\ninterface EqualityComparable<S extends Number> { boolean equalTo(S other); }\n"}, "");
    }

    public void test036d() {
        if (this.complianceLevel < 0x330000L) {
            this.runConformTest(new String[]{"Y.java", "abstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\tpublic abstract boolean equalTo(Number other);\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "");
        } else {
            this.runNegativeTest(new String[]{"Y.java", "abstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\tpublic abstract boolean equalTo(Number other);\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tabstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\t               ^\nName clash: The method equalTo(T) of type EqualityComparable<T> has the same erasure as equalTo(T) of type Equivalent<T> but does not override it\n----------\n");
        }
    }

    public void test036e() {
        this.runNegativeTest(new String[]{"Y.java", "abstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\tpublic abstract boolean equalTo(Object other);\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in Y.java (at line 2)\n\tpublic abstract boolean equalTo(Object other);\n\t                        ^^^^^^^^^^^^^^^^^^^^^\nName clash: The method equalTo(Object) of type Y has the same erasure as equalTo(T) of type EqualityComparable<T> but does not override it\n----------\n2. ERROR in Y.java (at line 2)\n\tpublic abstract boolean equalTo(Object other);\n\t                        ^^^^^^^^^^^^^^^^^^^^^\nName clash: The method equalTo(Object) of type Y has the same erasure as equalTo(T) of type Equivalent<T> but does not override it\n----------\n" : "----------\n1. ERROR in Y.java (at line 1)\n\tabstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\t               ^\nName clash: The method equalTo(T) of type EqualityComparable<T> has the same erasure as equalTo(T) of type Equivalent<T> but does not override it\n----------\n2. ERROR in Y.java (at line 2)\n\tpublic abstract boolean equalTo(Object other);\n\t                        ^^^^^^^^^^^^^^^^^^^^^\nName clash: The method equalTo(Object) of type Y has the same erasure as equalTo(T) of type EqualityComparable<T> but does not override it\n----------\n3. ERROR in Y.java (at line 2)\n\tpublic abstract boolean equalTo(Object other);\n\t                        ^^^^^^^^^^^^^^^^^^^^^\nName clash: The method equalTo(Object) of type Y has the same erasure as equalTo(T) of type Equivalent<T> but does not override it\n----------\n");
    }

    public void test036f() {
        this.runNegativeTest(new String[]{"Y.java", "abstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\tpublic abstract boolean equalTo(String other);\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tabstract class Y implements Equivalent<String>, EqualityComparable<Integer> {\n\t               ^\nName clash: The method equalTo(T) of type Equivalent<T> has the same erasure as equalTo(T) of type EqualityComparable<T> but does not override it\n----------\n");
    }

    public void test036g() {
        this.runNegativeTest(new String[]{"Y.java", "abstract class Y implements EqualityComparable<Integer>, Equivalent<String> {\n\tpublic boolean equalTo(Integer other) { return true; }\n}\ninterface Equivalent<T> { boolean equalTo(T other); }\ninterface EqualityComparable<T> { boolean equalTo(T other); }\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tabstract class Y implements EqualityComparable<Integer>, Equivalent<String> {\n\t               ^\nName clash: The method equalTo(T) of type EqualityComparable<T> has the same erasure as equalTo(T) of type Equivalent<T> but does not override it\n----------\n");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X implements I, J { }\nabstract class Y implements J, I { }\nabstract class Z implements K { }\nclass YYY implements J, I { public void foo(A a) {} }\nclass XXX implements I, J { public void foo(A a) {} }\nclass ZZZ implements K { public void foo(A a) {} }\ninterface I { void foo(A a); }\ninterface J { void foo(A<String> a); }\ninterface K extends I { void foo(A<String> a); }\nclass A<T> {}"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in X.java (at line 4)\n\tclass YYY implements J, I { public void foo(A a) {} }\n\t                                            ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tclass XXX implements I, J { public void foo(A a) {} }\n\t                                            ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\tclass ZZZ implements K { public void foo(A a) {} }\n\t                                         ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n4. WARNING in X.java (at line 7)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n5. ERROR in X.java (at line 9)\n\tinterface K extends I { void foo(A<String> a); }\n\t                             ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type K has the same erasure as foo(A) of type I but does not override it\n----------\n" : "----------\n1. WARNING in X.java (at line 4)\n\tclass YYY implements J, I { public void foo(A a) {} }\n\t                                            ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\tclass XXX implements I, J { public void foo(A a) {} }\n\t                                            ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n3. WARNING in X.java (at line 6)\n\tclass ZZZ implements K { public void foo(A a) {} }\n\t                                         ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n4. WARNING in X.java (at line 7)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n5. ERROR in X.java (at line 9)\n\tinterface K extends I { void foo(A<String> a); }\n\t                             ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type K has the same erasure as foo(A) of type I but does not override it\n----------\n");
    }

    public void test037a() {
        this.runNegativeTest(new String[]{"XX.java", "public abstract class XX implements I, J { public abstract void foo(A<String> a); }\ninterface I { void foo(A a); }\ninterface J { void foo(A<String> a); }\nclass A<T> {}"}, "----------\n1. ERROR in XX.java (at line 1)\n\tpublic abstract class XX implements I, J { public abstract void foo(A<String> a); }\n\t                                                                ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type XX has the same erasure as foo(A) of type I but does not override it\n----------\n2. WARNING in XX.java (at line 2)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test037b() {
        this.runNegativeTest(new String[]{"XX.java", "public class XX implements I, J { public void foo(A<String> a) {} }\nclass YY implements J, I { public void foo(A<String> a) {} }\nclass ZZ implements K { public void foo(A<String> a) {} }\ninterface I { void foo(A a); }\ninterface J { void foo(A<String> a); }\ninterface K extends I { void foo(A<String> a); }\nclass A<T> {}"}, "----------\n1. ERROR in XX.java (at line 1)\n\tpublic class XX implements I, J { public void foo(A<String> a) {} }\n\t             ^^\nThe type XX must implement the inherited abstract method I.foo(A)\n----------\n2. ERROR in XX.java (at line 1)\n\tpublic class XX implements I, J { public void foo(A<String> a) {} }\n\t                                              ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type XX has the same erasure as foo(A) of type I but does not override it\n----------\n3. ERROR in XX.java (at line 2)\n\tclass YY implements J, I { public void foo(A<String> a) {} }\n\t      ^^\nThe type YY must implement the inherited abstract method I.foo(A)\n----------\n4. ERROR in XX.java (at line 2)\n\tclass YY implements J, I { public void foo(A<String> a) {} }\n\t                                       ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type YY has the same erasure as foo(A) of type I but does not override it\n----------\n5. ERROR in XX.java (at line 3)\n\tclass ZZ implements K { public void foo(A<String> a) {} }\n\t      ^^\nThe type ZZ must implement the inherited abstract method I.foo(A)\n----------\n6. ERROR in XX.java (at line 3)\n\tclass ZZ implements K { public void foo(A<String> a) {} }\n\t                                    ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type ZZ has the same erasure as foo(A) of type I but does not override it\n----------\n7. WARNING in XX.java (at line 4)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n8. ERROR in XX.java (at line 6)\n\tinterface K extends I { void foo(A<String> a); }\n\t                             ^^^^^^^^^^^^^^^^\nName clash: The method foo(A<String>) of type K has the same erasure as foo(A) of type I but does not override it\n----------\n");
    }

    public void test037c() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X extends Y implements I { }\ninterface I { void foo(A a); }\nclass Y { void foo(A<String> a) {} }\nclass A<T> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract class X extends Y implements I { }\n\t                      ^\nName clash: The method foo(A<String>) of type Y has the same erasure as foo(A) of type I but does not override it\n----------\n2. WARNING in X.java (at line 2)\n\tinterface I { void foo(A a); }\n\t                       ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test037d() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X extends Y implements I { }\ninterface I { void foo(A<String> a); }\nclass Y { void foo(A a) {} }\nclass A<T> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract class X extends Y implements I { }\n\t                      ^\nThe inherited method Y.foo(A) cannot hide the public abstract method in I\n----------\n2. WARNING in X.java (at line 3)\n\tclass Y { void foo(A a) {} }\n\t                   ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n");
    }

    public void test037e() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X extends Y implements I { }\ninterface I { <T, S> void foo(T t); }\nclass Y { <T> void foo(T t) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract class X extends Y implements I { }\n\t                      ^\nName clash: The method foo(T) of type Y has the same erasure as foo(T) of type I but does not override it\n----------\n");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "public class X extends H<Object> { void foo(A<?> a) { super.foo(a); } }\nclass H<T extends Object> { void foo(A<? extends T> a) {} }\nclass A<T> {}"}, "");
    }

    public void test038a() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends H<Number> { void foo(A<?> a) {} }\nclass H<T extends Number> { void foo(A<? extends T> a) {} }\nclass A<T> {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends H<Number> { void foo(A<?> a) {} }\n\t                                        ^^^^^^^^^^^\nName clash: The method foo(A<?>) of type X has the same erasure as foo(A<? extends T>) of type H<T> but does not override it\n----------\n");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n      Test test = new Test();\n      This test2 = new Test();\n      System.out.println(test.get());\n   }\n   interface This {\n      public Object get();\n   }\n \n   interface That extends This {\n      public String get();\n \n   }\n \n   static class Test implements That {\n \n      public String get() {\n         return \"That\";\n \n      }\n   }\n}\n"}, "That");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"Base.java", "interface Base<E> { Base<E> proc(); }\nabstract class Derived<D> implements Base<D> { public abstract Derived<D> proc(); }\n"}, "");
    }

    public void test040a() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T extends Number> T test() { return null; } }\nclass B extends A { @Override Integer test() { return 1; } }\n"}, "----------\n1. WARNING in A.java (at line 2)\n\tclass B extends A { @Override Integer test() { return 1; } }\n\t                              ^^^^^^^\nType safety: The return type Integer for test() from the type B needs unchecked conversion to conform to T from the type A\n----------\n");
    }

    public void test040b() {
        this.runNegativeTest(new String[]{"A.java", "import java.util.*;\nclass A { List<String> getList() { return null; } }\nclass B extends A { @Override List getList() { return null; } }\n"}, "----------\n1. WARNING in A.java (at line 3)\n\tclass B extends A { @Override List getList() { return null; } }\n\t                              ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in A.java (at line 3)\n\tclass B extends A { @Override List getList() { return null; } }\n\t                              ^^^^\nType safety: The return type List for getList() from the type B needs unchecked conversion to conform to List<String> from the type A\n----------\n");
    }

    public void test040c() {
        this.runNegativeTest(new String[]{"X.java", "interface X<T> { X<T> x(); }\nabstract class Y<S> implements X<S> { public abstract X x(); }\nabstract class Z implements X { public abstract X x(); }\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tabstract class Y<S> implements X<S> { public abstract X x(); }\n\t                                                      ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tabstract class Y<S> implements X<S> { public abstract X x(); }\n\t                                                      ^\nType safety: The return type X for x() from the type Y<S> needs unchecked conversion to conform to X<T> from the type X<T>\n----------\n3. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X x(); }\n\t                            ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X x(); }\n\t                                                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test040d() {
        this.runNegativeTest(new String[]{"X.java", "interface X<T> { X<T>[] x(); }\nabstract class Y<S> implements X<S> { public abstract X[] x(); }\nabstract class Z implements X { public abstract X[] x(); }\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tabstract class Y<S> implements X<S> { public abstract X[] x(); }\n\t                                                      ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. WARNING in X.java (at line 2)\n\tabstract class Y<S> implements X<S> { public abstract X[] x(); }\n\t                                                      ^^^\nType safety: The return type X[] for x() from the type Y<S> needs unchecked conversion to conform to X<T>[] from the type X<T>\n----------\n3. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X[] x(); }\n\t                            ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\n\tabstract class Z implements X { public abstract X[] x(); }\n\t                                                ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test041() {
        this.runConformTest(true, new String[]{"X.java", "public class X { public void foo(String... n) {} }\ninterface I { void foo(String[] n); }\nclass Y extends X implements I { }\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tclass Y extends X implements I { }\n\t      ^\nVarargs methods should only override or be overridden by other varargs methods unlike X.foo(String...) and I.foo(String[])\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug83902);
    }

    public void test041a() {
        this.runConformTest(true, new String[]{"X.java", "public class X { public void foo(String[] n) {} }\ninterface I { void foo(String... n); }\nclass Y extends X implements I { }\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tclass Y extends X implements I { }\n\t      ^\nVarargs methods should only override or be overridden by other varargs methods unlike X.foo(String[]) and I.foo(String...)\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug83902);
    }

    public void test041b() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic Y foo() {\n\t\tSystem.out.println(\"SUCCESS\");\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\t((I) new Y()).foo();\n\t}\n}\ninterface I { X foo(); }\nclass Y extends X implements I { }\n"}, "SUCCESS");
    }

    public void test041c() {
        this.runNegativeTest(new String[]{"X.java", "public class X { public A foo() { return null; } }\ninterface I { A<String> foo(); }\nclass Y extends X implements I { }\nclass A<T> { }\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X { public A foo() { return null; } }\n\t                        ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tclass Y extends X implements I { }\n\t      ^\nType safety: The return type A for foo() from the type X needs unchecked conversion to conform to A<String> from the type I\n----------\n");
    }

    public void test041d() {
        this.runConformTest(true, new String[]{"X.java", "public class X { public Object foo() { return null; } }\ninterface I { <T> T foo(); }\nclass Y extends X implements I { }\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tclass Y extends X implements I { }\n\t      ^\nType safety: The return type Object for foo() from the type X needs unchecked conversion to conform to T from the type I\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug83902b);
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "interface Callable<T>\n{\n    public enum Result { GOOD, BAD };\n    public Result call(T arg);\n}\n\npublic class X implements Callable<String>\n{\n    public Result call(String arg) { return Result.GOOD; } // Warning line\n}\n"}, "");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void test(E<Integer,Integer> e) { e.id(new Integer(1)); } }\nabstract class C<A> { public abstract void id(A x); }\ninterface I<B> { void id(B x); }\nabstract class E<A, B> extends C<A> implements I<B> {}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tabstract class E<A, B> extends C<A> implements I<B> {}\n\t               ^\nName clash: The method id(A) of type C<A> has the same erasure as id(B) of type I<B> but does not override it\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug72704);
    }

    public void test043_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void test(E<Integer,Integer> e) { e.id(new Integer(1)); } }\nclass C<A> { public void id(A x) {} }\ninterface I<B> { void id(B x); }\nabstract class E<A, B> extends C<A> implements I<B> {}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tabstract class E<A, B> extends C<A> implements I<B> {}\n\t               ^\nName clash: The method id(A) of type C<A> has the same erasure as id(B) of type I<B> but does not override it\n----------\n");
    }

    public void test043a() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void test(E<Integer,Integer> e) { e.id(new Integer(2)); } }\nabstract class C<A extends Number> { public abstract void id(A x); }\ninterface I<B> { void id(B x); }\nabstract class E<A extends Number, B> extends C<A> implements I<B> {}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X { void test(E<Integer,Integer> e) { e.id(new Integer(2)); } }\n\t                                                     ^^\nThe method id(Integer) is ambiguous for the type E<Integer,Integer>\n----------\n");
    }

    public void test043b() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void test(E<Integer,Integer> e) { e.id(new Integer(111)); } }\nabstract class C<A extends Number> { public void id(A x) {} }\ninterface I<B> { void id(B x); }\nclass E<A extends Number, B> extends C<A> implements I<B> { public void id(B b) {} }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X { void test(E<Integer,Integer> e) { e.id(new Integer(111)); } }\n\t                                                     ^^\nThe method id(Integer) is ambiguous for the type E<Integer,Integer>\n----------\n");
    }

    public void test043c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test(E<Integer,Integer> e) { e.id(new Integer(111)); }\n\tvoid test(M<Integer,Integer> m) {\n\t\tm.id(new Integer(111));\n\t\t((E<Integer, Integer>) m).id(new Integer(111));\n\t}\n\tvoid test(N<Integer> n) { n.id(new Integer(111)); }\n}\nabstract class C<A extends Number> { public void id(A x) {} }\ninterface I<B> { void id(B x); }\nabstract class E<A extends Number, B> extends C<A> implements I<B> {}\nclass M<A extends Number, B> extends E<A, B> { public void id(B b) {} }\nabstract class N<T extends Number> extends E<T, Number> { @Override public void id(T n) {} }\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tm.id(new Integer(111));\n\t  ^^\nThe method id(Integer) is ambiguous for the type M<Integer,Integer>\n----------\n");
    }

    public void test043d() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p.Y.*;\nimport static p.Z.*;\npublic class X {\n\tY data = null;\n\tpublic X() { foo(data.l); }\n}\n", "p/Y.java", "package p;\nimport java.util.List;\npublic class Y {\n\tList l = null;\n\tpublic static <T> void foo(T... e) {}\n}\n", "p/Z.java", "package p;\nimport java.util.List;\npublic class Z {\n\tpublic static <T> void foo(List<T>... e) {}\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in p\\X.java (at line 6)\n\tpublic X() { foo(data.l); }\n\t             ^^^^^^^^^^^\nType safety: A generic array of List<Object> is created for a varargs parameter\n----------\n2. WARNING in p\\X.java (at line 6)\n\tpublic X() { foo(data.l); }\n\t             ^^^^^^^^^^^\nType safety: Unchecked invocation foo(List) of the generic method foo(List<T>...) of type Z\n----------\n3. WARNING in p\\X.java (at line 6)\n\tpublic X() { foo(data.l); }\n\t                 ^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n----------\n1. WARNING in p\\Y.java (at line 4)\n\tList l = null;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n" : "----------\n1. WARNING in p\\X.java (at line 6)\n\tpublic X() { foo(data.l); }\n\t             ^^^^^^^^^^^\nType safety: A generic array of List<Object> is created for a varargs parameter\n----------\n2. WARNING in p\\X.java (at line 6)\n\tpublic X() { foo(data.l); }\n\t             ^^^^^^^^^^^\nType safety: Unchecked invocation foo(List) of the generic method foo(List<T>...) of type Z\n----------\n3. WARNING in p\\X.java (at line 6)\n\tpublic X() { foo(data.l); }\n\t                 ^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n----------\n1. WARNING in p\\Y.java (at line 4)\n\tList l = null;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in p\\Y.java (at line 5)\n\tpublic static <T> void foo(T... e) {}\n\t                                ^\nType safety: Potential heap pollution via varargs parameter e\n----------\n----------\n1. WARNING in p\\Z.java (at line 4)\n\tpublic static <T> void foo(List<T>... e) {}\n\t                                      ^\nType safety: Potential heap pollution via varargs parameter e\n----------\n");
    }

    public void test043e() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport static p.Y.*;\npublic class X {\n\tY data = null;\n\tpublic X() { foo(data.l); }\n}\n", "p/Y.java", "package p;\nimport java.util.List;\npublic class Y {\n\tList l = null;\n\tpublic static <T> void foo(T... e) {}\n\tpublic static <T> void foo(List<T>... e) {}\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in p\\X.java (at line 5)\n\tpublic X() { foo(data.l); }\n\t             ^^^^^^^^^^^\nType safety: A generic array of List<Object> is created for a varargs parameter\n----------\n2. WARNING in p\\X.java (at line 5)\n\tpublic X() { foo(data.l); }\n\t             ^^^^^^^^^^^\nType safety: Unchecked invocation foo(List) of the generic method foo(List<T>...) of type Y\n----------\n3. WARNING in p\\X.java (at line 5)\n\tpublic X() { foo(data.l); }\n\t                 ^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n----------\n1. WARNING in p\\Y.java (at line 4)\n\tList l = null;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n" : "----------\n1. WARNING in p\\X.java (at line 5)\n\tpublic X() { foo(data.l); }\n\t             ^^^^^^^^^^^\nType safety: A generic array of List<Object> is created for a varargs parameter\n----------\n2. WARNING in p\\X.java (at line 5)\n\tpublic X() { foo(data.l); }\n\t             ^^^^^^^^^^^\nType safety: Unchecked invocation foo(List) of the generic method foo(List<T>...) of type Y\n----------\n3. WARNING in p\\X.java (at line 5)\n\tpublic X() { foo(data.l); }\n\t                 ^^^^^^\nType safety: The expression of type List needs unchecked conversion to conform to List<Object>\n----------\n----------\n1. WARNING in p\\Y.java (at line 4)\n\tList l = null;\n\t^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in p\\Y.java (at line 5)\n\tpublic static <T> void foo(T... e) {}\n\t                                ^\nType safety: Potential heap pollution via varargs parameter e\n----------\n3. WARNING in p\\Y.java (at line 6)\n\tpublic static <T> void foo(List<T>... e) {}\n\t                                      ^\nType safety: Potential heap pollution via varargs parameter e\n----------\n");
    }

    public void test043f() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid test(M<Integer,Integer> m) {\n\t\tm.id(new Integer(111), new Integer(112));\n\t}\n}\nabstract class C<T1 extends Number> { public <U1 extends Number> void id(T1 x, U1 u) {} }\ninterface I<T2> { }\nabstract class E<T3 extends Number, T4> extends C<T3> implements I<T4> {}\nclass M<T5 extends Number, T6> extends E<T5, T6> { public <U2 extends Number> void id(T5 b, U2 u) {} }\n"}, "");
    }

    public void test043g() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid test(M<Integer,Integer> m) {\n\t\tm.id(new Integer(111));\n\t}\n}\nabstract class C<T1 extends Number> { public void id(T1 x) {} }\ninterface I<T2> { void id(T2 x); }\nabstract class E<T3 extends Number, T4> extends C<T3> implements I<T4> {}\nclass M<T5 extends Number, T6> extends E<T5, T6> { public void id(T6 b) {} }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tm.id(new Integer(111));\n\t  ^^\nThe method id(Integer) is ambiguous for the type M<Integer,Integer>\n----------\n");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "public class X { final void foo() {} }\nclass XS extends X { @Override void foo() {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass XS extends X { @Override void foo() {} }\n\t                                    ^^^^^\nCannot override the final method from X\n----------\n");
    }

    public void test044a() {
        this.runNegativeTest(new String[]{"X.java", "public class X { public void foo() {} }\nclass XS extends X { @Override void foo() {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass XS extends X { @Override void foo() {} }\n\t                                    ^^^^^\nCannot reduce the visibility of the inherited method from X\n----------\n");
    }

    public void test044b() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void foo() {} }\nclass XS extends X { @Override void foo() throws ClassNotFoundException {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass XS extends X { @Override void foo() throws ClassNotFoundException {} }\n\t                                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nException ClassNotFoundException is not compatible with throws clause in X.foo()\n----------\n");
    }

    public void test044c() {
        this.runNegativeTest(new String[]{"X.java", "public class X { void foo() {} }\nclass XS extends X { @Override int foo() {} }\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass XS extends X { @Override int foo() {} }\n\t                               ^^^\nThe return type is incompatible with X.foo()\n----------\n");
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "class Foo {}\n\ninterface Bar {\n  Foo get(Class<?> c);\n}\npublic class X implements Bar {\n  public Foo get(Class c) { return null; }\n}\n"}, "");
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "interface IX <T> {\n\tpublic T doSomething();\n}\npublic class X implements IX<Integer> {\n   Zork z;\n\tpublic Integer doSomething() {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "interface Interface {\n    Number getValue();\n}\nclass C1 {\n    public Double getValue() {\n        return 0.0;\n    }\n}\npublic class X extends C1 implements Interface{\n    public static void main(String[] args) {\n        Interface i=new X();\n        System.out.println(i.getValue());\n    }\n}\n"}, "0.0");
    }

    public void test048() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X1.java (at line 2)\n\tpublic class X1 extends LinkedHashMap<String, String> {\n\t             ^^\nThe serializable class X1 does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X1.java (at line 3)\n\tpublic Object putAll(Map<String,String> a) { return null; }\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method putAll(Map<String,String>) of type X1 has the same erasure as putAll(Map<? extends K,? extends V>) of type HashMap<K,V> but does not override it\n----------\n" : "----------\n1. WARNING in X1.java (at line 2)\n\tpublic class X1 extends LinkedHashMap<String, String> {\n\t             ^^\nThe serializable class X1 does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X1.java (at line 3)\n\tpublic Object putAll(Map<String,String> a) { return null; }\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method putAll(Map<String,String>) of type X1 has the same erasure as putAll(Map<? extends K,? extends V>) of type HashMap<K,V> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X1.java", "import java.util.*;\npublic class X1 extends LinkedHashMap<String, String> {\n    public Object putAll(Map<String,String> a) { return null; }\n}\n"}, expectedCompilerLog);
    }

    public void test048a() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X2.java (at line 2)\n\tpublic Object foo(I<String> z) { return null; }\n\t              ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X2 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n" : "----------\n1. ERROR in X2.java (at line 2)\n\tpublic Object foo(I<String> z) { return null; }\n\t              ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X2 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X2.java", "public class X2 extends Y<String> {\n    public Object foo(I<String> z) { return null; }\n}\nclass Y<T> implements I<T> {\n    public void foo(I<? extends T> a) {}\n}\ninterface I<T> {\n    public void foo(I<? extends T> a);\n}\n"}, expectedCompilerLog);
    }

    public void test048b() {
        this.runNegativeTest(new String[]{"X3.java", "public class X3 extends Y<String> {\n    public void foo(I<String> z) {}\n}\nclass Y<T> implements I<T> {\n    public void foo(I<? extends T> a) {}\n}\ninterface I<T> {\n    public void foo(I<? extends T> a);\n}\n"}, "----------\n1. ERROR in X3.java (at line 2)\n\tpublic void foo(I<String> z) {}\n\t            ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X3 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n");
    }

    public void test048c() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X4.java (at line 2)\n\tpublic String foo(I<String> z) { return null; }\n\t              ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X4 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n" : "----------\n1. ERROR in X4.java (at line 2)\n\tpublic String foo(I<String> z) { return null; }\n\t              ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X4 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X4.java", "public class X4 extends Y<String> {\n    public String foo(I<String> z) { return null; }\n}\nclass Y<T> implements I<T> {\n    public Object foo(I<? extends T> a) { return null; }\n}\ninterface I<T> {\n    public Object foo(I<? extends T> a);\n}\n"}, expectedCompilerLog);
    }

    public void test048d() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X5.java (at line 2)\n\tpublic Object foo(I<String> z) { return null; }\n\t              ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X5 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n" : "----------\n1. ERROR in X5.java (at line 2)\n\tpublic Object foo(I<String> z) { return null; }\n\t              ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X5 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X5.java", "public class X5 extends Y<String> {\n    public Object foo(I<String> z) { return null; }\n}\nclass Y<T> implements I<T> {\n    public String foo(I<? extends T> a) { return null; }\n}\ninterface I<T> {\n    public String foo(I<? extends T> a);\n}\n"}, expectedCompilerLog);
    }

    public void test048e() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X6.java (at line 2)\n\tpublic void foo(I<String> z) {}\n\t            ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X6 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n" : "----------\n1. ERROR in X6.java (at line 2)\n\tpublic void foo(I<String> z) {}\n\t            ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X6 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X6.java", "public class X6 extends Y<String> {\n    public void foo(I<String> z) {}\n}\nclass Y<T> implements I<T> {\n    public Object foo(I<? extends T> a) { return null; }\n}\ninterface I<T> {\n    public Object foo(I<? extends T> a);\n}\n"}, expectedCompilerLog);
    }

    public void test048f() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X7.java (at line 2)\n\tpublic String foo(I<String> z) { return null; }\n\t              ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X7 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n" : "----------\n1. ERROR in X7.java (at line 2)\n\tpublic String foo(I<String> z) { return null; }\n\t              ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X7 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X7.java", "public class X7 extends Y<String> {\n    public String foo(I<String> z) { return null; }\n}\nclass Y<T> implements I<T> {\n    public T foo(I<? extends T> a) { return null; }\n}\ninterface I<T> {\n    public T foo(I<? extends T> a);\n}\n"}, expectedCompilerLog);
    }

    public void test048g() {
        this.runNegativeTest(new String[]{"X8.java", "public class X8 extends Y<String> {\n    public Object foo(I<String> z) { return null; }\n}\nclass Y<T> implements I<T> {\n    public T foo(I<? extends T> a) { return null; }\n}\ninterface I<T> {\n    public T foo(I<? extends T> a);\n}\n"}, "----------\n1. ERROR in X8.java (at line 2)\n\tpublic Object foo(I<String> z) { return null; }\n\t              ^^^^^^^^^^^^^^^^\nName clash: The method foo(I<String>) of type X8 has the same erasure as foo(I<? extends T>) of type Y<T> but does not override it\n----------\n");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tT id(T x) { return x; }\n\tA id(A x) { return x; }\n}\nclass Y<T extends A> extends X<T> {\n\t@Override T id(T x) { return x; }\n\t@Override A id(A x) { return x; }\n}\nclass A {}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t@Override T id(T x) { return x; }\n\t            ^^^^^^^\nErasure of method id(T) is the same as another method in type Y<T>\n----------\n2. ERROR in X.java (at line 6)\n\t@Override T id(T x) { return x; }\n\t            ^^^^^^^\nName clash: The method id(T) of type Y<T> has the same erasure as id(A) of type X<T> but does not override it\n----------\n3. ERROR in X.java (at line 7)\n\t@Override A id(A x) { return x; }\n\t            ^^^^^^^\nErasure of method id(A) is the same as another method in type Y<T>\n----------\n");
    }

    public void test049a() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tT id(T x) { return x; }\n\tA id(A x) { return x; }\n}\nclass Y<T extends A> extends X<T> {}\nclass A {}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tclass Y<T extends A> extends X<T> {}\n\t      ^\nDuplicate methods named id with the parameters (A) and (T) are defined by the type X<T>\n----------\n");
    }

    public void test050() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 2)\n\tpublic static <S extends A> S foo() { System.out.print(\"A\"); return null; }\n\t                              ^^^^^\nDuplicate method foo() in type X\n----------\n2. WARNING in X.java (at line 3)\n\tpublic static <N extends B> N foo() { System.out.print(\"B\"); return null; }\n\t                              ^^^^^\nDuplicate method foo() in type X\n----------\n3. WARNING in X.java (at line 7)\n\tnew X().<B>foo();\n\t^^^^^^^^^^^^^^^^\nThe static method foo() from the type X should be accessed in a static way\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\tpublic static <S extends A> S foo() { System.out.print(\"A\"); return null; }\n\t                              ^^^^^\nDuplicate method foo() in type X\n----------\n2. ERROR in X.java (at line 3)\n\tpublic static <N extends B> N foo() { System.out.print(\"B\"); return null; }\n\t                              ^^^^^\nDuplicate method foo() in type X\n----------\n3. ERROR in X.java (at line 6)\n\tX.<B>foo();\n\t     ^^^\nBound mismatch: The generic method foo() of type X is not applicable for the arguments (). The inferred type B is not a valid substitute for the bounded parameter <S extends A>\n----------\n4. ERROR in X.java (at line 7)\n\tnew X().<B>foo();\n\t           ^^^\nBound mismatch: The generic method foo() of type X is not applicable for the arguments (). The inferred type B is not a valid substitute for the bounded parameter <S extends A>\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static <S extends A> S foo() { System.out.print(\"A\"); return null; }\n\tpublic static <N extends B> N foo() { System.out.print(\"B\"); return null; }\n\tpublic static void main(String[] args) {\n\t\tX.<A>foo();\n\t\tX.<B>foo();\n\t\tnew X().<B>foo();\n\t}\n}\nclass A {}\nclass B {}"}, expectedCompilerLog);
    }

    public void test050a() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 2)\n\tpublic static <S extends A> void foo() { System.out.print(\"A\"); }\n\t                                 ^^^^^\nDuplicate method foo() in type X\n----------\n2. WARNING in X.java (at line 3)\n\tpublic static <N extends B> N foo() { System.out.print(\"B\"); return null; }\n\t                              ^^^^^\nDuplicate method foo() in type X\n----------\n3. ERROR in X.java (at line 5)\n\tX.foo();\n\t  ^^^\nThe method foo() is ambiguous for the type X\n----------\n4. ERROR in X.java (at line 6)\n\tfoo();\n\t^^^\nThe method foo() is ambiguous for the type X\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\tpublic static <S extends A> void foo() { System.out.print(\"A\"); }\n\t                                 ^^^^^\nDuplicate method foo() in type X\n----------\n2. ERROR in X.java (at line 3)\n\tpublic static <N extends B> N foo() { System.out.print(\"B\"); return null; }\n\t                              ^^^^^\nDuplicate method foo() in type X\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static <S extends A> void foo() { System.out.print(\"A\"); }\n\tpublic static <N extends B> N foo() { System.out.print(\"B\"); return null; }\n\tstatic void test () {\n\t\tX.foo();\n\t\tfoo();\n\t}\n}\nclass A {}\nclass B {}"}, expectedCompilerLog);
    }

    public void test050b() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. ERROR in X.java (at line 3)\n\tY foo(Object o) {  return null; } // duplicate\n\t  ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C1\n----------\n2. ERROR in X.java (at line 4)\n\tZ foo(Object o) {  return null; } // duplicate\n\t  ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C1\n----------\n3. WARNING in X.java (at line 7)\n\t<T extends Y> T foo(Object o) {  return null; } // duplicate\n\t                ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C2\n----------\n4. WARNING in X.java (at line 8)\n\t<T extends Z> T foo(Object o) {  return null; } // duplicate\n\t                ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C2\n----------\n5. ERROR in X.java (at line 11)\n\tA<Y> foo(Object o) {  return null; } // duplicate\n\t     ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C3\n----------\n6. ERROR in X.java (at line 12)\n\tA<Z> foo(Object o) {  return null; } // duplicate\n\t     ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C3\n----------\n7. ERROR in X.java (at line 15)\n\tY foo(Object o) {  return null; } // duplicate\n\t  ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C4\n----------\n8. ERROR in X.java (at line 16)\n\t<T extends Z> T foo(Object o) {  return null; } // duplicate\n\t                ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C4\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tY foo(Object o) {  return null; } // duplicate\n\t  ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C1\n----------\n2. ERROR in X.java (at line 4)\n\tZ foo(Object o) {  return null; } // duplicate\n\t  ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C1\n----------\n3. ERROR in X.java (at line 7)\n\t<T extends Y> T foo(Object o) {  return null; } // duplicate\n\t                ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C2\n----------\n4. ERROR in X.java (at line 8)\n\t<T extends Z> T foo(Object o) {  return null; } // duplicate\n\t                ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C2\n----------\n5. ERROR in X.java (at line 11)\n\tA<Y> foo(Object o) {  return null; } // duplicate\n\t     ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C3\n----------\n6. ERROR in X.java (at line 12)\n\tA<Z> foo(Object o) {  return null; } // duplicate\n\t     ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C3\n----------\n7. ERROR in X.java (at line 15)\n\tY foo(Object o) {  return null; } // duplicate\n\t  ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C4\n----------\n8. ERROR in X.java (at line 16)\n\t<T extends Z> T foo(Object o) {  return null; } // duplicate\n\t                ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C4\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass C1 {\n\t\tY foo(Object o) {  return null; } // duplicate\n\t\tZ foo(Object o) {  return null; } // duplicate\n\t}\n\tclass C2 {\n\t\t<T extends Y> T foo(Object o) {  return null; } // duplicate\n\t\t<T extends Z> T foo(Object o) {  return null; } // duplicate\n\t}\n\tclass C3 {\n\t\tA<Y> foo(Object o) {  return null; } // duplicate\n\t\tA<Z> foo(Object o) {  return null; } // duplicate\n\t}\n\tclass C4 {\n\t\tY foo(Object o) {  return null; } // duplicate\n\t\t<T extends Z> T foo(Object o) {  return null; } // duplicate\n\t}\n}\nclass A<T> {}\nclass Y {}\nclass Z {}"}, expectedCompilerLog);
    }

    public void test050c() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. ERROR in X.java (at line 3)\n\tA<Y> foo(A<Y> o) {  return null; } // duplicate\n\t     ^^^^^^^^^^^\nErasure of method foo(A<Y>) is the same as another method in type X.C5\n----------\n2. ERROR in X.java (at line 4)\n\tA<Z> foo(A<Z> o) {  return null; } // duplicate\n\t     ^^^^^^^^^^^\nErasure of method foo(A<Z>) is the same as another method in type X.C5\n----------\n3. WARNING in X.java (at line 7)\n\t<T extends Y> T foo(A<Y> o) {  return null; } // ok\n\t                ^^^^^^^^^^^\nErasure of method foo(A<Y>) is the same as another method in type X.C6\n----------\n4. WARNING in X.java (at line 8)\n\t<T extends Z> T foo(A<Z> o) {  return null; } // ok\n\t                ^^^^^^^^^^^\nErasure of method foo(A<Z>) is the same as another method in type X.C6\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tA<Y> foo(A<Y> o) {  return null; } // duplicate\n\t     ^^^^^^^^^^^\nErasure of method foo(A<Y>) is the same as another method in type X.C5\n----------\n2. ERROR in X.java (at line 4)\n\tA<Z> foo(A<Z> o) {  return null; } // duplicate\n\t     ^^^^^^^^^^^\nErasure of method foo(A<Z>) is the same as another method in type X.C5\n----------\n3. ERROR in X.java (at line 7)\n\t<T extends Y> T foo(A<Y> o) {  return null; } // ok\n\t                ^^^^^^^^^^^\nErasure of method foo(A<Y>) is the same as another method in type X.C6\n----------\n4. ERROR in X.java (at line 8)\n\t<T extends Z> T foo(A<Z> o) {  return null; } // ok\n\t                ^^^^^^^^^^^\nErasure of method foo(A<Z>) is the same as another method in type X.C6\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass C5 {\n\t\tA<Y> foo(A<Y> o) {  return null; } // duplicate\n\t\tA<Z> foo(A<Z> o) {  return null; } // duplicate\n\t}\n\tclass C6 {\n\t\t<T extends Y> T foo(A<Y> o) {  return null; } // ok\n\t\t<T extends Z> T foo(A<Z> o) {  return null; } // ok\n\t}\n}\nclass A<T> {}\nclass Y {}\nclass Z {}"}, expectedCompilerLog);
    }

    public void test050d() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 3)\n\t<T extends Y, U> T foo(Object o) {  return null; } // ok\n\t                   ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C7\n----------\n2. WARNING in X.java (at line 4)\n\t<T extends Z> T foo(Object o) {  return null; } // ok\n\t                ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C7\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\t<T extends Y, U> T foo(Object o) {  return null; } // ok\n\t                   ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C7\n----------\n2. ERROR in X.java (at line 4)\n\t<T extends Z> T foo(Object o) {  return null; } // ok\n\t                ^^^^^^^^^^^^^\nDuplicate method foo(Object) in type X.C7\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass C7 {\n\t\t<T extends Y, U> T foo(Object o) {  return null; } // ok\n\t\t<T extends Z> T foo(Object o) {  return null; } // ok\n\t}\n}\nclass A<T> {}\nclass Y {}\nclass Z {}"}, expectedCompilerLog);
    }

    public void test050e() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 2)\n\t<N extends B> N a(A<String> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nErasure of method a(A<String>) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 3)\n\t<N> Object a(A<Number> n) { return null; }\n\t           ^^^^^^^^^^^^^^\nErasure of method a(A<Number>) is the same as another method in type X\n----------\n3. WARNING in X.java (at line 4)\n\t<N extends B> void b(A<String> s) {}\n\t                   ^^^^^^^^^^^^^^\nErasure of method b(A<String>) is the same as another method in type X\n----------\n4. WARNING in X.java (at line 5)\n\t<N extends B> B b(A<Number> n) { return null; }\n\t                ^^^^^^^^^^^^^^\nErasure of method b(A<Number>) is the same as another method in type X\n----------\n5. WARNING in X.java (at line 6)\n\tvoid c(A<String> s) {}\n\t     ^^^^^^^^^^^^^^\nErasure of method c(A<String>) is the same as another method in type X\n----------\n6. WARNING in X.java (at line 7)\n\tB c(A<Number> n) { return null; }\n\t  ^^^^^^^^^^^^^^\nErasure of method c(A<Number>) is the same as another method in type X\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\t<N extends B> N a(A<String> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nErasure of method a(A<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<N> Object a(A<Number> n) { return null; }\n\t           ^^^^^^^^^^^^^^\nErasure of method a(A<Number>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 4)\n\t<N extends B> void b(A<String> s) {}\n\t                   ^^^^^^^^^^^^^^\nErasure of method b(A<String>) is the same as another method in type X\n----------\n4. ERROR in X.java (at line 5)\n\t<N extends B> B b(A<Number> n) { return null; }\n\t                ^^^^^^^^^^^^^^\nErasure of method b(A<Number>) is the same as another method in type X\n----------\n5. ERROR in X.java (at line 6)\n\tvoid c(A<String> s) {}\n\t     ^^^^^^^^^^^^^^\nErasure of method c(A<String>) is the same as another method in type X\n----------\n6. ERROR in X.java (at line 7)\n\tB c(A<Number> n) { return null; }\n\t  ^^^^^^^^^^^^^^\nErasure of method c(A<Number>) is the same as another method in type X\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> N a(A<String> s) { return null; }\n\t\t <N> Object a(A<Number> n) { return null; }\n\t\t <N extends B> void b(A<String> s) {}\n\t\t <N extends B> B b(A<Number> n) { return null; }\n\t\t void c(A<String> s) {}\n\t\t B c(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, expectedCompilerLog);
    }

    public void test050f() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> N a(A<String> s) { return null; }\n\t\t <N> B a(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<N extends B> N a(A<String> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nErasure of method a(A<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<N> B a(A<Number> n) { return null; }\n\t      ^^^^^^^^^^^^^^\nErasure of method a(A<Number>) is the same as another method in type X\n----------\n");
    }

    public void test050g() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> N b(A<String> s) { return null; }\n\t\t <N extends B> B b(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<N extends B> N b(A<String> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nErasure of method b(A<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<N extends B> B b(A<Number> n) { return null; }\n\t                ^^^^^^^^^^^^^^\nErasure of method b(A<Number>) is the same as another method in type X\n----------\n");
    }

    public void test050h() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t B c(A<String> s) { return null; }\n\t\t B c(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tB c(A<String> s) { return null; }\n\t  ^^^^^^^^^^^^^^\nErasure of method c(A<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\tB c(A<Number> n) { return null; }\n\t  ^^^^^^^^^^^^^^\nErasure of method c(A<Number>) is the same as another method in type X\n----------\n");
    }

    public void test050i() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 2)\n\t<N extends B> N a(A<Number> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n2. WARNING in X.java (at line 3)\n\t<N> Object a(A<Number> n) { return null; }\n\t           ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n3. WARNING in X.java (at line 4)\n\t<N extends B> N b(A<Number> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nErasure of method b(A<Number>) is the same as another method in type X\n----------\n4. WARNING in X.java (at line 5)\n\t<N> Object b(A<String> n) { return null; }\n\t           ^^^^^^^^^^^^^^\nErasure of method b(A<String>) is the same as another method in type X\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\t<N extends B> N a(A<Number> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<N> Object a(A<Number> n) { return null; }\n\t           ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n3. ERROR in X.java (at line 4)\n\t<N extends B> N b(A<Number> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nErasure of method b(A<Number>) is the same as another method in type X\n----------\n4. ERROR in X.java (at line 5)\n\t<N> Object b(A<String> n) { return null; }\n\t           ^^^^^^^^^^^^^^\nErasure of method b(A<String>) is the same as another method in type X\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> N a(A<Number> s) { return null; }\n\t\t <N> Object a(A<Number> n) { return null; }\n\t\t <N extends B> N b(A<Number> s) { return null; }\n\t\t <N> Object b(A<String> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, expectedCompilerLog);
    }

    public void test050j() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> N a(A<Number> s) { return null; }\n\t\t <N> B a(A<Number> n) { return null; }\n\t\t <N extends B> N b(A<Number> s) { return null; }\n\t\t <N> B b(A<String> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<N extends B> N a(A<Number> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<N> B a(A<Number> n) { return null; }\n\t      ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n3. ERROR in X.java (at line 4)\n\t<N extends B> N b(A<Number> s) { return null; }\n\t                ^^^^^^^^^^^^^^\nErasure of method b(A<Number>) is the same as another method in type X\n----------\n4. ERROR in X.java (at line 5)\n\t<N> B b(A<String> n) { return null; }\n\t      ^^^^^^^^^^^^^^\nErasure of method b(A<String>) is the same as another method in type X\n----------\n");
    }

    public void test050k() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t <N extends B> void a(A<Number> s) {}\n\t\t <N extends B> B a(A<Number> n) { return null; }\n\t\t <N extends B> Object b(A<Number> s) { return null; }\n\t\t <N extends B> B b(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<N extends B> void a(A<Number> s) {}\n\t                   ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<N extends B> B a(A<Number> n) { return null; }\n\t                ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n3. ERROR in X.java (at line 4)\n\t<N extends B> Object b(A<Number> s) { return null; }\n\t                     ^^^^^^^^^^^^^^\nDuplicate method b(A<Number>) in type X\n----------\n4. ERROR in X.java (at line 5)\n\t<N extends B> B b(A<Number> n) { return null; }\n\t                ^^^^^^^^^^^^^^\nDuplicate method b(A<Number>) in type X\n----------\n");
    }

    public void test050l() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\t void a(A<Number> s) {}\n\t\t B a(A<Number> n) { return null; }\n\t\t Object b(A<Number> s) {}\n\t\t B b(A<Number> n) { return null; }\n}\nclass A<T> {}\nclass B {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid a(A<Number> s) {}\n\t     ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n2. ERROR in X.java (at line 3)\n\tB a(A<Number> n) { return null; }\n\t  ^^^^^^^^^^^^^^\nDuplicate method a(A<Number>) in type X\n----------\n3. ERROR in X.java (at line 4)\n\tObject b(A<Number> s) {}\n\t       ^^^^^^^^^^^^^^\nDuplicate method b(A<Number>) in type X\n----------\n4. ERROR in X.java (at line 4)\n\tObject b(A<Number> s) {}\n\t       ^^^^^^^^^^^^^^\nThis method must return a result of type Object\n----------\n5. ERROR in X.java (at line 5)\n\tB b(A<Number> n) { return null; }\n\t  ^^^^^^^^^^^^^^\nDuplicate method b(A<Number>) in type X\n----------\n");
    }

    public void test051() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements I {\n\t\t public <T extends I> void foo(T t) {}\n}\ninterface I {\n\t\t <T> void foo(T t);\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements I {\n\t             ^\nThe type X must implement the inherited abstract method I.foo(T)\n----------\n");
    }

    public void test051a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(A<String> a) {}\n\tvoid foo(A<Integer> a) {}\n}\nclass A<T> {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(A<String> a) {}\n\t     ^^^^^^^^^^^^^^^^\nErasure of method foo(A<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\tvoid foo(A<Integer> a) {}\n\t     ^^^^^^^^^^^^^^^^^\nErasure of method foo(A<Integer>) is the same as another method in type X\n----------\n");
    }

    public void test051b() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 2)\n\tvoid foo(A<String> a) {}\n\t     ^^^^^^^^^^^^^^^^\nErasure of method foo(A<String>) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 3)\n\tObject foo(A<Integer> a) { return null; }\n\t       ^^^^^^^^^^^^^^^^^\nErasure of method foo(A<Integer>) is the same as another method in type X\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(A<String> a) {}\n\t     ^^^^^^^^^^^^^^^^\nErasure of method foo(A<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\tObject foo(A<Integer> a) { return null; }\n\t       ^^^^^^^^^^^^^^^^^\nErasure of method foo(A<Integer>) is the same as another method in type X\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(A<String> a) {}\n\tObject foo(A<Integer> a) { return null; }\n}\nclass A<T> {}\n"}, expectedCompilerLog);
    }

    public void test052() {
        this.runConformTest(new String[]{"A.java", "public class A<T> {\n\tpublic A test() { return null; }\n\tpublic A<T> test2() { return null; }\n\tpublic A<X> test3() { return null; }\n\tpublic <U> A<U> test4() { return null; }\n}\nclass B extends A<X> {\n\t@Override public B test() { return null; }\n\t@Override public B test2() { return null; }\n\t@Override public B test3() { return null; }\n\t@Override public <U> A<U> test4() { return null; }\n}\nclass X{}\n"}, "");
    }

    public void test052a() {
        this.runNegativeTest(new String[]{"A.java", "public class A<T> {\n\tpublic <U> A<U> test() { return null; }\n\tpublic <U> A<U> test2() { return null; }\n\tpublic <U> A<U> test3() { return null; }\n}\nclass B extends A<X> {\n\t@Override public B test() { return null; }\n\t@Override public A test2() { return null; }\n\t@Override public A<X> test3() { return null; }\n}\nclass X{}\n"}, "----------\n1. WARNING in A.java (at line 7)\n\t@Override public B test() { return null; }\n\t                 ^\nType safety: The return type B for test() from the type B needs unchecked conversion to conform to A<Object> from the type A<X>\n----------\n2. WARNING in A.java (at line 8)\n\t@Override public A test2() { return null; }\n\t                 ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n3. WARNING in A.java (at line 8)\n\t@Override public A test2() { return null; }\n\t                 ^\nType safety: The return type A for test2() from the type B needs unchecked conversion to conform to A<U> from the type A<T>\n----------\n4. WARNING in A.java (at line 9)\n\t@Override public A<X> test3() { return null; }\n\t                 ^\nType safety: The return type A<X> for test3() from the type B needs unchecked conversion to conform to A<Object> from the type A<X>\n----------\n");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tvoid test(A a) { B b = a.foo(); }\n\tvoid test2(A<X> a) { B b = a.foo(); }\n\tvoid test3(B b) { B bb = b.foo(); }\n}\nclass A<T> {\n\t<U> A<U> foo() { return null; }\n}\nclass B extends A<X> {\n\t@Override B foo() { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tvoid test(A a) { B b = a.foo(); }\n\t          ^\nA is a raw type. References to generic type A<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tvoid test(A a) { B b = a.foo(); }\n\t                       ^^^^^^^\nType mismatch: cannot convert from A to B\n----------\n3. ERROR in X.java (at line 3)\n\tvoid test2(A<X> a) { B b = a.foo(); }\n\t                           ^^^^^^^\nType mismatch: cannot convert from A<Object> to B\n----------\n4. WARNING in X.java (at line 10)\n\t@Override B foo() { return null; }\n\t          ^\nType safety: The return type B for foo() from the type B needs unchecked conversion to conform to A<Object> from the type A<X>\n----------\n");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid a(Object x) {}\n\t<T> T a(T x) {  return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid a(Object x) {}\n\t     ^^^^^^^^^^^\nErasure of method a(Object) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<T> T a(T x) {  return null; }\n\t      ^^^^^^\nErasure of method a(T) is the same as another method in type X\n----------\n");
    }

    public void test054a() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 2)\n\t<T1, T2> String aaa(X x) {  return null; }\n\t                ^^^^^^^^\nErasure of method aaa(X) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 3)\n\t<T extends X> T aaa(T x) {  return null; }\n\t                ^^^^^^^^\nErasure of method aaa(T) is the same as another method in type X\n----------\n3. WARNING in X.java (at line 4)\n\t<T> String aa(X x) {  return null; }\n\t           ^^^^^^^\nErasure of method aa(X) is the same as another method in type X\n----------\n4. WARNING in X.java (at line 5)\n\t<T extends X> T aa(T x) {  return null; }\n\t                ^^^^^^^\nErasure of method aa(T) is the same as another method in type X\n----------\n5. ERROR in X.java (at line 6)\n\tString a(X x) {  return null; }\n\t       ^^^^^^\nErasure of method a(X) is the same as another method in type X\n----------\n6. ERROR in X.java (at line 7)\n\t<T extends X> T a(T x) {  return null; }\n\t                ^^^^^^\nErasure of method a(T) is the same as another method in type X\n----------\n7. WARNING in X.java (at line 8)\n\t<T> String z(X x) { return null; }\n\t           ^^^^^^\nDuplicate method z(X) in type X\n----------\n8. WARNING in X.java (at line 9)\n\t<T, S> Object z(X x) { return null; }\n\t              ^^^^^^\nDuplicate method z(X) in type X\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\t<T1, T2> String aaa(X x) {  return null; }\n\t                ^^^^^^^^\nErasure of method aaa(X) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<T extends X> T aaa(T x) {  return null; }\n\t                ^^^^^^^^\nErasure of method aaa(T) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 4)\n\t<T> String aa(X x) {  return null; }\n\t           ^^^^^^^\nErasure of method aa(X) is the same as another method in type X\n----------\n4. ERROR in X.java (at line 5)\n\t<T extends X> T aa(T x) {  return null; }\n\t                ^^^^^^^\nErasure of method aa(T) is the same as another method in type X\n----------\n5. ERROR in X.java (at line 6)\n\tString a(X x) {  return null; }\n\t       ^^^^^^\nErasure of method a(X) is the same as another method in type X\n----------\n6. ERROR in X.java (at line 7)\n\t<T extends X> T a(T x) {  return null; }\n\t                ^^^^^^\nErasure of method a(T) is the same as another method in type X\n----------\n7. ERROR in X.java (at line 8)\n\t<T> String z(X x) { return null; }\n\t           ^^^^^^\nDuplicate method z(X) in type X\n----------\n8. ERROR in X.java (at line 9)\n\t<T, S> Object z(X x) { return null; }\n\t              ^^^^^^\nDuplicate method z(X) in type X\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T1, T2> String aaa(X x) {  return null; }\n\t<T extends X> T aaa(T x) {  return null; }\n\t<T> String aa(X x) {  return null; }\n\t<T extends X> T aa(T x) {  return null; }\n\tString a(X x) {  return null; }\n\t<T extends X> T a(T x) {  return null; }\n\t<T> String z(X x) { return null; }\n\t<T, S> Object z(X x) { return null; }\n}\n"}, expectedCompilerLog);
    }

    public void test054b() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 2)\n\tObject foo(X<T> t) { return null; }\n\t       ^^^^^^^^^^^\nDuplicate method foo(X<T>) in type X<T>\n----------\n2. WARNING in X.java (at line 3)\n\t<S> String foo(X<T> s) { return null; }\n\t           ^^^^^^^^^^^\nDuplicate method foo(X<T>) in type X<T>\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\tObject foo(X<T> t) { return null; }\n\t       ^^^^^^^^^^^\nDuplicate method foo(X<T>) in type X<T>\n----------\n2. ERROR in X.java (at line 3)\n\t<S> String foo(X<T> s) { return null; }\n\t           ^^^^^^^^^^^\nDuplicate method foo(X<T>) in type X<T>\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\t\t Object foo(X<T> t) { return null; }\n\t\t <S> String foo(X<T> s) { return null; }\n}\n"}, expectedCompilerLog);
    }

    public void test054c() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\t\t<T1 extends X<T1>> void dupT() {}\n\t\t<T2 extends X<T2>> Object dupT() {return null;}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T1 extends X<T1>> void dupT() {}\n\t                        ^^^^^^\nDuplicate method dupT() in type X<T>\n----------\n2. ERROR in X.java (at line 3)\n\t<T2 extends X<T2>> Object dupT() {return null;}\n\t                          ^^^^^^\nDuplicate method dupT() in type X<T>\n----------\n");
    }

    public void test054d() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 2)\n\t<T> T a(A<T> t) {return null;}\n\t      ^^^^^^^^^\nErasure of method a(A<T>) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 3)\n\t<T> String a(A<Object> o) {return null;}\n\t           ^^^^^^^^^^^^^^\nErasure of method a(A<Object>) is the same as another method in type X\n----------\n3. WARNING in X.java (at line 4)\n\t<T> T aa(A<T> t) {return null;}\n\t      ^^^^^^^^^^\nErasure of method aa(A<T>) is the same as another method in type X\n----------\n4. WARNING in X.java (at line 5)\n\tString aa(A<Object> o) {return null;}\n\t       ^^^^^^^^^^^^^^^\nErasure of method aa(A<Object>) is the same as another method in type X\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\t<T> T a(A<T> t) {return null;}\n\t      ^^^^^^^^^\nErasure of method a(A<T>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<T> String a(A<Object> o) {return null;}\n\t           ^^^^^^^^^^^^^^\nErasure of method a(A<Object>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 4)\n\t<T> T aa(A<T> t) {return null;}\n\t      ^^^^^^^^^^\nErasure of method aa(A<T>) is the same as another method in type X\n----------\n4. ERROR in X.java (at line 5)\n\tString aa(A<Object> o) {return null;}\n\t       ^^^^^^^^^^^^^^^\nErasure of method aa(A<Object>) is the same as another method in type X\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t<T> T a(A<T> t) {return null;}\n\t<T> String a(A<Object> o) {return null;}\n\t<T> T aa(A<T> t) {return null;}\n\tString aa(A<Object> o) {return null;}\n}\nclass A<T> {}\n"}, expectedCompilerLog);
    }

    public void test055() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tA a = new C();\n\t\ttry { a.f(new Object()); } catch (ClassCastException e) {\n\t\t\tSystem.out.println(1);\n\t\t}\n\t}\n}\ninterface A<T> { void f(T x); }\ninterface B extends A<String> { void f(String x); }\nclass C implements B { public void f(String x) {} }\n"}, "1");
    }

    public void test056() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static String bind(String message, Object binding) { return null; }\n   public static String bind(String message, Object[] bindings) { return null; }\n}\nclass Y extends X {\n   public static String bind(String message, Object binding) { return null; }\n   public static String bind(String message, Object[] bindings) { return null; }\n}\nclass Z {\n   void bar() { Y.bind(\"\", new String[] {\"\"}); }\n}\n"}, "");
    }

    public void test057() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n   \tA<Integer> x = new A<Integer>();\n   \tB<Integer> y = new B<Integer>();\n   \tnew X().print(x);\n   \tnew X().print(y);\n\t}\n\tpublic <T extends IA<?>> void print(T a) { System.out.print(1); }\n\tpublic <T extends IB<?>> void print(T a) { System.out.print(2); }\n}\ninterface IA<E> {}\ninterface IB<E> extends IA<E> {}\nclass A<E> implements IA<E> {}\nclass B<E> implements IB<E> {}\n"}, "12");
    }

    public void test057a() {
        this.runConformTest(new String[]{"XX.java", "public class XX {\n   public static void main(String[] args) {\n   \tA<Integer> x = new A<Integer>();\n   \tB<Integer> y = new B<Integer>();\n   \tprint(x);\n   \tprint(y);\n\t}\n\tpublic static <T extends IA<?>> void print(T a) { System.out.print(3); }\n\tpublic static <T extends IB<?>> void print(T a) { System.out.print(4); }\n}\ninterface IA<E> {}\ninterface IB<E> extends IA<E> {}\nclass A<E> implements IA<E> {}\nclass B<E> implements IB<E> {}\n"}, "34");
    }

    public void test058() {
        this.runConformTest(new String[]{"X.java", "public class X <B extends Number> {\n   public static void main(String[] args) {\n   \tX<Integer> x = new X<Integer>();\n   \tx.aaa(null);\n   \tx.aaa(15);\n\t}\n\t<T> T aaa(T t) { System.out.print('T'); return null; }\n\tvoid aaa(B b) { System.out.print('B'); }\n}\n"}, "BB");
    }

    public void test058a() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. ERROR in X.java (at line 3)\n\tnew X<Object>().foo(\"X\");\n\t                ^^^\nThe method foo(String) is ambiguous for the type X<Object>\n----------\n2. ERROR in X.java (at line 4)\n\tnew X<Object>().foo2(\"X\");\n\t                ^^^^\nThe method foo2(String) is ambiguous for the type X<Object>\n----------\n3. WARNING in X.java (at line 6)\n\t<T> T foo(T t) {return null;}\n\t      ^^^^^^^^\nErasure of method foo(T) is the same as another method in type X<A>\n----------\n4. WARNING in X.java (at line 7)\n\tvoid foo(A a) {}\n\t     ^^^^^^^^\nErasure of method foo(A) is the same as another method in type X<A>\n----------\n5. WARNING in X.java (at line 8)\n\t<T> T foo2(T t) {return null;}\n\t      ^^^^^^^^^\nErasure of method foo2(T) is the same as another method in type X<A>\n----------\n6. WARNING in X.java (at line 9)\n\t<T> void foo2(A a) {}\n\t         ^^^^^^^^^\nErasure of method foo2(A) is the same as another method in type X<A>\n----------\n" : "----------\n1. ERROR in X.java (at line 6)\n\t<T> T foo(T t) {return null;}\n\t      ^^^^^^^^\nErasure of method foo(T) is the same as another method in type X<A>\n----------\n2. ERROR in X.java (at line 7)\n\tvoid foo(A a) {}\n\t     ^^^^^^^^\nErasure of method foo(A) is the same as another method in type X<A>\n----------\n3. ERROR in X.java (at line 8)\n\t<T> T foo2(T t) {return null;}\n\t      ^^^^^^^^^\nErasure of method foo2(T) is the same as another method in type X<A>\n----------\n4. ERROR in X.java (at line 9)\n\t<T> void foo2(A a) {}\n\t         ^^^^^^^^^\nErasure of method foo2(A) is the same as another method in type X<A>\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X<A> {\n\tvoid test() {\n\t\tnew X<Object>().foo(\"X\");\n\t\tnew X<Object>().foo2(\"X\");\n\t}\n\t<T> T foo(T t) {return null;}\n\tvoid foo(A a) {}\n\t<T> T foo2(T t) {return null;}\n\t<T> void foo2(A a) {}\n}\n"}, expectedCompilerLog);
    }

    public void test058b() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. ERROR in X.java (at line 3)\n\tnew X<Object>().foo(\"X\");\n\t                ^^^\nThe method foo(String) is ambiguous for the type X<Object>\n----------\n2. ERROR in X.java (at line 4)\n\tnew X<Object>().foo2(\"X\");\n\t                ^^^^\nThe method foo2(String) is ambiguous for the type X<Object>\n----------\n3. WARNING in X.java (at line 6)\n\t<T> T foo(T t) {return null;}\n\t      ^^^^^^^^\nName clash: The method foo(T) of type X<A> has the same erasure as foo(A) of type Y<A> but does not override it\n----------\n4. WARNING in X.java (at line 7)\n\t<T> T foo2(T t) {return null;}\n\t      ^^^^^^^^^\nName clash: The method foo2(T) of type X<A> has the same erasure as foo2(A) of type Y<A> but does not override it\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tnew X<Object>().foo(\"X\");\n\t                ^^^\nThe method foo(String) is ambiguous for the type X<Object>\n----------\n2. ERROR in X.java (at line 4)\n\tnew X<Object>().foo2(\"X\");\n\t                ^^^^\nThe method foo2(String) is ambiguous for the type X<Object>\n----------\n3. ERROR in X.java (at line 6)\n\t<T> T foo(T t) {return null;}\n\t      ^^^^^^^^\nName clash: The method foo(T) of type X<A> has the same erasure as foo(A) of type Y<A> but does not override it\n----------\n4. ERROR in X.java (at line 7)\n\t<T> T foo2(T t) {return null;}\n\t      ^^^^^^^^^\nName clash: The method foo2(T) of type X<A> has the same erasure as foo2(A) of type Y<A> but does not override it\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X<A> extends Y<A> {\n\tvoid test() {\n\t\tnew X<Object>().foo(\"X\");\n\t\tnew X<Object>().foo2(\"X\");\n\t}\n\t<T> T foo(T t) {return null;}\n\t<T> T foo2(T t) {return null;}\n}\nclass Y<A> {\n\tvoid foo(A a) {}\n\t<T> void foo2(A a) {}\n}"}, expectedCompilerLog);
    }

    public void test059() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {new B().foo(\"aa\");}\n}\nclass A { <U> void foo(U u) {System.out.print(false);} }\nclass B extends A { <V> void foo(String s) {System.out.print(true);} }\n"}, "true");
    }

    public void test059a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {new B().foo(\"aa\");}\n}\nclass A { <U> void foo(String s) {System.out.print(true);} }\nclass B extends A { <V> void foo(V v) {System.out.print(false);} }\n"}, "true");
    }

    public void test060() {
        this.runConformTest(new String[]{"I.java", "import java.util.Iterator;\npublic interface I {\n\tvoid method(Iterator<Object> iter);\n\tpublic static class TestClass implements I {\n\t\tpublic void method(Iterator iter) {}\n\t}\n}"}, "");
    }

    public void test060b() {
        this.runConformTest(new String[]{"I2.java", "import java.util.Iterator;\npublic interface I2 {\n\tvoid method(Iterator<Object>[] iter);\n\tpublic static class TestClass implements I2 {\n\t\tpublic void method(Iterator[] iter) {}\n\t}\n}"}, "");
    }

    public void test060c() {
        this.runNegativeTest(new String[]{"I3.java", "import java.util.Iterator;\npublic interface I3 {\n\tvoid method(Iterator<Object>[] iter);\n\tpublic static class TestClass implements I3 {\n\t\tpublic void method(Iterator[][] iter) {}\n\t}\n}"}, "----------\n1. ERROR in I3.java (at line 4)\n\tpublic static class TestClass implements I3 {\n\t                    ^^^^^^^^^\nThe type I3.TestClass must implement the inherited abstract method I3.method(Iterator<Object>[])\n----------\n2. WARNING in I3.java (at line 5)\n\tpublic void method(Iterator[][] iter) {}\n\t                   ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"Try.java", "public class Try {\n\tpublic static void main(String[] args) {\n\t\tEx<String> ex = new Ex<String>();\n\t\tex.one(\"eclipse\", new Integer(1));\n\t\tex.two(new Integer(1));\n\t\tex.three(\"eclipse\");\n\t\tex.four(\"eclipse\");\n\t\tSystem.out.print(',');\n\t\tEx ex2 = ex;\n\t\tex2.one(\"eclipse\", new Integer(1));\n\t\tex2.two(new Integer(1));\n\t\tex2.three(\"eclipse\");\n\t\tex2.four(\"eclipse\");\n\t}\n}\nclass Top<TC> {\n\t<TM> void one(TC cTop, TM mTop) { System.out.print(-1); }\n\t<TM> void two(TM mTop) { System.out.print(-2); }\n\tvoid three(TC cTop) { System.out.print(-3); }\n\t<TM> void four(TC cTop) { System.out.print(-4); }\n}\nclass Ex<C> extends Top<C> {\n\t@Override <M> void one(C cEx, M mEx) { System.out.print(1); }\n\t@Override <M> void two(M mEx) { System.out.print(2); }\n\t@Override void three(C cEx) { System.out.print(3); }\n\t@Override <M> void four(C cEx) { System.out.print(4); }\n}"}, "----------\n1. WARNING in Try.java (at line 9)\n\tEx ex2 = ex;\n\t^^\nEx is a raw type. References to generic type Ex<C> should be parameterized\n----------\n2. WARNING in Try.java (at line 10)\n\tex2.one(\"eclipse\", new Integer(1));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method one(Object, Object) belongs to the raw type Ex. References to generic type Ex<C> should be parameterized\n----------\n3. WARNING in Try.java (at line 11)\n\tex2.two(new Integer(1));\n\t^^^^^^^^^^^^^^^^^^^^^^^\nType safety: The method two(Object) belongs to the raw type Ex. References to generic type Ex<C> should be parameterized\n----------\n4. WARNING in Try.java (at line 12)\n\tex2.three(\"eclipse\");\n\t^^^^^^^^^^^^^^^^^^^^\nType safety: The method three(Object) belongs to the raw type Ex. References to generic type Ex<C> should be parameterized\n----------\n5. WARNING in Try.java (at line 13)\n\tex2.four(\"eclipse\");\n\t^^^^^^^^^^^^^^^^^^^\nType safety: The method four(Object) belongs to the raw type Ex. References to generic type Ex<C> should be parameterized\n----------\n");
    }

    public void test062() {
        this.runNegativeTest(new String[]{"Errors.java", "public class Errors {\n\tvoid foo() {\n\t\tEx<String> ex = new Ex<String>();\n\t\tex.proof(\"eclipse\");\n\t\tex.five(\"eclipse\");\n\t\tex.six(\"eclipse\");\n\t\tEx ex2 = ex;\n\t\tex2.proof(\"eclipse\");\n\t\tex2.five(\"eclipse\");\n\t\tex2.six(\"eclipse\");\n\t}\n}\nclass Top<TC> {\n\t<TM> void proof(Object cTop) {}\n\t<TM> void five(TC cTop) {}\n\tvoid six(TC cTop) {}\n}\nclass Ex<C> extends Top<C> {\n\t@Override void proof(Object cTop) {}\n\t@Override void five(C cEx) {}\n\t@Override <M> void six(C cEx) {}\n}"}, "----------\n1. ERROR in Errors.java (at line 5)\n\tex.five(\"eclipse\");\n\t   ^^^^\nThe method five(String) is ambiguous for the type Ex<String>\n----------\n2. ERROR in Errors.java (at line 6)\n\tex.six(\"eclipse\");\n\t   ^^^\nThe method six(String) is ambiguous for the type Ex<String>\n----------\n3. WARNING in Errors.java (at line 7)\n\tEx ex2 = ex;\n\t^^\nEx is a raw type. References to generic type Ex<C> should be parameterized\n----------\n4. ERROR in Errors.java (at line 9)\n\tex2.five(\"eclipse\");\n\t    ^^^^\nThe method five(Object) is ambiguous for the type Ex\n----------\n5. ERROR in Errors.java (at line 10)\n\tex2.six(\"eclipse\");\n\t    ^^^\nThe method six(Object) is ambiguous for the type Ex\n----------\n6. ERROR in Errors.java (at line 20)\n\t@Override void five(C cEx) {}\n\t               ^^^^^^^^^^^\nName clash: The method five(C) of type Ex<C> has the same erasure as five(TC) of type Top<TC> but does not override it\n----------\n7. ERROR in Errors.java (at line 20)\n\t@Override void five(C cEx) {}\n\t               ^^^^^^^^^^^\n" + this.mustOverrideMessage("five(C)", "Ex<C>") + "----------\n" + "8. ERROR in Errors.java (at line 21)\n" + "\t@Override <M> void six(C cEx) {}\n" + "\t                   ^^^^^^^^^^\n" + "Name clash: The method six(C) of type Ex<C> has the same erasure as six(TC) of type Top<TC> but does not override it\n" + "----------\n" + "9. ERROR in Errors.java (at line 21)\n" + "\t@Override <M> void six(C cEx) {}\n" + "\t                   ^^^^^^^^^^\n" + this.mustOverrideMessage("six(C)", "Ex<C>") + "----------\n");
    }

    public void test063() {
        this.runConformTest(new String[]{"X.java", "interface IStructuredContentProvider<I, E extends I> {\n    public E[] getElements(I inputElement);\n    public E[] getChildren(E parent);\n}\n\npublic class X implements IStructuredContentProvider {\n// eclipse error: The type X must implement the inherited\n// abstract method IStructuredContentProvider.getChildren(I)\n\n    public Object[] getElements(Object inputElement) {\n        // eclipse error: The return type is incompatible with\n        // IStructuredContentProvider.getElements(Object)\n        return null;\n    }\n\n    public Object[] getChildren(Object parent) {\n        // eclipse error: Name clash: The method getChildren(Object) of type\n        // X has the same erasure as getChildren(E) of type\n        // IStructuredContentProvider<I,E> but does not override it\n        return null;\n    }\n}\n"}, "");
    }

    public void test064() {
        this.runConformTest(new String[]{"X.java", "interface IStructuredContentProvider<I, E extends I> {\n    public E[] getElements(I inputElement);\n    public E[] getChildren(E parent);\n}\n\npublic class X implements IStructuredContentProvider<Object,Object> {\n// eclipse error: The type X must implement the inherited\n// abstract method IStructuredContentProvider.getChildren(I)\n\n    public Object[] getElements(Object inputElement) {\n        // eclipse error: The return type is incompatible with\n        // IStructuredContentProvider.getElements(Object)\n        return null;\n    }\n\n    public Object[] getChildren(Object parent) {\n        // eclipse error: Name clash: The method getChildren(Object) of type\n        // X has the same erasure as getChildren(E) of type\n        // IStructuredContentProvider<I,E> but does not override it\n        return null;\n    }\n}\n"}, "");
    }

    public void test065() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\ninterface IStructuredContentProvider<I, E extends List<String>> {\n    public E[] getElements(I inputElement);\n    public E[] getChildren(E parent);\n}\n\npublic class X implements IStructuredContentProvider {\n// eclipse error: The type X must implement the inherited\n// abstract method IStructuredContentProvider.getChildren(I)\n\n    public List[] getElements(Object inputElement) {\n        // eclipse error: The return type is incompatible with\n        // IStructuredContentProvider.getElements(Object)\n        return null;\n    }\n\n    public List[] getChildren(List parent) {\n        // eclipse error: Name clash: The method getChildren(Object) of type\n        // X has the same erasure as getChildren(E) of type\n        // IStructuredContentProvider<I,E> but does not override it\n        return null;\n    }\n}\n"}, "");
    }

    public void test066() {
        this.runConformTest(new String[]{"JukeboxImpl.java", "public class JukeboxImpl implements Jukebox {\n    public <M extends Music,A extends Artist<M>> A getArtist (M music){return null;}\n    void test () { getArtist(new Rock()); }\n}\ninterface Jukebox {\n\t<M extends Music, A extends Artist<M>> A getArtist (M music);\n}\ninterface Music {}\nclass Rock implements Music {}\ninterface Artist<M extends Music> {}\n"}, "");
    }

    public void test067() {
        this.runConformTest(new String[]{"NoErrors.java", "public class NoErrors {\n    public static void main(String[] args) { new B().foo2(1, 10); }\n}\nclass A<T> {\n\t<S1 extends T> void foo2(Number t, S1 s) { System.out.print(false); }\n}\nclass B extends A<Number> {\n\t<S2 extends Number> void foo2(Number t, S2 s) { System.out.print(true); }\n}\n"}, "true");
    }

    public void test068() {
        this.runConformTest(new String[]{"ReflectionNavigator.java", "import java.lang.reflect.Type;\npublic class ReflectionNavigator implements Navigator<Type> {\n    public <T> Class<T> erasure(Type t) { return null; }\n}\ninterface Navigator<TypeT> {\n\t<T> TypeT erasure(TypeT x);\n}\nclass Usage {\n\tpublic void foo(ReflectionNavigator r, Type t) { r.erasure(t); }\n}\n"}, "");
    }

    public void test069() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.reflect.Type;\npublic class X implements I<A> {\n    public <N extends A> void x1() {}\n    public <N extends Number> void x2() {}\n    public <N extends Number> void x3() {}\n}\ninterface I<V> {\n\t<N extends V> void x1();\n\t<N extends String> void x2();\n\t<N extends Object> void x3();\n}\nclass A {}\nclass B<T> {}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X implements I<A> {\n\t             ^\nThe type X must implement the inherited abstract method I<A>.x3()\n----------\n2. ERROR in X.java (at line 2)\n\tpublic class X implements I<A> {\n\t             ^\nThe type X must implement the inherited abstract method I<A>.x2()\n----------\n3. ERROR in X.java (at line 4)\n\tpublic <N extends Number> void x2() {}\n\t                               ^^^^\nName clash: The method x2() of type X has the same erasure as x2() of type I<V> but does not override it\n----------\n4. ERROR in X.java (at line 5)\n\tpublic <N extends Number> void x3() {}\n\t                               ^^^^\nName clash: The method x3() of type X has the same erasure as x3() of type I<V> but does not override it\n----------\n5. WARNING in X.java (at line 9)\n\t<N extends String> void x2();\n\t           ^^^^^^\nThe type parameter N should not be bounded by the final type String. Final types cannot be further extended\n----------\n");
    }

    public void test070() {
        this.runConformTest(true, new String[]{"BooleanFactory.java", "interface Factory<T> {\n\t<U extends T> U create(Class<U> c);\n}\npublic class BooleanFactory implements Factory<Boolean> {\n\tpublic <U extends Boolean> U create(Class<U> c) {\n\t\ttry { return c.newInstance(); } catch(Exception e) { return null; }\n\t}\n}\n"}, "----------\n1. WARNING in BooleanFactory.java (at line 5)\n\tpublic <U extends Boolean> U create(Class<U> c) {\n\t                  ^^^^^^^\nThe type parameter U should not be bounded by the final type Boolean. Final types cannot be further extended\n----------\n", null, null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test071() {
        this.runNegativeTest(new String[]{"D.java", "class D extends B<Integer> {\n\t@Override void m(Number t) {}\n\t@Override void m(Integer t) {}\n}\nclass A<T extends Number> { void m(T t) {} }\nclass B<S extends Integer> extends A<S> { @Override void m(S t) {} }"}, "----------\n1. ERROR in D.java (at line 2)\n\t@Override void m(Number t) {}\n\t               ^^^^^^^^^^^\nName clash: The method m(Number) of type D has the same erasure as m(T) of type A<T> but does not override it\n----------\n2. ERROR in D.java (at line 2)\n\t@Override void m(Number t) {}\n\t               ^^^^^^^^^^^\n" + this.mustOverrideMessage("m(Number)", "D") + "----------\n" + "3. WARNING in D.java (at line 6)\n" + "\tclass B<S extends Integer> extends A<S> { @Override void m(S t) {} }\n" + "\t                  ^^^^^^^\n" + "The type parameter S should not be bounded by the final type Integer. Final types cannot be further extended\n" + "----------\n");
    }

    public void test072() {
        this.runConformTest(new String[]{"B.java", "class A<E> { E foo(E e) { return null; } }\nclass B<T> extends A<T> {\n\t@Override T foo(Object arg0) { return null; }\n}"}, "");
    }

    public void test073() {
        this.runConformTest(new String[]{"NumericArray.java", "class Array<T> {\n\tpublic void add(T t) { System.out.println(false); }\n}\npublic class NumericArray<T extends Number> extends Array<T> {\n\tpublic static void main(String[] s) { new NumericArray<Integer>().add(1); }\n\t@Override public void add(Number n) { System.out.println(true); }\n}"}, "true");
    }

    public void test073a() {
        this.runConformTest(new String[]{"NumericArray2.java", "class Array<T> {\n\tpublic T add(T t) { System.out.println(false); return null; }\n}\npublic class NumericArray2<T extends Number> extends Array<T> {\n\tpublic static void main(String[] s) { new NumericArray2<Integer>().add(1); }\n\t@Override public T add(Number n) { System.out.println(true); return null; }\n}"}, "true");
    }

    public void test073b() {
        this.runConformTest(new String[]{"NumericArray3.java", "class Array<T> {\n\tpublic <U extends Number> void add(U u) {}\n}\npublic class NumericArray3<T extends Number> extends Array<T> {\n\tpublic static void main(String[] s) { new NumericArray3<Integer>().add(1); }\n\t@Override public void add(Number n) { System.out.println(true); }\n}"}, "true");
    }

    public void test073c() {
        this.runNegativeTest(new String[]{"NumericArray4.java", "class Array<T> {\n\tpublic <U> void add(T t) {}\n}\npublic class NumericArray4<T extends Number> extends Array<T> {\n\t@Override public <U> void add(Number n) {}\n}"}, "----------\n1. ERROR in NumericArray4.java (at line 5)\n\t@Override public <U> void add(Number n) {}\n\t                          ^^^^^^^^^^^^^\n" + this.mustOverrideMessage("add(Number)", "NumericArray4<T>") + "----------\n");
    }

    public void test073d() {
        this.runNegativeTest(new String[]{"NumericArray5.java", "class Array<T> {\n\tpublic <U> void add(T t, U u) {}\n}\npublic class NumericArray5<T extends Number> extends Array<T> {\n\t@Override public void add(Number n, Integer i) {}\n}"}, "----------\n1. ERROR in NumericArray5.java (at line 5)\n\t@Override public void add(Number n, Integer i) {}\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^\n" + this.mustOverrideMessage("add(Number, Integer)", "NumericArray5<T>") + "----------\n");
    }

    public void test074() {
        this.runNegativeTest(new String[]{"I.java", "interface I {}\ninterface J extends I { @Override void clone(); }"}, "----------\n1. WARNING in I.java (at line 2)\n\tinterface J extends I { @Override void clone(); }\n\t                                  ^^^^\nThe return type is incompatible with Object.clone(), thus this interface cannot be implemented\n----------\n2. ERROR in I.java (at line 2)\n\tinterface J extends I { @Override void clone(); }\n\t                                       ^^^^^^^\n" + this.mustOverrideMessage("clone()", "J") + "----------\n");
    }

    public void test074a() {
        this.runNegativeTest(new String[]{"I.java", "interface I { @Override void clone(); }\ninterface J extends I {}"}, "----------\n1. WARNING in I.java (at line 1)\n\tinterface I { @Override void clone(); }\n\t                        ^^^^\nThe return type is incompatible with Object.clone(), thus this interface cannot be implemented\n----------\n2. ERROR in I.java (at line 1)\n\tinterface I { @Override void clone(); }\n\t                             ^^^^^^^\n" + this.mustOverrideMessage("clone()", "I") + "----------\n");
    }

    public void test074b() {
        this.runNegativeTest(new String[]{"A.java", "interface I {\n\tint finalize();\n\tfloat hashCode();\n}\ninterface J extends I {}\nabstract class A implements J {}"}, "----------\n1. WARNING in A.java (at line 2)\n\tint finalize();\n\t^^^\nThe return type is incompatible with Object.finalize(), thus this interface cannot be implemented\n----------\n2. ERROR in A.java (at line 3)\n\tfloat hashCode();\n\t^^^^^\nThe return type is incompatible with Object.hashCode()\n----------\n3. ERROR in A.java (at line 6)\n\tabstract class A implements J {}\n\t               ^\nThe return types are incompatible for the inherited methods I.finalize(), Object.finalize()\n----------\n4. ERROR in A.java (at line 6)\n\tabstract class A implements J {}\n\t               ^\nThe return types are incompatible for the inherited methods I.hashCode(), Object.hashCode()\n----------\n");
    }

    public void test075() {
        this.runNegativeTest(new String[]{"A.java", "class A { <T, S extends J & I<T>> void foo() { } }\nclass B extends A { @Override <T1, S1 extends J & I<S1>> void foo() { } }\nclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\nclass D extends A { @Override <T3, S3 extends J & I<T3>> void foo() { } }\nclass E extends A { @Override <T4, S4 extends I<T4> & J> void foo() { } }\ninterface I<TT> {}\ninterface J {}"}, "----------\n1. ERROR in A.java (at line 2)\n\tclass B extends A { @Override <T1, S1 extends J & I<S1>> void foo() { } }\n\t                                                              ^^^^^\nName clash: The method foo() of type B has the same erasure as foo() of type A but does not override it\n----------\n2. ERROR in A.java (at line 2)\n\tclass B extends A { @Override <T1, S1 extends J & I<S1>> void foo() { } }\n\t                                                              ^^^^^\n" + this.mustOverrideMessage("foo()", "B") + "----------\n" + "3. WARNING in A.java (at line 3)\n" + "\tclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\n" + "\t                                                  ^\n" + "I is a raw type. References to generic type I<TT> should be parameterized\n" + "----------\n" + "4. ERROR in A.java (at line 3)\n" + "\tclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\n" + "\t                                                          ^^^^^\n" + "Name clash: The method foo() of type C has the same erasure as foo() of type A but does not override it\n" + "----------\n" + "5. ERROR in A.java (at line 3)\n" + "\tclass C extends A { @Override <T2, S2 extends J & I> void foo() { } }\n" + "\t                                                          ^^^^^\n" + this.mustOverrideMessage("foo()", "C") + "----------\n");
    }

    public void test075a() {
        this.runConformTest(new String[]{"A.java", "class A<U> { <S extends J> void foo(U u, S s) { } }\nclass B<V> extends A<V> { <S1 extends K> void foo(V v, S1 s) { } }\ninterface J {}\ninterface K extends J {}"}, "");
    }

    public void test075b() {
        this.runNegativeTest(new String[]{"A.java", "class A<U> { <T, S extends J & I<T>> void foo(U u, T t, S s) { } }\nclass B<V> extends A<V> { @Override <T1, S1 extends K & I<T1>> void foo(V v, T1 t, S1 s) { } }\ninterface I<TT> {}\ninterface J {}\ninterface K extends J {}"}, "----------\n1. ERROR in A.java (at line 2)\n\tclass B<V> extends A<V> { @Override <T1, S1 extends K & I<T1>> void foo(V v, T1 t, S1 s) { } }\n\t                                                                    ^^^^^^^^^^^^^^^^^^^^\n" + this.mustOverrideMessage("foo(V, T1, S1)", "B<V>") + "----------\n");
    }

    public void test076() {
        this.runConformTest(new String[]{"A.java", "class A {\n\t<T, S extends J & I<S>> void foo(S s) { }\n\t<T, S extends I<T> & J > void foo(S s) { }\n}\ninterface I<TT> {}\ninterface J {}\n"}, "");
    }

    public void test076a() {
        this.runNegativeTest(new String[]{"A.java", "class A {\n\t<T, S extends J & I<T>> void foo() { }\n\t<T, S extends I<T> & J> void foo() { }\n}\ninterface I<TT> {}\ninterface J {}\n"}, "----------\n1. ERROR in A.java (at line 2)\n\t<T, S extends J & I<T>> void foo() { }\n\t                             ^^^^^\nDuplicate method foo() in type A\n----------\n2. ERROR in A.java (at line 3)\n\t<T, S extends I<T> & J> void foo() { }\n\t                             ^^^^^\nDuplicate method foo() in type A\n----------\n");
    }

    public void test076b() {
        this.runNegativeTest(new String[]{"A.java", "class A {\n\t<T, S extends J & I<T>> void foo() { }\n\t<T, S extends I<T> & K> void foo() { }\n}\ninterface I<TT> {}\ninterface J {}\ninterface K extends J {}"}, "----------\n1. ERROR in A.java (at line 2)\n\t<T, S extends J & I<T>> void foo() { }\n\t                             ^^^^^\nDuplicate method foo() in type A\n----------\n2. ERROR in A.java (at line 3)\n\t<T, S extends I<T> & K> void foo() { }\n\t                             ^^^^^\nDuplicate method foo() in type A\n----------\n");
    }

    public void test077() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tObject o = new A<Integer>().foo(new Integer(1));\n}\ninterface I<T1> { I<T1> foo(T1 t); }\ninterface J<T2> { J<T2> foo(T2 t); }\nclass B<T> { public A<T> foo(T t) { return new A<T>(); } }\nclass A<S> extends B<S> implements I<S>, J<S> {}"}, "");
    }

    public void test077a() {
        this.runNegativeTest(new String[]{"I.java", "public interface I { I foo(); }\ninterface J { J foo(); }\ninterface K extends I, J { K foo(); }\ninterface L { K getI(); }\ninterface M { I getI(); }\ninterface N { J getI(); }\ninterface O extends L, M, N { K getI(); }\ninterface P extends L, M, N {}\nclass X implements L, M, N { public K getI() { return null; } }\nabstract class Y implements L, M, N {}\nabstract class Z implements L, M, N { public K getI() { return null; } }\n"}, "");
    }

    public void test078() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        customOptions.put("org.eclipse.jdt.core.compiler.source", "1.4");
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        this.runNegativeTest(true, new String[]{"X.java", "public abstract class X implements IAppendable {\n    public X append(char c) {\n        return null;\n    }\n}\n\ninterface IAppendable {\n\tIAppendable append(char c);\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\tpublic X append(char c) {\n\t       ^\nThe return type is incompatible with IAppendable.append(char)\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test079() {
        this.runNegativeTest(new String[]{"A.java", "class A<E> { void x(A<String> s) {} }\nclass B extends A { void x(A<String> s) {} }\nclass C extends A { @Override void x(A s) {} }\nclass D extends A { void x(A<Object> s) {} }"}, "----------\n1. WARNING in A.java (at line 2)\n\tclass B extends A { void x(A<String> s) {} }\n\t                ^\nA is a raw type. References to generic type A<E> should be parameterized\n----------\n2. ERROR in A.java (at line 2)\n\tclass B extends A { void x(A<String> s) {} }\n\t                         ^^^^^^^^^^^^^^\nName clash: The method x(A<String>) of type B has the same erasure as x(A) of type A but does not override it\n----------\n3. WARNING in A.java (at line 3)\n\tclass C extends A { @Override void x(A s) {} }\n\t                ^\nA is a raw type. References to generic type A<E> should be parameterized\n----------\n4. WARNING in A.java (at line 3)\n\tclass C extends A { @Override void x(A s) {} }\n\t                                     ^\nA is a raw type. References to generic type A<E> should be parameterized\n----------\n5. WARNING in A.java (at line 4)\n\tclass D extends A { void x(A<Object> s) {} }\n\t                ^\nA is a raw type. References to generic type A<E> should be parameterized\n----------\n6. ERROR in A.java (at line 4)\n\tclass D extends A { void x(A<Object> s) {} }\n\t                         ^^^^^^^^^^^^^^\nName clash: The method x(A<Object>) of type D has the same erasure as x(A) of type A but does not override it\n----------\n");
    }

    public void test080() {
        this.runNegativeTest(new String[]{"HashOrder.java", "public class HashOrder extends DoubleHash<String> {\n\tpublic static HashOrder create() { return null; }\n}\nclass DoubleHash<T> {\n\tpublic static <U> DoubleHash<U> create() { return null; }\n}"}, "----------\n1. WARNING in HashOrder.java (at line 2)\n\tpublic static HashOrder create() { return null; }\n\t              ^^^^^^^^^\nType safety: The return type HashOrder for create() from the type HashOrder needs unchecked conversion to conform to DoubleHash<Object> from the type DoubleHash<String>\n----------\n");
    }

    public void test081() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X<U> implements I {\n\tpublic A<String> foo() { return null; }\n\tpublic <S> A<U> bar() { return null; }\n}\ninterface I {\n\t<T> A<T> foo();\n\t<S> A<S> bar();\n}\nclass A<V> {}"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic A<String> foo() { return null; }\n\t       ^\nType safety: The return type A<String> for foo() from the type X<U> needs unchecked conversion to conform to A<Object> from the type I\n----------\n2. ERROR in X.java (at line 3)\n\tpublic <S> A<U> bar() { return null; }\n\t           ^^^^\nThe return type is incompatible with I.bar()\n----------\n");
    }

    public void test082() {
        this.runNegativeTest(new String[]{"V.java", "public class V extends U { @Override public C<B> foo() { return null; } }\nclass U { public <T extends A> C<T> foo() { return null; } }\nclass A {}\nclass B extends A {}\nclass C<T> {}"}, "----------\n1. WARNING in V.java (at line 1)\n\tpublic class V extends U { @Override public C<B> foo() { return null; } }\n\t                                            ^\nType safety: The return type C<B> for foo() from the type V needs unchecked conversion to conform to C<A> from the type U\n----------\n");
    }

    public void test083() {
        this.runConformTest(new String[]{"C.java", "public class C extends p.B {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(((p.I) new C()).m() == null);\n\t}\n}", "p/B.java", "package p;\npublic abstract class B extends A {}\nabstract class A implements I {\n\tpublic A m() { return null; }\n}", "p/I.java", "package p;\npublic interface I { I m(); }\n"}, "true");
    }

    public void test084() {
        this.runConformTest(new String[]{"A.java", "public class A<T1 extends A.M> implements I<T1> {\n\tpublic java.util.List<T1> f(M n) { return null; }\n\tstatic class M {}\n}\ninterface I<T2> {\n\tjava.util.List<T2> f(T2 t);\n}"}, "");
    }

    public void test084a() {
        this.runConformTest(new String[]{"A.java", "public class A<T1 extends A.M> implements I<T1> {\n\tpublic void foo(Number n, M m) {}\n\tpublic void foo2(Number n, M m) {}\n\tpublic void foo3(Number n, M m) {}\n\tstatic class M {}\n}\ninterface I<T2> {\n\t<U extends Number> void foo(U u, T2 t);\n\tvoid foo2(Number n, T2 t);\n\t<U extends Number> void foo3(U u, A.M m);\n}"}, "");
    }

    public void test084b() {
        this.runNegativeTest(new String[]{"A.java", "public class A<T1 extends A.M> implements I<T1> {\n\tpublic void foo4(Number n, T1 m) {}\n\tstatic class M {}\n}\ninterface I<T2> {\n\t<U extends Number> void foo4(U u, A.M m);\n}"}, "----------\n1. ERROR in A.java (at line 1)\n\tpublic class A<T1 extends A.M> implements I<T1> {\n\t             ^\nThe type A<T1> must implement the inherited abstract method I<T1>.foo4(U, A.M)\n----------\n2. ERROR in A.java (at line 2)\n\tpublic void foo4(Number n, T1 m) {}\n\t            ^^^^^^^^^^^^^^^^^^^^\nName clash: The method foo4(Number, T1) of type A<T1> has the same erasure as foo4(U, A.M) of type I<T2> but does not override it\n----------\n");
    }

    public void test085() {
        this.runNegativeTest(new String[]{"Parent.java", "import java.util.Collection;\npublic class Parent {\n\tstatic void staticCase1(Collection c) {}\n\tstatic void staticCase2(Collection<String> c) {}\n\tvoid instanceCase1(Collection c) {}\n\tvoid instanceCase2(Collection<String> c) {}\n}\nclass Child extends Parent {\n\tstatic void staticCase1(Collection<String> c) {}\n\tstatic void staticCase2(Collection c) {}\n\tvoid instanceCase1(Collection<String> c) {}\n\t@Override void instanceCase2(Collection c) {}\n}"}, this.complianceLevel < 0x330000L ? "----------\n1. WARNING in Parent.java (at line 3)\n\tstatic void staticCase1(Collection c) {}\n\t                        ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in Parent.java (at line 5)\n\tvoid instanceCase1(Collection c) {}\n\t                   ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. WARNING in Parent.java (at line 10)\n\tstatic void staticCase2(Collection c) {}\n\t                        ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n4. ERROR in Parent.java (at line 11)\n\tvoid instanceCase1(Collection<String> c) {}\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method instanceCase1(Collection<String>) of type Child has the same erasure as instanceCase1(Collection) of type Parent but does not override it\n----------\n5. WARNING in Parent.java (at line 12)\n\t@Override void instanceCase2(Collection c) {}\n\t                             ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n" : "----------\n1. WARNING in Parent.java (at line 3)\n\tstatic void staticCase1(Collection c) {}\n\t                        ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in Parent.java (at line 5)\n\tvoid instanceCase1(Collection c) {}\n\t                   ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in Parent.java (at line 9)\n\tstatic void staticCase1(Collection<String> c) {}\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method staticCase1(Collection<String>) of type Child has the same erasure as staticCase1(Collection) of type Parent but does not hide it\n----------\n4. WARNING in Parent.java (at line 10)\n\tstatic void staticCase2(Collection c) {}\n\t                        ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n5. ERROR in Parent.java (at line 11)\n\tvoid instanceCase1(Collection<String> c) {}\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method instanceCase1(Collection<String>) of type Child has the same erasure as instanceCase1(Collection) of type Parent but does not override it\n----------\n6. WARNING in Parent.java (at line 12)\n\t@Override void instanceCase2(Collection c) {}\n\t                             ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n");
    }

    public void test085b() {
        this.runNegativeTest(new String[]{"Parent.java", "import java.util.Collection;\npublic class Parent {\n\tstatic void staticMismatchCase1(Collection c) {}\n\tstatic void staticMismatchCase2(Collection<String> c) {}\n\tvoid mismatchCase1(Collection c) {}\n\tvoid mismatchCase2(Collection<String> c) {}\n}\nclass Child extends Parent {\n\tvoid staticMismatchCase1(Collection c) {}\n\tvoid staticMismatchCase2(Collection<String> c) {}\n\tstatic void mismatchCase1(Collection c) {}\n\tstatic void mismatchCase2(Collection<String> c) {}\n}"}, "----------\n1. WARNING in Parent.java (at line 3)\n\tstatic void staticMismatchCase1(Collection c) {}\n\t                                ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n2. WARNING in Parent.java (at line 5)\n\tvoid mismatchCase1(Collection c) {}\n\t                   ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in Parent.java (at line 9)\n\tvoid staticMismatchCase1(Collection c) {}\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis instance method cannot override the static method from Parent\n----------\n4. WARNING in Parent.java (at line 9)\n\tvoid staticMismatchCase1(Collection c) {}\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n5. ERROR in Parent.java (at line 10)\n\tvoid staticMismatchCase2(Collection<String> c) {}\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis instance method cannot override the static method from Parent\n----------\n6. ERROR in Parent.java (at line 11)\n\tstatic void mismatchCase1(Collection c) {}\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis static method cannot hide the instance method from Parent\n----------\n7. WARNING in Parent.java (at line 11)\n\tstatic void mismatchCase1(Collection c) {}\n\t                          ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n8. ERROR in Parent.java (at line 12)\n\tstatic void mismatchCase2(Collection<String> c) {}\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThis static method cannot hide the instance method from Parent\n----------\n");
    }

    public void test085c() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X<V> extends CX<V> implements IX<V> {}\nclass CX<T> { public static void foo(Object o) {} }\nabstract class X2 extends CX implements IX {}\ninterface IX<U> { void foo(U u); }"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract class X<V> extends CX<V> implements IX<V> {}\n\t                      ^\nThe static method foo(Object) conflicts with the abstract method in IX<V>\n----------\n2. ERROR in X.java (at line 3)\n\tabstract class X2 extends CX implements IX {}\n\t               ^^\nThe static method foo(Object) conflicts with the abstract method in IX\n----------\n3. WARNING in X.java (at line 3)\n\tabstract class X2 extends CX implements IX {}\n\t                          ^^\nCX is a raw type. References to generic type CX<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\n\tabstract class X2 extends CX implements IX {}\n\t                                        ^^\nIX is a raw type. References to generic type IX<U> should be parameterized\n----------\n");
    }

    public void test086() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements I { public <T extends Object & Data> void copyData(T data) {} }\ninterface I { <A extends Data> void copyData(A data); }\ninterface Data {}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements I { public <T extends Object & Data> void copyData(T data) {} }\n\t             ^\nThe type X must implement the inherited abstract method I.copyData(A)\n----------\n");
    }

    public void test086b() {
        this.runConformTest(new String[]{"X.java", "public class X implements I { public <T> G<T> foo(Class<T> stuffClass) { return null; } }\ninterface I { <T extends Object> G<T> foo(Class<T> stuffClass); }\nclass G<T> {}"}, "");
    }

    public void test087() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\n\ninterface Interface1 {\n}\ninterface Interface2 extends Interface1 {\n}\ninterface Interface3 {\n    <P extends Interface1> Collection<P> doStuff();\n}\ninterface Interface4 extends Interface3 {\n    Collection<Interface2> doStuff();\n}\npublic class X {\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 11)\n\tCollection<Interface2> doStuff();\n\t^^^^^^^^^^\nType safety: The return type Collection<Interface2> for doStuff() from the type Interface4 needs unchecked conversion to conform to Collection<Interface1> from the type Interface3\n----------\n2. ERROR in X.java (at line 14)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test088() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X<T0> extends ArrayList<T0> implements I<T0>,Runnable {\n\t\n\tvoid foo() {\n\t\tthis.add(new Object());\n\t\tthis.add(null);\n\t}\n}\ninterface I<T1> extends Collection<String> {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic class X<T0> extends ArrayList<T0> implements I<T0>,Runnable {\n\t             ^\nThe interface Collection cannot be implemented more than once with different arguments: Collection<T0> and Collection<String>\n----------\n2. ERROR in X.java (at line 2)\n\tpublic class X<T0> extends ArrayList<T0> implements I<T0>,Runnable {\n\t             ^\nThe type X<T0> must implement the inherited abstract method Runnable.run()\n----------\n3. WARNING in X.java (at line 2)\n\tpublic class X<T0> extends ArrayList<T0> implements I<T0>,Runnable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n4. ERROR in X.java (at line 5)\n\tthis.add(new Object());\n\t     ^^^\nThe method add(T0) in the type ArrayList<T0> is not applicable for the arguments (Object)\n----------\n");
    }

    public void test089() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\npublic class X extends X2 {}\nabstract class X2 extends X3 implements List<String> {}\nabstract class X3 implements List<Thread> {}"}, "----------\n1. ERROR in X.java (at line 3)\n\tabstract class X2 extends X3 implements List<String> {}\n\t               ^^\nThe interface List cannot be implemented more than once with different arguments: List<Thread> and List<String>\n----------\n");
    }

    public void test090() throws Exception {
        this.runConformTest(new String[]{"X.java", "class XSuper {\n\tObject foo() throws Exception { return null; }\n\tprotected Object bar() throws Exception { return null; }\n}\npublic class X extends XSuper {\n\tprotected String foo() { return null; }\n\tpublic String bar() { return null; }\n}"}, "");
        String expectedOutput = "  // Method descriptor #17 ()Ljava/lang/Object;\n  // Stack: 1, Locals: 1\n  public bridge synthetic java.lang.Object bar() throws java.lang.Exception;\n    0  aload_0 [this]\n    1  invokevirtual X.bar() : java.lang.String [21]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 1]\n  \n  // Method descriptor #17 ()Ljava/lang/Object;\n  // Stack: 1, Locals: 1\n  protected bridge synthetic java.lang.Object foo() throws java.lang.Exception;\n    0  aload_0 [this]\n    1  invokevirtual X.foo() : java.lang.String [23]\n    4  areturn\n      Line numbers:\n        [pc: 0, line: 1]\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            MethodVerifyTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test091() {
        this.runNegativeTest(new String[]{"DataSet.java", "import java.io.Serializable;\nimport java.util.*;\n\nclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t\n\tpublic <S> S[] toArray(S[] s) {\n\t\treturn s;\n\t}\n\n\tpublic boolean add(Object o) { return false; }\n\tpublic void add(int index, Object element) {}\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\tpublic void clear() {}\n\tpublic boolean contains(Object o) {\treturn false; }\n\tpublic boolean containsAll(Collection c) { return false; }\n\tpublic Object get(int index) { return null; }\n\tpublic int indexOf(Object o) { return 0; }\n\tpublic boolean isEmpty() {\treturn false; }\n\tpublic Iterator iterator() {\treturn null; }\n\tpublic int lastIndexOf(Object o) {\treturn 0; }\n\tpublic ListIterator listIterator() {\treturn null; }\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\tpublic boolean remove(Object o) {\treturn false; }\n\tpublic Object remove(int index) {\treturn null; }\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\tpublic Object set(int index, Object element) {\treturn false; }\n\tpublic int size() {\treturn 0; }\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\tpublic Object[] toArray() {\treturn null; }\n\tpublic boolean hasNext() {\treturn false; }\n\tpublic Object next() {\treturn null; }\n\tpublic void remove() {}\n}\n"}, "----------\n1. ERROR in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe type DataSet<T> must implement the inherited abstract method List.toArray(Object[])\n----------\n2. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe serializable class DataSet does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                           ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                                 ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n5. ERROR in DataSet.java (at line 6)\n\tpublic <S> S[] toArray(S[] s) {\n\t               ^^^^^^^^^^^^^^\nName clash: The method toArray(S[]) of type DataSet<T> has the same erasure as toArray(Object[]) of type List but does not override it\n----------\n6. ERROR in DataSet.java (at line 6)\n\tpublic <S> S[] toArray(S[] s) {\n\t               ^^^^^^^^^^^^^^\nName clash: The method toArray(S[]) of type DataSet<T> has the same erasure as toArray(Object[]) of type Collection but does not override it\n----------\n7. WARNING in DataSet.java (at line 12)\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\t                      ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n8. WARNING in DataSet.java (at line 13)\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\t                                 ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n9. WARNING in DataSet.java (at line 16)\n\tpublic boolean containsAll(Collection c) { return false; }\n\t                           ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n10. WARNING in DataSet.java (at line 20)\n\tpublic Iterator iterator() {\treturn null; }\n\t       ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n11. WARNING in DataSet.java (at line 22)\n\tpublic ListIterator listIterator() {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n12. WARNING in DataSet.java (at line 23)\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n13. WARNING in DataSet.java (at line 26)\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n14. WARNING in DataSet.java (at line 27)\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n15. WARNING in DataSet.java (at line 30)\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test092() {
        this.runNegativeTest(new String[]{"DataSet.java", "import java.io.Serializable;\nimport java.util.*;\n\nclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t\n\tpublic <S extends T> S[] toArray(S[] s) {\n\t\treturn s;\n\t}\n\n\tpublic boolean add(Object o) { return false; }\n\tpublic void add(int index, Object element) {}\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\tpublic void clear() {}\n\tpublic boolean contains(Object o) {\treturn false; }\n\tpublic boolean containsAll(Collection c) { return false; }\n\tpublic Object get(int index) { return null; }\n\tpublic int indexOf(Object o) { return 0; }\n\tpublic boolean isEmpty() {\treturn false; }\n\tpublic Iterator iterator() {\treturn null; }\n\tpublic int lastIndexOf(Object o) {\treturn 0; }\n\tpublic ListIterator listIterator() {\treturn null; }\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\tpublic boolean remove(Object o) {\treturn false; }\n\tpublic Object remove(int index) {\treturn null; }\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\tpublic Object set(int index, Object element) {\treturn false; }\n\tpublic int size() {\treturn 0; }\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\tpublic Object[] toArray() {\treturn null; }\n\tpublic boolean hasNext() {\treturn false; }\n\tpublic Object next() {\treturn null; }\n\tpublic void remove() {}\n}\n"}, "----------\n1. ERROR in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe type DataSet<T> must implement the inherited abstract method List.toArray(Object[])\n----------\n2. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe serializable class DataSet does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                           ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                                 ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n5. WARNING in DataSet.java (at line 12)\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\t                      ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n6. WARNING in DataSet.java (at line 13)\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\t                                 ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n7. WARNING in DataSet.java (at line 16)\n\tpublic boolean containsAll(Collection c) { return false; }\n\t                           ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n8. WARNING in DataSet.java (at line 20)\n\tpublic Iterator iterator() {\treturn null; }\n\t       ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n9. WARNING in DataSet.java (at line 22)\n\tpublic ListIterator listIterator() {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n10. WARNING in DataSet.java (at line 23)\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n11. WARNING in DataSet.java (at line 26)\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n12. WARNING in DataSet.java (at line 27)\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n13. WARNING in DataSet.java (at line 30)\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test093() {
        this.runNegativeTest(new String[]{"DataSet.java", "import java.io.Serializable;\nimport java.util.*;\n\nclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t\n\tpublic <S> S[] toArray(S[] s) {\n\t\treturn s;\n\t}\n\tpublic Object[] toArray(Object[] o) {\n\t\treturn o;\n\t}\n\tpublic boolean add(Object o) { return false; }\n\tpublic void add(int index, Object element) {}\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\tpublic void clear() {}\n\tpublic boolean contains(Object o) {\treturn false; }\n\tpublic boolean containsAll(Collection c) { return false; }\n\tpublic Object get(int index) { return null; }\n\tpublic int indexOf(Object o) { return 0; }\n\tpublic boolean isEmpty() {\treturn false; }\n\tpublic Iterator iterator() {\treturn null; }\n\tpublic int lastIndexOf(Object o) {\treturn 0; }\n\tpublic ListIterator listIterator() {\treturn null; }\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\tpublic boolean remove(Object o) {\treturn false; }\n\tpublic Object remove(int index) {\treturn null; }\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\tpublic Object set(int index, Object element) {\treturn false; }\n\tpublic int size() {\treturn 0; }\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\tpublic Object[] toArray() {\treturn null; }\n\tpublic boolean hasNext() {\treturn false; }\n\tpublic Object next() {\treturn null; }\n\tpublic void remove() {}\n}\n"}, "----------\n1. ERROR in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe type DataSet<T> must implement the inherited abstract method List.toArray(Object[])\n----------\n2. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t      ^^^^^^^\nThe serializable class DataSet does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                           ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in DataSet.java (at line 4)\n\tclass DataSet<T extends Number> implements List, Iterator, Serializable {\n\t                                                 ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n5. ERROR in DataSet.java (at line 6)\n\tpublic <S> S[] toArray(S[] s) {\n\t               ^^^^^^^^^^^^^^\nErasure of method toArray(S[]) is the same as another method in type DataSet<T>\n----------\n6. ERROR in DataSet.java (at line 6)\n\tpublic <S> S[] toArray(S[] s) {\n\t               ^^^^^^^^^^^^^^\nName clash: The method toArray(S[]) of type DataSet<T> has the same erasure as toArray(Object[]) of type List but does not override it\n----------\n7. ERROR in DataSet.java (at line 6)\n\tpublic <S> S[] toArray(S[] s) {\n\t               ^^^^^^^^^^^^^^\nName clash: The method toArray(S[]) of type DataSet<T> has the same erasure as toArray(Object[]) of type Collection but does not override it\n----------\n8. ERROR in DataSet.java (at line 9)\n\tpublic Object[] toArray(Object[] o) {\n\t                ^^^^^^^^^^^^^^^^^^^\nErasure of method toArray(Object[]) is the same as another method in type DataSet<T>\n----------\n9. WARNING in DataSet.java (at line 14)\n\tpublic boolean addAll(Collection c) {\treturn false; }\n\t                      ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n10. WARNING in DataSet.java (at line 15)\n\tpublic boolean addAll(int index, Collection c) {\treturn false; }\n\t                                 ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n11. WARNING in DataSet.java (at line 18)\n\tpublic boolean containsAll(Collection c) { return false; }\n\t                           ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n12. WARNING in DataSet.java (at line 22)\n\tpublic Iterator iterator() {\treturn null; }\n\t       ^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n13. WARNING in DataSet.java (at line 24)\n\tpublic ListIterator listIterator() {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n14. WARNING in DataSet.java (at line 25)\n\tpublic ListIterator listIterator(int index) {\treturn null; }\n\t       ^^^^^^^^^^^^\nListIterator is a raw type. References to generic type ListIterator<E> should be parameterized\n----------\n15. WARNING in DataSet.java (at line 28)\n\tpublic boolean removeAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n16. WARNING in DataSet.java (at line 29)\n\tpublic boolean retainAll(Collection c) {\treturn false; }\n\t                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n17. WARNING in DataSet.java (at line 32)\n\tpublic List subList(int fromIndex, int toIndex) {\treturn null; }\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void test094() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.JavacCompilesIncorrectSource, new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Arrays;\nclass Y<T> {}\npublic class X\n{\n  private static ArrayList<Y<X>> y = new ArrayList<Y<X>>();\n  void foo(Y[] array)\n  {\n    y.addAll(Arrays.asList(array));\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tvoid foo(Y[] array)\n\t         ^\nY is a raw type. References to generic type Y<T> should be parameterized\n----------\n2. ERROR in X.java (at line 9)\n\ty.addAll(Arrays.asList(array));\n\t  ^^^^^^\nThe method addAll(Collection<? extends Y<X>>) in the type ArrayList<Y<X>> is not applicable for the arguments (List<Y>)\n----------\n");
    }

    public void test096() {
        this.runNegativeTest(new String[]{"ProblemClass.java", "import java.util.Collection;\nimport javax.swing.JLabel;\ninterface SuperInterface {\n   public <A extends JLabel> void doIt(Collection<A> as);\n}\n\npublic class ProblemClass implements SuperInterface {\n   public void doIt(Collection<? extends JLabel> as) {\n   }\n}\n"}, "----------\n1. ERROR in ProblemClass.java (at line 7)\n\tpublic class ProblemClass implements SuperInterface {\n\t             ^^^^^^^^^^^^\nThe type ProblemClass must implement the inherited abstract method SuperInterface.doIt(Collection<A>)\n----------\n2. ERROR in ProblemClass.java (at line 8)\n\tpublic void doIt(Collection<? extends JLabel> as) {\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method doIt(Collection<? extends JLabel>) of type ProblemClass has the same erasure as doIt(Collection<A>) of type SuperInterface but does not override it\n----------\n");
    }

    public void test097() {
        this.runConformTest(new String[]{"ProblemClass.java", "import java.util.Collection;\nimport javax.swing.JLabel;\ninterface SuperInterface {\n   public <A extends JLabel> void doIt(Collection<A> as);\n}\n\npublic class ProblemClass implements SuperInterface {\n   public <B extends JLabel> void doIt(Collection<B> as) {\n   }\n}\n"}, "");
    }

    public void test098() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X<A, B> {\n    public X(List<A> toAdd) {\n    }\n    public <L extends List<? super A>, LF extends Factory<L>> L \n            foo(B b, L l, LF lf) {\n        return l;\n    }\n    public static class ListFactory<T> implements Factory<List<T>> {\n        public List<T> create() {\n            return null;\n        }\n    }\n    public static interface Factory<T> {\n        public T create();\n    }\n    public static void bar() {\n        (new X<Long, Number>(new ArrayList<Long>())).\n            foo(1, (List<Number>) null, new ListFactory<Number>());\n    }\n}"}, "");
    }

    public void test099() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.source", "1.4");
        this.runConformTest(new String[]{"TestCharset.java", "import java.nio.charset.*;\npublic class TestCharset extends Charset {\n\tprotected TestCharset(String n, String[] a) { super(n, a); }\n\tpublic boolean contains(Charset cs) { return false; }\n\tpublic CharsetDecoder newDecoder() { return null; }\n\tpublic CharsetEncoder newEncoder() { return null; }\n}\n"}, "", null, true, null, customOptions, null);
    }

    public void test100() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\npublic class X<E> {\n  boolean removeAll(Collection<? extends E> c) {\n    return false;\n  }\n}\n", "Y.java", "import java.util.Collection;\npublic class Y<E> extends X<E>\n{\n  <T extends E> boolean removeAll(Collection<T> c) {\n    return false;\n  }\n}"}, "----------\n1. ERROR in Y.java (at line 4)\n\t<T extends E> boolean removeAll(Collection<T> c) {\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method removeAll(Collection<T>) of type Y<E> has the same erasure as removeAll(Collection<? extends E>) of type X<E> but does not override it\n----------\n");
    }

    public void test101() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 3)\n\tInteger getX(List<Integer> l) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nErasure of method getX(List<Integer>) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 6)\n\tString getX(List<String> l) {\n\t       ^^^^^^^^^^^^^^^^^^^^\nErasure of method getX(List<String>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 11)\n\tInteger getX(List<Integer> l) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nDuplicate method getX(List<Integer>) in type Y\n----------\n4. ERROR in X.java (at line 14)\n\tString getX(List<Integer> l) {\n\t       ^^^^^^^^^^^^^^^^^^^^^\nDuplicate method getX(List<Integer>) in type Y\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tInteger getX(List<Integer> l) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nErasure of method getX(List<Integer>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 6)\n\tString getX(List<String> l) {\n\t       ^^^^^^^^^^^^^^^^^^^^\nErasure of method getX(List<String>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 11)\n\tInteger getX(List<Integer> l) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nDuplicate method getX(List<Integer>) in type Y\n----------\n4. ERROR in X.java (at line 14)\n\tString getX(List<Integer> l) {\n\t       ^^^^^^^^^^^^^^^^^^^^^\nDuplicate method getX(List<Integer>) in type Y\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n    Integer getX(List<Integer> l) {\n        return null;\n    }\n    String getX(List<String> l) {\n        return null;\n    }\n}\nclass Y {\n    Integer getX(List<Integer> l) {\n        return null;\n    }\n    String getX(List<Integer> l) {\n        return null;\n    }\n}"}, expectedCompilerLog);
    }

    public void test102() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate interface ReturnLeaf extends ReturnDerived {\n\t}\n\n\tprivate interface Interface {\n\t\tReturnBase bar();\n\t}\n\n\tprivate static class Implementation {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child extends Implementation implements Interface {\n\t}\n\n\tprivate static class Grandchild extends Child implements Interface {\n\t\t@Override\n\t\tpublic ReturnLeaf bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 26)\n\tpublic ReturnLeaf bar() {\n\t                  ^^^^^\nCannot override the final method from X.Implementation\n----------\n", null, true, options);
    }

    public void test103() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate interface Interface {\n\t\tReturnBase bar();\n\t}\n\n\tprivate static class Implementation {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Grandchild extends Child implements Interface {\n\t}\n\n\tprivate static class Child extends Implementation implements Interface {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "", null, true, null, options, null);
        File fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Child.class");
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        boolean found = false;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertTrue((String)"bar should be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Grandchild.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        found = false;
        i = 0;
        max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
    }

    public void test104() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate interface Interface {\n\t\tReturnBase bar();\n\t}\n\n\tprivate static class Implementation {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child extends Implementation implements Interface {\n\t}\n\n\tprivate static class Grandchild extends Child implements Interface {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "", null, true, null, options, null);
        File fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Child.class");
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        boolean found = false;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertTrue((String)"bar should be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Grandchild.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        found = false;
        i = 0;
        max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
    }

    public void test105() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate static class Super {\n\t\tReturnBase bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Implementation extends Super {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child extends Implementation {\n\t}\n\n\tprivate static class Grandchild extends Child {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "", null, true, null, options, null);
        File fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Child.class");
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        boolean found = false;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Grandchild.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        found = false;
        i = 0;
        max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Implementation.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        int count = 0;
        found = false;
        int i2 = 0;
        int max2 = methodInfos.length;
        while (i2 < max2) {
            IMethodInfo methodInfo = methodInfos[i2];
            if (new String(methodInfo.getName()).equals("bar")) {
                ++count;
                if (Flags.isBridge((int)methodInfo.getAccessFlags())) {
                    found = true;
                }
            }
            ++i2;
        }
        MethodVerifyTest.assertEquals((String)"Should have two method bar", (int)2, (int)count);
        MethodVerifyTest.assertTrue((String)"should have one bridge method", (boolean)found);
    }

    public void test106() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate static class Super {\n\t\tReturnBase bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static abstract class Implementation extends Super {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child extends Implementation {\n\t}\n\n\tprivate static class Grandchild extends Child {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "", null, true, null, options, null);
        File fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Child.class");
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        boolean found = false;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Grandchild.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        found = false;
        i = 0;
        max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Implementation.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        int count = 0;
        found = false;
        int i2 = 0;
        int max2 = methodInfos.length;
        while (i2 < max2) {
            IMethodInfo methodInfo = methodInfos[i2];
            if (new String(methodInfo.getName()).equals("bar")) {
                ++count;
                if (Flags.isBridge((int)methodInfo.getAccessFlags())) {
                    found = true;
                }
            }
            ++i2;
        }
        MethodVerifyTest.assertEquals((String)"should have two methods bar", (int)2, (int)count);
        MethodVerifyTest.assertTrue((String)"should have one bridge method", (boolean)found);
    }

    public void test107() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate interface Interface<E> {\n\t\tReturnBase bar();\n\t}\n\n\tprivate static class Implementation<T> {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child<U> extends Implementation<U> implements Interface<U> {\n\t}\n\n\tprivate static class Grandchild<V> extends Child<V> implements Interface<V> {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "", null, true, null, options, null);
        File fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Child.class");
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        boolean found = false;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertTrue((String)"bar should be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Grandchild.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        found = false;
        i = 0;
        max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
    }

    public void test108() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate interface ReturnLeaf extends ReturnDerived {\n\t}\n\n\tprivate interface Interface<E> {\n\t\tReturnBase bar();\n\t}\n\n\tprivate static class Implementation<T> {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child<U> extends Implementation<U> implements Interface<U> {\n\t}\n\n\tprivate static class Grandchild<V> extends Child<V> implements Interface<V> {\n\t\t@Override\n\t\tpublic ReturnLeaf bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild<String>();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 26)\n\tpublic ReturnLeaf bar() {\n\t                  ^^^^^\nCannot override the final method from X.Implementation<V>\n----------\n", null, true, options);
    }

    public void test109() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate interface Interface<E> {\n\t\tReturnBase bar();\n\t}\n\n\tprivate static class Implementation<T> {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Grandchild<V> extends Child<V> implements Interface<V> {\n\t}\n\n\tprivate static class Child<U> extends Implementation<U> implements Interface<U> {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "", null, true, null, options, null);
        File fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Child.class");
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        boolean found = false;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertTrue((String)"bar should be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Grandchild.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        found = false;
        i = 0;
        max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
    }

    public void test110() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate interface Interface<E> {\n\t\tReturnBase bar();\n\t}\n\n\tprivate static class Implementation<T> {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child<U> extends Implementation<U> implements Interface<U> {\n\t}\n\n\tprivate static class Grandchild<V> extends Child<V> implements Interface<V> {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "", null, true, null, options, null);
        File fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Child.class");
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        boolean found = false;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertTrue((String)"bar should be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Grandchild.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        found = false;
        i = 0;
        max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
    }

    public void test111() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate static class Super<E> {\n\t\tReturnBase bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Implementation<T> extends Super<T> {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child<U> extends Implementation<U> {\n\t}\n\n\tprivate static class Grandchild<V> extends Child<V> {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "", null, true, null, options, null);
        File fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Child.class");
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        boolean found = false;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Grandchild.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        found = false;
        i = 0;
        max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Implementation.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        int count = 0;
        found = false;
        int i2 = 0;
        int max2 = methodInfos.length;
        while (i2 < max2) {
            IMethodInfo methodInfo = methodInfos[i2];
            if (new String(methodInfo.getName()).equals("bar")) {
                ++count;
                if (Flags.isBridge((int)methodInfo.getAccessFlags())) {
                    found = true;
                }
            }
            ++i2;
        }
        MethodVerifyTest.assertEquals((String)"should have two methods bar", (int)2, (int)count);
        MethodVerifyTest.assertTrue((String)"should have one bridge method", (boolean)found);
    }

    public void test112() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate interface ReturnBase {\n\t}\n\n\tprivate interface ReturnDerived extends ReturnBase {\n\t}\n\n\tprivate static class Super<E> {\n\t\tReturnBase bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static abstract class Implementation<T> extends Super<T> {\n\t\tpublic final ReturnDerived bar() {\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate static class Child<U> extends Implementation<U> {\n\t}\n\n\tprivate static class Grandchild<V> extends Child<V> {\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew Grandchild();\n\t}\n}"}, "", null, true, null, options, null);
        File fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Child.class");
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        boolean found = false;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Grandchild.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        found = false;
        i = 0;
        max = methodInfos.length;
        while (i < max) {
            if (new String(methodInfos[i].getName()).equals("bar")) {
                found = true;
                break;
            }
            ++i;
        }
        MethodVerifyTest.assertFalse((String)"bar should not be there", (boolean)found);
        fileX = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X$Implementation.class");
        reader = ToolFactory.createDefaultClassFileReader((String)fileX.getAbsolutePath(), (int)65503);
        methodInfos = reader.getMethodInfos();
        int count = 0;
        found = false;
        int i2 = 0;
        int max2 = methodInfos.length;
        while (i2 < max2) {
            IMethodInfo methodInfo = methodInfos[i2];
            if (new String(methodInfo.getName()).equals("bar")) {
                ++count;
                if (Flags.isBridge((int)methodInfo.getAccessFlags())) {
                    found = true;
                }
            }
            ++i2;
        }
        MethodVerifyTest.assertEquals((String)"should have two methods bar", (int)2, (int)count);
        MethodVerifyTest.assertTrue((String)"should have one bridge method", (boolean)found);
    }

    public void test113() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runConformTest(new String[]{"X.java", "abstract class Y {\n  abstract void foo();\n}\npublic class X extends Y {\n  void foo() {\n    // should not complain for missing super call, since overriding \n    // abstract method\n  }\n}"}, "", null, true, null, options, null);
    }

    public void test114() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runNegativeTest(true, new String[]{"X.java", "class Y {\n  void foo() {}\n}\npublic class X extends Y {\n  @Override\n  void foo() {\n  }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 6)\n\tvoid foo() {\n\t     ^^^^^\nThe method X.foo() is overriding a method without making a super invocation\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test115() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runConformTest(new String[]{"X.java", "class Y {\n  void foo() {}\n}\npublic class X extends Y {\n  @Override\n  void foo() {\n    super.foo();\n  }\n}"}, "", null, true, null, options, null);
    }

    public void test116() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runNegativeTest(new String[]{"X.java", "class Y {\n  Zork foo() {}\n}\npublic class X extends Y {\n  @Override\n  Object foo() {\n     return new Y() {\n         Object foo() {\n            return null;\n         }\n     };  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork foo() {}\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\tObject foo() {\n\t^^^^^^\nThe return type is incompatible with Y.foo()\n----------\n3. ERROR in X.java (at line 6)\n\tObject foo() {\n\t       ^^^^^\nThe method X.foo() is overriding a method without making a super invocation\n----------\n4. ERROR in X.java (at line 8)\n\tObject foo() {\n\t^^^^^^\nThe return type is incompatible with Y.foo()\n----------\n5. WARNING in X.java (at line 8)\n\tObject foo() {\n\t       ^^^^^\nThe method foo() of type new Y(){} should be tagged with @Override since it actually overrides a superclass method\n----------\n6. ERROR in X.java (at line 8)\n\tObject foo() {\n\t       ^^^^^\nThe method new Y(){}.foo() is overriding a method without making a super invocation\n----------\n", null, true, options);
    }

    public void test117() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runNegativeTest(true, new String[]{"X.java", "class Y {\n  Object foo() {\n     return null;\n  }\n}\npublic class X extends Y {\n  @Override\n  Object foo() {\n     return new Y() {\n         @Override\n         Object foo() {\n            return null;\n         }\n     };  }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 8)\n\tObject foo() {\n\t       ^^^^^\nThe method X.foo() is overriding a method without making a super invocation\n----------\n2. ERROR in X.java (at line 11)\n\tObject foo() {\n\t       ^^^^^\nThe method new Y(){}.foo() is overriding a method without making a super invocation\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test118() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runNegativeTest(true, new String[]{"X.java", "class Y<E> {\n\t<U extends E> U foo() {\n\t\treturn null;\n\t}\n}\n\npublic class X<T> extends Y<T> {\n\t@Override\n\t<V extends T> V foo() {\n\t\treturn null;\n\t}\n}"}, null, options, "----------\n1. ERROR in X.java (at line 9)\n\t<V extends T> V foo() {\n\t                ^^^^^\nThe method X<T>.foo() is overriding a method without making a super invocation\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test119() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "error");
        this.runNegativeTest(true, new String[]{"X.java", "class Y<E> {\n\tE foo() {\n\t\treturn null;\n\t}\n}\n\npublic class X<T> extends Y<T> {\n\t@Override\n\tT foo() {\n\t\treturn null;\n\t}\n}"}, null, options, "----------\n1. ERROR in X.java (at line 9)\n\tT foo() {\n\t  ^^^^^\nThe method X<T>.foo() is overriding a method without making a super invocation\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test120() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tabstract class M<T extends CharSequence, S> {\n\t\tvoid e(T t) {}\n\t\tvoid e(S s) {}\n\t}\n\tclass N extends M<String, String> {}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tclass N extends M<String, String> {}\n\t      ^\nDuplicate methods named e with the parameters (S) and (T) are defined by the type X.M<String,String>\n----------\n");
    }

    public void test120a() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in Bar.java (at line 2)\n\tint getThing(V v) { return 1; }\n\t    ^^^^^^^^^^^^^\nErasure of method getThing(V) is the same as another method in type Foo<V,E>\n----------\n2. WARNING in Bar.java (at line 3)\n\tboolean getThing(E e) { return true; }\n\t        ^^^^^^^^^^^^^\nErasure of method getThing(E) is the same as another method in type Foo<V,E>\n----------\n" : "----------\n1. ERROR in Bar.java (at line 2)\n\tint getThing(V v) { return 1; }\n\t    ^^^^^^^^^^^^^\nErasure of method getThing(V) is the same as another method in type Foo<V,E>\n----------\n2. ERROR in Bar.java (at line 3)\n\tboolean getThing(E e) { return true; }\n\t        ^^^^^^^^^^^^^\nErasure of method getThing(E) is the same as another method in type Foo<V,E>\n----------\n";
        this.runNegativeTest(new String[]{"Bar.java", "class Foo<V, E> {\n\tint getThing(V v) { return 1; }\n\tboolean getThing(E e) { return true; }\n}\npublic class Bar<V,E> extends Foo<V,E> {}"}, expectedCompilerLog);
    }

    public void test121() {
        this.runConformTest(new String[]{"X.java", "interface Root {\n\tpublic Root someMethod();\n}\n\ninterface Intermediary extends Root {\n\tpublic Leaf someMethod();\n}\n\nclass Leaf implements Intermediary {\n\tpublic Leaf someMethod() {\n\t\tSystem.out.print(\"SUCCESS\");\n\t\treturn null;\n\t}\n}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tLeaf leafReference = new Leaf();\n\t\tleafReference.someMethod();\n\t\tRoot rootReference = leafReference;\n\t\trootReference.someMethod(); /* throws error */\n\t}\n}"}, "SUCCESSSUCCESS");
    }

    public void test122() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  public void foo(Integer i, Y<String> l1, Y<String> l2);\n}\npublic class X implements I {\n  public void foo(Integer i, Y<String> l1, Y l2) {\n  }\n}\nclass Y<T> {\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic class X implements I {\n\t             ^\nThe type X must implement the inherited abstract method I.foo(Integer, Y<String>, Y<String>)\n----------\n2. ERROR in X.java (at line 5)\n\tpublic void foo(Integer i, Y<String> l1, Y l2) {\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method foo(Integer, Y<String>, Y) of type X has the same erasure as foo(Integer, Y<String>, Y<String>) of type I but does not override it\n----------\n3. WARNING in X.java (at line 5)\n\tpublic void foo(Integer i, Y<String> l1, Y l2) {\n\t                                         ^\nY is a raw type. References to generic type Y<T> should be parameterized\n----------\n");
    }

    public void test123() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  public void foo(Integer i, Y<String> l1, Y<String> l2);\n}\npublic class X implements I {\n  public void foo(Integer i, Y l1, Y l2) {\n  }\n}\nclass Y<T> {\n}"}, "");
    }

    public void test124() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static String choose(String one, String two) {\n    return one + X.<String>choose(one, two);\n  }\n  public static <T> T choose(T one, T two) {\n    return two;\n  }\n  public static void main(String args[]) {\n    try {\n        System.out.println(choose(\"a\", \"b\"));\n    } catch (StackOverflowError e) {\n        System.out.println(\"Stack Overflow\");\n    }\n  }\n}"}, this.complianceLevel <= 0x320000L ? "ab" : "Stack Overflow");
    }

    public void test124b() {
        this.runConformTest(new String[]{"A.java", "public class A {\n  public Object o = \"\";\n  public static void main(String args[]) {\n    X.main(args);\n  }\n}\n", "X.java", "public class X {\n  public static String choose(String one, String two) {\n    return one + X.<String>choose(one, two);\n  }\n  public static <T> T choose(T one, T two) {\n    return two;\n  }\n  public static void main(String args[]) {\n    try {\n        System.out.println(choose(\"a\", \"b\"));\n    } catch (StackOverflowError e) {\n        System.out.println(\"Stack Overflow\");\n    }\n  }\n}"}, this.complianceLevel <= 0x320000L ? "ab" : "Stack Overflow");
    }

    public void test125() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static <T> String choose(String one, String two) {\n    return one;\n  }\n  public static <T> T choose(T one, T two) {\n    return two;\n  }\n  public static void main(String args[]) {\n    System.out.println(choose(\"a\", \"b\") + X.<String>choose(\"a\", \"b\"));\n  }\n}"}, "aa");
    }

    public void test127() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  enum Enum1 {\n    value;\n  }\n  enum Enum2 {\n    value;\n  }\n  static abstract class A<T> {\n    abstract <U extends T> U foo();\n  }\n  static class B extends A<Enum<?>> {\n    @Override\n    Enum<?> foo() {\n      return Enum1.value;\n    }  \n  }\n  public static void main(String[] args) {\n    A<Enum<?>> a = new B();\n    Enum2 value = a.foo();\n  }\n}"}, "----------\n1. WARNING in X.java (at line 13)\n\tEnum<?> foo() {\n\t^^^^\nType safety: The return type Enum<?> for foo() from the type X.B needs unchecked conversion to conform to U from the type X.A<T>\n----------\n", null, true, null, "java.lang.ClassCastException");
    }

    public void test128() {
        this.runNegativeTest(new String[]{"X.java", "interface I<U, V> {\n  U foo(Object o, V v);\n}\npublic class X<U, V> implements I<U, V> {\n  public Object foo(Object o, Object v) { return null; }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic Object foo(Object o, Object v) { return null; }\n\t       ^^^^^^\nType safety: The return type Object for foo(Object, Object) from the type X<U,V> needs unchecked conversion to conform to U from the type I<U,V>\n----------\n");
    }

    public void test129() {
        this.runNegativeTest(new String[]{"X.java", "interface I<U, V> {\n  U foo(Object o, V v);\n}\npublic class X<U extends Z, V> implements I<U, V> {\n  public Object foo(Object o, Object v) { return null; }\n}\nclass Z {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic Object foo(Object o, Object v) { return null; }\n\t       ^^^^^^\nThe return type is incompatible with I<U,V>.foo(Object, V)\n----------\n");
    }

    public void test130() {
        this.runNegativeTest(new String[]{"X.java", "interface I<U, V> {\n  Z<U> foo(Object o, V v);\n}\npublic class X<U, V> implements I<U, V> {\n  public Z<Object> foo(Object o, Object v) { return null; }\n}\nclass Z<T> {}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic Z<Object> foo(Object o, Object v) { return null; }\n\t       ^^^^^^^^^\nThe return type is incompatible with I<U,V>.foo(Object, V)\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug180789);
    }

    public void test131() {
        this.runNegativeTest(new String[]{"X.java", "interface I<U, V> {\n  U foo();\n  U foo(Object o, V v);\n}\ninterface X<U, V> extends I<U, V> {\n  Object foo();\n  Object foo(Object o, Object v);\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tObject foo();\n\t^^^^^^\nThe return type is incompatible with I<U,V>.foo()\n----------\n2. WARNING in X.java (at line 7)\n\tObject foo(Object o, Object v);\n\t^^^^^^\nType safety: The return type Object for foo(Object, Object) from the type X<U,V> needs unchecked conversion to conform to U from the type I<U,V>\n----------\n");
    }

    public void test132() {
        this.runNegativeTest(new String[]{"X.java", "interface I<U> {\n  U foo(I<?> p);\n  U foo2(I<? extends Object> p);\n}\npublic class X<U> implements I<U> {\n  public Object foo(I<? extends Object> p) { return null; }\n  public Object foo2(I<?> p) { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic Object foo(I<? extends Object> p) { return null; }\n\t       ^^^^^^\nThe return type is incompatible with I<U>.foo(I<?>)\n----------\n2. ERROR in X.java (at line 7)\n\tpublic Object foo2(I<?> p) { return null; }\n\t       ^^^^^^\nThe return type is incompatible with I<U>.foo2(I<? extends Object>)\n----------\n");
    }

    public void test133() {
        this.runNegativeTest(new String[]{"A.java", "class A<U> {\n  U foo() { return null; }\n  U foo(U one) { return null; }\n  U foo(U one, U two) { return null; }\n}\nclass B<U> extends A<U> {\n  @Override // does not override error\n  Object foo() { return null; } // cannot override foo(), incompatible return type error\n  @Override // does not override error\n  Object foo(Object one) { return null; } // unchecked conversion warning\n  @Override // does not override error\n  Object foo(Object one, U two) { return null; }\n}\nclass C<U> extends A<U> {\n  @Override // does not override error\n  Object foo(U one) { return null; } // cannot override foo(U), incompatible return type error\n  @Override // does not override error\n  Object foo(U one, U two) { return null; } // cannot override foo(U), incompatible return type error\n}"}, "----------\n1. ERROR in A.java (at line 8)\n\tObject foo() { return null; } // cannot override foo(), incompatible return type error\n\t^^^^^^\nThe return type is incompatible with A<U>.foo()\n----------\n2. WARNING in A.java (at line 10)\n\tObject foo(Object one) { return null; } // unchecked conversion warning\n\t^^^^^^\nType safety: The return type Object for foo(Object) from the type B<U> needs unchecked conversion to conform to U from the type A<U>\n----------\n3. ERROR in A.java (at line 12)\n\tObject foo(Object one, U two) { return null; }\n\t       ^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method foo(Object, U) of type B<U> has the same erasure as foo(U, U) of type A<U> but does not override it\n----------\n4. ERROR in A.java (at line 12)\n\tObject foo(Object one, U two) { return null; }\n\t       ^^^^^^^^^^^^^^^^^^^^^^\n" + this.mustOverrideMessage("foo(Object, U)", "B<U>") + "----------\n" + "5. ERROR in A.java (at line 16)\n" + "\tObject foo(U one) { return null; } // cannot override foo(U), incompatible return type error\n" + "\t^^^^^^\n" + "The return type is incompatible with A<U>.foo(U)\n" + "----------\n" + "6. ERROR in A.java (at line 18)\n" + "\tObject foo(U one, U two) { return null; } // cannot override foo(U), incompatible return type error\n" + "\t^^^^^^\n" + "The return type is incompatible with A<U>.foo(U, U)\n" + "----------\n");
    }

    public void test134() {
        this.runNegativeTest(new String[]{"A.java", "interface I {\n  <T extends Exception & Cloneable> T foo(Number n);\n}\ninterface J extends I {\n  A foo(Number n);\n}\nabstract class A extends Exception implements Cloneable {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. WARNING in A.java (at line 5)\n\tA foo(Number n);\n\t^\nType safety: The return type A for foo(Number) from the type J needs unchecked conversion to conform to T from the type I\n----------\n");
    }

    public void test135() {
        this.runNegativeTest(new String[]{"X.java", "abstract class X implements J {}\nclass X2 implements J {\n  public A foo(Number n) { return null; }\n}\nabstract class Y extends X {}\ninterface I {\n  <T extends Exception & Cloneable> T foo(Number n);\n}\ninterface J extends I {\n  A foo(Number n);\n}\nabstract class A extends Exception implements Cloneable {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic A foo(Number n) { return null; }\n\t       ^\nType safety: The return type A for foo(Number) from the type X2 needs unchecked conversion to conform to T from the type I\n----------\n2. WARNING in X.java (at line 10)\n\tA foo(Number n);\n\t^\nType safety: The return type A for foo(Number) from the type J needs unchecked conversion to conform to T from the type I\n----------\n");
    }

    public void test136() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X extends E {}\nclass X2 extends E {\n  @Override public A foo(Number n) { return null; }\n}\nabstract class Y extends X {}\nabstract class D {\n  abstract <T extends Exception & Cloneable> T foo(Number n);\n}\nabstract class E extends D {\n  @Override abstract A foo(Number n);\n}\nabstract class A extends Exception implements Cloneable {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. WARNING in X.java (at line 10)\n\t@Override abstract A foo(Number n);\n\t                   ^\nType safety: The return type A for foo(Number) from the type E needs unchecked conversion to conform to T from the type D\n----------\n");
    }

    public void test137() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X implements J {}\ninterface I {\n  <T extends Y<T> & Cloneable> T foo(Number n);\n}\ninterface J extends I {\n  XX foo(Number n);\n}\nclass Z { }\nclass Y <U> extends Z { }\nabstract class XX extends Y<XX> implements Cloneable {}"}, "----------\n1. WARNING in X.java (at line 6)\n\tXX foo(Number n);\n\t^^\nType safety: The return type XX for foo(Number) from the type J needs unchecked conversion to conform to T from the type I\n----------\n");
    }

    public void test138() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X implements J {}\ninterface I {\n  <T extends Exception & Cloneable> A<T> foo(Number n);\n}\ninterface J extends I {\n  A<XX> foo(Number n);\n}\nclass A<T> { }abstract class XX extends Exception implements Cloneable {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. WARNING in X.java (at line 6)\n\tA<XX> foo(Number n);\n\t^\nType safety: The return type A<XX> for foo(Number) from the type J needs unchecked conversion to conform to A<Exception&Cloneable> from the type I\n----------\n");
    }

    public void test139() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X implements J {\n  void foo() {}\n  public XX foo(Number n) { return null; }\n}\ninterface I {\n  <T extends Exception & Cloneable> T foo(Number n);\n}\ninterface J extends I {\n  XX foo(Number n);\n}\nabstract class XX extends Exception implements Cloneable {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic XX foo(Number n) { return null; }\n\t       ^^\nType safety: The return type XX for foo(Number) from the type X needs unchecked conversion to conform to T from the type I\n----------\n2. WARNING in X.java (at line 9)\n\tXX foo(Number n);\n\t^^\nType safety: The return type XX for foo(Number) from the type J needs unchecked conversion to conform to T from the type I\n----------\n");
    }

    public void test140() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X implements J, K {}\ninterface I {\n  <T extends Exception & Cloneable> T foo(Number n);\n}\ninterface J extends I {\n  XX foo(Number n);\n}\ninterface K {\n  NullPointerException foo(Number n);\n}\nabstract class XX extends Exception implements Cloneable {\n\tprivate static final long serialVersionUID = 1L;\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic abstract class X implements J, K {}\n\t                      ^\nThe return types are incompatible for the inherited methods J.foo(Number), K.foo(Number)\n----------\n2. WARNING in X.java (at line 6)\n\tXX foo(Number n);\n\t^^\nType safety: The return type XX for foo(Number) from the type J needs unchecked conversion to conform to T from the type I\n----------\n");
    }

    public void test141() {
        this.runNegativeTest(new String[]{"X.java", "import java.nio.charset.Charset;\nimport java.nio.charset.CharsetDecoder;\nimport java.nio.charset.CharsetEncoder;\npublic class X extends Charset {\n  public X(String name, String[] aliases) { super(name, aliases); }\n  @Override public CharsetEncoder newEncoder() { return null;  }\n  @Override public CharsetDecoder newDecoder() { return null;  }\n  @Override public boolean contains(Charset x) { return false; }\n  public int compareTo(Object obj) {\n    return compareTo((Charset) obj);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tpublic int compareTo(Object obj) {\n\t           ^^^^^^^^^^^^^^^^^^^^^\nName clash: The method compareTo(Object) of type X has the same erasure as compareTo(T) of type Comparable<T> but does not override it\n----------\n");
    }

    public void test142() {
        this.runConformTest(new String[]{"X.java", "import java.nio.charset.Charset;\nimport java.nio.charset.CharsetDecoder;\nimport java.nio.charset.CharsetEncoder;\npublic class X extends Charset {\n  public X(String name, String[] aliases) { super(name, aliases); }\n  public CharsetEncoder newEncoder() { return null;  }\n  public CharsetDecoder newDecoder() { return null;  }\n  public boolean contains(Charset x) { return false; }\n}"}, "");
    }

    public void test143() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] s) { ((IBase) new Impl()).get(); }\n}\nclass Impl extends AImpl implements IBase, IEnhanced {}\ninterface IBase {\n\tIBaseReturn get();\n}\ninterface IEnhanced extends IBase {\n\tIEnhancedReturn get();\n}\nabstract class AImpl {\n\tpublic IEnhancedReturn get() { return null; }\n}\ninterface IBaseReturn {}\ninterface IEnhancedReturn extends IBaseReturn {}"}, "");
    }

    public void test144() {
        this.runNegativeTest(new String[]{"PurebredCatShopImpl.java", "import java.util.List;\ninterface Pet {}\ninterface Cat extends Pet {}\ninterface PetShop { List<Pet> getPets(); }\ninterface CatShop extends PetShop {\n\t<V extends Pet> List<? extends Cat> getPets();\n}\ninterface PurebredCatShop extends CatShop {}\nclass CatShopImpl implements CatShop {\n\tpublic List<Pet> getPets() { return null; }\n}\nclass PurebredCatShopImpl extends CatShopImpl implements PurebredCatShop {}"}, "----------\n1. ERROR in PurebredCatShopImpl.java (at line 6)\n\t<V extends Pet> List<? extends Cat> getPets();\n\t                                    ^^^^^^^^^\nName clash: The method getPets() of type CatShop has the same erasure as getPets() of type PetShop but does not override it\n----------\n2. WARNING in PurebredCatShopImpl.java (at line 10)\n\tpublic List<Pet> getPets() { return null; }\n\t       ^^^^\nType safety: The return type List<Pet> for getPets() from the type CatShopImpl needs unchecked conversion to conform to List<? extends Cat> from the type CatShop\n----------\n");
    }

    public void test145() {
        this.runConformTest(new String[]{"BaseImpl.java", "abstract class Base<Tvalue> implements BaseInterface<Tvalue>{ public void setValue(Object object) {} }\ninterface BaseInterface<Tvalue> { void setValue(Tvalue object); }\nclass BaseImpl extends Base<String> { public void setValue(String object) {} }"}, "");
    }

    public void test146() {
        this.runConformTest(new String[]{"BugB.java", "abstract class A<K> { void get(K key) {} }\nabstract class B extends A<C> { <S> void get(C<S> type) {} }\nclass B2 extends A<C> { <S> void get(C<S> type) {} }\nclass BugB extends B {}\nclass NonBugB extends B2 {}\nclass C<T> {}"}, "");
    }

    public void test147() {
        this.runNegativeTest(new String[]{"X.java", "interface J<T> { <U1, U2> void foo(T t); }\nclass Y<T> { public <U3> void foo(T t) {} }\nabstract class X<T> extends Y<T> implements J<T> {\n\t@Override public void foo(Object o) {}\n}\nabstract class X1<T> extends Y<T> implements J<T> {\n\tpublic <Ignored> void foo(Object o) {}\n}\nabstract class X2<T> extends Y<T> implements J<T> {}\nabstract class X3 extends Y<Number> implements J<String> {}\nabstract class X4 extends Y<Number> implements J<String> {\n\t@Override public void foo(Number o) {}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tabstract class X1<T> extends Y<T> implements J<T> {\n\t               ^^\nName clash: The method foo(T) of type Y<T> has the same erasure as foo(T) of type J<T> but does not override it\n----------\n2. ERROR in X.java (at line 7)\n\tpublic <Ignored> void foo(Object o) {}\n\t                      ^^^^^^^^^^^^^\nName clash: The method foo(Object) of type X1<T> has the same erasure as foo(T) of type Y<T> but does not override it\n----------\n3. ERROR in X.java (at line 7)\n\tpublic <Ignored> void foo(Object o) {}\n\t                      ^^^^^^^^^^^^^\nName clash: The method foo(Object) of type X1<T> has the same erasure as foo(T) of type J<T> but does not override it\n----------\n4. ERROR in X.java (at line 9)\n\tabstract class X2<T> extends Y<T> implements J<T> {}\n\t               ^^\nName clash: The method foo(T) of type Y<T> has the same erasure as foo(T) of type J<T> but does not override it\n----------\n5. ERROR in X.java (at line 10)\n\tabstract class X3 extends Y<Number> implements J<String> {}\n\t               ^^\nName clash: The method foo(T) of type Y<T> has the same erasure as foo(T) of type J<T> but does not override it\n----------\n6. ERROR in X.java (at line 11)\n\tabstract class X4 extends Y<Number> implements J<String> {\n\t               ^^\nName clash: The method foo(T) of type Y<T> has the same erasure as foo(T) of type J<T> but does not override it\n----------\n");
    }

    public void test148() {
        this.runNegativeTest(new String[]{"Y.java", "abstract class X { abstract <T extends Object> T go(A<T> a); }\nclass Y extends X {\n\t@Override <T extends Object> T go(A a) { return null; }\n}\nclass A<T> {}"}, "----------\n1. ERROR in Y.java (at line 2)\n\tclass Y extends X {\n\t      ^\nThe type Y must implement the inherited abstract method X.go(A<T>)\n----------\n2. ERROR in Y.java (at line 3)\n\t@Override <T extends Object> T go(A a) { return null; }\n\t                               ^^^^^^^\nName clash: The method go(A) of type Y has the same erasure as go(A<T>) of type X but does not override it\n----------\n3. ERROR in Y.java (at line 3)\n\t@Override <T extends Object> T go(A a) { return null; }\n\t                               ^^^^^^^\n" + this.mustOverrideMessage("go(A)", "Y") + "----------\n" + "4. WARNING in Y.java (at line 3)\n" + "\t@Override <T extends Object> T go(A a) { return null; }\n" + "\t                                  ^\n" + "A is a raw type. References to generic type A<T> should be parameterized\n" + "----------\n");
    }

    public void test149() {
        this.runNegativeTest(new String[]{"A.java", "class A {\n\tvoid a(X x) {}\n\tvoid b(Y<Integer> y) {}\n\tstatic void c(X x) {}\n\tstatic void d(Y<Integer> y) {}\n}\n", "B.java", "class B extends A {\n\tstatic void a(X x) {}\n\tstatic void b(Y<String> y) {}\n\tstatic void c(X x) {}\n\tstatic void d(Y<String> y) {}\n}\n", "B2.java", "class B2 extends A {\n\tstatic void b(Y<Integer> y) {}\n\tstatic void d(Y<Integer> y) {}\n}\n", "C.java", "class C extends A {\n\t@Override void a(X x) {}\n\tvoid b(Y<String> y) {}\n\tvoid c(X x) {}\n\tvoid d(Y<String> y) {}\n}\n", "C2.java", "class C2 extends A {\n\t@Override void b(Y<Integer> y) {}\n\tvoid d(Y<Integer> y) {}\n}\nclass X {}\nclass Y<T> {}"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in B.java (at line 2)\n\tstatic void a(X x) {}\n\t            ^^^^^^\nThis static method cannot hide the instance method from A\n----------\n----------\n1. ERROR in B2.java (at line 2)\n\tstatic void b(Y<Integer> y) {}\n\t            ^^^^^^^^^^^^^^^\nThis static method cannot hide the instance method from A\n----------\n----------\n1. ERROR in C.java (at line 3)\n\tvoid b(Y<String> y) {}\n\t     ^^^^^^^^^^^^^^\nName clash: The method b(Y<String>) of type C has the same erasure as b(Y<Integer>) of type A but does not override it\n----------\n2. ERROR in C.java (at line 4)\n\tvoid c(X x) {}\n\t     ^^^^^^\nThis instance method cannot override the static method from A\n----------\n----------\n1. ERROR in C2.java (at line 3)\n\tvoid d(Y<Integer> y) {}\n\t     ^^^^^^^^^^^^^^^\nThis instance method cannot override the static method from A\n----------\n" : "----------\n1. ERROR in B.java (at line 2)\n\tstatic void a(X x) {}\n\t            ^^^^^^\nThis static method cannot hide the instance method from A\n----------\n2. ERROR in B.java (at line 3)\n\tstatic void b(Y<String> y) {}\n\t            ^^^^^^^^^^^^^^\nName clash: The method b(Y<String>) of type B has the same erasure as b(Y<Integer>) of type A but does not hide it\n----------\n3. ERROR in B.java (at line 5)\n\tstatic void d(Y<String> y) {}\n\t            ^^^^^^^^^^^^^^\nName clash: The method d(Y<String>) of type B has the same erasure as d(Y<Integer>) of type A but does not hide it\n----------\n----------\n1. ERROR in B2.java (at line 2)\n\tstatic void b(Y<Integer> y) {}\n\t            ^^^^^^^^^^^^^^^\nThis static method cannot hide the instance method from A\n----------\n----------\n1. ERROR in C.java (at line 3)\n\tvoid b(Y<String> y) {}\n\t     ^^^^^^^^^^^^^^\nName clash: The method b(Y<String>) of type C has the same erasure as b(Y<Integer>) of type A but does not override it\n----------\n2. ERROR in C.java (at line 4)\n\tvoid c(X x) {}\n\t     ^^^^^^\nThis instance method cannot override the static method from A\n----------\n3. ERROR in C.java (at line 5)\n\tvoid d(Y<String> y) {}\n\t     ^^^^^^^^^^^^^^\nName clash: The method d(Y<String>) of type C has the same erasure as d(Y<Integer>) of type A but does not hide it\n----------\n----------\n1. ERROR in C2.java (at line 3)\n\tvoid d(Y<Integer> y) {}\n\t     ^^^^^^^^^^^^^^^\nThis instance method cannot override the static method from A\n----------\n");
    }

    public void test150() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t// DOESN'T Compile\n\tpublic MyT<Void> method3(D1<String> harg, D1<String> oarg, D1<java.util.Date> date){\n\t\treturn null;\n\t}\n\t// Doesn't compile\n\tpublic MyT<Void> method3(D1<String> harg, D1<String> oarg, D1<String> date){\n\t\treturn null;\n\t}\n\t// Using vararg trick compiles ok use vararg to differentiate method signature\n\tpublic MyT<Void> method3(D1<String> harg, D1<String> oarg, D1<java.util.Date> date, D1 ... notUsed){\n\t\treturn null;\n\t}\n\t// Using vararg trick compiles ok use vararg to differentiate method signature\n\tpublic MyT<Void> method3(D1<String> harg, D1<String> oarg, D1<String> date, D2 ... notUsed){\n\t\treturn null;\n\t}\n\tclass MyT<T>{}\n\tclass D1<T>{}\n\tclass D2<T>{}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic MyT<Void> method3(D1<String> harg, D1<String> oarg, D1<java.util.Date> date){\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method method3(X.D1<String>, X.D1<String>, X.D1<Date>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 7)\n\tpublic MyT<Void> method3(D1<String> harg, D1<String> oarg, D1<String> date){\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method method3(X.D1<String>, X.D1<String>, X.D1<String>) is the same as another method in type X\n----------\n3. WARNING in X.java (at line 11)\n\tpublic MyT<Void> method3(D1<String> harg, D1<String> oarg, D1<java.util.Date> date, D1 ... notUsed){\n\t                                                                                    ^^\nX.D1 is a raw type. References to generic type X.D1<T> should be parameterized\n----------\n4. WARNING in X.java (at line 15)\n\tpublic MyT<Void> method3(D1<String> harg, D1<String> oarg, D1<String> date, D2 ... notUsed){\n\t                                                                            ^^\nX.D2 is a raw type. References to generic type X.D2<T> should be parameterized\n----------\n");
    }

    public void test151() {
        this.runConformTest(new String[]{"X.java", "import java.util.Date;\n\npublic class X {\n\t// Using vararg trick compiles ok use vararg to differentiate method signature\n\tpublic static MyT<Void> method3(D1<String> harg, D1<String> oarg, D1<java.util.Date> date, D1... notUsed) {\n\t\tSystem.out.print(\"#method3(D1<String>, D1<String>, D1<java.util.Date>, D1[])\");\n\t\treturn null;\n\t}\n\n\t// Using vararg trick compiles ok use vararg to differentiate method signature\n\tpublic static MyT<Void> method3(D1<String> harg, D1<String> oarg, D1<String> date, D2... notUsed) {\n\t\tSystem.out.print(\"#method3(D1<String>, D1<String>, D1<java.util.Date>, D2[])\");\n\t\treturn null;\n\t}\n\n\t/**\n\t * this java main demonstrates that compiler can differentiate between to\n\t * the 2 different methods.\n\t * @param args\n\t */\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tD1<String> dString = x.new D1<String>();\n\t\tD1<Date> dDate = x.new D1<Date>();\n\t\t// calling first defined method\n\t\tX.method3(dString, dString, dDate);\n\t\t// calling second defined method\n\t\tX.method3(dString, dString, dString);\n\t\t// / will write out\n\t\t// method3 called with this signature: D1<String> harg, D1<String> oarg,\n\t\t// D1<java.util.Date> date\n\t\t// method3 called with this signature: D1<String> harg, D1<String> oarg,\n\t\t// D1<String> date\n\t}\n\tclass MyT<T> {}\n\tpublic class D1<T> {}\n\tpublic class D2<T> {}\n}\n"}, "#method3(D1<String>, D1<String>, D1<java.util.Date>, D1[])#method3(D1<String>, D1<String>, D1<java.util.Date>, D2[])");
    }

    public void test152() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic <T> void feedFoosValueIntoFoo(Foo<T> foo) {\n\t\tfoo.doSomething(foo.getValue());\n\t}\n\tstatic void testTypedString() {\n\t\tConcreteFoo foo = new ConcreteFoo();\n\t\tfoo.doSomething(foo.getValue());\n\t}\n\tstatic void testGenericString() {\n\t\tfeedFoosValueIntoFoo(new ConcreteFoo());\n\t}\n\tpublic static void main(String[] args) {\n\t\ttestTypedString();\n\t\ttestGenericString();\n\t\tSystem.out.print(1);\n\t}\n}\ninterface Foo<T> {\n\tT getValue();\n\tvoid doSomething(T o);\n}\nabstract class AbstractFoo<T> implements Foo<T> {\n\tpublic void doSomething(String o) {}\n}\nclass ConcreteFoo extends AbstractFoo<String> {\n\tpublic String getValue() { return null; }\n}"}, "1");
    }

    public void test153() {
        this.runConformTest(new String[]{"test/impl/SubOneImpl.java", "package test.impl;\nimport test.intf.SubTwo;\npublic abstract class SubOneImpl extends SuperTypeExtendImpl implements test.intf.SubOne\n{\n    public SubOneImpl plus(test.intf.SubOne attribute)\n    {\n        throw new RuntimeException(\"foo\");\n    }\n    public SubTwoImpl plus(SubTwo attribute)\n    {\n        throw new RuntimeException(\"foo\");\n    }\n}\n", "test/impl/SubSubOneImpl.java", "package test.impl;\npublic abstract class SubSubOneImpl extends SubOneImpl\n{\n}\n", "test/impl/SubTwoImpl.java", "package test.impl;\nimport test.intf.SubOne;\npublic abstract class SubTwoImpl extends SuperTypeExtendImpl implements\ntest.intf.SubTwo\n{\n    public SubTwoImpl plus(SubOne attribute)\n    {\n        throw new RuntimeException(\"foo\");\n    }\n    public SubTwoImpl plus(test.intf.SubTwo attribute)\n    {\n        throw new RuntimeException(\"foo\");\n    }\n}\n", "test/impl/SuperTypeExtend.java", "package test.impl;\nimport test.intf.SubOne;\nimport test.intf.SubTwo;\npublic interface SuperTypeExtend extends test.intf.SuperType\n{\n    public SuperTypeExtend plus(SubOne addend);\n    public SuperTypeExtend plus(SubTwo addend);\n}\n", "test/impl/SuperTypeExtendImpl.java", "package test.impl;\npublic abstract class SuperTypeExtendImpl implements SuperTypeExtend\n{\n}\n", "test/intf/SubOne.java", "package test.intf;\npublic interface SubOne<Owner> extends SuperType<Owner>\n{\n    public SubOne<Owner> plus(SubOne addend);\n    public SubTwo<Owner> plus(SubTwo addend);\n}\n", "test/intf/SubTwo.java", "package test.intf;\npublic interface SubTwo<Owner> extends SuperType<Owner>\n{\n    public SubTwo<Owner> plus(SubOne addend);\n    public SubTwo<Owner> plus(SubTwo addend);\n}\n", "test/intf/SuperType.java", "package test.intf;\npublic interface SuperType<Owner>\n{\n    public SuperType<Owner> plus(SubOne addend);\n    public SuperType<Owner> plus(SubTwo addend);\n}\n"}, "");
    }

    public void test154() {
        this.runConformTest(new String[]{"test/impl/SubOneImpl.java", "package test.impl;\npublic abstract class SubOneImpl extends SuperTypeExtendImpl implements test.impl.SubOne {\n\tpublic SubOneImpl plus(test.impl.SubOne attribute) {\n\t\tthrow new RuntimeException(\"foo\");\n\t}\n\tpublic SubTwoImpl plus(SubTwo attribute) {\n\t\tthrow new RuntimeException(\"foo\");\n\t}\n}\n\nabstract class SubSubOneImpl extends SubOneImpl {\n}\n\nabstract class SubTwoImpl extends SuperTypeExtendImpl implements test.impl.SubTwo {\n\tpublic SubTwoImpl plus(SubOne attribute) {\n\t\tthrow new RuntimeException(\"foo\");\n\t}\n\tpublic SubTwoImpl plus(test.impl.SubTwo attribute) {\n\t\tthrow new RuntimeException(\"foo\");\n\t}\n}\n\ninterface SuperTypeExtend extends test.impl.SuperType {\n\tpublic SuperTypeExtend plus(SubOne addend);\n\tpublic SuperTypeExtend plus(SubTwo addend);\n}\n\nabstract class SuperTypeExtendImpl implements SuperTypeExtend {\n}\n\ninterface SubOne<Owner> extends SuperType<Owner> {\n\tpublic SubOne<Owner> plus(SubOne addend);\n\tpublic SubTwo<Owner> plus(SubTwo addend);\n}\n\ninterface SubTwo<Owner> extends SuperType<Owner> {\n\tpublic SubTwo<Owner> plus(SubOne addend);\n\tpublic SubTwo<Owner> plus(SubTwo addend);\n}\n\ninterface SuperType<Owner> {\n\tpublic SuperType<Owner> plus(SubOne addend);\n\tpublic SuperType<Owner> plus(SubTwo addend);\n}\n"}, "");
    }

    public void test155() {
        this.runNegativeTest(new String[]{"X.java", "class A {}\nclass B {}\ninterface I {\n\tA foo();\n}\ninterface J {\n\tB foo();\n}\npublic abstract class X implements I, J {\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tpublic abstract class X implements I, J {\n\t                      ^\nThe return types are incompatible for the inherited methods I.foo(), J.foo()\n----------\n");
    }

    public void test156() {
        this.runNegativeTest(new String[]{"X.java", "class Common {}\nclass A extends Common {}\nclass B extends Common {}\ninterface I {\n\tA foo();\n}\ninterface J {\n\tB foo();\n}\npublic abstract class X implements I, J {\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tpublic abstract class X implements I, J {\n\t                      ^\nThe return types are incompatible for the inherited methods I.foo(), J.foo()\n----------\n");
    }

    public void test157() {
        this.runNegativeTest(new String[]{"X.java", "interface A {\n\tA foo();\n}\ninterface B {\n\tB foo();\n}\ninterface C extends A, B {}\n\nclass Root {\n\tpublic C foo() { return null; }\n}\npublic abstract class X extends Root implements A, B {\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tinterface C extends A, B {}\n\t          ^\nThe return types are incompatible for the inherited methods A.foo(), B.foo()\n----------\n");
    }

    public void test158() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\n\ninterface AFoo { \n\tSerializable foo();\n\tSerializable bar();\n}\ninterface BFoo { \n\tCloneable foo(); \n\tCloneable bar(); \n}\n\ninterface C extends Serializable, Cloneable {}\n\nclass Root {\n\tpublic C foo() { return null; }\n}\npublic abstract class X extends Root implements AFoo, BFoo {\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tpublic abstract class X extends Root implements AFoo, BFoo {\n\t                      ^\nThe return types are incompatible for the inherited methods AFoo.bar(), BFoo.bar()\n----------\n");
    }

    public void test159() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\n\ninterface AFoo { \n\tSerializable foo();\n\tSerializable bar();\n}\ninterface BFoo { \n\tCloneable foo(); \n\tCloneable bar(); \n}\ninterface C extends Serializable, Cloneable {}\nclass Root {\n\tpublic C foo() { return null; }\n}\npublic abstract class X extends Root implements AFoo, BFoo {}\nabstract class Y extends X {}\nclass Z extends X {}"}, "----------\n1. ERROR in X.java (at line 15)\n\tpublic abstract class X extends Root implements AFoo, BFoo {}\n\t                      ^\nThe return types are incompatible for the inherited methods AFoo.bar(), BFoo.bar()\n----------\n2. ERROR in X.java (at line 16)\n\tabstract class Y extends X {}\n\t               ^\nThe return types are incompatible for the inherited methods AFoo.bar(), BFoo.bar()\n----------\n3. ERROR in X.java (at line 17)\n\tclass Z extends X {}\n\t      ^\nThe type Z must implement the inherited abstract method BFoo.bar()\n----------\n");
    }

    public void test160() {
        this.runConformTest(new String[]{"bar/X.java", "package bar;public class X {\n\tstatic void foo() {}\n}", "foo/Y.java", "package foo;public class Y extends bar.X {\n\tstatic void foo() {}\n}"}, "");
    }

    public void test161() {
        this.runConformTest(new String[]{"Concrete.java", "abstract class SuperAbstract<Owner, Type> {\n\tabstract Object foo(Type other);\n}\nabstract class HalfGenericSuper<Owner> extends SuperAbstract<Owner, String> {\n\t@Override abstract Object foo(String other);\n}\nabstract class AbstractImpl<Owner> extends HalfGenericSuper<Owner> {\n\t@Override Object foo(String other) { return null; }\n}\nclass Concrete extends AbstractImpl{}"}, "");
    }

    public void test162() {
        this.runConformTest(new String[]{"Concrete.java", "abstract class SuperAbstract<Owner, Type> {\n\tabstract Object foo(Type other);\n}\nclass HalfGenericSuper<Owner> extends SuperAbstract<Owner, String> {\n\t@Override Object foo(String other) { return null; }\n}\nabstract class AbstractImpl<Owner> extends HalfGenericSuper<Owner> {}\nclass HalfConcrete extends HalfGenericSuper {}\nclass Concrete extends AbstractImpl{}"}, "");
    }

    public void test163() {
        this.runNegativeTest(new String[]{"Concrete.java", "abstract class SuperAbstract<Owner, Type> {\n\tabstract Type foo(Type other);\n}\nclass HalfGenericSuper<Owner> extends SuperAbstract<Owner, String> {\n\t@Override Object foo(String other) { return null; }\n}\nclass Concrete extends HalfGenericSuper{}"}, "----------\n1. ERROR in Concrete.java (at line 5)\n\t@Override Object foo(String other) { return null; }\n\t          ^^^^^^\nThe return type is incompatible with SuperAbstract<Owner,String>.foo(String)\n----------\n2. WARNING in Concrete.java (at line 7)\n\tclass Concrete extends HalfGenericSuper{}\n\t                       ^^^^^^^^^^^^^^^^\nHalfGenericSuper is a raw type. References to generic type HalfGenericSuper<Owner> should be parameterized\n----------\n");
    }

    public void test164() {
        this.runNegativeTest(new String[]{"Concrete.java", "interface I<Owner, Type> {\n\tType foo(Type other);\n\tOwner foo2(Type other);\n\tObject foo3(Type other);\n}\nclass HalfGenericSuper {\n\tpublic Object foo(String other) { return null; }\n\tpublic Integer foo2(String other) { return null; }\n\tpublic String foo3(String other) { return null; }\n}\nclass HalfConcrete extends HalfGenericSuper {}\nclass Concrete extends HalfConcrete implements I<Object, String> {}"}, "----------\n1. ERROR in Concrete.java (at line 12)\n\tclass Concrete extends HalfConcrete implements I<Object, String> {}\n\t      ^^^^^^^^\nThe type Concrete must implement the inherited abstract method I<Object,String>.foo(String) to override HalfGenericSuper.foo(String)\n----------\n");
    }

    public void test165() {
        this.runNegativeTest(new String[]{"X.java", "class X { void foo() {} }\nclass Y extends X { @Override int foo() { return 1; } }"}, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends X { @Override int foo() { return 1; } }\n\t                              ^^^\nThe return type is incompatible with X.foo()\n----------\n");
    }

    public void test166() {
        this.runNegativeTest(new String[]{"X.java", "class X extends A implements I<String> {}\ninterface I<T> { void foo(T item); }\nclass A {\n\tpublic void foo(Object item) {}\n\tpublic void foo(String item) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends A implements I<String> {}\n\t      ^\nName clash: The method foo(Object) of type A has the same erasure as foo(T) of type I<T> but does not override it\n----------\n");
    }

    public void test167() {
        this.runConformTest(new String[]{"X.java", "class X implements I<String>, J<String> {\n\tpublic <T3> void foo(T3 t, String s) {}\n}\ninterface I<U1> { <T1> void foo(T1 t, U1 u); }\ninterface J<U2> { <T2> void foo(T2 t, U2 u); }\n"}, "");
    }

    public void test168() {
        this.runNegativeTest(new String[]{"X.java", "class X<T> extends Y {\n\t@Override <V> void foo(M m) { }\n\t@Override <V> M bar() { return null; }\n}\nclass Y<T> {\n\tclass M<V> {}\n\t<V> void foo(M<V> m) {}\n\t<V> M<V> bar() { return null; }\n}"}, "----------\n1. WARNING in X.java (at line 1)\n\tclass X<T> extends Y {\n\t                   ^\nY is a raw type. References to generic type Y<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\t@Override <V> void foo(M m) { }\n\t                   ^^^^^^^^\nName clash: The method foo(Y.M) of type X<T> has the same erasure as foo(Y.M) of type Y but does not override it\n----------\n3. ERROR in X.java (at line 2)\n\t@Override <V> void foo(M m) { }\n\t                   ^^^^^^^^\n" + this.mustOverrideMessage("foo(Y.M)", "X<T>") + "----------\n" + "4. WARNING in X.java (at line 2)\n" + "\t@Override <V> void foo(M m) { }\n" + "\t                       ^\n" + "Y.M is a raw type. References to generic type Y<T>.M<V> should be parameterized\n" + "----------\n" + "5. WARNING in X.java (at line 3)\n" + "\t@Override <V> M bar() { return null; }\n" + "\t              ^\n" + "Y.M is a raw type. References to generic type Y<T>.M<V> should be parameterized\n" + "----------\n" + "6. ERROR in X.java (at line 3)\n" + "\t@Override <V> M bar() { return null; }\n" + "\t                ^^^^^\n" + "Name clash: The method bar() of type X<T> has the same erasure as bar() of type Y but does not override it\n" + "----------\n" + "7. ERROR in X.java (at line 3)\n" + "\t@Override <V> M bar() { return null; }\n" + "\t                ^^^^^\n" + this.mustOverrideMessage("bar()", "X<T>") + "----------\n");
    }

    public void test169() {
        this.runNegativeTest(false, new String[]{"X.java", "class X<T> {\n\tinterface I<S> {}\n\tinterface J { A foo(A a, I<String> i); }\n\tstatic class A {}\n\tstatic class B implements J {\n\t\tpublic R foo(A a, I i) { return null; }\n\t}\n}\nclass R<T> extends X.A {}"}, null, null, "----------\n1. WARNING in X.java (at line 6)\n\tpublic R foo(A a, I i) { return null; }\n\t       ^\nR is a raw type. References to generic type R<T> should be parameterized\n----------\n2. WARNING in X.java (at line 6)\n\tpublic R foo(A a, I i) { return null; }\n\t                  ^\nX.I is a raw type. References to generic type X.I<S> should be parameterized\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test169a() {
        this.runNegativeTest(false, new String[]{"X.java", "class X<T> {\n\tabstract class B implements J {\n\t\tpublic R foo(X<String>.B b, I i) { return null; }\n\t}\n}\ninterface I<S> {}\ninterface J { A foo(A a, I<String> i); }\nclass A {}\nclass R<T> extends A {}"}, null, null, "----------\n1. WARNING in X.java (at line 3)\n\tpublic R foo(X<String>.B b, I i) { return null; }\n\t       ^\nR is a raw type. References to generic type R<T> should be parameterized\n----------\n2. WARNING in X.java (at line 3)\n\tpublic R foo(X<String>.B b, I i) { return null; }\n\t                            ^\nI is a raw type. References to generic type I<S> should be parameterized\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test170() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", "error");
        this.runNegativeTest(false, new String[]{"X.java", "class X { synchronized void foo() {} }\nclass Y extends X { @Override void foo() { } }"}, null, options, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends X { @Override void foo() { } }\n\t                                   ^^^^^\nThe method Y.foo() is overriding a synchronized method without being synchronized\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test171() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", "error");
        this.runNegativeTest(false, new String[]{"X.java", "public enum X {\n  FOO { @Override void foo() { super.foo(); } };\n  synchronized void foo() { }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 2)\n\tFOO { @Override void foo() { super.foo(); } };\n\t                     ^^^^^\nThe method new X(){}.foo() is overriding a synchronized method without being synchronized\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test172() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", "error");
        this.runNegativeTest(false, new String[]{"X.java", "public class X {\n  void bar() { new X() { @Override void foo() {} }; }\n  synchronized void foo() { }\n}"}, null, options, "----------\n1. ERROR in X.java (at line 2)\n\tvoid bar() { new X() { @Override void foo() {} }; }\n\t                                      ^^^^^\nThe method new X(){}.foo() is overriding a synchronized method without being synchronized\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test173() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod", "error");
        this.runNegativeTest(false, new String[]{"X.java", "public class X { synchronized void foo() {} }\nclass Y extends X {}\nclass Z extends Y { @Override void foo() {} }\n"}, null, options, "----------\n1. ERROR in X.java (at line 3)\n\tclass Z extends Y { @Override void foo() {} }\n\t                                   ^^^^^\nThe method Z.foo() is overriding a synchronized method without being synchronized\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test174() {
        this.runNegativeTest(new String[]{"X.java", "class X extends Y implements I { }\nabstract class Y { public abstract Object m(); }\nabstract class A implements I, J { }\nabstract class B implements J, I { }\ninterface I { String m(); }\ninterface J { Object m(); }\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tclass X extends Y implements I { }\n\t      ^\nThe type X must implement the inherited abstract method I.m() to override Y.m()\n----------\n");
    }

    public void test175() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod", "warning");
        this.runNegativeTest(false, new String[]{"A.java", "class A {\n\t@Override public boolean equals(Object o) { return true; }\n}"}, null, options, "----------\n1. WARNING in A.java (at line 1)\n\tclass A {\n\t      ^\nThe type A should also implement hashCode() since it overrides Object.equals()\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test176() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod", "warning");
        this.runNegativeTest(new String[]{"A.java", "class A {\n\t@Override public boolean equals(Object o) { return true; }\n\t@Override public int hashCode() { return 1; }\n}\nclass B extends A {\n\t@Override public boolean equals(Object o) { return false; }\n}"}, "", null, false, options);
    }

    public void test177() {
        if (new CompilerOptions((Map)this.getCompilerOptions()).complianceLevel >= 0x320000L) {
            String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 3)\n\tclass A extends LinkedHashMap {\n\t      ^\nThe serializable class A does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 3)\n\tclass A extends LinkedHashMap {\n\t                ^^^^^^^^^^^^^\nLinkedHashMap is a raw type. References to generic type LinkedHashMap<K,V> should be parameterized\n----------\n3. WARNING in X.java (at line 4)\n\tpublic A foo(Collection c) { return this; }\n\t             ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n4. WARNING in X.java (at line 6)\n\tclass X extends A implements I {\n\t      ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n5. WARNING in X.java (at line 7)\n\t@Override public X foo(Collection<?> c) { return this; }\n\t                   ^^^^^^^^^^^^^^^^^^^^\nName clash: The method foo(Collection<?>) of type X has the same erasure as foo(Collection) of type A but does not override it\n----------\n" : "----------\n1. WARNING in X.java (at line 3)\n\tclass A extends LinkedHashMap {\n\t      ^\nThe serializable class A does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 3)\n\tclass A extends LinkedHashMap {\n\t                ^^^^^^^^^^^^^\nLinkedHashMap is a raw type. References to generic type LinkedHashMap<K,V> should be parameterized\n----------\n3. WARNING in X.java (at line 4)\n\tpublic A foo(Collection c) { return this; }\n\t             ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n4. WARNING in X.java (at line 6)\n\tclass X extends A implements I {\n\t      ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n5. ERROR in X.java (at line 7)\n\t@Override public X foo(Collection<?> c) { return this; }\n\t                   ^^^^^^^^^^^^^^^^^^^^\nName clash: The method foo(Collection<?>) of type X has the same erasure as foo(Collection) of type A but does not override it\n----------\n";
            this.runNegativeTest(new String[]{"X.java", "import java.util.*;\ninterface I { I foo(Collection<?> c); }\nclass A extends LinkedHashMap {\n\tpublic A foo(Collection c) { return this; }\n}\nclass X extends A implements I {\n\t@Override public X foo(Collection<?> c) { return this; }\n}"}, expectedCompilerLog);
        } else {
            this.runNegativeTest(new String[]{"X.java", "import java.util.*;\ninterface I { I foo(Collection<?> c); }\nclass A extends LinkedHashMap {\n\tpublic A foo(Collection c) { return this; }\n}\nclass X extends A implements I {\n\t@Override public X foo(Collection<?> c) { return this; }\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tclass A extends LinkedHashMap {\n\t      ^\nThe serializable class A does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 3)\n\tclass A extends LinkedHashMap {\n\t                ^^^^^^^^^^^^^\nLinkedHashMap is a raw type. References to generic type LinkedHashMap<K,V> should be parameterized\n----------\n3. WARNING in X.java (at line 4)\n\tpublic A foo(Collection c) { return this; }\n\t             ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n4. WARNING in X.java (at line 6)\n\tclass X extends A implements I {\n\t      ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n5. ERROR in X.java (at line 7)\n\t@Override public X foo(Collection<?> c) { return this; }\n\t                   ^^^^^^^^^^^^^^^^^^^^\nName clash: The method foo(Collection<?>) of type X has the same erasure as foo(Collection) of type A but does not override it\n----------\n6. ERROR in X.java (at line 7)\n\t@Override public X foo(Collection<?> c) { return this; }\n\t                   ^^^^^^^^^^^^^^^^^^^^\nThe method foo(Collection<?>) of type X must override a superclass method\n----------\n");
        }
    }

    public void test178() {
        this.runConformTest(new String[]{"I.java", "import java.util.*;\ninterface I<E> extends I1<E>, I2<E>, I3<E> {}\ninterface I1<E> { List<E> m(); }\ninterface I2<E> { Queue<E> m(); }\ninterface I3<E> { LinkedList<E> m(); }"}, "");
    }

    public void test179() {
        this.runNegativeTest(new String[]{"X.java", "interface Adaptable {\n\tpublic Object getAdapter(Class clazz);\t\n}\n\npublic class X implements Adaptable {\n\t@Override\n\tpublic Object getAdapter(Class<?> clazz) {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic Object getAdapter(Class clazz);\t\n\t                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tpublic class X implements Adaptable {\n\t             ^\nThe type X must implement the inherited abstract method Adaptable.getAdapter(Class)\n----------\n3. ERROR in X.java (at line 7)\n\tpublic Object getAdapter(Class<?> clazz) {\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method getAdapter(Class<?>) of type X has the same erasure as getAdapter(Class) of type Adaptable but does not override it\n----------\n4. ERROR in X.java (at line 7)\n\tpublic Object getAdapter(Class<?> clazz) {\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^\n" + this.mustOverrideMessage("getAdapter(Class<?>)", "X") + "----------\n");
    }

    public void test180() {
        this.runNegativeTest(new String[]{"X.java", "class S {\n\tString foo() { return null; }\n}\nclass X extends S {\n\tfoo() { return null; }\n\t@Override String foo() { return null; }\n\tNumber foo() { return null; }\n\tvoid test() { foo(); }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tfoo() { return null; }\n\t^^^^^\nReturn type for the method is missing\n----------\n2. ERROR in X.java (at line 5)\n\tfoo() { return null; }\n\t^^^^^\nDuplicate method foo() in type X\n----------\n3. ERROR in X.java (at line 6)\n\t@Override String foo() { return null; }\n\t                 ^^^^^\nDuplicate method foo() in type X\n----------\n4. ERROR in X.java (at line 7)\n\tNumber foo() { return null; }\n\t       ^^^^^\nDuplicate method foo() in type X\n----------\n");
    }

    public void test181() {
        this.runNegativeTest(new String[]{"I.java", "interface I {\n\tString m();\n\tObject n();\n\tString o();\n\tObject p();\n}\nabstract class A {\n\tpublic abstract Object m();\n\tpublic abstract String n();\n\tabstract Object o();\n\tabstract String p();\n}\nclass A2 {\n\tpublic abstract Object m();\n\tpublic abstract String n();\n\tabstract Object o();\n\tabstract String p();\n}\n", "B.java", "class B extends A implements I {}", "B2.java", "class B2 extends A2 implements I {}"}, "----------\n1. ERROR in I.java (at line 13)\n\tclass A2 {\n\t      ^^\nThe type A2 must be an abstract class to define abstract methods\n----------\n2. ERROR in I.java (at line 14)\n\tpublic abstract Object m();\n\t                       ^^^\nThe abstract method m in type A2 can only be defined by an abstract class\n----------\n3. ERROR in I.java (at line 15)\n\tpublic abstract String n();\n\t                       ^^^\nThe abstract method n in type A2 can only be defined by an abstract class\n----------\n4. ERROR in I.java (at line 16)\n\tabstract Object o();\n\t                ^^^\nThe abstract method o in type A2 can only be defined by an abstract class\n----------\n5. ERROR in I.java (at line 17)\n\tabstract String p();\n\t                ^^^\nThe abstract method p in type A2 can only be defined by an abstract class\n----------\n----------\n1. ERROR in B.java (at line 1)\n\tclass B extends A implements I {}\n\t      ^\nThe type B must implement the inherited abstract method A.p()\n----------\n2. ERROR in B.java (at line 1)\n\tclass B extends A implements I {}\n\t      ^\nThe type B must implement the inherited abstract method I.o() to override A.o()\n----------\n3. ERROR in B.java (at line 1)\n\tclass B extends A implements I {}\n\t      ^\nThe type B must implement the inherited abstract method A.n()\n----------\n4. ERROR in B.java (at line 1)\n\tclass B extends A implements I {}\n\t      ^\nThe type B must implement the inherited abstract method I.m() to override A.m()\n----------\n----------\n1. ERROR in B2.java (at line 1)\n\tclass B2 extends A2 implements I {}\n\t      ^^\nThe type B2 must implement the inherited abstract method I.o() to override A2.o()\n----------\n2. ERROR in B2.java (at line 1)\n\tclass B2 extends A2 implements I {}\n\t      ^^\nThe type B2 must implement the inherited abstract method I.m() to override A2.m()\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"B.java", "class B extends A implements I {}", "B2.java", "class B2 extends A2 implements I {}"}, "----------\n1. ERROR in B.java (at line 1)\n\tclass B extends A implements I {}\n\t      ^\nThe type B must implement the inherited abstract method A.p()\n----------\n2. ERROR in B.java (at line 1)\n\tclass B extends A implements I {}\n\t      ^\nThe type B must implement the inherited abstract method I.o() to override A.o()\n----------\n3. ERROR in B.java (at line 1)\n\tclass B extends A implements I {}\n\t      ^\nThe type B must implement the inherited abstract method A.n()\n----------\n4. ERROR in B.java (at line 1)\n\tclass B extends A implements I {}\n\t      ^\nThe type B must implement the inherited abstract method I.m() to override A.m()\n----------\n----------\n1. ERROR in B2.java (at line 1)\n\tclass B2 extends A2 implements I {}\n\t      ^^\nThe type B2 must implement the inherited abstract method I.o() to override A2.o()\n----------\n2. ERROR in B2.java (at line 1)\n\tclass B2 extends A2 implements I {}\n\t      ^^\nThe type B2 must implement the inherited abstract method I.m() to override A2.m()\n----------\n", null, false);
    }

    public void test182() {
        this.runNegativeTest(new String[]{"I.java", "interface I {\n\tString m();\n\tObject n();\n}\nclass A {\n\tpublic Object m() { return null; }\n\tpublic String n() { return null; }\n}\nabstract class A2 {\n\tpublic Object m() { return null; }\n\tpublic String n() { return null; }\n}\n", "B.java", "class B extends A implements I {}", "B2.java", "class B2 extends A2 implements I {}"}, "----------\n1. ERROR in B.java (at line 1)\n\tclass B extends A implements I {}\n\t      ^\nThe type B must implement the inherited abstract method I.m() to override A.m()\n----------\n----------\n1. ERROR in B2.java (at line 1)\n\tclass B2 extends A2 implements I {}\n\t      ^^\nThe type B2 must implement the inherited abstract method I.m() to override A2.m()\n----------\n");
        this.runNegativeTest(new String[]{"B.java", "class B extends A implements I {}", "B2.java", "class B2 extends A2 implements I {}"}, "----------\n1. ERROR in B.java (at line 1)\n\tclass B extends A implements I {}\n\t      ^\nThe type B must implement the inherited abstract method I.m() to override A.m()\n----------\n----------\n1. ERROR in B2.java (at line 1)\n\tclass B2 extends A2 implements I {}\n\t      ^^\nThe type B2 must implement the inherited abstract method I.m() to override A2.m()\n----------\n", null, false);
    }

    public void test183() {
        this.runNegativeTest(new String[]{"X.java", "class XX {\n\t<T extends C, S extends G<T>> void a(S gC) {}\n\t<T extends C, S extends G<T>> void b(T c) {}\n\t<T extends C> void c(G<T> gC) {}\n\t<T extends C, S extends G<T>> void d(S gC) {}\n}\nclass X extends XX {\n\t@Override void a(G g) {}\n\t@Override void b(C c) {}\n\t@Override void c(G g) {}\n\t@Override <T extends C, S extends G<C>> void d(S gc) {}\n}\nclass C {}\nclass G<T2> {}"}, "----------\n1. WARNING in X.java (at line 8)\n\t@Override void a(G g) {}\n\t                 ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n2. WARNING in X.java (at line 10)\n\t@Override void c(G g) {}\n\t                 ^\nG is a raw type. References to generic type G<T2> should be parameterized\n----------\n3. ERROR in X.java (at line 11)\n\t@Override <T extends C, S extends G<C>> void d(S gc) {}\n\t                                             ^^^^^^^\nName clash: The method d(S) of type X has the same erasure as d(S) of type XX but does not override it\n----------\n4. ERROR in X.java (at line 11)\n\t@Override <T extends C, S extends G<C>> void d(S gc) {}\n\t                                             ^^^^^^^\n" + this.mustOverrideMessage("d(S)", "X") + "----------\n");
    }

    public void test184() {
        this.runNegativeTest(new String[]{"A.java", "class A<U extends Number> {\n\t<T extends A<Number>> T a() { return null; }\n\t<T extends Number> U num() { return null; }\n\t<T> T x() { return null; }\n\t<T extends Number> T y() { return null; }\n\t<T extends Integer> T z() { return null; }\n}\nclass B extends A<Double> {\n\t@Override A a() { return null; }\n\t@Override Double num() { return 1.0; }\n\t@Override Integer x() { return 1; }\n\t@Override Integer y() { return 1; }\n\t@Override Integer z() { return 1; }\n}\nclass C extends A {\n\t@Override A a() { return null; }\n\t@Override Double num() { return 1.0; }\n\t@Override Integer x() { return 1; }\n\t@Override Integer y() { return 1; }\n\t@Override Integer z() { return 1; }\n}\nclass M {\n\t<T extends M> Object m(Class<T> c) { return null; }\n\t<T extends M> Object n(Class<T> c) { return null; }\n}\nclass N<V> extends M {\n\t@Override <T extends M> T m(Class<T> c) { return null; }\n\t@Override <T extends M> V n(Class<T> c) { return null; }\n}"}, "----------\n1. WARNING in A.java (at line 6)\n\t<T extends Integer> T z() { return null; }\n\t           ^^^^^^^\nThe type parameter T should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n2. WARNING in A.java (at line 9)\n\t@Override A a() { return null; }\n\t          ^\nA is a raw type. References to generic type A<U> should be parameterized\n----------\n3. WARNING in A.java (at line 9)\n\t@Override A a() { return null; }\n\t          ^\nType safety: The return type A for a() from the type B needs unchecked conversion to conform to T from the type A<U>\n----------\n4. WARNING in A.java (at line 11)\n\t@Override Integer x() { return 1; }\n\t          ^^^^^^^\nType safety: The return type Integer for x() from the type B needs unchecked conversion to conform to T from the type A<U>\n----------\n5. WARNING in A.java (at line 12)\n\t@Override Integer y() { return 1; }\n\t          ^^^^^^^\nType safety: The return type Integer for y() from the type B needs unchecked conversion to conform to T from the type A<U>\n----------\n6. WARNING in A.java (at line 13)\n\t@Override Integer z() { return 1; }\n\t          ^^^^^^^\nType safety: The return type Integer for z() from the type B needs unchecked conversion to conform to T from the type A<U>\n----------\n7. WARNING in A.java (at line 15)\n\tclass C extends A {\n\t                ^\nA is a raw type. References to generic type A<U> should be parameterized\n----------\n8. WARNING in A.java (at line 16)\n\t@Override A a() { return null; }\n\t          ^\nA is a raw type. References to generic type A<U> should be parameterized\n----------\n");
    }

    public void test185() {
        this.runNegativeTest(new String[]{"A.java", "interface I { I hello(); }\ninterface J { J hello(); }\nclass A implements I, J {}"}, "----------\n1. ERROR in A.java (at line 3)\n\tclass A implements I, J {}\n\t      ^\nThe type A must implement the inherited abstract method J.hello()\n----------\n");
    }

    public void test186() {
        this.runNegativeTest(false, new String[]{"p1/A.java", "package p1;\npublic class A { void m() {} }\n", "p2/B.java", "package p2;\npublic class B extends p1.A { void m() {} }\n", "p1/C.java", "package p1;\npublic class C extends p2.B { @Override void m() {} }"}, null, null, "----------\n1. WARNING in p2\\B.java (at line 2)\n\tpublic class B extends p1.A { void m() {} }\n\t                                   ^^^\nThe method B.m() does not override the inherited method from A since it is private to a different package\n----------\n----------\n1. WARNING in p1\\C.java (at line 2)\n\tpublic class C extends p2.B { @Override void m() {} }\n\t                                             ^^^\nThe method C.m() does not override the inherited method from B since it is private to a different package\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test187() {
        String expectedCompilerLog = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 6)\n\tdouble f(List<Integer> l) {return 0;}\n\t       ^^^^^^^^^^^^^^^^^^\nName clash: The method f(List<Integer>) of type Y has the same erasure as f(List<String>) of type X but does not override it\n----------\n2. WARNING in X.java (at line 13)\n\tint f(List<String> l) {return 0;}\n\t    ^^^^^^^^^^^^^^^^^\nErasure of method f(List<String>) is the same as another method in type XX\n----------\n3. WARNING in X.java (at line 14)\n\tdouble f(List<Integer> l) {return 0;}\n\t       ^^^^^^^^^^^^^^^^^^\nErasure of method f(List<Integer>) is the same as another method in type XX\n----------\n" : "----------\n1. ERROR in X.java (at line 6)\n\tdouble f(List<Integer> l) {return 0;}\n\t       ^^^^^^^^^^^^^^^^^^\nName clash: The method f(List<Integer>) of type Y has the same erasure as f(List<String>) of type X but does not override it\n----------\n2. ERROR in X.java (at line 13)\n\tint f(List<String> l) {return 0;}\n\t    ^^^^^^^^^^^^^^^^^\nErasure of method f(List<String>) is the same as another method in type XX\n----------\n3. ERROR in X.java (at line 14)\n\tdouble f(List<Integer> l) {return 0;}\n\t       ^^^^^^^^^^^^^^^^^^\nErasure of method f(List<Integer>) is the same as another method in type XX\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\nclass X {\n    int f(List<String> l) {return 0;}\n}\nclass Y extends X {\n    double f(List<Integer> l) {return 0;}\n}\ninterface I {\n\tdouble f(List<Integer> l);\n}\nabstract class Z extends X implements I {}\nclass XX {\n    int f(List<String> l) {return 0;}\ndouble f(List<Integer> l) {return 0;}\n}"}, expectedCompilerLog);
    }

    public void test188() {
        this.runNegativeTest(false, new String[]{"Y.java", "abstract class Y<T extends Number> implements I<T> {\n\tpublic T get(T element) { return null; }\n}\ninterface I<T> { T get(T element); }\nclass Z extends Y {}"}, null, null, "----------\n1. WARNING in Y.java (at line 5)\n\tclass Z extends Y {}\n\t                ^\nY is a raw type. References to generic type Y<T> should be parameterized\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test189() {
        this.runNegativeTest(new String[]{"X.java", "interface Interface {\n    void foo() throws CloneNotSupportedException, InterruptedException;\n}\nabstract class AbstractClass1 {\n    public abstract void foo() throws ClassNotFoundException, CloneNotSupportedException;\n}\nabstract class AbstractClass2 extends AbstractClass1  implements Interface {\n\tvoid bar() {\n        try {\n        \tfoo();\n        } catch (CloneNotSupportedException e) {\n        }\n    }\n}\n\nclass X extends AbstractClass2 {\n\t@Override\n\tpublic void foo() throws CloneNotSupportedException {\n\t}\n}\nclass Y extends AbstractClass2 {\n\t@Override public void foo() throws ClassNotFoundException, CloneNotSupportedException {}\n}\nclass Z extends AbstractClass2 {\n\t@Override public void foo() throws CloneNotSupportedException, InterruptedException {}\n}\nclass All extends AbstractClass2 {\n\t@Override public void foo() throws ClassNotFoundException, CloneNotSupportedException, InterruptedException {}\n}"}, "----------\n1. ERROR in X.java (at line 22)\n\t@Override public void foo() throws ClassNotFoundException, CloneNotSupportedException {}\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nException ClassNotFoundException is not compatible with throws clause in Interface.foo()\n----------\n2. ERROR in X.java (at line 25)\n\t@Override public void foo() throws CloneNotSupportedException, InterruptedException {}\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nException InterruptedException is not compatible with throws clause in AbstractClass1.foo()\n----------\n3. ERROR in X.java (at line 28)\n\t@Override public void foo() throws ClassNotFoundException, CloneNotSupportedException, InterruptedException {}\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nException ClassNotFoundException is not compatible with throws clause in Interface.foo()\n----------\n4. ERROR in X.java (at line 28)\n\t@Override public void foo() throws ClassNotFoundException, CloneNotSupportedException, InterruptedException {}\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nException InterruptedException is not compatible with throws clause in AbstractClass1.foo()\n----------\n");
    }

    public void test190() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tvoid foo() {}\n}", "p1/B.java", "package p1;\npublic class B extends p2.C {\n\t@Override public int foo() { return 0; }\n}", "p2/C.java", "package p2;\npublic class C extends p1.A {\n\tpublic int foo() { return 1; }\n}"}, "----------\n1. ERROR in p1\\B.java (at line 3)\n\t@Override public int foo() { return 0; }\n\t                 ^^^\nThe return type is incompatible with A.foo()\n----------\n----------\n1. WARNING in p2\\C.java (at line 3)\n\tpublic int foo() { return 1; }\n\t           ^^^^^\nThe method C.foo() does not override the inherited method from A since it is private to a different package\n----------\n");
    }

    public void test191() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tstatic void foo() {}\n}", "p1/B.java", "package p1;\npublic class B extends p2.C {\n\tpublic static int foo() { return 0; }\n}", "p2/C.java", "package p2;\npublic class C extends p1.A {\n\tpublic static int foo() { return 1; }\n}"}, "----------\n1. ERROR in p1\\B.java (at line 3)\n\tpublic static int foo() { return 0; }\n\t              ^^^\nThe return type is incompatible with A.foo()\n----------\n");
    }

    public void test192() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tvoid foo() {}\n}", "p1/B.java", "package p1;\npublic class B extends p2.C {\n\tpublic static int foo() { return 0; }\n}", "p2/C.java", "package p2;\npublic class C extends p1.A {\n\tpublic static int foo() { return 1; }\n}"}, "----------\n1. ERROR in p1\\B.java (at line 3)\n\tpublic static int foo() { return 0; }\n\t                  ^^^^^\nThis static method cannot hide the instance method from A\n----------\n");
    }

    public void test193() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tvoid foo() {}\n}", "p1/B.java", "package p1;\npublic class B extends p2.C {\n\t@Override public int foo() { return 0; }\n}", "p2/C.java", "package p2;\npublic class C extends p1.A {\n\tpublic static int foo() { return 1; }\n}"}, "----------\n1. ERROR in p1\\B.java (at line 3)\n\t@Override public int foo() { return 0; }\n\t                 ^^^\nThe return type is incompatible with A.foo()\n----------\n2. ERROR in p1\\B.java (at line 3)\n\t@Override public int foo() { return 0; }\n\t                     ^^^^^\nThis instance method cannot override the static method from C\n----------\n");
    }

    public void test194() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tstatic void foo() {}\n}", "p1/B.java", "package p1;\npublic class B extends p2.C {\n\tpublic int foo() { return 0; }\n}", "p2/C.java", "package p2;\npublic class C extends p1.A {\n\tpublic static int foo() { return 1; }\n}"}, "----------\n1. ERROR in p1\\B.java (at line 3)\n\tpublic int foo() { return 0; }\n\t           ^^^^^\nThis instance method cannot override the static method from A\n----------\n2. ERROR in p1\\B.java (at line 3)\n\tpublic int foo() { return 0; }\n\t           ^^^^^\nThis instance method cannot override the static method from C\n----------\n");
    }

    public void test195() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tstatic void foo() {}\n}", "p1/B.java", "package p1;\npublic class B extends p2.C {\n\t@Override public int foo() { return 0; }\n}", "p2/C.java", "package p2;\npublic class C extends p1.A {\n\tpublic int foo() { return 1; }\n}"}, "----------\n1. ERROR in p1\\B.java (at line 3)\n\t@Override public int foo() { return 0; }\n\t                     ^^^^^\nThis instance method cannot override the static method from A\n----------\n");
    }

    public void test196() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tstatic void foo() {}\n}", "p1/B.java", "package p1;\npublic class B extends p2.C {\n\tpublic static int foo() { return 0; }\n}", "p2/C.java", "package p2;\npublic class C extends p1.A {\n\tpublic int foo() { return 1; }\n}"}, "----------\n1. ERROR in p1\\B.java (at line 3)\n\tpublic static int foo() { return 0; }\n\t              ^^^\nThe return type is incompatible with A.foo()\n----------\n2. ERROR in p1\\B.java (at line 3)\n\tpublic static int foo() { return 0; }\n\t                  ^^^^^\nThis static method cannot hide the instance method from C\n----------\n");
    }

    public void test197() {
        this.runNegativeTest(new String[]{"p1/A.java", "package p1;\npublic class A {\n\tvoid foo() {}\n}", "p1/B.java", "package p1;\npublic class B extends p2.C {\n\tpublic static int foo() { return 0; }\n}", "p2/C.java", "package p2;\npublic class C extends p1.A {\n\tpublic int foo() { return 1; }\n}"}, "----------\n1. ERROR in p1\\B.java (at line 3)\n\tpublic static int foo() { return 0; }\n\t                  ^^^^^\nThis static method cannot hide the instance method from A\n----------\n2. ERROR in p1\\B.java (at line 3)\n\tpublic static int foo() { return 0; }\n\t                  ^^^^^\nThis static method cannot hide the instance method from C\n----------\n----------\n1. WARNING in p2\\C.java (at line 3)\n\tpublic int foo() { return 1; }\n\t           ^^^^^\nThe method C.foo() does not override the inherited method from A since it is private to a different package\n----------\n");
    }

    public void test198() {
        if (new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x320000L) {
            return;
        }
        this.runConformTest(new String[]{"MyAnnotation.java", "@interface MyAnnotation {\n    MyEnum value();\n}", "MyClass.java", "public class MyClass implements MyInterface {\n    @Override public void foo() {}\n}", "MyEnum.java", "enum MyEnum implements Runnable {\n\tG {\n\t\t@Override public void methodA() {\n\t\t\tnew Runnable() {\n\t\t\t\t@Override public void run() {}\n\t\t\t};\n\t\t}\n\t},\n\tD {\n\t\t@Override public void methodA() {}\n\t},\n\tA {\n\t\t@Override public void methodA() {}\n\t\t@Override public void methodB() {}\n\t},\n\tB {\n\t\t@Override public void methodA() {}\n\t},\n\tC {\n\t\t@Override public void methodA() {}\n\t\t@Override public void methodB() {}\n\t},\n\tE {\n\t\t@Override public void methodA() {}\n\t},\n\tF {\n\t\t@Override public void methodA() {}\n\t};\n\tprivate MyEnum() {}\n\tpublic void methodA() {}\n\tpublic void methodB() {}\n\t@Override public void run() {}\n}", "MyInterface.java", "interface MyInterface {\n    @MyAnnotation(MyEnum.D) public void foo();\n}"}, "");
    }

    public void test199() {
        this.runConformTest(new String[]{"Bar.java", "public interface Bar {\n\tvoid addError(String message, Object... arguments);\n\tvoid addError(Throwable t);\n}"}, "");
        this.runConformTest(false, new String[]{"Foo.java", "public class Foo {\n\tvoid bar(Bar bar) {\n\t\tbar.addError(\"g\");\n\t}\n}"}, "", "", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test200() {
        String errorMessage = "----------\n1. ERROR in X.java (at line 3)\n\tint foo(Collection bar) { return 0; }\n\t    ^^^^^^^^^^^^^^^^^^^\nErasure of method foo(Collection) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 3)\n\tint foo(Collection bar) { return 0; }\n\t        ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n3. ERROR in X.java (at line 4)\n\tdouble foo(Collection<String> bar) {return 0; }\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method foo(Collection<String>) is the same as another method in type X\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nclass X {\n\tint foo(Collection bar) { return 0; }\n\tdouble foo(Collection<String> bar) {return 0; }\n}"}, errorMessage);
    }

    public void test201() {
        this.runConformTest(new String[]{"A.java", "interface I {}\ninterface J<T1> { J<T1> get(); }\ninterface K<T2 extends J<? extends I>> { T2 get(); }\ninterface A<T3 extends K<T3> & J<? extends I>> extends J<I> {}\ninterface B<T4 extends J<? extends I> & K<T4>> extends J<I> {}"}, "");
    }

    public void test202() {
        this.runConformTest(new String[]{"SubClass.java", "interface MyInterface <T0 extends Object> {\n\tString testMe(T0 t);\n}\nabstract class AbstractSuperClass<T1 extends AbstractSuperClass> implements MyInterface<T1> {\n\tpublic String testMe(T1 o) { return null; }\n}\nclass SubClass extends AbstractSuperClass<SubClass> {\n   @Override public String testMe(SubClass o) {\n      return super.testMe(o);\n   }\n}"}, "");
    }

    public void test203() {
        this.runConformTest(new String[]{"X.java", "interface I {}\ninterface Y<T extends I> extends java.util.Comparator<T> {\n\tpublic int compare(T o1, T o2);\n}\nclass X implements Y {\n\tpublic int compare(Object o1, Object o2) {\n\t\treturn compare((I) o1, (I) o2);\n\t}\n\tpublic int compare(I o1, I o2) { return 0; }\n}"}, "");
    }

    public void test204() {
        this.runConformTest(new String[]{"OverrideBug.java", "import java.util.List;\ninterface Map<K, V> {\n\tpublic V put(K key, V value);\n}\npublic class OverrideBug<K, V> implements Map<K, List<V>> {\npublic List<V> put(final K arg0, final List<V> arg1) {\n    return null;\n}\npublic List<V> put(final K arg0, final V arg1) {\n    return null;\n}\n}"}, "");
    }

    public void test204a() {
        this.runNegativeTest(new String[]{"OverrideBug.java", "import java.util.List;\ninterface Map<K, V> {\n\tpublic V put(K key, V value);\n}\npublic class OverrideBug<K, V> implements Map<K, List<V>> {\npublic List<V> put(final K arg0, final List<V> arg1) {\n    return null;\n}\npublic V put(final K arg0, final V arg1) {\n    return null;\n}\n}"}, "----------\n1. ERROR in OverrideBug.java (at line 9)\n\tpublic V put(final K arg0, final V arg1) {\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method put(K, V) of type OverrideBug<K,V> has the same erasure as put(K, V) of type Map<K,V> but does not override it\n----------\n");
    }

    public void test205() {
        this.runConformTest(new String[]{"Tester.java", "import java.lang.reflect.Method;\n\npublic class Tester {\n\n public static interface Converter<T> {\n   T convert(String input);\n }\n\n public static abstract class EnumConverter<T extends Enum<T>> implements Converter<Enum<T>> {\n   public final T convert(String input) {\n     return null;\n   }\n }\n\n public static class SomeEnumConverter extends EnumConverter<Thread.State> {\n }\n\n public static void main(String[] args) throws Exception {\n   Method m = SomeEnumConverter.class.getMethod(\"convert\", String.class);\n   System.out.println(m.getGenericReturnType());\n }\n\n}\n"}, "T");
    }

    public void test206() {
        this.runConformTest(new String[]{"Tester.java", "import java.lang.reflect.Method;\n\npublic class Tester {\n\n public static interface Converter<T> {\n   T convert(String input);\n }\n\n public static abstract class EnumConverter<T extends Enum<T>> implements Converter<T> {\n   public final T convert(String input) {\n     return null;\n   }\n }\n\n public static class SomeEnumConverter extends EnumConverter<Thread.State> {\n }\n\n public static void main(String[] args) throws Exception {\n   Method m = SomeEnumConverter.class.getMethod(\"convert\", String.class);\n   System.out.println(m.getGenericReturnType());\n }\n\n}\n"}, "T");
    }

    public void test207() {
        this.runConformTest(new String[]{"Tester.java", "import java.lang.reflect.Method;\n\npublic class Tester {\n\n public static interface Converter<T> {\n   T convert(String input);\n }\n\n public static abstract class EnumConverter<T extends Enum<T>, K> implements Converter<T> {\n   public final T convert(K input) {\n     return null;\n   }\n }\n\n public static class SomeEnumConverter extends EnumConverter<Thread.State, String> {\n }\n\n public static void main(String[] args) throws Exception {\n   Method m = SomeEnumConverter.class.getMethod(\"convert\", String.class);\n   System.out.println(m.getGenericReturnType());\n }\n\n}\n"}, "class java.lang.Object");
    }

    public void test208() {
        this.runConformTest(new String[]{"Test.java", "import java.lang.annotation.Annotation;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.reflect.Method;\n\npublic class Test extends Super {\n    public static void main(String[] args) {\n        try {\n            Method m = Test.class.getMethod(\"setFoo\", String.class);\n            Annotation a = m.getAnnotation(Anno.class);\n            System.out.println(\"Annotation was \" + (a == null ? \"not \" : \"\") +\n\"found\");\n        } catch (Exception e) {\n            e.printStackTrace();\n        }\n    }\n}\n\nclass Super {\n    @Anno\n    public void setFoo(String foo) {}\n}\n\n@Retention(RetentionPolicy.RUNTIME)\n@interface Anno {\n\n}\n"}, "Annotation was found");
    }

    public void test208a() {
        this.runConformTest(new String[]{"Test.java", "import java.lang.annotation.Annotation;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.reflect.Method;\n\npublic class Test extends Super {\n    public void setFoo() {}\n    public static void main(String[] args) {\n        try {\n            Method m = Test.class.getMethod(\"setFoo\", String.class);\n            Annotation a = m.getAnnotation(Anno.class);\n            System.out.println(\"Annotation was \" + (a == null ? \"not \" : \"\") +\n\"found\");\n        } catch (Exception e) {\n            e.printStackTrace();\n        }\n    }\n}\n\nclass Super {\n    @Anno\n    public void setFoo(String foo) {}\n}\n\n@Retention(RetentionPolicy.RUNTIME)\n@interface Anno {\n\n}\n"}, "Annotation was found");
    }

    public void test209() {
        this.runNegativeTest(new String[]{"Concrete.java", "class Bar extends Zork {}\nclass Foo {}\n\ninterface Function<F, T> {\n    T apply(F f);\n}\ninterface Predicate<T> {\n    boolean apply(T t);\n}\n\npublic class Concrete implements Predicate<Foo>, Function<Bar, Boolean> {\n    public Boolean apply(Bar two) {\n        return null;\n    }\n    public boolean apply(Foo foo) {\n        return false;\n    }\n}\n"}, "----------\n1. ERROR in Concrete.java (at line 1)\n\tclass Bar extends Zork {}\n\t                  ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test210() {
        this.runNegativeTest(new String[]{"ErasureTest.java", "interface Interface1<T> {\n    public void hello(T greeting);\n}\ninterface Interface2<T> {\n    public int hello(T greeting);\n}\npublic class ErasureTest extends Zork implements Interface1<String>, Interface2<Double> {\n    public void hello(String greeting) { }\n    public int hello(Double greeting) {\n        return 0;\n    }\n}\n"}, "----------\n1. ERROR in ErasureTest.java (at line 7)\n\tpublic class ErasureTest extends Zork implements Interface1<String>, Interface2<Double> {\n\t                                 ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test211() {
        this.runNegativeTest(new String[]{"SomeClass.java", "interface Equivalent<T> {\n\tboolean equalTo(T other);\n}\n\ninterface EqualityComparable<T> {\n\tboolean equalTo(T other);\n}\n\npublic class SomeClass implements Equivalent<String>, EqualityComparable<Integer> {\n\tpublic boolean equalTo(String other) {\n\t\treturn true;\n\t}\n\tpublic boolean equalTo(Integer other) {\n\t\treturn true;\n\t}\n}\n"}, "----------\n1. ERROR in SomeClass.java (at line 9)\n\tpublic class SomeClass implements Equivalent<String>, EqualityComparable<Integer> {\n\t             ^^^^^^^^^\nName clash: The method equalTo(T) of type EqualityComparable<T> has the same erasure as equalTo(T) of type Equivalent<T> but does not override it\n----------\n");
    }

    public void test212() {
        this.runNegativeTest(new String[]{"Derived.java", "class Base<T> {\n    T foo(T x) {\n        return x;\n    }\n}\ninterface Interface<T>{\n    T foo(T x);\n}\npublic class Derived extends Base<String> implements Interface<Integer> {\n    public Integer foo(Integer x) {\n        return x;\n    }\n}\n"}, "----------\n1. ERROR in Derived.java (at line 9)\n\tpublic class Derived extends Base<String> implements Interface<Integer> {\n\t             ^^^^^^^\nName clash: The method foo(T) of type Interface<T> has the same erasure as foo(T) of type Base<T> but does not override it\n----------\n");
    }

    public void test213() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"Y.java", "public abstract class Y implements I<Y> {\n\t\tpublic final Y foo(Object o, J<Y> j) {\n\t\t\treturn null;\n\t\t}\n\tpublic final void bar(Object o, J<Y> j, Y y) {\n\t}\n}", "I.java", "public interface I<S> {\n\tpublic S foo(Object o, J<S> j);\n\tpublic void bar(Object o, J<S> j, S s);\n}", "J.java", "public interface J<S> {}"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic Object foo() {\n\t\treturn new Y() {};\n\t}\n}"}, "", null, false, null, compilerOptions14, null);
    }

    public void test213a() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"Y.java", "public abstract class Y implements I<Y> {\n\t\tpublic final Y foo(Object o, J<Y, I<Y>> j) {\n\t\t\treturn null;\n\t\t}\n\tpublic final void bar(Object o, J<Y, String> j, Y y) {\n\t}\n}", "I.java", "public interface I<S> {\n\tpublic S foo(Object o, J<S, I<S>> j);\n\tpublic void bar(Object o, J<S, String> j, S s);\n}", "J.java", "public interface J<S, T> {}"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic Object foo() {\n\t\treturn new Y() {};\n\t}\n}"}, "", null, false, null, compilerOptions14, null);
    }

    public void test213b() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"ConsoleSession.java", "public abstract class ConsoleSession implements ServiceFactory<Object> {\n\tpublic final void ungetService(Bundle bundle, ServiceRegistration<Object> registration, Object service) {\n\t}\n\t\n\tpublic final Object getService(Bundle bundle, ServiceRegistration<Object> registration) {\n\t\treturn this;\n\t}\n}\n\nclass Bundle {}\n\ninterface ServiceFactory<S> {\n\tpublic void ungetService(Bundle b, ServiceRegistration<S> registration, S service);\n\tpublic S getService(Bundle bundle, ServiceRegistration<S> registration);\n}\n\ninterface ServiceRegistration<T> {\n\n}\n"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runConformTest(new String[]{"OSGiConsole.java", "public class OSGiConsole {\n\tOSGiConsole() {\n\t\tnew ConsoleSession() {\n\t\t};\n\t}\n}\n"}, "", null, false, null, compilerOptions14, null);
    }

    public void test213c() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"ConsoleSession.java", "public abstract class ConsoleSession implements ServiceFactory<ConsoleSession> {\n\tpublic final void ungetService(Bundle bundle, ServiceRegistration<ConsoleSession> registration, ConsoleSession service) {\n\t}\n\t\n\tpublic final ConsoleSession getService(Bundle bundle, ServiceRegistration<ConsoleSession> registration) {\n\t\treturn this;\n\t}\n}\n\nclass Bundle {}\n\ninterface ServiceFactory<S> {\n\tpublic void ungetService(Bundle b, ServiceRegistration<S> registration, S service);\n\tpublic S getService(Bundle bundle, ServiceRegistration<S> registration);\n}\n\ninterface ServiceRegistration<T> {\n\n}\n"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runConformTest(new String[]{"OSGiConsole.java", "public class OSGiConsole {\n\tOSGiConsole() {\n\t\tnew ConsoleSession() {\n\t\t};\n\t}\n}\n"}, "", null, false, null, compilerOptions14, null);
    }

    public void test326354() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y<I>  implements I {\n    public static void main(String[] args) {\n        ((I) new X()).foo(null);\n    }\n}\n\ninterface I {\n    public void foo(I i);\n}\n \nabstract class Y<T> {\n\t   public void foo(T t) {}\n}\n"}, "");
    }

    public void test328827() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"Map.java", "public interface Map<K,V> {}\n", "EventProperties.java", "public class EventProperties implements Map<String, Object> {}\n", "Event.java", "public class Event {\n    public Event(Map<String, ?> properties) {}\n}"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        this.runConformTest(new String[]{"Map.java", "public interface Map {}\n", "X.java", "public class X {\n    public void start() {\n        Event event = new Event(new EventProperties());\n\t}\n}"}, "", null, false, null, compilerOptions14, null);
    }

    public void test329584() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"I.java", "public interface I {\n\tvoid foo(Object o[], Dictionary<Object, Object> dict);\n}", "Dictionary.java", "public class Dictionary<U, V> {}\n"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        this.runConformTest(new String[]{"X.java", "public class X implements I {\n\tpublic void foo(Object o[], Dictionary dict) {}\n}", "Dictionary.java", "public class Dictionary {}\n"}, "", null, false, null, compilerOptions14, null);
    }

    public void test329588() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic O<?> foo() {\n\t\treturn null;\n\t}\n}", "O.java", "public class O<V> {}\n"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void foo(A a) {\n\t\tO o = (O) a.foo();\n\t\tSystem.out.println(o);\n\t}\n}", "O.java", "public class O {}\n"}, "", null, false, null, compilerOptions14, null);
    }

    public void test330445() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"Y.java", "import java.util.Map;\npublic class Y {\n\tstatic void foo(Map<String, String> map) {\n\t}\n}"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runConformTest(new String[]{"X.java", "import java.util.Properties;\npublic class X {\n    static void bar(Object[] args) {\n        Y.foo(new Properties());\n    }\n}"}, "", null, false, null, compilerOptions14, null);
    }

    public void test330435() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic static <T> B<T> asList(T... tab) {\n\t\treturn null;\n\t}\n}", "B.java", "public interface B<V> {\n\t<T> T[] toArray(T[] tab);\n}\n"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString[] foo(Object[] args) {\n\t\tString[] a = A.asList(args).toArray(new String[0]);\n\t\treturn a;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tString[] a = A.asList(args).toArray(new String[0]);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object[] to String[]\n----------\n", null, false, compilerOptions14);
    }

    public void test330264() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"BundleContext.java", "public interface BundleContext {\n    <S> S getService(ServiceReference<S> reference);\n}\n", "ServiceReference.java", "public interface ServiceReference<S> extends Comparable<Object> {}\n"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runNegativeTest(new String[]{"Activator.java", "public class Activator  {\n    public void start(BundleContext context, ServiceReference ref) {\n        Runnable r = context.getService(ref);\n    }\n}\n"}, "----------\n1. ERROR in Activator.java (at line 3)\n\tRunnable r = context.getService(ref);\n\t             ^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to Runnable\n----------\n", null, false, compilerOptions14);
    }

    public void test331446() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"Test.java", "import java.util.Comparator;\nimport java.util.List;\n\npublic class Test {\n\tpublic static <T> void assertEquals(String message,\n\t\t\tComparator<T> comparator, List<T> expected, List<T> actual) {\n\t\tif (expected.size() != actual.size()) {\n\t\t\t//failNotEquals(message, expected, actual);\n\t\t}\n\t\tfor (int i = 0, l = expected.size(); i < l; i++) {\n\t\t\tassertEquals(message, comparator, expected.get(i), actual.get(i));\n\t\t}\n\t}\n\tpublic static <T> void assertEquals(String message,\n\t\t\tComparator<T> comparator, T expected, T actual) {\n\t\tif (comparator.compare(expected, actual) == 0) {\n\t\t\treturn;\n\t\t}\n\t\t//failNotEquals(message, expected, actual);\n\t}\n}\n"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Comparator;\n\npublic class X {\n\tpublic static void testAmbiguity() {\n\t\tComparator comparator = new Comparator() {\n\t\t\t\n\t\t\tpublic int compare(Object o1, Object o2) {\n\t\t\t\treturn 0;\n\t\t\t}\n\t\t};\n\t\tTest.assertEquals(\"Test\", comparator, new ArrayList(), new ArrayList());\n\t}\n}\n"}, "", null, false, null, compilerOptions14, null);
    }

    public void test331446a() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.4");
        this.runConformTest(new String[]{"Test.java", "import java.util.Comparator;\nimport java.util.List;\n\npublic class Test {\n\tpublic static  void assertEquals(String message,\n\t\t\tComparator comparator, List expected, List actual) {\n\t\tif (expected.size() != actual.size()) {\n\t\t\t//failNotEquals(message, expected, actual);\n\t\t}\n\t\tfor (int i = 0, l = expected.size(); i < l; i++) {\n\t\t\tassertEquals(message, comparator, expected.get(i), actual.get(i));\n\t\t}\n\t}\n\tpublic static void assertEquals(String message,\n\t\t\tComparator comparator, Object expected, Object actual) {\n\t\tif (comparator.compare(expected, actual) == 0) {\n\t\t\treturn;\n\t\t}\n\t\t//failNotEquals(message, expected, actual);\n\t}\n}\n"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Comparator;\n\npublic class X {\n\tpublic static void testAmbiguity() {\n\t\tComparator comparator = new Comparator() {\n\t\t\t\n\t\t\tpublic int compare(Object o1, Object o2) {\n\t\t\t\treturn 0;\n\t\t\t}\n\t\t};\n\t\tTest.assertEquals(\"Test\", comparator, new ArrayList(), new ArrayList());\n\t}\n}\n"}, "", null, false, null, compilerOptions14, null);
    }

    public void test331446b() {
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.4");
        this.runConformTest(new String[]{"Project.java", "class List{}\npublic class Project {\n    static  void foo(List expected) {}\n    public static void foo(Object expected) {}\n}\n"}, "", null, true, null, compilerOptions14, null);
        this.runConformTest(new String[]{"Client.java", "public class Client {\n    Client(List l) {\n        Project.foo(l);\n    }\n}\n"}, "", null, false, null, compilerOptions14, null);
    }

    public void test331446c() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"Project.java", "class List<T> {}\npublic class Project {\n    static <T> void foo(List<T> expected) {}\n    public static <T> void foo(T expected) {}\n}\n"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runConformTest(new String[]{"Client.java", "public class Client {\n    Client(List l) {\n        Project.foo(l);\n    }\n}\n"}, "", null, false, null, compilerOptions14, null);
    }

    public void test331446d() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"Project.java", "class List<T> {}\npublic class Project {\n    static <T> void foo(List<T> expected) {}\n    public static <T> void foo(T expected) {}\n}\n"}, "", null, true, null, compilerOptions15, null);
        this.runConformTest(new String[]{"Client.java", "public class Client {\n    Client(List l) {\n        Project.foo(l);\n    }\n}\n"}, "", null, false, null, compilerOptions15, null);
    }

    public void test1415Mix() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"Abstract.java", "abstract class Generic<T> {\n\tabstract void foo(T t);\n}\npublic abstract class Abstract extends Generic<String> {\n}"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runNegativeTest(new String[]{"Concrete.java", "public class Concrete extends Abstract {\n}"}, "----------\n1. ERROR in Concrete.java (at line 1)\n\tpublic class Concrete extends Abstract {\n\t             ^^^^^^^^\nThe type Concrete must implement the inherited abstract method Generic<String>.foo(String)\n----------\n", null, false, compilerOptions14);
    }

    public void test1415Mix2() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"Abstract.java", "abstract class Generic<T> {\n\tabstract void foo(T t);\n}\npublic abstract class Abstract extends Generic<String> {\n}"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runConformTest(new String[]{"Concrete.java", "public class Concrete extends Abstract {\n    void foo(String s) {}\n}"}, "", null, false, null, compilerOptions14, null);
    }

    public void test332744() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"EList.java", "import java.util.List;\npublic interface EList<E> extends List<E> {\n}\n", "FeatureMap.java", "public interface FeatureMap extends EList<FeatureMap.Entry> {\n    interface Entry {\n    }\n}\n", "InternalEList.java", "public interface InternalEList<E> extends EList<E> {\n}\n"}, "", null, true, null, compilerOptions15, null);
        this.runConformTest(new String[]{"Client.java", "public class Client {\n    Client(FeatureMap fm) {\n\t\tInternalEList e = (InternalEList) fm;\n\t}\n}\n"}, "", null, false, null, compilerOptions15, null);
    }

    public void test332744b() {
        Map compilerOptions15 = this.getCompilerOptions();
        compilerOptions15.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        compilerOptions15.put("org.eclipse.jdt.core.compiler.source", "1.5");
        this.runConformTest(new String[]{"EList.java", "import java.util.List;\npublic interface EList<E> extends List<E> {\n}\n", "FeatureMap.java", "public interface FeatureMap extends EList<FeatureMap.Entry> {\n    interface Entry {\n    }\n}\n", "InternalEList.java", "public interface InternalEList<E> extends EList<E> {\n}\n"}, "", null, true, null, compilerOptions15, null);
        Map compilerOptions14 = this.getCompilerOptions();
        compilerOptions14.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.source", "1.3");
        compilerOptions14.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
        this.runConformTest(new String[]{"Client.java", "public class Client {\n    Client(FeatureMap fm) {\n\t\tInternalEList e = (InternalEList) fm;\n\t}\n}\n"}, "", null, false, null, compilerOptions14, null);
    }

    public void test339447() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X implements Cloneable {\n\tpublic synchronized X clone() {\n\t\treturn this;\n\t}\n}"}, "");
        String expectedOutput = "  public bridge synthetic java.lang.Object clone() throws java.lang.CloneNotSupportedException;";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            MethodVerifyTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test322740() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "class Base  {\n    boolean equalTo(Object other) {return false;}\n}\ninterface EqualityComparable<T> {\n    boolean equalTo(T other);\n}\npublic class X extends Base implements EqualityComparable<String> {\n    public boolean equalTo(String other) {\n        return true;\n    }\n    public static void main(String args[]) {\n        new X().equalTo(args);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic class X extends Base implements EqualityComparable<String> {\n\t             ^\nName clash: The method equalTo(T) of type EqualityComparable<T> has the same erasure as equalTo(Object) of type Base but does not override it\n----------\n");
    }

    public void test334306() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "class X<T> {}\ninterface I {\n    void foo(X<Number> p);\n}\ninterface J extends I {\n    void foo(X<Integer> p);\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tvoid foo(X<Integer> p);\n\t     ^^^^^^^^^^^^^^^^^\nName clash: The method foo(X<Integer>) of type J has the same erasure as foo(X<Number>) of type I but does not override it\n----------\n");
    }

    public void test342819() throws Exception {
        this.runNegativeTest(new String[]{"TwoWayDTOAdapter.java", "public interface TwoWayDTOAdapter<A, B> extends DTOAdapter <A, B>{\n    public A convert(B b);\n}\n", "DTOAdapter.java", "public interface DTOAdapter<A, B> {\n    public B convert(A a);\n}\n", "TestAdapter.java", "public class TestAdapter implements TwoWayDTOAdapter<Long, Integer> {\n    public Long convert(Integer b) {\n        return null;\n    }\n    public Integer convert(Long a) {\n        return null;\n    }\n}"}, "----------\n1. ERROR in TwoWayDTOAdapter.java (at line 2)\n\tpublic A convert(B b);\n\t         ^^^^^^^^^^^^\nName clash: The method convert(B) of type TwoWayDTOAdapter<A,B> has the same erasure as convert(A) of type DTOAdapter<A,B> but does not override it\n----------\n");
    }

    public void test346029() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "class A<T> {\n    void f(String s) {}\n}\nclass B<T> extends A<T> {\n    void f(T t) {}\n}\npublic class X extends B<String> {\n    void foo(X x) {\n        x.f(\"\");\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tpublic class X extends B<String> {\n\t             ^\nDuplicate methods named f with the parameters (T) and (String) are inherited from the types B<String> and A<String>\n----------\n2. ERROR in X.java (at line 9)\n\tx.f(\"\");\n\t  ^\nThe method f(String) is ambiguous for the type X\n----------\n");
    }

    public void test346029b() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface A<T> {\n    void f(String s);\n}\ninterface B<T> extends A<T> {\n    void f(T t);\n}\npublic class X implements B<String> {\n    public void f(String t) {\n        Zork z;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test346029c() throws Exception {
        this.runNegativeTest(false, new String[]{"X.java", "class A<T> {\n    void f(String s) {}\n}\ninterface B<T> {\n    void f(T t);\n}\npublic class X extends A<String> implements B<String> {\n    public void f(String t) {\n    }\n}\n"}, null, null, "----------\n1. WARNING in X.java (at line 8)\n\tpublic void f(String t) {\n\t            ^^^^^^^^^^^\nThe method f(String) of type X should be tagged with @Override since it actually overrides a superclass method\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test346029d() throws Exception {
        this.runNegativeTest(false, new String[]{"X.java", "class A<T> {\n    void f(T s) {}\n}\ninterface B<T> {\n    void f(String t);\n}\npublic class X extends A<String> implements B<String> {\n    public void f(String t) {\n    }\n}\n"}, null, null, "----------\n1. WARNING in X.java (at line 8)\n\tpublic void f(String t) {\n\t            ^^^^^^^^^^^\nThe method f(String) of type X should be tagged with @Override since it actually overrides a superclass method\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test346029e() throws Exception {
        this.runNegativeTest(false, new String[]{"X.java", "class A<T> {\n    void f(String s) {}\n}\nclass B<T> extends A<T> {\n    void f(T t) {}\n}\npublic class X extends B<String> {\n    \tvoid f(String s) {\n       }\n}\n"}, null, null, "----------\n1. WARNING in X.java (at line 8)\n\tvoid f(String s) {\n\t     ^^^^^^^^^^^\nThe method f(String) of type X should be tagged with @Override since it actually overrides a superclass method\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings);
    }

    public void test346029f() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "class A<T> {\n    void f(String s) {}\n}\nclass B<T> extends A<T> {\n    void f(T t) {}\n}\npublic class X extends B<String> {\n\tvoid f(String s) {\n\t\tsuper.f(s);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tvoid f(String s) {\n\t     ^^^^^^^^^^^\nThe method f(String) of type X should be tagged with @Override since it actually overrides a superclass method\n----------\n2. ERROR in X.java (at line 9)\n\tsuper.f(s);\n\t      ^\nThe method f(String) is ambiguous for the type B<String>\n----------\n");
    }

    public void test353089() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\ninterface A {\nint get(List<String> l);\n}\ninterface B  {\nint get(List<Integer> l);\n}\ninterface C  extends A, B { \nint get(List l);      // name clash error here\n}\npublic class X {\n    public static void main(String [] args) {\n        System.out.println(\"Built OK\");\n    }\n}"}, "Built OK");
    }

    public void test353089b() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n    void a(List<String> i, List<String> j);\n    void b(List<String> i, List<String> j);\n    void c(List i, List<String> j);\n}\ninterface X extends I {\n    public void a(List<String> i, List j);\n    public void b(List i, List j);\n    public void c(List i, List j);\n    public void d(Zork z);\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid c(List i, List<String> j);\n\t       ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. ERROR in X.java (at line 8)\n\tpublic void a(List<String> i, List j);\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method a(List<String>, List) of type X has the same erasure as a(List<String>, List<String>) of type I but does not override it\n----------\n3. WARNING in X.java (at line 8)\n\tpublic void a(List<String> i, List j);\n\t                              ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in X.java (at line 9)\n\tpublic void b(List i, List j);\n\t              ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n5. WARNING in X.java (at line 9)\n\tpublic void b(List i, List j);\n\t                      ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n6. WARNING in X.java (at line 10)\n\tpublic void c(List i, List j);\n\t              ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n7. WARNING in X.java (at line 10)\n\tpublic void c(List i, List j);\n\t                      ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n8. ERROR in X.java (at line 11)\n\tpublic void d(Zork z);\n\t              ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test353089c() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface IFtest {\n    public void doTest(Integer i, List<String> pList, List<String> pList2);\n}\ninterface Impl extends IFtest {\n    public void doTest(Integer i, List<String> iList, List iList2);\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic void doTest(Integer i, List<String> iList, List iList2);\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nName clash: The method doTest(Integer, List<String>, List) of type Impl has the same erasure as doTest(Integer, List<String>, List<String>) of type IFtest but does not override it\n----------\n2. WARNING in X.java (at line 6)\n\tpublic void doTest(Integer i, List<String> iList, List iList2);\n\t                                                  ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n");
    }

    public void testBug317719() throws Exception {
        String output = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 4)\n\tpublic <T extends List> T foo() { return null; }\n\t                  ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. WARNING in X.java (at line 4)\n\tpublic <T extends List> T foo() { return null; }\n\t                          ^^^^^\nDuplicate method foo() in type X\n----------\n3. WARNING in X.java (at line 5)\n\tpublic <T extends Set> T foo() { return null; }\n\t                  ^^^\nSet is a raw type. References to generic type Set<E> should be parameterized\n----------\n4. WARNING in X.java (at line 5)\n\tpublic <T extends Set> T foo() { return null; }\n\t                         ^^^^^\nDuplicate method foo() in type X\n----------\n5. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 4)\n\tpublic <T extends List> T foo() { return null; }\n\t                  ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. ERROR in X.java (at line 4)\n\tpublic <T extends List> T foo() { return null; }\n\t                          ^^^^^\nDuplicate method foo() in type X\n----------\n3. WARNING in X.java (at line 5)\n\tpublic <T extends Set> T foo() { return null; }\n\t                  ^^^\nSet is a raw type. References to generic type Set<E> should be parameterized\n----------\n4. ERROR in X.java (at line 5)\n\tpublic <T extends Set> T foo() { return null; }\n\t                         ^^^^^\nDuplicate method foo() in type X\n----------\n5. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.Set;\nclass X {\n    public <T extends List> T foo() { return null; }\n\t public <T extends Set> T foo() { return null; }\n\t Zork z;\n}\n"}, output);
    }

    public void testBug317719a() throws Exception {
        String output = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 4)\n\tpublic Integer same(List<Integer> a) { return null; }\n\t               ^^^^^^^^^^^^^^^^^^^^^\nErasure of method same(List<Integer>) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 5)\n\tpublic String same(List<String> b) { return null; }\n\t              ^^^^^^^^^^^^^^^^^^^^\nErasure of method same(List<String>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. ERROR in X.java (at line 4)\n\tpublic Integer same(List<Integer> a) { return null; }\n\t               ^^^^^^^^^^^^^^^^^^^^^\nErasure of method same(List<Integer>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 5)\n\tpublic String same(List<String> b) { return null; }\n\t              ^^^^^^^^^^^^^^^^^^^^\nErasure of method same(List<String>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.Set;\nclass X {\n    public Integer same(List<Integer> a) { return null; }\n\t public String same(List<String> b) { return null; }\n\t Zork z;\n}\n"}, output);
    }

    public void testBug317719b() throws Exception {
        String output = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 3)\n\tpublic static String doIt(final List<String> arg) { return null; }\n\t                     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt(List<String>) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 4)\n\tpublic static CharSequence doIt(final List<CharSequence> arg) { return null; }\n\t                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt(List<CharSequence>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tpublic static String doIt(final List<String> arg) { return null; }\n\t                     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt(List<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 4)\n\tpublic static CharSequence doIt(final List<CharSequence> arg) { return null; }\n\t                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt(List<CharSequence>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nclass X {\n    public static String doIt(final List<String> arg) { return null; }\n\t public static CharSequence doIt(final List<CharSequence> arg) { return null; }\n\t Zork z;\n}\n"}, output);
    }

    public void testBug317719c() throws Exception {
        String output = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 3)\n\tprotected static <T extends String> T same(Collection<? extends T> p_col) { return null; }\n\t                            ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. WARNING in X.java (at line 3)\n\tprotected static <T extends String> T same(Collection<? extends T> p_col) { return null; }\n\t                                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method same(Collection<? extends T>) is the same as another method in type X\n----------\n3. WARNING in X.java (at line 4)\n\tprotected static <T extends Number> T same(Collection<? extends T> p_col) { return null; }\n\t                                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method same(Collection<? extends T>) is the same as another method in type X\n----------\n4. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 3)\n\tprotected static <T extends String> T same(Collection<? extends T> p_col) { return null; }\n\t                            ^^^^^^\nThe type parameter T should not be bounded by the final type String. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 3)\n\tprotected static <T extends String> T same(Collection<? extends T> p_col) { return null; }\n\t                                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method same(Collection<? extends T>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 4)\n\tprotected static <T extends Number> T same(Collection<? extends T> p_col) { return null; }\n\t                                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method same(Collection<? extends T>) is the same as another method in type X\n----------\n4. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nclass X {\n    protected static <T extends String> T same(Collection<? extends T> p_col) { return null; }\n\t protected static <T extends Number> T same(Collection<? extends T> p_col) { return null; }\n\t Zork z;\n}\n"}, output);
    }

    public void testBug317719d() throws Exception {
        String output = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 3)\n\tpublic static boolean foo(List<String> x) { return true; }\n\t                      ^^^^^^^^^^^^^^^^^^^\nErasure of method foo(List<String>) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 4)\n\tpublic static int foo(List<Integer> x) { return 2; }\n\t                  ^^^^^^^^^^^^^^^^^^^^\nErasure of method foo(List<Integer>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tpublic static boolean foo(List<String> x) { return true; }\n\t                      ^^^^^^^^^^^^^^^^^^^\nErasure of method foo(List<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 4)\n\tpublic static int foo(List<Integer> x) { return 2; }\n\t                  ^^^^^^^^^^^^^^^^^^^^\nErasure of method foo(List<Integer>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nclass X {\n    public static boolean foo(List<String> x) { return true; }\n\t public static int foo(List<Integer> x) { return 2; }\n\t Zork z;\n}\n"}, output);
    }

    public void testBug317719e() throws Exception {
        String output = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 3)\n\tpublic String getFirst (ArrayList<String> ss) { return ss.get(0); }\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method getFirst(ArrayList<String>) is the same as another method in type X\n----------\n2. WARNING in X.java (at line 4)\n\tpublic Integer getFirst (ArrayList<Integer> ss) { return ss.get(0); }\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method getFirst(ArrayList<Integer>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tpublic String getFirst (ArrayList<String> ss) { return ss.get(0); }\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method getFirst(ArrayList<String>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 4)\n\tpublic Integer getFirst (ArrayList<Integer> ss) { return ss.get(0); }\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method getFirst(ArrayList<Integer>) is the same as another method in type X\n----------\n3. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nclass X {\n    public String getFirst (ArrayList<String> ss) { return ss.get(0); }\n\t public Integer getFirst (ArrayList<Integer> ss) { return ss.get(0); }\n\t Zork z;\n}\n"}, output);
    }

    public void testBug317719f() throws Exception {
        String output = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 3)\n\tpublic static <R extends Object> X<R> forAccountSet(List list) { return null; }\n\t                                      ^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method forAccountSet(List) is the same as another method in type X<Z>\n----------\n2. WARNING in X.java (at line 3)\n\tpublic static <R extends Object> X<R> forAccountSet(List list) { return null; }\n\t                                                    ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. WARNING in X.java (at line 4)\n\tpublic static <R extends Object> ChildX<R> forAccountSet(List<R> list) { return null; }\n\t                                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method forAccountSet(List<R>) is the same as another method in type X<Z>\n----------\n4. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tpublic static <R extends Object> X<R> forAccountSet(List list) { return null; }\n\t                                      ^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method forAccountSet(List) is the same as another method in type X<Z>\n----------\n2. WARNING in X.java (at line 3)\n\tpublic static <R extends Object> X<R> forAccountSet(List list) { return null; }\n\t                                                    ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n3. ERROR in X.java (at line 4)\n\tpublic static <R extends Object> ChildX<R> forAccountSet(List<R> list) { return null; }\n\t                                           ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method forAccountSet(List<R>) is the same as another method in type X<Z>\n----------\n4. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nclass X<Z> {\n    public static <R extends Object> X<R> forAccountSet(List list) { return null; }\n\t public static <R extends Object> ChildX<R> forAccountSet(List<R> list) { return null; }\n\t Zork z;\n}\nclass ChildX<Z> extends X<Z>{}\n"}, output);
    }

    public void testBug317719g() throws Exception {
        String output = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in X.java (at line 3)\n\tpublic static int[] doIt(Collection<int[]> col) { return new int[1]; }\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt(Collection<int[]>) is the same as another method in type X<Z>\n----------\n2. WARNING in X.java (at line 4)\n\tpublic static int[][] doIt(Collection<int[][]> col) { return new int[0][0]; }\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt(Collection<int[][]>) is the same as another method in type X<Z>\n----------\n3. WARNING in X.java (at line 5)\n\tpublic int[] doIt2(Collection<int[]> col) { return new int[0]; }\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt2(Collection<int[]>) is the same as another method in type X<Z>\n----------\n4. WARNING in X.java (at line 6)\n\tpublic int[][] doIt2(Collection<int[][]> col) { return new int[0][0]; }\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt2(Collection<int[][]>) is the same as another method in type X<Z>\n----------\n5. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tpublic static int[] doIt(Collection<int[]> col) { return new int[1]; }\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt(Collection<int[]>) is the same as another method in type X<Z>\n----------\n2. ERROR in X.java (at line 4)\n\tpublic static int[][] doIt(Collection<int[][]> col) { return new int[0][0]; }\n\t                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt(Collection<int[][]>) is the same as another method in type X<Z>\n----------\n3. ERROR in X.java (at line 5)\n\tpublic int[] doIt2(Collection<int[]> col) { return new int[0]; }\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt2(Collection<int[]>) is the same as another method in type X<Z>\n----------\n4. ERROR in X.java (at line 6)\n\tpublic int[][] doIt2(Collection<int[][]> col) { return new int[0][0]; }\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method doIt2(Collection<int[][]>) is the same as another method in type X<Z>\n----------\n5. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nclass X<Z> {\n    public static int[] doIt(Collection<int[]> col) { return new int[1]; }\n\t public static int[][] doIt(Collection<int[][]> col) { return new int[0][0]; }\n\t public int[] doIt2(Collection<int[]> col) { return new int[0]; }\n\t public int[][] doIt2(Collection<int[][]> col) { return new int[0][0]; }\n\t Zork z;\n}\nclass ChildX<Z> extends X<Z>{}\n"}, output);
    }

    public void testBug317719h() throws Exception {
        String output = this.complianceLevel == 0x320000L ? "----------\n1. WARNING in Test.java (at line 3)\n\tpublic class Test<Key, Value> extends HashMap<Key, Collection<Value>> {\n\t             ^^^^\nThe serializable class Test does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in Test.java (at line 4)\n\tpublic Collection<Value> put(Key k, Value v) { return null; }\n\t                         ^^^^^^^^^^^^^^^^^^^\nName clash: The method put(Key, Value) of type Test<Key,Value> has the same erasure as put(K, V) of type HashMap<K,V> but does not override it\n----------\n3. WARNING in Test.java (at line 5)\n\tpublic Collection<Value> get(Key k) { return null; }\n\t                         ^^^^^^^^^^\nName clash: The method get(Key) of type Test<Key,Value> has the same erasure as get(Object) of type HashMap<K,V> but does not override it\n----------\n4. ERROR in Test.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in Test.java (at line 3)\n\tpublic class Test<Key, Value> extends HashMap<Key, Collection<Value>> {\n\t             ^^^^\nThe serializable class Test does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in Test.java (at line 4)\n\tpublic Collection<Value> put(Key k, Value v) { return null; }\n\t                         ^^^^^^^^^^^^^^^^^^^\nName clash: The method put(Key, Value) of type Test<Key,Value> has the same erasure as put(K, V) of type HashMap<K,V> but does not override it\n----------\n3. ERROR in Test.java (at line 5)\n\tpublic Collection<Value> get(Key k) { return null; }\n\t                         ^^^^^^^^^^\nName clash: The method get(Key) of type Test<Key,Value> has the same erasure as get(Object) of type HashMap<K,V> but does not override it\n----------\n4. ERROR in Test.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"Test.java", "import java.util.Collection;\nimport java.util.HashMap;\npublic class Test<Key, Value> extends HashMap<Key, Collection<Value>> {\n    public Collection<Value> put(Key k, Value v) { return null; }\n\t public Collection<Value> get(Key k) { return null; }\n\t Zork z;\n}\n"}, output);
    }

    public void test345949a() throws Exception {
        if (new CompilerOptions((Map)this.getCompilerOptions()).sourceLevel < 0x330000L) {
            return;
        }
        this.runNegativeTest(new String[]{"Sub.java", "class A<T> {}\nclass Super {\n    public static void foo(A<Number> p) {}\n}\npublic class Sub extends Super {\n\t public static void foo(A<Integer> p) {}\n}\n"}, "----------\n1. ERROR in Sub.java (at line 6)\n\tpublic static void foo(A<Integer> p) {}\n\t                   ^^^^^^^^^^^^^^^^^\nName clash: The method foo(A<Integer>) of type Sub has the same erasure as foo(A<Number>) of type Super but does not hide it\n----------\n");
    }

    public void testBug355838() throws Exception {
        String output = "----------\n1. ERROR in ErasureBug.java (at line 4)\n\tpublic String output(List<String> integers) {\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nErasure of method output(List<String>) is the same as another method in type ErasureBug\n----------\n2. ERROR in ErasureBug.java (at line 7)\n\tpublic String output(List doubles) {\n\t              ^^^^^^^^^^^^^^^^^^^^\nErasure of method output(List) is the same as another method in type ErasureBug\n----------\n3. WARNING in ErasureBug.java (at line 7)\n\tpublic String output(List doubles) {\n\t                     ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n4. WARNING in ErasureBug.java (at line 10)\n\tpublic static void main(String[] args) { new ErasureBug().output(new ArrayList()); }\n\t                                                                 ^^^^^^^^^^^^^^^\nType safety: The expression of type ArrayList needs unchecked conversion to conform to List<String>\n----------\n5. WARNING in ErasureBug.java (at line 10)\n\tpublic static void main(String[] args) { new ErasureBug().output(new ArrayList()); }\n\t                                                                     ^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n";
        this.runNegativeTest(new String[]{"ErasureBug.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class ErasureBug {\n    public String output(List<String> integers) {\n\t\treturn \"1\";\n\t }\n    public String output(List doubles) {\n\t\treturn \"2\";\n\t }\n\t public static void main(String[] args) { new ErasureBug().output(new ArrayList()); }\n}\n"}, output);
    }

    public void test288658() {
        this.runConformTest(new String[]{"pkg/Test.java", "package pkg;\nimport java.lang.annotation.Annotation;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.reflect.Method;\n\npublic class Test extends Super {\n    public static void main(String[] args) {\n        try {\n            Method m = Test.class.getMethod(\"setFoo\", String.class);\n            Annotation a = m.getAnnotation(Anno.class);\n            System.out.println(\"Annotation was \" + (a == null ? \"not \" : \"\") +\n\"found\");\n        } catch (Exception e) {\n            e.printStackTrace();\n        }\n    }\n}\n\nclass Super {\n    @Anno\n    public void setFoo(String foo) {}\n}\n\n@Retention(RetentionPolicy.RUNTIME)\n@interface Anno {\n\n}\n"}, "Annotation was found");
    }

    public void test288658a() {
        this.runConformTest(new String[]{"pkg/Test.java", "package pkg;\nimport java.lang.annotation.Annotation;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.reflect.Method;\n\npublic class Test extends Super {\n    public void setFoo() {}\n    public static void main(String[] args) {\n        try {\n            Method m = Test.class.getMethod(\"setFoo\", String.class);\n            Annotation a = m.getAnnotation(Anno.class);\n            System.out.println(\"Annotation was \" + (a == null ? \"not \" : \"\") +\n\"found\");\n        } catch (Exception e) {\n            e.printStackTrace();\n        }\n    }\n}\n\nclass Super {\n    @Anno\n    public void setFoo(String foo) {}\n}\n\n@Retention(RetentionPolicy.RUNTIME)\n@interface Anno {\n\n}\n"}, "Annotation was found");
    }

    public void test354229() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\ninterface A {\nint get(List<String> l);\n}\ninterface B  {\nint get(List<Integer> l);\n}\ninterface C  extends A, B { \n//int get(List l);      // name clash error here\n    Zork z;\n}\n"}, this.complianceLevel <= 0x320000L ? "----------\n1. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. ERROR in X.java (at line 8)\n\tinterface C  extends A, B { \n\t          ^\nName clash: The method get(List<Integer>) of type B has the same erasure as get(List<String>) of type A but does not override it\n----------\n2. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test354229b() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.*;\ninterface A {\nint get(List<String> l);\n}\ninterface B  {\nint get(List<Integer> l);\n}\ninterface C  extends A, B { \n    int get(List l);      // name clash error here\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tint get(List l);      // name clash error here\n\t        ^^^^\nList is a raw type. References to generic type List<E> should be parameterized\n----------\n2. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test354229c() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n    <T> T e(Action<T> p);\n}\ninterface Y {\n    <S, T> S e(Action<S> t);\n}\ninterface E extends X, Y {\n}\nclass Action<T> {\n    Zork z;\n}\n"}, this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n" : "----------\n1. ERROR in X.java (at line 7)\n\tinterface E extends X, Y {\n\t          ^\nName clash: The method e(Action<S>) of type Y has the same erasure as e(Action<T>) of type X but does not override it\n----------\n2. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test354229d() {
        this.runNegativeTest(new String[]{"X.java", "interface X {\n    <T> T e(Action<T> p);\n    <S, T> S e(Action<S> t);\n}\nclass Action<T> {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<T> T e(Action<T> p);\n\t      ^^^^^^^^^^^^^^\nErasure of method e(Action<T>) is the same as another method in type X\n----------\n2. ERROR in X.java (at line 3)\n\t<S, T> S e(Action<S> t);\n\t         ^^^^^^^^^^^^^^\nErasure of method e(Action<S>) is the same as another method in type X\n----------\n");
    }

    public void testBug384580() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface X { <T> List<T> m(); }\ninterface Y<K> { List<K> m(); }\ninterface Z extends X, Y {}  \nclass Foo implements Z {\n\tpublic <T> List<T> m() {\n\t\treturn null;\n\t}\n\t\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tinterface Z extends X, Y {}  \n\t                       ^\nY is a raw type. References to generic type Y<K> should be parameterized\n----------\n2. ERROR in X.java (at line 5)\n\tclass Foo implements Z {\n\t      ^^^\nThe type Foo must implement the inherited abstract method Y.m()\n----------\n3. ERROR in X.java (at line 6)\n\tpublic <T> List<T> m() {\n\t                   ^^^\nName clash: The method m() of type Foo has the same erasure as m() of type Y but does not override it\n----------\n");
    }

    public void testBug406928() {
        if (this.complianceLevel < 0x320000L) {
            return;
        }
        this.runConformTest(new String[]{"TestPointcut.java", "interface MethodMatcher {\n\tboolean matches();\n}\nabstract class StaticMethodMatcher implements MethodMatcher { }\nabstract class StaticMethodMatcherPointcut extends StaticMethodMatcher { }\n\nclass TestPointcut extends StaticMethodMatcherPointcut {\n\t@Override\n\tpublic boolean matches() { return false; } \n}\n"}, "");
    }

    public void testBug409473() {
        this.runConformTest(new String[]{"Foo.java", "public abstract class Foo<E> implements java.util.List<E> { } "});
    }

    public void testBug410325() {
        this.runConformTest(new String[]{"Main.java", "public class Main {\n\tpublic static void main(String[] args) {\n\t\tF3 f3 = new F3();\n\t\tSubSub sub = new SubSub();\n\t\tsub.foo(f3);\n\n\t\tSub<F3> sub2 = sub;\n\t\tBase<F3> base = sub;\n\t\tsub2.foo(f3);\n\t\tbase.foo(f3);\n\n\t\tF2 f2 = new F2();\n\t\tsub2.foo(f2);\n\t}\n\n\tpublic static class F1 {\n\t}\n\n\tpublic static class F2 extends F1 {\n\t}\n\n\tpublic static class F3 extends F2 {\n\t\tpublic void bar() {\n\t\t\tSystem.out.println(\"bar in F3\");\n\t\t}\n\t}\n\n\tpublic static abstract class Base<T extends F1> {\n\t\tpublic abstract void foo(T bar);\n\t}\n\n\tpublic static abstract class Sub<T extends F2> extends Base<T> {\n\t\t@Override\n\t\tpublic void foo(F2 bar) {\n\t\t\tSystem.out.println(getClass().getSimpleName() + \": F2 + \"\n\t\t\t\t\t+ bar.getClass().getSimpleName());\n\t\t}\n\t}\n\n\tpublic static class SubSub extends Sub<F3> {\n\t}\n}"});
    }

    public void testBug411811() {
        this.runConformTest(new String[]{"FaultyType.java", "    class ParamType {}\n\n    abstract class AbstractType<T extends ParamType> {\n        public abstract void foo(T t);\n    }\n\n    abstract class SubAbstractType<T extends ParamType> extends AbstractType<T> {\n        @Override public void foo(ParamType t) {}\n    }\n\n    class SubParamType extends ParamType {}\n    \npublic class FaultyType extends SubAbstractType<SubParamType> {}"});
    }

    public void testBug415600() {
        this.runConformTest(new String[]{"A.java", "import java.io.Reader;\nimport java.io.StringReader;\n\npublic abstract class A<E extends Reader> {\n\tprotected abstract void create(E element);\n}\n\nabstract class B<T extends Reader> extends A<T> {\n\tpublic void create(Reader element) { }\n}\n\nclass C extends B<StringReader> { }\n"});
    }

    public void test423849() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\nimport java.nio.file.Path;\nimport java.nio.file.WatchEvent.Kind;\nimport java.nio.file.WatchEvent.Modifier;\nimport java.nio.file.WatchKey;\nimport java.nio.file.WatchService;\nabstract class Y implements Path {\n    public WatchKey register(WatchService watcher, Kind<?>[] events, Modifier... modifiers) throws IOException {\n        return null;\n    }\n}\npublic class X {\n    public static void main(String [] args) {\n        System.out.println(\"OK\");\n    }\n}\n"});
    }

    public void testBug426546() {
        this.runConformTest(new String[]{"C.java", "class A {\n   A getMe() { return null; }\n}\nclass B extends A {\n   B getMe() { return null; }\n}\npublic class C extends B {\n   C getMe() { return this; }\n   public String toString() { return \"C\"; }\n   public static void main(String[] args) {\n      C c = new C();\n      System.out.print(c.getMe());\n      B b = c;\n      System.out.print(b.getMe());\n      A a = c;\n      System.out.print(a.getMe()); \n   }\n}\n"}, "CCC");
    }

    public void testBug438812() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.util.Collection;\nimport java.util.List;\n\npublic interface A {\n    Iterable getIterable();\n}\n\nclass B implements A {\n    public Collection getIterable() { return null; }\n}\n\nclass C extends B {\n    public List getIterable() { return null; }\n}"}, "");
        String expectedOutput = "  public bridge synthetic java.lang.Iterable getIterable();";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "C.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            MethodVerifyTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void testBug469454() throws Exception {
        this.runConformTest(new String[]{"TestClass.java", "public class TestClass {\n    public static class A {\n        public static A method() {\n            return null;\n        }\n    }\n    public static class B extends A {\n        public static B method() {\n            return null;\n        }\n    }\n    public static void main(String[] args) {\n        System.out.println(B.class.getDeclaredMethods().length);\n    }\n}\n"}, "1");
    }

    public void testBug469454a() throws Exception {
        this.runNegativeTest(new String[]{"TestClass.java", "public class TestClass {\n    public static class A {\n        public final A method() {\n            return null;\n        }\n    }\n    public static class B extends A {\n        @Override\n        public B method() {\n            return null;\n        }\n    }\n    public static void main(String[] args) {\n        System.out.println(B.class.getDeclaredMethods().length);\n    }\n}\n"}, "----------\n1. ERROR in TestClass.java (at line 9)\n\tpublic B method() {\n\t         ^^^^^^^^\nCannot override the final method from TestClass.A\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "  public bridge synthetic TestClass.A method();";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "TestClass$B.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index != -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index != -1) {
            MethodVerifyTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void testBug438812a() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.util.Collection;\nimport java.util.List;\n\npublic abstract class A {\n    abstract Iterable getIterable();\n}\n\nclass B extends A {\n    public Collection getIterable() { return null; }\n}\n\nclass C extends B {\n    public List getIterable() { return null; }\n}"}, "");
        String expectedOutput = "  public bridge synthetic java.lang.Iterable getIterable();";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "C.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            MethodVerifyTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void testBug461529() throws Exception {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runConformTest(new String[]{"foo/IBarable.java", "package foo;\npublic interface IBarable<T extends IBarable<T>> {\n    default IBar<T> createBar() {\n        throw new UnsupportedOperationException();\n    }\n}\n", "foo/IBar.java", "package foo;\npublic interface IBar<T extends IBarable<T>> {\n    T bar();\n}\n", "foo/Foo.java", "package foo;\npublic abstract class Foo implements IBarable<Foo> {\n    public abstract static class Builder implements IBar<Foo> {}\n    @Override\n    public abstract Builder createBar();\n}\n", "foo/ChildFoo.java", "package foo;\npublic abstract class ChildFoo extends Foo {}\n"});
    }

    public void testBug467776_regression() {
        if (this.complianceLevel < 0x320000L) {
            return;
        }
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "error");
        this.runConformTest(new String[]{"ITeam.java", "public interface ITeam {\n        <T> T getRole(Object o, Class<T> clazz);\n}\n", "Team.java", "public class Team implements ITeam {\n\n        @Override\n        public <T> T getRole(Object o, Class<T> clazz) {\n                return null;\n        }\n}\n", "MyTeam.java", "public class MyTeam extends Team {\n        @Override\n        public <T> T getRole(Object o, Class<T> clazz) {\n                return super.getRole(o, clazz);\n        }\n}\n"}, compilerOptions);
    }

    public void testBug500673() {
        this.runNegativeTest(new String[]{"mfi.java", "interface mfi {\n    public transient void a(Throwable throwable);\n}\n", "mfa.java", "final class mfa implements mfi {\n}\n"}, "----------\n1. ERROR in mfi.java (at line 2)\n\tpublic transient void a(Throwable throwable);\n\t                      ^^^^^^^^^^^^^^^^^^^^^^\n" + (this.complianceLevel < 0x340000L ? "Illegal modifier for the interface method a; only public & abstract are permitted\n" : "Illegal modifier for the interface method a; only public, abstract, default, static and strictfp are permitted\n") + "----------\n" + "----------\n" + "1. ERROR in mfa.java (at line 1)\n" + "\tfinal class mfa implements mfi {\n" + "\t            ^^^\n" + "The type mfa must implement the inherited abstract method mfi.a(Throwable)\n" + "----------\n");
    }

    public void testBug506653() {
        this.runConformTest(false, new String[]{"A.java", "   public class A {\n    public class B {\n        <E extends Object, F extends E> E bar(F x) {\n            return null;\n        }\n    }\n    public class C extends B {\n\t\t @Override\n        public String bar(Object x) {\n            return \"Oops\";\n        }\n    }\n    public static void main(String... args) {\n        new A().test();\n    }\n    void test() {\n        B b = new C();\n\t\t try {\n        \tInteger i = b.bar(1);\n\t\t } catch (ClassCastException cce) {\n\t\t\tSystem.out.print(\"cce\");\n\t\t }\n    }\n   }\n"}, "----------\n1. WARNING in A.java (at line 9)\n\tpublic String bar(Object x) {\n\t       ^^^^^^\nType safety: The return type String for bar(Object) from the type A.C needs unchecked conversion to conform to E from the type A.B\n----------\n", "cce", "", AbstractRegressionTest.JavacTestOptions.DEFAULT);
    }
}

