/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class NonFatalErrorTest
extends AbstractRegressionTest {
    public NonFatalErrorTest(String name) {
        super(name);
    }

    public static Test suite() {
        return NonFatalErrorTest.buildAllCompliancesTestSuite(NonFatalErrorTest.testClass());
    }

    public static Class testClass() {
        return NonFatalErrorTest.class;
    }

    public void test001() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        this.runNegativeTest(true, new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\t\t public static void main(String argv[]) {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t }\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 1)\n\timport java.util.*;\n\t       ^^^^^^^^^\nThe import java.util is never used\n----------\n", "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test002() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        this.runNegativeTest(true, new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\t\t public static void main(String argv[]) {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t }\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 1)\n\timport java.util.*;\n\t       ^^^^^^^^^\nThe import java.util is never used\n----------\n", "", "java.lang.Error: Unresolved compilation problem: \n\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test003() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\t public static void main(String argv[]) {\n\t\t\t\t System.out.println(\"SUCCESS\");\n\t\t }\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(\"SUCCESS\");\n\t                   ^^^^^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test004() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\t public static void foo() {}\n\t\t public static void main(String argv[]) {\n\t\t\t\tfoo();\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t }\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void foo() {}\n\t                         ^^\nEmpty block should be documented\n----------\n", "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t\t public static void foo() {}\n\t\t public static void main(String argv[]) {\n\t\t\t\tfoo();\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t }\n}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\tpublic static void foo() {}\n\t                         ^^\nEmpty block should be documented\n----------\n", "", "java.lang.Error: Unresolved compilation problem: \n\tEmpty block should be documented\n\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test006() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "disabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\t{     }\n\tstatic {  }\n \tX() { }\n \tX(int a) {}\n \tpublic void foo() {}\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\t{     }\n\t^^^^^^^\nEmpty block should be documented\n----------\n2. ERROR in X.java (at line 3)\n\tstatic {  }\n\t       ^^^^\nEmpty block should be documented\n----------\n3. ERROR in X.java (at line 5)\n\tX(int a) {}\n\t         ^^\nEmpty block should be documented\n----------\n4. ERROR in X.java (at line 6)\n\tpublic void foo() {}\n\t                  ^^\nEmpty block should be documented\n----------\n", "SUCCESS", null, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test007() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedWarningToken", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n        @SuppressWarnings(\"unused\")\n        static void foo() {\n            String s = null;\n            System.out.println(\"SUCCESS\");\n        }\n        public static void main(String argv[]) {\n            foo();\n        }\n}"}, "SUCCESS", null, true, null, customOptions, null);
    }

    public void testImportUnresolved() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        this.runNegativeTest(true, new String[]{"X.java", "import com.bogus.Missing;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew X().test();\n\t}\n\tvoid test() {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, null, options, "----------\n1. ERROR in X.java (at line 1)\n\timport com.bogus.Missing;\n\t       ^^^^^^^^^\nThe import com.bogus cannot be resolved\n----------\n", "OK", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void testImportUnresolved_fatal() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.fatalOptionalError", "enabled");
        this.runNegativeTest(true, new String[]{"p/Z.java", "package p;\npublic class Z {\n\tpublic static void main(String[] args) throws Exception {\n\t\ttry {\n\t\t\tClass.forName(\"X\").newInstance();\n\t\t} catch (java.lang.Error e) {\n\t\t\tSystem.err.println(e.getMessage());\n\t\t}\n\t}\n}\n", "X.java", "import com.bogus.Missing;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew X().test();\n\t}\n\tvoid test() {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, null, options, "----------\n1. ERROR in X.java (at line 1)\n\timport com.bogus.Missing;\n\t       ^^^^^^^^^\nThe import com.bogus cannot be resolved\n----------\n", "", "Unresolved compilation problem: \n\tThe import com.bogus cannot be resolved", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void testPackageConflict() {
        this.runNegativeTest(true, new String[]{"p/z.java", "package p;\npublic class z {\n\tpublic static void main(String[] args) throws Exception {\n\t\ttry {\n\t\t\tClass.forName(\"p.z.X\").newInstance();\n\t\t} catch (ClassNotFoundException e) {\n\t\t\tSystem.out.println(e.getClass().getName());\n\t\t}\n\t}\n}\n", "p/z/X.java", "package p.z;\npublic class X {\n\tpublic X() {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, null, this.getCompilerOptions(), "----------\n1. ERROR in p\\z\\X.java (at line 1)\n\tpackage p.z;\n\t        ^^^\nThe package p.z collides with a type\n----------\n", "java.lang.ClassNotFoundException", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void testImportVariousProblems() {
        this.runNegativeTest(true, new String[]{"p/Z.java", "package p;\npublic class Z {\n\tpublic static void main(String[] args) throws Exception {\n\t\ttry {\n\t\t\tClass.forName(\"X\").newInstance();\n\t\t} catch (ClassNotFoundException e) {\n\t\t\tSystem.out.println(e.getClass().getName());\n\t\t}\n\t}\n}\n", "p1/Y.java", "package p1;\npublic class Y {}\n", "p2/Y.java", "package p2;\npublic class Y {}\n", "X.java", "import java.util;\nimport p.Z;\nimport p1.Y;\nimport p2.Y;\npublic class X {\n\tpublic X() {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\nclass Z {}\n"}, null, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 1)\n\timport java.util;\n\t       ^^^^^^^^^\nOnly a type can be imported. java.util resolves to a package\n----------\n2. ERROR in X.java (at line 2)\n\timport p.Z;\n\t       ^^^\nThe import p.Z conflicts with a type defined in the same file\n----------\n3. ERROR in X.java (at line 4)\n\timport p2.Y;\n\t       ^^^^\nThe import p2.Y collides with another import statement\n----------\n", "OK", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void testImportStaticProblems() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runNegativeTest(true, new String[]{"p/Z.java", "package p;\npublic class Z {\n\tpublic static void main(String[] args) throws Exception {\n\t\ttry {\n\t\t\tClass.forName(\"X\").newInstance();\n\t\t} catch (ClassNotFoundException e) {\n\t\t\tSystem.out.println(e.getClass().getName());\n\t\t}\n\t}\n}\n", "p1/Y.java", "package p1;\npublic class Y {\n\tstatic int f;\n}\n", "X.java", "import static p1.Y;\nimport static p1.Y.f;\npublic class X {\n\tpublic X() {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\nclass Z {}\n"}, null, this.getCompilerOptions(), "----------\n1. ERROR in X.java (at line 1)\n\timport static p1.Y;\n\t              ^^^^\nThe static import p1.Y must be a field or member type\n----------\n2. ERROR in X.java (at line 2)\n\timport static p1.Y.f;\n\t              ^^^^^^\nThe field Y.p1.Y.f is not visible\n----------\n", "OK", "", AbstractRegressionTest.JavacTestOptions.SKIP);
    }
}

