/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.osgi.framework.Bundle;

public class NullReferenceTestAsserts
extends AbstractRegressionTest {
    String[] assertLib = null;
    static final String JUNIT_ASSERT_NAME = "junit/framework/Assert.java";
    static final String JUNIT_ASSERT_CONTENT = "package junit.framework;\npublic class Assert {\n    static public void assertNull(Object object) {}\n    static public void assertNull(String message, Object object) {}\n    static public void assertNotNull(Object object) {}\n    static public void assertNotNull(String message, Object object) {}\n    static public void assertTrue(boolean expression) {}\n    static public void assertTrue(String message, boolean expression) {}\n    static public void assertFalse(boolean expression) {}\n    static public void assertFalse(String message, boolean expression) {}\n}\n";
    static final String ORG_JUNIT_ASSERT_NAME = "org/junit/Assert.java";
    static final String ORG_JUNIT_ASSERT_CONTENT = "package org.junit;\npublic class Assert {\n    static public void assertNull(Object object) {}\n    static public void assertNull(String message, Object object) {}\n    static public void assertNotNull(Object object) {}\n    static public void assertNotNull(String message, Object object) {}\n    static public void assertTrue(boolean expression) {}\n    static public void assertTrue(String message, boolean expression) {}\n    static public void assertFalse(boolean expression) {}\n    static public void assertFalse(String message, boolean expression) {}\n}\n";
    static final String APACHE_VALIDATE_NAME = "org/apache/commons/lang/Validate.java";
    static final String APACHE_VALIDATE_CONTENT = "package org.apache.commons.lang;\npublic class Validate {\n    static public void notNull(Object object) {}\n    static public void notNull(Object object, String message) {}\n    static public void isTrue(boolean expression) {}\n    static public void isTrue(boolean expression, String message) {}\n    static public void isTrue(boolean expression, String message, double value) {}\n    static public void isTrue(boolean expression, String message, long value) {}\n    static public void isTrue(boolean expression, String message, Object value) {}\n}\n";
    static final String APACHE_3_VALIDATE_NAME = "org/apache/commons/lang3/Validate.java";
    static final String APACHE_3_VALIDATE_CONTENT = "package org.apache.commons.lang3;\npublic class Validate {\n    static public <T> T notNull(T object) { return object; }\n    static public <T> T notNull(T object, String message, Object... values) { return object; }\n    static public void isTrue(boolean expression) {}\n    static public void isTrue(boolean expression, String message, double value) {}\n    static public void isTrue(boolean expression, String message, long value) {}\n    static public void isTrue(boolean expression, String message, Object value) {}\n}\n";
    static final String GOOGLE_PRECONDITIONS_NAME = "com/google/common/base/Preconditions.java";
    static final String GOOGLE_PRECONDITIONS_CONTENT = "package com.google.common.base;\npublic class Preconditions {\n    static public <T> T checkNotNull(T object) { return object; }\n    static public <T> T checkNotNull(T object, Object message) { return object; }\n    static public <T> T checkNotNull(T object, String message, Object... values) { return object; }\n    static public void checkArgument(boolean expression) {}\n    static public void checkArgument(boolean expression, Object message) {}\n    static public void checkArgument(boolean expression, String msgTmpl, Object... messageArgs) {}\n    static public void checkState(boolean expression) {}\n    static public void checkState(boolean expression, Object message) {}\n    static public void checkState(boolean expression, String msgTmpl, Object... messageArgs) {}\n}\n";
    static boolean setNullRelatedOptions = true;

    public NullReferenceTestAsserts(String name) {
        super(name);
    }

    public static Test suite() {
        return NullReferenceTestAsserts.buildAllCompliancesTestSuite(NullReferenceTestAsserts.testClass());
    }

    public static Class testClass() {
        return NullReferenceTestAsserts.class;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (this.assertLib == null) {
            String[] defaultLibs = this.getDefaultClassPaths();
            int len = defaultLibs.length;
            this.assertLib = new String[len + 1];
            System.arraycopy(defaultLibs, 0, this.assertLib, 0, len);
            File bundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"org.eclipse.equinox.common"));
            this.assertLib[len] = bundleFile.isDirectory() ? String.valueOf(bundleFile.getPath()) + "/bin" : bundleFile.getPath();
        }
    }

    @Override
    protected Map getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        if (setNullRelatedOptions) {
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.includeNullInfoFromAsserts", "enabled");
        }
        return defaultOptions;
    }

    public void testBug127575a() throws IOException {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo(Object o) {\n    boolean b = o != null;\n    org.eclipse.core.runtime.Assert.isLegal(o != null);\n    o.toString();\n  }\n}\n"}, "", this.assertLib, true, null);
    }

    public void testBug127575b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(Object o) {\n    org.eclipse.core.runtime.Assert.isLegal(o == null);\n    o.toString();\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\to.toString();\n\t^\nNull pointer access: The variable o can only be null at this location\n----------\n", this.assertLib, true);
    }

    public void testBug127575c() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(Object o, boolean b) {\n    org.eclipse.core.runtime.Assert.isLegal(o != null || b, \"FAIL\");\n    o.toString();\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\to.toString();\n\t^\nPotential null pointer access: The variable o may be null at this location\n----------\n", this.assertLib, true);
    }

    public void testBug127575d() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(Object o1, Object o2) {\n    org.eclipse.core.runtime.Assert.isLegal(o1 != null && o2 == null);\n    if (o1 == null) { };\n    if (o2 == null) { };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (o1 == null) { };\n\t    ^^\nNull comparison always yields false: The variable o1 cannot be null at this location\n----------\n2. WARNING in X.java (at line 4)\n\tif (o1 == null) { };\n\t                ^^^\nDead code\n----------\n3. ERROR in X.java (at line 5)\n\tif (o2 == null) { };\n\t    ^^\nRedundant null check: The variable o2 can only be null at this location\n----------\n", this.assertLib, true);
    }

    public void testBug127575e() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(Object o) {\n    org.eclipse.core.runtime.Assert.isLegal(false && o != null);\n    if (o == null) { };\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\torg.eclipse.core.runtime.Assert.isLegal(false && o != null);\n\t                                                 ^^^^^^^^^\nDead code\n----------\n", this.assertLib, true);
    }

    public void testBug127575e_1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(Object o) {\n\t o = null;\n    org.eclipse.core.runtime.Assert.isLegal(false && o != null);\n    if (o == null) { };\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\torg.eclipse.core.runtime.Assert.isLegal(false && o != null);\n\t                                                 ^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 5)\n\tif (o == null) { };\n\t    ^\nRedundant null check: The variable o can only be null at this location\n----------\n", this.assertLib, true);
    }

    public void testBug127575e_2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(Object o) {\n    org.eclipse.core.runtime.Assert.isLegal(true || o != null);\n    if (o == null) { };\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\torg.eclipse.core.runtime.Assert.isLegal(true || o != null);\n\t                                                ^^^^^^^^^\nDead code\n----------\n", this.assertLib, true);
    }

    public void testBug127575f() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(Object o) {\n    org.eclipse.core.runtime.Assert.isLegal(false || o != null);\n    if (o == null) { };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (o == null) { };\n\t    ^\nNull comparison always yields false: The variable o cannot be null at this location\n----------\n2. WARNING in X.java (at line 4)\n\tif (o == null) { };\n\t               ^^^\nDead code\n----------\n", this.assertLib, true);
    }

    public void testBug127575g() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo() {\n    Object o = null;\n    org.eclipse.core.runtime.Assert.isLegal(o != null);\n    if (o == null) { };\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\torg.eclipse.core.runtime.Assert.isLegal(o != null);\n\t                                        ^\nNull comparison always yields false: The variable o can only be null at this location\n----------\n2. ERROR in X.java (at line 5)\n\tif (o == null) { };\n\t    ^\nNull comparison always yields false: The variable o cannot be null at this location\n----------\n3. WARNING in X.java (at line 5)\n\tif (o == null) { };\n\t               ^^^\nDead code\n----------\n", this.assertLib, true);
    }

    public void testBug127575h() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void m() {\n    X foo = new X();\n\t org.eclipse.core.runtime.Assert.isLegal (foo != null);\n\t if (foo == null) {}\n    X foo2 = new X();\n\t org.eclipse.core.runtime.Assert.isLegal (foo2 == null);\n\t if (foo2 == null) {}\n    X bar = null;\n\t org.eclipse.core.runtime.Assert.isLegal (bar == null);\n\t if (bar == null) {}\n    X bar2 = null;\n\t org.eclipse.core.runtime.Assert.isLegal (bar2 != null);\n\t if (bar2 == null) {}\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tif (foo == null) {}\n\t    ^^^\nNull comparison always yields false: The variable foo cannot be null at this location\n----------\n2. WARNING in X.java (at line 5)\n\tif (foo == null) {}\n\t                 ^^\nDead code\n----------\n3. ERROR in X.java (at line 7)\n\torg.eclipse.core.runtime.Assert.isLegal (foo2 == null);\n\t                                         ^^^^\nNull comparison always yields false: The variable foo2 cannot be null at this location\n----------\n4. ERROR in X.java (at line 8)\n\tif (foo2 == null) {}\n\t    ^^^^\nRedundant null check: The variable foo2 can only be null at this location\n----------\n5. ERROR in X.java (at line 11)\n\tif (bar == null) {}\n\t    ^^^\nRedundant null check: The variable bar can only be null at this location\n----------\n6. ERROR in X.java (at line 13)\n\torg.eclipse.core.runtime.Assert.isLegal (bar2 != null);\n\t                                         ^^^^\nNull comparison always yields false: The variable bar2 can only be null at this location\n----------\n7. ERROR in X.java (at line 14)\n\tif (bar2 == null) {}\n\t    ^^^^\nNull comparison always yields false: The variable bar2 cannot be null at this location\n----------\n8. WARNING in X.java (at line 14)\n\tif (bar2 == null) {}\n\t                  ^^\nDead code\n----------\n", this.assertLib, true);
    }

    public void testBug127575i() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void m() {\n\t X bar = null;\n    X foo = getX();\n    if (foo == null) {\n\t \tfoo = new X();\n\t }\n\t org.eclipse.core.runtime.Assert.isTrue (foo != null && bar == null);\n\t if (foo != null) {}\n\t if (bar == null) {}\n  }\n  public X getX() { return new X();}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tif (foo != null) {}\n\t    ^^^\nRedundant null check: The variable foo cannot be null at this location\n----------\n2. ERROR in X.java (at line 10)\n\tif (bar == null) {}\n\t    ^^^\nRedundant null check: The variable bar can only be null at this location\n----------\n", this.assertLib, true);
    }

    public void testBug127575j() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void m() {\n    X foo = new X();\n    X foo2 = new X();\n    X bar = null;\n    X bar2 = null;\n\t while (true) {\n\t \torg.eclipse.core.runtime.Assert.isLegal (foo != null);\n\t \tif (foo == null) {}\n\t \torg.eclipse.core.runtime.Assert.isLegal (foo2 == null);\n\t \tif (foo2 == null) {}\n\t \torg.eclipse.core.runtime.Assert.isLegal (bar == null);\n\t \tif (bar == null) {}\n\t \torg.eclipse.core.runtime.Assert.isLegal (bar2 != null);\n\t \tif (bar2 == null) {}\n\t }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tif (foo == null) {}\n\t    ^^^\nNull comparison always yields false: The variable foo cannot be null at this location\n----------\n2. WARNING in X.java (at line 9)\n\tif (foo == null) {}\n\t                 ^^\nDead code\n----------\n3. ERROR in X.java (at line 10)\n\torg.eclipse.core.runtime.Assert.isLegal (foo2 == null);\n\t                                         ^^^^\nNull comparison always yields false: The variable foo2 cannot be null at this location\n----------\n4. ERROR in X.java (at line 11)\n\tif (foo2 == null) {}\n\t    ^^^^\nRedundant null check: The variable foo2 can only be null at this location\n----------\n5. ERROR in X.java (at line 13)\n\tif (bar == null) {}\n\t    ^^^\nRedundant null check: The variable bar can only be null at this location\n----------\n6. ERROR in X.java (at line 14)\n\torg.eclipse.core.runtime.Assert.isLegal (bar2 != null);\n\t                                         ^^^^\nNull comparison always yields false: The variable bar2 can only be null at this location\n----------\n7. ERROR in X.java (at line 15)\n\tif (bar2 == null) {}\n\t    ^^^^\nNull comparison always yields false: The variable bar2 cannot be null at this location\n----------\n8. WARNING in X.java (at line 15)\n\tif (bar2 == null) {}\n\t                  ^^\nDead code\n----------\n", this.assertLib, true);
    }

    public void testBug127575k() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void m() {\n    X foo = new X();\n    X foo2 = new X();\n    X bar = null;\n    X bar2 = null;\n\t try {\n\t\tSystem.out.println(\"Inside try\");\n\t }\n\t finally {\n\t \torg.eclipse.core.runtime.Assert.isLegal (foo != null);\n\t \tif (foo == null) {}\n\t \torg.eclipse.core.runtime.Assert.isLegal (foo2 == null);\n\t \tif (foo2 == null) {}\n\t \torg.eclipse.core.runtime.Assert.isLegal (bar == null);\n\t \tif (bar == null) {}\n\t \torg.eclipse.core.runtime.Assert.isLegal (bar2 != null);\n\t \tif (bar2 == null) {}\n\t }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tif (foo == null) {}\n\t    ^^^\nNull comparison always yields false: The variable foo cannot be null at this location\n----------\n2. WARNING in X.java (at line 12)\n\tif (foo == null) {}\n\t                 ^^\nDead code\n----------\n3. ERROR in X.java (at line 13)\n\torg.eclipse.core.runtime.Assert.isLegal (foo2 == null);\n\t                                         ^^^^\nNull comparison always yields false: The variable foo2 cannot be null at this location\n----------\n4. ERROR in X.java (at line 14)\n\tif (foo2 == null) {}\n\t    ^^^^\nRedundant null check: The variable foo2 can only be null at this location\n----------\n5. ERROR in X.java (at line 16)\n\tif (bar == null) {}\n\t    ^^^\nRedundant null check: The variable bar can only be null at this location\n----------\n6. ERROR in X.java (at line 17)\n\torg.eclipse.core.runtime.Assert.isLegal (bar2 != null);\n\t                                         ^^^^\nNull comparison always yields false: The variable bar2 can only be null at this location\n----------\n7. ERROR in X.java (at line 18)\n\tif (bar2 == null) {}\n\t    ^^^^\nNull comparison always yields false: The variable bar2 cannot be null at this location\n----------\n8. WARNING in X.java (at line 18)\n\tif (bar2 == null) {}\n\t                  ^^\nDead code\n----------\n", this.assertLib, true);
    }

    public void testBug127575l() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n\tvoid foo(Object a, Object b, Object c) {\n\t\torg.eclipse.core.runtime.Assert.isLegal( a == null);\n \t\tif (a!=null) {\n\t\t\tSystem.out.println(\"a is not null\");\n\t\t } else{\n\t\t\tSystem.out.println(\"a is null\");\n\t\t }\n\t\ta = null;\n\t\tif (a== null) {}\n\t\torg.eclipse.core.runtime.Assert.isLegal(b != null);\n \t\tif (b!=null) {\n\t\t\tSystem.out.println(\"b is not null\");\n\t\t } else{\n\t\t\tSystem.out.println(\"b is null\");\n\t\t }\n\t\torg.eclipse.core.runtime.Assert.isLegal(c == null);\n\t\tif (c.equals(a)) {\n\t\t\tSystem.out.println(\"\");\n\t\t } else{\n\t\t\tSystem.out.println(\"\");\n\t\t }\n\t}\n\tpublic static void main(String[] args){\n\t\tTest test = new Test();\n\t\ttest.foo(null,null, null);\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 4)\n\tif (a!=null) {\n\t    ^\nNull comparison always yields false: The variable a can only be null at this location\n----------\n2. WARNING in Test.java (at line 4)\n\tif (a!=null) {\n\t\t\tSystem.out.println(\"a is not null\");\n\t\t } else{\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n3. ERROR in Test.java (at line 9)\n\ta = null;\n\t^\nRedundant assignment: The variable a can only be null at this location\n----------\n4. ERROR in Test.java (at line 10)\n\tif (a== null) {}\n\t    ^\nRedundant null check: The variable a can only be null at this location\n----------\n5. ERROR in Test.java (at line 12)\n\tif (b!=null) {\n\t    ^\nRedundant null check: The variable b cannot be null at this location\n----------\n6. WARNING in Test.java (at line 14)\n\t} else{\n\t\t\tSystem.out.println(\"b is null\");\n\t\t }\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n7. ERROR in Test.java (at line 18)\n\tif (c.equals(a)) {\n\t    ^\nNull pointer access: The variable c can only be null at this location\n----------\n", this.assertLib, true);
    }

    public void testBug127575m() {
        if (this.complianceLevel >= 0x310000L) {
            this.runNegativeTest(new String[]{"Info.java", "public class Info {\n\tpublic void test(Info[] infos) {\n\t\tfor (final Info info : infos) {\n \t\t\tif (info != null) {\n\t\t\t\torg.eclipse.core.runtime.Assert.isLegal( info.checkSomething());\n\t\t \t\tinfo.doSomething();\n\t\t\t}\n\t\t }\n\t\tfor (final Info info : infos) {\n \t\t\tif (info == null) {\n\t\t\t\torg.eclipse.core.runtime.Assert.isLegal(info.checkSomething());\n\t\t \t\tinfo.doSomething();\n\t\t\t}\n\t\t }\n\t}\n\tvoid doSomething()  {}\n\tboolean checkSomething() {return true;}\n}\n"}, "----------\n1. ERROR in Info.java (at line 11)\n\torg.eclipse.core.runtime.Assert.isLegal(info.checkSomething());\n\t                                        ^^^^\nNull pointer access: The variable info can only be null at this location\n----------\n", this.assertLib, true);
        }
    }

    public void testBug127575n() {
        if (this.complianceLevel >= 0x310000L) {
            this.runNegativeTest(new String[]{"DoWhileBug.java", "public class DoWhileBug {\n\tvoid test(boolean b1) {\n\t\tObject o1 = null;\n\t\tObject o2 = null;\n\t\tdo {\n           if (b1)\n\t\t\t\to1 = null;\n           org.eclipse.core.runtime.Assert.isLegal (o1 != null);\n\t\t} while (true);\n\t}\n}"}, "----------\n1. ERROR in DoWhileBug.java (at line 7)\n\to1 = null;\n\t^^\nRedundant assignment: The variable o1 can only be null at this location\n----------\n2. ERROR in DoWhileBug.java (at line 8)\n\torg.eclipse.core.runtime.Assert.isLegal (o1 != null);\n\t                                         ^^\nNull comparison always yields false: The variable o1 can only be null at this location\n----------\n", this.assertLib, true);
        }
    }

    public void testBug127575o() {
        if (this.complianceLevel >= 0x310000L) {
            this.runNegativeTest(new String[]{"DoWhileBug.java", "public class DoWhileBug {\n\tvoid test(boolean b1) {\n\t\tObject o1 = null;\n\t\tObject o2 = null;\n\t\tdo {\n           if (b1)\n\t\t\t\to1 = null;\n           org.eclipse.core.runtime.Assert.isLegal ((o2 = o1) == null);\n\t\t} while (true);\n\t}\n}"}, "----------\n1. ERROR in DoWhileBug.java (at line 7)\n\to1 = null;\n\t^^\nRedundant assignment: The variable o1 can only be null at this location\n----------\n", this.assertLib, true);
        }
    }

    public void testBug373953() throws IOException {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(Object o) {\n    boolean b = o != null;\n    java.eclipse.core.runtime.Assert.isLegal(o != null);\n    o.toString();\n  }\n  void foo1(Object o) {\n    boolean b = o != null;\n    org.lang.core.runtime.Assert.isLegal(o != null);\n    o.toString();\n  }\n}\n", "java.eclipse.core.runtime/Assert.java", "package java.eclipse.core.runtime;\npublic class Assert {\n  public static void isLegal(boolean b) {\n  }\n}\n", "org.lang.core.runtime/Assert.java", "package org.lang.core.runtime;\npublic class Assert {\n  public static void isLegal(boolean b) {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\to.toString();\n\t^\nPotential null pointer access: The variable o may be null at this location\n----------\n2. ERROR in X.java (at line 10)\n\to.toString();\n\t^\nPotential null pointer access: The variable o may be null at this location\n----------\n");
    }

    public void testBug382069a() throws IOException {
        this.runConformTest(new String[]{JUNIT_ASSERT_NAME, JUNIT_ASSERT_CONTENT, "X.java", "public class X {\n  void foo(Object o1, String o2) {\n    boolean b = o1 != null;\n    junit.framework.Assert.assertNotNull(o1);\n    o1.toString();\n    b = o2 != null;\n    junit.framework.Assert.assertNotNull(\"msg\", o2);\n    o2.toString();\n  }\n}\n"}, "");
    }

    public void testBug382069b() {
        if (this.complianceLevel >= 0x310000L) {
            this.runConformTest(new String[]{"X.java", "public class X {\n  void foo(Object o1, String o2) {\n    boolean b = o1 != null;\n    org.eclipse.core.runtime.Assert.isNotNull(o1);\n    o1.toString();\n    b = o2 != null;\n    org.eclipse.core.runtime.Assert.isNotNull(o2, \"msg\");\n    o2.toString();\n  }\n}"}, "", this.assertLib, true, null);
        }
    }

    public void testBug382069c() throws IOException {
        this.runNegativeTest(new String[]{JUNIT_ASSERT_NAME, JUNIT_ASSERT_CONTENT, "X.java", "public class X {\n  boolean foo(String o1, String o2) {\n    junit.framework.Assert.assertNull(\"something's wrong\", o1);\n    if (o2 == null)\n        return o1 != null;\n    junit.framework.Assert.assertNull(o2);\n    return false; // dead code\n  }\n  void bar(X x) {\n    if (x == null) {\n      junit.framework.Assert.assertNotNull(x);\n      return; // dead code\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn o1 != null;\n\t       ^^\nNull comparison always yields false: The variable o1 can only be null at this location\n----------\n2. WARNING in X.java (at line 7)\n\treturn false; // dead code\n\t^^^^^^^^^^^^^\nDead code\n----------\n3. WARNING in X.java (at line 12)\n\treturn; // dead code\n\t^^^^^^^\nDead code\n----------\n");
    }

    public void testBug382069d() throws IOException {
        this.runNegativeTest(new String[]{APACHE_VALIDATE_NAME, APACHE_VALIDATE_CONTENT, "X.java", "import org.apache.commons.lang.Validate;\npublic class X {\n  void foo(Object o1, String o2, X x) {\n    boolean b = o1 != null;\n    Validate.notNull(o1);\n    o1.toString();\n    b = o2 != null;\n    Validate.notNull(o2, \"msg\");\n    o2.toString();\n    Validate.isTrue(x == null, \"ups\", x);\n    x.foo(null, null, null); // definite NPE\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tx.foo(null, null, null); // definite NPE\n\t^\nNull pointer access: The variable x can only be null at this location\n----------\n");
    }

    public void testBug382069e() throws IOException {
        if (this.complianceLevel >= 0x310000L) {
            this.runNegativeTest(new String[]{APACHE_3_VALIDATE_NAME, APACHE_3_VALIDATE_CONTENT, "X.java", "import org.apache.commons.lang3.Validate;\npublic class X {\n  void foo(Object o1, String o2, X x) {\n    boolean b = o1 != null;\n    Validate.notNull(o1);\n    o1.toString();\n    b = o2 != null;\n    Validate.notNull(o2, \"msg\");\n    o2.toString();\n    Validate.isTrue(x == null, \"ups\", x);\n    x.foo(null, null, null); // definite NPE\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tx.foo(null, null, null); // definite NPE\n\t^\nNull pointer access: The variable x can only be null at this location\n----------\n");
        }
    }

    public void testBug382069f() throws IOException {
        if (this.complianceLevel >= 0x310000L) {
            this.runNegativeTest(new String[]{GOOGLE_PRECONDITIONS_NAME, GOOGLE_PRECONDITIONS_CONTENT, "X.java", "import com.google.common.base.Preconditions;\npublic class X {\n  void foo(Object o1, String o2, X x) {\n    boolean b = o1 != null;\n    Preconditions.checkNotNull(o1);\n    o1.toString();\n    b = o2 != null;\n    Preconditions.checkNotNull(o2, \"msg {0}.{1}\", o1, o2);\n    o2.toString();\n    Preconditions.checkArgument(x == null, \"ups\");\n    x.foo(null, null, null); // definite NPE\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tx.foo(null, null, null); // definite NPE\n\t^\nNull pointer access: The variable x can only be null at this location\n----------\n");
        }
    }

    public void testBug382069g() throws IOException {
        if (this.complianceLevel >= 0x330000L) {
            this.runConformTest(new String[]{"X.java", "import static java.util.Objects.requireNonNull;\npublic class X {\n  void foo(Object o1, String o2, X x) {\n    boolean b = o1 != null;\n    requireNonNull(o1);\n    o1.toString();\n    b = o2 != null;\n    requireNonNull(o2, \"msg\");\n    o2.toString();\n  }\n}\n"}, "");
        }
    }

    public void testBug382069h() throws IOException {
        this.runConformTest(new String[]{JUNIT_ASSERT_NAME, JUNIT_ASSERT_CONTENT, "X.java", "public class X {\n  void foo(Object o1, String o2) {\n    boolean b = o1 != null;\n    junit.framework.Assert.assertTrue(o1 != null);\n    o1.toString();\n    b = o2 != null;\n    junit.framework.Assert.assertFalse(\"msg\", o2 == null);\n    o2.toString();\n  }\n}\n"}, "");
    }

    public void testBug401159() throws IOException {
        this.runNegativeTest(new String[]{ORG_JUNIT_ASSERT_NAME, ORG_JUNIT_ASSERT_CONTENT, "X.java", "import org.junit.Assert;\npublic class X {\n  void foo(Object o1, String o2, X x) {\n    boolean b = o1 != null;\n    Assert.assertNotNull(o1);\n    o1.toString();\n    b = o2 != null;\n    Assert.assertNotNull(\"msg\", o2);\n    o2.toString();\n    Assert.assertTrue(\"ups\", x == null);\n    x.foo(null, null, null); // definite NPE\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tx.foo(null, null, null); // definite NPE\n\t^\nNull pointer access: The variable x can only be null at this location\n----------\n");
    }

    public void testBug472618() throws IOException {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{JUNIT_ASSERT_NAME, JUNIT_ASSERT_CONTENT, "AssertionTest.java", "import junit.framework.Assert;\n\npublic class AssertionTest extends Assert\n{\n    void test()\n    {\n        Long test = null;\n\n        if(Boolean.TRUE)\n        {\n            test = 0L;\n        }\n\n        assertNotNull(test);\n\n        test.longValue();  // <- potential null pointer access\n    }\n}\n"}, "");
    }
}

