/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.core.INameEnvironmentWithProgress;

public class PackageBindingTest
extends AbstractCompilerTest {
    public PackageBindingTest(String name) {
        super(name);
    }

    public void _test01() {
        NameEnvironmentDummy nameEnv = new NameEnvironmentDummy(true);
        PackageBinding packageBinding = new PackageBinding(new LookupEnvironment(null, new CompilerOptions(), null, (INameEnvironment)nameEnv));
        Binding resultBinding = packageBinding.getTypeOrPackage("java.lang".toCharArray());
        PackageBindingTest.assertNotNull((Object)resultBinding);
        PackageBindingTest.assertTrue((boolean)nameEnv.isPackageSearchExecuted);
        PackageBindingTest.assertFalse((boolean)nameEnv.isTypeSearchExecuted);
    }

    public void test02() {
        NameEnvironmentDummy nameEnv = new NameEnvironmentDummy(false);
        PackageBinding packageBinding = new PackageBinding(new LookupEnvironment(null, new CompilerOptions(), null, (INameEnvironment)nameEnv));
        Binding resultBinding = packageBinding.getTypeOrPackage("java.lang.String".toCharArray());
        PackageBindingTest.assertNull((Object)resultBinding);
        PackageBindingTest.assertTrue((boolean)nameEnv.isPackageSearchExecuted);
        PackageBindingTest.assertTrue((boolean)nameEnv.isTypeSearchExecuted);
    }

    public void test03() {
        NameEnvironmentDummy nameEnv = new NameEnvironmentDummy(false);
        LookupEnvironment lookupEnv = new LookupEnvironment(null, new CompilerOptions(), null, (INameEnvironment)nameEnv);
        PackageBinding packageBinding = lookupEnv.createPackage((char[][])new char[][]{"org/eclipse/jdt".toCharArray(), "org/eclipse/jdt/internal".toCharArray()});
        PackageBindingTest.assertNotNull((Object)packageBinding);
        PackageBindingTest.assertTrue((boolean)nameEnv.isTypeSearchExecuted);
    }

    public void test04() {
        NameEnvironmentWithProgressDummy nameEnvWithProgress = new NameEnvironmentWithProgressDummy();
        LookupEnvironment lookupEnv = new LookupEnvironment(null, new CompilerOptions(), null, (INameEnvironment)nameEnvWithProgress);
        PackageBinding packageBinding = lookupEnv.createPackage((char[][])new char[][]{"org/eclipse/jdt".toCharArray(), "org/eclipse/jdt/internal".toCharArray()});
        PackageBindingTest.assertNotNull((Object)packageBinding);
        PackageBindingTest.assertTrue((boolean)nameEnvWithProgress.isTypeSearchExecutedWithSearchWithSecondaryTypes);
        PackageBindingTest.assertFalse((boolean)nameEnvWithProgress.isTypeSearchWithSearchWithSecondaryTypes);
    }

    private class NameEnvironmentDummy
    implements INameEnvironment {
        private final boolean isPackage;
        boolean isPackageSearchExecuted;
        boolean isTypeSearchExecuted;

        NameEnvironmentDummy(boolean isPackage) {
            this.isPackage = isPackage;
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            this.isTypeSearchExecuted = true;
            return null;
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            this.isTypeSearchExecuted = true;
            return null;
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            this.isPackageSearchExecuted = true;
            return this.isPackage;
        }

        public void cleanup() {
        }
    }

    private class NameEnvironmentWithProgressDummy
    implements INameEnvironmentWithProgress {
        boolean isTypeSearchWithSearchWithSecondaryTypes;
        boolean isTypeSearchExecutedWithSearchWithSecondaryTypes;

        NameEnvironmentWithProgressDummy() {
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            return null;
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            return null;
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            return false;
        }

        public void cleanup() {
        }

        public void setMonitor(IProgressMonitor monitor) {
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, boolean searchWithSecondaryTypes) {
            this.isTypeSearchExecutedWithSearchWithSecondaryTypes = true;
            this.isTypeSearchWithSearchWithSecondaryTypes = searchWithSecondaryTypes;
            return null;
        }
    }
}

