/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.util.Util;

public class StackMapAttributeTest
extends AbstractRegressionTest {
    public StackMapAttributeTest(String name) {
        super(name);
    }

    public static Class testClass() {
        return StackMapAttributeTest.class;
    }

    public static Test suite() {
        return StackMapAttributeTest.buildMinimalComplianceTestSuite(StackMapAttributeTest.testClass(), 8);
    }

    public void test001() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX() {}\n\tX(double i) {\n\t\tthis(i > 0 ? null : new Object());\n\t\ttry {\n\t\t\tfoo(6, false);\n\t\t} catch(Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\tX(Object o) {}\n\tint foo(int i, boolean b) {\n\t\ttry {\n\t\t\tif (b) {\n\t\t\t\treturn i;\n\t\t\t}\n\t\t\treturn i + 1;\n\t\t} catch(Exception e) {\n\t\t\treturn 5;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(2, false);\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #14 (D)V\n  // Stack: 5, Locals: 4\n  X(double i);\n     0  aload_0 [this]\n     1  dload_1 [i]\n     2  dconst_0\n     3  dcmpl\n     4  ifle 11\n     7  aconst_null\n     8  goto 18\n    11  new java.lang.Object [3]\n    14  dup\n    15  invokespecial java.lang.Object() [8]\n    18  invokespecial X(java.lang.Object) [15]\n    21  aload_0 [this]\n    22  bipush 6\n    24  iconst_0\n    25  invokevirtual X.foo(int, boolean) : int [18]\n    28  pop\n    29  goto 37\n    32  astore_3 [e]\n    33  aload_3 [e]\n    34  invokevirtual java.lang.Exception.printStackTrace() : void [22]\n    37  return\n      Exception Table:\n        [pc: 21, pc: 29] -> 32 when : java.lang.Exception\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 21, line: 6]\n        [pc: 29, line: 7]\n        [pc: 33, line: 8]\n        [pc: 37, line: 10]\n      Local variable table:\n        [pc: 0, pc: 38] local: this index: 0 type: X\n        [pc: 0, pc: 38] local: i index: 1 type: double\n        [pc: 33, pc: 37] local: e index: 3 type: java.lang.Exception\n      Stack map table: number of frames 4\n        [pc: 11, same_locals_1_stack_item, stack: {uninitialized_this}]\n        [pc: 18, full, stack: {uninitialized_this, java.lang.Object}, locals: {uninitialized_this, double}]\n        [pc: 32, full, stack: {java.lang.Exception}, locals: {X, double}]\n        [pc: 37, same]\n  \n  // Method descriptor #17 (Ljava/lang/Object;)V\n  // Stack: 1, Locals: 2\n  X(java.lang.Object o);\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [8]\n    4  return\n      Line numbers:\n        [pc: 0, line: 11]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n        [pc: 0, pc: 5] local: o index: 1 type: java.lang.Object\n  \n  // Method descriptor #21 (IZ)I\n  // Stack: 2, Locals: 4\n  int foo(int i, boolean b);\n     0  iload_2 [b]\n     1  ifeq 6\n     4  iload_1 [i]\n     5  ireturn\n     6  iload_1 [i]\n     7  iconst_1\n     8  iadd\n     9  ireturn\n    10  astore_3 [e]\n    11  iconst_5\n    12  ireturn\n      Exception Table:\n        [pc: 0, pc: 5] -> 10 when : java.lang.Exception\n        [pc: 6, pc: 9] -> 10 when : java.lang.Exception\n      Line numbers:\n        [pc: 0, line: 14]\n        [pc: 4, line: 15]\n        [pc: 6, line: 17]\n        [pc: 10, line: 18]\n        [pc: 11, line: 19]\n      Local variable table:\n        [pc: 0, pc: 13] local: this index: 0 type: X\n        [pc: 0, pc: 13] local: i index: 1 type: int\n        [pc: 0, pc: 13] local: b index: 2 type: boolean\n        [pc: 11, pc: 13] local: e index: 3 type: java.lang.Exception\n      Stack map table: number of frames 2\n        [pc: 6, same]\n        [pc: 10, same_locals_1_stack_item, stack: {java.lang.Exception}]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test002() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(double d, boolean b) {\n\t\tdouble i;\n\t\ttry {\n\t\t\ti = 0;\n\t\t\ti++;\n\t\t\tint j = (int) (i - 1);\n\t\t\tif (b) {\n\t\t\t\tdouble d1 = 0;\n\t\t\t\tif (!b) {\n\t\t\t\t\td1 = 0;\n\t\t\t\t}\n\t\t\t\tdouble d2 = d + d1;\n\t\t\t}\n\t\t\tbar(j);\n\t\t} catch(NullPointerException e) {\n\t\t\ti = 2;\n\t\t} finally {\n\t\t\ti = 1;\n\t\t}\n\t\tlong j = (long) (i + 1);\n\t\tint k = (int) j;\n\t\tk += j;\n\t}\n\tpublic static void bar(int i) {}\n\tpublic static void main(String[] args) {\n\t\tfoo(0, true);\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 (DZ)V\n  // Stack: 4, Locals: 11\n  public static void foo(double d, boolean b);\n     0  dconst_0\n     1  dstore_3 [i]\n     2  dload_3 [i]\n     3  dconst_1\n     4  dadd\n     5  dstore_3 [i]\n     6  dload_3 [i]\n     7  dconst_1\n     8  dsub\n     9  d2i\n    10  istore 5 [j]\n    12  iload_2 [b]\n    13  ifeq 32\n    16  dconst_0\n    17  dstore 6 [d1]\n    19  iload_2 [b]\n    20  ifne 26\n    23  dconst_0\n    24  dstore 6 [d1]\n    26  dload_0 [d]\n    27  dload 6 [d1]\n    29  dadd\n    30  dstore 8\n    32  iload 5 [j]\n    34  invokestatic X.bar(int) : void [16]\n    37  goto 58\n    40  astore 5 [e]\n    42  ldc2_w <Double 2.0> [20]\n    45  dstore_3 [i]\n    46  dconst_1\n    47  dstore_3 [i]\n    48  goto 60\n    51  astore 10\n    53  dconst_1\n    54  dstore_3 [i]\n    55  aload 10\n    57  athrow\n    58  dconst_1\n    59  dstore_3 [i]\n    60  dload_3 [i]\n    61  dconst_1\n    62  dadd\n    63  d2l\n    64  lstore 5 [j]\n    66  lload 5 [j]\n    68  l2i\n    69  istore 7 [k]\n    71  iload 7 [k]\n    73  i2l\n    74  lload 5 [j]\n    76  ladd\n    77  l2i\n    78  istore 7 [k]\n    80  return\n      Exception Table:\n        [pc: 0, pc: 37] -> 40 when : java.lang.NullPointerException\n        [pc: 0, pc: 46] -> 51 when : any\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 2, line: 6]\n        [pc: 6, line: 7]\n        [pc: 12, line: 8]\n        [pc: 16, line: 9]\n        [pc: 19, line: 10]\n        [pc: 23, line: 11]\n        [pc: 26, line: 13]\n        [pc: 32, line: 15]\n        [pc: 37, line: 16]\n        [pc: 42, line: 17]\n        [pc: 46, line: 19]\n        [pc: 51, line: 18]\n        [pc: 53, line: 19]\n        [pc: 55, line: 20]\n        [pc: 58, line: 19]\n        [pc: 60, line: 21]\n        [pc: 66, line: 22]\n        [pc: 71, line: 23]\n        [pc: 80, line: 24]\n      Local variable table:\n        [pc: 0, pc: 81] local: d index: 0 type: double\n        [pc: 0, pc: 81] local: b index: 2 type: boolean\n        [pc: 2, pc: 40] local: i index: 3 type: double\n        [pc: 46, pc: 51] local: i index: 3 type: double\n        [pc: 55, pc: 81] local: i index: 3 type: double\n        [pc: 12, pc: 37] local: j index: 5 type: int\n        [pc: 19, pc: 32] local: d1 index: 6 type: double\n        [pc: 42, pc: 46] local: e index: 5 type: java.lang.NullPointerException\n        [pc: 66, pc: 81] local: j index: 5 type: long\n        [pc: 71, pc: 81] local: k index: 7 type: int\n      Stack map table: number of frames 6\n        [pc: 26, append: {double, int, double}]\n        [pc: 32, chop 1 local(s)]\n        [pc: 40, full, stack: {java.lang.NullPointerException}, locals: {double, int}]\n        [pc: 51, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 58, append: {double}]\n        [pc: 60, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test003() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(boolean b) {\n\t\tint i = 0;\n\t\ttry {\n\t\t\tSystem.out.println(\"FINALLY\");\n\t\t\ti++;\n\t\t\tint j = i -1;\n\t\t\tbar(j);\n\t\t} catch(NullPointerException e) {\n\t\t\te.printStackTrace();\n\t\t} finally {\n\t\t\tSystem.out.println(\"FINALLY\");\n\t\t}\n\t}\n\tpublic static void bar(int i) {}\n\t\n\tpublic static void main(String[] args) {\n\t\tfoo(true);\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "FINALLY\nFINALLY\nSUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 (Z)V\n  // Stack: 2, Locals: 4\n  public static void foo(boolean b);\n     0  iconst_0\n     1  istore_1 [i]\n     2  getstatic java.lang.System.out : java.io.PrintStream [16]\n     5  ldc <String \"FINALLY\"> [22]\n     7  invokevirtual java.io.PrintStream.println(java.lang.String) : void [24]\n    10  iinc 1 1 [i]\n    13  iload_1 [i]\n    14  iconst_1\n    15  isub\n    16  istore_2 [j]\n    17  iload_2 [j]\n    18  invokestatic X.bar(int) : void [30]\n    21  goto 51\n    24  astore_2 [e]\n    25  aload_2 [e]\n    26  invokevirtual java.lang.NullPointerException.printStackTrace() : void [34]\n    29  getstatic java.lang.System.out : java.io.PrintStream [16]\n    32  ldc <String \"FINALLY\"> [22]\n    34  invokevirtual java.io.PrintStream.println(java.lang.String) : void [24]\n    37  goto 59\n    40  astore_3\n    41  getstatic java.lang.System.out : java.io.PrintStream [16]\n    44  ldc <String \"FINALLY\"> [22]\n    46  invokevirtual java.io.PrintStream.println(java.lang.String) : void [24]\n    49  aload_3\n    50  athrow\n    51  getstatic java.lang.System.out : java.io.PrintStream [16]\n    54  ldc <String \"FINALLY\"> [22]\n    56  invokevirtual java.io.PrintStream.println(java.lang.String) : void [24]\n    59  return\n      Exception Table:\n        [pc: 2, pc: 21] -> 24 when : java.lang.NullPointerException\n        [pc: 2, pc: 29] -> 40 when : any\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 10, line: 6]\n        [pc: 13, line: 7]\n        [pc: 17, line: 8]\n        [pc: 21, line: 9]\n        [pc: 25, line: 10]\n        [pc: 29, line: 12]\n        [pc: 40, line: 11]\n        [pc: 41, line: 12]\n        [pc: 49, line: 13]\n        [pc: 51, line: 12]\n        [pc: 59, line: 14]\n      Local variable table:\n        [pc: 0, pc: 60] local: b index: 0 type: boolean\n        [pc: 2, pc: 60] local: i index: 1 type: int\n        [pc: 17, pc: 21] local: j index: 2 type: int\n        [pc: 25, pc: 29] local: e index: 2 type: java.lang.NullPointerException\n      Stack map table: number of frames 4\n        [pc: 24, full, stack: {java.lang.NullPointerException}, locals: {int, int}]\n        [pc: 40, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 51, same]\n        [pc: 59, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test004() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(boolean b) {\n\t\tC c;\n\t\tif (b) {\n\t\t\tc = new C1();\n\t\t} else {\n\t\t\tc = new C2();\n\t\t}\n\t\tSystem.out.println();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(true);\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}\nclass C {\n\tvoid foo() {}\n}\nclass C1 extends C {\n}\nclass C2 extends C {\n}"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 (Z)V\n  // Stack: 2, Locals: 2\n  public static void foo(boolean b);\n     0  iload_0 [b]\n     1  ifeq 15\n     4  new C1 [16]\n     7  dup\n     8  invokespecial C1() [18]\n    11  astore_1 [c]\n    12  goto 23\n    15  new C2 [19]\n    18  dup\n    19  invokespecial C2() [21]\n    22  astore_1 [c]\n    23  getstatic java.lang.System.out : java.io.PrintStream [22]\n    26  invokevirtual java.io.PrintStream.println() : void [28]\n    29  return\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 4, line: 5]\n        [pc: 12, line: 6]\n        [pc: 15, line: 7]\n        [pc: 23, line: 9]\n        [pc: 29, line: 10]\n      Local variable table:\n        [pc: 0, pc: 30] local: b index: 0 type: boolean\n        [pc: 12, pc: 15] local: c index: 1 type: C\n        [pc: 23, pc: 30] local: c index: 1 type: C\n      Stack map table: number of frames 2\n        [pc: 15, same]\n        [pc: 23, append: {C}]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test005() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    int i = 0, j, k, l;\n    boolean b;\n    if (i == 0 && (j = ++i) > 0)\n      i += j;\n    while (true) {\n      k = 3;\n      break;\n    } \n    i -= k;\n    b = false && (i = l) > 0;\n    if (i > 0)\n      l = i;\n    else\n      l = k;\n    j = l;\n    if (i != -1 || j != 3 || k != 3 || l != 3)\n      System.out.println(\"FAILED\");\n    System.out.println(\"SUCCESS\");\n  }\n}"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 6\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [i]\n     2  iload_1 [i]\n     3  ifne 19\n     6  iinc 1 1 [i]\n     9  iload_1 [i]\n    10  dup\n    11  istore_2 [j]\n    12  ifle 19\n    15  iload_1 [i]\n    16  iload_2 [j]\n    17  iadd\n    18  istore_1 [i]\n    19  iconst_3\n    20  istore_3 [k]\n    21  iload_1 [i]\n    22  iload_3 [k]\n    23  isub\n    24  istore_1 [i]\n    25  iconst_0\n    26  istore 5 [b]\n    28  iload_1 [i]\n    29  ifle 38\n    32  iload_1 [i]\n    33  istore 4 [l]\n    35  goto 41\n    38  iload_3 [k]\n    39  istore 4 [l]\n    41  iload 4 [l]\n    43  istore_2 [j]\n    44  iload_1 [i]\n    45  iconst_m1\n    46  if_icmpne 65\n    49  iload_2 [j]\n    50  iconst_3\n    51  if_icmpne 65\n    54  iload_3 [k]\n    55  iconst_3\n    56  if_icmpne 65\n    59  iload 4 [l]\n    61  iconst_3\n    62  if_icmpeq 73\n    65  getstatic java.lang.System.out : java.io.PrintStream [16]\n    68  ldc <String \"FAILED\"> [22]\n    70  invokevirtual java.io.PrintStream.println(java.lang.String) : void [24]\n    73  getstatic java.lang.System.out : java.io.PrintStream [16]\n    76  ldc <String \"SUCCESS\"> [30]\n    78  invokevirtual java.io.PrintStream.println(java.lang.String) : void [24]\n    81  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 15, line: 6]\n        [pc: 19, line: 8]\n        [pc: 21, line: 9]\n        [pc: 22, line: 11]\n        [pc: 25, line: 12]\n        [pc: 28, line: 13]\n        [pc: 32, line: 14]\n        [pc: 38, line: 16]\n        [pc: 41, line: 17]\n        [pc: 44, line: 18]\n        [pc: 65, line: 19]\n        [pc: 73, line: 20]\n        [pc: 81, line: 21]\n      Local variable table:\n        [pc: 0, pc: 82] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 82] local: i index: 1 type: int\n        [pc: 12, pc: 19] local: j index: 2 type: int\n        [pc: 44, pc: 82] local: j index: 2 type: int\n        [pc: 21, pc: 82] local: k index: 3 type: int\n        [pc: 35, pc: 38] local: l index: 4 type: int\n        [pc: 41, pc: 82] local: l index: 4 type: int\n        [pc: 28, pc: 82] local: b index: 5 type: boolean\n      Stack map table: number of frames 5\n        [pc: 19, append: {int}]\n        [pc: 38, full, stack: {}, locals: {java.lang.String[], int, _, int, _, int}]\n        [pc: 41, full, stack: {}, locals: {java.lang.String[], int, _, int, int, int}]\n        [pc: 65, full, stack: {}, locals: {java.lang.String[], int, int, int, int, int}]\n        [pc: 73, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test006() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo (int n) {\n   \tsynchronized (this) {\n       \tswitch (n) {\n       \t\tcase 1:\n       \t\tthrow new NullPointerException();\n\t\t\t}\n\t\t}\n\t}\n    public static void main(String args[]) {\n    \ttry {\n\t    \tnew X().foo(1);\n    \t} catch(Exception e) {\n\t        System.out.println(\"SUCCESS\"); \n    \t}\n    } \n}"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 (I)V\n  // Stack: 2, Locals: 3\n  void foo(int n);\n     0  aload_0 [this]\n     1  dup\n     2  astore_2\n     3  monitorenter\n     4  iload_1 [n]\n     5  tableswitch default: 32\n          case 1: 24\n    24  new java.lang.NullPointerException [16]\n    27  dup\n    28  invokespecial java.lang.NullPointerException() [18]\n    31  athrow\n    32  aload_2\n    33  monitorexit\n    34  goto 40\n    37  aload_2\n    38  monitorexit\n    39  athrow\n    40  return\n      Exception Table:\n        [pc: 4, pc: 34] -> 37 when : any\n        [pc: 37, pc: 39] -> 37 when : any\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 4, line: 4]\n        [pc: 24, line: 6]\n        [pc: 32, line: 3]\n        [pc: 40, line: 9]\n      Local variable table:\n        [pc: 0, pc: 41] local: this index: 0 type: X\n        [pc: 0, pc: 41] local: n index: 1 type: int\n      Stack map table: number of frames 4\n        [pc: 24, append: {X}]\n        [pc: 32, same]\n        [pc: 37, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 40, chop 1 local(s)]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test007() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tStringBuffer foo2(boolean b) {\n\t\tSystem.out.println(\"foo2\");\n\t\treturn new StringBuffer(b ? \"true\" : \"false\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 (Z)Ljava/lang/StringBuffer;\n  // Stack: 3, Locals: 2\n  java.lang.StringBuffer foo2(boolean b);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  ldc <String \"foo2\"> [22]\n     5  invokevirtual java.io.PrintStream.println(java.lang.String) : void [23]\n     8  new java.lang.StringBuffer [29]\n    11  dup\n    12  iload_1 [b]\n    13  ifeq 21\n    16  ldc <String \"true\"> [31]\n    18  goto 23\n    21  ldc <String \"false\"> [33]\n    23  invokespecial java.lang.StringBuffer(java.lang.String) [35]\n    26  areturn\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 8, line: 4]\n      Local variable table:\n        [pc: 0, pc: 27] local: this index: 0 type: X\n        [pc: 0, pc: 27] local: b index: 1 type: boolean\n      Stack map table: number of frames 2\n        [pc: 21, full, stack: {uninitialized(8), uninitialized(8)}, locals: {X, int}]\n        [pc: 23, full, stack: {uninitialized(8), uninitialized(8), java.lang.String}, locals: {X, int}]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test008() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint foo = 0;\n\t\tString bar = \"zero\";\n\t\tSystem.out.println((foo != 0) ? foo : bar);\n\t}\n\t<T extends Comparable<?>> void foo(T foo) {\n\t\tT bar = null;\n\t\tSystem.out.println((foo != null) ? foo : bar);\n\t}\t\n}\n"}, "zero");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 3\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  istore_1 [foo]\n     2  ldc <String \"zero\"> [16]\n     4  astore_2 [bar]\n     5  getstatic java.lang.System.out : java.io.PrintStream [18]\n     8  iload_1 [foo]\n     9  ifeq 19\n    12  iload_1 [foo]\n    13  invokestatic java.lang.Integer.valueOf(int) : java.lang.Integer [24]\n    16  goto 20\n    19  aload_2 [bar]\n    20  invokevirtual java.io.PrintStream.println(java.lang.Object) : void [30]\n    23  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 4]\n        [pc: 5, line: 5]\n        [pc: 23, line: 6]\n      Local variable table:\n        [pc: 0, pc: 24] local: args index: 0 type: java.lang.String[]\n        [pc: 2, pc: 24] local: foo index: 1 type: int\n        [pc: 5, pc: 24] local: bar index: 2 type: java.lang.String\n      Stack map table: number of frames 2\n        [pc: 19, full, stack: {java.io.PrintStream}, locals: {java.lang.String[], int, java.lang.String}]\n" + (this.complianceLevel >= 0x340000L ? "        [pc: 20, full, stack: {java.io.PrintStream, java.lang.Object}, locals: {java.lang.String[], int, java.lang.String}]\n" : "        [pc: 20, full, stack: {java.io.PrintStream, java.lang.Comparable}, locals: {java.lang.String[], int, java.lang.String}]\n") + "  \n" + (this.complianceLevel >= 0x340000L ? "  // Method descriptor #46 (Ljava/lang/Comparable;)V\n" : "  // Method descriptor #48 (Ljava/lang/Comparable;)V\n") + "  // Signature: <T::Ljava/lang/Comparable<*>;>(TT;)V\n" + "  // Stack: 2, Locals: 3\n" + "  void foo(java.lang.Comparable foo);\n" + "     0  aconst_null\n" + "     1  astore_2 [bar]\n" + "     2  getstatic java.lang.System.out : java.io.PrintStream [18]\n" + "     5  aload_1 [foo]\n" + "     6  ifnull 13\n" + "     9  aload_1 [foo]\n" + "    10  goto 14\n" + "    13  aload_2 [bar]\n" + "    14  invokevirtual java.io.PrintStream.println(java.lang.Object) : void [30]\n" + "    17  return\n" + "      Line numbers:\n" + "        [pc: 0, line: 8]\n" + "        [pc: 2, line: 9]\n" + "        [pc: 17, line: 10]\n" + "      Local variable table:\n" + "        [pc: 0, pc: 18] local: this index: 0 type: X\n" + "        [pc: 0, pc: 18] local: foo index: 1 type: java.lang.Comparable\n" + "        [pc: 2, pc: 18] local: bar index: 2 type: java.lang.Comparable\n" + "      Local variable type table:\n" + "        [pc: 0, pc: 18] local: foo index: 1 type: T\n" + "        [pc: 2, pc: 18] local: bar index: 2 type: T\n" + "      Stack map table: number of frames 2\n" + "        [pc: 13, full, stack: {java.io.PrintStream}, locals: {X, java.lang.Comparable, java.lang.Comparable}]\n" + (this.complianceLevel < 0x340000L ? "        [pc: 14, full, stack: {java.io.PrintStream, java.lang.Comparable}, locals: {X, java.lang.Comparable, java.lang.Comparable}]\n" : "        [pc: 14, full, stack: {java.io.PrintStream, java.lang.Object}, locals: {X, java.lang.Comparable, java.lang.Comparable}]\n");
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test009() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString s;\n\tX() {\n        int i = 0;\n        if (s == null) {\n        \tSystem.out.print(\"PASSED\");\n        } else {\n        \tSystem.out.print(\"FAILED\");\n        }\n        System.out.print(\"DONE\" + i);\n\t}\n    public static void main(String argv[]) {\n    \tnew X();\n    }\n}"}, "PASSEDDONE0");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #8 ()V\n  // Stack: 4, Locals: 2\n  X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [10]\n     4  iconst_0\n     5  istore_1 [i]\n     6  aload_0 [this]\n     7  getfield X.s : java.lang.String [12]\n    10  ifnonnull 24\n    13  getstatic java.lang.System.out : java.io.PrintStream [14]\n    16  ldc <String \"PASSED\"> [20]\n    18  invokevirtual java.io.PrintStream.print(java.lang.String) : void [22]\n    21  goto 32\n    24  getstatic java.lang.System.out : java.io.PrintStream [14]\n    27  ldc <String \"FAILED\"> [28]\n    29  invokevirtual java.io.PrintStream.print(java.lang.String) : void [22]\n    32  getstatic java.lang.System.out : java.io.PrintStream [14]\n    35  new java.lang.StringBuilder [30]\n    38  dup\n    39  ldc <String \"DONE\"> [32]\n    41  invokespecial java.lang.StringBuilder(java.lang.String) [34]\n    44  iload_1 [i]\n    45  invokevirtual java.lang.StringBuilder.append(int) : java.lang.StringBuilder [36]\n    48  invokevirtual java.lang.StringBuilder.toString() : java.lang.String [40]\n    51  invokevirtual java.io.PrintStream.print(java.lang.String) : void [22]\n    54  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 4, line: 4]\n        [pc: 6, line: 5]\n        [pc: 13, line: 6]\n        [pc: 21, line: 7]\n        [pc: 24, line: 8]\n        [pc: 32, line: 10]\n        [pc: 54, line: 11]\n      Local variable table:\n        [pc: 0, pc: 55] local: this index: 0 type: X\n        [pc: 6, pc: 55] local: i index: 1 type: int\n      Stack map table: number of frames 2\n        [pc: 24, full, stack: {}, locals: {X, int}]\n        [pc: 32, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test010() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint[] tab = new int[0];\n\t\tObject o = tab;\n\t\tObject o1 = null;\n\t\tif (tab.length == 0) {\n\t\t\tSystem.out.println(tab.getClass());\n\t\t}\n\t\to1 = tab.clone();\n\t}\n}"}, "class [I");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 4\n  public static void main(java.lang.String[] args);\n     0  iconst_0\n     1  newarray int [10]\n     3  astore_1 [tab]\n     4  aload_1 [tab]\n     5  astore_2 [o]\n     6  aconst_null\n     7  astore_3 [o1]\n     8  aload_1 [tab]\n     9  arraylength\n    10  ifne 23\n    13  getstatic java.lang.System.out : java.io.PrintStream [16]\n    16  aload_1 [tab]\n    17  invokevirtual java.lang.Object.getClass() : java.lang.Class [22]\n    20  invokevirtual java.io.PrintStream.println(java.lang.Object) : void [26]\n    23  aload_1 [tab]\n    24  invokevirtual int[].clone() : java.lang.Object [32]\n    27  astore_3 [o1]\n    28  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 4, line: 4]\n        [pc: 6, line: 5]\n        [pc: 8, line: 6]\n        [pc: 13, line: 7]\n        [pc: 23, line: 9]\n        [pc: 28, line: 10]\n      Local variable table:\n        [pc: 0, pc: 29] local: args index: 0 type: java.lang.String[]\n        [pc: 4, pc: 29] local: tab index: 1 type: int[]\n        [pc: 6, pc: 29] local: o index: 2 type: java.lang.Object\n        [pc: 8, pc: 29] local: o1 index: 3 type: java.lang.Object\n      Stack map table: number of frames 1\n        [pc: 23, append: {int[], java.lang.Object, java.lang.Object}]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test011() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tObject o;\n\n\tpublic static void main(String[] args) {\n\t\tX x;\n\t\tfor (int i = 0; i < 10; i++) {\n\t\t\tif (i < 90) {\n\t\t\t\tx = new X();\n\t\t\t\tif (i > 4) {\n\t\t\t\t\tx.o = new Object();\n\t\t\t\t} else {\n\t\t\t\t\tx.o = \"0\";\n\t\t\t\t}\n\t\t\t\tswitch (i) {\n\t\t\t\t\tcase 0:\n\t\t\t\t\t\tif (x.o instanceof String) {\n\t\t\t\t\t\t\tSystem.out.print(\"1\");\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault: {\n\t\t\t\t\t\tObject diff = x.o;\n\t\t\t\t\t\tif (diff != null) {\n\t\t\t\t\t\t\tSystem.out.print(\"2\");\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}"}, "1222222222");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #17 ([Ljava/lang/String;)V\n  // Stack: 3, Locals: 4\n  public static void main(java.lang.String[] args);\n      0  iconst_0\n      1  istore_2 [i]\n      2  goto 105\n      5  iload_2 [i]\n      6  bipush 90\n      8  if_icmpge 102\n     11  new X [1]\n     14  dup\n     15  invokespecial X() [18]\n     18  astore_1 [x]\n     19  iload_2 [i]\n     20  iconst_4\n     21  if_icmple 38\n     24  aload_1 [x]\n     25  new java.lang.Object [3]\n     28  dup\n     29  invokespecial java.lang.Object() [10]\n     32  putfield X.o : java.lang.Object [19]\n     35  goto 44\n     38  aload_1 [x]\n     39  ldc <String \"0\"> [21]\n     41  putfield X.o : java.lang.Object [19]\n     44  iload_2 [i]\n     45  tableswitch default: 85\n          case 0: 64\n     64  aload_1 [x]\n     65  getfield X.o : java.lang.Object [19]\n     68  instanceof java.lang.String [23]\n     71  ifeq 102\n     74  getstatic java.lang.System.out : java.io.PrintStream [25]\n     77  ldc <String \"1\"> [31]\n     79  invokevirtual java.io.PrintStream.print(java.lang.String) : void [33]\n     82  goto 102\n     85  aload_1 [x]\n     86  getfield X.o : java.lang.Object [19]\n     89  astore_3 [diff]\n     90  aload_3 [diff]\n     91  ifnull 102\n     94  getstatic java.lang.System.out : java.io.PrintStream [25]\n     97  ldc <String \"2\"> [39]\n     99  invokevirtual java.io.PrintStream.print(java.lang.String) : void [33]\n    102  iinc 2 1 [i]\n    105  iload_2 [i]\n    106  bipush 10\n    108  if_icmplt 5\n    111  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 5, line: 7]\n        [pc: 11, line: 8]\n        [pc: 19, line: 9]\n        [pc: 24, line: 10]\n        [pc: 35, line: 11]\n        [pc: 38, line: 12]\n        [pc: 44, line: 14]\n        [pc: 64, line: 16]\n        [pc: 74, line: 17]\n        [pc: 82, line: 19]\n        [pc: 85, line: 21]\n        [pc: 90, line: 22]\n        [pc: 94, line: 23]\n        [pc: 102, line: 6]\n        [pc: 111, line: 29]\n      Local variable table:\n        [pc: 0, pc: 112] local: args index: 0 type: java.lang.String[]\n        [pc: 19, pc: 102] local: x index: 1 type: X\n        [pc: 2, pc: 111] local: i index: 2 type: int\n        [pc: 90, pc: 102] local: diff index: 3 type: java.lang.Object\n      Stack map table: number of frames 7\n        [pc: 5, full, stack: {}, locals: {java.lang.String[], _, int}]\n        [pc: 38, full, stack: {}, locals: {java.lang.String[], X, int}]\n        [pc: 44, same]\n        [pc: 64, same]\n        [pc: 85, same]\n        [pc: 102, full, stack: {}, locals: {java.lang.String[], _, int}]\n        [pc: 105, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test012() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tX x;\n\t\tObject o;\n\t\tfor (int i = 0; i < 10; i++) {\n\t\t\tif (i < 90) {\n\t\t\t\tx = new X();\n\t\t\t\tif (i > 4) {\n\t\t\t\t\to = new Object();\n\t\t\t\t} else {\n\t\t\t\t\to = null;\n\t\t\t\t}\n\t\t\t\tswitch (i) {\n\t\t\t\t\tcase 0:\n\t\t\t\t\t\tif (o instanceof String) {\n\t\t\t\t\t\t\tSystem.out.print(\"1\");\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\tdefault: {\n\t\t\t\t\t\tObject diff = o;\n\t\t\t\t\t\tif (diff != null) {\n\t\t\t\t\t\t\tSystem.out.print(\"2\");\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tSystem.out.print(\"3\");\n\t\t\t}\n\t\t}\n\t}\n}"}, "333332323232323");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 5\n  public static void main(java.lang.String[] args);\n      0  iconst_0\n      1  istore_3 [i]\n      2  goto 99\n      5  iload_3 [i]\n      6  bipush 90\n      8  if_icmpge 96\n     11  new X [1]\n     14  dup\n     15  invokespecial X() [16]\n     18  astore_1 [x]\n     19  iload_3 [i]\n     20  iconst_4\n     21  if_icmple 35\n     24  new java.lang.Object [3]\n     27  dup\n     28  invokespecial java.lang.Object() [8]\n     31  astore_2 [o]\n     32  goto 37\n     35  aconst_null\n     36  astore_2 [o]\n     37  iload_3 [i]\n     38  tableswitch default: 72\n          case 0: 56\n     56  aload_2 [o]\n     57  instanceof java.lang.String [17]\n     60  ifeq 88\n     63  getstatic java.lang.System.out : java.io.PrintStream [19]\n     66  ldc <String \"1\"> [25]\n     68  invokevirtual java.io.PrintStream.print(java.lang.String) : void [27]\n     71  return\n     72  aload_2 [o]\n     73  astore 4 [diff]\n     75  aload 4 [diff]\n     77  ifnull 88\n     80  getstatic java.lang.System.out : java.io.PrintStream [19]\n     83  ldc <String \"2\"> [33]\n     85  invokevirtual java.io.PrintStream.print(java.lang.String) : void [27]\n     88  getstatic java.lang.System.out : java.io.PrintStream [19]\n     91  ldc <String \"3\"> [35]\n     93  invokevirtual java.io.PrintStream.print(java.lang.String) : void [27]\n     96  iinc 3 1 [i]\n     99  iload_3 [i]\n    100  bipush 10\n    102  if_icmplt 5\n    105  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 5, line: 6]\n        [pc: 11, line: 7]\n        [pc: 19, line: 8]\n        [pc: 24, line: 9]\n        [pc: 32, line: 10]\n        [pc: 35, line: 11]\n        [pc: 37, line: 13]\n        [pc: 56, line: 15]\n        [pc: 63, line: 16]\n        [pc: 71, line: 17]\n        [pc: 72, line: 22]\n        [pc: 75, line: 23]\n        [pc: 80, line: 24]\n        [pc: 88, line: 29]\n        [pc: 96, line: 5]\n        [pc: 105, line: 32]\n      Local variable table:\n        [pc: 0, pc: 106] local: args index: 0 type: java.lang.String[]\n        [pc: 19, pc: 96] local: x index: 1 type: X\n        [pc: 32, pc: 35] local: o index: 2 type: java.lang.Object\n        [pc: 37, pc: 96] local: o index: 2 type: java.lang.Object\n        [pc: 2, pc: 105] local: i index: 3 type: int\n        [pc: 75, pc: 88] local: diff index: 4 type: java.lang.Object\n      Stack map table: number of frames 8\n        [pc: 5, full, stack: {}, locals: {java.lang.String[], _, _, int}]\n        [pc: 35, full, stack: {}, locals: {java.lang.String[], X, _, int}]\n        [pc: 37, full, stack: {}, locals: {java.lang.String[], X, java.lang.Object, int}]\n        [pc: 56, same]\n        [pc: 72, same]\n        [pc: 88, same]\n        [pc: 96, full, stack: {}, locals: {java.lang.String[], _, _, int}]\n        [pc: 99, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test013() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n  void foo() {\n      synchronized (this) {\n        int n=0;\n        try {\n           Thread.sleep(n); \n        } catch (Exception e ) {\n        }\n     }\n  }\n  \n  public static void main(String[] args) {}\n}"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 4\n  void foo();\n     0  aload_0 [this]\n     1  dup\n     2  astore_1\n     3  monitorenter\n     4  iconst_0\n     5  istore_2 [n]\n     6  iload_2 [n]\n     7  i2l\n     8  invokestatic java.lang.Thread.sleep(long) : void [15]\n    11  goto 15\n    14  astore_3\n    15  aload_1\n    16  monitorexit\n    17  goto 23\n    20  aload_1\n    21  monitorexit\n    22  athrow\n    23  return\n      Exception Table:\n        [pc: 6, pc: 11] -> 14 when : java.lang.Exception\n        [pc: 4, pc: 17] -> 20 when : any\n        [pc: 20, pc: 22] -> 20 when : any\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 4, line: 5]\n        [pc: 6, line: 7]\n        [pc: 11, line: 8]\n        [pc: 15, line: 4]\n        [pc: 23, line: 11]\n      Local variable table:\n        [pc: 0, pc: 24] local: this index: 0 type: X\n        [pc: 6, pc: 15] local: n index: 2 type: int\n      Stack map table: number of frames 4\n        [pc: 14, full, stack: {java.lang.Exception}, locals: {X, X, int}]\n        [pc: 15, chop 1 local(s)]\n        [pc: 20, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 23, chop 1 local(s)]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test014() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    X() {\n\t\tfinal int i;\n\t\tsynchronized (this) {\n\t\t    i = 8;\n\t\t}\n    }  \n  public static void main(String[] args) {}\n}"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 3\n  X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [8]\n     4  aload_0 [this]\n     5  dup\n     6  astore_2\n     7  monitorenter\n     8  bipush 8\n    10  istore_1 [i]\n    11  aload_2\n    12  monitorexit\n    13  goto 19\n    16  aload_2\n    17  monitorexit\n    18  athrow\n    19  return\n      Exception Table:\n        [pc: 8, pc: 13] -> 16 when : any\n        [pc: 16, pc: 18] -> 16 when : any\n      Line numbers:\n        [pc: 0, line: 2]\n        [pc: 4, line: 4]\n        [pc: 8, line: 5]\n        [pc: 11, line: 4]\n        [pc: 19, line: 7]\n      Local variable table:\n        [pc: 0, pc: 20] local: this index: 0 type: X\n        [pc: 11, pc: 16] local: i index: 1 type: int\n        [pc: 19, pc: 20] local: i index: 1 type: int\n      Stack map table: number of frames 2\n        [pc: 16, full, stack: {java.lang.Throwable}, locals: {X, _, X}]\n        [pc: 19, full, stack: {}, locals: {X, int}]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test015() throws Exception {
        this.runConformTest(new String[]{"X.java", "public enum X {\n    a1(1), a2(5), a3(11);\n    int value;\n    X(int a) {\n        value = a;\n    }\n    int value () {\n    \treturn value;\n    }\n    public static void main(String argv[]) {\n    }\n    public static int foo() {\n        int val;\n        int res = 0;\n        int n = 0;\n        X[] vals = X.values();\n\t\tfor (int i = 0, max = vals.length; i < max; i++) {\n\t\t\tX e = vals[i];\n           if ( n == 1) {\n               continue;\n           }\n           val = e.value();\n\t\t\tSystem.out.println(val);\n        }\n        return res;\n    }\n}"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #40 ()I\n  // Stack: 2, Locals: 7\n  public static int foo();\n     0  iconst_0\n     1  istore_1 [res]\n     2  iconst_0\n     3  istore_2 [n]\n     4  invokestatic X.values() : X[] [46]\n     7  astore_3 [vals]\n     8  iconst_0\n     9  istore 4 [i]\n    11  aload_3 [vals]\n    12  arraylength\n    13  istore 5 [max]\n    15  goto 48\n    18  aload_3 [vals]\n    19  iload 4 [i]\n    21  aaload\n    22  astore 6 [e]\n    24  iload_2 [n]\n    25  iconst_1\n    26  if_icmpne 32\n    29  goto 45\n    32  aload 6 [e]\n    34  invokevirtual X.value() : int [50]\n    37  istore_0 [val]\n    38  getstatic java.lang.System.out : java.io.PrintStream [52]\n    41  iload_0 [val]\n    42  invokevirtual java.io.PrintStream.println(int) : void [58]\n    45  iinc 4 1 [i]\n    48  iload 4 [i]\n    50  iload 5 [max]\n    52  if_icmplt 18\n    55  iload_1 [res]\n    56  ireturn\n      Line numbers:\n        [pc: 0, line: 14]\n        [pc: 2, line: 15]\n        [pc: 4, line: 16]\n        [pc: 8, line: 17]\n        [pc: 18, line: 18]\n        [pc: 24, line: 19]\n        [pc: 29, line: 20]\n        [pc: 32, line: 22]\n        [pc: 38, line: 23]\n        [pc: 45, line: 17]\n        [pc: 55, line: 25]\n      Local variable table:\n        [pc: 38, pc: 45] local: val index: 0 type: int\n        [pc: 2, pc: 57] local: res index: 1 type: int\n        [pc: 4, pc: 57] local: n index: 2 type: int\n        [pc: 8, pc: 57] local: vals index: 3 type: X[]\n        [pc: 11, pc: 55] local: i index: 4 type: int\n        [pc: 15, pc: 55] local: max index: 5 type: int\n        [pc: 24, pc: 45] local: e index: 6 type: X\n      Stack map table: number of frames 4\n        [pc: 18, full, stack: {}, locals: {_, int, int, X[], int, int}]\n        [pc: 32, append: {X}]\n        [pc: 45, chop 1 local(s)]\n        [pc: 48, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test016() throws Exception {
        this.runConformTest(new String[]{"X.java", "public enum X {\n    a1(1), a2(5), a3(11);\n    int value;\n    X(int a) {\n        value = a;\n    }\n    int value () {\n    \treturn value;\n    }\n    public static void main(String argv[]) {\n    }\n    public static int foo() {\n        int val;\n        int res = 0;\n        int n = 0;\n        for (X e : X.values()) {\n            if ( n == 1) {\n                continue;\n            }\n            val = e.value();\n\t\t\t System.out.println(val);\n        }\n        return res;\n    }\n}"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #40 ()I\n  // Stack: 2, Locals: 7\n  public static int foo();\n     0  iconst_0\n     1  istore_1 [res]\n     2  iconst_0\n     3  istore_2 [n]\n     4  invokestatic X.values() : X[] [46]\n     7  dup\n     8  astore 6\n    10  arraylength\n    11  istore 5\n    13  iconst_0\n    14  istore 4\n    16  goto 48\n    19  aload 6\n    21  iload 4\n    23  aaload\n    24  astore_3 [e]\n    25  iload_2 [n]\n    26  iconst_1\n    27  if_icmpne 33\n    30  goto 45\n    33  aload_3 [e]\n    34  invokevirtual X.value() : int [50]\n    37  istore_0 [val]\n    38  getstatic java.lang.System.out : java.io.PrintStream [52]\n    41  iload_0 [val]\n    42  invokevirtual java.io.PrintStream.println(int) : void [58]\n    45  iinc 4 1\n    48  iload 4\n    50  iload 5\n    52  if_icmplt 19\n    55  iload_1 [res]\n    56  ireturn\n      Line numbers:\n        [pc: 0, line: 14]\n        [pc: 2, line: 15]\n        [pc: 4, line: 16]\n        [pc: 25, line: 17]\n        [pc: 30, line: 18]\n        [pc: 33, line: 20]\n        [pc: 38, line: 21]\n        [pc: 45, line: 16]\n        [pc: 55, line: 23]\n      Local variable table:\n        [pc: 38, pc: 45] local: val index: 0 type: int\n        [pc: 2, pc: 57] local: res index: 1 type: int\n        [pc: 4, pc: 57] local: n index: 2 type: int\n        [pc: 25, pc: 45] local: e index: 3 type: X\n      Stack map table: number of frames 4\n        [pc: 19, full, stack: {}, locals: {_, int, int, _, int, int, X[]}]\n        [pc: 33, full, stack: {}, locals: {_, int, int, X, int, int, X[]}]\n        [pc: 45, full, stack: {}, locals: {_, int, int, _, int, int, X[]}]\n        [pc: 48, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test017() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tint i;\n\t\t\n\t\tswitch (i = 0) {\n\t\t\tcase 0 :\n\t\t\t\ti = 1;\n\t\t\t\tbreak;\n\t\t\tdefault :\n\t\t\t\t;\n\t\t}\n\t\tSystem.out.print(i);\n\t}\n}"}, "1");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] argv);\n     0  iconst_0\n     1  dup\n     2  istore_1 [i]\n     3  tableswitch default: 22\n          case 0: 20\n    20  iconst_1\n    21  istore_1 [i]\n    22  getstatic java.lang.System.out : java.io.PrintStream [16]\n    25  iload_1 [i]\n    26  invokevirtual java.io.PrintStream.print(int) : void [22]\n    29  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 20, line: 7]\n        [pc: 22, line: 12]\n        [pc: 29, line: 13]\n      Local variable table:\n        [pc: 0, pc: 30] local: argv index: 0 type: java.lang.String[]\n        [pc: 3, pc: 30] local: i index: 1 type: int\n      Stack map table: number of frames 2\n        [pc: 20, append: {int}]\n        [pc: 22, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test018() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\ninterface Sequence<Value_Type> extends Iterable<Value_Type>{\n\n    Value_Type get(int i);\n    int length();\n    Value_Type set(int i, Value_Type value);\n}\n\nclass ArraySequence<Value_Type> implements Sequence<Value_Type> {\n\n    public ArraySequence(int length) {}\n    public Value_Type get(int i) {\n        return null;\n    }\n    public int length() {\n        return 0;\n    }\n    public Value_Type set(int i, Value_Type value) {\n        return value;\n    }\n    public Iterator<Value_Type> iterator() {\n        return null;\n    }\n}\n\nclass BirBlock {\n    void setRole(IrBlock.Role role) {}\n}\n\nclass CatchChain {\n    int dispatcherAddress() {\n        return 0;\n    }\n}\n\nclass ExceptionHandlerInfo {\n    int handlerProgramCounter() {\n        return 0;\n    }\n}\n\ninterface IrBlock {\n    enum Role {\n        EXCEPTION_DISPATCHER\n    }\n}\n\nclass ClassMethodActor {\n    Sequence<ExceptionHandlerInfo> exceptionHandlerInfos() {\n        return null;\n    }\n}\n\npublic class X {\n\n    private Sequence<CatchChain> _catchChains;\n    private ClassMethodActor _classMethodActor;\n\n    public Sequence<BirBlock> getExceptionDispatchers(final BirBlock[] blockMap) {\n        final ArraySequence<BirBlock> dispatchers = new ArraySequence<BirBlock>(_catchChains.length());\n        for (int i = 0; i < _catchChains.length(); i++) {\n            final BirBlock dispatcher = blockMap[_catchChains.get(i).dispatcherAddress()];\n            dispatcher.setRole(IrBlock.Role.EXCEPTION_DISPATCHER);\n            dispatchers.set(i, dispatcher);\n        }\n        for (ExceptionHandlerInfo exceptionHandlerInfo : _classMethodActor.exceptionHandlerInfos()) {\n            blockMap[exceptionHandlerInfo.handlerProgramCounter()].setRole(IrBlock.Role.EXCEPTION_DISPATCHER);\n        }\n        return dispatchers;\n    }\n    public static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "final public class X\n{\n    final class MyClass\n    {\n        void method1(final String s)\n        {\n        }\n    }\n\n    Object method1()\n    {\n        try\n        {\n            final MyClass myClass = null;\n\n            try\n            {\n                return null;\n            }\n            catch (final Throwable ex)\n            {\n                myClass.method1(this == null ? \"\" : \"\");\n            }\n\n            return null;\n        }\n        finally\n        {\n            {\n            }\n        }\n    }\n    public static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public static Map make(boolean sorted) {\n        return (sorted) ? new TreeMap() : new HashMap();\n    }\n    public static void main(String[] args) {\n       make(false);\n\t\tSystem.out.print(\"SUCCESS\");\n    }\n}"}, "SUCCESS");
    }

    public void test021() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n   {\n      if (true) throw new NullPointerException();\n   }\n   X() {\n      System.out.println();\n   }\n}"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 1\n  X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [8]\n     4  new java.lang.NullPointerException [10]\n     7  dup\n     8  invokespecial java.lang.NullPointerException() [12]\n    11  athrow\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 4, line: 3]\n      Local variable table:\n        [pc: 0, pc: 12] local: this index: 0 type: X\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tString errorMessage;\n\t\ttry {\n\t\t\tfoo();\n\t\t\terrorMessage = \"No exception thrown\";\n\t\t} catch (Exception e) {\n\t\t\tif (e instanceof NullPointerException) {\n\t\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t\t\treturn;\n\t\t\t}\n\t\t\terrorMessage = \"Exception thrown\" + e;\n\t\t}\n\t\tSystem.out.println(errorMessage);\n\t}\n\tpublic static void foo() {\n\t\tthrow new NullPointerException();\n\t}\n}"}, "SUCCESS");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean a = true, x;\n\t\tif (a ? false : (x = true))\n\t\t\ta = x;\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static final int MAX_PROPERTIES = 25;\n\tpublic C c = new C();\n\tvoid foo(int i) {\n\t\tfinal int len = c.foo2();\n\t\tA f = new A(\" Test \", i, 1, MAX_PROPERTIES) {\n\t\t\t@Override\n\t\t\tpublic double bar() {\n\t\t\t\treturn len;\n\t\t\t}\n\t\t\t@Override\n\t\t\tpublic String toString() {\n\t\t\t\treturn \"SUCCESS\";\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(f);\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(0);\n\t}\n}", "A.java", "class A {\n\tA(String s, double d, double d1, double d2) {}\n\tpublic double bar() {\n\t\treturn 0.0;\n\t}\n}", "C.java", "class C {\n\tpublic int foo2() {\n\t\treturn 0;\n\t}\n}"}, "SUCCESS");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\t\n\tvoid foo(Object[] o) {}\n\n\tvoid bar(boolean b) {\n\t\tfoo(new Object[] {\"\", \"\", b ? \"\" : \"\"}); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ \n\t}\n}"}, "SUCCESS");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static final Object EXIT_OK = new Object();\n\tpublic static final Object EXIT_RELAUNCH = new Object();\n\tpublic static final Object EXIT_RESTART = new Object();\n\tpublic static final int RETURN_RESTART = 1;\n\tpublic static final String PROP_EXIT_CODE = \"\";\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tprivate static int createAndRunWorkbench(Display display, IDEWorkbenchAdvisor advisor) {\n\t\treturn 0;\n\t}\n \n    public Object run(Object args) throws Exception {\n        Display display = createDisplay();\n        try {\n            Shell shell = new Shell(display, SWT.ON_TOP);\n            try {\n                if (!checkInstanceLocation(shell)) {\n                    Platform.endSplash();\n                    return EXIT_OK;\n                }\n            } finally {\n                if (shell != null) {\n\t\t\t\t\tshell.dispose();\n\t\t\t\t}\n            }\n            int returnCode = X.createAndRunWorkbench(display,\n                    new IDEWorkbenchAdvisor());\n            if (returnCode != X.RETURN_RESTART) {\n\t\t\t\treturn EXIT_OK;\n\t\t\t}\n            return EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH\n                    : EXIT_RESTART;\n        } finally {\n            if (display != null) {\n\t\t\t\tdisplay.dispose();\n\t\t\t}\n        }\n    }\n\tprivate boolean checkInstanceLocation(Shell shell) {\n\t\t// TODO Auto-generated method stub\n\t\treturn false;\n\t}\n\tprivate Display createDisplay() {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n}", "Display.java", "class Display {\n\n\tpublic void dispose() {\n\t\t// TODO Auto-generated method stub\n\t\t\n\t}\n}", "Shell.java", "class Shell {\n\tpublic Shell(Display display, int i) {\n\t\t// TODO Auto-generated constructor stub\n\t}\n\n\tpublic void dispose() {\n\t\t// TODO Auto-generated method stub\n\t\t\n\t}\n}", "Platform.java", "class Platform {\n\n\tpublic static void endSplash() {\n\t\t// TODO Auto-generated method stub\n\t\t\n\t}\n}", "SWT.java", "class SWT {\n\tpublic static final int ON_TOP = 1; \n}", "IDEWorkbenchAdvisor.java", "class IDEWorkbenchAdvisor {\n}"}, "SUCCESS");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\nimport java.io.InputStream;\npublic class X {\n\tprivate static final int BUF_SIZE = 8192;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\tBundleActivator activator;\n\tBundleHost bundle;\n\tpublic byte[] getBytes() throws IOException {\n\t\tInputStream in = getInputStream();\n\t\tint length = (int) getSize();\n\t\tbyte[] classbytes;\n\t\tint bytesread = 0;\n\t\tint readcount;\n\t\tif (Debug.DEBUG && Debug.DEBUG_LOADER)\n\t\t\tDebug.println(\"  about to read \" + length + \" bytes from \" + getName()); //$NON-NLS-1$ //$NON-NLS-2$\n\t\ttry {\n\t\t\tif (length > 0) {\n\t\t\t\tclassbytes = new byte[length];\n\t\t\t\tfor (; bytesread < length; bytesread += readcount) {\n\t\t\t\t\treadcount = in.read(classbytes, bytesread, length - bytesread);\n\t\t\t\t\tif (readcount <= 0)\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tlength = BUF_SIZE;\n\t\t\t\tclassbytes = new byte[length];\n\t\t\t\treadloop: while (true) {\n\t\t\t\t\tfor (; bytesread < length; bytesread += readcount) {\n\t\t\t\t\t\treadcount = in.read(classbytes, bytesread, length - bytesread);\n\t\t\t\t\t\tif (readcount <= 0)\n\t\t\t\t\t\t\tbreak readloop;\n\t\t\t\t\t}\n\t\t\t\t\tbyte[] oldbytes = classbytes;\n\t\t\t\t\tlength += BUF_SIZE;\n\t\t\t\t\tclassbytes = new byte[length];\n\t\t\t\t\tSystem.arraycopy(oldbytes, 0, classbytes, 0, bytesread);\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (classbytes.length > bytesread) {\n\t\t\t\tbyte[] oldbytes = classbytes;\n\t\t\t\tclassbytes = new byte[bytesread];\n\t\t\t\tSystem.arraycopy(oldbytes, 0, classbytes, 0, bytesread);\n\t\t\t}\n\t\t} finally {\n\t\t\ttry {\n\t\t\t\tin.close();\n\t\t\t} catch (IOException ee) {\n\t\t\t\t// ignore\n\t\t\t}\n\t\t}\n\t\treturn classbytes;\n\t}\n\tprotected void stop(Throwable t) throws BundleException {\n\t\t\tString clazz = \"\";//(activator == null) ? \"\" : activator.getClass().getName(); //$NON-NLS-1$\n\t\t\tthrow new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[] {clazz, \"stop\", bundle.getSymbolicName() == null ? \"\" + bundle.getBundleId() : bundle.getSymbolicName()}), t); //$NON-NLS-1$ //$NON-NLS-2$ \n\t}\n\tprivate String getName() {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\tprivate int getSize() {\n\t\t// TODO Auto-generated method stub\n\t\treturn 0;\n\t}\n\tprivate InputStream getInputStream() {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n}", "Debug.java", "class Debug {\n\tpublic static final boolean DEBUG = false;\n\tpublic static final boolean DEBUG_LOADER = false;\n\tpublic static final boolean DEBUG_GENERAL = false;\n\tpublic static void println(String string) {\n\t\t// TODO Auto-generated method stub\n\t\t\n\t}\n\tpublic static void printStackTrace(Throwable t) {\n\t\t// TODO Auto-generated method stub\n\t\t\n\t}\n}", "AccessController.java", "class AccessController {\n\tstatic void doPrivileged(Object o) {\n\t}\n}", "BundleException.java", "class BundleException extends Exception {\n\tprivate static final long serialVersionUID = 5758882959559471648L;\n\n\tpublic BundleException(String bind, Throwable t) {\n\t\t// TODO Auto-generated constructor stub\n\t}\n}", "PrivilegedExceptionAction.java", "class PrivilegedExceptionAction {\n}", "BundleActivator.java", "class BundleActivator {\n\tpublic void stop(X x) {\n\t\t// TODO Auto-generated method stub\n\t\t\n\t}\n}", "BundleHost.java", "class BundleHost {\n\tpublic Object getSymbolicName() {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\tpublic String getBundleId() {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n}", "NLS.java", "class NLS {\n\tpublic static String bind(String bundleActivatorException, Object[] objects) {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n}", "PrivilegedActionException.java", "class PrivilegedActionException extends Exception {\n\tprivate static final long serialVersionUID = 3919969055057660822L;\n\tpublic Throwable getException() {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n}", "Msg.java", "class Msg {\n\tpublic static final String BUNDLE_ACTIVATOR_EXCEPTION = \"\";\n}"}, "SUCCESS");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "import java.io.StringReader;\n\npublic class X {\n\tpublic void loadVariablesAndContainers() {\n\t\t// backward compatibility, consider persistent property\t\n\t\tString qName = \"1\";\n\t\tString xmlString = \"2\";\n\t\t\n\t\ttry {\n\t\t\tif (xmlString != null){\n\t\t\t\tStringReader reader = new StringReader(xmlString);\n\t\t\t\tObject o;\n\t\t\t\ttry {\n\t\t\t\t\tStringBuffer buffer = null;\n\t\t\t\t\to = new Object();\n\t\t\t\t} catch(RuntimeException e) {\n\t\t\t\t\treturn;\n\t\t\t\t} catch(Exception e){\n\t\t\t\t\treturn;\n\t\t\t\t} finally {\n\t\t\t\t\treader.close();\n\t\t\t\t}\n\t\t\t\tSystem.out.println(reader);\n\t\t\t}\n\t\t} catch(Exception e){\n\t\t\t// problem loading xml file: nothing we can do\n\t\t} finally {\n\t\t\tif (xmlString != null){\n\t\t\t\tSystem.out.println(xmlString);\n\t\t\t}\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic Object foo() {\n\t\tObject status;\n\t\ttry {\n\t\t\tstatus= bar();\n\t\t} catch (RuntimeException x) {\n\t\t\tstatus= foo2(x);\n\t\t} finally {\n\t\t\tSystem.out.println();\n\t\t}\n\t\treturn status;\n\t}\n\tpublic Object bar() {\n\t\treturn null;\n\t}\n\tpublic Object foo2(Exception e) {\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "import java.util.Collections;\nimport java.util.List;\npublic class X {\n\n\tprivate static final String COMPUTE_COMPLETION_PROPOSALS= \"computeCompletionProposals()\"; //$NON-NLS-1$\n\tprivate Object fLastError;\n\tprivate boolean fIsReportingDelay;\n\tprivate CompletionProposalComputerRegistry fRegistry;\n\tpublic List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {\n\t\tif (!isEnabled())\n\t\t\treturn Collections.EMPTY_LIST;\n\n\t\tIStatus status;\n\t\ttry {\n\t\t\tIJavaCompletionProposalComputer computer= getComputer();\n\t\t\tif (computer == null) // not active yet\n\t\t\t\treturn Collections.EMPTY_LIST;\n\t\t\t\n\t\t\ttry {\n\t\t\t\tPerformanceStats stats= startMeter(context, computer);\n\t\t\t\tList proposals= computer.computeCompletionProposals(context, monitor);\n\t\t\t\tstopMeter(stats, COMPUTE_COMPLETION_PROPOSALS);\n\t\t\t\t\n\t\t\t\tif (proposals != null) {\n\t\t\t\t\tfLastError= computer.getErrorMessage();\n\t\t\t\t\treturn proposals;\n\t\t\t\t}\n\t\t\t} finally {\n\t\t\t\tfIsReportingDelay= true;\n\t\t\t}\n\t\t\tstatus= createAPIViolationStatus(COMPUTE_COMPLETION_PROPOSALS);\n\t\t} catch (InvalidRegistryObjectException x) {\n\t\t\tstatus= createExceptionStatus(x);\n\t\t} catch (CoreException x) {\n\t\t\tstatus= createExceptionStatus(x);\n\t\t} catch (RuntimeException x) {\n\t\t\tstatus= createExceptionStatus(x);\n\t\t} finally {\n\t\t\tmonitor.done();\n\t\t}\n\n\t\tfRegistry.informUser(this, status);\n\n\t\treturn Collections.EMPTY_LIST;\n\t}\n\n\tprivate IStatus createExceptionStatus(Exception x) {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\n\tprivate IStatus createAPIViolationStatus(String computeCompletionProposals) {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\n\tprivate void stopMeter(PerformanceStats stats, String computeCompletionProposals) {\n\t\t// TODO Auto-generated method stub\n\t\t\n\t}\n\n\tprivate PerformanceStats startMeter(ContentAssistInvocationContext context, IJavaCompletionProposalComputer computer) {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\n\tprivate IJavaCompletionProposalComputer getComputer() throws CoreException, InvalidRegistryObjectException {\n\t\t// TODO Auto-generated method stub\n\t\treturn null;\n\t}\n\n\tprivate boolean isEnabled() {\n\t\t// TODO Auto-generated method stub\n\t\treturn false;\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}", "IProgressMonitor.java", "interface IProgressMonitor {\n\tvoid done();\n}", "ContentAssistInvocationContext.java", "class ContentAssistInvocationContext {\n}", "IStatus.java", "interface IStatus {}", "IJavaCompletionProposalComputer.java", "import java.util.List;\ninterface IJavaCompletionProposalComputer {\n\tList computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor);\n\tObject getErrorMessage();\n}", "PerformanceStats.java", "class PerformanceStats {}", "CompletionProposalComputerRegistry.java", "class CompletionProposalComputerRegistry {\n\tpublic void informUser(X x, IStatus status) {\n\t}\n}", "InvalidRegistryObjectException.java", "class InvalidRegistryObjectException extends Exception {\n\tprivate static final long serialVersionUID = 8943194846421947853L;\n}", "CoreException.java", "class CoreException extends Exception {\n\tprivate static final long serialVersionUID = 3996792687633449517L;\n}"}, "SUCCESS");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString s;\n\tX() {\n\t\tthis.s = \"\";\n\t}\n\tX(String s, double d, double d2, double i) {\n\t\tthis.s = s;\n\t}\n\tpublic static final int CONST = 1;\n\tpublic int foo() {\n\t\treturn 0;\n\t}\n\tpublic double value(double d1) {\n\t\treturn d1;\n\t}\n\tpublic void bar(int start) {\n\t\tfinal int len = foo();\n\t\tX x = new X(\"SUCCESS\", start, 1, CONST) {\n\t\t\t@Override\n\t\t\tpublic double value(double newValue) {\n\t\t\t\treturn len;\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(x);\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().bar(1);\n\t}\n\tpublic String toString() {\n\t\treturn this.s;\n\t}\n}"}, "SUCCESS");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n    public static void main(String[] args) {\n\t\tint i = args.length;\n       X[] array = new X[] { i == 0 ? null : null };\n\t\tSystem.out.print(\"SUCCESS\" + array.length);\n    }\n}"}, "SUCCESS1");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tC { @Override public boolean test() { return true; } };\n\tstatic {\n\t\tfor (int i = 0; i < 1; i++) {}\n\t}\n\tpublic boolean test() {\n\treturn false;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "public enum X {\n\tC;\n\tstatic {\n\t\tfor (int i = 0; i < 1; i++) {}\n\t}\n\tpublic boolean test() {\n\treturn false;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic double foo() {\n\t\tdouble d = 3.0;\n\t\td = -d;\n\t\treturn d > 1.0 ? d : -d;\n\t}\n\n\tstatic float foo2() {\n\t\tfloat f = 3.0f;\n\t\tint i = 0;\n\t\tfloat f2 = f+ i;\n\t\tlong l = (long) f;\n\t\tl += f2;\n\t\treturn i == 0 ? f : -f + (float) l;\n\t}\n\n\tstatic long foo3() {\n\t\tlong l = Long.MAX_VALUE - 3;\n\t\tboolean b = true;\n\t\treturn b ? l : -l;\n\t}\n\t\n\tstatic short foo4() {\n\t\tshort[] tab = new short[] { 1, 2, 3 };\n\t\treturn tab.length == 3 ? tab[2] : (tab.length == 2 ? tab[1] : tab[0]);\n\t}\n\n\tpublic static void main(String args[]) {\n\t\tfoo();\n\t\tfoo2();\n\t\tfoo3();\n\t\tfoo4();\n\t\tSystem.out.print(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "import java.util.Map;\nimport java.util.Set;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\n\t}\n\tpublic void foo(Object o, boolean b) {\n\t\tString[] models = new String[] {};\n\t\tMap map = null;\n\t\tSet set  = null;\n\t\tfor (int n = 0; n < models.length; n++) {\tbar(models[n]); }\n\t\tfoo2(new Object(),\n\t\t\t\tset,\n\t\t\t\tmap,\n\t\t\t\t!b);\n\t}\n\tvoid bar(String s) {}\n\tvoid foo2(Object o, Object s, Object m, boolean b) {}\n}"}, "SUCCESS");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", ("public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\n\t}\n\tString field;\n\tString field2;\n\tpublic void foo(int index, Object[] objs, Object[] objs2) {\n\t\tString methodName = \"foo\";\n\t\tint i = -1;\n\t\ttry {\n\t\t\tswitch (index) {\n\t\t\t\tcase 1130: {\n\t\t\t\t\tint j = ((Integer) objs[0]).intValue();\n\t\t\t\t\tint k = ((Integer) objs[0]).intValue();\n\t\t\t\t\t{\n\t\t\t\t\t\tString s = field;\n\t\t\t\t\t\tString s2 = field2;\n\t\t\t\t\t\tsynchronized (s2) {\n\t\t\t\t\t\t\tString s3 = s2;\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tSystem.out.println(s);\n\t\t\t\t\t\t\t\tSystem.out.println(s2);\n\t\t\t\t\t\t\t\tSystem.out.println(s3);\n\t\t\t\t\t\t\t} finally {\n\t\t\t\t\t\t\t\ts2.toString();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\t\tcase 0 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 2 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 3 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 4 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 5 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 6 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 7 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 8 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 9 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 10 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 11 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 12 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 13 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 14 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 15 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 16 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 17 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 18 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 19 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 20 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 21 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 22 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 23 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 24 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 25 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 26 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 27 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 28 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 29 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 30 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 31 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 32 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 33 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 34 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 35 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 36 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 37 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 38 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 39 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 40 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 41 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 42 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 43 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 44 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 45 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 46 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 47 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 48 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 49 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 50 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 51 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 52 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 53 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 54 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 55 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 56 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 57 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 58 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 59 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 60 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 61 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 62 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 63 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 64 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 65 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 66 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 67 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 68 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 69 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 70 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 71 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 72 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 73 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 74 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 75 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 76 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 77 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 78 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 79 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 80 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 81 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 82 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 83 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 84 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 85 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 86 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 87 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 88 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 89 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 90 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 91 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 92 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 93 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 94 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 95 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 96 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 97 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 98 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 99 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 100 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 101 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 102 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 103 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 104 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 105 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 106 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 107 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 108 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 109 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 110 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 111 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 112 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 113 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 114 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 115 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 116 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 117 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 118 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 119 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 120 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 121 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 122 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 123 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 124 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 125 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 126 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 127 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 128 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 129 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 130 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 131 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 132 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 133 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 134 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 135 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 136 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 137 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 138 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 139 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 140 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 141 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 142 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 143 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 144 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 145 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 146 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 147 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 148 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 149 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 150 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 151 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 152 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 153 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 154 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 155 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 156 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 157 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 158 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 159 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 160 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 161 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 162 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 163 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 164 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 165 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 166 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 167 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 168 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 169 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 170 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 171 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 172 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 173 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 174 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 175 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 176 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 177 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 178 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 179 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 180 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 181 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 182 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 183 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 184 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 185 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 186 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 187 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 188 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 189 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 190 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 191 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 192 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 193 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 194 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 195 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 196 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 197 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 198 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 199 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 200 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 201 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 202 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 203 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 204 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 205 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 206 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 207 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 208 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 209 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 210 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 211 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 212 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 213 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 214 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 215 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 216 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 217 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 218 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 219 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 220 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 221 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 222 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 223 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 224 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 225 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 226 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 227 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 228 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 229 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 230 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 231 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 232 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 233 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 234 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 235 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 236 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 237 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 238 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 239 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 240 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 241 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 242 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 243 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 244 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 245 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 246 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 247 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 248 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 249 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 250 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 251 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 252 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 253 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 254 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 255 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 256 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 257 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 258 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 259 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 260 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 261 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 262 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 263 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 264 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 265 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 266 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 267 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 268 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 269 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 270 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 271 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 272 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 273 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 274 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 275 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 276 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 277 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 278 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 279 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 280 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 281 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 282 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 283 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 284 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 285 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 286 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 287 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 288 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 289 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 290 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 291 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 292 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 293 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 294 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 295 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 296 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 297 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 298 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 299 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 300 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 301 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 302 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 303 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 304 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 305 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 306 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 307 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 308 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 309 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 310 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 311 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 312 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 313 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 314 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 315 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 316 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 317 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 318 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 319 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 320 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 321 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 322 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 323 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 324 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 325 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 326 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 327 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 328 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 329 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 330 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 331 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 332 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 333 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 334 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 335 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 336 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 337 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 338 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 339 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 340 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 341 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 342 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 343 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 344 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 345 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 346 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 347 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 348 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 349 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 350 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 351 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 352 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 353 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 354 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 355 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 356 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 357 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 358 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 359 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 360 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 361 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 362 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 363 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 364 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 365 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 366 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 367 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 368 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 369 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 370 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 371 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 372 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 373 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 374 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 375 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 376 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 377 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 378 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 379 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 380 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 381 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 382 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 383 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 384 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 385 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 386 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 387 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 388 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 389 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 390 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 391 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 392 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 393 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 394 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 395 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 396 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 397 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 398 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 399 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 400 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 401 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 402 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 403 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 404 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 405 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 406 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 407 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 408 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 409 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 410 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 411 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 412 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 413 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 414 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 415 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 416 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 417 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 418 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 419 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 420 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 421 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 422 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 423 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 424 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 425 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 426 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 427 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 428 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 429 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 430 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 431 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 432 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 433 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 434 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 435 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 436 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 437 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 438 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 439 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 440 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 441 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 442 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 443 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 444 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 445 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 446 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 447 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 448 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 449 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 450 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 451 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 452 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 453 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 454 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 455 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 456 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 457 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 458 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 459 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 460 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 461 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 462 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 463 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 464 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 465 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 466 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 467 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 468 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 469 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 470 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 471 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 472 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 473 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 474 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 475 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 476 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 477 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 478 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 479 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 480 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 481 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 482 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 483 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 484 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 485 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 486 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 487 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 488 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 489 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 490 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 491 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 492 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 493 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 494 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 495 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 496 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 497 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 498 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 499 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 500 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 501 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 502 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 503 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 504 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 505 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 506 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 507 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 508 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 509 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 510 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 511 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 512 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 513 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 514 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 515 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 516 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 517 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 518 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 519 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 520 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 521 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 522 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 523 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 524 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 525 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 526 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 527 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 528 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 529 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 530 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 531 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 532 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 533 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 534 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 535 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 536 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 537 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 538 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 539 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 540 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 541 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 542 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 543 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 544 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 545 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 546 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 547 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 548 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 549 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 550 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 551 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 552 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 553 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 554 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 555 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 556 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 557 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 558 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 559 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 560 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 561 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 562 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 563 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 564 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 565 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 566 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 567 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 568 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 569 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 570 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 571 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 572 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 573 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 574 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 575 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 576 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 577 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 578 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 579 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 580 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 581 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 582 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 583 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 584 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 585 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 586 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 587 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 588 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 589 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 590 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 591 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 592 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 593 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 594 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 595 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 596 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 597 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 598 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 599 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 600 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 601 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 602 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 603 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 604 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 605 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 606 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 607 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 608 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 609 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 610 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 611 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 612 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 613 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 614 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 615 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 616 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 617 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 618 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 619 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 620 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 621 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 622 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 623 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 624 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 625 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 626 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 627 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 628 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 629 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 630 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 631 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 632 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 633 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 634 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 635 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 636 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 637 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 638 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 639 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 640 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 641 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 642 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 643 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 644 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 645 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 646 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 647 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 648 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 649 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 650 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 651 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 652 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 653 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 654 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 655 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 656 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 657 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 658 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 659 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 660 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 661 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 662 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 663 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 664 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 665 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 666 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 667 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 668 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 669 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 670 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 671 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 672 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 673 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 674 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 675 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 676 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 677 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 678 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 679 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 680 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 681 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 682 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 683 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 684 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 685 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 686 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 687 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 688 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 689 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 690 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 691 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 692 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 693 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 694 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 695 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 696 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 697 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 698 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 699 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 700 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 701 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 702 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 703 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 704 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 705 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 706 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 707 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 708 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 709 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 710 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 711 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 712 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 713 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 714 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 715 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 716 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 717 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 718 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 719 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 720 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 721 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 722 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 723 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 724 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 725 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 726 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 727 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 728 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 729 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 730 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 731 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 732 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 733 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 734 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 735 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 736 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 737 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 738 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 739 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 740 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 741 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 742 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 743 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 744 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 745 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 746 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 747 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 748 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 749 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 750 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 751 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 752 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 753 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 754 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 755 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 756 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 757 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 758 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 759 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 760 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 761 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 762 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 763 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 764 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 765 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 766 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 767 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 768 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 769 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 770 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 771 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 772 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 773 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 774 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 775 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 776 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 777 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 778 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 779 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 780 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 781 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 782 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 783 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 784 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 785 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 786 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 787 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 788 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 789 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 790 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 791 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 792 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 793 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 794 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 795 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 796 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 797 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 798 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 799 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 800 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 801 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 802 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 803 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 804 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 805 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 806 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 807 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 808 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 809 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 810 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 811 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 812 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 813 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 814 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 815 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 816 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 817 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 818 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 819 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 820 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 821 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 822 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 823 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 824 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 825 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 826 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 827 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 828 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 829 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 830 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 831 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 832 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 833 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 834 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 835 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 836 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 837 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 838 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 839 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 840 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 841 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 842 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 843 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 844 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 845 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 846 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 847 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 848 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 849 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 850 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 851 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 852 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 853 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 854 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 855 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 856 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 857 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 858 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 859 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 860 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 861 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 862 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 863 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 864 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 865 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 866 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 867 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 868 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 869 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 870 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 871 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 872 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 873 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 874 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 875 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 876 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 877 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 878 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 879 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 880 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 881 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 882 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 883 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 884 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 885 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 886 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 887 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 888 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 889 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 890 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 891 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 892 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 893 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 894 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 895 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 896 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 897 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 898 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 899 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 900 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 901 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 902 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 903 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 904 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 905 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 906 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 907 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 908 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 909 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 910 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 911 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 912 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 913 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 914 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 915 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 916 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 917 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 918 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 919 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 920 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 921 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 922 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 923 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 924 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 925 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 926 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 927 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 928 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 929 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 930 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 931 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 932 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 933 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 934 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 935 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 936 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 937 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 938 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 939 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 940 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 941 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 942 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 943 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 944 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 945 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 946 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 947 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 948 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 949 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 950 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 951 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 952 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 953 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 954 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 955 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 956 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 957 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 958 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 959 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 960 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 961 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 962 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 963 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 964 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 965 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 966 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 967 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 968 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 969 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t" + "\t\tbreak;\n\t\t\t\tcase 970 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 971 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 972 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 973 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 974 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 975 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 976 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 977 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 978 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 979 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 980 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 981 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 982 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 983 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 984 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 985 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 986 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 987 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 988 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 989 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 990 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 991 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 992 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 993 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 994 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 995 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 996 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 997 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 998 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 999 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1000 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1001 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1002 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1003 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1004 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1005 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1006 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1007 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1008 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1009 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1010 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1011 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1012 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1013 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1014 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1015 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1016 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1017 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1018 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1019 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1020 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1021 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1022 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1023 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1024 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1025 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1026 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1027 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1028 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1029 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1030 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1031 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1032 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1033 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1034 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1035 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1036 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1037 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1038 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1039 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1040 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1041 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1042 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1043 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1044 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1045 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1046 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1047 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1048 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1049 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1050 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1051 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1052 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1053 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1054 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1055 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1056 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1057 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1058 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1059 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1060 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1061 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1062 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1063 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1064 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1065 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1066 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1067 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1068 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1069 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1070 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1071 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1072 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1073 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1074 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1075 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1076 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1077 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1078 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1079 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1080 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1081 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1082 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1083 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1084 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1085 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1086 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1087 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1088 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1089 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1090 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1091 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1092 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1093 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1094 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1095 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1096 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1097 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1098 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1099 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1100 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1101 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1102 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1103 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1104 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1105 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1106 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1107 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1108 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1109 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1110 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1111 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1112 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1113 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1114 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1115 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1116 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1117 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1118 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1119 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1120 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1121 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1122 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1123 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1124 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1125 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1126 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1127 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1128 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t\tcase 1129 :\n\t\t\t\t\tSystem.out.println(methodName + i);\n\t\t\t\tbreak;\n\t\t\t}\n\t\t} catch(Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}}").intern()}, "SUCCESS");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t{\n\t\tfor (boolean b : new boolean[] {}) {}\n\t}\n\tpublic X() {}\n\tpublic X(boolean b) {}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic String[][] foo(String s) {\n\t\treturn\n\t\t\tnew String[][] { {\" \", s != null ? s : \"\" },\n\t\t\t\t{\" \", s != null ? s : \"\" },\n\t\t\t\t{\" \", s != null ? s : \"\" },\n\t\t\t\t{\" \", s != null ? s : \"\" } };\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test040() throws Exception {
        this.runConformTest(new String[]{"I.java", "public interface I {\n\n\tpublic Object foo();\n\n\tpublic static class B implements I {\n\t\tpublic Object foo() {\n\t\t\treturn X.myI.foo();\n\t\t}\n\t}\n}", "X.java", "public class X {\n\tpublic static final I myI = new I.B() {\n\t\tint a = 0;\n\t\tint b = 1;\n\t};\n\n\tprivate Object bar2() {\n\t\treturn null;\n\t}\n\tprivate Object bar() {\n\t\tObject o = bar2();\n\t\tif (o != null) {\n\t\t\to.toString();\n\t\t}\n\t\treturn null;\n\t}\n\n}"}, "");
        String expectedOutput = "  // Method descriptor #23 ()Ljava/lang/Object;\n  // Stack: 1, Locals: 2\n  private java.lang.Object bar();\n     0  aload_0 [this]\n     1  invokespecial X.bar2() : java.lang.Object [25]\n     4  astore_1 [o]\n     5  aload_1 [o]\n     6  ifnull 14\n     9  aload_1 [o]\n    10  invokevirtual java.lang.Object.toString() : java.lang.String [27]\n    13  pop\n    14  aconst_null\n    15  areturn\n      Line numbers:\n        [pc: 0, line: 11]\n        [pc: 5, line: 12]\n        [pc: 9, line: 13]\n        [pc: 14, line: 15]\n      Local variable table:\n        [pc: 0, pc: 16] local: this index: 0 type: X\n        [pc: 5, pc: 16] local: o index: 1 type: java.lang.Object\n      Stack map table: number of frames 1\n        [pc: 14, append: {java.lang.Object}]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test041() throws Exception {
        this.runConformTest(new String[]{"I.java", "public interface I {\n\n\tpublic Object foo();\n\n\tpublic static class B implements I {\n\t\tpublic Object foo() {\n\t\t\treturn String.valueOf(X.myI.foo()) + String.valueOf(X.myU.foo());\n\t\t}\n\t}\n}", "X.java", "public class X {\n\tpublic static final I myI = new I.B() {\n\t\tint a = 0;\n\t\tint b = 1;\n\t};\n\tpublic static final I myU = new I.B() {\n\t\tint a = 0;\n\t\tint b = 1;\n\t\tint c = 2;\n\t};\n\tprivate Object bar2() {\n\t\treturn null;\n\t}\n\tprivate Object bar() {\n\t\tObject o = bar2();\n\t\tif (o != null) {\n\t\t\to.toString();\n\t\t}\n\t\treturn null;\n\t}\n}"}, "");
        String expectedOutput = "  // Method descriptor #29 ()Ljava/lang/Object;\n  // Stack: 1, Locals: 2\n  private java.lang.Object bar();\n     0  aload_0 [this]\n     1  invokespecial X.bar2() : java.lang.Object [31]\n     4  astore_1 [o]\n     5  aload_1 [o]\n     6  ifnull 14\n     9  aload_1 [o]\n    10  invokevirtual java.lang.Object.toString() : java.lang.String [33]\n    13  pop\n    14  aconst_null\n    15  areturn\n      Line numbers:\n        [pc: 0, line: 15]\n        [pc: 5, line: 16]\n        [pc: 9, line: 17]\n        [pc: 14, line: 19]\n      Local variable table:\n        [pc: 0, pc: 16] local: this index: 0 type: X\n        [pc: 5, pc: 16] local: o index: 1 type: java.lang.Object\n      Stack map table: number of frames 1\n        [pc: 14, append: {java.lang.Object}]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test042() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tprivate static void foo(Class<?> c, int n) { }\n\tpublic static void main(String... args) {\n\t\tfoo(Integer.class, (args == null ? -1 : 1));\n\t}\n}"}, "");
        String expectedOutput = "  // Stack: 2, Locals: 1\n  public static void main(java.lang.String... args);\n     0  ldc <Class java.lang.Integer> [26]\n     2  aload_0 [args]\n     3  ifnonnull 10\n     6  iconst_m1\n     7  goto 11\n    10  iconst_1\n    11  invokestatic X.foo(java.lang.Class, int) : void [28]\n    14  return\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 14, line: 5]\n      Local variable table:\n        [pc: 0, pc: 15] local: args index: 0 type: java.lang.String[]\n      Stack map table: number of frames 2\n        [pc: 10, same_locals_1_stack_item, stack: {java.lang.Class}]\n        [pc: 11, full, stack: {java.lang.Class, int}, locals: {java.lang.String[]}]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test043() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"ok\");\n\t}\n\tprivate static int willNotVerify() {\n\t\tint limit = 100;\n\t\tint match;\n\t\tint result = 200;\n\t\tdo {\n\t\t\tif (limit > 0) {\n\t\t\t\tcontinue;\n\t\t\t}\n\t\t\tmatch = 0;\n\t\t\twhile (++match < 100) {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t} while (--limit != 0);\n\t\treturn result;\n\t}\n}"}, "ok");
        String expectedOutput = "  // Method descriptor #33 ()I\n  // Stack: 2, Locals: 3\n  private static int willNotVerify();\n     0  bipush 100\n     2  istore_0 [limit]\n     3  sipush 200\n     6  istore_2 [result]\n     7  iload_0 [limit]\n     8  ifle 14\n    11  goto 34\n    14  iconst_0\n    15  istore_1 [match]\n    16  goto 25\n    19  getstatic java.lang.System.out : java.io.PrintStream [16]\n    22  invokevirtual java.io.PrintStream.println() : void [34]\n    25  iinc 1 1 [match]\n    28  iload_1 [match]\n    29  bipush 100\n    31  if_icmplt 19\n    34  iinc 0 -1 [limit]\n    37  iload_0 [limit]\n    38  ifne 7\n    41  iload_2 [result]\n    42  ireturn\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 3, line: 8]\n        [pc: 7, line: 10]\n        [pc: 11, line: 11]\n        [pc: 14, line: 13]\n        [pc: 16, line: 14]\n        [pc: 19, line: 15]\n        [pc: 25, line: 14]\n        [pc: 34, line: 17]\n        [pc: 41, line: 18]\n      Local variable table:\n        [pc: 3, pc: 43] local: limit index: 0 type: int\n        [pc: 16, pc: 34] local: match index: 1 type: int\n        [pc: 7, pc: 43] local: result index: 2 type: int\n      Stack map table: number of frames 5\n        [pc: 7, full, stack: {}, locals: {int, _, int}]\n        [pc: 14, same]\n        [pc: 19, full, stack: {}, locals: {int, int, int}]\n        [pc: 25, same]\n        [pc: 34, full, stack: {}, locals: {int, _, int}]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test044() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"ok\");\n\t}\n\tprivate static int willNotVerify() {\n\t\tint limit = 100;\n\t\tint match;\n\t\tint result = 200;\n\t\tdo {\n\t\t\tif (limit > 0) {\n\t\t\t\tcontinue;\n\t\t\t}\n\t\t\tmatch = 0;\n\t\t\twhile (++match < 100) {\n\t\t\t\t// empty\n\t\t\t}\n\t\t} while (--limit != 0);\n\t\treturn result;\n\t}\n}"}, "ok");
        String expectedOutput = "  // Method descriptor #33 ()I\n  // Stack: 2, Locals: 3\n  private static int willNotVerify();\n     0  bipush 100\n     2  istore_0 [limit]\n     3  sipush 200\n     6  istore_2 [result]\n     7  iload_0 [limit]\n     8  ifle 14\n    11  goto 25\n    14  iconst_0\n    15  istore_1 [match]\n    16  iinc 1 1 [match]\n    19  iload_1 [match]\n    20  bipush 100\n    22  if_icmplt 16\n    25  iinc 0 -1 [limit]\n    28  iload_0 [limit]\n    29  ifne 7\n    32  iload_2 [result]\n    33  ireturn\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 3, line: 8]\n        [pc: 7, line: 10]\n        [pc: 11, line: 11]\n        [pc: 14, line: 13]\n        [pc: 16, line: 14]\n        [pc: 25, line: 17]\n        [pc: 32, line: 18]\n      Local variable table:\n        [pc: 3, pc: 34] local: limit index: 0 type: int\n        [pc: 16, pc: 25] local: match index: 1 type: int\n        [pc: 7, pc: 34] local: result index: 2 type: int\n      Stack map table: number of frames 4\n        [pc: 7, full, stack: {}, locals: {int, _, int}]\n        [pc: 14, same]\n        [pc: 16, full, stack: {}, locals: {int, int, int}]\n        [pc: 25, full, stack: {}, locals: {int, _, int}]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test045() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String args[]) {\n\t\tint i;\n\t\tdo {\n\t\t} while ((i = 2) < 0);\n\t\tif (i != 2) {\n\t\t\tSystem.out.println(\"FAILED\");\n\t\t} else {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 2\n  public static void main(java.lang.String[] args);\n     0  iconst_2\n     1  dup\n     2  istore_1 [i]\n     3  iflt 0\n     6  iload_1 [i]\n     7  iconst_2\n     8  if_icmpeq 22\n    11  getstatic java.lang.System.out : java.io.PrintStream [16]\n    14  ldc <String \"FAILED\"> [22]\n    16  invokevirtual java.io.PrintStream.println(java.lang.String) : void [24]\n    19  goto 30\n    22  getstatic java.lang.System.out : java.io.PrintStream [16]\n    25  ldc <String \"SUCCESS\"> [30]\n    27  invokevirtual java.io.PrintStream.println(java.lang.String) : void [24]\n    30  return\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 3, line: 4]\n        [pc: 6, line: 6]\n        [pc: 11, line: 7]\n        [pc: 19, line: 8]\n        [pc: 22, line: 9]\n        [pc: 30, line: 11]\n      Local variable table:\n        [pc: 0, pc: 31] local: args index: 0 type: java.lang.String[]\n        [pc: 3, pc: 31] local: i index: 1 type: int\n      Stack map table: number of frames 3\n        [pc: 0, same]\n        [pc: 22, append: {int}]\n        [pc: 30, same]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test046() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass E1 extends RuntimeException {\n\t\tprivate static final long serialVersionUID = 1L;\n\t}\n\tstatic Object bar() {\n\t\treturn new Object() {\n\t\t\tpublic void foo() {\n\t\t\t\tif (condition())\n\t\t\t\t\tthrow new E1();\n\t\t\t}\n\t\t};\n\t}\n\tstatic boolean condition() {\n\t\treturn false;\n\t}\n\tpublic static void main(String[] args) {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tthrow new E1();\n\t      ^^^^^^^^\nNo enclosing instance of type X is accessible. Must qualify the allocation with an enclosing instance of type X (e.g. x.new A() where x is an instance of X).\n----------\n", null, true, customOptions);
    }

    public void test047() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void test() {\n\t\tfinal boolean x = true;\n\t\tnew Runnable() {\n\t\t\t@Override\n\t\t\tpublic void run() {\n\t\t\t\tsynchronized (X.this) {\n\t\t\t\t\tSystem.out.println(x);\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tsynchronized (X.this) {\n\t              ^^^^^^\nNo enclosing instance of the type X is accessible in scope\n----------\n");
    }

    public void test048() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] p) {\n        int i;\n        try {\n          if (p == null || p == null)\n            return;\n          i = 0;\n        } finally {\n            i = 0;\n        }\n    }\n}\n"}, "");
    }

    public void test049() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\nimport java.io.InputStream;\n\npublic class X implements Runnable {\n\n\tprivate boolean contentEquals(final String src, final String tar)\n\t\t\tthrows IOException {\n\t\tif (src == null && tar == null) {\n\t\t\treturn true;\n\t\t}\n\t\tif (!isFile(src) || !isFile(tar))\n\t\t\tthrow new IOException(\"cannot compare non-files\");\n\t\tif (size(src) != size(tar))\n\t\t\treturn false;\n\t\tfinal byte[] baSrc = new byte[8192];\n\t\tfinal byte[] baTar = new byte[baSrc.length];\n\t\tint lrSrc;\n\t\tint lrTar;\n\t\tInputStream isSrc = null;\n\t\tInputStream isTar = null;\n\t\ttry {\n\t\t\tisSrc = newInputStream(src);\n\t\t\tif (isSrc == null)\n\t\t\t\treturn false;\n\t\t\tisTar = newInputStream(tar);\n\t\t\tif (isTar == null)\n\t\t\t\treturn false;\n\t\t\tdo {\n\t\t\t\tlrSrc = isSrc.read(baSrc);\n\t\t\t\tlrTar = isTar.read(baTar);\n\t\t\t\tif (lrSrc != lrTar)\n\t\t\t\t\treturn false;\n\t\t\t\tfor (int i = 0; i < lrSrc; i++)\n\t\t\t\t\tif (baSrc[i] != baTar[i])\n\t\t\t\t\t\treturn false;\n\t\t\t} while ((lrSrc >= 0) && (lrSrc == lrTar));\n\t\t} finally {\n\t\t\ttry {\n\t\t\t\tclose(isSrc);\n\t\t\t} finally {\n\t\t\t\tclose(isTar);\n\t\t\t}\n\t\t}\n\t\treturn true;\n\t}\n\tprivate void close(final InputStream isSrc) {\n\t}\n\tprivate boolean isFile(final String src) {\n\t\treturn false;\n\t}\n\tpublic void run() {\n\t\ttry {\n\t\t\tSystem.out.println(contentEquals(null, null));\n\t\t} catch (final IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\tstatic InputStream newInputStream(String path) {\n\t\treturn null;\n\t}\n\tstatic int size(String path) {\n\t\treturn 0;\n\t}\n\tpublic static void main(final String[] args) {\n\t\tnew X().run();\n\t}\n}"}, "true");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileFilter;\nimport java.io.FileNotFoundException;\nimport java.io.IOException;\nimport java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\n\tpublic static final List<File> copyDir(List<File> lf,\n\t\t\tfinal boolean overwrite, final boolean recursive,\n\t\t\tfinal boolean returnSrc, final File src, final File tar,\n\t\t\tfinal FileFilter filter) throws IOException {\n\t\tif (!src.isDirectory())\n\t\t\tthrow new FileNotFoundException(\"not a directory: \" + src);\n\t\tif (!tar.isDirectory())\n\t\t\tthrow new FileNotFoundException(\"not a directory: \" + tar);\n\t\tfinal File[] fa = src.listFiles();\n\t\tif (fa == null)\n\t\t\tthrow new FileNotFoundException(\"directory not accessible: \" + src);\n\t\tif (lf == null)\n\t\t\tlf = new ArrayList<File>(fa.length);\n\t\tfor (final File f : fa) {\n\t\t\tfinal File right = new File(tar, f.getName());\n\t\t\tif (f.isDirectory()) {\n\t\t\t\tif (recursive && filter.accept(f)) {\n\t\t\t\t\tif (!right.exists())\n\t\t\t\t\t\tright.mkdir();\n\t\t\t\t\tcopyDir(lf, overwrite, recursive, returnSrc, f, right,\n\t\t\t\t\t\t\tfilter);\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tif (overwrite || (!right.exists() && filter.accept(f))) {\n\t\t\t\t\tlf.add(returnSrc ? f : right);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn lf;\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\n}"}, "SUCCESS");
    }

    public void test051() {
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.IOException;\nimport java.util.List;\n\npublic class X {\n\n\tpublic static final List<File> copyDir(int j, List<File> lf,\n\t\t\tfinal boolean returnSrc, final File[] fa) throws IOException {\n\t\tif (lf == null)\n\t\t\tlf = null;\n\t\tfor (int i = 0, max = fa.length; i < max; i++) {\n\t\t\tfinal File f = fa[i];\n\t\t\tfinal File right = new File(f.getName());\n\t\t\tif (f.isDirectory()) {\n\t\t\t} else {\n\t\t\t\tlf.add(returnSrc ? f : right);\n\t\t\t}\n\t\t}\n\t\treturn lf;\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n\n}"}, "SUCCESS");
    }

    public void test052() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX(int i) {}\n\tvoid foo() {}\n\tpublic static void main(String[] args) {\n\t\tnew X(args.length == 2 ? 1 : 2).foo();\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test053() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic {\n\t\tfor(int i = 0; i < 10; i++){\n\t\t\tA a = new A();\n\t\t\ta.foo();\n\t\t}\n\t}\n\tprivate class A {\n\t\tprivate A() {\n\t\t}\n\t\tvoid foo() {}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tA a = new A();\n\t      ^^^^^^^\nNo enclosing instance of type X is accessible. Must qualify the allocation with an enclosing instance of type X (e.g. x.new A() where x is an instance of X).\n----------\n", null, true, customOptions);
    }

    public void test054() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\npublic static void foo() {\n     X z;\n     while ((z = getObject()) != null) {\n         z.bar();\n     }\n\t  System.out.println(\"SUCCESS\");\n }\n public void bar() {}\n public static X getObject() {\n     return null;\n }\n   public static void main(String[] args) {\n       new X().foo();\n   }\n}"}, "SUCCESS");
    }

    public void testBug359495a() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nimport java.util.concurrent.locks.Lock;\nimport java.util.Arrays;\nimport java.util.concurrent.locks.ReentrantLock;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tfinal Lock lock = new ReentrantLock();\n\t\tfinal List<String> strings = Arrays.asList(args);\n\t\tlock.lock();\n\t\ttry{\n\t\t\tfor (final String string:strings){\n\t\t\t\treturn;\n\t\t\t}\n\t\t\treturn;\n\t\t} finally {\n\t\t\tlock.unlock();\n\t\t}\t}\n}"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 6\n  public static void main(java.lang.String[] args);\n     0  new java.util.concurrent.locks.ReentrantLock [16]\n     3  dup\n     4  invokespecial java.util.concurrent.locks.ReentrantLock() [18]\n     7  astore_1 [lock]\n     8  aload_0 [args]\n     9  invokestatic java.util.Arrays.asList(java.lang.Object[]) : java.util.List [19]\n    12  astore_2 [strings]\n    13  aload_1 [lock]\n    14  invokeinterface java.util.concurrent.locks.Lock.lock() : void [25] [nargs: 1]\n    19  aload_2 [strings]\n    20  invokeinterface java.util.List.iterator() : java.util.Iterator [30] [nargs: 1]\n    25  astore 4\n    27  aload 4\n    29  invokeinterface java.util.Iterator.hasNext() : boolean [36] [nargs: 1]\n    34  ifeq 55\n    37  aload 4\n    39  invokeinterface java.util.Iterator.next() : java.lang.Object [42] [nargs: 1]\n    44  checkcast java.lang.String [46]\n    47  astore_3 [string]\n    48  aload_1 [lock]\n    49  invokeinterface java.util.concurrent.locks.Lock.unlock() : void [48] [nargs: 1]\n    54  return\n    55  aload_1 [lock]\n    56  invokeinterface java.util.concurrent.locks.Lock.unlock() : void [48] [nargs: 1]\n    61  return\n    62  astore 5\n    64  aload_1 [lock]\n    65  invokeinterface java.util.concurrent.locks.Lock.unlock() : void [48] [nargs: 1]\n    70  aload 5\n    72  athrow\n      Exception Table:\n        [pc: 19, pc: 48] -> 62 when : any\n      Line numbers:\n        [pc: 0, line: 7]\n        [pc: 8, line: 8]\n        [pc: 13, line: 9]\n        [pc: 19, line: 11]\n        [pc: 48, line: 16]\n        [pc: 54, line: 12]\n        [pc: 55, line: 16]\n        [pc: 61, line: 14]\n        [pc: 62, line: 15]\n        [pc: 64, line: 16]\n        [pc: 70, line: 17]\n      Local variable table:\n        [pc: 0, pc: 73] local: args index: 0 type: java.lang.String[]\n        [pc: 8, pc: 73] local: lock index: 1 type: java.util.concurrent.locks.Lock\n        [pc: 13, pc: 73] local: strings index: 2 type: java.util.List\n        [pc: 48, pc: 55] local: string index: 3 type: java.lang.String\n      Local variable type table:\n        [pc: 13, pc: 73] local: strings index: 2 type: java.util.List<java.lang.String>\n      Stack map table: number of frames 2\n        [pc: 55, append: {java.util.concurrent.locks.Lock, java.util.List}]\n        [pc: 62, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void testBug359495b() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nimport java.util.Iterator;\nimport java.util.concurrent.locks.Lock;\nimport java.util.Arrays;\nimport java.util.concurrent.locks.ReentrantLock;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tfinal Lock lock = new ReentrantLock();\n\t\tfinal List<String> strings = Arrays.asList(args);\n\t\tlock.lock();\n\t\ttry{\n\t\t\tfor (Iterator i = strings.iterator(); i.hasNext();){\n\t\t\t\treturn;\n\t\t\t}\n\t\t\treturn;\n\t\t} finally {\n\t\t\tlock.unlock();\n\t\t}\t}\n}"}, "");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 5\n  public static void main(java.lang.String[] args);\n     0  new java.util.concurrent.locks.ReentrantLock [16]\n     3  dup\n     4  invokespecial java.util.concurrent.locks.ReentrantLock() [18]\n     7  astore_1 [lock]\n     8  aload_0 [args]\n     9  invokestatic java.util.Arrays.asList(java.lang.Object[]) : java.util.List [19]\n    12  astore_2 [strings]\n    13  aload_1 [lock]\n    14  invokeinterface java.util.concurrent.locks.Lock.lock() : void [25] [nargs: 1]\n    19  aload_2 [strings]\n    20  invokeinterface java.util.List.iterator() : java.util.Iterator [30] [nargs: 1]\n    25  astore_3 [i]\n    26  aload_3 [i]\n    27  invokeinterface java.util.Iterator.hasNext() : boolean [36] [nargs: 1]\n    32  ifeq 42\n    35  aload_1 [lock]\n    36  invokeinterface java.util.concurrent.locks.Lock.unlock() : void [42] [nargs: 1]\n    41  return\n    42  aload_1 [lock]\n    43  invokeinterface java.util.concurrent.locks.Lock.unlock() : void [42] [nargs: 1]\n    48  return\n    49  astore 4\n    51  aload_1 [lock]\n    52  invokeinterface java.util.concurrent.locks.Lock.unlock() : void [42] [nargs: 1]\n    57  aload 4\n    59  athrow\n      Exception Table:\n        [pc: 19, pc: 35] -> 49 when : any\n      Line numbers:\n        [pc: 0, line: 8]\n        [pc: 8, line: 9]\n        [pc: 13, line: 10]\n        [pc: 19, line: 12]\n        [pc: 35, line: 17]\n        [pc: 41, line: 13]\n        [pc: 42, line: 17]\n        [pc: 48, line: 15]\n        [pc: 49, line: 16]\n        [pc: 51, line: 17]\n        [pc: 57, line: 18]\n      Local variable table:\n        [pc: 0, pc: 60] local: args index: 0 type: java.lang.String[]\n        [pc: 8, pc: 60] local: lock index: 1 type: java.util.concurrent.locks.Lock\n        [pc: 13, pc: 60] local: strings index: 2 type: java.util.List\n        [pc: 26, pc: 42] local: i index: 3 type: java.util.Iterator\n      Local variable type table:\n        [pc: 13, pc: 60] local: strings index: 2 type: java.util.List<java.lang.String>\n      Stack map table: number of frames 2\n        [pc: 42, append: {java.util.concurrent.locks.Lock, java.util.List}]\n        [pc: 49, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test055() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttestError(3, 4, \"d\");\n\t}\n\tpublic static void testError(Number n0, Number n1, String refValue) {\n\t\tNumber result = refValue.equals(\"ttt\") ? n0 : (n1 == null ? null : n1.intValue());\n\t\tSystem.out.println(String.valueOf(result));\n\t}\n}"}, "4");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #27 (Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/String;)V\n  // Stack: 2, Locals: 4\n  public static void testError(java.lang.Number n0, java.lang.Number n1, java.lang.String refValue);\n     0  aload_2 [refValue]\n     1  ldc <String \"ttt\"> [30]\n     3  invokevirtual java.lang.String.equals(java.lang.Object) : boolean [32]\n     6  ifeq 13\n     9  aload_0 [n0]\n    10  goto 28\n    13  aload_1 [n1]\n    14  ifnonnull 21\n    17  aconst_null\n    18  goto 28\n    21  aload_1 [n1]\n    22  invokevirtual java.lang.Number.intValue() : int [38]\n    25  invokestatic java.lang.Integer.valueOf(int) : java.lang.Integer [16]\n    28  astore_3 [result]\n    29  getstatic java.lang.System.out : java.io.PrintStream [44]\n    32  aload_3 [result]\n    33  invokestatic java.lang.String.valueOf(java.lang.Object) : java.lang.String [50]\n    36  invokevirtual java.io.PrintStream.println(java.lang.String) : void [53]\n    39  return\n      Line numbers:\n        [pc: 0, line: 6]\n        [pc: 29, line: 7]\n        [pc: 39, line: 8]\n      Local variable table:\n        [pc: 0, pc: 40] local: n0 index: 0 type: java.lang.Number\n        [pc: 0, pc: 40] local: n1 index: 1 type: java.lang.Number\n        [pc: 0, pc: 40] local: refValue index: 2 type: java.lang.String\n        [pc: 29, pc: 40] local: result index: 3 type: java.lang.Number\n      Stack map table: number of frames 3\n        [pc: 13, same]\n        [pc: 21, same]\n        [pc: 28, same_locals_1_stack_item, stack: {java.lang.Number}]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test055a() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        Object o = args != null ? args : (args == null ? null : args.length);\n    }\n}\n"}, "");
    }

    public void test056() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.io.BufferedReader;\nimport java.io.Closeable;\nimport java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\n\npublic class X {\n\n\tstatic class C implements Closeable {\n\t\t@Override\n\t\tpublic void close() throws IOException {\n\t\t\t//\n\t\t}\n\t}\n\n\tint run() throws IOException {\n\t\tint lcnt = 0;\n\t\ttry (C c = new C();) {\n\t\t\ttry (final BufferedReader br = new BufferedReader(new FileReader(\n\t\t\t\t\tnew File(\"logging.properties\")))) {\n\t\t\t\tString s = null;\n\t\t\t\twhile ((s = br.readLine()) != null)\n\t\t\t\t\tlcnt++;\n\t\t\t\treturn lcnt;\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"read \" + lcnt + \" lines\");\n\t\t}\n\t}\n\n\tpublic static void main(final String[] args) throws IOException {\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test057() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void run() {\n        String s;\n        label1: do {\n            for (;;) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test058() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void run() {\n        String s;\n        label1: do {\n            for (;true;) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test059() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void run() {\n        String s;\n        label1: do {\n            for (;false;) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tlabel1: do {\n\t^^^^^^\nThe label label1 is never explicitly referenced\n----------\n2. ERROR in X.java (at line 5)\n\tfor (;false;) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n3. ERROR in X.java (at line 10)\n\t} while (s != null);\n\t         ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test060() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void run() {\n        String s;\n        label1: do {\n            for (; 5 < 10;) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test061() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void run() {\n        int five = 5, ten = 10;\n        String s;\n        label1: do {\n            for (; five < ten;) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tcontinue label1;\n\t^^^^^^^^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 11)\n\t} while (s != null);\n\t         ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test062() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void run() {\n        final int five = 5, ten = 10;\n        String s;\n        label1: do {\n            for (; five < ten;) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test063() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void run() {\n        final int five = 5, ten = 10;\n        String s;\n        label1: do {\n            for (; five > ten;) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tlabel1: do {\n\t^^^^^^\nThe label label1 is never explicitly referenced\n----------\n2. ERROR in X.java (at line 6)\n\tfor (; five > ten;) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n\t                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n3. ERROR in X.java (at line 11)\n\t} while (s != null);\n\t         ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test064() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void run() {\n        String s;\n        label1: do {\n            while (true) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test065() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void run() {\n        String s;\n        label1: do {\n            while (false) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tlabel1: do {\n\t^^^^^^\nThe label label1 is never explicitly referenced\n----------\n2. ERROR in X.java (at line 5)\n\twhile (false) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n3. ERROR in X.java (at line 10)\n\t} while (s != null);\n\t         ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test066() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void run() {\n        String s;\n        label1: do {\n            while(5 < 10) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test067() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void run() {\n        int five = 5, ten = 10;\n        String s;\n        label1: do {\n            while (five < ten) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tcontinue label1;\n\t^^^^^^^^^^^^^^^^\nDead code\n----------\n2. ERROR in X.java (at line 11)\n\t} while (s != null);\n\t         ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test068() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void run() {\n        final int five = 5, ten = 10;\n        String s;\n        label1: do {\n            while (five < ten) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
    }

    public void test069() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void run() {\n        final int five = 5, ten = 10;\n        String s;\n        label1: do {\n            while (five > ten) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n        } while (s != null);\n}\n    public static void main(String [] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tlabel1: do {\n\t^^^^^^\nThe label label1 is never explicitly referenced\n----------\n2. ERROR in X.java (at line 6)\n\twhile (five > ten) {\n                s = \"\";\n                if (s == null) \n                    continue label1;\n            }\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnreachable code\n----------\n3. ERROR in X.java (at line 11)\n\t} while (s != null);\n\t         ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test070() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.Iterator;\nimport java.util.List;\nimport java.util.Properties;\nimport org.w3c.dom.*;\npublic class X extends Object {\n        public static void main(String [] args) {\n            System.out.println (\"SUCCESS\");\n        }\n\tprivate static class Handler extends Object {\n\t\tpublic int getStuff() {\n\t\t\treturn 1;\n\t\t}\n\t\tpublic void handle(Element element) {\n\t\t\tProperties properties = new Properties();\n\t\t\tNamedNodeMap atts = element.getAttributes();\n\t\t\tif (atts != null) {\n\t\t\t\tfor (int a = 0; a < atts.getLength(); a++) {\n\t\t\t\t\tNode att = atts.item(a);\n\t\t\t\t\tString name = att.getNodeName();\n\t\t\t\t\tString value = att.getNodeValue();\n\t\t\t\t\tif (\"foo\".equals(name)) {\n\t\t\t\t\t\tname = value;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif (!\"bar\".equals(name))\n\t\t\t\t\t\t\tcontinue;\n\t\t\t\t\t\tname = value;\n\t\t\t\t\t}\n\t\t\t\t\tproperties.put(name, value);\n\t\t\t\t}\n\t\t\t}\n\t\t\tlabel0: do {\n\t\t\t\tNode node;\n\t\t\t\tString nodeName;\n\t\t\t\tlabel1: do {\n\t\t\t\t\tfor (Iterator i = (new ArrayList(1)).iterator(); i\n\t\t\t\t\t\t\t.hasNext(); members.add(equals(node))) {\n\t\t\t\t\t\tnode = (Node) i.next();\n\t\t\t\t\t\tnodeName = \"\" + equals(node.getNodeName());\n\t\t\t\t\t\tif (!\"foo\".equals(nodeName))\n\t\t\t\t\t\t\tcontinue label1;\n\t\t\t\t\t}\n\t\t\t\t\tbreak label0;\n\t\t\t\t} while (!\"bar\".equals(nodeName));\n\t\t\t\tIterator i = (new ArrayList(1)).iterator();\n\t\t\t\twhile (i.hasNext()) {\n\t\t\t\t\tNode n = (Node) i.next();\n\t\t\t\t\tString name = toString() + n.getNodeName();\n\t\t\t\t\tif (\"wtf\".equals(name)) {\n\t\t\t\t\t\tString propertyName = (toString() + n.getAttributes()\n\t\t\t\t\t\t\t\t.getNamedItem(\"broken\")).trim();\n\t\t\t\t\t\tString value = toString() + n;\n\t\t\t\t\t\tproperties.put(propertyName, value);\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} while (true);\n\t\t\tpropertiesBuilder.equals(properties);\n\t\t\tbuilder.equals(propertiesBuilder.hashCode());\n\t\t\tbuilder.equals(members);\n\t\t}\n\t\tprivate final Object c;\n\t\tprivate Object builder;\n\t\tprivate List members;\n\t\tprivate Object propertiesBuilder;\n\t\tpublic Handler(Object c) {\n\t\t\tthis.c = c;\n\t\t\tbuilder = Arrays.asList(Object.class);\n\t\t\tbuilder.equals(\"foo\");\n\t\t\tbuilder.equals(\"bar\");\n\t\t\tmembers = new ArrayList();\n\t\t\tpropertiesBuilder = Arrays.asList(Object.class);\n\t\t\tObject beanDefinition = propertiesBuilder.toString();\n\t\t\tObject holder = new String(\"stirng\");\n\t\t\tArrays.asList(holder, c.toString());\n\t\t}\n\t}\n\tpublic X() {\n\t}\n\tprotected Object parseInternal(Element element, Object c) {\n\t\tHandler h = new Handler(c);\n\t\th.handle(element);\n\t\treturn h.getStuff();\n\t}\n}\n"}, "SUCCESS");
    }

    public void testBug380313() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\npublic void foo() throws Exception {\n        int i = 1;\n        try {\n            if (i == 1) {\n                int n = bar();\n                if (n == 35)\n                   return;\n            } else {\n                throw new Exception();\n            }\n            if (i == 0)\n               return;\n        } finally {\n            bar();\n        }\n    }\n\n    private int bar() {\n        return 0;\n    }\n\n    public static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 2, Locals: 4\n  public void foo() throws java.lang.Exception;\n     0  iconst_1\n     1  istore_1 [i]\n     2  iload_1 [i]\n     3  iconst_1\n     4  if_icmpne 24\n     7  aload_0 [this]\n     8  invokespecial X.bar() : int [18]\n    11  istore_2 [n]\n    12  iload_2 [n]\n    13  bipush 35\n    15  if_icmpne 32\n    18  aload_0 [this]\n    19  invokespecial X.bar() : int [18]\n    22  pop\n    23  return\n    24  new java.lang.Exception [16]\n    27  dup\n    28  invokespecial java.lang.Exception() [22]\n    31  athrow\n    32  iload_1 [i]\n    33  ifne 50\n    36  aload_0 [this]\n    37  invokespecial X.bar() : int [18]\n    40  pop\n    41  return\n    42  astore_3\n    43  aload_0 [this]\n    44  invokespecial X.bar() : int [18]\n    47  pop\n    48  aload_3\n    49  athrow\n    50  aload_0 [this]\n    51  invokespecial X.bar() : int [18]\n    54  pop\n    55  return\n      Exception Table:\n        [pc: 2, pc: 18] -> 42 when : any\n        [pc: 24, pc: 36] -> 42 when : any\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 5]\n        [pc: 7, line: 6]\n        [pc: 12, line: 7]\n        [pc: 18, line: 15]\n        [pc: 23, line: 8]\n        [pc: 24, line: 10]\n        [pc: 32, line: 12]\n        [pc: 36, line: 15]\n        [pc: 41, line: 13]\n        [pc: 42, line: 14]\n        [pc: 43, line: 15]\n        [pc: 48, line: 16]\n        [pc: 50, line: 15]\n        [pc: 55, line: 17]\n      Local variable table:\n        [pc: 0, pc: 56] local: this index: 0 type: X\n        [pc: 2, pc: 56] local: i index: 1 type: int\n        [pc: 12, pc: 24] local: n index: 2 type: int\n      Stack map table: number of frames 4\n        [pc: 24, append: {int}]\n        [pc: 32, same]\n        [pc: 42, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 50, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void testBug380313b() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.io.FileInputStream;\nimport java.io.IOException;\npublic class X {\npublic void foo() throws Exception {\n        int i = 1;\n        try {\n            try (FileInputStream fis = new FileInputStream(\"\")) {\n\t\t\t\t if (i == 2)                \treturn;\n \t\t\t }\n            if (i == 35) \n                return;\n        } catch(IOException e) {\n            bar();\n        } finally {\n            bar();\n        }\n    }\n\n    private int bar() {\n        return 0;\n    }\n\n    public static void main(String[] args) {\n\t\tSystem.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 3, Locals: 6\n  public void foo() throws java.lang.Exception;\n      0  iconst_1\n      1  istore_1 [i]\n      2  aconst_null\n      3  astore_2\n      4  aconst_null\n      5  astore_3\n      6  new java.io.FileInputStream [18]\n      9  dup\n     10  ldc <String \"\"> [20]\n     12  invokespecial java.io.FileInputStream(java.lang.String) [22]\n     15  astore 4 [fis]\n     17  iload_1 [i]\n     18  iconst_2\n     19  if_icmpne 38\n     22  aload 4 [fis]\n     24  ifnull 32\n     27  aload 4 [fis]\n     29  invokevirtual java.io.FileInputStream.close() : void [25]\n     32  aload_0 [this]\n     33  invokespecial X.bar() : int [28]\n     36  pop\n     37  return\n     38  aload 4 [fis]\n     40  ifnull 86\n     43  aload 4 [fis]\n     45  invokevirtual java.io.FileInputStream.close() : void [25]\n     48  goto 86\n     51  astore_2\n     52  aload 4 [fis]\n     54  ifnull 62\n     57  aload 4 [fis]\n     59  invokevirtual java.io.FileInputStream.close() : void [25]\n     62  aload_2\n     63  athrow\n     64  astore_3\n     65  aload_2\n     66  ifnonnull 74\n     69  aload_3\n     70  astore_2\n     71  goto 84\n     74  aload_2\n     75  aload_3\n     76  if_acmpeq 84\n     79  aload_2\n     80  aload_3\n     81  invokevirtual java.lang.Throwable.addSuppressed(java.lang.Throwable) : void [32]\n     84  aload_2\n     85  athrow\n     86  iload_1 [i]\n     87  bipush 35\n     89  if_icmpne 122\n     92  aload_0 [this]\n     93  invokespecial X.bar() : int [28]\n     96  pop\n     97  return\n     98  astore_2 [e]\n     99  aload_0 [this]\n    100  invokespecial X.bar() : int [28]\n    103  pop\n    104  aload_0 [this]\n    105  invokespecial X.bar() : int [28]\n    108  pop\n    109  goto 127\n    112  astore 5\n    114  aload_0 [this]\n    115  invokespecial X.bar() : int [28]\n    118  pop\n    119  aload 5\n    121  athrow\n    122  aload_0 [this]\n    123  invokespecial X.bar() : int [28]\n    126  pop\n    127  return\n      Exception Table:\n        [pc: 17, pc: 22] -> 51 when : any\n        [pc: 32, pc: 38] -> 51 when : any\n        [pc: 6, pc: 64] -> 64 when : any\n        [pc: 2, pc: 32] -> 98 when : java.io.IOException\n        [pc: 38, pc: 92] -> 98 when : java.io.IOException\n        [pc: 2, pc: 32] -> 112 when : any\n        [pc: 38, pc: 92] -> 112 when : any\n        [pc: 98, pc: 104] -> 112 when : any\n      Line numbers:\n        [pc: 0, line: 5]\n        [pc: 2, line: 7]\n        [pc: 17, line: 8]\n        [pc: 22, line: 9]\n        [pc: 32, line: 15]\n        [pc: 37, line: 8]\n        [pc: 38, line: 9]\n        [pc: 86, line: 10]\n        [pc: 92, line: 15]\n        [pc: 97, line: 11]\n        [pc: 98, line: 12]\n        [pc: 99, line: 13]\n        [pc: 104, line: 15]\n        [pc: 112, line: 14]\n        [pc: 114, line: 15]\n        [pc: 119, line: 16]\n        [pc: 122, line: 15]\n        [pc: 127, line: 17]\n      Local variable table:\n        [pc: 0, pc: 128] local: this index: 0 type: X\n        [pc: 2, pc: 128] local: i index: 1 type: int\n        [pc: 17, pc: 62] local: fis index: 4 type: java.io.FileInputStream\n        [pc: 99, pc: 104] local: e index: 2 type: java.io.IOException\n      Stack map table: number of frames 12\n        [pc: 32, full, stack: {}, locals: {X, int, java.lang.Throwable, java.lang.Throwable, java.io.FileInputStream}]\n        [pc: 38, same]\n        [pc: 51, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 62, chop 1 local(s)]\n        [pc: 64, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 74, same]\n        [pc: 84, same]\n        [pc: 86, chop 2 local(s)]\n        [pc: 98, same_locals_1_stack_item, stack: {java.io.IOException}]\n        [pc: 112, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 122, same]\n        [pc: 127, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void testBug380927() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public final static Object f() {\n        final Object a = null;\n        Object b;\n        label: do {\n            switch (0) {\n            case 1: {\n                b = a;\n            }\n                break;\n            default:\n                break label;\n            }\n        } while (true);\n        return a;\n    }\n    public static void main(final String[] args) {\n        f();\n        System.out.println(\"SUCCESS\");\n    }\n}\n"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ()Ljava/lang/Object;\n  // Stack: 1, Locals: 2\n  public static final java.lang.Object f();\n     0  aconst_null\n     1  astore_0 [a]\n     2  iconst_0\n     3  tableswitch default: 25\n          case 1: 20\n    20  aload_0 [a]\n    21  astore_1 [b]\n    22  goto 2\n    25  aload_0 [a]\n    26  areturn\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 2, line: 6]\n        [pc: 20, line: 8]\n        [pc: 22, line: 10]\n        [pc: 25, line: 15]\n      Local variable table:\n        [pc: 2, pc: 27] local: a index: 0 type: java.lang.Object\n        [pc: 22, pc: 25] local: b index: 1 type: java.lang.Object\n      Stack map table: number of frames 3\n        [pc: 2, append: {java.lang.Object}]\n        [pc: 20, same]\n        [pc: 25, same]\n  \n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test385593_1() throws Exception {
        this.runConformTest(new String[]{"stackmap/StackMapTableFormatError.java", "package stackmap;\n\nimport java.util.Collection;\nimport java.util.Collections;\n\n/**\n * If compiled with Eclipse (compiler target >= 1.6) this snippet causes the\n * error \"java.lang.ClassFormatError: StackMapTable format error: bad\n * verification type\" when executed with JaCoCo code coverage. JaCoCo seems to\n * get confused by unexpected stackmap frames generated by ECJ.\n */\npublic class StackMapTableFormatError {\n\n\tpublic static Object exec(Collection<Object> set, Object a,\n\t\t\tboolean b) {\n\t\tfor (Object e : set) {\n\t\t\tif (a != null && (e == null || b)) {\n\t\t\t\tcontinue;\n\t\t\t}\n\t\t\treturn null;\n\t\t}\n\t\treturn null;\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\texec(Collections.emptySet(), null, false);\n\t}\n\n}\n"});
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "stackmap" + File.separator + "StackMapTableFormatError.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 (Ljava/util/Collection;Ljava/lang/Object;Z)Ljava/lang/Object;\n  // Signature: (Ljava/util/Collection<Ljava/lang/Object;>;Ljava/lang/Object;Z)Ljava/lang/Object;\n  // Stack: 1, Locals: 5\n  public static java.lang.Object exec(java.util.Collection set, java.lang.Object a, boolean b);\n     0  aload_0 [set]\n     1  invokeinterface java.util.Collection.iterator() : java.util.Iterator [18] [nargs: 1]\n     6  astore 4\n     8  goto 36\n    11  aload 4\n    13  invokeinterface java.util.Iterator.next() : java.lang.Object [24] [nargs: 1]\n    18  astore_3 [e]\n    19  aload_1 [a]\n    20  ifnull 34\n    23  aload_3 [e]\n    24  ifnull 36\n    27  iload_2 [b]\n    28  ifeq 34\n    31  goto 36\n    34  aconst_null\n    35  areturn\n    36  aload 4\n    38  invokeinterface java.util.Iterator.hasNext() : boolean [30] [nargs: 1]\n    43  ifne 11\n    46  aconst_null\n    47  areturn\n      Line numbers:\n        [pc: 0, line: 16]\n        [pc: 19, line: 17]\n        [pc: 31, line: 18]\n        [pc: 34, line: 20]\n        [pc: 36, line: 16]\n        [pc: 46, line: 22]\n      Local variable table:\n        [pc: 0, pc: 48] local: set index: 0 type: java.util.Collection\n        [pc: 0, pc: 48] local: a index: 1 type: java.lang.Object\n        [pc: 0, pc: 48] local: b index: 2 type: boolean\n        [pc: 19, pc: 36] local: e index: 3 type: java.lang.Object\n      Local variable type table:\n        [pc: 0, pc: 48] local: set index: 0 type: java.util.Collection<java.lang.Object>\n      Stack map table: number of frames 3\n        [pc: 11, full, stack: {}, locals: {java.util.Collection, java.lang.Object, int, _, java.util.Iterator}]\n        [pc: 34, full, stack: {}, locals: {java.util.Collection, java.lang.Object, int, java.lang.Object, java.util.Iterator}]\n        [pc: 36, full, stack: {}, locals: {java.util.Collection, java.lang.Object, int, _, java.util.Iterator}]";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test385593_2() throws Exception {
        this.runConformTest(new String[]{"snippet/X.java", "package snippet;\n\n\npublic class X { \n\tprivate void foo(boolean delete) { \n\t\t \n\t\tString s = bar(); \n\t\tStringBuffer buffer =new StringBuffer(); \n\t\t \n\t\ttry { \n\t\t\t \n\t\t\tString[] datas = new String[] { \"\" }; \n\t\t\tObject[] data= new Object[] { s }; \n\t\t\ttry { \n\t\t\t\tbuffer.append(datas).append(data); \n\t\t\t} catch (Exception e) { \n\t\t\t\tif (e != null) \n\t\t\t\t\tthrow e; \n\t\t\t\treturn; \n\t\t\t} \n\t\t\t\t \n\t\t\tif (delete) \n\t\t\t\tbuffer.delete(0, buffer.length()); \n\t\t\t \n\t\t} catch (Exception x) { \n\t\t} finally { \n\t\t\tbuffer = null; \n\t\t} \n\t} \n\t \n\tString bar() { \n\t\treturn \"\"; \n\t} \n\t \n\tpublic static void main(String[] args) { \n\t\tnew X().foo(false); \n\t\tSystem.out.println(\"SUCCESS\"); \n\t} \n}\n"});
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "snippet" + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "Stack map table: number of frames 7\n        [pc: 49, full, stack: {java.lang.Exception}, locals: {snippet.X, int, java.lang.String, java.lang.StringBuffer, java.lang.String[], java.lang.Object[]}]\n        [pc: 59, append: {java.lang.Exception}]\n        [pc: 62, chop 1 local(s)]\n        [pc: 79, full, stack: {java.lang.Exception}, locals: {snippet.X, int, java.lang.String, java.lang.StringBuffer}]\n        [pc: 86, same_locals_1_stack_item, stack: {java.lang.Throwable}]\n        [pc: 93, same]\n        [pc: 95, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test394718() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X\n{\n\tpublic static Boolean test() throws Exception\n\t{\n\t\ttry\n\t\t{\n\t\t\tfor (int i = 0; i < 1; i++)\n\t\t\t{\n\t\t\t\tlong status = System.currentTimeMillis();\n\t\t\t\tif (status < 0)\n\t\t\t\t\treturn false;\n\t\t\t\tif (status == 1)\n\t\t\t\t\treturn false;\n\t\t\t}\n\t\t\t\n\t\t\treturn false;\n\t\t}\n\t\tfinally\n\t\t{\n\t\t\tSystem.currentTimeMillis();\n\t\t}\n\t}\n\t\n\tpublic static void main(String[] args) throws Exception\n\t{\n\t\tSystem.out.print(\"Starting\");\n\t\ttest();\n\t\tSystem.out.println(\"Done\");\n\t}\n}"}, "StartingDone");
    }

    public void testBug412203_a() throws Exception {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.nullReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runConformTest(new String[]{"X2.java", "import java.util.*;\n\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n\nclass Y {\n\tpublic Y() { }\n}\n\n@NonNullByDefault\nabstract class X1 {\n\n\tprivate Object a;\n\tprivate Object b;\n\tprivate Object c;\n\tprivate Object d;\n\tprivate Object e;\n\tprivate Object f;\n\n\tprotected Object name;\n\n\t@SuppressWarnings(\"null\")\n\tprotected X1() {\n\t\tsuper ();\n\t}\n\n}\npublic class X2 extends X1 {\n\n\n\tpublic static final int ID = 4711;\n\n\tprivate Object x;\n\tprivate Object y;\n\tprivate Object z;\n\n\tprivate Runnable runable = new Runnable () {\n\t\t@Override\n\t\tpublic void run () {\n\t\t\t// whatever\n\t\t}\n\t};\n\n\tprivate void init () {\n\t\tfinal Object selector = new Object ();\n\t\tthis.name = new Object ();\n\t\tLinkedList<Character> invalidCharactersList = new LinkedList<> ();\n\t\tchar[] invalidCharacters = new char[invalidCharactersList.size ()];\n\t\tfor (int i = 0; i < invalidCharacters.length; i++) {\n\t\t\tinvalidCharacters[i] = invalidCharactersList.get (i).charValue ();\n\t\t}\n\t\tY inputVerifier = new Y();\n\t}\n\n}\n"}, "", this.getLibsWithNullAnnotations(0x330000L), true, null, options, null, true);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X2.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #16 ()V\n  // Stack: 4, Locals: 5\n  private void init();\n     0  new java.lang.Object [32]\n     3  dup\n     4  invokespecial java.lang.Object() [34]\n     7  astore_1 [selector]\n     8  aload_0 [this]\n     9  new java.lang.Object [32]\n    12  dup\n    13  invokespecial java.lang.Object() [34]\n    16  putfield X2.name : java.lang.Object [35]\n    19  new java.util.LinkedList [38]\n    22  dup\n    23  invokespecial java.util.LinkedList() [40]\n    26  astore_2 [invalidCharactersList]\n    27  aload_2 [invalidCharactersList]\n    28  invokevirtual java.util.LinkedList.size() : int [41]\n    31  newarray char [5]\n    33  astore_3 [invalidCharacters]\n    34  iconst_0\n    35  istore 4 [i]\n    37  goto 59\n    40  aload_3 [invalidCharacters]\n    41  iload 4 [i]\n    43  aload_2 [invalidCharactersList]\n    44  iload 4 [i]\n    46  invokevirtual java.util.LinkedList.get(int) : java.lang.Object [45]\n    49  checkcast java.lang.Character [49]\n    52  invokevirtual java.lang.Character.charValue() : char [51]\n    55  castore\n    56  iinc 4 1 [i]\n    59  iload 4 [i]\n    61  aload_3 [invalidCharacters]\n    62  arraylength\n    63  if_icmplt 40\n    66  new Y [55]\n    69  dup\n    70  invokespecial Y() [57]\n    73  astore 4 [inputVerifier]\n    75  return\n      Line numbers:\n        [pc: 0, line: 44]\n        [pc: 8, line: 45]\n        [pc: 19, line: 46]\n        [pc: 27, line: 47]\n        [pc: 34, line: 48]\n        [pc: 40, line: 49]\n        [pc: 56, line: 48]\n        [pc: 66, line: 51]\n        [pc: 75, line: 52]\n      Local variable table:\n        [pc: 0, pc: 76] local: this index: 0 type: X2\n        [pc: 8, pc: 76] local: selector index: 1 type: java.lang.Object\n        [pc: 27, pc: 76] local: invalidCharactersList index: 2 type: java.util.LinkedList\n        [pc: 34, pc: 76] local: invalidCharacters index: 3 type: char[]\n        [pc: 37, pc: 66] local: i index: 4 type: int\n        [pc: 75, pc: 76] local: inputVerifier index: 4 type: Y\n      Local variable type table:\n        [pc: 27, pc: 76] local: invalidCharactersList index: 2 type: java.util.LinkedList<java.lang.Character>\n      Stack map table: number of frames 2\n        [pc: 40, full, stack: {}, locals: {X2, java.lang.Object, java.util.LinkedList, char[], int}]\n        [pc: 59, same]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void testBug412203_b() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.nullReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runConformTest(new String[]{"X2.java", "import java.util.LinkedList;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\nabstract class X1 {\n\tprotected @NonNull Object name = new Object();\n}\n\npublic class X2 extends X1 {\n\tvoid init () {\n\t\tthis.name = new Object ();\n\t\tLinkedList<Character> l = new LinkedList<Character> ();\n\t\tchar[] cs = new char[l.size ()];\n\t\tfor (int i = 0; i < cs.length; i++) {\n\t\t\tcs[i] = l.get (i).charValue ();\n\t\t}\n\t\tObject o2 = new Object();\n\t}\n}\n"}, "", this.getLibsWithNullAnnotations(0x330000L), true, null, options, null, true);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X2.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 4, Locals: 4\n  void init();\n     0  aload_0 [this]\n     1  new java.lang.Object [15]\n     4  dup\n     5  invokespecial java.lang.Object() [17]\n     8  putfield X2.name : java.lang.Object [18]\n    11  new java.util.LinkedList [22]\n    14  dup\n    15  invokespecial java.util.LinkedList() [24]\n    18  astore_1 [l]\n    19  aload_1 [l]\n    20  invokevirtual java.util.LinkedList.size() : int [25]\n    23  newarray char [5]\n    25  astore_2 [cs]\n    26  iconst_0\n    27  istore_3 [i]\n    28  goto 48\n    31  aload_2 [cs]\n    32  iload_3 [i]\n    33  aload_1 [l]\n    34  iload_3 [i]\n    35  invokevirtual java.util.LinkedList.get(int) : java.lang.Object [29]\n    38  checkcast java.lang.Character [33]\n    41  invokevirtual java.lang.Character.charValue() : char [35]\n    44  castore\n    45  iinc 3 1 [i]\n    48  iload_3 [i]\n    49  aload_2 [cs]\n    50  arraylength\n    51  if_icmplt 31\n    54  new java.lang.Object [15]\n    57  dup\n    58  invokespecial java.lang.Object() [17]\n    61  astore_3 [o2]\n    62  return\n      Line numbers:\n        [pc: 0, line: 11]\n        [pc: 11, line: 12]\n        [pc: 19, line: 13]\n        [pc: 26, line: 14]\n        [pc: 31, line: 15]\n        [pc: 45, line: 14]\n        [pc: 54, line: 17]\n        [pc: 62, line: 18]\n      Local variable table:\n        [pc: 0, pc: 63] local: this index: 0 type: X2\n        [pc: 19, pc: 63] local: l index: 1 type: java.util.LinkedList\n        [pc: 26, pc: 63] local: cs index: 2 type: char[]\n        [pc: 28, pc: 54] local: i index: 3 type: int\n        [pc: 62, pc: 63] local: o2 index: 3 type: java.lang.Object\n      Local variable type table:\n        [pc: 19, pc: 63] local: l index: 1 type: java.util.LinkedList<java.lang.Character>\n      Stack map table: number of frames 2\n        [pc: 31, append: {java.util.LinkedList, char[], int}]\n        [pc: 48, same]\n}";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void testBug412203_c() throws Exception {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
        options.put("org.eclipse.jdt.core.compiler.problem.nullReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.nullSpecViolation", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runConformTest(new String[]{"X2.java", "import java.util.LinkedList;\n\nimport org.eclipse.jdt.annotation.NonNull;\n\nabstract class X1 {\n\tprotected @NonNull Object name = new Object();\n}\n\npublic class X2 extends X1 {\n\tvoid init () {\n\t\tname = new Object ();\n\t\tLinkedList<Character> l = new LinkedList<Character> ();\n\t\tchar[] cs = new char[l.size ()];\n\t\tfor (int i = 0; i < cs.length; i++) {\n\t\t\tcs[i] = l.get (i).charValue ();\n\t\t}\n\t\tObject o2 = new Object();\n\t}\n}\n"}, "", this.getLibsWithNullAnnotations(0x330000L), true, null, options, null, true);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X2.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 4, Locals: 4\n  void init();\n     0  aload_0 [this]\n     1  new java.lang.Object [15]\n     4  dup\n     5  invokespecial java.lang.Object() [17]\n     8  putfield X2.name : java.lang.Object [18]\n    11  new java.util.LinkedList [22]\n    14  dup\n    15  invokespecial java.util.LinkedList() [24]\n    18  astore_1 [l]\n    19  aload_1 [l]\n    20  invokevirtual java.util.LinkedList.size() : int [25]\n    23  newarray char [5]\n    25  astore_2 [cs]\n    26  iconst_0\n    27  istore_3 [i]\n    28  goto 48\n    31  aload_2 [cs]\n    32  iload_3 [i]\n    33  aload_1 [l]\n    34  iload_3 [i]\n    35  invokevirtual java.util.LinkedList.get(int) : java.lang.Object [29]\n    38  checkcast java.lang.Character [33]\n    41  invokevirtual java.lang.Character.charValue() : char [35]\n    44  castore\n    45  iinc 3 1 [i]\n    48  iload_3 [i]\n    49  aload_2 [cs]\n    50  arraylength\n    51  if_icmplt 31\n    54  new java.lang.Object [15]\n    57  dup\n    58  invokespecial java.lang.Object() [17]\n    61  astore_3 [o2]\n    62  return\n      Line numbers:\n        [pc: 0, line: 11]\n        [pc: 11, line: 12]\n        [pc: 19, line: 13]\n        [pc: 26, line: 14]\n        [pc: 31, line: 15]\n        [pc: 45, line: 14]\n        [pc: 54, line: 17]\n        [pc: 62, line: 18]\n      Local variable table:\n        [pc: 0, pc: 63] local: this index: 0 type: X2\n        [pc: 19, pc: 63] local: l index: 1 type: java.util.LinkedList\n        [pc: 26, pc: 63] local: cs index: 2 type: char[]\n        [pc: 28, pc: 54] local: i index: 3 type: int\n        [pc: 62, pc: 63] local: o2 index: 3 type: java.lang.Object\n      Local variable type table:\n        [pc: 19, pc: 63] local: l index: 1 type: java.util.LinkedList<java.lang.Character>\n      Stack map table: number of frames 2\n        [pc: 31, append: {java.util.LinkedList, char[], int}]\n        [pc: 48, same]\n}";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            StackMapAttributeTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }
}

