/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class SuperTypeTest
extends AbstractRegressionTest {
    public SuperTypeTest(String name) {
        super(name);
    }

    public static Test suite() {
        return SuperTypeTest.buildAllCompliancesTestSuite(SuperTypeTest.testClass());
    }

    public static Class testClass() {
        return SuperTypeTest.class;
    }

    public void test001() {
        this.runConformTest(new String[]{"org/eclipse/curiosity/A.java", "package org.eclipse.curiosity;\npublic abstract class A implements InterfaceA {\n\tprivate void e() {\n\t}\n\tpublic void f() {\n\t\tthis.e();\n\t}\n}", "org/eclipse/curiosity/InterfaceA.java", "package org.eclipse.curiosity;\npublic interface InterfaceA extends InterfaceBase {}\n", "org/eclipse/curiosity/InterfaceBase.java", "package org.eclipse.curiosity;\npublic interface InterfaceBase {\n    public void a();\n    public void b();\n    public void c();\n    public void d();\n}"});
    }

    public void test002() {
        String[] sources = new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tclass M { \n\t} \n\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tM m; \n\t\t}; \n\t\tSystem.out.println(\"SUCCESS\");\t\n\t} \n} \nclass Secondary { \n\tclass M {} \n} \n"};
        if (this.complianceLevel == 0x2F0000L) {
            this.runNegativeTest(sources, "----------\n1. ERROR in p1\\Test.java (at line 10)\n\tM m; \n\t^\nThe type M is defined in an inherited type and an enclosing scope\n----------\n");
        } else {
            this.runConformTest(sources, "SUCCESS");
        }
    }

    public void test003() {
        String[] sources = new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar() { \n\t\treturn \"FAILED\";\t\n\t} \n\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tString z = bar();\t\n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tString bar(){ return \"SUCCESS\"; } \n} \n"};
        if (this.complianceLevel == 0x2F0000L) {
            this.runNegativeTest(sources, "----------\n1. ERROR in p1\\Test.java (at line 11)\n\tString z = bar();\t\n\t           ^^^\nThe method bar is defined in an inherited type and an enclosing scope\n----------\n");
        } else {
            this.runConformTest(sources, "SUCCESS");
        }
    }

    public void test004() {
        String[] sources = new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar = \"FAILED\";\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tString z = bar; \n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tString bar = \"SUCCESS\"; \n} \n"};
        if (this.complianceLevel == 0x2F0000L) {
            this.runNegativeTest(sources, "----------\n1. ERROR in p1\\Test.java (at line 8)\n\tString z = bar; \n\t           ^^^\nThe field bar is defined in an inherited type and an enclosing scope \n----------\n");
        } else {
            this.runConformTest(sources, "SUCCESS");
        }
    }

    public void test005() {
        this.runConformTest(new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar() { \n\t\treturn \"SUCCESS\";\t\n\t} \n\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tString z = bar();\t\n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tprivate String bar(){ return \"FAILED\"; } \n} \n"}, "SUCCESS");
    }

    public void test006() {
        this.runConformTest(new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar = \"SUCCESS\";\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tString z = bar; \n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tprivate String bar = \"FAILED\"; \n} \n"}, "SUCCESS");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"p1/Test.java", "package p1; \npublic class Test { \n\tpublic static void main(String[] arguments) { \n\t\tnew Test().foo(); \n\t} \n\tString bar() { \n\t\treturn \"FAILED\";\t\n\t} \n\tvoid foo(){ \n\t\tclass Y extends Secondary { \n\t\t\tString z = bar();\t\n\t\t}; \n\t\tSystem.out.println(new Y().z);\t\n\t} \n} \nclass Secondary { \n\tString bar(int i){ return \"SUCCESS\"; } \n} \n"}, "----------\n1. ERROR in p1\\Test.java (at line 11)\n\tString z = bar();\t\n\t           ^^^\nThe method bar(int) in the type Secondary is not applicable for the arguments ()\n----------\n");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "public class X implements I {}\nclass Y extends X implements I, J {}interface I {}\ninterface J {}\n"}, "");
    }

    public void test009() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X implements I {}\nclass Y extends X implements I, J {}\ninterface I {}\ninterface J {}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends X implements I, J {}\n\t                             ^\nRedundant superinterface I for the type Y, already defined by X\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test010() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X implements I {}\nclass Y extends X {}\nclass Z extends Y implements J, I {}\ninterface I {}\ninterface J {}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 3)\n\tclass Z extends Y implements J, I {}\n\t                                ^\nRedundant superinterface I for the type Z, already defined by X\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test011() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "error");
        this.runConformTest(new String[]{"X.java", "public class X implements I {}\nclass Y extends X {}\nclass Z extends Y implements J {}interface I {}\ninterface J {}\n"}, "", null, true, null, customOptions, null);
    }

    public void test012() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X implements J {}\nclass Y extends X implements I {}\ninterface I {}\ninterface J extends I {}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\tclass Y extends X implements I {}\n\t                             ^\nRedundant superinterface I for the type Y, already defined by J\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test013() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "error");
        this.runNegativeTest(true, new String[]{"X.java", "import java.util.*;\ninterface X<E> extends List<E>, Collection<E>, Iterable<E> {}\ninterface Y<E> extends Collection<E>, List<E> {}\ninterface XXX<E> extends Iterable<E>, List<E>, Collection<E> {}\nabstract class Z implements List<Object>, Collection<Object> {}\nabstract class ZZ implements Collection<Object>, List<Object> {}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 2)\n\tinterface X<E> extends List<E>, Collection<E>, Iterable<E> {}\n\t                                ^^^^^^^^^^\nRedundant superinterface Collection<E> for the type X<E>, already defined by List<E>\n----------\n2. ERROR in X.java (at line 2)\n\tinterface X<E> extends List<E>, Collection<E>, Iterable<E> {}\n\t                                               ^^^^^^^^\nRedundant superinterface Iterable<E> for the type X<E>, already defined by List<E>\n----------\n3. ERROR in X.java (at line 3)\n\tinterface Y<E> extends Collection<E>, List<E> {}\n\t                       ^^^^^^^^^^\nRedundant superinterface Collection<E> for the type Y<E>, already defined by List<E>\n----------\n4. ERROR in X.java (at line 4)\n\tinterface XXX<E> extends Iterable<E>, List<E>, Collection<E> {}\n\t                         ^^^^^^^^\nRedundant superinterface Iterable<E> for the type XXX<E>, already defined by List<E>\n----------\n5. ERROR in X.java (at line 4)\n\tinterface XXX<E> extends Iterable<E>, List<E>, Collection<E> {}\n\t                                               ^^^^^^^^^^\nRedundant superinterface Collection<E> for the type XXX<E>, already defined by List<E>\n----------\n6. ERROR in X.java (at line 5)\n\tabstract class Z implements List<Object>, Collection<Object> {}\n\t                                          ^^^^^^^^^^\nRedundant superinterface Collection<Object> for the type Z, already defined by List<Object>\n----------\n7. ERROR in X.java (at line 6)\n\tabstract class ZZ implements Collection<Object>, List<Object> {}\n\t                             ^^^^^^^^^^\nRedundant superinterface Collection<Object> for the type ZZ, already defined by List<Object>\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test014() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X implements I, J {}", "I.java", "public interface I {}", "J.java", "public interface J extends I {}"}, null, customOptions, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements I, J {}\n\t                          ^\nRedundant superinterface I for the type X, already defined by J\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test015() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "error");
        this.runNegativeTest(true, new String[]{"X.java", "interface IVerticalRulerColumn {}\ninterface IVerticalRulerInfo {}\ninterface IVerticalRulerInfoExtension {}\ninterface IChangeRulerColumn extends IVerticalRulerColumn, IVerticalRulerInfoExtension {}\ninterface IRevisionRulerColumn extends IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\npublic final class X implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension, IChangeRulerColumn, IRevisionRulerColumn {}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 6)\n\tpublic final class X implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension, IChangeRulerColumn, IRevisionRulerColumn {}\n\t                                ^^^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerColumn for the type X, already defined by IChangeRulerColumn\n----------\n2. ERROR in X.java (at line 6)\n\tpublic final class X implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension, IChangeRulerColumn, IRevisionRulerColumn {}\n\t                                                      ^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerInfo for the type X, already defined by IRevisionRulerColumn\n----------\n3. ERROR in X.java (at line 6)\n\tpublic final class X implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension, IChangeRulerColumn, IRevisionRulerColumn {}\n\t                                                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerInfoExtension for the type X, already defined by IChangeRulerColumn\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test016() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "error");
        this.runNegativeTest(true, new String[]{"X.java", "interface IVerticalRulerColumn {}\ninterface IVerticalRulerInfo {}\ninterface IVerticalRulerInfoExtension {}\ninterface IChangeRulerColumn extends IVerticalRulerColumn, IVerticalRulerInfoExtension {}\ninterface IRevisionRulerColumn extends IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\nclass Z implements IChangeRulerColumn {}\nclass Y extends Z implements IRevisionRulerColumn {}\npublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 8)\n\tpublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n\t                                          ^^^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerColumn for the type X, already defined by IRevisionRulerColumn\n----------\n2. ERROR in X.java (at line 8)\n\tpublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n\t                                                                ^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerInfo for the type X, already defined by IRevisionRulerColumn\n----------\n3. ERROR in X.java (at line 8)\n\tpublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n\t                                                                                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerInfoExtension for the type X, already defined by IRevisionRulerColumn\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test017() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "error");
        this.runNegativeTest(true, new String[]{"X.java", "interface IVerticalRulerColumn {}\ninterface IVerticalRulerInfo {}\ninterface IVerticalRulerInfoExtension {}\ninterface IChangeRulerColumn extends IVerticalRulerColumn, IVerticalRulerInfoExtension {}\ninterface IRevisionRulerColumn extends IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\nclass Z implements IRevisionRulerColumn{}\nclass C extends Z {}\nclass B extends C implements IChangeRulerColumn {}\nclass H extends B {}\nclass Y extends H  {}\npublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 11)\n\tpublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n\t                                          ^^^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerColumn for the type X, already defined by IRevisionRulerColumn\n----------\n2. ERROR in X.java (at line 11)\n\tpublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n\t                                                                ^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerInfo for the type X, already defined by IRevisionRulerColumn\n----------\n3. ERROR in X.java (at line 11)\n\tpublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n\t                                                                                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerInfoExtension for the type X, already defined by IRevisionRulerColumn\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test018() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.redundantSuperinterface", "error");
        this.runNegativeTest(true, new String[]{"X.java", "interface IVerticalRulerColumn {}\ninterface IVerticalRulerInfo {}\ninterface IVerticalRulerInfoExtension {}\ninterface IChangeRulerColumn extends IVerticalRulerColumn, IVerticalRulerInfoExtension {}\ninterface IRevisionRulerColumn extends IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\nclass Z implements IVerticalRulerInfoExtension {}\nclass C extends Z {}\nclass B extends C implements IChangeRulerColumn {}\nclass H extends B implements IVerticalRulerInfo {}\nclass Y extends H  implements IVerticalRulerColumn {}\npublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n"}, null, customOptions, "----------\n1. ERROR in X.java (at line 10)\n\tclass Y extends H  implements IVerticalRulerColumn {}\n\t                              ^^^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerColumn for the type Y, already defined by IChangeRulerColumn\n----------\n2. ERROR in X.java (at line 11)\n\tpublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n\t                                          ^^^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerColumn for the type X, already defined by Y\n----------\n3. ERROR in X.java (at line 11)\n\tpublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n\t                                                                ^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerInfo for the type X, already defined by H\n----------\n4. ERROR in X.java (at line 11)\n\tpublic final class X extends Y implements IVerticalRulerColumn, IVerticalRulerInfo, IVerticalRulerInfoExtension {}\n\t                                                                                    ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nRedundant superinterface IVerticalRulerInfoExtension for the type X, already defined by Z\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP);
    }
}

