/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class TryStatement17Test
extends AbstractRegressionTest {
    public TryStatement17Test(String name) {
        super(name);
    }

    public static Test suite() {
        return TryStatement17Test.buildMinimalComplianceTestSuite(TryStatement17Test.testClass(), 16);
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println();\n\t\t\tReader r = new FileReader(args[0]);\n\t\t\tr.read();\n\t\t} catch(IOException | FileNotFoundException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t} catch(IOException | FileNotFoundException e) {\n\t                      ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative IOException\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println();\n\t\t\tReader r = new FileReader(args[0]);\n\t\t\tr.read();\n\t\t} catch(FileNotFoundException | FileNotFoundException | IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t} catch(FileNotFoundException | FileNotFoundException | IOException e) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative FileNotFoundException\n----------\n2. ERROR in X.java (at line 9)\n\t} catch(FileNotFoundException | FileNotFoundException | IOException e) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative IOException\n----------\n3. ERROR in X.java (at line 9)\n\t} catch(FileNotFoundException | FileNotFoundException | IOException e) {\n\t                                ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative IOException\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println();\n\t\t\tReader r = new FileReader(args[0]);\n\t\t\tr.read();\n\t\t} catch(FileNotFoundException e) {\t\t\te.printStackTrace();\n\t\t} catch(FileNotFoundException | IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\t} catch(FileNotFoundException | IOException e) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative IOException\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println();\n\t\t\tReader r = new FileReader(args[0]);\n\t\t\tr.read();\n\t\t} catch(RuntimeException | Exception e) {\t\t\te.printStackTrace();\n\t\t} catch(FileNotFoundException | IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t} catch(RuntimeException | Exception e) {\t\t\te.printStackTrace();\n\t        ^^^^^^^^^^^^^^^^\nThe exception RuntimeException is already caught by the alternative Exception\n----------\n2. ERROR in X.java (at line 10)\n\t} catch(FileNotFoundException | IOException e) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative IOException\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println();\n\t\t\tReader r = new FileReader(\"Zork\");\n\t\t\tr.read();\n\t\t} catch(NumberFormatException | RuntimeException e) {\n\t\t\te.printStackTrace();\n\t\t} catch(FileNotFoundException | IOException e) {\n\t\t\t// ignore\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\t} catch(NumberFormatException | RuntimeException e) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nThe exception NumberFormatException is already caught by the alternative RuntimeException\n----------\n2. ERROR in X.java (at line 11)\n\t} catch(FileNotFoundException | IOException e) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative IOException\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new Foo();\n\t\t} catch(SonOfFoo | DaughterOfFoo e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tthrow new Foo();\n\t^^^^^^^^^^^^^^^^\nUnhandled exception type Foo\n----------\n2. WARNING in X.java (at line 10)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 11)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 12)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new Foo();\n\t\t} catch(SonOfFoo | DaughterOfFoo e) {\n\t\t\tSystem.out.println(\"Caught lub\");\n\t\t} catch(Foo e) {\n           System.out.println(\"Caught Foo\");\n        }\n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "Caught Foo");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tif (args.length == 0) throw new SonOfFoo();\n\t\t\tthrow new DaughterOfFoo();\n\t\t} catch(SonOfFoo | DaughterOfFoo e) {\n\t\t\ttry {\n\t\t\t\tthrow e;\n\t\t\t} catch(SonOfFoo | DaughterOfFoo e1) {}\n\t\t}\n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "----------\n1. WARNING in X.java (at line 13)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 14)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 15)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new IOException();\n\t\t} catch(IOException | RuntimeException e) {\n\t\t\te = new IOException();\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\te = new IOException();\n\t^\nThe parameter e of a multi-catch block cannot be assigned\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new DaughterOfFoo();\n\t\t} catch(SonOfFoo | DaughterOfFoo e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t} catch(SonOfFoo | DaughterOfFoo e) {\n\t        ^^^^^^^^\nUnreachable catch block for SonOfFoo. This exception is never thrown from the try statement body\n----------\n2. WARNING in X.java (at line 10)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 11)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 12)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new DaughterOfFoo();\n\t\t} catch(Foo e) {\n\t\t\ttry {\n\t\t\t\tthrow e;\n\t\t\t} catch (SonOfFoo e1) {\n\t\t\t \te1.printStackTrace();\n\t\t\t} catch (Foo e1) {}\n\t\t}\n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t} catch (SonOfFoo e1) {\n\t         ^^^^^^^^\nUnreachable catch block for SonOfFoo. This exception is never thrown from the try statement body\n----------\n2. WARNING in X.java (at line 14)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 15)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 16)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new DaughterOfFoo();\n\t\t} catch(Foo e) {\n\t\t\ttry {\n\t\t\t\tthrow e;\n\t\t\t} catch (SonOfFoo e1) {\n\t\t\t \te1.printStackTrace();\n\t\t\t} catch (Foo e1) {}\n\t\t\tfinally {\t\t\t\tSystem.out.println(\"\");}\n\t\t}\n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t} catch (SonOfFoo e1) {\n\t         ^^^^^^^^\nUnreachable catch block for SonOfFoo. This exception is never thrown from the try statement body\n----------\n2. WARNING in X.java (at line 15)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 16)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 17)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new DaughterOfFoo();\n\t\t} catch(Foo e) {\n\t\t\ttry {\n\t\t\t\te = new Foo();\n\t\t\t\tthrow e;\n\t\t\t} catch (SonOfFoo e1) {\n\t\t\t \te1.printStackTrace();\n\t\t\t} catch (Foo e1) {}\n\t\t}\n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "----------\n1. WARNING in X.java (at line 15)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 16)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 17)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new DaughterOfFoo();\n\t\t} catch(Foo e) {\n\t\t\ttry {\n\t\t\t\tboolean DEBUG = true;\n\t\t\t\tif (DEBUG) {\n\t\t\t\t\tthrow e;\n\t\t\t\t}\t\t\t\te = new Foo();\n\t\t\t\te.printStackTrace();\n\t\t\t} catch (SonOfFoo e1) {\n\t\t\t \te1.printStackTrace();\n\t\t\t} catch (Foo e1) {}\n\t\t}\n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "----------\n1. WARNING in X.java (at line 18)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 19)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 20)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tthrow new DaughterOfFoo();\n\t\t} catch(Foo e) {\n\t\t\ttry {\n\t\t\t\tthrow new Foo();\n\t\t\t} catch (Foo e1) {\n\t\t\t\ttry {\n\t\t\t\t\tthrow e;\n\t\t\t\t} catch (SonOfFoo e2) {\n\t\t\t \t\te1.printStackTrace();\n\t\t\t\t} catch (Foo e3) {}\n\t\t\t}\n\t\t}\n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\t} catch (SonOfFoo e2) {\n\t         ^^^^^^^^\nUnreachable catch block for SonOfFoo. This exception is never thrown from the try statement body\n----------\n2. WARNING in X.java (at line 18)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 19)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 20)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        doSomething(false);\n    }\n    public static void doSomething (boolean bool) {\n        try {\n            if (bool)\n                throw new GrandSonOfFoo();\n            else \n                throw new GrandDaughterOfFoo();\n        } catch(SonOfFoo | DaughterOfFoo e) {\n        \tSonOfFoo s = e;\n        \te.callableOnBothGenders();\n        \te.callableOnlyOnMales();\n        \te.callableOnlyOnFemales();\n        }\n    }\n}\nclass Foo extends Exception {\n\tvoid callableOnBothGenders () {\n\t}\n}\nclass SonOfFoo extends Foo {\n\tvoid callableOnlyOnMales() {\n\t}\n}\nclass GrandSonOfFoo extends SonOfFoo {}\nclass DaughterOfFoo extends Foo {\n\tvoid callableOnlyOnFemales() {\n\t}\n}\nclass GrandDaughterOfFoo extends DaughterOfFoo {}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tSonOfFoo s = e;\n\t             ^\nType mismatch: cannot convert from Foo to SonOfFoo\n----------\n2. ERROR in X.java (at line 14)\n\te.callableOnlyOnMales();\n\t  ^^^^^^^^^^^^^^^^^^^\nThe method callableOnlyOnMales() is undefined for the type Foo\n----------\n3. ERROR in X.java (at line 15)\n\te.callableOnlyOnFemales();\n\t  ^^^^^^^^^^^^^^^^^^^^^\nThe method callableOnlyOnFemales() is undefined for the type Foo\n----------\n4. WARNING in X.java (at line 19)\n\tclass Foo extends Exception {\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n5. WARNING in X.java (at line 23)\n\tclass SonOfFoo extends Foo {\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n6. WARNING in X.java (at line 27)\n\tclass GrandSonOfFoo extends SonOfFoo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class GrandSonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n7. WARNING in X.java (at line 28)\n\tclass DaughterOfFoo extends Foo {\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n8. WARNING in X.java (at line 32)\n\tclass GrandDaughterOfFoo extends DaughterOfFoo {}\n\t      ^^^^^^^^^^^^^^^^^^\nThe serializable class GrandDaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(boolean bool) throws Foo {\n\t\ttry {\n\t\t\tif (bool) \n\t\t\t    throw new DaughterOfFoo();\n\t\t\telse\n\t\t\t    throw new SonOfFoo();\n\t\t} catch (final SonOfFoo | DaughterOfFoo e){\n\t\t\tthrow e;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tfoo(true);\n\t\t} catch(Foo e) {} \n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tthrow new SonOfFoo();\n\t^^^^^^^^^^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n2. WARNING in X.java (at line 18)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 19)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 20)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void foo(boolean bool) throws Foo {\n\t\ttry {\n\t\t\tif (bool) \n\t\t\t    throw new DaughterOfFoo();\n\t\t\telse\n\t\t\t    throw new SonOfFoo();\n\t\t} catch (final SonOfFoo | final DaughterOfFoo e){\n\t\t\tthrow e;\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tfoo(true);\n\t\t} catch(Foo e) {} \n\t}\n}\nclass Foo extends Exception {}\nclass SonOfFoo extends Foo {}\nclass DaughterOfFoo extends Foo {}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t} catch (final SonOfFoo | final DaughterOfFoo e){\n\t                          ^^^^^\nSyntax error on token \"final\", delete this token\n----------\n2. WARNING in X.java (at line 18)\n\tclass Foo extends Exception {}\n\t      ^^^\nThe serializable class Foo does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 19)\n\tclass SonOfFoo extends Foo {}\n\t      ^^^^^^^^\nThe serializable class SonOfFoo does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 20)\n\tclass DaughterOfFoo extends Foo {}\n\t      ^^^^^^^^^^^^^\nThe serializable class DaughterOfFoo does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args)  {\n\t\ttry {\n\t\t} catch (NullPointerException s) {\n\t\t\ttry {\n\t\t\t\tthrow s;\n\t\t\t} catch (ArithmeticException e) {\n\t\t\t}\n\t\t} finally {\n\t\t\tSystem.out.println(\"All done\");\n\t\t}\n\t}\n}\n"}, "All done");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tString[] exceptions = { \"NullPointerException\", \"ArithmeticException\",\n\t\t\t\t\"ArrayStoreException\", \"ArrayIndexOutOfBoundsException\" };\n\n\t\tfor (String exception : exceptions) {\n\t\t\ttry {\n\t\t\t\tswitch (exception) {\n\t\t\t\tcase \"NullPointerException\":\n\t\t\t\t\tthrow new NullPointerException();\n\t\t\t\tcase \"ArithmeticException\":\n\t\t\t\t\tthrow new ArithmeticException();\n\t\t\t\tcase \"ArrayStoreException\":\n\t\t\t\t\tthrow new ArrayStoreException();\n\t\t\t\tcase \"ArrayIndexOutOfBoundsException\":\n\t\t\t\t\tthrow new ArrayIndexOutOfBoundsException();\n\t\t\t\t}\n\t\t\t} catch (NullPointerException | ArithmeticException | ArrayStoreException | ArrayIndexOutOfBoundsException e) {\n\t\t\t\tSystem.out.println(e);\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "java.lang.NullPointerException\njava.lang.ArithmeticException\njava.lang.ArrayStoreException\njava.lang.ArrayIndexOutOfBoundsException");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Exception> {\npublic void foo(boolean bool) throws Exception {\n\ttry {\n\tif (bool)\n\t\tthrow new Exception();\n\telse\n\t\tthrow new NullPointerException();\n\t} catch (T | NullPointerException e) {}\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t} catch (T | NullPointerException e) {}\n\t         ^\nCannot use the type parameter T in a catch block\n----------\n");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> extends Exception {\npublic void foo(boolean bool) throws Exception {\n\ttry {\n\tif (bool)\n\t\tthrow new Exception();\n\telse\n\t\tthrow new NullPointerException();\n\t} catch (X<String> | NullPointerException e) {}\n}\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X<T> extends Exception {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in X.java (at line 1)\n\tpublic class X<T> extends Exception {\n\t                          ^^^^^^^^^\nThe generic class X<T> may not subclass java.lang.Throwable\n----------\n3. ERROR in X.java (at line 8)\n\t} catch (X<String> | NullPointerException e) {}\n\t         ^\nCannot use the parameterized type X<String> either in catch block or throws clause\n----------\n");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileNotFoundException;\nimport java.io.IOException;\npublic class X {\n    public static void main(String [] args) {\n        try {\n            if (args.length == 0)\n                throw new FileNotFoundException();\n            throw new IOException();\n        } catch(IOException | FileNotFoundException e) {\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\t} catch(IOException | FileNotFoundException e) {\n\t                      ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative IOException\n----------\n");
    }

    public void test024a() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileNotFoundException;\nimport java.io.IOException;\npublic class X {\n    public static void main(String [] args) {\n        try {\n            if (args.length == 0)\n                throw new FileNotFoundException();\n            throw new IOException();\n        } catch(FileNotFoundException | IOException e) {\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\t} catch(FileNotFoundException | IOException e) {\n\t        ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative IOException\n----------\n");
    }

    public void test025() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        try {\n            throw new D();\n        } catch (F e) {\n            try {\n                throw e;\n            } catch (F f) {\n            } catch (RuntimeException | S f) {\n            }\n        }\n    }\n}\nclass F extends Exception {}\nclass S extends F {}\nclass D extends F {}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\t} catch (RuntimeException | S f) {\n\t                            ^\nUnreachable catch block for S. It is already handled by the catch block for F\n----------\n2. WARNING in X.java (at line 14)\n\tclass F extends Exception {}\n\t      ^\nThe serializable class F does not declare a static final serialVersionUID field of type long\n----------\n3. WARNING in X.java (at line 15)\n\tclass S extends F {}\n\t      ^\nThe serializable class S does not declare a static final serialVersionUID field of type long\n----------\n4. WARNING in X.java (at line 16)\n\tclass D extends F {}\n\t      ^\nThe serializable class D does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.EOFException;\nimport java.io.FileNotFoundException;\npublic class X {\n    X() { \n        try {\n            zoo();\n        } catch (EOFException ea) {\n        } catch (FileNotFoundException eb) {\n        } catch (Exception ec) {\n            throw ec;\n        }\n    }\n    void zoo() throws FileNotFoundException, EOFException {\n    }\n}\n"}, "");
    }

    public void test026a() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.EOFException;\nimport java.io.FileNotFoundException;\npublic class X {\n    X() { \n        try {\n            zoo();\n            throw new Exception();\n        } catch (EOFException ea) {\n        } catch (FileNotFoundException eb) {\n        } catch (Exception ec) {\n            throw ec;\n        }\n    }\n    void zoo() throws FileNotFoundException, EOFException {\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tthrow ec;\n\t^^^^^^^^^\nUnhandled exception type Exception\n----------\n");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    X() throws Exception {\n        try {\n            throw (Throwable) new Exception();\n        } catch (Exception e) {\n            throw e;\n        } catch (Throwable e) {\n        }\n    }\n}\n"}, "");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void foo () {\n        try {\n            throw new Exception(); \n        } catch (Exception e) {\n            if (e instanceof RuntimeException) \n            \tthrow (RuntimeException) e; \n        } \n    }\n}\n"}, "");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String[] args) {\n        try (X x = new X();) {\n        } catch (Exception x) {\n        } catch (Throwable y) {\n        } \n        finally {\n            System.out.println(\"Done\");\n        }\n    }\n    public void close() {\n    }\n}\n"}, "Done");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String[] args) {\n        try (X x = new X();) {\n        } catch (Exception x) {\n        } catch (Throwable y) {\n        } \n        System.out.println(\"Done\");\n    }\n    public void close() {\n    }\n}\n"}, "Done");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String [] args) throws XXException, YYException, ZZException {\n        try (X x = new X(); Y y = new Y(); Z z = new Z()) {\n        } catch (XException x) {\n        } catch (YException y) {\n        } catch (ZException z) {\n        } finally {\n            System.out.println(\"Done\");\n        }\n    }\n    public X() throws XException {\n        throw new XException();\n    }\n    public void close() throws XXException {\n        throw new XXException();\n    }\n}\nclass Y implements AutoCloseable {\n    public Y() throws YException {\n        throw new YException();\n    }\n    public void close() throws YYException {\n        throw new YYException();\n    }\n}\nclass Z implements AutoCloseable {\n    public Z() throws ZException {\n        throw new ZException();\n    }\n    public void close() throws ZZException {\n        throw new ZZException();\n    }\n}\nclass XException extends Exception {}\nclass XXException extends Exception {}\nclass YException extends Exception {}\nclass YYException extends Exception {}\nclass ZException extends Exception {}\nclass ZZException extends Exception {}\n"}, "Done");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "public class X implements AutoCloseable {\n    public static void main(String [] args) throws XXException, YYException, ZZException {\n        try (X x = new X(); Y y = new Y(); Z z = new Z()) {\n        } catch (XException x) {\n        } catch (YException y) {\n        } catch (ZException z) {\n        }\n        System.out.println(\"Done\");\n    }\n    public X() throws XException {\n        throw new XException();\n    }\n    public void close() throws XXException {\n        throw new XXException();\n    }\n}\nclass Y implements AutoCloseable {\n    public Y() throws YException {\n        throw new YException();\n    }\n    public void close() throws YYException {\n        throw new YYException();\n    }\n}\nclass Z implements AutoCloseable {\n    public Z() throws ZException {\n        throw new ZException();\n    }\n    public void close() throws ZZException {\n        throw new ZZException();\n    }\n}\nclass XException extends Exception {}\nclass XXException extends Exception {}\nclass YException extends Exception {}\nclass YYException extends Exception {}\nclass ZException extends Exception {}\nclass ZZException extends Exception {}\n"}, "Done");
    }

    public void testBug391092() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String [] args) {\n\t\ttry {\n\t\t} catch (NullPointerException  | ArrayIndexOutOfBoundsException  e []) {\n\t\t} catch (ClassCastException [] c) {\n\t\t} catch (ArrayStoreException a[]) {\n\t\t} catch (ArithmeticException | NegativeArraySizeException b[][] ) {\n\t\t} catch (ClassCastException[][] | ClassNotFoundException[] g) {\n\t\t}\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t} catch (NullPointerException  | ArrayIndexOutOfBoundsException  e []) {\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIllegal attempt to create arrays of union types\n----------\n2. ERROR in X.java (at line 5)\n\t} catch (ClassCastException [] c) {\n\t         ^^^^^^^^^^^^^^^^^^^^^\nNo exception of type ClassCastException[] can be thrown; an exception type must be a subclass of Throwable\n----------\n3. ERROR in X.java (at line 6)\n\t} catch (ArrayStoreException a[]) {\n\t         ^^^^^^^^^^^^^^^^^^^^^^^\nNo exception of type ArrayStoreException[] can be thrown; an exception type must be a subclass of Throwable\n----------\n4. ERROR in X.java (at line 7)\n\t} catch (ArithmeticException | NegativeArraySizeException b[][] ) {\n\t         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nIllegal attempt to create arrays of union types\n----------\n5. ERROR in X.java (at line 8)\n\t} catch (ClassCastException[][] | ClassNotFoundException[] g) {\n\t         ^^^^^^^^^^^^^^^^^^^^^^\nNo exception of type ClassCastException[][] can be thrown; an exception type must be a subclass of Throwable\n----------\n6. ERROR in X.java (at line 8)\n\t} catch (ClassCastException[][] | ClassNotFoundException[] g) {\n\t                                  ^^^^^^^^^^^^^^^^^^^^^^^^\nNo exception of type ClassNotFoundException[] can be thrown; an exception type must be a subclass of Throwable\n----------\n");
    }

    public void testBug404146() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\nimport javax.naming.NamingException;\n\npublic final class X {\n\n    public static final void illegalStackMap() {\n        try {\n          try {\n            Y.decoy1();\n          } finally {\n            try {\n                Y.decoy2();\n            } catch (final IOException e) {\n              return;\n            }\n          }\n        } finally {\n          try {\n            Y.decoy3();\n          } catch (final NamingException e) {\n            return;\n          }\n        }\n    }\n}\n", "Y.java", "import java.io.IOException;\nimport javax.naming.NamingException;\npublic final class Y {\n\n    public static void decoy1() {}\n    public static void decoy2() throws IOException {}\n    public static void decoy3() throws NamingException {}\n}\n"});
    }

    public static Class testClass() {
        return TryStatement17Test.class;
    }
}

