/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.tests.eval.EvaluationTest;
import org.eclipse.jdt.internal.eval.EvaluationResult;
import org.eclipse.jdt.internal.eval.IRequestor;

public class CodeSnippetTest
extends EvaluationTest {
    public CodeSnippetTest(String name) {
        super(name);
    }

    private IRequestor getNoResultRequestor() {
        return new EvaluationTest.Requestor(this){

            @Override
            public void acceptResult(EvaluationResult result) {
                CodeSnippetTest.assertTrue((String)"No result", (boolean)false);
            }
        };
    }

    public static Test suite() {
        return CodeSnippetTest.setupSuite(CodeSnippetTest.testClass());
    }

    @Override
    public Map getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", "warning");
        return defaultOptions;
    }

    public void testCheckedException() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"try {", "\tthrow new java.io.IOException();", "} finally {", "\tSystem.err.println(\"This is an expected exception printed by the target VM:\");", "}"}), null);
    }

    public static Class testClass() {
        return CodeSnippetTest.class;
    }

    public void testEmptyStatement() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X {", "\tpublic int fact(int n){", "\t\treturn fact0(n, 1);", "\t}", "\tpublic int fact0(int n, int acc){", "\t\tif (n <= 1) return acc;", "\t\treturn fact0(n - 1, acc * n);", "\t}", "};", "new X().fact(10)"}), "3628800".toCharArray());
    }

    public void testEvaluateEmptyImport() {
        try {
            char[] importName = new char[]{};
            this.context.setImports((char[][])new char[][]{importName});
            EvaluationTest.Requestor requestor = new EvaluationTest.Requestor(this);
            this.context.evaluateImports(this.getEnv(), (IRequestor)requestor, this.getProblemFactory());
            CodeSnippetTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            CodeSnippetTest.assertTrue((String)"Problems", (boolean)result.hasProblems());
            CodeSnippetTest.assertEquals((String)"Evaluation type", (int)3, (int)result.getEvaluationType());
            this.assertEquals("Evaluation ID", importName, result.getEvaluationID());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testEvaluateExistingPackageAndNonExistingTypeImports() {
        try {
            char[] importName = "non.existing.Type".toCharArray();
            this.context.setImports((char[][])new char[][]{"java.lang.reflect.*".toCharArray(), importName});
            EvaluationTest.Requestor requestor = new EvaluationTest.Requestor(this);
            this.context.evaluateImports(this.getEnv(), (IRequestor)requestor, this.getProblemFactory());
            CodeSnippetTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            CodeSnippetTest.assertTrue((String)"Problems", (boolean)result.hasProblems());
            CodeSnippetTest.assertEquals((String)"Evaluation type", (int)3, (int)result.getEvaluationType());
            this.assertEquals("Evaluation ID", importName, result.getEvaluationID());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testEvaluateNonExistingPackageAndExistingTypeImports() {
        try {
            char[] importName = "non.existing.*".toCharArray();
            this.context.setImports((char[][])new char[][]{importName, "java.math.BigInteger".toCharArray()});
            EvaluationTest.Requestor requestor = new EvaluationTest.Requestor(this);
            this.context.evaluateImports(this.getEnv(), (IRequestor)requestor, this.getProblemFactory());
            CodeSnippetTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            CodeSnippetTest.assertTrue((String)"Problems", (boolean)result.hasProblems());
            CodeSnippetTest.assertEquals((String)"Evaluation type", (int)3, (int)result.getEvaluationType());
            this.assertEquals("Evaluation ID", importName, result.getEvaluationID());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testEvaluateNonExistingPackageImport() {
        try {
            char[] importName = "non.existing.*".toCharArray();
            this.context.setImports((char[][])new char[][]{importName});
            EvaluationTest.Requestor requestor = new EvaluationTest.Requestor(this);
            this.context.evaluateImports(this.getEnv(), (IRequestor)requestor, this.getProblemFactory());
            CodeSnippetTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            CodeSnippetTest.assertTrue((String)"Problems", (boolean)result.hasProblems());
            CodeSnippetTest.assertEquals((String)"Evaluation type", (int)3, (int)result.getEvaluationType());
            this.assertEquals("Evaluation ID", importName, result.getEvaluationID());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testEvaluateNonExistingTypeImport() {
        try {
            char[] importName = "non.existing.Type".toCharArray();
            this.context.setImports((char[][])new char[][]{importName});
            EvaluationTest.Requestor requestor = new EvaluationTest.Requestor(this);
            this.context.evaluateImports(this.getEnv(), (IRequestor)requestor, this.getProblemFactory());
            CodeSnippetTest.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            CodeSnippetTest.assertTrue((String)"Problems", (boolean)result.hasProblems());
            CodeSnippetTest.assertEquals((String)"Evaluation type", (int)3, (int)result.getEvaluationType());
            this.assertEquals("Evaluation ID", importName, result.getEvaluationID());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testEvaluateValidPackageAndTypeImports() {
        try {
            this.context.setImports((char[][])new char[][]{"java.util.Enumeration".toCharArray(), "java.lang.reflect.*".toCharArray()});
            this.context.evaluateImports(this.getEnv(), this.getNoResultRequestor(), this.getProblemFactory());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testEvaluateValidPackageImport() {
        try {
            this.context.setImports((char[][])new char[][]{"java.io.*".toCharArray()});
            this.context.evaluateImports(this.getEnv(), this.getNoResultRequestor(), this.getProblemFactory());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testEvaluateValidTypeImport() {
        try {
            this.context.setImports((char[][])new char[][]{"java.math.BigInteger".toCharArray()});
            this.context.evaluateImports(this.getEnv(), this.getNoResultRequestor(), this.getProblemFactory());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testFinallyError() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"try {", "\tthrow new Error();", "} finally {", "\tSystem.err.println(\"This is an expected error printed by the target VM:\");", "}"}), null);
    }

    public void testFinallyOneBlock() {
        this.evaluateWithExpectedWarningAndDisplayString(this.buildCharArray(new String[]{"try {", "\treturn 1;", "} finally {", "\treturn 2;", "}"}), new CategorizedProblem[]{this.newProblem(536871096, 0, 30, 40, 4)}, "2".toCharArray());
    }

    public void testFinallyTwoBlock() {
        this.evaluateWithExpectedWarningAndDisplayString(this.buildCharArray(new String[]{"try {", "\ttry {", "\t\treturn 1;", "\t} finally {", "\t\treturn 2;", "\t}", "} finally {", "\treturn 3;", "}"}), new CategorizedProblem[]{this.newProblem(536871096, 0, 40, 51, 5), this.newProblem(536871096, 0, 66, 76, 8)}, "3".toCharArray());
    }

    public void testFreeReturnAnonymous() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"new Object() {", "\tpublic String toString() {", "\t\treturn \"an object\";", "\t}", "}"}), "an object".toCharArray());
    }

    public void testFreeReturnClassDeclaration() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class Point {", "\tint x;", "\tint y;", "\tPoint(int x, int y) {", "\t\tthis.x = x;", "\t\tthis.y = y;", "\t}", "}", "new Point(56, 99).x"}), "56".toCharArray());
    }

    public void testFreeReturnExpression() {
        this.evaluateWithExpectedDisplayString("(1 + 2) * 3.0 / 4".toCharArray(), "2.25".toCharArray());
    }

    public void testFreeReturnInteger() {
        this.evaluateWithExpectedDisplayString("1".toCharArray(), "1".toCharArray());
    }

    public void testFreeReturnLocalVar() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"int i = 99;", "i + 4"}), "103".toCharArray());
    }

    public void testFreeReturnStatement() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"int i = 2;", "for (int j=0;j<10;j++) {", "\ti++;", "}", "i"}), "12".toCharArray());
    }

    public void testImportPackage() {
        try {
            this.context.setImports((char[][])new char[][]{"java.io.*".toCharArray()});
            this.evaluateWithExpectedDisplayString("return new File(\"!@#%\").exists();".toCharArray(), "false".toCharArray());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testImportType() {
        try {
            this.context.setImports((char[][])new char[][]{"java.math.BigInteger".toCharArray()});
            this.evaluateWithExpectedDisplayString("return new BigInteger(\"123456789012345678901234567890\");".toCharArray(), "123456789012345678901234567890".toCharArray());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testImportTypeAndPackage() {
        try {
            this.context.setImports((char[][])new char[][]{"java.util.Enumeration".toCharArray(), "java.lang.reflect.*".toCharArray()});
            this.evaluateWithExpectedDisplayString("Field[] fields = Enumeration.class.getDeclaredFields(); return fields.length;".toCharArray(), "0".toCharArray());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testInnerClassAnonymous() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"return new Object() {", "\tpublic String toString() {", "\t\treturn \"an inner class\";", "\t}", "};"}), "an inner class".toCharArray());
    }

    public void testInnerClassNamed() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X {", "\tint foo = 1;", "}", "return new X().foo;"}), "1".toCharArray());
    }

    public void testPackage() {
        if (this.isJRockitVM()) {
            return;
        }
        try {
            this.context.setPackageName("java.util.zip".toCharArray());
            this.evaluateWithExpectedDisplayString("return ZipConstants.LOCSIG;".toCharArray(), "67324752".toCharArray());
        }
        finally {
            this.context.setPackageName(new char[0]);
        }
    }

    public void testReturnDisplayStringBoolean() {
        this.evaluateWithExpectedDisplayString("return true;".toCharArray(), "true".toCharArray());
    }

    public void testReturnDisplayStringCharacter() {
        this.evaluateWithExpectedDisplayString("return 'c';".toCharArray(), "c".toCharArray());
    }

    public void testReturnDisplayStringDouble() {
        this.evaluateWithExpectedDisplayString("return 1.0;".toCharArray(), "1.0".toCharArray());
    }

    public void testReturnDisplayStringEmptyCodeSnippet() {
        this.evaluateWithExpectedDisplayString(new char[0], null);
    }

    public void testReturnDisplayStringFloat() {
        this.evaluateWithExpectedDisplayString("return (float)1.0;".toCharArray(), "1.0".toCharArray());
    }

    public void testReturnDisplayStringInteger() {
        this.evaluateWithExpectedDisplayString("return 1;".toCharArray(), "1".toCharArray());
    }

    public void testReturnDisplayStringLong() {
        this.evaluateWithExpectedDisplayString("return (long)1;".toCharArray(), "1".toCharArray());
    }

    public void testReturnDisplayStringNoExplicitReturnedValue() {
        this.evaluateWithExpectedDisplayString("new String(\"hello\".toCharArray());".toCharArray(), "hello".toCharArray());
    }

    public void testReturnDisplayStringObject() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"return new Object() {", "\tpublic String toString() {", "\t\treturn \"an object\";", "\t}", "};"}), "an object".toCharArray());
    }

    public void testReturnDisplayStringShort() {
        this.evaluateWithExpectedDisplayString("return (short)1;".toCharArray(), "1".toCharArray());
    }

    public void testReturnDisplayStringString() {
        this.evaluateWithExpectedDisplayString("return \"hello\";".toCharArray(), "hello".toCharArray());
    }

    public void testReturnDisplayStringVoid() {
        this.evaluateWithExpectedDisplayString("new Thread().start()".toCharArray(), null);
    }

    public void testReturnTypeBoolean() {
        this.evaluateWithExpectedType("return true;".toCharArray(), "boolean".toCharArray());
    }

    public void testReturnTypeBooleanArray() {
        this.evaluateWithExpectedType("return new boolean[] {true};".toCharArray(), "[Z".toCharArray());
    }

    public void testReturnTypeBooleanObject() {
        this.evaluateWithExpectedType("return new Boolean(true);".toCharArray(), "java.lang.Boolean".toCharArray());
    }

    public void testReturnTypeChar() {
        this.evaluateWithExpectedType("return 'c';".toCharArray(), "char".toCharArray());
    }

    public void testReturnTypeCharacterObject() {
        this.evaluateWithExpectedType("return new Character('c');".toCharArray(), "java.lang.Character".toCharArray());
    }

    public void testReturnTypeCharArray() {
        this.evaluateWithExpectedType("return new char[] {'c'};".toCharArray(), "[C".toCharArray());
    }

    public void testReturnTypeDouble() {
        this.evaluateWithExpectedType("return 1.0;".toCharArray(), "double".toCharArray());
    }

    public void testReturnTypeDoubleArray() {
        this.evaluateWithExpectedType("return new double[] {1.0};".toCharArray(), "[D".toCharArray());
    }

    public void testReturnTypeDoubleObject() {
        this.evaluateWithExpectedType("return new Double(1.0);".toCharArray(), "java.lang.Double".toCharArray());
    }

    public void testReturnTypeEmptyCodeSnippet() {
        this.evaluateWithExpectedType(new char[0], null);
    }

    public void testReturnTypeFloat() {
        this.evaluateWithExpectedType("return (float)1.0;".toCharArray(), "float".toCharArray());
    }

    public void testReturnTypeFloatArray() {
        this.evaluateWithExpectedType("return new float[] {(float)1.0};".toCharArray(), "[F".toCharArray());
    }

    public void testReturnTypeFloatObject() {
        this.evaluateWithExpectedType("return new Float(1.0);".toCharArray(), "java.lang.Float".toCharArray());
    }

    public void testReturnTypeInt() {
        this.evaluateWithExpectedType("return 1;".toCharArray(), "int".toCharArray());
    }

    public void testReturnTypeIntegerObject() {
        this.evaluateWithExpectedType("return new Integer(1);".toCharArray(), "java.lang.Integer".toCharArray());
    }

    public void testReturnTypeLong() {
        this.evaluateWithExpectedType("return (long)1;".toCharArray(), "long".toCharArray());
    }

    public void testReturnTypeLongArray() {
        this.evaluateWithExpectedType("return new long[] {(long)1};".toCharArray(), "[J".toCharArray());
    }

    public void testReturnTypeLongObject() {
        this.evaluateWithExpectedType("return new Long(1);".toCharArray(), "java.lang.Long".toCharArray());
    }

    public void testReturnTypeNoExplicitReturnedValue() {
        this.evaluateWithExpectedType("new Object();".toCharArray(), "java.lang.Object".toCharArray());
    }

    public void testReturnTypeObject() {
        this.evaluateWithExpectedType("return new Object();".toCharArray(), "java.lang.Object".toCharArray());
    }

    public void testReturnTypeObjectArray() {
        this.evaluateWithExpectedType("return new Object[] {new Object()};".toCharArray(), "[Ljava.lang.Object;".toCharArray());
    }

    public void testReturnTypeShort() {
        this.evaluateWithExpectedType("return (short)1;".toCharArray(), "short".toCharArray());
    }

    public void testReturnTypeShortArray() {
        this.evaluateWithExpectedType("return new short[] {(short)1};".toCharArray(), "[S".toCharArray());
    }

    public void testReturnTypeShortObject() {
        this.evaluateWithExpectedType("return new Short((short)1);".toCharArray(), "java.lang.Short".toCharArray());
    }

    public void testReturnTypesIntArray() {
        this.evaluateWithExpectedType("return new int[] {1};".toCharArray(), "[I".toCharArray());
    }

    public void testReturnTypeString() {
        this.evaluateWithExpectedType("return \"hello\";".toCharArray(), "java.lang.String".toCharArray());
    }

    public void testReturnTypeStringArray() {
        this.evaluateWithExpectedType("return new String[] {\"hello\"};".toCharArray(), "[Ljava.lang.String;".toCharArray());
    }

    public void testReturnTypeVoid() {
        this.evaluateWithExpectedType("new Thread().start()".toCharArray(), null);
    }

    public void testRunMethodInAnonymous() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X {", "\tpublic int i = 0;", "   public boolean finished = false;", "}", "final X x = new X();", "(new Thread() {", "\tpublic void run() {", "\t\tfor (int i=0;i<10;i++) {", "\t\t\ttry {", "\t\t\t\tThread.currentThread().sleep(10);", "\t\t\t} catch (InterruptedException e) {", "\t\t\t}", "\t\t\tx.i++;", "\t\t}", "       x.finished = true;", "\t}", "}).start();", "while (!x.finished) Thread.currentThread().sleep(100);", "x.i"}), "10".toCharArray());
    }

    public void testRunMethodInAnonymous2() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X {", "\tpublic int i = 0;", "   public boolean finished = false;", "}", "final X x = new X();", "(new Thread() {", "\tpublic void run() {", "\t\tfor (int i=0;i<10;i++) {", "\t\t\ttry {", "\t\t\t\tThread.currentThread().sleep(10);", "\t\t\t} catch (InterruptedException e) {", "\t\t\t}", "\t\t\t++x.i;", "\t\t}", "       x.finished = true;", "\t}", "}).start();", "while (!x.finished) Thread.currentThread().sleep(100);", "x.i"}), "10".toCharArray());
    }

    public void testRunMethodInAnonymous3() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X {", "\tpublic int i = 0;", "   public boolean finished = false;", "}", "final X x = new X();", "(new Thread() {", "\tpublic void run() {", "\t\tfor (int i=0;i<10;i++) {", "\t\t\ttry {", "\t\t\t\tThread.currentThread().sleep(10);", "\t\t\t} catch (InterruptedException e) {", "\t\t\t}", "\t\t\tx.i += 1;", "\t\t}", "       x.finished = true;", "\t}", "}).start();", "while (!x.finished) Thread.currentThread().sleep(100);", "x.i"}), "10".toCharArray());
    }

    public void testRunMethodInAnonymous4() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X {", "\tpublic int i = 0;", "   public boolean finished = false;", "}", "final X x = new X();", "(new Thread() {", "\tpublic void run() {", "\t\tfor (int i=0;i<10;i++) {", "\t\t\ttry {", "\t\t\t\tThread.currentThread().sleep(10);", "\t\t\t} catch (InterruptedException e) {", "\t\t\t}", "\t\t\tx.i = x.i + 1;", "\t\t}", "       x.finished = true;", "\t}", "}).start();", "while (!x.finished) Thread.currentThread().sleep(100);", "x.i"}), "10".toCharArray());
    }

    public void testRunMethodInAnonymous5() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X {", "\tpublic int i = 0;", "   public boolean finished = false;", "\tpublic X self() { return this; }", "}", "final X x = new X();", "(new Thread() {", "\tpublic void run() {", "\t\tfor (int i=0;i<10;i++) {", "\t\t\ttry {", "\t\t\t\tThread.currentThread().sleep(10);", "\t\t\t} catch (InterruptedException e) {", "\t\t\t}", "\t\t\tx.self().i++;", "\t\t}", "       x.finished = true;", "\t}", "}).start();", "while (!x.finished) Thread.currentThread().sleep(100);", "x.i"}), "10".toCharArray());
    }

    public void testRunMethodInAnonymous6() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X {", "\tpublic int i = 0;", "   public boolean finished = false;", "\tpublic X self() { return this; }", "}", "final X x = new X();", "(new Thread() {", "\tpublic void run() {", "\t\tfor (int i=0;i<10;i++) {", "\t\t\ttry {", "\t\t\t\tThread.currentThread().sleep(10);", "\t\t\t} catch (InterruptedException e) {", "\t\t\t}", "\t\t\t++ (x.self().i);", "\t\t}", "       x.finished = true;", "\t}", "}).start();", "while (!x.finished) Thread.currentThread().sleep(100);", "x.i"}), "10".toCharArray());
    }

    public void testRunMethodInAnonymous7() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X {", "\tpublic int i = 0;", "   public boolean finished = false;", "\tpublic X self() { return this; }", "}", "final X x = new X();", "(new Thread() {", "\tpublic void run() {", "\t\tfor (int i=0;i<10;i++) {", "\t\t\ttry {", "\t\t\t\tThread.currentThread().sleep(10);", "\t\t\t} catch (InterruptedException e) {", "\t\t\t}", "\t\t\tx.self().i += 1;", "\t\t}", "       x.finished = true;", "\t}", "}).start();", "while (!x.finished) Thread.currentThread().sleep(100);", "x.i"}), "10".toCharArray());
    }

    public void testRunMethodInAnonymous8() {
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X {", "\tpublic int i = 0;", "   public boolean finished = false;", "\tpublic X self() { return this; }", "}", "final X x = new X();", "(new Thread() {", "\tpublic void run() {", "\t\tfor (int i=0;i<10;i++) {", "\t\t\ttry {", "\t\t\t\tThread.currentThread().sleep(10);", "\t\t\t} catch (InterruptedException e) {", "\t\t\t}", "\t\t\tx.self().i = x.self().i + 1;", "\t\t}", "       x.finished = true;", "\t}", "}).start();", "while (!x.finished) Thread.currentThread().sleep(100);", "x.i"}), "10".toCharArray());
    }

    public void testFor89632() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        try {
            this.context.setImports((char[][])new char[][]{"java.util.*".toCharArray()});
            this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"Collection<String> c = new ArrayList<String>();\nc.add(\"a\");\nc.add(\"b\");\nc.add(\"c\");  \nIterator<String> i = c.iterator();\nStringBuffer buffer = new StringBuffer();\nwhile (i.hasNext()) {\n\tbuffer.append(i.next());\n}return String.valueOf(buffer);"}), "abc".toCharArray());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testBug345334() {
        Map options = this.getCompilerOptions();
        if (this.complianceLevel == 0x310000L) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
        } else if (this.complianceLevel >= 0x320000L) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "error");
            options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "error");
        }
        this.evaluateWithExpectedDisplayString(options, this.buildCharArray(new String[]{"return \"SUCCESS\";\n"}), "SUCCESS".toCharArray());
    }

    public void testDiamond() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"class X<T> {", "\tT field;", "\tpublic X(T param) {", "\t\tfield = param;", "\t}", "\tpublic T foo() {", "\t\treturn field;", "\t}", "};", "new X<>(\"SUCCESS\").foo();\n"}), "SUCCESS".toCharArray());
    }

    public void testBug464656() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.evaluateWithExpectedDisplayString(this.buildCharArray(new String[]{"java.util.stream.Stream<String> s = java.util.stream.Stream.of(\"a\",\"b\");\nreturn s.findFirst();"}), "Optional[a]".toCharArray());
    }
}

