/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.util.StringTokenizer;

public class VerifyTests {
    int portNumber;
    Socket socket;

    public void loadAndRun(String className) throws Throwable {
        Class<?> testClass = new VerifyClassLoader().loadClass(className);
        try {
            Method main = testClass.getMethod("main", String[].class);
            main.invoke(null, new Object[]{new String[0]});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static void main(String[] args) throws IOException {
        VerifyTests verify = new VerifyTests();
        verify.portNumber = Integer.parseInt(args[0]);
        verify.run();
    }

    public void run() throws IOException {
        this.socket = new Socket("localhost", this.portNumber);
        this.socket.setTcpNoDelay(true);
        DataInputStream in = new DataInputStream(this.socket.getInputStream());
        final DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
        while (true) {
            final String className = in.readUTF();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        VerifyTests.this.loadAndRun(className);
                        out.writeBoolean(true);
                        System.err.println(VerifyTests.class.getName());
                        System.out.println(VerifyTests.class.getName());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        try {
                            System.err.println(VerifyTests.class.getName());
                            System.out.println(VerifyTests.class.getName());
                            out.writeBoolean(false);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    try {
                        out.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        }
    }

    public class VerifyClassLoader
    extends ClassLoader {
        private String[] pathItems;
        private String[] excluded = new String[0];

        public VerifyClassLoader() {
            String classPath = System.getProperty("java.class.path");
            String separator = System.getProperty("path.separator");
            StringTokenizer st = new StringTokenizer(classPath, separator);
            int i = 0;
            while (st.hasMoreTokens()) {
                st.nextToken();
                ++i;
            }
            this.pathItems = new String[i];
            st = new StringTokenizer(classPath, separator);
            i = 0;
            while (st.hasMoreTokens()) {
                this.pathItems[i++] = st.nextToken();
            }
        }

        @Override
        public URL getResource(String name) {
            return ClassLoader.getSystemResource(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return ClassLoader.getSystemResourceAsStream(name);
        }

        protected boolean isExcluded(String name) {
            if (name.startsWith("java") || name.startsWith("[Ljava")) {
                return true;
            }
            int i = 0;
            while (i < this.excluded.length) {
                if (name.startsWith(this.excluded[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            File file;
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            if (this.isExcluded(name)) {
                try {
                    c = this.findSystemClass(name);
                    return c;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if ((file = this.locate(name)) == null) {
                throw new ClassNotFoundException();
            }
            byte[] data = this.loadClassData(file);
            c = this.defineClass(name, data, 0, data.length);
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        /*
         * Loose catch block
         */
        private byte[] loadClassData(File f) throws ClassNotFoundException {
            byte[] byArray;
            FileInputStream stream;
            block12: {
                stream = null;
                stream = new FileInputStream(f);
                byte[] b = new byte[stream.available()];
                stream.read(b);
                byArray = b;
                if (stream == null) break block12;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            return byArray;
            {
                catch (IOException iOException) {
                    try {
                        try {
                            throw new ClassNotFoundException();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new ClassNotFoundException();
                        }
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                }
            }
        }

        private File locate(String fileName) {
            if (fileName != null) {
                fileName = String.valueOf(fileName.replace('.', '/')) + ".class";
                File path = null;
                int i = 0;
                while (i < this.pathItems.length) {
                    path = new File(this.pathItems[i], fileName);
                    if (path.exists()) {
                        return path;
                    }
                    ++i;
                }
            }
            return null;
        }
    }
}

