/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class ExplicitConstructorInvocationCompletionTest
extends AbstractCompletionTest {
    public ExplicitConstructorInvocationCompletionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return ExplicitConstructorInvocationCompletionTest.buildAllCompliancesTestSuite(ExplicitConstructorInvocationCompletionTest.class);
    }

    public void testPrimarySuper() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tstatic Bar x;\t\t\t\t\t\t\t\t\n\tpublic class InnerBar {\t\t\t\t\t\t\n\t\tInnerBar(Bar x) {\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class SubInnerBar extends InnerBar {\t\n\t\tSubInnerBar(Bar x) {\t\t\t\t\t\n\t\t\tprimary().super(1, 2, i);\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "super(1, 2,", "<CompleteOnExplicitConstructorCall:primary().super(1, 2)>;", "class Bar {\n  public class InnerBar {\n    InnerBar(Bar x) {\n    }\n  }\n  public class SubInnerBar extends InnerBar {\n    SubInnerBar(Bar x) {\n      <CompleteOnExplicitConstructorCall:primary().super(1, 2)>;\n    }\n  }\n  static Bar x;\n  <clinit>() {\n  }\n  Bar() {\n  }\n}\n", "", "", "<complete on explicit constructor invocation primary super>");
    }

    public void testPrimaryThis() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tstatic Bar x;\t\t\t\t\t\t\t\t\n\tpublic class InnerBar {\t\t\t\t\t\t\n\t\tInnerBar(Bar x) {\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class SubInnerBar extends InnerBar {\t\n\t\tSubInnerBar(Bar x) {\t\t\t\t\t\n\t\t\tprimary().this(1, 2, i);\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "this(1, 2,", "<CompleteOnExplicitConstructorCall:primary().this(1, 2)>;", "class Bar {\n  public class InnerBar {\n    InnerBar(Bar x) {\n    }\n  }\n  public class SubInnerBar extends InnerBar {\n    SubInnerBar(Bar x) {\n      <CompleteOnExplicitConstructorCall:primary().this(1, 2)>;\n    }\n  }\n  static Bar x;\n  <clinit>() {\n  }\n  Bar() {\n  }\n}\n", "", "", "<complete on explicit constructor invocation primary this>");
    }

    public void testSuper() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tBar() {\t\t\t\t\t\t\t\t\t\n\t\tsuper(1, 2, i);\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "super(1, 2,", "<CompleteOnExplicitConstructorCall:super(1, 2)>;", "class Bar {\n  Bar() {\n    <CompleteOnExplicitConstructorCall:super(1, 2)>;\n  }\n}\n", "", "", "<completion on 'super' constructor invocation>");
    }

    public void testThis() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tBar() {\t\t\t\t\t\t\t\t\t\n\t\tthis(1, 2, i);\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "this(1, 2,", "<CompleteOnExplicitConstructorCall:this(1, 2)>;", "class Bar {\n  Bar() {\n    <CompleteOnExplicitConstructorCall:this(1, 2)>;\n  }\n}\n", "", "", "<completion on 'this' constructor invocation>");
    }

    public void testWrapperNameSuper() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tstatic Bar x;\t\t\t\t\t\t\t\t\n\tpublic class InnerBar {\t\t\t\t\t\t\n\t\tInnerBar(Bar x) {\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class SubInnerBar extends InnerBar {\t\n\t\tSubInnerBar() {\t\t\t\t\t\t\t\n\t\t\tBar.super(fred().xyz);\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "fred().x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  public class InnerBar {\n    InnerBar(Bar x) {\n    }\n  }\n  public class SubInnerBar extends InnerBar {\n    SubInnerBar() {\n      super(<CompleteOnMemberAccess:fred().x>);\n    }\n  }\n  static Bar x;\n  <clinit>() {\n  }\n  Bar() {\n  }\n}\n", "x", "xyz", "<complete on wrapper name super>");
    }

    public void testWrapperNameThis() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tstatic Bar x;\t\t\t\t\t\t\t\t\n\tpublic class InnerBar {\t\t\t\t\t\t\n\t\tInnerBar(Bar x) {\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class SubInnerBar extends InnerBar {\t\n\t\tSubInnerBar() {\t\t\t\t\t\t\t\n\t\t\tBar.this(fred().xyz);\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "fred().x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  public class InnerBar {\n    InnerBar(Bar x) {\n    }\n  }\n  public class SubInnerBar extends InnerBar {\n    SubInnerBar() {\n      this(<CompleteOnMemberAccess:fred().x>);\n    }\n  }\n  static Bar x;\n  <clinit>() {\n  }\n  Bar() {\n  }\n}\n", "x", "xyz", "<complete on wrapper name this>");
    }

    public void testWrapperPrimarySuper() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tstatic Bar x;\t\t\t\t\t\t\t\t\n\tpublic class InnerBar {\t\t\t\t\t\t\n\t\tInnerBar(Bar x) {\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n\tpublic class SubInnerBar extends InnerBar {\t\n\t\tSubInnerBar(Bar x) {\t\t\t\t\t\n\t\t\tprimary().super(fred().xyz);\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "fred().x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  public class InnerBar {\n    InnerBar(Bar x) {\n    }\n  }\n  public class SubInnerBar extends InnerBar {\n    SubInnerBar(Bar x) {\n      super(<CompleteOnMemberAccess:fred().x>);\n    }\n  }\n  static Bar x;\n  <clinit>() {\n  }\n  Bar() {\n  }\n}\n", "x", "xyz", "<complete on wrapper primary super>");
    }

    public void testWrapperSuper() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tBar() {\t\t\t\t\t\t\t\t\t\t\n\t\tsuper(fred().xyz);\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n    super(<CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on wrapper super>");
    }

    public void testWrapperThis() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\t\n\tBar() {\t\t\t\t\t\t\t\t\t\t\n\t\tthis(fred().xyz);\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "class Bar {\n  Bar() {\n    this(<CompleteOnMemberAccess:fred().x>);\n  }\n}\n", "x", "xyz", "<complete on wrapper this>");
    }
}

