/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.TypeElement;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.tests.compiler.regression.DefaultJavaRuntimeEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.InMemoryNameEnvironment;
import org.eclipse.jdt.core.tests.compiler.regression.RegressionTestSetup;
import org.eclipse.jdt.core.tests.compiler.regression.Requestor;
import org.eclipse.jdt.core.tests.junit.extension.StopableTestCase;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;
import org.eclipse.jdt.core.tests.util.TestVerifier;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.indexing.BinaryIndexer;
import org.eclipse.jdt.internal.core.util.Messages;
import org.osgi.framework.Bundle;

public abstract class AbstractRegressionTest
extends AbstractCompilerTest
implements StopableTestCase {
    protected static int[] DIFF_COUNTERS = new int[3];
    protected static final String EVAL_DIRECTORY = String.valueOf(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()) + File.separator + "eval";
    public static int INDENT = 2;
    protected static final String JAVA_NAME = File.pathSeparatorChar == ':' ? "java" : "java.exe";
    protected static final String JAVAC_NAME = File.pathSeparatorChar == ':' ? "javac" : "javac.exe";
    protected static String JAVAC_OUTPUT_DIR_NAME = String.valueOf(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()) + File.separator + "javac";
    static File JAVAC_OUTPUT_DIR;
    protected static String javacCommandLineHeader;
    protected static PrintWriter javacFullLog;
    private static String javacFullLogFileName;
    protected static String javaCommandLineHeader;
    protected static boolean javacTestErrorFlag;
    protected static String javacTestName;
    protected static IPath jdkRootDirPath;
    protected static List javacCompilers;
    public static final String OUTPUT_DIR;
    public static final String LIB_DIR;
    public static final String PACKAGE_INFO_NAME;
    public static final String MODULE_INFO_NAME;
    public static boolean SHIFT;
    protected static final String SOURCE_DIRECTORY;
    protected String[] classpaths;
    protected boolean createdVerifier;
    protected INameEnvironment javaClassLib;
    protected TestVerifier verifier;
    protected boolean shouldSwallowCaptureId;

    static {
        javacCompilers = null;
        OUTPUT_DIR = String.valueOf(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()) + File.separator + "regression";
        LIB_DIR = String.valueOf(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()) + File.separator + "lib";
        PACKAGE_INFO_NAME = new String(TypeConstants.PACKAGE_INFO_NAME);
        MODULE_INFO_NAME = new String(TypeConstants.MODULE_INFO_NAME);
        SHIFT = false;
        SOURCE_DIRECTORY = String.valueOf(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()) + File.separator + "source";
    }

    public AbstractRegressionTest(String name) {
        super(name);
    }

    protected void checkClassFile(String className, String source, String expectedOutput) throws ClassFormatException, IOException {
        this.checkClassFile("", className, source, expectedOutput, 4);
    }

    protected void checkClassFile(String className, String source, String expectedOutput, int mode) throws ClassFormatException, IOException {
        this.checkClassFile("", className, source, expectedOutput, mode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkClassFile(String directoryName, String className, String disassembledClassName, String source, String expectedOutput, int mode) throws ClassFormatException, IOException {
        this.compileAndDeploy(source, directoryName, className);
        try {
            File directory = new File(EVAL_DIRECTORY, directoryName);
            if (!directory.exists()) {
                AbstractRegressionTest.assertTrue((String)(".class file not generated properly in " + directory), (boolean)false);
            }
            File f = new File(directory, String.valueOf(disassembledClassName) + ".class");
            byte[] classFileBytes = Util.getFileByteContent((File)f);
            ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
            String result = disassembler.disassemble(classFileBytes, "\n", mode);
            int index = result.indexOf(expectedOutput);
            if (index == -1 || expectedOutput.length() == 0) {
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
            }
            if (index == -1) {
                AbstractRegressionTest.assertEquals("Wrong contents", expectedOutput, result);
            }
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(f);
                ClassFileReader.read((InputStream)stream, (String)(String.valueOf(className) + ".class"), (boolean)true);
            }
            catch (org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException e) {
                e.printStackTrace();
                AbstractRegressionTest.assertTrue((String)"ClassFormatException", (boolean)false);
                if (stream == null) return;
                try {
                    stream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    AbstractRegressionTest.assertTrue((String)"IOException", (boolean)false);
                    if (stream == null) return;
                }
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    stream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            if (stream == null) return;
            try {
                stream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        finally {
            this.removeTempClass(className);
        }
    }

    protected void checkClassFile(String directoryName, String className, String source, String expectedOutput, int mode) throws ClassFormatException, IOException {
        this.checkClassFile(directoryName, className, className, source, expectedOutput, mode);
    }

    /*
     * Unable to fully structure code
     */
    protected ClassFileReader getInternalClassFile(String directoryName, String className, String disassembledClassName, String source) throws ClassFormatException, IOException {
        this.compileAndDeploy(source, directoryName, className);
        try {
            block21: {
                directory = new File(AbstractRegressionTest.EVAL_DIRECTORY, directoryName);
                if (!directory.exists()) {
                    AbstractRegressionTest.assertTrue((String)(".class file not generated properly in " + directory), (boolean)false);
                }
                f = new File(directory, String.valueOf(disassembledClassName) + ".class");
                classFileReader = null;
                stream = null;
                try {
                    stream = new FileInputStream(f);
                    classFileReader = ClassFileReader.read((InputStream)stream, (String)(String.valueOf(className) + ".class"), (boolean)true);
                }
                catch (org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException e) {
                    e.printStackTrace();
                    AbstractRegressionTest.assertTrue((String)"ClassFormatException", (boolean)false);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException v0) {}
                    }
                    break block21;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        AbstractRegressionTest.assertTrue((String)"IOException", (boolean)false);
                        ** if (stream == null) goto lbl-1000
                    }
                    catch (Throwable var10_11) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException v2) {}
                        }
                        throw var10_11;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            stream.close();
                        }
                        catch (IOException v1) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block21;
                    }
                }
                if (stream == null) break block21;
                try {
                    stream.close();
                }
                catch (IOException v3) {}
            }
            var12_12 = classFileReader;
            return var12_12;
        }
        finally {
            this.removeTempClass(className);
        }
    }

    protected void checkDisassembledClassFile(String fileName, String className, String expectedOutput) throws Exception {
        this.checkDisassembledClassFile(fileName, className, expectedOutput, 1);
    }

    protected void checkDisassembledClassFile(String fileName, String className, String expectedOutput, int mode) throws Exception {
        File classFile = new File(fileName);
        if (!classFile.exists()) {
            AbstractRegressionTest.assertTrue((String)".class file doesn't exist", (boolean)false);
        }
        byte[] classFileBytes = Util.getFileByteContent((File)classFile);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", mode);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 2));
        }
        if (index == -1) {
            AbstractRegressionTest.assertEquals("Wrong contents", expectedOutput, result);
        }
        if ((index = result.indexOf(Messages.classformat_classformatexception)) != -1) {
            int start = Math.max(0, index - 300);
            int end = index + Messages.classformat_classformatexception.length();
            AbstractRegressionTest.fail((String)("ClassFormatException swallowed in Disassembler:\n..." + result.substring(start, end)));
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(classFile);
            ClassFileReader.read((InputStream)stream, (String)(String.valueOf(className) + ".class"), (boolean)true);
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void compileAndDeploy(String source, String directoryName, String className) {
        String processAnnot;
        File directory = new File(SOURCE_DIRECTORY);
        if (!directory.exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + SOURCE_DIRECTORY);
            return;
        }
        if (directoryName != null && directoryName.length() != 0 && !(directory = new File(SOURCE_DIRECTORY, directoryName)).exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + directory);
            return;
        }
        String fileName = String.valueOf(directory.getAbsolutePath()) + File.separator + className + ".java";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(source);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        StringBuffer buffer = new StringBuffer().append("\"").append(fileName).append("\" -d \"").append(EVAL_DIRECTORY);
        String string = processAnnot = this.enableAPT ? "" : "-proc:none";
        if (this.complianceLevel < 0x310000L) {
            buffer.append("\" -1.4 -source 1.3 -target 1.2");
        } else if (this.complianceLevel == 0x310000L) {
            buffer.append("\" -1.5");
        } else if (this.complianceLevel == 0x320000L) {
            buffer.append("\" -1.6 " + processAnnot);
        } else if (this.complianceLevel == 0x330000L) {
            buffer.append("\" -1.7 " + processAnnot);
        } else if (this.complianceLevel == 0x340000L) {
            buffer.append("\" -1.8 " + processAnnot);
        } else if (this.complianceLevel == 0x350000L) {
            buffer.append("\" -9 " + processAnnot);
        }
        buffer.append(" -preserveAllLocals -proceedOnError -nowarn -g -classpath \"").append(org.eclipse.jdt.core.tests.util.Util.getJavaClassLibsAsString()).append(SOURCE_DIRECTORY).append("\"");
        BatchCompiler.compile((String)buffer.toString(), (PrintWriter)new PrintWriter(System.out), (PrintWriter)new PrintWriter(System.err), null);
    }

    protected void checkCompilerLog(String[] testFiles, Requestor requestor, String[] alternatePlatformIndependantExpectedLogs, Throwable exception) {
        String computedProblemLog = org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(requestor.problemLog.toString());
        if (this.shouldSwallowCaptureId) {
            computedProblemLog = Pattern.compile("capture#(\\d+)").matcher(computedProblemLog).replaceAll("capture");
        }
        ProblemLog problemLog = new ProblemLog(computedProblemLog);
        int i = 0;
        while (i < alternatePlatformIndependantExpectedLogs.length) {
            if (problemLog.sameAs(alternatePlatformIndependantExpectedLogs[i])) {
                return;
            }
            ++i;
        }
        this.logTestTitle();
        System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(computedProblemLog, INDENT, SHIFT));
        this.logTestFiles(false, testFiles);
        if (exception == null) {
            AbstractRegressionTest.assertEquals("Invalid problem log ", alternatePlatformIndependantExpectedLogs[i - 1], computedProblemLog);
        }
    }

    protected void dualPrintln(String message) {
        System.out.println(message);
        javacFullLog.println(message);
    }

    protected void executeClass(String sourceFile, String expectedSuccessOutputString, String[] classLib, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor clientRequestor) {
        String className = sourceFile.substring(0, sourceFile.length() - 5).replace('/', '.').replace('\\', '.');
        if (className.endsWith(PACKAGE_INFO_NAME)) {
            return;
        }
        if (vmArguments != null) {
            if (this.verifier != null) {
                this.verifier.shutDown();
            }
            this.verifier = new TestVerifier(false);
            this.createdVerifier = true;
        }
        boolean passed = this.verifier.verifyClassFiles(sourceFile, className, expectedSuccessOutputString, this.classpaths, null, vmArguments);
        AbstractRegressionTest.assertTrue((String)this.verifier.failureReason, (boolean)passed);
        if (vmArguments != null) {
            if (this.verifier != null) {
                this.verifier.shutDown();
            }
            this.verifier = new TestVerifier(false);
            this.createdVerifier = true;
        }
    }

    protected String findReferences(String classFilePath) {
        final StringBuffer references = new StringBuffer(10);
        JavaSearchParticipant participant = new JavaSearchParticipant(){
            final SearchParticipant searchParticipant = this;

            public SearchDocument getDocument(String documentPath) {
                return new SearchDocument(documentPath, this.searchParticipant){

                    public byte[] getByteContents() {
                        try {
                            return Util.getFileByteContent((File)new File(this.getPath()));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }

                    public char[] getCharContents() {
                        return null;
                    }

                    public String getEncoding() {
                        return null;
                    }
                };
            }
        };
        SearchDocument document = participant.getDocument(new File(classFilePath).getPath());
        BinaryIndexer indexer = new BinaryIndexer(document){

            protected void addIndexEntry(char[] category, char[] key) {
                references.append(category);
                references.append('/');
                references.append(key);
                references.append('\n');
            }
        };
        indexer.indexDocument();
        String computedReferences = references.toString();
        return computedReferences;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ClassFileReader getClassFileReader(String fileName, String className) {
        ClassFileReader reader;
        File classFile = new File(fileName);
        if (!classFile.exists()) {
            AbstractRegressionTest.assertTrue((String)".class file doesn't exist", (boolean)false);
        }
        FileInputStream stream = null;
        stream = new FileInputStream(classFile);
        ClassFileReader classFileReader = reader = ClassFileReader.read((InputStream)stream, (String)(String.valueOf(className) + ".class"), (boolean)true);
        if (stream == null) return classFileReader;
        try {
            stream.close();
            return classFileReader;
        }
        catch (IOException iOException) {}
        return classFileReader;
        catch (org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException e) {
            e.printStackTrace();
            AbstractRegressionTest.assertTrue((String)"ClassFormatException", (boolean)false);
            if (stream == null) return null;
            try {
                stream.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            AbstractRegressionTest.assertTrue((String)"IOException", (boolean)false);
            if (stream == null) return null;
            {
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                stream.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    protected INameEnvironment[] getClassLibs(boolean useDefaultClasspaths) {
        String encoding = this.getCompilerOptions().get("org.eclipse.jdt.core.encoding");
        if ("".equals(encoding)) {
            encoding = null;
        }
        if (useDefaultClasspaths && encoding == null) {
            return DefaultJavaRuntimeEnvironment.create(this.classpaths);
        }
        INameEnvironment[] classLibs = new INameEnvironment[]{new FileSystem(this.classpaths, new String[0], encoding)};
        return classLibs;
    }

    @Override
    protected Map<String, String> getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.deadCode", "warning");
        return defaultOptions;
    }

    protected void enableAllWarningsForIrritants(Map<String, String> options, IrritantSet irritants) {
        int[] bits = irritants.getBits();
        int i = 0;
        while (i < bits.length) {
            int bit = bits[i];
            int b = 0;
            while (b < 29) {
                int single = bit & 1 << b;
                if (single != 0 && (single |= i << 29) != 0x40004000) {
                    String optionKey = CompilerOptions.optionKeyFromIrritant((int)single);
                    options.put(optionKey, "warning");
                }
                ++b;
            }
            ++i;
        }
    }

    protected String[] getDefaultClassPaths() {
        return DefaultJavaRuntimeEnvironment.getDefaultClassPaths();
    }

    protected String[] getLibsWithNullAnnotations(long sourceLevel) throws IOException {
        String[] defaultLibs = this.getDefaultClassPaths();
        int len = defaultLibs.length;
        String[] libs = new String[len + 1];
        System.arraycopy(defaultLibs, 0, libs, 0, len);
        String version = sourceLevel < 0x340000L ? "[1.1.0,2.0.0)" : "[2.0.0,3.0.0)";
        Bundle[] bundles = Platform.getBundles((String)"org.eclipse.jdt.annotation", (String)version);
        File bundleFile = FileLocator.getBundleFile((Bundle)bundles[0]);
        libs[len] = bundleFile.isDirectory() ? String.valueOf(bundleFile.getPath()) + "/bin" : bundleFile.getPath();
        return libs;
    }

    protected IErrorHandlingPolicy getErrorHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean proceedOnErrors() {
                return true;
            }

            public boolean ignoreAllErrors() {
                return false;
            }
        };
    }

    protected INameEnvironment getNameEnvironment(String[] testFiles, String[] classPaths) {
        this.classpaths = classPaths == null ? this.getDefaultClassPaths() : classPaths;
        return new InMemoryNameEnvironment(testFiles, this.getClassLibs(classPaths == null));
    }

    protected IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    protected CompilationUnit[] getCompilationUnits(String[] testFiles) {
        return org.eclipse.jdt.core.tests.util.Util.compilationUnits(testFiles);
    }

    @Override
    public void initialize(CompilerTestSetup setUp) {
        super.initialize(setUp);
        if (setUp instanceof RegressionTestSetup) {
            RegressionTestSetup regressionTestSetUp = (RegressionTestSetup)setUp;
            this.javaClassLib = regressionTestSetUp.javaClassLib;
            this.verifier = regressionTestSetUp.verifier;
        }
    }

    void logTestFiles(boolean logTitle, String[] testFiles) {
        if (logTitle) {
            this.logTestTitle();
        }
        int i = 0;
        while (i < testFiles.length) {
            System.out.print(testFiles[i]);
            System.out.println(" [");
            System.out.println(testFiles[i + 1]);
            System.out.println("]");
            i += 2;
        }
    }

    void logTestTitle() {
        System.out.println(String.valueOf(this.getClass().getName()) + '#' + this.getName());
    }

    protected void printFiles(String[] testFiles) {
        int i = 0;
        int length = testFiles.length;
        while (i < length) {
            System.out.println(testFiles[i++]);
            System.out.println(testFiles[i]);
            ++i;
        }
        System.out.println("");
    }

    protected void printJavacResultsSummary() {
        if (RUN_JAVAC) {
            Integer count = (Integer)TESTS_COUNTERS.get(CURRENT_CLASS_NAME);
            if (count != null) {
                int newCount = count - 1;
                TESTS_COUNTERS.put(CURRENT_CLASS_NAME, newCount);
                if (newCount == 0) {
                    if (DIFF_COUNTERS[0] != 0 || DIFF_COUNTERS[1] != 0 || DIFF_COUNTERS[2] != 0) {
                        this.dualPrintln("===========================================================================");
                        this.dualPrintln("Results summary:");
                    }
                    if (DIFF_COUNTERS[0] != 0) {
                        this.dualPrintln("\t- " + DIFF_COUNTERS[0] + " test(s) where Javac found errors/warnings but Eclipse did not");
                    }
                    if (DIFF_COUNTERS[1] != 0) {
                        this.dualPrintln("\t- " + DIFF_COUNTERS[1] + " test(s) where Eclipse found errors/warnings but Javac did not");
                    }
                    if (DIFF_COUNTERS[2] != 0) {
                        this.dualPrintln("\t- " + DIFF_COUNTERS[2] + " test(s) where Eclipse and Javac did not have same output");
                    }
                    System.out.println("\n");
                }
            }
            this.dualPrintln("\n\nFull results sent to " + javacFullLogFileName);
            javacFullLog.flush();
        }
    }

    protected void removeTempClass(String className) {
        int max;
        int i;
        File dir = new File(SOURCE_DIRECTORY);
        String[] fileNames = dir.list();
        if (fileNames != null) {
            i = 0;
            max = fileNames.length;
            while (i < max) {
                if (fileNames[i].indexOf(className) != -1) {
                    org.eclipse.jdt.core.tests.util.Util.delete(String.valueOf(SOURCE_DIRECTORY) + File.separator + fileNames[i]);
                }
                ++i;
            }
        }
        if ((fileNames = (dir = new File(EVAL_DIRECTORY)).list()) != null) {
            i = 0;
            max = fileNames.length;
            while (i < max) {
                if (fileNames[i].indexOf(className) != -1) {
                    org.eclipse.jdt.core.tests.util.Util.delete(String.valueOf(EVAL_DIRECTORY) + File.separator + fileNames[i]);
                }
                ++i;
            }
        }
    }

    protected void runConformTest(String[] testFiles) {
        this.runTest(true, testFiles, null, null, false, null, false, null, false, null, null, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, ASTVisitor visitor) {
        this.runTest(true, testFiles, new String[0], null, null, false, null, false, null, null, false, null, null, null, visitor, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedOutputString) {
        this.runConformTest(false, JavacTestOptions.DEFAULT, testFiles, expectedOutputString);
    }

    protected void runConformTest(boolean skipJavac, JavacTestOptions javacTestOptions, String[] testFiles, String expectedOutputString) {
        this.runTest(true, testFiles, null, null, false, null, false, null, false, null, expectedOutputString, null, skipJavac ? JavacTestOptions.SKIP : (javacTestOptions != null ? javacTestOptions : JavacTestOptions.DEFAULT));
    }

    protected void runConformTest(String[] testFiles, Map customOptions) {
        this.runTest(true, testFiles, null, customOptions, false, null, false, null, false, null, null, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedOutput, Map customOptions) {
        this.runTest(true, testFiles, null, customOptions, false, null, false, null, false, null, expectedOutput, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String[] dependantFiles, String expectedSuccessOutputString) {
        this.runTest(true, testFiles, dependantFiles, null, null, false, null, false, null, null, false, null, expectedSuccessOutputString, null, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedOutputString, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, null, false, null, false, null, false, vmArguments, expectedOutputString, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedOutputString, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor customRequestor) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, customRequestor, false, null, false, vmArguments, expectedOutputString, null, JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedSuccessOutputString, String[] classLib, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor clientRequestor, boolean skipJavac) {
        this.runConformTest(testFiles, expectedSuccessOutputString, classLib, shouldFlushOutputDirectory, vmArguments, customOptions, clientRequestor, skipJavac, skipJavac ? JavacTestOptions.SKIP : JavacTestOptions.DEFAULT);
    }

    protected void runConformTest(String[] testFiles, String expectedSuccessOutputString, String[] classLib, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor clientRequestor, boolean skipJavac, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLib, customOptions, false, clientRequestor, false, null, false, vmArguments, expectedSuccessOutputString, null, javacTestOptions);
    }

    protected void runJavac(String[] testFiles, String expectedProblemLog, String expectedSuccessOutputString, boolean shouldFlushOutputDirectory) {
        String testName = null;
        Process compileProcess = null;
        Process execProcess = null;
        try {
            try {
                testName = this.testName();
                File javacOutputDirectory = new File(JAVAC_OUTPUT_DIR_NAME);
                if (shouldFlushOutputDirectory) {
                    org.eclipse.jdt.core.tests.util.Util.delete(javacOutputDirectory);
                }
                this.writeFiles(testFiles);
                StringBuffer cmdLine = new StringBuffer(javacCommandLineHeader);
                String[] classpath = org.eclipse.jdt.core.tests.util.Util.concatWithClassLibs(JAVAC_OUTPUT_DIR_NAME, false);
                StringBuffer cp = new StringBuffer(" -classpath ");
                int length = classpath.length;
                int i = 0;
                while (i < length) {
                    if (i > 0) {
                        cp.append(File.pathSeparatorChar);
                    }
                    if (classpath[i].indexOf(" ") != -1) {
                        cp.append("\"" + classpath[i] + "\"");
                    } else {
                        cp.append(classpath[i]);
                    }
                    ++i;
                }
                cmdLine.append(cp);
                i = 0;
                while (i < testFiles.length) {
                    cmdLine.append(' ');
                    cmdLine.append(testFiles[i]);
                    i += 2;
                }
                compileProcess = Runtime.getRuntime().exec(cmdLine.toString(), null, this.outputTestDirectory);
                Logger errorLogger = new Logger(compileProcess.getErrorStream(), "ERROR");
                Logger outputLogger = new Logger(compileProcess.getInputStream(), "OUTPUT");
                errorLogger.start();
                outputLogger.start();
                int exitValue = compileProcess.waitFor();
                errorLogger.join();
                outputLogger.join();
                if (!testName.equals(javacTestName)) {
                    javacTestName = testName;
                    javacTestErrorFlag = false;
                    javacFullLog.println("-----------------------------------------------------------------");
                    javacFullLog.println(String.valueOf(CURRENT_CLASS_NAME) + " " + testName);
                }
                if (exitValue != 0) {
                    javacTestErrorFlag = true;
                }
                if (errorLogger.buffer.length() > 0) {
                    javacFullLog.println("--- javac err: ---");
                    javacFullLog.println(errorLogger.buffer.toString());
                }
                if (outputLogger.buffer.length() > 0) {
                    javacFullLog.println("--- javac out: ---");
                    javacFullLog.println(outputLogger.buffer.toString());
                }
                if (expectedProblemLog == null || expectedProblemLog.length() == 0) {
                    if (exitValue != 0) {
                        System.out.println("----------------------------------------");
                        System.out.println(String.valueOf(testName) + " - Javac has found error(s) but Eclipse expects conform result:\n");
                        javacFullLog.println("JAVAC_MISMATCH: Javac has found error(s) but Eclipse expects conform result");
                        System.out.println(errorLogger.buffer.toString());
                        this.printFiles(testFiles);
                        DIFF_COUNTERS[0] = DIFF_COUNTERS[0] + 1;
                    } else {
                        if (errorLogger.buffer.length() > 0) {
                            System.out.println("----------------------------------------");
                            System.out.println(String.valueOf(testName) + " - Javac has found warning(s) but Eclipse expects conform result:\n");
                            javacFullLog.println("JAVAC_MISMATCH: Javac has found warning(s) but Eclipse expects conform result");
                            System.out.println(errorLogger.buffer.toString());
                            this.printFiles(testFiles);
                            DIFF_COUNTERS[0] = DIFF_COUNTERS[0] + 1;
                        }
                        if (expectedSuccessOutputString != null && !javacTestErrorFlag) {
                            StringBuffer javaCmdLine = new StringBuffer(javaCommandLineHeader);
                            javaCmdLine.append(cp);
                            javaCmdLine.append(' ').append(testFiles[0].substring(0, testFiles[0].indexOf(46)));
                            execProcess = Runtime.getRuntime().exec(javaCmdLine.toString(), null, this.outputTestDirectory);
                            Logger logger = new Logger(execProcess.getInputStream(), "");
                            logger.start();
                            exitValue = execProcess.waitFor();
                            logger.join();
                            String javaOutput = logger.buffer.toString().trim();
                            if (!expectedSuccessOutputString.equals(javaOutput)) {
                                System.out.println("----------------------------------------");
                                System.out.println(String.valueOf(testName) + " - Javac and Eclipse runtime output is not the same:");
                                javacFullLog.println("JAVAC_MISMATCH: Javac and Eclipse runtime output is not the same");
                                this.dualPrintln("eclipse:");
                                this.dualPrintln(expectedSuccessOutputString);
                                this.dualPrintln("javac:");
                                this.dualPrintln(javaOutput);
                                System.out.println("\n");
                                this.printFiles(testFiles);
                                DIFF_COUNTERS[2] = DIFF_COUNTERS[2] + 1;
                            }
                        }
                    }
                } else if (errorLogger.buffer.length() == 0) {
                    System.out.println("----------------------------------------");
                    System.out.println(String.valueOf(testName) + " - Eclipse has found error(s)/warning(s) but Javac did not find any:");
                    javacFullLog.println("JAVAC_MISMATCH: Eclipse has found error(s)/warning(s) but Javac did not find any");
                    this.dualPrintln("eclipse:");
                    this.dualPrintln(expectedProblemLog);
                    this.printFiles(testFiles);
                    DIFF_COUNTERS[1] = DIFF_COUNTERS[1] + 1;
                } else if (expectedProblemLog.indexOf("ERROR") > 0 && exitValue == 0) {
                    System.out.println("----------------------------------------");
                    System.out.println(String.valueOf(testName) + " - Eclipse has found error(s) but Javac only found warning(s):");
                    javacFullLog.println("JAVAC_MISMATCH: Eclipse has found error(s) but Javac only found warning(s)");
                    this.dualPrintln("eclipse:");
                    this.dualPrintln(expectedProblemLog);
                    System.out.println("javac:");
                    System.out.println(errorLogger.buffer.toString());
                    this.printFiles(testFiles);
                    DIFF_COUNTERS[1] = DIFF_COUNTERS[1] + 1;
                }
            }
            catch (InterruptedException e1) {
                if (compileProcess != null) {
                    compileProcess.destroy();
                }
                if (execProcess != null) {
                    execProcess.destroy();
                }
                System.out.println(String.valueOf(testName) + ": Sun javac compilation was aborted!");
                javacFullLog.println("JAVAC_WARNING: Sun javac compilation was aborted!");
                e1.printStackTrace(javacFullLog);
                org.eclipse.jdt.core.tests.util.Util.delete(this.outputTestDirectory);
            }
            catch (Throwable e) {
                System.out.println(String.valueOf(testName) + ": could not launch Sun javac compilation!");
                e.printStackTrace();
                javacFullLog.println("JAVAC_ERROR: could not launch Sun javac compilation!");
                e.printStackTrace(javacFullLog);
                org.eclipse.jdt.core.tests.util.Util.delete(this.outputTestDirectory);
            }
        }
        finally {
            org.eclipse.jdt.core.tests.util.Util.delete(this.outputTestDirectory);
        }
    }

    protected boolean runJavac(String options, String[] testFileNames, String currentDirectoryPath) {
        Process compileProcess = null;
        try {
            StringBuffer cmdLine = new StringBuffer(javacCommandLineHeader);
            cmdLine.append(' ');
            cmdLine.append(options);
            int i = 0;
            while (i < testFileNames.length) {
                cmdLine.append(' ');
                cmdLine.append(testFileNames[i]);
                ++i;
            }
            File currentDirectory = new File(currentDirectoryPath);
            compileProcess = Runtime.getRuntime().exec(cmdLine.toString(), null, currentDirectory);
            Logger errorLogger = new Logger(compileProcess.getErrorStream(), "ERROR");
            errorLogger.start();
            int exitValue = compileProcess.waitFor();
            errorLogger.join();
            if (exitValue != 0) {
                return false;
            }
            if (errorLogger.buffer.length() > 0) {
                System.err.println("--- javac err: ---");
                System.err.println(errorLogger.buffer.toString());
                return false;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        finally {
            if (compileProcess != null) {
                compileProcess.destroy();
            }
        }
        return true;
    }

    protected void runJavac(String[] testFiles, boolean expectingCompilerErrors, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, boolean shouldFlushOutputDirectory, JavacTestOptions options, String[] vmArguments) {
        String newOptions;
        if (options == JavacTestOptions.SKIP) {
            return;
        }
        if (options == null) {
            options = JavacTestOptions.DEFAULT;
        }
        if ((newOptions = options.getCompilerOptions()).indexOf(" -d ") < 0) {
            options.setCompilerOptions(newOptions.concat(" -d ."));
        }
        if (newOptions.indexOf(" -Xlint") < 0) {
            options.setCompilerOptions(newOptions.concat(" -Xlint"));
        }
        String testName = this.testName();
        for (JavacCompiler compiler : javacCompilers) {
            if (options.skip(compiler) || compiler.compliance != this.complianceLevel) continue;
            JavacTestOptions.Excuse excuse = options.excuseFor(compiler);
            StringBuffer compilerLog = new StringBuffer();
            File javacOutputDirectory = null;
            int mismatch = 0;
            String[] sourceFileNames = null;
            try {
                javacOutputDirectory = new File(String.valueOf(JAVAC_OUTPUT_DIR_NAME) + File.separator + compiler.rawVersion);
                if (shouldFlushOutputDirectory) {
                    org.eclipse.jdt.core.tests.util.Util.delete(javacOutputDirectory);
                }
                javacOutputDirectory.mkdirs();
                int i = 0;
                int length = testFiles.length;
                while (i < length) {
                    File dir;
                    String fileName = testFiles[i++];
                    String contents = testFiles[i++];
                    File file = new File(javacOutputDirectory, fileName);
                    if (fileName.lastIndexOf(47) >= 0 && !(dir = file.getParentFile()).exists()) {
                        dir.mkdirs();
                    }
                    org.eclipse.jdt.core.tests.util.Util.writeToFile(contents, file.getPath());
                }
                int testFilesLength = testFiles.length;
                sourceFileNames = new String[testFilesLength / 2];
                int i2 = 0;
                int j = 0;
                while (i2 < testFilesLength) {
                    sourceFileNames[j] = testFiles[i2];
                    i2 += 2;
                    ++j;
                }
                long compilerResult = compiler.compile(javacOutputDirectory, options.getCompilerOptions(), sourceFileNames, compilerLog);
                if (!testName.equals(javacTestName)) {
                    javacTestName = testName;
                    javacTestErrorFlag = false;
                }
                if ((compilerResult & 0xFFFFFFFFL) != 0L) {
                    javacTestErrorFlag = true;
                }
                if (expectingCompilerErrors) {
                    if ((compilerResult & 0xFFFFFFFFL) == 0L) {
                        mismatch = (compilerResult & 0xFFFFFFFF00000000L) == 0L ? 1 : 2;
                    }
                } else if ((compilerResult & 0xFFFFFFFFL) != 0L) {
                    mismatch = expectedCompilerLog != null && expectedCompilerLog.length() > 0 ? 8 : 4;
                } else if (expectedCompilerLog != null) {
                    if (expectedCompilerLog.length() > 0 && (compilerResult & 0xFFFFFFFF00000000L) == 0L) {
                        mismatch = 16;
                    } else if (expectedCompilerLog.length() == 0 && (compilerResult & 0xFFFFFFFF00000000L) != 0L) {
                        mismatch = 32;
                    }
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                mismatch = 256;
            }
            catch (Throwable e) {
                e.printStackTrace();
                mismatch = 512;
            }
            String output = null;
            String err = null;
            try {
                if (!(expectedOutputString == null && expectedErrorString == null || javacTestErrorFlag || mismatch != 0 || sourceFileNames == null)) {
                    int l;
                    JavaRuntime runtime = JavaRuntime.runtimeFor(compiler);
                    StringBuffer stderr = new StringBuffer();
                    StringBuffer stdout = new StringBuffer();
                    String vmOptions = "";
                    if (vmArguments != null && (l = vmArguments.length) > 0) {
                        StringBuffer buffer = new StringBuffer(vmArguments[0]);
                        int i = 1;
                        while (i < l) {
                            buffer.append(' ');
                            buffer.append(vmArguments[i]);
                            ++i;
                        }
                        vmOptions = buffer.toString();
                    }
                    runtime.execute(javacOutputDirectory, vmOptions, testFiles[0].substring(0, testFiles[0].length() - 5), stdout, stderr);
                    if (expectedOutputString != null && !expectedOutputString.equals(output = stdout.toString().trim())) {
                        mismatch = 64;
                    }
                    if (!(expectedErrorString == null || mismatch != 0 || expectedErrorString.equals(err = stderr.toString().trim()) || expectedErrorString.length() == 0 && err.indexOf("java.lang.NoSuchMethodError: main") != -1 || err.indexOf("Error: Main method not found in class") != -1)) {
                        mismatch = 128;
                    }
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                mismatch = 1024;
            }
            catch (Throwable e) {
                e.printStackTrace();
                mismatch = 2048;
            }
            if (mismatch != 0) {
                if (excuse != null && excuse.clears(mismatch)) {
                    excuse = null;
                } else {
                    System.err.println("----------------------------------------");
                    this.logTestFiles(true, testFiles);
                    switch (mismatch) {
                        case 1: {
                            AbstractRegressionTest.assertEquals(String.valueOf(testName) + " - Eclipse found error(s) but Javac did not find any", "", expectedCompilerLog.toString());
                            break;
                        }
                        case 2: {
                            AbstractRegressionTest.assertEquals(String.valueOf(testName) + " - Eclipse found error(s) but Javac only found warning(s)", expectedCompilerLog.toString(), compilerLog.toString());
                            break;
                        }
                        case 4: {
                            AbstractRegressionTest.assertEquals(String.valueOf(testName) + " - Javac found error(s) but Eclipse did not find any", "", compilerLog.toString());
                            break;
                        }
                        case 8: {
                            AbstractRegressionTest.assertEquals(String.valueOf(testName) + " - Javac found error(s) but Eclipse only found warning(s)", expectedCompilerLog.toString(), compilerLog.toString());
                            break;
                        }
                        case 16: {
                            AbstractRegressionTest.assertEquals(String.valueOf(testName) + " - Eclipse found warning(s) but Javac did not find any", "", expectedCompilerLog.toString());
                            break;
                        }
                        case 32: {
                            AbstractRegressionTest.assertEquals(String.valueOf(testName) + " - Javac found warning(s) but Eclipse did not find any", "", compilerLog.toString());
                            break;
                        }
                        case 64: {
                            AbstractRegressionTest.assertEquals(String.valueOf(testName) + " - Eclipse/Javac standard output mismatch", expectedOutputString, output);
                            break;
                        }
                        case 128: {
                            AbstractRegressionTest.assertEquals(String.valueOf(testName) + " - Eclipse/Javac standard error mismatch", expectedErrorString, err);
                            break;
                        }
                        case 256: 
                        case 512: {
                            AbstractRegressionTest.fail((String)(String.valueOf(testName) + " - Javac failure"));
                            break;
                        }
                        case 1024: 
                        case 2048: {
                            AbstractRegressionTest.fail((String)(String.valueOf(testName) + " - Java failure"));
                            break;
                        }
                        default: {
                            throw new RuntimeException("unexpected mismatch value: " + mismatch);
                        }
                    }
                }
            }
            if (excuse == null) continue;
            AbstractRegressionTest.fail((String)(String.valueOf(testName) + ": unused excuse " + excuse + " for compiler " + compiler));
        }
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog) {
        this.runNegativeTest(false, null, testFiles, expectedCompilerLog);
    }

    protected void runNegativeTest(boolean skipJavac, JavacTestOptions javacTestOptions, String[] testFiles, String expectedCompilerLog) {
        this.runTest(true, testFiles, null, null, false, new Requestor(false, null, false, false), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : (javacTestOptions != null ? javacTestOptions : JavacTestOptions.DEFAULT));
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, boolean performStatementRecovery) {
        this.runNegativeTest(false, null, testFiles, expectedCompilerLog, performStatementRecovery);
    }

    protected void runNegativeTest(boolean skipJavac, JavacTestOptions javacTestOptions, String[] testFiles, String expectedCompilerLog, boolean performStatementRecovery) {
        this.runTest(true, testFiles, null, null, performStatementRecovery, new Requestor(false, null, false, false), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : (javacTestOptions != null ? javacTestOptions : JavacTestOptions.DEFAULT));
    }

    protected void runNegativeTest(String[] testFiles, String expectedProblemLog, String[] classLib, boolean shouldFlushOutputDirectory) {
        this.runNegativeTest(false, null, testFiles, expectedProblemLog, classLib, shouldFlushOutputDirectory);
    }

    protected void runNegativeTest(boolean skipJavac, JavacTestOptions javacTestOptions, String[] testFiles, String expectedProblemLog, String[] classLib, boolean shouldFlushOutputDirectory) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLib, null, false, new Requestor(false, null, false, false), expectedProblemLog == null || expectedProblemLog.indexOf("ERROR") != -1, expectedProblemLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : (javacTestOptions != null ? javacTestOptions : JavacTestOptions.DEFAULT));
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, new Requestor(false, null, false, false), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, JavacTestOptions.DEFAULT);
    }

    protected void runNegativeTest(boolean skipJavac, JavacTestOptions javacTestOptions, String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, new Requestor(false, null, false, false), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : (javacTestOptions != null ? javacTestOptions : JavacTestOptions.DEFAULT));
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions, String expectedErrorString) {
        this.runNegativeTest(testFiles, expectedCompilerLog, classLibraries, shouldFlushOutputDirectory, customOptions, expectedErrorString, JavacTestOptions.DEFAULT);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions, String expectedErrorString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, new Requestor(false, null, false, false), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, expectedErrorString, javacTestOptions);
    }

    protected void runNegativeTest(String[] testFiles, String expectedProblemLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions, boolean generateOutput, boolean showCategory, boolean showWarningToken) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, new Requestor(generateOutput, null, showCategory, showWarningToken), expectedProblemLog == null || expectedProblemLog.indexOf("ERROR") != -1, expectedProblemLog, false, null, null, null, JavacTestOptions.DEFAULT);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions, boolean generateOutput, boolean showCategory, boolean showWarningToken, boolean skipJavac, boolean performStatementsRecovery) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, performStatementsRecovery, new Requestor(generateOutput, null, showCategory, showWarningToken), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : JavacTestOptions.DEFAULT);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, String[] classLibraries, boolean shouldFlushOutputDirectory, Map customOptions, boolean generateOutput, boolean showCategory, boolean showWarningToken, boolean skipJavac, JavacTestOptions javacOptions, boolean performStatementsRecovery) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, performStatementsRecovery, new Requestor(generateOutput, null, showCategory, showWarningToken), expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, skipJavac ? JavacTestOptions.SKIP : javacOptions);
    }

    protected void runTest(String[] testFiles, boolean expectingCompilerErrors, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, boolean forceExecution, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor customRequestor, boolean skipJavac) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, customRequestor, expectingCompilerErrors, expectedCompilerLog, forceExecution, vmArguments, expectedOutputString, expectedErrorString, skipJavac ? JavacTestOptions.SKIP : JavacTestOptions.DEFAULT);
    }

    protected void runTest(String[] testFiles, boolean expectingCompilerErrors, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, boolean forceExecution, String[] classLibraries, boolean shouldFlushOutputDirectory, String[] vmArguments, Map customOptions, ICompilerRequestor clientRequestor, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, clientRequestor, expectingCompilerErrors, expectedCompilerLog, forceExecution, vmArguments, expectedOutputString, expectedErrorString, javacTestOptions);
    }

    private void runTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] classLibraries, Map customOptions, boolean performStatementsRecovery, ICompilerRequestor customRequestor, boolean expectingCompilerErrors, String expectedCompilerLog, boolean forceExecution, String[] vmArguments, String expectedOutputString, String expectedErrorString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, new String[0], classLibraries, customOptions, performStatementsRecovery, customRequestor, expectingCompilerErrors, expectedCompilerLog, null, forceExecution, vmArguments, expectedOutputString, expectedErrorString, null, javacTestOptions);
    }

    protected void runNegativeTestMultiResult(String[] testFiles, Map options, String[] alternateCompilerErrorLogs) {
        this.runTest(false, testFiles, new String[0], null, options, false, new Requestor(false, null, false, false), true, null, alternateCompilerErrorLogs, false, null, null, null, null, JavacTestOptions.DEFAULT);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void runTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] dependantFiles, String[] classLibraries, Map customOptions, boolean performStatementsRecovery, ICompilerRequestor customRequestor, boolean expectingCompilerErrors, String expectedCompilerLog, String[] alternateCompilerLogs, boolean forceExecution, String[] vmArguments, String expectedOutputString, String expectedErrorString, final ASTVisitor visitor, JavacTestOptions javacTestOptions) {
        block39: {
            block40: {
                if (shouldFlushOutputDirectory) {
                    org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(new File(AbstractRegressionTest.OUTPUT_DIR));
                }
                if (AbstractRegressionTest.RUN_JAVAC && testFiles != null && testFiles.length % 2 != 0) {
                    AbstractRegressionTest.fail((String)"odd number of strings in testFiles");
                }
                requestor = customRequestor instanceof Requestor != false ? (Requestor)customRequestor : new Requestor(forceExecution, customRequestor, false, false);
                requestor.outputPath = AbstractRegressionTest.OUTPUT_DIR.endsWith(File.separator) != false ? AbstractRegressionTest.OUTPUT_DIR : String.valueOf(AbstractRegressionTest.OUTPUT_DIR) + File.separator;
                options = this.getCompilerOptions();
                if (customOptions != null) {
                    options.putAll(customOptions);
                }
                compilerOptions = new CompilerOptions(options);
                compilerOptions.performMethodsFullRecovery = performStatementsRecovery;
                compilerOptions.performStatementsRecovery = performStatementsRecovery;
                nameEnvironment = this.getNameEnvironment(dependantFiles, classLibraries);
                batchCompiler = new Compiler(nameEnvironment, this.getErrorHandlingPolicy(), compilerOptions, requestor, this.getProblemFactory()){

                    public void process(CompilationUnitDeclaration unit, int i) {
                        super.process(unit, i);
                        if (visitor != null) {
                            unit.traverse(visitor, unit.scope);
                        }
                    }
                };
                if (this.enableAPT) {
                    batchCompiler.annotationProcessorManager = this.getAnnotationProcessorManager(batchCompiler);
                }
                compilerOptions.produceReferenceInfo = true;
                exception /* !! */  = null;
                try {
                    try {
                        batchCompiler.compile((ICompilationUnit[])this.getCompilationUnits(testFiles));
                        break block39;
                    }
                    catch (RuntimeException e) {
                        exception /* !! */  = e;
                        throw e;
                    }
                    catch (Error e) {
                        exception /* !! */  = e;
                        throw e;
                    }
                }
                catch (Throwable var24_26) {
                    nameEnvironment.cleanup();
                    alternatePlatformIndepentLogs = null;
                    if (expectedCompilerLog != null) {
                        alternatePlatformIndepentLogs = new String[]{org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(expectedCompilerLog)};
                        break block40;
                    }
                    if (alternateCompilerLogs == null) break block40;
                    alternatePlatformIndepentLogs = new String[alternateCompilerLogs.length];
                    i = 0;
                    ** while (i < alternateCompilerLogs.length)
                }
lbl-1000:
                // 1 sources

                {
                    alternatePlatformIndepentLogs[i] = org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(alternateCompilerLogs[i]);
                    ++i;
                    continue;
                }
            }
            if (alternatePlatformIndepentLogs != null) {
                this.checkCompilerLog(testFiles, requestor, alternatePlatformIndepentLogs, exception /* !! */ );
            }
            if (exception /* !! */  == null) {
                if (expectingCompilerErrors) {
                    if (!requestor.hasErrors) {
                        this.logTestFiles(true, testFiles);
                        AbstractRegressionTest.fail((String)"Unexpected success");
                    }
                } else if (requestor.hasErrors && !"".equals(requestor.problemLog)) {
                    this.logTestFiles(true, testFiles);
                    System.out.println("Copy-paste compiler log:");
                    System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(requestor.problemLog.toString()), AbstractRegressionTest.INDENT, AbstractRegressionTest.SHIFT));
                    AbstractRegressionTest.assertEquals("Unexpected failure", "", requestor.problemLog);
                }
            }
            throw var24_26;
        }
        nameEnvironment.cleanup();
        alternatePlatformIndepentLogs = null;
        if (expectedCompilerLog != null) {
            alternatePlatformIndepentLogs = new String[]{org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(expectedCompilerLog)};
        } else if (alternateCompilerLogs != null) {
            alternatePlatformIndepentLogs = new String[alternateCompilerLogs.length];
            i = 0;
            while (i < alternateCompilerLogs.length) {
                alternatePlatformIndepentLogs[i] = org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(alternateCompilerLogs[i]);
                ++i;
            }
        }
        if (alternatePlatformIndepentLogs != null) {
            this.checkCompilerLog(testFiles, requestor, alternatePlatformIndepentLogs, exception /* !! */ );
        }
        if (exception /* !! */  == null) {
            if (expectingCompilerErrors) {
                if (!requestor.hasErrors) {
                    this.logTestFiles(true, testFiles);
                    AbstractRegressionTest.fail((String)"Unexpected success");
                }
            } else if (requestor.hasErrors && !"".equals(requestor.problemLog)) {
                this.logTestFiles(true, testFiles);
                System.out.println("Copy-paste compiler log:");
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(org.eclipse.jdt.core.tests.util.Util.convertToIndependantLineDelimiter(requestor.problemLog.toString()), AbstractRegressionTest.INDENT, AbstractRegressionTest.SHIFT));
                AbstractRegressionTest.assertEquals("Unexpected failure", "", requestor.problemLog);
            }
        }
        if (!requestor.hasErrors || forceExecution) {
            sourceFile = testFiles[0];
            className = sourceFile.substring(0, sourceFile.length() - 5).replace('/', '.').replace('\\', '.');
            if (className.endsWith(AbstractRegressionTest.PACKAGE_INFO_NAME)) {
                return;
            }
            if (className.endsWith(AbstractRegressionTest.MODULE_INFO_NAME)) {
                return;
            }
            if (vmArguments != null) {
                if (this.verifier != null) {
                    this.verifier.shutDown();
                }
                this.verifier = new TestVerifier(false);
                this.createdVerifier = true;
            }
            if (!(passed = this.verifier.verifyClassFiles(sourceFile, className, expectedOutputString, expectedErrorString, this.classpaths, null, vmArguments))) {
                System.out.println(String.valueOf(this.getClass().getName()) + '#' + this.getName());
                execErrorString = this.verifier.getExecutionError();
                if (execErrorString != null && execErrorString.length() > 0) {
                    System.out.println("[ERR]:" + execErrorString);
                }
                if ((execOutputString = this.verifier.getExecutionOutput()) != null && execOutputString.length() > 0) {
                    System.out.println("[OUT]:" + execOutputString);
                }
                i = 0;
                while (i < testFiles.length) {
                    System.out.print(testFiles[i]);
                    System.out.println(" [");
                    System.out.println(testFiles[i + 1]);
                    System.out.println("]");
                    i += 2;
                }
                AbstractRegressionTest.assertEquals(this.verifier.failureReason, expectedErrorString == null ? "" : expectedErrorString, execErrorString);
                AbstractRegressionTest.assertEquals(this.verifier.failureReason, expectedOutputString == null ? "" : expectedOutputString, execOutputString);
            }
            AbstractRegressionTest.assertTrue((String)this.verifier.failureReason, (boolean)passed);
            if (vmArguments != null) {
                if (this.verifier != null) {
                    this.verifier.shutDown();
                }
                this.verifier = new TestVerifier(false);
                this.createdVerifier = true;
            }
        }
        if (AbstractRegressionTest.RUN_JAVAC && javacTestOptions != JavacTestOptions.SKIP) {
            this.runJavac(testFiles, expectingCompilerErrors, expectedCompilerLog, expectedOutputString, expectedErrorString, shouldFlushOutputDirectory, javacTestOptions, vmArguments);
        }
    }

    protected AbstractAnnotationProcessorManager getAnnotationProcessorManager(Compiler compiler) {
        try {
            DummyAnnotationProcessingManager annotationManager = new DummyAnnotationProcessingManager();
            annotationManager.configure(compiler, new String[0]);
            annotationManager.setErr(new PrintWriter(System.err));
            annotationManager.setOut(new PrintWriter(System.out));
            return annotationManager;
        }
        catch (UnsupportedClassVersionError e) {
            System.err.println(e);
            return null;
        }
    }

    public void runConformTest(String[] testFiles, JavacTestOptions javacTestOptions) {
        this.runTest(true, testFiles, null, null, false, null, false, "", false, null, "", "", javacTestOptions);
    }

    protected void runConformTest(boolean shouldFlushOutputDirectory, String[] testFiles, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, null, null, false, null, false, expectedCompilerLog, false, null, expectedOutputString, expectedErrorString, javacTestOptions);
    }

    protected void runConformTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] classLibraries, Map customOptions, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, null, false, expectedCompilerLog, false, null, expectedOutputString, expectedErrorString, javacTestOptions);
    }

    protected void runNegativeTest(String[] testFiles, String expectedCompilerLog, JavacTestOptions javacTestOptions) {
        this.runTest(true, testFiles, null, null, false, null, true, expectedCompilerLog, false, null, null, null, javacTestOptions);
    }

    protected void runNegativeTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] classLibraries, Map customOptions, String expectedCompilerLog, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, null, expectedCompilerLog == null || expectedCompilerLog.indexOf("ERROR") != -1, expectedCompilerLog, false, null, null, null, javacTestOptions);
    }

    protected void runNegativeTest(boolean shouldFlushOutputDirectory, String[] testFiles, String[] classLibraries, Map customOptions, String expectedCompilerLog, String expectedOutputString, String expectedErrorString, JavacTestOptions javacTestOptions) {
        this.runTest(shouldFlushOutputDirectory, testFiles, classLibraries, customOptions, false, null, true, expectedCompilerLog, true, null, expectedOutputString, expectedErrorString, javacTestOptions);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (this.verifier == null) {
            this.verifier = new TestVerifier(true);
            this.createdVerifier = true;
        }
        if (RUN_JAVAC && this.isFirst()) {
            if (javacFullLog == null) {
                JAVAC_OUTPUT_DIR = new File(JAVAC_OUTPUT_DIR_NAME);
                String jdkRootDirectory = System.getProperty("jdk.root");
                jdkRootDirPath = jdkRootDirectory == null ? new Path(org.eclipse.jdt.core.tests.util.Util.getJREDirectory()).removeLastSegments(1) : new Path(jdkRootDirectory);
                StringBuffer cmdLineHeader = new StringBuffer(jdkRootDirPath.append("bin").append(JAVA_NAME).toString());
                javaCommandLineHeader = cmdLineHeader.toString();
                cmdLineHeader = new StringBuffer(jdkRootDirPath.append("bin").append(JAVAC_NAME).toString());
                cmdLineHeader.append(" -classpath . ");
                String version = JavacCompiler.getVersion(cmdLineHeader.toString());
                cmdLineHeader.append(" -d ");
                cmdLineHeader.append(JAVAC_OUTPUT_DIR_NAME.indexOf(" ") != -1 ? "\"" + JAVAC_OUTPUT_DIR_NAME + "\"" : JAVAC_OUTPUT_DIR_NAME);
                cmdLineHeader.append(" -source 1.5 -deprecation -Xlint ");
                javacCommandLineHeader = cmdLineHeader.toString();
                new File(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()).mkdirs();
                javacFullLogFileName = String.valueOf(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory()) + File.separatorChar + version.replace(' ', '_') + "_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".txt";
                javacFullLog = new PrintWriter(new FileOutputStream(javacFullLogFileName));
                javacFullLog.println(version);
                System.out.println("***************************************************************************");
                System.out.println("* Sun Javac compiler output archived into file:");
                System.out.println("* " + javacFullLogFileName);
                System.out.println("***************************************************************************");
                javacCompilers = new ArrayList();
                String jdkRoots = System.getProperty("jdk.roots");
                if (jdkRoots == null) {
                    javacCompilers.add(new JavacCompiler(jdkRootDirPath.toString()));
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(jdkRoots, File.pathSeparator);
                    while (tokenizer.hasMoreTokens()) {
                        javacCompilers.add(new JavacCompiler(tokenizer.nextToken()));
                    }
                }
            }
            CURRENT_CLASS_NAME = this.getClass().getName();
            this.dualPrintln("***************************************************************************");
            System.out.print("* Comparison with Sun Javac compiler for class ");
            this.dualPrintln(String.valueOf(CURRENT_CLASS_NAME.substring(CURRENT_CLASS_NAME.lastIndexOf(46) + 1)) + " (" + TESTS_COUNTERS.get(CURRENT_CLASS_NAME) + " tests)");
            System.out.println("***************************************************************************");
            AbstractRegressionTest.DIFF_COUNTERS[0] = 0;
            AbstractRegressionTest.DIFF_COUNTERS[1] = 0;
            AbstractRegressionTest.DIFF_COUNTERS[2] = 0;
        }
    }

    @Override
    public void stop() {
        this.verifier.shutDown();
    }

    @Override
    protected void tearDown() throws Exception {
        File outputDir;
        if (this.createdVerifier) {
            this.stop();
        }
        if ((outputDir = new File(OUTPUT_DIR)).exists()) {
            org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(outputDir);
        }
        super.tearDown();
        if (RUN_JAVAC) {
            if (JAVAC_OUTPUT_DIR.exists()) {
                org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(JAVAC_OUTPUT_DIR);
            }
            this.printJavacResultsSummary();
        }
    }

    protected String getCompilerTestsPluginDirectoryPath() {
        try {
            URL platformURL = Platform.getBundle((String)"org.eclipse.jdt.core.tests.compiler").getEntry("/");
            return new File(FileLocator.toFileURL((URL)platformURL).getFile()).getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    class DummyAnnotationProcessingManager
    extends BaseAnnotationProcessorManager {
        ProcessorInfo processorInfo = null;

        DummyAnnotationProcessingManager() {
        }

        public ProcessorInfo discoverNextProcessor() {
            ProcessorInfo temp = this.processorInfo;
            this.processorInfo = null;
            return temp;
        }

        public void reportProcessorException(Processor p, Exception e) {
            throw new AbortCompilation(null, (Throwable)e);
        }

        public void setProcessors(Object[] processors) {
        }

        public void configure(Object batchCompiler, String[] options) {
            this._processingEnv = new DummyEnvironmentImpl((Compiler)batchCompiler);
        }

        public void processAnnotations(CompilationUnitDeclaration[] units, ReferenceBinding[] referenceBindings, boolean isLastRound) {
            if (this.processorInfo == null) {
                this.processorInfo = new ProcessorInfo((Processor)new DummyProcessor());
            }
            super.processAnnotations(units, referenceBindings, isLastRound);
        }

        public void configureFromPlatform(Compiler compiler, Object compilationUnitLocator, Object javaProject) {
        }

        class DummyEnvironmentImpl
        extends BaseProcessingEnvImpl {
            public DummyEnvironmentImpl(Compiler compiler) {
                this._compiler = compiler;
            }

            public Locale getLocale() {
                return Locale.getDefault();
            }
        }

        @SupportedAnnotationTypes(value={"*"})
        class DummyProcessor
        extends AbstractProcessor {
            DummyProcessor() {
            }

            @Override
            public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                return true;
            }
        }
    }

    static class JavaRuntime {
        private String rootDirectoryPath;
        private String javaPathName;
        String version;
        String rawVersion;
        int minor;
        private static HashMap runtimes = new HashMap();

        static JavaRuntime runtimeFor(JavacCompiler compiler) throws IOException, InterruptedException {
            JavaRuntime cached = (JavaRuntime)runtimes.get(compiler.rawVersion);
            if (cached == null) {
                cached = new JavaRuntime(compiler.rootDirectoryPath, compiler.version, compiler.rawVersion, compiler.minor);
                runtimes.put(compiler.rawVersion, cached);
            }
            return cached;
        }

        private JavaRuntime(String rootDirectoryPath, String version, String rawVersion, int minor) throws IOException, InterruptedException {
            this.rootDirectoryPath = rootDirectoryPath;
            this.javaPathName = new File(String.valueOf(this.rootDirectoryPath) + File.separator + "bin" + File.separator + JAVA_NAME).getCanonicalPath();
            this.version = version;
            this.rawVersion = rawVersion;
            this.minor = minor;
        }

        int execute(File directory, String options, String className, StringBuffer stdout, StringBuffer stderr) throws IOException, InterruptedException {
            Process executionProcess = null;
            try {
                StringBuffer cmdLine = new StringBuffer(this.javaPathName);
                cmdLine.append(" -classpath . ");
                cmdLine.append(options);
                cmdLine.append(' ');
                cmdLine.append(className);
                executionProcess = Runtime.getRuntime().exec(cmdLine.toString(), null, directory);
                Logger outputLogger = new Logger(executionProcess.getInputStream(), "RUNTIME OUTPUT", stdout == null ? new StringBuffer() : stdout);
                outputLogger.start();
                Logger errorLogger = new Logger(executionProcess.getErrorStream(), "RUNTIME ERROR", stderr == null ? new StringBuffer() : stderr);
                errorLogger.start();
                int result = executionProcess.waitFor();
                outputLogger.join();
                errorLogger.join();
                int n = result;
                return n;
            }
            finally {
                if (executionProcess != null) {
                    executionProcess.destroy();
                }
            }
        }
    }

    static class JavacCompiler {
        String rootDirectoryPath;
        String javacPathName;
        String version;
        int minor;
        String rawVersion;
        long compliance;
        public static final long EXIT_VALUE_MASK = 0xFFFFFFFFL;
        public static final long ERROR_LOG_MASK = -4294967296L;
        private String classpath;

        JavacCompiler(String rootDirectoryPath) throws IOException, InterruptedException {
            this(rootDirectoryPath, null);
        }

        JavacCompiler(String rootDirectoryPath, String rawVersion) throws IOException, InterruptedException {
            this.rootDirectoryPath = rootDirectoryPath;
            this.javacPathName = new File(String.valueOf(rootDirectoryPath) + File.separator + "bin" + File.separator + JAVAC_NAME).getCanonicalPath();
            if (rawVersion == null) {
                rawVersion = JavacCompiler.getVersion(this.javacPathName);
            }
            if (rawVersion.indexOf("1.4") != -1 || this.javacPathName.indexOf("1.4") != -1) {
                this.version = "1.4";
            } else if (rawVersion.indexOf("1.5") != -1) {
                this.version = "1.5";
            } else if (rawVersion.indexOf("1.6") != -1) {
                this.version = "1.6";
            } else if (rawVersion.indexOf("1.7") != -1) {
                this.version = "1.7";
            } else if (rawVersion.indexOf("1.8") != -1) {
                this.version = "1.8";
            } else if (rawVersion.startsWith("9")) {
                this.version = "9";
            } else {
                throw new RuntimeException("unknown javac version: " + rawVersion);
            }
            this.compliance = CompilerOptions.versionToJdkLevel((String)this.version);
            this.minor = JavacCompiler.minorFromRawVersion(this.version, rawVersion);
            this.rawVersion = rawVersion;
            StringBuffer classpathBuffer = new StringBuffer(" -classpath ");
            this.classpath = classpathBuffer.toString();
        }

        static String getVersion(String javacPathName) throws IOException, InterruptedException {
            Process fetchVersionProcess = null;
            try {
                int eol;
                fetchVersionProcess = Runtime.getRuntime().exec(String.valueOf(javacPathName) + " -version", null, null);
                Logger versionStdErrLogger = new Logger(fetchVersionProcess.getErrorStream(), "");
                Logger versionStdOutLogger = new Logger(fetchVersionProcess.getInputStream(), "");
                versionStdErrLogger.start();
                versionStdOutLogger.start();
                fetchVersionProcess.waitFor();
                versionStdErrLogger.join();
                versionStdOutLogger.join();
                String loggedVersion = versionStdErrLogger.buffer.toString();
                if (loggedVersion.isEmpty()) {
                    loggedVersion = versionStdOutLogger.buffer.toString();
                }
                if ((eol = loggedVersion.indexOf(10)) != -1) {
                    loggedVersion = loggedVersion.substring(0, eol);
                }
                if (loggedVersion.startsWith("javac ")) {
                    loggedVersion = loggedVersion.substring(6, loggedVersion.length());
                }
                String string = loggedVersion;
                return string;
            }
            finally {
                if (fetchVersionProcess != null) {
                    fetchVersionProcess.destroy();
                }
            }
        }

        static int minorFromRawVersion(String version, String rawVersion) {
            if (version == "1.5") {
                if ("1.5.0_15-ea".equals(rawVersion)) {
                    return 1500;
                }
                if ("1.5.0_16-ea".equals(rawVersion)) {
                    return 1600;
                }
            }
            if (version == "1.6") {
                if ("1.6.0_10-ea".equals(rawVersion)) {
                    return 1000;
                }
                if ("1.6.0_10-beta".equals(rawVersion)) {
                    return 1010;
                }
                if ("1.6.0_45".equals(rawVersion)) {
                    return 1045;
                }
            }
            if (version == "1.7") {
                if ("1.7.0-ea".equals(rawVersion)) {
                    return 0;
                }
                if ("1.7.0_10".equals(rawVersion)) {
                    return 1000;
                }
                if ("1.7.0_25".equals(rawVersion)) {
                    return 2500;
                }
                if ("1.7.0_80".equals(rawVersion)) {
                    return 8000;
                }
            }
            if (version == "1.8") {
                if ("1.8.0-ea".equals(rawVersion) || "1.8.0".equals(rawVersion)) {
                    return 0;
                }
                if ("1.8.0_40".equals(rawVersion)) {
                    return 1000;
                }
                if ("1.8.0_45".equals(rawVersion)) {
                    return 1100;
                }
                if ("1.8.0_60".equals(rawVersion)) {
                    return 1500;
                }
            }
            if (version == "9") {
                return 0;
            }
            throw new RuntimeException("unknown raw javac version: " + rawVersion);
        }

        long compile(File directory, String options, String[] sourceFileNames, StringBuffer log) throws IOException, InterruptedException {
            Process compileProcess = null;
            long result = 0L;
            try {
                if (!directory.exists()) {
                    directory.mkdir();
                }
                StringBuffer cmdLine = new StringBuffer(this.javacPathName);
                cmdLine.append(this.classpath);
                cmdLine.append(". ");
                cmdLine.append(options);
                int i = 0;
                while (i < sourceFileNames.length) {
                    cmdLine.append(' ');
                    cmdLine.append(sourceFileNames[i]);
                    ++i;
                }
                String cmdLineAsString = "Linux".equals(System.getProperty("os.name")) ? cmdLine.toString().replaceAll("\"", "") : cmdLine.toString();
                compileProcess = Runtime.getRuntime().exec(cmdLineAsString, null, directory);
                Logger errorLogger = new Logger(compileProcess.getErrorStream(), "ERROR", log == null ? new StringBuffer() : log);
                errorLogger.start();
                int compilerResult = compileProcess.waitFor();
                result |= (long)compilerResult;
                errorLogger.join();
                if (errorLogger.buffer.length() > 0) {
                    System.err.println("--- javac err: ---");
                    System.err.println(errorLogger.buffer.toString());
                    result |= 0xFFFFFFFF00000000L;
                }
            }
            finally {
                if (compileProcess != null) {
                    compileProcess.destroy();
                }
            }
            return result;
        }
    }

    protected static class JavacTestOptions {
        static final JavacTestOptions DEFAULT = new JavacTestOptions();
        static final JavacTestOptions SKIP = new JavacTestOptions(){

            @Override
            boolean skip(JavacCompiler compiler) {
                return true;
            }
        };
        static final JavacTestOptions SKIP_UNTIL_FRAMEWORK_FIX = new JavacTestOptions(){

            @Override
            boolean skip(JavacCompiler compiler) {
                return true;
            }
        };
        private String compilerOptions = "";

        public JavacTestOptions() {
        }

        public JavacTestOptions(String compilerOptions) {
            this.compilerOptions = compilerOptions;
        }

        String getCompilerOptions() {
            return this.compilerOptions;
        }

        public void setCompilerOptions(String options) {
            this.compilerOptions = options;
        }

        boolean skip(JavacCompiler compiler) {
            return false;
        }

        Excuse excuseFor(JavacCompiler compiler) {
            return null;
        }

        public static class EclipseHasABug
        extends Excuse {
            public static EclipseHasABug EclipseBug159851 = RUN_JAVAC ? new EclipseHasABug(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x330000L ? this : null;
                }
            } : null;
            public static EclipseHasABug EclipseBug177715 = RUN_JAVAC ? new EclipseHasABug(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x340000L ? this : null;
                }
            } : null;
            public static EclipseHasABug EclipseBug207935 = RUN_JAVAC ? new EclipseHasABug(17) : null;
            public static EclipseHasABug EclipseBug216558 = RUN_JAVAC ? new EclipseHasABug(4) : null;
            public static EclipseHasABug EclipseBug235550 = RUN_JAVAC ? new EclipseHasABug(4) : null;
            public static EclipseHasABug EclipseBug235809 = RUN_JAVAC ? new EclipseHasABug(64) : null;
            public static EclipseHasABug EclipseBug236217 = RUN_JAVAC ? new EclipseHasABug(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x340000L ? this : null;
                }
            } : null;
            public static EclipseHasABug EclipseBug236236 = RUN_JAVAC ? new EclipseHasABug(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x310000L ? this : null;
                }
            } : null;
            public static EclipseHasABug EclipseBug236242 = RUN_JAVAC ? new EclipseHasABug(2){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance == 0x330000L ? this : null;
                }
            } : null;
            public static EclipseHasABug EclipseBug236243 = RUN_JAVAC ? new EclipseHasABug(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x320000L ? this : null;
                }
            } : null;
            public static EclipseHasABug EclipseBug236379 = RUN_JAVAC ? new EclipseHasABug(16){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x310000L ? null : this;
                }
            } : null;
            public static EclipseHasABug EclipseBug424410 = RUN_JAVAC ? new EclipseHasABug(4) : null;
            public static EclipseHasABug EclipseBug427719 = RUN_JAVAC ? new EclipseHasABug(8) : null;
            public static EclipseHasABug EclipseBug421922 = RUN_JAVAC ? new EclipseHasABug(1) : null;
            public static EclipseHasABug EclipseBug428061 = RUN_JAVAC ? new EclipseHasABug(12) : null;

            EclipseHasABug(int mismatchType) {
                super(mismatchType);
            }
        }

        public static class EclipseJustification
        extends Excuse {
            public static final EclipseJustification EclipseBug72704 = RUN_JAVAC ? new EclipseJustification(1) : null;
            public static final EclipseJustification EclipseBug83902 = RUN_JAVAC ? new EclipseJustification(16){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x310000L ? this : null;
                }
            } : null;
            public static final EclipseJustification EclipseBug83902b = RUN_JAVAC ? new EclipseJustification(8) : null;
            public static final EclipseJustification EclipseBug95021 = RUN_JAVAC ? new EclipseJustification(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance == 0x330000L ? this : null;
                }
            } : null;
            public static final EclipseJustification EclipseBug112433 = RUN_JAVAC ? new EclipseJustification(4) : null;
            public static final EclipseJustification EclipseBug126712 = RUN_JAVAC ? new EclipseJustification(64){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x310000L ? this : null;
                }
            } : null;
            public static final EclipseJustification EclipseBug126744 = RUN_JAVAC ? new EclipseJustification(4) : null;
            public static final EclipseJustification EclipseBug151275 = RUN_JAVAC ? new EclipseJustification(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x330000L ? this : null;
                }
            } : null;
            public static final EclipseJustification EclipseBug159214 = RUN_JAVAC ? new EclipseJustification(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance == 0x320000L ? this : null;
                }
            } : null;
            public static final EclipseJustification EclipseBug169017 = RUN_JAVAC ? new EclipseJustification(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x310000L ? this : null;
                }
            } : null;
            public static final EclipseJustification EclipseBug180789 = RUN_JAVAC ? new EclipseJustification(2) : null;
            public static final EclipseJustification EclipseBug218677 = RUN_JAVAC ? new EclipseJustification(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance > 0x320000L ? this : null;
                }
            } : null;
            public static final EclipseJustification EclipseBug234815 = RUN_JAVAC ? new EclipseJustification(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance < 0x330000L ? this : null;
                }
            } : null;
            public static final EclipseJustification EclipseBug235543 = RUN_JAVAC ? new EclipseJustification(1) : null;
            public static final EclipseJustification EclipseBug235546 = RUN_JAVAC ? new EclipseJustification(4) : null;
            public static final EclipseJustification EclipseJustification0001 = RUN_JAVAC ? new EclipseJustification(1) : null;

            EclipseJustification(int mismatchType) {
                super(mismatchType);
            }
        }

        public static class Excuse
        extends JavacTestOptions {
            protected int mismatchType;
            public static Excuse EclipseHasSomeMoreWarnings = RUN_JAVAC ? new Excuse(16) : null;
            public static Excuse EclipseWarningConfiguredAsError = RUN_JAVAC ? new Excuse(3) : null;
            public static Excuse JavacCompilesBogusReferencedFileAgain = RUN_JAVAC ? new Excuse(1) : null;
            public static Excuse JavacDoesNotCompileCorrectSource = RUN_JAVAC ? new JavacHasABug(4) : null;
            public static Excuse JavacCompilesIncorrectSource = RUN_JAVAC ? new JavacHasABug(19) : null;
            public static Excuse JavacGeneratesIncorrectCode = RUN_JAVAC ? new JavacHasABug(64) : null;
            public static Excuse JavacHasWarningsEclipseNotConfigured = RUN_JAVAC ? new JavacHasABug(32) : null;
            public static Excuse JavacHasErrorsEclipseHasWarnings = RUN_JAVAC ? new JavacHasABug(8) : null;
            public static Excuse JavacHasErrorsEclipseHasNone = RUN_JAVAC ? new JavacHasABug(4) : null;

            Excuse(int mismatchType) {
                this.mismatchType = mismatchType;
            }

            @Override
            Excuse excuseFor(JavacCompiler compiler) {
                return this;
            }

            public boolean clears(int mismatch) {
                return this.mismatchType == 0 || (this.mismatchType & mismatch) == mismatch;
            }
        }

        public static class JavacHasABug
        extends Excuse {
            long pivotCompliance;
            int pivotMinor;
            int[] minorsFixed;
            static final int NO_FIX = -1;
            static final int IRRELEVANT = -2;
            public static JavacHasABug JavacBug4094180 = RUN_JAVAC ? new JavacHasABug(1) : null;
            public static JavacHasABug JavacBug4660984 = RUN_JAVAC ? new JavacHasABug(4) : null;
            public static JavacHasABug JavacBug5042462 = RUN_JAVAC ? new JavacHasABug(4, 0x330000L, 0) : null;
            public static JavacHasABug JavacBug5061359 = RUN_JAVAC ? new JavacHasABug(1, 0x330000L, 0) : null;
            public static JavacHasABug JavacBug6302954 = RUN_JAVAC ? new JavacHasABug(4, 0x330000L, 0) : null;
            public static JavacHasABug JavacBug6400189 = RUN_JAVAC ? new JavacHasABug(1){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance == 0x320000L ? this : null;
                }
            } : null;
            public static JavacHasABug JavacBug6500701 = RUN_JAVAC ? new JavacHasABug(64, 0x330000L, 0) : null;
            public static JavacHasABug JavacBug6531075 = RUN_JAVAC ? new JavacHasABug(64, 0x330000L, 0) : null;
            public static JavacHasABug JavacBug6569404 = RUN_JAVAC ? new JavacHasABug(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance == 0x320000L && compiler.minor >= 10 ? this : null;
                }
            } : null;
            public static JavacHasABug JavacBug6557661 = RUN_JAVAC ? new JavacHasABug(1) : null;
            public static JavacHasABug JavacBug6573446 = RUN_JAVAC ? new JavacHasABug(1) : null;
            public static JavacHasABug JavacBug6575821 = RUN_JAVAC ? new JavacHasABug(4, 0x320000L, 10) : null;
            public static JavacHasABug JavacBug8033810 = RUN_JAVAC ? new JavacHasABug(1) : null;
            public static JavacHasABug JavacBugFixed_6_10 = RUN_JAVAC ? new JavacHasABug(0, 0x320000L, 1000) : null;
            public static JavacHasABug JavacBugFixed_6_10_b24 = RUN_JAVAC ? new JavacHasABug(0, 0x320000L, 1010) : null;
            public static JavacHasABug JavacBugFixed_7 = RUN_JAVAC ? new JavacHasABug(0, 0x330000L, 0) : null;
            public static JavacHasABug JavacGeneratesByteCodeUponWhichJavaThrowsAnException = RUN_JAVAC ? new JavacHasABug(64) : null;
            public static JavacHasABug JavacThrowsAnException = RUN_JAVAC ? new JavacHasABug(4) : null;
            public static JavacHasABug JavacThrowsAnExceptionForJava_1_5_0_16 = RUN_JAVAC ? new JavacHasABug(4){

                @Override
                Excuse excuseFor(JavacCompiler compiler) {
                    return compiler.compliance != 0x310000L || compiler.minor != 1600 ? null : this;
                }
            } : null;

            JavacHasABug(int mismatchType) {
                super(mismatchType);
            }

            private JavacHasABug(int mismatchType, long pivotCompliance, int pivotMinor) {
                super(mismatchType);
                this.pivotCompliance = pivotCompliance;
                this.pivotMinor = pivotMinor;
            }

            @Override
            Excuse excuseFor(JavacCompiler compiler) {
                if (this.minorsFixed != null) {
                    if (compiler.compliance == 0x340000L) {
                        return this.minorsFixed[5] > compiler.minor || this.minorsFixed[5] < 0 ? this : null;
                    }
                    if (compiler.compliance == 0x330000L) {
                        return this.minorsFixed[4] > compiler.minor || this.minorsFixed[4] < 0 ? this : null;
                    }
                    if (compiler.compliance == 0x320000L) {
                        return this.minorsFixed[3] > compiler.minor || this.minorsFixed[3] < 0 ? this : null;
                    }
                    if (compiler.compliance == 0x310000L) {
                        return this.minorsFixed[2] > compiler.minor || this.minorsFixed[2] < 0 ? this : null;
                    }
                    if (compiler.compliance == 0x300000L) {
                        return this.minorsFixed[1] > compiler.minor || this.minorsFixed[1] < 0 ? this : null;
                    }
                    if (compiler.compliance == 0x2F0000L) {
                        return this.minorsFixed[0] > compiler.minor || this.minorsFixed[0] < 0 ? this : null;
                    }
                    throw new RuntimeException();
                }
                if (this.pivotCompliance > 0L) {
                    if (this.pivotCompliance < compiler.compliance) {
                        return null;
                    }
                    if (this.pivotCompliance > compiler.compliance) {
                        return this;
                    }
                    return this.pivotMinor > compiler.minor ? this : null;
                }
                if (this.pivotCompliance < 0L) {
                    if (this.pivotCompliance < -compiler.compliance) {
                        return null;
                    }
                    if (this.pivotCompliance > -compiler.compliance) {
                        return this;
                    }
                    return this.pivotMinor <= compiler.minor ? this : null;
                }
                return this;
            }
        }

        static class MismatchType {
            static final int EclipseErrorsJavacNone = 1;
            static final int EclipseErrorsJavacWarnings = 2;
            static final int JavacErrorsEclipseNone = 4;
            static final int JavacErrorsEclipseWarnings = 8;
            static final int EclipseWarningsJavacNone = 16;
            static final int JavacWarningsEclipseNone = 32;
            static final int StandardOutputMismatch = 64;
            static final int ErrorOutputMismatch = 128;
            static final int JavacAborted = 256;
            static final int JavacNotLaunched = 512;
            static final int JavaAborted = 1024;
            static final int JavaNotLaunched = 2048;

            MismatchType() {
            }
        }
    }

    static class Logger
    extends Thread {
        StringBuffer buffer;
        InputStream inputStream;
        String type;

        Logger(InputStream inputStream, String type) {
            this.inputStream = inputStream;
            this.type = type;
            this.buffer = new StringBuffer();
        }

        Logger(InputStream inputStream, String type, StringBuffer buffer) {
            this.inputStream = inputStream;
            this.type = type;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.buffer.append(line).append("\n");
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static final class ProblemLog {
        final Set<String> logEntry = new HashSet<String>();

        public ProblemLog(String log) {
            String[] entries = log.split("----------\n");
            Pattern pattern = Pattern.compile("\\A(\\d*\\. )");
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                Matcher matcher = pattern.matcher(entry);
                if (matcher.find()) {
                    entry = entry.substring(matcher.end());
                }
                this.logEntry.add(entry);
                ++n2;
            }
        }

        public boolean sameAs(String toTest) {
            ProblemLog log = new ProblemLog(toTest);
            return this.equals(log);
        }

        public int hashCode() {
            return this.logEntry.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProblemLog other = (ProblemLog)obj;
            return this.logEntry.equals(other.logEntry);
        }
    }
}

