/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.util.Util;

public class AutoBoxingTest
extends AbstractComparableTest {
    public AutoBoxingTest(String name) {
        super(name);
    }

    @Override
    protected Map getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.autoboxing", "warning");
        return defaultOptions;
    }

    public static Test suite() {
        return AutoBoxingTest.buildComparableTestSuite(AutoBoxingTest.testClass());
    }

    public static Class testClass() {
        return AutoBoxingTest.class;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(1);\n\t}\n\tpublic static void test(Integer i) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest((byte)127);\n\t}\n\tpublic static void test(Byte b) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest('b');\n\t}\n\tpublic static void test(Character c) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(-0.0f);\n\t}\n\tpublic static void test(Float f) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(0.0);\n\t}\n\tpublic static void test(Double d) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(Long.MAX_VALUE);\n\t}\n\tpublic static void test(Long l) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(Short.MAX_VALUE);\n\t}\n\tpublic static void test(Short s) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(false);\n\t}\n\tpublic static void test(Boolean b) { System.out.print('y'); }\n}\n"}, "y");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int bar() {return 1;}\n\tpublic static void main(String[] s) {\n\t\ttest(bar());\n\t}\n\tpublic static void test(Integer i) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static byte bar() {return 1;}\n\tpublic static void main(String[] s) {\n\t\ttest(bar());\n\t}\n\tpublic static void test(Byte b) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static char bar() {return 'c';}\n\tpublic static void main(String[] s) {\n\t\ttest(bar());\n\t}\n\tpublic static void test(Character c) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static float bar() {return 0.0f;}\n\tpublic static void main(String[] s) {\n\t\ttest(bar());\n\t}\n\tpublic static void test(Float f) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static double bar() {return 0.0;}\n\tpublic static void main(String[] s) {\n\t\ttest(bar());\n\t}\n\tpublic static void test(Double d) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static long bar() {return 0;}\n\tpublic static void main(String[] s) {\n\t\ttest(bar());\n\t}\n\tpublic static void test(Long l) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static short bar() {return 0;}\n\tpublic static void main(String[] s) {\n\t\ttest(bar());\n\t}\n\tpublic static void test(Short s) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static boolean bar() {return true;}\n\tpublic static void main(String[] s) {\n\t\ttest(bar());\n\t}\n\tpublic static void test(Boolean b) { System.out.print('y'); }\n}\n"}, "y");
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(new Integer(1));\n\t}\n\tpublic static void test(int i) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(new Byte((byte) 1));\n\t}\n\tpublic static void test(byte b) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(new Byte((byte) 1));\n\t}\n\tpublic static void test(long l) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(new Character('c'));\n\t}\n\tpublic static void test(char c) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(new Float(0.0f));\n\t}\n\tpublic static void test(float f) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(new Double(0.0));\n\t}\n\tpublic static void test(double d) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(new Long(0L));\n\t}\n\tpublic static void test(long l) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(new Short((short) 0));\n\t}\n\tpublic static void test(short s) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\ttest(Boolean.TRUE);\n\t}\n\tpublic static void test(boolean b) { System.out.print('y'); }\n}\n"}, "y");
    }

    public void test004() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.test(1);\n\t}\n}\nclass Y {\n\tprivate static void test(int i) { System.out.print('n'); }\n\tstatic void test(int... i) { System.out.print('n'); }\n\tpublic static void test(Integer i) { System.out.print('y'); }\n}\n"}, "y");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tnew Y().test(1);\n\t}\n}\nclass Y {\n\tprivate void test(int i) { System.out.print('n'); }\n\tvoid test(int... i) { System.out.print('n'); }\n\tpublic void test(Integer i) { System.out.print('y'); }\n}\n"}, "y");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tnew Y().test(1);\n\t}\n}\nclass Y {\n\tvoid test(Integer i) { System.out.print('n'); }\n\tvoid test(long i) { System.out.print('y'); }\n}\n"}, "y");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tnew Y().test(1, 1);\n\t}\n}\nclass Y {\n\tvoid test(Long i, int j) { System.out.print('n'); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew Y().test(1, 1);\n\t        ^^^^\nThe method test(Long, int) in the type Y is not applicable for the arguments (int, int)\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tnew Y().test((byte) 1, 1);\n\t}\n}\nclass Y {\n\tvoid test(Integer i, int j) { System.out.print('n'); }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew Y().test((byte) 1, 1);\n\t        ^^^^\nThe method test(Integer, int) in the type Y is not applicable for the arguments (byte, int)\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tnew Y().test(1, 1);\n\t}\n}\nclass Y {\n\tvoid test(Long i, int j) { System.out.print('n'); }\n\tvoid test(long i, Integer j) { System.out.print('y'); }\n}\n"}, "y");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tY.test(1, new Integer(2), -3);\n\t}\n}\nclass Y {\n\tpublic static void test(int ... i) { System.out.print('y'); }\n}\n"}, "y");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"deprecation\")\n\tpublic static void main(String[] s) {\n\t\tnew Y().test(1, 1);\n\t\tnew Y().test(new Integer(1), new Integer(1));\n\t}\n}\nclass Y {\n\tvoid test(Integer i, int j) {}\n\tvoid test(int i, Integer j) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tnew Y().test(1, 1);\n\t        ^^^^\nThe method test(Integer, int) is ambiguous for the type Y\n----------\n2. ERROR in X.java (at line 5)\n\tnew Y().test(new Integer(1), new Integer(1));\n\t        ^^^^\nThe method test(Integer, int) is ambiguous for the type Y\n----------\n");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tnew Y().test(new Integer(1), 1);\n\t\tnew Y().test(1, new Integer(1));\n\t}\n}\nclass Y {\n\tvoid test(Integer i, int j) { System.out.print(1); }\n\tvoid test(int i, Integer j) { System.out.print(2); }\n}\n"}, "12");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tint i = Y.test();\n\t\tSystem.out.print(i);\n\t}\n}\nclass Y {\n\tpublic static Byte test() { return new Byte((byte) 1); }\n}\n"}, "1");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tObject o = Y.test();\n\t\tSystem.out.print(o);\n\t}\n}\nclass Y {\n\tpublic static int test() { return 1; }\n}\n"}, "1");
    }

    public void test011() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int i = Y.test();\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print(i);\n\t}\n}\nclass Y {\n\tpublic static Byte test() { return new Byte((byte) 1); }\n}\n"}, "1");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic Object o = Y.test();\n\tpublic static void main(String[] s) {\n\t\tSystem.out.print(o);\n\t}\n}\nclass Y {\n\tpublic static int test() { return 1; }\n}\n"}, "1");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger x = new Integer(15); \n\t\tint y = 32;\n\t\tSystem.out.printf(\"%x + %x\", x, y);\n\t}\n}"}, "f + 20");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint[] tab = new int[] { 1, 2, 3, 4, 5, 6, 7, 8, 9 };\n\t\tfor (final Integer e : tab) {\n\t\t\tSystem.out.print(e);\n\t\t}\n\t}\n}\n"}, "123456789");
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger[] tab = new Integer[] { 1, 2, 3, 4, 5, 6, 7, 8, 9 };\n\t\tfor (final int e : tab) {\n\t\t\tSystem.out.print(e);\n\t\t}\n\t}\n}\n"}, "123456789");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tInteger i = new Integer(1);\n\t\tswitch(i) {\n\t\t\tcase 1 : System.out.print('y');\n\t\t}\n\t}\n}\n"}, "y");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic Integer foo1() {\n\t\treturn 0;\n\t}\n\tstatic int foo2() {\n\t\treturn new Integer(0);\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(foo1());\n\t\tSystem.out.println(foo2());\n\t}\n}\n"}, "00");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger i = args.length == 0 ? 0 : new Integer(1);\n\t\tSystem.out.println(i);\n\t}\n}\n"}, "0");
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger i = new Integer(1);\n\t\tSystem.out.println((int)i);\n\t}\n}\n"}, "1");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"deprecation\")\n\tpublic static void main(String[] args) {\n\t\tFloat f = args.length == 0 ? new Float(0) : 0;\n\t\tSystem.out.println((int)f);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tFloat f = args.length == 0 ? new Float(0) : 0;\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type float is boxed into Float\n----------\n2. WARNING in X.java (at line 4)\n\tFloat f = args.length == 0 ? new Float(0) : 0;\n\t                             ^^^^^^^^^^^^\nThe expression of type Float is unboxed into float\n----------\n3. ERROR in X.java (at line 5)\n\tSystem.out.println((int)f);\n\t                   ^^^^^^\nCannot cast from Float to int\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println((Integer) 0);\n\t\tSystem.out.println((Float) 0);\n\t\t\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tSystem.out.println((Integer) 0);\n\t                             ^\nThe expression of type int is boxed into Integer\n----------\n2. ERROR in X.java (at line 4)\n\tSystem.out.println((Float) 0);\n\t                   ^^^^^^^^^\nCannot cast from int to Float\n----------\n");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t    Byte b = new Byte((byte)1);\n      System.out.println(2 + b);\n    }\n}\n"}, "3");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t    Byte b = new Byte((byte)1);\n\t    Integer i = +b + (-b);\n\t\tSystem.out.println(i);\n    }\n}\n"}, "0");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t    Byte b = new Byte((byte)1);\n\t    Integer i = 0;\n\t    int n = b + i;\n\t\tSystem.out.println(n);\n    }\n}\n"}, "1");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tCharacter cValue = new Character('c');\n\t\tif ('c' == cValue) System.out.println('y');\n\t}\n}\n"}, "y");
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) { test(2); }\n\tstatic void test(Object o) { System.out.println('y'); }\n}\n"}, "y");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) { test(true); }\n\tstatic void test(Object ... o) { System.out.println('y'); }\n}\n"}, "y");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t    Byte b = new Byte((byte)1);\n\t    Integer i = 0;\n\t    i += b;\n\t\tSystem.out.println(i);\n    }\n}\n"}, "1");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tif (0 == new X()) {\n\t\t\tSystem.out.println();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tif (0 == new X()) {\n\t    ^^^^^^^^^^^^\nIncompatible operand types int and X\n----------\n");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t    Byte b = new Byte((byte)1);\n\t    int i = +b;\n\t\tSystem.out.println(i);\n    }\n}\n"}, "1");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Iterator;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tList<Integer> list = new ArrayList<Integer>();\n\t\tfor (int i = 0; i < 5; i++) {\n\t\t\tlist.add(i);\n\t    }\n\t    int sum = 0;\n\t    for (Iterator<Integer> iterator = list.iterator(); iterator.hasNext(); ) {\n\t    \tsum += iterator.next();\n\t    }\n        System.out.print(sum);\n    }\n}"}, "10");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tBoolean b = Boolean.TRUE;\n\t\t\n\t\tif (b && !b) {\n\t\t\tSystem.out.print(\"THEN\");\n\t\t} else {\n\t\t\tSystem.out.print(\"ELSE\");\n\t\t}\n    }\n}"}, "ELSE");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Boolean foo() { return Boolean.FALSE; }\n\tpublic static void main(String[] args) {\n\t\tBoolean b = foo();\n\t\t\n\t\tif (!b) {\n\t\t\tSystem.out.print(\"THEN\");\n\t\t} else {\n\t\t\tSystem.out.print(\"ELSE\");\n\t\t}\n    }\n}"}, "THEN");
    }

    public void test032() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] args) {\n      if (new Integer(1) == new Integer(0)) {\n         System.out.println();\n      }\n      System.out.print(\"SUCCESS\");\n   }\n}"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 4, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  new java.lang.Integer [16]\n     3  dup\n     4  iconst_1\n     5  invokespecial java.lang.Integer(int) [18]\n     8  new java.lang.Integer [16]\n    11  dup\n    12  iconst_0\n    13  invokespecial java.lang.Integer(int) [18]\n    16  if_acmpne 25\n    19  getstatic java.lang.System.out : java.io.PrintStream [21]\n    22  invokevirtual java.io.PrintStream.println() : void [27]\n    25  getstatic java.lang.System.out : java.io.PrintStream [21]\n    28  ldc <String \"SUCCESS\"> [32]\n    30  invokevirtual java.io.PrintStream.print(java.lang.String) : void [34]\n    33  return\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 3));
        }
        if (index == -1) {
            AutoBoxingTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String[] s) {\n      System.out.print(Boolean.TRUE || Boolean.FALSE);\n   }\n}"}, "true");
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t    Byte b = new Byte((byte)1);\n\t    int i = b++;\n\t\tSystem.out.print(i);\n\t\tSystem.out.print(b);\n    }\n}\n"}, "12");
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t    Byte b = new Byte((byte)1);\n\t    int i = b--;\n\t\tSystem.out.print(i);\n\t\tSystem.out.print(b);\n    }\n}\n"}, "10");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t    Byte b = new Byte((byte)1);\n\t    int i = ++b;\n\t\tSystem.out.print(i);\n\t\tSystem.out.print(b);\n    }\n}\n"}, "22");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t    Byte b = new Byte((byte)1);\n\t    int i = --b;\n\t\tSystem.out.print(i);\n\t\tSystem.out.print(b);\n    }\n}\n"}, "00");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static boolean foo() { return false; }\n   public static void main(String[] s) {\n\t\tboolean b = foo();\n      System.out.print(b || Boolean.FALSE);\n   }\n}"}, "false");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint i = 0;\n\t\tif (i != null) {\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tif (i != null) {\n\t    ^^^^^^^^^\nThe operator != is undefined for the argument type(s) int, null\n----------\n");
    }

    public void test040() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tpublic static void main(String[] args) {\n\t\tInteger i = new Integer(1);\n\t\tif (i == null)\n\t\t\ti++;\n\t\tSystem.out.print(i);\n\t}\n}"}, "1");
    }

    public void test041() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger i = 0;\n\t\tif (i != null) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Boolean bar() { return Boolean.TRUE; } \n\tpublic static void main(String[] args) {\n\t\tInteger i = bar() ? new Integer(1) : null;\n\t\tint j = i;\n\t\tSystem.out.print(j);\n\t}\n}"}, "1");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger i = 0;\n\t\ti += \"aaa\";\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tInteger i = 0;\n\t            ^\nThe expression of type int is boxed into Integer\n----------\n2. ERROR in X.java (at line 4)\n\ti += \"aaa\";\n\t^^^^^^^^^^\nThe operator += is undefined for the argument type(s) Integer, String\n----------\n");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger i = 0;\n\t\ti += null;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tInteger i = 0;\n\t            ^\nThe expression of type int is boxed into Integer\n----------\n2. ERROR in X.java (at line 4)\n\ti += null;\n\t^^^^^^^^^\nThe operator += is undefined for the argument type(s) Integer, null\n----------\n");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger i = 0;\n\t\ti = i + null;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tInteger i = 0;\n\t            ^\nThe expression of type int is boxed into Integer\n----------\n2. ERROR in X.java (at line 4)\n\ti = i + null;\n\t    ^^^^^^^^\nThe operator + is undefined for the argument type(s) Integer, null\n----------\n");
    }

    public void test046() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tByte b = new Byte((byte)1);\n\t\tb++;\n\t\tSystem.out.println((Byte)b);\n\t}\n}\n"}, "2");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tByte b = new Byte((byte)1);\n\t\tb++;\n\t\tif (b instanceof Byte) {\n\t\t\tSystem.out.println(\"SUCCESS\" + b);\n\t\t}\n\t}\n}\n"}, "SUCCESS2");
    }

    public void test048() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Byte b = new Byte((byte)1);\n\tpublic static void main(String[] s) {\n\t\tb++;\n\t\tif (b instanceof Byte) {\n\t\t\tSystem.out.print(\"SUCCESS\" + b);\n\t\t}\n\t}\n}\n"}, "SUCCESS2");
    }

    public void test049() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static class Y {\n\t\tpublic static Byte b = new Byte((byte)1);\n\t}\n\tpublic static void main(String[] s) {\n\t\tX.Y.b++;\n\t\tif (X.Y.b instanceof Byte) {\n\t\t\tSystem.out.print(\"SUCCESS\" + X.Y.b);\n\t\t}\n\t}\n}\n"}, "SUCCESS2");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static Byte b = new Byte((byte)1);\n\tpublic static void main(String[] s) {\n\t\t++b;\n\t\tif (b instanceof Byte) {\n\t\t\tSystem.out.print(\"SUCCESS\" + b);\n\t\t}\n\t}\n}\n"}, "SUCCESS2");
    }

    public void test051() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static class Y {\n\t\tpublic static Byte b = new Byte((byte)1);\n\t}\n\tpublic static void main(String[] s) {\n\t\t++X.Y.b;\n\t\tif (X.Y.b instanceof Byte) {\n\t\t\tSystem.out.print(\"SUCCESS\" + X.Y.b);\n\t\t}\n\t}\n}\n"}, "SUCCESS2");
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tByte b = 0;\n\t\t++b;\n\t\tfoo(0);\n\t}\n\tstatic void foo(Byte b) {\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tByte b = 0;\n\t         ^\nThe expression of type int is boxed into Byte\n----------\n2. WARNING in X.java (at line 4)\n\t++b;\n\t^^^\nThe expression of type byte is boxed into Byte\n----------\n3. WARNING in X.java (at line 4)\n\t++b;\n\t  ^\nThe expression of type Byte is unboxed into int\n----------\n4. ERROR in X.java (at line 5)\n\tfoo(0);\n\t^^^\nThe method foo(Byte) in the type X is not applicable for the arguments (int)\n----------\n");
    }

    public void test053() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tByte b = 1;\n\t\t++b;\n\t\tif (b instanceof Byte) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test054() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic Byte b = 1;\n\tpublic static void main(String[] s) {\n\t\t++b;\n\t\tif (b instanceof Byte) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tbyte[] bytes = {0, 1, 2};\n\t\tfor(Integer i : bytes) {\n\t\t\tSystem.out.print(i);\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tfor(Integer i : bytes) {\n\t                ^^^^^\nType mismatch: cannot convert from element type byte to Integer\n----------\n2. WARNING in X.java (at line 4)\n\tfor(Integer i : bytes) {\n\t                ^^^^^\nThe expression of type byte is boxed into Integer\n----------\n");
    }

    public void test056() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tint[] ints = {0, 1, 2};\n\t\tfor(Integer i : ints) {\n\t\t\tSystem.out.print(i);\n\t\t}\n\t}\n}\n"}, "012");
    }

    public void test057() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tbyte[] bytes = {0, 1, 2};\n\t\tfor(Byte b : bytes) {\n\t\t\tSystem.out.print(b);\n\t\t}\n\t}\n}\n"}, "012");
    }

    public void test058() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Iterator;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tList<Integer> list = new ArrayList<Integer>();\n\t\tfor (int i = 0; i < 5; i++) {\n\t\t\tlist.add(i);\n\t    }\n\t    int sum = 0;\n\t    for (Integer i : list) {\n\t    \tsum += i;\n\t    }\t    \n        System.out.print(sum);\n    }\n}\n"}, "10");
    }

    public void test059() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Iterator;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tList<Integer> list = new ArrayList<Integer>();\n\t\tfor (int i = 0; i < 5; i++) {\n\t\t\tlist.add(i);\n\t    }\n\t    int sum = 0;\n\t    for (Iterator<Integer> iterator = list.iterator(); iterator.hasNext(); ) {\n\t    \tif (1 == iterator.next()) {\n\t    \t\tSystem.out.println(\"SUCCESS\");\n\t    \t\tbreak;\n\t    \t}\n\t    }\n    }\n}\n"}, "SUCCESS");
    }

    public void test060() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Iterator;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tList<Boolean> list = new ArrayList<Boolean>();\n\t\tfor (int i = 0; i < 5; i++) {\n\t\t\tlist.add(i % 2 == 0);\n\t    }\n\t    for (Iterator<Boolean> iterator = list.iterator(); iterator.hasNext(); ) {\n\t    \tif (iterator.next()) {\n\t    \t\tSystem.out.println(\"SUCCESS\");\n\t    \t\tbreak;\n\t    \t}\n\t    }\n    }\n}\n"}, "SUCCESS");
    }

    public void test061() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Iterator;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tList<Boolean> list = new ArrayList<Boolean>();\n\t\tboolean b = true;\n\t\tfor (int i = 0; i < 5; i++) {\n\t\t\tlist.add((i % 2 == 0) && b);\n\t    }\n\t    for (Iterator<Boolean> iterator = list.iterator(); iterator.hasNext(); ) {\n\t    \tif (iterator.next()) {\n\t    \t\tSystem.out.println(\"SUCCESS\");\n\t    \t\tbreak;\n\t    \t}\n\t    }\n    }\n}\n"}, "SUCCESS");
    }

    public void test062() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Iterator;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tList<Integer> list = new ArrayList<Integer>();\n\t\tboolean b = true;\n\t\tfor (int i = 0; i < 5; i++) {\n\t\t\tlist.add(i);\n\t    }\n\t\tint sum = 0;\n\t    for (Iterator<Integer> iterator = list.iterator(); iterator.hasNext(); ) {\n\t    \tsum = sum + iterator.next();\n\t    }\n\t    System.out.println(sum);\n    }\n}\n"}, "10");
    }

    public void test063() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Iterator;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tList<Integer> list = new ArrayList<Integer>();\n\t\tboolean b = true;\n\t\tfor (int i = 0; i < 5; i++) {\n\t\t\tlist.add(i);\n\t    }\n\t\tint val = 0;\n\t    for (Iterator<Integer> iterator = list.iterator(); iterator.hasNext(); ) {\n\t    \tval = ~ iterator.next();\n\t    }\n\t    System.out.println(val);\n    }\n}\n"}, "-5");
    }

    public void test064() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Iterator;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tList<Integer> list = new ArrayList<Integer>();\n\t\tboolean b = true;\n\t\tfor (int i = 0; i < 5; i++) {\n\t\t\tlist.add(i);\n\t    }\n\t\tint val = 0;\n\t    for (Iterator<Integer> iterator = list.iterator(); iterator.hasNext(); ) {\n\t    \tval += (int) iterator.next();\n\t    }\n\t    System.out.println(val);\n    }\n}\n"}, "10");
    }

    public void test065() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<Integer> list = new ArrayList<Integer>();\n\t\tfor (int i = 0; i < 5; i++) {\n\t\t\tlist.add(i);\n\t    }\n\t    int sum = 0;\n\t    for (int i : list) {\n\t    \tsum += i;\n\t    }\n        System.out.print(sum);\n    }\n}"}, "10");
    }

    public void test066() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tInteger[] tab = new Integer[] {0, 1, 2, 3, 4};\n\t    int sum = 0;\n\t    for (int i : tab) {\n\t    \tsum += i;\n\t    }\n        System.out.print(sum);\n    }\n}"}, "10");
    }

    public void test067() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tint[] tab = new int[] {0, 1, 2, 3, 4};\n\t    int sum = 0;\n\t    for (Integer i : tab) {\n\t    \tsum += i;\n\t    }\n        System.out.print(sum);\n    }\n}"}, "10");
    }

    public void test068() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<Integer> list = new ArrayList<Integer>();\n\t\tfor (int i = 0; i < 5; i++) {\n\t\t\tlist.add(i);\n\t    }\n\t    int sum = 0;\n\t    for (Integer i : list) {\n\t    \tsum += i;\n\t    }\n        System.out.print(sum);\n    }\n}"}, "10");
    }

    public void test069() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tBoolean bool = true;\n\t\tassert bool : \"failed\";\n\t    System.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test070() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<Boolean> lb = new ArrayList<Boolean>();\n\t\tlb.add(true);\n\t\tIterator<Boolean> iterator = lb.iterator();\n\t\tassert iterator.next() : \"failed\";\n\t    System.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test071() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<Boolean> lb = new ArrayList<Boolean>();\n\t\tlb.add(true);\n\t\tIterator<Boolean> iterator = lb.iterator();\n\t\tassert args != null : iterator.next();\n\t    System.out.println(\"SUCCESS\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test072() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n        doFoo(getVoid());\n    }\n\n    private static void doFoo(Object o) { }\n\n    private static void getVoid() { }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tdoFoo(getVoid());\n\t^^^^^\nThe method doFoo(Object) in the type X is not applicable for the arguments (void)\n----------\n");
    }

    public void test073() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"deprecation\")\n    public static void main(String[] args) {\n        a(new Integer(1), 2);\n    }\n    public static void a(int a, int b) { System.out.println(\"SUCCESS\"); }\n    public static void a(Object a, Object b) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\ta(new Integer(1), 2);\n\t^\nThe method a(int, int) is ambiguous for the type X\n----------\n");
    }

    public void test074() {
        this.runConformTest(new String[]{"X.java", "public class X {\n Object e() {\n  return \"\".compareTo(\"\") > 0;\n }\n public static void main(String[] args) {\n  System.out.print(new X().e());\n }\n}"}, "false");
    }

    public void test075() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n Object e() {\n  return \"\".compareTo(\"\") > 0;\n }\n public static void main(String[] args) {\n  System.out.print(new X().e());\n }\n Zork z;\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\treturn \"\".compareTo(\"\") > 0;\n\t       ^^^^^^^^^^^^^^^^^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n2. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test076() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n Object e() {\n int i = 12; \n  boolean b = false;\n  switch(i) {\n    case 0: return i > 0;\n    case 1: return i >= 0;\n    case 2: return i < 0;\n    case 3: return i <= 0;\n    case 4: return i == 0;\n    case 5: return i != 0;\n    case 6: return i & 0;\n    case 7: return i ^ 0;\n    case 8: return i | 0;\n    case 9: return b && b;\n    default: return b || b;\n  }\n }\n public static void main(String[] args) {\n  System.out.print(new X().e());\n }\n Zork z;\n}"}, "----------\n1. WARNING in X.java (at line 6)\n\tcase 0: return i > 0;\n\t               ^^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n2. WARNING in X.java (at line 7)\n\tcase 1: return i >= 0;\n\t               ^^^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n3. WARNING in X.java (at line 8)\n\tcase 2: return i < 0;\n\t               ^^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n4. WARNING in X.java (at line 9)\n\tcase 3: return i <= 0;\n\t               ^^^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n5. WARNING in X.java (at line 10)\n\tcase 4: return i == 0;\n\t               ^^^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n6. WARNING in X.java (at line 11)\n\tcase 5: return i != 0;\n\t               ^^^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n7. WARNING in X.java (at line 12)\n\tcase 6: return i & 0;\n\t               ^^^^^\nThe expression of type int is boxed into Integer\n----------\n8. WARNING in X.java (at line 13)\n\tcase 7: return i ^ 0;\n\t               ^^^^^\nThe expression of type int is boxed into Integer\n----------\n9. WARNING in X.java (at line 14)\n\tcase 8: return i | 0;\n\t               ^^^^^\nThe expression of type int is boxed into Integer\n----------\n10. WARNING in X.java (at line 15)\n\tcase 9: return b && b;\n\t               ^^^^^^\nComparing identical expressions\n----------\n11. WARNING in X.java (at line 15)\n\tcase 9: return b && b;\n\t               ^^^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n12. WARNING in X.java (at line 16)\n\tdefault: return b || b;\n\t                ^^^^^^\nComparing identical expressions\n----------\n13. WARNING in X.java (at line 16)\n\tdefault: return b || b;\n\t                ^^^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n14. ERROR in X.java (at line 22)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test077() {
        this.runConformTest(new String[]{"X.java", "public class X {\n Object e() {\n int i = 12; \n  boolean b = false;\n  switch(i) {\n    case 0: return i > 0;\n    case 1: return i >= 0;\n    case 2: return i < 0;\n    case 3: return i <= 0;\n    case 4: return i == 0;\n    case 5: return i != 0;\n    case 6: return i & 0;\n    case 7: return i ^ 0;\n    case 8: return i | 0;\n    case 9: return b && b;\n    default: return b || b;\n  }\n }\n public static void main(String[] args) {\n  System.out.print(new X().e());\n }\n}"}, "false");
    }

    public void test078() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tpublic <A extends T> X(A... t) {}\n\t<T> void foo(T... t) {}\n\t<T> void zip(T t) {}\n\tvoid test() {\n\t\tnew X<Integer>(10, 20);\n\t\tfoo(10);\n\t\tfoo(10, 20);\n\t\tzip(10);\n\t}\n}\n"}, "");
    }

    public void _test079() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\npublic class X {\n\tstatic HashMap<Character, Character> substitutionList(String s1, String s2) {\n\t\tHashMap<Character, Character> subst = new HashMap<Character, Character>();\n\t\tfor (int i = 0; i < s1.length(); i++) {\n\t\t\tchar key = s1.charAt(i);\n\t\t\tchar value = s2.charAt(i);\n\t\t\tif (subst.containsKey(key)) {\n\t\t\t\tif (value != subst.get(key)) {\n\t\t\t\t\treturn null;\n\t\t\t\t}\n\t\t\t} else if (subst.containsValue(value)) {\n\t\t\t\treturn null;\n\t\t\t} else {\n\t\t\t\tsubst.put(key, value);\n\t\t\t}\n\t\t}\n\t\treturn subst;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"Bogon\");\n\t}\n}\n"}, "SUCCESS");
    }

    public void test080() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tHashMap<Character, Character> subst = new HashMap<Character, Character>();\n\t\tsubst.put('a', 'a');\n\t\tif ('a' == subst.get('a')) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test081() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\n\npublic class X {\n\n\tpublic static void main(String[] args) {\n\t\tHashMap<Byte, Byte> subst = new HashMap<Byte, Byte>();\n\t\tsubst.put((byte)1, (byte)1);\n\t\tif (1 + subst.get((byte)1) > 0.f) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\t\t\n\t}\n}\n"}, "SUCCESS");
    }

    public void test082() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(void.class == Void.TYPE);\n\t}\n}"}, "true");
    }

    public void test083() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint counter = 0;\n\n\tpublic boolean wasNull() {\n\t\treturn ++counter % 2 == 0;\n\t}\n\n\tprivate Byte getByte() {\n\t\treturn (byte) 0;\n\t}\n\n\tprivate Short getShort() {\n\t\treturn (short) 0;\n\t}\n\n\tprivate Long getLong() {\n\t\treturn 0L;\n\t}\n\n\tprivate Integer getInt() {\n\t\treturn 0; // autoboxed okay\n\t}\n\n\t// This should be the same as the second one.\n\tprivate Byte getBytey() {\n\t\tbyte value = getByte();\n\t\treturn wasNull() ? null : value;\n\t}\n\n\tprivate Byte getByteyNoBoxing() {\n\t\tbyte value = getByte();\n\t\treturn wasNull() ? null : (Byte) value;\n\t}\n\n\t// This should be the same as the second one.\n\tprivate Short getShorty() {\n\t\tshort value = getShort();\n\t\treturn wasNull() ? null : value;\n\t}\n\n\tprivate Short getShortyNoBoxing() {\n\t\tshort value = getShort();\n\t\treturn wasNull() ? null : (Short) value;\n\t}\n\n\t// This should be the same as the second one.\n\tprivate Long getLongy() {\n\t\tlong value = getLong();\n\t\treturn wasNull() ? null : value;\n\t}\n\n\tprivate Long getLongyNoBoxing() {\n\t\tlong value = getLong();\n\t\treturn wasNull() ? null : (Long) value;\n\t}\n\n\t// This should be the same as the second one.\n\tprivate Integer getIntegery() {\n\t\tint value = getInt();\n\t\treturn wasNull() ? null : value;\n\t}\n\n\tprivate Integer getIntegeryNoBoxing() {\n\t\tint value = getInt();\n\t\treturn wasNull() ? null : (Integer) value;\n\t}\n}\n"}, "");
    }

    public void test084() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tShort foo() {\n\t\tshort value = 0;\n\t\treturn this == null ? null : value;\n\t}\n\tboolean bar() {\n\t\tshort value = 0;\n\t\treturn null == value;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\treturn this == null ? null : value;\n\t                             ^^^^^\nThe expression of type short is boxed into Short\n----------\n2. ERROR in X.java (at line 8)\n\treturn null == value;\n\t       ^^^^^^^^^^^^^\nThe operator == is undefined for the argument type(s) null, short\n----------\n");
    }

    public void test085() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tprivate static void checkByteConversions(Byte _byte) {\n\t\tshort s = (short) _byte;\n\t\tshort s2 = _byte;\n\t\tint i = (int) _byte;\n\t\tlong l = (long) _byte;\n\t\tfloat f = (float) _byte;\n\t\tdouble d = (double) _byte;\n\t\tif ( _byte.byteValue() != s ) {\n            System.err.println(\"Must be equal 0\");\n        }\n\t\tif ( _byte.byteValue() != i ) {\n            System.err.println(\"Must be equal 1\");\n        }\n\t\tif ( _byte.byteValue() != l ) {\n            System.err.println(\"Must be equal 2\");\n        }\n\t\tif ( _byte.byteValue() != f ) {\n            System.err.println(\"Must be equal 3\");\n        }\n\t\tif ( _byte.byteValue() != d ) {\n            System.err.println(\"Must be equal 4\");\n        }\n\t} \n\n\tprivate static void checkCharacterConversions(Character _character) {\n\t\tint i = (int) _character;\n\t\tlong l = (long) _character;\n\t\tfloat f = (float) _character;\n\t\tdouble d = (double) _character;\n\t\tif ( _character.charValue() != i ) {\n            System.err.println(\"Must be equal 9\");\n        }\n\t\tif ( _character.charValue() != l ) {\n            System.err.println(\"Must be equal 10\");\n        }\n\t\tif ( _character.charValue() != f ) {\n            System.err.println(\"Must be equal 11\");\n        }\n\t\tif ( _character.charValue() != d ) {\n            System.err.println(\"Must be equal 12\");\n        }\n\t}\n\n\tprivate static void checkFloatConversions(Float _float) {\n\t\tdouble d = (double) _float;\n\t\tif ( _float.floatValue() != d ) {\n            System.err.println(\"Must be equal 18\");\n        }\n\t}\n\n\tprivate static void checkIntegerConversions(Integer _integer) {\n\t\tlong l = (long) _integer;\n\t\tfloat f = (float) _integer;\n\t\tdouble d = (double) _integer;\n\t\tif ( _integer.intValue() != l ) {\n            System.err.println(\"Must be equal 13\");\n        }\n\t\tif ( _integer.intValue() != f ) {\n            System.err.println(\"Must be equal 14\");\n        }\n\t\tif ( _integer.intValue() != d ) {\n            System.err.println(\"Must be equal 15\");\n        }\n\t}\n\n\tprivate static void checkIntegerConversions(Short _short) {\n\t\tint i = (int) _short;\n\t\tlong l = (long) _short;\n\t\tfloat f = (float) _short;\n\t\tdouble d = (double) _short;\n\t\tif ( _short.shortValue() != i ) {\n            System.err.println(\"Must be equal 5\");\n        }\n\t\tif ( _short.shortValue() != l ) {\n            System.err.println(\"Must be equal 6\");\n        }\n\t\tif ( _short.shortValue() != f ) {\n            System.err.println(\"Must be equal 7\");\n        }\n\t\tif ( _short.shortValue() != d ) {\n            System.err.println(\"Must be equal 8\");\n        }\n\t}\n\n\tprivate static void checkLongConversions(Long _long) {\n\t\tfloat f = (float) _long;\n\t\tdouble d = (double) _long;\n\t\tif ( _long.longValue() != f ) {\n            System.err.println(\"Must be equal 16\");\n        }\n\t\tif ( _long.longValue() != d ) {\n            System.err.println(\"Must be equal 17\");\n        }\n\t}\n\n    public static void main(String args[]) {\n        Byte _byte = new Byte((byte)2);\n        Character _character = new Character('@');\n        Short _short = new Short((short)255);\n        Integer _integer = new Integer(12345678);\n        Long _long = new Long(1234567890);\n        Float _float = new Float(-0.0);\n\n        checkByteConversions(_byte);\n        checkIntegerConversions(_short);\n        checkCharacterConversions(_character);\n        checkIntegerConversions(_integer);\n        checkLongConversions(_long);\n        checkFloatConversions(_float);\n\n        System.out.println(\"OK\");\n      }\n}\n"}, "OK");
    }

    public void test086() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  private static void checkConversions(byte _byte) {\n    Short s = (short) _byte; // cast is necessary\n    Short s2 = _byte; // ko\n  } \n  public static void main(String args[]) {\n    byte _byte = 2;\n    checkConversions(_byte);\n    System.out.println(\"OK\");\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tShort s = (short) _byte; // cast is necessary\n\t          ^^^^^^^^^^^^^\nThe expression of type short is boxed into Short\n----------\n2. ERROR in X.java (at line 4)\n\tShort s2 = _byte; // ko\n\t           ^^^^^\nType mismatch: cannot convert from byte to Short\n----------\n");
    }

    public void test087() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    <T> T foo(T t) { return t; }\n    \n    public static void main(String[] args) {\n        int i = new X().foo(12);\n        System.out.println(i);\n    }\n    Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tint i = new X().foo(12);\n\t        ^^^^^^^^^^^^^^^\nThe expression of type Integer is unboxed into int\n----------\n2. WARNING in X.java (at line 5)\n\tint i = new X().foo(12);\n\t                    ^^\nThe expression of type int is boxed into Integer\n----------\n3. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test088() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.autoboxing", "warning");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint f;\n\tvoid foo(int i) {\n\t\ti = i++;\n\t\ti = ++i;\n\t\tf = f++;\n\t\tf = ++f;\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\ti = ++i;\n\t^^^^^^^\nThe assignment to variable i has no effect\n----------\n2. WARNING in X.java (at line 7)\n\tf = ++f;\n\t^^^^^^^\nThe assignment to variable f has no effect\n----------\n3. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, customOptions);
    }

    public void test089() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public Object foo() {\n  \tbyte b = 0;\n\tNumber n = (Number) b;\n\n    java.io.Serializable o = null;\n    if (o == 0) return o;\n    return this;\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tNumber n = (Number) b;\n\t           ^^^^^^^^^^\nUnnecessary cast from byte to Number\n----------\n2. WARNING in X.java (at line 4)\n\tNumber n = (Number) b;\n\t                    ^\nThe expression of type byte is boxed into Byte\n----------\n3. ERROR in X.java (at line 7)\n\tif (o == 0) return o;\n\t    ^^^^^^\nIncompatible operand types Serializable and int\n----------\n");
    }

    public void test090() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public Object foo() {\n  \n  \tBoolean b = null;\n     if (b == true) return b;\n     Object o = null;\n    if (o == true) return o;\n    return this;\n  }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tif (b == true) return b;\n\t    ^\nThe expression of type Boolean is unboxed into boolean\n----------\n2. ERROR in X.java (at line 7)\n\tif (o == true) return o;\n\t    ^^^^^^^^^\nIncompatible operand types Object and boolean\n----------\n");
    }

    public void test091() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n    public static void main(String[] args) {\n        Comparable<?> c1 = foo(\"\", new Integer(5));\n        Object o = foo(\"\", 5);\n    }\n    public static <T> T foo(T t1, T t2) { \n    \tSystem.out.print(\"foo(\"+t1.getClass().getSimpleName()+\",\"+t2.getClass().getSimpleName()+\")\");\n    \treturn null; \n    }\n}\n"}, "foo(String,Integer)foo(String,Integer)");
    }

    public void test092() {
        this.runConformTest(new String[]{"X.java", "public class X\n{\n\tpublic X()\n\t{\n\t\tsuper();\n\t}\n\n\tpublic Object convert(Object value)\n\t{\n\t\tDouble d = (Double)value;\n\t\td = (d/100);\n\t\treturn d;\n\t}\n\n\tpublic static void main(String[] args)\n\t{\n\t\tX test = new X();\n\t\tObject value = test.convert(new Double(50));\n\t\tSystem.out.println(value);\n\t}\n}\n"}, "0.5");
    }

    public void test093() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger someInteger = 12;\n\t\tSystem.out.println((args == null ? someInteger : 'A') == 'A');\n\t}\n}\n"}, "true");
    }

    public void test094() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger someInteger = 12;\n\t\tSystem.out.println((args == null ? someInteger : 'A') == 'A');\n\t\tZork z;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tInteger someInteger = 12;\n\t                      ^^\nThe expression of type int is boxed into Integer\n----------\n2. WARNING in X.java (at line 4)\n\tSystem.out.println((args == null ? someInteger : 'A') == 'A');\n\t                                   ^^^^^^^^^^^\nThe expression of type Integer is unboxed into int\n----------\n3. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test095() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tboolean b = true;\n\t\tCharacter _Character = new Character(' ');\n\t\tchar c = ' ';\n\t\tInteger _Integer = new Integer(2);\n\t\tif ((b ? _Character : _Integer) == c) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t} else {\n\t\t\tSystem.out.println(\"FAILURE\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test096() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"deprecation\")\n\tpublic static void main(String[] args) {\n\t\tboolean b = true;\n\t\tCharacter _Character = new Character(' ');\n\t\tchar c = ' ';\n\t\tInteger _Integer = new Integer(2);\n\t\tif ((b ? _Character : _Integer) == c) {\n\t\t\tSystem.out.println(zork);\n\t\t} else {\n\t\t\tSystem.out.println(\"FAILURE\");\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tif ((b ? _Character : _Integer) == c) {\n\t         ^^^^^^^^^^\nThe expression of type Character is unboxed into int\n----------\n2. WARNING in X.java (at line 8)\n\tif ((b ? _Character : _Integer) == c) {\n\t                      ^^^^^^^^\nThe expression of type Integer is unboxed into int\n----------\n3. ERROR in X.java (at line 9)\n\tSystem.out.println(zork);\n\t                   ^^^^\nzork cannot be resolved to a variable\n----------\n");
    }

    public void test097() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String args[]) {\n        Integer i = 1;\n        Integer j = 2;\n        Short s = 3;\n        foo(args != null ? i : j);\n        foo(args != null ? i : s);\n    }\n    static void foo(int i) {\n        System.out.print(\"[int:\"+i+\"]\");\n    }\n    static void foo(Integer i) {\n        System.out.print(\"[Integer:\"+i+\"]\");\n    }\n}\n"}, "[Integer:1][int:1]");
    }

    public void test098() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String args[]) {\n        Integer i = 1;\n        Integer j = 2;\n        Short s = 3;\n        foo(args != null ? i : j);\n        foo(args != null ? i : s);\n\t\t Zork z;\n    }\n    static void foo(int i) {\n        System.out.print(\"[int:\"+i+\"]\");\n    }\n    static void foo(Integer i) {\n        System.out.print(\"[Integer:\"+i+\"]\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tInteger i = 1;\n\t            ^\nThe expression of type int is boxed into Integer\n----------\n2. WARNING in X.java (at line 4)\n\tInteger j = 2;\n\t            ^\nThe expression of type int is boxed into Integer\n----------\n3. WARNING in X.java (at line 5)\n\tShort s = 3;\n\t          ^\nThe expression of type int is boxed into Short\n----------\n4. WARNING in X.java (at line 7)\n\tfoo(args != null ? i : s);\n\t                   ^\nThe expression of type Integer is unboxed into int\n----------\n5. WARNING in X.java (at line 7)\n\tfoo(args != null ? i : s);\n\t                       ^\nThe expression of type Short is unboxed into int\n----------\n6. ERROR in X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test099() {
        this.runConformTest(new String[]{"X.java", "public class X extends A {\n    public void m(Object o) { System.out.println(\"SUCCESS\"); }\n    public static void main(String[] args) { ((A) new X()).m(1); }\n}\ninterface I { void m(Object o); }\nabstract class A implements I {\n\tpublic final void m(int i) {\n\t\tSystem.out.print(\"SUCCESS + \");\n\t\tm(new Integer(i));\n\t}\n\tpublic final void m(double d) {\n\t\tSystem.out.print(\"FAILED\");\n\t}\n}\n"}, "SUCCESS + SUCCESS");
    }

    public void test100() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger[] integers = {};\n\t\tint[] ints = (int[]) integers;\n\t\tfloat[] floats = {};\n\t\tFloat[] fs = (Float[]) floats;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tint[] ints = (int[]) integers;\n\t             ^^^^^^^^^^^^^^^^\nCannot cast from Integer[] to int[]\n----------\n2. ERROR in X.java (at line 6)\n\tFloat[] fs = (Float[]) floats;\n\t             ^^^^^^^^^^^^^^^^\nCannot cast from float[] to Float[]\n----------\n");
    }

    public void test101() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Object... i) { System.out.print(1); }\n\tvoid foo(int... i) { System.out.print(2); }\n\t@SuppressWarnings(\"deprecation\")\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(1);\n\t\tnew X().foo(new Integer(1));\n\t\tnew X().foo(1, new Integer(1));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tnew X().foo(1);\n\t        ^^^\nThe method foo(Object[]) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 7)\n\tnew X().foo(new Integer(1));\n\t        ^^^\nThe method foo(Object[]) is ambiguous for the type X\n----------\n3. ERROR in X.java (at line 8)\n\tnew X().foo(1, new Integer(1));\n\t        ^^^\nThe method foo(Object[]) is ambiguous for the type X\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Number... i) { System.out.print(1); }\n\tvoid foo(int... i) { System.out.print(2); }\n\t@SuppressWarnings(\"deprecation\")\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(1);\n\t\tnew X().foo(new Integer(1));\n\t\tnew X().foo(1, new Integer(1));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tnew X().foo(1);\n\t        ^^^\nThe method foo(Number[]) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 7)\n\tnew X().foo(new Integer(1));\n\t        ^^^\nThe method foo(Number[]) is ambiguous for the type X\n----------\n3. ERROR in X.java (at line 8)\n\tnew X().foo(1, new Integer(1));\n\t        ^^^\nThe method foo(Number[]) is ambiguous for the type X\n----------\n");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(int i, Object... o) { System.out.print(1); }\n\tvoid foo(Integer o, int... i) { System.out.print(2); }\n\t@SuppressWarnings(\"deprecation\")\n\tpublic static void main(String[] args) {\n\t\tnew X().foo(1);\n\t\tnew X().foo(new Integer(1));\n\t\tnew X().foo(1, new Integer(1));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tnew X().foo(1);\n\t        ^^^\nThe method foo(int, Object[]) is ambiguous for the type X\n----------\n2. ERROR in X.java (at line 7)\n\tnew X().foo(new Integer(1));\n\t        ^^^\nThe method foo(int, Object[]) is ambiguous for the type X\n----------\n3. ERROR in X.java (at line 8)\n\tnew X().foo(1, new Integer(1));\n\t        ^^^\nThe method foo(int, Object[]) is ambiguous for the type X\n----------\n");
    }

    public void test102() {
        this.runConformTest(true, new String[]{"X.java", "class Cla<A> {\n\tA val;\n\tpublic Cla(A x) { val = x; }\n\tA getVal() { return val; }\n}\n\npublic class X {\n\t\n\tvoid proc0(Cla<Long> b0) {\n\t\tfinal Long t1 = b0.getVal();\n\t\tSystem.out.print(t1);\n\t\tfinal long t2 = b0.getVal();\n\t\tSystem.out.print(t2);\n\t}\n\n\tvoid proc1(Cla<? extends Long> obj) {\n\t\tfinal Long t3 = obj.getVal();\n\t\tSystem.out.print(t3);\n\t\tfinal long t4 = obj.getVal();\n\t\tSystem.out.print(t4);\n\t}\n\t\n\t<U extends Long> void proc2(Cla<U> obj) {\n\t\tfinal Long t5 = obj.getVal();\n\t\tSystem.out.print(t5);\n\t\tfinal long t6 = obj.getVal();\n\t\tSystem.out.println(t6);\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.proc0(new Cla<Long>(0l));\n\t\tx.proc1(new Cla<Long>(1l));\n\t\tx.proc2(new Cla<Long>(2l));\n\t}\n}\n"}, null, "001122", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test103() {
        this.runNegativeTest(new String[]{"X.java", "class Cla<A> {\n\tZork z;\n\tA val;\n\tpublic Cla(A x) { val = x; }\n\tA getVal() { return val; }\n}\n\npublic class X {\n\t\n\tvoid proc0(Cla<Long> b0) {\n\t\tfinal Long t1 = b0.getVal();\n\t\tSystem.out.print(t1);\n\t\tfinal long t2 = b0.getVal();\n\t\tSystem.out.print(t2);\n\t}\n\n\tvoid proc1(Cla<? extends Long> obj) {\n\t\tfinal Long t3 = obj.getVal();\n\t\tSystem.out.print(t3);\n\t\tfinal long t4 = obj.getVal();\n\t\tSystem.out.print(t4);\n\t}\n\t\n\t<U extends Long> void proc2(Cla<U> obj) {\n\t\tfinal Long t5 = obj.getVal();\n\t\tSystem.out.print(t5);\n\t\tfinal long t6 = obj.getVal();\n\t\tSystem.out.printltn(t6);\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.proc0(new Cla<Long>(0l));\n\t\tx.proc1(new Cla<Long>(1l));\n\t\tx.proc2(new Cla<Long>(2l));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 13)\n\tfinal long t2 = b0.getVal();\n\t                ^^^^^^^^^^^\nThe expression of type Long is unboxed into long\n----------\n3. WARNING in X.java (at line 20)\n\tfinal long t4 = obj.getVal();\n\t                ^^^^^^^^^^^^\nThe expression of type capture#2-of ? extends Long is unboxed into long\n----------\n4. WARNING in X.java (at line 24)\n\t<U extends Long> void proc2(Cla<U> obj) {\n\t           ^^^^\nThe type parameter U should not be bounded by the final type Long. Final types cannot be further extended\n----------\n5. WARNING in X.java (at line 27)\n\tfinal long t6 = obj.getVal();\n\t                ^^^^^^^^^^^^\nThe expression of type U is unboxed into long\n----------\n6. ERROR in X.java (at line 28)\n\tSystem.out.printltn(t6);\n\t           ^^^^^^^^\nThe method printltn(long) is undefined for the type PrintStream\n----------\n7. WARNING in X.java (at line 33)\n\tx.proc0(new Cla<Long>(0l));\n\t                      ^^\nThe expression of type long is boxed into Long\n----------\n8. WARNING in X.java (at line 34)\n\tx.proc1(new Cla<Long>(1l));\n\t                      ^^\nThe expression of type long is boxed into Long\n----------\n9. WARNING in X.java (at line 35)\n\tx.proc2(new Cla<Long>(2l));\n\t                      ^^\nThe expression of type long is boxed into Long\n----------\n");
    }

    public void test104() {
        this.runConformTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.JavacGeneratesIncorrectCode, new String[]{"X.java", "import java.util.HashMap;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tString x = \"\";\n\t\t\tHashMap<String, Integer> y = new HashMap<String, Integer>();\n\t\t\tInteger w = (x.equals(\"X\") ? 0 : y.get(\"yKey\"));\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}\n"}, "SUCCESS");
    }

    public void test105() {
        this.runConformTest(true, new String[]{"X.java", "final class Pair<F, S> {\n\tpublic F first;\n\tpublic S second;\n\n\tpublic static <F, S> Pair<F, S> create(F f, S s) {\n\t\treturn new Pair<F, S>(f, s);\n\t}\n\n\tpublic Pair(final F f, final S s) {\n\t\tfirst = f;\n\t\tsecond = s;\n\t}\n}\n\npublic class X {\n\tpublic void a() {\n\t\tPair<Integer, Integer> p = Pair.create(1, 3);\n\t\t// p.first -= 1; // should be rejected ?\n\t\tp.first--;\n\t\t--p.first;\n\t\tp.first = p.first - 1;\n\t\tSystem.out.println(p.first);\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tnew X().a();\n\t}\n}\n"}, null, "-2", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test106() {
        this.runConformTest(true, new String[]{"X.java", "class XSuper<T> {\n\tT value;\n}\npublic class X extends XSuper<Integer>{\n\tpublic void a() {\n\t\tvalue--;\n\t\t--value;\n\t\tvalue -= 1;\n\t\tvalue = value - 1;\n\t\tSystem.out.println(value);\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tX x = new X();\n\t\tx.value = 5;\n\t\tx.a();\n\t}\n}\n"}, null, "1", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test107() {
        this.runConformTest(true, new String[]{"X.java", "class XSuper<T> {\n\tT value;\n}\npublic class X extends XSuper<Integer>{\n\tpublic void a() {\n\t\tthis.value--;\n\t\t--this.value;\n\t\tthis.value -= 1;\n\t\tthis.value = this.value - 1;\n\t\tSystem.out.println(this.value);\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tX x = new X();\n\t\tx.value = 5;\n\t\tx.a();\n\t}\n}\n"}, null, "1", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test108() {
        this.runConformTest(true, new String[]{"X.java", "class XSuper<T> {\n\tT value;\n}\npublic class X extends XSuper<Integer>{\n\tpublic static void a(X x) {\n\t\tx.value--;\n\t\t--x.value;\n\t\tx.value -= 1;\n\t\tx.value = x.value - 1;\n\t\tSystem.out.println(x.value);\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tX x = new X();\n\t\tx.value = 5;\n\t\ta(x);\n\t}\n}\n"}, null, "1", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test109() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint foo = 0;\n\t\tString bar = \"zero\";\n\t\tSystem.out.println((foo != 0) ? foo : bar);\n\t}\n}\n"}, "zero");
    }

    public void test110() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String args[]) {\n    \tif (new Boolean(true) ? true : new Boolean(false)) {\n    \t\tSystem.out.print(\"SUCCESS\");\n    \t} else {\n    \t\tSystem.out.print(\"FAILED\");\n    \t}\n    }\n}\n"}, "SUCCESS");
    }

    public void test111() {
        this.runConformTest(true, new String[]{"X.java", "class Wrapper< T >\n{\n    public T value;\n}\n\npublic class X\n{\n    public static void main( final String[ ] args )\n    {\n        final Wrapper< Integer > wrap = new Wrapper< Integer >( );\n        wrap.value = 0;\n        wrap.value = wrap.value + 1; // works\n        wrap.value++; // throws VerifyError\n        wrap.value += 1; // throws VerifyError\n    }\n}\n"}, null, "", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test112() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tShort s;\n\t\ts = 5;  // Type mismatch: cannot convert from int to Short\n\t\tShort[] shorts = { 0, 1, 2, 3 };\n\t\tSystem.out.println(s+shorts[2]);\n\t}\n}\n"}, "7");
    }

    public void test113() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tShort s;\n\t\ts = 5;  // Type mismatch: cannot convert from int to Short\n\n\t\tint i = 0;\n\t\ts = i; // not a constant\n\t\t\n\t\tbar(4);\n\t\tShort[] shorts = { 0, 1, 2, 3 };\n\t}\n\tvoid bar(Short s) {}\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\ts = 5;  // Type mismatch: cannot convert from int to Short\n\t    ^\nThe expression of type int is boxed into Short\n----------\n2. ERROR in X.java (at line 7)\n\ts = i; // not a constant\n\t    ^\nType mismatch: cannot convert from int to Short\n----------\n3. ERROR in X.java (at line 9)\n\tbar(4);\n\t^^^\nThe method bar(Short) in the type X is not applicable for the arguments (int)\n----------\n4. WARNING in X.java (at line 10)\n\tShort[] shorts = { 0, 1, 2, 3 };\n\t                   ^\nThe expression of type int is boxed into Short\n----------\n5. WARNING in X.java (at line 10)\n\tShort[] shorts = { 0, 1, 2, 3 };\n\t                      ^\nThe expression of type int is boxed into Short\n----------\n6. WARNING in X.java (at line 10)\n\tShort[] shorts = { 0, 1, 2, 3 };\n\t                         ^\nThe expression of type int is boxed into Short\n----------\n7. WARNING in X.java (at line 10)\n\tShort[] shorts = { 0, 1, 2, 3 };\n\t                            ^\nThe expression of type int is boxed into Short\n----------\n");
    }

    public void test114() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tchar c = 'a';\n\t\tSystem.out.printf(\"%c\",c);\t\t\n\t\tSystem.out.printf(\"%d\\n\",(int)c);\t\t\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\r\n\tSystem.out.printf(\"%c\",c);\t\t\r\n\t                       ^\nThe expression of type char is boxed into Character\n----------\n2. WARNING in X.java (at line 5)\r\n\tSystem.out.printf(\"%d\\n\",(int)c);\t\t\r\n\t                         ^^^^^^\nThe expression of type int is boxed into Integer\n----------\n3. ERROR in X.java (at line 7)\r\n\tZork z;\r\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test115() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tchar c = 'a';\n\t\tSystem.out.printf(\"%c\",c);\t\t\n\t\tSystem.out.printf(\"%d\\n\",(int)c);\t\t\n\t}\n}\n"}, "a97");
    }

    public void test116() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    boolean foo(Long l, Float f) {\n    \treturn f == l;\n    }\n    float bar(Long l, Float f) {\n    \treturn this == null ? f : l;\n    }\n    double baz(Long l, Float f) {\n    \treturn this == null ? f : l;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\r\n\treturn f == l;\r\n\t       ^^^^^^\nIncompatible operand types Float and Long\n----------\n2. WARNING in X.java (at line 6)\r\n\treturn this == null ? f : l;\r\n\t                      ^\nThe expression of type Float is unboxed into float\n----------\n3. WARNING in X.java (at line 6)\r\n\treturn this == null ? f : l;\r\n\t                          ^\nThe expression of type Long is unboxed into float\n----------\n4. WARNING in X.java (at line 9)\r\n\treturn this == null ? f : l;\r\n\t                      ^\nThe expression of type Float is unboxed into float\n----------\n5. WARNING in X.java (at line 9)\r\n\treturn this == null ? f : l;\r\n\t                          ^\nThe expression of type Long is unboxed into float\n----------\n");
    }

    public void test117() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args)\n    {\n        Object obj = true ? true : 17.3;\n\t\t Zork z;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tObject obj = true ? true : 17.3;\n\t                    ^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n2. WARNING in X.java (at line 4)\n\tObject obj = true ? true : 17.3;\n\t                           ^^^^\nThe expression of type double is boxed into Double\n----------\n3. ERROR in X.java (at line 5)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test118() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n    public static <T extends Integer> void foo(final T[] p) {\n        System.out.println(p[0] / 4);\n    }\n    public static void main(final String[] args) {\n        X.foo(new Integer[] { 4, 8, 16 });\n    }\n}"}, null, "1", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug6575821);
    }

    public void test119() {
        this.runConformTest(true, new String[]{"X.java", "public class X<T> {\n    T m;\n    X(T p) {\n        this.m = p;\n    }\n    public static void main(String[] args) {\n        X<Integer> l = new X<Integer>(0);\n        l.m++;\n        System.out.println(l.m);\n    }\n}"}, null, "1", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBugFixed_6_10);
    }

    public void test120() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint a = 100;\n\t\tboolean c = a instanceof Integer;\n\t\tInteger i = (Integer) a;\n\t\tSystem.out.println(c);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tboolean c = a instanceof Integer;\n\t            ^^^^^^^^^^^^^^^^^^^^\nIncompatible conditional operand types int and Integer\n----------\n2. WARNING in X.java (at line 5)\n\tInteger i = (Integer) a;\n\t            ^^^^^^^^^^^\nUnnecessary cast from int to Integer\n----------\n3. WARNING in X.java (at line 5)\n\tInteger i = (Integer) a;\n\t                      ^\nThe expression of type int is boxed into Integer\n----------\n");
    }

    public void test121() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tfinal int i = -128;\n\t\tByte b = i;\n\t}\n\tpublic static void main(String[] args) {\n\t\tByte no = 127; // warning: int boxed to Byte > fine\n\t\tswitch (no) { // warning: Byte is unboxed into int > why in int??? output\n\t\t\tcase -128: // error: cannot convert int to Byte > needs a explicit (byte)cast.\n\t\t\t\tbreak;\n\t\t\tcase (byte) 127: // works\n\t\t\t\tbreak;\n\t\t}\n\t\tno = new Byte(127);\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tByte b = i;\n\t         ^\nThe expression of type int is boxed into Byte\n----------\n2. WARNING in X.java (at line 7)\n\tByte no = 127; // warning: int boxed to Byte > fine\n\t          ^^^\nThe expression of type int is boxed into Byte\n----------\n3. WARNING in X.java (at line 8)\n\tswitch (no) { // warning: Byte is unboxed into int > why in int??? output\n\t        ^^\nThe expression of type Byte is unboxed into int\n----------\n4. ERROR in X.java (at line 14)\n\tno = new Byte(127);\n\t     ^^^^^^^^^^^^^\nThe constructor Byte(int) is undefined\n----------\n");
    }

    public void test122() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tByte foo() {\n\t\tfinal int i = -128;\n\t\treturn i;\n\t}\n\tByte bar() {\n\t\tfinal int i = 1000;\n\t\treturn i;\n\t}\t\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\treturn i;\n\t       ^\nThe expression of type int is boxed into Byte\n----------\n2. ERROR in X.java (at line 8)\n\treturn i;\n\t       ^\nType mismatch: cannot convert from int to Byte\n----------\n");
    }

    public void test123() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tfoo1();\n\t\tfoo2();\n\t\tfoo3();\n\t\tfoo4();\n\t\tSystem.out.println(\"[done]\");\n\t}\n\tstatic void foo1() {\n\t\tObject x = true ? true : \"\";\n\t\tSystem.out.print(\"[1:\"+ x + \",\" + x.getClass().getCanonicalName() + \"]\");\n\t}\n\tstatic void foo2() {\n\t\tObject x = Boolean.TRUE != null ? true : \"\";\n\t\tSystem.out.print(\"[2:\"+ x + \",\" + x.getClass().getCanonicalName() + \"]\");\n\t}\n\tstatic void foo3() {\n\t\tObject x = false ? \"\" : false;\n\t\tSystem.out.print(\"[3:\"+ x + \",\" + x.getClass().getCanonicalName() + \"]\");\n\t}\n\tstatic void foo4() {\n\t\tObject x = Boolean.TRUE == null ? \"\" : false;\n\t\tSystem.out.print(\"[4:\"+ x + \",\" + x.getClass().getCanonicalName() + \"]\");\n\t}\n}"}, "[1:true,java.lang.Boolean][2:true,java.lang.Boolean][3:false,java.lang.Boolean][4:false,java.lang.Boolean][done]");
    }

    public void test124() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tstatic void foo5() {\n\t\tboolean x = false ? \"\" : false;\n\t\tSystem.out.print(\"[4:\"+ x + \",\" + x.getClass().getCanonicalName() + \"]\");\n\t}\t\n}"}, this.complianceLevel >= 0x340000L ? "----------\n1. ERROR in X.java (at line 3)\n\tboolean x = false ? \"\" : false;\n\t                    ^^\nType mismatch: cannot convert from String to boolean\n----------\n2. ERROR in X.java (at line 4)\n\tSystem.out.print(\"[4:\"+ x + \",\" + x.getClass().getCanonicalName() + \"]\");\n\t                                  ^^^^^^^^^^^^\nCannot invoke getClass() on the primitive type boolean\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tboolean x = false ? \"\" : false;\n\t            ^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object&Serializable&Comparable<?> to boolean\n----------\n2. WARNING in X.java (at line 3)\n\tboolean x = false ? \"\" : false;\n\t                         ^^^^^\nThe expression of type boolean is boxed into Boolean\n----------\n3. ERROR in X.java (at line 4)\n\tSystem.out.print(\"[4:\"+ x + \",\" + x.getClass().getCanonicalName() + \"]\");\n\t                                  ^^^^^^^^^^^^\nCannot invoke getClass() on the primitive type boolean\n----------\n");
    }

    public void test125() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tfoo1();\n\t\tfoo2();\n\t\tfoo3();\n\t\tSystem.out.println(\"[done]\");\n\t}\n\tstatic void foo1() {\n\t\tObject x = true ? 3.0f : false;\n\t\tSystem.out.print(\"[1:\"+ x + \",\" + x.getClass().getCanonicalName() + \"]\");\n\t}\n\tstatic void foo2() {\n\t\tObject x = true ? 2 : false;\n\t\tSystem.out.print(\"[2:\"+ x + \",\" + x.getClass().getCanonicalName() + \"]\");\n\t}\n\tstatic void foo3() {\n\t\tObject x = false ? 2 : false;\n\t\tSystem.out.print(\"[3:\"+ x + \",\" + x.getClass().getCanonicalName() + \"]\");\n\t}\n}\n"}, "[1:3.0,java.lang.Float][2:2,java.lang.Integer][3:false,java.lang.Boolean][done]");
    }

    public void test126() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(boolean b) {\n\t\tint i = 12;\n\t\tInteger r1 = b ? null : i;\n\t\tint r2 = b ? null : i;\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tInteger r1 = b ? null : i;\n\t                        ^\nThe expression of type int is boxed into Integer\n----------\n2. WARNING in X.java (at line 5)\n\tint r2 = b ? null : i;\n\t         ^^^^^^^^^^^^\nThe expression of type Integer is unboxed into int\n----------\n3. WARNING in X.java (at line 5)\n\tint r2 = b ? null : i;\n\t                    ^\nThe expression of type int is boxed into Integer\n----------\n4. ERROR in X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test127() {
        this.runConformTest(new String[]{"X.java", "public class X {\n        public static void main(String[] s) {\n                Object[] os1 = new Object[] {(long)1234567};\n                Object[] os2 = new Object[] {1234567};\n                Object o1 = os1[0], o2 = os2[0];\n                if (o1.getClass().equals(o2.getClass())) {\n                    System.out.println(\"FAILED:o1[\"+o1.getClass().getName()+\"],o2:[\"+o2.getClass()+\"]\");\n                } else {\n                    System.out.println(\"SUCCESS:o1[\"+o1.getClass().getName()+\"],o2:[\"+o2.getClass()+\"]\");\n                }\n        }\n}\n"}, "SUCCESS:o1[java.lang.Long],o2:[class java.lang.Integer]");
    }

    public void test128() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] s) {\n\t\tObject o1 = (long) 1234567;\n\t\tObject[] os1 = new Object[] { (long) 1234567 };\n\t\tObject[] os2 = { (long) 1234567 };\n\t\tfoo((long) 1234567);\n\t}\n\tstatic void foo(Object o) {\n\t}\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tObject o1 = (long) 1234567;\n\t            ^^^^^^^^^^^^^^\nThe expression of type long is boxed into Long\n----------\n2. WARNING in X.java (at line 4)\n\tObject[] os1 = new Object[] { (long) 1234567 };\n\t                              ^^^^^^^^^^^^^^\nThe expression of type long is boxed into Long\n----------\n3. WARNING in X.java (at line 5)\n\tObject[] os2 = { (long) 1234567 };\n\t                 ^^^^^^^^^^^^^^\nThe expression of type long is boxed into Long\n----------\n4. WARNING in X.java (at line 6)\n\tfoo((long) 1234567);\n\t    ^^^^^^^^^^^^^^\nThe expression of type long is boxed into Long\n----------\n5. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test129() {
        this.runNegativeTest(new String[]{"X.java", "public class X{\n   java.io.Serializable field=this==null?8:\"\".getBytes();\n\tZork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\r\n\tjava.io.Serializable field=this==null?8:\"\".getBytes();\r\n\t                                      ^\nThe expression of type int is boxed into Integer\n----------\n2. ERROR in X.java (at line 3)\r\n\tZork z;\r\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test130() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tBoolean[] myBool = new Boolean[1];\n\tvoid foo() {\n\t\tif (this.myBool[0]) {}\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().foo();\n\t\t\tSystem.out.println(\"FAILURE\");\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test131() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tBoolean myBool = null;\n\tvoid foo() {\n\t\tif (myBool) {}\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().foo();\n\t\t\tSystem.out.println(\"FAILURE\");\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test132() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic Boolean myBool = null;\n\tstatic void foo() {\n\t\tif (myBool) {}\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tfoo();\n\t\t\tSystem.out.println(\"FAILURE\");\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test133() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tBoolean myBool = null;\n\tvoid foo() {\n\t\tif (this.myBool) {}\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X().foo();\n\t\t\tSystem.out.println(\"FAILURE\");\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test134() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic Boolean MyBool = null;\n\tstatic void foo() {\n\t\tif (X.MyBool) {}\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tfoo();\n\t\t\tSystem.out.println(\"FAILURE\");\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test135() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo() { return null; }\n}\n\npublic class X {\n        public static void main(String[] args) {\n                A<Long> a = new A<Long>();\n\t\t\t\t A ua = a;\n                try {\n\t                long s = a.foo();\n                } catch(NullPointerException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test136() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo(Object o) {\n                return (T) o; // should get unchecked warning\n        }\n}\n\npublic class X {\n        public static void main(String[] args) {\n                A<Long> a = new A<Long>();\n                try {\n\t                long s = a.foo(new Object());\n                } catch(ClassCastException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test137() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo;\n}\n\npublic class X {\n        public static void main(String[] args) {\n                A<Long> a = new A<Long>();\n\t\t\t\t A ua = a;\n\t\t\t\t ua.foo = new Object();\n                try {\n\t                long s = a.foo;\n                } catch(ClassCastException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test138() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo;\n}\n\npublic class X extends A<Long>{\n        public static void main(String[] args) {\n\t\t\tnew X().foo();\n\t\t }\n \t\t public void foo() {\n\t\t\t\t A ua = this;\n\t\t\t\t ua.foo = new Object();\n                try {\n\t                long s = foo;\n                } catch(ClassCastException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test139() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo;\n}\n\npublic class X extends A<Long>{\n        public static void main(String[] args) {\n\t\t\tnew X().foo();\n\t\t }\n \t\t public void foo() {\n\t\t\t\t A ua = this;\n\t\t\t\t ua.foo = new Object();\n                try {\n\t                long s = this.foo;\n                } catch(ClassCastException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test140() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A {\n        long foo() {\n                return 0L;\n        }\n}\n\npublic class X {\n        public static void main(String[] args) {\n                A a = new A();\n\t             Long s = a.foo();\n                System.out.println(\"SUCCESS\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test141() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A {\n        long foo = 0L;\n}\n\npublic class X {\n        public static void main(String[] args) {\n                A a = new A();\n\t             Long s = a.foo;\n                System.out.println(\"SUCCESS\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test142() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A {\n        long foo = 0L;\n}\n\npublic class X extends A {\n        public static void main(String[] args) {\n\t\t\tnew X().bar();\n        }\n\t\tvoid bar() {\n\t             Long s = foo;\n                System.out.println(\"SUCCESS\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test143() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A {\n        long foo = 0L;\n}\n\npublic class X extends A {\n        public static void main(String[] args) {\n\t\t\tnew X().bar();\n        }\n\t\tvoid bar() {\n\t             Long s = this.foo;\n                System.out.println(\"SUCCESS\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test144() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T[] foo;\n}\n\npublic class X extends A<Long>{\n        public static void main(String[] args) {\n\t\t\tnew X().foo();\n\t\t }\n \t\t public void foo() {\n\t\t\t\t A ua = this;\n\t\t\t\t ua.foo = new Object[1];\n                try {\n\t                long s = this.foo[0];\n                } catch(ClassCastException e) {\n                \tSystem.out.println(\"SUCCESS\");\n                \treturn;\n                }\n            \tSystem.out.println(\"FAILED\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test145() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A {\n        long[] foo = { 0L };\n}\n\npublic class X extends A {\n        public static void main(String[] args) {\n\t\t\tnew X().bar();\n        }\n\t\tvoid bar() {\n\t             Long s = this.foo[0];\n                System.out.println(\"SUCCESS\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test146() {
        Map settings = this.getCompilerOptions();
        settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "class A<T> {\n        public T foo;\n}\n\npublic class X {\n        public static void main(String[] args) {\n            A<Long> a = new A<Long>();\n\t         long s = a.foo.MAX_VALUE;\n            System.out.println(\"SUCCESS\");\n        }\n}\n"}, "SUCCESS", null, true, null, settings, null);
    }

    public void test147() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tif(new Integer(2) == 0) {}\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test148() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tZ test = new Z(1, 1);\n\t\tSystem.out.println(\"SUCCESS\" + test.foo());\n\t}\n}", "Z.java", "class Z {\n\tpublic <A, B extends A> Z(A a, B b) {\n\t}\n\tpublic int foo() {\n\t\treturn 0;\n\t}\n}"}, "SUCCESS0");
    }

    public void test149() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tZ test = new Z(1, 1);\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}", "Z.java", "class Z {\n\tpublic <A, B extends A> Z(A a, B b) {\n\t}\n}"}, "SUCCESS");
    }

    public void test150() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tif(new Integer(2) == 0) {\n\t\t\tSystem.out.println(\"FAILED\");\n\t\t} else {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test151() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tif(new Double(2.0) == 0.0) {\n\t\t\tSystem.out.println(\"FAILED\");\n\t\t} else {\n\t\t\tSystem.out.println(\"SUCCESS\");\n\t\t}\n\t}\n}"}, "SUCCESS");
    }

    public void test152() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tif(new Double(2.0) == 0.0) {}\n\t\tSystem.out.println(\"SUCCESS\");\n\t}\n}"}, "SUCCESS");
    }

    public void test153() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tInteger a = 0;\n\t\tchar b = (char)((int)a);\n\t\tchar c = (char)(a + 1);\n\t\tchar d = (char)(a);\n\t\tint e = (int) a;\n\t\tInteger f = (Integer) e;\n\t}\n\tvoid bar() {\n\t\tX x = (X) null;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tInteger a = 0;\n\t            ^\nThe expression of type int is boxed into Integer\n----------\n2. WARNING in X.java (at line 4)\n\tchar b = (char)((int)a);\n\t                     ^\nThe expression of type Integer is unboxed into int\n----------\n3. WARNING in X.java (at line 5)\n\tchar c = (char)(a + 1);\n\t                ^\nThe expression of type Integer is unboxed into int\n----------\n4. ERROR in X.java (at line 6)\n\tchar d = (char)(a);\n\t         ^^^^^^^^^\nCannot cast from Integer to char\n----------\n5. WARNING in X.java (at line 7)\n\tint e = (int) a;\n\t        ^^^^^^^\nUnnecessary cast from Integer to int\n----------\n6. WARNING in X.java (at line 7)\n\tint e = (int) a;\n\t              ^\nThe expression of type Integer is unboxed into int\n----------\n7. WARNING in X.java (at line 8)\n\tInteger f = (Integer) e;\n\t            ^^^^^^^^^^^\nUnnecessary cast from int to Integer\n----------\n8. WARNING in X.java (at line 8)\n\tInteger f = (Integer) e;\n\t                      ^\nThe expression of type int is boxed into Integer\n----------\n9. WARNING in X.java (at line 11)\n\tX x = (X) null;\n\t      ^^^^^^^^\nUnnecessary cast from null to X\n----------\n");
    }

    public void test154() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n        T counter;\n        public static void main(String[] args) {\n        \t bar(new X<Integer>());\n        \t new Y().foo();\n        \t new Y().baz();\n        }\n        static void bar(X<Integer> x) {\n        \tx.counter = 0;\n            System.out.print(Integer.toString(x.counter++));\n        }\n}\n\nclass Y extends X<Integer> {\n\tY() {\n\t\tthis.counter = 0;\n\t}\n    void foo() {\n        System.out.print(Integer.toString(counter++));\n    }\n    void baz() {\n        System.out.println(Integer.toString(this.counter++));\n    }\n}\n"}, "000");
    }

    public void test155() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n        T[] counter;\n        public static void main(String[] args) {\n        \t bar(new X<Integer>());\n        \t new Y().foo();\n        \t new Y().baz();\n        }\n        static void bar(X<Integer> x) {\n        \tx.counter = new Integer[]{ 0 };\n            System.out.print(Integer.toString(x.counter[0]++));\n        }\n}\n\nclass Y extends X<Integer> {\n\tY() {\n\t\tthis.counter =  new Integer[]{ 0 };\n\t}\n    void foo() {\n        System.out.print(Integer.toString(counter[0]++));\n    }\n    void baz() {\n        System.out.println(Integer.toString(this.counter[0]++));\n    }\n}\n"}, "000");
    }

    public void test156() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic void print(Character c) {\n\t\tSystem.out.print((char) c);\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 'H';\n\t\tprint(c++);\n\t\tprint(c++);\n\t\tSystem.out.println(\"done\");\n    }\n}\n"}, "HIdone");
    }

    public void test157() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tchar c = 'H';\n\tstatic void print(Character c) {\n\t\tSystem.out.print((char) c);\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tprint(x.c++);\n\t\tprint(x.c++);\n\t\tSystem.out.println(\"done\");\n    }\n}\n"}, "HIdone");
    }

    public void test158() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic X singleton = new X();\n\tstatic X singleton() { return singleton; }\n\tchar c = 'H';\n\t\n\tstatic void print(Character c) {\n\t\tSystem.out.print((char) c);\n\t}\n\tpublic static void main(String[] args) {\n\t\tprint(singleton().c++);\n\t\tprint(singleton().c++);\n\t\tSystem.out.println(\"done\");\n    }\n}\n"}, "HIdone");
    }

    public void test159() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X {\n    ArrayList params;\n    public int getSqlParamCount() {\n        return params == null ? null:params.size();\n    }\n    public int getSqlParamCount2() {\n        return null;\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tArrayList params;\n\t^^^^^^^^^\nArrayList is a raw type. References to generic type ArrayList<E> should be parameterized\n----------\n2. WARNING in X.java (at line 5)\n\treturn params == null ? null:params.size();\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe expression of type Integer is unboxed into int\n----------\n3. WARNING in X.java (at line 5)\n\treturn params == null ? null:params.size();\n\t                             ^^^^^^^^^^^^^\nThe expression of type int is boxed into Integer\n----------\n4. ERROR in X.java (at line 8)\n\treturn null;\n\t       ^^^^\nType mismatch: cannot convert from null to int\n----------\n");
    }

    public void test160() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n        T counter;\n        public static void main(String[] args) {\n        \t bar(new X<Integer>());\n        \t new Y().foo();\n        \t new Y().baz();\n        }\n        static void bar(X<Integer> x) {\n        \tx.counter = 0;\n            System.out.print(Integer.toString(++x.counter));\n        }\n}\n\nclass Y extends X<Integer> {\n\tY() {\n\t\tthis.counter = 0;\n\t}\n    void foo() {\n        System.out.print(Integer.toString(++counter));\n    }\n    void baz() {\n        System.out.println(Integer.toString(++this.counter));\n    }\n}\n"}, "111");
    }

    public void test161() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n        T[] counter;\n        public static void main(String[] args) {\n        \t bar(new X<Integer>());\n        \t new Y().foo();\n        \t new Y().baz();\n        }\n        static void bar(X<Integer> x) {\n        \tx.counter = new Integer[]{ 0 };\n            System.out.print(Integer.toString(++x.counter[0]));\n        }\n}\n\nclass Y extends X<Integer> {\n\tY() {\n\t\tthis.counter =  new Integer[]{ 0 };\n\t}\n    void foo() {\n        System.out.print(Integer.toString(++counter[0]));\n    }\n    void baz() {\n        System.out.println(Integer.toString(++this.counter[0]));\n    }\n}\n"}, "111");
    }

    public void test162() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic void print(Character c) {\n\t\tSystem.out.print((char) c);\n\t}\n\tpublic static void main(String[] args) {\n\t\tchar c = 'H';\n\t\tprint(++c);\n\t\tprint(++c);\n\t\tSystem.out.println(\"done\");\n    }\n}\n"}, "IJdone");
    }

    public void test163() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tchar c = 'H';\n\tstatic void print(Character c) {\n\t\tSystem.out.print((char) c);\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tprint(++x.c);\n\t\tprint(++x.c);\n\t\tSystem.out.println(\"done\");\n    }\n}\n"}, "IJdone");
    }

    public void test164() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic X singleton = new X();\n\tstatic X singleton() { return singleton; }\n\tchar c = 'H';\n\t\n\tstatic void print(Character c) {\n\t\tSystem.out.print((char) c);\n\t}\n\tpublic static void main(String[] args) {\n\t\tprint(++singleton().c);\n\t\tprint(++singleton().c);\n\t\tSystem.out.println(\"done\");\n    }\n}\n"}, "IJdone");
    }

    public void test165() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void foo() {\n        Integer i1 = 10 ;\n        final short s = 100;\n        i1 = s;\n        switch (i1)\n        {\n            case s:\n        }\n    }\n    public void bar() {\n        Integer i2 = 10 ;\n        final byte b = 100;\n        i2 = b;\n        switch (i2)\n        {\n            case b:\n        }\n    }   \n    public void baz() {\n        Integer i3 = 10 ;\n        final char c = 100;\n        i3 = c;\n        switch (i3)\n        {\n            case c:\n        }\n    }     \n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tInteger i1 = 10 ;\n\t             ^^\nThe expression of type int is boxed into Integer\n----------\n2. ERROR in X.java (at line 5)\n\ti1 = s;\n\t     ^\nType mismatch: cannot convert from short to Integer\n----------\n3. WARNING in X.java (at line 6)\n\tswitch (i1)\n\t        ^^\nThe expression of type Integer is unboxed into int\n----------\n4. ERROR in X.java (at line 8)\n\tcase s:\n\t     ^\nType mismatch: cannot convert from short to Integer\n----------\n5. WARNING in X.java (at line 12)\n\tInteger i2 = 10 ;\n\t             ^^\nThe expression of type int is boxed into Integer\n----------\n6. ERROR in X.java (at line 14)\n\ti2 = b;\n\t     ^\nType mismatch: cannot convert from byte to Integer\n----------\n7. WARNING in X.java (at line 15)\n\tswitch (i2)\n\t        ^^\nThe expression of type Integer is unboxed into int\n----------\n8. ERROR in X.java (at line 17)\n\tcase b:\n\t     ^\nType mismatch: cannot convert from byte to Integer\n----------\n9. WARNING in X.java (at line 21)\n\tInteger i3 = 10 ;\n\t             ^^\nThe expression of type int is boxed into Integer\n----------\n10. ERROR in X.java (at line 23)\n\ti3 = c;\n\t     ^\nType mismatch: cannot convert from char to Integer\n----------\n11. WARNING in X.java (at line 24)\n\tswitch (i3)\n\t        ^^\nThe expression of type Integer is unboxed into int\n----------\n12. ERROR in X.java (at line 26)\n\tcase c:\n\t     ^\nType mismatch: cannot convert from char to Integer\n----------\n");
    }

    public void test166() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(short s, byte b, char c) {\n\t\tInteger is = s;\n\t\tInteger ib = b;\n\t\tInteger ic = c;\t\n\t}\n\tvoid foo() {\n\t\tfinal short s = 0;\n\t\tfinal byte b = 0;\n\t\tfinal char c = 0;\n\t\tInteger is = s;\n\t\tInteger ib = b;\n\t\tInteger ic = c;\t\n\t}\n\tvoid foo2() {\n\t\tInteger is = (short)0;\n\t\tInteger ib = (byte)0;\n\t\tInteger ic = (char)0;\t\n\t}\n\tvoid foo3() {\n\t\tShort si = 0;\n\t\tByte bi = 0;\n\t\tCharacter ci = 0;\n\t}\n\tvoid foo4() {\n\t\tShort si = (byte) 0;\n\t\tByte bi = (short) 0;\n\t\tCharacter ci = (short) 0;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tInteger is = s;\n\t             ^\nType mismatch: cannot convert from short to Integer\n----------\n2. ERROR in X.java (at line 4)\n\tInteger ib = b;\n\t             ^\nType mismatch: cannot convert from byte to Integer\n----------\n3. ERROR in X.java (at line 5)\n\tInteger ic = c;\t\n\t             ^\nType mismatch: cannot convert from char to Integer\n----------\n4. ERROR in X.java (at line 11)\n\tInteger is = s;\n\t             ^\nType mismatch: cannot convert from short to Integer\n----------\n5. ERROR in X.java (at line 12)\n\tInteger ib = b;\n\t             ^\nType mismatch: cannot convert from byte to Integer\n----------\n6. ERROR in X.java (at line 13)\n\tInteger ic = c;\t\n\t             ^\nType mismatch: cannot convert from char to Integer\n----------\n7. ERROR in X.java (at line 16)\n\tInteger is = (short)0;\n\t             ^^^^^^^^\nType mismatch: cannot convert from short to Integer\n----------\n8. ERROR in X.java (at line 17)\n\tInteger ib = (byte)0;\n\t             ^^^^^^^\nType mismatch: cannot convert from byte to Integer\n----------\n9. ERROR in X.java (at line 18)\n\tInteger ic = (char)0;\t\n\t             ^^^^^^^\nType mismatch: cannot convert from char to Integer\n----------\n10. WARNING in X.java (at line 21)\n\tShort si = 0;\n\t           ^\nThe expression of type int is boxed into Short\n----------\n11. WARNING in X.java (at line 22)\n\tByte bi = 0;\n\t          ^\nThe expression of type int is boxed into Byte\n----------\n12. WARNING in X.java (at line 23)\n\tCharacter ci = 0;\n\t               ^\nThe expression of type int is boxed into Character\n----------\n13. WARNING in X.java (at line 26)\n\tShort si = (byte) 0;\n\t           ^^^^^^^^\nThe expression of type byte is boxed into Short\n----------\n14. WARNING in X.java (at line 27)\n\tByte bi = (short) 0;\n\t          ^^^^^^^^^\nThe expression of type short is boxed into Byte\n----------\n15. WARNING in X.java (at line 28)\n\tCharacter ci = (short) 0;\n\t               ^^^^^^^^^\nThe expression of type short is boxed into Character\n----------\n");
    }

    public void test167() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n     String foo(Comparable<String> x) {\n       System.out.println( \"one\" );\t\treturn null;\n     }\n     void foo(int x) {\n       System.out.println( \"two\" );\n     }\n\tvoid bar() {\n       Integer i = 1;\n       String s = foo(i); \n     }\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tInteger i = 1;\n\t            ^\nThe expression of type int is boxed into Integer\n----------\n2. ERROR in X.java (at line 10)\n\tString s = foo(i); \n\t           ^^^^^^\nType mismatch: cannot convert from void to String\n----------\n3. WARNING in X.java (at line 10)\n\tString s = foo(i); \n\t               ^\nThe expression of type Integer is unboxed into int\n----------\n");
    }

    public void test168() {
        this.runNegativeTest(new String[]{"X.java", "@SuppressWarnings(\"deprecation\")\npublic class X {\n    <T extends Integer> T a() { return 35; }\n    <T extends Integer> T[] b() { return new int[]{35}; }\n    <T extends Integer> T c() { return new Integer(35); }\n    <T extends Integer> T[] d() { return new Integer[]{35}; }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\t<T extends Integer> T a() { return 35; }\n\t           ^^^^^^^\nThe type parameter T should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 3)\n\t<T extends Integer> T a() { return 35; }\n\t                                   ^^\nType mismatch: cannot convert from int to T\n----------\n3. WARNING in X.java (at line 4)\n\t<T extends Integer> T[] b() { return new int[]{35}; }\n\t           ^^^^^^^\nThe type parameter T should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n4. ERROR in X.java (at line 4)\n\t<T extends Integer> T[] b() { return new int[]{35}; }\n\t                                     ^^^^^^^^^^^^^\nType mismatch: cannot convert from int[] to T[]\n----------\n5. WARNING in X.java (at line 5)\n\t<T extends Integer> T c() { return new Integer(35); }\n\t           ^^^^^^^\nThe type parameter T should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n6. ERROR in X.java (at line 5)\n\t<T extends Integer> T c() { return new Integer(35); }\n\t                                   ^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Integer to T\n----------\n7. WARNING in X.java (at line 6)\n\t<T extends Integer> T[] d() { return new Integer[]{35}; }\n\t           ^^^^^^^\nThe type parameter T should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n8. ERROR in X.java (at line 6)\n\t<T extends Integer> T[] d() { return new Integer[]{35}; }\n\t                                     ^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Integer[] to T[]\n----------\n9. WARNING in X.java (at line 6)\n\t<T extends Integer> T[] d() { return new Integer[]{35}; }\n\t                                                   ^^\nThe expression of type int is boxed into Integer\n----------\n");
    }

    public void test169() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T extends Integer> {\n    T x = 12;\n    Byte y = 12;\n    \tvoid x(T t) {\n    \t\tt = 5;\n    \t\tswitch (t) {\n    \t\tcase 1:\n    \t\t\tbreak;\n    \t\t}\n    \t}\n    \tvoid y(Byte t) {\n    \t\tt = 5;\n    \t\tswitch (t) {\n    \t\tcase 1:\n    \t\t\tbreak;\n    \t\t}\n    \t}\n}\n"}, "----------\n1. WARNING in X.java (at line 1)\n\tpublic class X<T extends Integer> {\n\t                         ^^^^^^^\nThe type parameter T should not be bounded by the final type Integer. Final types cannot be further extended\n----------\n2. ERROR in X.java (at line 2)\n\tT x = 12;\n\t      ^^\nType mismatch: cannot convert from int to T\n----------\n3. WARNING in X.java (at line 3)\n\tByte y = 12;\n\t         ^^\nThe expression of type int is boxed into Byte\n----------\n4. ERROR in X.java (at line 5)\n\tt = 5;\n\t    ^\nType mismatch: cannot convert from int to T\n----------\n5. WARNING in X.java (at line 6)\n\tswitch (t) {\n\t        ^\nThe expression of type T is unboxed into int\n----------\n6. ERROR in X.java (at line 7)\n\tcase 1:\n\t     ^\nType mismatch: cannot convert from int to T\n----------\n7. WARNING in X.java (at line 12)\n\tt = 5;\n\t    ^\nThe expression of type int is boxed into Byte\n----------\n8. WARNING in X.java (at line 13)\n\tswitch (t) {\n\t        ^\nThe expression of type Byte is unboxed into int\n----------\n");
    }
}

