/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.util.ManifestAnalyzer;
import org.eclipse.jdt.internal.compiler.util.Util;

public class BatchCompilerTest
extends AbstractBatchCompilerTest {
    static final AbstractBatchCompilerTest.Matcher EMPTY_STRING_MATCHER = new AbstractBatchCompilerTest.Matcher(){

        @Override
        String expected() {
            return Util.EMPTY_STRING;
        }

        @Override
        boolean match(String effective) {
            return effective != null && effective.length() == 0;
        }
    };
    static final AbstractBatchCompilerTest.Matcher ONE_FILE_GENERATED_MATCHER = new SubstringMatcher("[1 .class file generated]");
    static final AbstractBatchCompilerTest.Matcher TWO_FILES_GENERATED_MATCHER = new SubstringMatcher("[2 .class files generated]");
    private static AbstractBatchCompilerTest.Normalizer textLogsNormalizer = new AbstractBatchCompilerTest.StringNormalizer(new XMLClasspathsSectionNormalizer(new LinesRangeNormalizer(null, 0, 2)), OUTPUT_DIR, "---OUTPUT_DIR_PLACEHOLDER---");
    private static AbstractBatchCompilerTest.Normalizer xmlLogsNormalizer = new AbstractBatchCompilerTest.StringNormalizer(new XMLClasspathsSectionNormalizer(new LinesRangeNormalizer(null, 1, 1)), OUTPUT_DIR, "---OUTPUT_DIR_PLACEHOLDER---");

    public BatchCompilerTest(String name) {
        super(name);
    }

    public static Test suite() {
        return BatchCompilerTest.buildMinimalComplianceTestSuite(BatchCompilerTest.testClass(), 4);
    }

    public static Class testClass() {
        return BatchCompilerTest.class;
    }

    public void test001() {
        String commandLine = "-classpath \"D:/a folder\";d:/jdk1.4/jre/lib/rt.jar -1.4 -preserveAllLocals -g -verbose d:/eclipse/workspaces/development2.0/plugins/Bar/src2/ -d d:/test";
        String expected = " <-classpath> <D:/a folder;d:/jdk1.4/jre/lib/rt.jar> <-1.4> <-preserveAllLocals> <-g> <-verbose> <d:/eclipse/workspaces/development2.0/plugins/Bar/src2/> <-d> <d:/test>";
        String[] args = Main.tokenize((String)commandLine);
        StringBuffer buffer = new StringBuffer(30);
        int i = 0;
        while (i < args.length) {
            buffer.append(" <" + args[i] + ">");
            ++i;
        }
        String result = buffer.toString();
        BatchCompilerTest.assertEquals("incorrect tokenized command line", expected, result);
    }

    public void test002() {
        String commandLine = "-classpath \"a folder\";\"b folder\"";
        String expected = " <-classpath> <a folder;b folder>";
        String[] args = Main.tokenize((String)commandLine);
        StringBuffer buffer = new StringBuffer(30);
        int i = 0;
        while (i < args.length) {
            buffer.append(" <" + args[i] + ">");
            ++i;
        }
        String result = buffer.toString();
        BatchCompilerTest.assertEquals("incorrect tokenized command line", expected, result);
    }

    public void test003() {
        String commandLine = "-classpath \"a folder;b folder\"";
        String expected = " <-classpath> <a folder;b folder>";
        String[] args = Main.tokenize((String)commandLine);
        StringBuffer buffer = new StringBuffer(30);
        int i = 0;
        while (i < args.length) {
            buffer.append(" <" + args[i] + ">");
            ++i;
        }
        String result = buffer.toString();
        BatchCompilerTest.assertEquals("incorrect tokenized command line", expected, result);
    }

    public void test004() {
        String commandLine = "\"d:/tmp A/\"A.java  -classpath \"d:/tmp A\";d:/jars/rt.jar -nowarn -time -g -d d:/tmp";
        String expected = " <d:/tmp A/A.java> <-classpath> <d:/tmp A;d:/jars/rt.jar> <-nowarn> <-time> <-g> <-d> <d:/tmp>";
        String[] args = Main.tokenize((String)commandLine);
        StringBuffer buffer = new StringBuffer(30);
        int i = 0;
        while (i < args.length) {
            buffer.append(" <" + args[i] + ">");
            ++i;
        }
        String result = buffer.toString();
        BatchCompilerTest.assertEquals("incorrect tokenized command line", expected, result);
    }

    public void test005() {
        String commandLine = "\"d:/tmp A/\"A.java  -classpath d:/jars/rt.jar;\"d:/tmp A\";\"toto\" -nowarn -time -g -d d:/tmp";
        String expected = " <d:/tmp A/A.java> <-classpath> <d:/jars/rt.jar;d:/tmp A;toto> <-nowarn> <-time> <-g> <-d> <d:/tmp>";
        String[] args = Main.tokenize((String)commandLine);
        StringBuffer buffer = new StringBuffer(30);
        int i = 0;
        while (i < args.length) {
            buffer.append(" <" + args[i] + ">");
            ++i;
        }
        String result = buffer.toString();
        BatchCompilerTest.assertEquals("incorrect tokenized command line", expected, result);
    }

    public void test006() {
        String commandLine = "\"d:/tmp A/A.java\"  -classpath d:/jars/rt.jar;\"d:/tmp A\";d:/tmpB/ -nowarn -time -g -d d:/tmp";
        String expected = " <d:/tmp A/A.java> <-classpath> <d:/jars/rt.jar;d:/tmp A;d:/tmpB/> <-nowarn> <-time> <-g> <-d> <d:/tmp>";
        String[] args = Main.tokenize((String)commandLine);
        StringBuffer buffer = new StringBuffer(30);
        int i = 0;
        while (i < args.length) {
            buffer.append(" <" + args[i] + ">");
            ++i;
        }
        String result = buffer.toString();
        BatchCompilerTest.assertEquals("incorrect tokenized command line", expected, result);
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\n@SuppressWarnings(\"all\"//$NON-NLS-1$\n)\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tif (false) {\n\t\t\t;\n\t\t} else {\n\t\t}\n\t\t// Zork z;\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + " -cp " + this.getJCEJarAsQuotedString() + " -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -verbose -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "[parsing    ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[reading    java/lang/Object.class]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[reading    java/util/List.class]\n[reading    java/lang/SuppressWarnings.class]\n[reading    java/lang/String.class]\n[writing    X.class - #1]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[1 unit compiled]\n[1 .class file generated]\n", "", true);
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\n@SuppressWarnings(\"all\"//$NON-NLS-1$\n)\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tif (false) {\n\t\t\t;\n\t\t} else {\n\t\t}\n\t\tZork z;\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + " -cp " + this.getJCEJarAsQuotedString() + " -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n1 problem (1 error)\n", true);
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n\tOK1 ok1;\n\tOK2 ok2;\n\tWarn warn;\n\tKO ko;\n\tZork z;\n}", "OK1.java", "/** */\npublic class OK1 {\n\t// empty\n}", "OK2.java", "/** */\npublic class OK2 {\n\t// empty\n}", "Warn.java", "/** */\npublic class Warn {\n\t// empty\n}", "KO.java", "/** */\npublic class KO {\n\t// empty\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[+OK2" + File.pathSeparator + "~Warn" + File.pathSeparator + "-KO]\"" + " -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tWarn warn;\n\t^^^^\nDiscouraged access: The type 'Warn' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tKO ko;\n\t^^\nAccess restriction: The type 'KO' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3 problems (1 error, 2 warnings)\n", true);
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\n\n@SuppressWarnings(\"all\"//$NON-NLS-1$\n)\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tif (false) {\n\t\t\t;\n\t\t} else {\n\t\t}\n\t\t// Zork z;\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -verbose -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "[parsing    ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[reading    java/lang/Object.class]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[reading    java/util/List.class]\n[reading    java/lang/SuppressWarnings.class]\n[reading    java/lang/String.class]\n[writing    X.class - #1]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[1 unit compiled]\n[1 .class file generated]\n", "", true);
    }

    public void test011_classpath() {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[+**/OK2;~**/Warn;-KO]" + "\"" + File.pathSeparator + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test012() {
        String expectedOutput = "{0} {1}\n{2}\n \n Usage: <options> <source files | directories>\n If directories are specified, then their source contents are compiled.\n Possible options are listed below. Options enabled by default are prefixed\n with ''+''.\n \n Classpath options:\n    -cp -classpath <directories and ZIP archives separated by " + File.pathSeparator + ">\n" + "                       specify location for application classes and sources.\n" + "                       Each directory or file can specify access rules for\n" + "                       types between ''['' and '']'' (e.g. [-X] to forbid\n" + "                       access to type X, [~X] to discourage access to type X,\n" + "                       [+p/X" + File.pathSeparator + "-p/*] to forbid access to all types in package p\n" + "                       but allow access to p/X)\n" + "    -bootclasspath <directories and ZIP archives separated by " + File.pathSeparator + ">\n" + "                       specify location for system classes. Each directory or\n" + "                       file can specify access rules for types between ''[''\n" + "                       and '']''\n" + "    -sourcepath <directories and ZIP archives separated by " + File.pathSeparator + ">\n" + "                       specify location for application sources. Each directory\n" + "                       or file can specify access rules for types between ''[''\n" + "                       and '']''. Each directory can further specify a specific\n" + "                       destination directory using a ''-d'' option between ''[''\n" + "                       and '']''; this overrides the general ''-d'' option.\n" + "                       .class files created from source files contained in a\n" + "                       jar file are put in the user.dir folder in case no\n" + "                       general ''-d'' option is specified. ZIP archives cannot\n" + "                       override the general ''-d'' option\n" + "    -extdirs <directories separated by " + File.pathSeparator + ">\n" + "                       specify location for extension ZIP archives\n" + "    -endorseddirs <directories separated by " + File.pathSeparator + ">\n" + "                       specify location for endorsed ZIP archives\n" + "    -d <dir>           destination directory (if omitted, no directory is\n" + "                       created); this option can be overridden per source\n" + "                       directory\n" + "    -d none            generate no .class files\n" + "    -encoding <enc>    specify default encoding for all source files. Each\n" + "                       file/directory can override it when suffixed with\n" + "                       ''[''<enc>'']'' (e.g. X.java[utf8]).\n" + "                       If multiple default encodings are specified, the last\n" + "                       one will be used.\n" + " \n" + " Module compilation options:\n" + "   These options are meaningful only in Java 9 environment or later.\n" + "    --module-source-path <directories separated by " + File.pathSeparator + ">\n" + "                       specify where to find source files for multiple modules\n" + "    -p --module-path <directories separated by " + File.pathSeparator + ">\n" + "                       specify where to find application modules\n" + "    --system <jdk>      Override location of system modules \n" + " Compliance options:\n" + "    -1.3               use 1.3 compliance (-source 1.3 -target 1.1)\n" + "    -1.4             + use 1.4 compliance (-source 1.3 -target 1.2)\n" + "    -1.5 -5 -5.0       use 1.5 compliance (-source 1.5 -target 1.5)\n" + "    -1.6 -6 -6.0       use 1.6 compliance (-source 1.6 -target 1.6)\n" + "    -1.7 -7 -7.0       use 1.7 compliance (-source 1.7 -target 1.7)\n" + "    -1.8 -8 -8.0       use 1.8 compliance (-source 1.8 -target 1.8)\n" + "    -1.9 -9 -9.0       use 1.9 compliance (-source 1.9 -target 1.9)\n" + "    -source <version>  set source level: 1.3 to 1.9 (or 6, 6.0, etc)\n" + "    -target <version>  set classfile target: 1.1 to 1.9 (or 6, 6.0, etc)\n" + "                       cldc1.1 can also be used to generate the StackMap\n" + "                       attribute\n" + " \n" + " Warning options:\n" + "    -deprecation     + deprecation outside deprecated code (equivalent to\n" + "                       -warn:+deprecation)\n" + "    -nowarn -warn:none disable all warnings\n" + "    -nowarn:[<directories separated by " + File.pathSeparator + ">]\n" + "                       specify directories from which optional problems should\n" + "                       be ignored\n" + "    -?:warn -help:warn display advanced warning options\n" + " \n" + " Error options:\n" + "    -err:<warnings separated by ,>    convert exactly the listed warnings\n" + "                                      to be reported as errors\n" + "    -err:+<warnings separated by ,>   enable additional warnings to be\n" + "                                      reported as errors\n" + "    -err:-<warnings separated by ,>   disable specific warnings to be\n" + "                                      reported as errors\n" + " \n" + " Info options:\n" + "    -info:<warnings separated by ,>    convert exactly the listed warnings\n" + "                                      to be reported as infos\n" + "    -info:+<warnings separated by ,>   enable additional warnings to be\n" + "                                      reported as infos\n" + "    -info:-<warnings separated by ,>   disable specific warnings to be\n" + "                                      reported as infos\n" + " \n" + " Setting warning, error or info options using properties file:\n" + "    -properties <file>   set warnings/errors/info option based on the properties\n" + "                          file contents. This option can be used with -nowarn,\n" + "                          -err:.., -info: or -warn:.. options, but the last one\n" + "                          on the command line sets the options to be used.\n" + " \n" + " Debug options:\n" + "    -g[:lines,vars,source] custom debug info\n" + "    -g:lines,source  + both lines table and source debug info\n" + "    -g                 all debug info\n" + "    -g:none            no debug info\n" + "    -preserveAllLocals preserve unused local vars for debug purpose\n" + " \n" + " Annotation processing options:\n" + "   These options are meaningful only in a 1.6 environment.\n" + "    -Akey[=value]        options that are passed to annotation processors\n" + "    -processorpath <directories and ZIP archives separated by " + File.pathSeparator + ">\n" + "                         specify locations where to find annotation processors.\n" + "                         If this option is not used, the classpath will be\n" + "                         searched for processors\n" + "    -processor <class1[,class2,...]>\n" + "                         qualified names of the annotation processors to run.\n" + "                         This bypasses the default annotation discovery process\n" + "    -proc:only           run annotation processors, but do not compile\n" + "    -proc:none           perform compilation but do not run annotation\n" + "                         processors\n" + "    -s <dir>             destination directory for generated source files\n" + "    -XprintProcessorInfo print information about which annotations and elements\n" + "                         a processor is asked to process\n" + "    -XprintRounds        print information about annotation processing rounds\n" + "    -classNames <className1[,className2,...]>\n" + "                         qualified names of binary classes to process\n" + " \n" + " Advanced options:\n" + "    @<file>            read command line arguments from file\n" + "    -maxProblems <n>   max number of problems per compilation unit (100 by\n" + "                       default)\n" + "    -log <file>        log to a file. If the file extension is ''.xml'', then\n" + "                       the log will be a xml file.\n" + "    -proceedOnError[:Fatal]\n" + "                       do not stop at first error, dumping class files with\n" + "                       problem methods\n" + "                       With \":Fatal\", all optional errors are treated as fatal\n" + "    -verbose           enable verbose output\n" + "    -referenceInfo     compute reference info\n" + "    -progress          show progress (only in -log mode)\n" + "    -time              display speed information \n" + "    -noExit            do not call System.exit(n) at end of compilation (n==0\n" + "                       if no error)\n" + "    -repeat <n>        repeat compilation process <n> times for perf analysis\n" + "    -inlineJSR         inline JSR bytecode (implicit if target >= 1.5)\n" + "    -enableJavadoc     consider references in javadoc\n" + "    -parameters        generate method parameters attribute (for target >= 1.8)\n" + "    -genericsignature  generate generic signature for lambda expressions\n" + "    -Xemacs            used to enable emacs-style output in the console.\n" + "                       It does not affect the xml log output\n" + "    -missingNullDefault  report missing default nullness annotation\n" + "    -annotationpath <directories and ZIP archives separated by " + File.pathSeparator + ">\n" + "                       specify locations where to find external annotations\n" + "                       to support annotation-based null analysis.\n" + "                       The special name CLASSPATH will cause lookup of\n" + "                       external annotations from the classpath and sourcepath.\n" + " \n" + "    -? -help           print this help message\n" + "    -v -version        print compiler version\n" + "    -showversion       print compiler version and continue\n" + " \n" + " Ignored options:\n" + "    -J<option>         pass option to virtual machine (ignored)\n" + "    -X<option>         specify non-standard option (ignored\n" + "                       except for listed -X options)\n" + "    -X                 print non-standard options and exit (ignored)\n" + "    -O                 optimize for execution time (ignored)\n" + "\n";
        String expandedExpectedOutput = MessageFormat.format(expectedOutput, MAIN.bind("compiler.name"), MAIN.bind("compiler.version"), MAIN.bind("compiler.copyright"));
        this.runConformTest(new String[0], " -help -referenceInfo", expandedExpectedOutput, "", true);
        this.checkWidth(expandedExpectedOutput, 80);
    }

    public void test012b() {
        String expectedOutput = "{0} {1}\n{2}\n \n Warning options:\n    -deprecation         + deprecation outside deprecated code\n    -nowarn -warn:none disable all warnings and infos\n    -nowarn:[<directories separated by " + File.pathSeparator + ">]\n" + "                       specify directories from which optional problems should\n" + "                       be ignored\n" + "    -warn:<warnings separated by ,>    enable exactly the listed warnings\n" + "    -warn:+<warnings separated by ,>   enable additional warnings\n" + "    -warn:-<warnings separated by ,>   disable specific warnings\n" + "      all                  enable all warnings\n" + "      allDeadCode          dead code including trivial if(DEBUG) check\n" + "      allDeprecation       deprecation including inside deprecated code\n" + "      allJavadoc           invalid or missing javadoc\n" + "      allOver-ann          all missing @Override annotations\n" + "      all-static-method    all method can be declared as static warnings\n" + "      assertIdentifier   + ''assert'' used as identifier\n" + "      boxing               autoboxing conversion\n" + "      charConcat         + char[] in String concat\n" + "      compareIdentical   + comparing identical expressions\n" + "      conditionAssign      possible accidental boolean assignment\n" + "      constructorName    + method with constructor name\n" + "      deadCode           + dead code excluding trivial if (DEBUG) check\n" + "      dep-ann              missing @Deprecated annotation\n" + "      deprecation        + deprecation outside deprecated code\n" + "      discouraged        + use of types matching a discouraged access rule\n" + "      emptyBlock           undocumented empty block\n" + "      enumIdentifier       ''enum'' used as identifier\n" + "      enumSwitch           incomplete enum switch\n" + "      enumSwitchPedantic + report missing enum switch cases even\n" + "                           in the presence of a default case\n" + "      fallthrough          possible fall-through case\n" + "      fieldHiding          field hiding another variable\n" + "      finalBound           type parameter with final bound\n" + "      finally            + finally block not completing normally\n" + "      forbidden          + use of types matching a forbidden access rule\n" + "      hashCode              missing hashCode() method when overriding equals()\n" + "      hiding               macro for fieldHiding, localHiding, typeHiding and\n" + "                           maskedCatchBlock\n" + "      includeAssertNull    raise null warnings for variables\n" + "                           that got tainted in an assert expression\n" + "      indirectStatic       indirect reference to static member\n" + "      inheritNullAnnot     inherit null annotations\n" + "      intfAnnotation     + annotation type used as super interface\n" + "      intfNonInherited   + interface non-inherited method compatibility\n" + "      intfRedundant        find redundant superinterfaces\n" + "      invalidJavadoc       all warnings for malformed javadoc tags\n" + "      invalidJavadocTag    validate javadoc tag arguments\n" + "      invalidJavadocTagDep validate deprecated references in javadoc tag args\n" + "      invalidJavadocTagNotVisible  validate non-visible references in javadoc\n" + "\t\t\t\t\t\t\ttag args\n" + "      invalidJavadocVisibility(<visibility>)  specify visibility modifier\n" + "\t\t\t\t\t\t\tfor malformed javadoc tag warnings\n" + "      javadoc              invalid javadoc\n" + "      localHiding          local variable hiding another variable\n" + "      maskedCatchBlock   + hidden catch block\n" + "      missingJavadocTags   missing Javadoc tags\n" + "      missingJavadocTagsOverriding missing Javadoc tags in overriding methods\n" + "      missingJavadocTagsMethod missing Javadoc tags for method type parameter\n" + "      missingJavadocTagsVisibility(<visibility>)  specify visibility modifier\n" + "\t\t\t\t\t\t\tfor missing javadoc tags warnings\n" + "      missingJavadocComments   missing Javadoc comments\n" + "      missingJavadocCommentsOverriding   missing Javadoc tags in overriding\n" + "\t\t\t\t\t\t\tmethods\n" + "      missingJavadocCommentsVisibility(<visibility>)  specify visibility\n" + "\t\t\t\t\t\t\tmodifier for missing javadoc comments warnings\n" + "      nls                  string literal lacking non-nls tag //$NON-NLS-<n>$\n" + "      noEffectAssign     + assignment without effect\n" + "      null                 potential missing or redundant null check\n" + "      nullAnnot(<annot. names separated by |>)   annotation based null analysis,\n" + "                           nullable|nonnull|nonnullbydefault annotation types\n" + "                           optionally specified using fully qualified names.\n" + "\t\t\t\t\t\t\tEnabling this option enables all null-annotation\n" + "\t\t\t\t\t\t\trelated sub-options. These can be individually\n" + "\t\t\t\t\t\t\tcontrolled using options listed below.\n" + "      nullAnnotConflict    conflict between null annotation specified\n" + "\t\t\t\t\t\t\tand nullness inferred. Is effective only with\n" + "\t\t\t\t\t\t\tnullAnnot option enabled.\n" + "      nullAnnotRedundant   redundant specification of null annotation. Is\n" + "\t\t\t\t\t\t\teffective only with nullAnnot option enabled.\n" + "      nullDereference    + missing null check\n" + "\t   nullUncheckedConversion unchecked conversion from non-annotated type\n" + "\t\t\t\t\t\t\tto @NonNull type. Is effective only with\n" + "\t\t\t\t\t\t\tnullAnnot option enabled.\n" + "      over-ann             missing @Override annotation (superclass)\n" + "      paramAssign          assignment to a parameter\n" + "      pkgDefaultMethod   + attempt to override package-default method\n" + "      raw                + usage of raw type\n" + "      removal            + deprecation marked for removal\n" + "      resource           + (pot.) unsafe usage of resource of type Closeable\n" + "      semicolon            unnecessary semicolon, empty statement\n" + "      serial             + missing serialVersionUID\n" + "      specialParamHiding   constructor or setter parameter hiding a field\n" + "      static-method        method can be declared as static\n" + "      static-access        macro for indirectStatic and staticReceiver\n" + "      staticReceiver     + non-static reference to static member\n" + "      super                overriding a method without making a super invocation\n" + "      suppress           + enable @SuppressWarnings\n" + "                           When used with -err:, it can also silence optional\n" + "                           errors and warnings\n" + "      switchDefault        switch statement lacking a default case\n" + "      syncOverride         missing synchronized in synchr. method override\n" + "      syntacticAnalysis    perform syntax-based null analysis for fields\n" + "      syntheticAccess      synthetic access for innerclass\n" + "      tasks(<tags separated by |>) tasks identified by tags inside comments\n" + "      typeHiding         + type parameter hiding another type\n" + "      unavoidableGenericProblems + ignore unavoidable type safety problems\n" + "                                   due to raw APIs\n" + "      unchecked          + unchecked type operation\n" + "      unlikelyCollectionMethodArgumentType\n" + "                         + unlikely argument type for collection method\n" + "                           declaring an Object parameter\n" + "      unlikelyEqualsArgumentType unlikely argument type for method equals()\n" + "      unnecessaryElse      unnecessary else clause\n" + "      unqualifiedField     unqualified reference to field\n" + "      unused               macro for unusedAllocation, unusedArgument,\n" + "                               unusedImport, unusedLabel, unusedLocal,\n" + "                               unusedPrivate, unusedThrown, and unusedTypeArgs,\n" + "\t\t\t\t\t\t\t\tunusedExceptionParam\n" + "      unusedAllocation     allocating an object that is not used\n" + "      unusedArgument       unread method parameter\n" + "      unusedExceptionParam unread exception parameter\n" + "      unusedImport       + unused import declaration\n" + "      unusedLabel        + unused label\n" + "      unusedLocal        + unread local variable\n" + "      unusedParam\t\t    unused parameter\n" + "      unusedParamOverriding unused parameter for overriding method\n" + "      unusedParamImplementing unused parameter for implementing method\n" + "      unusedParamIncludeDoc unused parameter documented in comment tag\n" + "      unusedPrivate      + unused private member declaration\n" + "      unusedThrown         unused declared thrown exception\n" + "      unusedThrownWhenOverriding unused declared thrown exception in \n" + "\t\t\t\t\t\t\toverriding method\n" + "      unusedThrownIncludeDocComment     unused declared thrown exception,\n" + "\t\t\t\t\t\t\tdocumented in a comment tag\n" + "      unusedThrownExemptExceptionThrowable  unused declared thrown exception,\n" + "\t\t\t\t\t\t\texempt Exception and Throwable\n" + "      unusedTypeArgs     + unused type arguments for method and constructor\n" + "      uselessTypeCheck     unnecessary cast/instanceof operation\n" + "      varargsCast        + varargs argument need explicit cast\n" + "      warningToken       + unsupported or unnecessary @SuppressWarnings\n" + "\n";
        String expandedExpectedOutput = MessageFormat.format(expectedOutput, MAIN.bind("compiler.name"), MAIN.bind("compiler.version"), MAIN.bind("compiler.copyright"));
        this.runConformTest(new String[0], " -help:warn -referenceInfo", expandedExpectedOutput, "", true);
        this.checkWidth(expandedExpectedOutput, 80);
    }

    public void test013() {
        String logFileName = String.valueOf(OUTPUT_DIR) + File.separator + "log.xml";
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n\tZork z;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -proceedOnError" + " -log \"" + logFileName + "\" -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n1 problem (1 error)", true);
        String logContents = org.eclipse.jdt.core.tests.util.Util.fileContent(logFileName);
        String expectedLogContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE compiler PUBLIC \"-//Eclipse.org//DTD Eclipse JDT 3.2.005 Compiler//EN\" \"http://www.eclipse.org/jdt/core/compiler_32_005.dtd\">\n<compiler copyright=\"{2}\" name=\"{1}\" version=\"{3}\">\n\t<command_line>\n\t\t<argument value=\"---OUTPUT_DIR_PLACEHOLDER---{0}X.java\"/>\n\t\t<argument value=\"-1.5\"/>\n\t\t<argument value=\"-proceedOnError\"/>\n\t\t<argument value=\"-log\"/>\n\t\t<argument value=\"---OUTPUT_DIR_PLACEHOLDER---{0}log.xml\"/>\n\t\t<argument value=\"-d\"/>\n\t\t<argument value=\"---OUTPUT_DIR_PLACEHOLDER---\"/>\n\t</command_line>\n\t<options>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.annotation.missingNonNullByDefaultAnnotation\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.annotation.nonnull\" value=\"org.eclipse.jdt.annotation.NonNull\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.annotation.nonnull.secondary\" value=\"\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.annotation.nonnullbydefault\" value=\"org.eclipse.jdt.annotation.NonNullByDefault\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.annotation.nonnullbydefault.secondary\" value=\"\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.annotation.nullable\" value=\"org.eclipse.jdt.annotation.Nullable\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.annotation.nullable.secondary\" value=\"\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.annotation.nullanalysis\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.codegen.lambda.genericSignature\" value=\"do not generate\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.codegen.methodParameters\" value=\"do not generate\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.codegen.shareCommonFinallyBlocks\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.codegen.targetPlatform\" value=\"1.5\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.codegen.unusedLocal\" value=\"optimize out\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.compliance\" value=\"1.5\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.debug.lineNumber\" value=\"generate\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.debug.localVariable\" value=\"do not generate\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.debug.sourceFile\" value=\"generate\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.doc.comment.support\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.emulateJavacBug8031744\" value=\"enabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.generateClassFiles\" value=\"enabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.maxProblemPerUnit\" value=\"100\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.APILeak\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.annotationSuperInterface\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.assertIdentifier\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.autoboxing\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.comparingIdentical\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.deadCode\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.deadCodeInTrivialIfStatement\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.deprecation\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.discouragedReference\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.emptyStatement\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.enumIdentifier\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.fallthroughCase\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.fatalOptionalError\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.fieldHiding\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.finalParameterBound\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.forbiddenReference\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.includeNullInfoFromAsserts\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.indirectStaticAccess\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.invalidJavadoc\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.invalidJavadocTags\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility\" value=\"public\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.localVariableHiding\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.methodWithConstructorName\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingDefaultCase\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingEnumCaseDespiteDefault\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingHashCodeMethod\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingJavadocComments\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility\" value=\"public\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingJavadocTagDescription\" value=\"return_tag\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingJavadocTags\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingJavadocTagsMethodTypeParameters\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility\" value=\"public\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation\" value=\"enabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingSerialVersion\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.missingSynchronizedOnInheritedMethod\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.noEffectAssignment\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.nullAnnotationInferenceConflict\" value=\"error\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.nullReference\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.nullSpecViolation\" value=\"error\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.nullUncheckedConversion\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.overridingMethodWithoutSuperInvocation\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.parameterAssignment\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.potentialNullReference\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.rawTypeReference\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.redundantNullAnnotation\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.redundantNullCheck\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.redundantSuperinterface\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.specialParameterHidingField\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.staticAccessReceiver\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.suppressWarnings\" value=\"enabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.syntacticNullAnalysisForFields\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.tasks\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.terminalDeprecation\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.typeParameterHiding\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unavoidableGenericTypeProblems\" value=\"enabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unclosedCloseable\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unhandledWarningToken\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.uninternedIdentityComparison\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unlikelyCollectionMethodArgumentType\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unlikelyCollectionMethodArgumentTypeStrict\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unlikelyEqualsArgumentType\" value=\"info\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unnecessaryElse\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionExemptExceptionAndThrowable\" value=\"enabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference\" value=\"enabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedExceptionParameter\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedImport\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedLabel\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedLocal\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedParameter\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference\" value=\"enabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedPrivateMember\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedTypeArgumentsForMethodInvocation\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedTypeParameter\" value=\"ignore\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.unusedWarningToken\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast\" value=\"warning\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.processAnnotations\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.source\" value=\"1.5\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.storeAnnotations\" value=\"disabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.taskCaseSensitive\" value=\"enabled\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.taskPriorities\" value=\"\"/>\n\t\t<option key=\"org.eclipse.jdt.core.compiler.taskTags\" value=\"\"/>\n\t</options>\n\t<classpaths>NORMALIZED SECTION</classpaths>\n\t<sources>\n\t\t<source output=\"---OUTPUT_DIR_PLACEHOLDER---\" path=\"---OUTPUT_DIR_PLACEHOLDER---" + File.separator + "X.java\">\n" + "\t\t\t<problems errors=\"1\" infos=\"0\" problems=\"1\" warnings=\"0\">\n" + "\t\t\t\t<problem categoryID=\"40\" charEnd=\"28\" charStart=\"25\" id=\"UndefinedType\" line=\"3\" problemID=\"16777218\" severity=\"ERROR\">\n" + "\t\t\t\t\t<message value=\"Zork cannot be resolved to a type\"/>\n" + "\t\t\t\t\t<source_context sourceEnd=\"3\" sourceStart=\"0\" value=\"Zork z;\"/>\n" + "\t\t\t\t\t<arguments>\n" + "\t\t\t\t\t\t<argument value=\"Zork\"/>\n" + "\t\t\t\t\t</arguments>\n" + "\t\t\t\t</problem>\n" + "\t\t\t</problems>\n" + "\t\t\t<classfile path=\"---OUTPUT_DIR_PLACEHOLDER---{0}X.class\"/>\n" + "\t\t</source>\n" + "\t</sources>\n" + "\t<stats>\n" + "\t\t<problem_summary errors=\"1\" infos=\"0\" problems=\"1\" tasks=\"0\" warnings=\"0\"/>\n" + "\t</stats>\n" + "</compiler>\n";
        String normalizedExpectedLogContents = MessageFormat.format(expectedLogContents, File.separator, MAIN.bind("compiler.name"), MAIN.bind("compiler.copyright"), MAIN.bind("compiler.version"));
        String normalizedLogContents = xmlLogsNormalizer.normalized(logContents);
        boolean compareOK = normalizedExpectedLogContents.equals(normalizedLogContents);
        if (!compareOK) {
            System.out.println(String.valueOf(this.getClass().getName()) + '#' + this.getName());
            System.out.println("------------ [START LOG] ------------\n------------- Expected: -------------\n" + expectedLogContents + "\n------------- but was:  -------------\n" + xmlLogsNormalizer.normalized(logContents) + "\n--------- (cut and paste:) ----------\n" + org.eclipse.jdt.core.tests.util.Util.displayString(xmlLogsNormalizer.normalized(logContents)) + "\n------------- [END LOG] -------------\n");
            BatchCompilerTest.assertEquals("Unexpected log contents", normalizedExpectedLogContents, normalizedLogContents);
        }
    }

    public void test014() {
        String logFileName = String.valueOf(OUTPUT_DIR) + File.separator + "log.txt";
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n\tZork z;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -proceedOnError" + " -log \"" + logFileName + "\" -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n1 problem (1 error)\n", false);
        String logContents = org.eclipse.jdt.core.tests.util.Util.fileContent(logFileName);
        String expectedLogContents = "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---" + File.separator + "X.java (at line 3)\n" + "\tZork z;\n" + "\t^^^^\n" + "Zork cannot be resolved to a type\n" + "----------\n" + "1 problem (1 error)\n";
        boolean compareOK = this.semiNormalizedComparison(expectedLogContents, logContents, textLogsNormalizer);
        if (!compareOK) {
            System.out.println(String.valueOf(this.getClass().getName()) + '#' + this.getName());
            System.out.println("------------ [START LOG] ------------\n------------- Expected: -------------\n" + expectedLogContents + "\n------------- but was:  -------------\n" + outputDirNormalizer.normalized(logContents) + "\n--------- (cut and paste:) ----------\n" + org.eclipse.jdt.core.tests.util.Util.displayString(outputDirNormalizer.normalized(logContents)) + "\n------------- [END LOG] -------------\n");
        }
        BatchCompilerTest.assertTrue((String)"unexpected log contents", (boolean)compareOK);
    }

    public void test015() {
        String logFileName = String.valueOf(OUTPUT_DIR) + File.separator + "log";
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n\tZork z;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -proceedOnError" + " -log \"" + logFileName + "\" -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n1 problem (1 error)\n", false);
        String logContents = org.eclipse.jdt.core.tests.util.Util.fileContent(logFileName);
        String expectedLogContents = "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---" + File.separator + "X.java (at line 3)\n" + "\tZork z;\n" + "\t^^^^\n" + "Zork cannot be resolved to a type\n" + "----------\n" + "1 problem (1 error)\n";
        boolean compareOK = this.semiNormalizedComparison(expectedLogContents, logContents, textLogsNormalizer);
        if (!compareOK) {
            System.out.println(String.valueOf(this.getClass().getName()) + '#' + this.getName());
            System.out.println("------------ [START LOG] ------------\n------------- Expected: -------------\n" + expectedLogContents + "\n------------- but was:  -------------\n" + outputDirNormalizer.normalized(logContents) + "\n--------- (cut and paste:) ----------\n" + org.eclipse.jdt.core.tests.util.Util.displayString(outputDirNormalizer.normalized(logContents)) + "\n------------- [END LOG] -------------\n");
        }
        BatchCompilerTest.assertTrue((String)"unexpected log contents", (boolean)compareOK);
    }

    public void test016() {
        String setting = System.getProperty("jdt.compiler.useSingleThread");
        try {
            System.setProperty("jdt.compiler.useSingleThread", "true");
            this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n\tOK1 ok1;\n}", "OK1.java", "/** */\npublic class OK1 {\n\t// empty\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp ." + File.pathSeparator + File.pathSeparator + File.pathSeparator + "\"" + OUTPUT_DIR + "\"" + " -verbose -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", "[parsing    ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[reading    java/lang/Object.class]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[parsing    ---OUTPUT_DIR_PLACEHOLDER---/OK1.java - #2/2]\n[writing    X.class - #1]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/2]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/OK1.java - #2/2]\n[writing    OK1.class - #2]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/OK1.java - #2/2]\n[2 units compiled]\n[2 .class files generated]\n", "", true);
        }
        catch (Throwable throwable) {
            System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
            throw throwable;
        }
        System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n\tOK1 ok1;\n}", "OK1.java", "/** */\npublic class OK1 {\n\t// empty\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp dummmy_dir" + File.pathSeparator + "dummy.jar" + File.pathSeparator + File.pathSeparator + "\"" + OUTPUT_DIR + "\"" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", "", "incorrect classpath: dummmy_dir\n", true);
    }

    public void test017b() {
        this.runTest(true, new String[]{"X.java", "/** */\npublic class X {\n\tOK1 ok1;\n}", "OK1.java", "/** */\npublic class OK1 {\n\t// empty\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp dummy.jar" + File.pathSeparator + File.pathSeparator + "\"" + OUTPUT_DIR + "\"" + " -verbose -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", TWO_FILES_GENERATED_MATCHER, EMPTY_STRING_MATCHER, true);
    }

    public void test017c() {
        this.runTest(true, new String[]{"X.java", "/** */\npublic class X {\n\tOK1 ok1;\n}", "OK1.java", "/** */\npublic class OK1 {\n\t// empty\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp " + File.pathSeparator + File.pathSeparator + "\"" + OUTPUT_DIR + "\"" + " -verbose -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", TWO_FILES_GENERATED_MATCHER, EMPTY_STRING_MATCHER, true);
    }

    public void test018a() {
        String currentWorkingDirectoryPath = System.getProperty("user.dir");
        if (currentWorkingDirectoryPath == null) {
            System.err.println("BatchCompilerTest#18a could not access the current working directory " + currentWorkingDirectoryPath);
        } else if (!new File(currentWorkingDirectoryPath).isDirectory()) {
            System.err.println("BatchCompilerTest#18a current working directory is not a directory " + currentWorkingDirectoryPath);
        } else {
            String xPath = String.valueOf(currentWorkingDirectoryPath) + File.separator + "X.java";
            String ok1Path = String.valueOf(currentWorkingDirectoryPath) + File.separator + "OK1.java";
            try {
                try {
                    File file = new File(xPath);
                    try (PrintWriter sourceFileWriter = new PrintWriter(new FileOutputStream(file));){
                        sourceFileWriter.write("/** */\npublic class X {\n\tOK1 ok1;\n}");
                    }
                    file = new File(ok1Path);
                    sourceFileWriter = new PrintWriter(new FileOutputStream(file));
                    try {
                        sourceFileWriter.write("/** */\npublic class OK1 {\n\t// empty\n}");
                    }
                    finally {
                        sourceFileWriter.close();
                    }
                    this.runTest(true, new String[]{"dummy.java", ""}, "X.java -1.5 -g -preserveAllLocals -verbose -proceedOnError -sourcepath . -d \"" + OUTPUT_DIR + "\"", TWO_FILES_GENERATED_MATCHER, EMPTY_STRING_MATCHER, false);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("BatchCompilerTest#18a could not write to current working directory " + currentWorkingDirectoryPath);
                    new File(xPath).delete();
                    new File(ok1Path).delete();
                }
            }
            finally {
                new File(xPath).delete();
                new File(ok1Path).delete();
            }
        }
    }

    public void _test018b() {
        String currentWorkingDirectoryPath = System.getProperty("user.dir");
        if (currentWorkingDirectoryPath == null) {
            System.err.println("BatchCompilerTest#18b could not access the current working directory " + currentWorkingDirectoryPath);
        } else if (!new File(currentWorkingDirectoryPath).isDirectory()) {
            System.err.println("BatchCompilerTest#18b current working directory is not a directory " + currentWorkingDirectoryPath);
        } else {
            String xPath = String.valueOf(currentWorkingDirectoryPath) + File.separator + "X.java";
            String ok1Path = String.valueOf(currentWorkingDirectoryPath) + File.separator + "OK1.java";
            try {
                try {
                    File file = new File(xPath);
                    PrintWriter sourceFileWriter = new PrintWriter(new FileOutputStream(file));
                    sourceFileWriter.write("/** */\npublic class X {\n\tOK1 ok1;\n}");
                    sourceFileWriter.close();
                    file = new File(ok1Path);
                    sourceFileWriter = new PrintWriter(new FileOutputStream(file));
                    sourceFileWriter.write("/** */\npublic class OK1 {\n\t// empty\n}");
                    sourceFileWriter.close();
                    this.runTest(true, new String[]{"dummy.java", ""}, "X.java -1.5 -g -preserveAllLocals -verbose -proceedOnError -d \"" + OUTPUT_DIR + "\"", TWO_FILES_GENERATED_MATCHER, EMPTY_STRING_MATCHER, false);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println("BatchCompilerTest#18b could not write to current working directory " + currentWorkingDirectoryPath);
                    new File(xPath).delete();
                    new File(ok1Path).delete();
                }
            }
            finally {
                new File(xPath).delete();
                new File(ok1Path).delete();
            }
        }
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n\tOK1 ok1;\n\tOK2 ok2;\n\tWarn warn;\n\tKO ko;\n\tZork z;\n}", "OK1.java", "/** */\npublic class OK1 {\n\t// empty\n}", "OK2.java", "/** */\npublic class OK2 {\n\t// empty\n}", "Warn.java", "/** */\npublic class Warn {\n\t// empty\n}", "KO.java", "/** */\npublic class KO {\n\t// empty\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[+OK2" + File.pathSeparator + "~Warn" + File.pathSeparator + "-KO]\"" + " -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tWarn warn;\n\t^^^^\nDiscouraged access: The type 'Warn' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tKO ko;\n\t^^\nAccess restriction: The type 'KO' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3 problems (1 error, 2 warnings)\n", true);
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -verbose -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\" -O -Xxxx -O -Jxyz -Xtyu -Jyu", "[parsing    ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[reading    java/lang/Object.class]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[writing    X.class - #1]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/X.java - #1/1]\n[1 unit compiled]\n[1 .class file generated]\n", "", true);
    }

    public void test021() {
        String setting = System.getProperty("jdt.compiler.useSingleThread");
        try {
            System.setProperty("jdt.compiler.useSingleThread", "true");
            this.runConformTest(new String[]{"src1/X.java", "/** */\npublic class X {\n}", "src2/Y.java", "/** */\npublic class Y extends X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src2/Y.java\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src1\"" + File.pathSeparator + "\"" + OUTPUT_DIR + File.separator + "src2\"" + " -1.5 -g -preserveAllLocals" + " -verbose -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\" ", "[parsing    ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java - #1/1]\n[parsing    ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #2/2]\n[reading    java/lang/Object.class]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java - #1/2]\n[writing    Y.class - #1]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java - #1/2]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #2/2]\n[writing    X.class - #2]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #2/2]\n[2 units compiled]\n[2 .class files generated]\n", "", true);
        }
        catch (Throwable throwable) {
            System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
            throw throwable;
        }
        System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
    }

    public void test022_repeated_sourcepath() {
        this.runNegativeTest(new String[]{"src1/X.java", "/** */\npublic class X {\n}", "src2/Y.java", "/** */\npublic class Y extends X {\n}"}, " -sourcepath \"" + OUTPUT_DIR + File.separator + "src1\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src2\"" + " \"" + OUTPUT_DIR + File.separator + "src2/Y.java\"" + " -1.5 -g -preserveAllLocals" + " -verbose -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\" ", "", "duplicate sourcepath specification: -sourcepath ---OUTPUT_DIR_PLACEHOLDER---/src2\n", true);
    }

    public void test023() {
        this.runNegativeTest(new String[]{"src1/X.java", "/** */\npublic class X {\n}", "src2/Y.java", "/** */\npublic class Y extends X {\n}"}, " -extdirs \"" + OUTPUT_DIR + File.separator + "src1\"" + " -extdirs \"" + OUTPUT_DIR + File.separator + "src2\"" + " \"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -verbose -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\" ", "", "duplicate extdirs specification: -extdirs ---OUTPUT_DIR_PLACEHOLDER---/src2\n", true);
    }

    public void test024() {
        if (!System.getProperty("java.vm.vendor").equals("Sun Microsystems Inc.")) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n  sun.net.spi.nameservice.dns.DNSNameService dummy;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -extdirs \"\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tsun.net.spi.nameservice.dns.DNSNameService dummy;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^\nsun.net.spi.nameservice.dns cannot be resolved to a type\n----------\n1 problem (1 error)\n", true);
    }

    public void test025() throws Exception {
        String path = LIB_DIR;
        String libPath = null;
        libPath = path.endsWith(File.separator) ? String.valueOf(path) + "lib.jar" : String.valueOf(path) + File.separator + "lib.jar";
        String setting = System.getProperty("jdt.compiler.useSingleThread");
        try {
            org.eclipse.jdt.core.tests.util.Util.createJar(new String[]{"my/pkg/Zork.java", "package my.pkg;\npublic class Zork {\n}"}, libPath, "1.4");
            System.setProperty("jdt.compiler.useSingleThread", "true");
            this.runConformTest(new String[]{"src1/X.java", "/** */\npublic class X {\n  my.pkg.Zork dummy;\n}", "src2/Y.java", "/** */\npublic class Y extends X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src2/Y.java\"" + " -extdirs \"" + path + File.pathSeparator + OUTPUT_DIR + File.separator + "src1\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src1\"" + " -1.5 -g -preserveAllLocals" + " -verbose -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\" ", "[parsing    ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java - #1/1]\n[parsing    ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #2/2]\n[reading    java/lang/Object.class]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java - #1/2]\n[writing    Y.class - #1]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java - #1/2]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #2/2]\n[reading    my/pkg/Zork.class]\n[writing    X.class - #2]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #2/2]\n[2 units compiled]\n[2 .class files generated]\n", "", true);
        }
        catch (Throwable throwable) {
            System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
            org.eclipse.jdt.core.tests.util.Util.delete(libPath);
            throw throwable;
        }
        System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
        org.eclipse.jdt.core.tests.util.Util.delete(libPath);
    }

    public void test026() {
        String setting = System.getProperty("jdt.compiler.useSingleThread");
        try {
            System.setProperty("jdt.compiler.useSingleThread", "true");
            this.runConformTest(new String[]{"src1/X.java", "/** */\npublic class X {\n}", "src2/Y.java", "/** */\npublic class Y extends X {\n}", "src3/X.java", "/** */\npublic class X {\n  Zork error;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src2/Y.java\"" + " -classpath \"" + OUTPUT_DIR + File.separator + "src3\"" + " -extdirs \"" + this.getExtDirectory() + File.pathSeparator + OUTPUT_DIR + File.separator + "src1\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src2" + File.pathSeparator + OUTPUT_DIR + File.separator + "src1\"" + " -1.5 -g -preserveAllLocals" + " -verbose -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\" ", "[parsing    ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java - #1/1]\n[parsing    ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #2/2]\n[reading    java/lang/Object.class]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java - #1/2]\n[writing    Y.class - #1]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java - #1/2]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #2/2]\n[writing    X.class - #2]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #2/2]\n[2 units compiled]\n[2 .class files generated]\n", "", true);
        }
        catch (Throwable throwable) {
            System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
            throw throwable;
        }
        System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n\tOK1 ok1;\n\tOK2 ok2;\n\tWarn warn;\n\tKO ko;\n\tZork z;\n}", "OK1.java", "/** */\npublic class OK1 {\n\t// empty\n}", "OK2.java", "/** */\npublic class OK2 {\n\t// empty\n}", "p1/Warn.java", "/** */\npublic class Warn {\n\t// empty\n}", "KO.java", "/** */\npublic class KO {\n\t// empty\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[+OK2" + File.pathSeparator + "-KO]" + File.pathSeparator + OUTPUT_DIR + File.separator + "p1[~Warn]\"" + " -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tWarn warn;\n\t^^^^\nDiscouraged access: The type 'Warn' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---/p1')\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tKO ko;\n\t^^\nAccess restriction: The type 'KO' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3 problems (1 error, 2 warnings)\n", true);
    }

    public void test028() {
        this.runConformTest(new String[]{"src1/X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src1/X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin/\"", "", "", true);
        this.runConformTest(new String[]{"src2/Y.java", "/** */\npublic class Y extends X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src2/Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp dummy" + File.pathSeparator + "\"" + OUTPUT_DIR + File.separator + "bin\"" + File.pathSeparator + "dummy" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin/\"", "", "incorrect classpath: dummy\nincorrect classpath: dummy\n", false);
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "public interface X<T extends X<T, K, S>, \n                   K extends X.K<T, S>, \n                   S extends X.S> {\n\tpublic interface K<KT extends X<KT, ?, KS>, \n\t                   KS extends X.S> {\n\t}\n\tpublic interface S {\n\t}\n}\n", "Y.java", "public class Y<T extends X<T, K, S>, \n               K extends X.K<T, S>, \n               S extends X.S> { \n}\n"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + File.separator + "\"" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[]{"X.java", "public interface X<T extends X<T, K, S>, \n                   K extends X.K<T, S>, \n                   S extends X.S> {\n\tpublic interface K<KT extends X<KT, ?, KS>, \n\t                   KS extends X.S> {\n\t}\n\tpublic interface S {\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[]{"Y.java", "public class Y<T extends X<T, K, S>, \n               K extends X.K<T, S>, \n               S extends X.S> { \n}\n"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + File.separator + "\"" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test032() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport java.io.Serializable;\npublic interface X<T extends X<T, U, V>, \n\t\t\t\t   U extends X.XX<T, V>, \n\t\t\t\t   V extends X.XY> {\n\tpublic interface XX<TT extends X<TT, ?, UU>, \n\t                    UU extends X.XY> \n\t\t\textends\tSerializable {\n\t}\n\tpublic interface XY extends Serializable {\n\t}\n}\n", "p/Y.java", "package p;\nimport java.util.*;\nimport p.X.*;\npublic class Y<T extends X<T, U, V>, \n               U extends X.XX<T, V>, \n               V extends X.XY> {\n\tprivate final Map<U, V> m1 = new HashMap<U, V>();\n\tprivate final Map<U, T> m2 = new HashMap<U, T>();\n\tprivate final Z m3;\n\n\tpublic Y(final Z p1) {\n\t\tthis.m3 = p1;\n\t}\n\n\tpublic void foo1(final U p1, final V p2, final T p3) {\n\t\tm1.put(p1, p2);\n\t\tm2.put(p1, p3);\n\t\tm3.foo2(p1, p2);\n\t}\n\n\tpublic void foo3(final U p1) {\n\t\tassert m1.containsKey(p1);\n\t\tm1.remove(p1);\n\t\tm2.remove(p1);\n\t\tm3.foo2(p1, null);\n\t}\n\n\tpublic Collection<T> foo4() {\n\t\treturn Collections.unmodifiableCollection(m2.values());\n\t}\n\n\tpublic void foo5(final Map<XX<?, ?>, XY> p1) {\n\t\tp1.putAll(m1);\n\t}\n\tpublic void foo6(final Map<XX<?, ?>, XY> p1) {\n\t\tm1.keySet().retainAll(p1.keySet());\n\t\tm2.keySet().retainAll(p1.keySet());\n\t}\n}\n", "p/Z.java", "package p;\n\nimport java.util.*;\n\nimport p.X.*;\n\npublic class Z {\n\tprivate final Map<Class<? extends X>, \n\t\t              Y<?, ? extends XX<?, ?>, ? extends XY>> \n\t\tm1 = new HashMap<Class<? extends X>, \n\t\t                 Y<?, ? extends XX<?, ?>, ? extends XY>>();\n\n\tprivate Map<X.XX<?, XY>, \n\t            X.XY> \n\t\tm2 = new HashMap<X.XX<?, XY>, \n\t\t                 X.XY>();\n\n\tpublic <T extends X<T, U, V>, \n\t        U extends X.XX<T, V>, \n\t        V extends X.XY> \n\tY<T, U, V> foo1(final Class<T> p1) {\n\t\tY l1 = m1.get(p1);\n\t\tif (l1 == null) {\n\t\t\tl1 = new Y<T, U, V>(this);\n\t\t\tm1.put(p1, l1);\n\t\t}\n\t\treturn l1;\n\t}\n\n\tpublic <TT extends X.XX<?, UU>, \n\t        UU extends X.XY> \n\tvoid foo2(final TT p1, final UU p2) {\n\t\tm2.put((XX<?, XY>) p1, p2);\n\t}\n\n\tpublic Map<XX<?, ?>, XY> foo3() {\n\t\tfinal Map<XX<?, ?>, \n\t\t          XY> l1 = new HashMap<XX<?, ?>, \n\t\t                               XY>();\n\t\tfor (final Y<?, \n\t\t\t\t     ? extends XX<?, ?>, \n\t\t\t\t     ? extends XY> \n\t\t\t\ti : m1.values()) {\n\t\t\ti.foo5(l1);\n\t\t}\n\t\treturn l1;\n\t}\n\n\tpublic void foo4(final Object p1, final Map<XX<?, ?>, \n\t\t\t                                    XY> p2) {\n\t\tfor (final Y<?, \n\t\t\t\t     ? extends XX<?, ?>, \n\t\t\t\t     ? extends XY> i : m1.values()) {\n\t\t\ti.foo6(p2);\n\t\t}\n\t\tfor (final Map.Entry<XX<?, ?>, \n\t\t\t\t             XY> i : p2.entrySet()) {\n\t\t\tfinal XX<?, XY> l1 = (XX<?, XY>) i.getKey();\n\t\t}\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p/X.java\"" + " \"" + OUTPUT_DIR + File.separator + "p/Y.java\"" + " \"" + OUTPUT_DIR + File.separator + "p/Z.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + File.separator + "\"" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 8)\n\tprivate final Map<Class<? extends X>, \n\t                                  ^\nX is a raw type. References to generic type X<T,U,V> should be parameterized\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 10)\n\tm1 = new HashMap<Class<? extends X>, \n\t                                 ^\nX is a raw type. References to generic type X<T,U,V> should be parameterized\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 22)\n\tY l1 = m1.get(p1);\n\t^\nY is a raw type. References to generic type Y<T,U,V> should be parameterized\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 25)\n\tm1.put(p1, l1);\n\t           ^^\nType safety: The expression of type Y needs unchecked conversion to conform to Y<?,? extends X.XX<?,?>,? extends X.XY>\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 27)\n\treturn l1;\n\t       ^^\nType safety: The expression of type Y needs unchecked conversion to conform to Y<T,U,V>\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 33)\n\tm2.put((XX<?, XY>) p1, p2);\n\t       ^^^^^^^^^^^^^^\nType safety: Unchecked cast from TT to X.XX<?,X.XY>\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 58)\n\tfinal XX<?, XY> l1 = (XX<?, XY>) i.getKey();\n\t                ^^\nThe value of the local variable l1 is not used\n----------\n8. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 58)\n\tfinal XX<?, XY> l1 = (XX<?, XY>) i.getKey();\n\t                     ^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X.XX<capture#22-of ?,capture#23-of ?> to X.XX<?,X.XY>\n----------\n8 problems (8 warnings)\n", true);
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport java.io.Serializable;\npublic interface X<T extends X<T, U, V>, \n\t\t\t\t   U extends X.XX<T, V>, \n\t\t\t\t   V extends X.XY> {\n\tpublic interface XX<TT extends X<TT, ?, UU>, \n\t                    UU extends X.XY> \n\t\t\textends\tSerializable {\n\t}\n\tpublic interface XY extends Serializable {\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p/X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[]{"p/Y.java", "package p;\nimport java.util.*;\nimport p.X.*;\npublic class Y<T extends X<T, U, V>, \n               U extends X.XX<T, V>, \n               V extends X.XY> {\n\tprivate final Map<U, V> m1 = new HashMap<U, V>();\n\tprivate final Map<U, T> m2 = new HashMap<U, T>();\n\tprivate final Z m3;\n\n\tpublic Y(final Z p1) {\n\t\tthis.m3 = p1;\n\t}\n\n\tpublic void foo1(final U p1, final V p2, final T p3) {\n\t\tm1.put(p1, p2);\n\t\tm2.put(p1, p3);\n\t\tm3.foo2(p1, p2);\n\t}\n\n\tpublic void foo3(final U p1) {\n\t\tassert m1.containsKey(p1);\n\t\tm1.remove(p1);\n\t\tm2.remove(p1);\n\t\tm3.foo2(p1, null);\n\t}\n\n\tpublic Collection<T> foo4() {\n\t\treturn Collections.unmodifiableCollection(m2.values());\n\t}\n\n\tpublic void foo5(final Map<XX<?, ?>, XY> p1) {\n\t\tp1.putAll(m1);\n\t}\n\tpublic void foo6(final Map<XX<?, ?>, XY> p1) {\n\t\tm1.keySet().retainAll(p1.keySet());\n\t\tm2.keySet().retainAll(p1.keySet());\n\t}\n}\n", "p/Z.java", "package p;\n\nimport java.util.*;\n\nimport p.X.*;\n\npublic class Z {\n\tprivate final Map<Class<? extends X>, \n\t\t              Y<?, ? extends XX<?, ?>, ? extends XY>> \n\t\tm1 = new HashMap<Class<? extends X>, \n\t\t                 Y<?, ? extends XX<?, ?>, ? extends XY>>();\n\n\tprivate Map<X.XX<?, XY>, \n\t            X.XY> \n\t\tm2 = new HashMap<X.XX<?, XY>, \n\t\t                 X.XY>();\n\n\tpublic <T extends X<T, U, V>, \n\t        U extends X.XX<T, V>, \n\t        V extends X.XY> \n\tY<T, U, V> foo1(final Class<T> p1) {\n\t\tY l1 = m1.get(p1);\n\t\tif (l1 == null) {\n\t\t\tl1 = new Y<T, U, V>(this);\n\t\t\tm1.put(p1, l1);\n\t\t}\n\t\treturn l1;\n\t}\n\n\tpublic <TT extends X.XX<?, UU>, \n\t        UU extends X.XY> \n\tvoid foo2(final TT p1, final UU p2) {\n\t\tm2.put((XX<?, XY>) p1, p2);\n\t}\n\n\tpublic Map<XX<?, ?>, XY> foo3() {\n\t\tfinal Map<XX<?, ?>, \n\t\t          XY> l1 = new HashMap<XX<?, ?>, \n\t\t                               XY>();\n\t\tfor (final Y<?, \n\t\t\t\t     ? extends XX<?, ?>, \n\t\t\t\t     ? extends XY> \n\t\t\t\ti : m1.values()) {\n\t\t\ti.foo5(l1);\n\t\t}\n\t\treturn l1;\n\t}\n\n\tpublic void foo4(final Object p1, final Map<XX<?, ?>, \n\t\t\t                                    XY> p2) {\n\t\tfor (final Y<?, \n\t\t\t\t     ? extends XX<?, ?>, \n\t\t\t\t     ? extends XY> i : m1.values()) {\n\t\t\ti.foo6(p2);\n\t\t}\n\t\tfor (final Map.Entry<XX<?, ?>, \n\t\t\t\t             XY> i : p2.entrySet()) {\n\t\t\tfinal XX<?, XY> l1 = (XX<?, XY>) i.getKey();\n\t\t}\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p/Y.java\"" + " \"" + OUTPUT_DIR + File.separator + "p/Z.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + File.separator + "\"" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 8)\n\tprivate final Map<Class<? extends X>, \n\t                                  ^\nX is a raw type. References to generic type X<T,U,V> should be parameterized\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 10)\n\tm1 = new HashMap<Class<? extends X>, \n\t                                 ^\nX is a raw type. References to generic type X<T,U,V> should be parameterized\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 22)\n\tY l1 = m1.get(p1);\n\t^\nY is a raw type. References to generic type Y<T,U,V> should be parameterized\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 25)\n\tm1.put(p1, l1);\n\t           ^^\nType safety: The expression of type Y needs unchecked conversion to conform to Y<?,? extends X.XX<?,?>,? extends X.XY>\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 27)\n\treturn l1;\n\t       ^^\nType safety: The expression of type Y needs unchecked conversion to conform to Y<T,U,V>\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 33)\n\tm2.put((XX<?, XY>) p1, p2);\n\t       ^^^^^^^^^^^^^^\nType safety: Unchecked cast from TT to X.XX<?,X.XY>\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 58)\n\tfinal XX<?, XY> l1 = (XX<?, XY>) i.getKey();\n\t                ^^\nThe value of the local variable l1 is not used\n----------\n8. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/Z.java (at line 58)\n\tfinal XX<?, XY> l1 = (XX<?, XY>) i.getKey();\n\t                     ^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from X.XX<capture#22-of ?,capture#23-of ?> to X.XX<?,X.XY>\n----------\n8 problems (8 warnings)\n", false);
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "\"" + File.pathSeparator + " -repeat 2 -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "[repetition 1/2]\n[repetition 2/2]\n", "", true);
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp " + File.pathSeparator + "\"" + OUTPUT_DIR + "\"" + File.pathSeparator + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test035() {
        String javaClassspath = System.getProperty("java.class.path");
        String javaUserDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", OUTPUT_DIR);
            this.runConformTest(new String[]{"p/Y.java", "package p;\npublic class Y { public static final String S = \"\"; }"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "", true);
            System.setProperty("java.class.path", "");
            this.runConformTest(new String[]{"X.java", "import p.Y;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(Y.S);\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "no classpath defined, using default directory instead\n", false);
            String userDir = System.getProperty("user.dir");
            File f = new File(userDir, "X.java");
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f)) {
                System.out.println("Could not delete X");
            }
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f = new File(userDir, "p" + File.separator + "Y.java"))) {
                System.out.println("Could not delete Y");
            }
        }
        finally {
            System.setProperty("java.class.path", javaClassspath);
            System.setProperty("user.dir", javaUserDir);
        }
    }

    public void test036() {
        this.runConformTest(new String[]{"src1/p/X.java", "package p;\n/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + "/src1/p/X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "/bin1/\"", "", "", true);
        this.runConformTest(new String[]{"src2/Y.java", "/** */\npublic class Y extends p.X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src2/Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + File.separator + "bin1[~**/X]\"" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin2/\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java (at line 2)\n\tpublic class Y extends p.X {\n\t                       ^^^\nDiscouraged access: The type 'X' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---/bin1')\n----------\n1 problem (1 warning)\n", false);
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(int i, final int j) {\n    i =  0; // warning\n    j =  0; // error\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 " + " -cp \"" + OUTPUT_DIR + "\"" + " -warn:+paramAssign" + " -proceedOnError" + " -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\ti =  0; // warning\n\t^\nThe parameter i should not be assigned\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tj =  0; // error\n\t^\nThe final local variable j cannot be assigned. It must be blank and not using a compound assignment\n----------\n2 problems (1 error, 1 warning)\n", true);
    }

    public void test039() {
        this.runConformTest(new String[]{"src1/p/X.java", "package p;\npublic class X<T> {\n\tT m;\n}"}, "\"" + OUTPUT_DIR + "/src1/p/X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + "/bin1/\"", "", "", true);
        this.runConformTest(new String[]{"src2/Y.java", "package p;\npublic class Y {\n\tX x1;\n\tX<String> x2 = new X<String>();\n}"}, "\"" + OUTPUT_DIR + File.separator + "src2/Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + File.separator + "bin1[~**/X]\"" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin2/\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java (at line 3)\n\tX x1;\n\t^\nDiscouraged access: The type 'X<T>' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---/bin1')\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java (at line 3)\n\tX x1;\n\t^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java (at line 4)\n\tX<String> x2 = new X<String>();\n\t^\nDiscouraged access: The type 'X<String>' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---/bin1')\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java (at line 4)\n\tX<String> x2 = new X<String>();\n\t               ^^^^^^^^^^^^^^^\nDiscouraged access: The constructor 'X<String>()' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---/bin1')\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java (at line 4)\n\tX<String> x2 = new X<String>();\n\t                   ^\nDiscouraged access: The type 'X<String>' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---/bin1')\n----------\n5 problems (5 warnings)\n", false);
    }

    public void test040() {
        this.runConformTest(new String[]{"p/X.java", "package p;\n/** */\npublic class X {\n}", "p/Z.java", "package p;\n/** */\npublic class Z {\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " \"" + OUTPUT_DIR + File.separator + "p" + File.separator + "Z.java\"" + " -1.5 -g -preserveAllLocals" + " -nowarn" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[]{"Y.java", "/** */\npublic class Y {\n  p.X x;\n  p.Z z;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[+p/X" + File.pathSeparator + "-p/*]\"" + " -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/Y.java (at line 4)\n\tp.Z z;\n\t^^^\nAccess restriction: The type 'Z' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n1 problem (1 warning)\n", false);
    }

    public void test041() {
        this.runConformTest(new String[]{"p/X.java", "package p;\n/** */\npublic class X {\n}", "p/Z.java", "package p;\n/** */\npublic class Z {\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " \"" + OUTPUT_DIR + File.separator + "p" + File.separator + "Z.java\"" + " -1.5 -g -preserveAllLocals" + " -nowarn" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[]{"Y.java", "/** */\npublic class Y {\n  p.X x;\n  p.Z z;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[~p/X" + File.pathSeparator + "-p/*]\"" + " -warn:-discouraged -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/Y.java (at line 4)\n\tp.Z z;\n\t^^^\nAccess restriction: The type 'Z' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n1 problem (1 warning)\n", false);
    }

    public void test042() {
        this.runConformTest(new String[]{"p/X.java", "package p;\n/** */\npublic class X {\n}", "p/Z.java", "package p;\n/** */\npublic class Z {\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " \"" + OUTPUT_DIR + File.separator + "p" + File.separator + "Z.java\"" + " -1.5 -g -preserveAllLocals" + " -nowarn" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[]{"Y.java", "/** */\npublic class Y {\n  p.X x;\n  p.Z z;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[~p/X" + File.pathSeparator + "-p/*]\"" + " -warn:-forbidden -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/Y.java (at line 3)\n\tp.X x;\n\t^^^\nDiscouraged access: The type 'X' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n1 problem (1 warning)\n", false);
    }

    public void test043() {
        this.runConformTest(new String[]{"p/X.java", "package p;\n/** */\npublic class X {\n}", "p/Z.java", "package p;\n/** */\npublic class Z {\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " \"" + OUTPUT_DIR + File.separator + "p" + File.separator + "Z.java\"" + " -1.5 -g -preserveAllLocals" + " -nowarn" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[]{"Y.java", "/** */\npublic class Y {\n  p.X x;\n  p.Z z;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[~p/X" + File.pathSeparator + "-p/*]\"" + " -warn:-discouraged,forbidden -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    Object o = null;\n    o.toString();\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + " -cp " + this.getJCEJarAsQuotedString() + " -warn:+null" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\to.toString();\n\t^\nNull pointer access: The variable o can only be null at this location\n----------\n1 problem (1 warning)\n", true);
    }

    public void test045() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    Object o = null;\n    o.toString();\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + " -cp " + this.getJCEJarAsQuotedString() + " -warn:-null" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test046() {
        this.runConformTest(new String[]{"p/X.java", "package p;\n/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -nowarn" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[]{"Y.java", "/** */\n@SuppressWarnings(\"all\")\npublic class Y {\n  p.X x;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[~p/X" + File.pathSeparator + "-p/*]\"" + " -warn:+discouraged,forbidden,deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test047() {
        this.runConformTest(new String[]{"p/X.java", "package p;\n/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -nowarn" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[]{"Y.java", "/** */\n@SuppressWarnings(\"restriction\")\npublic class Y {\n  p.X x;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[~p/X" + File.pathSeparator + "-p/*]\"" + " -warn:+discouraged,forbidden,deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test048() {
        this.runConformTest(new String[]{"p/X.java", "package p;\n/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -nowarn" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[]{"Y.java", "/** */\n@SuppressWarnings(\"deprecation\")\npublic class Y {\n  p.X x;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[~p/X" + File.pathSeparator + "-p/*]\"" + " -warn:+discouraged,forbidden,deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/Y.java (at line 2)\n\t@SuppressWarnings(\"deprecation\")\n\t                  ^^^^^^^^^^^^^\nUnnecessary @SuppressWarnings(\"deprecation\")\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/Y.java (at line 4)\n\tp.X x;\n\t^^^\nDiscouraged access: The type 'X' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n2 problems (2 warnings)\n", false);
    }

    public void test049() {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n        case 1:\n            System.out.println(1); // possible fall-through\n        }\n    }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -nowarn" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n        case 1:\n            System.out.println(1); // possible fall-through\n        }\n    }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -warn:-fallthrough" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test051() {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n        case 1:\n            System.out.println(1); // complain: possible fall-through\n        }\n    }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -warn:+fallthrough" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case. If intended, add a new comment //$FALL-THROUGH$ on the line above\n----------\n1 problem (1 warning)\n", true);
    }

    public void test052() {
        try {
            new File(OUTPUT_DIR).mkdirs();
            File barFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "Bar.java");
            try (FileOutputStream barOutput = new FileOutputStream(barFile);){
                String barContents = "public class Bar\t\n{\t\n  Bar(int class)\t\n  {\t\n  }\t\n}\n";
                barOutput.write(barContents.getBytes());
            }
        }
        catch (IOException iOException) {}
        this.runNegativeTest(new String[]{"X.java", "public class X\n{\n  static Object x()\n  {\n    return new Bar(5);\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -cp \"" + OUTPUT_DIR + File.pathSeparator + "\"" + " -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\treturn new Bar(5);\n\t       ^^^^^^^^^^\nThe constructor Bar(int) is undefined\n----------\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/Bar.java (at line 2)\n\t{\t\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/Bar.java (at line 3)\n\tBar(int class)\t\n\t        ^^^^^\nSyntax error on token \"class\", invalid VariableDeclaratorId\n----------\n4. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/Bar.java (at line 3)\n\tBar(int class)\t\n  {\t\n  }\t\n\t        ^^^^^^^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n5. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/Bar.java (at line 6)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n5 problems (5 errors)\n", false);
    }

    public void test053() {
        this.runConformTest(new String[]{"X.java", "public class X {}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -d \"" + OUTPUT_DIR + File.separator + "X.java\"", "", "No .class file created for file X.class in ---OUTPUT_DIR_PLACEHOLDER---/X.java because of an IOException: Regular file ---OUTPUT_DIR_PLACEHOLDER---/X.java cannot be used as output directory\n", true);
    }

    public void test054() {
        this.runConformTest(new String[]{"X.java", "public class X {}", "f", ""}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -d \"" + OUTPUT_DIR + "/f/out\"", "", "No .class file created for file X.class in ---OUTPUT_DIR_PLACEHOLDER---/f/out because of an IOException: Could not create output directory ---OUTPUT_DIR_PLACEHOLDER---/f/out\n", true);
    }

    public void test055() {
        if (File.separatorChar == '/') {
            String tentativeOutputDirNameTail = String.valueOf(File.separator) + "out";
            File outputDirectory = new File(String.valueOf(OUTPUT_DIR) + tentativeOutputDirNameTail);
            outputDirectory.mkdirs();
            outputDirectory.setReadOnly();
            this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {}"}, "\"" + OUTPUT_DIR + File.separator + "p/X.java\"" + " -1.5 -g -preserveAllLocals" + " -d \"" + OUTPUT_DIR + "/out\"", "", "No .class file created for file p/X.class in ---OUTPUT_DIR_PLACEHOLDER---/out because of an IOException: Could not create subdirectory p into output directory ---OUTPUT_DIR_PLACEHOLDER---/out\n", false);
        }
    }

    public void test056() {
        String tentativeOutputDirNameTail = String.valueOf(File.separator) + "out";
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {}", "out/p", ""}, "\"" + OUTPUT_DIR + File.separator + "p/X.java\"" + " -1.5 -g -preserveAllLocals" + " -d \"" + OUTPUT_DIR + tentativeOutputDirNameTail + "\"", "", "No .class file created for file p/X.class in ---OUTPUT_DIR_PLACEHOLDER---/out because of an IOException: Regular file ---OUTPUT_DIR_PLACEHOLDER---/out/p cannot be used as output directory\n", true);
    }

    public void test057_access_restrictions_separator() {
        String oppositeSeparator = File.pathSeparatorChar == ':' ? ";" : ":";
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n\tOK1 ok1;\n\tOK2 ok2;\n\tKO ko;\n}", "OK1.java", "/** */\npublic class OK1 {\n\t// empty\n}", "OK2.java", "/** */\npublic class OK2 {\n\t// empty\n}", "KO.java", "/** */\npublic class KO {\n\t// empty\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[+OK2" + oppositeSeparator + "-KO]\"" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test058() {
        File outputDirectory = new File(String.valueOf(OUTPUT_DIR) + File.separator + "foo.java");
        outputDirectory.mkdirs();
        this.runConformTest(new String[]{"X.java", "public class X {}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -d \"" + OUTPUT_DIR + "/out\"", "", "", false);
    }

    public void test060() {
        File outputDirectory = new File(String.valueOf(OUTPUT_DIR) + File.separator + "foo.java");
        outputDirectory.mkdirs();
        this.runConformTest(new String[]{"X.java", "public class X {}"}, "\"" + OUTPUT_DIR + "\"" + " -1.5 -g -preserveAllLocals" + " -d \"" + OUTPUT_DIR + "/out\"", "", "", false);
    }

    public void test061() {
        File outputDirectory = new File(String.valueOf(OUTPUT_DIR) + File.separator + "foo.java");
        outputDirectory.mkdirs();
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  foo m;\n}"}, "\"" + OUTPUT_DIR + "\"" + " -1.5 -g -preserveAllLocals" + " -d \"" + OUTPUT_DIR + "/out\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tfoo m;\n\t^^^\nfoo cannot be resolved to a type\n----------\n1 problem (1 error)\n", false);
    }

    public void _test062() {
        String outputDirName = String.valueOf(OUTPUT_DIR) + File.separator + "d";
        String metaInfDirName = String.valueOf(outputDirName) + File.separator + "META-INF";
        String jarFileName = String.valueOf(outputDirName) + File.separator + "L.jar";
        this.runConformTest(new String[]{"d/Y.java", "public class Y {\n}"}, "\"" + outputDirName + "\"" + " -1.5 -g -preserveAllLocals" + " -d \"" + outputDirName + "\"", "", "", true);
        File outputDirectory = new File(outputDirName);
        File metaInfDirectory = new File(metaInfDirName);
        metaInfDirectory.mkdirs();
        try {
            org.eclipse.jdt.core.tests.util.Util.createFile(String.valueOf(metaInfDirName) + File.separator + "MANIFEST.MF", "Manifest-Version: 1.0\nClass-Path: ../d/L.jar\n");
        }
        catch (IOException iOException) {
            BatchCompilerTest.fail((String)"could not create manifest file");
        }
        try {
            org.eclipse.jdt.core.tests.util.Util.zip(outputDirectory, jarFileName);
        }
        catch (IOException iOException) {
            BatchCompilerTest.fail((String)"could not create jar file");
        }
        org.eclipse.jdt.core.tests.util.Util.delete(String.valueOf(outputDirName) + File.separator + "Y.class");
        org.eclipse.jdt.core.tests.util.Util.delete(String.valueOf(outputDirName) + File.separator + "Y.java");
        this.runConformTest(new String[]{"d/X.java", "public class X {\n  Y m;\n}"}, "\"" + outputDirName + "\"" + " -1.5 -g -preserveAllLocals" + " -cp L.jar" + " -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test063() {
        String outputDirName = String.valueOf(OUTPUT_DIR) + File.separator + "d";
        String metaInfDirName = String.valueOf(outputDirName) + File.separator + "META-INF";
        String jarFileName = String.valueOf(outputDirName) + File.separator + "L.jar";
        this.runConformTest(new String[]{"d/Y.java", "public class Y {\n}"}, "\"" + outputDirName + "\"" + " -1.5 -g -preserveAllLocals" + " -d \"" + outputDirName + "\"", "", "", true);
        File outputDirectory = new File(outputDirName);
        File metaInfDirectory = new File(metaInfDirName);
        metaInfDirectory.mkdirs();
        try {
            org.eclipse.jdt.core.tests.util.Util.createFile(String.valueOf(metaInfDirName) + File.separator + "MANIFEST.MF", "Manifest-Version: 1.0\nClass-Path: ../d/L.jar\n");
        }
        catch (IOException iOException) {
            BatchCompilerTest.fail((String)"could not create manifest file");
        }
        try {
            org.eclipse.jdt.core.tests.util.Util.zip(outputDirectory, jarFileName);
        }
        catch (IOException iOException) {
            BatchCompilerTest.fail((String)"could not create jar file");
        }
        org.eclipse.jdt.core.tests.util.Util.delete(String.valueOf(outputDirName) + File.separator + "Y.class");
        org.eclipse.jdt.core.tests.util.Util.delete(String.valueOf(outputDirName) + File.separator + "Y.java");
        this.runConformTest(new String[]{"d/X.java", "public class X {\n  Y m;\n}"}, "\"" + outputDirName + "\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + jarFileName + "\"" + " -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void _test064_per_sourcepath_directory_default_encoding() {
        String source1 = "src1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + source1 + "[UTF-8]\"", "", "", true);
    }

    public void test065_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + " -d \"" + OUTPUT_DIR + File.separator + output1 + "\"", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test066_per_source_output_directory() {
        String source1 = "src1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + source1 + "\"", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test067_per_source_output_directory() {
        this.runConformTest(new String[]{"X.java", "public class X {}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5" + " -d none", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test068_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        String output2 = "bin2";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -d \"" + OUTPUT_DIR + File.separator + output2 + "\"", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test069_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test070_per_source_output_directory() {
        String source1 = "src1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d none]", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test071_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -d none", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test072_per_source_output_directory() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + "\"" + "[-d dir][~**/internal/*]", "", "access rules cannot follow destination path entries: ---OUTPUT_DIR_PLACEHOLDER---[-d dir][~**/internal/*]\n", true);
    }

    public void test073_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-**/*][-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/Z.java (at line 2)\n\tX f;\n\t^\nAccess restriction: The type 'X' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---/src1')\n----------\n1 problem (1 warning)\n", true);
    }

    public void test074_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        String output2 = "bin2";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -classpath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -d \"" + OUTPUT_DIR + File.separator + output2 + "\"", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test075_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -cp \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test076_per_source_output_directory() {
        String source1 = "src1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -classpath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d none]", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test077_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -classpath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -d none", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test078_per_source_output_directory() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5" + " -classpath \"" + OUTPUT_DIR + "\"" + "[-d dir][~**/internal/*]", "", "access rules cannot follow destination path entries: ---OUTPUT_DIR_PLACEHOLDER---[-d dir][~**/internal/*]\n", true);
    }

    public void test079_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -classpath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-**/*][-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/Z.java (at line 2)\n\tX f;\n\t^\nAccess restriction: The type 'X' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---/src1')\n----------\n1 problem (1 warning)\n", true);
    }

    public void test080_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        String output2 = "bin2";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + File.pathSeparator + "\"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -d \"" + OUTPUT_DIR + File.separator + output2 + "\"", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test081_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + File.pathSeparator + "\"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test082_per_source_output_directory() {
        String source1 = "src1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + File.pathSeparator + "\"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d none]", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test083_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + File.pathSeparator + "\"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -d none", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + File.separator + "Z.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test084_per_source_output_directory() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5" + " -bootclasspath \"" + OUTPUT_DIR + "\"" + "[-d dir][~**/internal/*]", "", "access rules cannot follow destination path entries: ---OUTPUT_DIR_PLACEHOLDER---[-d dir][~**/internal/*]\n", true);
    }

    public void test085_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + File.pathSeparator + "\"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-**/*][-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/Z.java (at line 2)\n\tX f;\n\t^\nAccess restriction: The type 'X' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---/src1')\n----------\n1 problem (1 warning)\n", true);
    }

    public void test086_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        String output2 = "bin2";
        File outputDir = new File(OUTPUT_DIR);
        File sourceDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + source1);
        try {
            if (outputDir.exists()) {
                org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(outputDir);
            } else {
                outputDir.mkdirs();
            }
            sourceDir.mkdir();
            org.eclipse.jdt.core.tests.util.Util.createFile(String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.java", "public class X {}");
            org.eclipse.jdt.core.tests.util.Util.zip(sourceDir, String.valueOf(OUTPUT_DIR) + File.separator + "X.jar");
        }
        catch (IOException iOException) {
            BatchCompilerTest.fail((String)"could not create jar file");
        }
        this.runConformTest(new String[]{"Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "X.jar\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -d \"" + OUTPUT_DIR + File.separator + output2 + "\"", "", "", false);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test087_per_source_output_directory() {
        String output1 = "bin1";
        String output2 = "bin2";
        this.runNegativeTest(new String[]{"Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -classpath \"" + OUTPUT_DIR + File.separator + "X.jar\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -d \"" + OUTPUT_DIR + File.separator + output2 + "\"", "", "unexpected destination path entry for file: ---OUTPUT_DIR_PLACEHOLDER---/X.jar\n", true);
    }

    public void test088_per_source_output_directory() {
        String output1 = "bin1";
        String output2 = "bin2";
        this.runNegativeTest(new String[]{"Z.java", "public class Z {\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -bootclasspath \"" + OUTPUT_DIR + File.separator + "X.jar\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -d \"" + OUTPUT_DIR + File.separator + output2 + "\"", "", "unexpected destination path entry for file: ---OUTPUT_DIR_PLACEHOLDER---/X.jar\n", true);
    }

    public void test089_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        File outputDir = new File(OUTPUT_DIR);
        File sourceDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + source1);
        File standardXOutputFile = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "X.class");
        try {
            if (outputDir.exists()) {
                org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(outputDir);
            } else {
                outputDir.mkdirs();
            }
            sourceDir.mkdir();
            org.eclipse.jdt.core.tests.util.Util.createFile(String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.java", "public class X {}");
            org.eclipse.jdt.core.tests.util.Util.zip(sourceDir, String.valueOf(OUTPUT_DIR) + File.separator + "X.jar");
            if (standardXOutputFile.exists()) {
                org.eclipse.jdt.core.tests.util.Util.delete(standardXOutputFile);
            }
        }
        catch (IOException iOException) {
            BatchCompilerTest.fail((String)"could not create jar file");
        }
        this.runConformTest(new String[]{"Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "X.jar\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]", "", "", false);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        BatchCompilerTest.assertFalse((String)("extraneous file: " + standardXOutputFile.getPath()), (boolean)standardXOutputFile.exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test090_per_source_output_directory() {
        String source1 = "src1";
        File outputDir = new File(OUTPUT_DIR);
        File sourceDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + source1);
        File standardXOutputFile = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "X.class");
        try {
            if (outputDir.exists()) {
                org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(outputDir);
            } else {
                outputDir.mkdirs();
            }
            sourceDir.mkdir();
            org.eclipse.jdt.core.tests.util.Util.createFile(String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.java", "public class X {}");
            org.eclipse.jdt.core.tests.util.Util.zip(sourceDir, String.valueOf(OUTPUT_DIR) + File.separator + "X.jar");
            if (standardXOutputFile.exists()) {
                org.eclipse.jdt.core.tests.util.Util.delete(standardXOutputFile);
            }
        }
        catch (IOException iOException) {
            BatchCompilerTest.fail((String)"could not create jar file");
        }
        this.runConformTest(new String[]{"Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "X.jar\"" + "[-d none]", "", "", false);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        BatchCompilerTest.assertFalse((String)("extraneous file: " + standardXOutputFile.getPath()), (boolean)standardXOutputFile.exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test091_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        File outputDir = new File(OUTPUT_DIR);
        File sourceDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + source1);
        File standardXOutputFile = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "X.class");
        try {
            if (outputDir.exists()) {
                org.eclipse.jdt.core.tests.util.Util.flushDirectoryContent(outputDir);
            } else {
                outputDir.mkdirs();
            }
            sourceDir.mkdir();
            org.eclipse.jdt.core.tests.util.Util.createFile(String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.java", "public class X {}");
            org.eclipse.jdt.core.tests.util.Util.zip(sourceDir, String.valueOf(OUTPUT_DIR) + File.separator + "X.jar");
            if (standardXOutputFile.exists()) {
                org.eclipse.jdt.core.tests.util.Util.delete(standardXOutputFile);
            }
        }
        catch (IOException iOException) {
            BatchCompilerTest.fail((String)"could not create jar file");
        }
        this.runConformTest(new String[]{"Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -d none", "", "", false);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test092_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        String output2 = "bin2";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -1.5" + " -d \"" + OUTPUT_DIR + File.separator + output2 + "\"", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test093_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -1.5", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test094_per_source_output_directory() {
        String source1 = "src1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  // X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d none]" + " -1.5", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test095_per_source_output_directory() {
        String source1 = "src1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  // X f;\n}"}, " \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d none] " + "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " -1.5", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test096_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", "Z.java", "public class Z {\n  X f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "Z.java\"" + " \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -1.5" + " -d none", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + "Z.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test097_per_source_output_directory() {
        String source1 = "src1";
        String source2 = "src2";
        String output1 = "bin1";
        String output2 = "bin2";
        this.runConformTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}", String.valueOf(source2) + File.separator + "Z.java", "public class Z {\n  X f;\n}"}, " \"" + OUTPUT_DIR + File.separator + source2 + "\"" + " \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -1.5" + " -d none", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + output1 + File.separator + "X.class";
        BatchCompilerTest.assertTrue((String)("missing file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source1 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + output2 + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
        fileName = String.valueOf(OUTPUT_DIR) + File.separator + source2 + File.separator + "Z.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test098_per_source_output_directory() {
        String source1 = "src1";
        this.runNegativeTest(new String[]{String.valueOf(source1) + File.separator + "X.java", "public class X {\n  Zork z;\n}"}, "\"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[~**/internal/*]" + " -1.5", "", "unsupported encoding format: ~**/internal/*\n", true);
    }

    public void test099_per_source_output_directory() {
        File none = new File("none");
        if (none.exists()) {
            BatchCompilerTest.fail((String)("unexpected file: " + none.getAbsolutePath() + "; please cleanup the test environment"));
        }
        this.runConformTest(new String[]{"X.java", "public class X {}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5" + " -d none", "", "", true);
        String fileName = "none" + File.separator + "X.class";
        BatchCompilerTest.assertFalse((String)("extraneous file: " + fileName), (boolean)new File(fileName).exists());
    }

    public void test100_per_source_output_directory() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5" + " -extdirs \"" + OUTPUT_DIR + "\"" + "[-d dir]", "", "unexpected destination path entry in -extdir option\n", true);
    }

    public void test101_per_source_output_directory() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5" + " -endorseddirs \"" + OUTPUT_DIR + "\"" + "[-d dir]", "", "unexpected destination path entry in -endorseddirs option\n", true);
    }

    public void test102_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runNegativeTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}"}, " \"" + OUTPUT_DIR + File.separator + source1 + "\"" + "[-d \"" + OUTPUT_DIR + File.separator + output1 + "\"" + " -1.5" + " -d none", "", "incorrect destination path entry: [-d ---OUTPUT_DIR_PLACEHOLDER---/bin1\n", true);
    }

    public void test103_per_source_output_directory() {
        String source1 = "src1";
        String output1 = "bin1";
        this.runNegativeTest(new String[]{String.valueOf(source1) + File.separator + "/X.java", "public class X {}"}, " \"" + OUTPUT_DIR + File.separator + source1 + "\"" + " [-d \"" + OUTPUT_DIR + File.separator + output1 + "\"]" + " -1.5", "", "unexpected bracket: [-d\n", true);
    }

    public void test104_per_source_output_directory() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5" + " -sourcepath \"" + OUTPUT_DIR + "\"" + "[[-d dir]", "", "unexpected bracket: ---OUTPUT_DIR_PLACEHOLDER---[[-d\n", true);
    }

    public void test105_per_source_output_directory() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5" + " -cp \"" + OUTPUT_DIR + "\"" + "[-d dir]]", "", "unexpected bracket: dir]]\n", true);
    }

    public void test106_per_source_output_directory() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5" + " -cp \"" + OUTPUT_DIR + "\"" + "[-d dir1" + File.pathSeparator + "dir2]", "", "incorrect destination path entry: ---OUTPUT_DIR_PLACEHOLDER---[-d dir1" + File.pathSeparator + "dir2]\n", true);
    }

    public void test107() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.3 -source 1.3 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.1 : 45.3, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test108() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.4 -source 1.3 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.2 : 46.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test109() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.4 -source 1.4 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.4 : 48.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test110() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -source 1.3 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.4 : 48.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test111() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -source 1.4 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.4 : 48.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test112() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -source 1.5 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.5 : 49.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test113() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.6 -source 1.3 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.4 : 48.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test114() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.6 -source 1.4 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.4 : 48.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test115() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.6 -source 1.5 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.6 : 50.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test116() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.6 -source 1.6 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.6 : 50.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test117() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.7 -source 1.3 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.4 : 48.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test118() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.7 -source 1.4 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.4 : 48.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test119() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.7 -source 1.5 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.6 : 50.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test120() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.7 -source 1.6 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.6 : 50.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test121() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.7 -source 1.7 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.7 : 51.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test122_classpath() {
        String[] stringArray = new String[3];
        stringArray[0] = OUTPUT_DIR;
        stringArray[1] = "{pattern=**/OK2 (ACCESSIBLE)}";
        this.runClasspathTest(String.valueOf(OUTPUT_DIR) + "[+**/OK2]" + File.pathSeparator + File.pathSeparator + File.pathSeparator, stringArray, null);
    }

    public void test123_classpath() {
        String cp = String.valueOf(OUTPUT_DIR) + "[+OK2" + File.pathSeparator + File.pathSeparator + File.pathSeparator + "~Warn" + File.pathSeparator + "-KO]";
        this.runClasspathTest(cp, null, null);
    }

    public void test124_classpath() {
        String[] stringArray = new String[3];
        stringArray[0] = OUTPUT_DIR;
        stringArray[1] = "{pattern=OK2 (ACCESSIBLE), pattern=d ~Warn (NON ACCESSIBLE), pattern=KO (NON ACCESSIBLE)}";
        this.runClasspathTest(String.valueOf(OUTPUT_DIR) + "[+OK2" + File.pathSeparator + "-d ~Warn" + File.pathSeparator + "-KO]", stringArray, null);
    }

    public void test125_classpath() {
        String cp = String.valueOf(OUTPUT_DIR) + "[-d +OK2" + File.pathSeparator + "~Warn" + File.pathSeparator + "-KO]";
        this.runClasspathTest(cp, null, "incorrect destination path entry: " + cp);
    }

    public void test126_classpath() {
        String cp = String.valueOf(OUTPUT_DIR) + "[-d +OK2" + File.pathSeparator + "~Warn" + File.pathSeparator + "-KO][-d dummy]";
        this.runClasspathTest(cp, null, "incorrect destination path entry: " + cp);
    }

    public void test127_classpath() {
        String jarFile = String.valueOf(OUTPUT_DIR) + File.separator + "[squarebracket].jar";
        String[] stringArray = new String[3];
        stringArray[0] = jarFile;
        this.runClasspathTest(jarFile, stringArray, null);
    }

    public void test128_classpath() {
        String jarFile = String.valueOf(OUTPUT_DIR) + File.separator + "[square][bracket].jar";
        String[] stringArray = new String[3];
        stringArray[0] = jarFile;
        this.runClasspathTest(jarFile, stringArray, null);
    }

    public void test129_classpath() {
        String[] stringArray = new String[6];
        stringArray[0] = "file.jar";
        stringArray[1] = "{pattern=A (ACCESSIBLE)}";
        stringArray[3] = OUTPUT_DIR;
        this.runClasspathTest("file.jar[+A]" + File.pathSeparator + OUTPUT_DIR, stringArray, null);
    }

    public void test130_classpath() {
        String cp = String.valueOf(OUTPUT_DIR) + "[-d dir][~**/internal/*]";
        this.runClasspathTest(cp, null, "access rules cannot follow destination path entries: " + cp);
    }

    public void test131_classpath() {
        String cp = String.valueOf(OUTPUT_DIR) + "[~**/internal/*][-d dir]";
        this.runClasspathTest(cp, new String[]{OUTPUT_DIR, "{pattern=**/internal/* (DISCOURAGED)}", "dir"}, null);
    }

    public void test132_classpath() {
        String cp = String.valueOf(OUTPUT_DIR) + "[~**/internal/*[-d dir]";
        this.runClasspathTest(cp, null, null);
    }

    public void test133_classpath() {
        String cp = String.valueOf(OUTPUT_DIR) + "[~**/internal/*]-d dir]";
        this.runClasspathTest(cp, null, null);
    }

    public void test134_classpath() {
        String jarFile = String.valueOf(OUTPUT_DIR) + File.separator + "[squarebracket].jar";
        this.runClasspathTest(String.valueOf(jarFile) + "[~**/internal/*][-d " + OUTPUT_DIR + "]", new String[]{jarFile, "{pattern=**/internal/* (DISCOURAGED)}", OUTPUT_DIR}, null);
    }

    public void test135_classpath() {
        String jarFile = String.valueOf(OUTPUT_DIR) + File.separator + "[square][bracket].jar";
        this.runClasspathTest(String.valueOf(jarFile) + "[~**/internal/*][-d dir]", new String[]{jarFile, "{pattern=**/internal/* (DISCOURAGED)}", "dir"}, null);
    }

    public void test136_classpath() {
        String target = String.valueOf(OUTPUT_DIR) + File.separator + "[a]";
        new File(target).mkdirs();
        String[] stringArray = new String[3];
        stringArray[0] = target;
        this.runClasspathTest(String.valueOf(target) + File.separator, stringArray, null);
    }

    public void test137_classpath() {
        String target = String.valueOf(OUTPUT_DIR) + File.separator + "[a]";
        new File(target).mkdirs();
        this.runClasspathTest(String.valueOf(target) + File.separator + "[~**/internal/*][-d dir]", new String[]{target, "{pattern=**/internal/* (DISCOURAGED)}", "dir"}, null);
    }

    public void test138_classpath() {
        this.runClasspathTest(String.valueOf(OUTPUT_DIR) + File.separator + "[a][~**/internal/*][-d dir]", null, null);
    }

    public void test139_classpath() {
        String cp = "[a].jar";
        String[] stringArray = new String[3];
        stringArray[0] = cp;
        this.runClasspathTest(cp, stringArray, null);
    }

    public void test140_classpath() {
        String cp = "[a].jar";
        this.runClasspathTest(String.valueOf(cp) + "[~**/internal/*][-d dir]", new String[]{cp, "{pattern=**/internal/* (DISCOURAGED)}", "dir"}, null);
    }

    public void test141_null_ref_option() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    Object o = null;\n    o.toString();\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + " -cp " + this.getJCEJarAsQuotedString() + " -warn:+nullDereference" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\to.toString();\n\t^\nNull pointer access: The variable o can only be null at this location\n----------\n1 problem (1 warning)\n", true);
    }

    public void test142_null_ref_option() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    Object o = null;\n    if (o == null) {}\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + " -cp " + this.getJCEJarAsQuotedString() + " -warn:+null" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tif (o == null) {}\n\t    ^\nRedundant null check: The variable o can only be null at this location\n----------\n1 problem (1 warning)\n", true);
    }

    public void test143_null_ref_option() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    Object o = null;\n    if (o == null) {}\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + " -cp " + this.getJCEJarAsQuotedString() + " -warn:+nullDereference" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test144() throws Exception {
        String version = System.getProperty("java.class.version");
        if ("49.0".equals(version)) {
            this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.6 -source 1.6 -d \"" + OUTPUT_DIR + "\"", "", "Annotation processing got disabled, since it requires a 1.6 compliant JVM\n", true);
            String expectedOutput = "// Compiled from X.java (version 1.6 : 50.0, super bit)";
            this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
        }
    }

    public void test145_declared_thrown_checked_exceptions() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  public void foo() throws IOException {\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + " -cp " + this.getJCEJarAsQuotedString() + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test146_declared_thrown_checked_exceptions() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n  public void foo() throws IOException {\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + " -cp " + this.getJCEJarAsQuotedString() + " -warn:+unusedThrown" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tpublic void foo() throws IOException {\n\t                         ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo() from type X\n----------\n1 problem (1 warning)\n", true);
    }

    public void test148_access_restrictions() {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n\tKO ko;\n   void foo() {\n     ko = new KO();\n     ko.bar();\n     if (ko.m) {}\n   }\n   Zork z;\n}", "KO.java", "/** */\npublic class KO {\n  void bar() {};\n  boolean m;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + OUTPUT_DIR + "[-KO]\"" + " -warn:+deprecation,syntheticAccess,uselessTypeCheck,unsafe,finalBound,unusedLocal" + " -proceedOnError -referenceInfo -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tKO ko;\n\t^^\nAccess restriction: The type 'KO' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tko = new KO();\n\t     ^^^^^^^^\nAccess restriction: The constructor 'KO()' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tko = new KO();\n\t         ^^\nAccess restriction: The type 'KO' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tko.bar();\n\t^^^^^^^^\nAccess restriction: The method 'KO.bar()' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tif (ko.m) {}\n\t       ^\nAccess restriction: The field 'KO.m' is not API (restriction on classpath entry '---OUTPUT_DIR_PLACEHOLDER---')\n----------\n6. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 9)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n6 problems (1 error, 5 warnings)\n", true);
    }

    public void test149() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {}\n\tpublic static void bar() {\n\t\tX.<String>foo();\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.7 -warn:-unused -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test150_null_ref_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n   }\n\t// Zork z;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\ts.toString();\n\t^\nNull pointer access: The variable s can only be null at this location\n----------\n1 problem (1 warning)\n", true);
    }

    public void test151_null_ref_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n   }\n\t// Zork z;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:-nullDereference -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test152() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n   }\n\t// Zork z;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:-nullDereferences -proc:none -d \"" + OUTPUT_DIR + "\"", "", "invalid warning token: 'nullDereferences'. Ignoring warning and compiling\n----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\ts.toString();\n\t^\nNull pointer access: The variable s can only be null at this location\n----------\n1 problem (1 warning)\n", true);
    }

    public void test153_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n     String u;\n   }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\ts.toString();\n\t^\nNull pointer access: The variable s can only be null at this location\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tString u;\n\t       ^\nThe value of the local variable u is not used\n----------\n2 problems (2 warnings)\n", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:none -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test154_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n     String u;\n   }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:null -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\ts.toString();\n\t^\nNull pointer access: The variable s can only be null at this location\n----------\n1 problem (1 warning)\n", true);
    }

    public void test155_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n     String u;\n   }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:none -warn:null -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\ts.toString();\n\t^\nNull pointer access: The variable s can only be null at this location\n----------\n1 problem (1 warning)\n", true);
    }

    public void test156_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n     String u;\n   }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:null -warn:unused -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tString u;\n\t       ^\nThe value of the local variable u is not used\n----------\n1 problem (1 warning)\n", true);
    }

    public void test157_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n     String u;\n   }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:null -warn:+unused -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\ts.toString();\n\t^\nNull pointer access: The variable s can only be null at this location\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tString u;\n\t       ^\nThe value of the local variable u is not used\n----------\n2 problems (2 warnings)\n", true);
    }

    public void test158_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n     String u;\n   }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:null -warn:+unused -warn:-null -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tString u;\n\t       ^\nThe value of the local variable u is not used\n----------\n1 problem (1 warning)\n", true);
    }

    public void test159_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n     String u;\n   }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tString u;\n\t       ^\nThe value of the local variable u is not used\n----------\n1 problem (1 warning)\n", true);
    }

    public void test160_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n     String u;\n   }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:none -warn:+unused,null -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\ts.toString();\n\t^\nNull pointer access: The variable s can only be null at this location\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tString u;\n\t       ^\nThe value of the local variable u is not used\n----------\n2 problems (2 warnings)\n", true);
    }

    public void test161_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n     String u;\n   }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:-null,unused,+unused,null -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\ts.toString();\n\t^\nNull pointer access: The variable s can only be null at this location\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tString u;\n\t       ^\nThe value of the local variable u is not used\n----------\n2 problems (2 warnings)\n", true);
    }

    public void test162_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void foo() {\n     String s = null;\n     s.toString();\n     String u;\n   }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -nowarn -warn:+null,unused,-unused,null -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test163_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tY f;\n\t^\nThe type Y is deprecated\n----------\n1 problem (1 warning)\n", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:none -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test164_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -nowarn -deprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tY f;\n\t^\nThe type Y is deprecated\n----------\n1 problem (1 warning)\n", true);
    }

    public void test165_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -nowarn -deprecation -warn:-deprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test166_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -nowarn -deprecation -warn:-allDeprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test167_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:allDeprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tY f;\n\t^\nThe type Y is deprecated\n----------\n1 problem (1 warning)\n", true);
    }

    public void test168_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:javadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\t@param\n\t ^^^^^\nJavadoc: Missing parameter name\n----------\n1 problem (1 warning)\n", false);
    }

    public void test169_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:allJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\tpublic class X {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\t@param\n\t ^^^^^\nJavadoc: Missing parameter name\n----------\n2 problems (2 warnings)\n", true);
    }

    public void test170_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:javadoc -warn:-allJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test171_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:allJavadoc -warn:-javadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\tpublic class X {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n1 problem (1 warning)\n", true);
    }

    public void test172_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n  /** @deprecated */\n  void foo(Y p) {\n  }\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tY f;\n\t^\nThe type Y is deprecated\n----------\n1 problem (1 warning)\n", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:allDeprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tY f;\n\t^\nThe type Y is deprecated\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tvoid foo(Y p) {\n\t         ^\nThe type Y is deprecated\n----------\n2 problems (2 warnings)\n", false);
    }

    public void _test173_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n  /** @deprecated */\n  void foo(Y p) {\n  }\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:allDeprecation -warn:-deprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tvoid foo(Y p) {\n\t         ^\nThe type Y is deprecated\n----------\n1 problem (1 warning)", true);
    }

    public void test174_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  class XX {\n    int i;\n  }\n  void foo(int i) {\n    class XX {\n    }\n    if (i > 0) {\n      try {\n        bar();\n      } catch (E2 e2) {\n      } catch (E1 e1) {\n      }\n    }\n  }\n  void bar() throws E2 {\n    throw new E2();\n  }\n}\nclass E1 extends Exception {\n  private static final long serialVersionUID = 1L;\n}\nclass E2 extends E1 {\n  private static final long serialVersionUID = 1L;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tclass XX {\n\t      ^^\nThe type XX is hiding the type X.XX\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tclass XX {\n\t      ^^\nThe type XX is never used locally\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 13)\n\t} catch (E1 e1) {\n\t         ^^\nUnreachable catch block for E1. Only more specific exceptions are thrown and they are handled by previous catch block(s).\n----------\n3 problems (3 warnings)\n", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -nowarn -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test175_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  class XX {\n    int i;\n  }\n  void foo(int i) {\n    class XX {\n    }\n    if (i > 0) {\n      try {\n        bar();\n      } catch (E2 e2) {\n      } catch (E1 e1) {\n      }\n    }\n  }\n  void bar() throws E2 {\n    throw new E2();\n  }\n}\nclass E1 extends Exception {\n  private static final long serialVersionUID = 1L;\n}\nclass E2 extends E1 {\n  private static final long serialVersionUID = 1L;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:hiding -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint i;\n\t    ^\nThe field X.XX.i is hiding a field from type X\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tvoid foo(int i) {\n\t             ^\nThe parameter i is hiding a field from type X\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tclass XX {\n\t      ^^\nThe type XX is hiding the type X.XX\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 13)\n\t} catch (E1 e1) {\n\t         ^^\nUnreachable catch block for E1. Only more specific exceptions are thrown and they are handled by previous catch block(s).\n----------\n4 problems (4 warnings)\n", true);
    }

    public void test176_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  class XX {\n    int i;\n  }\n  void foo(int i) {\n    class XX {\n    }\n    if (i > 0) {\n      try {\n        bar();\n      } catch (E2 e2) {\n      } catch (E1 e1) {\n      }\n    }\n  }\n  void bar() throws E2 {\n    throw new E2();\n  }\n}\nclass E1 extends Exception {\n  private static final long serialVersionUID = 1L;\n}\nclass E2 extends E1 {\n  private static final long serialVersionUID = 1L;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:fieldHiding -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint i;\n\t    ^\nThe field X.XX.i is hiding a field from type X\n----------\n1 problem (1 warning)\n", true);
    }

    public void test177_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  class XX {\n    int i;\n  }\n  void foo(int i) {\n    class XX {\n    }\n    if (i > 0) {\n      try {\n        bar();\n      } catch (E2 e2) {\n      } catch (E1 e1) {\n      }\n    }\n  }\n  void bar() throws E2 {\n    throw new E2();\n  }\n}\nclass E1 extends Exception {\n  private static final long serialVersionUID = 1L;\n}\nclass E2 extends E1 {\n  private static final long serialVersionUID = 1L;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:localHiding -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tvoid foo(int i) {\n\t             ^\nThe parameter i is hiding a field from type X\n----------\n1 problem (1 warning)\n", true);
    }

    public void test178_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  class XX {\n    int i;\n  }\n  void foo(int i) {\n    class XX {\n    }\n    if (i > 0) {\n      try {\n        bar();\n      } catch (E2 e2) {\n      } catch (E1 e1) {\n      }\n    }\n  }\n  void bar() throws E2 {\n    throw new E2();\n  }\n}\nclass E1 extends Exception {\n  private static final long serialVersionUID = 1L;\n}\nclass E2 extends E1 {\n  private static final long serialVersionUID = 1L;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:maskedCatchBlock -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 13)\n\t} catch (E1 e1) {\n\t         ^^\nUnreachable catch block for E1. Only more specific exceptions are thrown and they are handled by previous catch block(s).\n----------\n1 problem (1 warning)\n", true);
    }

    public void test179_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  class XX {\n    int i;\n  }\n  void foo(int i) {\n    class XX {\n    }\n    if (i > 0) {\n      try {\n        bar();\n      } catch (E2 e2) {\n      } catch (E1 e1) {\n      }\n    }\n  }\n  void bar() throws E2 {\n    throw new E2();\n  }\n}\nclass E1 extends Exception {\n  private static final long serialVersionUID = 1L;\n}\nclass E2 extends E1 {\n  private static final long serialVersionUID = 1L;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:typeHiding -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tclass XX {\n\t      ^^\nThe type XX is hiding the type X.XX\n----------\n1 problem (1 warning)\n", true);
    }

    public void test180_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  class XX {\n    int i;\n  }\n  void foo(int i) {\n    class XX {\n    }\n    if (i > 0) {\n      try {\n        bar();\n      } catch (E2 e2) {\n      } catch (E1 e1) {\n      }\n    }\n  }\n  void bar() throws E2 {\n    throw new E2();\n  }\n}\nclass E1 extends Exception {\n  private static final long serialVersionUID = 1L;\n}\nclass E2 extends E1 {\n  private static final long serialVersionUID = 1L;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:hiding -warn:-fieldHiding -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tvoid foo(int i) {\n\t             ^\nThe parameter i is hiding a field from type X\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tclass XX {\n\t      ^^\nThe type XX is hiding the type X.XX\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 13)\n\t} catch (E1 e1) {\n\t         ^^\nUnreachable catch block for E1. Only more specific exceptions are thrown and they are handled by previous catch block(s).\n----------\n3 problems (3 warnings)\n", true);
    }

    public void test181_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  class XX {\n    int i;\n  }\n  void foo(int i) {\n    class XX {\n    }\n    if (i > 0) {\n      try {\n        bar();\n      } catch (E2 e2) {\n      } catch (E1 e1) {\n      }\n    }\n  }\n  void bar() throws E2 {\n    throw new E2();\n  }\n}\nclass E1 extends Exception {\n  private static final long serialVersionUID = 1L;\n}\nclass E2 extends E1 {\n  private static final long serialVersionUID = 1L;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:hiding -warn:-localHiding -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint i;\n\t    ^\nThe field X.XX.i is hiding a field from type X\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tclass XX {\n\t      ^^\nThe type XX is hiding the type X.XX\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 13)\n\t} catch (E1 e1) {\n\t         ^^\nUnreachable catch block for E1. Only more specific exceptions are thrown and they are handled by previous catch block(s).\n----------\n3 problems (3 warnings)\n", true);
    }

    public void test182_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  class XX {\n    int i;\n  }\n  void foo(int i) {\n    class XX {\n    }\n    if (i > 0) {\n      try {\n        bar();\n      } catch (E2 e2) {\n      } catch (E1 e1) {\n      }\n    }\n  }\n  void bar() throws E2 {\n    throw new E2();\n  }\n}\nclass E1 extends Exception {\n  private static final long serialVersionUID = 1L;\n}\nclass E2 extends E1 {\n  private static final long serialVersionUID = 1L;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:hiding -warn:-maskedCatchBlock -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint i;\n\t    ^\nThe field X.XX.i is hiding a field from type X\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tvoid foo(int i) {\n\t             ^\nThe parameter i is hiding a field from type X\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tclass XX {\n\t      ^^\nThe type XX is hiding the type X.XX\n----------\n3 problems (3 warnings)\n", true);
    }

    public void test183_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  class XX {\n    int i;\n  }\n  void foo(int i) {\n    class XX {\n    }\n    if (i > 0) {\n      try {\n        bar();\n      } catch (E2 e2) {\n      } catch (E1 e1) {\n      }\n    }\n  }\n  void bar() throws E2 {\n    throw new E2();\n  }\n}\nclass E1 extends Exception {\n  private static final long serialVersionUID = 1L;\n}\nclass E2 extends E1 {\n  private static final long serialVersionUID = 1L;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:hiding -warn:-typeHiding -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint i;\n\t    ^\nThe field X.XX.i is hiding a field from type X\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tvoid foo(int i) {\n\t             ^\nThe parameter i is hiding a field from type X\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 13)\n\t} catch (E1 e1) {\n\t         ^^\nUnreachable catch block for E1. Only more specific exceptions are thrown and they are handled by previous catch block(s).\n----------\n3 problems (3 warnings)\n", true);
    }

    public void test184_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n  public static int i;\n  void foo() {\n    if (this.i > X.j) {\n    }\n  }\n}\nclass Y {\n  static int j;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tif (this.i > X.j) {\n\t         ^\nThe static field X.i should be accessed in a static way\n----------\n1 problem (1 warning)\n", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -nowarn -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test185_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n  public static int i;\n  void foo() {\n    if (this.i > X.j) {\n    }\n  }\n}\nclass Y {\n  static int j;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:staticReceiver -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tif (this.i > X.j) {\n\t         ^\nThe static field X.i should be accessed in a static way\n----------\n1 problem (1 warning)\n", true);
    }

    public void test186_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n  public static int i;\n  void foo() {\n    if (this.i > X.j) {\n    }\n  }\n}\nclass Y {\n  static int j;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:indirectStatic -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tif (this.i > X.j) {\n\t               ^\nThe static field Y.j should be accessed directly\n----------\n1 problem (1 warning)\n", true);
    }

    public void test187_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n  public static int i;\n  void foo() {\n    if (this.i > X.j) {\n    }\n  }\n}\nclass Y {\n  static int j;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:static-access -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tif (this.i > X.j) {\n\t         ^\nThe static field X.i should be accessed in a static way\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tif (this.i > X.j) {\n\t               ^\nThe static field Y.j should be accessed directly\n----------\n2 problems (2 warnings)\n", true);
    }

    public void test188_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n  public static int i;\n  void foo() {\n    if (this.i > X.j) {\n    }\n  }\n}\nclass Y {\n  static int j;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:static-access -warn:-staticReceiver -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tif (this.i > X.j) {\n\t               ^\nThe static field Y.j should be accessed directly\n----------\n1 problem (1 warning)\n", true);
    }

    public void test189_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X extends Y {\n  public static int i;\n  void foo() {\n    if (this.i > X.j) {\n    }\n  }\n}\nclass Y {\n  static int j;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:static-access -warn:-indirectStatic -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tif (this.i > X.j) {\n\t         ^\nThe static field X.i should be accessed in a static way\n----------\n1 problem (1 warning)\n", true);
    }

    public void test190_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method foo(int) from the type X is never used locally\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint j;\n\t    ^\nThe value of the local variable j is not used\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tthis.<String>bar();\n\t      ^^^^^^\nUnused type arguments for the non generic method bar() of type X; it should not be parameterized with arguments <String>\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tnext: for (;;) {\n\t^^^^\nThe label next is never explicitly referenced\n----------\n5 problems (5 warnings)\n", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -nowarn -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test191_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method foo(int) from the type X is never used locally\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                     ^\nThe value of the parameter i is not used\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                               ^^^^^^^^^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint j;\n\t    ^\nThe value of the local variable j is not used\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tthis.<String>bar();\n\t      ^^^^^^\nUnused type arguments for the non generic method bar() of type X; it should not be parameterized with arguments <String>\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tnext: for (;;) {\n\t^^^^\nThe label next is never explicitly referenced\n----------\n8. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 14)\n\t<T> void bar() {\n\t ^\nUnused type parameter T\n----------\n8 problems (8 warnings)\n", true);
    }

    public void test192_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedArgument -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                     ^\nThe value of the parameter i is not used\n----------\n1 problem (1 warning)\n", true);
    }

    public void test193_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedImport -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n1 problem (1 warning)\n", true);
    }

    public void test194_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedLabel -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tnext: for (;;) {\n\t^^^^\nThe label next is never explicitly referenced\n----------\n1 problem (1 warning)\n", true);
    }

    public void test195_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedLocal -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint j;\n\t    ^\nThe value of the local variable j is not used\n----------\n1 problem (1 warning)\n", true);
    }

    public void test196_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedPrivate -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method foo(int) from the type X is never used locally\n----------\n1 problem (1 warning)\n", true);
    }

    public void test197_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedTypeArgs -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tthis.<String>bar();\n\t      ^^^^^^\nUnused type arguments for the non generic method bar() of type X; it should not be parameterized with arguments <String>\n----------\n1 problem (1 warning)\n", true);
    }

    public void test198_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedThrown -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                               ^^^^^^^^^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n1 problem (1 warning)\n", true);
    }

    public void test199_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -warn:-unusedArgument -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method foo(int) from the type X is never used locally\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                               ^^^^^^^^^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint j;\n\t    ^\nThe value of the local variable j is not used\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tthis.<String>bar();\n\t      ^^^^^^\nUnused type arguments for the non generic method bar() of type X; it should not be parameterized with arguments <String>\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tnext: for (;;) {\n\t^^^^\nThe label next is never explicitly referenced\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 14)\n\t<T> void bar() {\n\t ^\nUnused type parameter T\n----------\n7 problems (7 warnings)\n", true);
    }

    public void test200_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -warn:-unusedImport -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method foo(int) from the type X is never used locally\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                     ^\nThe value of the parameter i is not used\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                               ^^^^^^^^^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint j;\n\t    ^\nThe value of the local variable j is not used\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tthis.<String>bar();\n\t      ^^^^^^\nUnused type arguments for the non generic method bar() of type X; it should not be parameterized with arguments <String>\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tnext: for (;;) {\n\t^^^^\nThe label next is never explicitly referenced\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 14)\n\t<T> void bar() {\n\t ^\nUnused type parameter T\n----------\n7 problems (7 warnings)\n", true);
    }

    public void test201_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -warn:-unusedLabel -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method foo(int) from the type X is never used locally\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                     ^\nThe value of the parameter i is not used\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                               ^^^^^^^^^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint j;\n\t    ^\nThe value of the local variable j is not used\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tthis.<String>bar();\n\t      ^^^^^^\nUnused type arguments for the non generic method bar() of type X; it should not be parameterized with arguments <String>\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 14)\n\t<T> void bar() {\n\t ^\nUnused type parameter T\n----------\n7 problems (7 warnings)\n", true);
    }

    public void test202_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -warn:-unusedLocal -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method foo(int) from the type X is never used locally\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                     ^\nThe value of the parameter i is not used\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                               ^^^^^^^^^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tthis.<String>bar();\n\t      ^^^^^^\nUnused type arguments for the non generic method bar() of type X; it should not be parameterized with arguments <String>\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tnext: for (;;) {\n\t^^^^\nThe label next is never explicitly referenced\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 14)\n\t<T> void bar() {\n\t ^\nUnused type parameter T\n----------\n7 problems (7 warnings)\n", true);
    }

    public void test203_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -warn:-unusedPrivate -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                     ^\nThe value of the parameter i is not used\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                               ^^^^^^^^^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint j;\n\t    ^\nThe value of the local variable j is not used\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tthis.<String>bar();\n\t      ^^^^^^\nUnused type arguments for the non generic method bar() of type X; it should not be parameterized with arguments <String>\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tnext: for (;;) {\n\t^^^^\nThe label next is never explicitly referenced\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 14)\n\t<T> void bar() {\n\t ^\nUnused type parameter T\n----------\n7 problems (7 warnings)\n", true);
    }

    public void test204_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -warn:-unusedThrown -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method foo(int) from the type X is never used locally\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                     ^\nThe value of the parameter i is not used\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint j;\n\t    ^\nThe value of the local variable j is not used\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tthis.<String>bar();\n\t      ^^^^^^\nUnused type arguments for the non generic method bar() of type X; it should not be parameterized with arguments <String>\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tnext: for (;;) {\n\t^^^^\nThe label next is never explicitly referenced\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 14)\n\t<T> void bar() {\n\t ^\nUnused type parameter T\n----------\n7 problems (7 warnings)\n", true);
    }

    public void test205_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X extends Y {\n  private void foo(int i) throws java.io.IOException {\n    int j;\n    this.<String>bar();\n    next: for (;;) {\n      return;\n    }\n  }\n  void bar() {\n  }\n}\nclass Y {\n  <T> void bar() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -warn:-unusedTypeArgs -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport java.util.ArrayList;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe import java.util.ArrayList is never used\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe method foo(int) from the type X is never used locally\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                     ^\nThe value of the parameter i is not used\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate void foo(int i) throws java.io.IOException {\n\t                               ^^^^^^^^^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo(int) from type X\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tint j;\n\t    ^\nThe value of the local variable j is not used\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tnext: for (;;) {\n\t^^^^\nThe label next is never explicitly referenced\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 14)\n\t<T> void bar() {\n\t ^\nUnused type parameter T\n----------\n7 problems (7 warnings)\n", true);
    }

    public void test206_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:allJavadoc -enableJavadoc -warn:-allJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test207_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:javadoc -enableJavadoc -warn:-javadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test208_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param i explained\n  */\n  public void foo(int i) {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tpublic void foo(int i) {\n\t                    ^\nThe value of the parameter i is not used\n----------\n1 problem (1 warning)\n", true);
    }

    public void test209_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param i explained\n  */\n  public void foo(int i) {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -enableJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test210_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param i explained\n  */\n  public void foo(int i) {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -warn:-allJavadoc -enableJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test211_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param i explained\n  */\n  public void foo(int i) {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -enableJavadoc -warn:-allJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test212_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param i explained\n  */\n  public void foo(int i) {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused,allJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\tpublic class X {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tpublic void foo(int i) {\n\t                    ^\nThe value of the parameter i is not used\n----------\n2 problems (2 warnings)\n", true);
    }

    public void test213_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param i explained\n  */\n  public void foo(int i) {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused,javadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tpublic void foo(int i) {\n\t                    ^\nThe value of the parameter i is not used\n----------\n1 problem (1 warning)\n", true);
    }

    public void _test216a_warn_options() {
        this.runConformTest(new String[]{"X.java", "/** */public class X {\n  /**\n    {@link Y}\n  */\n  public void foo() {\n  }\n}\n", "Y.java", "/** @deprecated */public class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:allJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + "\"", "", "", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:allJavadoc -warn:+javadoc -proc:none -d \"" + OUTPUT_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + "\"", "", "", false);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:javadoc -proc:none -d \"" + OUTPUT_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test216b_warn_options() {
        this.runConformTest(new String[]{"X.java", "/** */public class X {\n  /**\n    {@link Y}\n  */\n  public void foo() {\n  }\n}\n", "Y.java", "/** @deprecated */public class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:+allJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\t{@link Y}\n\t       ^\nJavadoc: The type Y is deprecated\n----------\n1 problem (1 warning)\n", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:+allJavadoc -warn:+javadoc -proc:none -d \"" + OUTPUT_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\t{@link Y}\n\t       ^\nJavadoc: The type Y is deprecated\n----------\n1 problem (1 warning)\n", false);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:+javadoc -proc:none -d \"" + OUTPUT_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\t{@link Y}\n\t       ^\nJavadoc: The type Y is deprecated\n----------\n1 problem (1 warning)\n", false);
    }

    public void test217_warn_options() {
        this.runConformTest(new String[]{"X.java", "/** */public class X {\n  /**\n    @see #bar()\n  */\n  public void foo() {\n    bar();\n  }\n  private void bar() {\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:allJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\t@see #bar()\n\t     ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'private' reference\n----------\n1 problem (1 warning)\n", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:allJavadoc -warn:+javadoc -proc:none -d \"" + OUTPUT_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\t@see #bar()\n\t     ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'private' reference\n----------\n1 problem (1 warning)\n", false);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:javadoc -proc:none -d \"" + OUTPUT_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\t@see #bar()\n\t     ^^^^^^\nJavadoc: 'public' visibility for malformed doc comments hides this 'private' reference\n----------\n1 problem (1 warning)\n", false);
    }

    public void test218_batch_classpath_apis() {
        BatchCompilerTest.assertFalse((String)"path should be absolute", (new ClasspathJar(new File("relative.jar"), true, null, null).getPath().indexOf(File.separator) == -1 ? 1 : 0) != 0);
    }

    public void test219_batch_classpath_apis() {
        BatchCompilerTest.assertFalse((String)"path should be absolute", (CharOperation.indexOf((char)'/', (char[])new ClasspathJar(new File("relative.jar"), true, null, null).normalizedPath()) == -1 ? 1 : 0) != 0);
    }

    public void _test220_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n  /** @deprecated */\n  void foo(Y p) {\n  }\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:allDeprecation -warn:+deprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tY f;\n\t^\nThe type Y is deprecated\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tvoid foo(Y p) {\n\t         ^\nThe type Y is deprecated\n----------\n2 problems (2 warnings)", true);
    }

    public void test221_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n  /** @deprecated */\n  void foo(Y p) {\n  }\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:allDeprecation -warn:deprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tY f;\n\t^\nThe type Y is deprecated\n----------\n1 problem (1 warning)\n", true);
    }

    public void test222_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n  /** @deprecated */\n  void foo(Y p) {\n  }\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:allDeprecation -deprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tY f;\n\t^\nThe type Y is deprecated\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tvoid foo(Y p) {\n\t         ^\nThe type Y is deprecated\n----------\n2 problems (2 warnings)\n", true);
    }

    public void test223_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  Y f;\n  /** @deprecated */\n  void foo(Y p) {\n  }\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -deprecation -warn:-allDeprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void _test224_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  int i;\n  X(int i) {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:+localHiding,specialParamHiding -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tX(int i) {\n\t      ^\nThe parameter i is hiding a field from type X\n----------\n1 problem (1 warning)", true);
        this.runConformTest(new String[0], "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:+localHiding,specialParamHiding -warn:deprecation -warn:+localHiding -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void test225_warn_options() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"deprecation\")\npublic class X {\n  Y f;\n  /** @deprecated */\n  void foo(Y p) {\n  }\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -sourcepath \"" + OUTPUT_DIR + "\"" + " -deprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void _test226_warn_options() {
        this.runConformTest(new String[]{"X.java", "@SuppressWarnings(\"deprecation\")\npublic class X {\n  Y f;\n  /** @deprecated */\n  void foo(Y p) {\n  }\n}", "Y.java", "/** @deprecated */\npublic class Y {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:deprecation -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tY f;\n\t^\nThe type Y is deprecated\n----------\n1 problem (1 warning)", true);
    }

    public void test227_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  /**\n    @param i explained\n  */\n  public void foo(int i) {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unused -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tpublic void foo(int i) {\n\t                    ^\nThe value of the parameter i is not used\n----------\n1 problem (1 warning)\n", true);
    }

    public void test228_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n/** @throws IOException mute warning **/\n  public void foo() throws IOException {\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedThrown -enableJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test229_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n/** @throws IOException mute warning **/\n  public void foo() throws IOException {\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedThrown -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tpublic void foo() throws IOException {\n\t                         ^^^^^^^^^^^\nThe declared exception IOException is not actually thrown by the method foo() from type X\n----------\n1 problem (1 warning)\n", true);
    }

    public void test230_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\npublic class X<T>{\n  public X() {\n  }\n  public X(T t){}\n  void foo() {\n      X<String> x = new X<String>();\n\t   X<Number> x1 = new X<Number>(1);\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedTypeArgs -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tX<String> x = new X<String>();\n\t                  ^\nRedundant specification of type arguments <String>\n----------\n1 problem (1 warning)\n", true);
    }

    public void test230_sourcepath_vs_classpath() throws IOException, InterruptedException {
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  public static final int CONST = 1;\n}\n", "src2/X.java", "public class X {\n  public static final int CONST = 2;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -verbose -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin1" + "\"", "[parsing    ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #1/1]\n[reading    java/lang/Object.class]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #1/1]\n[writing    X.class - #1]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/src1/X.java - #1/1]\n[1 unit compiled]\n[1 .class file generated]\n", "", true, null);
        File sourceFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "src1" + File.separator + "X.java");
        File classFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "bin1" + File.separator + "X.class");
        while (classFile.lastModified() <= sourceFile.lastModified()) {
            this.runConformTest(null, "\"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin1" + "\"", "", "", false);
        }
        this.runConformTest(new String[]{"Y.java", "public class Y {\n  public static void main (String[] args) {\n    System.out.println(X.CONST);\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -classpath \"" + OUTPUT_DIR + File.separator + "bin1" + "\"" + " -verbose -proc:none -d \"" + OUTPUT_DIR + "\"", "[parsing    ---OUTPUT_DIR_PLACEHOLDER---/Y.java - #1/1]\n[reading    java/lang/Object.class]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/Y.java - #1/1]\n[reading    java/lang/String.class]\n[reading    java/lang/System.class]\n[reading    java/io/PrintStream.class]\n[reading    X.class]\n[writing    Y.class - #1]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/Y.java - #1/1]\n[1 unit compiled]\n[1 .class file generated]\n", "", false);
        String sourceFilePath = "\"" + OUTPUT_DIR + File.separator + "Y.java\"";
        String commonOptions = " -classpath \"" + OUTPUT_DIR + File.separator + "bin1" + "\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src2" + "\"" + " -d \"" + OUTPUT_DIR + File.separator + "bin2" + "\"";
        String setting = System.getProperty("jdt.compiler.useSingleThread");
        try {
            System.setProperty("jdt.compiler.useSingleThread", "true");
            this.runConformTest(null, String.valueOf(sourceFilePath) + commonOptions + " -verbose -proc:none", "[parsing    ---OUTPUT_DIR_PLACEHOLDER---/Y.java - #1/1]\n[reading    java/lang/Object.class]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/Y.java - #1/1]\n[reading    java/lang/String.class]\n[reading    java/lang/System.class]\n[reading    java/io/PrintStream.class]\n[parsing    ---OUTPUT_DIR_PLACEHOLDER---/src2/X.java - #2/2]\n[writing    Y.class - #1]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/Y.java - #1/2]\n[analyzing  ---OUTPUT_DIR_PLACEHOLDER---/src2/X.java - #2/2]\n[writing    X.class - #2]\n[completed  ---OUTPUT_DIR_PLACEHOLDER---/src2/X.java - #2/2]\n[2 units compiled]\n[2 .class files generated]\n", "", false);
        }
        catch (Throwable throwable) {
            System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
            throw throwable;
        }
        System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
        if (RUN_JAVAC) {
            this.verifier.execute("Y", new String[]{String.valueOf(OUTPUT_DIR) + File.separator + "bin2"});
            BatchCompilerTest.assertTrue((boolean)this.verifier.getExecutionOutput().startsWith("2"));
            Iterator javacCompilersIterator = javacCompilers.iterator();
            String specialOptions = String.valueOf(commonOptions) + " -Xprefer:source ";
            String[] sourceFileNames = new String[]{sourceFilePath};
            File outputDir = new File(OUTPUT_DIR);
            while (javacCompilersIterator.hasNext()) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)javacCompilersIterator.next();
                BatchCompilerTest.assertTrue((javacCompiler.compile(outputDir, commonOptions, sourceFileNames, null) == 0L ? 1 : 0) != 0);
                this.verifier.execute("Y", new String[]{String.valueOf(OUTPUT_DIR) + File.separator + "bin2"});
                BatchCompilerTest.assertEquals((char)'1', (char)this.verifier.getExecutionOutput().charAt(0));
                if (javacCompiler.version.compareTo("1.6") < 0) continue;
                BatchCompilerTest.assertTrue((javacCompiler.compile(outputDir, specialOptions, sourceFileNames, null) == 0L ? 1 : 0) != 0);
                this.verifier.execute("Y", new String[]{String.valueOf(OUTPUT_DIR) + File.separator + "bin2"});
                BatchCompilerTest.assertEquals((char)'2', (char)this.verifier.getExecutionOutput().charAt(0));
            }
        }
    }

    public void test231_sourcepath_vs_classpath() throws IOException, InterruptedException {
        this.runConformTest(new String[]{"src1/X.java", "public class X {\n  public static final int CONST = 1;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin1" + "\"", "", "", true);
        File sourceFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "src2" + File.separator + "X.java");
        File classFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "bin1" + File.separator + "X.class");
        new File(String.valueOf(OUTPUT_DIR) + File.separator + "src2").mkdirs();
        do {
            org.eclipse.jdt.core.tests.util.Util.writeToFile("public class X {\n}\n", sourceFile.getPath());
        } while (classFile.lastModified() >= sourceFile.lastModified());
        String sourceFilePath = "\"" + OUTPUT_DIR + File.separator + "Y.java\"";
        String commonOptions = " -classpath \"" + OUTPUT_DIR + File.separator + "bin1" + "\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src2" + "\"" + " -d \"" + OUTPUT_DIR + File.separator + "bin2" + "\"";
        this.runTest(false, new String[]{"Y.java", "public class Y {\n  public static void main (String[] args) {\n    System.out.println(X.CONST);\n  }\n}\n"}, String.valueOf(sourceFilePath) + commonOptions + " -proc:none ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/Y.java (at line 3)\n\tSystem.out.println(X.CONST);\n\t                     ^^^^^\nCONST cannot be resolved or is not a field\n----------\n1 problem (1 error)\n", false, null);
        if (RUN_JAVAC) {
            Iterator javacCompilersIterator = javacCompilers.iterator();
            String[] sourceFileNames = new String[]{sourceFilePath};
            File outputDir = new File(OUTPUT_DIR);
            while (javacCompilersIterator.hasNext()) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)javacCompilersIterator.next();
                BatchCompilerTest.assertFalse((javacCompiler.compile(outputDir, commonOptions, sourceFileNames, null) == 0L ? 1 : 0) != 0);
            }
            BatchCompilerTest.assertFalse((boolean)this.runJavac(commonOptions, new String[]{sourceFilePath}, OUTPUT_DIR));
        }
    }

    public void test232_repeated_classpath() throws IOException, InterruptedException {
        String commonOptions = " -d \"" + OUTPUT_DIR + File.separator + "bin" + "\" -classpath \"" + OUTPUT_DIR + File.separator + "src1";
        String combinedClasspathOptions = String.valueOf(commonOptions) + File.pathSeparator + OUTPUT_DIR + File.separator + "src2\" ";
        String splitClasspathOptions = String.valueOf(commonOptions) + "\" -classpath \"" + OUTPUT_DIR + File.separator + "src2\" ";
        String sourceFilePath = "\"" + OUTPUT_DIR + File.separator + "src3" + File.separator + "Z.java\"";
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n}\n", "src2/Y.java", "public class Y {\n}\n", "src3/Z.java", "public class Z {\n  X x;\n  Y y;\n}\n"}, String.valueOf(sourceFilePath) + " -proc:none " + combinedClasspathOptions, "", "", true, null);
        this.runTest(true, null, String.valueOf(sourceFilePath) + " -proc:none " + splitClasspathOptions, "", "", false, null);
        if (RUN_JAVAC) {
            Iterator javacCompilersIterator = javacCompilers.iterator();
            String[] sourceFileNames = new String[]{sourceFilePath};
            File outputDir = new File(OUTPUT_DIR);
            while (javacCompilersIterator.hasNext()) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)javacCompilersIterator.next();
                BatchCompilerTest.assertTrue((javacCompiler.compile(outputDir, combinedClasspathOptions, sourceFileNames, null) == 0L ? 1 : 0) != 0);
                BatchCompilerTest.assertFalse((javacCompiler.compile(outputDir, splitClasspathOptions, sourceFileNames, null) == 0L ? 1 : 0) != 0);
            }
        }
    }

    public void test233_repeated_sourcepath() throws IOException, InterruptedException {
        String commonOptions = " -d \"" + OUTPUT_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src1\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src2\"";
        String sourceFilePathZ = "\"" + OUTPUT_DIR + File.separator + "src3" + File.separator + "Z.java\"";
        String sourceFilePathW = "\"" + OUTPUT_DIR + File.separator + "src3" + File.separator + "W.java\"";
        this.runTest(false, new String[]{"src1/X.java", "public class X {\n}\n", "src2/Y.java", "public class Y {\n}\n", "src3/Z.java", "public class Z {\n  Y y;\n}\n", "src3/W.java", "public class W {\n  X x;\n  Y y;\n}\n"}, String.valueOf(sourceFilePathZ) + " -proc:none " + commonOptions, "", "duplicate sourcepath specification: -sourcepath ---OUTPUT_DIR_PLACEHOLDER---/src2\n", true, null);
        if (RUN_JAVAC) {
            Iterator javacCompilersIterator = javacCompilers.iterator();
            String[] sourceFileNamesZ = new String[]{sourceFilePathZ};
            String[] sourceFileNamesW = new String[]{sourceFilePathW};
            File outputDir = new File(OUTPUT_DIR);
            while (javacCompilersIterator.hasNext()) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)javacCompilersIterator.next();
                BatchCompilerTest.assertTrue((javacCompiler.compile(outputDir, commonOptions, sourceFileNamesZ, null) == 0L ? 1 : 0) != 0);
                BatchCompilerTest.assertFalse((javacCompiler.compile(outputDir, commonOptions, sourceFileNamesW, null) == 0L ? 1 : 0) != 0);
            }
        }
    }

    public void test234_sourcepath_vs_classpath() throws IOException, InterruptedException {
        String commonOptions = " -d \"" + OUTPUT_DIR + File.separator + "bin\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src1\"" + " -classpath \"" + OUTPUT_DIR + File.separator + "src2\" ";
        String sourceFilePath = "\"" + OUTPUT_DIR + File.separator + "src3" + File.separator + "Z.java\"";
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n}\n", "src2/Y.java", "public class Y {\n}\n", "src3/Z.java", "public class Z {\n  X x;\n  Y y;\n}\n"}, String.valueOf(sourceFilePath) + " -proc:none " + commonOptions, "", "", true, null);
        if (RUN_JAVAC) {
            Iterator javacCompilersIterator = javacCompilers.iterator();
            String[] sourceFileNames = new String[]{sourceFilePath};
            File outputDir = new File(OUTPUT_DIR);
            while (javacCompilersIterator.hasNext()) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)javacCompilersIterator.next();
                BatchCompilerTest.assertFalse((javacCompiler.compile(outputDir, commonOptions, sourceFileNames, null) == 0L ? 1 : 0) != 0);
            }
        }
    }

    public void test235_classpath() throws IOException, InterruptedException {
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  public static final int CONST = 1;\n}\n", "src2/X.java", "public class X {\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin1" + "\"", "", "", true, null);
        File sourceFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "src2" + File.separator + "X.java");
        File classFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "bin1" + File.separator + "X.class");
        while (classFile.lastModified() <= sourceFile.lastModified()) {
            this.runTest(true, null, "\"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin1" + "\"", "", "", false, null);
        }
        String sourceFilePath = "\"" + OUTPUT_DIR + File.separator + "Y.java\"";
        String commonOptions = " -classpath \"" + OUTPUT_DIR + File.separator + "src2" + File.pathSeparator + OUTPUT_DIR + File.separator + "bin1\"" + " -d \"" + OUTPUT_DIR + File.separator + "bin2" + "\"";
        this.runTest(false, new String[]{"Y.java", "public class Y {\n  public static void main (String[] args) {\n    System.out.println(X.CONST);\n  }\n}\n"}, String.valueOf(sourceFilePath) + " -proc:none " + commonOptions, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/Y.java (at line 3)\n\tSystem.out.println(X.CONST);\n\t                     ^^^^^\nCONST cannot be resolved or is not a field\n----------\n1 problem (1 error)\n", false, null);
        if (RUN_JAVAC) {
            Iterator javacCompilersIterator = javacCompilers.iterator();
            String[] sourceFileNames = new String[]{sourceFilePath};
            File outputDir = new File(OUTPUT_DIR);
            while (javacCompilersIterator.hasNext()) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)javacCompilersIterator.next();
                BatchCompilerTest.assertTrue((javacCompiler.compile(outputDir, commonOptions, sourceFileNames, null) == 0L ? 1 : 0) != 0);
            }
        }
    }

    public void test236_classpath() throws IOException, InterruptedException {
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  public static final int CONST = 1;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin1" + "\"", "", "", true, null);
        File bin1File = new File(String.valueOf(OUTPUT_DIR) + File.separator + "bin1" + File.separator + "X.class");
        File bin2File = new File(String.valueOf(OUTPUT_DIR) + File.separator + "bin2" + File.separator + "X.class");
        do {
            this.runTest(true, new String[]{"src2/X.java", "public class X {\n  public static final int CONST = 2;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src2" + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin2" + "\"", "", "", false, null);
        } while (bin2File.lastModified() <= bin1File.lastModified());
        String sourceFilePath = "\"" + OUTPUT_DIR + File.separator + "Y.java\"";
        String commonOptions = " -classpath \"" + OUTPUT_DIR + File.separator + "bin1" + File.pathSeparator + OUTPUT_DIR + File.separator + "bin2" + "\"" + " -d \"" + OUTPUT_DIR + File.separator + "bin" + "\"";
        this.runTest(true, new String[]{"Y.java", "public class Y {\n  public static void main (String[] args) {\n    System.out.println(X.CONST);\n  }\n}\n"}, String.valueOf(sourceFilePath) + commonOptions + " -proc:none ", "", "", false, null);
        this.verifier.execute("Y", new String[]{String.valueOf(OUTPUT_DIR) + File.separator + "bin"});
        BatchCompilerTest.assertTrue((boolean)this.verifier.getExecutionOutput().startsWith("1"));
        if (RUN_JAVAC) {
            Iterator javacCompilersIterator = javacCompilers.iterator();
            String[] sourceFileNames = new String[]{sourceFilePath};
            File outputDir = new File(OUTPUT_DIR);
            while (javacCompilersIterator.hasNext()) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)javacCompilersIterator.next();
                BatchCompilerTest.assertTrue((javacCompiler.compile(outputDir, commonOptions, sourceFileNames, null) == 0L ? 1 : 0) != 0);
                this.verifier.execute("Y", new String[]{String.valueOf(OUTPUT_DIR) + File.separator + "bin"});
                BatchCompilerTest.assertEquals((char)'1', (char)this.verifier.getExecutionOutput().charAt(0));
            }
        }
    }

    public void test237_classpath() throws IOException, InterruptedException {
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  public static final int CONST = 1;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin1" + "\"", "", "", true, null);
        File sourceFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "src2" + File.separator + "X.java");
        File classFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "bin1" + File.separator + "X.class");
        new File(String.valueOf(OUTPUT_DIR) + File.separator + "src2").mkdirs();
        do {
            org.eclipse.jdt.core.tests.util.Util.writeToFile("public class X {\n  public static final int CONST = 2;\n}\n", sourceFile.getPath());
        } while (classFile.lastModified() >= sourceFile.lastModified());
        String sourceFilePath = "\"" + OUTPUT_DIR + File.separator + "Y.java\"";
        String commonOptions = " -classpath \"" + OUTPUT_DIR + File.separator + "bin1" + File.pathSeparator + OUTPUT_DIR + File.separator + "src2" + "\"" + " -d \"" + OUTPUT_DIR + File.separator + "bin" + "\"";
        this.runTest(true, new String[]{"Y.java", "public class Y {\n  public static void main (String[] args) {\n    System.out.println(X.CONST);\n  }\n}\n"}, String.valueOf(sourceFilePath) + commonOptions + " -proc:none ", "", "", false, null);
        this.verifier.execute("Y", new String[]{String.valueOf(OUTPUT_DIR) + File.separator + "bin"});
        BatchCompilerTest.assertTrue((boolean)this.verifier.getExecutionOutput().startsWith("1"));
        if (RUN_JAVAC) {
            Iterator javacCompilersIterator = javacCompilers.iterator();
            String[] sourceFileNames = new String[]{sourceFilePath};
            File outputDir = new File(OUTPUT_DIR);
            while (javacCompilersIterator.hasNext()) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)javacCompilersIterator.next();
                BatchCompilerTest.assertTrue((javacCompiler.compile(outputDir, commonOptions, sourceFileNames, null) == 0L ? 1 : 0) != 0);
                this.verifier.execute("Y", new String[]{String.valueOf(OUTPUT_DIR) + File.separator + "bin"});
                BatchCompilerTest.assertEquals((char)'2', (char)this.verifier.getExecutionOutput().charAt(0));
            }
        }
    }

    public void test238_classpath() throws IOException, InterruptedException {
        new File(String.valueOf(OUTPUT_DIR) + File.separator + "src1").mkdirs();
        File sourceFile1 = new File(String.valueOf(OUTPUT_DIR) + File.separator + "src1" + File.separator + "X.java");
        File sourceFile2 = new File(String.valueOf(OUTPUT_DIR) + File.separator + "src2" + File.separator + "X.java");
        org.eclipse.jdt.core.tests.util.Util.writeToFile("public class X {\n  public static final int CONST = 1;\n}\n", sourceFile1.getPath());
        new File(String.valueOf(OUTPUT_DIR) + File.separator + "src2").mkdirs();
        do {
            org.eclipse.jdt.core.tests.util.Util.writeToFile("public class X {\n  public static final int CONST = 2;\n}\n", sourceFile2.getPath());
        } while (sourceFile1.lastModified() >= sourceFile2.lastModified());
        String sourceFilePath = "\"" + OUTPUT_DIR + File.separator + "Y.java\"";
        String commonOptions = " -classpath \"" + OUTPUT_DIR + File.separator + "src1" + File.pathSeparator + OUTPUT_DIR + File.separator + "src2" + "\"" + " -d \"" + OUTPUT_DIR + File.separator + "bin" + "\"";
        this.runTest(true, new String[]{"Y.java", "public class Y {\n  public static void main (String[] args) {\n    System.out.println(X.CONST);\n  }\n}\n"}, String.valueOf(sourceFilePath) + commonOptions + " -proc:none ", "", "", false, null);
        this.verifier.execute("Y", new String[]{String.valueOf(OUTPUT_DIR) + File.separator + "bin"});
        BatchCompilerTest.assertTrue((boolean)this.verifier.getExecutionOutput().startsWith("1"));
        if (RUN_JAVAC) {
            Iterator javacCompilersIterator = javacCompilers.iterator();
            String[] sourceFileNames = new String[]{sourceFilePath};
            File outputDir = new File(OUTPUT_DIR);
            while (javacCompilersIterator.hasNext()) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)javacCompilersIterator.next();
                BatchCompilerTest.assertTrue((javacCompiler.compile(outputDir, commonOptions, sourceFileNames, null) == 0L ? 1 : 0) != 0);
                this.verifier.execute("Y", new String[]{String.valueOf(OUTPUT_DIR) + File.separator + "bin"});
                BatchCompilerTest.assertEquals((char)'1', (char)this.verifier.getExecutionOutput().charAt(0));
            }
        }
    }

    public void test239_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n  B b;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib1.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    public void test240_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n  B b;\n  C c;\n  D d;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib3.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    public void test241_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runNegativeTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  int i = R.R2;\n  int j = R.R3;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib1.jar\"" + " -cp \"" + LIB_DIR + File.separator + "lib3.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 5)\n\tint j = R.R3;\n\t          ^^\nR3 cannot be resolved or is not a field\n----------\n1 problem (1 error)\n", true);
    }

    public void test242_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runNegativeTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  int i = R.R2;\n  int j = R.R3;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib4.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 5)\n\tint j = R.R3;\n\t          ^^\nR3 cannot be resolved or is not a field\n----------\n1 problem (1 error)\n", true);
    }

    public void test243_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n  B b;\n  C c;\n  D d;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib5.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    public void test244_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  C c;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib4.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    public void test245_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  F f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib8.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    public void test246_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n  F f;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib8.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    public void test247_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runNegativeTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  C c;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib8.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tC c;\n\t^\nC cannot be resolved to a type\n----------\n1 problem (1 error)\n", true);
    }

    public void test248_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n  G g;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib9.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "multiple Class-Path headers in manifest of jar file: ---LIB_DIR_PLACEHOLDER---/lib9.jar\n", true);
    }

    public void test249_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  C c;\n  G g;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib9.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "multiple Class-Path headers in manifest of jar file: ---LIB_DIR_PLACEHOLDER---/lib9.jar\n", true);
    }

    public void test250_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runNegativeTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n  B b;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -bootclasspath " + this.getLibraryClassesAsQuotedString() + File.pathSeparator + "\"" + LIB_DIR + File.separator + "lib1.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 5)\n\tB b;\n\t^\nB cannot be resolved to a type\n----------\n1 problem (1 error)\n", true);
    }

    public void test251_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib3.jar[~p/A]\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tA a;\n\t^\nDiscouraged access: The type 'A' is not API (restriction on classpath entry '---LIB_DIR_PLACEHOLDER---/lib3.jar')\n----------\n1 problem (1 warning)\n", true);
    }

    public void test252_progress() {
        this.runProgressTest(new String[]{"X.java", "public class X {\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -d \"" + OUTPUT_DIR + "\"", "", "", "----------\n[worked: 0 - remaining: 1]\nBeginning to compile\nProcessing ---OUTPUT_DIR_PLACEHOLDER---/X.java\n[worked: 1 - remaining: 0]\n----------\n");
    }

    public void test253_progress() {
        this.runProgressTest(new String[]{"Y.java", "public class Y {\n}\n", "X.java", "public class X extends Y {\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -cp " + File.pathSeparator + File.pathSeparator + "\"" + OUTPUT_DIR + "\"" + " -d \"" + OUTPUT_DIR + "\"", "", "", "----------\n[worked: 0 - remaining: 1]\nBeginning to compile\nProcessing ---OUTPUT_DIR_PLACEHOLDER---/X.java\n[worked: 1 - remaining: 1]\nProcessing ---OUTPUT_DIR_PLACEHOLDER---/Y.java\n[worked: 2 - remaining: 0]\n----------\n");
    }

    public void test254_progress() {
        this.runProgressTest(new String[]{"X.java", "public class X {\n}\n", "Y.java", "public class Y {\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " \"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -cp " + File.pathSeparator + File.pathSeparator + "\"" + OUTPUT_DIR + "\"" + " -d \"" + OUTPUT_DIR + "\"" + " -repeat 3", "[repetition 1/3]\n[repetition 2/3]\n[repetition 3/3]\n", "", "----------\n[worked: 0 - remaining: 6]\nBeginning to compile\nProcessing ---OUTPUT_DIR_PLACEHOLDER---/X.java\n[worked: 1 - remaining: 5]\nProcessing ---OUTPUT_DIR_PLACEHOLDER---/Y.java\n[worked: 2 - remaining: 4]\nBeginning to compile\nProcessing ---OUTPUT_DIR_PLACEHOLDER---/X.java\n[worked: 3 - remaining: 3]\nProcessing ---OUTPUT_DIR_PLACEHOLDER---/Y.java\n[worked: 4 - remaining: 2]\nBeginning to compile\nProcessing ---OUTPUT_DIR_PLACEHOLDER---/X.java\n[worked: 5 - remaining: 1]\nProcessing ---OUTPUT_DIR_PLACEHOLDER---/Y.java\n[worked: 6 - remaining: 0]\n----------\n");
    }

    public void test255_progress() {
        AbstractBatchCompilerTest.TestCompilationProgress progress = new AbstractBatchCompilerTest.TestCompilationProgress(){

            @Override
            public void worked(int workIncrement, int remainingWork) {
                if (remainingWork == 1) {
                    this.isCanceled = true;
                }
                super.worked(workIncrement, remainingWork);
            }
        };
        String setting = System.getProperty("jdt.compiler.useSingleThread");
        try {
            System.setProperty("jdt.compiler.useSingleThread", "true");
            this.runProgressTest(false, new String[]{"Y.java", "public class Y {\n}\n", "X.java", "public class X extends Y {\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -cp " + File.pathSeparator + File.pathSeparator + "\"" + OUTPUT_DIR + "\"" + " -d \"" + OUTPUT_DIR + "\"", "", "", progress, "----------\n[worked: 0 - remaining: 1]\nBeginning to compile\nProcessing ---OUTPUT_DIR_PLACEHOLDER---/X.java\n[worked: 1 - remaining: 1]\n----------\n");
        }
        catch (Throwable throwable) {
            System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
            throw throwable;
        }
        System.setProperty("jdt.compiler.useSingleThread", setting == null ? "false" : setting);
    }

    public void test256_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib3.jar[~p/A]\"" + " -cp \"" + LIB_DIR + File.separator + "lib1.jar[-p/A]\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tA a;\n\t^\nDiscouraged access: The type 'A' is not API (restriction on classpath entry '---LIB_DIR_PLACEHOLDER---/lib3.jar')\n----------\n1 problem (1 warning)\n", true);
    }

    public void test257_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib3.jar[-DUMMY]\"" + " -cp \"" + LIB_DIR + File.separator + "lib1.jar[-p/A]\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    public void test258_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib3.jar\"" + " -cp \"" + LIB_DIR + File.separator + "lib1.jar[-p/A]\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    public void test259_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  S1 s;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -sourcepath \"" + LIB_DIR + File.separator + "lib1.jar\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    public void test260_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runNegativeTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  S2 s;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -sourcepath \"" + LIB_DIR + File.separator + "lib1.jar\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tS2 s;\n\t^^\nS2 cannot be resolved to a type\n----------\n1 problem (1 error)\n", true);
    }

    public void test261_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runNegativeTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n  B b;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib10.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 5)\n\tB b;\n\t^\nB cannot be resolved to a type\n----------\n1 problem (1 error)\n", true);
    }

    public void test262_jar_ref_in_jar() {
        String currentWorkingDirectoryPath = System.getProperty("user.dir");
        if (currentWorkingDirectoryPath == null) {
            System.err.println("BatchCompilerTest#235 could not access the current working directory " + currentWorkingDirectoryPath);
        } else if (!new File(currentWorkingDirectoryPath).isDirectory()) {
            System.err.println("BatchCompilerTest#235 current working directory is not a directory " + currentWorkingDirectoryPath);
        } else {
            String lib1Path = String.valueOf(currentWorkingDirectoryPath) + File.separator + "lib1.jar";
            String lib2Path = String.valueOf(currentWorkingDirectoryPath) + File.separator + "lib2.jar";
            try {
                try {
                    org.eclipse.jdt.core.tests.util.Util.createJar(null, new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib2.jar\n"}, lib1Path, "1.4");
                    org.eclipse.jdt.core.tests.util.Util.createJar(new String[]{"p/A.java", "package p;\npublic class A {\n}"}, null, lib2Path, "1.4");
                    this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp lib1.jar" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
                }
                catch (IOException iOException) {
                    System.err.println("BatchCompilerTest#235 could not write to current working directory " + currentWorkingDirectoryPath);
                    new File(lib1Path).delete();
                    new File(lib2Path).delete();
                }
            }
            finally {
                new File(lib1Path).delete();
                new File(lib2Path).delete();
            }
        }
    }

    public void test263_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runTest(true, new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -classpath \"" + LIB_DIR + File.separator + "lib11.jar\"" + " -1.5 -g -preserveAllLocals" + " -verbose -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", ONE_FILE_GENERATED_MATCHER, new StringMatcher("invalid Class-Path header in manifest of jar file: ---LIB_DIR_PLACEHOLDER---/lib11.jar\n", outputDirNormalizer), true);
    }

    public void test264_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runTest(false, new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -classpath \"" + LIB_DIR + File.separator + "lib12.jar\"" + " -1.5 -g -preserveAllLocals" + " -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "invalid Class-Path header in manifest of jar file: ---LIB_DIR_PLACEHOLDER---/lib12.jar\n----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tA a;\n\t^\nA cannot be resolved to a type\n----------\n1 problem (1 error)\n", true, null);
    }

    public void test265_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runTest(false, new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -classpath \"" + LIB_DIR + File.separator + "lib13.jar\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "invalid Class-Path header in manifest of jar file: ---LIB_DIR_PLACEHOLDER---/lib13.jar\n----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tA a;\n\t^\nA cannot be resolved to a type\n----------\n1 problem (1 error)\n", true, null);
    }

    public void test266_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runTest(false, new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -classpath \"" + LIB_DIR + File.separator + "lib14.jar\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tA a;\n\t^\nA cannot be resolved to a type\n----------\n1 problem (1 error)\n", true, null);
    }

    public void test267_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runTest(false, new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -classpath \"" + LIB_DIR + File.separator + "lib15.jar\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "invalid Class-Path header in manifest of jar file: ---LIB_DIR_PLACEHOLDER---/lib15.jar\n----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tA a;\n\t^\nA cannot be resolved to a type\n----------\n1 problem (1 error)\n", true, null);
    }

    public void test268_jar_ref_in_jar() {
        try {
            ManifestAnalyzer analyzer = new ManifestAnalyzer();
            BatchCompilerTest.assertTrue((boolean)this.analyzeManifestContents(analyzer, "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib1.jar\n\nClass-Path: lib3.jar\n"));
            BatchCompilerTest.assertEquals((int)2, (int)analyzer.getClasspathSectionsCount());
            BatchCompilerTest.assertEquals((int)2, (int)analyzer.getCalledFileNames().size());
        }
        catch (IOException e) {
            e.printStackTrace();
            BatchCompilerTest.fail();
        }
    }

    public void test269_jar_ref_in_jar() {
        try {
            ManifestAnalyzer analyzer = new ManifestAnalyzer();
            BatchCompilerTest.assertTrue((boolean)this.analyzeManifestContents(analyzer, "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib1.jar\nDummy:\nClass-Path: lib3.jar\n"));
            BatchCompilerTest.assertEquals((int)2, (int)analyzer.getClasspathSectionsCount());
            BatchCompilerTest.assertEquals((int)2, (int)analyzer.getCalledFileNames().size());
        }
        catch (IOException e) {
            e.printStackTrace();
            BatchCompilerTest.fail();
        }
    }

    public void test270_jar_ref_in_jar() {
        try {
            ManifestAnalyzer analyzer = new ManifestAnalyzer();
            BatchCompilerTest.assertTrue((boolean)this.analyzeManifestContents(analyzer, "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: lib1.jar\tlib2.jar\n"));
            BatchCompilerTest.assertEquals((int)1, (int)analyzer.getClasspathSectionsCount());
            BatchCompilerTest.assertEquals((int)1, (int)analyzer.getCalledFileNames().size());
        }
        catch (IOException e) {
            e.printStackTrace();
            BatchCompilerTest.fail();
        }
    }

    public void test271_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n  B b;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib16.jar\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    public void test272_jar_ref_in_jar() {
        try {
            ManifestAnalyzer analyzer = new ManifestAnalyzer();
            BatchCompilerTest.assertTrue((boolean)this.analyzeManifestContents(analyzer, "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: \n            lib1.jar       \n\n"));
            BatchCompilerTest.assertEquals((int)1, (int)analyzer.getClasspathSectionsCount());
            BatchCompilerTest.assertEquals((int)1, (int)analyzer.getCalledFileNames().size());
        }
        catch (IOException e) {
            e.printStackTrace();
            BatchCompilerTest.fail();
        }
    }

    public void test273_jar_ref_in_jar() {
        try {
            ManifestAnalyzer analyzer = new ManifestAnalyzer();
            BatchCompilerTest.assertTrue((boolean)this.analyzeManifestContents(analyzer, "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: \n \n            lib1.jar       \n \n            lib1.jar       \n\n"));
            BatchCompilerTest.assertEquals((int)1, (int)analyzer.getClasspathSectionsCount());
            BatchCompilerTest.assertEquals((int)2, (int)analyzer.getCalledFileNames().size());
        }
        catch (IOException e) {
            e.printStackTrace();
            BatchCompilerTest.fail();
        }
    }

    public void test274_jar_ref_in_jar() {
        try {
            ManifestAnalyzer analyzer = new ManifestAnalyzer();
            BatchCompilerTest.assertFalse((boolean)this.analyzeManifestContents(analyzer, "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: \n            lib1.jar"));
        }
        catch (IOException e) {
            e.printStackTrace();
            BatchCompilerTest.fail();
        }
    }

    public void test275_jar_ref_in_jar() {
        try {
            BatchCompilerTest.assertFalse((boolean)this.analyzeManifestContents(new ManifestAnalyzer(), "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path: \n \n            lib1.jar"));
        }
        catch (IOException e) {
            e.printStackTrace();
            BatchCompilerTest.fail();
        }
    }

    private boolean analyzeManifestContents(ManifestAnalyzer manifestAnalyzer, String string) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes());){
            boolean bl = manifestAnalyzer.analyzeManifestContents((InputStream)stream);
            return bl;
        }
    }

    public void test276_jar_ref_in_jar() {
        try {
            BatchCompilerTest.assertFalse((boolean)this.analyzeManifestContents(new ManifestAnalyzer(), "Manifest-Version: 1.0\nCreated-By: Eclipse JDT Test Harness\nClass-Path:      \nlib1.jar"));
        }
        catch (IOException e) {
            e.printStackTrace();
            BatchCompilerTest.fail();
        }
    }

    public void test277_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runNegativeTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n  B b;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -extdirs \"" + LIB_DIR + File.separator + "dir\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 5)\n\tB b;\n\t^\nB cannot be resolved to a type\n----------\n1 problem (1 error)\n", true);
    }

    public void test278_jar_ref_in_jar() {
        this.createCascadedJars();
        this.runNegativeTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n  B b;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -endorseddirs \"" + LIB_DIR + File.separator + "dir\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 5)\n\tB b;\n\t^\nB cannot be resolved to a type\n----------\n1 problem (1 error)\n", true);
    }

    public void test279_sourcepath_vs_classpath() throws IOException, InterruptedException {
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  public static final int CONST = 1;\n}\n", "src2/X.java", "public class X {\n  public static final int CONST = 2;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin1" + "\"", "", "", true, null);
        File sourceFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "src2" + File.separator + "X.java");
        File classFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "bin1" + File.separator + "X.class");
        while (classFile.lastModified() <= sourceFile.lastModified()) {
            this.runConformTest(null, "\"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin1" + "\"", "", "", false);
        }
        this.runConformTest(new String[]{"Y.java", "public class Y {\n  public static void main (String[] args) {\n    System.out.println(X.CONST);\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src2[?**/*]" + "\"" + " -classpath \"" + OUTPUT_DIR + File.separator + "bin1" + "\"" + " -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", false);
        this.verifier.execute("Y", new String[]{OUTPUT_DIR});
        BatchCompilerTest.assertTrue((boolean)this.verifier.getExecutionOutput().startsWith("1"));
    }

    public void test280_sourcepath_vs_classpath() throws IOException, InterruptedException {
        this.runTest(true, new String[]{"src1/X.java", "public class X {\n  public static final int CONST = 1;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src1" + File.separator + "X.java\"" + " -proc:none -d \"" + OUTPUT_DIR + File.separator + "bin1" + "\"", "", "", true, null);
        File sourceFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "src2" + File.separator + "X.java");
        File classFile = new File(String.valueOf(OUTPUT_DIR) + File.separator + "bin1" + File.separator + "X.class");
        new File(String.valueOf(OUTPUT_DIR) + File.separator + "src2").mkdirs();
        do {
            org.eclipse.jdt.core.tests.util.Util.writeToFile("public class X {\n  public static final int CONST = 2;\n}\n", sourceFile.getPath());
        } while (classFile.lastModified() >= sourceFile.lastModified());
        this.runConformTest(new String[]{"Y.java", "public class Y {\n  public static void main (String[] args) {\n    System.out.println(X.CONST);\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "Y.java\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src2[?**/*]" + "\"" + " -classpath \"" + OUTPUT_DIR + File.separator + "bin1" + "\"" + " -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", false);
        this.verifier.execute("Y", new String[]{OUTPUT_DIR});
        BatchCompilerTest.assertTrue((boolean)this.verifier.getExecutionOutput().startsWith("1"));
    }

    public void test281_classpath() {
        this.runConformTest(new String[]{"src1/X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src1/X.java\" -cp Y.java", "", "incorrect classpath: Y.java\n", false);
    }

    public void test282_classpath() {
        this.runConformTest(new String[]{"src1/X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src1/X.java\" -cp p/Y.java", "", "incorrect classpath: p/Y.java\n", false);
    }

    public void test283_classpath() {
        this.runConformTest(new String[]{"src1/X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src1/X.java\" -cp Y.class", "", "incorrect classpath: Y.class\n", false);
    }

    public void test284_classpath() {
        this.runConformTest(new String[]{"src1/X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src1/X.java\" -cp p/Y.class", "", "incorrect classpath: p/Y.class\n", false);
    }

    public void test285_option_files() {
        this.runConformTest(new String[]{"X.java", "public @interface X {\n}", "options.txt", "-source 1.5"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" " + "\"@" + OUTPUT_DIR + File.separator + "options.txt\"", "", "", true);
    }

    public void test286_option_files() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n}", "options.txt", "-source 1.4"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" " + "\"@" + OUTPUT_DIR + File.separator + "options.txt\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\tpublic @interface X {\n\t                  ^\nSyntax error, annotation declarations are only available if source level is 1.5 or greater\n----------\n1 problem (1 error)\n", true);
    }

    public void test287_option_files() {
        this.runNegativeTest(new String[]{"X.java", "public @interface X {\n}", "options1.txt", "@options2.txt", "options2.txt", "@options1.txt"}, "\"" + OUTPUT_DIR + File.separator + "X.java\" " + "\"@" + OUTPUT_DIR + File.separator + "options1.txt\"", "", "Unrecognized option : @options2.txt\n", true);
    }

    public void test288_warn_options() {
        this.runConformTest(new String[]{"X.java", "interface IX {}\nclass BaseX implements IX {}\npublic class X extends BaseX implements IX {\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:+intfRedundant -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tpublic class X extends BaseX implements IX {\n\t                                        ^^\nRedundant superinterface IX for the type X, already defined by BaseX\n----------\n1 problem (1 warning)\n", true);
    }

    public void test289_warn_options() {
        this.runConformTest(new String[]{"X.java", "interface IX {}\nclass BaseX implements IX {}\npublic class X extends BaseX implements IX {\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:+redundantSuperinterface -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tpublic class X extends BaseX implements IX {\n\t                                        ^^\nRedundant superinterface IX for the type X, already defined by BaseX\n----------\n1 problem (1 warning)\n", true);
    }

    public void test290_warn_options() {
        this.runConformTest(new String[]{"X.java", "interface IX {}\nclass BaseX implements IX {}\npublic class X extends BaseX implements IX {\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:+intfRedundant -warn:-intfRedundant -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test291_jar_ref_in_jar() throws Exception {
        ManifestAnalyzer analyzer = new ManifestAnalyzer();
        BatchCompilerTest.assertTrue((boolean)this.analyzeManifestContents(analyzer, "Manifest-Version: 1.0\r\nCreated-By: Eclipse JDT Test Harness\r\nClass-Path: \r\n\r\n"));
        List calledFileNames = analyzer.getCalledFileNames();
        String actual = calledFileNames == null ? "<null>" : org.eclipse.jdt.core.tests.util.Util.toString(calledFileNames.toArray(new String[calledFileNames.size()]), false);
        BatchCompilerTest.assertStringEquals("<null>", actual, true);
    }

    public void test292_warn_options() {
        this.runConformTest(new String[]{"X.java", "interface A {\n  void m();\n}interface B extends A{\n  void m();\n}public class X implements A{\n  public void m(){}\n  public String toString(){return \"HelloWorld\";}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:allOver-ann -1.6 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tvoid m();\n\t     ^^^\nThe method m() of type B should be tagged with @Override since it actually overrides a superinterface method\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tpublic void m(){}\n\t            ^^^\nThe method m() of type X should be tagged with @Override since it actually overrides a superinterface method\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tpublic String toString(){return \"HelloWorld\";}\n\t              ^^^^^^^^^^\nThe method toString() of type X should be tagged with @Override since it actually overrides a superclass method\n----------\n3 problems (3 warnings)\n", true);
    }

    public void test293_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tvoid foo(Object a, Object b, Object c) {\n\t\tassert a == null;\n \t\tif (a!=null) {\n\t\t\tSystem.out.println(\"a is not null\");\n\t\t } else{\n\t\t\tSystem.out.println(\"a is null\");\n\t\t }\n\t\ta = null;\n\t\tif (a== null) {}\n\t\tassert b != null;\n \t\tif (b!=null) {\n\t\t\tSystem.out.println(\"b is not null\");\n\t\t } else{\n\t\t\tSystem.out.println(\"b is null\");\n\t\t }\n\t\tassert c == null;\n\t\tif (c.equals(a)) {\n\t\t\tSystem.out.println(\"\");\n\t\t } else{\n\t\t\tSystem.out.println(\"\");\n\t\t }\n\t}\n\tpublic static void main(String[] args){\n\t\tX test = new X();\n\t\ttest.foo(null,null, null);\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:null,includeAssertNull -1.5 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tif (a!=null) {\n\t    ^\nNull comparison always yields false: The variable a can only be null at this location\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 9)\n\ta = null;\n\t^\nRedundant assignment: The variable a can only be null at this location\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 10)\n\tif (a== null) {}\n\t    ^\nRedundant null check: The variable a can only be null at this location\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 12)\n\tif (b!=null) {\n\t    ^\nRedundant null check: The variable b cannot be null at this location\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 18)\n\tif (c.equals(a)) {\n\t    ^\nNull pointer access: The variable c can only be null at this location\n----------\n5 problems (5 warnings)\n", true);
    }

    public void test294_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int field1;\n\tpublic static int field2;\n\tpublic void bar(int i) {\n\t\tSystem.out.println(foo());\n\t\tfoo();\t\tSystem.out.println(X.field1);\n\t\tSystem.out.println(field2);\n\t\tfield2 = 1;\n\t}\n\tprivate static String foo() {\n\t\treturn null;\n\t}\n\tprivate void foo1() {\n\t\tSystem.out.println();\n\t}\n\tpublic final void foo2() {\n\t\tSystem.out.println();\n\t}\n}\nfinal class A {\tpublic void foo() {\n\t\tSystem.out.println();\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:static-method -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 13)\n\tprivate void foo1() {\n\t             ^^^^^^\nThe method foo1() from the type X can be declared as static\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 16)\n\tpublic final void foo2() {\n\t                  ^^^^^^\nThe method foo2() from the type X can be declared as static\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 20)\n\tfinal class A {\tpublic void foo() {\n\t               \t            ^^^^^\nThe method foo() from the type A can be declared as static\n----------\n3 problems (3 warnings)\n", true);
    }

    public void test295_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static int field1;\n\tpublic static int field2;\n\tpublic void bar(int i) {\n\t\tSystem.out.println(foo());\n\t\tfoo();\t\tSystem.out.println(X.field1);\n\t\tSystem.out.println(field2);\n\t\tfield2 = 1;\n\t}\n\tprivate static String foo() {\n\t\treturn null;\n\t}\n\tprivate void foo1() {\n\t\tSystem.out.println();\n\t}\n\tpublic final void foo2() {\n\t\tSystem.out.println();\n\t}\n}\nfinal class A {\tpublic void foo() {\n\t\tSystem.out.println();\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:all-static-method -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tpublic void bar(int i) {\n\t            ^^^^^^^^^^\nThe method bar(int) from the type X can potentially be declared as static\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 13)\n\tprivate void foo1() {\n\t             ^^^^^^\nThe method foo1() from the type X can be declared as static\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 16)\n\tpublic final void foo2() {\n\t                  ^^^^^^\nThe method foo2() from the type X can be declared as static\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 20)\n\tfinal class A {\tpublic void foo() {\n\t               \t            ^^^^^\nThe method foo() from the type A can be declared as static\n----------\n4 problems (4 warnings)\n", true);
    }

    public void test293() {
        this.createCascadedJars();
        this.runNegativeTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib3.jar[~p/A]\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo -err:+discouraged" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tA a;\n\t^\nDiscouraged access: The type 'A' is not API (restriction on classpath entry '---LIB_DIR_PLACEHOLDER---/lib3.jar')\n----------\n1 problem (1 error)\n", true);
    }

    public void test294() {
        this.runConformTest(new String[]{"src/X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -cp \"" + LIB_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo -err:+discouraged2" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "invalid error token: 'discouraged2'. Ignoring this error token and compiling\n", true);
    }

    public void test296() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -cp \"" + LIB_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo -err:" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "invalid error configuration: '-err:'\n", true);
    }

    public void test297() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -cp \"" + LIB_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo -err" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "invalid error configuration: '-err'\n", true);
    }

    public void test298() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unused\")\n\tprivate int i;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -err:+unused,suppress -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test299() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unused\")\n\tprivate int i;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -err:+unused -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. INFO in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\t@SuppressWarnings(\"unused\")\n\t                  ^^^^^^^^\nAt least one of the problems in category 'unused' is not analysed due to a compiler option being ignored\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate int i;\n\t            ^\nThe value of the field X.i is not used\n----------\n2 problems (1 error, 0 warnings, 1 info)\n", true);
    }

    public void test300() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unused\")\n\tprivate int i;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -warn:-suppress -err:+suppress,unused -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test301() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unused\")\n\tprivate int i;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -warn:-suppress -err:+unused -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate int i;\n\t            ^\nThe value of the field X.i is not used\n----------\n1 problem (1 error)\n", true);
    }

    public void test302() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unused\")\n\tprivate int i;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -warn:-suppress -err:+suppress,unused -warn:-suppress -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate int i;\n\t            ^\nThe value of the field X.i is not used\n----------\n1 problem (1 error)\n", true);
    }

    public void test303() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unused\")\n\tprivate int i;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -warn:-suppress -err:+suppress,unused -warn:+suppress -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. INFO in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\t@SuppressWarnings(\"unused\")\n\t                  ^^^^^^^^\nAt least one of the problems in category 'unused' is not analysed due to a compiler option being ignored\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate int i;\n\t            ^\nThe value of the field X.i is not used\n----------\n2 problems (1 error, 0 warnings, 1 info)\n", true);
    }

    public void test304() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t@SuppressWarnings(\"unused\")\n\tprivate int i;\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -err:+suppress,unused -warn:-suppress -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tprivate int i;\n\t            ^\nThe value of the field X.i is not used\n----------\n1 problem (1 error)\n", true);
    }

    public void test305() {
        this.runConformTest(new String[]{"src/X.java", "public class X {}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -encoding UTF-8 -1.5 -g -encoding ISO-8859-1", "Found encoding ISO-8859-1. A different encoding was specified: UTF-8\nMultiple encoding specified: ISO-8859-1, UTF-8. The default encoding has been set to ISO-8859-1\n", "", true);
    }

    public void test306() {
        this.runConformTest(new String[]{"src/X.java", "public class X {}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -encoding UTF-8 -1.5 -encoding Cp1252 -g -encoding ISO-8859-1", "Found encoding Cp1252. A different encoding was specified: UTF-8\nFound encoding ISO-8859-1. Different encodings were specified: Cp1252, UTF-8\nMultiple encoding specified: Cp1252, ISO-8859-1, UTF-8. The default encoding has been set to ISO-8859-1\n", "", true);
    }

    public void test0307() {
        String os = System.getProperty("os.name");
        if (!os.startsWith("Windows")) {
            return;
        }
        String javaClassspath = System.getProperty("java.class.path");
        String javaUserDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", OUTPUT_DIR);
            this.runConformTest(new String[]{"p/Y.java", "package p;\npublic class Y { public class I {}; }"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "", true);
            System.setProperty("java.class.path", "");
            this.runConformTest(new String[]{"X.java", "import p.Y.I;\npublic class X {\n   I i;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "no classpath defined, using default directory instead\n", false);
            String userDir = System.getProperty("user.dir");
            File f = new File(userDir, "X.java");
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f)) {
                System.out.println("Could not delete X");
            }
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f = new File(userDir, "p" + File.separator + "Y.java"))) {
                System.out.println("Could not delete Y");
            }
        }
        finally {
            System.setProperty("java.class.path", javaClassspath);
            System.setProperty("user.dir", javaUserDir);
        }
    }

    public void test0307a() {
        String os = System.getProperty("os.name");
        if (!os.startsWith("Windows")) {
            return;
        }
        String javaClassspath = System.getProperty("java.class.path");
        String javaUserDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", OUTPUT_DIR);
            this.runConformTest(new String[]{"P/Y.java", "package P;\npublic class Y { public class I {}; }"}, "\"" + OUTPUT_DIR + File.separator + "P" + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "", true);
            System.setProperty("java.class.path", "");
            this.runNegativeTest(new String[]{"X.java", "import p.Y.I;\npublic class X {\n   I i;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "no classpath defined, using default directory instead\n----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport p.Y.I;\n\t       ^^^\nThe import p.Y cannot be resolved\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tI i;\n\t^\nI cannot be resolved to a type\n----------\n2 problems (2 errors)\n", false);
            String userDir = System.getProperty("user.dir");
            File f = new File(userDir, "X.java");
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f)) {
                System.out.println("Could not delete X");
            }
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f = new File(userDir, "p" + File.separator + "Y.java"))) {
                System.out.println("Could not delete Y");
            }
        }
        finally {
            System.setProperty("java.class.path", javaClassspath);
            System.setProperty("user.dir", javaUserDir);
        }
    }

    public void test0307b() {
        String os = System.getProperty("os.name");
        if (!os.startsWith("Windows")) {
            return;
        }
        String javaClassspath = System.getProperty("java.class.path");
        String javaUserDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", OUTPUT_DIR);
            this.runConformTest(new String[]{"p/y.java", "package p;\npublic class y { public class I {}; }"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "y.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "", true);
            System.setProperty("java.class.path", "");
            this.runNegativeTest(new String[]{"X.java", "import p.Y.I;\npublic class X {\n   I i;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "no classpath defined, using default directory instead\n----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport p.Y.I;\n\t       ^^^\nThe import p.Y cannot be resolved\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tI i;\n\t^\nI cannot be resolved to a type\n----------\n2 problems (2 errors)\n", false);
            String userDir = System.getProperty("user.dir");
            File f = new File(userDir, "X.java");
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f)) {
                System.out.println("Could not delete X");
            }
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f = new File(userDir, "p" + File.separator + "Y.java"))) {
                System.out.println("Could not delete Y");
            }
        }
        finally {
            System.setProperty("java.class.path", javaClassspath);
            System.setProperty("user.dir", javaUserDir);
        }
    }

    public void test0307c() {
        String os = System.getProperty("os.name");
        if (!os.startsWith("Windows")) {
            return;
        }
        String javaClassspath = System.getProperty("java.class.path");
        String javaUserDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", OUTPUT_DIR);
            this.runConformTest(new String[]{"p/Y.java", "package p;\npublic class Y { public class i {}; }"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "", true);
            System.setProperty("java.class.path", "");
            this.runNegativeTest(new String[]{"X.java", "import p.Y.I;\npublic class X {\n   I i;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "no classpath defined, using default directory instead\n----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport p.Y.I;\n\t       ^^^^^\nThe import p.Y.I cannot be resolved\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tI i;\n\t^\nI cannot be resolved to a type\n----------\n2 problems (2 errors)\n", false);
            String userDir = System.getProperty("user.dir");
            File f = new File(userDir, "X.java");
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f)) {
                System.out.println("Could not delete X");
            }
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f = new File(userDir, "p" + File.separator + "Y.java"))) {
                System.out.println("Could not delete Y");
            }
        }
        finally {
            System.setProperty("java.class.path", javaClassspath);
            System.setProperty("user.dir", javaUserDir);
        }
    }

    public void test0307d() {
        String os = System.getProperty("os.name");
        if (!os.startsWith("Windows")) {
            return;
        }
        String javaClassspath = System.getProperty("java.class.path");
        String javaUserDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", OUTPUT_DIR);
            this.runConformTest(new String[]{"p/Y.java", "package P;\npublic class Y { public class I {}; }"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "", true);
            System.setProperty("java.class.path", "");
            this.runNegativeTest(new String[]{"X.java", "import p.Y.I;\npublic class X {\n   I i;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "no classpath defined, using default directory instead\n----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport p.Y.I;\n\t       ^^^\nThe import p.Y cannot be resolved\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tI i;\n\t^\nI cannot be resolved to a type\n----------\n2 problems (2 errors)\n", false);
            String userDir = System.getProperty("user.dir");
            File f = new File(userDir, "X.java");
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f)) {
                System.out.println("Could not delete X");
            }
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f = new File(userDir, "p" + File.separator + "Y.java"))) {
                System.out.println("Could not delete Y");
            }
        }
        finally {
            System.setProperty("java.class.path", javaClassspath);
            System.setProperty("user.dir", javaUserDir);
        }
    }

    public void test0307e() {
        String os = System.getProperty("os.name");
        if (!os.startsWith("Windows")) {
            return;
        }
        String javaClassspath = System.getProperty("java.class.path");
        String javaUserDir = System.getProperty("user.dir");
        try {
            System.setProperty("user.dir", OUTPUT_DIR);
            this.runConformTest(new String[]{"p/Y.java", "package P;\npublic class Y { public class I {}; }"}, "\"" + OUTPUT_DIR + File.separator + "P" + File.separator + "Y.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "", true);
            System.setProperty("java.class.path", "");
            this.runNegativeTest(new String[]{"X.java", "import p.Y.I;\npublic class X {\n   I i;\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"\");\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -g -preserveAllLocals -proceedOnError -referenceInfo ", "", "no classpath defined, using default directory instead\n----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\timport p.Y.I;\n\t       ^^^\nThe import p.Y cannot be resolved\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tI i;\n\t^\nI cannot be resolved to a type\n----------\n2 problems (2 errors)\n", false);
            String userDir = System.getProperty("user.dir");
            File f = new File(userDir, "X.java");
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f)) {
                System.out.println("Could not delete X");
            }
            if (!org.eclipse.jdt.core.tests.util.Util.delete(f = new File(userDir, "p" + File.separator + "Y.java"))) {
                System.out.println("Could not delete Y");
            }
        }
        finally {
            System.setProperty("java.class.path", javaClassspath);
            System.setProperty("user.dir", javaUserDir);
        }
    }

    public void testInferenceIn14Project() {
        String currentWorkingDirectoryPath = System.getProperty("user.dir");
        if (currentWorkingDirectoryPath == null) {
            BatchCompilerTest.fail((String)("BatchCompilerTest#testInference14 could not access the current working directory " + currentWorkingDirectoryPath));
        } else if (!new File(currentWorkingDirectoryPath).isDirectory()) {
            BatchCompilerTest.fail((String)("BatchCompilerTest#testInference14 current working directory is not a directory " + currentWorkingDirectoryPath));
        }
        String lib1Path = String.valueOf(currentWorkingDirectoryPath) + File.separator + "lib1.jar";
        try {
            try {
                org.eclipse.jdt.core.tests.util.Util.createJar(new String[]{"Bundle.java", "public class Bundle {\n    static <A> A adapt(Class<A> type) {\n        return null;\n    }\n}"}, null, lib1Path, "1.5");
                this.runNegativeTest(new String[]{"src/X.java", "public class X {\n    Bundle b = Bundle.adapt(BundleWiring.class);\n}\nclass BundleWiring {}\n"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -cp lib1.jar" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.4 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/X.java (at line 2)\n\tBundle b = Bundle.adapt(BundleWiring.class);\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from Object to Bundle\n----------\n1 problem (1 error)\n", true);
            }
            catch (IOException iOException) {
                System.err.println("BatchCompilerTest#testInference14 could not write to current working directory " + currentWorkingDirectoryPath);
                new File(lib1Path).delete();
            }
        }
        finally {
            new File(lib1Path).delete();
        }
    }

    public void testInferenceIn15Project() {
        String currentWorkingDirectoryPath = System.getProperty("user.dir");
        if (currentWorkingDirectoryPath == null) {
            BatchCompilerTest.fail((String)("BatchCompilerTest#testInference14 could not access the current working directory " + currentWorkingDirectoryPath));
        } else if (!new File(currentWorkingDirectoryPath).isDirectory()) {
            BatchCompilerTest.fail((String)("BatchCompilerTest#testInference14 current working directory is not a directory " + currentWorkingDirectoryPath));
        }
        String lib1Path = String.valueOf(currentWorkingDirectoryPath) + File.separator + "lib1.jar";
        try {
            try {
                org.eclipse.jdt.core.tests.util.Util.createJar(new String[]{"Bundle.java", "public class Bundle {\n    static <A> A adapt(Class<A> type) {\n        return null;\n    }\n}"}, null, lib1Path, "1.5");
                this.runNegativeTest(new String[]{"src/X.java", "public class X {\n    Bundle b = Bundle.adapt(BundleWiring.class);\n}\nclass BundleWiring {}\n"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -cp lib1.jar" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/X.java (at line 2)\n\tBundle b = Bundle.adapt(BundleWiring.class);\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from BundleWiring to Bundle\n----------\n1 problem (1 error)\n", true);
            }
            catch (IOException iOException) {
                System.err.println("BatchCompilerTest#testInference14 could not write to current working directory " + currentWorkingDirectoryPath);
                new File(lib1Path).delete();
            }
        }
        finally {
            new File(lib1Path).delete();
        }
    }

    public void test186565() {
        String outputDirName = String.valueOf(OUTPUT_DIR) + File.separator + "d";
        String metaInfDirName = String.valueOf(outputDirName) + File.separator + "META-INF";
        String jarFileName = String.valueOf(outputDirName) + File.separator + "classB15.jar";
        this.runConformTest(new String[]{"d/B.java", "public class B<T> extends A<T> {\n}", "d/A.java", "public class A<T> {\n}"}, "\"" + outputDirName + "\"" + " -1.5 -g -preserveAllLocals" + " -d \"" + outputDirName + "\"", "", "", true);
        File outputDirectory = new File(outputDirName);
        File metaInfDirectory = new File(metaInfDirName);
        metaInfDirectory.mkdirs();
        try {
            org.eclipse.jdt.core.tests.util.Util.createFile(String.valueOf(metaInfDirName) + File.separator + "MANIFEST.MF", "Manifest-Version: 1.0\nClass-Path: ../d/classB15.jar\n");
        }
        catch (IOException iOException) {
            BatchCompilerTest.fail((String)"could not create manifest file");
        }
        org.eclipse.jdt.core.tests.util.Util.delete(String.valueOf(outputDirName) + File.separator + "A.class");
        org.eclipse.jdt.core.tests.util.Util.delete(String.valueOf(outputDirName) + File.separator + "A.java");
        try {
            org.eclipse.jdt.core.tests.util.Util.zip(outputDirectory, jarFileName);
        }
        catch (IOException iOException) {
            BatchCompilerTest.fail((String)"could not create jar file");
        }
        org.eclipse.jdt.core.tests.util.Util.delete(String.valueOf(outputDirName) + File.separator + "B.class");
        org.eclipse.jdt.core.tests.util.Util.delete(String.valueOf(outputDirName) + File.separator + "B.java");
        this.runConformTest(new String[]{"d/A.java", "public class A {\n}", "d/C.java", "public class C extends B<String> {\n}"}, "\"" + outputDirName + "\"" + " -1.5 -g -preserveAllLocals" + " -cp \"" + jarFileName + "\"" + " -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void testBridgeMethodRetention() {
        String currentWorkingDirectoryPath = System.getProperty("user.dir");
        if (currentWorkingDirectoryPath == null) {
            BatchCompilerTest.fail((String)("BatchCompilerTest#testBridgeMethodRetention could not access the current working directory " + currentWorkingDirectoryPath));
        } else if (!new File(currentWorkingDirectoryPath).isDirectory()) {
            BatchCompilerTest.fail((String)("BatchCompilerTest#testBridgeMethodRetention current working directory is not a directory " + currentWorkingDirectoryPath));
        }
        String lib1Path = String.valueOf(currentWorkingDirectoryPath) + File.separator + "lib1.jar";
        try {
            try {
                org.eclipse.jdt.core.tests.util.Util.createJar(new String[]{"Comparable.java", "public interface Comparable<T> {\n    public int compareTo(T o);\n}\n", "Character.java", "public class Character implements Comparable<Character> {\n\tpublic int compareTo(Character obj) {\n\t\treturn 0;\n\t}\n}\n"}, null, lib1Path, "1.5");
                this.runConformTest(new String[]{"src/X.java", "public class X {\n    Object fValue;\n    public int compareTo(Object obj) {\n            return ((Character)fValue).compareTo(obj);\n    }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -cp lib1.jar" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.4 -g -preserveAllLocals" + " -proceedOnError -referenceInfo" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
            }
            catch (IOException iOException) {
                System.err.println("BatchCompilerTest#testBridgeMethodRetention could not write to current working directory " + currentWorkingDirectoryPath);
                new File(lib1Path).delete();
            }
        }
        finally {
            new File(lib1Path).delete();
        }
    }

    public void testReportingUnavoidableGenericProblems() {
        this.runNegativeTest(new String[]{"X.java", "interface Adaptable {\n    public Object getAdapter(Class clazz);    \n}\npublic class X implements Adaptable {\n    public Object getAdapter(Class clazz) {\n        return null;\n    }\n    Zork z;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -warn:-unavoidableGenericProblems -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tpublic Object getAdapter(Class clazz);    \n\t                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2 problems (1 error, 1 warning)\n", true);
    }

    public void testReportingUnavoidableGenericProblems2() {
        this.runNegativeTest(new String[]{"X.java", "interface Adaptable {\n    public Object getAdapter(Class clazz);    \n}\npublic class X implements Adaptable {\n    public Object getAdapter(Class clazz) {\n        return null;\n    }\n    Zork z;\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -1.5 -warn:+unavoidableGenericProblems -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tpublic Object getAdapter(Class clazz);    \n\t                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 5)\n\tpublic Object getAdapter(Class clazz) {\n\t                         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 8)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3 problems (1 error, 2 warnings)\n", true);
    }

    public void test0308_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n  void foo() throws java.io.IOException {\n      FileReader r = new FileReader(\"f1\");\n      char[] cs = new char[1024];\n\t   r.read(cs);\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:-resource -1.7 -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test0309_warn_options() {
        this.runConformTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n  void foo(boolean b) throws java.io.IOException {\n      FileReader r = new FileReader(\"f1\");\n      char[] cs = new char[1024];\n\t   r.read(cs);\n      if (b) r.close();\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:+resource -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 4)\n\tFileReader r = new FileReader(\"f1\");\n\t           ^\nPotential resource leak: 'r' may not be closed\n----------\n1 problem (1 warning)\n", true);
    }

    public void test310_warn_options() {
        this.runConformTest(new String[]{"X.java", "class X { synchronized void foo() {} }\nclass Y extends X { @Override void foo() { } }"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:syncOverride -1.5 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tclass Y extends X { @Override void foo() { } }\n\t                                   ^^^^^\nThe method Y.foo() is overriding a synchronized method without being synchronized\n----------\n1 problem (1 warning)\n", true);
    }

    public void test310b_warn_options() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void bar() { new X() { @Override void foo() {} }; }\n  synchronized void foo() { }\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -warn:syncOverride -1.5 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tvoid bar() { new X() { @Override void foo() {} }; }\n\t                                      ^^^^^\nThe method new X(){}.foo() is overriding a synchronized method without being synchronized\n----------\n1 problem (1 warning)\n", true);
    }

    public void test312_warn_options() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@SuppressWarnings(\"unused\")\npublic class X {\n\tpublic void test() { Object o = null; o.toString();}\n  @NonNull Object foo(@Nullable Object o, @NonNull Object o2) {\n    if (o.toString() == \"\"){ return null;}\n    if (o2 == null) {}\n    goo(null).toString();\n\t Object local = null;\n\t o.toString();\n\t return null;\n  }\n  @Nullable Object goo(@NonNull Object o2) {\n    return new Object();\n  }\n  @NonNullByDefault Object hoo(Object o2) {\n    if (o2 == null){}\n    if (o2 == null){\n\t    return null;\n\t }\n\t return new Object();\n  }\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface NonNull{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface Nullable{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ PACKAGE, TYPE, METHOD, CONSTRUCTOR })\n@interface NonNullByDefault{\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -1.5" + " -warn:+nullAnnot(p.Nullable|p.NonNull|p.NonNullByDefault) -warn:+null -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 6)\n\tpublic void test() { Object o = null; o.toString();}\n\t                                      ^\nNull pointer access: The variable o can only be null at this location\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 8)\n\tif (o.toString() == \"\"){ return null;}\n\t    ^\nPotential null pointer access: The variable o may be null at this location\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 8)\n\tif (o.toString() == \"\"){ return null;}\n\t                                ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\tif (o2 == null) {}\n\t    ^^\nNull comparison always yields false: The variable o2 is specified as @NonNull\n----------\n5. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 10)\n\tgoo(null).toString();\n\t^^^^^^^^^\nPotential null pointer access: The method goo(Object) may return null\n----------\n6. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 10)\n\tgoo(null).toString();\n\t    ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n7. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 13)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n8. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 19)\n\tif (o2 == null){}\n\t    ^^\nNull comparison always yields false: The variable o2 is specified as @NonNull\n----------\n9. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 20)\n\tif (o2 == null){\n\t    ^^\nNull comparison always yields false: The variable o2 is specified as @NonNull\n----------\n9 problems (9 warnings)\n", true);
    }

    public void test317_warn_options() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nenum Color { RED, GREEN };\npublic class X {\n     int getVal(Color c) {\n         switch (c) {\n             case RED: return 1;\n             default : return 0;\n         }\n     }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:+enumSwitchPedantic -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 5)\n\tswitch (c) {\n\t        ^\nThe enum constant GREEN should have a corresponding case label in this enum switch on Color. To suppress this problem, add a comment //$CASES-OMITTED$ on the line above the 'default:'\n----------\n1 problem (1 warning)\n", true);
    }

    public void test318_warn_options() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nenum Color { RED, GREEN };\npublic class X {\n     int getVal(Color c) {\n         switch (c) {\n             case RED: return 1;\n             default : return 0;\n         }\n     }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -err:+enumSwitchPedantic -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 5)\n\tswitch (c) {\n\t        ^\nThe enum constant GREEN should have a corresponding case label in this enum switch on Color. To suppress this problem, add a comment //$CASES-OMITTED$ on the line above the 'default:'\n----------\n1 problem (1 error)\n", true);
    }

    public void test319_warn_options() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nenum Color { RED, GREEN };\npublic class X {\n     int getVal(Color c) {\n         switch (c) {\n             case RED: return 1;\n             case GREEN : return 2;\n         }\n         return 0;\n     }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:+switchDefault -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 5)\n\tswitch (c) {\n\t        ^\nThe switch over the enum type Color should have a default case\n----------\n1 problem (1 warning)\n", true);
    }

    public void test317_nowarn_options() {
        this.runConformTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -warn:javadoc -nowarn:[\"" + OUTPUT_DIR + File.separator + "src" + "\"] -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test318_nowarn_options() {
        this.runConformTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}", "src2/Y.java", "public class Y {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " \"" + OUTPUT_DIR + File.separator + "src2/Y.java\"" + " -warn:javadoc -nowarn:[" + "\"" + OUTPUT_DIR + File.separator + "src" + "\"] -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src2/Y.java (at line 3)\n\t@param\n\t ^^^^^\nJavadoc: Missing parameter name\n----------\n1 problem (1 warning)\n", true);
    }

    public void test319_nowarn_options() {
        this.runConformTest(new String[]{"src1/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}", "src2/Y.java", "public class Y {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src1/X.java\"" + " \"" + OUTPUT_DIR + File.separator + "src2/Y.java\"" + " -warn:javadoc -nowarn:[" + "\"" + OUTPUT_DIR + File.separator + "src1\"" + File.pathSeparator + "\"" + OUTPUT_DIR + File.separator + "src2\"] -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test320_nowarn_options() {
        this.runConformTest(new String[]{"src1/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}", "src2/Y.java", "public class Y {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src1/X.java\"" + " \"" + OUTPUT_DIR + File.separator + "src2/Y.java\"" + " -warn:javadoc -nowarn:[" + "\"" + OUTPUT_DIR + File.separator + "src1\"] -nowarn:[" + "\"" + OUTPUT_DIR + File.separator + "src2\"] " + "-proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test321_nowarn_options() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -warn:javadoc -nowarn: -proc:none -d \"" + OUTPUT_DIR + "\"", "", "invalid syntax for nowarn option: -nowarn:\n", true);
    }

    public void test322_nowarn_options() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -warn:javadoc -nowarn:[ -proc:none -d \"" + OUTPUT_DIR + "\"", "", "invalid syntax for nowarn option: -nowarn:[\n", true);
    }

    public void test323_nowarn_options() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -warn:javadoc -nowarn:[src -proc:none -d \"" + OUTPUT_DIR + "\"", "", "invalid syntax for nowarn option: -nowarn:[src\n", true);
    }

    public void test324_nowarn_options() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -warn:javadoc -nowarn:src] -proc:none -d \"" + OUTPUT_DIR + "\"", "", "invalid syntax for nowarn option: -nowarn:src]\n", true);
    }

    public void test325_nowarn_options() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -warn:javadoc -nowarn[src] -proc:none -d \"" + OUTPUT_DIR + "\"", "", "invalid syntax for nowarn option: -nowarn[src]\n", true);
    }

    public void test326_nowarn_options() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -warn:javadoc -nowarn:[src1]src2 -proc:none -d \"" + OUTPUT_DIR + "\"", "", "invalid syntax for nowarn option: -nowarn:[src1]src2\n", true);
    }

    public void test327_nowarn_options() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -warn:javadoc -nowarn:[] -proc:none -d \"" + OUTPUT_DIR + "\"", "", "invalid syntax for nowarn option: -nowarn:[]\n", true);
    }

    public void test328_nowarn_options() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n    a++;\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -warn:javadoc -nowarn:[" + "\"" + OUTPUT_DIR + File.separator + "src]\" -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/X.java (at line 6)\n\ta++;\n\t^\na cannot be resolved to a variable\n----------\n1 problem (1 error)\n", true);
    }

    public void test329_nowarn_options() {
        this.runConformTest(new String[]{"src/X.java", "public class X {\n  /**\n    @param\n  */\n  public void foo() {\n    // TODO nothing\n  }\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -warn:javadoc,tasks(TODO) -nowarn:[" + "\"" + OUTPUT_DIR + File.separator + "src]\" -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/X.java (at line 6)\n\t// TODO nothing\n\t   ^^^^^^^^^^^^\nTODO nothing\n----------\n1 problem (1 warning)\n", true);
    }

    public void test330_warn_options() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport java.util.Map;\npublic class X {\n  Integer foo(Map<String,Integer> map) {\n\t return map.get(3);\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:-unlikelyCollectionMethodArgumentType -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test331_warn_options() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  boolean foo() {\n\t return \"three\".equals(3);\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -info:-unlikelyEqualsArgumentType -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void testBug375409a() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n/** \n* Description {@see String}, {@category cat}\n* @param a\n*/\npublic void foo(int i) {}}\n"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:invalidJavadoc -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 4)\n\t* Description {@see String}, {@category cat}\n\t                ^^^\nJavadoc: Unexpected tag\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 4)\n\t* Description {@see String}, {@category cat}\n\t                               ^^^^^^^^\nJavadoc: Unexpected tag\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 5)\n\t* @param a\n\t         ^\nJavadoc: Parameter a is not declared\n----------\n3 problems (3 warnings)\n", true);
    }

    public void testBug375409b() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n/** \n* Description {@see String}, {@category cat}\n* @param a\n*/\npublic void foo(int i) {}}\n"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:missingJavadocTags,missingJavadocTagsVisibility(public) -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 7)\n\tpublic void foo(int i) {}}\n\t                    ^\nJavadoc: Missing tag for parameter i\n----------\n1 problem (1 warning)\n", true);
    }

    public void testBug375409c() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n/** \n* Description {@see String}, {@category cat}\n* @param a\n*/\npublic void foo(int i) {}}\n"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:missingJavadocComments -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 2)\n\tpublic class X {\n\t             ^\nJavadoc: Missing comment for public declaration\n----------\n1 problem (1 warning)\n", true);
    }

    public void testBug375409d() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n/** \n* Description {@see String}, {@category cat}\n* @param a\n*/\nvoid foo(int i) {}\n/** \n* Description {@see String}, {@category cat}\n* @param a\n*/\npublic void foo2(int i2) {}}\n"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:missingJavadocTags,missingJavadocTagsVisibility(public) -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 12)\n\tpublic void foo2(int i2) {}}\n\t                     ^^\nJavadoc: Missing tag for parameter i2\n----------\n1 problem (1 warning)\n", true);
    }

    public void testBug375409e() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\npublic class X {\n  @NonNull Object foo(@Nullable Object o, @NonNull Object o2) {\n\t Object o3 = new X().bar();\n\t return o3;\n  }\n  @Nullable Object bar() {\n\t return null;\n  }\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface NonNull{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface Nullable{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ PACKAGE, TYPE, METHOD, CONSTRUCTOR })\n@interface NonNullByDefault{\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -1.5" + " -warn:+nullAnnot(p.Nullable|p.NonNull|p.NonNullByDefault),+null,-nullAnnotConflict " + "-proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void testBug375409f() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@NonNullByDefault public class X {\n  @NonNull Object foo() {\n\t return null;\n  }\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface NonNull{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface Nullable{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ PACKAGE, TYPE, METHOD, CONSTRUCTOR })\n@interface NonNullByDefault{\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -1.5" + " -warn:+nullAnnot(p.Nullable|p.NonNull|p.NonNullByDefault),+null,-nullAnnotRedundant " + "-proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 6)\n\treturn null;\n\t       ^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is null\n----------\n1 problem (1 warning)\n", true);
    }

    public void testBug375409g() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\npublic class X {\n  @NonNull Object foo(@Nullable Object o, @NonNull Object o2) {\n\t return new X().bar();\n  }\n  Object bar() {\n\t return null;\n  }\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface NonNull{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface Nullable{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ PACKAGE, TYPE, METHOD, CONSTRUCTOR })\n@interface NonNullByDefault{\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -1.5" + " -warn:+nullAnnot(p.Nullable|p.NonNull|p.NonNullByDefault) -warn:+null -warn:-nullUncheckedConversion " + "-proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void testBug375366a() throws IOException {
        this.createOutputTestDirectory("regression/.settings");
        org.eclipse.jdt.core.tests.util.Util.createFile(String.valueOf(OUTPUT_DIR) + "/.settings/org.eclipse.jdt.core.prefs", "eclipse.preferences.version=1\norg.eclipse.jdt.core.compiler.problem.unusedParameter=warning\n");
        this.runConformTest(new String[]{"bugs/warning/ShowBug.java", "package bugs.warning;\n\npublic class ShowBug {\n\t/**\n\t * \n\t * @param unusedParam\n\t */\n\tpublic void foo(Object unusedParam) {\n\t\t\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "bugs" + File.separator + "warning" + File.separator + "ShowBug.java\"" + " -1.5" + " -properties " + OUTPUT_DIR + File.separator + ".settings" + File.separator + "org.eclipse.jdt.core.prefs " + " -d \"" + OUTPUT_DIR + "\"", "", "", false);
    }

    public void testBug375366b() throws IOException {
        this.createOutputTestDirectory("regression/.settings");
        org.eclipse.jdt.core.tests.util.Util.createFile(String.valueOf(OUTPUT_DIR) + "/.settings/org.eclipse.jdt.core.prefs", "eclipse.preferences.version=1\norg.eclipse.jdt.core.compiler.problem.unusedParameter=warning\norg.eclipse.jdt.core.compiler.doc.comment.support=disabled\n");
        this.runTest(true, new String[]{"bugs/warning/ShowBug.java", "package bugs.warning;\n\npublic class ShowBug {\n\t/**\n\t * \n\t * @param unusedParam\n\t */\n\tpublic void foo(Object unusedParam) {\n\t\t\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "bugs" + File.separator + "warning" + File.separator + "ShowBug.java\"" + " -1.5" + " -properties " + OUTPUT_DIR + File.separator + ".settings" + File.separator + "org.eclipse.jdt.core.prefs " + " -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/bugs/warning/ShowBug.java (at line 8)\n\tpublic void foo(Object unusedParam) {\n\t                       ^^^^^^^^^^^\nThe value of the parameter unusedParam is not used\n----------\n1 problem (1 warning)\n", false, null);
    }

    public void test385780_warn_option() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\npublic <S> X() {\n}\npublic void ph(int t) {\n}\n}\ninterface doNothingInterface<T> {\n}\nclass doNothing {\npublic <T> void doNothingMethod() {}\n}\nclass noerror {\npublic <T> void doNothing(T t) {}}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:unusedTypeParameter -proc:none -1.7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 1)\n\tpublic class X<T> {\n\t               ^\nUnused type parameter T\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 2)\n\tpublic <S> X() {\n\t        ^\nUnused type parameter S\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 7)\n\tinterface doNothingInterface<T> {\n\t                             ^\nUnused type parameter T\n----------\n4. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 10)\n\tpublic <T> void doNothingMethod() {}\n\t        ^\nUnused type parameter T\n----------\n4 problems (4 warnings)\n", true);
    }

    public void test405225_extdirs() {
        if (AbstractCompilerTest.isJRE9) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n  void foo() throws java.io.IOException {\n      FileReader r = new FileReader(\"f1\");\n      char[] cs = new char[1024];\n\t   r.read(cs);\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -warn:-resource -1.7 -extdirs \"" + LIB_DIR + "\" -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test408038a() {
        this.runConformTest(new String[]{"externalizable/warning/X.java", "package externalizable.warning;\n\npublic class X {\n\tprivate class Y {\n\t\tstatic final int i = 10;\n\t\tpublic Y() {}\n\t\tpublic Y(int x) {System.out.println(x);}\n\t}\n\n\tpublic void zoo() {\n\t\tSystem.out.println(Y.i);\n\t\tY y = new Y(5);\n\t\tSystem.out.println(y);\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "externalizable" + File.separator + "warning" + File.separator + "X.java\"" + " -1.6 -d none", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/externalizable/warning/X.java (at line 6)\n\tpublic Y() {}\n\t       ^^^\nThe constructor X.Y() is never used locally\n----------\n1 problem (1 warning)\n", true);
    }

    public void test408038b() {
        this.runConformTest(new String[]{"externalizable/warning/X.java", "package externalizable.warning;\n\npublic class X {\n\tprivate static class Y {\n\t\tstatic final int i = 10;\n\t\tpublic Y() {}\n\t\tpublic Y(int x) {System.out.println(x);}\n\t}\n\n\tpublic void zoo() {\n\t\tSystem.out.println(Y.i);\n\t\tY y = new Y(5);\n\t\tSystem.out.println(y);\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "externalizable" + File.separator + "warning" + File.separator + "X.java\"" + " -1.6 -d none", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/externalizable/warning/X.java (at line 6)\n\tpublic Y() {}\n\t       ^^^\nThe constructor X.Y() is never used locally\n----------\n1 problem (1 warning)\n", true);
    }

    public void test408038c() {
        this.runConformTest(new String[]{"externalizable/warning/X.java", "package externalizable.warning;\nimport java.io.Externalizable;\nimport java.io.IOException;\nimport java.io.ObjectInput;\nimport java.io.ObjectOutput;\n\npublic class X {\n\tprivate static class Y implements Externalizable {\n\t\tstatic final int i = 10;\n\t\tpublic Y() {}\n\t\tpublic Y(int x) {System.out.println(x);}\n\n\t\t@Override\n\t\tpublic void writeExternal(ObjectOutput out) throws IOException {\n\t\t}\n\n\t\t@Override\n\t\tpublic void readExternal(ObjectInput in) throws IOException,\n\t\tClassNotFoundException {\n\t\t}\n\t}\n\n\tpublic void zoo() {\n\t\tSystem.out.println(Y.i);\n\t\tY y = new Y(5);\n\t\tSystem.out.println(y);\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "externalizable" + File.separator + "warning" + File.separator + "X.java\"" + " -1.6 -d none", "", "", true);
    }

    public void test408038d() {
        this.runConformTest(new String[]{"externalizable/warning/X.java", "package externalizable.warning;\nimport java.io.Externalizable;\nimport java.io.IOException;\nimport java.io.ObjectInput;\nimport java.io.ObjectOutput;\n\npublic class X {\n\tprivate class Y implements Externalizable {\n\t\tstatic final int i = 10;\n\t\tpublic Y() {}\n\t\tpublic Y(int x) {System.out.println(x);}\n\n\t\t@Override\n\t\tpublic void writeExternal(ObjectOutput out) throws IOException {\n\t\t}\n\n\t\t@Override\n\t\tpublic void readExternal(ObjectInput in) throws IOException,\n\t\tClassNotFoundException {\n\t\t}\n\t}\n\n\tpublic void zoo() {\n\t\tSystem.out.println(Y.i);\n\t\tY y = new Y(5);\n\t\tSystem.out.println(y);\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "externalizable" + File.separator + "warning" + File.separator + "X.java\"" + " -1.6 -d none", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/externalizable/warning/X.java (at line 10)\n\tpublic Y() {}\n\t       ^^^\nThe constructor X.Y() is never used locally\n----------\n1 problem (1 warning)\n", true);
    }

    public void test408038e() {
        this.runConformTest(new String[]{"externalizable/warning/X.java", "package externalizable.warning;\nclass X {\n\tint i;\n\tprivate X(int x) {i = x;}\n\tX() {}\n\tpublic int foo() {\n\t\tX x = new X();\n\t\treturn x.i;\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "externalizable" + File.separator + "warning" + File.separator + "X.java\"" + " -1.6 -d none", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/externalizable/warning/X.java (at line 4)\n\tprivate X(int x) {i = x;}\n\t        ^^^^^^^^\nThe constructor X(int) is never used locally\n----------\n1 problem (1 warning)\n", true);
    }

    public void testBug419351() {
        String backup = System.getProperty("java.endorsed.dirs");
        if (backup == null) {
            return;
        }
        String endorsedPath = String.valueOf(LIB_DIR) + File.separator + "endorsed";
        new File(endorsedPath).mkdir();
        String lib1Path = String.valueOf(endorsedPath) + File.separator + "lib1.jar";
        try {
            try {
                System.setProperty("java.endorsed.dirs", endorsedPath);
                org.eclipse.jdt.core.tests.util.Util.createJar(new String[]{"java/lang/String.java", "package java.lang;\npublic class String {\n    public String(java.lang.Object obj) {}\n}\n"}, null, lib1Path, "1.5");
                this.runConformTest(new String[]{"src/X.java", "public class X {\n    public void foo(Object obj) {\n        java.lang.String str = new java.lang.String(obj);\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.4 -nowarn" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
            }
            catch (IOException iOException) {
                System.setProperty("java.endorsed.dirs", backup);
                new File(endorsedPath).delete();
                new File(lib1Path).delete();
            }
        }
        finally {
            System.setProperty("java.endorsed.dirs", backup);
            new File(endorsedPath).delete();
            new File(lib1Path).delete();
        }
    }

    public void test501457() throws IOException {
        this.runConformTest(new String[]{"FailingClass.java", "import java.lang.invoke.MethodHandle;\nimport java.util.ArrayList;\npublic class FailingClass {\n  protected void test(MethodHandle handle) throws Throwable {\n        handle.invoke(null, new ArrayList<>());\n    }\n}\n"}, " -1.8  -sourcepath \"" + OUTPUT_DIR + "\" " + "\"" + OUTPUT_DIR + File.separator + "FailingClass.java", "", "", true);
    }

    public void test439750() {
        this.runConformTest(new String[]{"externalizable/warning/X.java", "import java.io.FileInputStream;\nimport java.io.IOException;\nclass X {\n\tpublic static void main(String[] args) {\n\t\tFileInputStream fis = null;\n\t\ttry {\n\t\t\tfis = new FileInputStream(\"xyz\");\n\t\t\tSystem.out.println(\"fis\");\n\t\t} catch (IOException e) {\n\t\t\te.printStackTrace();\n\t\t} finally {\n\t\t\ttry {\n\t\t\t\tif (fis != null) fis.close();\n\t\t\t} catch (Exception e) {}\n\t\t}\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "externalizable" + File.separator + "warning" + File.separator + "X.java\"" + " -1.6 -warn:unused -warn:unusedExceptionParam -d none", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/externalizable/warning/X.java (at line 14)\n\t} catch (Exception e) {}\n\t                   ^\nThe value of the exception parameter e is not used\n----------\n1 problem (1 warning)\n", true);
    }

    public void testFileSystem_findSecondaryInClass() {
        File testScratchAreaFile = new File(org.eclipse.jdt.core.tests.util.Util.getOutputDirectory(), "fileSystemTestScratchArea");
        try {
            if (!testScratchAreaFile.exists()) {
                testScratchAreaFile.mkdirs();
            }
            BatchCompilerTest.assertTrue((boolean)testScratchAreaFile.exists());
            FileSystem.Classpath classpath = FileSystem.getClasspath((String)testScratchAreaFile.getPath(), null, null);
            BatchCompilerTest.assertNotNull((Object)classpath);
            BatchCompilerTest.assertTrue((boolean)(classpath instanceof ClasspathDirectory));
            ClasspathDirectory classpathDirectory = (ClasspathDirectory)classpath;
            NameEnvironmentAnswer answer = classpathDirectory.findSecondaryInClass(TypeConstants.PACKAGE_INFO_NAME, null, null);
            BatchCompilerTest.assertNull((Object)answer);
            try {
                classpathDirectory.findSecondaryInClass("X".toCharArray(), null, null);
                BatchCompilerTest.fail((String)"An exception is expected, because the parameter qualifiedPackageName can not be NULL!");
            }
            catch (Exception exception) {}
        }
        finally {
            if (testScratchAreaFile.exists()) {
                org.eclipse.jdt.core.tests.util.Util.delete(testScratchAreaFile);
            }
        }
    }

    public void test496137a() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib3.jar[~p/A]\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo -info:+discouraged" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "----------\n1. INFO in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 4)\n\tA a;\n\t^\nDiscouraged access: The type 'A' is not API (restriction on classpath entry '---LIB_DIR_PLACEHOLDER---/lib3.jar')\n----------\n1 problem (1 info)\n", true);
    }

    public void test496137b() {
        this.runConformTest(new String[]{"src/X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -cp \"" + LIB_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo -info:+discouraged2" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "invalid info token: 'discouraged2'. Ignoring this info token and compiling\n", true);
    }

    public void test496137c() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -cp \"" + LIB_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo -info:" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "invalid info configuration: '-info:'\n", true);
    }

    public void test496137d() {
        this.runNegativeTest(new String[]{"src/X.java", "public class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/X.java\"" + " -cp \"" + LIB_DIR + "\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo -info" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "invalid info configuration: '-info'\n", true);
    }

    public void test496137e() throws IOException {
        this.createOutputTestDirectory("regression/.settings");
        org.eclipse.jdt.core.tests.util.Util.createFile(String.valueOf(OUTPUT_DIR) + "/.settings/org.eclipse.jdt.core.prefs", "eclipse.preferences.version=1\norg.eclipse.jdt.core.compiler.problem.unusedParameter=info\norg.eclipse.jdt.core.compiler.doc.comment.support=disabled\n");
        this.runTest(true, new String[]{"bugs/warning/ShowBug.java", "package bugs.warning;\n\npublic class ShowBug {\n\t/**\n\t * \n\t * @param unusedParam\n\t */\n\tpublic void foo(Object unusedParam) {\n\t\t\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "bugs" + File.separator + "warning" + File.separator + "ShowBug.java\"" + " -1.5" + " -properties " + OUTPUT_DIR + File.separator + ".settings" + File.separator + "org.eclipse.jdt.core.prefs " + " -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. INFO in ---OUTPUT_DIR_PLACEHOLDER---/bugs/warning/ShowBug.java (at line 8)\n\tpublic void foo(Object unusedParam) {\n\t                       ^^^^^^^^^^^\nThe value of the parameter unusedParam is not used\n----------\n1 problem (1 info)\n", false, null);
    }

    public void test496137f() {
        this.createCascadedJars();
        this.runConformTest(new String[]{"src/p/X.java", "package p;\n/** */\npublic class X {\n  A a;\n}"}, "\"" + OUTPUT_DIR + File.separator + "src/p/X.java\"" + " -cp \"" + LIB_DIR + File.separator + "lib3.jar[~p/A]\"" + " -sourcepath \"" + OUTPUT_DIR + File.separator + "src\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -referenceInfo -info:+discouraged -warn:none" + " -d \"" + OUTPUT_DIR + File.separator + "bin\" ", "", "", true);
    }

    private static class LinesRangeNormalizer
    extends AbstractBatchCompilerTest.Normalizer {
        private int first;
        private int number;

        LinesRangeNormalizer() {
            super(null);
            this.number = 0;
            this.first = 0;
        }

        LinesRangeNormalizer(AbstractBatchCompilerTest.Normalizer nextInChain) {
            super(nextInChain);
            this.number = 0;
            this.first = 0;
        }

        LinesRangeNormalizer(AbstractBatchCompilerTest.Normalizer nextInChain, int firstLineToRemove, int linesNumber) {
            super(nextInChain);
            this.first = firstLineToRemove;
            this.number = linesNumber >= 0 ? linesNumber : 0;
        }

        @Override
        String normalized(String originalValue) {
            String result;
            if (this.number == 0 || originalValue.length() == 0) {
                result = super.normalized(originalValue);
            } else {
                int state = 0;
                int currentLineIndex = 0;
                int currentCharIndex = 0;
                char currentChar = '\u0000';
                state = this.first <= 0 ? 3 : 1;
                StringBuffer normalizedValueBuffer = new StringBuffer();
                StringBuffer source = new StringBuffer(originalValue);
                int sourceLength = source.length();
                block16: while (state != 5 && state != 6) {
                    if (currentCharIndex < sourceLength) {
                        currentChar = source.charAt(currentCharIndex++);
                        block0 : switch (currentChar) {
                            case '\r': {
                                switch (state) {
                                    case 1: {
                                        normalizedValueBuffer.append(currentChar);
                                        state = 2;
                                        break block0;
                                    }
                                    case 3: {
                                        state = 4;
                                        break block0;
                                    }
                                }
                                state = 6;
                                break;
                            }
                            case '\n': {
                                ++currentLineIndex;
                                switch (state) {
                                    case 1: 
                                    case 2: {
                                        normalizedValueBuffer.append(currentChar);
                                        if (currentLineIndex != this.first) continue block16;
                                        state = 3;
                                        break;
                                    }
                                    case 3: 
                                    case 4: {
                                        if (currentLineIndex >= this.first + this.number) {
                                            if (currentCharIndex < sourceLength) {
                                                normalizedValueBuffer.append(source.substring(currentCharIndex));
                                            }
                                            state = 5;
                                            break;
                                        }
                                        state = 3;
                                        break;
                                    }
                                    default: {
                                        state = 6;
                                        break;
                                    }
                                }
                                continue block16;
                            }
                            default: {
                                switch (state) {
                                    case 1: {
                                        normalizedValueBuffer.append(currentChar);
                                        break block0;
                                    }
                                    case 3: {
                                        break block0;
                                    }
                                }
                                state = 6;
                                break;
                            }
                        }
                        continue;
                    }
                    state = currentChar == '\n' ? 5 : 6;
                }
                if (state == 6) {
                    normalizedValueBuffer.append("UNEXPECTED ERROR in LinesRangeNormalizer");
                }
                result = super.normalized(normalizedValueBuffer.toString());
            }
            return result;
        }
    }

    static class StringMatcher
    extends AbstractBatchCompilerTest.Matcher {
        private String expected;
        private AbstractBatchCompilerTest.Normalizer normalizer;

        StringMatcher(String expected, AbstractBatchCompilerTest.Normalizer normalizer) {
            this.expected = expected;
            this.normalizer = normalizer;
        }

        @Override
        boolean match(String effective) {
            if (this.expected == null) {
                return effective == null;
            }
            if (this.normalizer == null) {
                return this.expected.equals(effective);
            }
            return this.expected.equals(this.normalizer.normalized(effective));
        }

        @Override
        String expected() {
            return this.expected;
        }
    }

    static class SubstringMatcher
    extends AbstractBatchCompilerTest.Matcher {
        private String substring;

        SubstringMatcher(String substring) {
            this.substring = substring;
        }

        @Override
        boolean match(String effective) {
            return (effective = outputDirNormalizer.normalized(effective)).indexOf(this.substring) != -1;
        }

        @Override
        String expected() {
            return "*" + this.substring + "*";
        }
    }

    private static class XMLClasspathsSectionNormalizer
    extends AbstractBatchCompilerTest.Normalizer {
        XMLClasspathsSectionNormalizer() {
            super(null);
        }

        XMLClasspathsSectionNormalizer(AbstractBatchCompilerTest.Normalizer nextInChain) {
            super(nextInChain);
        }

        @Override
        String normalized(String originalValue) {
            StringBuffer normalizedValueBuffer = new StringBuffer(originalValue);
            int classpathsStartTagStart = normalizedValueBuffer.indexOf("<classpaths>");
            int classpathsEndTagStart = normalizedValueBuffer.indexOf("</classpaths>");
            if (classpathsStartTagStart != -1 && classpathsEndTagStart != -1 && classpathsStartTagStart < classpathsEndTagStart) {
                normalizedValueBuffer.replace(classpathsStartTagStart + 12, classpathsEndTagStart, "NORMALIZED SECTION");
            }
            String result = super.normalized(normalizedValueBuffer.toString());
            return result;
        }
    }
}

