/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.HashMap;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class Deprecated9Test
extends AbstractRegressionTest {
    public Deprecated9Test(String name) {
        super(name);
    }

    public static Test suite() {
        return Deprecated9Test.buildMinimalComplianceTestSuite(Deprecated9Test.testClass(), 64);
    }

    public void test002() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "ignore");
        this.runNegativeTest(true, new String[]{"p/M1.java", "package p;\npublic class M1 {\n  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n", "a/N1.java", "package a;\npublic class N1 {\n  @Deprecated(since=\"1.2\",forRemoval=true)\n  public class N2 {    public void foo() {}    public class N3 {      public void foo() {}    }  }}\n"}, null, customOptions, "----------\n1. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t     ^^\nThe type N1.N2 has been deprecated and marked for removal\n----------\n2. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t        ^^\nThe type N1.N2.N3 has been deprecated and marked for removal\n----------\n3. ERROR in p\\M1.java (at line 5)\n\tm.foo();\n\t  ^^^^^\nThe method foo() from the type N1.N2.N3 has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test004() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        this.runNegativeTest(true, new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t@Deprecated(forRemoval=true,since=\"3\")\n\tpublic static int x = 5, y= 10;\n}", "test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in test1\\E02.java (at line 4)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x has been deprecated and marked for removal\n----------\n2. ERROR in test1\\E02.java (at line 5)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005a() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        this.runNegativeTest(true, new String[]{"p1/X.java", "package p1;\npublic class X {\n    public static class Inner {        public void foo() {}\n    }\n}\n", "p1/package-info.java", "@java.lang.Deprecated(forRemoval=true)\npackage p1;\n", "p2/C.java", "package p2;\npublic class C {\n    void bar(p1.X.Inner a) {\n        a.foo();\n    }\n}\n"}, null, customOptions, "----------\n1. ERROR in p2\\C.java (at line 3)\n\tvoid bar(p1.X.Inner a) {\n\t            ^\nThe type X has been deprecated and marked for removal\n----------\n2. ERROR in p2\\C.java (at line 3)\n\tvoid bar(p1.X.Inner a) {\n\t              ^^^^^\nThe type X.Inner has been deprecated and marked for removal\n----------\n3. ERROR in p2\\C.java (at line 4)\n\ta.foo();\n\t  ^^^^^\nThe method foo() from the type X.Inner has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005b() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "ignore");
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic class X {\n    public static class Inner {        public void foo() {}\n    }\n}\n", "p1/package-info.java", "@java.lang.Deprecated(forRemoval=true)\npackage p1;\n", "p2/C.java", "package p2;\npublic class C {\n    void bar(p1.X.Inner a) {\n        a.foo();\n    }\n}\n"}, customOptions);
    }

    public void test005c() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "warning");
        this.runNegativeTest(true, new String[]{"p1/X.java", "package p1;\npublic class X {\n    public static class Inner {\n\t\t @java.lang.Deprecated(forRemoval=true)\n        public void foo() {}\n    }\n}\n", "p1/package-info.java", "@java.lang.Deprecated(forRemoval=false)\npackage p1;\n", "p2/C.java", "package p2;\npublic class C {\n\t @SuppressWarnings(\"deprecation\")\n    void bar(p1.X.Inner a) {\n        a.foo();\n    }\n}\n"}, null, customOptions, "----------\n1. WARNING in p2\\C.java (at line 5)\n\ta.foo();\n\t  ^^^^^\nThe method foo() from the type X.Inner has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test006() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        this.runNegativeTest(true, new String[]{"test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo(E01 arg) {\n\t\t// nop\n\t}\n}", "test1/E01.java", "package test1;\n@SuppressWarnings(\"all\") @Deprecated(since=\"4\")\npublic class E01 {\n\tpublic static int x = 5;\n}"}, null, customOptions, "----------\n1. WARNING in test1\\E02.java (at line 3)\n\tpublic void foo(E01 arg) {\n\t                ^^^\nThe type E01 is deprecated\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test007() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        this.runNegativeTest(true, new String[]{"p1/X.java", "package p1;\npublic class X {\n\t @java.lang.Deprecated(forRemoval=false)\n    public void foo() {}\n\t @java.lang.Deprecated(forRemoval=true)\n\t public void bar() {}\n}\n", "p2/C.java", "package p2;\nimport p1.X;\npublic class C extends X {\n    @Override public void foo() {}\n    @Override public void bar() {}\n}\n"}, null, customOptions, "----------\n1. WARNING in p2\\C.java (at line 4)\n\t@Override public void foo() {}\n\t                      ^^^^^\nThe method C.foo() overrides a deprecated method from X\n----------\n2. ERROR in p2\\C.java (at line 5)\n\t@Override public void bar() {}\n\t                      ^^^^^\nThe method C.bar() overrides a method from X that has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public static Class<?> testClass() {
        return Deprecated9Test.class;
    }
}

