/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class OverloadResolutionTest8
extends AbstractRegressionTest {
    public OverloadResolutionTest8(String name) {
        super(name);
    }

    public static Test suite() {
        return OverloadResolutionTest8.buildMinimalComplianceTestSuite(OverloadResolutionTest8.testClass(), 32);
    }

    public static Class testClass() {
        return OverloadResolutionTest8.class;
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo(int [] a);\n}\ninterface J  {\n\tint foo(int a);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo((a)->a.length));\n\t}\n\tstatic String foo(I i) {\n\t\treturn(\"foo(I)\");\n\t}\n\tstatic String foo(J j) {\n\t\treturn(\"foo(J)\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tSystem.out.println(foo((a)->a.length));\n\t                   ^^^\nThe method foo(I) is ambiguous for the type X\n----------\n");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tint foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"goo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"goo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfinal boolean x = true;\n\t\tgoo(()-> goo((I)null));\n\t}\n\tint f() {\n\t\tfinal boolean x = true;\n\t\twhile (x);\n\t}\n}\n"}, "goo(I)");
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "interface J {\n\tint foo();\n}\npublic class X {\n   static final boolean f = true;\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"goo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfinal boolean x = true;\n\t\tgoo(()-> { \n\t\t\tfinal boolean y = true;\n\t\t\twhile (y); \n\t\t\t});\n\t\tgoo(()-> { \n\t\t\twhile (x); \n\t\t\t});\n\t\tgoo(()-> { \n\t\t\twhile (f); \n\t\t\t});\n\t}\n}\n"}, "goo(J)\ngoo(J)\ngoo(J)");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "interface J {\n\tint foo();\n}\npublic class X {\n   static boolean f = true;\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"goo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tboolean x = true;\n\t\tgoo(()-> { \n\t\t\tboolean y = true;\n\t\t\twhile (y); \n\t\t\t});\n\t\tgoo(()-> { \n\t\t\twhile (x); \n\t\t\t});\n\t\tgoo(()-> { \n\t\t\twhile (f); \n\t\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tgoo(()-> { \n\t^^^\nThe method goo(J) in the type X is not applicable for the arguments (() -> {})\n----------\n2. ERROR in X.java (at line 15)\n\tgoo(()-> { \n\t^^^\nThe method goo(J) in the type X is not applicable for the arguments (() -> {})\n----------\n3. ERROR in X.java (at line 18)\n\tgoo(()-> { \n\t^^^\nThe method goo(J) in the type X is not applicable for the arguments (() -> {})\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "interface J {\n\tint foo();\n}\npublic class X {\n   final boolean f = true;\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"goo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfinal boolean x = true;\n\t\tgoo(()-> { \n\t\t\tfinal boolean y = true;\n\t\t\twhile (y); \n\t\t\t});\n\t\tgoo(()-> { \n\t\t\twhile (x); \n\t\t\t});\n\t\tgoo(()-> { \n\t\t\twhile (f); \n\t\t\t});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tgoo(()-> { \n\t^^^\nThe method goo(J) in the type X is not applicable for the arguments (() -> {})\n----------\n2. ERROR in X.java (at line 19)\n\twhile (f); \n\t       ^\nCannot make a static reference to the non-static field f\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n public static interface StringToInt {\n  \tint stoi(String s);\n }\n public static interface ReduceInt {\n     int reduce(int a, int b);\n }\n void foo(StringToInt s) { }\n void bar(ReduceInt r) { }\n void bar() {\n     bar((int x, int y) -> x+y); //SingleVariableDeclarations are OK\n     foo(s -> s.length());\n     foo((s) -> s.length());\n     foo((String s) -> s.length()); //SingleVariableDeclaration is OK\n     bar((x, y) -> x+y);\n }\n}\n"}, "");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "interface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"goo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(()-> 10); \n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tgoo(()-> 10); \n\t^^^\nThe method goo(J) in the type X is not applicable for the arguments (() -> {})\n----------\n2. ERROR in X.java (at line 9)\n\tgoo(()-> 10); \n\t         ^^\nVoid methods cannot return a value\n----------\n");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tObject foo();\n}\ninterface J  {\n\tString foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(()->null));\n\t}\n\tstatic String foo(I i) {\n\t\treturn(\"foo(I)\");\n\t}\n\tstatic String foo(J j) {\n\t\treturn(\"foo(J)\");\n\t}\n}\n"}, "foo(J)");
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tObject foo();\n}\ninterface J  {\n\tvoid foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(()-> {}));\n\t}\n\tstatic String foo(I i) {\n\t\treturn(\"foo(I)\");\n\t}\n\tstatic String foo(J j) {\n\t\treturn(\"foo(J)\");\n\t}\n}\n"}, "foo(J)");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tObject foo();\n}\ninterface J  {\n\tvoid foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(()-> foo(()->null)));\n\t}\n\tstatic String foo(I i) {\n\t\treturn(\"foo(I)\");\n\t}\n\tstatic String foo(J j) {\n\t\treturn(\"foo(J)\");\n\t}\n}\n"}, "foo(I)");
    }

    public void test011() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\ninterface J  {\n\tString foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(()-> \"Hello\" ));\n\t}\n\tstatic String foo(I i) {\n\t\treturn(\"foo(I)\");\n\t}\n\tstatic String foo(J j) {\n\t\treturn(\"foo(J)\");\n\t}\n}\n"}, "foo(J)");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\ninterface J  {\n\tString foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(()-> 1234 ));\n\t}\n\tstatic String foo(I i) {\n\t\treturn(\"foo(I)\");\n\t}\n\tstatic String foo(J j) {\n\t\treturn(\"foo(J)\");\n\t}\n}\n"}, "foo(I)");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\ninterface J  {\n\tInteger foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(foo(()-> 1234 ));\n\t}\n\tstatic String foo(I i) {\n\t\treturn(\"foo(I)\");\n\t}\n\tstatic String foo(J j) {\n\t\treturn(\"foo(J)\");\n\t}\n}\n"}, "foo(I)");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tInteger foo();\n}\ninterface J {\n\tint foo();\n}\npublic class X {\n \n\tstatic void foo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\t\n\tstatic void foo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tfoo(()-> new Integer(10));\n\t}\n}\n"}, "foo(I)");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "interface J {\n\tint foo();\n}\ninterface I {\n\tInteger foo();\n}\npublic class X {\n \n\tstatic void foo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\t\n\tstatic void foo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tfoo(()-> new Integer(10));\n\t}\n}\n"}, "foo(I)");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "interface O {\n\tObject foo();\n}\ninterface S {\n\tString foo();\n}\ninterface I {\n\tO foo();\n}\ninterface J {\n\tS foo();\n}\npublic class X {\n\tstatic void foo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void foo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(()-> ()-> \"String\");\n\t}\n}\n"}, "foo(J)");
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "interface J {\n\tint foo();\n}\npublic class X {\n\tstatic void foo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(()-> new Integer(10));\n\t}\n}\n"}, "foo(J)");
    }

    public void test018() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX [] foo(int x);\n}\npublic class X {\n\tstatic void foo(I x) {\n            System.out.println(\"foo(I)\");\n\t}\n\tI i = X[]::new;\n\tpublic static void main(String[] args) {\n\t\tfoo(X[]::new);\n\t}\n}\n"}, "foo(I)");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\npublic class X {\n\tstatic void foo(I x) {\n            System.out.println(\"foo(I)\");\n\t}\n\tI i = X[]::new;\n\tpublic static void main(String[] args) {\n\t\tfoo(X[]::new);\n\t}\n}\n"}, "foo(I)");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tY foo(int x);\n}\ninterface J {\n\tY foo();\n}\nclass Y {\n\tY() {\n\t}\n\t\n\tY(int x) {\n\t}\n}\npublic class X {\n\tstatic void foo(I i) {\n\t}\n\tstatic void foo(J j) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(Y::new);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 20)\n\tfoo(Y::new);\n\t^^^\nThe method foo(I) is ambiguous for the type X\n----------\n");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tY foo(int x);\n}\ninterface J {\n\tY foo();\n}\nclass Y {\n\tprivate Y() {\n\t}\n\t\n\tY(int x) {\n\t}\n}\npublic class X {\n\tstatic void foo(I i) {\n       System.out.println(\"foo(I)\");\n\t}\n\tstatic void foo(J j) {\n       System.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(Y::new);\n\t}\n}\n"}, "foo(I)");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tY foo(int x);\n}\ninterface J {\n\tY foo();\n}\nclass Y {\n\tY(float f) {\n       System.out.println(\"Y(float)\");\n\t}\n\t\n\tY(int x) {\n       System.out.println(\"Y(int)\");\n\t}\n}\npublic class X {\n\tstatic void foo(I i) {\n       i.foo(10);\n\t}\n\tstatic void foo(J j) {\n       j.foo();\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(Y::new);\n\t}\n}\n"}, "Y(int)");
    }

    public void test023() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tY foo(int x);\n}\ninterface J {\n\tY foo();\n}\nclass Y {\n\tY(int ... x) {\n\t}\n\t\n}\npublic class X {\n\tstatic void foo(I i) {\n\t}\n\tstatic void foo(J j) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(Y::new);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tfoo(Y::new);\n\t^^^\nThe method foo(I) is ambiguous for the type X\n----------\n");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tY foo(int x);\n}\ninterface J {\n\tY foo(int x);\n}\nclass Y {\n\tY(int x) {\n\t}\n\t\n}\npublic class X {\n\tstatic void foo(I i) {\n\t}\n\tstatic void foo(J j) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(Y::new);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tfoo(Y::new);\n\t^^^\nThe method foo(I) is ambiguous for the type X\n----------\n");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tY foo(int x);\n}\ninterface J {\n\tX foo(int x);\n}\nclass Y extends X {\n    Y(int x) {\n    }\n}\npublic class X {\n\tstatic void foo(I i) {\n            System.out.println(\"foo(I)\");\n\t}\n\tstatic void foo(J j) {\n            System.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(Y::new);\n\t}\n}\n"}, "foo(I)");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tY foo(int x);\n}\ninterface J {\n\tX foo(int x);\n}\nclass Y extends X {\n    <T> Y(int x) {\n    }\n}\npublic class X {\n\tstatic void foo(I i) {\n            System.out.println(\"foo(I)\");\n\t}\n\tstatic void foo(J j) {\n            System.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(Y::new);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 19)\n\tfoo(Y::new);\n\t^^^\nThe method foo(I) is ambiguous for the type X\n----------\n");
    }

    public void test027() {
        this.runConformTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.JavacDoesNotCompileCorrectSource, new String[]{"X.java", "interface I {\n\tY foo(int x);\n}\ninterface J {\n\tX foo(int x);\n}\nclass Y extends X {\n    <T> Y(int x) {\n    }\n}\npublic class X {\n\tstatic void foo(I i) {\n            System.out.println(\"foo(I)\");\n\t}\n\tstatic void foo(J j) {\n            System.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(Y::<String>new);\n\t}\n}\n"}, "foo(I)");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tY [] foo(int x);\n}\ninterface J {\n\tX [] foo();\n}\nclass Y extends X {\n}\npublic class X {\n\tstatic void foo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void foo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(Y []::new);\n\t}\n}\n"}, "foo(I)");
    }

    public void test029() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tY [] foo(int x);\n}\ninterface J {\n\tX [] foo();\n}\nclass Y extends X {\n}\npublic class X {\n\tstatic void foo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void foo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(X []::new);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tfoo(X []::new);\n\t^^^\nThe method foo(I) in the type X is not applicable for the arguments (X[]::new)\n----------\n2. ERROR in X.java (at line 17)\n\tfoo(X []::new);\n\t    ^^^^^^^^^\nConstructed array X[] cannot be assigned to Y[] as required in the interface descriptor  \n----------\n");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tY [] foo(int x);\n}\ninterface J {\n\tX [] foo(int x);\n}\nclass Y extends X {\n}\npublic class X {\n\tstatic void foo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void foo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo(X []::new);\n\t}\n}\n"}, "foo(J)");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tvoid foo(X<String> s) {\n       System.out.println(\"foo(X<String>)\");\n   }\n\tpublic static void main(String[] args) {\n\t\tnew X<String>().foo(new X<>());\n\t}\n}\n"}, "foo(X<String>)");
    }

    public void _test032() {
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n    void foo(X<String> s, Object o) {\n        System.out.println(\"foo(X<String>)\");\n    }\n    void foo(X xs, String s) {\n        System.out.println(\"foo(X<String>)\");\n    }\n    public static void main(String[] args) {\n        new X<String>().foo(new X<>(), \"Hello\");\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tvoid foo(X xs, String s) {\n\t         ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n2. ERROR in X.java (at line 9)\n\tnew X<String>().foo(new X<>(), \"Hello\");\n\t                ^^^\nThe method foo(X<String>, Object) is ambiguous for the type X<String>\n----------\n");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "class Y<T> {}\npublic class X<T> extends Y<T> {\n    void foo(X<String> s) {\n        System.out.println(\"foo(X<String>)\");\n    }\n    void foo(Y<String> y) {\n        System.out.println(\"foo(Y<String>)\");\n    }\n    public static void main(String[] args) {\n        new X<String>().foo(new X<>());\n    }\n}\n"}, "foo(X<String>)");
    }

    public void test422050() {
        this.runConformTest(new String[]{"X.java", "interface I { \n\tint foo(); \n}\ninterface J { \n\tdouble foo(); \n}\npublic class X {\n\tstatic int foo(I i) {\n\t\treturn 0;\n\t}\n\tstatic int foo(J j) {\n\t\treturn 1;\n\t}\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(foo (() -> true ? 0 : 1));\n\t}\n}\n"}, "0");
    }

    public void test400871() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tint foo();\n}\npublic class X {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tstatic int foo() {\n\t\t return 0;\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(X::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test400871a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tint foo(int x);\n}\nclass Y {\n\tint foo(int y) {\n\t\t return 0;\n\t}\n}\npublic class X extends Y {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tint foo(int x) {\n\t\t return 0;\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test400871b() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tint foo(int x);\n}\nclass Y {\n\t<T> int foo(int y) {\n\t\t return 0;\n\t}\n}\npublic class X extends Y {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tint foo(int x) {\n\t\t return 0;\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test400871c() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tint foo(int x);\n}\nclass Y {\n\t<T> int foo(String y) {\n\t\t return 0;\n\t}\n}\npublic class X extends Y {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tint foo(int x) {\n\t\t return 0;\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 23)\n\tgoo(new X()::foo);\n\t^^^\nThe method goo(I) is ambiguous for the type X\n----------\n");
    }

    public void test400871d() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tint foo(int x);\n}\nclass Y {\n\tint foo(String y) {\n\t\t return 0;\n\t}\n}\npublic class X extends Y {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\t<T> int foo(int x) {\n\t\t return 0;\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 23)\n\tgoo(new X()::foo);\n\t^^^\nThe method goo(I) is ambiguous for the type X\n----------\n");
    }

    public void test4008712() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tint foo(int x);\n}\nclass Y {\n\tint foo(String y) {\n\t\t return 0;\n\t}\n}\npublic class X extends Y {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\t<T> int foo(int x) {\n\t\t return 0;\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 23)\n\tgoo(new X()::foo);\n\t^^^\nThe method goo(I) is ambiguous for the type X\n----------\n");
    }

    public void test4008712e() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tint foo(int x);\n}\nclass Y {\n\tint foo(int y) {\n\t\t return 0;\n\t}\n}\npublic class X extends Y {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712f() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tint foo(int x);\n}\nclass Y {\n\tint foo(int ... x) {\n\t\t return 0;\n\t}\n}\npublic class X extends Y {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 20)\n\tgoo(new X()::foo);\n\t^^^\nThe method goo(I) is ambiguous for the type X\n----------\n");
    }

    public void test4008712g() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tint foo(int x);\n}\nclass Y {\n\tprivate int foo(int x) {\n\t\t return 0;\n\t}\n}\npublic class X extends Y {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tprivate int foo(int x) {\n\t            ^^^^^^^^^^\nThe method foo(int) from the type Y is never used locally\n----------\n2. ERROR in X.java (at line 20)\n\tgoo(new X()::foo);\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (new X()::foo)\n----------\n3. ERROR in X.java (at line 20)\n\tgoo(new X()::foo);\n\t    ^^^^^^^^^^^^\nThe type X does not define foo(int) that is applicable here\n----------\n");
    }

    public void test4008712h() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tint foo(int x);\n}\nclass Y {\n\tpublic <T> int foo(int x) {\n\t\t return 0;\n\t}\n}\npublic class X extends Y {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 20)\n\tgoo(new X()::foo);\n\t^^^\nThe method goo(I) is ambiguous for the type X\n----------\n");
    }

    public void test4008712i() {
        this.runConformTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.JavacDoesNotCompileCorrectSource, new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tint foo(int x);\n}\nclass Y {\n\tpublic <T> int foo(int x) {\n\t\t return 0;\n\t}\n}\npublic class X extends Y {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::<String>foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712j() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(String x);\n}\ninterface J {\n\tint foo(String x);\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<T> {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X<String>()::foo);\n\t}\n}\n"}, "foo(I)");
    }

    public void test4008712k() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(String x);\n}\ninterface J {\n\tString foo(String x);\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<T> {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X<String>()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712l() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(String x);\n}\ninterface J {\n\tString foo(String x);\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X<String>()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712m() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(String x);\n}\ninterface J {\n\tString foo(String x);\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n   public void foo() {}\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X<String>()::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 21)\n\tgoo(new X<String>()::foo);\n\t^^^\nThe method goo(I) is ambiguous for the type X<T>\n----------\n");
    }

    public void test4008712n() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(String x);\n}\ninterface J {\n\tString foo(String x);\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n   public String foo(String s) { return null; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X<String>()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712o() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(String x);\n}\ninterface J {\n\tString foo(String x);\n}\ninterface K<T> {\n\tpublic T foo(T x);\n}\nclass Y<T> implements K {\n\tpublic Object foo(Object x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n   public Object foo(Object s) { return null; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X<String>()::foo);\n\t}\n}\n"}, "foo(I)");
    }

    public void test4008712p() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo(String x);\n}\ninterface J {\n\tString foo(String x);\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n   public String foo(String s) { return null; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 21)\n\tgoo(new X()::foo);\n\t^^^\nThe method goo(I) is ambiguous for the type X<T>\n----------\n2. WARNING in X.java (at line 21)\n\tgoo(new X()::foo);\n\t        ^\nX is a raw type. References to generic type X<T> should be parameterized\n----------\n");
    }

    public void test4008712q() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(String x);\n}\ninterface J {\n\tString foo(String x);\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(I)");
    }

    public void test4008712r() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tString foo();\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X[0]::clone);\n\t}\n}\n"}, "foo(I)");
    }

    public void test4008712s() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tString foo();\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X[0]::toString);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712t() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tClass foo();\n}\ninterface J {\n\tObject foo();\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X[0]::getClass);\n\t}\n}\n"}, "foo(I)");
    }

    public void test4008712u() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tint foo();\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(I::clone);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 20)\n\tgoo(I::clone);\n\t^^^\nThe method goo(I) in the type X<T> is not applicable for the arguments (I::clone)\n----------\n2. ERROR in X.java (at line 20)\n\tgoo(I::clone);\n\t    ^^^^^^^^\nThe type I does not define clone() that is applicable here\n----------\n");
    }

    public void test4008712v() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tint foo();\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n       I i = () -> {};\n\t\tgoo(i::hashCode);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712w() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tint foo();\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n}\npublic class X<T> extends Y<String> {\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n       I i = () -> {};\n\t\tgoo(i::clone);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 21)\n\tgoo(i::clone);\n\t^^^\nThe method goo(I) in the type X<T> is not applicable for the arguments (i::clone)\n----------\n2. ERROR in X.java (at line 21)\n\tgoo(i::clone);\n\t    ^^^^^^^^\nThe type I does not define clone() that is applicable here\n----------\n");
    }

    public void test4008712x() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(String x);\n}\ninterface J {\n\tString foo(String x);\n}\nclass Y<T> {\n\tpublic T foo(T x) {\n\t\t return null;\n\t}\n   private void foo() {}\n}\npublic class X<T> extends Y<String> {\n   public String foo(String s) { return null; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X<String>()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712y() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tint foo();\n}\npublic class X {\n   public int foo() { return 0; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712z() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tlong foo();\n}\ninterface J {\n\tint foo();\n}\npublic class X {\n   public int foo() { return 0; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712za() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tlong foo();\n}\ninterface J {\n\tint foo();\n}\npublic class X {\n   public long foo() { return 0; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(I)");
    }

    public void test4008712zb() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n   public long foo() { return 0; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 16)\n\tgoo(new X()::foo);\n\t^^^\nThe method goo(I) is ambiguous for the type X\n----------\n");
    }

    public void test4008712zc() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\ninterface J {\n\tInteger foo();\n}\npublic class X {\n   public long foo() { return 0; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 16)\n\tgoo(new X()::foo);\n\t^^^\nThe method goo(I) in the type X is not applicable for the arguments (new X()::foo)\n----------\n2. ERROR in X.java (at line 16)\n\tgoo(new X()::foo);\n\t    ^^^^^^^^^^^^\nThe type of foo() from the type X is long, this is incompatible with the descriptor's return type: int\n----------\n");
    }

    public void test4008712zd() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\ninterface J {\n\tLong foo();\n}\npublic class X {\n   public long foo() { return 0; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712ze() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\ninterface J {\n\tInteger foo();\n}\npublic class X {\n   public int foo() { return 0; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(I)");
    }

    public void test4008712zf() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo();\n}\ninterface J {\n\tInteger foo();\n}\npublic class X {\n   public Integer foo() { return 0; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void test4008712zg() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tInteger foo();\n}\ninterface J {\n\tLong foo();\n}\npublic class X {\n   public Integer foo() { return 0; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(I)");
    }

    public void test4008712zh() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tInteger foo();\n}\ninterface J {\n\tLong foo();\n}\npublic class X {\n   public Long foo() { return 0L; }\n\tstatic void goo(I i) {\n\t\tSystem.out.println(\"foo(I)\");\n\t}\n\tstatic void goo(J j) {\n\t\tSystem.out.println(\"foo(J)\");\n\t}\n\tpublic static void main(String[] args) { \n\t\tgoo(new X()::foo);\n\t}\n}\n"}, "foo(J)");
    }

    public void testVarargs() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\npublic class X {\n\tstatic void goo(I ... i) {\n\t\ti[0].foo();\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo(()->{ System.out.println(\"Lambda\");});\n\t}\n}\n"}, "Lambda");
    }

    public void test401850() {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tvoid foo(X<String> s) {\n\t\tSystem.out.println(\"foo(X<String>)\");\n\t}\n\tvoid foo(int x) {\n\t\tSystem.out.println(\"foo(int)\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X<String>().foo(new X<>());\n\t}\n}\n"}, "foo(X<String>)");
    }

    public void test427072() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object m(X t);\n}\ninterface J extends I {\n}\npublic class X {\n    int foo()  { return 0; }\n    int test() {\n        return foo(X::foo);\n    }\n    int foo(I i) {return 0;}\n    int foo(J j) { return 1;}\n    public static void main(String args[]) {\n        X x = new X();\n        int i = x.test();\n        System.out.println(i);\n    }\n}\n"}, "1");
    }

    public void test427072a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object m(X t);\n}\ninterface J extends I {\n}\npublic class X {\n    int foo()  { return 0; }\n    int test() {\n        return foo((x) -> x);\n    }\n    int foo(I i) {return 0;}\n    int foo(J j) { return 1;}\n    public static void main(String args[]) {\n        X x = new X();\n        int i = x.test();\n        System.out.println(i);\n    }\n}\n"}, "1");
    }

    public void test427072b() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object m(X t);\n}\ninterface J extends I {\n}\npublic class X {\n    int foo()  { return 0; }\n    int test() {\n        return foo(true ? (x) -> x : X::foo);\n    }\n    int foo(I i) {return 0;}\n    int foo(J j) { return 1;}\n    public static void main(String args[]) {\n        X x = new X();\n        int i = x.test();\n        System.out.println(i);\n    }\n}\n"}, "1");
    }

    public void test427072c() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object m(X t);\n}\ninterface J extends I {\n}\npublic class X {\n    int foo1()  { return 0; }\n    int foo2()  { return 0; }\n    int test() {\n        return foo(true ? X::foo1 : X::foo2);\n    }\n    int foo(I i) {return 0;}\n    int foo(J j) { return 1;}\n    public static void main(String args[]) {\n        X x = new X();\n        int i = x.test();\n        System.out.println(i);\n    }\n}\n"}, "1");
    }

    public void test427628() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   public static void main(String [] args) {\n       new X().error(null);\n   }\n\tpublic void error(I i) {\n\t\ttest(i!=null?i.getJ():null);\n\t}\n\tpublic void test(I i) {\n       System.out.println(\"I\");\n\t}\n\tpublic void test(J j) {\n       System.out.println(\"J\" + j);\n\t}\n\tpublic class I{\n\t\tpublic J getJ() {\n\t\t\treturn null;\n\t\t}\n\t}\n\tpublic class J{}\n}\n"}, "Jnull");
    }

    public void test427628a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   public static void main(String [] args) {\n       new X().error(null);\n   }\n\tpublic void error(I i) {\n\t\ttest(i!=null?i.getJ():null);\n\t}\n\tpublic void test(I i) {\n       System.out.println(\"I\");\n\t}\n\tpublic void test(K k) {\n       System.out.println(\"K\" + j);\n\t}\n\tpublic class I{\n\t\tpublic J getJ() {\n\t\t\treturn null;\n\t\t}\n\t}\n\tpublic class J{}\n\tpublic class K{}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\ttest(i!=null?i.getJ():null);\n\t^^^^\nThe method test(X.I) in the type X is not applicable for the arguments (((i != null) ? i.getJ() : null))\n----------\n2. ERROR in X.java (at line 6)\n\ttest(i!=null?i.getJ():null);\n\t             ^^^^^^^^\nType mismatch: cannot convert from X.J to X.I\n----------\n3. ERROR in X.java (at line 12)\n\tSystem.out.println(\"K\" + j);\n\t                         ^\nj cannot be resolved to a variable\n----------\n");
    }

    public void test427628b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void setSetting(String key, String value) {\n\t}\n\tpublic void setSetting(String key, Integer value) {\n\t    setSetting(key, value == null ? null : Integer.toString(value));\n\t}\n}\n"}, "");
    }

    public void _test421922() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n    public static void main(String[] args) {\n        test(1);\n    }\n    public static void test(int... a) {\n        System.out.print(\"int ... = \");\n        System.out.println(Arrays.toString(a));\n    }\n    public static <T> void test(Object... a) {\n        System.out.print(\"Object ... = \");\n        System.out.println(Arrays.toString(a));\n    }\n}\n"}, "int ... = [1]");
    }

    public void test427748() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String [] args) {\n    getLog(doit(baction));\n  }\n  private static interface Action<T> {T run();}\n  private static Action<Boolean> baction = () -> true;\n  static void getLog(int override) {}\n  static void getLog(boolean override) {\n      System.out.println(\"OK\");\n  }\n  private static <T> T doit(Action<T> action) { return action.run(); }\n}\n"}, "OK");
    }

    public void test427808() {
        this.runConformTest(new String[]{"X.java", "public class X extends Foo {\n\tpublic X(I i) {\n\t\tsuper(i != null ?  i.toString() : null);\n    }\n   public static void main(String [] args) {\n       new X(null);\n   }\n}\nclass Foo implements I {\n\tFoo(I i) {}\n\tFoo(String string){ System.out.println(\"OK\"); }\n}\ninterface I {}\n"}, "OK");
    }

    public void test429985() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t// This does not compile with ECJ\n\t\ttest(() -> \"hi\");\n\t}\n\t// Note: when removing this code the main function compiles with ECJ\n\tstatic void test(String message) {\n\t}\n\tstatic void test(Supplier<String> messageSupplier) {\n       System.out.println(messageSupplier.get());\n\t}\n}\n"}, "hi");
    }

    public void test429985a() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t// This does not compile with ECJ\n\t\ttest(() -> \"hi\");\n\t}\n\tstatic void test(Supplier<String> messageSupplier) {\n       System.out.println(messageSupplier.get());\n\t}\n\t// Note: when removing this code the main function compiles with ECJ\n\tstatic void test(String message) {\n\t}\n}\n"}, "hi");
    }

    public void test448801() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate class Y {\n\t}\n\tpublic X(Y ...ys) {\n\t}\n\tpublic void foo(Y ...ys) {\n\t}\n\tpublic void goo() {\n\t}\n}\n", "Z.java", "interface I {\n\tstatic void ifoo() {\n\t}\n}\nabstract class ZSuper {\n\tvoid zSuperFoo() {\n\t}\n\tabstract void goo();\n}\npublic class Z extends ZSuper implements I {\n\tvoid goo() {\n\t\tsuper.zSuperFoo();\n\t\tsuper.goo();\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.foo();\n\t\tSystem.out.println(x.goo());\n\t\tgoo();\n\t\tZ.goo();\n\t\tzoo();\n\t\tnew Z().ifoo();\n\t\tsuper.zSuperFoo();\n\t}\n\tclass ZZ {\n\t\tclass ZZZ {\n\t\t\tvoid zoo() {\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Z.java (at line 13)\n\tsuper.goo();\n\t^^^^^^^^^^^\nCannot directly invoke the abstract method goo() for the type ZSuper\n----------\n2. ERROR in Z.java (at line 16)\n\tX x = new X();\n\t      ^^^^^^^\nThe constructor X(X.Y...) of type X is not applicable as the formal varargs element type X.Y is not accessible here\n----------\n3. ERROR in Z.java (at line 17)\n\tx.foo();\n\t  ^^^\nThe method foo(X.Y...) of type X is not applicable as the formal varargs element type X.Y is not accessible here\n----------\n4. ERROR in Z.java (at line 18)\n\tSystem.out.println(x.goo());\n\t           ^^^^^^^\nThe method println(boolean) in the type PrintStream is not applicable for the arguments (void)\n----------\n5. ERROR in Z.java (at line 19)\n\tgoo();\n\t^^^\nCannot make a static reference to the non-static method goo() from the type Z\n----------\n6. ERROR in Z.java (at line 20)\n\tZ.goo();\n\t^^^^^^^\nCannot make a static reference to the non-static method goo() from the type Z\n----------\n7. ERROR in Z.java (at line 21)\n\tzoo();\n\t^^^\nThe method zoo() is undefined for the type Z\n----------\n8. ERROR in Z.java (at line 22)\n\tnew Z().ifoo();\n\t        ^^^^\nThe method ifoo() is undefined for the type Z\n----------\n9. ERROR in Z.java (at line 23)\n\tsuper.zSuperFoo();\n\t^^^^^\nCannot use super in a static context\n----------\n");
    }

    public void test450415() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\ninterface I {\n\tString foo();\n}\ninterface J {\n\tList<String> foo();\n}\npublic class X {\n    static void goo(I i) {\n    \tSystem.out.println(\"goo(I)\");\n    }\n    static void goo(J j) {\n    \tSystem.out.println(\"goo(J)\");\n    }\n    static <T> List<T> loo() {\n    \treturn null;\n    }\n    public static void main(String[] args) {\n\t\tgoo(()->loo());\n\t}\n}\n"}, "goo(J)");
    }

    public void test450415a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\npublic class X {\n\tstatic <T> void foo() {\n\t\tclass Y {\n\t\t\tvoid goo(T t) {\n\t\t\t\tSystem.out.println(\"T\");\n\t\t\t}\n\t\t\tvoid goo(I i) {\n\t\t\t\tSystem.out.println(\"I\");\n\t\t\t}\n\t\t}\n\t\tnew Y().goo(()->{});\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo();\n\t}\n}\n"}, "I");
    }

    public void test482440a() {
        this.runNegativeTest(new String[]{"Test.java", "class Test {\n\n    // generic method\n    interface ConsumerA {\n        <T> void accept(int i);\n    }\n\n    // non-generic\n    interface ConsumerB {\n        void accept(int i);\n    }\n\n    // A before B\n    void execute1(ConsumerA c) {}\n    void execute1(ConsumerB c) {}\n\n    // B before A\n    void execute2(ConsumerB c) {}\n    void execute2(ConsumerA c) {}\n\n    void test() {\n        execute1(x -> {});  // compiles in Eclipse\n        execute2(x -> {});  // doesn't compile\n    }\n\n}\n"}, "----------\n1. ERROR in Test.java (at line 22)\n\texecute1(x -> {});  // compiles in Eclipse\n\t^^^^^^^^\nThe method execute1(Test.ConsumerA) is ambiguous for the type Test\n----------\n2. ERROR in Test.java (at line 23)\n\texecute2(x -> {});  // doesn't compile\n\t^^^^^^^^\nThe method execute2(Test.ConsumerB) is ambiguous for the type Test\n----------\n");
    }

    public void test482440b() {
        this.runConformTest(new String[]{"Test.java", "class Test {\n\n    // generic method\n    interface ConsumerA {\n        <T> void accept(int i);\n    }\n\n    // non-generic\n    interface ConsumerB {\n        void accept(int i);\n    }\n\n    // A before B\n    void execute1(ConsumerA c) {}\n    void execute1(ConsumerB c) {}\n\n    // B before A\n    void execute2(ConsumerB c) {}\n    void execute2(ConsumerA c) {}\n\n    void test() {\n        execute1((int x) -> {});  // compiles in Eclipse\n        execute2((int x) -> {});  // doesn't compile\n    }\n\n}\n"});
    }
}

