/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ProblemTypeAndMethodTest
extends AbstractRegressionTest {
    public ProblemTypeAndMethodTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ProblemTypeAndMethodTest.buildAllCompliancesTestSuite(ProblemTypeAndMethodTest.testClass());
    }

    public static Class testClass() {
        return ProblemTypeAndMethodTest.class;
    }

    public void test001() {
        IBinaryMethod method;
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        interface Moosh { void foo(); }\n\n        static abstract class A implements Moosh {}\n\n        static class W extends A {}\n        static class Y extends A {}\n        static class Z extends A {}\n        public static void main(String[] args) {\n                new W();  // throws ClassFormatError\n        }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tstatic class W extends A {}\n\t             ^\nThe type X.W must implement the inherited abstract method X.Moosh.foo()\n----------\n2. ERROR in X.java (at line 7)\n\tstatic class Y extends A {}\n\t             ^\nThe type X.Y must implement the inherited abstract method X.Moosh.foo()\n----------\n3. ERROR in X.java (at line 8)\n\tstatic class Z extends A {}\n\t             ^\nThe type X.Z must implement the inherited abstract method X.Moosh.foo()\n----------\n", null, true, null, true, false, false, false, false);
        ClassFileReader reader = this.getClassFileReader(String.valueOf(OUTPUT_DIR) + File.separator + "X$W.class", "X$W");
        IBinaryMethod[] methods = reader.getMethods();
        ProblemTypeAndMethodTest.assertEquals((String)"Wrong size", (int)2, (int)methods.length);
        int counter = 0;
        int i = 0;
        while (i < 2) {
            method = methods[i];
            if (new String(method.getSelector()).equals("foo")) {
                ++counter;
            }
            ++i;
        }
        ProblemTypeAndMethodTest.assertEquals((String)"Wrong number of foo method", (int)1, (int)counter);
        reader = this.getClassFileReader(String.valueOf(OUTPUT_DIR) + File.separator + "X$Y.class", "X$Y");
        methods = reader.getMethods();
        ProblemTypeAndMethodTest.assertEquals((String)"Wrong size", (int)2, (int)methods.length);
        counter = 0;
        i = 0;
        while (i < 2) {
            method = methods[i];
            if (new String(method.getSelector()).equals("foo")) {
                ++counter;
            }
            ++i;
        }
        ProblemTypeAndMethodTest.assertEquals((String)"Wrong number of foo method", (int)1, (int)counter);
        reader = this.getClassFileReader(String.valueOf(OUTPUT_DIR) + File.separator + "X$Z.class", "X$Z");
        methods = reader.getMethods();
        ProblemTypeAndMethodTest.assertEquals((String)"Wrong size", (int)2, (int)methods.length);
        counter = 0;
        i = 0;
        while (i < 2) {
            method = methods[i];
            if (new String(method.getSelector()).equals("foo")) {
                ++counter;
            }
            ++i;
        }
        ProblemTypeAndMethodTest.assertEquals((String)"Wrong number of foo method", (int)1, (int)counter);
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Zork {\n\tvoid foo() {\n\t\tZork z = this;\n\t\tString s = this;\n\t\tZork2 z2 = this;\n\t}\n\tZork fz = this;\n\tString fs = this;\n\tZork2 fz2 = this;\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Zork {\n\t                       ^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tZork z = this;\n\t^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\tString s = this;\n\t           ^^^^\nType mismatch: cannot convert from X to String\n----------\n4. ERROR in X.java (at line 5)\n\tZork2 z2 = this;\n\t^^^^^\nZork2 cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 7)\n\tZork fz = this;\n\t^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 8)\n\tString fs = this;\n\t            ^^^^\nType mismatch: cannot convert from X to String\n----------\n7. ERROR in X.java (at line 9)\n\tZork2 fz2 = this;\n\t^^^^^\nZork2 cannot be resolved to a type\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tZork field;\n\t\n\tvoid foo(Y y) {\n\t\tObject o = y.foo();\n\t\tObject s = y.slot;\n\t\ty.bar(null);\n\t\tObject s2 = new Y().slot;\n\t\tObject f = field;\n\t}\n}\nclass Y {\n\tZork foo() {\treturn null; }\n\tvoid bar(Zork z) {}\n\tZork slot;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tZork field;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\tObject o = y.foo();\n\t             ^^^\nThe method foo() from the type Y refers to the missing type Zork\n----------\n3. ERROR in X.java (at line 6)\n\tObject s = y.slot;\n\t           ^^^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 7)\n\ty.bar(null);\n\t  ^^^\nThe method bar(Zork) from the type Y refers to the missing type Zork\n----------\n5. ERROR in X.java (at line 8)\n\tObject s2 = new Y().slot;\n\t            ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 9)\n\tObject f = field;\n\t           ^^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 13)\n\tZork foo() {\treturn null; }\n\t^^^^\nZork cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 14)\n\tvoid bar(Zork z) {}\n\t         ^^^^\nZork cannot be resolved to a type\n----------\n9. ERROR in X.java (at line 15)\n\tZork slot;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test004() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q.Zork;\n\npublic class OtherFoo extends Zork{\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n", "q/Zork.java", "package q;\npublic class Zork {\n}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "import p.OtherFoo;\nimport q.Zork;\n\npublic class X {\n\tvoid foo() {\n\t\tOtherFoo ofoo;\n\t\tString s1 = ofoo.foo;\n\t\tString s2 = ofoo.bar();\n\t\tString s3 = ofoo.new OtherMember();\n\t\tofoo.baz(this);\n\t}\n\tvoid bar() {\n\t\tOtherX ox;\n\t\tString s1 = ox.foo;\n\t\tString s2 = ox.bar();\n\t\tString s3 = ox.new OtherMember();\n\t\tox.baz(this);\n\t}\n}\t\n\nclass OtherX {\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tString s1 = ofoo.foo;\n\t            ^^^^^^^^\nType mismatch: cannot convert from Zork to String\n----------\n2. ERROR in X.java (at line 8)\n\tString s2 = ofoo.bar();\n\t            ^^^^^^^^^^\nType mismatch: cannot convert from Zork to String\n----------\n3. ERROR in X.java (at line 9)\n\tString s3 = ofoo.new OtherMember();\n\t            ^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from OtherFoo.OtherMember to String\n----------\n4. ERROR in X.java (at line 10)\n\tofoo.baz(this);\n\t     ^^^\nThe method baz(Zork) in the type OtherFoo is not applicable for the arguments (X)\n----------\n5. ERROR in X.java (at line 14)\n\tString s1 = ox.foo;\n\t            ^^^^^^\nType mismatch: cannot convert from Zork to String\n----------\n6. ERROR in X.java (at line 15)\n\tString s2 = ox.bar();\n\t            ^^^^^^^^\nType mismatch: cannot convert from Zork to String\n----------\n7. ERROR in X.java (at line 16)\n\tString s3 = ox.new OtherMember();\n\t            ^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from OtherX.OtherMember to String\n----------\n8. ERROR in X.java (at line 17)\n\tox.baz(this);\n\t   ^^^\nThe method baz(Zork) in the type OtherX is not applicable for the arguments (X)\n----------\n", null, false);
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q" + File.separator + "Zork.class"));
        this.runNegativeTest(new String[]{"X.java", "import p.OtherFoo;\nimport q.Zork;\n\npublic class X {\n\tvoid foo() {\n\t\tOtherFoo ofoo;\n\t\tString s1 = ofoo.foo;\n\t\tString s2 = ofoo.bar();\n\t\tString s3 = ofoo.new OtherMember();\n\t\tofoo.baz(this);\n\t}\n\tvoid bar() {\n\t\tOtherX ox;\n\t\tString s1 = ox.foo;\n\t\tString s2 = ox.bar();\n\t\tString s3 = ox.new OtherMember();\n\t\tox.baz(this);\n\t}\n}\t\n\nclass OtherX {\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\timport p.OtherFoo;\n\t^\nThe type q.Zork cannot be resolved. It is indirectly referenced from required .class files\n----------\n2. ERROR in X.java (at line 2)\n\timport q.Zork;\n\t       ^^^^^^\nThe import q.Zork cannot be resolved\n----------\n3. ERROR in X.java (at line 7)\n\tString s1 = ofoo.foo;\n\t            ^^^^^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 8)\n\tString s2 = ofoo.bar();\n\t                 ^^^\nThe method bar() from the type OtherFoo refers to the missing type Zork\n----------\n5. ERROR in X.java (at line 9)\n\tString s3 = ofoo.new OtherMember();\n\t            ^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from OtherFoo.OtherMember to String\n----------\n6. ERROR in X.java (at line 10)\n\tofoo.baz(this);\n\t     ^^^\nThe method baz(Zork) from the type OtherFoo refers to the missing type Zork\n----------\n7. ERROR in X.java (at line 14)\n\tString s1 = ox.foo;\n\t            ^^^^^^\nZork cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 15)\n\tString s2 = ox.bar();\n\t               ^^^\nThe method bar() from the type OtherX refers to the missing type Zork\n----------\n9. ERROR in X.java (at line 16)\n\tString s3 = ox.new OtherMember();\n\t            ^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from OtherX.OtherMember to String\n----------\n10. ERROR in X.java (at line 17)\n\tox.baz(this);\n\t   ^^^\nThe method baz(Zork) from the type OtherX refers to the missing type Zork\n----------\n11. ERROR in X.java (at line 22)\n\tpublic class OtherMember extends Zork {}\n\t                                 ^^^^\nZork cannot be resolved to a type\n----------\n12. ERROR in X.java (at line 23)\n\tpublic Zork foo;\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n13. ERROR in X.java (at line 24)\n\tpublic Zork bar() {\treturn null; }\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n14. ERROR in X.java (at line 25)\n\tpublic void baz(Zork z) {}\n\t                ^^^^\nZork cannot be resolved to a type\n----------\n", null, false);
    }

    public void test005() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo extends Zork{\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q1"));
        this.runNegativeTest(false, new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tp.OtherFoo ofoo = new p.OtherFoo();\n\t\tofoo.bar();\n\t\tq1.q2.Zork z;\n\t}\n}\t\n"}, null, null, "----------\n1. ERROR in X.java (at line 4)\n\tofoo.bar();\n\t^^^^^^^^^^\nThe type q1.q2.Zork cannot be resolved. It is indirectly referenced from required .class files\n----------\n2. ERROR in X.java (at line 4)\n\tofoo.bar();\n\t     ^^^\nThe method bar() from the type OtherFoo refers to the missing type Zork\n----------\n3. ERROR in X.java (at line 5)\n\tq1.q2.Zork z;\n\t^^^^^^^^^^\nq1.q2.Zork cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP_UNTIL_FRAMEWORK_FIX);
    }

    public void test006() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo extends Zork{\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q1"));
        this.runNegativeTest(false, new String[]{"X.java", "import q1.q2.*;\npublic class X {\n\tvoid foo() {\n\t\tp.OtherFoo ofoo = new p.OtherFoo();\n\t\tofoo.bar();\n\t\tZork z;\n\t}\n}\t\n"}, null, null, "----------\n1. ERROR in X.java (at line 1)\n\timport q1.q2.*;\n\t       ^^\nThe import q1 cannot be resolved\n----------\n2. ERROR in X.java (at line 5)\n\tofoo.bar();\n\t^^^^^^^^^^\nThe type q1.q2.Zork cannot be resolved. It is indirectly referenced from required .class files\n----------\n3. ERROR in X.java (at line 5)\n\tofoo.bar();\n\t     ^^^\nThe method bar() from the type OtherFoo refers to the missing type Zork\n----------\n4. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP_UNTIL_FRAMEWORK_FIX);
    }

    public void test007() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo extends Zork{\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q1"));
        this.runNegativeTest(false, new String[]{"X.java", "import q1.q2.Zork;\npublic class X {\n\tvoid foo() {\n\t\tp.OtherFoo ofoo = new p.OtherFoo();\n\t\tofoo.bar();\n\t\tZork z;\n\t}\n}\t\n"}, null, null, "----------\n1. ERROR in X.java (at line 1)\n\timport q1.q2.Zork;\n\t       ^^\nThe import q1 cannot be resolved\n----------\n2. ERROR in X.java (at line 5)\n\tofoo.bar();\n\t^^^^^^^^^^\nThe type q1.q2.Zork cannot be resolved. It is indirectly referenced from required .class files\n----------\n3. ERROR in X.java (at line 5)\n\tofoo.bar();\n\t     ^^^\nThe method bar() from the type OtherFoo refers to the missing type Zork\n----------\n4. ERROR in X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP_UNTIL_FRAMEWORK_FIX);
    }

    public void test008() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo extends Zork{\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q1"));
        this.runNegativeTest(false, new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tq1.q2.Zork z;\n\t}\n}\t\n"}, null, null, "----------\n1. ERROR in X.java (at line 3)\n\tq1.q2.Zork z;\n\t^^\nq1 cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP_UNTIL_FRAMEWORK_FIX);
    }

    public void test009() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo extends Zork{\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q1"));
        this.runNegativeTest(false, new String[]{"X.java", "import q1.q2.*;\npublic class X {\n\tvoid foo() {\n\t\tZork z;\n\t}\n}\t\n"}, null, null, "----------\n1. ERROR in X.java (at line 1)\n\timport q1.q2.*;\n\t       ^^\nThe import q1 cannot be resolved\n----------\n2. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP_UNTIL_FRAMEWORK_FIX);
    }

    public void test010() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo extends Zork{\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q1"));
        this.runNegativeTest(false, new String[]{"X.java", "import q1.q2.Zork;\npublic class X {\n\tvoid foo() {\n\t\tZork z;\n\t}\n}\t\n"}, null, null, "----------\n1. ERROR in X.java (at line 1)\n\timport q1.q2.Zork;\n\t       ^^\nThe import q1 cannot be resolved\n----------\n2. ERROR in X.java (at line 4)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP_UNTIL_FRAMEWORK_FIX);
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "public class  X {\n\tjava[] field1;\n\tjava.lang[] field2;\n\tvoid field3;\n\tvoid[] field4;\n\t\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tjava[] field1;\n\t^^^^\njava cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tjava.lang[] field2;\n\t^^^^^^^^^\njava.lang cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 4)\n\tvoid field3;\n\t     ^^^^^^\nvoid is an invalid type for the variable field3\n----------\n4. ERROR in X.java (at line 5)\n\tvoid[] field4;\n\t^^^^^^\nvoid[] is an invalid type\n----------\n");
    }

    public void test012() {
        String expectedResult = this.complianceLevel <= 0x300000L ? "----------\n1. ERROR in X.java (at line 2)\n\tClass c1 = java[].class;\n\t           ^^^^\njava cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tClass c2 = java.lang[].class;\n\t           ^^^^^^^^^\njava.lang cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tClass c4 = void[].class;\n\t           ^^^^^^\nvoid[] is an invalid type\n----------\n" : "----------\n1. WARNING in X.java (at line 2)\n\tClass c1 = java[].class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tClass c1 = java[].class;\n\t           ^^^^\njava cannot be resolved to a type\n----------\n3. WARNING in X.java (at line 3)\n\tClass c2 = java.lang[].class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n4. ERROR in X.java (at line 3)\n\tClass c2 = java.lang[].class;\n\t           ^^^^^^^^^\njava.lang cannot be resolved to a type\n----------\n5. WARNING in X.java (at line 4)\n\tClass c3 = void.class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n6. WARNING in X.java (at line 5)\n\tClass c4 = void[].class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n7. ERROR in X.java (at line 5)\n\tClass c4 = void[].class;\n\t           ^^^^^^\nvoid[] is an invalid type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class  X {\n\tClass c1 = java[].class;\n\tClass c2 = java.lang[].class;\n\tClass c3 = void.class;\n\tClass c4 = void[].class;\n}\n"}, expectedResult);
    }

    public void test013() {
        String expectedResult = this.complianceLevel <= 0x300000L ? "----------\n1. ERROR in X.java (at line 3)\n\tClass c2 = java.lang[].class;\n\t           ^^^^^^^^^\njava.lang cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 3)\n\tClass c2 = java.lang[].class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tClass c2 = java.lang[].class;\n\t           ^^^^^^^^^\njava.lang cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class  X {\n\t// check if no prior reference to missing 'java'\n\tClass c2 = java.lang[].class;\n}\n"}, expectedResult);
    }

    public void test014() {
        String expectedResult = this.complianceLevel <= 0x300000L ? "----------\n1. ERROR in X.java (at line 3)\n\tClass c2 = java.lang[].class;\n\t           ^^^^^^^^^\njava.lang cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 3)\n\tClass c2 = java.lang[].class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tClass c2 = java.lang[].class;\n\t           ^^^^^^^^^\njava.lang cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class  X {\n\t// check if no prior reference to missing 'java'\n\tClass c2 = java.lang[].class;\n}\n"}, expectedResult);
    }

    public void test015() {
        String expectedResult = this.complianceLevel <= 0x300000L ? "----------\n1. ERROR in X.java (at line 2)\n\tClass a = zork1[].class;\n\t          ^^^^^\nzork1 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tClass x = zork1.zork2[].class;\t// compile time error\n\t          ^^^^^\nzork1 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tClass a2 = zork1.class;\n\t           ^^^^^\nzork1 cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 6)\n\tClass x2 = zork1.zork2.class;\t// compile time error\t\n\t           ^^^^^\nzork1 cannot be resolved to a type\n----------\n" : "----------\n1. WARNING in X.java (at line 2)\n\tClass a = zork1[].class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n2. ERROR in X.java (at line 2)\n\tClass a = zork1[].class;\n\t          ^^^^^\nzork1 cannot be resolved to a type\n----------\n3. WARNING in X.java (at line 3)\n\tClass x = zork1.zork2[].class;\t// compile time error\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n4. ERROR in X.java (at line 3)\n\tClass x = zork1.zork2[].class;\t// compile time error\n\t          ^^^^^\nzork1 cannot be resolved to a type\n----------\n5. WARNING in X.java (at line 5)\n\tClass a2 = zork1.class;\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n6. ERROR in X.java (at line 5)\n\tClass a2 = zork1.class;\n\t           ^^^^^\nzork1 cannot be resolved to a type\n----------\n7. WARNING in X.java (at line 6)\n\tClass x2 = zork1.zork2.class;\t// compile time error\t\n\t^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n8. ERROR in X.java (at line 6)\n\tClass x2 = zork1.zork2.class;\t// compile time error\t\n\t           ^^^^^\nzork1 cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class  X {\n\tClass a = zork1[].class;\n\tClass x = zork1.zork2[].class;\t// compile time error\n\t\n\tClass a2 = zork1.class;\n\tClass x2 = zork1.zork2.class;\t// compile time error\t\n}\n"}, expectedResult);
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tjava.langz.AClass1 field1;\n\tjava.langz.AClass2 field2;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tjava.langz.AClass1 field1;\n\t^^^^^^^^^^\njava.langz cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tjava.langz.AClass2 field2;\n\t^^^^^^^^^^\njava.langz cannot be resolved to a type\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tjava.langz field1;\n\tjava.langz.AClass2 field2;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tjava.langz field1;\n\t^^^^^^^^^^\njava.langz cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tjava.langz.AClass2 field2;\n\t^^^^^^^^^^\njava.langz cannot be resolved to a type\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tjava.langz.AClass1 field1;\n\tjava.langz field2;\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tjava.langz.AClass1 field1;\n\t^^^^^^^^^^\njava.langz cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tjava.langz field2;\n\t^^^^^^^^^^\njava.langz cannot be resolved to a type\n----------\n");
    }

    public void test019() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo extends Zork{\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q1"));
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(p.OtherFoo ofoo) {\n\t\ta.b.Missing1 m1;\n\t\tq1.q2.Missing2 m2;\n\t}\n}\t\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ta.b.Missing1 m1;\n\t^\na cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tq1.q2.Missing2 m2;\n\t^^^^^^^^^^^^^^\nq1.q2.Missing2 cannot be resolved to a type\n----------\n", null, false);
    }

    public void test020() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo extends Zork{\n\tpublic class OtherMember extends Zork {}\n\tpublic Zork foo;\n\tpublic Zork bar() {\treturn null; }\n\tpublic void baz(Zork z) {}\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(p.OtherFoo ofoo) {\n\t\ta.b.Missing1 m1;\n\t\tq1.q2.Missing2 m2;\n\t}\n}\t\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ta.b.Missing1 m1;\n\t^\na cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tq1.q2.Missing2 m2;\n\t^^^^^^^^^^^^^^\nq1.q2.Missing2 cannot be resolved to a type\n----------\n", null, false);
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(p.OtherFoo ofoo) {\n\t\ta.b.Missing1 m1;\n\t\tq1.q2.Missing2 m2;\n\t}\n}\t\n", "p/OtherFoo.java", "package p;\npublic class OtherFoo extends q1.q2.Zork{\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\ta.b.Missing1 m1;\n\t^\na cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tq1.q2.Missing2 m2;\n\t^^\nq1 cannot be resolved to a type\n----------\n----------\n1. ERROR in p\\OtherFoo.java (at line 2)\n\tpublic class OtherFoo extends q1.q2.Zork{\n\t                              ^^\nq1 cannot be resolved to a type\n----------\n");
    }

    public void test022() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo {\n\tpublic Zork foo;\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q1"));
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(q1.q2.Missing1 m1) {\n\t\ta.b.Missing1 m1a;\n\t\tp.OtherFoo ofoo;\n\t\tq1.q2.Missing1 m11;\n\t}\n}\t\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(q1.q2.Missing1 m1) {\n\t         ^^\nq1 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\ta.b.Missing1 m1a;\n\t^\na cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tq1.q2.Missing1 m11;\n\t^^\nq1 cannot be resolved to a type\n----------\n", null, false);
    }

    public void test023() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo {\n\tpublic Zork foo;\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(q1.q2.Missing1 m1) {\n\t\ta.b.Missing1 m1a;\n\t\tp.OtherFoo ofoo;\n\t\tq1.q2.Missing1 m11;\n\t}\n}\t\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(q1.q2.Missing1 m1) {\n\t         ^^^^^^^^^^^^^^\nq1.q2.Missing1 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\ta.b.Missing1 m1a;\n\t^\na cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tq1.q2.Missing1 m11;\n\t^^^^^^^^^^^^^^\nq1.q2.Missing1 cannot be resolved to a type\n----------\n", null, false);
    }

    public void test024() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo {\n\tpublic Zork foo;\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q1/q2"));
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(q1.q2.Missing1 m1) {\n\t\ta.b.Missing1 m1a;\n\t\tp.OtherFoo ofoo;\n\t\tq1.q2.Missing1 m11;\n\t}\n}\t\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(q1.q2.Missing1 m1) {\n\t         ^^^^^\nq1.q2 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\ta.b.Missing1 m1a;\n\t^\na cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tq1.q2.Missing1 m11;\n\t^^^^^^^^^^^^^^\nq1.q2.Missing1 cannot be resolved to a type\n----------\n", null, false);
    }

    public void test025() {
        this.runConformTest(new String[]{"p/OtherFoo.java", "package p;\n\nimport q1.q2.Zork;\n\npublic class OtherFoo {\n\tpublic Zork foo;\n}\n", "q1/q2/Zork.java", "package q1.q2;\npublic class Zork {\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "q1/q2"));
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(q1.q2.Missing1 m1) {\n\t\ta.b.Missing1 m1a;\n\t\tp.OtherFoo ofoo;\n\t}\n}\t\n", "Y.java", "public class Y {\n\tvoid foo() {\n\t\tq1.q2.Missing1 m11;\n\t}\n}\t\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(q1.q2.Missing1 m1) {\n\t         ^^^^^\nq1.q2 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\ta.b.Missing1 m1a;\n\t^\na cannot be resolved to a type\n----------\n----------\n1. ERROR in Y.java (at line 3)\n\tq1.q2.Missing1 m11;\n\t^^^^^^^^^^^^^^\nq1.q2.Missing1 cannot be resolved to a type\n----------\n", null, false);
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Missing1 m1) {\n\t\tMissing2 m2 = m1;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Missing1 m1) {\n\t         ^^^^^^^^\nMissing1 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tMissing2 m2 = m1;\n\t^^^^^^^^\nMissing2 cannot be resolved to a type\n----------\n");
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X x) {\n\t\tnew Other().m2 = x;\n\t\tOther other = new Other();\n\t\tother.m2 = x;\n\t\tother.m2.m3 = x;\n\t}\n}\n\nclass Other {\n\tMissing2 m2;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew Other().m2 = x;\n\t^^^^^^^^^^^^^^\nMissing2 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\tother.m2 = x;\n\t^^^^^^^^\nMissing2 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 6)\n\tother.m2.m3 = x;\n\t^^^^^^^^\nMissing2 cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 11)\n\tMissing2 m2;\n\t^^^^^^^^\nMissing2 cannot be resolved to a type\n----------\n");
    }

    public void test028() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X x) {\n\t\tSystem.out.println(new Other().m2.m3);\n\t\tSystem.out.println(new Other().m2.m3());\n\t\tMissing2.foo();\n\t}\n}\n\nclass Other {\n\tMissing2 m2;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(new Other().m2.m3);\n\t                   ^^^^^^^^^^^^^^\nMissing2 cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tSystem.out.println(new Other().m2.m3());\n\t                   ^^^^^^^^^^^^^^\nMissing2 cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tMissing2.foo();\n\t^^^^^^^^\nMissing2 cannot be resolved\n----------\n4. ERROR in X.java (at line 10)\n\tMissing2 m2;\n\t^^^^^^^^\nMissing2 cannot be resolved to a type\n----------\n");
    }

    public void test029() throws Exception {
        this.runNegativeTest(new String[]{"Y.java", "public class Y extends Z {\n}\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y extends Z {\n\t                       ^\nZ cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        String expectedOutput = "public class Y {\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "Y.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            ProblemTypeAndMethodTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test030() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y extends Z {\n}\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y extends Z {\n\t                       ^\nZ cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Y {\n\t             ^\nThe hierarchy of the type X is inconsistent\n----------\n", null, false, null, true, false, false);
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y {\n}\n", "Y.java", "public class Y extends Z {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X extends Y {\n\t             ^\nThe hierarchy of the type X is inconsistent\n----------\n----------\n1. ERROR in Y.java (at line 1)\n\tpublic class Y extends Z {\n\t                       ^\nZ cannot be resolved to a type\n----------\n");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.java", "import existing.*;\npublic class X {\n  void foo(p.Zork z) {}\n  void bar(Zork z) {} // should bind to existing.Zork\n}\n", "p/Clyde.java", "package p;\npublic class Clyde {\n}\n", "existing/Zork.java", "package existing;\npublic class Zork {\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo(p.Zork z) {}\n\t         ^^^^^^\np.Zork cannot be resolved to a type\n----------\n");
    }

    public void test033() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"Y.java", "@Z public class Y {\n}\n"}, "----------\n1. ERROR in Y.java (at line 1)\n\t@Z public class Y {\n\t ^\nZ cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runConformTest(false, new String[]{"X.java", "public class X extends Y {\n}\n"}, "", "", "", AbstractRegressionTest.JavacTestOptions.SKIP_UNTIL_FRAMEWORK_FIX);
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = x1.bar();\n\t}\n}\n", "X1.java", "public class X1 {\n\tZork bar() { return null; }\t\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = x1.bar();\n\t              ^^^\nThe method bar() from the type X1 refers to the missing type Zork\n----------\n----------\n1. ERROR in X1.java (at line 2)\n\tZork bar() { return null; }\t\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tZork bar() { return null; }\t\n}\n"}, "----------\n1. ERROR in X1.java (at line 2)\n\tZork bar() { return null; }\t\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = x1.bar();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = x1.bar();\n\t              ^^^\nThe method bar() from the type X1 refers to the missing type Zork\n----------\n", null, false, null, true, false, false);
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = x1.bar(x1);\n\t}\n}\n", "X1.java", "public class X1 {\n\tObject bar(Zork z) { return null; }\t\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = x1.bar(x1);\n\t              ^^^\nThe method bar(Zork) from the type X1 refers to the missing type Zork\n----------\n----------\n1. ERROR in X1.java (at line 2)\n\tObject bar(Zork z) { return null; }\t\n\t           ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tObject bar(Zork z) { return null; }\t\n}\n"}, "----------\n1. ERROR in X1.java (at line 2)\n\tObject bar(Zork z) { return null; }\t\n\t           ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = x1.bar(x1);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = x1.bar(x1);\n\t              ^^^\nThe method bar(Zork) from the type X1 refers to the missing type Zork\n----------\n", null, false, null, true, false, false);
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = x1.bar(x1);\n\t}\n}\n", "X1.java", "public class X1 {\n\tObject bar(Object o) throws Zork { return null; }\t\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = x1.bar(x1);\n\t              ^^^\nThe method bar(Object) from the type X1 refers to the missing type Zork\n----------\n----------\n1. ERROR in X1.java (at line 2)\n\tObject bar(Object o) throws Zork { return null; }\t\n\t                            ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tObject bar(Object o) throws Zork { return null; }\t\n}\n"}, "----------\n1. ERROR in X1.java (at line 2)\n\tObject bar(Object o) throws Zork { return null; }\t\n\t                            ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = x1.bar(x1);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = x1.bar(x1);\n\t              ^^^\nThe method bar(Object) from the type X1 refers to the missing type Zork\n----------\n", null, false, null, true, false, false);
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = new X1(x1);\n\t}\n}\n", "X1.java", "public class X1 {\n\tpublic X1(Zork z) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new X1(x1);\n\t           ^^^^^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1(Zork z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test041() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tpublic X1(Zork z) {}\n}\n"}, "----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1(Zork z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = new X1(x1);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new X1(x1);\n\t           ^^^^^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n", null, false, null, true, false, false);
    }

    public void test042() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = new X1();\n\t}\n}\n", "X1.java", "public class X1 {\n\tpublic X1() throws Zork {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new X1();\n\t           ^^^^^^^^\nThe constructor X1() refers to the missing type Zork\n----------\n----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1() throws Zork {}\n\t                   ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test043() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tpublic X1() throws Zork {}\n}\n"}, "----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1() throws Zork {}\n\t                   ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = new X1();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new X1();\n\t           ^^^^^^^^\nThe constructor X1() refers to the missing type Zork\n----------\n", null, false, null, true, false, false);
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = new X1(x1){};\n\t}\n}\n", "X1.java", "public class X1 {\n\tpublic X1(Zork z) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new X1(x1){};\n\t               ^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1(Zork z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tpublic X1(Zork z) {}\n}\n"}, "----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1(Zork z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = new X1(x1){};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new X1(x1){};\n\t               ^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n", null, false, null, true, false, false);
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = new X1(){};\n\t}\n}\n", "X1.java", "public class X1 {\n\tpublic X1() throws Zork {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new X1(){};\n\t               ^^^^\nThe constructor X1() refers to the missing type Zork\n----------\n----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1() throws Zork {}\n\t                   ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test047() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tpublic X1() throws Zork {}\n}\n"}, "----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1() throws Zork {}\n\t                   ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o = new X1(){};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tObject o = new X1(){};\n\t               ^^^^\nThe constructor X1() refers to the missing type Zork\n----------\n", null, false, null, true, false, false);
    }

    public void test048() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends X1 {\n\tX(X1 x1) {\n\t\tsuper(x1);\n\t}\n}\n", "X1.java", "public class X1 {\n\tpublic X1(Zork z) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tsuper(x1);\n\t^^^^^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1(Zork z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tpublic X1(Zork z) {}\n}\n"}, "----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1(Zork z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X extends X1 {\n\tX(X1 x1) {\n\t\tsuper(x1);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tsuper(x1);\n\t^^^^^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n", null, false, null, true, false, false);
    }

    public void test050() {
        this.runNegativeTest(new String[]{"X.java", "public class X extends X1 {\n\tX(X1 x1) {\n\t\tsuper();\n\t}\n}\n", "X1.java", "public class X1 {\n\tpublic X1() throws Zork {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tsuper();\n\t^^^^^^^^\nThe constructor X1() refers to the missing type Zork\n----------\n----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1() throws Zork {}\n\t                   ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test051() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tpublic X1() throws Zork {}\n}\n"}, "----------\n1. ERROR in X1.java (at line 2)\n\tpublic X1() throws Zork {}\n\t                   ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X extends X1 {\n\tX(X1 x1) {\n\t\tsuper();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tsuper();\n\t^^^^^^^^\nThe constructor X1() refers to the missing type Zork\n----------\n", null, false, null, true, false, false);
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o;\n\t\to = x1.next.zork;\n\t\to = this.zork;\n\t\to = zork;\n\t\to = x1.next.zork.foo();\n\t\to = this.zork.foo();\n\t\to = zork.foo();\n\t}\n\tZork zork;\n}\nclass X1 {\n\tX1 next;\n\tZork zork;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\to = x1.next.zork;\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\to = this.zork;\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 6)\n\to = zork;\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 7)\n\to = x1.next.zork.foo();\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 8)\n\to = this.zork.foo();\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 9)\n\to = zork.foo();\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 11)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 15)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar(X1 x1) {\n\t\tString s;\n\t\ts = x1.next.zork;\n\t\ts = this.zork;\n\t\ts = zork;\n\t\ts = x1.next.zork.foo();\n\t\ts = this.zork.foo();\n\t\ts = zork.foo();\n\t}\t\n\tZork zork;\n}\nclass X1 {\n\tX1 next;\n\tZork zork;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\ts = x1.next.zork;\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\ts = this.zork;\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 6)\n\ts = zork;\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 7)\n\ts = x1.next.zork.foo();\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 8)\n\ts = this.zork.foo();\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 9)\n\ts = zork.foo();\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 11)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 15)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test054() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid baz(X1 x1) {\n\t\tZork z;\n\t\tz = x1.next.zork;\n\t\tz = this.zork;\n\t\tz = zork;\n\t\tz = x1.next.zork.foo();\n\t\tz = this.zork.foo();\n\t\tz = zork.foo();\n\t}\t\n\tZork zork;\n}\nclass X1 {\n\tX1 next;\n\tZork zork;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tz = x1.next.zork;\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tz = this.zork;\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 6)\n\tz = zork;\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 7)\n\tz = x1.next.zork.foo();\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 8)\n\tz = this.zork.foo();\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 9)\n\tz = zork.foo();\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 11)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n9. ERROR in X.java (at line 15)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test055() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tpublic X1 next;\n\tpublic Zork zork;\n}\n"}, "----------\n1. ERROR in X1.java (at line 3)\n\tpublic Zork zork;\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tObject o;\n\t\to = x1.next.zork;\n\t\to = this.zork;\n\t\to = zork;\n\t\to = x1.next.zork.foo();\n\t\to = this.zork.foo();\n\t\to = zork.foo();\n\t}\n\tZork zork;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\to = x1.next.zork;\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\to = this.zork;\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 6)\n\to = zork;\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 7)\n\to = x1.next.zork.foo();\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 8)\n\to = this.zork.foo();\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 9)\n\to = zork.foo();\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 11)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, false, null, true, false, false);
    }

    public void test056() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tpublic X1 next;\n\tpublic Zork zork;\n}\n"}, "----------\n1. ERROR in X1.java (at line 3)\n\tpublic Zork zork;\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid bar(X1 x1) {\n\t\tString s;\n\t\ts = x1.next.zork;\n\t\ts = this.zork;\n\t\ts = zork;\n\t\ts = x1.next.zork.foo();\n\t\ts = this.zork.foo();\n\t\ts = zork.foo();\n\t}\t\n\tZork zork;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\ts = x1.next.zork;\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\ts = this.zork;\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 6)\n\ts = zork;\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 7)\n\ts = x1.next.zork.foo();\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 8)\n\ts = this.zork.foo();\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 9)\n\ts = zork.foo();\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 11)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, false, null, true, false, false);
    }

    public void test057() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tpublic X1 next;\n\tpublic Zork zork;\n}\n"}, "----------\n1. ERROR in X1.java (at line 3)\n\tpublic Zork zork;\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n", null, true, null, true, false, false);
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid baz(X1 x1) {\n\t\tZork z;\n\t\tz = x1.next.zork;\n\t\tz = this.zork;\n\t\tz = zork;\n\t\tz = x1.next.zork.foo();\n\t\tz = this.zork.foo();\n\t\tz = zork.foo();\n\t}\t\n\tZork zork;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tz = x1.next.zork;\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 5)\n\tz = this.zork;\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 6)\n\tz = zork;\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n5. ERROR in X.java (at line 7)\n\tz = x1.next.zork.foo();\n\t    ^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 8)\n\tz = this.zork.foo();\n\t    ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 9)\n\tz = zork.foo();\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 11)\n\tZork zork;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, false, null, true, false, false);
    }

    public void test058() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tx1.bar().baz();\n\t}\n}\n\nclass X1 {\n\tZork bar(){}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tx1.bar().baz();\n\t   ^^^\nThe method bar() from the type X1 refers to the missing type Zork\n----------\n2. ERROR in X.java (at line 8)\n\tZork bar(){}\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test059() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tnew X1(x1).baz();\n\t\tnew X1(null).baz();\n\t\tnew Zork().baz();\n\t\tnew X1(x1){}.baz();\n\t\tnew X1(null){}.baz();\n\t\tnew Zork(){}.baz();\n\t}\n}\n\nclass X1 {\n\tX1(Zork z) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew X1(x1).baz();\n\t^^^^^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n2. ERROR in X.java (at line 3)\n\tnew X1(x1).baz();\n\t           ^^^\nThe method baz() is undefined for the type X1\n----------\n3. ERROR in X.java (at line 4)\n\tnew X1(null).baz();\n\t^^^^^^^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n4. ERROR in X.java (at line 4)\n\tnew X1(null).baz();\n\t             ^^^\nThe method baz() is undefined for the type X1\n----------\n5. ERROR in X.java (at line 5)\n\tnew Zork().baz();\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 6)\n\tnew X1(x1){}.baz();\n\t    ^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n7. ERROR in X.java (at line 6)\n\tnew X1(x1){}.baz();\n\t             ^^^\nThe method baz() is undefined for the type new X1(){}\n----------\n8. ERROR in X.java (at line 7)\n\tnew X1(null){}.baz();\n\t    ^^^^^^^^\nThe constructor X1(Zork) refers to the missing type Zork\n----------\n9. ERROR in X.java (at line 7)\n\tnew X1(null){}.baz();\n\t               ^^^\nThe method baz() is undefined for the type new X1(){}\n----------\n10. ERROR in X.java (at line 8)\n\tnew Zork(){}.baz();\n\t    ^^^^\nZork cannot be resolved to a type\n----------\n11. ERROR in X.java (at line 13)\n\tX1(Zork z) {}\n\t   ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test060() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Zork z) {\n\t\tz.bar();\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tvoid foo(Zork z) {\n\t         ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(X1 x1) {\n\t\tint i = x1.next.z;\n\t\tint j = x1.next.zArray;\n\t}\n}\n\nclass X1 {\n\tX1 next;\n\tZork z;\n\tZork[] zArray;\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint i = x1.next.z;\n\t        ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tint j = x1.next.zArray;\n\t        ^^^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 11)\n\tZork[] zArray;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test062() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tX1 x1;\n\tvoid foo() {\n\t\tint i = x1.next.z;\n\t\tint j = x1.next.zArray;\n\t}\n}\n\nclass X1 {\n\tX1 next;\n\tZork z;\n\tZork[] zArray;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tint i = x1.next.z;\n\t        ^^^^^^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\tint j = x1.next.zArray;\n\t        ^^^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 12)\n\tZork[] zArray;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test063() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tvoid foo() {\n\t\tint i = p.X1.z;\n\t\tint j = p.X1.zArray;\n\t}\n}\n\nclass X1 {\n\tstatic Zork z;\n\tstatic Zork[] zArray;\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 4)\n\tint i = p.X1.z;\n\t        ^^^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in p\\X.java (at line 5)\n\tint j = p.X1.zArray;\n\t        ^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in p\\X.java (at line 10)\n\tstatic Zork z;\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in p\\X.java (at line 11)\n\tstatic Zork[] zArray;\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test064() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\t\t\npublic class X {\n    void foo() {\n        Serializable[] v= new ArrayListExtra[10];\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tSerializable[] v= new ArrayListExtra[10];\n\t                      ^^^^^^^^^^^^^^\nArrayListExtra cannot be resolved to a type\n----------\n");
    }

    public void test065() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\t\t\npublic class X {\n    void foo() {\n    \tint l = array.length;\n    \tObject o = array[1];\n\n    }\n    Zork[] array;\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tint l = array.length;\n\t        ^^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 5)\n\tObject o = array[1];\n\t           ^^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 8)\n\tZork[] array;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test066() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n        void foo() {\n                Zork z1 = null;\n                Object o = z1;\n                Object o1 = z1.z2;\n                Object o2 = bar();\n                Zork[] array = null;\n                int length = array.length;\n        }\n        Zork bar() {\n        }\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tZork z1 = null;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\tObject o2 = bar();\n\t            ^^^\nThe method bar() from the type X refers to the missing type Zork\n----------\n3. ERROR in X.java (at line 7)\n\tZork[] array = null;\n\t^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 10)\n\tZork bar() {\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test067() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"E.java", "public class E<T> {\n    class SomeType { }\n    void foo() {\n        E<XYX> list= new E<SomeType>();\n        list = new E<SomeType>();\n    }\n    E<XYX> fList= new E<SomeType>();\n}\n"}, "----------\n1. ERROR in E.java (at line 4)\n\tE<XYX> list= new E<SomeType>();\n\t  ^^^\nXYX cannot be resolved to a type\n----------\n2. ERROR in E.java (at line 7)\n\tE<XYX> fList= new E<SomeType>();\n\t  ^^^\nXYX cannot be resolved to a type\n----------\n");
    }

    public void test068() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"E.java", "import java.util.Map;\npublic class E<T> {\n    static class SomeType { }\n    void foo() {\n        E<Map<String, ? extends XYX>> list= new E<Map<String, ? extends SomeType>>() {\n        };\n    }\n}\n"}, "----------\n1. ERROR in E.java (at line 5)\n\tE<Map<String, ? extends XYX>> list= new E<Map<String, ? extends SomeType>>() {\n\t                        ^^^\nXYX cannot be resolved to a type\n----------\n");
    }

    public void test069() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tIOException foo() {}\n}\n", "p/Y.java", "package p;\nimport java.io.*;\npublic class Y {\n   void foo(IOException e) {}\n   void bar(Zork z) {}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\tIOException foo() {}\n\t^^^^^^^^^^^\nIOException cannot be resolved to a type\n----------\n----------\n1. ERROR in p\\Y.java (at line 5)\n\tvoid bar(Zork z) {}\n\t         ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test070() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tIOException foo() {}\n}\n", "q/Y.java", "package q;\nimport p.*;\nimport java.io.*;\npublic class Y {\n   void foo(IOException e) {}\n   void bar(Zork z) {}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 3)\n\tIOException foo() {}\n\t^^^^^^^^^^^\nIOException cannot be resolved to a type\n----------\n----------\n1. ERROR in q\\Y.java (at line 6)\n\tvoid bar(Zork z) {}\n\t         ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test071() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tIOException foo() {}\n}\n", "Y.java", "import java.io.*;\npublic class Y {\n   void foo(IOException e) {}\n   void bar(Zork z) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tIOException foo() {}\n\t^^^^^^^^^^^\nIOException cannot be resolved to a type\n----------\n----------\n1. ERROR in Y.java (at line 4)\n\tvoid bar(Zork z) {}\n\t         ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test072() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo() throws Foo {\n\t}\n\tpublic void bar() throws Zork {\n\t}\t\n}\n\nclass Foo extends Zork {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo() throws Foo {\n\t                         ^^^\nNo exception of type Foo can be thrown; an exception type must be a subclass of Throwable\n----------\n2. ERROR in X.java (at line 4)\n\tpublic void bar() throws Zork {\n\t                         ^^^^\nZork cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 8)\n\tclass Foo extends Zork {\n\t                  ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test073() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t/**\n\t * @see Foo.Private#foo()\n\t * @param p\n\t */\n\tvoid foo(Foo.Private p) {\n\t\tp.foo();\n\t}\n}\n\nclass Foo {\n\tprivate class Private {\n\t\tprivate void foo(){}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tvoid foo(Foo.Private p) {\n\t         ^^^^^^^^^^^\nThe type Foo.Private is not visible\n----------\n2. ERROR in X.java (at line 7)\n\tp.foo();\n\t^\nThe type Foo.Private is not visible\n----------\n3. WARNING in X.java (at line 12)\n\tprivate class Private {\n\t              ^^^^^^^\nThe type Foo.Private is never used locally\n----------\n4. WARNING in X.java (at line 13)\n\tprivate void foo(){}\n\t             ^^^^^\nThe method foo() from the type Foo.Private is never used locally\n----------\n");
    }

    public void test074() {
        String expected = this.complianceLevel <= 0x300000L ? "----------\n1. ERROR in X.java (at line 4)\n\tbar1().foo();\n\t^^^^\nThe method bar1() from the type X refers to the missing type Zork\n----------\n2. ERROR in X.java (at line 5)\n\tbar2();\n\t^^^^\nThe method bar2() from the type X refers to the missing type Zork\n----------\n3. ERROR in X.java (at line 6)\n\tbar3(null);\n\t^^^^\nThe method bar3(Zork) from the type X refers to the missing type Zork\n----------\n4. ERROR in X.java (at line 7)\n\tbar4(null,null);\n\t^^^^\nThe method bar4(Zork) from the type X refers to the missing type Zork\n----------\n5. ERROR in X.java (at line 9)\n\tZork<String> bar1() {}\n\t^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 9)\n\tZork<String> bar1() {}\n\t     ^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n7. ERROR in X.java (at line 10)\n\tList<Zork> bar2() {}\n\t     ^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n8. ERROR in X.java (at line 10)\n\tList<Zork> bar2() {}\n\t     ^^^^\nZork cannot be resolved to a type\n----------\n9. ERROR in X.java (at line 11)\n\tvoid bar3(Zork<String> z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n10. ERROR in X.java (at line 11)\n\tvoid bar3(Zork<String> z) {}\n\t               ^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n11. ERROR in X.java (at line 12)\n\tvoid bar4(Zork<String,String> z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n12. ERROR in X.java (at line 12)\n\tvoid bar4(Zork<String,String> z) {}\n\t               ^^^^^^^^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n" : "----------\n1. ERROR in X.java (at line 4)\n\tbar1().foo();\n\t^^^^\nThe method bar1() from the type X refers to the missing type Zork\n----------\n2. ERROR in X.java (at line 5)\n\tbar2();\n\t^^^^\nThe method bar2() from the type X refers to the missing type Zork\n----------\n3. ERROR in X.java (at line 6)\n\tbar3(null);\n\t^^^^\nThe method bar3(Zork<String>) from the type X refers to the missing type Zork\n----------\n4. ERROR in X.java (at line 7)\n\tbar4(null,null);\n\t^^^^\nThe method bar4(Zork<String,String>) from the type X refers to the missing type Zork\n----------\n5. ERROR in X.java (at line 9)\n\tZork<String> bar1() {}\n\t^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 10)\n\tList<Zork> bar2() {}\n\t     ^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 11)\n\tvoid bar3(Zork<String> z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n8. ERROR in X.java (at line 12)\n\tvoid bar4(Zork<String,String> z) {}\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tvoid foo() {\n\t\tbar1().foo();\n\t\tbar2();\n\t\tbar3(null);\n\t\tbar4(null,null);\n\t}\n\tZork<String> bar1() {}\n\tList<Zork> bar2() {}\n\tvoid bar3(Zork<String> z) {}\n\tvoid bar4(Zork<String,String> z) {}\n}\n"}, expected);
    }

    public void test075() {
        String expected = this.complianceLevel <= 0x300000L ? "----------\n1. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? extends Number>) o;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? extends Number>) o;\n\t     ^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n3. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? extends Number>) o;\n\t               ^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? extends Number>) o;\n\t                    ^^^^^^^^^^^^^^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n5. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number>) o;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number>) o;\n\t            ^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number>) o;\n\t                 ^^^^^^^^^^^^^^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? extends Number>) o;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? extends Number>) o;\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Zork<?,? extends Number>\n----------\n3. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? extends Number>) o;\n\t               ^^^^\nZork cannot be resolved to a type\n----------\n4. WARNING in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number>) o;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Zork<?,? extends Number>\n----------\n5. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number>) o;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nZork<capture#3-of ?,capture#4-of ? extends Number> cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number>) o;\n\t            ^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Object o) {\n\t\tZork<?,?> z = (Zork<?, ? extends Number>) o;\n\t\tString s = (Zork<?, ? extends Number>) o;\n\t}\n}\n"}, expected);
    }

    public void test076() {
        String expected = this.complianceLevel <= 0x300000L ? "----------\n1. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number>) o;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number>) o;\n\t     ^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n3. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number>) o;\n\t               ^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number>) o;\n\t                    ^^^^^^^^^^^^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n5. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? super Number>) o;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? super Number>) o;\n\t            ^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? super Number>) o;\n\t                 ^^^^^^^^^^^^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number>) o;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number>) o;\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Zork<?,? super Number>\n----------\n3. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number>) o;\n\t               ^^^^\nZork cannot be resolved to a type\n----------\n4. WARNING in X.java (at line 4)\n\tString s = (Zork<?, ? super Number>) o;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Zork<?,? super Number>\n----------\n5. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? super Number>) o;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^\nZork<capture#3-of ?,capture#4-of ? super Number> cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? super Number>) o;\n\t            ^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Object o) {\n\t\tZork<?,?> z = (Zork<?, ? super Number>) o;\n\t\tString s = (Zork<?, ? super Number>) o;\n\t}\n}\n"}, expected);
    }

    public void test077() {
        String expected = this.complianceLevel <= 0x300000L ? "----------\n1. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number[]>) o;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number[]>) o;\n\t     ^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n3. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number[]>) o;\n\t               ^^^^\nZork cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number[]>) o;\n\t                    ^^^^^^^^^^^^^^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n5. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number[]>) o;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nZork cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number[]>) o;\n\t            ^^^^\nZork cannot be resolved to a type\n----------\n7. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number[]>) o;\n\t                 ^^^^^^^^^^^^^^^^^^^^^\nSyntax error, parameterized types are only available if source level is 1.5 or greater\n----------\n" : "----------\n1. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number[]>) o;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2. WARNING in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number[]>) o;\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Zork<?,? super Number[]>\n----------\n3. ERROR in X.java (at line 3)\n\tZork<?,?> z = (Zork<?, ? super Number[]>) o;\n\t               ^^^^\nZork cannot be resolved to a type\n----------\n4. WARNING in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number[]>) o;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType safety: Unchecked cast from Object to Zork<?,? extends Number[]>\n----------\n5. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number[]>) o;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nZork<capture#3-of ?,capture#4-of ? extends Number[]> cannot be resolved to a type\n----------\n6. ERROR in X.java (at line 4)\n\tString s = (Zork<?, ? extends Number[]>) o;\n\t            ^^^^\nZork cannot be resolved to a type\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(Object o) {\n\t\tZork<?,?> z = (Zork<?, ? super Number[]>) o;\n\t\tString s = (Zork<?, ? extends Number[]>) o;\n\t}\n}\n"}, expected);
    }

    public void test078() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface B {\n  B m(String seq);\n}\npublic class X implements B {\n\tpublic Zork m(String arg0) {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic Zork m(String arg0) {\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test079() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic Zork m(X x) {\n\t\treturn x;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic Zork m(X x) {\n\t       ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test080() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface B {\n  void m() throws Exception;\n}\npublic class X implements B {\n\tpublic void m() throws IOException {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tpublic void m() throws IOException {\n\t                       ^^^^^^^^^^^\nIOException cannot be resolved to a type\n----------\n");
    }

    public void test081() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
        this.runNegativeTest(new String[]{"com/ost/util/report/Matrix.java", "package com.ost.util.report;\nimport java.io.Serializable;\nimport com.ost.util.report.exceptions.InvalidRowSizeException;\npublic class Matrix<T> implements Serializable {\n\t/**\n\t * @see exceptions.InvalidRowSizeException2\n\t */\n\tpublic synchronized final void addRow(Object[] row){\n\t\t\tthrow new InvalidRowSizeException();\n\t}\n}\n", "com/ost/util/report/FilterConstraintSpecification.java", "package com.ost.util.report;\nimport java.io.Serializable;\nimport com.ost.util.report.exceptions.MalformedFilterConstraintSpecification;\npublic final class FilterConstraintSpecification implements Serializable, Cloneable {\n\tprivate final void makeConstraint(){\n\t\tthrow new MalformedFilterConstraintSpecification();\n\t}\n}\n", "com/ost/util/report/exceptions/MalformedFilterConstraintSpecification.java", "package com.ost.util.report.exceptions;\npublic class MalformedFilterConstraintSpecification extends RuntimeException {\n\t/** Creates a new instance of MalformedFilterConstraintSpecification */\n\tpublic MalformedFilterConstraintSpecification() {\n\t\tsuper();\n\t}\n\t/* Creates a new instance of MalformedFilterConstraintSpecification */\n\tpublic MalformedFilterConstraintSpecification(String message) {\n\t\tsuper(message);\n\t}\n}\n", "com/ost/util/report/exceptions/InvalidRowSizeException.java", "package com.ost.util.report.exceptions;\npublic class InvalidRowSizeException extends RuntimeException {\n\t/** Creates a new instance of InvalidRowSizeException */\n\tpublic InvalidRowSizeException() {\n\t\tsuper();\n\t}\n\t/* Creates a new instance of InvalidRowSizeException */\n\tpublic InvalidRowSizeException(String message) {\n\t\tsuper(message);\n\t}\n}\n"}, "----------\n1. WARNING in com\\ost\\util\\report\\Matrix.java (at line 4)\n\tpublic class Matrix<T> implements Serializable {\n\t             ^^^^^^\nThe serializable class Matrix does not declare a static final serialVersionUID field of type long\n----------\n2. ERROR in com\\ost\\util\\report\\Matrix.java (at line 6)\n\t* @see exceptions.InvalidRowSizeException2\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nJavadoc: exceptions cannot be resolved to a type\n----------\n----------\n1. WARNING in com\\ost\\util\\report\\FilterConstraintSpecification.java (at line 4)\n\tpublic final class FilterConstraintSpecification implements Serializable, Cloneable {\n\t                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe serializable class FilterConstraintSpecification does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in com\\ost\\util\\report\\FilterConstraintSpecification.java (at line 5)\n\tprivate final void makeConstraint(){\n\t                   ^^^^^^^^^^^^^^^^\nThe method makeConstraint() from the type FilterConstraintSpecification is never used locally\n----------\n----------\n1. WARNING in com\\ost\\util\\report\\exceptions\\MalformedFilterConstraintSpecification.java (at line 2)\n\tpublic class MalformedFilterConstraintSpecification extends RuntimeException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe serializable class MalformedFilterConstraintSpecification does not declare a static final serialVersionUID field of type long\n----------\n----------\n1. WARNING in com\\ost\\util\\report\\exceptions\\InvalidRowSizeException.java (at line 2)\n\tpublic class InvalidRowSizeException extends RuntimeException {\n\t             ^^^^^^^^^^^^^^^^^^^^^^^\nThe serializable class InvalidRowSizeException does not declare a static final serialVersionUID field of type long\n----------\n", null, false, customOptions);
    }

    public void test082() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runConformTest(new String[]{"com/ost/util/report/Matrix.java", "package com.ost.util.report;\nimport java.io.Serializable;\nimport com.ost.util.report.exceptions.InvalidRowSizeException;\npublic class Matrix<T> implements Serializable {\n\t/**\n\t * @see exceptions.InvalidRowSizeException2\n\t */\n\tpublic synchronized final void addRow(Object[] row){\n\t\t\tthrow new InvalidRowSizeException();\n\t}\n}\n", "com/ost/util/report/FilterConstraintSpecification.java", "package com.ost.util.report;\nimport java.io.Serializable;\nimport com.ost.util.report.exceptions.MalformedFilterConstraintSpecification;\npublic final class FilterConstraintSpecification implements Serializable, Cloneable {\n\tprivate final void makeConstraint(){\n\t\tthrow new MalformedFilterConstraintSpecification();\n\t}\n}\n", "com/ost/util/report/exceptions/MalformedFilterConstraintSpecification.java", "package com.ost.util.report.exceptions;\npublic class MalformedFilterConstraintSpecification extends RuntimeException {\n\t/** Creates a new instance of MalformedFilterConstraintSpecification */\n\tpublic MalformedFilterConstraintSpecification() {\n\t\tsuper();\n\t}\n\t/* Creates a new instance of MalformedFilterConstraintSpecification */\n\tpublic MalformedFilterConstraintSpecification(String message) {\n\t\tsuper(message);\n\t}\n}\n", "com/ost/util/report/exceptions/InvalidRowSizeException.java", "package com.ost.util.report.exceptions;\npublic class InvalidRowSizeException extends RuntimeException {\n\t/** Creates a new instance of InvalidRowSizeException */\n\tpublic InvalidRowSizeException() {\n\t\tsuper();\n\t}\n\t/* Creates a new instance of InvalidRowSizeException */\n\tpublic InvalidRowSizeException(String message) {\n\t\tsuper(message);\n\t}\n}\n"}, "");
    }

    public void test083() {
        this.runConformTest(new String[]{"foo/X.java", "package foo;\nimport foo.exceptions.*;\npublic class X {\n  class exceptions {}\n  exceptions E;\n}\n", "foo/exceptions/Z.java", "package foo.exceptions;\npublic class Z {\n}\n"}, "");
    }

    public void test084() {
        this.runNegativeTest(new String[]{"foo/X.java", "package foo;\nimport foo.exceptions.*;\npublic class X {\n  exceptions E;\n}\nclass exceptions {}\n", "foo/exceptions/Z.java", "package foo.exceptions;\npublic class Z {\n}\n"}, "----------\n1. WARNING in foo\\X.java (at line 2)\n\timport foo.exceptions.*;\n\t       ^^^^^^^^^^^^^^\nThe import foo.exceptions is never used\n----------\n----------\n1. ERROR in foo\\exceptions\\Z.java (at line 1)\n\tpackage foo.exceptions;\n\t        ^^^^^^^^^^^^^^\nThe package foo.exceptions collides with a type\n----------\n");
    }

    public void test085() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X extends zork.Z {\n}\n", "p/Y.java", "package p;\nimport p.zork.Z;\npublic class Y {\n}\n", "p/zork/Z.java", "package p.zork;\npublic class Z {\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\tpublic class X extends zork.Z {\n\t                       ^^^^\nzork cannot be resolved to a type\n----------\n----------\n1. WARNING in p\\Y.java (at line 2)\n\timport p.zork.Z;\n\t       ^^^^^^^^\nThe import p.zork.Z is never used\n----------\n");
    }

    public void test086() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X extends zork.Z {\n}\n", "p/Y.java", "package p;\nimport p.zork.*;\npublic class Y {\n}\n", "p/zork/Z.java", "package p.zork;\npublic class Z {\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\tpublic class X extends zork.Z {\n\t                       ^^^^\nzork cannot be resolved to a type\n----------\n----------\n1. WARNING in p\\Y.java (at line 2)\n\timport p.zork.*;\n\t       ^^^^^^\nThe import p.zork is never used\n----------\n");
    }

    public void test087() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X extends zork.Z {\n}\n", "p/Y.java", "package p;\nimport static p.zork.Z.M;\npublic class Y {\n}\n", "p/zork/Z.java", "package p.zork;\npublic class Z {\n\tpublic static class M {}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\tpublic class X extends zork.Z {\n\t                       ^^^^\nzork cannot be resolved to a type\n----------\n----------\n1. WARNING in p\\Y.java (at line 2)\n\timport static p.zork.Z.M;\n\t              ^^^^^^^^^^\nThe import p.zork.Z.M is never used\n----------\n");
    }

    public void test088() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X extends zork.Z {\n}\n", "p/Y.java", "package p;\nimport static p.zork.Z.*;\npublic class Y {\n}\n", "p/zork/Z.java", "package p.zork;\npublic class Z {\n\tstatic class M {}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 2)\n\tpublic class X extends zork.Z {\n\t                       ^^^^\nzork cannot be resolved to a type\n----------\n----------\n1. WARNING in p\\Y.java (at line 2)\n\timport static p.zork.Z.*;\n\t              ^^^^^^^^\nThe import p.zork.Z is never used\n----------\n");
    }

    public void test089() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        this.runConformTest(new String[]{"com/foo/bar/baz/reporting/dom/ReportExceptionBase.java", "package com.foo.bar.baz.reporting.dom;\npublic class ReportExceptionBase extends Exception  {\n}\n", "com/foo/bar/baz/reporting/Report.java", "package com.foo.bar.baz.reporting;\nimport com.foo.bar.baz.reporting.dom.ReportExceptionBase;\n/**\n * {@link dom.ReportDefs.ReportType.foo foo}\n */\npublic abstract class Report {\n}\n", "com/foo/bar/baz/reporting/Derived.java", "package com.foo.bar.baz.reporting;\nimport com.foo.bar.baz.reporting.dom.ReportExceptionBase;\npublic class Derived {\n  public Derived() throws ReportExceptionBase {\n    throw new ReportExceptionBase();\n  }\n}\n"}, "", null, true, null, options, null);
    }

    public void test090() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n<U,V extends Runnable> void foo(Zork z) {}\t\n\tvoid bar() {\n\t\tfoo(null);\n\t} \n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t<U,V extends Runnable> void foo(Zork z) {}\t\n\t                                ^^^^\nZork cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 4)\n\tfoo(null);\n\t^^^\nThe method foo(Zork) from the type X refers to the missing type Zork\n----------\n");
    }

    public void test091() throws Exception {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"TypeUtils.java", "import java.util.Collection;\nimport java.util.Iterator;\n\npublic final class TypeUtils {\n\n\t// personal\n\n\tprivate TypeUtils() {\n\t}\n\n\t// class\n\n\t/**\n\t * Returns true if a target type is exactly any one in a group of types.\n\t * @param target Target type. Never null.\n\t * @param types Group of types. If empty, returns false. Never null.\n\t * @return True if the target is a valid type.\n\t */\n\tpublic static boolean isIdenticalToAny(Class<?> target, Collection<Class<?>> types) {\n\t\tif (target == null) throw new IllegalArgumentException(\n\t\t\"Target is null.\");\n\n\t\tif (types.contains(target)) return true;\n\t\treturn false;\n\t}\n\n\t/**\n\t * Returns true if a target type is the same or a subtype of (assignable to)\n\t * a reference type. Convenience method for completeness. Forwards to\n\t * Class.isAssignableFrom().\n\t * @param target Target type. Never null.\n\t * @param type Reference type. Never null.\n\t * @return True if condition is met.\n\t */\n\tpublic static boolean isAssignableTo(Class<?> target, Class<?> type) {\n\t\treturn type.isAssignableFrom(target);\n\t}\n\n\t/**\n\t * Returns true if a target type is the same or a subtype of (assignable to)\n\t * any one reference type.\n\t * @param target Target type. Never null.\n\t * @param types Reference types (Class). Never null. If empty returns false.\n\t * @return True if condition is met.\n\t */\n\tpublic static boolean isAssignableToAny(Class<?> target,\n\tCollection<Class<?>> types) {\n\t\tif (types.isEmpty()) return false;\n\n\t\tfor(Class<?> type : types) {\n\t\t\tif (type.isAssignableFrom(target)) return true;\n\t\t}\n\t\treturn false;\n\t}\n\n\t/**\n\t * Returns true if any one target type is the same or a subtype of\n\t * (assignable to) a reference type.\n\t * @param targets Target types (Class). Never null. If empty returns false.\n\t * @param type Reference type. Never null.\n\t * @return True if condition is met.\n\t */\n\tpublic static boolean areAnyAssignableTo(Collection<Class<?>> targets,\n\tClass<?> type) {\n\t\tif (targets.isEmpty()) return false;\n\n\t\tfor(Class<?> target : targets) {\n\t\t\tif (type.isAssignableFrom(target)) return true;\n\t\t}\n\t\treturn false;\n\t}\n\n\t/**\n\t * Returns true if any one target type is the same or a subtype of\n\t * (assignable to) any one reference type.\n\t * @param targets Target types (Class). Never null. If empty returns false.\n\t * @param types Reference types (Class). Never null. If empty returns false.\n\t * @return True if condition is met.\n\t */\n\tpublic static boolean areAnyAssignableToAny(Collection<Class<?>> targets,\n\tCollection<Class<?>> types) {\n\t\tif (targets.isEmpty()) return false;\n\t\tif (types.isEmpty()) return false;\n\n\t\tfor(Class<?> target : targets) {\n\t\t\tif (isAssignableToAny(target, types)) return true;\n\t\t}\n\t\treturn false;\n\t}\n\n\t/**\n\t * Returns true if a target object's type is the same or a subtype of\n\t * (assignable to) a reference type. Convenience method for completeness.\n\t * Forwards to Class.isInstance().\n\t * @param target Target object. Never null.\n\t * @param type Reference type. Never null.\n\t * @return True if condition is met.\n\t */\n\tpublic static boolean isInstanceOf(Object target, Class<?> type) {\n\t\treturn type.isInstance(target);\n\t}\n\n\t/**\n\t * Returns true if a target object's type is the same or a subtype of\n\t * (assignable to) any one type.\n\t * @param target Target object. Never null.\n\t * @param types Reference types. Never null. If empty returns false.\n\t * @return True if condition is met.\n\t */\n\tpublic static boolean isInstanceOfAny(Object target,\n\tCollection<Class<?>> types) {\n\t\tif (types.isEmpty()) return false;\n\n\t\tfor (Class<?> type : types) {\n\t\t\tif (type.isInstance(target)) return true;\n\t\t}\n\t\treturn false;\n\t}\n\n\t/**\n\t * Returns true if any one target object's type is the same or a subtype of\n\t * (assignable to) a reference type.\n\t * @param targets Target objects. Never null. If empty returns false.\n\t * @param type Reference type. Never null.\n\t * @return True if condition is met.\n\t */\n\tpublic static boolean areAnyInstanceOf(Collection<Object> targets,\n\tClass<?> type) {\n\t\tif (targets.isEmpty()) return false;\n\n\t\tfor(Object target : targets) {\n\t\t\tif (type.isInstance(target)) return true;\n\t\t}\n\t\treturn false;\n\t}\n\n\t/**\n\t * Returns true if all target object types are the same or a subtype of\n\t * (assignable to) a reference type.\n\t * @param targets Target objects. Never null. If empty returns\n\t * false.\n\t * @param type Reference type. Never null.\n\t * @return True if condition is met.\n\t */\n\tpublic static boolean areAllInstanceOf(Collection<Object> targets,\n\tClass<?> type) {\n\t\tif (targets.isEmpty()) return false;\n\n\t\tfor(Object target : targets) {\n\t\t\tif (!type.isInstance(target)) return false;\n\t\t}\n\t\treturn true;\n\t}\n\n\t/**\n\t * Returns true if no target object types are the same or a subtype of\n\t * (assignable to) a reference type.\n\t * @param targets Target objects. Never null. If empty returns\n\t * false.\n\t * @param type Reference type. Never null.\n\t * @return True if condition is met.\n\t */\n\tpublic static boolean areNoneInstanceOf(Collection<Object> targets,\n\tClass<?> type) {\n\t\tif (targets.isEmpty()) return false;\n\n\t\tfor(Object target : targets) {\n\t\t\tif (type.isInstance(target)) return false;\n\t\t}\n\t\treturn true;\n\t}\n\n\t/**\n\t * Returns true if any one target object's type is the same or a subtype of\n\t * (assignable to) any one reference type.\n\t * @param targets Target objects. Never null. If empty returns\n\t * false.\n\t * @param types Reference types. Never null. If empty returns false.\n\t * @return True if condition is met.\n\t */\n\tpublic static boolean areAnyInstanceOfAny(Collection<Object> targets,\n\tCollection<Class<?>> types) {\n\t\tif (targets.isEmpty()) return false;\n\t\tif (types.isEmpty()) return false;\n\n\t\tfor(Object target : targets) {\n\t\t\tif (isInstanceOfAny(target, types)) return true;\n\t\t}\n\t\treturn false;\n\t}\n\n\t/**\n\t * Returns only those target objects whose type is identical to the included\n\t * reference type.\n\t * @param targets Group of target objects. If empty, returns empty. Never\n\t * null.\n\t * @param type Included reference type. Never null.\n\t * @param retVal Return value object. The collection of valid target\n\t * objects. Can be {@code targets}. Never null.\n\t * @return Reference to retVal. Never null.\n\t */\n\tpublic static Collection<Object> includeIdenticalTo(Collection<Object> targets,\n\tClass<?> type, Collection<Object> retVal) {\n\t\t// save targets in retVal\n\t\tif (targets != retVal) {\n\t\t\tretVal.clear();\n\t\t\tretVal.addAll(targets);\n\t\t}\n\n\t\t// remove unwanted targets, by target\n\t\tIterator<?> objectI = retVal.iterator();\n\t\twhile (objectI.hasNext()) {\n\t\t\tObject object = objectI.next();\n\t\t\tif (!type.equals(object.getClass())) objectI.remove();\n\t\t}\n\n\t\treturn retVal;\n\t}\n\n\t/**\n\t * Returns only those target objects whose type is exactly one of the\n\t * included reference types.\n\t * @param targets Group of target objects. If empty, returns empty. Never\n\t * null.\n\t * @param types Group of included reference types. If empty, returns empty.\n\t * If null, all types are included (all targets are returned).\n\t * @param retVal Return value object. The collection of valid target\n\t * objects. Can be {@code targets}. Never null.\n\t * @return Reference to retVal. Never null.\n\t */\n\tpublic static Collection<Object> includeIdenticalToAny(\n\tCollection<Object> targets,\n\tCollection<Class<?>> types, Collection<Object> retVal) {\n\t\t// save targets in retVal\n\t\tif (targets != retVal) {\n\t\t\tretVal.clear();\n\t\t\tretVal.addAll(targets);\n\t\t}\n\n\t\tif (types == null) return retVal;\n\n\t\t// remove unwanted targets, by target\n\t\tIterator<Object> objectI = retVal.iterator();\n\t\twhile (objectI.hasNext()) {\n\t\t\tObject object = objectI.next();\n\t\t\tif (!isIdenticalToAny(object.getClass(), types)) objectI.remove();\n\t\t}\n\n\t\treturn retVal;\n\t}\n\n\t/**\n\t * Returns only those target objects whose type is NOT identical to the\n\t * excluded reference type.\n\t * @param targets Group of target objects. If empty, returns empty. Never\n\t * null.\n\t * @param type The excluded reference type. Never null.\n\t * @param retVal Return value object. The collection of valid target\n\t * objects. Can be {@code targets}. Never null.\n\t * @return Reference to retVal. Never null.\n\t */\n\tpublic static Collection<Object> excludeIdenticalTo(\n\tCollection<Object> targets, Class<?> type,\n\tCollection<Object> retVal) {\n\t\t// save targets in retVal\n\t\tif (targets != retVal) {\n\t\t\tretVal.clear();\n\t\t\tretVal.addAll(targets);\n\t\t}\n\n\t\t// remove unwanted targets, by target\n\t\tIterator<Object> objectI = retVal.iterator();\n\t\twhile (objectI.hasNext()) {\n\t\t\tObject object = objectI.next();\n\t\t\tif (type.equals(object.getClass())) objectI.remove();\n\t\t}\n\n\t\treturn retVal;\n\t}\n\n\t/**\n\t * Returns only those target objects whose type is NOT exactly one of the\n\t * excluded reference types.\n\t * @param targets Group of target objects. If empty, returns empty. Never\n\t * null.\n\t * @param types Group of excluded reference types. If empty, returns empty.\n\t * If null, no types are excluded (all targets are returned).\n\t * @param retVal Return value object. The collection of valid target\n\t * objects. Can be targets. Never null.\n\t * @return Reference to retVal. Never null.\n\t */\n\tpublic static Collection<Object> excludeIdenticalToAny(\n\tCollection<Object> targets, Collection<Class<?>> types,\n\tCollection<Object> retVal) {\n\t\t// save targets in retVal\n\t\tif (targets != retVal) {\n\t\t\tretVal.clear();\n\t\t\tretVal.addAll(targets);\n\t\t}\n\n\t\tif (types == null) return retVal;\n\n\t\t// remove unwanted targets, by target\n\t\tIterator<Object> objectI = retVal.iterator();\n\t\twhile (objectI.hasNext()) {\n\t\t\tObject object = objectI.next();\n\t\t\tif (isIdenticalToAny(object.getClass(), types)) objectI.remove();\n\t\t}\n\n\t\treturn retVal;\n\t}\n\n\t/**\n\t * Returns only those target objects whose type is assignable to (an\n\t * instance of) the included reference type.\n\t * @param targets Group of target objects. If empty, returns empty. Never\n\t * null.\n\t * @param type Included reference type. Never null.\n\t * @param retVal Return value object. The collection of valid target objects\n\t * (Object). Can be targets. Never null.\n\t * @return Reference to retVal. Never null.\n\t */\n\tpublic static Collection<Object> includeAssignableTo(\n\tCollection<Object> targets, Class<?> type, Collection<Object> retVal) {\n\t\t// save targets in retVal\n\t\tif (targets != retVal) {\n\t\t\tretVal.clear();\n\t\t\tretVal.addAll(targets);\n\t\t}\n\n\t\t// remove unwanted targets, by target\n\t\tIterator<Object> objectI = retVal.iterator();\n\t\twhile (objectI.hasNext()) {\n\t\t\tObject object = objectI.next();\n\t\t\tif (!type.isInstance(object)) objectI.remove();\n\t\t}\n\n\t\treturn retVal;\n\t}\n\n\t/**\n\t * Returns only those target objects whose type is assignable to (an\n\t * instance of) any one of the included reference types.\n\t * @param targets Group of target objects. If empty, returns empty. Never\n\t * null.\n\t * @param types Group of included reference types. If empty, returns empty.\n\t * If null, all types are included (all targets are returned).\n\t * @param retVal Return value object. The collection of valid target\n\t * objects. Can be targets. Never null.\n\t * @return Reference to retVal. Never null.\n\t */\n\tpublic static Collection<Object> includeAssignableToAny(\n\tCollection<Object> targets, Collection<Class<?>> types,\n\tCollection<Object> retVal) {\n\t\t// save targets in retVal\n\t\tif (targets != retVal) {\n\t\t\tretVal.clear();\n\t\t\tretVal.addAll(targets);\n\t\t}\n\n\t\tif (types == null) return retVal;\n\n\t\t// remove unwanted targets, by target\n\t\tIterator<Object> objectI = retVal.iterator();\n\t\twhile (objectI.hasNext()) {\n\t\t\tObject object = objectI.next();\n\t\t\tif (!isInstanceOfAny(object, types)) objectI.remove();\n\t\t}\n\n\t\treturn retVal;\n\t}\n\n\t/**\n\t * Returns only those target objects whose type is NOT assignable to (an\n\t * instance of) the excluded reference type.\n\t * @param targets Group of target objects. If empty, returns empty. Never\n\t * null.\n\t * @param type The excluded reference type. Never null.\n\t * @param retVal Return value object. The collection of valid target\n\t * objects. Never null.\n\t * @return Reference to retVal. Never null.\n\t */\n\tpublic static Collection<Object> excludeAssignableTo(\n\tCollection<Object> targets, Class<?> type, Collection<Object> retVal) {\n\t\t// save targets in retVal\n\t\tif (targets != retVal) {\n\t\t\tretVal.clear();\n\t\t\tretVal.addAll(targets);\n\t\t}\n\n\t\t// remove unwanted targets, by target\n\t\tIterator<Object> objectI = retVal.iterator();\n\t\twhile (objectI.hasNext()) {\n\t\t\tObject object = objectI.next();\n\t\t\tif (type.isInstance(object)) objectI.remove();\n\t\t}\n\n\t\treturn retVal;\n\t}\n\n\t/**\n\t * Returns only those target objects whose type is NOT assignable to (an\n\t * instance of) any one of the excluded reference types.\n\t * @param targets Group of target objects. If empty, returns empty. Never\n\t * null.\n\t * @param types Group of excluded reference types. If empty, returns empty.\n\t * If null, no types are excluded (all targets are returned).\n\t * @param retVal Return value object. The collection of valid target\n\t * objects. Never null.\n\t * @return Reference to retVal. Never null.\n\t */\n\tpublic static Collection<Object> excludeAssignableToAny(\n\tCollection<Object> targets, Collection<Class<?>> types,\n\tCollection<Object> retVal) {\n\t\t// save targets in retVal\n\t\tif (targets != retVal) {\n\t\t\tretVal.clear();\n\t\t\tretVal.addAll(targets);\n\t\t}\n\n\t\tif (types == null) return retVal;\n\n\t\t// remove unwanted targets, by target\n\t\tIterator<Object> objectI = retVal.iterator();\n\t\twhile (objectI.hasNext()) {\n\t\t\tObject object = objectI.next();\n\t\t\tif (isInstanceOfAny(object, types)) objectI.remove();\n\t\t}\n\n\t\treturn retVal;\n\t}\n\n\t/**\n\t * Returns the first target object whose type is assignable to (an instance\n\t * of) the reference type.\n\t * @param targets Group of target objects. If empty, returns null.\n\t * Never null.\n\t * @param type Reference type. Never null.\n\t * @return The result (Object, assignable instance of type). Null if none.\n\t */\n\tpublic static <T extends Class<?>> T getFirstAssignableTo(\n\tCollection<Object> targets, T type) {\n\t\tfor(Object target : targets) {\n\t\t\tif (type.isInstance(target)) return target;\n\t\t}\n\n\t\treturn null;\n\t}\n\n\t/**\n\t * Returns the first target object whose type is exactly the specified type.\n\t * @param targets Group of target objects (Object). If empty, returns null.\n\t * Never null.\n\t * @param type The type. Never null. objects (Object). Can be targets. Never\n\t * null.\n\t * @return The result (Object, exact instance of type). Null if none.\n\t */\n\tpublic static Object getFirstIdenticalTo(Collection targets, Class type) {\n\t\tIterator targetI = targets.iterator();\n\t\twhile (targetI.hasNext()) {\n\t\t\tObject target = targetI.next();\n\t\t\tif (type.equals(target.getClass())) return target;\n\t\t}\n\n\t\treturn null;\n\t}\n\n\t/**\n\t * Gets a target object T from a source object S in a group of objects, and\n\t * returns the target objects in result group R. A group object is ignored\n\t * if it is not a source type or, if it is a source type, its target object\n\t * is not a target type.\n\t * @param group Temp input group of shared exposed objects. If null, returns\n\t * empty.\n\t * @param sourceType Desired source object type. Never null.\n\t * @param getter Gets a target object from a source object. Never null.\n\t * @param targetType Desired target object type. Never null.\n\t * @param retVal Temp output group of shared exposed target objects. Never\n\t * null.\n\t * @return Reference to retVal. Never null.\n\t */\n\tpublic static <S,T,TT extends T,R extends Collection<? super TT>> R getAll(\n\tCollection<?> group, Class<? extends S> sourceType, Getter<S,T> getter,\n\tClass<TT> targetType, R retVal) {\n\t\tif (sourceType == null) throw new IllegalArgumentException(\n\t\t\"Source type is null.\");\n\t\tif (getter == null) throw new IllegalArgumentException(\n\t\t\"Getter is null.\");\n\t\tif (targetType == null) throw new IllegalArgumentException(\n\t\t\"Target type is null.\");\n\t\tif (retVal == null) throw new IllegalArgumentException(\n\t\t\"Return value is null.\");\n\t\tretVal.clear();\n\n\t\tif (group == null) return retVal;\n\n\t\tfor (Object obj : group) {\n\t\t\tif (!sourceType.isInstance(obj)) continue; // ignore\n\t\t\tS source = (S) obj;\n\t\t\tT target = getter.getFrom(source);\n\t\t\tif (!targetType.isInstance(target)) continue; // ignore\n\t\t\tretVal.add((TT) target);\n\t\t}\n\n\t\treturn retVal;\n\t}\n\n\t/**\n\t * Similar to getAll(Collection, Class, Getter, Class, Collection), but all\n\t * target objects are returned, regardless of type, including nulls.\n\t * @param group Temp input group of shared exposed objects. If null, returns\n\t * empty.\n\t * @param sourceType Desired source object type. Never null.\n\t * @param getter Gets a target object from a source object. Never null.\n\t * @param retVal Temp output group of shared exposed target objects. Never\n\t * null.\n\t * @return Reference to retVal. Never null.\n\t */\n\tpublic static <S,T,R extends Collection<? super T>> R getAll(\n\tCollection<?> group, Class<? extends S> sourceType, Getter<S,T> getter,\n\tR retVal) {\n\t\tif (sourceType == null) throw new IllegalArgumentException(\n\t\t\"Source type is null.\");\n\t\tif (getter == null) throw new IllegalArgumentException(\n\t\t\"Getter is null.\");\n\t\tif (retVal == null) throw new IllegalArgumentException(\n\t\t\"Return value is null.\");\n\t\tretVal.clear();\n\n\t\tif (group == null) return retVal;\n\n\t\tfor (Object obj : group) {\n\t\t\tif (!sourceType.isInstance(obj)) continue; // ignore\n\t\t\tS source = (S) obj;\n\t\t\tT target = getter.getFrom(source);\n\t\t\tretVal.add(target);\n\t\t}\n\n\t\treturn retVal;\n\t}\n}\n"}, "----------\n1. WARNING in TypeUtils.java (at line 441)\n\tpublic static <T extends Class<?>> T getFirstAssignableTo(\n\t                         ^^^^^\nThe type parameter T should not be bounded by the final type Class<?>. Final types cannot be further extended\n----------\n2. ERROR in TypeUtils.java (at line 444)\n\tif (type.isInstance(target)) return target;\n\t                                    ^^^^^^\nType mismatch: cannot convert from Object to T\n----------\n3. WARNING in TypeUtils.java (at line 458)\n\tpublic static Object getFirstIdenticalTo(Collection targets, Class type) {\n\t                                         ^^^^^^^^^^\nCollection is a raw type. References to generic type Collection<E> should be parameterized\n----------\n4. WARNING in TypeUtils.java (at line 458)\n\tpublic static Object getFirstIdenticalTo(Collection targets, Class type) {\n\t                                                             ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n5. WARNING in TypeUtils.java (at line 459)\n\tIterator targetI = targets.iterator();\n\t^^^^^^^^\nIterator is a raw type. References to generic type Iterator<E> should be parameterized\n----------\n6. ERROR in TypeUtils.java (at line 483)\n\tCollection<?> group, Class<? extends S> sourceType, Getter<S,T> getter,\n\t                                                    ^^^^^^\nGetter cannot be resolved to a type\n----------\n7. WARNING in TypeUtils.java (at line 499)\n\tS source = (S) obj;\n\t           ^^^^^^^\nType safety: Unchecked cast from Object to S\n----------\n8. WARNING in TypeUtils.java (at line 502)\n\tretVal.add((TT) target);\n\t           ^^^^^^^^^^^\nType safety: Unchecked cast from T to TT\n----------\n9. ERROR in TypeUtils.java (at line 520)\n\tCollection<?> group, Class<? extends S> sourceType, Getter<S,T> getter,\n\t                                                    ^^^^^^\nGetter cannot be resolved to a type\n----------\n10. WARNING in TypeUtils.java (at line 534)\n\tS source = (S) obj;\n\t           ^^^^^^^\nType safety: Unchecked cast from Object to S\n----------\n");
    }

    public void test092() {
        this.runNegativeTest(new String[]{"p1/p2/X.java", "package p1.p2;\npublic class X {\n\tpublic p2.p3.Z z() {return null;}\n}\n"}, "----------\n1. ERROR in p1\\p2\\X.java (at line 3)\n\tpublic p2.p3.Z z() {return null;}\n\t       ^^\np2 cannot be resolved to a type\n----------\n", null, false, null, true, false, false);
        this.runConformTest(new String[]{"a/b/A.java", "package a.b;\npublic class A {\n\tp1.p2.X x;\n\tvoid test() { x.z(); }\n\tvoid foo(p2.p3.Z z) {}\n}\n", "p2/p3/Z.java", "package p2.p3;\npublic class Z {}\n"}, "", null, false, null);
        this.runConformTest(new String[]{"a/b/A.java", "package a.b;\npublic class A {\n\tp1.p2.X x;\n\tvoid test() { x.z(); }\n\tvoid foo(p2.p3.Z z) {}\n}\n"}, "", null, false, null);
    }

    public void test093() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tvoid foo() {\n\t\tList<? extends Zork> zlist = null;\n\t\tbar(zlist.get(0));\n\t}\n\t<T> T bar(T t) { return t; }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tList<? extends Zork> zlist = null;\n\t               ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test094() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tvoid foo(boolean b, Runnable r) {\n\t\tbar(r);\n\t}\n\t<T> T bar(Zork z) { return z; }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tbar(r);\n\t^^^\nThe method bar(Zork) from the type X refers to the missing type Zork\n----------\n2. ERROR in X.java (at line 7)\n\t<T> T bar(Zork z) { return z; }\n\t          ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test095() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\n\npublic class X {\n\tvoid foo(boolean b, Runnable r) {\n\t\tbar(r);\n\t}\n\t<T> bar(Zork z) { return z; }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tbar(r);\n\t^^^\nThe method bar(Runnable) is undefined for the type X\n----------\n2. ERROR in X.java (at line 7)\n\t<T> bar(Zork z) { return z; }\n\t    ^^^^^^^^^^^\nReturn type for the method is missing\n----------\n3. ERROR in X.java (at line 7)\n\t<T> bar(Zork z) { return z; }\n\t        ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test096() {
        this.runNegativeTest(new String[]{"p2/B.java", "package p2;\nimport p1.A;\npublic abstract class B {\n\tpublic static A foo() {}\n}\n", "p3/C.java", "package p3;\nimport p1.A;\npublic abstract class C extends p2.B {\n\tpublic static A foo() {}\n}\n", "p/D.java", "package p;\npublic class D extends p3.C {}"}, "----------\n1. ERROR in p2\\B.java (at line 2)\n\timport p1.A;\n\t       ^^\nThe import p1 cannot be resolved\n----------\n2. ERROR in p2\\B.java (at line 4)\n\tpublic static A foo() {}\n\t              ^\nA cannot be resolved to a type\n----------\n----------\n1. ERROR in p3\\C.java (at line 2)\n\timport p1.A;\n\t       ^^\nThe import p1 cannot be resolved\n----------\n2. ERROR in p3\\C.java (at line 4)\n\tpublic static A foo() {}\n\t              ^\nA cannot be resolved to a type\n----------\n");
    }

    public void test097() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tpublic static interface InnerInterface<TheTypeMirror, TheDeclaredType extends TheTypeMirror, TheClassType extends TheDeclaredType, TheInterfaceType extends TheDeclaredType, ThePrimitiveType extends TheTypeMirror, TheArrayType extends TheTypeMirror, TheTypeVariable extends TheTypeMirror, TheWildcardType extends TheTypeMirror, TheFieldDeclaration, TheTypeParameterDeclaration, TheTypeDeclaration, TheClassDeclaration extends TheTypeDeclaration> {\n\t}\n\tprotected <TheTypeMirror, TheDeclaredType extends TheTypeMirror, TheClassType extends TheDeclaredType, TheInterfaceType extends TheDeclaredType, ThePrimitiveType extends TheTypeMirror, TheArrayType extends TheTypeMirror, TheTypeVariable extends TheTypeMirror, TheWildcardType extends TheTypeMirror, TheFieldDeclaration, TheTypeParameterDeclaration, TheTypeDeclaration, TheClassDeclaration extends TheTypeDeclaration, Env extends InnerInterface<TheTypeMirror, TheDeclaredType, TheClassType, TheInterfaceType, ThePrimitiveType, TheArrayType, TheTypeVariable, TheWildcardType, TheFieldDeclaration, TheTypeParameterDeclaration, TheTypeDeclaration, TheClassDeclaration>, ParamType extends TheTypeMirror> void testMethod(\n\t\t\tTheFieldDeclaratation fieldDeclaratation, Env\n\t\t\tenvironment) {\n\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tTheFieldDeclaratation fieldDeclaratation, Env\n\t^^^^^^^^^^^^^^^^^^^^^\nTheFieldDeclaratation cannot be resolved to a type\n----------\n");
    }

    public void test098() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    private class A {\n    \tpublic void foo(int a) {\n   \t\tSystem.out.println(\"Hello\");\n    \t}\n\t    public void foo(float a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(boolean a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n      \tpublic void foo(Integer a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   }\n   private class B extends A {\n\t\tpublic void foo(int a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n\t\tpublic void foo(float a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(double a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(char a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo(int a) {\n\t            ^^^^^^^^^^\nThe method foo(int) from the type X.A is never used locally\n----------\n2. WARNING in X.java (at line 6)\n\tpublic void foo(float a) {\n\t            ^^^^^^^^^^^^\nThe method foo(float) from the type X.A is never used locally\n----------\n3. WARNING in X.java (at line 9)\n\tpublic void foo(boolean a) {\n\t            ^^^^^^^^^^^^^^\nThe method foo(boolean) from the type X.A is never used locally\n----------\n4. WARNING in X.java (at line 12)\n\tpublic void foo(Integer a) {\n\t            ^^^^^^^^^^^^^^\nThe method foo(Integer) from the type X.A is never used locally\n----------\n5. WARNING in X.java (at line 16)\n\tprivate class B extends A {\n\t              ^\nThe type X.B is never used locally\n----------\n6. WARNING in X.java (at line 16)\n\tprivate class B extends A {\n\t              ^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method\n----------\n7. WARNING in X.java (at line 23)\n\tpublic void foo(double a) {\n\t            ^^^^^^^^^^^^^\nThe method foo(double) from the type X.B is never used locally\n----------\n8. WARNING in X.java (at line 26)\n\tpublic void foo(char a) {\n\t            ^^^^^^^^^^^\nThe method foo(char) from the type X.B is never used locally\n----------\n");
    }

    public void test099() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    private class A {\n    \tpublic void foo(int a) {\n   \t\tSystem.out.println(\"Hello\");\n    \t}\n\t    public void foo(float a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(boolean a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n      \tpublic void foo(Integer a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   }\n   private class B extends A {\n\t\tpublic void foo(int a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n\t\tpublic void foo(float a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(double a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(char a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   }\n   public class C extends B {\n\t\tpublic void foo(int a) {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t}\n\t\tpublic void foo(double a) {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t}\n\t\tpublic void foo(boolean a) {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t}\n\t\tpublic void foo(byte a) {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t}\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo(int a) {\n\t            ^^^^^^^^^^\nThe method foo(int) from the type X.A is never used locally\n----------\n2. WARNING in X.java (at line 6)\n\tpublic void foo(float a) {\n\t            ^^^^^^^^^^^^\nThe method foo(float) from the type X.A is never used locally\n----------\n3. WARNING in X.java (at line 9)\n\tpublic void foo(boolean a) {\n\t            ^^^^^^^^^^^^^^\nThe method foo(boolean) from the type X.A is never used locally\n----------\n4. WARNING in X.java (at line 16)\n\tprivate class B extends A {\n\t              ^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method\n----------\n5. WARNING in X.java (at line 23)\n\tpublic void foo(double a) {\n\t            ^^^^^^^^^^^^^\nThe method foo(double) from the type X.B is never used locally\n----------\n6. WARNING in X.java (at line 30)\n\tpublic class C extends B {\n\t             ^\nAccess to enclosing constructor X.B() is emulated by a synthetic accessor method\n----------\n");
    }

    public void test099a() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   public class C extends B {\n\t\tpublic void foo(int a) {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t}\n\t\tpublic void foo(double a) {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t}\n\t\tpublic void foo(boolean a) {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t}\n\t\tpublic void foo(byte a) {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t}\n   }\n   private class B extends A {\n\t\tpublic void foo(int a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n\t\tpublic void foo(float a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(double a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(char a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   }\n   private class A {\n    \tpublic void foo(int a) {\n   \t\tSystem.out.println(\"Hello\");\n    \t}\n\t    public void foo(float a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(boolean a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n      \tpublic void foo(Integer a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 2)\n\tpublic class C extends B {\n\t             ^\nAccess to enclosing constructor X.B() is emulated by a synthetic accessor method\n----------\n2. WARNING in X.java (at line 16)\n\tprivate class B extends A {\n\t              ^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method\n----------\n3. WARNING in X.java (at line 23)\n\tpublic void foo(double a) {\n\t            ^^^^^^^^^^^^^\nThe method foo(double) from the type X.B is never used locally\n----------\n4. WARNING in X.java (at line 31)\n\tpublic void foo(int a) {\n\t            ^^^^^^^^^^\nThe method foo(int) from the type X.A is never used locally\n----------\n5. WARNING in X.java (at line 34)\n\tpublic void foo(float a) {\n\t            ^^^^^^^^^^^^\nThe method foo(float) from the type X.A is never used locally\n----------\n6. WARNING in X.java (at line 37)\n\tpublic void foo(boolean a) {\n\t            ^^^^^^^^^^^^^^\nThe method foo(boolean) from the type X.A is never used locally\n----------\n");
    }

    public void test099b() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    private class A {\n    \tpublic void foo(int a) {\n   \t\tSystem.out.println(\"Hello\");\n    \t}\n\t    public void foo(float a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(boolean a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n      \tpublic void foo(Integer a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   }\n   private class B extends A {\n\t\tpublic void foo(int a) {\n   \t\tsuper.foo(a);\n   \t}\n\t\tpublic void foo(float a) {\n   \t\tsuper.foo(a);\n   \t}\n   \tpublic void foo(double a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   \tpublic void foo(char a) {\n   \t\tSystem.out.println(\"Hello\");\n   \t}\n   }\n   public class C extends B {\n\t\tpublic void foo(int a) {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t}\n\t\tpublic void foo(double a) {\n\t\t\tsuper.foo(a);\n\t\t}\n\t\tpublic void foo(boolean a) {\n\t\t\tsuper.foo(a);\n\t\t}\n\t\tpublic void foo(byte a) {\n\t\t\tSystem.out.println(\"Hello\");\n\t\t}\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 16)\n\tprivate class B extends A {\n\t              ^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method\n----------\n2. WARNING in X.java (at line 30)\n\tpublic class C extends B {\n\t             ^\nAccess to enclosing constructor X.B() is emulated by a synthetic accessor method\n----------\n");
    }

    public void test100() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    private class A {\n        public void foo() {}\n    }\n    public class B extends A {}\n}"}, "----------\n1. WARNING in X.java (at line 5)\n\tpublic class B extends A {}\n\t             ^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method\n----------\n");
    }

    public void test101() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    private class A {\n        public void foo() {}\n        public void foo(int a) {}\n    }\n    public class B extends A {}\n}"}, "----------\n1. WARNING in X.java (at line 6)\n\tpublic class B extends A {}\n\t             ^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method\n----------\n");
    }

    public void test102() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    private class A {\n        private void foo() {}\n        private void foo(int a) {}\n    }\n    public class B extends A {}\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tprivate void foo() {}\n\t             ^^^^^\nThe method foo() from the type X.A is never used locally\n----------\n2. WARNING in X.java (at line 4)\n\tprivate void foo(int a) {}\n\t             ^^^^^^^^^^\nThe method foo(int) from the type X.A is never used locally\n----------\n3. WARNING in X.java (at line 6)\n\tpublic class B extends A {}\n\t             ^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method\n----------\n");
    }

    public void test103() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    private class A {\n        public void foo() {}\n        public void foo(int a) {}\n    }\n    private class B extends A {}\n}"}, "----------\n1. WARNING in X.java (at line 3)\n\tpublic void foo() {}\n\t            ^^^^^\nThe method foo() from the type X.A is never used locally\n----------\n2. WARNING in X.java (at line 4)\n\tpublic void foo(int a) {}\n\t            ^^^^^^^^^^\nThe method foo(int) from the type X.A is never used locally\n----------\n3. WARNING in X.java (at line 6)\n\tprivate class B extends A {}\n\t              ^\nThe type X.B is never used locally\n----------\n4. WARNING in X.java (at line 6)\n\tprivate class B extends A {}\n\t              ^\nAccess to enclosing constructor X.A() is emulated by a synthetic accessor method\n----------\n");
    }

    public void test104() {
        this.runNegativeTest(new String[]{"p/Bar.java", "package p;\nimport q.Zork;\npublic abstract class Bar {\n\tprotected abstract boolean isBaz();\n}\n"}, "----------\n1. ERROR in p\\Bar.java (at line 2)\n\timport q.Zork;\n\t       ^\nThe import q cannot be resolved\n----------\n", null, true, null, true, false, false, false, false);
        this.runConformTest(new String[]{"X.java", "import p.Bar;\npublic class X extends Bar {\n\tprotected boolean isBaz() {\n\t\treturn false;\n\t}\n}"}, "", null, false, null);
    }

    public void test105() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    static {\n        System.loadLibrary(\"tpbrooktrout\");\n    }\n    private final int time;\n    private int foo() { return 0;}\n    private class Inner {}\n    public X(int delay) {\n        time = delay;\n    }\n    public native void run(Inner i);\n}\n"}, "");
    }

    public void test106() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tnew Listener() {\n\t\t\t  void foo(int a) { }\n\t\t}.bar();\n       new Listener() {\n\t\t\t  void foo(int a) { }\n\t\t}.field = 10;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tnew Listener() {\n\t    ^^^^^^^^\nListener cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 6)\n\tnew Listener() {\n\t    ^^^^^^^^\nListener cannot be resolved to a type\n----------\n");
    }

    public void test107() {
        this.runNegativeTest(new String[]{"p/OuterBogus.java", "package p;\nabstract final class OuterBogus {\n\tpublic static void call() {\n\t\tSystem.out.println(\"Hi. I'm outer bogus.\");\n\t}\n}"}, "----------\n1. ERROR in p\\OuterBogus.java (at line 2)\n\tabstract final class OuterBogus {\n\t                     ^^^^^^^^^^\nThe class OuterBogus can be either abstract or final, not both\n----------\n", null, true, null, true, false, false, false, false);
        this.runConformTest(new String[]{"p/Bogus.java", "package p;\n\npublic class Bogus {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tOuterBogus.call();\n\t\t} catch(ClassFormatError e) {\n\t\t\tSystem.out.println(\"Wrong error found\");\n\t\t} catch(Error e) {\n\t\t\tSystem.out.println(\"Compilation error found\");\n\t\t}\n\t}\n}"}, "Compilation error found", null, false, null);
    }

    public void test108() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"SyntheticConstructorTooManyArgs.java", "public class SyntheticConstructorTooManyArgs {\n\n\tstatic class A {\n\t\tprivate A(\n\t\t\t/*this,*/int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p0a, int p0b, int p0c, int p0d, int p0e, int p0f, \n\t\t\tint p10, int p11, int p12, int p13, int p14, int p15, int p16, int p17, int p18, int p19, int p1a, int p1b, int p1c, int p1d, int p1e, int p1f, \n\t\t\tint p20, int p21, int p22, int p23, int p24, int p25, int p26, int p27, int p28, int p29, int p2a, int p2b, int p2c, int p2d, int p2e, int p2f, \n\t\t\tint p30, int p31, int p32, int p33, int p34, int p35, int p36, int p37, int p38, int p39, int p3a, int p3b, int p3c, int p3d, int p3e, int p3f, \n\t\t\tint p40, int p41, int p42, int p43, int p44, int p45, int p46, int p47, int p48, int p49, int p4a, int p4b, int p4c, int p4d, int p4e, int p4f, \n\t\t\tint p50, int p51, int p52, int p53, int p54, int p55, int p56, int p57, int p58, int p59, int p5a, int p5b, int p5c, int p5d, int p5e, int p5f, \n\t\t\tint p60, int p61, int p62, int p63, int p64, int p65, int p66, int p67, int p68, int p69, int p6a, int p6b, int p6c, int p6d, int p6e, int p6f, \n\t\t\tint p70, int p71, int p72, int p73, int p74, int p75, int p76, int p77, int p78, int p79, int p7a, int p7b, int p7c, int p7d, int p7e, int p7f, \n\t\t\tint p80, int p81, int p82, int p83, int p84, int p85, int p86, int p87, int p88, int p89, int p8a, int p8b, int p8c, int p8d, int p8e, int p8f, \n\t\t\tint p90, int p91, int p92, int p93, int p94, int p95, int p96, int p97, int p98, int p99, int p9a, int p9b, int p9c, int p9d, int p9e, int p9f, \n\t\t\tint pa0, int pa1, int pa2, int pa3, int pa4, int pa5, int pa6, int pa7, int pa8, int pa9, int paa, int pab, int pac, int pad, int pae, int paf, \n\t\t\tint pb0, int pb1, int pb2, int pb3, int pb4, int pb5, int pb6, int pb7, int pb8, int pb9, int pba, int pbb, int pbc, int pbd, int pbe, int pbf, \n\t\t\tint pc0, int pc1, int pc2, int pc3, int pc4, int pc5, int pc6, int pc7, int pc8, int pc9, int pca, int pcb, int pcc, int pcd, int pce, int pcf, \n\t\t\tint pd0, int pd1, int pd2, int pd3, int pd4, int pd5, int pd6, int pd7, int pd8, int pd9, int pda, int pdb, int pdc, int pdd, int pde, int pdf, \n\t\t\tint pe0, int pe1, int pe2, int pe3, int pe4, int pe5, int pe6, int pe7, int pe8, int pe9, int pea, int peb, int pec, int ped, int pee, int pef, \n\t\t\tint pf0, int pf1, int pf2, int pf3, int pf4, int pf5, int pf6, int pf7, int pf8, int pf9, int pfa, int pfb, int pfc, int pfd, int pfe\n\t\t\t) {}\n\t}\n\t@SuppressWarnings(\"synthetic-access\")\n\tA a = new A(\n\t\t  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n\t\t);\n\tpublic static void main(String[] args) {\n\t\tStringBuilder params = new StringBuilder();\n\t\tparams.append(\"/*this,*/\");\n\t\tfor (int p = 1; p < 255; p++) {\n\t\t\tif (p > 1) {\n\t\t\t\tparams.append(\", \");\n\t\t\t\tif (p % 16 == 0)\n\t\t\t\t\tparams.append('\\n');\n\t\t\t}\n\t\t\tparams.append(\"int p\"\n\t\t\t\t\t+ Character.forDigit(p / 16, 16)\n\t\t\t\t\t+ Character.forDigit(p % 16, 16)\n\t\t\t\t\t);\n\t\t}\n\t\tSystem.out.println(params);\n\t\tA.class.getName(); // ClassFormatError\n\t}\n}"}, "----------\n1. ERROR in SyntheticConstructorTooManyArgs.java (at line 4)\n\tprivate A(\n\t\t\t/*this,*/int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p0a, int p0b, int p0c, int p0d, int p0e, int p0f, \n\t\t\tint p10, int p11, int p12, int p13, int p14, int p15, int p16, int p17, int p18, int p19, int p1a, int p1b, int p1c, int p1d, int p1e, int p1f, \n\t\t\tint p20, int p21, int p22, int p23, int p24, int p25, int p26, int p27, int p28, int p29, int p2a, int p2b, int p2c, int p2d, int p2e, int p2f, \n\t\t\tint p30, int p31, int p32, int p33, int p34, int p35, int p36, int p37, int p38, int p39, int p3a, int p3b, int p3c, int p3d, int p3e, int p3f, \n\t\t\tint p40, int p41, int p42, int p43, int p44, int p45, int p46, int p47, int p48, int p49, int p4a, int p4b, int p4c, int p4d, int p4e, int p4f, \n\t\t\tint p50, int p51, int p52, int p53, int p54, int p55, int p56, int p57, int p58, int p59, int p5a, int p5b, int p5c, int p5d, int p5e, int p5f, \n\t\t\tint p60, int p61, int p62, int p63, int p64, int p65, int p66, int p67, int p68, int p69, int p6a, int p6b, int p6c, int p6d, int p6e, int p6f, \n\t\t\tint p70, int p71, int p72, int p73, int p74, int p75, int p76, int p77, int p78, int p79, int p7a, int p7b, int p7c, int p7d, int p7e, int p7f, \n\t\t\tint p80, int p81, int p82, int p83, int p84, int p85, int p86, int p87, int p88, int p89, int p8a, int p8b, int p8c, int p8d, int p8e, int p8f, \n\t\t\tint p90, int p91, int p92, int p93, int p94, int p95, int p96, int p97, int p98, int p99, int p9a, int p9b, int p9c, int p9d, int p9e, int p9f, \n\t\t\tint pa0, int pa1, int pa2, int pa3, int pa4, int pa5, int pa6, int pa7, int pa8, int pa9, int paa, int pab, int pac, int pad, int pae, int paf, \n\t\t\tint pb0, int pb1, int pb2, int pb3, int pb4, int pb5, int pb6, int pb7, int pb8, int pb9, int pba, int pbb, int pbc, int pbd, int pbe, int pbf, \n\t\t\tint pc0, int pc1, int pc2, int pc3, int pc4, int pc5, int pc6, int pc7, int pc8, int pc9, int pca, int pcb, int pcc, int pcd, int pce, int pcf, \n\t\t\tint pd0, int pd1, int pd2, int pd3, int pd4, int pd5, int pd6, int pd7, int pd8, int pd9, int pda, int pdb, int pdc, int pdd, int pde, int pdf, \n\t\t\tint pe0, int pe1, int pe2, int pe3, int pe4, int pe5, int pe6, int pe7, int pe8, int pe9, int pea, int peb, int pec, int ped, int pee, int pef, \n\t\t\tint pf0, int pf1, int pf2, int pf3, int pf4, int pf5, int pf6, int pf7, int pf8, int pf9, int pfa, int pfb, int pfc, int pfd, int pfe\n\t\t\t) {}\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe synthetic method created to access A(int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int) of type SyntheticConstructorTooManyArgs.A has too many parameters\n----------\n");
    }

    public void test109() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runConformTest(new String[]{"SyntheticConstructorTooManyArgs.java", "public class SyntheticConstructorTooManyArgs {\n\n\tstatic class A {\n\t\tprivate A foo(\n\t\t\t/*this,*/int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p0a, int p0b, int p0c, int p0d, int p0e, int p0f, \n\t\t\tint p10, int p11, int p12, int p13, int p14, int p15, int p16, int p17, int p18, int p19, int p1a, int p1b, int p1c, int p1d, int p1e, int p1f, \n\t\t\tint p20, int p21, int p22, int p23, int p24, int p25, int p26, int p27, int p28, int p29, int p2a, int p2b, int p2c, int p2d, int p2e, int p2f, \n\t\t\tint p30, int p31, int p32, int p33, int p34, int p35, int p36, int p37, int p38, int p39, int p3a, int p3b, int p3c, int p3d, int p3e, int p3f, \n\t\t\tint p40, int p41, int p42, int p43, int p44, int p45, int p46, int p47, int p48, int p49, int p4a, int p4b, int p4c, int p4d, int p4e, int p4f, \n\t\t\tint p50, int p51, int p52, int p53, int p54, int p55, int p56, int p57, int p58, int p59, int p5a, int p5b, int p5c, int p5d, int p5e, int p5f, \n\t\t\tint p60, int p61, int p62, int p63, int p64, int p65, int p66, int p67, int p68, int p69, int p6a, int p6b, int p6c, int p6d, int p6e, int p6f, \n\t\t\tint p70, int p71, int p72, int p73, int p74, int p75, int p76, int p77, int p78, int p79, int p7a, int p7b, int p7c, int p7d, int p7e, int p7f, \n\t\t\tint p80, int p81, int p82, int p83, int p84, int p85, int p86, int p87, int p88, int p89, int p8a, int p8b, int p8c, int p8d, int p8e, int p8f, \n\t\t\tint p90, int p91, int p92, int p93, int p94, int p95, int p96, int p97, int p98, int p99, int p9a, int p9b, int p9c, int p9d, int p9e, int p9f, \n\t\t\tint pa0, int pa1, int pa2, int pa3, int pa4, int pa5, int pa6, int pa7, int pa8, int pa9, int paa, int pab, int pac, int pad, int pae, int paf, \n\t\t\tint pb0, int pb1, int pb2, int pb3, int pb4, int pb5, int pb6, int pb7, int pb8, int pb9, int pba, int pbb, int pbc, int pbd, int pbe, int pbf, \n\t\t\tint pc0, int pc1, int pc2, int pc3, int pc4, int pc5, int pc6, int pc7, int pc8, int pc9, int pca, int pcb, int pcc, int pcd, int pce, int pcf, \n\t\t\tint pd0, int pd1, int pd2, int pd3, int pd4, int pd5, int pd6, int pd7, int pd8, int pd9, int pda, int pdb, int pdc, int pdd, int pde, int pdf, \n\t\t\tint pe0, int pe1, int pe2, int pe3, int pe4, int pe5, int pe6, int pe7, int pe8, int pe9, int pea, int peb, int pec, int ped, int pee, int pef, \n\t\t\tint pf0, int pf1, int pf2, int pf3, int pf4, int pf5, int pf6, int pf7, int pf8, int pf9, int pfa, int pfb, int pfc, int pfd, int pfe\n\t\t\t) { return new A();}\n\t}\n\t@SuppressWarnings(\"synthetic-access\")\n\tA a = new A().foo(\n\t\t  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n\t\t);\n\tpublic static void main(String[] args) {\n\t\tStringBuilder params = new StringBuilder();\n\t\tparams.append(\"/*this,*/\");\n\t\tfor (int p = 1; p < 255; p++) {\n\t\t\tif (p > 1) {\n\t\t\t\tparams.append(\", \");\n\t\t\t\tif (p % 16 == 0)\n\t\t\t\t\tparams.append('\\n');\n\t\t\t}\n\t\t\tparams.append(\"int p\"\n\t\t\t\t\t+ Character.forDigit(p / 16, 16)\n\t\t\t\t\t+ Character.forDigit(p % 16, 16)\n\t\t\t\t\t);\n\t\t}\n\t\tSystem.out.println(params);\n\t\tA.class.getName(); // ClassFormatError\n\t}\n}"}, "/*this,*/int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p0a, int p0b, int p0c, int p0d, int p0e, int p0f, \nint p10, int p11, int p12, int p13, int p14, int p15, int p16, int p17, int p18, int p19, int p1a, int p1b, int p1c, int p1d, int p1e, int p1f, \nint p20, int p21, int p22, int p23, int p24, int p25, int p26, int p27, int p28, int p29, int p2a, int p2b, int p2c, int p2d, int p2e, int p2f, \nint p30, int p31, int p32, int p33, int p34, int p35, int p36, int p37, int p38, int p39, int p3a, int p3b, int p3c, int p3d, int p3e, int p3f, \nint p40, int p41, int p42, int p43, int p44, int p45, int p46, int p47, int p48, int p49, int p4a, int p4b, int p4c, int p4d, int p4e, int p4f, \nint p50, int p51, int p52, int p53, int p54, int p55, int p56, int p57, int p58, int p59, int p5a, int p5b, int p5c, int p5d, int p5e, int p5f, \nint p60, int p61, int p62, int p63, int p64, int p65, int p66, int p67, int p68, int p69, int p6a, int p6b, int p6c, int p6d, int p6e, int p6f, \nint p70, int p71, int p72, int p73, int p74, int p75, int p76, int p77, int p78, int p79, int p7a, int p7b, int p7c, int p7d, int p7e, int p7f, \nint p80, int p81, int p82, int p83, int p84, int p85, int p86, int p87, int p88, int p89, int p8a, int p8b, int p8c, int p8d, int p8e, int p8f, \nint p90, int p91, int p92, int p93, int p94, int p95, int p96, int p97, int p98, int p99, int p9a, int p9b, int p9c, int p9d, int p9e, int p9f, \nint pa0, int pa1, int pa2, int pa3, int pa4, int pa5, int pa6, int pa7, int pa8, int pa9, int paa, int pab, int pac, int pad, int pae, int paf, \nint pb0, int pb1, int pb2, int pb3, int pb4, int pb5, int pb6, int pb7, int pb8, int pb9, int pba, int pbb, int pbc, int pbd, int pbe, int pbf, \nint pc0, int pc1, int pc2, int pc3, int pc4, int pc5, int pc6, int pc7, int pc8, int pc9, int pca, int pcb, int pcc, int pcd, int pce, int pcf, \nint pd0, int pd1, int pd2, int pd3, int pd4, int pd5, int pd6, int pd7, int pd8, int pd9, int pda, int pdb, int pdc, int pdd, int pde, int pdf, \nint pe0, int pe1, int pe2, int pe3, int pe4, int pe5, int pe6, int pe7, int pe8, int pe9, int pea, int peb, int pec, int ped, int pee, int pef, \nint pf0, int pf1, int pf2, int pf3, int pf4, int pf5, int pf6, int pf7, int pf8, int pf9, int pfa, int pfb, int pfc, int pfd, int pfe");
    }

    public void test110() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runConformTest(new String[]{"SyntheticConstructorTooManyArgs.java", "public class SyntheticConstructorTooManyArgs {\n\n\tstatic class A {\n\t\tprivate static A foo(\n\t\t\t/*this,*/int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p0a, int p0b, int p0c, int p0d, int p0e, int p0f, \n\t\t\tint p10, int p11, int p12, int p13, int p14, int p15, int p16, int p17, int p18, int p19, int p1a, int p1b, int p1c, int p1d, int p1e, int p1f, \n\t\t\tint p20, int p21, int p22, int p23, int p24, int p25, int p26, int p27, int p28, int p29, int p2a, int p2b, int p2c, int p2d, int p2e, int p2f, \n\t\t\tint p30, int p31, int p32, int p33, int p34, int p35, int p36, int p37, int p38, int p39, int p3a, int p3b, int p3c, int p3d, int p3e, int p3f, \n\t\t\tint p40, int p41, int p42, int p43, int p44, int p45, int p46, int p47, int p48, int p49, int p4a, int p4b, int p4c, int p4d, int p4e, int p4f, \n\t\t\tint p50, int p51, int p52, int p53, int p54, int p55, int p56, int p57, int p58, int p59, int p5a, int p5b, int p5c, int p5d, int p5e, int p5f, \n\t\t\tint p60, int p61, int p62, int p63, int p64, int p65, int p66, int p67, int p68, int p69, int p6a, int p6b, int p6c, int p6d, int p6e, int p6f, \n\t\t\tint p70, int p71, int p72, int p73, int p74, int p75, int p76, int p77, int p78, int p79, int p7a, int p7b, int p7c, int p7d, int p7e, int p7f, \n\t\t\tint p80, int p81, int p82, int p83, int p84, int p85, int p86, int p87, int p88, int p89, int p8a, int p8b, int p8c, int p8d, int p8e, int p8f, \n\t\t\tint p90, int p91, int p92, int p93, int p94, int p95, int p96, int p97, int p98, int p99, int p9a, int p9b, int p9c, int p9d, int p9e, int p9f, \n\t\t\tint pa0, int pa1, int pa2, int pa3, int pa4, int pa5, int pa6, int pa7, int pa8, int pa9, int paa, int pab, int pac, int pad, int pae, int paf, \n\t\t\tint pb0, int pb1, int pb2, int pb3, int pb4, int pb5, int pb6, int pb7, int pb8, int pb9, int pba, int pbb, int pbc, int pbd, int pbe, int pbf, \n\t\t\tint pc0, int pc1, int pc2, int pc3, int pc4, int pc5, int pc6, int pc7, int pc8, int pc9, int pca, int pcb, int pcc, int pcd, int pce, int pcf, \n\t\t\tint pd0, int pd1, int pd2, int pd3, int pd4, int pd5, int pd6, int pd7, int pd8, int pd9, int pda, int pdb, int pdc, int pdd, int pde, int pdf, \n\t\t\tint pe0, int pe1, int pe2, int pe3, int pe4, int pe5, int pe6, int pe7, int pe8, int pe9, int pea, int peb, int pec, int ped, int pee, int pef, \n\t\t\tint pf0, int pf1, int pf2, int pf3, int pf4, int pf5, int pf6, int pf7, int pf8, int pf9, int pfa, int pfb, int pfc, int pfd, int pfe\n\t\t\t) { return new A();}\n\t}\n\t@SuppressWarnings(\"synthetic-access\")\n\tA a = A.foo(\n\t\t  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0\n\t\t);\n\tpublic static void main(String[] args) {\n\t\tStringBuilder params = new StringBuilder();\n\t\tparams.append(\"/*this,*/\");\n\t\tfor (int p = 1; p < 255; p++) {\n\t\t\tif (p > 1) {\n\t\t\t\tparams.append(\", \");\n\t\t\t\tif (p % 16 == 0)\n\t\t\t\t\tparams.append('\\n');\n\t\t\t}\n\t\t\tparams.append(\"int p\"\n\t\t\t\t\t+ Character.forDigit(p / 16, 16)\n\t\t\t\t\t+ Character.forDigit(p % 16, 16)\n\t\t\t\t\t);\n\t\t}\n\t\tSystem.out.println(params);\n\t\tA.class.getName(); // ClassFormatError\n\t}\n}"}, "/*this,*/int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p0a, int p0b, int p0c, int p0d, int p0e, int p0f, \nint p10, int p11, int p12, int p13, int p14, int p15, int p16, int p17, int p18, int p19, int p1a, int p1b, int p1c, int p1d, int p1e, int p1f, \nint p20, int p21, int p22, int p23, int p24, int p25, int p26, int p27, int p28, int p29, int p2a, int p2b, int p2c, int p2d, int p2e, int p2f, \nint p30, int p31, int p32, int p33, int p34, int p35, int p36, int p37, int p38, int p39, int p3a, int p3b, int p3c, int p3d, int p3e, int p3f, \nint p40, int p41, int p42, int p43, int p44, int p45, int p46, int p47, int p48, int p49, int p4a, int p4b, int p4c, int p4d, int p4e, int p4f, \nint p50, int p51, int p52, int p53, int p54, int p55, int p56, int p57, int p58, int p59, int p5a, int p5b, int p5c, int p5d, int p5e, int p5f, \nint p60, int p61, int p62, int p63, int p64, int p65, int p66, int p67, int p68, int p69, int p6a, int p6b, int p6c, int p6d, int p6e, int p6f, \nint p70, int p71, int p72, int p73, int p74, int p75, int p76, int p77, int p78, int p79, int p7a, int p7b, int p7c, int p7d, int p7e, int p7f, \nint p80, int p81, int p82, int p83, int p84, int p85, int p86, int p87, int p88, int p89, int p8a, int p8b, int p8c, int p8d, int p8e, int p8f, \nint p90, int p91, int p92, int p93, int p94, int p95, int p96, int p97, int p98, int p99, int p9a, int p9b, int p9c, int p9d, int p9e, int p9f, \nint pa0, int pa1, int pa2, int pa3, int pa4, int pa5, int pa6, int pa7, int pa8, int pa9, int paa, int pab, int pac, int pad, int pae, int paf, \nint pb0, int pb1, int pb2, int pb3, int pb4, int pb5, int pb6, int pb7, int pb8, int pb9, int pba, int pbb, int pbc, int pbd, int pbe, int pbf, \nint pc0, int pc1, int pc2, int pc3, int pc4, int pc5, int pc6, int pc7, int pc8, int pc9, int pca, int pcb, int pcc, int pcd, int pce, int pcf, \nint pd0, int pd1, int pd2, int pd3, int pd4, int pd5, int pd6, int pd7, int pd8, int pd9, int pda, int pdb, int pdc, int pdd, int pde, int pdf, \nint pe0, int pe1, int pe2, int pe3, int pe4, int pe5, int pe6, int pe7, int pe8, int pe9, int pea, int peb, int pec, int ped, int pee, int pef, \nint pf0, int pf1, int pf2, int pf3, int pf4, int pf5, int pf6, int pf7, int pf8, int pf9, int pfa, int pfb, int pfc, int pfd, int pfe");
    }

    public void test111() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runNegativeTest(new String[]{"SyntheticConstructorTooManyArgs.java", "public class SyntheticConstructorTooManyArgs {\n\n\tclass A {\n\t\tprivate A(\n\t\t\t/*this,*/int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p0a, int p0b, int p0c, int p0d, int p0e, int p0f, \n\t\t\tint p10, int p11, int p12, int p13, int p14, int p15, int p16, int p17, int p18, int p19, int p1a, int p1b, int p1c, int p1d, int p1e, int p1f, \n\t\t\tint p20, int p21, int p22, int p23, int p24, int p25, int p26, int p27, int p28, int p29, int p2a, int p2b, int p2c, int p2d, int p2e, int p2f, \n\t\t\tint p30, int p31, int p32, int p33, int p34, int p35, int p36, int p37, int p38, int p39, int p3a, int p3b, int p3c, int p3d, int p3e, int p3f, \n\t\t\tint p40, int p41, int p42, int p43, int p44, int p45, int p46, int p47, int p48, int p49, int p4a, int p4b, int p4c, int p4d, int p4e, int p4f, \n\t\t\tint p50, int p51, int p52, int p53, int p54, int p55, int p56, int p57, int p58, int p59, int p5a, int p5b, int p5c, int p5d, int p5e, int p5f, \n\t\t\tint p60, int p61, int p62, int p63, int p64, int p65, int p66, int p67, int p68, int p69, int p6a, int p6b, int p6c, int p6d, int p6e, int p6f, \n\t\t\tint p70, int p71, int p72, int p73, int p74, int p75, int p76, int p77, int p78, int p79, int p7a, int p7b, int p7c, int p7d, int p7e, int p7f, \n\t\t\tint p80, int p81, int p82, int p83, int p84, int p85, int p86, int p87, int p88, int p89, int p8a, int p8b, int p8c, int p8d, int p8e, int p8f, \n\t\t\tint p90, int p91, int p92, int p93, int p94, int p95, int p96, int p97, int p98, int p99, int p9a, int p9b, int p9c, int p9d, int p9e, int p9f, \n\t\t\tint pa0, int pa1, int pa2, int pa3, int pa4, int pa5, int pa6, int pa7, int pa8, int pa9, int paa, int pab, int pac, int pad, int pae, int paf, \n\t\t\tint pb0, int pb1, int pb2, int pb3, int pb4, int pb5, int pb6, int pb7, int pb8, int pb9, int pba, int pbb, int pbc, int pbd, int pbe, int pbf, \n\t\t\tint pc0, int pc1, int pc2, int pc3, int pc4, int pc5, int pc6, int pc7, int pc8, int pc9, int pca, int pcb, int pcc, int pcd, int pce, int pcf, \n\t\t\tint pd0, int pd1, int pd2, int pd3, int pd4, int pd5, int pd6, int pd7, int pd8, int pd9, int pda, int pdb, int pdc, int pdd, int pde, int pdf, \n\t\t\tint pe0, int pe1, int pe2, int pe3, int pe4, int pe5, int pe6, int pe7, int pe8, int pe9, int pea, int peb, int pec, int ped, int pee, int pef, \n\t\t\tint pf0, int pf1, int pf2, int pf3, int pf4, int pf5, int pf6, int pf7, int pf8, int pf9, int pfa, int pfb, int pfc, int pfd\n\t\t\t) {}\n\t}\n\t@SuppressWarnings(\"synthetic-access\")\n\tA a = new A(\n\t\t  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0\n\t\t);\n\tpublic static void main(String[] args) {\n\t\tStringBuilder params = new StringBuilder();\n\t\tparams.append(\"/*this,*/\");\n\t\tfor (int p = 1; p < 255; p++) {\n\t\t\tif (p > 1) {\n\t\t\t\tparams.append(\", \");\n\t\t\t\tif (p % 16 == 0)\n\t\t\t\t\tparams.append('\\n');\n\t\t\t}\n\t\t\tparams.append(\"int p\"\n\t\t\t\t\t+ Character.forDigit(p / 16, 16)\n\t\t\t\t\t+ Character.forDigit(p % 16, 16)\n\t\t\t\t\t);\n\t\t}\n\t\tSystem.out.println(params);\n\t\tA.class.getName(); // ClassFormatError\n\t}\n}"}, "----------\n1. ERROR in SyntheticConstructorTooManyArgs.java (at line 4)\n\tprivate A(\n\t\t\t/*this,*/int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p0a, int p0b, int p0c, int p0d, int p0e, int p0f, \n\t\t\tint p10, int p11, int p12, int p13, int p14, int p15, int p16, int p17, int p18, int p19, int p1a, int p1b, int p1c, int p1d, int p1e, int p1f, \n\t\t\tint p20, int p21, int p22, int p23, int p24, int p25, int p26, int p27, int p28, int p29, int p2a, int p2b, int p2c, int p2d, int p2e, int p2f, \n\t\t\tint p30, int p31, int p32, int p33, int p34, int p35, int p36, int p37, int p38, int p39, int p3a, int p3b, int p3c, int p3d, int p3e, int p3f, \n\t\t\tint p40, int p41, int p42, int p43, int p44, int p45, int p46, int p47, int p48, int p49, int p4a, int p4b, int p4c, int p4d, int p4e, int p4f, \n\t\t\tint p50, int p51, int p52, int p53, int p54, int p55, int p56, int p57, int p58, int p59, int p5a, int p5b, int p5c, int p5d, int p5e, int p5f, \n\t\t\tint p60, int p61, int p62, int p63, int p64, int p65, int p66, int p67, int p68, int p69, int p6a, int p6b, int p6c, int p6d, int p6e, int p6f, \n\t\t\tint p70, int p71, int p72, int p73, int p74, int p75, int p76, int p77, int p78, int p79, int p7a, int p7b, int p7c, int p7d, int p7e, int p7f, \n\t\t\tint p80, int p81, int p82, int p83, int p84, int p85, int p86, int p87, int p88, int p89, int p8a, int p8b, int p8c, int p8d, int p8e, int p8f, \n\t\t\tint p90, int p91, int p92, int p93, int p94, int p95, int p96, int p97, int p98, int p99, int p9a, int p9b, int p9c, int p9d, int p9e, int p9f, \n\t\t\tint pa0, int pa1, int pa2, int pa3, int pa4, int pa5, int pa6, int pa7, int pa8, int pa9, int paa, int pab, int pac, int pad, int pae, int paf, \n\t\t\tint pb0, int pb1, int pb2, int pb3, int pb4, int pb5, int pb6, int pb7, int pb8, int pb9, int pba, int pbb, int pbc, int pbd, int pbe, int pbf, \n\t\t\tint pc0, int pc1, int pc2, int pc3, int pc4, int pc5, int pc6, int pc7, int pc8, int pc9, int pca, int pcb, int pcc, int pcd, int pce, int pcf, \n\t\t\tint pd0, int pd1, int pd2, int pd3, int pd4, int pd5, int pd6, int pd7, int pd8, int pd9, int pda, int pdb, int pdc, int pdd, int pde, int pdf, \n\t\t\tint pe0, int pe1, int pe2, int pe3, int pe4, int pe5, int pe6, int pe7, int pe8, int pe9, int pea, int peb, int pec, int ped, int pee, int pef, \n\t\t\tint pf0, int pf1, int pf2, int pf3, int pf4, int pf5, int pf6, int pf7, int pf8, int pf9, int pfa, int pfb, int pfc, int pfd\n\t\t\t) {}\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe synthetic method created to access A(int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int) of type SyntheticConstructorTooManyArgs.A has too many parameters\n----------\n");
    }

    public void test112() {
        if (this.complianceLevel <= 0x300000L) {
            return;
        }
        this.runConformTest(new String[]{"SyntheticConstructorTooManyArgs.java", "public class SyntheticConstructorTooManyArgs {\n\n\tclass A {\n\t\tprivate A(\n\t\t\t/*this,*/int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p0a, int p0b, int p0c, int p0d, int p0e, int p0f, \n\t\t\tint p10, int p11, int p12, int p13, int p14, int p15, int p16, int p17, int p18, int p19, int p1a, int p1b, int p1c, int p1d, int p1e, int p1f, \n\t\t\tint p20, int p21, int p22, int p23, int p24, int p25, int p26, int p27, int p28, int p29, int p2a, int p2b, int p2c, int p2d, int p2e, int p2f, \n\t\t\tint p30, int p31, int p32, int p33, int p34, int p35, int p36, int p37, int p38, int p39, int p3a, int p3b, int p3c, int p3d, int p3e, int p3f, \n\t\t\tint p40, int p41, int p42, int p43, int p44, int p45, int p46, int p47, int p48, int p49, int p4a, int p4b, int p4c, int p4d, int p4e, int p4f, \n\t\t\tint p50, int p51, int p52, int p53, int p54, int p55, int p56, int p57, int p58, int p59, int p5a, int p5b, int p5c, int p5d, int p5e, int p5f, \n\t\t\tint p60, int p61, int p62, int p63, int p64, int p65, int p66, int p67, int p68, int p69, int p6a, int p6b, int p6c, int p6d, int p6e, int p6f, \n\t\t\tint p70, int p71, int p72, int p73, int p74, int p75, int p76, int p77, int p78, int p79, int p7a, int p7b, int p7c, int p7d, int p7e, int p7f, \n\t\t\tint p80, int p81, int p82, int p83, int p84, int p85, int p86, int p87, int p88, int p89, int p8a, int p8b, int p8c, int p8d, int p8e, int p8f, \n\t\t\tint p90, int p91, int p92, int p93, int p94, int p95, int p96, int p97, int p98, int p99, int p9a, int p9b, int p9c, int p9d, int p9e, int p9f, \n\t\t\tint pa0, int pa1, int pa2, int pa3, int pa4, int pa5, int pa6, int pa7, int pa8, int pa9, int paa, int pab, int pac, int pad, int pae, int paf, \n\t\t\tint pb0, int pb1, int pb2, int pb3, int pb4, int pb5, int pb6, int pb7, int pb8, int pb9, int pba, int pbb, int pbc, int pbd, int pbe, int pbf, \n\t\t\tint pc0, int pc1, int pc2, int pc3, int pc4, int pc5, int pc6, int pc7, int pc8, int pc9, int pca, int pcb, int pcc, int pcd, int pce, int pcf, \n\t\t\tint pd0, int pd1, int pd2, int pd3, int pd4, int pd5, int pd6, int pd7, int pd8, int pd9, int pda, int pdb, int pdc, int pdd, int pde, int pdf, \n\t\t\tint pe0, int pe1, int pe2, int pe3, int pe4, int pe5, int pe6, int pe7, int pe8, int pe9, int pea, int peb, int pec, int ped, int pee, int pef, \n\t\t\tint pf0, int pf1, int pf2, int pf3, int pf4, int pf5, int pf6, int pf7, int pf8, int pf9, int pfa, int pfb, int pfc\n\t\t\t) {}\n\t}\n\t@SuppressWarnings(\"synthetic-access\")\n\tA a = new A(\n\t\t  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,\n\t\t0,0,0,0,0,0,0,0,0,0,0,0,0\n\t\t);\n\tpublic static void main(String[] args) {\n\t\tStringBuilder params = new StringBuilder();\n\t\tparams.append(\"/*this,*/\");\n\t\tfor (int p = 1; p < 253; p++) {\n\t\t\tif (p > 1) {\n\t\t\t\tparams.append(\", \");\n\t\t\t\tif (p % 16 == 0)\n\t\t\t\t\tparams.append('\\n');\n\t\t\t}\n\t\t\tparams.append(\"int p\"\n\t\t\t\t\t+ Character.forDigit(p / 16, 16)\n\t\t\t\t\t+ Character.forDigit(p % 16, 16)\n\t\t\t\t\t);\n\t\t}\n\t\tSystem.out.println(params);\n\t\tA.class.getName(); // ClassFormatError\n\t}\n}"}, "/*this,*/int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p0a, int p0b, int p0c, int p0d, int p0e, int p0f, \nint p10, int p11, int p12, int p13, int p14, int p15, int p16, int p17, int p18, int p19, int p1a, int p1b, int p1c, int p1d, int p1e, int p1f, \nint p20, int p21, int p22, int p23, int p24, int p25, int p26, int p27, int p28, int p29, int p2a, int p2b, int p2c, int p2d, int p2e, int p2f, \nint p30, int p31, int p32, int p33, int p34, int p35, int p36, int p37, int p38, int p39, int p3a, int p3b, int p3c, int p3d, int p3e, int p3f, \nint p40, int p41, int p42, int p43, int p44, int p45, int p46, int p47, int p48, int p49, int p4a, int p4b, int p4c, int p4d, int p4e, int p4f, \nint p50, int p51, int p52, int p53, int p54, int p55, int p56, int p57, int p58, int p59, int p5a, int p5b, int p5c, int p5d, int p5e, int p5f, \nint p60, int p61, int p62, int p63, int p64, int p65, int p66, int p67, int p68, int p69, int p6a, int p6b, int p6c, int p6d, int p6e, int p6f, \nint p70, int p71, int p72, int p73, int p74, int p75, int p76, int p77, int p78, int p79, int p7a, int p7b, int p7c, int p7d, int p7e, int p7f, \nint p80, int p81, int p82, int p83, int p84, int p85, int p86, int p87, int p88, int p89, int p8a, int p8b, int p8c, int p8d, int p8e, int p8f, \nint p90, int p91, int p92, int p93, int p94, int p95, int p96, int p97, int p98, int p99, int p9a, int p9b, int p9c, int p9d, int p9e, int p9f, \nint pa0, int pa1, int pa2, int pa3, int pa4, int pa5, int pa6, int pa7, int pa8, int pa9, int paa, int pab, int pac, int pad, int pae, int paf, \nint pb0, int pb1, int pb2, int pb3, int pb4, int pb5, int pb6, int pb7, int pb8, int pb9, int pba, int pbb, int pbc, int pbd, int pbe, int pbf, \nint pc0, int pc1, int pc2, int pc3, int pc4, int pc5, int pc6, int pc7, int pc8, int pc9, int pca, int pcb, int pcc, int pcd, int pce, int pcf, \nint pd0, int pd1, int pd2, int pd3, int pd4, int pd5, int pd6, int pd7, int pd8, int pd9, int pda, int pdb, int pdc, int pdd, int pde, int pdf, \nint pe0, int pe1, int pe2, int pe3, int pe4, int pe5, int pe6, int pe7, int pe8, int pe9, int pea, int peb, int pec, int ped, int pee, int pef, \nint pf0, int pf1, int pf2, int pf3, int pf4, int pf5, int pf6, int pf7, int pf8, int pf9, int pfa, int pfb, int pfc");
    }

    public void test113() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\npublic class X {\n\tpublic static void bar(int i) {\n\t\tfinal String before;\n\t\ttry {\n\t\t\tbefore = foo();\n\t\t} catch (IOException e) {\n\t\t\t// ignore\n\t\t}\n\t\tB b = new B(new I() {\n\t\t\tpublic String bar() {\n\t\t\t\treturn new String(before);\n\t\t\t}\n\t\t});\n\t\ttry {\n\t\t\tb.toString();\n\t\t} catch(Exception e) {\n\t\t\t// ignore\n\t\t}\n\t}\n\tprivate static String foo() throws IOException {\n\t\treturn null;\n\t}\n\tstatic class B {\n\t\tB(I i) {\n\t\t\t//ignore\n\t\t}\n\t}\n\tstatic interface I {\n\t\tString bar();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\treturn new String(before);\n\t                  ^^^^^^\nThe local variable before may not have been initialized\n----------\n", null, true, null, true, false, false, false, false);
        this.runConformTest(new String[]{"Y.java", "public class Y {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tX.bar(3);\n\t\t} catch(VerifyError e) {\n\t\t\tSystem.out.println(\"FAILED\");\n\t\t}\n\t}\n}"}, "", null, false, null);
    }

    public void test114() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static int field1;\n\tpublic static int field2;\n\tpublic void bar(int i) {\n\t\tSystem.out.println(foo());\n\t\tfoo();\t\tSystem.out.println(X.field1);\n\t\tSystem.out.println(field2);\n\t\tfield2 = 1;\n\t}\n\tpublic final void bar2(int i) {\n\t\tSystem.out.println(foo());\n\t\tfoo();\t\tSystem.out.println(X.field1);\n\t\tSystem.out.println(field2);\n\t\tfield2 = 1;\n\t}\n\tprivate void bar3(int i) {\n\t\tSystem.out.println(foo());\n\t\tfoo();\t\tSystem.out.println(X.field1);\n\t\tSystem.out.println(field2);\n\t\tfield2 = 1;\n\t}\n\tprivate static String foo() {\n\t\treturn null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic void bar(int i) {\n\t            ^^^^^^^^^^\nThe method bar(int) from the type X can potentially be declared as static\n----------\n2. ERROR in X.java (at line 10)\n\tpublic final void bar2(int i) {\n\t                  ^^^^^^^^^^^\nThe method bar2(int) from the type X can be declared as static\n----------\n3. WARNING in X.java (at line 16)\n\tprivate void bar3(int i) {\n\t             ^^^^^^^^^^^\nThe method bar3(int) from the type X is never used locally\n----------\n4. ERROR in X.java (at line 16)\n\tprivate void bar3(int i) {\n\t             ^^^^^^^^^^^\nThe method bar3(int) from the type X can be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test115() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X extends B{\n\tpublic static int field1;\n\tpublic static int field2;\n\tpublic void bar(int i) {\n\t\tSystem.out.println(foo());\n\t\tX.field2 = 2;\n\t\tSystem.out.println(field1);\n\t\tA a = new A();\n\t\ta.a1();\n\t}\n\tprivate static String foo() {\n\t\treturn null;\n\t}\n}\nclass A{\n\tpublic void a1() {\n\t}\n}\nclass B{\n\tpublic void b1(){\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic void bar(int i) {\n\t            ^^^^^^^^^^\nThe method bar(int) from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test116a() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X extends B{\n\tpublic static int field1;\n\tpublic X xfield;\n\tpublic void bar1(int i) {\n\t\tbaz();\n\t}\n\tpublic void bar2(int i) {\n\t\tthis.baz();\n\t}\n\tpublic void bar3(int i) {\n\t\tthis.xfield.baz();\n\t}\n\tpublic void bar4(int i) {\n\t\txfield.baz();\n\t}\n\tpublic void bar5(int i) {\n\t\tX x = new X();\n\t\tx.baz();\n\t}\n\tpublic void bar6(int i) {\n\t\tA.xA.baz();\n\t}\n\tpublic void bar7(int i) {\n\t\tb1();\n\t}\n\tpublic void bar8(int i) {\n\t\tthis.b1();\n\t}\n\tpublic void bar9(int i) {\n\t\tnew X().b1();\n\t}\n\tpublic void baz() {\n\t}\n}\nclass A{\n\tpublic static X xA;\n}\nclass B{\n\tpublic void b1(){\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 16)\n\tpublic void bar5(int i) {\n\t            ^^^^^^^^^^^\nThe method bar5(int) from the type X can potentially be declared as static\n----------\n2. ERROR in X.java (at line 20)\n\tpublic void bar6(int i) {\n\t            ^^^^^^^^^^^\nThe method bar6(int) from the type X can potentially be declared as static\n----------\n3. ERROR in X.java (at line 29)\n\tpublic void bar9(int i) {\n\t            ^^^^^^^^^^^\nThe method bar9(int) from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test116b() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X extends B{\n\tpublic static int field1;\n\tpublic static X xfield;\n\tpublic void bar1(int i) {\n\t\tbaz();\n\t}\n\tpublic void bar2(int i) {\n\t\tthis.baz();\n\t}\n\tpublic void bar3(int i) {\n\t\tthis.xfield.baz();\n\t}\n\tpublic void bar4(int i) {\n\t\txfield.baz();\n\t}\n\tpublic void bar5(int i) {\n\t\tX x = new X();\n\t\tx.baz();\n\t}\n\tpublic void bar6(int i) {\n\t\tA.xA.baz();\n\t}\n\tpublic void bar7(int i) {\n\t\tb1();\n\t}\n\tpublic void bar8(int i) {\n\t\tthis.b1();\n\t}\n\tpublic void bar9(int i) {\n\t\tnew X().b1();\n\t}\n\tpublic static void baz() {\n\t}\n}\nclass A{\n\tpublic static X xA;\n}\nclass B{\n\tpublic static void b1(){\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic void bar1(int i) {\n\t            ^^^^^^^^^^^\nThe method bar1(int) from the type X can potentially be declared as static\n----------\n2. ERROR in X.java (at line 13)\n\tpublic void bar4(int i) {\n\t            ^^^^^^^^^^^\nThe method bar4(int) from the type X can potentially be declared as static\n----------\n3. ERROR in X.java (at line 16)\n\tpublic void bar5(int i) {\n\t            ^^^^^^^^^^^\nThe method bar5(int) from the type X can potentially be declared as static\n----------\n4. ERROR in X.java (at line 20)\n\tpublic void bar6(int i) {\n\t            ^^^^^^^^^^^\nThe method bar6(int) from the type X can potentially be declared as static\n----------\n5. ERROR in X.java (at line 23)\n\tpublic void bar7(int i) {\n\t            ^^^^^^^^^^^\nThe method bar7(int) from the type X can potentially be declared as static\n----------\n6. ERROR in X.java (at line 29)\n\tpublic void bar9(int i) {\n\t            ^^^^^^^^^^^\nThe method bar9(int) from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test117a() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X extends B{\n\tpublic int field1;\n\tpublic X xfield;\n\tpublic void bar1(int i) {\n\t\tfield1 = 1;\n\t}\n\tpublic void bar2(int i) {\n\t\tthis.field1 = 1;\n\t}\n\tpublic void bar3(int i) {\n\t\tSystem.out.println(field1);\n\t}\n\tpublic void bar4(int i) {\n\t\tSystem.out.println(this.field1);\n\t}\n\tpublic void bar5(int i) {\n\t\tX x = new X();\n\t\tx.field1 = 1;\n\t}\n\tpublic void bar6(int i) {\n\t\tA.xA.field1 = 1;\n\t}\n\tpublic void bar7(int i) {\n\t\tb1 = 1;\n\t}\n\tpublic void bar8(int i) {\n\t\tthis.b1 = 1;\n\t}\n\tpublic void bar9(int i) {\n\t\tnew X().b1 = 1;\n\t}\n\tpublic void bar10(int i) {\n\t\tthis.xfield.field1 = 1;\n\t}\n\tpublic void bar11(int i) {\n\t\tSystem.out.println(this.xfield.field1);\n\t}\n\tpublic void bar12(int i) {\n\t\tSystem.out.println(new X().b1);\n\t}\n\tpublic void bar13(int i) {\n\t\tSystem.out.println(b1);\n\t}\n\tpublic void bar14(int i) {\n\t\tSystem.out.println(this.b1);\n\t}\n\tpublic void bar15(int i) {\n\t\txfield.field1 = 1;\n\t}\n\tpublic void bar16(int i) {\n\t\tSystem.out.println(xfield.field1);\n\t}\n\tpublic void baz() {\n\t}\n}\nclass A{\n\tpublic static X xA;\n}\nclass B{\n\tpublic int b1;\n}"}, "----------\n1. ERROR in X.java (at line 16)\n\tpublic void bar5(int i) {\n\t            ^^^^^^^^^^^\nThe method bar5(int) from the type X can potentially be declared as static\n----------\n2. ERROR in X.java (at line 20)\n\tpublic void bar6(int i) {\n\t            ^^^^^^^^^^^\nThe method bar6(int) from the type X can potentially be declared as static\n----------\n3. ERROR in X.java (at line 29)\n\tpublic void bar9(int i) {\n\t            ^^^^^^^^^^^\nThe method bar9(int) from the type X can potentially be declared as static\n----------\n4. ERROR in X.java (at line 38)\n\tpublic void bar12(int i) {\n\t            ^^^^^^^^^^^^\nThe method bar12(int) from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test117b() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X extends B{\n\tpublic static int field1;\n\tpublic static X xfield;\n\tpublic void bar1(int i) {\n\t\tfield1 = 1;\n\t}\n\tpublic void bar2(int i) {\n\t\tthis.field1 = 1;\n\t}\n\tpublic void bar3(int i) {\n\t\tSystem.out.println(field1);\n\t}\n\tpublic void bar4(int i) {\n\t\tSystem.out.println(this.field1);\n\t}\n\tpublic void bar5(int i) {\n\t\tX x = new X();\n\t\tx.field1 = 1;\n\t}\n\tpublic void bar6(int i) {\n\t\tA.xA.field1 = 1;\n\t}\n\tpublic void bar7(int i) {\n\t\tb1 = 1;\n\t}\n\tpublic void bar8(int i) {\n\t\tthis.b1 = 1;\n\t}\n\tpublic void bar9(int i) {\n\t\tnew X().b1 = 1;\n\t}\n\tpublic void bar10(int i) {\n\t\tthis.xfield.field1 = 1;\n\t}\n\tpublic void bar11(int i) {\n\t\tSystem.out.println(this.xfield.field1);\n\t}\n\tpublic void bar12(int i) {\n\t\tSystem.out.println(new X().b1);\n\t}\n\tpublic void bar13(int i) {\n\t\tSystem.out.println(b1);\n\t}\n\tpublic void bar14(int i) {\n\t\tSystem.out.println(this.b1);\n\t}\n\tpublic void bar15(int i) {\n\t\txfield.field1 = 1;\n\t}\n\tpublic void bar16(int i) {\n\t\tSystem.out.println(xfield.field1);\n\t}\n\tpublic void baz() {\n\t}\n}\nclass A{\n\tpublic static X xA;\n}\nclass B{\n\tpublic static int b1;\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic void bar1(int i) {\n\t            ^^^^^^^^^^^\nThe method bar1(int) from the type X can potentially be declared as static\n----------\n2. ERROR in X.java (at line 10)\n\tpublic void bar3(int i) {\n\t            ^^^^^^^^^^^\nThe method bar3(int) from the type X can potentially be declared as static\n----------\n3. ERROR in X.java (at line 16)\n\tpublic void bar5(int i) {\n\t            ^^^^^^^^^^^\nThe method bar5(int) from the type X can potentially be declared as static\n----------\n4. ERROR in X.java (at line 20)\n\tpublic void bar6(int i) {\n\t            ^^^^^^^^^^^\nThe method bar6(int) from the type X can potentially be declared as static\n----------\n5. ERROR in X.java (at line 23)\n\tpublic void bar7(int i) {\n\t            ^^^^^^^^^^^\nThe method bar7(int) from the type X can potentially be declared as static\n----------\n6. ERROR in X.java (at line 29)\n\tpublic void bar9(int i) {\n\t            ^^^^^^^^^^^\nThe method bar9(int) from the type X can potentially be declared as static\n----------\n7. ERROR in X.java (at line 38)\n\tpublic void bar12(int i) {\n\t            ^^^^^^^^^^^^\nThe method bar12(int) from the type X can potentially be declared as static\n----------\n8. ERROR in X.java (at line 41)\n\tpublic void bar13(int i) {\n\t            ^^^^^^^^^^^^\nThe method bar13(int) from the type X can potentially be declared as static\n----------\n9. ERROR in X.java (at line 47)\n\tpublic void bar15(int i) {\n\t            ^^^^^^^^^^^^\nThe method bar15(int) from the type X can potentially be declared as static\n----------\n10. ERROR in X.java (at line 50)\n\tpublic void bar16(int i) {\n\t            ^^^^^^^^^^^^\nThe method bar16(int) from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test118() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "final public class X {\n\tpublic static int field1;\n\tpublic static int field2;\n\tpublic void bar(int i) {\n\t\tSystem.out.println(foo());\n\t\tfoo();\t\tSystem.out.println(X.field1);\n\t\tSystem.out.println(field2);\n\t\tfield2 = 1;\n\t}\n\tpublic static int foo(){ return 1;}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic void bar(int i) {\n\t            ^^^^^^^^^^\nThe method bar(int) from the type X can be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test119() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static int field1;\n\tpublic int field2;\n\tpublic void bar(int i) {\n\t\t(new Object() {\n\t\t\tpublic boolean foo1() {\n\t\t\t\treturn X.this.field2 == 1;\n\t\t\t}\n\t\t}).foo1();\n\tSystem.out.println(X.field1);\n\t}\n\tpublic void bar2(int i) {\n\t\t(new Object() {\n\t\t\tpublic boolean foo1() {\n\t\t\t\tSystem.out.println(X.field1);\n\t\t\t\treturn true;\t\t\t}\n\t\t}).foo1();\n\tSystem.out.println(X.field1);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 12)\n\tpublic void bar2(int i) {\n\t            ^^^^^^^^^^^\nThe method bar2(int) from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test120() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\tpublic static int field1;\n\tpublic int field2;\n\tpublic void bar(T t) {\n\t\tX.field1 = 1;\n\t\tSystem.out.println(t);\n\t}\n\tpublic <E> void bar2(E e) {\n\t\tX.field1 = 1;\n\t\tSystem.out.println(e);\n\t}\n\tpublic <E> void bar3() {\n\t\tT a;\n\t\tSystem.out.println();\n\t}\n\tpublic <E,Y> void bar4() {\n\t\tY a;\n\t\tSystem.out.println();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tpublic <E> void bar2(E e) {\n\t                ^^^^^^^^^\nThe method bar2(E) from the type X<T> can potentially be declared as static\n----------\n2. ERROR in X.java (at line 16)\n\tpublic <E,Y> void bar4() {\n\t                  ^^^^^^\nThe method bar4() from the type X<T> can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test121() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X extends A{\n\tpublic static int field1;\n\tpublic int field2;\n\tpublic void methodA() {\n\t\tsuper.methodA();\n\t}\n\tpublic void bar() {\n\t\tsuper.fieldA = 1;\n\t}\n\tpublic void bar2() {\n\t\tSystem.out.println(super.fieldA);\n\t}\n\tpublic void bar3() {\n\t\tSystem.out.println(X.fieldA);\n\t}\n}\nclass A{\n\tpublic static int fieldA;\n   public void methodA(){\n   }\n}"}, "----------\n1. ERROR in X.java (at line 13)\n\tpublic void bar3() {\n\t            ^^^^^^\nThe method bar3() from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test122() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tclass A{\n   \tvoid methodA() {\n\t\t\tSystem.out.println();\n\t\t}\n   }\n\tstatic class B{\n   \tvoid methodB() {\n\t\t\tSystem.out.println();\n\t\t}\n   }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tvoid methodB() {\n\t     ^^^^^^^^^\nThe method methodB() from the type X.B can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test123() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n\t<E,Y> T method1() {\n\t\treturn null;\n\t}\n\t<E,Y> E method2() {\n\t\treturn null;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\t<E,Y> E method2() {\n\t        ^^^^^^^^^\nThe method method2() from the type X<T> can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void testBug335845a() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate class Bar {\n\t\tint a = 1;\n\t}\n\tprivate void foo() {\n\t\tnew Bar();\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void testBug335845b() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate class Bar {\n\t\tint a = 1;\n\t}\n\tprivate void foo() {\n\t\tint x = new Bar().a;\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void testBug335845c() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate static class Bar {\n\t\tint a = 1;\n\t}\n\tprivate void foo() {\n\t\tnew Bar();\n\t\tint x = new Bar().a;\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tprivate void foo() {\n\t             ^^^^^\nThe method foo() from the type X can be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void testBug335845d() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate class Bar {\n\t\tclass Bar2{}\n\t}\n\tprivate void foo() {\n\t\tnew Bar().new Bar2();\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void testBug335845e() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate class Bar {\n\t\tint a = 1;\n\t}\n\tprivate void foo() {\n\t\tnew X().new Bar();\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tprivate void foo() {\n\t             ^^^^^\nThe method foo() from the type X can be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void testBug335845f() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate class Bar {\n\t\tint a = 1;\n\t}\n\tprivate void foo() {\n\t\tX x = new X();\t\tx.new Bar().a = 2;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tprivate void foo() {\n\t             ^^^^^\nThe method foo() from the type X can be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void testBug335845g() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedObjectAllocation", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tclass Bar {\n\t}\n}"});
        this.runNegativeTest(new String[]{"p/Y.java", "package p;\npublic class Y extends X {\n\tprivate void foo() {\n\t\tnew Bar();\n\t}\n}"}, "", null, false, compilerOptions);
    }

    public void test124a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void method1() {\n\t\tFoo.m(this);\n\t}\nstatic class Foo{\n\tstatic void m(X bug) {\n\t\t\n\t}\n}\n}"}, "", null, true, compilerOptions);
    }

    public void test124b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   public static X xField;\tpublic void method1() {\n\t\tFoo.m(this.xField);\n\t}\nstatic class Foo{\n\tstatic void m(X bug) {\n\t\t\n\t}\n}\n}"}, "", null, true, compilerOptions);
    }

    public void test354502() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   public abstract class Abstract{}\n   public static abstract class Abstract2{}\n\tprivate void method1() {\n\t\tnew Abstract() {};\n\t}\n\tprivate void method2() {\n\t\tnew Abstract2() {};\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tprivate void method2() {\n\t             ^^^^^^^^^\nThe method method2() from the type X can be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test360164() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"p/B.java", "package p;\n\npublic abstract class B<K,V> {\n\t protected abstract V foo(K element);\n}\n", "p/C.java", "package p;\npublic class C {\n}\n", "p/D.java", "package p;\npublic class D extends E {\n}\n", "p/E.java", "package p;\npublic abstract class E implements I {\n}\n", "p/I.java", "package p;\npublic interface I {\n}\n", "p/X.java", "package p;\npublic class X {\n\tprivate final class A extends B<C,D>{\n\t\t@Override\n\t\tprotected D foo(C c) {\n\t\t\treturn null;\n\t\t}\n   }\n}\n"}, "");
        org.eclipse.jdt.core.tests.util.Util.delete(new File(OUTPUT_DIR, "p" + File.separator + "I.class"));
        this.runNegativeTest(false, new String[]{"p/X.java", "package p;\npublic class X {\n\tprivate final class A extends B<C,D>{\n\t\t@Override\n\t\tprotected D foo(C c) {\n            Zork z;\n\t\t\treturn null;\n\t\t}\n   }\n}\n"}, null, null, "----------\n1. WARNING in p\\X.java (at line 3)\n\tprivate final class A extends B<C,D>{\n\t                    ^\nThe type X.A is never used locally\n----------\n2. ERROR in p\\X.java (at line 6)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", AbstractRegressionTest.JavacTestOptions.SKIP_UNTIL_FRAMEWORK_FIX);
    }

    public void test376550_1a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint i = 1;\n   public void upper1(){}\n   public void foo(){\n   \tclass Local{\n\t\t\tint i2 = 1;\n\t\t\tvoid method1() {\n\t\t\t\ti = 1;\n\t\t\t}\n\t\t}\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void test376550_1b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint i = 1;\n   public void upper1(){}\n   public void foo(){\n   \tclass Local{\n\t\t\tint i2 = 1;\n\t\t\tvoid method2() {\n\t\t\t\ti2 = 1;\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_2a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n   public void upper1(){}\n   public void foo(){\n   \tclass Local<K>{\n\t\t\tvoid method2() {\n\t\t\t\tK k;\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X<T> can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_2b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n   public void upper1(){}\n   public void foo(){\n   \tclass Local<K>{\n\t\t\tvoid method2() {\n\t\t\t\tT t;\n\t\t\t}\n\t\t}\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void test376550_3a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n   public void upper1(){}\n   public void foo(){\n   \tclass Local<K>{\n\t\t\tvoid lower() {}\n\t\t\tvoid method2() {\n\t\t\t\tupper1();\n\t\t\t}\n\t\t}\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void test376550_3b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n   public void upper1(){}\n   public void foo(){\n   \tclass Local<K>{\n\t\t\tvoid lower() {}\n\t\t\tvoid method2() {\n\t\t\t\tlower();\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X<T> can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_4a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n   int i1 = 1;\n   public void foo(){\n   \tclass Local<K>{\n\t\t\tint i2 = 1;\n\t\t\tvoid lower(int i) {}\n\t\t\tvoid method2() {\n\t\t\t\tlower(i2);\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X<T> can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_4b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X<T> {\n   int i1 = 1;\n   public void foo(){\n   \tclass Local<K>{\n\t\t\tint i2 = 1;\n\t\t\tvoid lower(int i) {}\n\t\t\tvoid method2() {\n\t\t\t\tlower(i1);\n\t\t\t}\n\t\t}\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void test376550_5a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   int i1 = 1;\n   public void foo(){\n   \tclass Local{\n\t\t\tint i2 = 1;\n\t\t\tvoid method2() {\n\t\t\t\tLocal.this.i2 = 1;\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_5aa() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint i1 = 1;\n\tpublic void foo(){\n\t\tclass Local{\n\t\t\tint i2 = 1;\n       }\n       class Local2 extends Local {\n\t\t\tvoid method2() {\n\t\t\t\tLocal2.this.i2 = 1;\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_5b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   int i1 = 1;\n   public void foo(){\n   \tclass Local{\n\t\t\tint i2 = 1;\n\t\t\tvoid method2() {\n\t\t\t\tX.this.i1 = 1;\n\t\t\t}\n\t\t}\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void test376550_6a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   int i1 = 1;\n   public void foo(){\n   \tclass Local{\n\t\t\tint i2 = 1;\n\t\t\tboolean method2() {\n\t\t\t\treturn Local.this.i2 == 1;\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_6b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   int i1 = 1;\n   public void foo(){\n   \tclass Local{\n\t\t\tint i2 = 1;\n\t\t\tboolean method2() {\n\t\t\t\treturn X.this.i1 == 1;\n\t\t\t}\n\t\t}\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void test376550_7a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   abstract class AbsUp{}\n   public void foo(){\n   \tclass Local{\n\t\t\tabstract class AbsLow{}\n\t\t\tvoid method2() {\n\t\t\t\tnew AbsLow(){};\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_7b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   abstract class AbsUp{}\n   public void foo(){\n   \tclass Local{\n\t\t\tabstract  class AbsLow{}\n\t\t\tvoid method2() {\n\t\t\t\tnew AbsUp(){};\n\t\t\t}\n\t\t}\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void test376550_8a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   class AbsUp{ int a;}\n   public void foo(){\n   \tclass Local{\n\t\t\tclass AbsLow{  int a;}\n\t\t\tvoid method2() {\n\t\t\t\tint abc = new AbsLow().a;\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_8b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   class AbsUp{ int a;}\n   public void foo(){\n   \tclass Local{\n\t\t\tclass AbsLow{  int a;}\n\t\t\tvoid method2() {\n\t\t\t\tint abc = new AbsUp().a;\n\t\t\t}\n\t\t}\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void test376550_9a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   X xup;\n\tint i = 1;\n   public void foo(){\n   \tclass Local{\n\t\t\tX xdown;\n\t\t\tclass AbsLow{  int a;}\n\t\t\tvoid method2() {\n\t\t\t\tint abc = xdown.i;\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_9b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   X xup;\n\tint i = 1;\n   public void foo(){\n   \tclass Local{\n\t\t\tX xdown;\n\t\t\tclass AbsLow{  int a;}\n\t\t\tvoid method2() {\n\t\t\t\tint abc = xup.i;\n\t\t\t}\n\t\t}\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void test376550_10a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   X xup;\n\tint i = 1;\n   public void foo(){\n   \tclass Local{\n\t\t\tX xdown;\n\t\t\tvoid calc(int i1){}\n\t\t\tvoid method2() {\n\t\t\t\tcalc(xdown.i);\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tpublic void foo(){\n\t            ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }

    public void test376550_10b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n   X xup;\n\tint i = 1;\n   public void foo(){\n   \tclass Local{\n\t\t\tX xdown;\n\t\t\tvoid calc(int i1){}\n\t\t\tvoid method2() {\n\t\t\t\tcalc(xup.i);\n\t\t\t}\n\t\t}\n\t}\n}"}, "", null, true, compilerOptions);
    }

    public void test376550_11() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\npublic class X {\n   private Object o = new Object();\n   public final Collection<Object> go() {\n   \treturn new ArrayList<Object>() {\n\t\t\t{ add(o);}\n\t\t};\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 6)\n\treturn new ArrayList<Object>() {\n\t           ^^^^^^^^^^^^^^^^^^^\nThe serializable class  does not declare a static final serialVersionUID field of type long\n----------\n2. WARNING in X.java (at line 7)\n\t{ add(o);}\n\t      ^\nRead access to enclosing field X.o is emulated by a synthetic accessor method\n----------\n", null, true, compilerOptions);
    }

    public void test376550_11a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\npublic class X {\n   private Object o = new Object();\n   public final Collection<Object> go() {\n   \treturn new ArrayList<Object>() {\n\t\t\t{ add(null);}\n\t\t};\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic final Collection<Object> go() {\n\t                                ^^^^\nThe method go() from the type X can be declared as static\n----------\n2. WARNING in X.java (at line 6)\n\treturn new ArrayList<Object>() {\n\t           ^^^^^^^^^^^^^^^^^^^\nThe serializable class  does not declare a static final serialVersionUID field of type long\n----------\n", null, true, compilerOptions);
    }

    public void test376550_12() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\npublic class X<E> {\n   private Object o = new Object();\n   public final <E1> Collection<E1> go() {\n   \treturn new ArrayList<E1>() {\n\t\t\t{ E1 e;}\n\t\t};\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tpublic final <E1> Collection<E1> go() {\n\t                                 ^^^^\nThe method go() from the type X<E> can be declared as static\n----------\n2. WARNING in X.java (at line 6)\n\treturn new ArrayList<E1>() {\n\t           ^^^^^^^^^^^^^^^\nThe serializable class  does not declare a static final serialVersionUID field of type long\n----------\n", null, true, compilerOptions);
    }

    public void test376550_13() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runConformTest(new String[]{"QualifiedSuper.java", "public class QualifiedSuper {\n\tclass InnerS {\n\t\tvoid flub() {}\n\t}\n\tstatic class InnerT extends InnerS {\n\t\tInnerT(QualifiedSuper qs) {\n\t\t\tqs.super();\n\t\t}\n\t\tfinal void schlumpf() {\n\t\t\tInnerT.super.flub();\n\t\t}\n\t}\t\n}\n"}, "", null, true, null, compilerOptions, null);
    }

    public void test379530() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runConformTest(new String[]{"X.java", "public class X<S> {\n   S s;\n\t{\n\t\t S /*[*/s/*]*/;\n\t\t s= X.this.s;\t}\n}"}, "", null, true, null, compilerOptions, null);
    }

    public void test393781() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        String oldOption = compilerOptions.get("org.eclipse.jdt.core.compiler.problem.rawTypeReference");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        try {
            this.runNegativeTest(new String[]{"p/X.java", "public class X {\n   public void foo(Map map, String str) {}\n\tpublic void foo1() {}\n\tpublic void bar(java.util.Map map) {\n\t\tfoo(map, \"\");\n\t\tfoo(map);\n\t\tfoo();\n\t\tfoo1(map, \"\");\n\t}\n}\nclass Map {}\n"}, "----------\n1. ERROR in p\\X.java (at line 5)\n\tfoo(map, \"\");\n\t^^^\nThe method foo(Map, java.lang.String) in the type X is not applicable for the arguments (java.util.Map, java.lang.String)\n----------\n2. ERROR in p\\X.java (at line 6)\n\tfoo(map);\n\t^^^\nThe method foo(Map, String) in the type X is not applicable for the arguments (Map)\n----------\n3. ERROR in p\\X.java (at line 7)\n\tfoo();\n\t^^^\nThe method foo(Map, String) in the type X is not applicable for the arguments ()\n----------\n4. ERROR in p\\X.java (at line 8)\n\tfoo1(map, \"\");\n\t^^^^\nThe method foo1() in the type X is not applicable for the arguments (Map, String)\n----------\n", null, true, compilerOptions);
        }
        finally {
            compilerOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", oldOption);
        }
    }

    private void runStaticWarningConformTest(String fileName, String body) {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runConformTest(new String[]{fileName, body}, compilerOptions);
    }

    public void test378674_comment0() {
        this.runStaticWarningConformTest("Test.java", "public class Test<T> {\n\n    @SuppressWarnings({ \"unchecked\", \"rawtypes\" })\n    public static void main(String[] args) {\n        new Test().method(null);\n    }\n\n    private static class SubClass<A> {\n\n    }\n\n    private void method(SubClass<T> s) {\n        System.out.println(s);\n    }\n\n}\n");
    }

    public void test378674_comment1b() {
        this.runStaticWarningConformTest("X.java", "import java.util.Collection;\nclass X<E>{\n   public final <E1> Collection<E> go() {  // cannot be static\n\t\treturn null; \n   }\n}\n");
    }

    public void test378674_comment1c() {
        this.runStaticWarningConformTest("X.java", "import java.util.Collection;\nimport java.util.ArrayList;\n\tclass X<E>{\n   public final <E1> Collection<?> go() {  // cannot be static\n\t\treturn new ArrayList<E>(); \n   }\n}\n");
    }

    public void test378674_comment2() {
        this.runStaticWarningConformTest("X.java", "public class X<T> {\n\tpublic final void foo() {\n\t\tjava.util.List<T> k;\n\t}\n}\n");
    }

    public void test378674_comment3() {
        this.runStaticWarningConformTest("Test.java", "public class Test {\n\t//false positive of method can be declared static\n\tvoid bar() {\n\t\tfoo(Test.this);\n\t}\n\n\tprivate static void foo(Test test) {\n\t\tSystem.out.println(test.getClass().getName());\n\t}\n}\n");
    }

    public void test378674_comment5a() {
        this.runStaticWarningConformTest("Test.java", "public class Test<T> {\n\n    @SuppressWarnings({ \"unchecked\", \"rawtypes\" })\n    public static void main(String[] args) {\n        new Test().method2(null);\n    }\n\n    private static class SubClass<A> {\n\n    }\n\n    private void method2(SubClass<java.util.List<T>> s) {\n        System.out.println(s);\n    }\n\n}\n");
    }

    public void test378674_comment5b() {
        this.runStaticWarningConformTest("Test.java", "public class Test<T> {\n\n    @SuppressWarnings({ \"unchecked\", \"rawtypes\" })\n    public static void main(String[] args) {\n        new Test().method();\n    }\n\n    private java.util.Collection<T> method() {\n        return null;\n    }\n\n}\n");
    }

    public void test378674_comment9() {
        this.runStaticWarningConformTest("Test.java", "public class Test<T> {\n\n    @SuppressWarnings({ \"rawtypes\" })\n    public static void main(String[] args) {\n        new Test().method();\n    }\n\n    private java.util.Collection<? extends T> method() {\n        return null;\n    }\n}\n");
    }

    public void test378674_comment11() {
        this.runStaticWarningConformTest("Test.java", "public class Test<T> {\n\n    @SuppressWarnings({ \"rawtypes\" })\n    public static void main(String[] args) {\n        new Test().method1();\n        new Test().method2();\n    }\n\n   private <TT extends T> TT method1() { \n\t\treturn null;\n\t}\n\n   private <TT extends Object & Comparable<? super T>> TT method2() { \n\t\treturn null;\n\t}\n}\n");
    }

    public void test378674_comment21a() {
        this.runStaticWarningConformTest("X.java", "public class X<P extends Exception> {\n\tfinal <T> void foo(T x) throws P {\n\t}\n}\n");
    }

    public void test378674_comment21b() {
        this.runStaticWarningConformTest("X.java", "public class X<P extends Exception> {\n\tfinal <T> void foo(T x) {\n\t\tObject o = (P) null;\n\t}\n}\n");
    }

    public void test378674_comment21c() {
        this.runStaticWarningConformTest("X.java", "public class X<P extends Exception> {\n\tfinal <T> void foo(T x) {\n\t\tnew Outer().new Inner<P>();\n\t}\n}\nclass Outer {\n\tclass Inner<Q> {}\n}\n");
    }

    public void test378674_comment21d() {
        this.runStaticWarningConformTest("X.java", "public class X<P extends Exception> {\n\tfinal <T> void foo(T x) {\n\t\tclass Local {\n\t\t\tP p;\n\t\t}\n\t}\n}\n");
    }

    public void test406396() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n\tint f;\n\tvoid foo() {\n\t\tclass Y {\n\t\t\tint p;\n\t\t\t{\n\t\t\t\tclass Z {\n\t\t\t\t\tint f = p;\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tvoid foo() {\n\t     ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n2. WARNING in X.java (at line 4)\n\tclass Y {\n\t      ^\nThe type Y is never used locally\n----------\n3. WARNING in X.java (at line 7)\n\tclass Z {\n\t      ^\nThe type Z is never used locally\n----------\n4. WARNING in X.java (at line 8)\n\tint f = p;\n\t    ^\nThe field Z.f is hiding a field from type X\n----------\n5. WARNING in X.java (at line 8)\n\tint f = p;\n\t    ^\nThe value of the field Z.f is not used\n----------\n", null, true, compilerOptions);
    }

    public void test406396a() {
        Map<String, String> compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBeStatic", "error");
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.reportMethodCanBePotentiallyStatic", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n\tint f;\n\tint foo() {\n\t\tint f = 0;\n\t\treturn f;\n\t}\n\tint goo() {\n\t\treturn 0;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint foo() {\n\t    ^^^^^\nThe method foo() from the type X can potentially be declared as static\n----------\n2. WARNING in X.java (at line 4)\n\tint f = 0;\n\t    ^\nThe local variable f is hiding a field from type X\n----------\n3. ERROR in X.java (at line 7)\n\tint goo() {\n\t    ^^^^^\nThe method goo() from the type X can potentially be declared as static\n----------\n", null, true, compilerOptions);
    }
}

