/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.jdt.core.tests.runtime.DRLVMLauncher;
import org.eclipse.jdt.core.tests.runtime.J9VMLauncher;
import org.eclipse.jdt.core.tests.runtime.JRockitVMLauncher;
import org.eclipse.jdt.core.tests.runtime.LocalVirtualMachine;
import org.eclipse.jdt.core.tests.runtime.MacVMLauncher;
import org.eclipse.jdt.core.tests.runtime.RuntimeConstants;
import org.eclipse.jdt.core.tests.runtime.SideCarJ9VMLauncher;
import org.eclipse.jdt.core.tests.runtime.SideCarVMLauncher;
import org.eclipse.jdt.core.tests.runtime.StandardVMLauncher;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.util.Util;

public abstract class LocalVMLauncher
implements RuntimeConstants {
    public static final boolean TARGET_HAS_FILE_SYSTEM = true;
    public static final String REGULAR_CLASSPATH_DIRECTORY = "regularPath";
    public static final String BOOT_CLASSPATH_DIRECTORY = "bootPath";
    protected String[] bootPath;
    protected String[] classPath;
    protected int debugPort = -1;
    protected int evalPort = -1;
    protected String evalTargetPath;
    protected String[] programArguments;
    protected String programClass;
    protected Vector runningVMs = new Vector();
    protected String[] vmArguments;
    protected String vmPath;

    public static LocalVMLauncher getLauncher() {
        String vmName = System.getProperty("java.vm.name");
        if ("J9".equals(vmName)) {
            return new J9VMLauncher();
        }
        if (vmName != null && vmName.indexOf("JRockit") != -1) {
            return new JRockitVMLauncher();
        }
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac")) {
            return new MacVMLauncher();
        }
        String javaVersion = System.getProperty("java.version");
        boolean isJrt = javaVersion != null && javaVersion.length() > 0 && javaVersion.charAt(0) == '9';
        File file = new File(String.valueOf(Util.getJREDirectory()) + (isJrt ? "/lib/jrt-fs.jar" : "/lib/rt.jar"));
        if (file.exists()) {
            return new StandardVMLauncher();
        }
        if ("IBM J9SE VM".equals(vmName)) {
            return new SideCarJ9VMLauncher();
        }
        if ("DRLVM".equals(vmName)) {
            return new DRLVMLauncher();
        }
        return new SideCarVMLauncher();
    }

    protected String buildClassPath() {
        StringBuffer classPathString = new StringBuffer();
        char pathSeparator = File.pathSeparatorChar;
        if (this.evalPort != -1) {
            classPathString.append(new File(this.evalTargetPath, "EvalTestsTarget.zip").getPath());
            classPathString.append(pathSeparator);
        }
        if (this.classPath != null) {
            int length = this.classPath.length;
            int i = 0;
            while (i < length) {
                classPathString.append(this.classPath[i]);
                classPathString.append(pathSeparator);
                ++i;
            }
        }
        if (this.evalPort != -1) {
            classPathString.append(this.evalTargetPath);
            classPathString.append(File.separatorChar);
            classPathString.append(REGULAR_CLASSPATH_DIRECTORY);
        }
        return classPathString.toString();
    }

    protected Process execCommandLine() throws TargetException {
        if (this.vmPath == null) {
            throw new TargetException("Path to the VM has not been specified");
        }
        if (this.programClass == null && this.evalPort == -1) {
            throw new TargetException("Program class has not been specified");
        }
        Process vmProcess = null;
        try {
            String[] commandLine = this.getCommandLine();
            vmProcess = Runtime.getRuntime().exec(commandLine);
        }
        catch (IOException iOException) {
            throw new TargetException("Error launching VM at " + this.vmPath);
        }
        return vmProcess;
    }

    public String[] getBootClassPath() {
        return this.bootPath;
    }

    public String[] getClassPath() {
        return this.classPath;
    }

    public abstract String[] getCommandLine();

    public int getDebugPort() {
        return this.debugPort;
    }

    public int getEvalPort() {
        return this.evalPort;
    }

    public String getEvalTargetPath() {
        return this.evalTargetPath;
    }

    public String[] getProgramArguments() {
        if (this.evalPort != -1) {
            return null;
        }
        return this.programArguments;
    }

    public String getProgramClass() {
        if (this.evalPort != -1) {
            return null;
        }
        return this.programClass;
    }

    public LocalVirtualMachine[] getRunningVirtualMachines() {
        Vector<LocalVirtualMachine> actuallyRunning = new Vector<LocalVirtualMachine>();
        Enumeration en = this.runningVMs.elements();
        while (en.hasMoreElements()) {
            LocalVirtualMachine vm = (LocalVirtualMachine)en.nextElement();
            if (!vm.isRunning()) continue;
            actuallyRunning.addElement(vm);
        }
        this.runningVMs = actuallyRunning;
        int size = actuallyRunning.size();
        LocalVirtualMachine[] result = new LocalVirtualMachine[size];
        int i = 0;
        while (i < size) {
            result[i] = (LocalVirtualMachine)actuallyRunning.elementAt(i);
            ++i;
        }
        return result;
    }

    public String getTargetAddress() {
        return "localhost";
    }

    public String[] getVMArguments() {
        return this.vmArguments;
    }

    public String getVMPath() {
        return this.vmPath;
    }

    protected void initTargetPath() throws TargetException {
        File directory = new File(this.evalTargetPath);
        directory.mkdirs();
        if (!directory.exists()) {
            throw new TargetException("Could not create directory " + this.evalTargetPath);
        }
        File classesDirectory = new File(directory, REGULAR_CLASSPATH_DIRECTORY);
        classesDirectory.mkdir();
        if (!classesDirectory.exists()) {
            throw new TargetException("Could not create directory " + classesDirectory.getPath());
        }
        File bootDirectory = new File(directory, BOOT_CLASSPATH_DIRECTORY);
        bootDirectory.mkdir();
        if (!bootDirectory.exists()) {
            throw new TargetException("Could not create directory " + bootDirectory.getPath());
        }
        InputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                in = this.getClass().getResourceAsStream("/EvalTestsTarget.zip");
                if (in == null) {
                    throw new TargetException("Could not find resource /EvalTestsTarget.zip");
                }
                int bufferLength = 1024;
                byte[] buffer = new byte[bufferLength];
                File file = new File(directory, "EvalTestsTarget.zip");
                out = new FileOutputStream(file);
                int read = 0;
                while (read != -1) {
                    read = in.read(buffer, 0, bufferLength);
                    if (read == -1) continue;
                    out.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                throw new TargetException("IOException while copying EvalTestsTarget.zip: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public LocalVirtualMachine launch() throws TargetException {
        if (this.evalTargetPath != null) {
            this.initTargetPath();
        }
        Process p = this.execCommandLine();
        LocalVirtualMachine vm = new LocalVirtualMachine(p, this.debugPort, this.evalTargetPath);
        this.runningVMs.addElement(vm);
        return vm;
    }

    public void setBootClassPath(String[] bootClassPath) {
        this.bootPath = bootClassPath;
    }

    public void setClassPath(String[] classPath) {
        this.classPath = classPath;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public void setEvalPort(int evalPort) {
        this.evalPort = evalPort;
    }

    public void setEvalTargetPath(String evalTargetPath) {
        this.evalTargetPath = evalTargetPath;
    }

    public void setProgramArguments(String[] args) {
        this.programArguments = args;
    }

    public void setProgramClass(String programClass) {
        this.programClass = programClass;
    }

    public void setVMArguments(String[] args) {
        this.vmArguments = args;
    }

    public void setVMPath(String vmPath) {
        this.vmPath = vmPath;
    }
}

