/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.util;

import java.util.Enumeration;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class CompilerTestSetup
extends TestSuite {
    long complianceLevel;

    public CompilerTestSetup(long complianceLevel) {
        super(CompilerOptions.versionFromJdkLevel((long)complianceLevel));
        this.complianceLevel = complianceLevel;
    }

    protected void initTest(Object test) {
        if (test instanceof AbstractCompilerTest) {
            AbstractCompilerTest compilerTest = (AbstractCompilerTest)((Object)test);
            compilerTest.initialize(this);
            return;
        }
        if (test instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)test;
            Enumeration evaluationTestClassTests = testSuite.tests();
            while (evaluationTestClassTests.hasMoreElements()) {
                this.initTest(evaluationTestClassTests.nextElement());
            }
            return;
        }
        if (test instanceof Enumeration) {
            Enumeration evaluationTestClassTests = (Enumeration)test;
            while (evaluationTestClassTests.hasMoreElements()) {
                this.initTest(evaluationTestClassTests.nextElement());
            }
            return;
        }
    }

    public void run(TestResult result) {
        try {
            this.setUp();
            super.run(result);
        }
        finally {
            this.tearDown();
        }
    }

    protected void setUp() {
        this.initTest(this.tests());
    }

    protected void tearDown() {
    }
}

