/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class AllocationExpressionCompletionTest
extends AbstractCompletionTest {
    public AllocationExpressionCompletionTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return AllocationExpressionCompletionTest.buildAllCompliancesTestSuite(AllocationExpressionCompletionTest.class);
    }

    public void testInIfStatement() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tif (true) {\t\t\t\t\t\t\t\n\t\t\tnew z.y.X(1, 2, i);\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(1, 2,", "<CompleteOnAllocationExpression:new z.y.X(1, 2)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    {\n      <CompleteOnAllocationExpression:new z.y.X(1, 2)>;\n    }\n  }\n}\n", "", "", "<complete inside an if statement>");
    }

    public void testNoQualificationQualifiedTypeName() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew z.y.X(1, 2, i);\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(1, 2,", "<CompleteOnAllocationExpression:new z.y.X(1, 2)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnAllocationExpression:new z.y.X(1, 2)>;\n  }\n}\n", "", "", "<complete on non qualified instance creation with qualified type name>");
    }

    public void testNoQualificationSimpleTypeName() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tnew X(1, 2, i);\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(1, 2,", "<CompleteOnAllocationExpression:new X(1, 2)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnAllocationExpression:new X(1, 2)>;\n  }\n}\n", "", "", "<complete on non qualified instance creation with simple type name>");
    }

    public void testQualifiedWithName() {
        this.runTestCheckMethodParse("class Bar {\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tBuz.x.new X(1, 2, i);\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(1, 2,", "<CompleteOnQualifiedAllocationExpression:Buz.x.new X(1, 2)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnQualifiedAllocationExpression:Buz.x.new X(1, 2)>;\n  }\n}\n", "", "", "<complete on name qualified instance creation>");
    }

    public void testQualifiedWithPrimary() {
        this.runTestCheckMethodParse("class Bar {\t\t\t\t\t\t\t\t\n\tvoid foo() {\t\t\t\t\t\t\t\n\t\tprimary().new X(1, 2, i);\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\n", "X(1, 2,", "<CompleteOnQualifiedAllocationExpression:primary().new X(1, 2)>", "class Bar {\n  Bar() {\n  }\n  void foo() {\n    <CompleteOnQualifiedAllocationExpression:primary().new X(1, 2)>;\n  }\n}\n", "", "", "<complete on primary qualified instance creation>");
    }
}

