/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Locale;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class StatementRecoveryTest_1_5
extends AbstractCompilerTest {
    public static final boolean ONLY_DIET_PLUS_BODY_WITH_STATEMENT_RECOVERY = false;
    public static boolean optimizeStringLiterals = false;
    public static long sourceLevel = 0x2F0000L;

    public static Test suite() {
        return StatementRecoveryTest_1_5.buildAllCompliancesTestSuite(StatementRecoveryTest_1_5.class);
    }

    public StatementRecoveryTest_1_5(String testName) {
        super(testName);
    }

    public void checkParse(char[] source, String expectedDietUnitToString, String expectedDietWithStatementRecoveryUnitToString, String expectedDietPlusBodyUnitToString, String expectedDietPlusBodyWithStatementRecoveryUnitToString, String expectedFullUnitToString, String expectedFullWithStatementRecoveryUnitToString, String testName) {
        int length;
        int i;
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        parser.setStatementsRecovery(false);
        CompilationUnit sourceUnit = new CompilationUnit(source, testName, null);
        CompilationResult compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        CompilationUnitDeclaration computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        String computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest_1_5.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietWithStatementRecoveryUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest_1_5.assertEquals("Invalid unit diet structure with statement recovery enabled" + testName, expectedDietWithStatementRecoveryUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        parser.setStatementsRecovery(false);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest_1_5.assertEquals("Invalid unit diet structure" + testName, expectedDietUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            i = 0;
            length = computedUnit.types.length;
            while (i < length) {
                computedUnit.types[i].parseMethods(parser, computedUnit);
                ++i;
            }
        }
        if (!expectedDietPlusBodyUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest_1_5.assertEquals("Invalid unit diet+body structure" + testName, expectedDietPlusBodyUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.dietParse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedDietWithStatementRecoveryUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest_1_5.assertEquals("Invalid unit diet structure" + testName, expectedDietWithStatementRecoveryUnitToString, computedUnitToString);
        if (computedUnit.types != null) {
            i = 0;
            length = computedUnit.types.length;
            while (i < length) {
                computedUnit.types[i].parseMethods(parser, computedUnit);
                ++i;
            }
        }
        if (!expectedDietPlusBodyWithStatementRecoveryUnitToString.equals(computedUnitToString = computedUnit.toString())) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest_1_5.assertEquals("Invalid unit diet+body structure with statement recovery enabled" + testName, expectedDietPlusBodyWithStatementRecoveryUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        parser.setStatementsRecovery(false);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest_1_5.assertEquals("Invalid unit full structure" + testName, expectedFullUnitToString, computedUnitToString);
        parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.getCompilerOptions()), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault())), optimizeStringLiterals);
        sourceUnit = new CompilationUnit(source, testName, null);
        compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0);
        computedUnit = parser.parse((ICompilationUnit)sourceUnit, compilationResult);
        computedUnitToString = computedUnit.toString();
        if (!expectedFullWithStatementRecoveryUnitToString.equals(computedUnitToString)) {
            System.out.println(Util.displayString(computedUnitToString));
        }
        StatementRecoveryTest_1_5.assertEquals("Invalid unit full structure with statement recovery enabled" + testName, expectedFullWithStatementRecoveryUnitToString, computedUnitToString);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        return options;
    }

    public void test0001() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo(Collection c) {\t\t\t\t\t\n    for(String s: c) {\t\t\t\t\t\t\n      try {\t\t\t\t\t\t\t\t\t\n        foo();\t\t`\t\t\t\t\t\t\n      }\t\t\t\t`\t\t\t\t\t\t\n    }\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(Collection c) {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo(Collection c) {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo(Collection c) {\n    for (String s : c) \n      {\n        try\n          {\n            foo();\n          }\n        finally\n          {\n          }\n      }\n    ;\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo(Collection c) {\n  }\n}\n";
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0002() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\n    #\t\t\t\t\t\t\t\t\t\t\n    @MyAnnot(value=)\t\t\t\t\t\t\t\n    int i;\t\t\t`\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    @MyAnnot(value = $missing$) int i;\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0003() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\t\t\t\t\n    @AnAnnotation(name) #\t\t\t\t\t\t\t\t\t\n    int var;\t\t\t\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    @AnAnnotation(name) int var;\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0004() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\t\t\t\t\n    @AnAnnotation(name=)\t\t\t\t\t\t\t\t\t\t\n    int var;\t\t\t\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    @AnAnnotation(name = $missing$) int var;\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0005() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\t\t\t\t\n    foo1();\t\t\t\t\t\t\t\t\t\t\t\t\t\n    @AnAnnotation(name) #\t\t\t\t\t\t\t\t\t\n    class Y {}\t\t\t\t\t\t\t\t\t\t\t\t\n    foo2();\t\t\t\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    @AnAnnotation(name) class Y {\n      Y() {\n        super();\n      }\n    }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    foo1();\n    @AnAnnotation(name) class Y {\n      Y() {\n        super();\n      }\n    }\n    foo2();\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0006() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\t\t\t\t\n    foo1();\t\t\t\t\t\t\t\t\t\t\t\t\t\n    @AnAnnotation(name=)\t\t\t\t\t\t\t\t\t\t\n    class Y {}\t\t\t\t\t\t\t\t\t\t\t\t\n    foo2();\t\t\t\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    @AnAnnotation(name = $missing$) class Y {\n      Y() {\n        super();\n      }\n    }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    foo1();\n    @AnAnnotation(name = $missing$) class Y {\n      Y() {\n        super();\n      }\n    }\n    foo2();\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0007() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "package a;\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\npublic class X {\t\t\t\t\t\t\t\t\t\t\t\t\n  void foo() {\t\t\t\t\t\t\t\t\t\t\t\t\n    foo1();\t\t\t\t\t\t\t\t\t\t\t\t\t\n    final @AnAnnotation(name) #\t\t\t\t\t\t\t\t\n    class Y {}\t\t\t\t\t\t\t\t\t\t\t\t\n    foo2();\t\t\t\t\t\t\t\t\t\t\t\t\t\n  }\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "package a;\npublic class X {\n  public X() {\n  }\n  void foo() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    final @AnAnnotation(name) class Y {\n      Y() {\n        super();\n      }\n    }\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "package a;\npublic class X {\n  public X() {\n    super();\n  }\n  void foo() {\n    foo1();\n    final @AnAnnotation(name) class Y {\n      Y() {\n        super();\n      }\n    }\n    foo2();\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = expectedDietUnitToString;
        String testName = "<test>";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }

    public void test0008() {
        String expectedFullUnitToString;
        String expectedDietUnitToString;
        String s = "public class Try {\n\n    void m() {\n\n        synchronized new Object();\n\n    }\n}\n\n";
        String expectedDietWithStatementRecoveryUnitToString = expectedDietUnitToString = "public class Try {\n  public Try() {\n  }\n  void m() {\n  }\n}\n";
        String expectedDietPlusBodyUnitToString = "public class Try {\n  public Try() {\n    super();\n  }\n  void m() {\n  }\n}\n";
        String expectedDietPlusBodyWithStatementRecoveryUnitToString = "public class Try {\n  public Try() {\n    super();\n  }\n  void m() {\n  }\n}\n";
        String expectedFullWithStatementRecoveryUnitToString = expectedFullUnitToString = expectedDietUnitToString;
        String testName = "test";
        this.checkParse(s.toCharArray(), expectedDietUnitToString, expectedDietWithStatementRecoveryUnitToString, expectedDietPlusBodyUnitToString, expectedDietPlusBodyWithStatementRecoveryUnitToString, expectedFullUnitToString, expectedFullWithStatementRecoveryUnitToString, testName);
    }
}

