/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.core.tests.compiler.Activator;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.osgi.framework.Bundle;

public abstract class AbstractNullAnnotationTest
extends AbstractComparableTest {
    String[] LIBS;
    static final String CUSTOM_NONNULL_NAME = "org/foo/NonNull.java";
    static final String CUSTOM_NONNULL_CONTENT = "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface NonNull {\n}\n";
    static final String CUSTOM_NONNULL_CONTENT_JSR308 = "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface NonNull {\n}\n";
    static final String CUSTOM_NULLABLE_NAME = "org/foo/Nullable.java";
    static final String CUSTOM_NULLABLE_CONTENT = "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE})\npublic @interface Nullable {\n}\n";
    static final String CUSTOM_NULLABLE_CONTENT_JSR308 = "package org.foo;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Retention(RetentionPolicy.CLASS)\n@Target({METHOD,PARAMETER,LOCAL_VARIABLE,TYPE_USE})\npublic @interface Nullable {\n}\n";
    static boolean setNullRelatedOptions = true;

    public AbstractNullAnnotationTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (this.LIBS == null) {
            String[] defaultLibs = this.getDefaultClassPaths();
            int len = defaultLibs.length;
            this.LIBS = new String[len + 1];
            System.arraycopy(defaultLibs, 0, this.LIBS, 0, len);
            String version = this.complianceLevel >= 0x340000L ? "[2.0.0,3.0.0)" : "[1.1.0,2.0.0)";
            Bundle[] bundles = Activator.getPackageAdmin().getBundles("org.eclipse.jdt.annotation", version);
            File bundleFile = FileLocator.getBundleFile((Bundle)bundles[0]);
            this.LIBS[len] = bundleFile.isDirectory() ? String.valueOf(bundleFile.getPath()) + "/bin" : bundleFile.getPath();
        }
    }

    @Override
    protected Map getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        if (setNullRelatedOptions) {
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.includeNullInfoFromAsserts", "enabled");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "disabled");
            defaultOptions.put("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.pessimisticNullAnalysisForFreeTypeVariables", "error");
            defaultOptions.put("org.eclipse.jdt.core.compiler.problem.nonnullTypeVariableFromLegacyInvocation", "warning");
        }
        return defaultOptions;
    }

    void runNegativeTestWithLibs(String[] testFiles, String expectedErrorLog) {
        this.runNegativeTest(testFiles, expectedErrorLog, this.LIBS, false);
    }

    void runNegativeTestWithLibs(boolean skipJavac, String[] testFiles, String expectedErrorLog) {
        this.runNegativeTest(skipJavac, null, testFiles, expectedErrorLog, this.LIBS, false);
    }

    void runNegativeTestWithExtraLibs(String[] testFiles, String expectedErrorLog, String[] extraLibs) {
        String[] libraries = new String[(this.LIBS == null ? 0 : this.LIBS.length) + (extraLibs == null ? 0 : extraLibs.length)];
        if (this.LIBS != null) {
            System.arraycopy(this.LIBS, 0, libraries, 0, this.LIBS.length);
        }
        if (extraLibs != null) {
            System.arraycopy(extraLibs, 0, libraries, this.LIBS == null ? 0 : this.LIBS.length, extraLibs.length);
        }
        this.runNegativeTest(testFiles, expectedErrorLog, libraries, false);
    }

    void runNegativeTestWithLibs(boolean shouldFlushOutputDirectory, String[] testFiles, Map customOptions, String expectedErrorLog) {
        this.runNegativeTestWithLibs(shouldFlushOutputDirectory, testFiles, customOptions, expectedErrorLog, false);
    }

    void runNegativeTestWithLibs(boolean shouldFlushOutputDirectory, String[] testFiles, Map customOptions, String expectedErrorLog, boolean skipJavaC) {
        this.runNegativeTest(shouldFlushOutputDirectory, testFiles, this.LIBS, customOptions, expectedErrorLog, skipJavaC ? AbstractRegressionTest.JavacTestOptions.SKIP : AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    void runNegativeTestWithLibs(String[] testFiles, Map customOptions, String expectedErrorLog) {
        this.runNegativeTestWithLibs(false, testFiles, customOptions, expectedErrorLog);
    }

    void runNegativeTestWithLibs(String[] testFiles, Map customOptions, String expectedErrorLog, boolean skipJavac) {
        this.runNegativeTestWithLibs(false, testFiles, customOptions, expectedErrorLog, skipJavac);
    }

    void runConformTestWithLibs(String[] testFiles, Map customOptions, String expectedCompilerLog) {
        this.runConformTestWithLibs(false, testFiles, customOptions, expectedCompilerLog);
    }

    void runConformTestWithLibs(String[] testFiles, Map customOptions, String expectedCompilerLog, String expectedOutput) {
        this.runConformTest(false, testFiles, this.LIBS, customOptions, expectedCompilerLog, expectedOutput, "", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    void runConformTestWithLibs(boolean shouldFlushOutputDirectory, String[] testFiles, Map customOptions, String expectedCompilerLog) {
        this.runConformTest(shouldFlushOutputDirectory, testFiles, this.LIBS, customOptions, expectedCompilerLog, "", "", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    void runConformTest(String[] testFiles, Map customOptions, String expectedOutputString) {
        this.runConformTest(testFiles, expectedOutputString, null, true, null, customOptions, null);
    }
}

