/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class AssignmentTest
extends AbstractRegressionTest {
    public AssignmentTest(String name) {
        super(name);
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.nullReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "error");
        return options;
    }

    public static Test suite() {
        Test suite = AssignmentTest.buildAllCompliancesTestSuite(AssignmentTest.testClass());
        return suite;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    int i;\t\n    X(int j) {\t\n    \ti = j;\t\n    }\t\n    X() {\t\n    }\t\n    class B extends X {\t\n        B() {\t\n            this.i = X.this.i;\t\n        }\t\n    }\t\n    public static void main(String[] args) {\t\n        X a = new X(3);\t\n        System.out.print(a.i + \" \");\t\n        System.out.print(a.new B().i);\t\n\t}\t\n}\t\n"}, "3 3");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint a;\t\n\tX next;\t\n\tpublic void foo(int arg){\t\n\t\n\t\tzork = zork;\t\n\t\targ = zork;\t\n\t\n\t\targ = arg;  // noop\t\n\t\ta = a;  // noop\t\n\t\tthis.next = this.next; // noop\t\n\t\tthis.next = next; // noop\t\n\t\n\t\tnext.a = next.a; // could raise NPE\t\n\t\tthis.next.next.a = next.next.a; // could raise NPE\t\n\t\ta = next.a; // could raise NPE\t\n\t\tthis. a = next.a; \t\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tzork = zork;\t\n\t^^^^\nzork cannot be resolved to a variable\n----------\n2. ERROR in X.java (at line 6)\n\tzork = zork;\t\n\t       ^^^^\nzork cannot be resolved to a variable\n----------\n3. ERROR in X.java (at line 7)\n\targ = zork;\t\n\t      ^^^^\nzork cannot be resolved to a variable\n----------\n4. ERROR in X.java (at line 9)\n\targ = arg;  // noop\t\n\t^^^^^^^^^\nThe assignment to variable arg has no effect\n----------\n5. ERROR in X.java (at line 10)\n\ta = a;  // noop\t\n\t^^^^^\nThe assignment to variable a has no effect\n----------\n6. ERROR in X.java (at line 11)\n\tthis.next = this.next; // noop\t\n\t^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable next has no effect\n----------\n7. ERROR in X.java (at line 12)\n\tthis.next = next; // noop\t\n\t^^^^^^^^^^^^^^^^\nThe assignment to variable next has no effect\n----------\n");
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint portNumber;\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tx.portNumber = Integer.parseInt(\"12\");\n\t\tx.run();\n\t}\n\tprivate void run() {\n\t\tSystem.out.println(portNumber);\n\t}\n}"}, "12");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    // correctly passes compilation\n    static class Test1 {\n        private final Object o;\n        \n        Test1() {\n            o = new Object();\n        }\n    }\n    \n    // correctly passes compilation\n    static class Test2 {\n        private final Object o;\n        \n        Test2() {\n            this.o = new Object();\n        }\n    }\n    \n    // correctly fails compilation\n    static class Test3 {\n        private final Object o;\n        \n        Test3() {\n            System.out.println(o); // illegal; o is not definitely assigned\n            o = new Object();\n        }\n    }\n    \n    // correctly passes compilation\n    static class Test4 {\n        private final Object o;\n        \n        Test4() {\n            System.out.println(this.o); // legal\n            o = new Object();\n        }\n    }\n    \n    // incorrectly passes compilation\n    static class Test5 {\n        private final Object o;\n        \n        Test5() {\n            Test5 other = this;\n            other.o = new Object(); // illegal!  other.o is not assignable\n        } // error: this.o is not definitely assigned\n    }\n    \n    // flags wrong statement as error\n    static class Test6 {\n        private final Object o;\n        static Test6 initing;\n        \n       Test6() {\n           initing = this;\n           System.out.println(\"greetings\");\n           Test6 other = initing;\n           other.o = new Object(); // illegal!  other.o is not assignable\n           o = new Object(); // legal\n       }\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tprivate final Object o;\n\t                     ^\nThe value of the field X.Test1.o is not used\n----------\n2. WARNING in X.java (at line 13)\n\tprivate final Object o;\n\t                     ^\nThe value of the field X.Test2.o is not used\n----------\n3. ERROR in X.java (at line 25)\n\tSystem.out.println(o); // illegal; o is not definitely assigned\n\t                   ^\nThe blank final field o may not have been initialized\n----------\n" + (this.complianceLevel >= 0x330000L ? "4. ERROR in X.java (at line 35)\n\tSystem.out.println(this.o); // legal\n\t                        ^\nThe blank final field o may not have been initialized\n----------\n5. WARNING in X.java (at line 42)\n\tprivate final Object o;\n\t                     ^\nThe value of the field X.Test5.o is not used\n----------\n6. ERROR in X.java (at line 44)\n\tTest5() {\n\t^^^^^^^\nThe blank final field o may not have been initialized\n----------\n7. ERROR in X.java (at line 46)\n\tother.o = new Object(); // illegal!  other.o is not assignable\n\t      ^\nThe final field X.Test5.o cannot be assigned\n----------\n8. WARNING in X.java (at line 52)\n\tprivate final Object o;\n\t                     ^\nThe value of the field X.Test6.o is not used\n----------\n9. ERROR in X.java (at line 59)\n\tother.o = new Object(); // illegal!  other.o is not assignable\n\t      ^\nThe final field X.Test6.o cannot be assigned\n----------\n" : "4. WARNING in X.java (at line 42)\n\tprivate final Object o;\n\t                     ^\nThe value of the field X.Test5.o is not used\n----------\n5. ERROR in X.java (at line 44)\n\tTest5() {\n\t^^^^^^^\nThe blank final field o may not have been initialized\n----------\n6. ERROR in X.java (at line 46)\n\tother.o = new Object(); // illegal!  other.o is not assignable\n\t      ^\nThe final field X.Test5.o cannot be assigned\n----------\n7. WARNING in X.java (at line 52)\n\tprivate final Object o;\n\t                     ^\nThe value of the field X.Test6.o is not used\n----------\n8. ERROR in X.java (at line 59)\n\tother.o = new Object(); // illegal!  other.o is not assignable\n\t      ^\nThe final field X.Test6.o cannot be assigned\n----------\n"));
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tfinal int contents;\n\t\n\tX() {\n\t\tcontents = 3;\n\t}\n\tX(X other) {\n\t\tother.contents = 5;\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tX one = new X();\n\t\tSystem.out.println(\"one.contents: \" + one.contents);\n\t\tX two = new X(one);\n\t\tSystem.out.println(\"one.contents: \" + one.contents);\n\t\tSystem.out.println(\"two.contents: \" + two.contents);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tX(X other) {\n\t^^^^^^^^^^\nThe blank final field contents may not have been initialized\n----------\n2. ERROR in X.java (at line 8)\n\tother.contents = 5;\n\t      ^^^^^^^^\nThe final field X.contents cannot be assigned\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tfinal int v;\n\t\tfor (int i = 0; i < 10; i++) {\n\t\t\tv = i;\n\t\t}\n\t\tv = 0;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tv = i;\n\t^\nThe final local variable v may already have been assigned\n----------\n2. ERROR in X.java (at line 7)\n\tv = 0;\n\t^\nThe final local variable v may already have been assigned\n----------\n");
    }

    public void test033() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t\n\tvoid foo() {\n\t\tString a,b;\n\t\tdo{\n\t\t   a=\"Hello \";\n\t\t}while(a!=null);\n\t\t\t\t\n\t\tif(a!=null)\n\t\t{\n\t\t   b=\"World!\";\n\t\t}\n\t\tSystem.out.println(a+b);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\t}while(a!=null);\n\t       ^\nRedundant null check: The variable a cannot be null at this location\n----------\n2. ERROR in X.java (at line 9)\n\tif(a!=null)\n\t   ^\nNull comparison always yields false: The variable a can only be null at this location\n----------\n3. ERROR in X.java (at line 13)\n\tSystem.out.println(a+b);\n\t                     ^\nThe local variable b may not have been initialized\n----------\n");
    }

    public void test034() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        this.runNegativeTest(new String[]{"X.java", "public final class X \n{\n\tpublic static String vdg;\n\tpublic static final String aa = null;\n\tpublic static final int a = 14;\n\tpublic static final int b = 3;\n\tprivate static final int c = 12;\n\tprivate static final int d = 2; \n\tprivate static final int e = 3; \n\tprivate static final int f = 34; \n\tprivate static final int g = 35; \n\tprivate static final int h = 36; \n\tprivate static final int j = 4;\n\tprivate static final int k = 1;\n\tpublic static final int aba = 1;\n\tpublic static final int as = 11;\n\tpublic static final int ad = 12;\n\tpublic static final int af = 13;\n\tpublic static final int ag = 2;\n\tpublic static final int ah = 21;\n\tpublic static final int aj = 22;\n\tpublic static final int ak = 3;\n\tpublic static final String aaad = null;\n\tpublic static final int aaaf = 1;\n\tpublic static final int aaag = 2;\n\tpublic static final int aaha = 2;\n\tstatic int cxvvb = 1;\n\tstatic int z = a;\n\tString asdff;\n\tpublic static String ppfp;\n\tpublic static int ppfpged;\n\tboolean asfadf;\n\tboolean cbxbx;\n\tprivate static long tyt, rrky;\n\tprivate static int dgjt, ykjr6y;\n\tprivate static final int krykr = 1;\n\tprotected static int rykr5;\n\tprotected static int dhfg;\n\tprivate static int dthj;\n\tprivate static int fkffy;\n\tprivate static String fhfy;\n\tprotected static String fhmf;\n\tprotected String ryur6;\n\tprotected String dhdthd;\n\tprotected String dth5;\n\tprotected String kfyk;\n\tprivate String ntd;\n\tpublic int asdasdads;\n\tpublic static final int dntdr = 7;\n\tpublic static final int asys = 1;\n\tpublic static final int djd5rwas = 11;\n\tpublic static final int dhds45rjd = 12;\n\tpublic static final int srws4jd = 13;\n\tpublic static final int s4ts = 2;\n\tpublic static final int dshes4 = 21;\n\tpublic static final int drthed56u = 22;\n\tpublic static final int drtye45 = 23;\n\tpublic static final int xxbxrb = 3;\n\tpublic static final int xfbxr = 31;\n\tpublic static final int asgw4y = 32;\n\tpublic static final int hdtrhs5r = 33;\n\tpublic static final int dshsh = 34;\n\tpublic static final int ds45yuwsuy = 4;\n\tpublic static final int astgs45rys = 5;\n\tpublic static final int srgs4y = 6;\n\tpublic static final int srgsryw45 = -6;\n\tpublic static final int srgdtgjd45ry = -7;\n\tpublic static final int srdjs43t = 1;\n\tpublic static final int sedteued5y = 2;\n\tpublic static int jrfd6u;\n\tpublic static int udf56u;\n\tprivate String jf6tu;\n\tprivate String jf6tud;\n\tString bsrh;\n\tprotected X(String a)\n\t{\n\t}\n\tprivate long sfhdsrhs;\n\tprivate boolean qaafasdfs;\n\tprivate int sdgsa;\n\tprivate long dgse4;\n\tlong sgrdsrg;\n\tpublic void gdsthsr()\n\t{\n\t}\n\tprivate int hsrhs;\n\tprivate void hsrhsdsh()\n\t{\n\t}\n\tprivate String dsfhshsr;\n\tprotected void sfhsh4rsrh()\n\t{\n\t}\n\tprotected void shsrhsh()\n\t{\n\t}\n\tprotected void sfhstuje56u()\n\t{\n\t}\n\tpublic void dhdrt6u()\n\t{\n\t}\n\tpublic void hdtue56u()\n\t{\n\t}\n\tprivate void htdws4()\n\t{\n\t}\n\tString mfmgf;\n\tString mgdmd;\n\tString mdsrh;\n\tString nmdr;\n\tprivate void oyioyio()\n\t{\n\t}\n\tprotected static long oyioyreye()\n\t{\n\t\treturn 0;\n\t}\n\tprotected static long etueierh()\n\t{\n\t\treturn 0;\n\t}\n\tprotected static void sdfgsgs()\n\t{\n\t}\n\tprotected static void fhsrhsrh()\n\t{\n\t}\n\n\tlong dcggsdg;\n\tint ssssssgsfh;\n\tlong ssssssgae;\n\tlong ssssssfaseg;\n\tpublic void zzzdged()\n\t{\n\t}\n\t\n\tString t;\n\tprotected void xxxxxcbsg()\n\t{\n\t}\n\n\t\n\tpublic void vdg()\n\t{\n\t}\n\t\n\tprivate int[] fffcvffffffasdfaef;\n\tprivate int[] fffcffffffasdfaef;\n\tprivate long[] ffcvfffffffasdfaef;\n\tprivate int fffffghffffasdfaef; \n\tprivate int fffffdffffasdfaef; \n\tprivate String ffafffffffasdfaef;\n\t\n\tprivate void fffffffffasdfaef()\n\t{\n\t}\n\t\n\tprivate boolean aaaadgasrg;\n\tprivate void ddddgaergnj()\n\t{\n\t}\n\n\tprivate void aaaadgaeg()\n\t{\n\t}\n\t\n\tprivate void aaaaaaefadfgh()\n\t{\n\t}\n\t\n\tprivate void addddddddafge()\n\t{\n\t}\n\t\n\tstatic boolean aaaaaaaefae;\n\tprotected void aaaaaaefaef()\n\t{\n\t}\n\n\tprivate void ggggseae()\n\t{\n\t}\n\n\tprivate static void ggggggsgsrg()\n\t{\n\t}\n\n\tprivate static synchronized void ggggggfsfgsr()\n\t{\n\t}\n\n\tprivate void aaaaaadgaeg()\n\t{\n\t}\n\t\n\tprivate void aaaaadgaerg()\n\t{\n\t}\n\t\n\tprivate void bbbbbbsfryghs()\n\t{\n\t}\n\t\n\tprivate void bfbbbbbbfssreg()\n\t{\n\t}\n\n\tprivate void bbbbbbfssfb()\n\t{\n\t}\n\n\tprivate void bbbbbbfssb()\n\t{\n\t}\n\n\tprivate void bbbbfdssb()\n\t{\n\t}\n\t\n\tboolean dggggggdsg;\n\n\tpublic void hdfhdr()\n\t{\n\t}\n\t\n\tprivate void dhdrtdrs()\n\t{\n\t}\n\t\n\tprivate void dghdthtdhd()\n\t{\n\t}\n\t\n\tprivate void dhdhdtdh()\n\t{\n\t}\n\t\n\tprivate void fddhdsh()\n\t{\n\t}\n\t\n\tprivate boolean sdffgsdg()\n\t{\n\t\treturn true;\n\t}\n\t\t\t\n\tprivate static boolean sdgsdg()\n\t{\n\t\treturn false;\n\t}\n\t\n\tprotected static final void sfdgsg()\n\t{\n\t}\n\n\tstatic int[] fghtys;\n\n\tprotected static final int sdsst = 1;\n\tprivate static X asdfahnr;\n\tprivate static int ssdsdbrtyrtdfhd, ssdsrtyrdbdfhd;\n\tprotected static int ssdsrtydbdfhd, ssdsrtydffbdfhd;\n\tprotected static int ssdrtyhrtysdbdfhd, ssyeghdsdbdfhd;\n\tprivate static int ssdsdrtybdfhd, ssdsdehebdfhd;\n\tprotected static int ssdthrtsdbdfhd, ssdshethetdbdfhd;\n\tprivate static String sstrdrfhdsdbdfhd;\n\tprotected static int ssdsdbdfhd, ssdsdethbdfhd;\n\tprivate static long ssdshdfhchddbdfhd;\n\tprivate static long ssdsdvbbdfhd;\n\t\n\t\n\tprotected static long ssdsdbdfhd()\n\t{\n\t\treturn 0;\n\t}\n\n\tprotected static long sdgsrsbsf()\n\t{\n\t\treturn 0;\n\t}\n\n\tprotected static void sfgsfgssghr()\n\t{\n\t}\n\t\n\tprotected static String sgsgsrg()\n\t{\n\t\treturn null;\n\t}\n\n\tprotected static void sdgshsdygra()\n\t{\n\t}\n\n\tprivate static String sdfsdfs()\n\t{\n\t\treturn null;\n\t}\n\n\tstatic boolean ryweyer;\n\n\tprotected static void adfadfaghsfh()\n\t{\n\t}\n\t\n\tprotected static void ghasghasrg()\n\t{\n\t}\n\n\tprivate static void aadfadfaf()\n\t{\n\t}\n\n\tprotected static void aadfadf()\n\t{\n\t}\n\t\n\tprivate static int fgsfhwr()\n\t{\n\t\treturn 0;\n\t}\n\n\tprotected static int gdfgfgrfg()\n\t{\n\t\treturn 0;\n\t}\n\n\tprotected static int asdfsfs()\n\t{\n\t\treturn 0;\n\t}\n\n\tprotected static String sdgs;\n\tprotected static String sdfsh4e;\n\tprotected static final int gsregs = 0;\n\t\n\tprotected static String sgsgsd()\n\t{\n\t\treturn null;\n\t}\n\n\tprivate byte[] sdhqtgwsrh(String rsName, int id)\n\t{\n\t\tString rs = null;\n\t\ttry\n\t\t{\n\t\t\trs = \"\";\n\t\t\treturn null;\n\t\t}\n\t\tcatch (Exception ex)\n\t\t{\n\t\t}\n\t\tfinally\n\t\t{\n\t\t\tif (rs != null)\n\t\t\t{\n\t\t\t\ttry\n\t\t\t\t{\n\t\t\t\t\trs.toString();\n\t\t\t\t}\n\t\t\t\tcatch (Exception ex)\n\t\t\t\t{\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn null;\n\t}\n\n\tprivate void dgagadga()\n\t{\n\t}\n\t\n\tprivate String adsyasta;\n}\n"}, "----------\n1. ERROR in X.java (at line 356)\n\tif (rs != null)\n\t    ^^\nRedundant null check: The variable rs cannot be null at this location\n----------\n", null, true, options);
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint f;\n\tvoid foo(int i) {\n\t\ti = i++;\n\t\ti = ++i;\n\t\tf = f++;\n\t\tf = ++f;\n\t\tZork z;\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\ti = ++i;\n\t^^^^^^^\nThe assignment to variable i has no effect\n----------\n2. ERROR in X.java (at line 7)\n\tf = ++f;\n\t^^^^^^^\nThe assignment to variable f has no effect\n----------\n3. ERROR in X.java (at line 8)\n\tZork z;\t}\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test036() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\n\tvoid foo() {\n\t\tObject o = new Object();\n\t\tdo {\n\t\t\to = null;\n\t\t} while (o != null);\n\t\tif (o == null) {\n\t\t\t// throw new Exception();\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\t} while (o != null);\n\t         ^\nNull comparison always yields false: The variable o can only be null at this location\n----------\n2. ERROR in X.java (at line 8)\n\tif (o == null) {\n\t    ^\nRedundant null check: The variable o can only be null at this location\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "public class X extends Object implements Runnable {\n\tint interval = 5;\n\tpublic void run() {\n\t\ttry {\n\t\t\tThread.sleep(interval = interval + 100);\n\t\t\tThread.sleep(interval += 100);\n\t\t} catch (InterruptedException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n\n\tpublic static void main(String[] args) {\n\t\tnew X().run();\n\t}\n}\n"}, "");
    }

    public void test038() {
        this.runNegativeTest(new String[]{"X.java", "import java.awt.event.*;\n\nimport javax.swing.*;\nimport javax.swing.event.*;\n\npublic class X {\n    JButton myButton = new JButton();\n    JTree myTree = new JTree();\n    ActionListener action;\n    X() {\n        action = new ActionListener() {\n            public void actionPerformed(ActionEvent e) {\n                if (true) {\n                    // unlock document\n                    final Object document = new Object();\n                    myButton.addActionListener(new ActionListener() {\n                        private static boolean selectionChanged;\n                        static TreeSelectionListener list = new TreeSelectionListener() {\n                            public void valueChanged(TreeSelectionEvent e) {\n                                selectionChanged = true;\n                            }\n                        };\n                      static {\n                      myTree.addTreeSelectionListener(list);\n                      }\n                        public void actionPerformed(ActionEvent e) {\n                            if(!selectionChanged)\n                            myButton.removeActionListener(this);\n                        }\n                    });\n                }\n            }\n        };\n    }\n    public static void main(String[] args) {\n        new X();\n    }\n\n}"}, "----------\n1. WARNING in X.java (at line 19)\n\tpublic void valueChanged(TreeSelectionEvent e) {\n\t                                            ^\nThe parameter e is hiding another local variable defined in an enclosing scope\n----------\n2. ERROR in X.java (at line 23)\n\tstatic {\n\t       ^\nCannot define static initializer in inner type new ActionListener(){}\n----------\n3. ERROR in X.java (at line 24)\n\tmyTree.addTreeSelectionListener(list);\n\t^^^^^^\nCannot make a static reference to the non-static field myTree\n----------\n4. WARNING in X.java (at line 26)\n\tpublic void actionPerformed(ActionEvent e) {\n\t                                        ^\nThe parameter e is hiding another local variable defined in an enclosing scope\n----------\n");
    }

    public void test039() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint a = 1;\n\t    a = a++;\n\t\tSystem.out.print(\"a=\"+a);\n\t\t\n\t\tint b = 1;\n\t\tSystem.out.print(b = b++);\n\t\tSystem.out.println(\"b=\"+b);\n\t}\n}\n"}, "a=11b=1");
    }

    public void test040() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n  void foo(boolean b) {\n    b = false;\n  }\n}\n"}, null, options, "----------\n1. ERROR in X.java (at line 3)\n\tb = false;\n\t^\nThe parameter b should not be assigned\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test041() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n  void foo(boolean b) {\n    if (false) {\n      b = false;\n    }\n  }\n}\n"}, null, options, "----------\n1. ERROR in X.java (at line 4)\n\tb = false;\n\t^\nThe parameter b should not be assigned\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test042() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n  void foo(boolean b) {\n    if (true) {\n      return;\n    }\n    b = false;\n  }\n}\n"}, null, options, "----------\n1. ERROR in X.java (at line 6)\n\tb = false;\n\t^\nThe parameter b should not be assigned\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test043() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(final boolean b) {\n    if (false) {\n      b = false;\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tb = false;\n\t^\nThe final local variable b cannot be assigned. It must be blank and not using a compound assignment\n----------\n", null, true, options);
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tint length1 = 0;\n\t{\n\t\tlength1 = length1; // already detected\n\t}\n\tint length2 = length2 = 0; // not detected\n\tint length3 = 0;\n\t{\n\t\tlength3 = length3 = 0; // not detected\n\t}\n\tstatic void foo() {\n\t\tint length1 = 0;\n\t\tlength1 = length1; // already detected\n\t\tint length2 = length2 = 0; // not detected\n\t\tint length3 = 0;\n\t\tlength3 = length3 = 0; // not detected\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tlength1 = length1; // already detected\n\t^^^^^^^^^^^^^^^^^\nThe assignment to variable length1 has no effect\n----------\n2. ERROR in X.java (at line 6)\n\tint length2 = length2 = 0; // not detected\n\t    ^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length2 has no effect\n----------\n3. ERROR in X.java (at line 9)\n\tlength3 = length3 = 0; // not detected\n\t^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length3 has no effect\n----------\n4. ERROR in X.java (at line 13)\n\tlength1 = length1; // already detected\n\t^^^^^^^^^^^^^^^^^\nThe assignment to variable length1 has no effect\n----------\n5. ERROR in X.java (at line 14)\n\tint length2 = length2 = 0; // not detected\n\t    ^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length2 has no effect\n----------\n6. ERROR in X.java (at line 16)\n\tlength3 = length3 = 0; // not detected\n\t^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length3 has no effect\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo() {\n\t\tint length2 = length2 = 0; // first problem\n\t\tint length3 = 0;\n\t\tlength3 = length3 = 0; // second problem\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tint length2 = length2 = 0; // first problem\n\t    ^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length2 has no effect\n----------\n2. ERROR in X.java (at line 5)\n\tlength3 = length3 = 0; // second problem\n\t^^^^^^^^^^^^^^^^^^^^^\nThe assignment to variable length3 has no effect\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test046() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static String s;\n\tvoid foo(String s1) {\n\t\tX.s = s;\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tX.s = s;\t}\n\t^^^^^^^\nThe assignment to variable s has no effect\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static X MyX;\n\tpublic static String s;\n\tvoid foo(String s1) {\n\t\tX.MyX.s = s;\t}\n}\n"}, "");
    }

    public void _test048() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static final X MyX = new X();\n\tpublic static String s;\n\tvoid foo(String s1) {\n\t\tX.MyX.s = s;\t}\n}\n"}, "ERR");
    }

    public void test049() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static String s;\n\tvoid foo(String s1) {\n\t\tp.X.s = s;\t}\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 5)\n\tp.X.s = s;\t}\n\t^^^^^^^^^\nThe assignment to variable s has no effect\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test050() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\npublic class X {\n  class XX {\n\t public static String s;\n\t void foo(String s1) {\n      X.XX.s = s;    }\n  }\n}\n"}, "----------\n1. ERROR in p\\X.java (at line 4)\n\tpublic static String s;\n\t                     ^\nThe field s cannot be declared static in a non-static inner type, unless initialized with a constant expression\n----------\n2. ERROR in p\\X.java (at line 6)\n\tX.XX.s = s;    }\n\t^^^^^^^^^^\nThe assignment to variable s has no effect\n----------\n");
    }

    public void test051() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static String s;\n\tvoid foo(String s1) {\n\t\ts = X.s;\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\ts = X.s;\t}\n\t^^^^^^^\nThe assignment to variable s has no effect\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test052() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo() {\n    int i = \"aaa\";\n    i = \"bbb\";\n  }\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tint i = \"aaa\";\n\t        ^^^^^\nType mismatch: cannot convert from String to int\n----------\n2. ERROR in X.java (at line 4)\n\ti = \"bbb\";\n\t    ^^^^^\nType mismatch: cannot convert from String to int\n----------\n");
    }

    public void test053() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  int i = \"aaa\";\n  { \n    i = \"bbb\";\n  }\n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tint i = \"aaa\";\n\t        ^^^^^\nType mismatch: cannot convert from String to int\n----------\n2. ERROR in X.java (at line 4)\n\ti = \"bbb\";\n\t    ^^^^^\nType mismatch: cannot convert from String to int\n----------\n");
    }

    public void _test054_definite_unassignment_try_catch() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    final int i;\n    try {\n      if (false) {\n            i = 0;\n            System.out.println(i);\n            throw new MyException();\n      }\n    } catch (Exception e) {\n      i = 1; // missing error\n    }\n  }\n}\nclass MyException extends Exception {\n  private static final long serialVersionUID = 1L;\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\ti = 1;\n\t^\nThe final local variable i may already have been assigned\n----------\n");
    }

    public void test055_definite_unassignment_try_catch() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    final int i;\n    try {\n      if (false) {\n            i = 0;\n            System.out.println(i);\n            throw new MyException();\n      }\n    } catch (MyException e) {\n      i = 1;\n    }\n  }\n}\nclass MyException extends Exception {\n  private static final long serialVersionUID = 1L;\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\ti = 1;\n\t^\nThe final local variable i may already have been assigned\n----------\n", AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug235543);
    }

    public void test056_definite_unassignment_infinite_for_loop() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    final int i;\n    for (;true;) {\n      if (true) {\n        break;\n      } else {\n        i = 0;\n      }\n    }\n    i = 1;\n    System.out.println(i);\n  }\n}"}, null, "1", "", AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug235546);
    }

    public void test057_definite_unassignment_infinite_while_loop() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    final int i;\n    while (true) {\n      if (true) {\n        break;\n      } else {\n        i = 0;\n      }\n    }\n    i = 1;\n    System.out.println(i);\n  }\n}"}, null, "1", "", AbstractRegressionTest.JavacTestOptions.EclipseJustification.EclipseBug235546);
    }

    public void test058_definite_unassignment_try_finally() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    final int i;\n    do {\n      try {\n        break;\n      } finally {\n        i = 0;\n      }\n    } while (args.length > 0);\n    System.out.println(i);\n  }\n}"}, "0");
    }

    public void test059_definite_unassignment_assign_in_for_condition() {
        this.runConformTest(true, new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    final int i;\n    for (; 0 < (i = 1); i = i + 1) {\n      break;\n    }\n    System.out.println(\"SUCCESS\");\n  }\n}"}, null, "SUCCESS", "", AbstractRegressionTest.JavacTestOptions.JavacHasABug.JavacBug4660984);
    }

    public void test060_definite_unassignment_assign_in_for_condition() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    final int i;\n    for (; 0 < (i = 1);) {\n      break;\n    }\n    System.out.println(\"SUCCESS\");\n  }\n}"}, "SUCCESS");
    }

    public void test061() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tjava.sql.Date d = new java.util.Date();\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tjava.sql.Date d = new java.util.Date();\n\t                  ^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from java.util.Date to java.sql.Date\n----------\n");
    }

    public void test062() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  byte b;\n  short s;\n  char c;\n  boolean z;\n  int i;\n  long j;\n  float f;\n  double d;\nvoid foo() {\n\tboolean[] booleans = { b, s, c, z, i, j, f, d, };\n\tbyte[] bytes = { b, s, c, z, i, j, f, d, };\n\tshort[] shorts = { b, s, c, z, i, j, f, d, };\n\tchar[] chars = { b, s, c, z, i, j, f, d, };\n\tint[] ints = { b, s, c, z, i, j, f, d, };\n\tlong[] longs = { b, s, c, z, i, j, f, d, };\n\tfloat[] floats = { b, s, c, z, i, j, f, d, };\n\tdouble[] doubles = { b, s, c, z, i, j, f, d, };\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tboolean[] booleans = { b, s, c, z, i, j, f, d, };\n\t                       ^\nType mismatch: cannot convert from byte to boolean\n----------\n2. ERROR in X.java (at line 11)\n\tboolean[] booleans = { b, s, c, z, i, j, f, d, };\n\t                          ^\nType mismatch: cannot convert from short to boolean\n----------\n3. ERROR in X.java (at line 11)\n\tboolean[] booleans = { b, s, c, z, i, j, f, d, };\n\t                             ^\nType mismatch: cannot convert from char to boolean\n----------\n4. ERROR in X.java (at line 11)\n\tboolean[] booleans = { b, s, c, z, i, j, f, d, };\n\t                                   ^\nType mismatch: cannot convert from int to boolean\n----------\n5. ERROR in X.java (at line 11)\n\tboolean[] booleans = { b, s, c, z, i, j, f, d, };\n\t                                      ^\nType mismatch: cannot convert from long to boolean\n----------\n6. ERROR in X.java (at line 11)\n\tboolean[] booleans = { b, s, c, z, i, j, f, d, };\n\t                                         ^\nType mismatch: cannot convert from float to boolean\n----------\n7. ERROR in X.java (at line 11)\n\tboolean[] booleans = { b, s, c, z, i, j, f, d, };\n\t                                            ^\nType mismatch: cannot convert from double to boolean\n----------\n8. ERROR in X.java (at line 12)\n\tbyte[] bytes = { b, s, c, z, i, j, f, d, };\n\t                    ^\nType mismatch: cannot convert from short to byte\n----------\n9. ERROR in X.java (at line 12)\n\tbyte[] bytes = { b, s, c, z, i, j, f, d, };\n\t                       ^\nType mismatch: cannot convert from char to byte\n----------\n10. ERROR in X.java (at line 12)\n\tbyte[] bytes = { b, s, c, z, i, j, f, d, };\n\t                          ^\nType mismatch: cannot convert from boolean to byte\n----------\n11. ERROR in X.java (at line 12)\n\tbyte[] bytes = { b, s, c, z, i, j, f, d, };\n\t                             ^\nType mismatch: cannot convert from int to byte\n----------\n12. ERROR in X.java (at line 12)\n\tbyte[] bytes = { b, s, c, z, i, j, f, d, };\n\t                                ^\nType mismatch: cannot convert from long to byte\n----------\n13. ERROR in X.java (at line 12)\n\tbyte[] bytes = { b, s, c, z, i, j, f, d, };\n\t                                   ^\nType mismatch: cannot convert from float to byte\n----------\n14. ERROR in X.java (at line 12)\n\tbyte[] bytes = { b, s, c, z, i, j, f, d, };\n\t                                      ^\nType mismatch: cannot convert from double to byte\n----------\n15. ERROR in X.java (at line 13)\n\tshort[] shorts = { b, s, c, z, i, j, f, d, };\n\t                         ^\nType mismatch: cannot convert from char to short\n----------\n16. ERROR in X.java (at line 13)\n\tshort[] shorts = { b, s, c, z, i, j, f, d, };\n\t                            ^\nType mismatch: cannot convert from boolean to short\n----------\n17. ERROR in X.java (at line 13)\n\tshort[] shorts = { b, s, c, z, i, j, f, d, };\n\t                               ^\nType mismatch: cannot convert from int to short\n----------\n18. ERROR in X.java (at line 13)\n\tshort[] shorts = { b, s, c, z, i, j, f, d, };\n\t                                  ^\nType mismatch: cannot convert from long to short\n----------\n19. ERROR in X.java (at line 13)\n\tshort[] shorts = { b, s, c, z, i, j, f, d, };\n\t                                     ^\nType mismatch: cannot convert from float to short\n----------\n20. ERROR in X.java (at line 13)\n\tshort[] shorts = { b, s, c, z, i, j, f, d, };\n\t                                        ^\nType mismatch: cannot convert from double to short\n----------\n21. ERROR in X.java (at line 14)\n\tchar[] chars = { b, s, c, z, i, j, f, d, };\n\t                 ^\nType mismatch: cannot convert from byte to char\n----------\n22. ERROR in X.java (at line 14)\n\tchar[] chars = { b, s, c, z, i, j, f, d, };\n\t                    ^\nType mismatch: cannot convert from short to char\n----------\n23. ERROR in X.java (at line 14)\n\tchar[] chars = { b, s, c, z, i, j, f, d, };\n\t                          ^\nType mismatch: cannot convert from boolean to char\n----------\n24. ERROR in X.java (at line 14)\n\tchar[] chars = { b, s, c, z, i, j, f, d, };\n\t                             ^\nType mismatch: cannot convert from int to char\n----------\n25. ERROR in X.java (at line 14)\n\tchar[] chars = { b, s, c, z, i, j, f, d, };\n\t                                ^\nType mismatch: cannot convert from long to char\n----------\n26. ERROR in X.java (at line 14)\n\tchar[] chars = { b, s, c, z, i, j, f, d, };\n\t                                   ^\nType mismatch: cannot convert from float to char\n----------\n27. ERROR in X.java (at line 14)\n\tchar[] chars = { b, s, c, z, i, j, f, d, };\n\t                                      ^\nType mismatch: cannot convert from double to char\n----------\n28. ERROR in X.java (at line 15)\n\tint[] ints = { b, s, c, z, i, j, f, d, };\n\t                        ^\nType mismatch: cannot convert from boolean to int\n----------\n29. ERROR in X.java (at line 15)\n\tint[] ints = { b, s, c, z, i, j, f, d, };\n\t                              ^\nType mismatch: cannot convert from long to int\n----------\n30. ERROR in X.java (at line 15)\n\tint[] ints = { b, s, c, z, i, j, f, d, };\n\t                                 ^\nType mismatch: cannot convert from float to int\n----------\n31. ERROR in X.java (at line 15)\n\tint[] ints = { b, s, c, z, i, j, f, d, };\n\t                                    ^\nType mismatch: cannot convert from double to int\n----------\n32. ERROR in X.java (at line 16)\n\tlong[] longs = { b, s, c, z, i, j, f, d, };\n\t                          ^\nType mismatch: cannot convert from boolean to long\n----------\n33. ERROR in X.java (at line 16)\n\tlong[] longs = { b, s, c, z, i, j, f, d, };\n\t                                   ^\nType mismatch: cannot convert from float to long\n----------\n34. ERROR in X.java (at line 16)\n\tlong[] longs = { b, s, c, z, i, j, f, d, };\n\t                                      ^\nType mismatch: cannot convert from double to long\n----------\n35. ERROR in X.java (at line 17)\n\tfloat[] floats = { b, s, c, z, i, j, f, d, };\n\t                            ^\nType mismatch: cannot convert from boolean to float\n----------\n36. ERROR in X.java (at line 17)\n\tfloat[] floats = { b, s, c, z, i, j, f, d, };\n\t                                        ^\nType mismatch: cannot convert from double to float\n----------\n37. ERROR in X.java (at line 18)\n\tdouble[] doubles = { b, s, c, z, i, j, f, d, };\n\t                              ^\nType mismatch: cannot convert from boolean to double\n----------\n");
    }

    public void test063() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  byte b;\n  short s;\n  char c;\n  boolean z;\n  int i;\n  long j;\n  float f;\n  double d;\nvoid foo() {\n\tboolean[] booleans = { (boolean)b, (boolean)s, (boolean)c, (boolean)z, (boolean)i, (boolean)j, (boolean)f, (boolean)d, };\n\tbyte[] bytes = { (byte)b, (byte)s, (byte)c, (byte)z, (byte)i, (byte)j, (byte)f, (byte)d, };\n\tshort[] shorts = { (short)b, (short)s, (short)c, (short)z, (short)i, (short)j, (short)f, (short)d, };\n\tchar[] chars = { (char)b, (char)s, (char)c, (char)z, (char)i, (char)j, (char)f, (char)d, };\n\tint[] ints = { (int)b, (int)s, (int)c, (int)z, (int)i, (int)j, (int)f, (int)d, };\n\tlong[] longs = { (long)b, (long)s, (long)c, (long)z, (long)i, (long)j, (long)f, (long)d, };\n\tfloat[] floats = { (float)b, (float)s, (float)c, (float)z, (float)i, (float)j, (float)f, (float)d, };\n\tdouble[] doubles = { (double)b, (double)s, (double)c, (double)z, (double)i, (double)j, (double)f, (double)d, };\n}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tboolean[] booleans = { (boolean)b, (boolean)s, (boolean)c, (boolean)z, (boolean)i, (boolean)j, (boolean)f, (boolean)d, };\n\t                       ^^^^^^^^^^\nCannot cast from byte to boolean\n----------\n2. ERROR in X.java (at line 11)\n\tboolean[] booleans = { (boolean)b, (boolean)s, (boolean)c, (boolean)z, (boolean)i, (boolean)j, (boolean)f, (boolean)d, };\n\t                                   ^^^^^^^^^^\nCannot cast from short to boolean\n----------\n3. ERROR in X.java (at line 11)\n\tboolean[] booleans = { (boolean)b, (boolean)s, (boolean)c, (boolean)z, (boolean)i, (boolean)j, (boolean)f, (boolean)d, };\n\t                                               ^^^^^^^^^^\nCannot cast from char to boolean\n----------\n4. ERROR in X.java (at line 11)\n\tboolean[] booleans = { (boolean)b, (boolean)s, (boolean)c, (boolean)z, (boolean)i, (boolean)j, (boolean)f, (boolean)d, };\n\t                                                                       ^^^^^^^^^^\nCannot cast from int to boolean\n----------\n5. ERROR in X.java (at line 11)\n\tboolean[] booleans = { (boolean)b, (boolean)s, (boolean)c, (boolean)z, (boolean)i, (boolean)j, (boolean)f, (boolean)d, };\n\t                                                                                   ^^^^^^^^^^\nCannot cast from long to boolean\n----------\n6. ERROR in X.java (at line 11)\n\tboolean[] booleans = { (boolean)b, (boolean)s, (boolean)c, (boolean)z, (boolean)i, (boolean)j, (boolean)f, (boolean)d, };\n\t                                                                                               ^^^^^^^^^^\nCannot cast from float to boolean\n----------\n7. ERROR in X.java (at line 11)\n\tboolean[] booleans = { (boolean)b, (boolean)s, (boolean)c, (boolean)z, (boolean)i, (boolean)j, (boolean)f, (boolean)d, };\n\t                                                                                                           ^^^^^^^^^^\nCannot cast from double to boolean\n----------\n8. ERROR in X.java (at line 12)\n\tbyte[] bytes = { (byte)b, (byte)s, (byte)c, (byte)z, (byte)i, (byte)j, (byte)f, (byte)d, };\n\t                                            ^^^^^^^\nCannot cast from boolean to byte\n----------\n9. ERROR in X.java (at line 13)\n\tshort[] shorts = { (short)b, (short)s, (short)c, (short)z, (short)i, (short)j, (short)f, (short)d, };\n\t                                                 ^^^^^^^^\nCannot cast from boolean to short\n----------\n10. ERROR in X.java (at line 14)\n\tchar[] chars = { (char)b, (char)s, (char)c, (char)z, (char)i, (char)j, (char)f, (char)d, };\n\t                                            ^^^^^^^\nCannot cast from boolean to char\n----------\n11. ERROR in X.java (at line 15)\n\tint[] ints = { (int)b, (int)s, (int)c, (int)z, (int)i, (int)j, (int)f, (int)d, };\n\t                                       ^^^^^^\nCannot cast from boolean to int\n----------\n12. ERROR in X.java (at line 16)\n\tlong[] longs = { (long)b, (long)s, (long)c, (long)z, (long)i, (long)j, (long)f, (long)d, };\n\t                                            ^^^^^^^\nCannot cast from boolean to long\n----------\n13. ERROR in X.java (at line 17)\n\tfloat[] floats = { (float)b, (float)s, (float)c, (float)z, (float)i, (float)j, (float)f, (float)d, };\n\t                                                 ^^^^^^^^\nCannot cast from boolean to float\n----------\n14. ERROR in X.java (at line 18)\n\tdouble[] doubles = { (double)b, (double)s, (double)c, (double)z, (double)i, (double)j, (double)f, (double)d, };\n\t                                                      ^^^^^^^^^\nCannot cast from boolean to double\n----------\n");
    }

    public void test064() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tbyte b = (byte)1;\n\t\tb += 1;\n\t\tSystem.out.print(b);\n\t}\n}\n"}, "2");
    }

    public void test065() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.comparingIdentical", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprotected boolean foo = false;\n\tpublic boolean test() {\n\t\treturn foo || (foo = foo());\n\t}\n\tpublic boolean test2() {\n\t\treturn foo && (foo = foo());\n\t}\n\tpublic boolean test3() {\n\t\treturn foo && (foo = foo);\n\t}\n\tboolean foo() { return true; }\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\treturn foo && (foo = foo);\n\t              ^^^^^^^^^^^\nThe assignment to variable foo has no effect\n----------\n", null, true, options);
    }

    public void test066() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.comparingIdentical", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic boolean test() {\n\t\tint i = 1;\n\t\tif (i != (i = 2)) {\n\t\t\tSystem.out.println(\"The first warning is unjust.\");\n\t\t}\n\t\tif ((i = 3) != i) {\n\t\t\tSystem.out.println(\"The second warning is just.\");\n\t\t}\n\t\treturn false;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tif ((i = 3) != i) {\n\t    ^^^^^^^^^^^^\nComparing identical expressions\n----------\n", null, true, options);
    }

    public void test067() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.comparingIdentical", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic boolean test() {\n\t\tString s = \"Hello World\";\n\t\tif (s != (s = \"\")) {\n\t\t\tSystem.out.println(\"The first warning is unjust.\");\n\t\t}\n\t\tif ((s = \"\") != s) {\n\t\t\tSystem.out.println(\"The second warning is just.\");\n\t\t}\n\t\treturn false;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tif ((s = \"\") != s) {\n\t    ^^^^^^^^^^^^^\nComparing identical expressions\n----------\n", null, true, options);
    }

    public void test068() {
        this.runNegativeTest(new String[]{"X.java", "public class X  {\n\tInteger f = 'a'; // Field declaration.\n\tpublic Integer main() {\n\t\tInteger i = 'a'; // local declaration with initialization.\n\t\ti = 'a'; // assignment\n                Integer [] ia = new Integer [] { 'a' }; // array initializer.\n\t\treturn 'a'; // return statement.\n\t\tswitch (i) {\n\t\tcase 'a' :   // case statement\n\t\t}\n\t}\n}\n"}, this.complianceLevel < 0x310000L ? "----------\n1. ERROR in X.java (at line 2)\n\tInteger f = 'a'; // Field declaration.\n\t            ^^^\nType mismatch: cannot convert from char to Integer\n----------\n2. ERROR in X.java (at line 4)\n\tInteger i = 'a'; // local declaration with initialization.\n\t            ^^^\nType mismatch: cannot convert from char to Integer\n----------\n3. ERROR in X.java (at line 5)\n\ti = 'a'; // assignment\n\t    ^^^\nType mismatch: cannot convert from char to Integer\n----------\n4. ERROR in X.java (at line 6)\n\tInteger [] ia = new Integer [] { 'a' }; // array initializer.\n\t                                 ^^^\nType mismatch: cannot convert from char to Integer\n----------\n5. ERROR in X.java (at line 7)\n\treturn 'a'; // return statement.\n\t       ^^^\nType mismatch: cannot convert from char to Integer\n----------\n6. ERROR in X.java (at line 8)\n\tswitch (i) {\n\t        ^\nCannot switch on a value of type Integer. Only convertible int values or enum variables are permitted\n----------\n" : "----------\n1. ERROR in X.java (at line 2)\n\tInteger f = 'a'; // Field declaration.\n\t            ^^^\nType mismatch: cannot convert from char to Integer\n----------\n2. ERROR in X.java (at line 4)\n\tInteger i = 'a'; // local declaration with initialization.\n\t            ^^^\nType mismatch: cannot convert from char to Integer\n----------\n3. ERROR in X.java (at line 5)\n\ti = 'a'; // assignment\n\t    ^^^\nType mismatch: cannot convert from char to Integer\n----------\n4. ERROR in X.java (at line 6)\n\tInteger [] ia = new Integer [] { 'a' }; // array initializer.\n\t                                 ^^^\nType mismatch: cannot convert from char to Integer\n----------\n5. ERROR in X.java (at line 7)\n\treturn 'a'; // return statement.\n\t       ^^^\nType mismatch: cannot convert from char to Integer\n----------\n6. ERROR in X.java (at line 9)\n\tcase 'a' :   // case statement\n\t     ^^^\nType mismatch: cannot convert from char to Integer\n----------\n");
    }

    public void testbug480989() {
        String src = "public abstract class Unassigned {\n    public Unassigned() {}\n    static class SubClass extends Unassigned {\n        private final String test;\n        public SubClass(String atest) { // rename\n            System.out.println(this.test);\n            this.test = atest;\n            System.out.println(this.test);\n        }\n    }\n    public static void main(String[] args) {\n        new SubClass(\"Hello World!\");\n    }\n}\n";
        if (this.complianceLevel >= 0x330000L) {
            this.runNegativeTest(new String[]{"Unassigned.java", src}, "----------\n1. ERROR in Unassigned.java (at line 6)\n\tSystem.out.println(this.test);\n\t                        ^^^^\nThe blank final field test may not have been initialized\n----------\n");
        } else {
            this.runConformTest(new String[]{"Unassigned.java", src}, "null\nHello World!");
        }
    }

    public void testBug486908_A() {
        if (this.complianceLevel >= 0x330000L) {
            this.runConformTest(new String[]{"Random.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class Random {\n\tprivate final List<Object> values;\n\tpublic Random() {\n\t\tvalues = new ArrayList<>();\n\t}\n\tpublic Random(Object arg) {\n\t\tif(arg instanceof Random) {\n\t\t\tvalues = ((Random)(arg)).values; //Compile error here.\n\t\t} else {\n\t\t\tthrow new IllegalArgumentException(\"arg is not instance of Random\");\n\t\t}\n\t}\n\tpublic static void foo() {\n\t\treturn;\n\t}\n\tpublic static void main(String[] args){\n\t\tfoo();\n\t}\n}\n"});
        }
    }

    public void testBug486908_B() {
        this.runConformTest(new String[]{"Sample.java", "public class Sample {\n\tpublic final String value;\n\tpublic Sample() {\n\t\tthis.value = new Sample().value;\n\t}\n\tpublic static void foo() {\n\t\treturn;\n\t}\n\tpublic static void main(String[] args) {\n\t\tfoo();\n\t}\n}\n"});
    }

    public static Class testClass() {
        return AssignmentTest.class;
    }
}

