/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.compiler.regression.BatchCompilerTest;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;

public class ConcurrentBatchCompilerTest
extends BatchCompilerTest {
    Thread runner1;
    Thread runner2;
    static int COUNT = 100;

    public static Test suite() {
        return ConcurrentBatchCompilerTest.buildUniqueComplianceTestSuite(ConcurrentBatchCompilerTest.testClass(), 0x320000L);
    }

    public static Class testClass() {
        return ConcurrentBatchCompilerTest.class;
    }

    public ConcurrentBatchCompilerTest(String name) {
        super(name);
    }

    @Override
    protected boolean invokeCompiler(PrintWriter out, PrintWriter err, Object extraArguments, AbstractBatchCompilerTest.TestCompilationProgress compilationProgress) {
        boolean success = true;
        int j = 0;
        while (j < COUNT) {
            success &= super.invokeCompiler(out, err, extraArguments, compilationProgress);
            ++j;
        }
        return success;
    }

    @Override
    protected String testName() {
        Thread current = Thread.currentThread();
        String baseName = super.testName();
        if (current == this.runner1) {
            return String.valueOf(baseName) + "-Thread1";
        }
        if (current == this.runner2) {
            return String.valueOf(baseName) + "-Thread2";
        }
        return baseName;
    }

    public void testBug372319() throws Throwable {
        try {
            FakedTrackingVariable.TEST_372319 = true;
            final StringBuffer errorOutput = new StringBuffer();
            int j = 0;
            while (j < COUNT) {
                errorOutput.append("----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/test01/X.java (at line 12)\n\tFileReader reader = getReader(\"somefile\");\n\t           ^^^^^^\nPotential resource leak: 'reader' may not be closed\n----------\n1 problem (1 error)\n");
                ++j;
            }
            final Throwable[] thrown = new Throwable[2];
            this.runner1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConcurrentBatchCompilerTest.this.runConformTest(new String[]{"org/eclipse/jdt/internal/launching/CompositeId.java", "/*******************************************************************************\n * Copyright (c) 2000, 2014 IBM Corporation and others.\n * All rights reserved. This program and the accompanying materials\n * are made available under the terms of the Eclipse Public License v1.0\n * which accompanies this distribution, and is available at\n * http://www.eclipse.org/legal/epl-v10.html\n * \n * Contributors:\n *     IBM Corporation - initial API and implementation\n *******************************************************************************/\npackage org.eclipse.jdt.internal.launching;\n\nimport java.util.ArrayList;\n\n/**\n * Utility class for id's made of multiple Strings\n */\npublic class CompositeId {\n\tprivate String[] fParts;\n\t\n\tpublic CompositeId(String[] parts) {\n\t\tfParts= parts;\n\t}\n\t\n\tpublic static CompositeId fromString(String idString) {\n\t\tArrayList<String> parts= new ArrayList<String>();\n\t\tint commaIndex= idString.indexOf(',');\n\t\twhile (commaIndex > 0) {\n\t\t\tint length= Integer.valueOf(idString.substring(0, commaIndex)).intValue();\n\t\t\tString part= idString.substring(commaIndex+1, commaIndex+1+length);\n\t\t\tparts.add(part);\n\t\t\tidString= idString.substring(commaIndex+1+length);\n\t\t\tcommaIndex= idString.indexOf(',');\n\t\t}\n\t\tString[] result= parts.toArray(new String[parts.size()]);\n\t\treturn new CompositeId(result);\n\t}\n\t\n\t@Override\n\tpublic String toString() {\n\t\tStringBuffer buf= new StringBuffer();\n\t\tfor (int i= 0; i < fParts.length; i++) {\n\t\t\tbuf.append(fParts[i].length());\n\t\t\tbuf.append(',');\n\t\t\tbuf.append(fParts[i]);\n\t\t}\n\t\treturn buf.toString();\n\t}\n\t\n\tpublic String get(int index) {\n\t\treturn fParts[index];\n\t}\n\t\n\tpublic int getPartCount() {\n\t\treturn fParts.length;\n\t}\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "org/eclipse/jdt/internal/launching/CompositeId.java\"" + " -1.5 -g -preserveAllLocals" + " -proceedOnError -d \"" + OUTPUT_DIR + "\"", "", "", false);
                    }
                    catch (Throwable t) {
                        thrown[0] = t;
                    }
                }
            });
            this.runner2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Map<String, String> options = ConcurrentBatchCompilerTest.this.getCompilerOptions();
                        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
                        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
                        ConcurrentBatchCompilerTest.this.runNegativeTest(new String[]{"test01/X.java", "package test01;\nimport java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    FileReader getReader(String filename) throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n        return fileReader;\n    }\n    void foo() throws IOException {\n        FileReader reader = getReader(\"somefile\");\n        char[] in = new char[50];\n        reader.read(in);\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "test01/X.java\"" + " -1.5 -g -preserveAllLocals -err:+resource" + " -proceedOnError -d \"" + OUTPUT_DIR + "\"", "", errorOutput.toString(), false);
                    }
                    catch (Throwable t) {
                        thrown[1] = t;
                    }
                }
            });
            this.runner2.start();
            this.runner1.start();
            this.runner1.join();
            this.runner2.join();
            if (thrown[0] != null) {
                throw thrown[0];
            }
            if (thrown[1] != null) {
                throw thrown[1];
            }
        }
        finally {
            FakedTrackingVariable.TEST_372319 = false;
        }
    }
}

