/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ConditionalExpressionTest
extends AbstractRegressionTest {
    public ConditionalExpressionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ConditionalExpressionTest.buildAllCompliancesTestSuite(ConditionalExpressionTest.testClass());
    }

    public static Class testClass() {
        return ConditionalExpressionTest.class;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    final boolean isA = true;\n    public static void main(String[] args) {\n        X x = new X();\n        System.out.print(x.isA ? \"SUCCESS\" : \"FAILURE\");\n    }\n}"}, "SUCCESS");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "class RecipeElement {\n    public static final RecipeElement[] NO_CHILDREN= new RecipeElement[0]; \n}\nclass Ingredient extends RecipeElement { }\nclass X extends RecipeElement {\n    private Ingredient[] fIngredients;\n    public RecipeElement[] getChildren() {\n        return fIngredients == null ? NO_CHILDREN : fIngredients;\n    }\n}"}, "");
    }

    public void test003() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tboolean isOdd(boolean what) {\n\t\treturn square(what ? new Integer(1) : new Integer(2)) % 2 == 1; // trouble here\n\t}\n\t<T> int square(int i) {\n\t\treturn i * i;\n\t}\n\tpublic static void main(String argv[]) {\n\t\tSystem.out.println(new X().isOdd(true));\n\t}\n}\n"}, "true");
    }

    public void test004() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", "class A{/**/}\nclass B extends A {/**/}\nclass G<T> {\n\tG<B> gb=null;\n\tG<? super A> gsa=null;\n\tG<? super B> l = (true)? gsa : gb;\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tG<? super B> l = (true)? gsa : gb;\n\t                 ^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from G<capture#2-of ? extends Object> to G<? super B>\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", "class A{/**/}\nclass B extends A {/**/}\nclass G<T> {\n\tG<B> gb=null;\n\tG<? super A> gsa=null;\n\tG<? super B> l = (true)? gsa : gb;\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, "OK");
        }
    }

    public void test005() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        if (this.complianceLevel < 0x340000L) {
            this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String args[]) {\n    \tI<? super J> i = true ? (I<I>) null : (I<J>) null; // Type mismatch reported\n       System.out.println(\"OK\");\n    }\n}\ninterface I<T> {}\ninterface J<T> extends I<T> {}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tI<? super J> i = true ? (I<I>) null : (I<J>) null; // Type mismatch reported\n\t          ^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n2. ERROR in X.java (at line 3)\n\tI<? super J> i = true ? (I<I>) null : (I<J>) null; // Type mismatch reported\n\t                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from I<capture#1-of ? extends I> to I<? super J>\n----------\n3. WARNING in X.java (at line 3)\n\tI<? super J> i = true ? (I<I>) null : (I<J>) null; // Type mismatch reported\n\t                           ^\nI is a raw type. References to generic type I<T> should be parameterized\n----------\n4. WARNING in X.java (at line 3)\n\tI<? super J> i = true ? (I<I>) null : (I<J>) null; // Type mismatch reported\n\t                                         ^\nJ is a raw type. References to generic type J<T> should be parameterized\n----------\n");
        } else {
            this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String args[]) {\n    \tI<? super J> i = true ? (I<I>) null : (I<J>) null; // Type mismatch reported\n       System.out.println(\"OK\");\n    }\n}\ninterface I<T> {}\ninterface J<T> extends I<T> {}\n"}, "OK");
        }
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tstatic int foo(Object x) {\n\t\treturn 0;\n\t}\n\tstatic int foo(int e) { \n\t\treturn 1; \n\t}\n \tpublic static void main(String args[]) {\n \t\tObject x = new Object();\n\t\tSystem.out.println(foo(true ? x : new int[0]) != 0);\n\t}\n}\n"}, "false");
    }

    public void test007() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "interface BinaryOperation<T> {\n    T operate(T x, T y);\n}\nclass StringCatenation implements BinaryOperation<String> { \n    public String operate(String x, String y) { return x + y; }\n}\npublic class X {\n    public static void main(String argv[]) {\n    \tfoo(false ? (a,b)->a+b :new StringCatenation());\n    }\n    static void foo(BinaryOperation<Integer> x) {\n       x.operate(5, 15);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tfoo(false ? (a,b)->a+b :new StringCatenation());\n\t^^^\nThe method foo(BinaryOperation<Integer>) in the type X is not applicable for the arguments ((false ? (<no type> a, <no type> b) -> (a + b) : new StringCatenation()))\n----------\n2. ERROR in X.java (at line 9)\n\tfoo(false ? (a,b)->a+b :new StringCatenation());\n\t                        ^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from StringCatenation to BinaryOperation<Integer>\n----------\n");
    }

    public void test008() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "interface BinaryOperation<T> {\n    T operate(T x, T y);\n}\nclass StringCatenation implements BinaryOperation<String> { \n    public String operate(String x, String y) { return x + y; }\n}\npublic class X {\n    public static void main(String argv[]) {\n    \tfoo(false ? new StringCatenation() : (a,b)->a+b);\n    }\n    static void foo(BinaryOperation<Integer> x) {\n       x.operate(5, 15);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tfoo(false ? new StringCatenation() : (a,b)->a+b);\n\t^^^\nThe method foo(BinaryOperation<Integer>) in the type X is not applicable for the arguments ((false ? new StringCatenation() : (<no type> a, <no type> b) -> (a + b)))\n----------\n2. ERROR in X.java (at line 9)\n\tfoo(false ? new StringCatenation() : (a,b)->a+b);\n\t            ^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from StringCatenation to BinaryOperation<Integer>\n----------\n");
    }

    public void test009() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(test(1, X::intToSome));\n\t}\n\tstatic <T> Some test(T value, Function<T, Some> f) {\n\t\treturn (value == null) ? new Nothing() : f.apply(value);\n\t}\n\tstatic SomeInt intToSome(int i) {\n\t\treturn new SomeInt();\n\t}\n\tstatic abstract class Some {}\n\tstatic class SomeInt extends Some {\n\t    public String toString() {\n\t\t\treturn \"SomeInt instance\";\n        }\n   }\n\tstatic class Nothing extends Some {}\n}\n"}, "SomeInt instance");
    }

    public void test010() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(test(1, X::intToSome));\n\t}\n\tstatic <T> Some test(T value, Function<T, Some> f) {\n\t\treturn id((value == null) ? new Nothing<>() : f.apply(value));\n\t}\n\tstatic <T> T id(T t) {\n\t\treturn t;\n\t}\n\tstatic SomeInt intToSome(int i) {\n\t\treturn new SomeInt();\n\t}\n\tstatic abstract class Some {}\n\tstatic class SomeInt extends Some {\n\t    public String toString() {\n\t\treturn \"SomeInt instance\";\n            }\n        }\n\tstatic class Nothing<T> extends Some {}\n}\n"}, "SomeInt instance");
    }

    public void test011() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(test(1, X::intToSome));\n\t}\n\tstatic <T> Some test(T value, Function<T, Some> f) {\n\t\treturn (value == null) ? f.apply(value) : new Nothing();\n\t}\n\tstatic SomeInt intToSome(int i) {\n\t\treturn new SomeInt();\n\t}\n\tstatic abstract class Some {}\n\tstatic class SomeInt extends Some {\n\t    public String toString() {\n\t\t\treturn \"SomeInt instance\";\n        }\n   }\n\tstatic class Nothing<T> extends Some {\n\t    public String toString() {\n\t\t\treturn \"Nothing instance\";\n       }\n   }\n}\n"}, "Nothing instance");
    }

    public void test012() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(test(1, X::intToSome));\n\t}\n\tstatic <T> Some test(T value, Function<T, Some> f) {\n\t\treturn id((value == null) ? f.apply(value) : new Nothing<>());\n\t}\n\tstatic <T> T id(T t) {\n\t\treturn t;\n\t}\n\tstatic SomeInt intToSome(int i) {\n\t\treturn new SomeInt();\n\t}\n\tstatic abstract class Some {}\n\tstatic class SomeInt extends Some {\n\t    public String toString() {\n\t\treturn \"SomeInt instance\";\n            }\n        }\n\tstatic class Nothing<T> extends Some {\n\t    public String toString() {\n\t\t\treturn \"Nothing instance\";\n       }\n   }\n}\n"}, "Nothing instance");
    }

    public void test013() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(test(1, X::intToSome));\n\t}\n\tstatic <T> Some test(T value, Function<T, Some> f) {\n\t\treturn id((value == null) ? new Nothing<>() : f.apply(value));\n\t}\n\tstatic <T> T id(T t) {\n\t\treturn t;\n\t}\n\tstatic SomeInt intToSome(int i) {\n\t\treturn new SomeInt();\n\t}\n\tstatic interface Some {}\n\tstatic class SomeInt implements Some {\n\t\tpublic String toString() {\n\t\t\treturn \"SomeInt instance\";\n\t\t}\n\t}\n\tstatic class Nothing<T> implements Some {}\n}"}, "SomeInt instance");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic X(Class clazz) {\n\t}\n\tpublic void error() {\n\t\tboolean test = false;\n\t\tint i = 1;\n\t\tnew X(test ? (i == 2 ? D.class : E.class) : null);\n\t}\n\tpublic class D {\n\t}\n\tpublic class E {\n\t}\n}\n"}, this.complianceLevel < 0x310000L ? "" : "----------\n1. WARNING in X.java (at line 2)\n\tpublic X(Class clazz) {\n\t         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic X(Class clazz) {\n\t}\n\tpublic void error() {\n\t\tboolean test = false;\n\t\tint i = 1;\n\t\tnew X(test ? null : (i == 2 ? D.class : E.class));\n\t}\n\tpublic class D {\n\t}\n\tpublic class E {\n\t}\n}\n"}, this.complianceLevel < 0x310000L ? "" : "----------\n1. WARNING in X.java (at line 2)\n\tpublic X(Class clazz) {\n\t         ^^^^^\nClass is a raw type. References to generic type Class<T> should be parameterized\n----------\n");
    }

    public void test427625() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collection;\nimport java.util.List;\npublic class X {\n\tpublic void error(Collection<Object> c) {\n\t\tboolean b  =true;\n\t\tc.add(b ? new Integer(1)\n\t\t        : c==null ? null \n\t\t\t\t  : c instanceof List ? Integer.valueOf(1) \n\t\t\t\t                      : o()); \n\t}\n\tpublic Object o() {\n\t\treturn null;\n\t}\n}\n"}, "", null, true, options);
    }

    public void testBug432487() {
        this.runNegativeTest(new String[]{"X.java", "class Y {\n\tString f() {\n\t\treturn \"\";\n\t}\n}\npublic class X {\nvoid f(String x) {}\n\tvoid bar(Y y) {\n\t\tf(y.f2() == 1 ? null : y.f());\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tf(y.f2() == 1 ? null : y.f());\n\t    ^^\nThe method f2() is undefined for the type Y\n----------\n");
    }

    public void test437444_c113() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X extends Y {\n    public X(Z[] n) {\n        super((n == null) ? null : n.clone());\n    }\n}\nclass Y  {\n    public Y(Z[] notifications) {\n    }\n}\ninterface Z {}\n"}, "");
    }

    public void test484425() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"Main.java", "public class Main {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tif ((false) ? true: null);\n\t\t} catch(NullPointerException npe) {\n\t\t\tSystem.out.println(\"Success\");\n\t\t}\n\t}\n}\n"}, "Success");
    }
}

