/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ConstantTest
extends AbstractRegressionTest {
    public ConstantTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ConstantTest.buildAllCompliancesTestSuite(ConstantTest.testClass());
    }

    public void test001() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class  X { \npublic static void main (String args []) {\n  foo(); \n}\npublic static void foo() {\n  if(55f!=00000000000000000000055F)      // HERE VA/Java detects an unexpected error\n  {\nSystem.out.println(\"55f!=00000000000000000000055F\");\n  }\n  else\n  {\nSystem.out.println(\"55f==00000000000000000000055F\");\n  }\n }      \n}\n"});
    }

    public void test002() {
        this.runConformTest(new String[]{"p/X.java", "package p;\npublic class X {\n  public static void main (String args []) {\n    foo();\n  }\n  public static void foo() {\n    if(55f!=00000000000000000000055F)      // HERE VA/Java detects an unexpected error\n      {\n      System.out.println(\"55f!=00000000000000000000055F\");\n    }\n    else\n    {\n      System.out.println(\"55f==00000000000000000000055F\");\n    }\n  }      \n}\n"});
    }

    public void test003() {
        this.runConformTest(new String[]{"p/Z.java", "package p;\npublic class Z {\n  public static void main(String[] cargs) throws Exception {\n    System.out.println(System.getProperty(\"java.vm.info\", \"J9\"));\n    System.out.write((byte) 0x89);\n    System.out.println();\n    System.out.println(\"\u00e2?\u00b0\");\n    System.out.println(Integer.toHexString(\"\u00e2?\u00b0\".charAt(0)));\n  }\n}\n"});
    }

    public void test004() {
        this.runConformTest(new String[]{"TempClassFormat.java", "/**\n * Insert the type's description here.\n * Creation date: (02/28/01 2:58:07 PM)\n * @author: Administrator\n */\npublic class TempClassFormat {\n\t\t// ERROR NUMBERS\n\n\t// Blank field error numbers\n\tprivate static final String PERSON_ID_BLANK = \"2\";\n\tprivate static final String DEMOGRAPHIC_TYPE_BLANK = \"3\";\n\tprivate static final String EMPLOYEE_NUMBER_BLANK = \"23\";\n\tprivate static final String WORK_PHONE_AREA_CODE_BLANK = \"25\";\n\tprivate static final String WORK_PHONE1_BLANK = \"26\";\n\tprivate static final String WORK_PHONE2_BLANK = \"27\";\n\tprivate static final String WORK_ADDRESS1_BLANK = \"28\";\n\tprivate static final String WORK_CITY_BLANK = \"29\";\n\tprivate static final String WORK_STATE_BLANK = \"30\";\n\tprivate static final String WORK_ZIP5_BLANK = \"31\";\n\tprivate static final String BENEFITS_SALARY_BLANK = \"32\";\n\tprivate static final String TRUE_SALARY_BLANK = \"33\";\n\tprivate static final String PAY_FREQUENCY_BLANK = \"34\";\n\tprivate static final String WORK_HOURS_BLANK = \"35\";\n\tprivate static final String LOCATION_ID_BLANK = \"36\";\n\tprivate static final String SALARY_GRADE_BLANK = \"37\";\n\tprivate static final String DATE_OF_HIRE_BLANK = \"38\";\n\tprivate static final String RETIRE_VEST_PERCENT_BLANK = \"39\";\n\tprivate static final String JOB_CODE_BLANK = \"40\";\n\tprivate static final String UNION_FLAG_BLANK = \"41\";\n\tprivate static final String OFFICER_FLAG_BLANK = \"42\";\n\tprivate static final String PIN_USER_ID_BLANK = \"43\";\n\tprivate static final String VENDOR_EMPLOYEE_ID_BLANK = \"44\";\n\tprivate static final String MODIFIED_BY_BLANK = \"8\";\n\tprivate static final String MODIFIED_DATE_BLANK = \"9\";\n\t\n\t\n\t// Invalid field error numbers\n\tprivate static final String DEMOGRAPHIC_TYPE_INVALID = \"54\";\n\tprivate static final String EMPLOYER_ID_INVALID = \"22\";\n\tprivate static final String WORK_STATE_INVALID = \"70\";\n\tprivate static final String PAY_FREQUENCY_INVALID = \"138\";\n\tprivate static final String WORK_HOURS_TOO_SMALL = \"140\";\n\tprivate static final String DATE_OF_HIRE_INVALID = \"75\";\n\tprivate static final String DATE_OF_HIRE_AFTER_TODAY = \"137\";\n\tprivate static final String RETIRE_VEST_PERCENT_TOO_LARGE = \"77\";\n\tprivate static final String RETIRE_VEST_PERCENT_TOO_SMALL = \"139\";\n\tprivate static final String UNION_FLAG_INVALID = \"78\";\n\tprivate static final String OFFICER_FLAG_INVALID = \"79\";\n\tprivate static final String BENEFIT_GROUP_ID_INVALID = \"45\";\n\tprivate static final String LAST_PERSON_SEQ_NUMBER_INVALID = \"80\";\n\n\t// Field not numeric error numbers\n\tprivate static final String WORK_PHONE_AREA_CODE_NOT_NUMERIC = \"67\";\n\tprivate static final String WORK_PHONE1_NOT_NUMERIC = \"68\";\n\tprivate static final String WORK_PHONE2_NOT_NUMERIC = \"69\";\n\tprivate static final String WORK_PHONE_EXTENSION_NOT_NUMERIC = \"109\";\n\tprivate static final String WORK_ZIP5_NOT_NUMERIC = \"71\";\n\tprivate static final String WORK_ZIP4_NOT_NUMERIC = \"46\";\n\tprivate static final String BENEFITS_SALARY_NOT_NUMERIC = \"72\";\n\tprivate static final String TRUE_SALARY_NOT_NUMERIC = \"73\";\n\tprivate static final String WORK_HOURS_NOT_NUMERIC = \"74\";\n\tprivate static final String RETIRE_VEST_PERCENT_NOT_NUMERIC = \"76\";\n\t\n\t// Field too short error numbers\n\tprivate static final String WORK_PHONE_AREA_CODE_TOO_SHORT = \"110\";\n\tprivate static final String WORK_PHONE1_TOO_SHORT = \"111\";\n\tprivate static final String WORK_PHONE2_TOO_SHORT = \"112\";\n\tprivate static final String WORK_STATE_TOO_SHORT = \"113\";\n\tprivate static final String WORK_ZIP5_TOO_SHORT = \"114\";\n\tprivate static final String WORK_ZIP4_TOO_SHORT = \"115\";\n\n\t// Field too long error numbers\n\tprivate static final String PERSON_ID_TOO_LONG = \"82\";\n\tprivate static final String EMPLOYEE_NUMBER_TOO_LONG = \"116\";\n\tprivate static final String WORK_PHONE_AREA_CODE_TOO_LONG = \"117\";\n\tprivate static final String WORK_PHONE1_TOO_LONG = \"118\";\n\tprivate static final String WORK_PHONE2_TOO_LONG = \"119\";\n\tprivate static final String WORK_PHONE_EXTENSION_TOO_LONG = \"120\";\n\tprivate static final String WORK_ADDRESS1_TOO_LONG = \"121\";\n\tprivate static final String WORK_ADDRESS2_TOO_LONG = \"122\";\n\tprivate static final String WORK_CITY_TOO_LONG = \"123\";\n\tprivate static final String WORK_STATE_TOO_LONG = \"124\";\n\tprivate static final String WORK_ZIP5_TOO_LONG = \"125\";\n\tprivate static final String WORK_ZIP4_TOO_LONG = \"126\";\n\tprivate static final String BENEFITS_SALARY_TOO_LONG = \"127\";\n\tprivate static final String TRUE_SALARY_TOO_LONG = \"128\";\n\tprivate static final String WORK_HOURS_TOO_LONG = \"129\";\n\tprivate static final String LOCATION_ID_TOO_LONG = \"130\";\n\tprivate static final String SALARY_GRADE_TOO_LONG = \"131\";\n\tprivate static final String RETIRE_VEST_PERCENT_TOO_LONG = \"132\";\n\tprivate static final String JOB_CODE_TOO_LONG = \"133\";\n\tprivate static final String PIN_USER_ID_TOO_LONG = \"134\";\n\tprivate static final String VENDOR_EMPLOYEE_ID_TOO_LONG = \"135\";\n\tprivate static final String MODIFIED_BY_TOO_LONG = \"86\";\n\n\t// Administrator approval error numbers\n\tprivate static final String EMPLOYER_ID_REQ_APPR = \"623\";\n\tprivate static final String EMPLOYEE_NUMBER_REQ_APPR = \"624\";\n\tprivate static final String STATUS_FLAG_REQ_APPR = \"625\";\n\tprivate static final String WORK_PHONE_AREA_CODE_REQ_APPR = \"626\";\n\tprivate static final String WORK_PHONE1_REQ_APPR = \"627\";\n\tprivate static final String WORK_PHONE2_REQ_APPR = \"628\";\n\tprivate static final String WORK_PHONE_EXTENSION_REQ_APPR = \"629\";\n\tprivate static final String WORK_ADDRESS1_REQ_APPR = \"630\";\n\tprivate static final String WORK_ADDRESS2_REQ_APPR = \"631\";\n\tprivate static final String WORK_CITY_REQ_APPR = \"632\";\n\tprivate static final String WORK_STATE_REQ_APPR = \"633\";\n\tprivate static final String WORK_ZIP5_REQ_APPR = \"634\";\n\tprivate static final String WORK_ZIP4_REQ_APPR = \"635\";\n\tprivate static final String BENEFITS_SALARY_REQ_APPR = \"636\";\n\tprivate static final String TRUE_SALARY_REQ_APPR = \"637\";\n\tprivate static final String PAY_FREQUENCY_REQ_APPR = \"638\";\n\tprivate static final String WORK_HOURS_REQ_APPR = \"639\";\n\tprivate static final String LOCATION_ID_REQ_APPR = \"640\";\n\tprivate static final String SALARY_GRADE_REQ_APPR = \"641\";\n\tprivate static final String DATE_OF_HIRE_REQ_APPR = \"642\";\n\tprivate static final String RETIRE_VEST_PERCENT_REQ_APPR = \"643\";\n\tprivate static final String JOB_CODE_REQ_APPR = \"644\";\n\tprivate static final String UNION_FLAG_REQ_APPR = \"645\";\n\tprivate static final String OFFICER_FLAG_REQ_APPR = \"646\";\n\tprivate static final String PIN_USER_ID_REQ_APPR = \"647\";\n\tprivate static final String VENDOR_EMPLOYEE_ID_REQ_APPR = \"648\";\n\tprivate static final String BENEFIT_GROUP_ID_REQ_APPR = \"649\";\n\tprivate static final String LAST_PERSON_SEQ_NBR_REQ_APPR = \"650\";\n\t\npublic static void main(String[] args) {\n\t\tSystem.out.println(\"Success\");\n}\n}"}, "Success");
    }

    public void test005() {
        this.runConformTest(new String[]{"Code.java", "public class Code {\n  public static final String s = \"<clinit>\";\n  public static final String s2 = \"()V\";\n  public Code(int i) {\n  }\npublic static void main(String[] args) {\n  System.out.print(s.length());\n  System.out.println(s2.length());\n}\n}"}, "83");
    }

    public void test006() {
        this.runConformTest(new String[]{"p1/X.java", "package p1;\t\npublic class X {\t\n\tX otherX;\t\n\tstatic String STR = \"SUCCESS\";\t\n\tpublic static void main(String args[]) {\t\n\t\ttry {\t\n\t\t\tSystem.out.println(new X().otherX.STR);\t\n\t\t} catch(NullPointerException e){\t\n\t\t\tSystem.out.println(\"FAILED\");\t\n\t\t}\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static final boolean F = false;\t\n    public static final String Str = F ? \"dummy\" : null;\t\n    public static void main(String[] args) {\t\n        if (Str == null)\t\n        \tSystem.out.println(\"SUCCESS\");\t\n       \telse\t\n        \tSystem.out.println(\"FAILED\");\t\n    }\t\n}\t\n"}, "SUCCESS");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n      \tSystem.out.println(\"SUCCESS\");\t\n\t} \t\n\tvoid foo(){\t\n\t\twhile (null == null);\t//not an inlinable constant\n\t\tSystem.out.println(\"unreachable but shouldn't be flagged\");\t\n\t}\t\n}\t\n"}, "SUCCESS");
    }

    public void test009() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n        if (null == null) System.out.print(\"1\");\t\n        if ((null==null ? null:null) == (null==null ? null:null))\t\n        \tSystem.out.print(\"2\");\t\n\t\tboolean b = (\"[\" + null + \"]\") == \"[null]\";  // cannot inline\t\n\t\tSystem.out.print(\"3\");\t\n\t\tfinal String s = (String) null;\t\n\t\tif (s == null) System.out.print(\"4\");\t\n\t\tfinal String s2 = (String) \"aaa\";\t\n\t\tif (s2 == \"aaa\") System.out.println(\"5\");\t\n    }\t\n}"}, "12345");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 3, Locals: 4\n  public static void main(java.lang.String[] args);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  ldc <String \"1\"> [22]\n     5  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n     8  aconst_null\n     9  goto 13\n    12  aconst_null\n    13  aconst_null\n    14  goto 18\n    17  aconst_null\n    18  if_acmpne 29\n    21  getstatic java.lang.System.out : java.io.PrintStream [16]\n    24  ldc <String \"2\"> [30]\n    26  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    29  new java.lang.StringBuffer [32]\n    32  dup\n    33  ldc <String \"[\"> [34]\n    35  invokespecial java.lang.StringBuffer(java.lang.String) [36]\n    38  aconst_null\n    39  invokevirtual java.lang.StringBuffer.append(java.lang.Object) : java.lang.StringBuffer [38]\n    42  ldc <String \"]\"> [42]\n    44  invokevirtual java.lang.StringBuffer.append(java.lang.String) : java.lang.StringBuffer [44]\n    47  invokevirtual java.lang.StringBuffer.toString() : java.lang.String [47]\n    50  ldc <String \"[null]\"> [51]\n    52  if_acmpne 59\n    55  iconst_1\n    56  goto 60\n    59  iconst_0\n    60  istore_1 [b]\n    61  getstatic java.lang.System.out : java.io.PrintStream [16]\n    64  ldc <String \"3\"> [53]\n    66  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    69  aconst_null\n    70  astore_2 [s]\n    71  aload_2 [s]\n    72  ifnonnull 83\n    75  getstatic java.lang.System.out : java.io.PrintStream [16]\n    78  ldc <String \"4\"> [55]\n    80  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    83  ldc <String \"aaa\"> [57]\n    85  astore_3 [s2]\n    86  getstatic java.lang.System.out : java.io.PrintStream [16]\n    89  ldc <String \"5\"> [59]\n    91  invokevirtual java.io.PrintStream.println(java.lang.String) : void [61]\n    94  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 8, line: 4]\n        [pc: 21, line: 5]\n        [pc: 29, line: 6]\n        [pc: 61, line: 7]\n        [pc: 69, line: 8]\n        [pc: 71, line: 9]\n        [pc: 83, line: 10]\n        [pc: 86, line: 11]\n        [pc: 94, line: 12]\n      Local variable table:\n        [pc: 0, pc: 95] local: args index: 0 type: java.lang.String[]\n        [pc: 61, pc: 95] local: b index: 1 type: boolean\n        [pc: 71, pc: 95] local: s index: 2 type: java.lang.String\n        [pc: 86, pc: 95] local: s2 index: 3 type: java.lang.String\n";
        String expectedOutput15 = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 3, Locals: 4\n  public static void main(java.lang.String[] args);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  ldc <String \"1\"> [22]\n     5  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n     8  aconst_null\n     9  goto 13\n    12  aconst_null\n    13  aconst_null\n    14  goto 18\n    17  aconst_null\n    18  if_acmpne 29\n    21  getstatic java.lang.System.out : java.io.PrintStream [16]\n    24  ldc <String \"2\"> [30]\n    26  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    29  new java.lang.StringBuilder [32]\n    32  dup\n    33  ldc <String \"[\"> [34]\n    35  invokespecial java.lang.StringBuilder(java.lang.String) [36]\n    38  aconst_null\n    39  invokevirtual java.lang.StringBuilder.append(java.lang.Object) : java.lang.StringBuilder [38]\n    42  ldc <String \"]\"> [42]\n    44  invokevirtual java.lang.StringBuilder.append(java.lang.String) : java.lang.StringBuilder [44]\n    47  invokevirtual java.lang.StringBuilder.toString() : java.lang.String [47]\n    50  ldc <String \"[null]\"> [51]\n    52  if_acmpne 59\n    55  iconst_1\n    56  goto 60\n    59  iconst_0\n    60  istore_1 [b]\n    61  getstatic java.lang.System.out : java.io.PrintStream [16]\n    64  ldc <String \"3\"> [53]\n    66  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    69  aconst_null\n    70  astore_2 [s]\n    71  aload_2 [s]\n    72  ifnonnull 83\n    75  getstatic java.lang.System.out : java.io.PrintStream [16]\n    78  ldc <String \"4\"> [55]\n    80  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    83  ldc <String \"aaa\"> [57]\n    85  astore_3 [s2]\n    86  getstatic java.lang.System.out : java.io.PrintStream [16]\n    89  ldc <String \"5\"> [59]\n    91  invokevirtual java.io.PrintStream.println(java.lang.String) : void [61]\n    94  return\n      Line numbers:\n        [pc: 0, line: 3]\n        [pc: 8, line: 4]\n        [pc: 21, line: 5]\n        [pc: 29, line: 6]\n        [pc: 61, line: 7]\n        [pc: 69, line: 8]\n        [pc: 71, line: 9]\n        [pc: 83, line: 10]\n        [pc: 86, line: 11]\n        [pc: 94, line: 12]\n      Local variable table:\n        [pc: 0, pc: 95] local: args index: 0 type: java.lang.String[]\n        [pc: 61, pc: 95] local: b index: 1 type: boolean\n        [pc: 71, pc: 95] local: s index: 2 type: java.lang.String\n        [pc: 86, pc: 95] local: s2 index: 3 type: java.lang.String\n";
        if (this.complianceLevel >= 0x310000L) {
            int index = actualOutput.indexOf(expectedOutput15);
            if (index == -1 || expectedOutput15.length() == 0) {
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
            }
            if (index == -1) {
                ConstantTest.assertEquals("Wrong contents", expectedOutput15, actualOutput);
            }
        } else {
            int index = actualOutput.indexOf(expectedOutput);
            if (index == -1 || expectedOutput.length() == 0) {
                System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
            }
            if (index == -1) {
                ConstantTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
            }
        }
    }

    public void test010() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n    public static void main(String[] args) {\t\n       if (null == null) {\n\t\t\tSystem.out.print(\"SUCCESS\");\t\n\t\t\treturn;\t\n\t\t}\t\n\t\tSystem.out.print(\"SHOULDN'T BE GENERATED\");\t\n    }\t\n}\t\n"}, "SUCCESS");
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        byte[] classFileBytes = Util.getFileByteContent((File)new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class"));
        String actualOutput = disassembler.disassemble(classFileBytes, "\n", 1);
        String expectedOutput = "  // Method descriptor #15 ([Ljava/lang/String;)V\n  // Stack: 2, Locals: 1\n  public static void main(java.lang.String[] args);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  ldc <String \"SUCCESS\"> [22]\n     5  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n     8  return\n     9  getstatic java.lang.System.out : java.io.PrintStream [16]\n    12  ldc <String \"SHOULDN'T BE GENERATED\"> [30]\n    14  invokevirtual java.io.PrintStream.print(java.lang.String) : void [24]\n    17  return\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 8, line: 5]\n        [pc: 9, line: 7]\n        [pc: 17, line: 8]\n      Local variable table:\n        [pc: 0, pc: 18] local: args index: 0 type: java.lang.String[]\n";
        int index = actualOutput.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(actualOutput, 2));
        }
        if (index == -1) {
            ConstantTest.assertEquals("Wrong contents", expectedOutput, actualOutput);
        }
    }

    public void test011() {
        this.runConformTest(new String[]{"A.java", "public class A {\n    public static void main(String[] args) {\n\t\tSystem.out.print((01.f == 1) && (01e0f == 1));\t\n    }\n}"}, "true");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static String C = \"\" + +' ';\n    public static String I = \"\" + +32;\n\n    public static void main(String[] args) {\n        System.out.print(C);\n        System.out.print(I);\n    }\n}"}, "3232");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(-9223372036854775809L); // KO\n\t\tSystem.out.println(9223372036854775809L); // KO\n\t\tSystem.out.println(9223372036854775808L); // KO\n\t\tSystem.out.println(23092395825689123986L); // KO\n\t\tSystem.out.println(-9223372036854775808L); // OK\n\t\tSystem.out.println(9223372036854775807L); // OK\n\t\tSystem.out.println(2309239582568912398L); // OK\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tSystem.out.println(-9223372036854775809L); // KO\n\t                    ^^^^^^^^^^^^^^^^^^^^\nThe literal 9223372036854775809L of type long is out of range \n----------\n2. ERROR in X.java (at line 4)\n\tSystem.out.println(9223372036854775809L); // KO\n\t                   ^^^^^^^^^^^^^^^^^^^^\nThe literal 9223372036854775809L of type long is out of range \n----------\n3. ERROR in X.java (at line 5)\n\tSystem.out.println(9223372036854775808L); // KO\n\t                   ^^^^^^^^^^^^^^^^^^^^\nThe literal 9223372036854775808L of type long is out of range \n----------\n4. ERROR in X.java (at line 6)\n\tSystem.out.println(23092395825689123986L); // KO\n\t                   ^^^^^^^^^^^^^^^^^^^^^\nThe literal 23092395825689123986L of type long is out of range \n----------\n");
    }

    public void test014() throws Exception {
        if (this.complianceLevel > 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX fx;\n\tfinal static boolean DBG = false;\n\tvoid foo1(X x) {\n\t\tif (x.DBG) {\n\t\t\tboolean b = x.DBG;\n\t\t}\n\t\tboolean bb;\n\t\tif (bb = x.DBG) {\n\t\t\tboolean b = x.DBG;\n\t\t}\n\t}\n\tvoid foo2(X x) {\n\t\twhile (x.DBG) {\n\t\t\tboolean b = x.DBG;\n\t\t}\n\t}\n\tvoid foo3(X x) {\n\t\tfor (;x.DBG;) {\n\t\t\tboolean b = x.DBG;\n\t\t}\n\t}\n\tvoid foo4(X x) {\n\t\tboolean b = x.DBG ? x == null : x.DBG;\n\t}\n\tvoid foo5() {\n\t\tif (this.fx.DBG) {\n\t\t\tboolean b = this.fx.DBG;\n\t\t}\n\t}\n\tvoid foo6() {\n\t\twhile (this.fx.DBG) {\n\t\t\tboolean b = this.fx.DBG;\n\t\t}\n\t}\n\tvoid foo7() {\n\t\tfor (;this.fx.DBG;) {\n\t\t\tboolean b = this.fx.DBG;\n\t\t}\n\t}\n\tvoid foo8() {\n\t\tboolean b = this.fx.DBG ? this.fx == null : this.fx.DBG;\n\t}\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #20 (LX;)V\n  // Stack: 2, Locals: 4\n  void foo1(X x);\n    0  iconst_0\n    1  dup\n    2  istore_2 [bb]\n    3  ifeq 8\n    6  iconst_0\n    7  istore_3\n    8  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 6, line: 10]\n        [pc: 8, line: 12]\n      Local variable table:\n        [pc: 0, pc: 9] local: this index: 0 type: X\n        [pc: 0, pc: 9] local: x index: 1 type: X\n        [pc: 3, pc: 9] local: bb index: 2 type: boolean\n  \n  // Method descriptor #20 (LX;)V\n  // Stack: 0, Locals: 2\n  void foo2(X x);\n    0  return\n      Line numbers:\n        [pc: 0, line: 17]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n        [pc: 0, pc: 1] local: x index: 1 type: X\n  \n  // Method descriptor #20 (LX;)V\n  // Stack: 0, Locals: 2\n  void foo3(X x);\n    0  return\n      Line numbers:\n        [pc: 0, line: 22]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n        [pc: 0, pc: 1] local: x index: 1 type: X\n  \n  // Method descriptor #20 (LX;)V\n  // Stack: 1, Locals: 3\n  void foo4(X x);\n    0  iconst_0\n    1  istore_2 [b]\n    2  return\n      Line numbers:\n        [pc: 0, line: 24]\n        [pc: 2, line: 25]\n      Local variable table:\n        [pc: 0, pc: 3] local: this index: 0 type: X\n        [pc: 0, pc: 3] local: x index: 1 type: X\n        [pc: 2, pc: 3] local: b index: 2 type: boolean\n  \n  // Method descriptor #12 ()V\n  // Stack: 0, Locals: 1\n  void foo5();\n    0  return\n      Line numbers:\n        [pc: 0, line: 30]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n  \n  // Method descriptor #12 ()V\n  // Stack: 0, Locals: 1\n  void foo6();\n    0  return\n      Line numbers:\n        [pc: 0, line: 35]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n  \n  // Method descriptor #12 ()V\n  // Stack: 0, Locals: 1\n  void foo7();\n    0  return\n      Line numbers:\n        [pc: 0, line: 40]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n  \n  // Method descriptor #12 ()V\n  // Stack: 1, Locals: 2\n  void foo8();\n    0  iconst_0\n    1  istore_1 [b]\n    2  return\n      Line numbers:\n        [pc: 0, line: 42]\n        [pc: 2, line: 43]\n      Local variable table:\n        [pc: 0, pc: 3] local: this index: 0 type: X\n        [pc: 2, pc: 3] local: b index: 1 type: boolean\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            ConstantTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test015() throws Exception {
        if (this.complianceLevel > 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX fx;\n\tfinal static boolean DBG = false;\n\tvoid foo1(X x) {\n\t\tif (x.DBG) {\n\t\t\tboolean b = x.DBG;\n\t\t}\n\t\tboolean bb;\n\t\tif (bb = x.DBG) {\n\t\t\tboolean b = x.DBG;\n\t\t}\n\t}\n\tvoid foo2(X x) {\n\t\twhile (x.DBG) {\n\t\t\tboolean b = x.DBG;\n\t\t}\n\t}\n\tvoid foo3(X x) {\n\t\tfor (;x.DBG;) {\n\t\t\tboolean b = x.DBG;\n\t\t}\n\t}\n\tvoid foo4(X x) {\n\t\tboolean b = x.DBG ? x == null : x.DBG;\n\t}\n\tvoid foo5() {\n\t\tif (this.fx.DBG) {\n\t\t\tboolean b = this.fx.DBG;\n\t\t}\n\t}\n\tvoid foo6() {\n\t\twhile (this.fx.DBG) {\n\t\t\tboolean b = this.fx.DBG;\n\t\t}\n\t}\n\tvoid foo7() {\n\t\tfor (;this.fx.DBG;) {\n\t\t\tboolean b = this.fx.DBG;\n\t\t}\n\t}\n\tvoid foo8() {\n\t\tboolean b = this.fx.DBG ? this.fx == null : this.fx.DBG;\n\t}\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #20 (LX;)V\n  // Stack: 2, Locals: 4\n  void foo1(X x);\n    0  iconst_0\n    1  dup\n    2  istore_2 [bb]\n    3  ifeq 8\n    6  iconst_0\n    7  istore_3\n    8  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 6, line: 10]\n        [pc: 8, line: 12]\n      Local variable table:\n        [pc: 0, pc: 9] local: this index: 0 type: X\n        [pc: 0, pc: 9] local: x index: 1 type: X\n        [pc: 3, pc: 9] local: bb index: 2 type: boolean\n  \n  // Method descriptor #20 (LX;)V\n  // Stack: 0, Locals: 2\n  void foo2(X x);\n    0  return\n      Line numbers:\n        [pc: 0, line: 17]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n        [pc: 0, pc: 1] local: x index: 1 type: X\n  \n  // Method descriptor #20 (LX;)V\n  // Stack: 0, Locals: 2\n  void foo3(X x);\n    0  return\n      Line numbers:\n        [pc: 0, line: 22]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n        [pc: 0, pc: 1] local: x index: 1 type: X\n  \n  // Method descriptor #20 (LX;)V\n  // Stack: 1, Locals: 3\n  void foo4(X x);\n    0  iconst_0\n    1  istore_2 [b]\n    2  return\n      Line numbers:\n        [pc: 0, line: 24]\n        [pc: 2, line: 25]\n      Local variable table:\n        [pc: 0, pc: 3] local: this index: 0 type: X\n        [pc: 0, pc: 3] local: x index: 1 type: X\n        [pc: 2, pc: 3] local: b index: 2 type: boolean\n  \n  // Method descriptor #12 ()V\n  // Stack: 0, Locals: 1\n  void foo5();\n    0  return\n      Line numbers:\n        [pc: 0, line: 30]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n  \n  // Method descriptor #12 ()V\n  // Stack: 0, Locals: 1\n  void foo6();\n    0  return\n      Line numbers:\n        [pc: 0, line: 35]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n  \n  // Method descriptor #12 ()V\n  // Stack: 0, Locals: 1\n  void foo7();\n    0  return\n      Line numbers:\n        [pc: 0, line: 40]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n  \n  // Method descriptor #12 ()V\n  // Stack: 1, Locals: 2\n  void foo8();\n    0  iconst_0\n    1  istore_1 [b]\n    2  return\n      Line numbers:\n        [pc: 0, line: 42]\n        [pc: 2, line: 43]\n      Local variable table:\n        [pc: 0, pc: 3] local: this index: 0 type: X\n        [pc: 2, pc: 3] local: b index: 1 type: boolean\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            ConstantTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test016() throws Exception {
        if (this.complianceLevel > 0x310000L) {
            return;
        }
        this.runConformTest(new String[]{"X.java", "public class X {\n\tX fx;\n\tfinal static boolean DBG = false;\n\tvoid foo1(X x) {\n\t\tboolean b;\n\t\tif (false ? false : x.DBG) {\n\t\t\tboolean bb = x.DBG;\n\t\t}\n\t}\n\tvoid foo2(X x) {\n\t\tboolean b;\n\t\twhile (x == null ? x.DBG : x.DBG) {\n\t\t\tboolean bb = x.DBG;\n\t\t}\n\t}\n\tvoid foo3(X x) {\n\t\tboolean b;\n\t\tfor (;x == null ? x.DBG : x.DBG;) {\n\t\t\tboolean bb = x.DBG;\n\t\t}\n\t}\n\tvoid foo4(X x) {\n\t\tboolean bb = (x == null ? x.DBG :  x.DBG) ? x == null : x.DBG;\n\t}\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #20 (LX;)V\n  // Stack: 0, Locals: 2\n  void foo1(X x);\n    0  return\n      Line numbers:\n        [pc: 0, line: 9]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n        [pc: 0, pc: 1] local: x index: 1 type: X\n  \n  // Method descriptor #20 (LX;)V\n  // Stack: 1, Locals: 2\n  void foo2(X x);\n    0  aload_1 [x]\n    1  ifnonnull 4\n    4  return\n      Line numbers:\n        [pc: 0, line: 12]\n        [pc: 4, line: 15]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n        [pc: 0, pc: 5] local: x index: 1 type: X\n  \n  // Method descriptor #20 (LX;)V\n  // Stack: 1, Locals: 2\n  void foo3(X x);\n    0  aload_1 [x]\n    1  ifnonnull 4\n    4  return\n      Line numbers:\n        [pc: 0, line: 18]\n        [pc: 4, line: 21]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n        [pc: 0, pc: 5] local: x index: 1 type: X\n  \n  // Method descriptor #20 (LX;)V\n  // Stack: 1, Locals: 3\n  void foo4(X x);\n    0  aload_1 [x]\n    1  ifnonnull 4\n    4  iconst_0\n    5  istore_2 [bb]\n    6  return\n      Line numbers:\n        [pc: 0, line: 23]\n        [pc: 6, line: 24]\n      Local variable table:\n        [pc: 0, pc: 7] local: this index: 0 type: X\n        [pc: 0, pc: 7] local: x index: 1 type: X\n        [pc: 6, pc: 7] local: bb index: 2 type: boolean\n";
        File f = new File(String.valueOf(OUTPUT_DIR) + File.separator + "X.class");
        byte[] classFileBytes = Util.getFileByteContent((File)f);
        ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
        String result = disassembler.disassemble(classFileBytes, "\n", 1);
        int index = result.indexOf(expectedOutput);
        if (index == -1 || expectedOutput.length() == 0) {
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString(result, 3));
        }
        if (index == -1) {
            ConstantTest.assertEquals("Wrong contents", expectedOutput, result);
        }
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n\t\tint x = 2;\n       System.out.println(\"n: \"+(x > 1  ? 2 : 1.0));\n    }\n}"}, "n: 2.0");
    }

    public void test018() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n\t\tSystem.out.println(\"n: \"+(true ? 2 : 1.0));\n    }\n}"}, "n: 2.0");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    static class Enclosed {\n\t\t static final String constant = \"\";\n\t\t static final String notAConstant;\n        static {\n\t\t     notAConstant = null;\n        }\n    }\n}"}, "");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    class Inner {\n\t\t static final String constant = \"\";\n\t\t static final String notAConstant = null;\n    }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tstatic final String notAConstant = null;\n\t                    ^^^^^^^^^^^^\nThe field notAConstant cannot be declared static in a non-static inner type, unless initialized with a constant expression\n----------\n");
    }

    public void testAllConstants() {
        Constant byteConstant = ByteConstant.fromValue((byte)1);
        Constant byteConstant2 = ByteConstant.fromValue((byte)2);
        Constant byteConstant3 = ByteConstant.fromValue((byte)1);
        Constant charConstant = CharConstant.fromValue((char)'c');
        Constant charConstant2 = CharConstant.fromValue((char)'d');
        Constant charConstant3 = CharConstant.fromValue((char)'c');
        Constant booleanConstant = BooleanConstant.fromValue((boolean)true);
        Constant booleanConstant2 = BooleanConstant.fromValue((boolean)false);
        Constant booleanConstant3 = BooleanConstant.fromValue((boolean)true);
        Constant doubleConstant = DoubleConstant.fromValue((double)1.0);
        Constant doubleConstant2 = DoubleConstant.fromValue((double)2.0);
        Constant doubleConstant3 = DoubleConstant.fromValue((double)1.0);
        Constant floatConstant = FloatConstant.fromValue((float)1.0f);
        Constant floatConstant2 = FloatConstant.fromValue((float)2.0f);
        Constant floatConstant3 = FloatConstant.fromValue((float)1.0f);
        Constant intConstant = IntConstant.fromValue((int)20);
        Constant intConstant2 = IntConstant.fromValue((int)30);
        Constant intConstant3 = IntConstant.fromValue((int)20);
        Constant longConstant = LongConstant.fromValue((long)3L);
        Constant longConstant2 = LongConstant.fromValue((long)4L);
        Constant longConstant3 = LongConstant.fromValue((long)3L);
        Constant shortConstant = ShortConstant.fromValue((short)4);
        Constant shortConstant2 = ShortConstant.fromValue((short)3);
        Constant shortConstant3 = ShortConstant.fromValue((short)4);
        Constant stringConstant = StringConstant.fromValue((String)"test");
        Constant stringConstant2 = StringConstant.fromValue((String)"test2");
        Constant stringConstant3 = StringConstant.fromValue((String)"test");
        Constant stringConstant4 = StringConstant.fromValue(null);
        Constant stringConstant5 = StringConstant.fromValue(null);
        ClassSignature classSignature = new ClassSignature("java.lang.Object".toCharArray());
        ClassSignature classSignature2 = new ClassSignature("java.lang.String".toCharArray());
        ClassSignature classSignature3 = new ClassSignature("java.lang.Object".toCharArray());
        EnumConstantSignature enumConstantSignature = new EnumConstantSignature("myEnum".toCharArray(), "C".toCharArray());
        EnumConstantSignature enumConstantSignature2 = new EnumConstantSignature("myEnum".toCharArray(), "A".toCharArray());
        EnumConstantSignature enumConstantSignature3 = new EnumConstantSignature("myEnum".toCharArray(), "C".toCharArray());
        EnumConstantSignature enumConstantSignature4 = new EnumConstantSignature("myEnum2".toCharArray(), "A".toCharArray());
        this.verifyConstantEqualsAndHashcode(byteConstant, byteConstant2, byteConstant3, intConstant);
        this.verifyConstantEqualsAndHashcode(charConstant, charConstant2, charConstant3, byteConstant);
        this.verifyConstantEqualsAndHashcode(booleanConstant, booleanConstant2, booleanConstant3, byteConstant);
        this.verifyConstantEqualsAndHashcode(doubleConstant, doubleConstant2, doubleConstant3, byteConstant);
        this.verifyConstantEqualsAndHashcode(floatConstant, floatConstant2, floatConstant3, byteConstant);
        this.verifyConstantEqualsAndHashcode(intConstant, intConstant2, intConstant3, stringConstant);
        this.verifyConstantEqualsAndHashcode(longConstant, longConstant2, longConstant3, byteConstant);
        this.verifyConstantEqualsAndHashcode(shortConstant, shortConstant2, shortConstant3, byteConstant);
        this.verifyConstantEqualsAndHashcode(stringConstant, stringConstant2, stringConstant3, byteConstant);
        this.verifyConstantEqualsAndHashcode(stringConstant, stringConstant4, stringConstant3, byteConstant);
        this.verifyConstantEqualsAndHashcode(stringConstant4, stringConstant3, stringConstant5, byteConstant);
        this.verifyConstantEqualsAndHashcode(classSignature, classSignature2, classSignature3, byteConstant);
        this.verifyConstantEqualsAndHashcode(enumConstantSignature, enumConstantSignature2, enumConstantSignature3, byteConstant);
        this.verifyConstantEqualsAndHashcode(enumConstantSignature, enumConstantSignature4, enumConstantSignature3, byteConstant);
        ConstantTest.assertNotNull((Object)Constant.NotAConstant.toString());
        this.verifyValues(byteConstant, charConstant, booleanConstant, doubleConstant, floatConstant, intConstant, longConstant, shortConstant, stringConstant);
        ConstantTest.assertTrue((boolean)stringConstant4.equals(stringConstant5));
    }

    private void verifyValues(Constant byteConstant, Constant charConstant, Constant booleanConstant, Constant doubleConstant, Constant floatConstant, Constant intConstant, Constant longConstant, Constant shortConstant, Constant stringConstant) {
        byteConstant.byteValue();
        charConstant.byteValue();
        try {
            booleanConstant.byteValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        doubleConstant.byteValue();
        floatConstant.byteValue();
        intConstant.byteValue();
        longConstant.byteValue();
        shortConstant.byteValue();
        try {
            stringConstant.byteValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        try {
            byteConstant.booleanValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        try {
            charConstant.booleanValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        booleanConstant.booleanValue();
        try {
            doubleConstant.booleanValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        try {
            floatConstant.booleanValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        try {
            intConstant.booleanValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        try {
            longConstant.booleanValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        try {
            shortConstant.booleanValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        try {
            stringConstant.booleanValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        byteConstant.charValue();
        charConstant.charValue();
        try {
            booleanConstant.charValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        doubleConstant.charValue();
        floatConstant.charValue();
        intConstant.charValue();
        longConstant.charValue();
        shortConstant.charValue();
        try {
            stringConstant.charValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        byteConstant.doubleValue();
        charConstant.doubleValue();
        try {
            booleanConstant.doubleValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        doubleConstant.doubleValue();
        floatConstant.doubleValue();
        intConstant.doubleValue();
        longConstant.doubleValue();
        shortConstant.doubleValue();
        try {
            stringConstant.doubleValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        byteConstant.floatValue();
        charConstant.floatValue();
        try {
            booleanConstant.floatValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        doubleConstant.floatValue();
        floatConstant.floatValue();
        intConstant.floatValue();
        longConstant.floatValue();
        shortConstant.floatValue();
        try {
            stringConstant.floatValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        byteConstant.intValue();
        charConstant.intValue();
        try {
            booleanConstant.intValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        doubleConstant.intValue();
        floatConstant.intValue();
        intConstant.intValue();
        longConstant.intValue();
        shortConstant.intValue();
        try {
            stringConstant.intValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        byteConstant.longValue();
        charConstant.longValue();
        try {
            booleanConstant.longValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        doubleConstant.longValue();
        floatConstant.longValue();
        intConstant.longValue();
        longConstant.longValue();
        shortConstant.longValue();
        try {
            stringConstant.longValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        byteConstant.shortValue();
        charConstant.shortValue();
        try {
            booleanConstant.shortValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        doubleConstant.shortValue();
        floatConstant.shortValue();
        intConstant.shortValue();
        longConstant.shortValue();
        shortConstant.shortValue();
        try {
            stringConstant.shortValue();
            ConstantTest.assertTrue((boolean)false);
        }
        catch (ShouldNotImplement shouldNotImplement) {}
        byteConstant.stringValue();
        charConstant.stringValue();
        booleanConstant.stringValue();
        doubleConstant.stringValue();
        floatConstant.stringValue();
        intConstant.stringValue();
        longConstant.stringValue();
        shortConstant.stringValue();
        stringConstant.stringValue();
    }

    private void verifyConstantEqualsAndHashcode(Object o, Object o2, Object o3, Object o4) {
        ConstantTest.assertTrue((boolean)o.equals(o));
        ConstantTest.assertTrue((boolean)o.equals(o3));
        ConstantTest.assertFalse((boolean)o.equals(o2));
        ConstantTest.assertFalse((boolean)o.equals(o4));
        ConstantTest.assertFalse((boolean)o.equals(null));
        ConstantTest.assertFalse((o.hashCode() == o2.hashCode() ? 1 : 0) != 0);
        ConstantTest.assertNotNull((Object)o.toString());
        if (o instanceof Constant) {
            ConstantTest.assertTrue((String)"Not the same values", (boolean)((Constant)o).hasSameValue((Constant)o3));
            ConstantTest.assertFalse((String)"Have same values", (boolean)((Constant)o).hasSameValue((Constant)o2));
            ConstantTest.assertFalse((String)"Have same values", (boolean)((Constant)o).hasSameValue((Constant)o4));
        }
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x0L); // OK\n\t\tSystem.out.println(0x8000000000000000L); // OK\n\t\tSystem.out.println(0x8000000000000000l); // OK\n\t\tSystem.out.println(01000000000000000000000L); // OK\n\t\tSystem.out.println(01000000000000000000000l); // OK\n\t\tSystem.out.println(-9223372036854775808L); // OK\n\t\tSystem.out.println(-9223372036854775808l); // OK\n\t\tSystem.out.println(0x7fffffffffffffffL); // OK\n\t\tSystem.out.println(0x7fffffffffffffffl); // OK\n\t\tSystem.out.println(0777777777777777777777L); // OK\n\t\tSystem.out.println(0777777777777777777777l); // OK\n\t\tSystem.out.println(9223372036854775807L); // OK\n\t\tSystem.out.println(9223372036854775807l); // OK\n\t\tSystem.out.println(0xffffffffffffffffL); // OK\n\t\tSystem.out.println(0x0000000000000ffffffffffffffffL); // OK\n\t\tSystem.out.println(0xffffffffffffffffl); // OK\n\t\tSystem.out.println(01777777777777777777777L); // OK\n\t\tSystem.out.println(01777777777777777777777l); // OK\n\t\tSystem.out.println(-0x1L); // OK\n\t\tSystem.out.println(-0x1l); // OK\n\t\tSystem.out.println(0677777777777777777777L);\n\t\tSystem.out.println(0677777777777777777777l);\n\t\tSystem.out.println(0x0000000000000L); // OK\n\t\tSystem.out.println(0L); // OK\n\t}\n}"}, "0\n-9223372036854775808\n-9223372036854775808\n-9223372036854775808\n-9223372036854775808\n-9223372036854775808\n-9223372036854775808\n9223372036854775807\n9223372036854775807\n9223372036854775807\n9223372036854775807\n9223372036854775807\n9223372036854775807\n-1\n-1\n-1\n-1\n-1\n-1\n-1\n8070450532247928831\n8070450532247928831\n0\n0");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(0x0); // OK\n\t\tSystem.out.println(0x80000000); // OK\n\t\tSystem.out.println(020000000000); // OK\n\t\tSystem.out.println(-2147483648); // OK\n\t\tSystem.out.println(0x7fffffff); // OK\n\t\tSystem.out.println(017777777777); // OK\n\t\tSystem.out.println(2147483647); // OK\n\t\tSystem.out.println(0xffffffff); // OK\n\t\tSystem.out.println(0x0000000000000ffffffff); // OK\n\t\tSystem.out.println(037777777777); // OK\n\t\tSystem.out.println(-0x1); // OK\n\t\tSystem.out.println(0xDADACAFE);\n\t\tSystem.out.println(0x0000000000000); // OK\n\t}\n}"}, "0\n-2147483648\n-2147483648\n-2147483648\n2147483647\n2147483647\n2147483647\n-1\n-1\n-1\n-1\n-623195394\n0");
    }

    public static Class testClass() {
        return ConstantTest.class;
    }
}

