/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.HashMap;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class Deprecated9Test
extends AbstractRegressionTest {
    public Deprecated9Test(String name) {
        super(name);
    }

    public static Test suite() {
        return Deprecated9Test.buildMinimalComplianceTestSuite(Deprecated9Test.testClass(), 64);
    }

    public void test002() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "ignore");
        this.runNegativeTest(true, new String[]{"p/M1.java", "package p;\npublic class M1 {\n  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n", "a/N1.java", "package a;\npublic class N1 {\n  @Deprecated(since=\"1.2\",forRemoval=true)\n  public class N2 {    public void foo() {}    public class N3 {      public void foo() {}    }  }}\n"}, null, customOptions, "----------\n1. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t     ^^\nThe type N1.N2 has been deprecated since version 1.2 and marked for removal\n----------\n2. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t        ^^\nThe type N1.N2.N3 has been deprecated and marked for removal\n----------\n3. ERROR in p\\M1.java (at line 5)\n\tm.foo();\n\t  ^^^^^\nThe method foo() from the type N1.N2.N3 has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test002binary() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.nullReference", "ignore");
        runner.testFiles = new String[]{"a/N1.java", "package a;\npublic class N1 {\n  @Deprecated(since=\"1.2\",forRemoval=true)\n  public class N2 {    public void foo() {}    public class N3 {      public void foo() {}    }  }}\n"};
        runner.runConformTest();
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"p/M1.java", "package p;\npublic class M1 {\n  void bar() {\n    a.N1.N2.N3 m = null;\n    m.foo();\n  }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t     ^^\nThe type N1.N2 has been deprecated since version 1.2 and marked for removal\n----------\n2. ERROR in p\\M1.java (at line 4)\n\ta.N1.N2.N3 m = null;\n\t        ^^\nThe type N1.N2.N3 has been deprecated and marked for removal\n----------\n3. ERROR in p\\M1.java (at line 5)\n\tm.foo();\n\t  ^^^^^\nThe method foo() from the type N1.N2.N3 has been deprecated and marked for removal\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public void test004() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        this.runNegativeTest(true, new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t@Deprecated(forRemoval=true,since=\"3\")\n\tpublic static int x = 5, y= 10;\n}", "test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n}"}, null, customOptions, "----------\n1. ERROR in test1\\E02.java (at line 4)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x has been deprecated since version 3 and marked for removal\n----------\n2. ERROR in test1\\E02.java (at line 5)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y has been deprecated since version 3 and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005a() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        this.runNegativeTest(true, new String[]{"p1/X.java", "package p1;\npublic class X {\n    public static class Inner {        public void foo() {}\n    }\n}\n", "p1/package-info.java", "@java.lang.Deprecated(forRemoval=true)\npackage p1;\n", "p2/C.java", "package p2;\npublic class C {\n    void bar(p1.X.Inner a) {\n        a.foo();\n    }\n}\n"}, null, customOptions, "----------\n1. ERROR in p2\\C.java (at line 3)\n\tvoid bar(p1.X.Inner a) {\n\t            ^\nThe type X has been deprecated and marked for removal\n----------\n2. ERROR in p2\\C.java (at line 3)\n\tvoid bar(p1.X.Inner a) {\n\t              ^^^^^\nThe type X.Inner has been deprecated and marked for removal\n----------\n3. ERROR in p2\\C.java (at line 4)\n\ta.foo();\n\t  ^^^^^\nThe method foo() from the type X.Inner has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test005b() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "ignore");
        this.runConformTest(new String[]{"p1/X.java", "package p1;\npublic class X {\n    public static class Inner {        public void foo() {}\n    }\n}\n", "p1/package-info.java", "@java.lang.Deprecated(forRemoval=true)\npackage p1;\n", "p2/C.java", "package p2;\npublic class C {\n    void bar(p1.X.Inner a) {\n        a.foo();\n    }\n}\n"}, customOptions);
    }

    public void test005c() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "warning");
        runner.testFiles = new String[]{"p1/X.java", "package p1;\npublic class X {\n    public static class Inner {\n\t\t @java.lang.Deprecated(forRemoval=true)\n        public void foo() {}\n    }\n}\n", "p1/package-info.java", "@java.lang.Deprecated(forRemoval=false)\npackage p1;\n", "p2/C.java", "package p2;\npublic class C {\n\t @SuppressWarnings(\"deprecation\")\n    void bar(p1.X.Inner a) {\n        a.foo();\n    }\n}\n"};
        runner.expectedCompilerLog = "----------\n1. WARNING in p2\\C.java (at line 5)\n\ta.foo();\n\t  ^^^^^\nThe method foo() from the type X.Inner has been deprecated and marked for removal\n----------\n";
        runner.runWarningTest();
    }

    public void test006() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.testFiles = new String[]{"test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo(E01 arg) {\n\t\t// nop\n\t}\n}", "test1/E01.java", "package test1;\n@SuppressWarnings(\"all\") @Deprecated(since=\"4\")\npublic class E01 {\n\tpublic static int x = 5;\n}"};
        runner.expectedCompilerLog = "----------\n1. WARNING in test1\\E02.java (at line 3)\n\tpublic void foo(E01 arg) {\n\t                ^^^\nThe type E01 is deprecated since version 4\n----------\n";
        runner.runWarningTest();
    }

    public void test007() {
        HashMap<String, String> customOptions = new HashMap<String, String>();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        this.runNegativeTest(true, new String[]{"p1/X.java", "package p1;\npublic class X {\n\t @java.lang.Deprecated(forRemoval=false)\n    public void foo() {}\n\t @java.lang.Deprecated(forRemoval=true)\n\t public void bar() {}\n}\n", "p2/C.java", "package p2;\nimport p1.X;\npublic class C extends X {\n    @Override public void foo() {}\n    @Override public void bar() {}\n}\n"}, null, customOptions, "----------\n1. WARNING in p2\\C.java (at line 4)\n\t@Override public void foo() {}\n\t                      ^^^^^\nThe method C.foo() overrides a deprecated method from X\n----------\n2. ERROR in p2\\C.java (at line 5)\n\t@Override public void bar() {}\n\t                      ^^^^^\nThe method C.bar() overrides a method from X that has been deprecated and marked for removal\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void testSinceSource() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.testFiles = new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t@Deprecated(since=\"1.0\") protected static class Old {}\n\t@Deprecated(since=\"2\") public static int x = 5, y= 10;\n\t@Deprecated(since=\"3.0.0\") public E01() {}\n\t@Deprecated(since=\"4-SNAPSHOT\") protected void old() {}\n}", "test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(new E01.Old());\n\t\tE01 e = new E01();\n\t\te.old();\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n\tclass E03 extends E01 {\n\t\tprotected void old() {}\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. WARNING in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                       ^^^^^^^^^\nThe constructor E01.Old() is deprecated since version 1.0\n----------\n2. WARNING in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                           ^^^\nThe type E01.Old is deprecated since version 1.0\n----------\n3. WARNING in test1\\E02.java (at line 5)\n\tE01 e = new E01();\n\t            ^^^^^\nThe constructor E01() is deprecated since version 3.0.0\n----------\n4. WARNING in test1\\E02.java (at line 6)\n\te.old();\n\t  ^^^^^\nThe method old() from the type E01 is deprecated since version 4-SNAPSHOT\n----------\n5. WARNING in test1\\E02.java (at line 7)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x is deprecated since version 2\n----------\n6. WARNING in test1\\E02.java (at line 8)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y is deprecated since version 2\n----------\n7. WARNING in test1\\E02.java (at line 10)\n\tclass E03 extends E01 {\n\t      ^^^\nThe constructor E01() is deprecated since version 3.0.0\n----------\n8. WARNING in test1\\E02.java (at line 11)\n\tprotected void old() {}\n\t               ^^^^^\nThe method E02.E03.old() overrides a method from E01 that is deprecated since version 4-SNAPSHOT\n----------\n";
        runner.runWarningTest();
    }

    public void testSinceBinary() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.testFiles = new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t@Deprecated(since=\"1.0\") protected static class Old {}\n\t@Deprecated(since=\"2\") public static int x = 5, y= 10;\n\t@Deprecated(since=\"3.0.0\") public E01() {}\n\t@Deprecated(since=\"4-SNAPSHOT\") protected void old() {}\n}"};
        runner.runConformTest();
        runner.shouldFlushOutputDirectory = false;
        runner.testFiles = new String[]{"test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(new E01.Old());\n\t\tE01 e = new E01();\n\t\te.old();\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n\tclass E03 extends E01 {\n\t\tprotected void old() {}\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. WARNING in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                       ^^^^^^^^^\nThe constructor E01.Old() is deprecated since version 1.0\n----------\n2. WARNING in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                           ^^^\nThe type E01.Old is deprecated since version 1.0\n----------\n3. WARNING in test1\\E02.java (at line 5)\n\tE01 e = new E01();\n\t            ^^^^^\nThe constructor E01() is deprecated since version 3.0.0\n----------\n4. WARNING in test1\\E02.java (at line 6)\n\te.old();\n\t  ^^^^^\nThe method old() from the type E01 is deprecated since version 4-SNAPSHOT\n----------\n5. WARNING in test1\\E02.java (at line 7)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x is deprecated since version 2\n----------\n6. WARNING in test1\\E02.java (at line 8)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y is deprecated since version 2\n----------\n7. WARNING in test1\\E02.java (at line 10)\n\tclass E03 extends E01 {\n\t      ^^^\nThe constructor E01() is deprecated since version 3.0.0\n----------\n8. WARNING in test1\\E02.java (at line 11)\n\tprotected void old() {}\n\t               ^^^^^\nThe method E02.E03.old() overrides a method from E01 that is deprecated since version 4-SNAPSHOT\n----------\n";
        runner.runWarningTest();
    }

    public void testSinceTerminally() {
        AbstractRegressionTest.Runner runner = new AbstractRegressionTest.Runner();
        runner.customOptions = new HashMap<String, String>();
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        runner.customOptions.put("org.eclipse.jdt.core.compiler.problem.terminalDeprecation", "error");
        runner.testFiles = new String[]{"test1/E01.java", "package test1;\npublic class E01 {\n\t@Deprecated(since=\"1.0\", forRemoval=true) protected static class Old {}\n\t@Deprecated(since=\"2\", forRemoval=true) public static int x = 5, y= 10;\n\t@Deprecated(since=\"3.0.0\", forRemoval=true) public E01() {}\n\t@Deprecated(since=\"4-SNAPSHOT\", forRemoval=true) protected void old() {}\n}", "test1/E02.java", "package test1;\npublic class E02 {\n\tpublic void foo() {\n\t\tSystem.out.println(new E01.Old());\n\t\tE01 e = new E01();\n\t\te.old();\n\t\tSystem.out.println(E01.x);\n\t\tSystem.out.println(E01.y);\n\t}\n\tclass E03 extends E01 {\n\t\tprotected void old() {}\n\t}\n}"};
        runner.expectedCompilerLog = "----------\n1. ERROR in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                       ^^^^^^^^^\nThe constructor E01.Old() has been deprecated since version 1.0 and marked for removal\n----------\n2. ERROR in test1\\E02.java (at line 4)\n\tSystem.out.println(new E01.Old());\n\t                           ^^^\nThe type E01.Old has been deprecated since version 1.0 and marked for removal\n----------\n3. ERROR in test1\\E02.java (at line 5)\n\tE01 e = new E01();\n\t            ^^^^^\nThe constructor E01() has been deprecated since version 3.0.0 and marked for removal\n----------\n4. ERROR in test1\\E02.java (at line 6)\n\te.old();\n\t  ^^^^^\nThe method old() from the type E01 has been deprecated since version 4-SNAPSHOT and marked for removal\n----------\n5. ERROR in test1\\E02.java (at line 7)\n\tSystem.out.println(E01.x);\n\t                       ^\nThe field E01.x has been deprecated since version 2 and marked for removal\n----------\n6. ERROR in test1\\E02.java (at line 8)\n\tSystem.out.println(E01.y);\n\t                       ^\nThe field E01.y has been deprecated since version 2 and marked for removal\n----------\n7. ERROR in test1\\E02.java (at line 10)\n\tclass E03 extends E01 {\n\t      ^^^\nThe constructor E01() has been deprecated since version 3.0.0 and marked for removal\n----------\n8. ERROR in test1\\E02.java (at line 11)\n\tprotected void old() {}\n\t               ^^^^^\nThe method E02.E03.old() overrides a method from E01 that has been deprecated since version 4-SNAPSHOT and marked for removal\n----------\n";
        runner.javacTestOptions = AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError;
        runner.runNegativeTest();
    }

    public static Class<?> testClass() {
        return Deprecated9Test.class;
    }
}

