/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest9;

public class GenericsRegressionTest_9
extends AbstractRegressionTest9 {
    public GenericsRegressionTest_9(String name) {
        super(name);
    }

    public static Test suite() {
        return GenericsRegressionTest_9.buildMinimalComplianceTestSuite(GenericsRegressionTest_9.testClass(), 64);
    }

    public void testBug488663_001() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic Y<String> bar() {\n\t\tY<String> y = new Y<>() {\n\t\t\t@Override\n\t\t\tpublic void foo(String s) {\n\t\t\t\tthis.s = s;\n\t \t\t}\n\t\t};\n\t\treturn y;\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new X().bar();\n\t\ty.foo(\"Done\");\n\t\ty.print();\n\t}\n}\nabstract class Y<T> {\n\tString s;\n\tpublic abstract void foo(String s);\n\tpublic void print() {\n\t\tSystem.out.println(this.s);\n\t}\n}\n"}, "Done");
    }

    public void testBug488663_002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic Y<String> bar() {\n\t\tY<String> y = new Y<>() {\n\t\t\t@Override\n\t\t\tpublic void foo(T t) {\n\t\t\t\tthis.s = t;\n\t\t\t}\n\t\t};\n\t\treturn y;\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new X().bar();\n\t\ty.foo(\"Done\");\n\t\ty.print();\n\t}\n}\nabstract class Y<T> {\n\tT s;\n\tpublic abstract void foo(T t);\n\tpublic void print() {\n\t\tSystem.out.println(this.s);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 3)\n\tY<String> y = new Y<>() {\n\t                  ^^^^^\nThe type new Y<String>(){} must implement the inherited abstract method Y<String>.foo(String)\n----------\n2. ERROR in X.java (at line 5)\n\tpublic void foo(T t) {\n\t                ^\nT cannot be resolved to a type\n----------\n");
    }

    public void testBug488663_003() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n@SuppressWarnings(\"unused\") \n\tpublic static void main(String[] args) {\n\t\tY<?> y1 = new Y<>(){};\n\t\tY<String> y2 = new Y<>(){};\n\t\tY<? extends String> y3 = new Y<>() {};\n\t\tY<? super String> y4 = new Y<>() {};\n\t}\n}\nclass Y<T> {}\n"}, "");
    }

    public void testBug488663_004() {
        this.runConformTest(new String[]{"X.java", "public class X {\t\n@SuppressWarnings(\"unused\") \n\tpublic static void main(String[] args) {\n\t\tY<?> y1 = new X().new Y<>(){};\n\t\tY<String> y2 = new X().new Y<>(){};\n\t\tY<? extends String> y3 = new X().new Y<>() {};\n\t\tY<? super String> y4 = new X().new Y<>() {};\n\t}\n\n\tclass Y<T> {}\n}\n"}, "");
    }

    public void testBug488663_005() {
        this.runNegativeTest(new String[]{"X.java", "interface I {}\ninterface J{}\nclass Y<T extends I & J> {}\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tY<?> y = new Y<>() {};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tY<?> y = new Y<>() {};\n\t             ^\nType Y<J & I> inferred for Y<>, is not valid for an anonymous class with '<>'\n----------\n");
    }

    public void testBug488663_006() {
        this.runNegativeTest(new String[]{"X.java", "class Y<T> {\n   Y(T x) {}\n}\n\nclass X {\n  public static void main(String[] args) {\n\t  Y<? extends Integer> fi = null;\n\t  Y<?> f = new Y<>(fi){};\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tY<?> f = new Y<>(fi){};\n\t             ^\nType Y<Y<capture#1-of ? extends Integer>> inferred for Y<>, is not valid for an anonymous class with '<>'\n----------\n");
    }

    public void testBug488663_007() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"Success\");\n\t\tI<X> i = new I<>() {\n\t\t\tpublic String toString(X x1) {\n\t\t\t\treturn x1.name();\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(i.toString(x));\n\t}\n}\ninterface I<T> {\n\tString toString(T t);\n}"}, "Success");
    }

    public void testBug488663_008() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\t<T> void print(T o, I<T> converter) {\n\t\tSystem.out.println(converter.toString(o));\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"Success\");\n\t\tx.print(x, new I<>() {\n\t\t\tpublic String toString(X x1) {\n\t\t\t\treturn x1.name();\n\t\t\t}\n\t\t});\n\t}\n}\ninterface I<T> {\n\tString toString(T t);\n}"}, "Success");
    }

    public void testBug488663_009() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\t<T> void print(T o, I<T> converter) {\n\t\tSystem.out.println(converter.toString(o));\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"Success\");\n\t\tx.print(x, new Z<>() {\n\t\t\tpublic String toString(X x1) {\n\t\t\t\treturn x1.name();\n\t\t\t}\n\t\t});\n\t}\n}\ninterface I<T> {\n\tString toString(T t);\n}\nabstract class Z<T> implements I<T> {}\n"}, "Success");
    }

    public void testBug488663_010() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new Y<>(() -> System.out.println(\"Done\")) {\n\t\t};\n\t}\n}\ninterface J {\n\tvoid doSomething();\n}\nclass Y<T> {\n\tpublic Y(J j) {\n\t\tj.doSomething();\n\t}\n}"}, "Done");
    }

    public void testBug488663_011() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new Y<>(Y::foo) {\n\t\t};\n\t}\n}\ninterface J {\n\tvoid doSomething();\n}\nclass Y<T> {\n\tpublic Y(J j) {\n\t\tj.doSomething();\n\t}\n\tstatic void foo() {\n\t\tSystem.out.println(\"Done\");\n\t}\n}"}, "Done");
    }

    public void testBug488663_012() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new Y<>(\"Done\", new I<>() {\n\t\t\t\tpublic void doSomething(String s) {\n\t\t\t\t\tSystem.out.println(s);\n\t\t\t\t}\n\t\t\t}){\n\t\t};\n\t}\n}\ninterface I<T> {\n\tvoid doSomething(T t);\n}\nclass Y<T> {\n\tpublic Y(T t, I<T> i) {\n\t\ti.doSomething(t);\n\t}\n}"}, "Done");
    }

    public void testBug488663_013() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"Success\");\n\t\tI<X> i = new I<X>() {\n\t\t\tpublic String toString(X x1) {\n\t\t\t\treturn x1.name();\n\t\t\t}\n\t\t};\n\t\tSystem.out.println(i.toString(x));\n\t}\n}\ninterface I<T> {\n\tString toString(T t);\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tI<X> i = new I<X>() {\n\t             ^\nRedundant specification of type arguments <X>\n----------\n", null, true, options);
    }

    public void testBug488663_014() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\t<T> void print(T o, I<T> converter) {\n\t\tSystem.out.println(converter.toString(o));\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"asdasfd\");\n\t\tx.print(x, new Z<>() {\n\t\t\tpublic String toString(String s) {\n\t\t\t\treturn s;\n\t\t\t}\n\t\t});\n\t}\n}\ninterface I<T> {\n\tString toString(T t);\n}\nclass Z<T> implements I<T> {\n\tpublic String toString(T t) {\n\t\treturn \"\";\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 15)\n\tpublic String toString(String s) {\n\t              ^^^^^^^^^^^^^^^^^^\nThe method toString(String) of type new Z<X>(){} must override or implement a supertype method\n----------\n");
    }

    public void testBug488663_015() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test<T> {\n\tprivate static class Inner {\t\tpublic Inner(){}\n\t}\n\t<R> void print(I<R> i) {}\n\tpublic Inner get() {\n\t\treturn new Inner();\n\t}\n}\n", "Z.java", "class Z<T> implements I<T> {\n\tpublic Z(T t1) {}\n\tpublic String toString (T t) {\n\t\treturn t.toString();\n\t}\n}", "X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tTest<String> t = new Test<>();\n\t\tt.print(new Z<>(t.get()) {\n\t\t\t\n\t\t});\n\t}\n}\ninterface I<T> {\n\tString toString();\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tt.print(new Z<>(t.get()) {\n\t            ^^^^^^^^^^^^\nThe type Test$Inner is not visible\n----------\n");
    }

    public void testBug488663_016() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test<T> {\n\tprivate static class Inner {\t\tpublic Inner(){}\n\t}\n\t<R extends Inner> void print(I<R> i) {}\n\tpublic Inner get() {\n\t\treturn new Inner();\n\t}\n}\n", "X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tTest<String> t = new Test<>();\n\t\tt.print(new I<>() {\n\t\t\tpublic String toString() {\n\t\t\t\treturn \"\";\n\t\t\t}\n\t\t});\n\t}\n}\ninterface I<T> {\n\tString toString();\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tt.print(new I<>() {\n\t            ^^^^^\nThe type Test$Inner is not visible\n----------\n");
    }

    public void testBug517926() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString name;\n\tpublic X(String name) {\n\t\tthis.name = name;\n\t}\n\t<T> void print(T o, I<T> converter) {\n\t\tSystem.out.println(converter.toString(o));\n\t}\n\tString name() {\n\t\treturn this.name;\n\t}\n\tpublic static void main(String[] args) {\n\t\tX x = new X(\"asdasfd\");\n\t\tx.print(x, new I<>() {\n\t\t\tpublic String name() {return null;}\n\t\t\tpublic String toString(X xx) {\n\t\t\t\treturn xx.toString();\n\t\t\t}\n\t\t});\n\t}\n}\ninterface I<T> {\nprivate String name() {return null;}\tString toString(T t);\ndefault String getName() {return name();}}"}, "----------\n1. ERROR in X.java (at line 15)\n\tpublic String name() {return null;}\n\t              ^^^^^^\nThe method name() of type new I<X>(){} must override or implement a supertype method\n----------\n");
    }

    public void testBug521815a() {
        this.runNegativeTest(new String[]{"a/b/X.java", "package a.b;\ninterface I{\n    public static class Inner { }\n}\nclass Cl {\n    public static class Inner {}\n}\npublic class X extends Cl implements I {}\n", "a/Y.java", "package p;\nimport static a.b.X.Inner;\npublic class Y {;\n\tInner t;\n}\n"}, "----------\n1. ERROR in a\\Y.java (at line 4)\n\tInner t;\n\t^^^^^\nThe type Inner is ambiguous\n----------\n");
    }

    public void testBug521815b() {
        if (this.complianceLevel <= 0x340000L) {
            return;
        }
        this.runNegativeTest(new String[]{"a/b/X.java", "package a.b;\ninterface I{\n    public static class Inner { }\n}\nclass Cl {\n    public static class Inner {}\n}\npublic class X extends Cl implements I {}\n", "a/Y.java", "package p;\nimport static a.b.X.Inner;\npublic class Y {;\n}\n"}, "----------\n1. WARNING in a\\Y.java (at line 2)\n\timport static a.b.X.Inner;\n\t              ^^^^^^^^^^^\nThe import a.b.X.Inner is never used\n----------\n");
    }

    public static Class<GenericsRegressionTest_9> testClass() {
        return GenericsRegressionTest_9.class;
    }
}

