/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.util.IAttributeNamesConstants;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.core.util.BootstrapMethodsAttribute;
import org.eclipse.jdt.internal.core.util.Util;

public class LambdaExpressionsTest
extends AbstractRegressionTest {
    public LambdaExpressionsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return LambdaExpressionsTest.buildMinimalComplianceTestSuite(LambdaExpressionsTest.testClass(), 32);
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  int add(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    I i = (x, y) -> {\n      return x + y;\n    };\n    System.out.println(i.add(1234, 5678));\n  }\n}\n"}, "6912");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "interface Greetings {\n  void greet(String head, String tail);\n}\npublic class X {\n  public static void main(String[] args) {\n    Greetings g = (x, y) -> {\n      System.out.println(x + y);\n    };\n    g.greet(\"Hello, \", \"World!\");\n  }\n}\n"}, "Hello, World!");
    }

    public void test003() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  void foo(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    BinaryOperator<String> binOp = (x,y) -> { return x+y; };\n    System.out.println(\"SUCCESS\");\n    // System.out.println(binOp.apply(\"SUCC\", \"ESS\")); // when lambdas run\n  }\n}\n", "BiFunction.java", "@FunctionalInterface\npublic interface BiFunction<T, U, R> {\n    R apply(T t, U u);\n}", "BinaryOperator.java", "@FunctionalInterface\npublic interface BinaryOperator<T> extends BiFunction<T,T,T> {\n}"}, "SUCCESS");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  void foo(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    BinaryOperator binOp = (x,y) -> { return x+y; };\n    System.out.println(\"SUCCESS\");\n    // System.out.println(binOp.apply(\"SUCC\", \"ESS\")); // when lambdas run\n  }\n}\n", "BiFunction.java", "@FunctionalInterface\npublic interface BiFunction<T, U, R> {\n    R apply(T t, U u);\n}", "BinaryOperator.java", "@FunctionalInterface\npublic interface BinaryOperator<T> extends BiFunction<T,T,T> {\n}"}, "----------\n1. WARNING in X.java (at line 6)\n\tBinaryOperator binOp = (x,y) -> { return x+y; };\n\t^^^^^^^^^^^^^^\nBinaryOperator is a raw type. References to generic type BinaryOperator<T> should be parameterized\n----------\n2. ERROR in X.java (at line 6)\n\tBinaryOperator binOp = (x,y) -> { return x+y; };\n\t                                         ^^^\nThe operator + is undefined for the argument type(s) java.lang.Object, java.lang.Object\n----------\n");
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString id(String s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> s;\n\t\tSystem.out.println(i.id(\"Hello\"));\n\t}\n}\n"}, "Hello");
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString id(String s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> s + s;\n\t\tSystem.out.println(i.id(\"Hello\"));\n\t}\n}\n"}, "HelloHello");
    }

    public void test007() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid print(String s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> System.out.println(s);\n\t\ti.print(\"Hello\");\n\t}\n}\n"}, "Hello");
    }

    public void test008() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString print(String s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> new String(s).toUpperCase();\n\t\tSystem.out.println(i.print(\"Hello\"));\n\t}\n}\n"}, "HELLO");
    }

    public void test009() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString print(String s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> new String(s);\n\t\tSystem.out.println(i.print(\"Hello\"));\n\t}\n}\n"}, "Hello");
    }

    public void test010() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint unbox(Integer i);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> s;\n\t\tSystem.out.println(i.unbox(new Integer(1234)));\n\t}\n}\n"}, "1234");
    }

    public void test011() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tInteger box(int i);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (s) -> s;\n\t\tSystem.out.println(i.box(1234));\n\t}\n}\n"}, "1234");
    }

    public void test012() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX subType();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = () -> new Y();\n\t\tSystem.out.println(i.subType());\n\t}\n}\nclass Y extends X {\n    public String toString() {\n        return \"Some Y\";\n    }\n}"}, "Some Y");
    }

    public void test013() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    void foo(String s);\n}\npublic class X {\n    public static void main(String [] args) {\n        int in = 12345678;\n        I i = (s) -> {\n            I j = (s2) -> {\n                System.out.println(s + s2 + in);  \n            };\n            j.foo(\"Number=\");\n        };\n        i.foo(\"The \");\n    }\n}\n"}, "The Number=12345678");
    }

    public void test014() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void nonmain(String[] args) {\n    int var = 2;\n    I x2 = () -> {\n      System.out.println(\"Argc = \" + args.length);\n      for (int i = 0; i < args.length; i++) {\n          System.out.println(\"Argv[\" + i + \"] = \" + args[i]);\n      }\n    };\n    x2.doit();\n    var=2;\n  }\n  public static void main(String[] args) {\n      nonmain(new String[] {\"Hello! \", \"World!\" });\n  }\n}"}, "Argc = 2\nArgv[0] = Hello! \nArgv[1] = World!");
    }

    public void test015() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    try {\n      new java.io.File((String) null).getCanonicalPath();\n    } catch (NullPointerException | java.io.IOException ioe) {\n      I x2 = () -> {\n        System.out.println(ioe.getMessage()); // OK: args is not re-assignment since declaration/first assignment\n      };\n      x2.doit();\n    };\n  }\n}\n"}, "null");
    }

    public void test016() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\npublic class X {\n  public static void main(String[] args) {\n    java.util.List<String> list = new java.util.ArrayList<>();\n    list.add(\"SomeString\");\n    for (String s : list) {\n      I x2 = () -> {\n        System.out.println(s); // OK: args is not re-assignment since declaration/first assignment\n      };\n      x2.doit();\n    };\n  }\n\n}\n"}, "SomeString");
    }

    public void test017() {
        this.runConformTest(new String[]{"X.java", "interface I {\n  void foo(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    BinaryOperator<String> binOp = (x,y) -> { return x+y; }; \n    System.out.println(binOp.apply(\"SUCC\", \"ESS\")); // when lambdas run\n  }\n}\n@FunctionalInterface\ninterface BiFunction<T, U, R> { \n    R apply(T t, U u);\n}\n@FunctionalInterface \ninterface BinaryOperator<T> extends BiFunction<T,T,T> { \n}\n"}, "SUCCESS");
    }

    public void test018() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX [][][] copy (short x);\n}\npublic class X  {\n\tpublic static void main(String[] args) {\n\t\tI i = X[][][]::new;\n       I j = X[][][]::new;\n\t\tX[][][] x = i.copy((short) 631);\n\t\tSystem.out.println(x.length);\n       x = j.copy((short) 136);\n\t\tSystem.out.println(x.length);\n\t}\n}\n"}, "631\n136");
    }

    public void test019() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX [][][] copy (int x);\n}\npublic class X  {\n\tpublic static void main(String[] args) {\n\t\tI i = X[][][]::new;\n       I j = X[][][]::new;\n\t\tX[][][] x = i.copy(631);\n\t\tSystem.out.println(x.length);\n       x = j.copy(136);\n\t\tSystem.out.println(x.length);\n\t}\n}\n"}, "631\n136");
    }

    public void test020() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX [][][] copy (Integer x);\n}\npublic class X  {\n\tpublic static void main(String[] args) {\n\t\tI i = X[][][]::new;\n       I j = X[][][]::new;\n\t\tX[][][] x = i.copy(631);\n\t\tSystem.out.println(x.length);\n       x = j.copy(136);\n\t\tSystem.out.println(x.length);\n\t}\n}\n"}, "631\n136");
    }

    public void test021() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX [][][] copy (Integer x);\n}\npublic class X  {\n\tpublic static void main(String[] args) {\n\t\tI i = X[][][]::new;\n       I j = X[][][]::new;\n\t\tX[][][] x = i.copy(new Integer(631));\n\t\tSystem.out.println(x.length);\n       x = j.copy(new Integer((short)136));\n\t\tSystem.out.println(x.length);\n\t}\n}\n"}, "631\n136");
    }

    public void test022() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object copy(int [] ia);\n}\ninterface J {\n\tint [] copy(int [] ia);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = int[]::<String>clone;\n        int [] x = new int [] { 10, 20, 30 };\n        int [] y = (int []) i.copy(x);\n        if (x == y || x.length != y.length || x[0] != y[0] || x[1] != y[1] || x[2] != y[2]) {\n        \tSystem.out.println(\"Broken\");\n        } else {\n        \tSystem.out.println(\"OK\");\n        }\n        J j = int []::clone;\n        y = null;\n        y = j.copy(x);\n        if (x == y || x.length != y.length || x[0] != y[0] || x[1] != y[1] || x[2] != y[2]) {\n        \tSystem.out.println(\"Broken\");\n        } else {\n        \tSystem.out.println(\"OK\");\n        }\n    }\n}\n"}, "OK\nOK");
    }

    public void test023() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object copy(int [] ia);\n}\n\npublic class X  {\n    public static void main(String [] args) {\n        I i = int[]::<String>clone;\n        int [] ia = (int []) i.copy(new int[10]);\n        System.out.println(ia.length);\n    }\n}\n"}, "10");
    }

    public void test024() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    YBase copy(Y ia);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = Y::<String>copy;\n        YBase yb = i.copy(new Y());\n        System.out.println(yb.getClass());\n    }\n}\nclass YBase {\n\tpublic YBase copy() {\n\t\treturn this;\n\t}\n}\nclass Y extends YBase {\n}\n"}, "class Y");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    int foo(int [] ia);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = int[]::<String>hashCode;\n        i.foo(new int[10]);\n    }\n}\n"}, "");
    }

    public void test026() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tInteger foo(int x, int y);\n}\nclass Y {\n\tint foo(int x, int y) {\n\t\tSystem.out.println(\"Y.foo(\" + x + \",\" + y + \")\");\n\t\treturn foo(x, y);\n\t}\n}\npublic class X extends Y {\n\tint foo(int x, int y) {\n\t\tSystem.out.println(\"X.foo(\" + x + \",\" + y + \")\");\n\t\treturn x + y;\n\t}\n\tvoid goo() {\n\t\tI i = super::foo;\n\t\tSystem.out.println(i.foo(1234, 4321));\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().goo();\n\t}\n}\n"}, "Y.foo(1234,4321)\nX.foo(1234,4321)\n5555");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo(int x, int y);\n}\ninterface J {\n\tdefault int foo(int x, int y) {\n\t\tSystem.out.println(\"I.foo(\" + x + \",\" + y + \")\");\n\t\treturn x + y;\n\t}\n}\npublic class X implements J {\n\tpublic static void main(String[] args) {\n\t\tI i = new X().f();\n\t\tSystem.out.println(i.foo(1234, 4321));\n\t\ti = new X().g();\n\t\ttry {\n\t\t\tSystem.out.println(i.foo(1234, 4321));\n\t\t} catch (Throwable e) {\n\t\t\tSystem.out.println(e.getMessage());\n\t\t}\n\t}\n\tI f() {\n\t\treturn J.super::foo;\n\t}\n\tI g() {\n\t\treturn new X()::foo;\n\t}\n\tpublic int foo(int x, int y) {\n\t\tthrow new RuntimeException(\"Exception\");\n\t}\n}\n"}, "I.foo(1234,4321)\n5555\nException");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object copy();\n}\npublic class X  {\n    public static void main(String [] args) {\n    \tint [] x = new int[] { 0xdeadbeef, 0xfeedface };\n    \tI i = x::<String>clone;\n       System.out.println(Integer.toHexString(((int []) i.copy())[0]));\n       System.out.println(Integer.toHexString(((int []) i.copy())[1]));\n    }\n}\n"}, "deadbeef\nfeedface");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX.Y.Z makexyz(int val);\n}\npublic class X {\n\tpublic static void main(String args []) {\n\t\tnew X().new Y().new Z().new P().goo();\n\t}\n\tclass Y {\n\t\tclass Z {\n\t\t\tZ(int val) {\n\t\t\t\tSystem.out.println(Integer.toHexString(val));\n\t\t\t}\t\n\t\t\tZ() {\n\t\t\t}\n\t\t\tclass P {\n\t\t\t\tvoid goo() {\n\t\t\t\t\tI i = Z::new;\n\t\t\t\t\ti.makexyz(0xdeadbeef);\n\t\t\t\t}\n\t\t\t\tI i = Z::new;\n\t\t\t\t{ i.makexyz(0xfeedface); }\n\t\t\t}\n\t\t}\n\t\tI i = Z::new;\n\t\t{ i.makexyz(0xbeeffeed); }\n\t}\n}\n"}, "beeffeed\nfeedface\ndeadbeef");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX.Y makeY();\n}\npublic class X {\n\tpublic class Y {\n       public String toString() {\n           return \"class Y\";\n   }\n\t}\n\tvoid foo() {\n\t\tI i = Y::new;\n\t\tSystem.out.println(i.makeY());\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "class Y");
    }

    public void test031() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX.Y makeY(int x);\n}\npublic class X {\n\tclass Y {\n\t\tString state; \n\t\tY(int x) {\n\t\t\tstate = Integer.toHexString(x);\n\t\t}\n\t\tpublic String toString() {\n\t\t\treturn state;\n\t\t}\n\t}\n\tclass Z extends Y {\n\t\tZ(int x) {\n\t\t\tsuper(x);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().f();\n\t}\n\tvoid f() {\n\t\tI i = Y::new;\n\t\tSystem.out.println(i.makeY(0xdeadbeef));\n\t}\n}\n"}, "deadbeef");
    }

    public void test032() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX.Y makeY(int x);\n}\npublic class X {\n\tclass Y {\n\t\tString state; \n\t\tY(int x) {\n\t\t\tstate = Integer.toHexString(x);\n\t\t}\n\t\tpublic String toString() {\n\t\t\treturn state;\n\t\t}\n\t}\n\tclass Z extends Y {\n\t\tZ(int x) {\n\t\t\tsuper(x);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().f();\n\t}\n\tvoid f() {\n\t\tI i = Z::new;\n\t\tSystem.out.println(i.makeY(0xdeadbeef));\n\t}\n}\n"}, "deadbeef");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX.Y.Z makeY(int x);\n}\npublic class X {\n\tclass Y {\n\t\tY() {\n\t\t}\n\t\tclass Z {\n\t\t\tString state;\n\t\t\tZ(int x) {\n\t\t\t\tstate = Integer.toHexString(x);\n\t\t\t}\n\t\t\tpublic String toString() {\n\t\t\t\treturn state;\n\t\t\t}\n\t\t}\n\t}\n\tclass YS extends Y {\n\t\tYS() {\n\t\t}\n\t\tvoid f() {\n\t\t\tI i = Z::new;\n\t\t\tSystem.out.println(i.makeY(0xbeefface));\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new YS().f();\n\t}\n}\n"}, "beefface");
    }

    public void test034() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    int foo();\n}\npublic class X {\n    int f = 1234;\n    void foo() {\n        int x = 4321;\n        I i = () -> x + f;\n        System.out.println(i.foo());\n    }\n    public static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "5555");
    }

    public void test035() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int p, int q);\n}\npublic class X {\n   int f;\n\tvoid foo(int outerp) {\n       int locouter;\n\t\tI i = (int p, int q)  -> {\n\t\t\tclass Local {\n\t\t\t\tvoid foo() {\n               }\n\t\t\t};\n\t\t\tnew Local();\n\t\t};\n   }\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, "OK");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    String foo(String x, String y);\n}\npublic class X {\n    String xf = \"Lambda \";\n    String x() {\n    \tString xl = \"code \";\n    \tclass Y {\n\t\t\tString yf = \"generation \";\n\t\t\tString y () {\n\t\t\t\tString yl = \"with \";\n\t\t\t\tclass Z {\n\t\t\t\t\tString zf = \"instance \";\n\t\t\t\t\tString z () {\n\t\t\t\t\t\tString zl = \"and \";\n\t\t\t\t\t\tclass P {\n\t\t\t\t\t\t\tString pf = \"local \";\n\t\t\t\t\t\t\tString p () {\n\t\t\t\t\t\t\t\tString pl = \"capture \";\n\t\t\t\t\t\t\t\tI i = (x1, y1) -> {\n\t\t\t\t\t\t\t\t\treturn (((I) ((x2, y2) -> {\n\t\t\t\t\t\t\t\t\t\treturn ( ((I) ((x3, y3) -> {\n\t\t\t\t\t\t\t\t\t\t\treturn xf + xl + yf + yl + zf + zl + pf + pl + x3 + y3;\n\t\t\t\t\t\t\t\t\t\t})).foo(\"works \", \"fine \") + x2 + y2);\n\t\t\t\t\t\t\t\t\t})).foo(\"in \", \"the \") + x1 + y1);\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t\treturn i.foo(\"eclipse \", \"compiler \");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn new P().p();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn new Z().z();\n\t\t\t}\n    \t}\n    \treturn new Y().y();\n    }\n    public static void main(String[] args) {\n\tSystem.out.println(new X().x());\n    }\n}\n"}, "Lambda code generation with instance and local capture works fine in the eclipse compiler");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "interface I {\n    String foo(String x, String y);\n}\npublic class X {\n    String xf = \"Lambda \";\n    String x() {\n    \tString xl = \"code \";\n    \tclass Y {\n\t\t\tString yf = \"generation \";\n\t\t\tString y () {\n\t\t\t\tString yl = \"with \";\n\t\t\t\tclass Z {\n\t\t\t\t\tString zf = \"instance \";\n\t\t\t\t\tString z () {\n\t\t\t\t\t\tString zl = \"and \";\n\t\t\t\t\t\tclass P {\n\t\t\t\t\t\t\tString pf = \"local \";\n\t\t\t\t\t\t\tString p () {\n\t\t\t\t\t\t\t\tString pl = \"capture \";\n\t\t\t\t\t\t\t\tI i = (x1, y1) -> {\n\t\t\t\t\t\t\t\t\treturn (((I) ((x2, y2) -> {\n\t\t\t\t\t\t\t\t\t\treturn ( ((I) ((x3, y3) -> {\n                                           String exclaim = \"!\";\n\t\t\t\t\t\t\t\t\t\t\treturn xf + xl + yf + yl + zf + zl + pf + pl + x3 + y3 + x2 + y2 + x1 + y1 + exclaim;\n\t\t\t\t\t\t\t\t\t\t})).foo(\"works \", \"fine \"));\n\t\t\t\t\t\t\t\t\t})).foo(\"in \", \"the \"));\n\t\t\t\t\t\t\t\t};\n\t\t\t\t\t\t\t\treturn i.foo(\"eclipse \", \"compiler \");\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t\treturn new P().p();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn new Z().z();\n\t\t\t}\n    \t}\n    \treturn new Y().y();\n    }\n    public static void main(String[] args) {\n\tSystem.out.println(new X().x());\n    }\n}\n"}, "Lambda code generation with instance and local capture works fine in the eclipse compiler !");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\npublic class X implements I, J {\n\tpublic static void main( String [] args) { \n\t\tf(new X());\n\t}\n\tstatic void f(Object o) {\n\t\tX x = (X & I & J) o;\n       System.out.println(\"OK\");\n\t}\n}\n"}, "OK");
    }

    public void test039() {
        String errMsg = "X cannot be cast to I";
        this.runConformTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\npublic class X implements J {\n\tpublic static void main( String [] args) { \n\t\tf(new X());\n\t}\n\tstatic void f(Object o) {\n       try {\n\t\t    X x = (X & I & J) o;\n       } catch (ClassCastException e) {\n           System.out.println(e.getMessage());\n       }\n\t}\n}\n"}, errMsg);
    }

    public void test041() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tclass Z {\n\t\tvoid f() {\n\t\t\tI i = X::new;\n\t\t\ti.makeX(123456);\n\t\t}\n\t}\n\tprivate X(int x) {\n\t\tSystem.out.println(x);\n\t}\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new Z().f();\n\t}\n}\n"}, "123456");
    }

    public void test042() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tclass Y extends X {\n\t\tclass Z {\n\t\t\tvoid f() {\n\t\t\t\tI i = X::new;\n\t\t\t\ti.makeX(123456);\n\t\t\t\ti = Y::new;\n\t\t\t\ti.makeX(987654);\n\t\t\t}\n\t\t}\n\t\tprivate Y(int y) {\n\t\t\tSystem.out.println(\"Y(\" + y + \")\");\n\t\t}\n\t\tprivate Y() {\n\t\t\t\n\t\t}\n\t}\n\tprivate X(int x) {\n\t\tSystem.out.println(\"X(\" + x + \")\");\n\t}\n\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().new Z().f();\n\t}\n\n}\n"}, "X(123456)\nY(987654)");
    }

    public void test043() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tclass Y extends X {\n\t\tclass Z extends X {\n\t\t\tvoid f() {\n\t\t\t\tI i = X::new;\n\t\t\t\ti.makeX(123456);\n\t\t\t\ti = Y::new;\n\t\t\t\ti.makeX(987654);\n               i = Z::new;\n               i.makeX(456789);\n\t\t\t}\n       \tprivate Z(int z) {\n\t\t\t\tSystem.out.println(\"Z(\" + z + \")\");\n\t\t\t}\n           Z() {\n           }\n       }\n\t\tprivate Y(int y) {\n\t\t\tSystem.out.println(\"Y(\" + y + \")\");\n\t\t}\n\t\tprivate Y() {\n\t\t\t\n\t\t}\n\t}\n\tprivate X(int x) {\n\t\tSystem.out.println(\"X(\" + x + \")\");\n\t}\n\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().new Z().f();\n\t}\n\n}\n"}, "X(123456)\nY(987654)\nZ(456789)");
    }

    public void test044() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tvoid foo() {\n\t\tint local;\n\t\tclass Y extends X {\n\t\t\tclass Z extends X {\n\t\t\t\tvoid f() {\n\t\t\t\t\tI i = X::new;\n\t\t\t\t\ti.makeX(123456);\n\t\t\t\t\ti = Y::new;\n\t\t\t\t\ti.makeX(987654);\n\t\t\t\t\ti = Z::new;\n\t\t\t\t\ti.makeX(456789);\n\t\t\t\t}\n\t\t\t\tprivate Z(int z) {\n\t\t\t\t\tSystem.out.println(\"Z(\" + z + \")\");\n\t\t\t\t}\n\t\t\t\tZ() {}\n\t\t\t}\n\t\t\tprivate Y(int y) {\n\t\t\t\tSystem.out.println(\"Y(\" + y + \")\");\n\t\t\t}\n\t\t\tprivate Y() {\n\t\t\t}\n\t\t}\n\t\tnew Y().new Z().f();\n\t}\n\tprivate X(int x) {\n\t\tSystem.out.println(\"X(\" + x + \")\");\n\t}\n\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "X(123456)\nY(987654)\nZ(456789)");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tI i = (x) -> {\n\t\tclass Y extends X {\n\t\t\tprivate Y (int y) {\n\t\t\t\tSystem.out.println(y);\n\t\t\t}\n\t\t\tY() {\n\t\t\t}\n\t\t\tvoid f() {\n\t\t\t\tI i = X::new;\n\t\t\t\ti.makeX(123456);\n\t\t\t\ti = X.Y::new;\n\t\t\t\ti.makeX(987654);\n\t\t\t}\n\t\t}\n\t\treturn null; \n\t};\n\tprivate X(int x) {\n\t\tSystem.out.println(x);\n\t}\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().f();\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\tclass Y extends X {\n\t      ^\nThe type Y is never used locally\n----------\n2. WARNING in X.java (at line 7)\n\tprivate Y (int y) {\n\t        ^^^^^^^^^\nThe constructor Y(int) is never used locally\n----------\n3. WARNING in X.java (at line 10)\n\tY() {\n\t^^^\nThe constructor Y() is never used locally\n----------\n4. WARNING in X.java (at line 13)\n\tI i = X::new;\n\t  ^\nThe local variable i is hiding a field from type X\n----------\n5. ERROR in X.java (at line 15)\n\ti = X.Y::new;\n\t      ^\nY cannot be resolved or is not a field\n----------\n6. ERROR in X.java (at line 27)\n\tnew X().new Y().f();\n\t            ^\nX.Y cannot be resolved to a type\n----------\n");
    }

    public void test046() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString doit();\n}\npublic class X extends B {\n\tclass Y {\n\t\tclass Z {\n\t\t\tvoid f() {\n\t\t\t\t\n\t\t\t\t I i = X.super::toString; // Verify error\n\t\t\t\t System.out.println(i.doit());\n\t\t\t\t i = X.this::toString; // This call gets dispatched OK.\n\t\t\t\t System.out.println(i.doit());\n\t\t\t}\n\t\t}\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().new Z().f(); \n\t}\n\t\n\tpublic String toString() {\n\t\treturn \"X's toString\";\n\t}\n}\nclass B {\n\tpublic String toString() {\n\t\treturn \"B's toString\";\n\t}\n}\n"}, "B's toString\nX's toString");
    }

    public void test047() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x, int y);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tlong lng = 1234;\n\t\tdouble d = 1234.5678;\n\t\tI i = (x, y) -> {\n\t\t\tSystem.out.println(\"long = \" + lng);\n\t\t\tSystem.out.println(\"args length = \" + args.length);\n\t\t\tSystem.out.println(\"double = \" + d);\n\t\t\tSystem.out.println(\"x = \" + x);\n\t\t\tSystem.out.println(\"y = \" + y);\n\t\t};\n\t\ti.foo(9876, 4321);\n\t}\n}\n"}, "long = 1234\nargs length = 0\ndouble = 1234.5678\nx = 9876\ny = 4321");
    }

    public void test048() {
        this.runConformTest(new String[]{"X.java", "interface I<T, J> {\n\tvoid foo(T x, J y);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tlong lng = 1234;\n\t\tdouble d = 1234.5678;\n\t\tI<Object, Object> i = (x, y) -> {\n\t\t\tSystem.out.println(\"long = \" + lng);\n\t\t\tSystem.out.println(\"args length = \" + args.length);\n\t\t\tSystem.out.println(\"double = \" + d);\n\t\t\tSystem.out.println(\"x = \" + x);\n\t\t\tSystem.out.println(\"y = \" + y);\n\t\t};\n\t\ti.foo(9876, 4321);\n\t\t\n\t\tI<String, String> i2 = (x, y) -> {\n\t\t\tSystem.out.println(x);\n\t\t\tSystem.out.println(y);\n\t\t};\n\t\ti2.foo(\"Hello !\",  \"World\");\n\t}\n}\n"}, "long = 1234\nargs length = 0\ndouble = 1234.5678\nx = 9876\ny = 4321\nHello !\nWorld");
    }

    public void test049() {
        this.runConformTest(new String[]{"X.java", "interface I<T, J> {\n\tvoid foo(X x, T t, J j);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI<String, String> i = X::foo;\n\t\ti.foo(new X(), \"Hello\", \"World!\");\n\t}\n\tvoid foo(String s, String t) {\n\t\tSystem.out.println(s);\n\t\tSystem.out.println(t);\n\t}\n}\n"}, "Hello\nWorld!");
    }

    public void test050() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x, int y);\n}\npublic class X {\n\tstatic private void add(int x, int y) {\n\t\tSystem.out.println(x + y);\n\t}\n\tprivate void multiply(int x, int y) {\n\t\tSystem.out.println(x * y);\n\t}\n\tstatic class Y {\n\t\tstatic private void subtract(int x, int y) {\n\t\t\tSystem.out.println(x - y);\n\t\t}\n\t\tprivate void divide (int x, int y) {\n\t\t\tSystem.out.println(x / y);\n\t\t}\n\t\tstatic void doy() {\n\t\t\tI i = X::add;\n\t\t\ti.foo(1234, 12);\n\t\t\ti = new X()::multiply;\n\t\t\ti.foo(12, 20);\n\t\t\ti = Y::subtract;\n\t\t\ti.foo(123,  13);\n\t\t\ti = new Y()::divide;\n\t\t\ti.foo(99, 9);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::add;\n\t\ti.foo(1234, 12);\n\t\ti = new X()::multiply;\n\t\ti.foo(12, 20);\n\t\ti = Y::subtract;\n\t\ti.foo(123,  13);\n\t\ti = new Y()::divide;\n\t\ti.foo(99, 9);\n\t\tY.subtract(10,  7);\n\t\tY.doy();\n\t}\n}\n"}, "1246\n240\n110\n11\n3\n1246\n240\n110\n11");
    }

    public void test051() {
        this.runConformTest(new String[]{"p2/B.java", "package p2;\nimport p1.*;\t\t\t\t\t\t\t\t\ninterface I {\n\tvoid foo();\n}\ninterface J {\n\tvoid foo();\n}\npublic class B extends A {\n\tclass Y {\n\t\tvoid g() {\n\t\t\tI i = B::foo;\n\t\t\ti.foo();\n\t\t\tJ j = new B()::goo;\n\t\t\tj.foo();\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew B().new Y().g();\n\t}\n}\n", "p1/A.java", "package p1;\nimport p2.*;\npublic class A {\n\tprotected static void foo() {\n\t    System.out.println(\"A's static foo\");\n\t}\n\tprotected void goo() {\n\t    System.out.println(\"A's instance goo\");\n\t}\n}"}, "A's static foo\nA's instance goo");
    }

    public void test052() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\npublic class X {\n\tvoid foo() {\n\t\tint local = 10;\n\t\tclass Y {\n\t\t\tvoid foo(int x) {\n\t\t\t\tSystem.out.println(local);\n\t\t\t}\n\t\t\tvoid goo() {\n\t\t\t\tI i = this::foo;\n\t\t\t\ti.foo(10);\n\t\t\t}\n\t\t}\n\t\tnew Y().goo();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}\n"}, "10");
    }

    public void test053() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n  public static <E> void printItem(E value, int index) {\n    String output = String.format(\"%d -> %s\", index, value);\n    System.out.println(output);\n  }\n  public static void main(String[] argv) {\n    List<String> list = Arrays.asList(\"A\",\"B\",\"C\");\n    eachWithIndex(list,X::printItem);\n  }\n  interface ItemWithIndexVisitor<E> {\n    public void visit(E item, int index);\n  }\n  public static <E> void eachWithIndex(List<E> list, ItemWithIndexVisitor<E> visitor) {\n    for (int i = 0; i < list.size(); i++) {\n         visitor.visit(list.get(i), i);\n    }\n  }\n}\n"}, "0 -> A\n1 -> B\n2 -> C");
    }

    public void test054() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n  public static <E> void printItem(E value) {}\n  public static void main(String[] argv) {\n    List<String> list = null;\n    eachWithIndex(list, X::printItem);\n  }\n  interface ItemWithIndexVisitor<E> {\n    public void visit(E item);\n  }\n  public static <E> void eachWithIndex(List<E> list, ItemWithIndexVisitor<E> visitor) {}\n}\n"}, "");
    }

    public void test055() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int i);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tX x = new X();\n\t\tI i = x::foo;\n\t}\n\tint foo(int x) {\n\t\treturn x;\n\t}\n}\n"}, "");
    }

    public void test056() {
        this.runConformTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.JavacGeneratesIncorrectCode, new String[]{"X.java", "interface I {\n\tvoid foo(int i);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tX x = null;\n\t\ttry {\n\t\t\tI i = x::foo;\n\t\t\ti.foo(10);\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(npe.getMessage());\n\t\t}\n\t}\n\tint foo(int x) {\n\t\treturn x;\n\t}\n}\n"}, "null");
    }

    public void test057() {
        String source = "interface I {\n    void foo(Y<String> y);\n}\npublic class Y<T> {\n    class Z<K> {\n        Z(Y<String> y) {\n            System.out.println(\"Y<T>.Z<K>:: new\");\n        }\n        public void bar() {\n            I i = Y<String>.Z<Integer>::<String> new;\n            i.foo(new Y<String>());\n            i = Y<String>.Z<Integer>:: new;\n            i.foo(new Y<String>());\n            i = Y.Z:: new;\n            i.foo(new Y<String>());\n        }\n    }\n\tpublic void foo() {\n\t\tZ<String> z = new Z<String>(null);\n\t\tz.bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tY<String> y = new Y<String>();\n\t\ty.foo();\n\t}\n}\n";
        this.runConformTest(new String[]{"Y.java", source}, "Y<T>.Z<K>:: new\nY<T>.Z<K>:: new\nY<T>.Z<K>:: new\nY<T>.Z<K>:: new");
    }

    public void test058() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tF1 f = X::foo;\n\t\tSystem.out.println(\"Hello, World\");\n\t}\n    static int foo (int x) throws NumberFormatException { return 0; }\n}\ninterface F1 { int X(int x);}\n"}, "Hello, World");
    }

    public void testGenericArrayCreation() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX<?, ?, ?>[] makeArray(int i);\n}\npublic class X<T, U, V> {\n\tpublic static void main(String [] args) {\n\t\tI i = X<?, ?, ?>[]::new; // OK.\n\t\tSystem.out.println(i.makeArray(1024).length);\n\t}\n}\n"}, "1024");
    }

    public void test421536() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "interface I {\n\tI foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tI i = () -> null;\n\t\t} catch (NullPointerException npe) {}\n       System.out.println(\"OK\");\n\t}\n}\n"}, "OK", customOptions);
    }

    public void test421536a() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo();\n}\npublic class X {\n   public static void foo() {}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tI i = X::foo;\n\t\t} catch (NullPointerException npe) {}\n       System.out.println(\"OK\");\n\t}\n}\n"}, "OK", customOptions);
    }

    public void test421607() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tpublic void foo();\n}\nclass C implements I {\n\tpublic void foo() {\n\t\tSystem.out.println(\"You will get here\");\n\t}\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t((C & I) (I) new C()).foo();\n\t}\n}\n"}, "You will get here");
    }

    public void test421712() {
        this.runConformTest(new String[]{"X.java", "interface F {\n\tvoid foo();\n}\ninterface I {\n\tdefault void foo() {\n\t\tF f = () -> {\n\t\t};\n   System.out.println(\"Lambda instantiated\");\n\t}\n}\npublic class X implements I {\n\tpublic static void main(String argv[]) {\n\t\tX x = new X();\n\t\tx.foo();\n\t}\n}\n"}, "Lambda instantiated");
    }

    public void test422515() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) throws InterruptedException {\n        final int[] result = { 0 };\n        Thread t = new Thread(() -> result[0] = 42);\n        t.start();\n        t.join();\n        System.out.println(result[0]);\n    }\n}\n"}, "42");
    }

    public void test422515a() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) throws InterruptedException {\n        final int[] result= { 0 };\n        final int x = args.length + 42;\n        Thread t = new Thread(() -> {\n            result[0]= x;\n        });\n        t.start();\n        t.join();\n        System.out.println(result[0]);\n    }\n}\n"}, "42");
    }

    public void test422800() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    private String fField; // must be here; can be used or unused\n    public void foo(Integer arg) {\n        new Thread(() -> {\n            arg.intValue();\n        });\n    }\n    public static void main(String [] args) {\n\t     System.out.println(\"OK\");\n    }\n}\n"}, "OK");
    }

    public void test421927() {
        this.runConformTest(new String[]{"X.java", "interface I { \n\tint foo();\n}\npublic class X {\n    static I i  = (I & java.io.Serializable) () -> 42;\n    public static void main(String args[]) {\n        System.out.println(i.foo());\n    }\n}\n"}, "42");
    }

    public void testReferenceExpressionInference1() {
        this.runConformTest(new String[]{"X.java", "interface I<E> {\n\tE foo(E e);\n}\npublic class X {\n\t<T> T print(I<T> i) { return null; }\n\tvoid test() {\n\t\tString s = print(this::bar);\t}\n\t<S> S bar(S s) { return s; }\n}\n"});
    }

    public void testReferenceExpressionInference2() {
        this.runConformTest(new String[]{"X.java", "interface I<E,F> {\n\tF foo(E e);\n}\npublic class X {\n\t<S,T,U> I<S,U> compose(I<S,T> i1, I<T,U> i2) { return null; }\n\tvoid test() {\n\t\tI<X,String> x2s = compose(this::bar, this::i2s);\t}\n\tString i2s (Integer i) { return i.toString(); }\n\t<V,W extends Number> W bar(V v) { return null; }\n}\n"});
    }

    public void testReferenceExpressionInference3a() {
        this.runConformTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.JavacDoesNotCompileCorrectSource, new String[]{"X.java", "interface I<E,F> {\n\tF foo(E e);\n}\npublic class X {\n\t<S,T,U> I<S,U> compose(I<S,T> i1, I<T,U> i2) { return null; }\n\tvoid test() {\n\t\tI<X,String> x2s = compose(this::bar, this::<String>i2s);\t}\n\t<Z> Z i2s (Integer i) { return null; }\n\t<V,W extends Number> W bar(V v) { return null; }\n}\n"}, null);
    }

    public void testReferenceExpressionInference3b() {
        this.runNegativeTest(new String[]{"X.java", "interface I<E,F> {\n\tF foo(E e);\n}\npublic class X {\n\t<S,T,U> I<S,U> compose(I<S,T> i1, I<T,U> i2) { return null; }\n\tvoid test() {\n\t\tI<X,String> x2s = compose(this::bar, this::i2s);\n\t}\n\t<Z> Z i2s (Integer i) { return null; }\n\t<V,W extends Number> W bar(V v) { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tI<X,String> x2s = compose(this::bar, this::i2s);\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from I<Object,Object> to I<X,String>\n----------\n2. ERROR in X.java (at line 7)\n\tI<X,String> x2s = compose(this::bar, this::i2s);\n\t                                     ^^^^^^^^^\nThe type X does not define i2s(Object) that is applicable here\n----------\n");
    }

    public void testLambdaInference1() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\npublic class X {\n  public static void main(String[] argv) {\n    List<String> list = null;\n    eachWithIndex(list, s -> print(s));\n  }\n  static void print(String s) {}\n  interface ItemWithIndexVisitor<E> {\n    public void visit(E item);\n  }\n  public static <E> void eachWithIndex(List<E> list, ItemWithIndexVisitor<E> visitor) {}\n}\n"}, "");
    }

    public void testLambdaInference2() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nclass A {}\nclass B extends A {\n\tvoid bar() {}\n}\npublic class X {\n  public static void main(String[] argv) {\n    someWithIndex(getList(), (B b) -> b.bar());\n  }\n  interface ItemWithIndexVisitor<E> {\n    public void visit(E item);\n  }\n  public static <G> void someWithIndex(List<G> list, ItemWithIndexVisitor<G> visitor) {}\n  static <I extends A> List<I> getList() { return null; }\n}\n"}, "");
    }

    public void testBug419048_1() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.stream.*;\npublic class X {\n\tpublic void test() {\n\t\t List<Person> roster = new ArrayList<>();\n        \n        Map<String, Person> map = \n            roster\n                .stream()\n                .collect(\n                    Collectors.toMap(\n                        p -> p.getLast(),\n                        p -> p\n                    ));\n\t}\n}\nclass Person {\n  public String getLast() { return null; }\n}\n"});
    }

    public void testBug419048_2() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\npublic class X {\n\tpublic void test() {\n\t\t List<Person> roster = new ArrayList<>();\n        \n        Map<String, Person> map = \n            roster\n                .stream()\n                .collect(\n                    Collectors.toMap(\n                        Person::getLast,\n                        Function.identity()\n                    ));\n\t}\n}\nclass Person {\n  public String getLast() { return null; }\n}\n"});
    }

    public void testBug419048_3() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.function.*;\nimport java.util.stream.*;\npublic class X {\n\tpublic void test() {\n\t\t List<Person> roster = new ArrayList<>();\n        \n        Map<String, Person> map = \n            roster\n                .stream()\n                .collect(\n                    Collectors.toMap(\n                        new Function<Person, String>() {\n                            public String apply(Person p) { \n                                return p.getLast(); \n                            } \n                        },\n                        Function.identity()\n                    ));\n\t}\n}\nclass Person {\n  public String getLast() { return null; }\n}\n"});
    }

    public void test424226() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void fun1() {\n\t\tFI fi = I::staticMethod; \n\t}\n   public static void main(String [] args) {\n       System.out.println(\"OK\");\n   }\n}\n@FunctionalInterface\ninterface FI {\n\tvoid foo();\t\n}\ninterface I {\n\tstatic FI staticMethod() {\n\t\treturn null;\n\t}\n}\n"}, "OK");
    }

    public void test423684() {
        this.runConformTest(new String[]{"Test.java", "import java.util.Arrays;\nimport java.util.List;\nimport mypackage.MyPublicClass;\npublic class Test {\n    public static void main(String[] args) {\n        doesWork();\n        doesNotWork();\n    }\n    public static void doesNotWork() {\n        MyPublicClass victim = new MyPublicClass();\n        List<String> items = Arrays.asList(\"first\", \"second\", \"third\");\n        items.forEach(victim::doSomething); //illegal access error here\n    }\n    public static void doesWork() {\n        MyPublicClass victim = new MyPublicClass();\n        List<String> items = Arrays.asList(\"first\", \"second\", \"third\");\n        for (String item : items) {\n            victim.doSomething(item);\n        }\n    }\n}\n", "mypackage/MyPublicClass.java", "package mypackage;\nclass MyPackagePrivateBaseClass {\n    public void doSomething(String input) {\n        System.out.println(input);\n    }\n}\npublic class MyPublicClass extends MyPackagePrivateBaseClass {\n}\n"}, "first\nsecond\nthird\nfirst\nsecond\nthird");
    }

    public void testBug424742() {
        this.runNegativeTest(new String[]{"TestInlineLambdaArray.java", "package two.test;\n\nclass TestInlineLambdaArray {\n\tTestInlineLambdaArray h = new TestInlineLambdaArray(x -> x++);\t// [9]\n\tpublic TestInlineLambda(FI fi) {}\n}\n\ninterface FI {\n\t\tvoid foo();\n}\n"}, "----------\n1. ERROR in TestInlineLambdaArray.java (at line 4)\n\tTestInlineLambdaArray h = new TestInlineLambdaArray(x -> x++);\t// [9]\n\t                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe constructor TestInlineLambdaArray((<no type> x) -> {}) is undefined\n----------\n2. ERROR in TestInlineLambdaArray.java (at line 5)\n\tpublic TestInlineLambda(FI fi) {}\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nReturn type for the method is missing\n----------\n");
    }

    public void test424589() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.Collection;\nimport java.util.function.Supplier;\nimport java.util.Set;\npublic class X {\n    public static <T, Y extends Collection<T>>\n        Y foo(Supplier<Y> y) {\n            return null;\n    }  \n    public static void main(String[] args) {\n        Set<Z> x = foo(Set::new);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tSet<Z> x = foo(Set::new);\n\t    ^\nZ cannot be resolved to a type\n----------\n2. ERROR in X.java (at line 11)\n\tSet<Z> x = foo(Set::new);\n\t               ^^^\nCannot instantiate the type Set\n----------\n");
    }

    public void test425152() {
        this.runConformTest(new String[]{"Main.java", "interface Base { \n\tBase get(int x);\n}\nclass Main {\n    <T> Base foo(Base b) { \n        return null; \n     }\n    void bar(Base b) { }\n    void testCase() {\n        bar(foo((int p)->null));\n     }\n}\n"});
    }

    public void test425512() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X  {\n    public static void main(String argv[]) {\n    \tint [] a = (int [] & Cloneable & Serializable) new int[5];\n       System.out.println(a.length);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tint [] a = (int [] & Cloneable & Serializable) new int[5];\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nArrays are not allowed in intersection cast operator\n----------\n");
    }

    public void test424628() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static interface Consumer<T> {\n        void accept(T t);\n    }\n    \n    public static class Base {\n        public void method () { System.out.println(123); }\n    }\n    public static class Foo extends Base {}\n    public static class Bar extends Base {}\n\n    public static void main (String[] args) {\n        Consumer<Foo> foo = Foo::method;\n        Consumer<Bar> bar = Bar::method;\n        foo.accept(new Foo());\n        bar.accept(new Bar());\n    }\n}\n"}, "123\n123");
    }

    public void test425712() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n    {\n        bar( () -> (char) 0); // [1]\n    }\n    void bar(FB fb) { }\n    public static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\ninterface FB {\n\tbyte foo();\n}\n"}, "OK");
    }

    public void test426074() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface Functional<T> {\n    void foo(T t);\n}\ninterface I { }\npublic class X {\n\tpublic static void main(String[] args) {\n    \tFunctional<? extends X> f = (Functional<? extends X> & I) (X c) -> {\n    \t\tSystem.out.println(\"main\");\n    \t};\n    \tf.foo(null);\n    }\n}\n"}, "main");
    }

    public void test426411() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\t((Serializable & AutoCloseable) (() -> {})).close();\n\t}\n}\n"}, "");
    }

    public void test426411b() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface AnotherAutoCloseable extends AutoCloseable {}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\t((Serializable & AnotherAutoCloseable) (() -> {})).close();\n\t}\n}\n"}, "");
    }

    public void test426411c() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\t((AutoCloseable & Serializable) (() -> {})).close();\n\t}\n}\n"}, "");
    }

    public void test426411d() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface AnotherAutoCloseable extends AutoCloseable {}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\t((AnotherAutoCloseable & Serializable) (() -> {})).close();\n\t}\n}\n"}, "");
    }

    public void test426411e() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface I {}\ninterface J extends I {\n   static final int xyz = 99;\n}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\tJ j = new J() {};\n\t\tSystem.out.println(((I & J) j).xyz);\n\t}\n}\n"}, "99");
    }

    public void test426411f() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\ninterface I {}\ninterface J extends I {\n   final int xyz = 99;\n}\npublic class X {\n\tpublic static void main(String argv[]) throws Exception {\n\t\tJ j = new J() {};\n\t\tSystem.out.println(((I & J) j).xyz);\n\t}\n}\n"}, "99");
    }

    public void test426086() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface Functional {\n    Long square(Integer a);\n}\npublic class X {\n    static class Base {\n    \t private Long square(Integer a) {\n             return Long.valueOf(a*a);\n         } \n    }\n    static class SubClass extends Base {\n        public Long callSquare(Integer i) {\n            Functional fi = SubClass.super::square;\n            return fi.square(i);\n        }\n    }\n    public static void main(String argv[]) throws Exception {\n    \tSystem.out.println(new SubClass().callSquare(-3));\n    }\n}\n"}, "9");
    }

    public void test426086a() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface Functional {\n    Long square(Integer a);\n}\npublic class X {\n    static class Base {\n    \t private Long square(Integer a) {\n             return Long.valueOf(a*a);\n         } \n    }\n    static class SubClass extends Base {\n        public Long callSquare(Integer i) {\n            Functional fi = super::square;\n            return fi.square(i);\n        }\n    }\n    public static void main(String argv[]) throws Exception {\n    \tSystem.out.println(new SubClass().callSquare(-3));\n    }\n}\n"}, "9");
    }

    public void test406744a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer a1, Integer a2, String a3);\n}\nclass Y {\n\tstatic void m(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X {\n\tpublic static void main(String [] args) {\n\t\tI i = Y::m;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10\n20\n10, 20");
    }

    public void test406744b() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tint foo(Integer a1, Integer a2, String a3);\n}\nclass Y {\n\tstatic int m(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t\treturn 1;\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X {\n\tpublic static void main(String [] args) {\n\t\tI i = Y::m;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10\n20\n10, 20");
    }

    public void test406744c() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer a1, Integer a2, String a3);\n}\nclass Y {\n\t Y(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void m(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X {\n\tpublic static void main(String [] args) {\n\t\tI i = Y::new;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10\n20\n10, 20");
    }

    public void test406744d() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int a1, Integer a2, String a3);\n}\ninterface Y {\n\tstatic void m(float a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic interface X extends Y{\n\tpublic static void main(String [] args) {\n\t\tI i = Y::m;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10.0\n20\n10, 20");
    }

    public void test406744e() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tString method(int a);\n}\nclass C {\n\tstatic String foo(Integer... i) {\n\t\treturn \"foo\";\n\t}\n\tstatic String goo(Integer bi, Integer... i) {\n\t\treturn \"bar\";\n\t}\n\tpublic void foo() {\n\t\tI i;\n\t\ti = C::foo;\n\t\tSystem.out.println(i.method(0));\n\t\ti = C::goo;\n\t\tSystem.out.println(i.method(0));\n\t}\n}\npublic class X {\n\tpublic static void main(String argv[])   {\n\t\tnew C().foo();\n\t}\n}\n"}, "foo\nbar");
    }

    public void test406744f() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer a1, Integer a2, String a3);\n}\nclass Y {\n\tvoid m(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X extends Y {\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = super::m;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10\n20\n10, 20");
    }

    public void test406744g() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer a1, Integer a2, String a3);\n}\nclass Y {\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X extends Y {\n\tprivate void m(Number a1, Object... rest) {\n\t\tSystem.out.println(a1);\n\t\tprint(rest);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = this::m;\n\t\ti.foo(10, 20, \"10, 20\");\n\t}\n}\n"}, "10\n20\n10, 20");
    }

    public void test406744h() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int [] ia);\n}\nclass Y {\n\tvoid m(Object... rest) {\n\t\tSystem.out.println(\"Hello \" + rest.length);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X extends Y {\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = super::m;\n\t\ti.foo(new int [0]);\n\t}\n}\n"}, "Hello 1");
    }

    public void test406744i() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int [] ia);\n}\ninterface I1 {\n\tvoid foo(int [] ia);\n}\nclass Y {\n\tvoid m(Object... rest) {\n\t\tSystem.out.println(\"Hello \" + rest.length);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X extends Y {\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = super::m;\n\t\ti.foo(new int [0]);\n\t\tI1 i1 = super::m;\n\t\ti1.foo(new int [0]);\n\t}\n}\n"}, "Hello 1\nHello 1");
    }

    public void test406744j() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int [] ia);\n}\nclass Y {\n\tvoid m(Object... rest) {\n\t\tI i = this::n;\n\t\ti.foo(new int [0]);\n\t}\n\tvoid n(Object... rest) {\n\t\tSystem.out.println(\"Hello \" + rest.length);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\npublic class X extends Y {\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = super::m;\n\t\ti.foo(new int [0]);\n\t}\n}\n"}, "Hello 1");
    }

    public void test406744k() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int [] ia);\n}\nclass Y {\n\tstatic void m(Object... rest) {\n\t\tSystem.out.println(\"Hello \" + rest.length);\n\t}\n\tstatic void print (Object [] o) {\n\t\tfor (int i = 0; i < o.length; i++)\n\t\t\tSystem.out.println(o[i]);\n\t}\n}\nclass Y1 extends Y { }\npublic class X {\n\tpublic static void main(String [] args) {\n\t\tnew X().foo();\n\t}\n\tvoid foo() {\n\t\tI i = Y::m;\n\t\ti.foo(new int [0]);\n\t\ti = Y1::m;\n\t\ti.foo(new int [0]);\n\t}\n}\n"}, "Hello 1\nHello 1");
    }

    public void test406744l() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer i);\n}\npublic class X {\n\tstatic void foo(int ... x) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::foo;\n\t\ti.foo(1);\n\t\tSystem.out.println(\"Hello\");\n}\n}\n"}, "Hello");
    }

    public void test406744m() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int i);\n}\npublic class X {\n\tstatic void foo(int ... x) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::foo;\n\t\ti.foo(1);\n\t\tSystem.out.println(\"Hello\");\n\t}\n}\n"}, "Hello");
    }

    public void test406744n() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(Integer i);\n}\nclass Base {\n\tvoid foo(Object ...objects) {\n\t\tSystem.out.println(\"Ok\");\n\t}\n}\npublic class X extends Base {\n\tvoid foo(Object... objects) {\n\t\tthrow new RuntimeException();\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().goo();\n\t}\n\tvoid goo() {\n\t\tI i = super::foo;\n\t\ti.foo(10);\n\t}\n}\n"}, "Ok");
    }

    public void test406744o() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\nclass Base {\n\tpublic void foo(int ...is) {\n\t\tSystem.out.println(\"foo\");\n\t}\n}\npublic class X extends Base {\n\tpublic static void main( String[] args ) {\n\t\tI i = new X()::foo;\n\t\ti.foo(10);\n\t}\n}\n"}, "foo");
    }

    public void test406744p() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\npublic class X {\n\tprivate void foo(int ...is) {\n\t\tSystem.out.println(\"foo\");\n\t}\n\tpublic static void main(String[] args ) {\n\t\tnew X().new Y().foo();\n\t}\n\tclass Y extends X {\n\t\tvoid foo() {\n\t\t\tI i = new X()::foo;\n\t\t\ti.foo(10);\n\t\t}\n\t}\n}\n"}, "foo");
    }

    public void test406744q() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\nclass Y {\n\tpublic static void foo(int ...is) {\n\t\tSystem.out.println(\"Y.foo\");\n\t}\n}\npublic class X {\n\tpublic static void foo(int ...is) {\n\t\tSystem.out.println(\"X.foo\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::foo;\n\t\ti.foo(10);\n\t\ti = Y::foo;\n\t\ti.foo(20);\n\t}\n}\n"}, "X.foo\nY.foo");
    }

    public void test406744r() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int t, int [] ia);\n}\npublic class X {\n\tpublic static void foo(Integer i, int ...is) {\n\t\tSystem.out.println(\"Y.foo\");\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = X::foo;\n\t\ti.foo(10, null);\n\t}\n}\n"}, "Y.foo");
    }

    public void test406744s() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX foo(int x);\n}\npublic class X {\n\tclass Y extends X {\n\t\tY(int ... x) {\n\t\t\tSystem.out.println(\"Y::Y\");\n\t\t}\n\t}\n\tpublic static void main(String[] args ) {\n\t\tnew X().goo();\n\t}\n\tvoid goo() {\n\t\tI i = Y::new;\n\t\ti.foo(10);\n\t}\n}\n"}, "Y::Y");
    }

    public void test406744t() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX foo(int x);\n}\npublic class X<T> {\n\tclass Y extends X {\n\t    Y(int ... x) {\n\t\t    System.out.println(\"Y::Y\");\n\t    }\n\t}\n\tpublic static void main(String[] args ) {\n\t\tSystem.out.println(\"Hello\");\n\t\tnew X().goo();\n\t}\n\tvoid goo() {\n\t\tI i = Y::new;\n\t\ti.foo(10);\n\t}\n}\n"}, "Hello\nY::Y");
    }

    public void test406744u() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX<String> foo(int x);\n}\npublic class X<T> {  \n\tclass Y extends X<String> {\n\t    Y(int ... x) {\n\t\t    System.out.println(\"Y::Y\"); \n\t    }\n\t}\n\tpublic static void main(String[] args ) {\n\t\tSystem.out.println(\"Hello\");\n\t\tnew X<String>().goo();  \n\t}\n\tvoid goo() {\n\t\tI i = Y::new;\n\t\ti.foo(10); \n\t}\n}\n"}, "Hello\nY::Y");
    }

    public void test406744v() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX foo();\n}\npublic class X {\n\tprivate X(int ... is) {\n\t\tSystem.out.println(\"X::X\");\n\t}\n\t\n\tpublic static void main(String[] args) {\n\t\tnew X().new Y().goo();\n\t}\n\tpublic class Y {\n\t\tpublic void goo() {\n\t\t\tI i = X::new; \n\t\t\ti.foo();\n\t\t} \n\t}\n}\n"}, "X::X\nX::X");
    }

    public void test406744w() {
        this.runConformTest(new String[]{"p2/B.java", "package p2;\nimport p1.*;\ninterface I {\n\tvoid foo(int x);\n}\ninterface J {\n\tvoid foo(int x);\n}\npublic class B extends A {\n\tclass Y {\n\t\tvoid g() {\n\t\t\tI i = B::foo;\n\t\t\ti.foo(10);\n\t\t\tJ j = new B()::goo;\n\t\t\tj.foo(10);\n\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew B().new Y().g();\n\t}\n}\n", "p1/A.java", "package p1;\nimport p2.*;\npublic class A {\n\tprotected static void foo(int ... is) {\n\t    System.out.println(\"A's static foo\");\n\t}\n\tprotected void goo(int ... is) {\n\t    System.out.println(\"A's instance goo\");\n\t}\n}\n"}, "A's static foo\nA's instance goo");
    }

    public void test406744x() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid foo(int x);\n}\npublic class X {\n\tclass Y {\n\t\tvoid goo() {\n\t\t\tI i = X::goo;\n\t\t\ti.foo(10);\n\t\t}\n\t}\n\tprivate static void goo(Integer i) {\n\t\tSystem.out.println(i);\n\t}\n\tpublic static void main(String[] args) {\n\t\t new X().new Y().goo(); \n\t}\n}\n"}, "10");
    }

    public void test427483() {
        this.runConformTest(new String[]{"X.java", "import java.util.TreeSet;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew TreeSet<>((String qn1, String qn2) -> {\n\t\t\tboolean b = true;\n\t\t\tSystem.out.println(b); // ok\n\t\t\tif (b) {\n\t\t\t} // Eclipse says: b cannot be resolved or is not a field\n\t\t\treturn qn1.compareTo(qn2);\n\t\t});\n\t}\n}\n"}, "");
    }

    public void test427627() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\n  public static void main(String[] args) {\n    Runnable r = () -> {\n      List<SourceKey> keys = new ArrayList<>();\n\n      associate(\"Test\", keys.toArray(new SourceKey[keys.size()]));\n    };\n    r.run();\n  }\n  private static void associate(String o, SourceKey... keys) {\n\t  System.out.println(o);\n\t  System.out.println(keys.length);\n  }\n  public class SourceKey {\n    public SourceKey(Object source, Object key) {\n    }\n  }\n}\n"}, "Test\n0");
    }

    public void test427744() {
        this.runConformTest(new String[]{"X.java", "public class X {   \n    public static void main(String argv[]) {\n        int i = ((I) (x) -> { return 999; }).foo(true ? 0 : (Comparable) null);\n        System.out.println(i);\n    }\n    interface I {\n        int foo (Comparable arg); \n        default int foo (Object arg) { \n            return 0;\n        }\n    }\n}\n"}, "999");
    }

    public void test427962() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\nimport java.util.function.IntFunction;\nimport java.util.stream.Stream;\nimport java.util.stream.IntStream;\npublic class X {\n  static <A, B> Stream<B> objmap(Function<A, B> p1, A[] p2) {return Stream.of(p2).map(p1);}\n  static <B> Stream<B> intmap(IntFunction<B> p1, int[] p2) {return IntStream.of(p2).mapToObj(p1);}\n  public static void main(String[] args) {\n    Integer[] p12 = {1, 2, 3};\n    int[] p22 = {1, 2, 3};\n    //works\n    String[] a11 = objmap(String::valueOf, p12).<String> toArray(String[]::new);\n    String[] a21 = intmap(String::valueOf, p22).<String> toArray(String[]::new);\n    //does not work\n    String[] a12 = objmap(String::valueOf, p12).toArray(String[]::new);\n    String[] a22 = intmap(String::valueOf, p22).toArray(String[]::new);\n  }\n}\n"}, "");
    }

    public void test428112() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.Locale;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(Locale.lookup(Stream.of( \"de\", \"*-CH\" ).map(Locale.LanguageRange::new).collect(Collectors.toList()), \n                                   Arrays.asList(Locale.getAvailableLocales())));\n\t}\n}\n"}, "de");
    }

    public void test428003() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n    public static void main(String[] args) {\n        Arrays.sort(args, (String x, String y) -> x.length() - y.length());\n        Arrays.sort(args, (x, y) -> Integer.compare(x.length(), y.length()));\n    }\n}\n"}, "");
    }

    public void test428003a() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\npublic class X {\n    public static void main(String[] args) {\n        String[] words = {\"java\", \"interface\", \"lambda\", \"expression\" };\n        Arrays.sort(words, (String word1, String word2) -> {\n                    if (word1.length() < word2.length())\n                        return -1;\n                    else if (word1.length() > word2.length())\n                        return 1;\n                    else\n                        return 0;\n                  });\n        for (String word : words)\n            System.out.println(word);\n        words = new String [] {\"java\", \"interface\", \"lambda\", \"expression\" };\n        Arrays.sort(words, (word1, word2) -> Integer.compare(word1.length(), word2.length()));\n        for (String word : words)\n            System.out.println(word);\n        words = new String [] {\"java\", \"interface\", \"lambda\", \"expression\" };\n        Arrays.sort(words, (String word1, String word2) -> Integer.compare(word1.length(), word2.length()));\n        for (String word : words)\n            System.out.println(word);\n      }\n  }\n"}, "java\nlambda\ninterface\nexpression\njava\nlambda\ninterface\nexpression\njava\nlambda\ninterface\nexpression");
    }

    public void test428261() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX foo(int a);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tString s = \"Blah\";\n\t\tclass Local extends X {\n\t\t\tLocal(int a) {\n\t\t\t\tSystem.out.println(a);\n\t\t\t\tSystem.out.println(s);\n\t\t\t}\n\t\t}\n\t\tI i = Local::new; // Incorrect error here.\n       i.foo(10);\n\t}\n}\n"}, "10\nBlah");
    }

    public void test428261a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX foo(int a);\n}\npublic class X {\n\tvoid goo() {\n\t\tclass Local extends X {\n\t\t\tLocal(int a) {\n\t\t\t\tSystem.out.println(a);\n\t\t\t}\n\t\t}\n\t\tI i = Local::new;\n       i.foo(10);\n\t}\n   public static void main(String [] args) {\n        new X().goo();\n   }\n}\n"}, "10");
    }

    public void test428552() {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n\tinterface Example extends Serializable {\n\t\tString convert(Object o);\n\t}\n\tpublic static void main(String[] args) throws IOException {\n\t\tExample e=Object::toString;\n\t\ttry(ObjectOutputStream os=new ObjectOutputStream(new ByteArrayOutputStream())) {\n\t\t\tos.writeObject(e);\n\t\t}\n       System.out.println(\"No exception !\");\n\t}\n}\n"}, "No exception !", null, true, new String[]{"-Ddummy"});
    }

    public void test428642() {
        this.runConformTest(new String[]{"QuickSerializedLambdaTest.java", "import java.io.*;\nimport java.util.function.IntConsumer;\npublic class QuickSerializedLambdaTest {\n\tinterface X extends IntConsumer,Serializable{}\n\tpublic static void main(String[] args) throws IOException, ClassNotFoundException {\n\t\tX x1 = i -> System.out.println(i);// lambda expression\n\t\tX x2 = System::exit; // method reference\n\t\tByteArrayOutputStream debug=new ByteArrayOutputStream();\n\t\ttry(ObjectOutputStream oo=new ObjectOutputStream(debug))\n\t\t{\n\t\t\too.writeObject(x1);\n\t\t\too.writeObject(x2);\n\t\t}\n\t\ttry(ObjectInputStream oi=new ObjectInputStream(new ByteArrayInputStream(debug.toByteArray())))\n\t\t{\n\t\t\tX x=(X)oi.readObject();\n\t\t\tx.accept(42);// shall print 42\n\t\t\tx=(X)oi.readObject();\n\t\t\tx.accept(0);// shall exit\n\t\t}\n\t\tthrow new AssertionError(\"should not reach this point\");\n\t}\n}\n"}, "42", null, true, new String[]{"-Ddummy"});
    }

    public void test429112() {
        this.runConformTest(new String[]{"ArrayConstructorReference.java", "import java.io.Serializable;\nimport java.util.function.IntFunction;\npublic class ArrayConstructorReference {\n  interface IF extends IntFunction<Object>, Serializable {}\n  public static void main(String[] args) {\n    IF factory=String[][][]::new;\n    Object o = factory.apply(10);\n    System.out.println(o.getClass());\n    String [][][] sa = (String [][][]) o;\n    System.out.println(sa.length);\n  }\n}\n"}, "class [[[Ljava.lang.String;\n10");
    }

    public void test429112a() {
        this.runConformTest(new String[]{"ArrayConstructorReference.java", "import java.io.Serializable;\nimport java.util.function.IntFunction;\npublic class ArrayConstructorReference {\n  interface IF extends IntFunction<Object>, Serializable {}\n  public static void main(String[] args) {\n    IF factory=java.util.function.IntFunction[][][]::new;\n    Object o = factory.apply(10);\n    System.out.println(o.getClass());\n    java.util.function.IntFunction[][][] sa = (java.util.function.IntFunction[][][]) o;\n    System.out.println(sa.length);\n  }\n}\n"}, "class [[[Ljava.util.function.IntFunction;\n10");
    }

    public void test429112b() {
        this.runConformTest(new String[]{"ArrayConstructorReference.java", "import java.io.Serializable;\nimport java.util.function.IntFunction;\npublic class ArrayConstructorReference {\n  interface IF extends IntFunction<Object>, Serializable {}\n  public static void main(String[] args) {\n    IF factory=java.util.function.IntFunction[]::new;\n    Object o = factory.apply(10);\n    System.out.println(o.getClass());\n    java.util.function.IntFunction[] sa = (java.util.function.IntFunction[]) o;\n    System.out.println(sa.length);\n  }\n}\n"}, "class [Ljava.util.function.IntFunction;\n10");
    }

    public void test429112c() {
        this.runConformTest(new String[]{"ArrayConstructorReference.java", "import java.io.Serializable;\nimport java.util.function.IntFunction;\npublic class ArrayConstructorReference {\n  interface IF extends IntFunction<Object>, Serializable {}\n  public static void main(String[] args) {\n    IF factory=String[]::new;\n    Object o = factory.apply(10);\n    System.out.println(o.getClass());\n    String [] sa = (String []) o;\n    System.out.println(sa.length);\n  }\n}\n"}, "class [Ljava.lang.String;\n10");
    }

    public void test428857() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.function.Function;\npublic class X {\n    public static void main (String[] args) {\n        Function<List<String>, String> func = List::toString;\n        System.out.println(func.apply(Arrays.asList(\"a\", \"b\")));\n    }\n}\n"}, "[a, b]", customOptions);
    }

    public void test428857a() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\ninterface I {\n    List<String> getList();\n}\npublic class X {\n    public static void main (String[] args) {\n        I i = ArrayList::new;\n        System.out.println(i.getList());\n    }\n}\n"}, "[]", customOptions);
    }

    public void test428857b() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.function.Function;\ninterface I {\n    ArrayList<String> getList();\n}\npublic class X {\n    public static void main (String[] args) {\n        I i = ArrayList::new;\n        System.out.println(i.getList());\n    }\n}\n"}, "[]", customOptions);
    }

    public void test428857c() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "error");
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.ArrayList;\npublic class X {\n    public static void main (String[] args) {\n        Function<ArrayList<String>, String> func = List::toString;\n        System.out.println(func.apply(new ArrayList<>(Arrays.asList(\"a\", \"b\"))));\n    }\n}\n"}, "[a, b]", customOptions);
    }

    public void test429763() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n       try {\n\t\t    final int i = new Test<Integer>().test((Byte b) -> (int) b);\n       } catch (NullPointerException e) {\n            System.out.println(\"NPE\");\n       }\n\t}\n\tstatic class Test<R> {\n\t\t<T> R test(Function<T,R> f) {\n\t\t\treturn null;\n\t\t}\n\t}\n}\n"}, "NPE");
    }

    public void test429763a() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t// does not compile\n\t\tnew Test<Integer>().test((Byte b) -> (int) b);\n\t}\n\tstatic class Test<R> {\n\t\t<T> void test(Function<T,R> f) {\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test429759() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\nimport java.util.function.Supplier;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tfinal int i = new Test<Integer>().test(\"\", (String s) -> 1);\n\t}\n\tstatic class Test<R> {\n\t\t<T> R test(T t, Supplier<R> s) {\n\t\t\treturn s.get();\n\t\t}\n\t\t<T> R test(T t, Function<T, R> f) {\n\t\t\treturn f.apply(t);\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test429948() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Supplier;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\texecute(() -> {\n\t\t\texecuteInner(() -> {\n\t\t\t});\n\t\t\treturn null;\n\t\t});\n\t\tSystem.out.println(\"done\");\n\t}\n\tstatic <R> R execute(Supplier<R> supplier) {\n\t\treturn null;\n\t}\n\tstatic void executeInner(Runnable callback) {\n\t}\n}\n"}, "done");
    }

    public void test429969() {
        this.runConformTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.Optional;\npublic class X {\n    public static void main(String[] args) {\n        final String s = Arrays.asList(\"done\").stream().reduce(null, (s1,s2) -> {\n                // THE FOLLOWING LINE CAUSES THE PROBLEM\n                require(s1 != null || s2 != null, \"both strings are null\");\n                    return (s1 != null) ? s1 : s2;\n            }, (s1,s2) -> (s1 != null) ? s1 : s2);\n\t\n        System.out.println(s);\n    }\n    static void require(boolean condition, String msg) throws RuntimeException {\n        if (!condition) {\n            throw new RuntimeException(msg);\n        }\n    }\n}\n"}, "done");
    }

    public void test430015() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Method;\nimport java.lang.reflect.Parameter;\nimport java.util.Arrays;\nimport java.util.function.IntConsumer;\npublic class X {\n    IntConsumer xx(int a) {\n        return i -> { };\n    }\n    public static void main(String[] args) {\n        Method[] methods = X.class.getDeclaredMethods();\n        for (Method method : methods) {\n        \tif (method.getName().contains(\"lambda\")) {\n         \t\tParameter[] parameters = method.getParameters();\n        \t\tSystem.out.println(Arrays.asList(parameters));\n        \t}\n        }\n    }\n}\n"}, "[int arg0]");
    }

    public void test430040() {
        this.runConformTest(new String[]{"X.java", "public class X {\n    public static void main(String [] args) {\n        System.out.println(\"OK\");\n    }\n    class Observable<T> {}\n    class ObservableValue<T> {}\n    interface InvalidationListener {\n        public void invalidated(Observable observable);\n    }\n    public interface ChangeListener<T> {\n        void changed(ObservableValue<? extends T> observable, T oldValue, T newValue);\n    }\n    static class ExpressionHelper<T> {}\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, InvalidationListener listener) {\n        return helper;\n    }\n    public static <T> ExpressionHelper<T> addListener(ExpressionHelper<T> helper, ObservableValue<T> observable, ChangeListener<? super T> listener) {\n        return helper;\n    }\n    private ExpressionHelper<Object> helper;\n    public void junk() {\n        helper = (ExpressionHelper<Object>) addListener(helper, null, (Observable o) -> {throw new RuntimeException();});\n        helper = addListener(helper, null, (Observable o) -> {throw new RuntimeException();});\n    }\n}\n"}, "OK");
    }

    public void test430043() {
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.IOException;\nimport java.io.StringReader;\nimport java.nio.file.Files;\nimport java.text.MessageFormat;\nimport java.util.*;\nimport java.util.function.Function;\nimport java.util.jar.Attributes;\nimport java.util.jar.JarFile;\nimport java.util.jar.Manifest;\npublic class X<T>  {\n    public X(String name, String description, String id, Class<T> valueType, String[] fallbackIDs, Function<Map<String, ? super Object>, T> defaultValueFunction, boolean requiresUserSetting, Function<String, T> stringConverter) {\n    }\n    public static final X<String> NAME  =\n            new X<>(\n                    null,\n                    null,\n                    null,\n                    String.class,\n                    null,\n                    params -> {throw new IllegalArgumentException(\"junk14\");},\n                    true,\n                    s -> s\n            );\n     public static void main(String [] args) {\n         System.out.println(\"OK\");\n     }\n}\n"}, "OK");
    }

    public void test430035() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Consumer;\npublic class X {\n    interface StringConsumer extends Consumer<String> {\n        void accept(String t);\n    }\n    public static void main(String... x) {\n      StringConsumer c = s->System.out.println(\"m(\"+s+')');\n      c.accept(\"direct call\");\n      Consumer<String> c4b=c;\n      c4b.accept(\"bridge method\");\n    }\n}\n"}, "m(direct call)\nm(bridge method)");
    }

    public void test430035a() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Consumer;\npublic class X {\n    interface StringConsumer extends Consumer<String> {\n        void accept(String t);\n    }\n    static void m(String s) { System.out.println(\"m(\"+s+\")\"); } \n    public static void main(String... x) {\n      StringConsumer c = X::m;\n      c.accept(\"direct call\");\n      Consumer<String> c4b=c;\n      c4b.accept(\"bridge method\");\n    }\n}\n"}, "m(direct call)\nm(bridge method)");
    }

    public void test430035b() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tvoid foo(T t);\n}\ninterface J<T> {\n\tvoid foo(T t);\n}\ninterface K extends I<String>, J<String> {\n}\npublic class X {\n    public static void main(String... x) {\n      K k = s -> System.out.println(\"m(\"+s+')');\n      k.foo(\"direct call\");\n      J<String> j = k;\n      j.foo(\"bridge method\");\n      I<String> i = k;\n      i.foo(\"bridge method\");\n    }\n}\n"}, "m(direct call)\nm(bridge method)\nm(bridge method)");
    }

    public void test430035c() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tvoid foo(String t, T u);\n}\ninterface J<T> {\n\tvoid foo(T t, String u);\n}\ninterface K extends I<String>, J<String> {\n\tvoid foo(String t, String u);\n}\npublic class X {\n    public static void main(String... x) {\n      K k = (s, u) -> System.out.println(\"m(\"+ s + u + ')');\n      k.foo(\"direct\", \" call\");\n      J<String> j = k;\n      j.foo(\"bridge\",  \" method(j)\");\n      I<String> i = k;\n      i.foo(\"bridge\",  \" method(i)\");\n    }\n}\n"}, "m(direct call)\nm(bridge method(j))\nm(bridge method(i))");
    }

    public void test430035d() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tvoid foo(String t, T u);\n}\ninterface J<T> {\n\tvoid foo(T t, String u);\n}\ninterface K extends I<String>, J<String> {\n}\npublic class X {\n    public static void main(String... x) {\n      K k = (s, u) -> System.out.println(\"m(\"+ s + u + ')');\n      k.foo(\"direct\", \" call\");\n      J<String> j = k;\n      j.foo(\"bridge\",  \" method(j)\");\n      I<String> i = k;\n      i.foo(\"bridge\",  \" method(i)\");\n    }\n}\n"}, "m(direct call)\nm(bridge method(j))\nm(bridge method(i))");
    }

    public void test430035e() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tObject foo(String t, T u);\n}\ninterface J<T> {\n\tString foo(T t, String u);\n}\ninterface K extends I<String>, J<String> {\n}\npublic class X {\n    public static void main(String... x) {\n      K k = (s, u) -> s + u;\n      System.out.println(k.foo(\"direct\", \" call\"));\n      J<String> j = k;\n      System.out.println(j.foo(\"bridge\",  \" method(j)\"));\n      I<String> i = k;\n      System.out.println(i.foo(\"bridge\",  \" method(i)\"));\n    }\n}\n"}, "direct call\nbridge method(j)\nbridge method(i)");
    }

    public void test430035f() {
        this.runConformTest(new String[]{"X.java", "interface I<T> {\n\tObject foo(String t, String u);\n}\ninterface J<T> {\n\tString foo(String t, String u);\n}\ninterface K extends I<String>, J<String> {\n}\npublic class X {\n    public static void main(String... x) {\n      K k = (s, u) -> s + u;\n      System.out.println(k.foo(\"direct\", \" call\"));\n      J<String> j = k;\n      System.out.println(j.foo(\"bridge\",  \" method(j)\"));\n      I<String> i = k;\n      System.out.println(i.foo(\"bridge\",  \" method(i)\"));\n    }\n}\n"}, "direct call\nbridge method(j)\nbridge method(i)");
    }

    public void test430241() {
        this.runConformTest(new String[]{"X.java", "interface K extends I, J {\n}\ninterface I {\n    Comparable<Integer> foo();\n}\ninterface J {\n    Comparable foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tK k = () -> null;\n\t\tSystem.out.println(k.foo());\n\t}\n}\n"}, "null");
    }

    public void test430310() {
        this.runConformTest(new String[]{"X.java", "interface Func1<T1, R> {\n        R apply(T1 v1);\n        void other();\n}\n@FunctionalInterface // spurious error: F1<T, R> is not a functional interface\npublic interface X<T1, R> extends Func1<T1, R> {\n\tdefault void other() {}\n   public static void main(String [] args) {\n       System.out.println(\"OK\");\n   }\n}\n"}, "OK");
    }

    public void test430310a() {
        this.runConformTest(new String[]{"X.java", "@FunctionalInterface\npublic interface X<T1, T2, R> {\n    R apply(T1 v1, T2 v2);\n    default void other() {}\n    public static void main(String[] args) {\n        System.out.println(\"OK\");\n    }\n}\n"}, "OK");
    }

    public void test430310b() {
        this.runConformTest(new String[]{"X.java", "interface I1 {\n\tint foo(String s);\n}\n@FunctionalInterface\ninterface A1 extends I1 {\n\t@Override\n\tdefault int foo(String s) {\n\t\treturn -1;\n\t}\n\tint foo(java.io.Serializable s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, "OK");
    }

    public void test430310c() {
        this.runConformTest(new String[]{"X.java", "interface I2 {\n\tint foo(String s);\n}\n@FunctionalInterface\ninterface A2 extends I2 {\n\t@Override\n\tdefault int foo(String s) {\n\t\treturn -1;\n\t}\n\tint bar(java.io.Serializable s);\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, "OK");
    }

    public void test432619() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.function.BiConsumer;\npublic interface X<E extends Exception> {\n\tstatic void foo() {\n\t    BiConsumer<double[][], Double> biConsumer2 = Re2::accumulate;\n\t}\n\tstatic class Re2 {\n\t    static void accumulate(double[][] container, Double value) {}\n\t}\n   public static void main(String [] args) {\n       System.out.println(\"OK\");\n   }\n}\n"}, "OK");
    }

    public void test432619a() throws Exception {
        this.runConformTest(new String[]{"StreamInterface.java", "import java.util.Map;\nimport java.util.stream.Collector;\npublic interface StreamInterface<E extends Exception> {\n\tstatic class DoubleCo {\n\t\tprivate static class Re2 {\n\t\t\tstatic <K, E extends Exception> Map<K, double[]> internalToMapToList2() {\n\t\t\t\tCollector<Double, double[][], double[][]> toContainer1 = Collector.of(\n\t\t\t\t//The method supply() from the type StreamInterface.DoubleCo.Re2 should be accessed in a static way\n\t\t\t\t  StreamInterface.DoubleCo.Re2::supply,\n\t\t\t\t  //The method accumulate(double[][], Double) from the type StreamInterface.DoubleCo.Re2 should be accessed in a static way\n\t\t\t\t  StreamInterface.DoubleCo.Re2::accumulate,\n\t\t\t\t  //The method combine(double[][], double[][]) from the type StreamInterface.DoubleCo.Re2 should be accessed in a static way\n\t\t\t\t  StreamInterface.DoubleCo.Re2::combine);\n\t\t\t\tCollector<Double, double[][], double[][]> toContainer2 =\n\t\t\t\t//All 3 from above:\n\t\t\t\t  Collector.of(DoubleCo.Re2::supply, DoubleCo.Re2::accumulate, DoubleCo.Re2::combine);\n\t\t\t\treturn null;\n\t\t\t}\n\t\t\tprivate static double[][] supply() {\n\t\t\t\treturn new double[64][];\n\t\t\t}\n\t\t\tprivate static void accumulate(double[][] container, Double value) {}\n\t\t\tprivate static double[][] combine(double[][] container, double[][] containerRight) {\n\t\t\t\treturn new double[container.length + containerRight.length][];\n\t\t\t}\n\t\t}\n\t}\n     public static void main(String [] args) {\n         System.out.println(\"OK\");\n     }\n}\n"}, "OK");
    }

    public void test432682() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.Optional;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tOptional<String> userName = Optional.of(\"sa\");\n\t\tOptional<String> password = Optional.of(\"sa\");\n\t\tboolean isValid = userName.flatMap(u -> {\n\t\t\treturn password.map(p -> {\n\t\t\t\treturn u.equals(\"sa\") && p.equals(\"sa\");\n\t\t\t});\n\t\t}).orElse(false);\n\t\tSystem.out.println(isValid);\n\t}\n}\n"}, "true");
    }

    public void test432520() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void withProvider(Provider<String> provider) { }\n\tpublic static void main(String [] args) {\n\t\twithProvider(() -> \"user\");\n\t}\n}\ninterface ParentProvider<T> {\n\tT get();\n}\n// if you remove the extends clause everything works fine\ninterface Provider<T> extends ParentProvider<T> {\n\tT get();\n}\n"}, "");
    }

    public void test432625() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.Stream;\npublic class X {\n    public static void main(String[] args) {\n        Stream<?> stream = Stream.of(\"A\");\n        stream.map(x -> (String) x);\n    }\n}\n"}, "");
    }

    public void test430766() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Comparator;\nimport java.util.List;\npublic class X {\n\tstatic class Person {\n\t\tprivate String email;\n\t\tpublic Person(String email) {\n\t\t\tthis.email = email;\n\t\t}\n\t\tpublic String getEmail() {\n\t\t\treturn email;\t\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tList<Person> persons = new ArrayList<Person>();\n\t\tpersons.add(new Person(\"joe.smith@gmail.com\"));\n\t\tpersons.add(new Person(\"alice.smith@gmail.com\"));\n\t\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::getEmail)));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::getEmail)));\n\t                                             ^^^^^^^^^\nThe method nullsLast(Comparator<? super T>) in the type Comparator is not applicable for the arguments (Person::getEmail)\n----------\n2. ERROR in X.java (at line 17)\n\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::getEmail)));\n\t                                                       ^^^^^^^^^^^^^^^^\nThe type X.Person does not define getEmail(T, T) that is applicable here\n----------\n");
    }

    public void test430766a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Comparator;\nimport java.util.List;\nimport java.io.Serializable;\npublic class X {\n\tstatic class Person {\n\t\tprivate String email;\n\t\tpublic Person(String email) {\n\t\t\tthis.email = email;\n\t\t}\n\t\tpublic String getEmail() {\n\t\t\treturn email;\t\t}\n\tpublic static <T extends Runnable,V extends Serializable> int isRunnable(T first, V second) {\n\t\treturn (second instanceof Runnable) ? 1 : 0;\n\t}\n\t}\n\tpublic static void main(String[] args) {\n\t\tList<Person> persons = new ArrayList<Person>();\n\t\tpersons.add(new Person(\"joe.smith@gmail.com\"));\n\t\tpersons.add(new Person(\"alice.smith@gmail.com\"));\n\t\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::<Runnable>isRunnable)));\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 21)\n\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::<Runnable>isRunnable)));\n\t                                             ^^^^^^^^^\nThe method nullsLast(Comparator<? super T>) in the type Comparator is not applicable for the arguments (Person::<Runnable>isRunnable)\n----------\n2. ERROR in X.java (at line 21)\n\tpersons.sort(Comparator.comparing(Comparator.nullsLast(Person::<Runnable>isRunnable)));\n\t                                                       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe type X.Person does not define isRunnable(T, T) that is applicable here\n----------\n");
    }

    public void test431190() throws Exception {
        this.runConformTest(new String[]{"Java8VerifyError.java", "public class Java8VerifyError {\n    public static class Foo {\n        public Object get() {\n            return new Object();\n        }\n    }\n    @FunctionalInterface\n    public static interface Provider<T> {\n        public T get();\n    }\n    public static void main(String[] args) {\n        Provider<Foo> f = () -> new Foo();\n        Provider<Provider<Object>> meta = () -> f.get()::get;\n    }\n}\n"}, "");
    }

    public void test431514() {
        this.runConformTest(new String[]{"X.java", "class X {\n\tvoid fun1(int x) {\n\t\tclass Local {\n\t\t\tFI test= () -> {\n\t\t\t\ttry {\n\t\t\t\t} catch (Exception e) {\n\t\t\t\t\tint x;\n\t\t\t\t};\n\t\t\t};\n\t\t}\n\t}\n}\ninterface FI {\n\tvoid foo();\n}"});
    }

    public void test431514a() {
        this.runConformTest(new String[]{"X.java", "class X {\n\tvoid fun1(int x) {\n\t\tclass Local {\n\t\t\tclass L1 { }\n\t\t\tint y;\n\t\t\tFI test= () -> {\n\t\t\t\tclass L1 { } \n\t\t\t\tint y; \n\t\t\t};\n\t\t}\n\t}\n\t\n}\ninterface FI {\n\tvoid foo();\n}"});
    }

    public void test432531() {
        this.runConformTest(new String[]{"Y.java", "import java.util.function.Supplier;\nclass E {\n\tE(Supplier<Object> factory) { }\n}\npublic class Y extends E {\n\tY() {\n\t\tsuper(() -> new Object() {\n\t\t});\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Y();\n\t}\n}"});
    }

    public void test434297() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.Collections;\nimport java.util.Comparator;\nimport java.util.List;\npublic class X {\n  public static void main(String[] args) {\n  }\n  public void bla() {\n    boolean b = Boolean.TRUE.booleanValue();\n    List<String> c1 = new ArrayList<>();\n    Collections.sort(c1, b ? null : new Bar(new ArrayList<>(),Comparator.nullsLast((a,e) -> {return 0;})));\n  }\n  private static class Bar implements Comparator<String>{\n\t  public <T> Bar(Collection<T> col, Comparator<T> comp) { }\n\t@Override\n\tpublic int compare(String o1, String o2) {\n\t\treturn 0;\n\t}\n  }\n}"});
    }

    public void test436542() throws Exception {
        this.runConformTest(new String[]{"Utility.java", "import java.util.Collection;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\npublic class Utility {\n    public static void main(String[] args) {\n        System.out.println(\"Success\");\n    }\n    public static <T, R> List<R> mapList(Collection<T> original, Function<T, R> func) {\n        return original.stream().map(func).collect(Collectors.toList());\n    }\n    public static <S, T> void bindMap(List<T> dest, ObservableList<S> src, Function<S, T> func) {\n        dest.addAll(mapList(src, func));\n        src.addListener((ListChangeListener<S>) changes -> {\n            for (int i = changes.getFrom(); i < changes.getTo(); i++)\n                dest.set(i, func.apply(src.get(i)));\n        });\n    }\n    public interface ObservableList<E> extends List<E> {\n        public void addListener(ListChangeListener<? super E> listener);\n    }\n    @FunctionalInterface\n    public interface ListChangeListener<E> {\n        public abstract static class Change<E> {\n            public abstract int getFrom();\n            public abstract int getTo();\n        }\n        public void onChanged(Change<? extends E> c);\n    }\n}"}, "Success", org.eclipse.jdt.core.tests.util.Util.concatWithClassLibs(new String[]{OUTPUT_DIR}, false), true, null);
        IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((String)(String.valueOf(OUTPUT_DIR) + File.separator + "Utility.class"), (int)65535);
        IMethodInfo lambdaMethod = null;
        IMethodInfo[] methodInfos = classFileReader.getMethodInfos();
        int length = methodInfos.length;
        int i = 0;
        while (i < length) {
            IMethodInfo methodInfo = methodInfos[i];
            if ("lambda$0".equals(new String(methodInfo.getName()))) {
                lambdaMethod = methodInfo;
                break;
            }
            ++i;
        }
        LambdaExpressionsTest.assertNotNull((String)"Could not find lambda method", lambdaMethod);
        IClassFileAttribute signature = Util.getAttribute(lambdaMethod, (char[])IAttributeNamesConstants.SIGNATURE);
        LambdaExpressionsTest.assertNull((String)"Found generic signature for lambda method", (Object)signature);
    }

    public void test439515() {
        this.runConformTest(new String[]{"X.java", "interface Fun<T, R> {\n\tR apply(T arg);\n}\npublic class X {\n\tint size() {\n\t\treturn -1;\n\t}\n\tint size(Object arg) {\n\t\treturn 0;\n\t}\n\tint size(X arg) {\n\t\treturn 1;\n\t}\n\tpublic static void main(String args[]) {\n\t\tFun<X, Integer> f1 = X::size;\n\t\tSystem.out.println(f1.apply(new X()));\n\t}\n}\n"}, "-1");
    }

    public void test439515a() {
        this.runConformTest(new String[]{"X.java", "interface Fun<T, R> {\n\tR apply(T arg);\n}\npublic class X {\n\tstatic int size() {\n\t\treturn -1;\n\t}\n\tstatic int size(Object arg) {\n\t\treturn 0;\n\t}\n\tstatic int size(X arg) {\n\t\treturn 1;\n\t}\n\tpublic static void main(String args[]) {\n\t\tFun<X, Integer> f1 = X::size;\n\t\tSystem.out.println(f1.apply(new X()));\n\t}\n}\n"}, "1");
    }

    public void test438534() {
        this.runConformTest(new String[]{"ByteCodeTest.java", "import java.lang.reflect.Method;\nimport java.security.AccessController;\nimport java.security.PrivilegedAction;\nimport java.util.Collections;\nimport java.util.Comparator;\npublic class ByteCodeTest {\n  public static class BrokenByteCode {\n    public void hello() {\n      Collections.sort(Collections.<String> emptyList(), Comparator.comparing((String data) -> data.length()));\n    }\n  }\n  public static void main(String[] args) {\n    for (Method method : AccessController.doPrivileged((PrivilegedAction<Method[]>) () -> BrokenByteCode.class.getDeclaredMethods())) {\n      method.getGenericExceptionTypes();\n      method.getGenericParameterTypes();\n      method.getGenericReturnType();\n    }\n    System.out.println(\"SUCCESS\");\n  }\n}\n"}, "SUCCESS");
    }

    public void test440152() {
        this.runConformTest(new String[]{"Foo.java", "import java.util.function.Function;\ninterface Foo {void alpha(Bar pBar);}\nclass Bar {Object bravo() {return null;}}\nclass Test {\n  Test(Function pFunction) {\n    class Baz {public Baz(Object pObj) {pFunction.apply(pObj);}}\n    delta(pBar -> charlie(new Baz(pBar.bravo())));\n  }\n  void charlie(Object pRemovals) {}\n  void delta(Foo pListener) {}\n}"});
    }

    public void test440152a() {
        this.runConformTest(new String[]{"Foo.java", "import java.util.function.Function;\ninterface Foo {void alpha(Bar pBar);}\nclass Bar {Object bravo() {return null;}}\nclass Test {\n\tTest(Function pFunction) {\n\t    class Baz {\n\t    \tpublic Baz(Object pObj) {\n\t    \t}\n\t    \tclass NestedBaz extends Baz {\n\t    \t\tNestedBaz(Object pObj) {\n\t    \t\t\tsuper(pObj);\n\t    \t\t\tpFunction.apply(pObj);\n\t    \t\t}\n\t    \t}\n\t    \t}\n\t    delta(pBar -> charlie(new Baz(pBar).new NestedBaz(pBar.bravo())));\n\t  }\n\t  void charlie(Object pRemovals) {}\n\t  void delta(Foo pListener) {}\n}\n"});
    }

    public void test432110() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Function;\npublic interface X {\n    default void test() {\n        testee().flatMap(_warning_ -> {\n            return result().map(s -> 0);\n        });\n    }\n    Either<Integer, Integer> testee();\n    Either<Integer, String> result();\n    static interface Either<L, R> {\n        <U> Either<L, U> flatMap(Function<? super R, Either<L, U>> mapper);\n        <U> Either<L, U> map(Function<? super R, U> mapper);\n    }\n    public static void main(String [] args) {\n        System.out.println(\"OK\");\n    }\n}\n"}, "OK");
    }

    public void test441929() {
        this.runNegativeTest(new String[]{"Y.java", "public class Y {\n    @FunctionalInterface\n    interface X {\n        public void x();\n    }\n    public void z(X x) {\n    }\n    public <T> void test() {\n        z(() -> {\n            try {\n                @SuppressWarnings(\"unchecked\")   // (1)\n                Class<? extends T> klass = (Class<? extends T>) Class.forName(\"java.lang.Object\");   // (2)\n                System.out.println(klass.getName());\n            } catch (Exception e) {\n                e.printStackTrace();\n            }\n        });\n    }\n}\n"}, "");
    }

    public void test437781() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Consumer;\nimport java.util.function.Function;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tnew X().visit( System.out::println );\n\t}\n\tpublic boolean visit(Function<Integer, Boolean> func) {\n\t\tSystem.out.println(\"Function\");\n\t\treturn true;\n\t}\n\tpublic void visit(Consumer<Integer> func) {\n\t\tSystem.out.println(\"Consumer\");\n\t}\t\n}\n"}, "Consumer");
    }

    public void test443889() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.BiConsumer;\nimport java.util.function.Consumer;\npublic class X {\n    public interface CurryBiConsumer<T, U> extends BiConsumer<T, U> {\n        default public CurryConsumer<U> curryFirst(T t) {\n            return (u) -> accept(t, u);\n        }\n        default public CurryConsumer<T> currySecond(U u) {\n            return (t) -> accept(t, u);\n        }\n    }\n    public interface CurryConsumer<T> extends Consumer<T> {\n        default public Runnable curry(T t) {\n            return () -> accept(t);\n        }\n    }\n    static void execute(Runnable r) {\n        System.out.println(\"BEFORE\");\n        r.run();\n        System.out.println(\"AFTER\");\n    }\n    static void display(String str, int count) {\n        System.out.println(\"DISP: \" + str + \" \" + count);\n    }\n    public static void main(String[] args) {\n        CurryBiConsumer<String, Integer> bc = X::display;\n        execute(bc.curryFirst(\"Salomon\").curry(42));\n    }\n}\n"}, "BEFORE\nDISP: Salomon 42\nAFTER");
    }

    public void test441907() {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.util.function.Predicate;\nimport java.util.stream.Stream;\npublic class X {\n  public static class FooBar<V> {\n  }\n  public interface FooBarred {\n    public <V> boolean hasFooBar(final FooBar<V> fooBar);\n  }\n  public interface Widget extends FooBarred {\n  }\n  public static void test() {\n    Set<FooBar<?>> foobars = new HashSet<>();\n    Set<Widget> widgets = new HashSet<>();\n    Stream<X.FooBar<?>> s = null;\n    FooBarred fb = null;\n    fb.hasFooBar((FooBar<?>) null);\n    boolean anyWidgetHasFooBar = widgets.stream().anyMatch(\n        widget -> foobars.stream().anyMatch(widget::hasFooBar)\n        );\n  }\n}\n"}, "");
    }

    public void test444773() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Optional;\n \npublic class X {\n  static class Container {\n    final private String s;\n    public Container(String s) { this.s = s; }\n  }\n \n  public static void main(String[] args) {\n    final List<Container> list = new ArrayList<>();\n    final Optional<String> optStr = Optional.of(\"foo\");\n    list.add(new Container(optStr.orElseThrow(() -> new IllegalStateException()))); // Error here\n \n    // This will work:\n    final String s = optStr.orElseThrow(IllegalStateException::new);\n    list.add(new Container(s));\t\n  }\n}\n"}, "");
    }

    public void test444772() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Optional;\n \npublic class X {\n  static class Container {\n    final private String s;\n    public Container(String s) { this.s = s; }\n  }\n \n  public static void main(String[] args) {\n    final List<Container> list = new ArrayList<>();\n    final Optional<String> optStr = Optional.of(\"foo\");\n    list.add(new Container(optStr.orElseThrow(IllegalStateException::new))); // Error here\n \n    // This will work:\n    final String s = optStr.orElseThrow(IllegalStateException::new);\n    list.add(new Container(s));\t\n  }\n}\n"}, "");
    }

    public void test444803() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\npublic class X {\n    X abc = null;\n    public static void main(String[] args) {\n        new X();\n    }\n    private void doSth() {\n        final List<String> l = new ArrayList<>();\n        try {\n            System.out.println(\"ok\");\n        } finally {\n            Runnable r = () -> abc.terminateInstances(abc.withInstanceIds(l));\n        }\n    }\n    public void terminateInstances(X abc) {\n    }\n    public X withInstanceIds(Collection<String> arg0) {\n    \treturn null;\n    }\n}\ninterface FI {\n\tpublic void foo(Collection<String> arg0);\n}\n"}, "");
    }

    public void test444785() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.function.Function;\npublic interface X {\n\t@FunctionalInterface\n\tstatic interface Function1<T1, R> extends Function<T1, R>, Serializable {\n\t\t@Override\n\t\tR apply(T1 t1);\n\t}\n\t@FunctionalInterface\n\tstatic interface Function6<T1, T2, T3, T4, T5, T6, R> extends Serializable {\n\t\tR apply(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6);\n\t\tdefault Function1<T1, Function1<T2, Function1<T3, Function1<T4, Function1<T5, Function1<T6, R>>>>>> curried() {\n\t\t\treturn t1 -> t2 -> t3 -> t4 -> t5 -> t6 -> apply(t1, t2, t3, t4, t5, t6);\n\t\t}\n\t\tdefault Function1<Tuple6<T1, T2, T3, T4, T5, T6>, R> tupled() {\n\t\t\treturn t -> apply(t._1, t._2, t._3, t._4, t._5, t._6);\n\t\t}\n\t}\n\tstatic final class Tuple6<T1, T2, T3, T4, T5, T6> {\n\t\tpublic final T1 _1;\n\t\tpublic final T2 _2;\n\t\tpublic final T3 _3;\n\t\tpublic final T4 _4;\n\t\tpublic final T5 _5;\n\t\tpublic final T6 _6;\n\t\tpublic Tuple6(T1 t1, T2 t2, T3 t3, T4 t4, T5 t5, T6 t6) {\n\t\t\tthis._1 = t1;\n\t\t\tthis._2 = t2;\n\t\t\tthis._3 = t3;\n\t\t\tthis._4 = t4;\n\t\t\tthis._5 = t5;\n\t\t\tthis._6 = t6;\n\t\t}\n\t}\n}\n"}, "");
    }

    public void test447119() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Method;\nimport java.lang.reflect.Parameter;\nimport java.util.Arrays;\nimport java.util.function.Function;\nimport java.util.List;\npublic class X {\n    private static List<String> foo(List<String> x){return x;}\n    public static void main(String[] args) {\n        Function<List<String>,List<String>> f = i -> { return i; };\n        Method[] methods = X.class.getDeclaredMethods();\n        for (Method m : methods) {\n        \tif (m.getName().contains(\"lambda\")) {\n        \t\tSystem.out.println(\"- \" + m.getGenericReturnType() + \" \" + m.getName() + \"(\" + Arrays.asList(m.getGenericParameterTypes()) + \")\");\n        \t}\n        }\n    }\n}\n"}, "- interface java.util.List lambda$0([interface java.util.List])");
    }

    public void test447119a() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Method;\nimport java.lang.reflect.Parameter;\nimport java.util.Arrays;\nimport java.util.function.Function;\nimport java.util.List;\npublic class X {\n    private static List<String> foo(List<String> x){return x;}\n    public static void main(String[] args) {\n        Function<List<String>,List<String>> f = X::foo;\n        Method[] methods = X.class.getDeclaredMethods();\n        for (Method m : methods) {\n        \tif (m.getName().contains(\"lambda\")) {\n        \t\tSystem.out.println(\"- \" + m.getGenericReturnType() + \" \" + m.getName() + \"(\" + Arrays.asList(m.getGenericParameterTypes()) + \")\");\n        \t}\n        }\n    }\n}\n"}, "");
    }

    public void test447119b() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Method;\nimport java.lang.reflect.Parameter;\nimport java.util.Arrays;\nimport java.util.function.Function;\nimport java.util.List;\nimport java.io.Serializable;public class X {\n    private static interface SerializableFunction<A, R> extends Function<A, R>, Serializable { }    private static List<String> foo(List<String> x){return x;}\n    public static void main(String[] args) {\n        SerializableFunction<List<String>, List<String>> f = i -> { return i; };\n        Method[] methods = X.class.getDeclaredMethods();\n        for (Method m : methods) {\n        \tif (m.getName().contains(\"lambda\")) {\n        \t\tSystem.out.println(\"- \" + m.getGenericReturnType() + \" \" + m.getName() + \"(\" + Arrays.asList(m.getGenericParameterTypes()) + \")\");\n        \t}\n        }\n    }\n}\n"}, "- interface java.util.List lambda$0([interface java.util.List])");
    }

    public void test447119c() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Method;\nimport java.lang.reflect.Parameter;\nimport java.util.Arrays;\nimport java.util.function.Function;\nimport java.util.List;\nimport java.io.Serializable;public class X {\n    private static interface SerializableFunction<A, R> extends Function<A, R>, Serializable { }    private static List<String> foo(List<String> x){return x;}\n    public static void main(String[] args) {\n        SerializableFunction<List<String>, List<String>> f = X::foo;\n        Method[] methods = X.class.getDeclaredMethods();\n        for (Method m : methods) {\n        \tif (m.getName().contains(\"foo\")) {\n        \t\tSystem.out.println(\"- \" + m.getGenericReturnType() + \" \" + m.getName() + \"(\" + Arrays.asList(m.getGenericParameterTypes()) + \")\");\n        \t}\n        }\n    }\n}\n"}, "- java.util.List<java.lang.String> foo([java.util.List<java.lang.String>])");
    }

    public void test447119d() {
        String[] stringArray;
        String[] stringArray2 = new String[]{"X.java", "import java.io.ObjectStreamClass;\nimport java.io.Serializable;\nimport java.lang.invoke.SerializedLambda;\nimport java.lang.reflect.Method;\nimport java.util.List;\nimport java.util.function.Function;\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\npublic class X {\n\tprivate static interface SerializableFunction<A, R> extends Function<A, R>, Serializable { }\n\tprivate static List<String> noop(List<String> l) { return l; }\n\tpublic static void main(String[] args) throws Exception {\n\t\tSerializableFunction<List<String>, List<String>> f = X::noop;\n\t\tMethod invokeWriteReplaceMethod = ObjectStreamClass.class.getDeclaredMethod(\"invokeWriteReplace\", Object.class);\n\t\tinvokeWriteReplaceMethod.setAccessible(true);\n\t\tSerializedLambda l = (SerializedLambda)invokeWriteReplaceMethod.invoke(ObjectStreamClass.lookupAny(f.getClass()), f);\n\t\tSystem.out.println(\"Lambda binds to: \" + l.getImplClass() + \".\" + l.getImplMethodName());\n\t\tSystem.out.println(\"Methods (with generics):\");\n\t\tList<String> list = new ArrayList<String>();\n\t\tfor(Method m : X.class.getDeclaredMethods()) {\n\t\t\tif(m.getName().equals(\"main\")) continue;\n\t\t\tif(m.getName().contains(\"deserializeLambda\")) continue;\n\t\t\tlist.add(\"- \" + m.getGenericReturnType() + \" \" + m.getName() + \"(\" + m.getGenericParameterTypes()[0] + \")\");\n\t\t}\n\t\tCollections.sort(list, new Comparator<String>() {\n\t\t\tpublic int compare(String s1, String s2) {\n\t\t\t\treturn s1.compareTo(s2);\n\t\t\t}\n\t\t});\n\t\tSystem.out.println(list.toString());\n\t}\n}\n"};
        if (isJRE9) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "--add-opens";
            stringArray = stringArray3;
            stringArray3[1] = "java.base/java.io=ALL-UNNAMED";
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "-Ddummy";
        }
        this.runConformTest(stringArray2, "Lambda binds to: X.noop\nMethods (with generics):\n[- java.util.List<java.lang.String> noop(java.util.List<java.lang.String>)]", null, true, stringArray);
    }

    public void test447119e() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Method;\nimport java.lang.reflect.Parameter;\nimport java.util.Arrays;\nimport java.util.function.Function;\nimport java.util.List;\npublic class X implements java.io.Serializable {\n    private static List<String> foo(List<String> x){return x;}\n    public static void main(String[] args) {\n        Function<List<String>,List<String>> f = X::foo;\n        Method[] methods = X.class.getDeclaredMethods();\n        for (Method m : methods) {\n        \tif (m.getName().contains(\"lambda\")) {\n        \t\tSystem.out.println(\"- \" + m.getGenericReturnType() + \" \" + m.getName() + \"(\" + Arrays.asList(m.getGenericParameterTypes()) + \")\");\n        \t}\n        }\n    }\n}\n"}, "");
    }

    public void test432605() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.function.Function;\nimport java.util.function.Supplier;\nimport java.util.stream.Collector;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\npublic class X {\nstatic <T, E extends Exception, K, L, M> M terminalAsMapToList(\n    Function<? super T, ? extends K> classifier,\n    Function<HashMap<K, L>, M> intoMap,\n    Function<ArrayList<T>, L> intoList,\n    Supplier<Stream<T>> supplier,\n    Class<E> classOfE) throws E {\n  \treturn terminalAsCollected(\n  \t  classOfE,\n  \t  Collectors.collectingAndThen(\n  \t    Collectors.groupingBy(\n  \t      classifier,\n  \t      HashMap<K, L>::new,\n  \t      Collectors.collectingAndThen(\n  \t      \t// The type ArrayList<T> does not define add(ArrayList<T>, Object) that is applicable here\n  \t      \t// from ArrayList<T>::add:\n  \t        Collector.of(ArrayList<T>::new, ArrayList<T>::add, (ArrayList<T> left, ArrayList<T> right) -> { \n  \t\t        left.addAll(right);\n  \t\t        return left;\n  \t        }),\n  \t        intoList)),\n  \t    intoMap),\n  \t  supplier);\n  }\n\tstatic <E extends Exception, T, M> M terminalAsCollected(\n    Class<E> class1,\n    Collector<T, ?, M> collector,\n    Supplier<Stream<T>> supplier) throws E {\n  \ttry(Stream<T> s = supplier.get()) {\n  \t\treturn s.collect(collector);\n  \t} catch(RuntimeException e) {\n  \t\tthrow unwrapCause(class1, e);\n  \t}\n  }\n\tstatic <E extends Exception> E unwrapCause(Class<E> classOfE, RuntimeException e) throws E {\n\t\tThrowable cause = e.getCause();\n\t\tif(classOfE.isInstance(cause) == false) {\n\t\t\tthrow e;\n\t\t}\n\t\tthrow classOfE.cast(cause);\n}\n}\n"}, "");
    }

    public void testreduced432605() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.function.Function;\nimport java.util.stream.Collector;\nimport java.util.stream.Collectors;\npublic class X {\n    static <T, K, L, M> void foo() {\n\tCollector<T, ?, M> cat = \n            Collectors.collectingAndThen(\n\t\tCollectors.groupingBy((Function<? super T, ? extends K>) null, \n\t\t\t\tHashMap<K, L>::new, \n\t\t\t\t(Collector<T, ArrayList<T>, L>) null), \n\t\t\t\t(Function<HashMap<K, L>, M>) null);\n\t}\n}\n"}, "");
    }

    public void test448802() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.Optional;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tOptional<String> userName = Optional.of(\"sa\");\n\t\tOptional<String> password = Optional.of(\"sa\");\n\t\tboolean isValid = userName.flatMap((String u) -> {\n\t\t\treturn password.map((String p) -> {\n\t\t\t\treturn u.equals(\"sa\") && p.equals(\"sa\");\n\t\t\t});\n\t\t}).orElse(false);\n\t\tSystem.out.println(isValid);\n\t}\n}\n"}, "true");
    }

    public void test449063() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.lambda.genericSignature", "generate");
        this.runConformTest(new String[]{"Test.java", "import java.io.Serializable;\nimport java.lang.invoke.SerializedLambda;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.Type;\npublic class Test {\n    public static interface Map<IN, OUT> {\n        public OUT map(IN in);\n    }\n    public static class Tuple<T1, T2> {\n        private T1 field1;\n        private T2 field2;\n    }\n    public static void main(String[] strings) throws Exception {\n        Map<Tuple<String, Double>, Tuple<Integer, String>> map = (in) -> new Tuple<>();\n        for(Method m : Test.class.getDeclaredMethods()) {\n        // Use the type information stored in signature\n            if (m.getName().contains(\"lambda\")) {\n              System.out.println(m.getGenericReturnType());\n              for (Type t : m.getGenericParameterTypes()) {\n                  System.out.println(t);\n              }\n            }\n        }\n    }\n}"}, isJRE9 ? "Test$Tuple<java.lang.Integer, java.lang.String>\nTest$Tuple<java.lang.String, java.lang.Double>" : "Test.Test$Tuple<java.lang.Integer, java.lang.String>\nTest.Test$Tuple<java.lang.String, java.lang.Double>", customOptions);
    }

    public void test449063a() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.lambda.genericSignature", "generate");
        this.runConformTest(new String[]{"Test.java", "import java.io.Serializable;\nimport java.lang.invoke.SerializedLambda;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.Type;\npublic class Test {\n    public static interface Map<IN, OUT> extends Serializable {\n        public OUT map(IN in);\n    }\n    public static class Tuple<T1, T2> {\n        private T1 field1;\n        private T2 field2;\n    }\n    public static void main(String[] strings) throws Exception {\n        Map<Tuple<String, Double>, Tuple<Integer, String>> map = (in) -> new Tuple<>();\n        SerializedLambda sl = getSerializedLambda(map);      \n        Method m = getLambdaMethod(sl);\n        // Use the type information stored in signature\n        System.out.println(m.getGenericReturnType());\n        for (Type t : m.getGenericParameterTypes()) {\n            System.out.println(t);\n        }\n    }\n    public static Method getLambdaMethod(SerializedLambda lambda) throws Exception {\n        String implClassName = lambda.getImplClass().replace('/', '.');\n        Class<?> implClass = Class.forName(implClassName);\n        String lambdaName = lambda.getImplMethodName();\n        for (Method m : implClass.getDeclaredMethods()) {\n            if (m.getName().equals(lambdaName)) {\n                return m;\n            }\n        }\n        throw new Exception(\"Lambda Method not found\");\n    }\n    public static SerializedLambda getSerializedLambda(Object function) throws Exception {\n        if (function == null || !(function instanceof java.io.Serializable)) {\n            throw new IllegalArgumentException();\n        }\n        for (Class<?> clazz = function.getClass(); clazz != null; clazz = clazz.getSuperclass()) {\n            try {\n                Method replaceMethod = clazz.getDeclaredMethod(\"writeReplace\");\n                replaceMethod.setAccessible(true);\n                Object serializedForm = replaceMethod.invoke(function);\n                if (serializedForm instanceof SerializedLambda) {\n                    return (SerializedLambda) serializedForm;\n                }\n            }\n            catch (NoSuchMethodError e) {\n                // fall through the loop and try the next class\n            }\n            catch (Throwable t) {\n                throw new RuntimeException(\"Error while extracting serialized lambda\", t);\n            }\n        }\n        throw new Exception(\"writeReplace method not found\");\n    }\n}"}, isJRE9 ? "Test$Tuple<java.lang.Integer, java.lang.String>\nTest$Tuple<java.lang.String, java.lang.Double>" : "Test.Test$Tuple<java.lang.Integer, java.lang.String>\nTest.Test$Tuple<java.lang.String, java.lang.Double>", customOptions);
    }

    public void test449063b() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.lambda.genericSignature", "do not generate");
        this.runConformTest(new String[]{"Test.java", "import java.io.Serializable;\nimport java.lang.invoke.SerializedLambda;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.Type;\npublic class Test {\n    public static interface Map<IN, OUT> {\n        public OUT map(IN in);\n    }\n    public static class Tuple<T1, T2> {\n        private T1 field1;\n        private T2 field2;\n    }\n    public static void main(String[] strings) throws Exception {\n        Map<Tuple<String, Double>, Tuple<Integer, String>> map = (in) -> new Tuple<>();\n        for(Method m : Test.class.getDeclaredMethods()) {\n        // Use the type information stored in signature\n            if (m.getName().contains(\"lambda\")) {\n              System.out.println(m.getGenericReturnType());\n              for (Type t : m.getGenericParameterTypes()) {\n                  System.out.println(t);\n              }\n            }\n        }\n    }\n}"}, "class Test$Tuple\nclass Test$Tuple", customOptions);
    }

    public void test449063c() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.lambda.genericSignature", "do not generate");
        this.runConformTest(new String[]{"Test.java", "import java.io.Serializable;\nimport java.lang.invoke.SerializedLambda;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.Type;\npublic class Test {\n    public static interface Map<IN, OUT> extends Serializable {\n        public OUT map(IN in);\n    }\n    public static class Tuple<T1, T2> {\n        private T1 field1;\n        private T2 field2;\n    }\n    public static void main(String[] strings) throws Exception {\n        Map<Tuple<String, Double>, Tuple<Integer, String>> map = (in) -> new Tuple<>();\n        SerializedLambda sl = getSerializedLambda(map);      \n        Method m = getLambdaMethod(sl);\n        // Use the type information stored in signature\n        System.out.println(m.getGenericReturnType());\n        for (Type t : m.getGenericParameterTypes()) {\n            System.out.println(t);\n        }\n    }\n    public static Method getLambdaMethod(SerializedLambda lambda) throws Exception {\n        String implClassName = lambda.getImplClass().replace('/', '.');\n        Class<?> implClass = Class.forName(implClassName);\n        String lambdaName = lambda.getImplMethodName();\n        for (Method m : implClass.getDeclaredMethods()) {\n            if (m.getName().equals(lambdaName)) {\n                return m;\n            }\n        }\n        throw new Exception(\"Lambda Method not found\");\n    }\n    public static SerializedLambda getSerializedLambda(Object function) throws Exception {\n        if (function == null || !(function instanceof java.io.Serializable)) {\n            throw new IllegalArgumentException();\n        }\n        for (Class<?> clazz = function.getClass(); clazz != null; clazz = clazz.getSuperclass()) {\n            try {\n                Method replaceMethod = clazz.getDeclaredMethod(\"writeReplace\");\n                replaceMethod.setAccessible(true);\n                Object serializedForm = replaceMethod.invoke(function);\n                if (serializedForm instanceof SerializedLambda) {\n                    return (SerializedLambda) serializedForm;\n                }\n            }\n            catch (NoSuchMethodError e) {\n                // fall through the loop and try the next class\n            }\n            catch (Throwable t) {\n                throw new RuntimeException(\"Error while extracting serialized lambda\", t);\n            }\n        }\n        throw new Exception(\"writeReplace method not found\");\n    }\n}"}, "class Test$Tuple\nclass Test$Tuple", customOptions);
    }

    public void test449063d() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.lambda.genericSignature", "generate");
        this.runConformTest(new String[]{"Test.java", "import java.io.Serializable;\nimport java.lang.invoke.SerializedLambda;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.Type;\npublic class Test {\n    public static interface Map<IN, OUT> {\n        public OUT map(IN in);\n    }\n    public static Tuple<Integer, String> noop(Tuple<String, Double> t){return null;}\n    public static class Tuple<T1, T2> {\n        private T1 field1;\n        private T2 field2;\n    }\n    public static void main(String[] strings) throws Exception {\n        Map<Tuple<String, Double>, Tuple<Integer, String>> map = Test::noop;\n        for(Method m : Test.class.getDeclaredMethods()) {\n        // Use the type information stored in signature\n            if (m.getName().contains(\"lambda\")) {\n              System.out.println(m.getGenericReturnType());\n              for (Type t : m.getGenericParameterTypes()) {\n                  System.out.println(t);\n              }\n            }\n        }\n    }\n}"}, "", customOptions);
    }

    public void test449063e() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.lambda.genericSignature", "do not generate");
        this.runConformTest(new String[]{"Test.java", "import java.io.Serializable;\nimport java.lang.invoke.SerializedLambda;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.Type;\npublic class Test {\n    public static interface Map<IN, OUT> extends Serializable {\n        public OUT map(IN in);\n    }\n    public static Tuple<Integer, String> noop(Tuple<String, Double> t){return null;}\n    public static class Tuple<T1, T2> {\n        private T1 field1;\n        private T2 field2;\n    }\n    public static void main(String[] strings) throws Exception {\n        Map<Tuple<String, Double>, Tuple<Integer, String>> map = Test::noop;\n        SerializedLambda sl = getSerializedLambda(map);      \n        Method m = getLambdaMethod(sl);\n        // Use the type information stored in signature\n        System.out.println(m.getGenericReturnType());\n        for (Type t : m.getGenericParameterTypes()) {\n            System.out.println(t);\n        }\n    }\n    public static Method getLambdaMethod(SerializedLambda lambda) throws Exception {\n        String implClassName = lambda.getImplClass().replace('/', '.');\n        Class<?> implClass = Class.forName(implClassName);\n        String lambdaName = lambda.getImplMethodName();\n        for (Method m : implClass.getDeclaredMethods()) {\n            if (m.getName().equals(lambdaName)) {\n                return m;\n            }\n        }\n        throw new Exception(\"Lambda Method not found\");\n    }\n    public static SerializedLambda getSerializedLambda(Object function) throws Exception {\n        if (function == null || !(function instanceof java.io.Serializable)) {\n            throw new IllegalArgumentException();\n        }\n        for (Class<?> clazz = function.getClass(); clazz != null; clazz = clazz.getSuperclass()) {\n            try {\n                Method replaceMethod = clazz.getDeclaredMethod(\"writeReplace\");\n                replaceMethod.setAccessible(true);\n                Object serializedForm = replaceMethod.invoke(function);\n                if (serializedForm instanceof SerializedLambda) {\n                    return (SerializedLambda) serializedForm;\n                }\n            }\n            catch (NoSuchMethodError e) {\n                // fall through the loop and try the next class\n            }\n            catch (Throwable t) {\n                throw new RuntimeException(\"Error while extracting serialized lambda\", t);\n            }\n        }\n        throw new Exception(\"writeReplace method not found\");\n    }\n}"}, isJRE9 ? "Test$Tuple<java.lang.Integer, java.lang.String>\nTest$Tuple<java.lang.String, java.lang.Double>" : "Test.Test$Tuple<java.lang.Integer, java.lang.String>\nTest.Test$Tuple<java.lang.String, java.lang.Double>", customOptions);
    }

    public void test449063f() {
        Map<String, String> customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.lambda.genericSignature", "generate");
        this.runConformTest(new String[]{"Test.java", "import java.io.Serializable;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.Type;\npublic class Test implements Serializable{\n    public static interface Map<IN, OUT> {\n        public OUT map(IN in);\n    }\n    public static Tuple<Integer, String> noop(Tuple<String, Double> t){return null;}\n    public static class Tuple<T1, T2> {\n        private T1 field1;\n        private T2 field2;\n    }\n    public static void main(String[] strings) throws Exception {\n        Map<Tuple<String, Double>, Tuple<Integer, String>> map = Test::noop;\n        for(Method m : Test.class.getDeclaredMethods()) {\n        // Use the type information stored in signature\n            if (m.getName().contains(\"lambda\")) {\n              System.out.println(m.getGenericReturnType());\n              for (Type t : m.getGenericParameterTypes()) {\n                  System.out.println(t);\n              }\n            }\n        }\n    }\n}"}, "", customOptions);
    }

    public void test445949() {
        this.runConformTest(new String[]{"X.java", "import java.util.function.Consumer;\npublic class X {\n\tvoid methodInFirstLevel(int y) {\n\t\tclass Second {\n\t\t\tint t = y;\n\t\t\tConsumer<Integer> myConsumer1 = (z) -> {\n\t\t\t\tSystem.out.println(\"z = \" + z);\n\t\t\t\tSystem.out.println(\"y = \" + y);\n\t\t\t\tSystem.out.println(\"t = \" + t);\n\t\t\t};\n\t\t\tConsumer<Integer> myConsumer2 = (y) -> {\n\t\t\t\tSystem.out.println(\"y = \" + y);\n\t\t\t\tSystem.out.println(\"t = \" + t);\n\t\t\t};\n\t\t\tvoid foo( int y) {\n\t\t\t\tSystem.out.println(\"y = \" + y);\n\t\t\t}\n\t\t\tclass Third {\n\t\t\t\tConsumer<Integer> myConsumer3 = (y) -> {\n\t\t\t\t\tSystem.out.println(\"y = \" + y);\n\t\t\t\t};\n\t\t\t}\n\t\t\tvoid bar(int y) {\n\t\t\t\tnew Third().myConsumer3.accept(y);\n\t\t\t}\n \t\t}\n\t\tnew Second().myConsumer1.accept(10);\n\t\tnew Second().myConsumer2.accept(20);\n\t\tnew Second().foo(30);\n\t\tnew Second().bar(40);\n\t\t\n\t}\n\tvoid foo() {\n  \t\tConsumer<Integer> myConsumer2 = (y) -> {\n\t\tclass Inner {\n\t  \tConsumer<Integer> myConsumer4 = (y) -> { \n\t\tclass InnerMost {\n\t\tConsumer<Integer> myConsumer3 = (y /*error without fix*/) -> {};\n\t\t}\n\t  \t};\n\t\t}\n\t\tnew Inner().myConsumer4.accept(10);\n\t};\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().methodInFirstLevel(5);\n\t\tnew X().foo();\n\t}\n}\n"}, "z = 10\ny = 5\nt = 5\ny = 20\nt = 5\ny = 30\ny = 40");
    }

    public void test445949a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.Consumer;\nclass X {\n\tvoid foo(int y) {\n\t\tConsumer<Integer> c1 = (y)-> {};\n\t}\n\tvoid foo2() {\n\t\tint y;\n\t\tConsumer<Integer> c1 = (y)-> {};\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tConsumer<Integer> c1 = (y)-> {};\n\t                        ^\nLambda expression's parameter y cannot redeclare another local variable defined in an enclosing scope. \n----------\n2. ERROR in X.java (at line 8)\n\tConsumer<Integer> c1 = (y)-> {};\n\t                        ^\nLambda expression's parameter y cannot redeclare another local variable defined in an enclosing scope. \n----------\n");
    }

    public void test456395() {
        this.runConformTest(new String[]{"Test.java", "import java.io.*;\nimport java.util.*;\nimport java.util.stream.*;\nimport static java.util.stream.Collectors.*;\npublic class Test {\n   public static void main(String[] args) throws IOException {\n      Stream<Locale> locales = Stream.of(Locale.getAvailableLocales());\n      locales = Stream.of(Locale.getAvailableLocales());\n      Map<String, Set<String>> countryToLanguages = locales.collect(\n         groupingBy(Locale::getDisplayCountry, \n            mapping(Locale::getDisplayLanguage,\n               toSet())));\n   }\n}\n"});
    }

    public void test459305() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.function.BiConsumer;\nimport java.util.function.Consumer;\npublic class X {\n   public static void main(String[] args) {\n      foo(arg1 -> bar(X::baz));\n   }\n   private static <A1> void foo(Consumer<A1> c) { c.accept(null); }\n   private static void baz(String s1, String s2) { System.out.println(s1 + \"::\" + s2); }\n   private static void bar(VoidMethodRef2<String, String> mr2) { mr2.accept(\"one\", \"two\"); }\n   private static interface VoidMethodRef2<A1, A2> extends BiConsumer<A1, A2>, Serializable {}\n}\n"}, "one::two");
    }

    public void test467825() {
        this.runConformTest(new String[]{"Main.java", "import java.util.function.Function;\npublic class Main {\n    public Function<String, String> f(int x) {\n    \tclass A {\n    \t\tvoid g() {\n    \t        System.out.println(x);\n    \t\t}\n    \t}\n        return s -> {\n        \tA a = new A();\n            return s;\n        };\n    }\n}\n"});
    }

    public void test467825a() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.Function;\ninterface Foo {void alpha(Bar pBar);}\nclass Bar {Object bravo() {return null;}}\nclass Test {\n\tFoo foo(Function pFunction) {\n\t    class Baz {\n\t    \tpublic Baz(Object pObj) {\n\t    \t}\n\t    \tclass NestedBaz extends Baz {\n\t    \t\tNestedBaz(Object pObj) {\n\t    \t\t\tsuper(pObj);\n\t    \t\t\tpFunction.apply(pObj);\n\t    \t\t}\n\t    \t}\n\t    }\n\t    return pBar -> {\n\t    \t\tObject o = new Baz(pBar).new NestedBaz(pBar.bravo());\n\t    \t};\n\t  }\n\t  void charlie(Object pRemovals) {}\n\t  void delta(Foo pListener) {}\n}\n"});
    }

    public void test461004() {
        this.runConformTest(new String[]{"Ice.java", "import java.util.function.BiPredicate;\nimport java.util.function.Function;\nclass Ice {\n  static <T> BiPredicate<T, T> create(BiPredicate<? super T, ? super T> fn) {\n    return null;\n  }\n  static <T, K> BiPredicate<T, T> create(Function<? super T, ? super K> map) {\n    return null;\n  }\n  void someMethod(BiPredicate<String, String> b) {}\n  void method() {\n    BiPredicate<String, String> eq = String::equalsIgnoreCase;\n    // these all compile:\n    BiPredicate<String, String> ok1 = create( eq );\n    BiPredicate<String, String> ok2 = create( (a, b) -> true );\n    BiPredicate<String, String> ok3 = create( String::valueOf );\n    // this causes an internal compiler error, ArrayIndexOutOfBoundsException: 1\n    someMethod(create( String::equalsIgnoreCase ));\n  }\n}\n"});
    }

    public void test478533() {
        this.runConformTest(new String[]{"test/BugDemonstrator.java", "package test;\nimport test.subpackage.B;\npublic class BugDemonstrator {\n\tpublic static void main(String[] args) {\n\t\t// OK\n\t\tinvoke(new B() {\n\t\t\tpublic String invoke(Integer input) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t});\n\t\t// ERROR\n\t\tinvoke((Integer i) -> { // Error is here: The type A<Object,Integer> from the descriptor computed for the target context is not visible here.\n\t\t\treturn null;\n\t\t});\n\t}\n\tprivate static String invoke(B b) {\n\t\treturn b.invoke(1);\n\t}\n}\n", "test/subpackage/A.java", "package test.subpackage;\ninterface A<I> {\n\tString invoke(I input);\n}\n", "test/subpackage/B.java", "package test.subpackage;\npublic interface B extends A<Integer> {}\n"});
    }

    public void test478533a() {
        this.runNegativeTest(new String[]{"test/BugDemonstrator.java", "package test;\nimport test.subpackage.C;\npublic class BugDemonstrator {\n\tpublic static void main(String[] args) {\n\t\tC c = new C();\n\t\tc.invoke((Integer i) -> { \n\t\t\treturn null;\n\t\t}, 2);\n\t}\n}\n", "test/subpackage/A.java", "package test.subpackage;\npublic interface A<I> {\n\tString invoke(I input);\n}\n", "test/subpackage/B.java", "package test.subpackage;\ninterface B extends A<Integer> {}\n", "test/subpackage/C.java", "package test.subpackage;\npublic class C {\n\tpublic String invoke(B b, Integer input) {\n\t\treturn b.invoke(input);\n\t}\n}\n"}, "----------\n1. ERROR in test\\BugDemonstrator.java (at line 6)\n\tc.invoke((Integer i) -> { \n\t         ^^^^^^^^^^^^^^\nThe type B from the descriptor computed for the target context is not visible here.  \n----------\n");
    }

    public void test477263() {
        this.runConformTest(new String[]{"Test.java", "import java.util.function.Function;\npublic interface Test<T> {\n    static <K> void test(Function<?, ? extends K> function) {\n        class Outer {\n        \tOuter(K k) {}\n            class Inner {\n                public Inner(K k) {}\n                private void method(K k) {\n                    System.out.println(function.apply(null));\n                    Function<K, Inner> f = Inner::new;\n                    Function<K, Outer> f2 = Outer::new;\n                }\n            }\n        }\n        new Outer(null).new Inner(null).method(null);\n    }\n    public static void main(String[] args) {\n\t\tTest.test((k) -> \"Success\");\n\t}\n}"}, "Success");
    }

    public void test477263a() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tvoid foo() {\n\t\tint local = 10;\n\t\tclass Y extends X {\n\t\t\tclass Z extends X  {\n\t\t\t\tprivate Z(int z) {\n\t\t\t\t}\n\t\t\t\tprivate Z() {}\n\t\t\t}\n\t\t\tprivate Y(int y) {\n\t\t\t\tSystem.out.println(y);\n\t\t\t}\n\t\t\t Y() {\n\t\t\t}\n\t\t}\n\t\tI i = Y :: new;\n\t\ti.makeX(local);\n\t}\n\tprivate X(int x) {\n\t}\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}"}, "10");
    }

    public void test477263b() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\tvoid foo() {\n\t\tint local = 10;\n\t\tclass Y extends X {\n\t\t\tclass Z extends X  {\n\t\t\t\tprivate Z(int z) {\n\t\t\t\t\tSystem.out.println(local);\n\t\t\t\t}\n\t\t\t\tvoid f(int in) {\n\t\t\t\t\tI i2 = Z::new;\n\t\t\t\t\ti2.makeX(in);\n\t\t\t\t}\n\t\t\t\tprivate Z() {}\n\t\t\t}\n\t\t\tprivate Y(int y) {\n\t\t\t\tSystem.out.println(\"Y\");\n\t\t\t}\n\t\t\t Y() {\n\t\t\t}\n\t\t}\n\t\tnew Y().new Z().f(0);\n\t}\n\tprivate X(int x) {\n\t\tSystem.out.println(x);\n\t}\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X().foo();\n\t}\n}"}, "10");
    }

    public void testBug487586() {
        this.runNegativeTest(new String[]{"X.java", "\ninterface Calculator {\n    public int calculate(int a, int b);\n}\n\ninterface Sumator {\n    public int test();\n\n    public int test3(int a, int b);\n}\n\n// intersection of both types\ninterface Both extends Sumator, Calculator {\n\n}\npublic class X {\n  public static void main(String[] args) {\n    Calculator test = (Calculator & Sumator) (a, b) -> a + b;\n    System.out.println(test.calculate(2, 3));\n\n    Sumator sumator = (Calculator & Sumator) (a, b) -> a + b; // does compile, but throws an Exception\n    sumator.test();\n\n    Both both = (Both) (a, b) -> a + b; // does not compile\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tCalculator test = (Calculator & Sumator) (a, b) -> a + b;\n\t                                         ^^^^^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n2. ERROR in X.java (at line 21)\n\tSumator sumator = (Calculator & Sumator) (a, b) -> a + b; // does compile, but throws an Exception\n\t                                         ^^^^^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n3. ERROR in X.java (at line 24)\n\tBoth both = (Both) (a, b) -> a + b; // does not compile\n\t                   ^^^^^^^^^^^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void testBug452587() {
        this.runConformTest(new String[]{"Test.java", " public class Test {\n    public static void main(String[] args) {\n      Runnable m = Test::m;\n      Runnable n = Test::m;\n      Runnable o = Test::m;\n      Runnable p = Test::m;\n      Runnable q = Test::m;\n    }\n    public static void m() {}\n  }\n"});
        IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((String)(String.valueOf(OUTPUT_DIR) + File.separator + "Test.class"), (int)65535);
        BootstrapMethodsAttribute bootstrapMethodsAttribute = null;
        IClassFileAttribute[] attrs = classFileReader.getAttributes();
        int i = 0;
        int max = attrs.length;
        while (i < max) {
            if (new String(attrs[i].getAttributeName()).equals("BootstrapMethods")) {
                bootstrapMethodsAttribute = (BootstrapMethodsAttribute)attrs[i];
                break;
            }
            ++i;
        }
        LambdaExpressionsTest.assertNotNull((String)"BootstrapMethods attribute not found", bootstrapMethodsAttribute);
        int bmaLength = bootstrapMethodsAttribute.getBootstrapMethodsLength();
        LambdaExpressionsTest.assertEquals((String)"Incorrect number of bootstrap methods found", (int)1, (int)bmaLength);
    }

    public void testBug485529() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tX makeX(int x);\n}\npublic class X {\n\t\tclass Y extends X {\n\t\t\tclass Z extends X  {\n\t\t\t\tprivate Z(int z) {\n\t\t\t\t}\n\t\t\t\tprivate Z() {}\n\t\t\t}\n\t\t\tprivate Y(int y) {\n\t\t\t}\n\t\t\t Y() {\n\t\t\t}\n\t\t}\n\t\tI i = Y :: new;\n\tprivate X(int x) {\n\t}\n\t\n\tX() {\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew X();\n\t\t\n\t}\n}"}, "");
    }

    public void testBug479284() {
        this.runNegativeTest(new String[]{"BadInferenceMars451.java", "package bug.report;\nimport java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.function.BinaryOperator;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\n/**\n * Problem is valid on Version: Mars.1 Release (4.5.1) Build id: 20150924-1200\n */\npublic class BadInferenceMars451 {\n\tpublic static Map<Object, List<X>> BadInferenceMars451Casus1() {\n\t\tList<X> stuff = new ArrayList<>();\n\t\treturn stuff.stream().collect(Collectors.toMap(Function.identity(), t -> Arrays.asList(t), BadInferenceMars451::sum));\n\t}\n\tpublic static Map<Object, List<X>> BadInferenceMars451Casus1Fixed1() {\n\t\tList<X> stuff = new ArrayList<>();\n\t\treturn stuff.stream().collect(Collectors.toMap(Function.identity(), t -> Arrays.asList(t), (BinaryOperator<List<X>>) BadInferenceMars451::sum));\n\t}\n\tpublic static Map<Object, List<X>> BadInferenceMars451Casus1Fixed2() {\n\t\tList<X> stuff = new ArrayList<>();\n\t\treturn stuff.stream().collect(Collectors.toMap(Function.identity(), t -> Arrays.<X> asList(t), BadInferenceMars451::sum));\n\t}\n\t/* \n\t * Uncomment this to see eclipse crash at build\n\t * this doesnt work but it should not crash the ide\n\t */ \n\tpublic static Map<Object, List<X>> BadInferenceMars451Casus1Crash() {\n\t\tList<X> stuff = new ArrayList<>();\n\t\treturn stuff.stream().collect(Collectors.toMap(Function.identity(), t -> Arrays.asList(t), BadInferenceMars451<X>::sum));\n\t}\n\tpublic static <T> List<T> sum(List<T> l1, List<T> l2) {\n\t\treturn null;\n\t}\n\tpublic static class X {\n\t}\n}\n"}, "----------\n1. ERROR in BadInferenceMars451.java (at line 31)\n\treturn stuff.stream().collect(Collectors.toMap(Function.identity(), t -> Arrays.asList(t), BadInferenceMars451<X>::sum));\n\t                                                                                           ^^^^^^^^^^^^^^^^^^^\nThe type BadInferenceMars451 is not generic; it cannot be parameterized with arguments <BadInferenceMars451.X>\n----------\n");
    }

    public void testBug491139() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tinterface Foo<T> {\n\t\t\tdefault String bar(String s) {\n\t\t\treturn (\"default : \" + s);\n\t\t}\n\t\tString bar(T t);\n\t}\n\tpublic String testLambdaRedefiningADefault() {\n\t\tFoo<String> foo =\n\t\t    (t) -> {\n\t\t      return \"lambda : \" + t;\n\t\t  };\n\t\treturn (((Foo)foo).bar(\"String\"));\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(new Test().testLambdaRedefiningADefault());\n\t}\n}\n"}, "lambda : String");
    }

    public void test489631() {
        this.runConformTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.List;\ninterface I { int getLength(); }\npublic class Test {\n\tpublic void test() {\n\t\tclass A<T> {\n\t\t\tList<T> l;\n\t\t\tpublic A(List<T> l) {\n\t\t\t\tthis.l = l;\n\t\t\t}\n\t\t}\n\t\tList<Integer> list = new ArrayList<>();\n\t\tI i = () -> new A<>(list).l.size();\n\t\tSystem.out.println(i.getLength());\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Test().test();\n\t}\n}"}, "0");
    }

    public void test489631a() {
        this.runConformTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.List;\ninterface I { int getLength(); }\npublic class Test {\n\tpublic void test() {\n\t\tclass A<T> {\n\t\t\tList<T> l;\n\t\t\tpublic A(List<T> l) {\n\t\t\t\tthis.l = l;\n\t\t\t}\n\t\t\tclass B {\n\t\t\t\tList<Integer> iL;\n\t\t\t\tpublic B(List<Integer> l) {\n\t\t\t\t\t// super(l);\n\t\t\t\t\tthis.iL = l;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tList<Integer> list = new ArrayList<>();\n\t\tI i = () -> new A<>(list).new B(list).iL.size();\n\t\tSystem.out.println(i.getLength());\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Test().test();\n\t}\n}"}, "0");
    }

    public void test476859() {
        this.runConformTest(new String[]{"Test.java", "import java.lang.reflect.Method;\nimport java.util.function.Function;\npublic class Test {\n  public static void main(String[] args) {\n    final Function<Void,Method> f = __ -> {\n    \tclass Dummy{}\n      return new Dummy(){}.getClass().getEnclosingMethod();\n    };\n    System.out.println(f.apply(null));\n  }\n}"}, "private static java.lang.reflect.Method Test.lambda$0(java.lang.Void)");
    }

    public void test476859a() {
        this.runConformTest(new String[]{"Test.java", "import java.lang.reflect.Method;\nimport java.util.function.Function;\npublic class Test {\n  public static void main(String[] args) {\n\t  \n    final Function<Void,Method> f = __ -> {\n    \tclass Dummy{}\n      return new Dummy(){}.getClass().getEnclosingMethod();\n    };\n    System.out.println(f.apply(null));\n    new AnotherClass().foo();\n  }\n}\nclass AnotherClass {\n\tvoid foo() {\n\t\tfinal Function<Void,Method> f = __ -> {\n\t    \tclass Dummy{}\n\t      return new Dummy(){}.getClass().getEnclosingMethod();\n\t    };\n\t    System.out.println(f.apply(null));\n\t}\n}\n"}, "private static java.lang.reflect.Method Test.lambda$0(java.lang.Void)\nprivate java.lang.reflect.Method AnotherClass.lambda$0(java.lang.Void)");
    }

    public void testBug499258() {
        this.runConformTest(new String[]{"bug499258/ShellTab.java", "package bug499258;\nclass Controller {\n\tpublic void newTerminal(Object... path) {\n\t}\n}\n\ninterface EventHandler {\n\tvoid handle();\n}\n\npublic class ShellTab {\n\tprivate final Controller controller;\n\n\tpublic ShellTab(Controller controller) {\n\t\tthis.controller = controller;\n\t\tEventHandler h = this.controller::newTerminal;\n\t}\n}\n"});
    }

    public void test500374() {
        this.runConformTest(new String[]{"client/Client.java", "package client;\nimport lib.Sub;\npublic class Client {\n    public static void main(String[] args) throws Throwable {\n        Sub s1 = new Sub();\n        doSomething(() -> s1.m());\n        doSomething(s1::m);\n    }\n    interface Aaa {\n        Object f() throws Throwable;\n    }\n    public static void doSomething(Aaa a) throws Throwable {\n        System.out.println(\"Done\");\n    }\n}\n", "lib/Sub.java", "package lib;\npublic class Sub extends Base<Sub> {}", "lib/Base.java", "package lib;\nclass Base<T> {\n    public T m() {\n        System.out.println(\"m\");\n        return thisInstance();\n    }\n    @SuppressWarnings(\"unchecked\")\n    T thisInstance() {\n        return (T) this;\n    }\n}"}, "Done\nDone");
    }

    public void test500374a() {
        this.runConformTest(new String[]{"client/Client.java", "package client;\nimport java.lang.invoke.MethodHandle;\nimport java.lang.invoke.MethodHandles;\nimport java.lang.invoke.MethodType;\nimport lib.Sub;\npublic class Client {\n    public static void main(String[] args) throws Throwable {\n        MethodHandle mh = MethodHandles.lookup().findVirtual(Sub.class, \"m\", MethodType.methodType(Object.class));\n        doSomething(mh::invoke);\n    }\n    interface Aaa {\n        Object f() throws Throwable;\n    }\n    public static void doSomething(Aaa a) throws Throwable {\n        System.out.println(\"Done\");\n    }\n}\n", "lib/Sub.java", "package lib;\npublic class Sub extends Base<Sub> {}", "lib/Base.java", "package lib;\nclass Base<T> {\n    public T m() {\n        System.out.println(\"m\");\n        return thisInstance();\n    }\n    @SuppressWarnings(\"unchecked\")\n    T thisInstance() {\n        return (T) this;\n    }\n}"}, "Done");
    }

    public void testBug502871() {
        this.runNegativeTest(new String[]{"test/GryoMapper.java", "package test;\n\ninterface Generic<A> {\n}\n\ninterface SAM<B> {\n\tB m();\n}\n\npublic final class GryoMapper {\n\tpublic void addCustom(Generic c) {\n\t\taddOrOverrideRegistration(() -> GryoTypeReg.of(c));\n\t}\n\n\tprivate <C> void addOrOverrideRegistration(SAM<GryoTypeReg<C>> newRegistrationBuilder) {\n\t}\n\n\tstatic class GryoTypeReg<D> {\n\t\tstatic <E> GryoTypeReg<E> of(Generic<E> clazz) {\n\t\t\treturn null;\n\t\t}\n\t}\n}\n"}, "----------\n1. WARNING in test\\GryoMapper.java (at line 11)\n\tpublic void addCustom(Generic c) {\n\t                      ^^^^^^^\nGeneric is a raw type. References to generic type Generic<A> should be parameterized\n----------\n2. WARNING in test\\GryoMapper.java (at line 12)\n\taddOrOverrideRegistration(() -> GryoTypeReg.of(c));\n\t                                ^^^^^^^^^^^^^^^^^\nType safety: Unchecked invocation of(Generic) of the generic method of(Generic<E>) of type GryoMapper.GryoTypeReg\n----------\n3. WARNING in test\\GryoMapper.java (at line 12)\n\taddOrOverrideRegistration(() -> GryoTypeReg.of(c));\n\t                                ^^^^^^^^^^^^^^^^^\nType safety: The expression of type GryoMapper.GryoTypeReg needs unchecked conversion to conform to GryoMapper.GryoTypeReg<Object>\n----------\n4. WARNING in test\\GryoMapper.java (at line 12)\n\taddOrOverrideRegistration(() -> GryoTypeReg.of(c));\n\t                                               ^\nType safety: The expression of type Generic needs unchecked conversion to conform to Generic<Object>\n----------\n");
    }

    public void testBUg490469() {
        this.runConformTest(new String[]{"AbstractClientProxy.java", "import java.util.function.Supplier;\npublic abstract class AbstractClientProxy {\n\tprotected <T> T getRemoteObject(String url, Class<T> responseType, Object... urlVariables) {\n\t\treturn handleException(this.bindGet(REST::getForObject, url, responseType, urlVariables));\n\t}\n\tprivate <T> T handleException(Supplier<T> s){\n\t\tT t = null;\n\t\ttry{\n\t\t\tt= s.get();\n\t\t}catch(Exception e){\n\t\t}\n\t\treturn t;\n\t}\n\tprivate  <T> Supplier<T> bindGet(GetFunc fn, String url, Class<T> responseType, Object... uriVariables) {\n\t\treturn () -> fn.invoke(url, responseType, uriVariables);\n\t}\n}\nclass REST {\n\tstatic <T> T getForObject(String url, Class<T> respType, Object... vars) {\n\t\treturn null;\n\t}\n}\ninterface GetFunc {\n\t<T> T invoke(String url, Class<T> responseType, Object... uriVariables);\n}\n"});
    }

    public void test509804() {
        this.runConformTest(new String[]{"Test.java", "import java.lang.reflect.Method;\nimport java.util.function.Supplier;\npublic enum Test {\n\tA(Object::new),\n\tB(() -> new Object(){}),\n\t;\n\tprivate final Supplier<Object> s;\n\tTest(Supplier<Object> e){\n\t\tthis.s = e;\n\t}\n\tpublic static void main(String[] args) throws NoSuchMethodException, SecurityException {\n\t\tSystem.out.println(B.s.get().getClass().getEnclosingMethod());\n\t}\n}\n"}, "private static java.lang.Object Test.lambda$1()");
    }

    public void testBug514105() {
        this.runConformTest(new String[]{"FunctionalInterfaceBug.java", "import java.util.function.Function;\nimport java.util.function.UnaryOperator;\n\n@FunctionalInterface\ninterface BaseFunction<S, T> extends Function<S, T> {\n\n    T foo(final S s);\n\n    default T apply(final S s) {\n        return null;\n    }\n}\n\n@FunctionalInterface\ninterface SubFunction<T> extends UnaryOperator<T>, BaseFunction<T, T> {\n}\npublic class FunctionalInterfaceBug {}\n"});
    }

    public void testBug515473() {
        this.runConformTest(new String[]{"test/LambdaResourceLeak.java", "package test;\n\nclass X implements AutoCloseable {\n\t@Override\n\tpublic void close() {\n\t}\n}\n\ninterface SAM {\n\tObject m();\n}\n\npublic class LambdaResourceLeak {\n\tvoid f() {\n\t\tX x1 = new X();\n\t\tSAM sam = () -> {\n\t\t\treturn \"\";\n\t\t};\n\t\tsam.m();\n\t\tx1.close();\n\t}\n}\n"});
    }

    public void testBug517951() {
        this.runConformTest(new String[]{"Minimal.java", "public class Minimal {\n    public void iCrash() {\n        try {\n            System.out.println(\"Body can't be empty\");\n        } finally {\n            consumes(sneaky()::withVarargs);\n        }\n    }\n    public static void main(String[] args) {\n\t\tnew Minimal().iCrash();\n\t}\n    private Minimal sneaky() { return this; }\n    private void withVarargs(String... test) {}\n    private void consumes(Runnable r) {}\n}"}, "Body can't be empty");
    }

    public void testBug517951a() {
        this.runConformTest(new String[]{"Snippet.java", "import java.nio.file.Files;\nimport java.nio.file.Paths;\nimport java.util.function.Consumer;\npublic class Snippet {\n\tvoid postError( String fmt, Object ... args ) {\n\t}\n\tpublic boolean test(Consumer<String> postError ) {\n\t\treturn false;\n\t}\n\tvoid func() {\n\t\ttry( java.io.InputStream istr = Files.newInputStream( Paths.get( \"\" ) )){\n\t\t} catch( Exception e ) {\n\t\t} finally {\n\t\t\ttest( this::postError);\n\t\t}\n\t}\n}"});
    }

    public void testBug517951b() {
        this.runConformTest(new String[]{"Element.java", "public class Element\n{\n    Operation operation = new Operation(Element::new);\n    public Element(Integer matrix)\n    {\n    \t\t//...\n    }\n    public Element(Operation... operation)\n    {\n    \t\t//...\n    }\n}\nclass Operation\n{\n    public Operation(Factory factory)\n    {\n        //...\n    }\n}\ninterface Factory\n{\n    Element create(Operation... operations);\n}"});
    }

    public void testBug517951c() {
        this.runConformTest(new String[]{"npetest/NpeTest.java", "package npetest;\npublic class NpeTest {\n    public NpeTestScheduler scheduler;\n    private void doIt(Object... params) {\n        try {\n            System.out.println(\"Done\");\n        }\n        finally {\n            scheduler.schedule(this::doIt);\n        }\n    }\n}", "npetest/NpeTestIf.java", "package npetest;\n@FunctionalInterface\npublic interface NpeTestIf {\n    void doSomething(Object... params);\n}", "npetest/NpeTestScheduler.java", "package npetest;\npublic class NpeTestScheduler {\n    public void schedule(NpeTestIf what) {\n        what.doSomething();\n    }\n}"});
    }

    public void testBug521808() {
        this.runConformTest(new String[]{"Z.java", "interface FI1 {\n\tObject m(Integer... s);\n}\ninterface FI2<T> {\n\tObject m(T... arg);\n}\npublic class Z {\n\tstatic Object m(FI1 fi, Integer v1, Integer v2) {\n\t\treturn fi.m(v1, v2);\n\t}\n\tstatic <V extends Integer> Object m(FI2<V> fi, V v1, V v2) {\n\t\treturn null;\n\t}\n\tpublic static void main(String argv[]) {\n\t\tObject obj = m((FI1) (Integer... is) -> is[0] + is[1], 3, 4);\n\t\tobj = m((Integer... is) -> is[0] + is[1], 3, 4); // Javac compiles, ECJ won't\n\t}\n}"});
    }

    public void testBug521818() {
        this.runConformTest(new String[]{"test/Main.java", "package test;\nclass C {}\nclass D {\n\t<T extends C & Runnable> D(int i, T t) {\t\tSystem.out.println(\"D\");\n}\n}\ninterface Goo {\n    <T extends C & Runnable> String m(T p);\n}\nclass A {\n    public static <K extends Runnable> String bar(K a) {\n\t\tSystem.out.println(\"Bar\");\n       return null;\n    }\n    public static <K extends Runnable> D baz(int i, K a) {\n\t\tSystem.out.println(\"Baz\");\n       return null;\n    }\n}\ninterface Foo<Z extends C & Runnable> {\n\tD get(int i, Z z);\n}\npublic class Main  {\n    public static void main(String[] args) {\n    \tFoo<? extends C> h = A::baz;\n    \th.get(0,  null);\n    \tFoo<? extends C> h2 = D::new;\n    \th2.get(0,  null);\n    \tGoo g = A::bar;\n    \tg.m(null);\n    } \n}"}, "Baz\nD\nBar");
    }

    public void testBug522469() {
        this.runConformTest(new String[]{"X.java", "public class X<R> {\n\n\tpublic static void main(String[] args) {\n\t\tI<?> i = (X<?> x) -> \"\";\n\t}\n}\ninterface I<T> {\n\tString m(X<? extends T> x);\n}\n"});
    }

    public void testBug522469a() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\npublic class X<R> {\n\tpublic static void main(String[] args) {\n\t\tI<?> i = (X<?> x) -> \"\";\n\t\tJ<?, Y> j = (C<?, Y> y) -> \"\";\n\t\tJ<?, Y> j2 = (C<? extends Object, Y> y) -> \"\";\n\t\tJ<? extends Object, Y> j3 = (C<?, Y> y) -> \"\";\n\t\tJ<? extends Object, Y> j4 = (C<? extends Object, Y> y) -> \"\";\n\t\tJ<?, Y> j5 = (C<?, Z> y) -> \"\";\n\t\tK<? extends List<?>> k = (D<? extends List<?>> d) -> \"\";\n\t}\n}\nclass C<T, U> {}\nclass D<T extends List<T>> {}\nclass Z {}\nclass Y extends Z {}\ninterface I<T> {\n\tString m(X<? extends T> x);\n}\ninterface J<R, S extends Z> {\n\tString m(C<? extends R, S> ya);\n}\ninterface K<R extends List<R>> {\n\tString m(D<? extends R> d);\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tJ<?, Y> j5 = (C<?, Z> y) -> \"\";\n\t             ^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from J<Object,Z> to J<?,Y>\n----------\n2. ERROR in X.java (at line 10)\n\tK<? extends List<?>> k = (D<? extends List<?>> d) -> \"\";\n\t                         ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe target type of this expression is not a well formed parameterized type due to bound(s) mismatch\n----------\n");
    }

    public void testBug521182() {
        this.runConformTest(new String[]{"MethodRef.java", "import java.util.function.Supplier;\npublic class MethodRef {\n  public static void m(Supplier<?> s) {\n  }\n  public static void main(String[] args) {\n    Object ref = null;\n\t try {\n    \tm(ref::toString);\n\t    System.out.println(\"A NPE should have been thrown !!!!!\");\n\t } catch (NullPointerException e) {\n\t\tSystem.out.println(\"Success\");\n\t }\n  }\n}"}, "Success");
    }

    public void testBug521182a() {
        this.runConformTest(new String[]{"MethodRef.java", "import java.util.function.Supplier;\npublic class MethodRef {\n\tObject field = null;\n  public static void m(Supplier<?> s) {\n  }\n  public static void main(String[] args) {\n\t try {\n\t\tMethodRef ref = new MethodRef();\n    \tm(ref.field::toString);\n\t    System.out.println(\"A NPE should have been thrown !!!!!\");\n\t } catch (NullPointerException e) {\n\t\tSystem.out.println(\"Success\");\n\t }\n  }\n}"}, "Success");
    }

    public void testBug521182b() {
        this.runConformTest(new String[]{"MethodRef.java", "import java.util.function.Supplier;\npublic class MethodRef {\n  public static void m(Supplier<?> s) {\n  }\n  public static Object get() {\n\t return null;\n  }\n  public static void main(String[] args) {\n\t try {\n    \tm(get()::toString);\n\t    System.out.println(\"A NPE should have been thrown !!!!!\");\n\t } catch (NullPointerException e) {\n\t\tSystem.out.println(\"Success\");\n\t }\n  }\n}"}, "Success");
    }

    public static Class testClass() {
        return LambdaExpressionsTest.class;
    }
}

