/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.util.Util;

public class ModuleCompilationTests
extends AbstractBatchCompilerTest {
    public ModuleCompilationTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ModuleCompilationTests.buildMinimalComplianceTestSuite(ModuleCompilationTests.testClass(), 64);
    }

    public static Class<?> testClass() {
        return ModuleCompilationTests.class;
    }

    protected void writeFileCollecting(List<String> collectedFiles, String directoryName, String fileName, String source) {
        this.writeFile(directoryName, fileName, source);
        collectedFiles.add(String.valueOf(directoryName) + File.separator + fileName);
    }

    protected void writeFile(String directoryName, String fileName, String source) {
        File directory = new File(directoryName);
        if (!directory.exists() && !directory.mkdirs()) {
            System.out.println("Could not create " + directoryName);
            return;
        }
        String filePath = String.valueOf(directory.getAbsolutePath()) + File.separator + fileName;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
            writer.write(source);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    void runConformModuleTest(List<String> testFileNames, StringBuffer commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory) {
        this.runConformModuleTest(testFileNames, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, OUTPUT_DIR);
    }

    void runConformModuleTest(List<String> testFileNames, StringBuffer commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String output) {
        for (String file : testFileNames) {
            commandLine.append(" \"").append(file).append("\"");
        }
        this.runConformModuleTest(new String[0], commandLine.toString(), expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, output);
    }

    Set<String> runConformModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory) {
        return this.runConformModuleTest(testFiles, commandLine, expectedFailureErrOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, OUTPUT_DIR);
    }

    Set<String> runConformModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String output) {
        this.runConformTest(testFiles, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory);
        if (RUN_JAVAC) {
            File outputDir = new File(output);
            HashSet<String> outFiles = new HashSet<String>();
            this.walkOutFiles(output, outFiles, true);
            String[] testFileNames = new String[testFiles.length / 2];
            int i = 0;
            while (i < testFileNames.length) {
                testFileNames[i] = testFiles[i * 2];
                ++i;
            }
            for (Object comp : javacCompilers) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)comp;
                if (javacCompiler.compliance < 0x350000L) continue;
                commandLine = this.adjustForJavac(commandLine);
                StringBuffer log = new StringBuffer();
                try {
                    long compileResult = javacCompiler.compile(outputDir, commandLine, testFileNames, log);
                    if (compileResult != 0L) {
                        System.err.println("Previous error was from " + this.testName());
                        ModuleCompilationTests.fail((String)"Unexpected error from javac");
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    throw new AssertionFailedError(e.getMessage());
                }
                HashSet<String> expectedFiles = new HashSet<String>(outFiles);
                this.walkOutFiles(output, expectedFiles, false);
                for (String missingFile : expectedFiles) {
                    System.err.println("Missing output file from javac:    " + missingFile);
                }
            }
            return outFiles;
        }
        return null;
    }

    void runNegativeModuleTest(List<String> testFileNames, StringBuffer commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch) {
        this.runNegativeModuleTest(testFileNames, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, javacErrorMatch, OUTPUT_DIR);
    }

    void runNegativeModuleTest(List<String> testFileNames, StringBuffer commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch, String output) {
        for (String file : testFileNames) {
            commandLine.append(" \"").append(file).append("\"");
        }
        this.runNegativeModuleTest(new String[0], commandLine.toString(), expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, javacErrorMatch, output);
    }

    void runNegativeModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch) {
        this.runNegativeModuleTest(testFiles, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory, javacErrorMatch, OUTPUT_DIR);
    }

    void runNegativeModuleTest(String[] testFiles, String commandLine, String expectedFailureOutOutputString, String expectedFailureErrOutputString, boolean shouldFlushOutputDirectory, String javacErrorMatch, String output) {
        this.runNegativeTest(testFiles, commandLine, expectedFailureOutOutputString, expectedFailureErrOutputString, shouldFlushOutputDirectory);
        if (RUN_JAVAC) {
            String[] testFileNames = new String[testFiles.length / 2];
            int i = 0;
            while (i < testFileNames.length) {
                testFileNames[i] = testFiles[i * 2];
                ++i;
            }
            File outputDir = new File(OUTPUT_DIR);
            HashSet<String> outFiles = new HashSet<String>();
            this.walkOutFiles(output, outFiles, true);
            for (Object comp : javacCompilers) {
                AbstractRegressionTest.JavacCompiler javacCompiler = (AbstractRegressionTest.JavacCompiler)comp;
                if (javacCompiler.compliance < 0x350000L) continue;
                commandLine = this.adjustForJavac(commandLine);
                StringBuffer log = new StringBuffer();
                try {
                    long compileResult = javacCompiler.compile(outputDir, commandLine, testFileNames, log);
                    if (compileResult == 0L) {
                        System.err.println("Previous error was from " + this.testName());
                        ModuleCompilationTests.fail((String)(String.valueOf(this.testName()) + ": Unexpected success from javac"));
                    }
                    if (!log.toString().contains(javacErrorMatch)) {
                        System.err.println(String.valueOf(this.testName()) + ": Error match " + javacErrorMatch + " not found in \n" + log.toString());
                        ModuleCompilationTests.fail((String)("Expected error match not found: " + javacErrorMatch));
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    throw new AssertionFailedError(e.getMessage());
                }
                HashSet<String> expectedFiles = new HashSet<String>(outFiles);
                this.walkOutFiles(output, expectedFiles, false);
                for (String missingFile : expectedFiles) {
                    System.err.println("Missing output file from javac:    " + missingFile);
                }
            }
        }
    }

    String adjustForJavac(String commandLine) {
        String[] tokens = commandLine.split(" ");
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].trim().equals("-9")) {
                buf.append(" -source 9 ");
            } else if (tokens[i].startsWith("-warn") || tokens[i].startsWith("-err") || tokens[i].startsWith("-info")) {
                if (tokens[i].contains("exports") && !tokens[i].contains("-exports")) {
                    buf.append(" -Xlint:exports ");
                }
            } else {
                buf.append(tokens[i]).append(' ');
            }
            ++i;
        }
        return buf.toString();
    }

    private void walkOutFiles(final String outputLocation, final Set<String> fileNames, final boolean add) {
        if (!new File(outputLocation).exists()) {
            return;
        }
        try {
            Files.walkFileTree(FileSystems.getDefault().getPath(outputLocation, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().endsWith(".class")) {
                        if (add) {
                            fileNames.add(file.toString());
                        } else if (!fileNames.remove(file.toString())) {
                            System.err.println("Unexpected output file from javac: " + file.toString());
                        }
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!dir.toString().equals(outputLocation)) {
                        try {
                            Files.delete(dir);
                        }
                        catch (DirectoryNotEmptyException directoryNotEmptyException) {}
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AssertionFailedError(e.getMessage());
        }
    }

    private void assertClassFile(String msg, String fileName, Set<String> classFiles) {
        if (classFiles != null) {
            ModuleCompilationTests.assertTrue((String)msg, (boolean)classFiles.contains(fileName));
        } else {
            ModuleCompilationTests.assertTrue((String)msg, (boolean)new File(fileName).exists());
        }
    }

    public void test001() {
        this.runNegativeModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n     java.sql.Connection con = null;\n\t}\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" " + "\"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 4)\n\tjava.sql.Connection con = null;\n\t^^^^^^^^\njava.sql cannot be resolved to a type\n----------\n1 problem (1 error)\n", true, "package java.sql");
    }

    public void test002() {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n     java.sql.Connection con = null;\n     System.out.println(con);\n\t}\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" " + "\"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
    }

    public void test003() {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n     java.sql.Connection con = null;\n     System.out.println(con);\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
    }

    public void test004() {
        Set<String> classFiles = this.runConformModuleTest(new String[]{"module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\"", "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + "module-info.class";
        this.assertClassFile("Missing modul-info.class: " + fileName, fileName, classFiles);
    }

    public void test005() {
        Set<String> classFiles = this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tjava.sql.Connection con;\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n\trequires java.desktop;\n}", "q/Y.java", "package q;\npublic class Y {\n   java.awt.Image image;\n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" " + "\"" + OUTPUT_DIR + File.separator + "q/Y.java\" " + "\"" + OUTPUT_DIR + File.separator + "p/X.java\" " + "-d " + OUTPUT_DIR, "", "", true);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + "module-info.class";
        this.assertClassFile("Missing modul-info.class: " + fileName, fileName, classFiles);
    }

    public void test006() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n\trequires java.desktop;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tjava.sql.Connection con;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.awt.Image image;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void test007() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 3)\n\tjava.sql.Connection con = p.X.getConnection();\n\t                          ^^^\nThe type p.X is not accessible\n----------\n1 problem (1 error)\n", false, "p.X");
    }

    public void test008() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p;\n\trequires mod.two;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\nimport q.Y;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn Y.con;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports q;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   public static java.sql.Connection con = null;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-exports").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void test008a() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.q;\n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "q", "X.java", "package p.q;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q" + File.separator + "r", "Y.java", "package q.r;\npublic class Y {\n   java.sql.Connection con = p.q.X.getConnection();\n}");
        String systemDirectory = String.valueOf(OUTPUT_DIR) + File.separator + "system";
        this.writeFile(systemDirectory, "readme.txt", "Not a valid system");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append("--system ").append(systemDirectory).append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "invalid location for system libraries: ---OUTPUT_DIR_PLACEHOLDER---/system\n", false, "system");
    }

    public void test009() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p;\n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    private void createUnnamedLibrary(String unnamedLoc, String unnamedBin) {
        this.writeFile(String.valueOf(unnamedLoc) + File.separator + "s" + File.separator + "t", "Tester.java", "package s.t;\npublic class Tester {\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + unnamedBin).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\"").append(" -sourcepath \"" + unnamedLoc + "\" ").append(String.valueOf(unnamedLoc) + File.separator + "s" + File.separator + "t" + File.separator + "Tester.java");
        this.runConformTest(new String[0], buffer.toString(), "", "", false);
    }

    private void createReusableModules(String srcDir, String outDir, File modDir) {
        File mod2;
        String fileName2;
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p;\n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p1", "X1.java", "package p1;\npublic class X1 {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(srcDir) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports q;\n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + srcDir + "\"");
        for (String fileName2 : files) {
            buffer.append(" \"").append(fileName2).append("\"");
        }
        this.runConformTest(new String[0], buffer.toString(), "", "", false);
        fileName2 = modDir + File.separator + "mod.one.jar";
        try {
            Util.zip(new File(String.valueOf(outDir) + File.separator + "mod.one"), fileName2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!modDir.exists() && !modDir.mkdirs()) {
            ModuleCompilationTests.fail((String)("Coult not create folder " + modDir));
        }
        if (!(mod2 = new File(modDir, "mod.two")).mkdir()) {
            ModuleCompilationTests.fail((String)("Coult not create folder " + mod2));
        }
        Util.copy(String.valueOf(outDir) + File.separator + "mod.two", mod2.getAbsolutePath());
        Util.flushDirectoryContent(new File(outDir));
        Util.flushDirectoryContent(new File(srcDir));
    }

    public void test010() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "r", "Z.java", "package r;\npublic class Z extends Object {\n\tp.X x = null;\n\tq.Y y = null;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append(" --module-source-path \"" + srcDir + "\"");
        this.runConformModuleTest(files, buffer, "", "", false, outDir);
    }

    public void test011() {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n   java.lang.SecurityManager man = null;\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n}"}, " -9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" " + "\"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
    }

    public void test012() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "r", "Z.java", "package r;\npublic class Z extends Object {\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append(modDir + File.separator + "mod.one.jar").append(File.pathSeparator).append(modDir + File.separator + "mod.two").append(File.pathSeparator).append("\" ").append(" --module-source-path \"" + srcDir + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 2)\n\trequires mod.one;\n\t         ^^^^^^^\nmod.one cannot be resolved to a module\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 3)\n\trequires mod.two;\n\t         ^^^^^^^\nmod.two cannot be resolved to a module\n----------\n2 problems (2 errors)\n", false, "module");
    }

    public void test013() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "Z.java", "package r;\npublic class Z extends Object {\n\tp.X x = null;\n\tq.Y y = null;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append(modDir + File.separator + "mod.one.jar").append(File.pathSeparator).append(modDir + File.separator + "mod.two").append(File.pathSeparator).append("\" ").append(" --module-source-path \"" + srcDir + "\"");
        this.runConformModuleTest(files, buffer, "", "", false, outDir);
    }

    public void testBug495500a() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -9 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 9 : 53.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void testBug495500b() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -9 -source 8 -target 9 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 9 : 53.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void testBug495500c() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -9 -source 9 -target 9 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 9 : 53.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void test014() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n\trequires mod.one;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void test015() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 3)\n\tjava.sql.Connection con = p.X.getConnection();\n\t                          ^\np cannot be resolved\n----------\n1 problem (1 error)\n", false, "cannot be resolved", String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void test016() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two").append(" --add-reads mod.two=mod.one");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void test017() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.three").append(" --add-reads mod.two=mod.one");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 3)\n\tjava.sql.Connection con = p.X.getConnection();\n\t                          ^^^\nThe type p.X is not accessible\n----------\n1 problem (1 error)\n", false, "visible", String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void test018() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.three";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "r", "Z.java", "package r;\npublic class Z {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two,mod.three").append(" --add-reads mod.two=mod.one").append(" --add-reads mod.three=mod.one");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void test019() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic abstract class X extends com.sun.security.ntlm.Server {\n\t//public X() {}\n\tpublic X(String arg0, String arg1) throws com.sun.security.ntlm.NTLMException {\n\t\tsuper(arg0, arg1);\n\t}\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -sourcepath \"" + moduleLoc + "\" ").append(" --add-exports java.base/com.sun.security.ntlm=ALL-UNNAMED ");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void test019b() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String unnamedLoc = String.valueOf(directory) + File.separator + "nomodule";
        String unnamedBin = String.valueOf(OUTPUT_DIR) + File.separator + "un_bin";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod" + File.separator + "mod.one";
        this.createUnnamedLibrary(unnamedLoc, unnamedBin);
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one {\n\texports p.q;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "q", "X.java", "package p.q;\npublic abstract class X {\n\ts.t.Tester t;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append(String.valueOf(unnamedBin) + File.pathSeparator).append("\"").append(" --module-source-path \"" + directory + File.separator + "mod" + "\" ").append(" --add-reads mod.one=ALL-UNNAMED ");
        this.runConformModuleTest(files, buffer, "", "", false, String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void test019c() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String unnamedLoc = String.valueOf(directory) + File.separator + "nomodule";
        String unnamedBin = String.valueOf(OUTPUT_DIR) + File.separator + "un_bin";
        this.createUnnamedLibrary(unnamedLoc, unnamedBin);
        ArrayList<String> files = new ArrayList<String>();
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one {\n\texports p.q;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "q", "X.java", "package p.q;\nimport s.*;\nimport s.t.*;\npublic abstract class X {\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append(String.valueOf(unnamedBin) + File.pathSeparator).append("\"").append(" --module-source-path \"" + directory + "\" ").append(" --add-reads mod.one=ALL-UNNAMED ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/q/X.java (at line 2)\n\timport s.*;\n\t       ^\nThe package s is not accessible\n----------\n1 problem (1 error)\n", false, "package s", String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void test019fail() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic abstract class X extends com.sun.security.ntlm.Server {\n\t//public X() {}\n\tpublic X(String arg0, String arg1) throws com.sun.security.ntlm.NTLMException {\n\t\tsuper(arg0, arg1);\n\t}\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -sourcepath \"" + moduleLoc + "\" ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 2)\n\tpublic abstract class X extends com.sun.security.ntlm.Server {\n\t                                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe type com.sun.security.ntlm.Server is not accessible\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 4)\n\tpublic X(String arg0, String arg1) throws com.sun.security.ntlm.NTLMException {\n\t                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nThe type com.sun.security.ntlm.NTLMException is not accessible\n----------\n2 problems (2 errors)\n", false, "does not export it to the unnamed module");
    }

    public void test020() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one=mod.two,mod.three");
        this.runNegativeModuleTest(files, buffer, "", "incorrectly formatted option: --add-exports mod.one=mod.two,mod.three\n", false, "option");
    }

    public void test021() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-reads mod.one/mod.two");
        this.runNegativeModuleTest(files, buffer, "", "incorrectly formatted option: --add-reads mod.one/mod.two\n", false, "option");
    }

    public void test022() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.three").append(" --add-exports mod.one/p=mod.three");
        this.runNegativeModuleTest(files, buffer, "", "can specify a package in a module only once with --add-export\n", false, "export");
    }

    public void test023() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append("\"" + moduleLoc + File.separator + "module-info.java\" ").append(" -extdirs " + OUTPUT_DIR + File.separator + "src");
        this.runNegativeModuleTest(files, buffer, "", "option -extdirs not supported at compliance level 9 and above\n", false, "extdirs");
    }

    public void test024() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" \"" + moduleLoc + File.separator + "module-info.java\" ").append(" -bootclasspath " + OUTPUT_DIR + File.separator + "src");
        this.runNegativeModuleTest(files, buffer, "", "option -bootclasspath not supported at compliance level 9 and above\n", false, "not allowed");
    }

    public void test025() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append("\"" + moduleLoc + File.separator + "module-info.java\" ").append(" -endorseddirs " + OUTPUT_DIR + File.separator + "src");
        this.runNegativeModuleTest(files, buffer, "", "option -endorseddirs not supported at compliance level 9 and above\n", false, "endorseddirs");
    }

    public void test026() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires transitive java.sql;\n}");
        String javaHome = System.getProperty("java.home");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" --system \"").append(javaHome).append("\"").append(" \"" + moduleLoc + File.separator + "module-info.java\" ");
        this.runConformModuleTest(new String[0], buffer.toString(), "", "", false);
    }

    public void test028() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "r", "Z.java", "package r;\npublic class Z extends Object {\n\tp.X x = null;\n\tp1.X1 x1 = null;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append(" --module-source-path \"" + srcDir + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/r/Z.java (at line 4)\n\tp1.X1 x1 = null;\n\t^^^^^\nThe type p1.X1 is not accessible\n----------\n1 problem (1 error)\n", false, "visible", outDir);
    }

    public void test029() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\npublic class Y {\n   java.sql.Connection con = p.X.getConnection();\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two,mod.three").append(" --add-reads mod.two=mod.one");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 3)\n\tpublic static java.sql.Connection getConnection() {\n\t              ^^^^^^^^^^^^^^^^^^^\nThe type Connection from module java.sql may not be accessible to clients due to missing 'requires transitive'\n----------\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 3)\n\tjava.sql.Connection con = p.X.getConnection();\n\t^^^^^^^^^^^^^^^^^^^\nThe type java.sql.Connection is not accessible\n----------\n2 problems (1 error, 1 warning)\n", false, "visible");
    }

    public void test030() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tpublic static java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\nimport java.sql.*;\npublic class Y {\n   Connection con = null;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:-exports").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two,mod.three").append(" --add-reads mod.two=mod.one");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 2)\n\timport java.sql.*;\n\t       ^^^^^^^^\nThe package java.sql is not accessible\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 4)\n\tConnection con = null;\n\t^^^^^^^^^^\nConnection cannot be resolved to a type\n----------\n2 problems (2 errors)\n", false, "visible", String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void test031() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X {\n\tstatic java.sql.Connection getConnection() {\n\t\treturn null;\n\t}\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "Y.java", "package q;\nimport java.sql.Connection;\npublic class Y {\n   Connection con = null;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"").append(" --add-exports mod.one/p=mod.two,mod.three").append(" --add-reads mod.two=mod.one");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 2)\n\timport java.sql.Connection;\n\t       ^^^^^^^^^^^^^^^^^^^\nThe type java.sql.Connection is not accessible\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/q/Y.java (at line 4)\n\tConnection con = null;\n\t^^^^^^^^^^\nConnection cannot be resolved to a type\n----------\n2 problems (2 errors)\n", false, "visible", String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void test032() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + "/p", "X.java", "package p;\npublic class X {\n\tpublic static class Inner {\n\t}\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false, String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void test033() {
        File libDir = new File(LIB_DIR);
        Util.delete(libDir);
        libDir.mkdirs();
        try {
            Util.createJar(new String[]{"a/A.java", "package a;\npublic class A {\n}"}, String.valueOf(LIB_DIR) + "/lib1.jar", "9");
        }
        catch (IOException iOException) {}
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X extends a.A {\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append(LIB_DIR).append(File.separator).append("lib1.jar").append(File.pathSeparator).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 2)\n\tpublic class X extends a.A {\n\t                       ^\na cannot be resolved to a type\n----------\n1 problem (1 error)\n", false, "package a does not exist");
    }

    public void test034() {
        File libDir = new File(LIB_DIR);
        Util.delete(libDir);
        libDir.mkdirs();
        try {
            Util.createJar(new String[]{"a/A.java", "package a;\npublic class A {\n}"}, String.valueOf(LIB_DIR) + "/lib1.jar", "9");
        }
        catch (IOException iOException) {}
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X extends a.A {\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append("-p \"").append(LIB_DIR).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/X.java (at line 2)\n\tpublic class X extends a.A {\n\t                       ^\na cannot be resolved to a type\n----------\n1 problem (1 error)\n", false, "does not read");
    }

    public void test035() {
        File libDir = new File(LIB_DIR);
        Util.delete(libDir);
        libDir.mkdirs();
        try {
            Util.createJar(new String[]{"a/A.java", "package a;\npublic class A {\n}"}, String.valueOf(LIB_DIR) + "/lib1.jar", "9");
        }
        catch (IOException iOException) {}
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n\trequires java.sql;\n\trequires lib1;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p", "X.java", "package p;\npublic class X extends a.A {\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append("-p \"").append(LIB_DIR).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void testBug515985() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "impl", "Other.java", "package impl;\npublic class Other {\n    public void privateMethod() {}}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\nimport impl.Other;\npublic class C1 extends Other {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "po", "Client.java", "package po;\nimport pm.C1;\npublic class Client {\n    void test1(C1 one) {\n        one.privateMethod(); // ecj: The method privateMethod() is undefined for the type C1\n    }\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void testApiLeak1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "impl", "Other.java", "package impl;\npublic class Other {\n}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\nimport impl.Other;\npublic class C1 extends Other {\n\tpublic void m1(Other o) {}\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "impl", "Other.java", "package impl;\npublic class Other {\n}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "po", "Client.java", "package po;\nimport pm.C1;\npublic class Client {\n    void test1(C1 one) {\n        one.m1(one);\n    }\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/pm/C1.java (at line 4)\n\tpublic void m1(Other o) {}\n\t               ^^^^^\nThe type Other is not exported from this module\n----------\n1 problem (1 warning)\n", false);
    }

    public void testApiLeak2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "impl", "SomeImpl.java", "package impl;\npublic class SomeImpl {\n}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\nimport impl.SomeImpl;\npublic class C1 {\n\tpublic void m1(SomeImpl o) {}\n}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "Other.java", "package pm;\nimport impl.SomeImpl;\npublic class Other extends SomeImpl {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "impl", "SomeImpl.java", "package impl;\npublic class SomeImpl {\n}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "po", "Client.java", "package po;\nimport pm.C1;\nimport pm.Other;\nimport impl.SomeImpl;\npublic class Client {\n    void test1(C1 one) {\n\t\t SomeImpl impl = new SomeImpl();\n        one.m1(impl);\n\t\t one.m1(new Other());\n    }\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -info:+exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. INFO in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/pm/C1.java (at line 4)\n\tpublic void m1(SomeImpl o) {}\n\t               ^^^^^^^^\nThe type SomeImpl is not exported from this module\n----------\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/po/Client.java (at line 8)\n\tone.m1(impl);\n\t    ^^\nThe method m1(impl.SomeImpl) in the type C1 is not applicable for the arguments (impl.SomeImpl)\n----------\n2 problems (1 error, 0 warnings, 1 info)\n", false, "incompatible", String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void testPackageConflict0() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1x.java", "package pm;\npublic class C1x {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\trequires transitive mod.x;\n}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n\texports p2;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p2", "C2.java", "package p2;\npublic class C2 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports pm;\n\texports p2.sub;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C3.java", "package pm;\npublic class C3 {\n}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p2" + File.separator + "sub", "C4.java", "package p2.sub;\npublic class C4 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.three";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n\trequires transitive mod.y;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 2)\n\trequires mod.one;\n\t^^^^^^^^^^^^^^^^\nThe package pm is accessible from more than one module: mod.one, mod.two, mod.x\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 3)\n\trequires mod.two;\n\t^^^^^^^^^^^^^^^^\nThe package pm is accessible from more than one module: mod.one, mod.two, mod.x\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 4)\n\trequires transitive mod.y;\n\t^^^^^^^^^^^^^^^^^^^^^^^^^\nThe package pm is accessible from more than one module: mod.one, mod.two, mod.x\n----------\n3 problems (3 errors)\n", false, "reads package pm");
    }

    public void testPackageConflict1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n\texports p2;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p2", "C2.java", "package p2;\npublic class C2 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports pm;\n\texports p2.sub;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C3.java", "package pm;\npublic class C3 {\n}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p2" + File.separator + "sub", "C4.java", "package p2.sub;\npublic class C4 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.three";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "po", "Client.java", "package po;\nimport pm.*;\nimport pm.C3;\nimport p2.C2;\npublic class Client {\n    void test1(C1 one) {\n    }\n\t pm.C1 f1;\n\t p2.sub.C4 f4;\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 2)\n\trequires mod.one;\n\t^^^^^^^^^^^^^^^^\nThe package pm is accessible from more than one module: mod.one, mod.two\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 3)\n\trequires mod.two;\n\t^^^^^^^^^^^^^^^^\nThe package pm is accessible from more than one module: mod.one, mod.two\n----------\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/po/Client.java (at line 2)\n\timport pm.*;\n\t       ^^\nThe package pm is accessible from more than one module: mod.one, mod.two\n----------\n4. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/po/Client.java (at line 3)\n\timport pm.C3;\n\t       ^^\nThe package pm is accessible from more than one module: mod.one, mod.two\n----------\n5. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/po/Client.java (at line 8)\n\tpm.C1 f1;\n\t^^\nThe package pm is accessible from more than one module: mod.one, mod.two\n----------\n5 problems (5 errors)\n", false, "reads package pm");
    }

    public void testPackageConflict3() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        ArrayList<String> files = new ArrayList<String>();
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C3.java", "package pm;\npublic class C3 {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.two/pm/C3.java (at line 1)\n\tpackage pm;\n\t        ^^\nThe package pm conflicts with a package accessible from another module: mod.one\n----------\n1 problem (1 error)\n", false, "", String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void testPackageConflict4() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, String.valueOf(directory) + File.separator + "p", "X.java", "public class X extends pm.C1 { \n}");
        buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 1)\n\tpublic class X extends pm.C1 { \n\t                       ^^\nThe package pm is accessible from more than one module: mod.x, mod.y\n----------\n1 problem (1 error)\n", false, "package conflict");
    }

    public void _testPackageConflict4a() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, String.valueOf(directory) + File.separator + "p", "X.java", "public class X extends pm.C1 { \n}");
        buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 1)\n\tpublic class X extends pm.C1 { \n\t                       ^^\npm cannot be resolved to a type\n----------\n1 problem (1 error)\n", false, "package conflict");
    }

    public void testPackageConflict5() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, String.valueOf(directory) + File.separator + "p", "X.java", "public class X extends pm.C1 { \n}");
        buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"").append(" --add-modules mod.x,mod.y");
        this.runNegativeModuleTest(files, buffer, "", "The package pm is accessible from more than one module: mod.y, mod.x\n", false, "package conflict");
        buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"").append(" --add-modules mod.x,mod.z");
        this.runNegativeModuleTest(files, buffer, "", "invalid module name: mod.z\n", false, "invalid module");
    }

    public void testPackageConflict6() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, String.valueOf(directory) + File.separator + "p", "X.java", "public class X extends pm.C1 { \n}");
        buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"").append(" --add-modules mod.x,");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/p/X.java (at line 1)\n\tpublic class X extends pm.C1 { \n\t                       ^^\nThe package pm is accessible from more than one module: mod.x, mod.y\n----------\n1 problem (1 error)\n", false, "package conflict");
    }

    public void testPackageConflict7() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.y";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.y { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
        Util.flushDirectoryContent(srcDir);
        files.clear();
        this.writeFileCollecting(files, String.valueOf(directory) + File.separator + "p", "X.java", "public class X { \n}");
        buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\"").append(" --add-modules mod.x,mod.y");
        this.runNegativeModuleTest(files, buffer, "", "The package pm is accessible from more than one module: mod.y, mod.x\n", false, "package conflict");
    }

    public void testPackageTypeConflict1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p1" + File.separator + "p2", "t3.java", "package p1.p2;\npublic class t3 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports p1.p2.t3;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p1" + File.separator + "p2" + File.separator + "t3", "t4.java", "package p1.p2.t3;\npublic class t4 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.three";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "po", "Client.java", "package po;\npublic class Client {\n\t p1.p2.t3.t4 f;\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void testBug519922() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, String.valueOf(directory) + File.separator + "test", "Test.java", "package test;\n\npublic class Test implements org.eclipse.SomeInterface {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/test/Test.java (at line 3)\n\tpublic class Test implements org.eclipse.SomeInterface {\n\t                             ^^^^^^^^^^^\norg.eclipse cannot be resolved to a type\n----------\n1 problem (1 error)\n", false, "not in a module");
    }

    public void testMixedSourcepath() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod" + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one {\n\texports p.q;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\"").append(" -sourcepath \"" + directory + "\" ").append(" --module-source-path \"" + directory + File.separator + "mod" + "\" ").append(" --add-reads mod.one=ALL-UNNAMED ");
        this.runNegativeModuleTest(files, buffer, "", "cannot specify both -source-path and --module-source-path\n", false, "cannot specify both", String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void testAPILeakDetection1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\nimport p.priv.*;\nclass C0 {\n\tpublic void test(C0 c) {}\n}\npublic class C1 {\n\tpublic C2 f;\n\tpublic void test1(C0 c) {}\n\tpublic void test2(C2 c) {}\n\tprotected void test3(C0 c) {}\n\tprotected void test4(C2 c) {}\n\tpublic p.priv.C2 test5() { return null; }\n}\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "priv", "C2.java", "package p.priv;\npublic class C2 {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 7)\n\tpublic C2 f;\n\t       ^^\nThe type C2 is not exported from this module\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 8)\n\tpublic void test1(C0 c) {}\n\t                  ^^\nThe type C0 is not accessible to clients that require this module\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 9)\n\tpublic void test2(C2 c) {}\n\t                  ^^\nThe type C2 is not exported from this module\n----------\n4. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 12)\n\tpublic p.priv.C2 test5() { return null; }\n\t       ^^^^^^^^^\nThe type C2 is not exported from this module\n----------\n4 problems (4 errors)\n", false, "is not exported");
    }

    public void testAPILeakDetection2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\nimport java.util.*;\nclass C0 {\n\tpublic void test(C0 c) {}\n}\npublic class C1 {\n\tpublic List<C0> f1;\n\tpublic C0[] f2;\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:+exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 7)\n\tpublic List<C0> f1;\n\t            ^^\nThe type C0 is not accessible to clients that require this module\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 8)\n\tpublic C0[] f2;\n\t       ^^\nThe type C0 is not accessible to clients that require this module\n----------\n2 problems (2 errors)\n", false, "not accessible to clients");
    }

    public void testAPILeakDetection3() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\nimport java.util.*;\nclass C0 {\n\tpublic void test(C0 c) {}\n}\npublic class C1 {\n\t@SuppressWarnings(\"exports\")\n\tpublic List<C0> f1;\n\t@SuppressWarnings(\"exports\")\n\tpublic C0[] f2;\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -warn:+exports,+suppress").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void testAPILeakDetection4() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\npublic class C1 {\n\tstatic class C3 {\n\t\tpublic static class C4 {}\n\t}\n\tpublic C3 f1;\n\tpublic C3.C4 f2;\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:+exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 6)\n\tpublic C3 f1;\n\t       ^^\nThe type C1.C3 is not accessible to clients that require this module\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 7)\n\tpublic C3.C4 f2;\n\t       ^^^^^\nThe type C1.C3.C4 is not accessible to clients that require this module\n----------\n2 problems (2 errors)\n", false, "one is not accessible to clients");
    }

    public void testAPILeakDetection5() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp1;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "exp1", "C1.java", "package p.exp1;\npublic class C1 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\texports p.exp2;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "exp2", "C2.java", "package p.exp2;\npublic class C2 {\n}\n");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.three";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one; // missing transitive\n\trequires transitive mod.two;\n\texports p.exp3;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "exp3", "C3.java", "package p.exp3;\npublic class C3 {\n\tpublic void m1(p.exp1.C1 arg) {}\n\tpublic void m2(p.exp2.C2 arg) {}\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:+exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/p/exp3/C3.java (at line 3)\n\tpublic void m1(p.exp1.C1 arg) {}\n\t               ^^^^^^^^^\nThe type C1 from module mod.one may not be accessible to clients due to missing 'requires transitive'\n----------\n1 problem (1 error)\n", false, "is not indirectly exported");
    }

    public void testAPILeakDetection6() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@interface ANN {}\nclass C0 {}\npublic class C1 {\n\tpublic @ANN String f1;\n\tpublic @ANN C0 f3;\n\tpublic @ANN String test(@ANN String arg, @ANN C0 c) { return \"\"; }\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:exports").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 8)\n\tpublic @ANN C0 f3;\n\t            ^^\nThe type C0 is not accessible to clients that require this module\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p/exp/C1.java (at line 9)\n\tpublic @ANN String test(@ANN String arg, @ANN C0 c) { return \"\"; }\n\t                                              ^^\nThe type C0 is not accessible to clients that require this module\n----------\n2 problems (2 errors)\n", false, "is not accessible to clients");
    }

    public void testAPILeakDetection7() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p.exp;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\npublic enum C1 {\n\tX, Y, Z;\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:exports").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void testBug486013_comment27() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String projLoc = String.valueOf(directory) + File.separator + "Proj";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, String.valueOf(projLoc) + File.separator + "p" + File.separator + "exp", "C1.java", "package p.exp;\nimport java.util.*;\npublic class C1 {\n\tList<?> l;\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" -err:exports").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void testBug518295a() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append("-classNames mod.one/p.XYZ").append(" --module-source-path \"" + srcDir + "\"");
        this.runNegativeModuleTest(files, buffer, "", "invalid class name: mod.one/p.XYZ\n", false, "", outDir);
    }

    public void testBug518295b() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append("-classNames mod.xyz/p.X").append(" --module-source-path \"" + srcDir + "\"");
        this.runNegativeModuleTest(files, buffer, "", "invalid module name: mod.xyz\n", false, "", outDir);
    }

    public void testBug518295c() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append("-classNames mod.one/p.X").append(" --module-source-path \"" + srcDir + "\"");
        this.runConformModuleTest(files, buffer, "", "", false, outDir);
    }

    public void testUnnamedPackage_Bug520839() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.base;\n}");
        this.writeFileCollecting(files, moduleLoc, "X.java", "public class X {\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/X.java (at line 1)\n\tpublic class X {\n\t^\nMust declare a named package because this compilation unit is associated to the named module 'mod.one'\n----------\n1 problem (1 warning)\n", false, String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void testAutoModule1() throws Exception {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String[] sources = new String[]{"p/a/X.java", "package p.a;\npublic class X {}\n;"};
        String jarPath = String.valueOf(OUTPUT_DIR) + File.separator + "lib-x.jar";
        Util.createJar(sources, jarPath, "1.8");
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires lib.x;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "q", "X.java", "package q;\npublic class X {\n\tp.a.X f;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + jarPath + "\"");
        this.runConformModuleTest(files, buffer, "", "", false, String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void testBug521458a() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod._3_ { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append("-classNames mod.one/p.X").append(" --module-source-path \"" + srcDir + "\"");
        this.runNegativeModuleTest(files, buffer, "", "module name mod._3_ does not match expected name mod.three\n", false, outDir);
    }

    public void _testBug521458b() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.3 { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" -p \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append("-classNames mod.one/p.X").append(" --module-source-path \"" + srcDir + "\"");
        this.runNegativeModuleTest(files, buffer, "", "module name mod.3 does not match expected name mod.three\r\n", false, outDir);
    }

    public void testBug521362_emptyFile() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p1;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p1", "X.java", "");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\texports p1;\n\t        ^^\nThe package p1 does not exist or is empty\n----------\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/p1/X.java\nMust declare a named package because this compilation unit is associated to the named module 'mod.one'\n----------\n2 problems (1 error, 1 warning)\n", false, String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void testBug521362_mismatchingdeclaration() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p1;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p1", "X.java", "package q;\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\texports p1;\n\t        ^^\nThe package p1 does not exist or is empty\n----------\n1 problem (1 error)\n", false, String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void testBug521362_multiplePackages() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p1;\n\texports p2;\n\texports p3;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p1", "X.java", "package q;\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p2", "X.java", "package q2;\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p3", "X.java", "package p3;\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\texports p1;\n\t        ^^\nThe package p1 does not exist or is empty\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 3)\n\texports p2;\n\t        ^^\nThe package p2 does not exist or is empty\n----------\n2 problems (2 errors)\n", false, String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void testBug521362_multiplePackages2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports p1;\n\texports p2;\n\texports p3.p4.p5;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p1", "X.java", "package q;\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p2", "X.java", "package q2;\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p3" + File.separator + "p4" + File.separator + "p5", "X.java", "package p3.p4.p5;\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\texports p1;\n\t        ^^\nThe package p1 does not exist or is empty\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 3)\n\texports p2;\n\t        ^^\nThe package p2 does not exist or is empty\n----------\n2 problems (2 errors)\n", false, String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void testBug500170a() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.sql;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ").append(String.valueOf(moduleLoc) + File.separator + "module-info.java");
        Set<String> classFiles = this.runConformModuleTest(new String[]{"mod.one/module-info.java", "module mod.one { \n\trequires java.sql;\n}"}, buffer.toString(), "", "", false);
        String fileName = String.valueOf(OUTPUT_DIR) + File.separator + out + File.separator + "mod.one" + File.separator + "module-info.class";
        this.assertClassFile("Missing modul-info.class: " + fileName, fileName, classFiles);
    }

    public void testBug500170b() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\trequires java.sql;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 1)\n\tmodule mod.one { \n\t^^^^^^\nSyntax error on token \"module\", package expected\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 1)\n\tmodule mod.one { \n\t^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 2)\n\trequires java.sql;\n\t             ^\nSyntax error on token \".\", , expected\n----------\n4. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.one/module-info.java (at line 3)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n4 problems (4 errors)\n", false, String.valueOf(OUTPUT_DIR) + File.separator + out);
    }

    public void testBug522472c() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File srcDir = new File(directory);
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n\texports x.y.z;\n\texports a.b.c;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "x" + File.separator + "y" + File.separator + "z", "X.java", "package x.y.z;\n");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "a" + File.separator + "b" + File.separator + "c", "A.java", "package a.b.c;\npublic class A {}");
        moduleLoc = String.valueOf(directory) + File.separator + "mod.one.a";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one.a { \n\texports x.y.z;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "x" + File.separator + "y" + File.separator + "z", "X.java", "package x.y.z;\npublic class X {}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-source-path \"" + directory + "\" ");
        this.runConformModuleTest(files, buffer, "", "", false);
        Util.flushDirectoryContent(srcDir);
        files.clear();
        moduleLoc = String.valueOf(directory) + File.separator + "mod.two";
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.two { \n\trequires mod.one;\n\trequires mod.one.a;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "p" + File.separator + "q" + File.separator + "r", "Main.java", "package p.q.r;\nimport a.b.c.*;\nimport x.y.z.*;\n@SuppressWarnings(\"unused\")\npublic class Main {}");
        buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --module-path \"" + OUTPUT_DIR + File.separator + out + "\" ").append(" --module-source-path \"" + directory + "\" ");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void testReleaseOption1() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --release 8 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.8 : 52.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void testReleaseOption2() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --release 7 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.7 : 51.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void testReleaseOption3() throws Exception {
        this.runConformTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --release 6 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from X.java (version 1.6 : 50.0, super bit)";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput);
    }

    public void testReleaseOption4() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --release 6 -source 1.6 -d \"" + OUTPUT_DIR + "\"", "", "option -source is not supported when --release is used\n", true);
    }

    public void testReleaseOption5() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --release 8 -target 1.8 -d \"" + OUTPUT_DIR + "\"", "", "option -target is not supported when --release is used\n", true);
    }

    public void testReleaseOption6() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --release 5 -d \"" + OUTPUT_DIR + "\"", "", "release version 5 is not supported\n", true);
    }

    public void testReleaseOption7() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.stream.*;\n/** */\npublic class X {\n\tpublic Stream<String> emptyStream() {\n\t\tStream<String> st = Stream.empty();\n\t\treturn st;\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --release 8 -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void testReleaseOption8() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "/** */\npublic class X {\n\tpublic java.util.stream.Stream<String> emptyStream() {\n\t\treturn null;\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --release 7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 3)\n\tpublic java.util.stream.Stream<String> emptyStream() {\n\t       ^^^^^^^^^^^^^^^^\njava.util.stream cannot be resolved to a type\n----------\n1 problem (1 error)\n", true);
    }

    public void testReleaseOption9() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n  int add(int x, int y);\n}\npublic class X {\n  public static void main(String[] args) {\n    I i = (x, y) -> {\n      return x + y;\n    };\n  }\n}\n"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --release 7 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 6)\n\tI i = (x, y) -> {\n\t      ^^^^^^^^^\nLambda expressions are allowed only at source level 1.8 or above\n----------\n1 problem (1 error)\n", true);
    }

    public void testReleaseOption10() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\n\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println();\n\t\t\tReader r = new FileReader(args[0]);\n\t\t\tr.read();\n\t\t} catch(IOException | FileNotFoundException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --release 6 -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 9)\n\t} catch(IOException | FileNotFoundException e) {\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nMulti-catch parameters are not allowed for source level below 1.7\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X.java (at line 9)\n\t} catch(IOException | FileNotFoundException e) {\n\t                      ^^^^^^^^^^^^^^^^^^^^^\nThe exception FileNotFoundException is already caught by the alternative IOException\n----------\n2 problems (2 errors)\n", true);
    }

    public void testReleaseOption11() throws Exception {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " -bootclasspath " + OUTPUT_DIR + File.separator + "src " + " --release 9 -d \"" + OUTPUT_DIR + "\"", "", "option -bootclasspath not supported at compliance level 9 and above\n", true);
    }

    public void _testReleaseOption12() throws Exception {
        String javaHome = System.getProperty("java.home");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n}"}, "\"" + OUTPUT_DIR + File.separator + "X.java\"" + " --system \"" + javaHome + "\"" + " --release 6 -d \"" + OUTPUT_DIR + "\"", "", "----------\noption --system not supported below compliance level 9", true);
    }

    public void testReleaseOption13() {
        this.runConformModuleTest(new String[]{"p/X.java", "package p;\npublic class X {\n\tpublic static void main(String[] args) {\n\t}\n}", "module-info.java", "module mod.one { \n\trequires java.base;\n}"}, " --release 9 \"" + OUTPUT_DIR + File.separator + "module-info.java\" " + "\"" + OUTPUT_DIR + File.separator + "p/X.java\"", "", "", true);
    }

    public void testReleaseOption14() {
        this.runNegativeModuleTest(new String[]{"module-info.java", "module mod.one { \n}"}, " --release 8 \"" + OUTPUT_DIR + File.separator + "module-info.java\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/module-info.java (at line 1)\n\tmodule mod.one { \n\t^^^^^^\nSyntax error on token \"module\", package expected\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/module-info.java (at line 1)\n\tmodule mod.one { \n}\n\t               ^^^^\nSyntax error on tokens, delete these tokens\n----------\n2 problems (2 errors)\n", true, "");
    }

    public void testReleaseOption15() {
        this.runConformModuleTest(new String[]{"foo/Module.java", "package foo;\npublic class Module {}\n", "foo/X.java", "package foo;\npublic class X { \n\tpublic Module getModule(String name) {\n\t\treturn null;\n\t}\n}"}, " --release 8 \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "Module.java\" " + "\"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "X.java\" ", "", "", true, "");
    }

    public void testReleaseOption16() {
        this.runNegativeModuleTest(new String[]{"foo/Module.java", "package foo;\npublic class Module {}\n", "bar/X.java", "package bar;\nimport foo.*;\npublic class X { \n\tpublic Module getModule(String name) {\n\t\treturn null;\n\t}\n}"}, " -source 9 \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "Module.java\" " + "\"" + OUTPUT_DIR + File.separator + "bar" + File.separator + "X.java\" ", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/bar/X.java (at line 4)\n\tpublic Module getModule(String name) {\n\t       ^^^^^^\nThe type Module is ambiguous\n----------\n1 problem (1 error)\n", true, "");
    }

    public void testReleaseOption17() {
        this.runNegativeModuleTest(new String[]{"foo/Module.java", "package foo;\npublic class Module {}\n", "foo/X.java", "package foo;\npublic class X { \n\tpublic Module getModule(String name) {\n\t\treturn null;\n\t}\n}"}, " --release 60 \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "Module.java\" " + "\"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "X.java\" ", "", "release 60 is not found in the system\n", true, "");
    }

    public void testReleaseOption18() {
        this.runNegativeModuleTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, " --release 6 -1.8 \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "Module.java\" " + "\"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "X.java\" ", "", "option 1.8 is not supported when --release is used\n", true, "");
    }

    public void testReleaseOption19() {
        this.runNegativeModuleTest(new String[]{"X.java", "/** */\npublic class X {\n}"}, " -9 --release 9 \"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "Module.java\" " + "\"" + OUTPUT_DIR + File.separator + "foo" + File.separator + "X.java\" ", "", "option 9 is not supported when --release is used\n", true, "");
    }

    public void testLimitModules1() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n\trequires java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --limit-modules java.base").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.x/module-info.java (at line 3)\n\trequires java.sql;\n\t         ^^^^^^^^\njava.sql cannot be resolved to a module\n----------\n1 problem (1 error)\n", false, "is not accessible to clients");
    }

    public void testLimitModules2() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\nimport java.sql.Connection;\npublic class C1 {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --limit-modules java.base").append(" --module-source-path \"" + directory + "\"");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.x/pm/C1.java (at line 2)\n\timport java.sql.Connection;\n\t       ^^^^^^^^\nThe import java.sql cannot be resolved\n----------\n1 problem (1 error)\n", false, "is not accessible to clients");
    }

    public void testLimitModules3() {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.x";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.x { \n\texports pm;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pm", "C1.java", "package pm;\npublic class C1 {\n}\n");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ").append(" --limit-modules java.sql").append(" --module-source-path \"" + directory + "\"");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void testLimitModules4() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append(" --limit-modules mod.one,mod.two ").append(" --module-source-path \"" + srcDir + "\" ");
        this.runConformModuleTest(files, buffer, "", "", false);
    }

    public void testLimitModules5() {
        Util.flushDirectoryContent(new File(OUTPUT_DIR));
        String outDir = String.valueOf(OUTPUT_DIR) + File.separator + "bin";
        String srcDir = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        File modDir = new File(String.valueOf(OUTPUT_DIR) + File.separator + "mod");
        this.createReusableModules(srcDir, outDir, modDir);
        String moduleLoc = String.valueOf(srcDir) + File.separator + "mod.three";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.three { \n\trequires mod.one;\n\trequires mod.two;\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + outDir).append(" -9 ").append(" --module-path \"").append(Util.getJavaClassLibsAsString()).append(modDir.getAbsolutePath()).append("\" ").append(" --limit-modules mod.one ").append(" --module-source-path \"" + srcDir + "\" ");
        this.runNegativeModuleTest(files, buffer, "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/src/mod.three/module-info.java (at line 3)\n\trequires mod.two;\n\t         ^^^^^^^\nmod.two cannot be resolved to a module\n----------\n1 problem (1 error)\n", false, "");
    }

    public void testBug508889_001() throws Exception {
        this.runConformTest(new String[]{"module-info.java", "module mymodule {\n}"}, "\"" + OUTPUT_DIR + File.separator + "module-info.java\"" + " -9 -source 9 -target 9 -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String expectedOutput = "// Compiled from module-info.java (version 9 : 53.0, no super bit)\n module mymodule  {\n  // Version: \n\n  requires java.base;\n\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "module-info.class", "module-info", expectedOutput);
    }

    public void testBug508889_002() throws Exception {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n    exports pack1;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pack1", "X11.java", "package pack1;\npublic class X11 {\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runConformModuleTest(files, buffer, "", "", false);
        String expectedOutput = "// Compiled from module-info.java (version 9 : 53.0, no super bit)\n module mod.one  {\n  // Version: \n\n  requires java.base;\n\n  exports pack1;\n\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + out + File.separator + "module-info.class", "module-info", expectedOutput);
    }

    public void testBug508889_003() throws Exception {
        File outputDirectory = new File(OUTPUT_DIR);
        Util.flushDirectoryContent(outputDirectory);
        String out = "bin";
        String directory = String.valueOf(OUTPUT_DIR) + File.separator + "src";
        String moduleLoc = String.valueOf(directory) + File.separator + "mod.one";
        ArrayList<String> files = new ArrayList<String>();
        this.writeFileCollecting(files, moduleLoc, "module-info.java", "module mod.one { \n    exports pack1;\n    exports pack2 to second;\n    opens pack3;\n    opens pack4 to third;\n    uses pack5.X51;\n    provides pack1.I11 with pack1.X11;\n    requires transitive java.sql;\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pack1", "I11.java", "package pack1;\npublic interface I11 {\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pack1", "X11.java", "package pack1;\npublic class X11 implements I11{\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pack2", "X21.java", "package pack2;\npublic class X21 {\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pack3", "X31.java", "package pack3;\npublic class X31 {\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pack4", "X41.java", "package pack4;\npublic class X41 {\n}");
        this.writeFileCollecting(files, String.valueOf(moduleLoc) + File.separator + "pack5", "X51.java", "package pack5;\npublic class X51 {\n}");
        StringBuffer buffer = new StringBuffer();
        buffer.append("-d " + OUTPUT_DIR + File.separator + out).append(" -9 ").append(" -classpath \"").append(Util.getJavaClassLibsAsString()).append("\" ");
        this.runConformModuleTest(files, buffer, "", "", false);
        String expectedOutput = "// Compiled from module-info.java (version 9 : 53.0, no super bit)\n module mod.one  {\n  // Version: \n\n  requires transitive java.sql;\n  requires java.base;\n\n  exports pack1;\n  exports pack2 to second;\n\n  opens pack3;\n  opens pack4 to third;\n\n  uses pack5.X51\n\n  provides pack1.I11 with pack1.X11;\n\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + out + File.separator + "module-info.class", "module-info", expectedOutput);
    }
}

