/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractBatchCompilerTest;
import org.eclipse.jdt.core.tests.util.Util;

public class NullAnnotationBatchCompilerTest
extends AbstractBatchCompilerTest {
    protected static final String NONNULL_BY_DEFAULT_ANNOTATION_CONTENT = "package org.eclipse.jdt.annotation;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ PACKAGE, TYPE, METHOD, CONSTRUCTOR })\npublic @interface NonNullByDefault{\n}";
    protected static final String NULLABLE_ANNOTATION_CONTENT = "package org.eclipse.jdt.annotation;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER, FIELD })\npublic @interface Nullable{\n}\n";
    protected static final String NONNULL_ANNOTATION_CONTENT = "package org.eclipse.jdt.annotation;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER, FIELD })\npublic @interface NonNull{\n}\n";
    protected static final String ELEMENT_TYPE_18_CONTENT = "package java.lang.annotation;\npublic enum ElementType {\n    TYPE,\n    FIELD,\n    METHOD,\n    PARAMETER,\n    CONSTRUCTOR,\n    LOCAL_VARIABLE,\n    ANNOTATION_TYPE,\n    PACKAGE,\n    TYPE_PARAMETER,\n    TYPE_USE\n}\n";
    protected static final String NONNULL_ANNOTATION_18_CONTENT = "package org.eclipse.jdt.annotation;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.*;\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ ElementType.TYPE_USE })\npublic @interface NonNull{\n}\n";
    protected static final String NULLABLE_ANNOTATION_18_CONTENT = "package org.eclipse.jdt.annotation;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.*;\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ ElementType.TYPE_USE })\npublic @interface Nullable{\n}\n";
    protected static final String NONNULL_BY_DEFAULT_ANNOTATION_18_CONTENT = "package org.eclipse.jdt.annotation;\nimport java.lang.annotation.ElementType;\nimport static org.eclipse.jdt.annotation.DefaultLocation.*;\n\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\n@Retention(RetentionPolicy.CLASS)\n@Target({ ElementType.PACKAGE, ElementType.TYPE, ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.LOCAL_VARIABLE })\npublic @interface NonNullByDefault {\n\tDefaultLocation[] value() default { PARAMETER, RETURN_TYPE, FIELD, TYPE_BOUND, TYPE_ARGUMENT };\n}\n";
    protected static final String DEFAULT_LOCATION_CONTENT = "package org.eclipse.jdt.annotation;\npublic enum DefaultLocation {\n\tPARAMETER,\n\tRETURN_TYPE,\n\tFIELD,\n\tTYPE_PARAMETER,\n\tTYPE_BOUND,\n\tTYPE_ARGUMENT,\n\tARRAY_CONTENTS\n}\n";
    private static final String TEST_440687_MAP_EEA_CONTENT = "class java/util/Map\n <K:V:>\n\nget\n (Ljava/lang/Object;)TV;\n (Ljava/lang/Object;)T0V;\nput\n (TK;TV;)TV;\n (TK;TV;)T0V;\nremove\n (Ljava/lang/Object;)TV;\n (Ljava/lang/Object;)T0V;\n";
    private static final String TEST_440687_OBJECT_EEA_CONTENT = "class java/lang/Object\n\nequals\n (Ljava/lang/Object;)Z\n (L0java/lang/Object;)Z\n";

    public static Test suite() {
        return NullAnnotationBatchCompilerTest.buildMinimalComplianceTestSuite(NullAnnotationBatchCompilerTest.testClass(), 4);
    }

    public static Class<?> testClass() {
        return NullAnnotationBatchCompilerTest.class;
    }

    public NullAnnotationBatchCompilerTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Util.delete(OUTPUT_DIR);
    }

    public void test314_warn_options() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n  @NonNull Object foo(@Nullable Object o, @NonNull Object o2) {\n\t return this;\n  }\n}\nclass Y extends X {\n    @Nullable Object foo(Object o, Object o2) { return null; }\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -err:+nullAnnot -warn:-null -err:+nonnullNotRepeated -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t^^^^^^^^^^^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.foo(Object, Object) (mismatching null constraints)\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t                     ^^^^^^\nMissing nullable annotation: inherited method from X specifies this parameter as @Nullable\n----------\n3. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t                               ^^^^^^\nMissing non-null annotation: inherited method from X specifies this parameter as @NonNull\n----------\n3 problems (3 errors)\n", true);
    }

    public void test315_warn_options() {
        this.runConformTest(new String[]{"p/package-info.java", "@org.eclipse.jdt.annotation.NonNullByDefault\npackage p;\n", "p/X.java", "package p;\npublic class X {\n}\n", "p1/X1.java", "package p1;\npublic class X1 {\n}\n", "p1/X1a.java", "package p1;\npublic class X1a {\n}\n", "Default1.java", "public class Default1 {\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:+nullAnnot -warn:+null -missingNullDefault -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test315_warn_options_a() {
        this.runConformTest(new String[]{"p1/X1.java", "package p1;\npublic class X1 {\n   class Inner{};\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p1" + File.separator + "X1.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:+nullAnnot -warn:+null -missingNullDefault -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p1/X1.java (at line 1)\n\tpackage p1;\n\t        ^^\nA default nullness annotation has not been specified for the package p1\n----------\n1 problem (1 warning)\n", true);
    }

    public void test315_warn_options_b() {
        this.runNegativeTest(new String[]{"X1.java", "public class X1 {\n\tZork z;\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "X1.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:+nullAnnot -warn:+null -missingNullDefault -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/X1.java (at line 1)\n\tpublic class X1 {\n\t             ^^\nA default nullness annotation has not been specified for the type X1\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/X1.java (at line 2)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n2 problems (1 error, 1 warning)\n", true);
    }

    public void test316_warn_options() {
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport org.eclipse.jdt.annotation.*;\n@SuppressWarnings(\"unused\")\npublic class X {}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:+nullAnnot(foo|bar) -warn:+null -nonNullByDefault -proc:none -d \"" + OUTPUT_DIR + "\"", "", "Token nullAnnot(foo|bar) is not in the expected format \"nullAnnot(<non null annotation name> | <nullable annotation name> | <non-null by default annotation name>)\"\n", true);
    }

    public void test316b_warn_options() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n  @Nullable Object f;\n  @NonNull Object foo() {\n    if (this.f != null)\n      return this.f;\n\t return this;\n  }\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:+nullAnnot -warn:+null,syntacticAnalysis -proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
    }

    public void test313_warn_options() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n  @NonNull Object foo(@Nullable Object o, @NonNull Object o2) {\n\t return this;\n  }\n}\nclass Y extends X {\n    @Nullable Object foo(Object o, Object o2) { return null; }\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:+nullAnnot -warn:-null -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t^^^^^^^^^^^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.foo(Object, Object) (mismatching null constraints)\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t                     ^^^^^^\nMissing nullable annotation: inherited method from X specifies this parameter as @Nullable\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t                               ^^^^^^\nMissing non-null annotation: inherited method from X specifies this parameter as @NonNull\n----------\n3 problems (3 warnings)\n", true);
    }

    public void test320_warn_options() {
        this.runNegativeTest(new String[]{"p/Super.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class Super {\n    void foo(@NonNull String s) {}\n}\n", "p/Sub.java", "package p;\npublic class Sub extends Super {\n    void foo(String s) {\n        s= null;\n        super.foo(s);\n    }\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "Sub.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -err:+nullAnnot,+null,+inheritNullAnnot -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/Sub.java (at line 4)\n\ts= null;\n\t   ^^^^\nNull type mismatch: required '@NonNull String' but the provided value is null\n----------\n1 problem (1 error)\n", true);
    }

    public void testBug466291() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@NonNullByDefault\npublic class X {\n  public Object foo(@Nullable Object o, Object o2) {\n\t return new Object();\n  }\n  public Object bar() {\n\t return this;\n  }\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface NonNull{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface Nullable{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ PACKAGE, TYPE, METHOD, CONSTRUCTOR })\n@interface NonNullByDefault{\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -1.5" + " -warn:+nullAnnot(p.Nullable|p.NonNull|p.NonNullByDefault) -warn:+null -warn:-nullUncheckedConversion " + "-proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        int i = 0;
        while (i < 2) {
            this.runNegativeTest(new String[]{"p2/X2.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\npublic class X2 {\n  @NonNull Object test(@NonNull p.X nonnullX, @Nullable p.X nullableX) {\n    nonnullX.foo(nullableX, nullableX);\n\t return nonnullX.bar();\n  }\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p2" + File.separator + "X2.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -classpath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:+nullAnnot(org.eclipse.jdt.annotation.Nullable|org.eclipse.jdt.annotation.NonNull|org.eclipse.jdt.annotation.NonNullByDefault)" + " -warn:+nullAnnot(p.Nullable||p.NonNullByDefault) -warn+null -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p2/X2.java (at line 5)\n\tnonnullX.foo(nullableX, nullableX);\n\t                        ^^^^^^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is specified as @Nullable\n----------\n1 problem (1 error)\n", false);
            String xPath = String.valueOf(OUTPUT_DIR) + File.separator + "p" + File.separator + "X.java";
            new File(xPath).delete();
            ++i;
        }
    }

    public void testBug466291b() {
        this.runConformTest(new String[]{"p/X.java", "package p;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.*;\n@NonNullByDefault\npublic class X {\n  public Object foo(@Nullable Object o, Object o2) {\n\t return new Object();\n  }\n  public Object bar() {\n\t return this;\n  }\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface NonNull{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ METHOD, PARAMETER })\n@interface Nullable{\n}\n@Documented\n@Retention(RetentionPolicy.CLASS)\n@Target({ PACKAGE, TYPE, METHOD, CONSTRUCTOR })\n@interface NonNullByDefault{\n}"}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -1.5" + " -warn:+nullAnnot(p.Nullable|p.NonNull|p.NonNullByDefault) -warn:+null -warn:-nullUncheckedConversion " + "-proc:none -d \"" + OUTPUT_DIR + "\"", "", "", true);
        String xPath = String.valueOf(OUTPUT_DIR) + File.separator + "p" + File.separator + "X.java";
        new File(xPath).delete();
        this.runNegativeTest(new String[]{"p2/X2.java", "package p2;\nimport org.eclipse.jdt.annotation.*;\npublic class X2 {\n  @NonNull Object test(@NonNull p.X nonnullX, @Nullable p.X nullableX) {\n    nonnullX.foo(nullableX, nullableX);\n\t return nonnullX.bar();\n  }\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p2" + File.separator + "X2.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -classpath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -warn:+nullAnnot(org.eclipse.jdt.annotation.Nullable|org.eclipse.jdt.annotation.NonNull|org.eclipse.jdt.annotation.NonNullByDefault)" + " -warn:+nullAnnot(|x.AbsentNonNull|) " + " -warn:+nullAnnot(p.Nullable||p.NonNullByDefault) " + " -warn:+nullAnnot(yet.AnotherNullable|yet.AnotherNonnull|yet.anotherNNBD) " + " -warn+null -proc:none -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p2/X2.java (at line 5)\n\tnonnullX.foo(nullableX, nullableX);\n\t                        ^^^^^^^^^\nNull type mismatch: required '@NonNull Object' but the provided value is specified as @Nullable\n----------\n1 problem (1 error)\n", false);
    }

    public void testBug375366c() throws IOException {
        this.createOutputTestDirectory("regression/.settings");
        Util.createFile(String.valueOf(OUTPUT_DIR) + "/.settings/org.eclipse.jdt.core.prefs", "eclipse.preferences.version=1\norg.eclipse.jdt.core.compiler.annotation.nullanalysis=enabled\n");
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n  @NonNull Object foo(@Nullable Object o, @NonNull Object o2) {\n\t return this;\n  }\n}\nclass Y extends X {\n    @Nullable Object foo(Object o, Object o2) { return null; }\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -properties " + OUTPUT_DIR + File.separator + ".settings" + File.separator + "org.eclipse.jdt.core.prefs " + " -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t^^^^^^^^^^^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.foo(Object, Object) (mismatching null constraints)\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t                     ^^^^^^\nMissing nullable annotation: inherited method from X specifies this parameter as @Nullable\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t                               ^^^^^^\nMissing non-null annotation: inherited method from X specifies this parameter as @NonNull\n----------\n3 problems (2 errors, 1 warning)\n", false);
    }

    public void testBug375366d() throws IOException {
        this.createOutputTestDirectory("regression/.settings");
        Util.createFile(String.valueOf(OUTPUT_DIR) + "/.settings/org.eclipse.jdt.core.prefs", "eclipse.preferences.version=1\norg.eclipse.jdt.core.compiler.annotation.nullanalysis=enabled\norg.eclipse.jdt.core.compiler.problem.nonnullParameterAnnotationDropped=ignore\n");
        this.runNegativeTest(new String[]{"p/X.java", "package p;\nimport org.eclipse.jdt.annotation.*;\npublic class X {\n  @NonNull Object foo(@Nullable Object o, @NonNull Object o2) {\n\t return this;\n  }\n}\nclass Y extends X {\n    @Nullable Object foo(Object o, Object o2) { return null; }\n}\n", "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_CONTENT}, "\"" + OUTPUT_DIR + File.separator + "p" + File.separator + "X.java\"" + " -sourcepath \"" + OUTPUT_DIR + "\"" + " -1.5" + " -properties " + OUTPUT_DIR + File.separator + ".settings" + File.separator + "org.eclipse.jdt.core.prefs " + " -d \"" + OUTPUT_DIR + "\"", "", "----------\n1. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t^^^^^^^^^^^^^^^^\nThe return type is incompatible with '@NonNull Object' returned from X.foo(Object, Object) (mismatching null constraints)\n----------\n2. ERROR in ---OUTPUT_DIR_PLACEHOLDER---/p/X.java (at line 9)\n\t@Nullable Object foo(Object o, Object o2) { return null; }\n\t                     ^^^^^^\nMissing nullable annotation: inherited method from X specifies this parameter as @Nullable\n----------\n2 problems (2 errors)\n", false);
    }

    public void test440477() throws IOException {
        String annots_dir = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots";
        String annots_java_util = String.valueOf(annots_dir) + File.separator + "java/util";
        new File(annots_java_util).mkdirs();
        Util.createFile(String.valueOf(annots_java_util) + File.separator + "Map.eea", TEST_440687_MAP_EEA_CONTENT);
        String o_e_j_annotation_dir = String.valueOf(OUTPUT_DIR) + File.separator + "org" + File.separator + "eclipse" + File.separator + "jdt" + File.separator + "annotation";
        String j_l_annotation_dir = String.valueOf(OUTPUT_DIR) + File.separator + "java" + File.separator + "lang" + File.separator + "annotation";
        this.runConformTest(new String[]{"java/lang/annotation/ElementType.java", ELEMENT_TYPE_18_CONTENT, "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_18_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_18_CONTENT, "org/eclipse/jdt/annotation/DefaultLocation.java", DEFAULT_LOCATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_18_CONTENT, "test1/Test1.java", "package test1;\n\nimport java.util.Map;\nimport org.eclipse.jdt.annotation.*;\n\n@NonNullByDefault\npublic class Test1 {\n\tvoid test(Map<String,Test1> map, String key) {\n\t\tTest1 v = map.get(key);\n\t\tif (v == null)\n\t\t\tthrow new RuntimeException(); // should not be reported as dead code, although V is a '@NonNull Test1'\n\t}\n}\n"}, " -1.8 -proc:none -d none -warn:+nullAnnot -annotationpath " + annots_dir + " -sourcepath \"" + OUTPUT_DIR + "\" " + "\"" + j_l_annotation_dir + File.separator + "ElementType.java\" " + "\"" + o_e_j_annotation_dir + File.separator + "NonNull.java\" " + "\"" + o_e_j_annotation_dir + File.separator + "DefaultLocation.java\" " + "\"" + o_e_j_annotation_dir + File.separator + "NonNullByDefault.java\" " + "\"" + OUTPUT_DIR + File.separator + "test1" + File.separator + "Test1.java\"", "", "", true);
    }

    void runTest440687(String compilerPathArgs, String extraSourcePaths, String expectedCompilerMessage, boolean isSuccess) {
        String[] testFiles = new String[]{"java/lang/annotation/ElementType.java", ELEMENT_TYPE_18_CONTENT, "org/eclipse/jdt/annotation/NonNull.java", NONNULL_ANNOTATION_18_CONTENT, "org/eclipse/jdt/annotation/Nullable.java", NULLABLE_ANNOTATION_18_CONTENT, "org/eclipse/jdt/annotation/DefaultLocation.java", DEFAULT_LOCATION_CONTENT, "org/eclipse/jdt/annotation/NonNullByDefault.java", NONNULL_BY_DEFAULT_ANNOTATION_18_CONTENT, "test1/Test1.java", "package test1;\n\nimport java.util.Map;\nimport org.eclipse.jdt.annotation.*;\n\n@NonNullByDefault\npublic class Test1 {\n\tvoid test(Map<String,Test1> map, String key) {\n\t\tTest1 v = map.get(key);\n\t\tif (v == null)\n\t\t\tthrow new RuntimeException(); // should not be reported as dead code, although V is a '@NonNull Test1'\n\t}\n\tpublic boolean equals(@NonNull Object other) { return false; }\n}\n"};
        String o_e_j_annotation_dir = String.valueOf(OUTPUT_DIR) + File.separator + "org" + File.separator + "eclipse" + File.separator + "jdt" + File.separator + "annotation";
        String j_l_annotation_dir = String.valueOf(OUTPUT_DIR) + File.separator + "java" + File.separator + "lang" + File.separator + "annotation";
        String commandLine = " -1.8 -proc:none -d none -warn:+nullAnnot " + compilerPathArgs + " -sourcepath \"" + OUTPUT_DIR + extraSourcePaths + "\" " + "\"" + j_l_annotation_dir + File.separator + "ElementType.java\" " + "\"" + o_e_j_annotation_dir + File.separator + "NonNull.java\" " + "\"" + o_e_j_annotation_dir + File.separator + "DefaultLocation.java\" " + "\"" + o_e_j_annotation_dir + File.separator + "NonNullByDefault.java\" " + "\"" + OUTPUT_DIR + File.separator + "test1" + File.separator + "Test1.java\"";
        if (expectedCompilerMessage == null) {
            expectedCompilerMessage = "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/test1/Test1.java (at line 13)\n\tpublic boolean equals(@NonNull Object other) { return false; }\n\t                      ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter other, inherited method from Object declares this parameter as @Nullable\n----------\n1 problem (1 warning)\n";
        }
        try {
            if (isSuccess) {
                this.runConformTest(testFiles, commandLine, "", expectedCompilerMessage, true);
            } else {
                this.runNegativeTest(testFiles, commandLine, "", expectedCompilerMessage, true);
            }
        }
        finally {
            Util.delete(Util.getOutputDirectory());
        }
    }

    public void test440687a() throws IOException {
        String annots_dir1 = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots1";
        String annots_java_util = String.valueOf(annots_dir1) + File.separator + "java/util";
        new File(annots_java_util).mkdirs();
        Util.createFile(String.valueOf(annots_java_util) + File.separator + "Map.eea", TEST_440687_MAP_EEA_CONTENT);
        String annots_dir2 = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots2";
        String annots_java_lang = String.valueOf(annots_dir2) + File.separator + "java/lang";
        new File(annots_java_lang).mkdirs();
        Util.createFile(String.valueOf(annots_java_lang) + File.separator + "Object.eea", TEST_440687_OBJECT_EEA_CONTENT);
        this.runTest440687("-annotationpath CLASSPATH -classpath \"" + annots_dir2 + "\"", String.valueOf(File.pathSeparator) + annots_dir1, null, true);
    }

    public void test440687b() throws IOException {
        String annots_dir = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots1";
        String annots_java_util = String.valueOf(annots_dir) + File.separator + "java/util";
        new File(annots_java_util).mkdirs();
        Util.createFile(String.valueOf(annots_java_util) + File.separator + "Map.eea", TEST_440687_MAP_EEA_CONTENT);
        String annots_dir2 = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots2";
        String annots_java_lang = String.valueOf(annots_dir2) + File.separator + "java/lang";
        new File(annots_java_lang).mkdirs();
        Util.createFile(String.valueOf(annots_java_lang) + File.separator + "Object.eea", TEST_440687_OBJECT_EEA_CONTENT);
        this.runTest440687("-annotationpath \"" + annots_dir + File.pathSeparator + annots_dir2 + "\" ", "", null, true);
    }

    public void test440687c() throws IOException {
        String annots_dir = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots";
        new File(annots_dir).mkdirs();
        String annotsZipFile = String.valueOf(annots_dir) + File.separator + "jre-annots.zip";
        Util.createSourceZip(new String[]{"java/util/Map.eea", TEST_440687_MAP_EEA_CONTENT, "java/lang/Object.eea", TEST_440687_OBJECT_EEA_CONTENT}, annotsZipFile);
        this.runTest440687("-annotationpath CLASSPATH -classpath \"" + annotsZipFile + "\"", "", null, true);
    }

    public void test440687d() throws IOException {
        this.runTest440687("-annotationpath", "", "Missing argument to -annotationpath at '-sourcepath'\n", false);
    }

    public void test490010NoEeaFile1() throws IOException {
        String annots_dir1 = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots1";
        new File(annots_dir1).mkdirs();
        String annots_dir2 = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots2";
        String annots_java_lang = String.valueOf(annots_dir2) + File.separator + "java/lang";
        new File(annots_java_lang).mkdirs();
        Util.createFile(String.valueOf(annots_java_lang) + File.separator + "Object.eea", TEST_440687_OBJECT_EEA_CONTENT);
        this.runTest440687("-annotationpath CLASSPATH -classpath \"" + annots_dir2 + "\"", String.valueOf(File.pathSeparator) + annots_dir1, "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/test1/Test1.java (at line 9)\n\tTest1 v = map.get(key);\n\t          ^^^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type '@NonNull Map<@NonNull String,@NonNull Test1>'. Type 'Map<K,V>' doesn't seem to be designed with null type annotations in mind\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/test1/Test1.java (at line 11)\n\tthrow new RuntimeException(); // should not be reported as dead code, although V is a '@NonNull Test1'\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/test1/Test1.java (at line 13)\n\tpublic boolean equals(@NonNull Object other) { return false; }\n\t                      ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter other, inherited method from Object declares this parameter as @Nullable\n----------\n3 problems (3 warnings)\n", true);
    }

    public void test490010NoEeaFile2() throws IOException {
        String annots_dir1 = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots1";
        new File(annots_dir1).mkdirs();
        String annots_dir2 = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots2";
        String annots_java_lang = String.valueOf(annots_dir2) + File.separator + "java/lang";
        new File(annots_java_lang).mkdirs();
        Util.createFile(String.valueOf(annots_java_lang) + File.separator + "Object.eea", TEST_440687_OBJECT_EEA_CONTENT);
        String zipName = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots2.zip";
        Util.zip(new File(annots_dir2), zipName);
        Util.delete(annots_dir2);
        this.runTest440687("-annotationpath CLASSPATH -classpath \"" + zipName + "\"", String.valueOf(File.pathSeparator) + annots_dir1, "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/test1/Test1.java (at line 9)\n\tTest1 v = map.get(key);\n\t          ^^^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type '@NonNull Map<@NonNull String,@NonNull Test1>'. Type 'Map<K,V>' doesn't seem to be designed with null type annotations in mind\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/test1/Test1.java (at line 11)\n\tthrow new RuntimeException(); // should not be reported as dead code, although V is a '@NonNull Test1'\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/test1/Test1.java (at line 13)\n\tpublic boolean equals(@NonNull Object other) { return false; }\n\t                      ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter other, inherited method from Object declares this parameter as @Nullable\n----------\n3 problems (3 warnings)\n", true);
    }

    public void test490010NoEeaFile3() throws IOException {
        String annots_dir1 = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots1";
        new File(annots_dir1).mkdirs();
        String annots_dir2 = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots2";
        String annots_java_lang = String.valueOf(annots_dir2) + File.separator + "java/lang";
        new File(annots_java_lang).mkdirs();
        Util.createFile(String.valueOf(annots_java_lang) + File.separator + "Object.eea", TEST_440687_OBJECT_EEA_CONTENT);
        String zipName = String.valueOf(Util.getOutputDirectory()) + File.separator + "annots2.zip";
        Util.zip(new File(annots_dir2), zipName);
        Util.delete(annots_dir2);
        this.runTest440687("-annotationpath \"" + zipName + "\"", String.valueOf(File.pathSeparator) + annots_dir1, "----------\n1. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/test1/Test1.java (at line 9)\n\tTest1 v = map.get(key);\n\t          ^^^^^^^^^^^^\nUnsafe interpretation of method return type as '@NonNull' based on the receiver type '@NonNull Map<@NonNull String,@NonNull Test1>'. Type 'Map<K,V>' doesn't seem to be designed with null type annotations in mind\n----------\n2. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/test1/Test1.java (at line 11)\n\tthrow new RuntimeException(); // should not be reported as dead code, although V is a '@NonNull Test1'\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n3. WARNING in ---OUTPUT_DIR_PLACEHOLDER---/test1/Test1.java (at line 13)\n\tpublic boolean equals(@NonNull Object other) { return false; }\n\t                      ^^^^^^^^^^^^^^^\nIllegal redefinition of parameter other, inherited method from Object declares this parameter as @Nullable\n----------\n3 problems (3 warnings)\n", true);
    }
}

