/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ProblemConstructorTest
extends AbstractRegressionTest {
    public ProblemConstructorTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ProblemConstructorTest.buildAllCompliancesTestSuite(ProblemConstructorTest.testClass());
    }

    public static Class testClass() {
        return ProblemConstructorTest.class;
    }

    public void test001() {
        this.runNegativeTest(new String[]{"prs/Test1.java", "package prs;\t\nimport java.io.IOException;\t\npublic class Test1 {\t\nString s = 3;\t\nTest1() throws IOException {\t\n}\t\n}"}, "----------\n1. ERROR in prs\\Test1.java (at line 4)\n\tString s = 3;\t\n\t           ^\nType mismatch: cannot convert from int to String\n----------\n", null, true, null, true, false, false);
        this.runConformTest(false, new String[]{"prs/Test2.java", "package prs;\t\nimport java.io.IOException;\t\npublic class Test2 {\t\npublic void foo() {\t\ntry {\t\nTest1 t = new Test1();\t\nSystem.out.println();\t\n} catch(IOException e)\t\n{\t\ne.printStackTrace();\t\n}\t\n}\t\n}"}, "", null, null, AbstractRegressionTest.JavacTestOptions.SKIP);
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public X();\n    public Y();\n    \n}"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic X();\n\t       ^^^\nThis method requires a body instead of a semicolon\n----------\n2. ERROR in X.java (at line 3)\n\tpublic Y();\n\t       ^^^\nReturn type for the method is missing\n----------\n3. ERROR in X.java (at line 3)\n\tpublic Y();\n\t       ^^^\nThis method requires a body instead of a semicolon\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"Example.java", "class Example {\n  private Example() {\n  }\n  public Example(int i) {\n  }\n}\nclass E1 {\n    private E1(int i) {}\n    private E1(long l) {}\n}\nclass E2 {\n    private E2(int i) {}\n}\nclass E3 {\n    public E3(int i) {}\n    Zork z;\n}\n"}, "----------\n1. WARNING in Example.java (at line 2)\n\tprivate Example() {\n\t        ^^^^^^^^^\nThe constructor Example() is never used locally\n----------\n2. ERROR in Example.java (at line 16)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate class M { \n       private int state = 0;\n       public int unusedMethod() { return this.state; }\n       public M (int state) { this.state = state;} \n       public int unusedField = 0;\n       public class N {}\n\t}\n\tprivate class N { \n       private int state = 0;\n       public int usedMethod() { new O(); return new N(this.state + this.usedField).state; }\n       public N (int state) { this.state = state;} \n       public int usedField = 0;\n       public class O {}\n\t}\n\tpublic class P { \n       private int state = 0;\n       public int unusedMethod() { return this.state; }\n       public P (int state) { this.state = state;} \n       public int unusedField = 0;\n       public class N {}\n\t}\n\tpublic M foo(M m, N n) {\n   n.usedMethod(); return m;\n\t}\n} \n"}, "----------\n1. WARNING in X.java (at line 4)\n\tpublic int unusedMethod() { return this.state; }\n\t           ^^^^^^^^^^^^^^\nThe method unusedMethod() from the type X.M is never used locally\n----------\n2. WARNING in X.java (at line 5)\n\tpublic M (int state) { this.state = state;} \n\t       ^^^^^^^^^^^^^\nThe constructor X.M(int) is never used locally\n----------\n3. WARNING in X.java (at line 6)\n\tpublic int unusedField = 0;\n\t           ^^^^^^^^^^^\nThe value of the field X.M.unusedField is not used\n----------\n4. WARNING in X.java (at line 7)\n\tpublic class N {}\n\t             ^\nThe type X.M.N is never used locally\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tpublic A(String s) {\n\t\tB.test();\n\t}\n\n\tprivate static class B extends A {\n\t\tpublic B () { super(\"\"); }\n\tprivate static void test() {};\n\t}\n}\n"}, "----------\n1. WARNING in A.java (at line 3)\n\tB.test();\n\t^^^^^^^^\nAccess to enclosing method test() from the type A.B is emulated by a synthetic accessor method\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tpublic A(String s) {\n\t\tB.test();\n\t}\n\tpublic A() {}\n\n\tprivate static class B extends A {\n\t\tpublic B () { super(\"\"); }\n\t\tprivate static void test() {};\n   }\n}\n"}, "----------\n1. WARNING in A.java (at line 3)\n\tB.test();\n\t^^^^^^^^\nAccess to enclosing method test() from the type A.B is emulated by a synthetic accessor method\n----------\n2. WARNING in A.java (at line 8)\n\tpublic B () { super(\"\"); }\n\t       ^^^^\nThe constructor A.B() is never used locally\n----------\n");
    }

    public void test007() {
        this.runConformTest(new String[]{"A.java", "public class A {\n\tpublic A(String s) {\n\t\tB.test();\n\t}\n\tpublic A() {}\n\n\tprivate static class B extends A {\n\t\tprivate static void test() {};\n\t}\n}\n"});
    }

    public void test008() {
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tpublic A(String s) {this();}\n\tprivate A() {}\n}\nclass C {\n\tprivate static class B extends A {\n\t\tpublic B () { super(\"\"); }\n\t\tstatic void foo() {}\n\t}\n\tC() {\n\t\tB.foo();\n\t}\n}\n"}, "");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"A.java", "public class A {\n\tpublic A(String s) {}\n\tprotected A() {}\n}\nclass C {\n\tprivate static class B extends A {\n\t\tpublic B () { super(\"\"); }\n\t\tstatic void foo() {}\n\t}\n\tC() {\n\t\tB.foo();\n\t}\n}\n"}, "----------\n1. WARNING in A.java (at line 7)\n\tpublic B () { super(\"\"); }\n\t       ^^^^\nThe constructor C.B() is never used locally\n----------\n");
    }

    public void test408038a() {
        if (this.complianceLevel < 0x320000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate class Y {\n\t\tstatic final int i = 10;\n\t\tpublic Y() {}\n\t\tpublic Y(int x) {System.out.println(x);}\n   }\n\n\tpublic void zoo() {\n\t\tSystem.out.println(Y.i);\n\t\tY y = new Y(5);\n\t\tSystem.out.println(y);\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tpublic Y() {}\n\t       ^^^\nThe constructor X.Y() is never used locally\n----------\n", null, true, null);
    }

    public void test408038b() {
        if (this.complianceLevel < 0x320000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tprivate static class Y {\n\t\tstatic final int i = 10;\n\t\tpublic Y() {}\n\t\tpublic Y(int x) {System.out.println(x);}\n   }\n\n\tpublic void zoo() {\n\t\tSystem.out.println(Y.i);\n\t\tY y = new Y(5);\n\t\tSystem.out.println(y);\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 4)\n\tpublic Y() {}\n\t       ^^^\nThe constructor X.Y() is never used locally\n----------\n", null, true, null);
    }

    public void test408038c() {
        if (this.complianceLevel < 0x320000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.io.Externalizable;\nimport java.io.IOException;\nimport java.io.ObjectInput;\nimport java.io.ObjectOutput;\npublic class X {\n\tprivate static class Y implements Externalizable {\n\t\tstatic final int i = 10;\n\t\tpublic Y() {}\n\t\tpublic Y(int x) {System.out.println(x);}\n\n\t\t@Override\n\t\tpublic void writeExternal(ObjectOutput out) throws IOException {\n\t\t}\n\n\t\t@Override \n\t\tpublic void readExternal(ObjectInput in) throws IOException,\n\t\tClassNotFoundException {\n\t\t}\n\t}\n\tpublic void zoo() {\n\t\tSystem.out.println(Y.i);\n\t\tY y = new Y(5);\n\t\tSystem.out.println(y);\n\t}\n}"}, "", null, true, null);
    }

    public void test408038d() {
        if (this.complianceLevel < 0x320000L) {
            return;
        }
        this.runNegativeTest(new String[]{"X.java", "import java.io.Externalizable;\nimport java.io.IOException;\nimport java.io.ObjectInput;\nimport java.io.ObjectOutput;\npublic class X {\n\tprivate class Y implements Externalizable {\n\t\tstatic final int i = 10;\n\t\tpublic Y() {}\n\t\tpublic Y(int x) {System.out.println(x);}\n\n\t\t@Override\n\t\tpublic void writeExternal(ObjectOutput out) throws IOException {\n\t\t}\n\n\t\t@Override \n\t\tpublic void readExternal(ObjectInput in) throws IOException,\n\t\tClassNotFoundException {\n\t\t}\n\t}\n\tpublic void zoo() {\n\t\tSystem.out.println(Y.i);\n\t\tY y = new Y(5);\n\t\tSystem.out.println(y);\n\t}\n}"}, "----------\n1. WARNING in X.java (at line 8)\n\tpublic Y() {}\n\t       ^^^\nThe constructor X.Y() is never used locally\n----------\n", null, true, null);
    }

    public void test408038e() {
        this.runNegativeTest(new String[]{"X.java", "class X {\n\tint i;\n\tprivate X(int x) {i = x;}\n\tX() {}\n\tpublic int foo() {\n\t\tX x = new X();\n\t\treturn x.i;\n\t}\n}\n"}, "----------\n1. WARNING in X.java (at line 3)\n\tprivate X(int x) {i = x;}\n\t        ^^^^^^^^\nThe constructor X(int) is never used locally\n----------\n");
    }
}

