/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractComparableTest;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;

public class RepeatableAnnotationTest
extends AbstractComparableTest {
    public RepeatableAnnotationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return RepeatableAnnotationTest.buildMinimalComplianceTestSuite(RepeatableAnnotationTest.testClass(), 32);
    }

    public static Class testClass() {
        return RepeatableAnnotationTest.class;
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "public @Foo @Foo class X {\n}\n\n", "Foo.java", "public @interface Foo {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic @Foo @Foo class X {\n\t       ^^^^\nDuplicate annotation of non-repeatable type @Foo. Only annotation types marked @Repeatable can be used multiple times at one target.\n----------\n2. ERROR in X.java (at line 1)\n\tpublic @Foo @Foo class X {\n\t            ^^^^\nDuplicate annotation of non-repeatable type @Foo. Only annotation types marked @Repeatable can be used multiple times at one target.\n----------\n");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "@Foo @Foo public class X {\n}\n\n", "Foo.java", "@java.lang.annotation.Repeatable(FooContainer.class) public @interface Foo {\n}\n", "FooContainer.java", "public @interface FooContainer {\n\tFoo[] value();\n}\n"}, "");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"FooContainer.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target({ElementType.METHOD, ElementType.FIELD}) public @interface FooContainer {\n\tFoo[] value();\n}\n", "Foo.java", "@java.lang.annotation.Repeatable(FooContainer.class) public @interface Foo {\n}\n", "X.java", "@Foo @Foo public class X { /* Problem */\n  @Foo @Foo void okHere() { /* No problem */\n    @Foo @Foo int local = 0; /* Problem! */\n  }\n  @Foo @Foo int alsoFoo = 0; /* No problem */\n  @Foo class Y {} /* No problem since not repeated */\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Foo @Foo public class X { /* Problem */\n\t^^^^\nThe annotation @Foo cannot be repeated at this location since its container annotation type @FooContainer is disallowed at this location\n----------\n2. ERROR in X.java (at line 3)\n\t@Foo @Foo int local = 0; /* Problem! */\n\t^^^^\nThe annotation @Foo cannot be repeated at this location since its container annotation type @FooContainer is disallowed at this location\n----------\n");
    }

    public void test004() {
        this.runConformTest(new String[]{"FooContainer.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target({ElementType.METHOD, ElementType.FIELD}) public @interface FooContainer {\n\tFoo[] value();\n}\n", "Foo.java", "@java.lang.annotation.Repeatable(FooContainer.class) public @interface Foo {\n}\n"}, "");
        this.runNegativeTest(new String[]{"X.java", "@Foo @Foo public class X { /* Problem */\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Foo @Foo public class X { /* Problem */\n\t^^^^\nThe annotation @Foo cannot be repeated at this location since its container annotation type @FooContainer is disallowed at this location\n----------\n", null, false);
    }

    public void test005() {
        this.runConformTest(new String[]{"X.java", "@java.lang.annotation.Repeatable(FooContainer.class) @interface Foo {}\n@interface FooContainer { Foo[] value(); }\n@Foo @FooContainer({@Foo, @Foo}) public class X { /* Not a problem */ }\n"}, "");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "@interface FooContainer { Foo[] value(); }\n@java.lang.annotation.Repeatable(FooContainer.class) @interface Foo {}\n@Foo @Foo @FooContainer({@Foo, @Foo}) public class X { /* A problem */ }\n"}, "----------\n1. ERROR in X.java (at line 3)\n\t@Foo @Foo @FooContainer({@Foo, @Foo}) public class X { /* A problem */ }\n\t^^^^\nThe repeatable annotation @Foo may not be repeated where its container annotation type @FooContainer is also used directly\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "@interface FooContainerContainer { FooContainer[] value(); }\n@java.lang.annotation.Repeatable(FooContainerContainer.class) @interface FooContainer { Foo[] value(); }\n@java.lang.annotation.Repeatable(FooContainer.class) @interface Foo {}\n@Foo @Foo @FooContainer({@Foo, @Foo}) public class X { /* Still a problem */ }\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t@Foo @Foo @FooContainer({@Foo, @Foo}) public class X { /* Still a problem */ }\n\t^^^^\nThe repeatable annotation @Foo may not be repeated where its container annotation type @FooContainer is also used directly\n----------\n");
    }

    public void test007a() {
        this.runNegativeTest(new String[]{"X.java", "@interface FooContainerContainer { FooContainer[] value(); }\n@java.lang.annotation.Repeatable(FooContainerContainer.class) @interface FooContainer { Foo[] value(); }\n@java.lang.annotation.Repeatable(FooContainer.class) @interface Foo {}\n@interface Bar {}\n@Foo @Foo @Bar @Bar @FooContainer({@Foo, @Foo}) public class X { /* Still a problem */ }\n"}, "----------\n1. ERROR in X.java (at line 5)\n\t@Foo @Foo @Bar @Bar @FooContainer({@Foo, @Foo}) public class X { /* Still a problem */ }\n\t^^^^\nThe repeatable annotation @Foo may not be repeated where its container annotation type @FooContainer is also used directly\n----------\n2. ERROR in X.java (at line 5)\n\t@Foo @Foo @Bar @Bar @FooContainer({@Foo, @Foo}) public class X { /* Still a problem */ }\n\t          ^^^^\nDuplicate annotation of non-repeatable type @Bar. Only annotation types marked @Repeatable can be used multiple times at one target.\n----------\n3. ERROR in X.java (at line 5)\n\t@Foo @Foo @Bar @Bar @FooContainer({@Foo, @Foo}) public class X { /* Still a problem */ }\n\t               ^^^^\nDuplicate annotation of non-repeatable type @Bar. Only annotation types marked @Repeatable can be used multiple times at one target.\n----------\n");
    }

    public void _test008() {
        this.runNegativeTest(new String[]{"X.java", "@interface Bar {}\n@interface Baz {}\n@java.lang.annotation.Repeatable(FooContainer.class) @interface Foo {}\n@interface FooContainer { Foo[] value(); }\n@Foo @Bar @Foo /* just lexical */ @Foo public class X { /* Gives a warning */ }\n"}, "----------\n1. WARNING in X.java (at line 5)\n\t@Foo @Bar @Foo /* just lexical */ @Foo public class X { /* Gives a warning */ }\n\t          ^^^^\nRepeated @Foo annotations are not grouped together\n----------\n");
    }

    public void _test009() {
        this.runConformTest(new String[]{"Y.java", "@java.lang.annotation.Repeatable(FooContainer.class) @interface Foo { int value(); }\n@Deprecated @interface FooContainer { Foo[] value(); }\n@Foo(0) class X { /* Gives a warning */ }\n@Foo(1) @Foo(2) public class Y { /* Gives a warning */ }\n"}, new ASTVisitor(){

            public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
                if (new String(typeDeclaration.name).equals("X")) {
                    RepeatableAnnotationTest.assertFalse((String)"Foo on X should NOT be deprecated!", (boolean)typeDeclaration.annotations[0].getCompilerAnnotation().getAnnotationType().isDeprecated());
                }
                if (new String(typeDeclaration.name).equals("Y")) {
                    RepeatableAnnotationTest.assertEquals((String)"Find Foo(1) on Y", (Object)IntConstant.fromValue((int)1), (Object)typeDeclaration.annotations[0].getCompilerAnnotation().getElementValuePairs()[0].value);
                    RepeatableAnnotationTest.assertTrue((String)"1st Foo on Y should be deprecated!", (boolean)typeDeclaration.annotations[0].getCompilerAnnotation().getAnnotationType().isDeprecated());
                    RepeatableAnnotationTest.assertEquals((String)"Find Foo(2) on Y", (Object)IntConstant.fromValue((int)2), (Object)typeDeclaration.annotations[1].getCompilerAnnotation().getElementValuePairs()[0].value);
                    RepeatableAnnotationTest.assertTrue((String)"2nd Foo on Y should be deprecated!", (boolean)typeDeclaration.annotations[1].getCompilerAnnotation().getAnnotationType().isDeprecated());
                }
                return true;
            }
        });
    }

    public void test010() {
        this.runNegativeTest(new String[]{"Foo.java", "@interface FooContainer {\n}\n@java.lang.annotation.Repeatable(FooContainer.class)\n@interface Foo {}\n"}, "----------\n1. ERROR in Foo.java (at line 3)\n\t@java.lang.annotation.Repeatable(FooContainer.class)\n\t                                 ^^^^^^^^^^^^^^^^^^\nThe container annotation type @FooContainer must declare a member value()\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"Foo.java", "@interface FooContainer {\n    int[] value();\n}\n@java.lang.annotation.Repeatable(FooContainer.class)\n@interface Foo {}\n"}, "----------\n1. ERROR in Foo.java (at line 4)\n\t@java.lang.annotation.Repeatable(FooContainer.class)\n\t                                 ^^^^^^^^^^^^^^^^^^\nThe value method in the container annotation type @FooContainer must be of type Foo[] but is int[]\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"Foo.java", "@interface FooContainer {\n    Foo[][] value();\n}\n@java.lang.annotation.Repeatable(FooContainer.class)\n@interface Foo {}\n"}, "----------\n1. ERROR in Foo.java (at line 2)\n\tFoo[][] value();\n\t^^^^^^^\nInvalid type Foo[][] for the annotation attribute FooContainer.value; only primitive type, String, Class, annotation, enumeration are permitted or 1-dimensional arrays thereof\n----------\n2. ERROR in Foo.java (at line 4)\n\t@java.lang.annotation.Repeatable(FooContainer.class)\n\t                                 ^^^^^^^^^^^^^^^^^^\nThe value method in the container annotation type @FooContainer must be of type Foo[] but is Foo[][]\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"Foo.java", "@interface FooContainer {\n    Foo[] value();\n    int hasDefaultValue() default 1337;\n    int doesntHaveDefaultValue();\n}\n@java.lang.annotation.Repeatable(FooContainer.class)\n@interface Foo {}\n"}, "----------\n1. ERROR in Foo.java (at line 6)\n\t@java.lang.annotation.Repeatable(FooContainer.class)\n\t                                 ^^^^^^^^^^^^^^^^^^\nThe container annotation type @FooContainer must declare a default value for the annotation attribute 'doesntHaveDefaultValue'\n----------\n");
    }

    public void test014() {
        this.runConformTest(new String[]{"Foo.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@Retention(RetentionPolicy.CLASS)\n@interface FooContainer {\n    Foo[] value();\n}\n@java.lang.annotation.Repeatable(FooContainer.class)\n@Retention(RetentionPolicy.CLASS)\n@interface Foo {\n}\n"}, "");
    }

    public void test015() {
        this.runConformTest(new String[]{"FooContainer.java", "public @interface FooContainer {\n\tFoo[] value();\n}\n", "Foo.java", "@java.lang.annotation.Repeatable(FooContainer.class) public @interface Foo {\n}\n"}, "");
        this.runConformTest(new String[]{"FooContainer.java", "public @interface FooContainer {\n\tint[] value();\n}\n"}, "", null, false, null);
        this.runNegativeTest(new String[]{"X.java", "@Foo @Foo public class X { /* Problem since Foo now uses FooContainer which doesn't work anymore*/\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\t@Foo @Foo public class X { /* Problem since Foo now uses FooContainer which doesn't work anymore*/\n\t^^^^\nThe value method in the container annotation type @FooContainer must be of type Foo[] but is int[]\n----------\n", null, false);
    }

    public void test016() {
        this.runNegativeTest(new String[]{"Foo.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@Retention(RetentionPolicy.SOURCE)\n@interface FooContainer { Foo[] value(); }\n@java.lang.annotation.Repeatable(FooContainer.class)\n@Retention(RetentionPolicy.RUNTIME)\n@interface Foo { }\n"}, "----------\n1. ERROR in Foo.java (at line 5)\n\t@java.lang.annotation.Repeatable(FooContainer.class)\n\t                                 ^^^^^^^^^^^^^^^^^^\nRetention 'RUNTIME' of @Foo is longer than the retention of its container annotation type @FooContainer, which is 'SOURCE'\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"Foo.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@Retention(RetentionPolicy.SOURCE)\n@interface FooContainer { Foo[] value(); }\n@java.lang.annotation.Repeatable(FooContainer.class)\n@interface Foo { }\n"}, "----------\n1. ERROR in Foo.java (at line 5)\n\t@java.lang.annotation.Repeatable(FooContainer.class)\n\t                                 ^^^^^^^^^^^^^^^^^^\nRetention 'CLASS' of @Foo is longer than the retention of its container annotation type @FooContainer, which is 'SOURCE'\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"Foo.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@interface FooContainer { Foo[] value(); }\n@java.lang.annotation.Repeatable(FooContainer.class)\n@Retention(RetentionPolicy.RUNTIME)\n@interface Foo { }\n"}, "----------\n1. ERROR in Foo.java (at line 4)\n\t@java.lang.annotation.Repeatable(FooContainer.class)\n\t                                 ^^^^^^^^^^^^^^^^^^\nRetention 'RUNTIME' of @Foo is longer than the retention of its container annotation type @FooContainer, which is 'CLASS'\n----------\n");
    }

    public void test019() {
        this.runConformTest(new String[]{"Foo.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@interface FooContainer { Foo[] value(); }\n@java.lang.annotation.Repeatable(FooContainer.class)\n@Retention(RetentionPolicy.SOURCE)\n@interface Foo { }\n"});
    }

    public void test020() {
        this.runConformTest(new String[]{"FooContainer.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@Retention(RetentionPolicy.SOURCE)\npublic @interface FooContainer { Foo[] value(); }\n", "Foo.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@Retention(RetentionPolicy.SOURCE)\n@java.lang.annotation.Repeatable(FooContainer.class)\npublic @interface Foo { }\n"});
        this.runNegativeTest(new String[]{"Foo.java", "@java.lang.annotation.Repeatable(FooContainer.class)\npublic @interface Foo { } // If omitted, retention is class\n"}, "----------\n1. ERROR in Foo.java (at line 1)\n\t@java.lang.annotation.Repeatable(FooContainer.class)\n\t                                 ^^^^^^^^^^^^^^^^^^\nRetention 'CLASS' of @Foo is longer than the retention of its container annotation type @FooContainer, which is 'SOURCE'\n----------\n", null, false);
    }

    public void test021() {
        this.runConformTest(new String[]{"FooContainer.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\npublic @interface FooContainer { Foo[] value(); }\n", "Foo.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@java.lang.annotation.Repeatable(FooContainer.class)\npublic @interface Foo { }\n"});
        this.runNegativeTest(new String[]{"Foo.java", "import java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\n@java.lang.annotation.Repeatable(FooContainer.class)\n@Retention(RetentionPolicy.RUNTIME)\n@interface Foo { }\n"}, "----------\n1. ERROR in Foo.java (at line 3)\n\t@java.lang.annotation.Repeatable(FooContainer.class)\n\t                                 ^^^^^^^^^^^^^^^^^^\nRetention 'RUNTIME' of @Foo is longer than the retention of its container annotation type @FooContainer, which is 'CLASS'\n----------\n", null, false);
    }

    public void test022() {
        this.runNegativeTest(new String[]{"FooContainer.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\npublic @Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})\n@interface FooContainer { Foo[] value(); }\n", "Foo.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\npublic @java.lang.annotation.Repeatable(FooContainer.class)\n@Target({ElementType.FIELD})\n@interface Foo { }\n"}, "----------\n1. ERROR in Foo.java (at line 3)\n\tpublic @java.lang.annotation.Repeatable(FooContainer.class)\n\t                                        ^^^^^^^^^^^^^^^^^^\nThe container annotation type @FooContainer is allowed at targets where the repeatable annotation type @Foo is not: TYPE, METHOD\n----------\n");
    }

    public void test023() {
        this.runConformTest(new String[]{"FooContainer.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\npublic @Target({ElementType.METHOD})\n@interface FooContainer { Foo[] value(); }\n", "Foo.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\npublic @Target({ElementType.METHOD})\n@interface Foo { }\n"});
        this.runNegativeTest(new String[]{"Foo.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\npublic @java.lang.annotation.Repeatable(FooContainer.class)\n@java.lang.annotation.Target({ElementType.FIELD})\n@interface Foo { }\n"}, "----------\n1. ERROR in Foo.java (at line 3)\n\tpublic @java.lang.annotation.Repeatable(FooContainer.class)\n\t                                        ^^^^^^^^^^^^^^^^^^\nThe container annotation type @FooContainer is allowed at targets where the repeatable annotation type @Foo is not: METHOD\n----------\n", null, false);
    }

    public void test024() {
        this.runConformTest(new String[]{"FooContainer.java", "import java.lang.annotation.ElementType;\n@java.lang.annotation.Target({ElementType.METHOD, ElementType.ANNOTATION_TYPE})\n@interface FooContainer { Foo[] value(); }\n", "Foo.java", "import java.lang.annotation.ElementType;\n@java.lang.annotation.Repeatable(FooContainer.class)\n@java.lang.annotation.Target({ElementType.METHOD, ElementType.TYPE})\n@interface Foo { }\n"});
    }

    public void test025() {
        this.runNegativeTest(new String[]{"FooContainer.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\npublic @Target({ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.CONSTRUCTOR, ElementType.LOCAL_VARIABLE, ElementType.ANNOTATION_TYPE, ElementType.PACKAGE, ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})\n@interface FooContainer { Foo[] value(); }\n", "Foo.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\npublic @java.lang.annotation.Repeatable(FooContainer.class)\n@Target({})\n@interface Foo { }\n"}, "----------\n1. ERROR in Foo.java (at line 3)\n\tpublic @java.lang.annotation.Repeatable(FooContainer.class)\n\t                                        ^^^^^^^^^^^^^^^^^^\nThe container annotation type @FooContainer is allowed at targets where the repeatable annotation type @Foo is not: TYPE, FIELD, METHOD, PARAMETER, CONSTRUCTOR, LOCAL_VARIABLE, ANNOTATION_TYPE, PACKAGE, TYPE_PARAMETER, TYPE_USE\n----------\n");
    }

    public void test026() {
        this.runConformTest(new String[]{"FooContainer.java", "@interface FooContainer { Foo[] value(); }\n", "Foo.java", "@interface Foo { }\n"});
        this.runNegativeTest(new String[]{"Foo.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n@java.lang.annotation.Repeatable(FooContainer.class)\n@java.lang.annotation.Target({ElementType.FIELD})\n@interface Foo { }\n"}, "----------\n1. ERROR in Foo.java (at line 3)\n\t@java.lang.annotation.Repeatable(FooContainer.class)\n\t                                 ^^^^^^^^^^^^^^^^^^\nThe container annotation type @FooContainer is allowed at targets where the repeatable annotation type @Foo is not: TYPE, METHOD, PARAMETER, CONSTRUCTOR, LOCAL_VARIABLE, ANNOTATION_TYPE, PACKAGE\n----------\n", null, false);
    }

    public void test027() {
        this.runConformTest(new String[]{"FooContainer.java", "@java.lang.annotation.Documented @interface FooContainer { Foo[] value(); }\n", "Foo.java", "@java.lang.annotation.Documented @interface Foo { }\n"});
    }

    public void test028() {
        this.runConformTest(new String[]{"FooContainer.java", "@java.lang.annotation.Documented @interface FooContainer { Foo[] value(); }\n", "Foo.java", "@interface Foo { }\n"});
    }

    public void test029() {
        this.runNegativeTest(new String[]{"FooContainer.java", "@interface FooContainer { Foo[] value(); }\n", "Foo.java", "@java.lang.annotation.Repeatable(FooContainer.class) @java.lang.annotation.Documented\n@interface Foo { }\n"}, "----------\n1. ERROR in Foo.java (at line 1)\n\t@java.lang.annotation.Repeatable(FooContainer.class) @java.lang.annotation.Documented\n\t                                 ^^^^^^^^^^^^^^^^^^\nThe repeatable annotation type @Foo is marked @Documented, but its container annotation type @FooContainer is not\n----------\n");
    }

    public void test030() {
        this.runConformTest(new String[]{"FooContainer.java", "@java.lang.annotation.Documented @interface FooContainer { Foo[] value(); }\n", "Foo.java", "@java.lang.annotation.Documented @interface Foo { }\n"});
        this.runConformTest(new String[]{"Foo.java", "public @java.lang.annotation.Documented @java.lang.annotation.Repeatable(FooContainer.class)\n@interface Foo { }\n"}, "", null, false, null);
    }

    public void test031() {
        this.runConformTest(new String[]{"FooContainer.java", "@java.lang.annotation.Inherited @interface FooContainer { Foo[] value(); }\n", "Foo.java", "@java.lang.annotation.Inherited @interface Foo { }\n"});
    }

    public void test032() {
        this.runConformTest(new String[]{"FooContainer.java", "@java.lang.annotation.Inherited @interface FooContainer { Foo[] value(); }\n", "Foo.java", "@interface Foo { }\n"});
    }

    public void test033() {
        this.runNegativeTest(new String[]{"FooContainer.java", "@interface FooContainer { Foo[] value(); }\n", "Foo.java", "@java.lang.annotation.Repeatable(FooContainer.class) @java.lang.annotation.Inherited\n@interface Foo { }\n"}, "----------\n1. ERROR in Foo.java (at line 1)\n\t@java.lang.annotation.Repeatable(FooContainer.class) @java.lang.annotation.Inherited\n\t                                 ^^^^^^^^^^^^^^^^^^\nThe repeatable annotation type @Foo is marked @Inherited, but its container annotation type @FooContainer is not\n----------\n");
    }

    public void test034() {
        this.runConformTest(new String[]{"FooContainer.java", "@java.lang.annotation.Inherited @interface FooContainer { Foo[] value(); }\n", "Foo.java", "@java.lang.annotation.Inherited @interface Foo { }\n"});
        this.runConformTest(new String[]{"Foo.java", "public @java.lang.annotation.Inherited @java.lang.annotation.Repeatable(FooContainer.class)\n@interface Foo { }\n"}, "", null, false, null);
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Target;\n@Target(ElementType.FIELD)\n@interface TC {\n\tT [] value();\n}\n@Target(ElementType.TYPE)\n@Repeatable(TC.class)\n@interface T {\n}\n@T @T // we used to double report here.\npublic class X { \n\tX f;\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\t@Repeatable(TC.class)\n\t            ^^^^^^^^\nThe container annotation type @TC is allowed at targets where the repeatable annotation type @T is not: FIELD\n----------\n2. ERROR in X.java (at line 12)\n\t@T @T // we used to double report here.\n\t^^\nThe annotation @T cannot be repeated at this location since its container annotation type @TC is disallowed at this location\n----------\n");
    }

    public void test036() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Repeatable;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n\n@Retention(RUNTIME)\n@interface AttrContainer {\n  public Attr[] value();\n}\n@Retention(RUNTIME)\n@Repeatable(AttrContainer.class)\n@interface Attr {\n  public int value() default -1;\n}\n\n@Attr(1) @Attr(2)\npublic class X {\n  public static void main(String args[]) {\n  \tObject e[] = X.class.getAnnotationsByType(Attr.class);\n  \tfor (int i=0; i<e.length;++i) System.out.print(e[i] + \" \");\n  }\n}"}, "@Attr(value=1) @Attr(value=2)");
    }

    public void test037() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n\n@Retention(RUNTIME)\n@interface AttrContainer {\n  public Attr[] value();\n}\n@Retention(RUNTIME)\n@Repeatable(AttrContainer.class)\n@interface Attr {\n  public int value() default -1;\n}\n\npublic class X {\n  @Attr(1) class Y1 {}\n  @Attr(1) @Attr(2) class Y2 {} \n  public static void main(String args[]) {\n  \tSystem.out.print(\"Y1: \" + normalizeAnnotation(Y1.class.getAnnotation(Attr.class)) + \"\\n\");\n  \tSystem.out.print(\"Y2: \" + normalizeAnnotation(Y2.class.getAnnotation(Attr.class)) + \"\\n\");\n  \tSystem.out.print(\"Y1: \" + normalizeAnnotation(Y1.class.getAnnotation(AttrContainer.class)) + \"\\n\");\n  \tSystem.out.print(\"Y2: \" + normalizeAnnotation(Y2.class.getAnnotation(AttrContainer.class)) + \"\\n\");\n  }\n  static String normalizeAnnotation(Annotation a) {\n \t\tif (a == null) return null;\n\t  String str = a.toString();\n\t  str = str.replace(\"value={@\", \"value=[@\");\n\t  str = str.replace(\")}\", \")]\");\n\t  return str;\n  }\n}"}, "Y1: @Attr(value=1)\nY2: null\nY1: null\nY2: @AttrContainer(value=[@Attr(value=1), @Attr(value=2)])");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Repeatable;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n\n@Retention(RUNTIME)\n@interface AttrContainer {\n  public Attr[] value();\n}\n@Retention(SOURCE)\n@Repeatable(AttrContainer.class)\n@interface Attr {\n  public int value() default -1;\n}\n\npublic class X {\n  @Attr(1) class Y1 {}\n  @Attr(1) @Attr(2) class Y2 {} \n  public static void main(String args[]) {\n  \tSystem.out.println(\"Y1 has \" + Y1.class.getAnnotationsByType(Attr.class).length);\n  \tSystem.out.println(\"Y2 has \" + Y2.class.getAnnotationsByType(Attr.class).length);\n  }\n}"}, "Y1 has 0\nY2 has 2");
    }

    public void test039() throws Exception {
        String[] testFiles = new String[]{"repeatable/Main.java", "package repeatable;\npublic class Main {\n    public static void main (String[] argv) {\n    };\n}", "repeatable/FooContainer.java", "package repeatable;\n@java.lang.annotation.Target(java.lang.annotation.ElementType.PACKAGE)\n@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)\npublic @interface FooContainer {\n\tFoo[] value();\n}\n", "repeatable/Foo.java", "package repeatable;\n@java.lang.annotation.Repeatable(FooContainer.class)\npublic @interface Foo {}\n", "repeatable/package-info.java", "@Foo @Foo\npackage repeatable;\nimport repeatable.Foo;"};
        this.runConformTest(testFiles, "");
        String expectedOutout = "  RuntimeVisibleAnnotations: \n    #8 @repeatable.FooContainer(\n      #9 value=[\n        annotation value =\n            #10 @repeatable.Foo(\n            )\n        annotation value =\n            #10 @repeatable.Foo(\n            )\n        ]\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "repeatable" + File.separator + "package-info.class", "package-info", expectedOutout, 4);
    }

    public void test040() {
        this.runConformTest(new String[]{"X.java", "import java.lang.reflect.Field;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.Parameter;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n\n@Retention(RUNTIME)\n@interface AttrContainer {\n  public Attr[] value();\n}\n@Retention(RUNTIME)\n@Repeatable(AttrContainer.class)\n@interface Attr {\n  public int value() default -1;\n}\n\npublic class X {\n   @Attr(1) @Attr(2) public int field;\n\n   @Attr(3) @Attr(4)\n   public static void main(@Attr(5) @Attr(6) String args[]) throws Exception {\n    Field fieldField = X.class.getField(\"field\");\n    dump(fieldField.getAnnotationsByType(Attr.class));\n    Method mainMethod = X.class.getMethod(\"main\", (new String[0]).getClass());\n    dump(mainMethod.getAnnotationsByType(Attr.class));\n    Parameter argvParameter = mainMethod.getParameters()[0];\n    dump(argvParameter.getAnnotationsByType(Attr.class));\n   }\n   static void dump(Attr[] attrs) {\n    for (int i=0; i<attrs.length;++i) System.out.print(attrs[i] + \" \");\n   }\n}"}, "@Attr(value=1) @Attr(value=2) @Attr(value=3) @Attr(value=4) @Attr(value=5) @Attr(value=6)");
    }

    public void testTypeParameters() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport java.lang.reflect.AnnotatedElement;\nimport java.lang.reflect.AnnotatedType;\nimport java.lang.reflect.Field;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.Type;\nimport java.lang.reflect.TypeVariable;\n\nimport static java.lang.annotation.RetentionPolicy.*;\n\n@Retention(RUNTIME)\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD, ElementType.CONSTRUCTOR, ElementType.PARAMETER,})\n@interface TC {\n  public T[] value();\n}\n@Retention(RUNTIME)\n@Repeatable(TC.class)\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.METHOD})\n@interface T {\n  public int value() default -1;\n}\n\ninterface I<@T(1) @T(2) K extends @T(3) @T(4) Object & java.lang.@T(5) @T(6) Comparable<?>> {\n}\n\n\npublic class X {\n  public static void main(String args[]) {\n\tClass<I> ci = I.class;  \n  \tprintAnnotations(\"I.class\", ci);\n  \tTypeVariable<Class<I>>[] typeParameters = ci.getTypeParameters();\n  \tfor (TypeVariable<?> t: typeParameters) {\n  \t\tprintAnnotations(t.getName(), t);\n  \t\tAnnotatedType[] bounds = t.getAnnotatedBounds();\n  \t\tfor (AnnotatedType bound : bounds) {\n  \t\t\tprintAnnotations(bound.getType().getTypeName(), bound);\n  \t\t}\n  \t}\n  }\n  \n  static void printAnnotations(String name, AnnotatedElement element) {\n\t  int [] iterations = { 0, 1 };\n\t  for (int i : iterations) {\n\t\t  Class<? extends Annotation> annotation = i == 0 ? T.class : TC.class;\n\t\t  for (int j: iterations) {\n\t\t\t  Annotation [] annotations = j == 0 ? new Annotation [] { element.getAnnotation(annotation) } : element.getAnnotationsByType(annotation);\n\t\t\t  if (annotations.length == 0 || (annotations.length == 1 && annotations[0] == null)) continue;\n\t\t\t  System.out.print(name + (j == 0 ? \".getAnnotation(\" : \".getAnnotationByType(\") + annotation.getName() + \".class): \");\n\t\t\t  for (Annotation a : annotations) {\n\t\t\t\t  System.out.print(normalizeAnnotation(a) + \" \");\n\t\t\t  }\n\t\t\t  System.out.print(\"\\n\");\n\t\t  }\n\t  }\n  }\n  static String normalizeAnnotation(Annotation a) {\n \t\tif (a == null) return null;\n\t  String str = a.toString();\n\t  str = str.replace(\"value={@\", \"value=[@\");\n\t  str = str.replace(\")}\", \")]\");\n\t  return str;\n  }\n}\n"}, "K.getAnnotationByType(T.class): @T(value=1) @T(value=2) \nK.getAnnotation(TC.class): @TC(value=[@T(value=1), @T(value=2)]) \nK.getAnnotationByType(TC.class): @TC(value=[@T(value=1), @T(value=2)]) \njava.lang.Object.getAnnotationByType(T.class): @T(value=3) @T(value=4) \njava.lang.Object.getAnnotation(TC.class): @TC(value=[@T(value=3), @T(value=4)]) \njava.lang.Object.getAnnotationByType(TC.class): @TC(value=[@T(value=3), @T(value=4)]) \njava.lang.Comparable<?>.getAnnotationByType(T.class): @T(value=5) @T(value=6) \njava.lang.Comparable<?>.getAnnotation(TC.class): @TC(value=[@T(value=5), @T(value=6)]) \njava.lang.Comparable<?>.getAnnotationByType(TC.class): @TC(value=[@T(value=5), @T(value=6)])", null, true, new String[]{"-Ddummy"});
    }

    public void testVariousSites() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Annotation;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport java.lang.reflect.AnnotatedArrayType;\nimport java.lang.reflect.AnnotatedElement;\nimport java.lang.reflect.AnnotatedParameterizedType;\nimport java.lang.reflect.AnnotatedType;\nimport java.lang.reflect.Constructor;\nimport java.lang.reflect.Field;\nimport java.lang.reflect.Method;\nimport java.lang.reflect.TypeVariable;\n\nimport static java.lang.annotation.RetentionPolicy.*;\n\n@Retention(RUNTIME)\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.METHOD})\n@interface TC {\n  public T[] value();\n}\n@Retention(RUNTIME)\n@Repeatable(TC.class)\n@Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.METHOD})\n@interface T {\n  public int value() default -1;\n}\n\ninterface I {\n}\n\n@T(1) @T(2)\npublic class X<@T(3) @T(4) K extends @T(5) @T(6) Object & java.lang.@T(7) @T(8) Comparable<?>, @T(9) @T(10) V> extends @T(11) @T(12) Object implements @T(13) @T(14) I {\n  public @T(15) @T(16) X<@T(17) @T(18) String, @T(19) @T(20) Integer> field;\n  @T(21) @T(22)\n  public <@T(23) @T(24) Q> X @T(25) @T(26) [] method(@T(27) @T(28) X<K, V> this, \n\t\t                                             @T(29) @T(30) X<@T(31) @T(32) String, String> that) throws @T(33) @T(34) NullPointerException {\n\t  return null;\n  }\n  @T(35) @T(36)\n  public X() {\n\t  \n  }\n  @T(37) @T(48)\n  public class MemberType {\n\t  \n  }\n  \n  public static void main(String args[]) {\n\tClass<X> xc = X.class;  \n  \tprintAnnotations(\"Class: \" + \"X.class\", xc);\n  \tTypeVariable<Class<X>>[] typeParameters = xc.getTypeParameters();\n  \tfor (TypeVariable<?> t: typeParameters) {\n  \t\tprintAnnotations(\"Type Parameter: \" + t.getName(), t);\n  \t\tAnnotatedType[] bounds = t.getAnnotatedBounds();\n  \t\tfor (AnnotatedType bound : bounds) {\n  \t\t\tprintAnnotations(\"Type parameter bound: \" + bound.getType().getTypeName(), bound);\n  \t\t}\n  \t}\n  \tAnnotatedType annotatedSuperclass = xc.getAnnotatedSuperclass();\n  \tprintAnnotations(\"Superclass: \" + annotatedSuperclass.getType().getTypeName(), annotatedSuperclass);\n  \t\n  \tAnnotatedType [] annotatedSuperInterfaces = xc.getAnnotatedInterfaces();\n  \tprintAnnotations(\"Superinterface: \" + annotatedSuperInterfaces[0].getType().getTypeName(), annotatedSuperInterfaces[0]);\n  \t\n  \tfor (Field field: xc.getFields()) {\n  \t\tprintAnnotations(\"Field: \" + field.getName(), field);\n  \t\tAnnotatedParameterizedType fType = (AnnotatedParameterizedType) field.getAnnotatedType();\n  \t\tfor (AnnotatedType typeArgumentType : fType.getAnnotatedActualTypeArguments())\n  \t\t\tprintAnnotations(\"Field Type argument: \" + typeArgumentType.getType().getTypeName(), typeArgumentType);\n  \t\t\t\n  \t}\n  \tfor (Method method: xc.getMethods()) {\n  \t\tswitch (method.getName()) {\n  \t\tcase \"method\"  :\n  \t\t\tprintAnnotations(method.getName(), method);\n  \t\t\tAnnotatedArrayType mType = (AnnotatedArrayType) method.getAnnotatedReturnType();\n  \t\t\tprintAnnotations(\"Method return type: \" + mType.getType().getTypeName(), mType);\n  \t\t\tAnnotatedType mTypeEtype = mType.getAnnotatedGenericComponentType();\n  \t\t\tprintAnnotations(\"Method return type, element type: \" + mTypeEtype.getType().getTypeName(), mTypeEtype);\n  \t\t\tTypeVariable<Method>[] typeParameters2 = method.getTypeParameters();\n  \t\t  \tfor (TypeVariable<?> t: typeParameters2) {\n  \t\t  \t\tprintAnnotations(\"Method Type Parameter: \" + t.getName(), t);\n  \t\t  \t}\n  \t\t  \tAnnotatedType annotatedReceiverType = method.getAnnotatedReceiverType();\n  \t\t  \tprintAnnotations(\"Receiver: \", annotatedReceiverType);\n  \t\t  \tAnnotatedType[] annotatedParameterTypes = method.getAnnotatedParameterTypes();\n  \t\t  \tfor (AnnotatedType annotatedParameterType : annotatedParameterTypes) {\n  \t\t  \t\tprintAnnotations(\"Parameter: \", annotatedParameterType);\n  \t\t  \t}\n  \t\t  \tAnnotatedType[] annotatedExceptionTypes = method.getAnnotatedExceptionTypes();\n  \t\t  \tfor (AnnotatedType annotatedType : annotatedExceptionTypes) {\n\t\t\t\tprintAnnotations(\"Exception type: \", annotatedType);\n\t\t\t}\n  \t\t\tbreak;\n  \t\t}\n  \t}\n  \tfor (Constructor<?> constructor : xc.getConstructors()) {\n  \t\tprintAnnotations(\"Constructor: \", constructor);\n  \t}\n  \t// don't know how to get member classes.\n  }\n  \n  static void printAnnotations(String name, AnnotatedElement element) {\n\t  int [] iterations = { 0, 1 };\n\t  for (int i : iterations) {\n\t\t  Class<? extends Annotation> annotation = i == 0 ? T.class : TC.class;\n\t\t  for (int j: iterations) {\n\t\t\t  Annotation [] annotations = j == 0 ? new Annotation [] { element.getAnnotation(annotation) } : element.getAnnotationsByType(annotation);\n\t\t\t  if (annotations.length == 0 || (annotations.length == 1 && annotations[0] == null)) continue;\n\t\t\t  System.out.print(name + (j == 0 ? \".getAnnotation(\" : \".getAnnotationByType(\") + annotation.getName() + \".class): \");\n\t\t\t  for (Annotation a : annotations) {\n\t\t\t\t  System.out.print(normalizeAnnotation(a) + \" \");\n\t\t\t  }\n\t\t\t  System.out.print(\"\\n\");\n\t\t  }\n\t  }\n  }\n  static String normalizeAnnotation(Annotation a) {\n \t\tif (a == null) return null;\n\t  String str = a.toString();\n\t  str = str.replace(\"value={@\", \"value=[@\");\n\t  str = str.replace(\")}\", \")]\");\n\t  return str;\n  }\n}\n"}, "Class: X.class.getAnnotationByType(T.class): @T(value=1) @T(value=2) \nClass: X.class.getAnnotation(TC.class): @TC(value=[@T(value=1), @T(value=2)]) \nClass: X.class.getAnnotationByType(TC.class): @TC(value=[@T(value=1), @T(value=2)]) \nType Parameter: K.getAnnotationByType(T.class): @T(value=3) @T(value=4) \nType Parameter: K.getAnnotation(TC.class): @TC(value=[@T(value=3), @T(value=4)]) \nType Parameter: K.getAnnotationByType(TC.class): @TC(value=[@T(value=3), @T(value=4)]) \nType parameter bound: java.lang.Object.getAnnotationByType(T.class): @T(value=5) @T(value=6) \nType parameter bound: java.lang.Object.getAnnotation(TC.class): @TC(value=[@T(value=5), @T(value=6)]) \nType parameter bound: java.lang.Object.getAnnotationByType(TC.class): @TC(value=[@T(value=5), @T(value=6)]) \nType parameter bound: java.lang.Comparable<?>.getAnnotationByType(T.class): @T(value=7) @T(value=8) \nType parameter bound: java.lang.Comparable<?>.getAnnotation(TC.class): @TC(value=[@T(value=7), @T(value=8)]) \nType parameter bound: java.lang.Comparable<?>.getAnnotationByType(TC.class): @TC(value=[@T(value=7), @T(value=8)]) \nType Parameter: V.getAnnotationByType(T.class): @T(value=9) @T(value=10) \nType Parameter: V.getAnnotation(TC.class): @TC(value=[@T(value=9), @T(value=10)]) \nType Parameter: V.getAnnotationByType(TC.class): @TC(value=[@T(value=9), @T(value=10)]) \nSuperclass: java.lang.Object.getAnnotationByType(T.class): @T(value=11) @T(value=12) \nSuperclass: java.lang.Object.getAnnotation(TC.class): @TC(value=[@T(value=11), @T(value=12)]) \nSuperclass: java.lang.Object.getAnnotationByType(TC.class): @TC(value=[@T(value=11), @T(value=12)]) \nSuperinterface: I.getAnnotationByType(T.class): @T(value=13) @T(value=14) \nSuperinterface: I.getAnnotation(TC.class): @TC(value=[@T(value=13), @T(value=14)]) \nSuperinterface: I.getAnnotationByType(TC.class): @TC(value=[@T(value=13), @T(value=14)]) \nField: field.getAnnotationByType(T.class): @T(value=15) @T(value=16) \nField: field.getAnnotation(TC.class): @TC(value=[@T(value=15), @T(value=16)]) \nField: field.getAnnotationByType(TC.class): @TC(value=[@T(value=15), @T(value=16)]) \nField Type argument: java.lang.String.getAnnotationByType(T.class): @T(value=17) @T(value=18) \nField Type argument: java.lang.String.getAnnotation(TC.class): @TC(value=[@T(value=17), @T(value=18)]) \nField Type argument: java.lang.String.getAnnotationByType(TC.class): @TC(value=[@T(value=17), @T(value=18)]) \nField Type argument: java.lang.Integer.getAnnotationByType(T.class): @T(value=19) @T(value=20) \nField Type argument: java.lang.Integer.getAnnotation(TC.class): @TC(value=[@T(value=19), @T(value=20)]) \nField Type argument: java.lang.Integer.getAnnotationByType(TC.class): @TC(value=[@T(value=19), @T(value=20)]) \nmethod.getAnnotationByType(T.class): @T(value=21) @T(value=22) \nmethod.getAnnotation(TC.class): @TC(value=[@T(value=21), @T(value=22)]) \nmethod.getAnnotationByType(TC.class): @TC(value=[@T(value=21), @T(value=22)]) \nMethod return type: X[].getAnnotationByType(T.class): @T(value=25) @T(value=26) \nMethod return type: X[].getAnnotation(TC.class): @TC(value=[@T(value=25), @T(value=26)]) \nMethod return type: X[].getAnnotationByType(TC.class): @TC(value=[@T(value=25), @T(value=26)]) \nMethod return type, element type: X.getAnnotationByType(T.class): @T(value=21) @T(value=22) \nMethod return type, element type: X.getAnnotation(TC.class): @TC(value=[@T(value=21), @T(value=22)]) \nMethod return type, element type: X.getAnnotationByType(TC.class): @TC(value=[@T(value=21), @T(value=22)]) \nMethod Type Parameter: Q.getAnnotationByType(T.class): @T(value=23) @T(value=24) \nMethod Type Parameter: Q.getAnnotation(TC.class): @TC(value=[@T(value=23), @T(value=24)]) \nMethod Type Parameter: Q.getAnnotationByType(TC.class): @TC(value=[@T(value=23), @T(value=24)]) \nReceiver: .getAnnotationByType(T.class): @T(value=27) @T(value=28) \nReceiver: .getAnnotation(TC.class): @TC(value=[@T(value=27), @T(value=28)]) \nReceiver: .getAnnotationByType(TC.class): @TC(value=[@T(value=27), @T(value=28)]) \nParameter: .getAnnotationByType(T.class): @T(value=29) @T(value=30) \nParameter: .getAnnotation(TC.class): @TC(value=[@T(value=29), @T(value=30)]) \nParameter: .getAnnotationByType(TC.class): @TC(value=[@T(value=29), @T(value=30)]) \nException type: .getAnnotationByType(T.class): @T(value=33) @T(value=34) \nException type: .getAnnotation(TC.class): @TC(value=[@T(value=33), @T(value=34)]) \nException type: .getAnnotationByType(TC.class): @TC(value=[@T(value=33), @T(value=34)]) \nConstructor: .getAnnotationByType(T.class): @T(value=35) @T(value=36) \nConstructor: .getAnnotation(TC.class): @TC(value=[@T(value=35), @T(value=36)]) \nConstructor: .getAnnotationByType(TC.class): @TC(value=[@T(value=35), @T(value=36)])", null, true, new String[]{"-Ddummy"});
    }

    public void testBadContainerType() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.Repeatable;\n@Repeatable(X.class)\n@interface T {\n  public int value() default -1;\n}\npublic class X {\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\t@Repeatable(X.class)\n\t            ^^^^^^^\nType mismatch: cannot convert from Class<X> to Class<? extends Annotation>\n----------\n");
    }

    public void testUnspecifiedTarget() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface TC {\n\tT [] value();\n}\n\n@Repeatable(TC.class)\n@interface T {\n}\n\n@T @T\npublic class X { \n\tX f;\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\t@Repeatable(TC.class)\n\t            ^^^^^^^^\nThe container annotation type @TC is allowed at targets where the repeatable annotation type @T is not: TYPE_USE\n----------\n");
    }

    public void testUnspecifiedTarget2() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Repeatable;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_PARAMETER)\n@interface TC {\n\tT [] value();\n}\n\n@Repeatable(TC.class)\n@interface T {\n}\n\n@T @T\npublic class X { \n\tX f;\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\t@Repeatable(TC.class)\n\t            ^^^^^^^^\nThe container annotation type @TC is allowed at targets where the repeatable annotation type @T is not: TYPE_PARAMETER\n----------\n2. ERROR in X.java (at line 14)\n\t@T @T\n\t^^\nThe annotation @T cannot be repeated at this location since its container annotation type @TC is disallowed at this location\n----------\n");
    }

    public void testDeprecation() {
        this.runNegativeTest(new String[]{"TC.java", "@Deprecated\npublic @interface TC {\n  public T[] value();\n}\n", "T.java", "@java.lang.annotation.Repeatable(TC.class)\n@interface T {\n  public int value() default -1;\n}\ninterface I<@T(1) @T(2) K> {\n}\n"}, "----------\n1. WARNING in T.java (at line 1)\n\t@java.lang.annotation.Repeatable(TC.class)\n\t                                 ^^\nThe type TC is deprecated\n----------\n2. ERROR in T.java (at line 5)\n\tinterface I<@T(1) @T(2) K> {\n\t            ^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n3. WARNING in T.java (at line 5)\n\tinterface I<@T(1) @T(2) K> {\n\t            ^^\nThe type TC is deprecated\n----------\n4. ERROR in T.java (at line 5)\n\tinterface I<@T(1) @T(2) K> {\n\t            ^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n5. ERROR in T.java (at line 5)\n\tinterface I<@T(1) @T(2) K> {\n\t                  ^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n");
    }

    public void testDeprecation2() {
        this.runNegativeTest(new String[]{"T.java", "@Deprecated\n@interface TC {\n  public T[] value();\n}\n@java.lang.annotation.Repeatable(TC.class)\n@interface T {\n  public int value() default -1;\n}\ninterface I<@T(1) @T(2) K> {\n}\n"}, "----------\n1. ERROR in T.java (at line 9)\n\tinterface I<@T(1) @T(2) K> {\n\t            ^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n2. ERROR in T.java (at line 9)\n\tinterface I<@T(1) @T(2) K> {\n\t            ^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n3. ERROR in T.java (at line 9)\n\tinterface I<@T(1) @T(2) K> {\n\t                  ^^\nAnnotation types that do not specify explicit target element types cannot be applied here\n----------\n");
    }

    public void testRepeatableWithContaining1() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, new String[]{"A.java", "@interface FooContainerContainer {\n  public FooContainer[] value();\n}\n@java.lang.annotation.Repeatable(FooContainerContainer.class)\n@interface FooContainer {\n  public Foo[] value();\n}\n@java.lang.annotation.Repeatable(FooContainer.class)\n@interface Foo {\n  public int value() default -1;\n}\n@FooContainer({@Foo(1)}) @FooContainer({@Foo(2)}) @Foo(3) class A {}\n"}, "----------\n1. WARNING in A.java (at line 12)\n\t@FooContainer({@Foo(1)}) @FooContainer({@Foo(2)}) @Foo(3) class A {}\n\t                                                  ^^^^\nThe repeatable annotation @Foo may not be present where its container annotation type @FooContainer is repeated\n----------\n");
    }

    public void testRepeatableWithContaining2() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, new String[]{"A.java", "@interface FooContainerContainer {\n  public FooContainer[] value();\n}\n@java.lang.annotation.Repeatable(FooContainerContainer.class)\n@interface FooContainer {\n  public Foo[] value();\n}\n@java.lang.annotation.Repeatable(FooContainer.class)\n@interface Foo {\n  public int value() default -1;\n}\n@Foo(1) @FooContainer({@Foo(2)}) @FooContainer({@Foo(3)}) class A {}\n"}, "----------\n1. WARNING in A.java (at line 12)\n\t@Foo(1) @FooContainer({@Foo(2)}) @FooContainer({@Foo(3)}) class A {}\n\t^^^^\nThe repeatable annotation @Foo may not be present where its container annotation type @FooContainer is repeated\n----------\n");
    }

    public void testRepeatableWithContaining3() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, new String[]{"A.java", "@interface FooContainerContainer {\n  public FooContainer[] value();\n}\n@java.lang.annotation.Repeatable(FooContainerContainer.class)\n@interface FooContainer {\n  public Foo[] value();\n}\n@java.lang.annotation.Repeatable(FooContainer.class)\n@interface Foo {\n  public int value() default -1;\n}\n@FooContainer({@Foo(2)}) @Foo(1) @FooContainer({@Foo(3)}) class A {}\n"}, "----------\n1. WARNING in A.java (at line 12)\n\t@FooContainer({@Foo(2)}) @Foo(1) @FooContainer({@Foo(3)}) class A {}\n\t                         ^^^^\nThe repeatable annotation @Foo may not be present where its container annotation type @FooContainer is repeated\n----------\n");
    }
}

