/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.osgi.framework.Bundle;

public class ResourceLeakTests
extends AbstractRegressionTest {
    private static final String GUAVA_CLOSEABLES_JAVA = "com/google/common/io/Closeables.java";
    private static final String GUAVA_CLOSEABLES_CONTENT = "package com.google.common.io;\npublic class Closeables {\n    public static void closeQuietly(java.io.Closeable closeable) {}\n    public static void close(java.io.Closeable closeable, boolean flag) {}\n}\n";
    private static final String APACHE_DBUTILS_JAVA = "org/apache/commons/dbutils/DbUtils.java";
    private static final String APACHE_DBUTILS_CONTENT = "package org.apache.commons.dbutils;\nimport java.sql.*;\npublic class DbUtils {\n    public static void close(Connection connection) {}\n    public static void close(ResultSet resultSet) {}\n    public static void close(Statement statement) {}\n    public static void closeQuietly(Connection connection) {}\n    public static void closeQuietly(ResultSet resultSet) {}\n    public static void closeQuietly(Statement statement) {}\n    public static void closeQuietly(Connection conn, Statement stmt, ResultSet rs) {}\n}\n";

    public ResourceLeakTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ResourceLeakTests.buildAllCompliancesTestSuite(ResourceLeakTests.class);
    }

    void runTestsExpectingErrorsOnlyIn17(String[] testFiles, String errorsIn17, Map options) {
        if (this.complianceLevel >= 0x330000L) {
            this.runNegativeTest(testFiles, errorsIn17, null, true, options);
        } else {
            this.runConformTest(testFiles, "", null, true, null, options, null);
        }
    }

    public void test056() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tFileReader fileReader = new FileReader(file);\n\t           ^^^^^^^^^^\nResource leak: 'fileReader' is never closed\n----------\n", null, true, options);
    }

    public void test056a() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        this.runTestsExpectingErrorsOnlyIn17(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n        char[] in = new char[50];\n        fileReader.read(in);\n\t\t fileReader.close();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tFileReader fileReader = new FileReader(file);\n\t           ^^^^^^^^^^\nResource 'fileReader' should be managed by try-with-resource\n----------\n", options);
    }

    public void test056b() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n        try {\n            char[] in = new char[50];\n            fileReader.read(in);\n        } finally {\n\t\t     fileReader.close();\n        }\n    }\n    public static void main(String[] args) {\n        try {\n            new X().foo();\n        } catch (IOException ioex) {\n            System.out.println(\"caught\");\n        }\n    }\n}\n"}, "caught", null, true, null, options, null);
    }

    public void test056c() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        try (FileReader fileReader = new FileReader(file)) {\n            char[] in = new char[50];\n            fileReader.read(in);\n\t\t }\n    }\n    public static void main(String[] args) {\n        try {\n            new X().foo();\n        } catch (IOException ioex) {\n            System.out.println(\"caught\");\n        }\n    }\n}\n"}, "caught", null, true, null, options, null);
    }

    public void test056d() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo(boolean flag1, boolean flag2) throws IOException {\n        File file = new File(\"somefile\");\n        char[] in = new char[50];\n        FileReader fileReader1 = new FileReader(file);\n        fileReader1.read(in);\n        FileReader fileReader2 = new FileReader(file);\n        fileReader2.read(in);\n        if (flag1) {\n            fileReader2.close();\n            return;\n        } else if (flag2) {\n            fileReader2.close();\n        }\n        fileReader1.close();\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo(false, true);\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 10)\n\tFileReader fileReader2 = new FileReader(file);\n\t           ^^^^^^^^^^^\nPotential resource leak: 'fileReader2' may not be closed\n----------\n2. ERROR in X.java (at line 14)\n\treturn;\n\t^^^^^^^\nResource leak: 'fileReader1' is not closed at this location\n----------\n", null, true, options);
    }

    public void test056d_suppress() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        this.enableAllWarningsForIrritants(options, IrritantSet.RESOURCE);
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo(boolean flag1, boolean flag2) throws IOException {\n        @SuppressWarnings(\"resource\") File file = new File(\"somefile\"); // unnecessary suppress\n        char[] in = new char[50];\n        FileReader fileReader1 = new FileReader(file);\n        fileReader1.read(in);\n        @SuppressWarnings(\"resource\") FileReader fileReader2 = new FileReader(file); // useful suppress\n        fileReader2.read(in);\n        if (flag1) {\n            fileReader2.close();\n            return; // not suppressed\n        } else if (flag2) {\n            fileReader2.close();\n        }\n        fileReader1.close();\n    }\n    @SuppressWarnings(\"resource\") // useful suppress\n    void bar() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n        char[] in = new char[50];\n        fileReader.read(in);\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo(false, true);\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 6)\n\t@SuppressWarnings(\"resource\") File file = new File(\"somefile\"); // unnecessary suppress\n\t                  ^^^^^^^^^^\nUnnecessary @SuppressWarnings(\"resource\")\n----------\n2. ERROR in X.java (at line 14)\n\treturn; // not suppressed\n\t^^^^^^^\nResource leak: 'fileReader1' is not closed at this location\n----------\n", null, true, options);
    }

    public void test056e() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    FileReader getReader(String filename) throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n        return fileReader;\n    }\n    void foo() throws IOException {\n        FileReader reader = getReader(\"somefile\");\n        char[] in = new char[50];\n        reader.read(in);\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tFileReader reader = getReader(\"somefile\");\n\t           ^^^^^^\nPotential resource leak: 'reader' may not be closed\n----------\n", null, true, options);
    }

    public void test056f() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        this.runTestsExpectingErrorsOnlyIn17(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = null;\n        try {\n            fileReader = new FileReader(file);\n            char[] in = new char[50];\n            fileReader.read(in);\n        } finally {\n            fileReader.close();\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tFileReader fileReader = null;\n\t           ^^^^^^^^^^\nResource 'fileReader' should be managed by try-with-resource\n----------\n", options);
    }

    public void test056g() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n        char[] in = new char[50];\n        fileReader.read(in);\n        fileReader = new FileReader(file);\n        fileReader.read(in);\n        fileReader.close();\n        fileReader = null;\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tfileReader = new FileReader(file);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: 'fileReader' is not closed at this location\n----------\n", null, true, options);
    }

    public void test056g2() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n        char[] in = new char[50];\n        fileReader.read(in);\n        fileReader = null;\n        fileReader = new FileReader(file);\n        fileReader.read(in);\n        fileReader.close();\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tfileReader = null;\n\t^^^^^^^^^^^^^^^^^\nResource leak: 'fileReader' is not closed at this location\n----------\n", null, true, options);
    }

    public void test056h() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        final File file = new File(\"somefile\");\n        final FileReader fileReader = new FileReader(file);\n        char[] in = new char[50];\n        fileReader.read(in);\n        new Runnable() {\n public void run() {\n            try {\n                fileReader.close();\n                FileReader localReader = new FileReader(file);\n            } catch (IOException ex) { /* nop */ }\n        }}.run();\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tfinal FileReader fileReader = new FileReader(file);\n\t                 ^^^^^^^^^^\nPotential resource leak: 'fileReader' may not be closed\n----------\n2. ERROR in X.java (at line 14)\n\tFileReader localReader = new FileReader(file);\n\t           ^^^^^^^^^^^\nResource leak: 'localReader' is never closed\n----------\n", null, true, options);
    }

    public void test056i() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo(boolean f1, boolean f2) throws IOException {\n        File file = new File(\"somefile\");\n        if (f1) {\n            FileReader fileReader = new FileReader(file); // err: not closed\n            char[] in = new char[50];\n            fileReader.read(in);\n            while (true) {\n                 FileReader loopReader = new FileReader(file); // don't warn, properly closed\n                 loopReader.close();                 break;\n            }\n        } else {\n            FileReader fileReader = new FileReader(file); // warn: not closed on all paths\n            if (f2)\n                fileReader.close();\n        }\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo(true, true);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tFileReader fileReader = new FileReader(file); // err: not closed\n\t           ^^^^^^^^^^\nResource leak: 'fileReader' is never closed\n----------\n2. WARNING in X.java (at line 16)\n\tFileReader fileReader = new FileReader(file); // warn: not closed on all paths\n\t           ^^^^^^^^^^\nPotential resource leak: 'fileReader' may not be closed\n----------\n", null, true, options);
    }

    public void test056i_ignore() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "ignore");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo(boolean f1, boolean f2) throws IOException {\n        File file = new File(\"somefile\");\n        if (f1) {\n            FileReader fileReader = new FileReader(file); // err: not closed\n            char[] in = new char[50];\n            fileReader.read(in);\n            while (true) {\n                 FileReader loopReader = new FileReader(file); // don't warn, properly closed\n                 loopReader.close();                 break;\n            }\n        } else {\n            FileReader fileReader = new FileReader(file); // warn: not closed on all paths\n            if (f2)\n                fileReader.close();\n        }\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test056i2() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo(boolean f1, boolean f2) throws IOException {\n        File file = new File(\"somefile\");\n        if (f1) {\n            FileReader fileReader = new FileReader(file); // properly closed\n            char[] in = new char[50];\n            fileReader.read(in);\n            while (true) {\n                  fileReader.close();\n                  FileReader loopReader = new FileReader(file); // don't warn, properly closed\n                  loopReader.close();\n                  break;\n            }\n        } else {\n            FileReader fileReader = new FileReader(file); // warn: not closed on all paths\n            if (f2)\n                fileReader.close();\n        }\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo(true, true);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\tFileReader fileReader = new FileReader(file); // warn: not closed on all paths\n\t           ^^^^^^^^^^\nPotential resource leak: 'fileReader' may not be closed\n----------\n", null, true, options);
    }

    public void test056j() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n        read(fileReader);\n    }\n    void read(FileReader reader) { }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tFileReader fileReader = new FileReader(file);\n\t           ^^^^^^^^^^\nPotential resource leak: 'fileReader' may not be closed\n----------\n", null, true, options);
    }

    public void test056jconditional() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo(boolean b) throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n        synchronized (b ? this : new X()) {\n            new ReadDelegator(fileReader);\n        }\n    }\n    class ReadDelegator { ReadDelegator(FileReader reader) { } }\n    public static void main(String[] args) throws IOException {\n        new X().foo(true);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tFileReader fileReader = new FileReader(file);\n\t           ^^^^^^^^^^\nPotential resource leak: 'fileReader' may not be closed\n----------\n", null, true, options);
    }

    public void test056k() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        String expectedProblems = this.complianceLevel < 0x330000L ? "----------\n1. ERROR in X.java (at line 15)\n\tra2 = new FileReader(file);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: 'ra2' is never closed\n----------\n2. ERROR in X.java (at line 28)\n\trb2 = new FileReader(file);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: 'rb2' is never closed\n----------\n" : "----------\n1. ERROR in X.java (at line 12)\n\tFileReader ra1 = null, ra2 = null;\n\t           ^^^\nResource 'ra1' should be managed by try-with-resource\n----------\n2. ERROR in X.java (at line 15)\n\tra2 = new FileReader(file);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: 'ra2' is never closed\n----------\n3. ERROR in X.java (at line 16)\n\tFileReader ra3 = new FileReader(file);\n\t           ^^^\nResource 'ra3' should be managed by try-with-resource\n----------\n4. ERROR in X.java (at line 25)\n\tFileReader rb1 = null, rb2 = null;\n\t           ^^^\nResource 'rb1' should be managed by try-with-resource\n----------\n5. ERROR in X.java (at line 28)\n\trb2 = new FileReader(file);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: 'rb2' is never closed\n----------\n6. ERROR in X.java (at line 29)\n\tFileReader rb3 = new FileReader(file);\n\t           ^^^\nResource 'rb3' should be managed by try-with-resource\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        int i01, i02, i03, i04, i05, i06, i07, i08, i09,\n            i11, i12, i13, i14, i15, i16, i17, i18, i19,\n            i21, i22, i23, i24, i25, i26, i27, i28, i29,\n            i31, i32, i33, i34, i35, i36, i37, i38, i39,\n            i41, i42, i43, i44, i45, i46, i47, i48, i49;\n        File file = new File(\"somefile\");\n        FileReader ra1 = null, ra2 = null;\n        try {\n            ra1 = new FileReader(file);\n            ra2 = new FileReader(file);\n            FileReader ra3 = new FileReader(file);\n            char[] in = new char[50];\n            ra1.read(in);\n            ra2.read(in);\n            ra3.close();\n        } finally {\n            ra1.close();\n        }\n        int i51, i52, i53, i54, i55, i56, i57, i58, i59, i60;\n        FileReader rb1 = null, rb2 = null;\n        try {\n            rb1 = new FileReader(file);\n            rb2 = new FileReader(file);\n            FileReader rb3 = new FileReader(file);\n            char[] in = new char[50];\n            rb1.read(in);\n            rb2.read(in);\n            rb3.close();\n        } finally {\n            rb1.close();\n        }\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, expectedProblems, null, true, options);
    }

    public void test056l() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        String expectedProblems = this.complianceLevel >= 0x330000L ? "----------\n1. ERROR in X.java (at line 8)\n\tFileReader fileReader = getReader();\n\t           ^^^^^^^^^^\nResource 'fileReader' should be managed by try-with-resource\n----------\n2. ERROR in X.java (at line 11)\n\tFileReader r3 = getReader();\n\t           ^^\nResource 'r3' should be managed by try-with-resource\n----------\n3. ERROR in X.java (at line 24)\n\tFileReader r2 = new FileReader(new File(\"inexist\")); // only potential problem: ctor X below might close r2\n\t           ^^\nPotential resource leak: 'r2' may not be closed\n----------\n4. ERROR in X.java (at line 25)\n\tnew X(r2).foo(new FileReader(new File(\"notthere\"))); // potential problem: foo may/may not close the new FileReader\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: '<unassigned Closeable value>' may not be closed\n----------\n" : "----------\n1. ERROR in X.java (at line 24)\n\tFileReader r2 = new FileReader(new File(\"inexist\")); // only potential problem: ctor X below might close r2\n\t           ^^\nPotential resource leak: 'r2' may not be closed\n----------\n2. ERROR in X.java (at line 25)\n\tnew X(r2).foo(new FileReader(new File(\"notthere\"))); // potential problem: foo may/may not close the new FileReader\n\t              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: '<unassigned Closeable value>' may not be closed\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    X(FileReader r0) {}\n    FileReader getReader() { return null; }\n    void foo(FileReader r1) throws IOException {\n        FileReader fileReader = getReader();\n        if (fileReader == null)\n            return;\n        FileReader r3 = getReader();\n        if (r3 == null)\n            r3 = new FileReader(new File(\"absent\"));\n        try {\n            char[] in = new char[50];\n            fileReader.read(in);\n            r1.read(in);\n        } finally {\n            fileReader.close();\n            r3.close();\n        }\n    }\n    public static void main(String[] args) throws IOException {\n        FileReader r2 = new FileReader(new File(\"inexist\")); // only potential problem: ctor X below might close r2\n        new X(r2).foo(new FileReader(new File(\"notthere\"))); // potential problem: foo may/may not close the new FileReader\n    }\n}\n"}, expectedProblems, null, true, options);
    }

    public void test056m() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() {\n        File file = new File(\"somefile\");        try {\n            FileReader fileReader = new FileReader(file);\n            try {\n                char[] in = new char[50];\n                if (fileReader.read(in)==0)\n                    return;\n            } finally {\n\t\t         fileReader.close();\n            }\n        } catch (IOException e) {\n            System.out.println(\"caught\");\n        }\n    }\n    public static void main(String[] args) {\n        new X().foo();\n    }\n}\n"}, "caught", null, true, null, options, null);
    }

    public void test056n() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\nimport java.io.FileNotFoundException;\npublic class X {\n    void foo(File someFile, char[] buf) throws IOException {\n\t\tFileReader fr1 = new FileReader(someFile);\n\t\ttry {\n\t\t\tfr1.read(buf);\n\t\t} finally {\n\t\t\tfr1.close();\n\t\t}\n\t\ttry {\n\t\t\tFileReader fr3 = new FileReader(someFile);\n\t\t\ttry {\n\t\t\t} finally {\n\t\t\t\tfr3.close();\n\t\t\t}\n\t\t} catch (IOException e) {\n\t\t}\n\t }\n    public static void main(String[] args) throws IOException {\n        try {\n            new X().foo(new File(\"missing\"), new char[100]);\n        } catch (FileNotFoundException e) {\n            System.out.println(\"caught\");\n        }\n    }\n}\n"}, "caught", null, true, null, options, null);
    }

    public void test056o() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\nimport java.io.FileNotFoundException;\npublic class X {\n    void foo(File someFile, char[] buf) throws IOException {\n\t\tFileReader fr1 = null;\n\t\ttry {\n           fr1 = new FileReader(someFile);\t\t\tfr1.read(buf);\n\t\t} finally {\n\t\t\tif (fr1 != null)\n               try {\n                   fr1.close();\n               } catch (IOException e) { /*do nothing*/ }\n\t\t}\n\t }\n    public static void main(String[] args) throws IOException {\n        try {\n            new X().foo(new File(\"missing\"), new char[100]);\n        } catch (FileNotFoundException e) {\n            System.out.println(\"caught\");\n        }\n    }\n}\n"}, "caught", null, true, null, options, null);
    }

    public void test056p() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.Reader;\nimport java.io.IOException;\npublic abstract class X <T extends Reader> {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        T fileReader = newReader(file);\n        char[] in = new char[50];\n        fileReader.read(in);\n    }\n    abstract T newReader(File file) throws IOException;\n    public static void main(String[] args) throws IOException {\n        new X<FileReader>() {\n            FileReader newReader(File f) throws IOException { return new FileReader(f); }\n        }.foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tT fileReader = newReader(file);\n\t  ^^^^^^^^^^\nPotential resource leak: 'fileReader' may not be closed\n----------\n", null, true, options);
    }

    public void test056q() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n        char[] in = new char[50];\n        fileReader.read(in);\n        if (2*2 == 4)\n        \treturn;\n        fileReader.close();\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tFileReader fileReader = new FileReader(file);\n\t           ^^^^^^^^^^\nResource leak: 'fileReader' is never closed\n----------\n2. WARNING in X.java (at line 10)\n\tif (2*2 == 4)\n\t    ^^^^^^^^\nComparing identical expressions\n----------\n3. WARNING in X.java (at line 12)\n\tfileReader.close();\n\t^^^^^^^^^^^^^^^^^^\nDead code\n----------\n", null, true, options);
    }

    public void test056r() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "ignore");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fr = new FileReader(file);\n  \t\t Object b = null;\n        fr.close();\n        if (b != null) {\n            fr = new FileReader(file);\n            return;\n        } else {\n            System.out.print(42);\n        }\n        return;     // Should not complain about fr\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tif (b != null) {\n            fr = new FileReader(file);\n            return;\n        } else {\n\t               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n2. WARNING in X.java (at line 13)\n\t} else {\n            System.out.print(42);\n        }\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nStatement unnecessarily nested within else clause. The corresponding then clause does not complete normally\n----------\n", null, true, options);
    }

    public void test056s() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "ignore");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        try (FileReader fileReader = new FileReader(file);) {\n            char[] in = new char[50];\n            fileReader.read(in);\n            fileReader = new FileReader(file);  // debug here\n            fileReader.read(in);\n        }\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tfileReader = new FileReader(file);  // debug here\n\t^^^^^^^^^^\nThe resource fileReader of a try-with-resources statement cannot be assigned\n----------\n", null, true, options);
    }

    public void test056t() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo31() throws IOException {\n        FileReader reader = new FileReader(\"file\"); //warning\n        if (reader != null) {\n            reader.close();\n        } else {\n            // nop\n        }\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo31();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\t} else {\n            // nop\n        }\n\t       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nDead code\n----------\n", null, true, options);
    }

    public void test056u() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo() throws Exception {\n        FileReader reader1 = new FileReader(\"file1\");\n        FileReader reader2 = new FileReader(\"file2\");\n        reader2 = reader1;// this disconnects reader 2\n        try (FileReader reader3 = new FileReader(\"file3\")) {\n            int ch;\n            while ((ch = reader2.read()) != -1) {\n                System.out.println(ch);\n                reader1.read();\n            }\n            reader2 = reader1; // warning 1 regarding original reader1\n            reader2 = reader1; // warning 2 regarding original reader1\n        } finally {\n            if (reader2 != null) {\n                reader2.close();\n            } else {\n                System.out.println();\n            }\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tFileReader reader2 = new FileReader(\"file2\");\n\t           ^^^^^^^\nResource leak: 'reader2' is never closed\n----------\n2. ERROR in X.java (at line 13)\n\treader2 = reader1; // warning 1 regarding original reader1\n\t^^^^^^^^^^^^^^^^^\nResource leak: 'reader1' is not closed at this location\n----------\n3. ERROR in X.java (at line 14)\n\treader2 = reader1; // warning 2 regarding original reader1\n\t^^^^^^^^^^^^^^^^^\nResource leak: 'reader1' is not closed at this location\n----------\n", null, true, options);
    }

    public void test056v() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        String expectedProblems = this.complianceLevel >= 0x330000L ? "----------\n1. ERROR in X.java (at line 4)\n\tFileReader reader = new FileReader(\"file\");\n\t           ^^^^^^\nResource leak: 'reader' is never closed\n----------\n2. WARNING in X.java (at line 19)\n\tFileReader reader111 = new FileReader(\"file2\");\n\t           ^^^^^^^^^\nResource 'reader111' should be managed by try-with-resource\n----------\n3. ERROR in X.java (at line 42)\n\treturn;\n\t^^^^^^^\nResource leak: 'reader2' is not closed at this location\n----------\n" : "----------\n1. ERROR in X.java (at line 4)\n\tFileReader reader = new FileReader(\"file\");\n\t           ^^^^^^\nResource leak: 'reader' is never closed\n----------\n2. ERROR in X.java (at line 42)\n\treturn;\n\t^^^^^^^\nResource leak: 'reader2' is not closed at this location\n----------\n";
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    boolean foo1() throws Exception {\n        FileReader reader = new FileReader(\"file\");\n        try {\n            int ch;\n            while ((ch = reader.read()) != -1) {\n                System.out.println(ch);\n                reader.read();\n            }\n            if (ch > 10) {\n                return true;\n            }\n            return false;\n        } finally {\n        }\n    }\n    void foo111() throws Exception {\n        FileReader reader111 = new FileReader(\"file2\");\n        try {\n            int ch;\n            while ((ch = reader111.read()) != -1) {\n                System.out.println(ch);\n                reader111.read();\n            }\n            return;\n        } finally {\n            if (reader111 != null) {\n                reader111.close();\n            }\n        }\n    }\n    void foo2() throws Exception {\n        FileReader reader2 = new FileReader(\"file\");\n        try {\n            int ch;\n            while ((ch = reader2.read()) != -1) {\n                System.out.println(ch);\n                reader2.read();\n            }\n            if (ch > 10) {\n                return;\n            }\n        } finally {\n        }\n        reader2.close();\n    }\n}\n"}, expectedProblems, null, true, options);
    }

    public void test056w() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    boolean foo1() throws Exception {\n        FileReader reader = new FileReader(\"file\");\n        try {\n            int ch;\n            while ((ch = reader.read()) != -1) {\n                System.out.println(ch);\n                reader.read();\n            }\n            if (ch > 10) {\n\t\t\t\t reader.close();\n                return true;\n            }\n            return false;\n        } finally {\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 15)\n\treturn false;\n\t^^^^^^^^^^^^^\nResource leak: 'reader' is not closed at this location\n----------\n", null, true, options);
    }

    public void test056x() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo31(boolean b) throws Exception {\n        FileReader reader = new FileReader(\"file\");\n        if (b) {\n            reader.close();\n        } else {\n            return; // warning\n        }\n    }\n    void foo32(boolean b) throws Exception {\n        FileReader reader = new FileReader(\"file\"); // warn here\n        return;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\treturn; // warning\n\t^^^^^^^\nResource leak: 'reader' is not closed at this location\n----------\n2. ERROR in X.java (at line 12)\n\tFileReader reader = new FileReader(\"file\"); // warn here\n\t           ^^^^^^\nResource leak: 'reader' is never closed\n----------\n", null, true, options);
    }

    public void test056y() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo31(boolean b) throws Exception {\n        final FileReader reader31 = new FileReader(\"file\");\n        new Runnable() {\n            public void run() {\n                foo18(reader31);\n            }\n        }.run();\n    }\n    void foo18(FileReader r18) {\n        // could theoretically close r18;\n    }\n    abstract class ResourceProvider {\n        abstract FileReader provide();    }\n    ResourceProvider provider;    void foo23() throws Exception {\n        final FileReader reader23 = new FileReader(\"file\");\n        provider = new ResourceProvider() {\n            public FileReader provide() {\n                return reader23;\n            }\n        };\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 4)\n\tfinal FileReader reader31 = new FileReader(\"file\");\n\t                 ^^^^^^^^\nPotential resource leak: 'reader31' may not be closed\n----------\n", null, true, options);
    }

    public void test056z() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo17() throws Exception {\n        FileReader reader17 = new FileReader(\"file\");\n        final FileReader readerCopy = reader17;\n        readerCopy.close();\n    }\n    void foo17a() throws Exception {\n        FileReader reader17a = new FileReader(\"file\");\n        FileReader readerCopya;\t\t readerCopya = reader17a;\n        bar(readerCopya);\n    }\n    void bar(FileReader r) {}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tFileReader reader17a = new FileReader(\"file\");\n\t           ^^^^^^^^^\nPotential resource leak: 'reader17a' may not be closed\n----------\n", null, true, options);
    }

    public void test056zz() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runTestsExpectingErrorsOnlyIn17(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo16() throws Exception {\n        FileReader reader16 = new FileReader(\"file\");\n        try {\n            reader16.close();\n             return;\n        } catch (RuntimeException re) {\n            return;\n        } catch (Error e) {\n            return;\n        } finally {\n            reader16.close();\n         }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tFileReader reader16 = new FileReader(\"file\");\n\t           ^^^^^^^^\nResource 'reader16' should be managed by try-with-resource\n----------\n", options);
    }

    public void test056zzz() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo16() throws Exception {\n        FileReader reader16 = new FileReader(\"file\");\n        try {\n            return;\n        } catch (RuntimeException re) {\n            return;\n        } catch (Error e) {\n            return;\n        } finally {\n            System.out.println();\n         }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tFileReader reader16 = new FileReader(\"file\");\n\t           ^^^^^^^^\nResource leak: 'reader16' is never closed\n----------\n", null, true, options);
    }

    public void test056throw1() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo2(boolean a, boolean b, boolean c) throws Exception {\n        FileReader reader = new FileReader(\"file\");\n        if(a)\n            throw new Exception();    //warning 1\n        else if (b)\n            reader.close();\n        else if(c)\n            throw new Exception();    //warning 2\n        reader.close();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tthrow new Exception();    //warning 1\n\t^^^^^^^^^^^^^^^^^^^^^^\nResource leak: 'reader' is not closed at this location\n----------\n2. ERROR in X.java (at line 10)\n\tthrow new Exception();    //warning 2\n\t^^^^^^^^^^^^^^^^^^^^^^\nResource leak: 'reader' is not closed at this location\n----------\n", null, true, options);
    }

    public void test056throw2() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runTestsExpectingErrorsOnlyIn17(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo1() throws Exception {\n        FileReader reader = new FileReader(\"file\"); // propose t-w-r\n        try {\n            reader.read();\n            return;\n        } catch (Exception e) {\n            throw new Exception();\n        } finally {\n            reader.close();\n        }\n    }\n\n    void foo2() throws Exception {\n        FileReader reader = new FileReader(\"file\"); // propose t-w-r\n        try {\n            reader.read();\n            throw new Exception(); // should not warn here\n        } catch (Exception e) {\n            throw new Exception();\n        } finally {\n            reader.close();\n        }\n    }\n\n    void foo3() throws Exception {\n        FileReader reader = new FileReader(\"file\"); // propose t-w-r\n        try {\n            reader.read();\n            throw new Exception();\n        } finally {\n            reader.close();\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tFileReader reader = new FileReader(\"file\"); // propose t-w-r\n\t           ^^^^^^\nResource 'reader' should be managed by try-with-resource\n----------\n2. ERROR in X.java (at line 16)\n\tFileReader reader = new FileReader(\"file\"); // propose t-w-r\n\t           ^^^^^^\nResource 'reader' should be managed by try-with-resource\n----------\n3. ERROR in X.java (at line 28)\n\tFileReader reader = new FileReader(\"file\"); // propose t-w-r\n\t           ^^^^^^\nResource 'reader' should be managed by try-with-resource\n----------\n", options);
    }

    public void test056throw3() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runTestsExpectingErrorsOnlyIn17(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo2x() throws Exception {\n        FileReader reader = new FileReader(\"file\"); // propose t-w-r\n        try {\n            reader.read();\n            throw new Exception(); // should not warn here\n        } catch (Exception e) {\n            throw new Exception();\n        } finally {\n            if (reader != null)\n                 try {\n                     reader.close();\n                 } catch (java.io.IOException io) {}\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tFileReader reader = new FileReader(\"file\"); // propose t-w-r\n\t           ^^^^^^\nResource 'reader' should be managed by try-with-resource\n----------\n", options);
    }

    public void test056throw4() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo2x(boolean b) throws Exception {\n        FileReader reader = new FileReader(\"file\");\n        try {\n            reader.read();\n            throw new Exception(); // should warn here\n        } catch (Exception e) {\n            throw new Exception(); // should warn here\n        } finally {\n            if (reader != null && b)\n                 try {\n                     reader.close();\n                 } catch (java.io.IOException io) {}\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tthrow new Exception(); // should warn here\n\t^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'reader' may not be closed at this location\n----------\n2. ERROR in X.java (at line 9)\n\tthrow new Exception(); // should warn here\n\t^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'reader' may not be closed at this location\n----------\n", null, true, options);
    }

    public void test056throw5() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.deadCode", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.FileReader;\npublic class X {\n    void foo2x() throws Exception {\n        FileReader reader = new FileReader(\"file\");\n        try {\n            reader.read();\n            throw new Exception(); // should warn 'may not' here\n        } catch (Exception e) {\n            throw new Exception(); // should warn 'may not' here\n        } finally {\n            doClose(reader);\n        }\n    }\n    void doClose(FileReader r) { try { r.close(); } catch (java.io.IOException ex) {}}\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tthrow new Exception(); // should warn 'may not' here\n\t^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'reader' may not be closed at this location\n----------\n2. ERROR in X.java (at line 9)\n\tthrow new Exception(); // should warn 'may not' here\n\t^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'reader' may not be closed at this location\n----------\n", null, true, options);
    }

    public void test061a() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.BufferedInputStream;\nimport java.io.FileInputStream;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileInputStream fileStream  = new FileInputStream(file);\n        BufferedInputStream bis = new BufferedInputStream(fileStream);\n        BufferedInputStream doubleWrap = new BufferedInputStream(bis);\n        System.out.println(bis.available());\n        fileStream.close();\n    }\n    void inline() throws IOException {\n        File file = new File(\"somefile\");\n        FileInputStream fileStream;\n        BufferedInputStream bis = new BufferedInputStream(fileStream = new FileInputStream(file));\n        System.out.println(bis.available());\n        fileStream.close();\n    }\n    public static void main(String[] args) throws IOException {\n        try {\n            new X().foo();\n        } catch (IOException ex) {            System.out.println(\"Got IO Exception\");\n        }\n    }\n}\n"}, "Got IO Exception", null, true, null, options, null);
    }

    public void test061b() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.StringReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        StringReader string  = new StringReader(\"content\");\n        System.out.println(string.read());\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "99", null, true, null, options, null);
    }

    public void test061c() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.BufferedReader;\nimport java.io.StringReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        StringReader input = new StringReader(\"content\");\n        BufferedReader br = new BufferedReader(input);\n        BufferedReader doubleWrap = new BufferedReader(br);\n        System.out.println(br.read());\n    }\n    void inline() throws IOException {\n        BufferedReader br = new BufferedReader(new StringReader(\"content\"));\n        System.out.println(br.read());\n    }\n    public static void main(String[] args) throws IOException {\n        new X().foo();\n    }\n}\n"}, "99", null, true, null, options, null);
    }

    public void test061d() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "warning");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.BufferedInputStream;\nimport java.io.FileInputStream;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileInputStream fileStream  = new FileInputStream(file);\n        BufferedInputStream bis = new BufferedInputStream(fileStream);\n        BufferedInputStream doubleWrap = new BufferedInputStream(bis);\n        System.out.println(bis.available());\n    }\n    void inline() throws IOException {\n        File file = new File(\"somefile\");\n        BufferedInputStream bis2 = new BufferedInputStream(new FileInputStream(file));\n        System.out.println(bis2.available());\n    }\n    public static void main(String[] args) throws IOException {\n        try {\n            new X().foo();\n        } catch (IOException ex) {            System.out.println(\"Got IO Exception\");\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tBufferedInputStream doubleWrap = new BufferedInputStream(bis);\n\t                    ^^^^^^^^^^\nResource leak: 'doubleWrap' is never closed\n----------\n2. ERROR in X.java (at line 15)\n\tBufferedInputStream bis2 = new BufferedInputStream(new FileInputStream(file));\n\t                    ^^^^\nResource leak: 'bis2' is never closed\n----------\n", null, true, options);
    }

    public void test061e() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.BufferedInputStream;\nimport java.io.FileInputStream;\nimport java.io.IOException;\npublic class X {\n    FileInputStream fis;    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileInputStream fileStream  = new FileInputStream(file);\n        BufferedInputStream bis = new BufferedInputStream(fileStream);\n        BufferedInputStream doubleWrap = new BufferedInputStream(bis);\n        System.out.println(bis.available());\n        bis.close();\n    }\n    void inline() throws IOException {\n        File file = new File(\"somefile\");\n        BufferedInputStream bis2 = new BufferedInputStream(fis = new FileInputStream(file));\n        System.out.println(bis2.available());\n        bis2.close();\n        FileInputStream fileStream  = null;\n        BufferedInputStream bis3 = new BufferedInputStream(fileStream = new FileInputStream(file));\n        System.out.println(bis3.available());\n        bis3.close();\n    }\n    public static void main(String[] args) throws IOException {\n        try {\n            new X().foo();\n        } catch (IOException ex) {            System.out.println(\"Got IO Exception\");\n        }\n    }\n}\n"}, "Got IO Exception", null, true, null, options, null);
    }

    public void test061f() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        URL url = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.jdt.core.tests.compiler"), (IPath)new Path("META-INF/MANIFEST.MF"), null));
        this.runConformTest(new String[]{"X.java", "import java.io.InputStream;\nimport java.io.InputStreamReader;\nimport java.io.BufferedReader;\nimport java.io.IOException;\nimport java.net.URL;\npublic class X {\n    boolean loadURL(final URL url) throws IOException {\n        InputStream stream = null;\n        BufferedReader reader = null;\n        try {\n            stream = url.openStream();\n            reader = new BufferedReader(new InputStreamReader(stream));\n            System.out.println(reader.readLine());\n        } finally {\n            try {\n                if (reader != null)\n                    reader.close();\n            } catch (IOException x) {\n            }\n        }\n        return false; // 'stream' may not be closed at this location\n    }\n    public static void main(String[] args) throws IOException {\n        try {\n            new X().loadURL(new URL(\"" + url.toString() + "\"));\n" + "        } catch (IOException ex) {\n" + "            System.out.println(\"Got IO Exception\"+ex);\n" + "        }\n" + "    }\n" + "}\n"}, "Manifest-Version: 1.0", null, true, null, options, null);
    }

    public void test061f2() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.OutputStream;\nimport java.io.FileOutputStream;\nimport java.io.BufferedOutputStream;\nimport java.io.IOException;\npublic class X {\n    void zork() throws IOException {\n\t\ttry {\n\t\t\tOutputStream os = null;\n\t\t\ttry {\n\t\t\t\tos = new BufferedOutputStream(new FileOutputStream(\"somefile\"));\n\t\t\t\tString externalForm = \"externalPath\";\n\t\t\t} finally {\n\t\t\t\tif (os != null)\n\t\t\t\t\tos.close();\n\t\t\t}\n\t\t} catch (IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test061f3() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.FileNotFoundException;\nimport java.io.InputStream;\nimport java.io.BufferedInputStream;\npublic class X {\n    String loadProfile(File profileFile) {\n\t\ttry {\n\t\t\tInputStream stream = new BufferedInputStream(new FileInputStream(profileFile));\n\t\t\treturn loadProfile(stream);\n\t\t} catch (FileNotFoundException e) {\n\t\t\t//null\n\t\t}\n\t\treturn null;\n\t}\n\tprivate String loadProfile(InputStream stream) {\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\treturn loadProfile(stream);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'stream' may not be closed at this location\n----------\n", null, true, options);
    }

    public void test061g() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.BufferedInputStream;\nimport java.io.FileInputStream;\nimport java.io.IOException;\npublic class X {\n    void closeMiddle() throws IOException {\n        File file = new File(\"somefile\");\n        FileInputStream fileStream  = new FileInputStream(file);\n        BufferedInputStream bis = new BufferedInputStream(fileStream);\n        BufferedInputStream doubleWrap = new BufferedInputStream(bis);\n        System.out.println(bis.available());\n        bis.close();\n    }\n    void closeOuter() throws IOException {\n        File file2 = new File(\"somefile\");\n        FileInputStream fileStream2  = new FileInputStream(file2);\n        BufferedInputStream bis2 = new BufferedInputStream(fileStream2);\n        BufferedInputStream doubleWrap2 = new BufferedInputStream(bis2);\n        System.out.println(bis2.available());\n        doubleWrap2.close();\n    }\n    void neverClosed() throws IOException {\n        File file3 = new File(\"somefile\");\n        FileInputStream fileStream3  = new FileInputStream(file3);\n        BufferedInputStream bis3 = new BufferedInputStream(fileStream3);\n        BufferedInputStream doubleWrap3 = new BufferedInputStream(bis3);\n        System.out.println(doubleWrap3.available());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 26)\n\tBufferedInputStream doubleWrap3 = new BufferedInputStream(bis3);\n\t                    ^^^^^^^^^^^\nResource leak: 'doubleWrap3' is never closed\n----------\n", null, true, options);
    }

    public void test061h() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.BufferedInputStream;\nimport java.io.FileInputStream;\nimport java.io.IOException;\npublic class X {\n    void closeMiddle(boolean b) throws IOException {\n        File file = new File(\"somefile\");\n        FileInputStream fileStream  = new FileInputStream(file);\n        BufferedInputStream bis = new BufferedInputStream(fileStream);\n        BufferedInputStream doubleWrap = new BufferedInputStream(bis);\n        System.out.println(bis.available());\n        if (b)\n            bis.close();\n    }\n    void closeOuter(boolean b) throws IOException {\n        File file2 = new File(\"somefile\");\n        FileInputStream fileStream2  = new FileInputStream(file2);\n        BufferedInputStream dummy;\n        BufferedInputStream bis2 = (dummy = new BufferedInputStream(fileStream2));\n        BufferedInputStream doubleWrap2 = new BufferedInputStream(bis2);\n        System.out.println(bis2.available());\n        if (b)\n            doubleWrap2.close();\n    }\n    void potAndDef(boolean b) throws IOException {\n        File file3 = new File(\"somefile\");\n        FileInputStream fileStream3  = new FileInputStream(file3);\n        BufferedInputStream bis3 = new BufferedInputStream(fileStream3);\n        BufferedInputStream doubleWrap3 = new BufferedInputStream(bis3);\n        System.out.println(doubleWrap3.available());\n        if (b) bis3.close();\n        fileStream3.close();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tBufferedInputStream doubleWrap = new BufferedInputStream(bis);\n\t                    ^^^^^^^^^^\nPotential resource leak: 'doubleWrap' may not be closed\n----------\n2. ERROR in X.java (at line 20)\n\tBufferedInputStream doubleWrap2 = new BufferedInputStream(bis2);\n\t                    ^^^^^^^^^^^\nPotential resource leak: 'doubleWrap2' may not be closed\n----------\n", null, true, options);
    }

    public void test061i() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.InputStream;\nimport java.io.BufferedInputStream;\nimport java.io.FileInputStream;\nimport java.io.IOException;\npublic class X {\n    void closeMiddle() throws IOException {\n        File file = new File(\"somefile\");\n        InputStream stream  = new FileInputStream(file);\n        stream = new BufferedInputStream(stream);\n        InputStream middle;\n        stream = new BufferedInputStream(middle = stream);\n        System.out.println(stream.available());\n        middle.close();\n    }\n    void closeOuter() throws IOException {\n        File file = new File(\"somefile\");\n        InputStream stream2  = new FileInputStream(file);\n        stream2 = new BufferedInputStream(stream2);\n        stream2 = new BufferedInputStream(stream2);\n        System.out.println(stream2.available());\n        stream2.close();\n    }\n    void neverClosed() throws IOException {\n        File file = new File(\"somefile\");\n        InputStream stream3  = new FileInputStream(file);\n        stream3 = new BufferedInputStream(stream3);\n        stream3 = new BufferedInputStream(stream3);\n        System.out.println(stream3.available());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 26)\n\tInputStream stream3  = new FileInputStream(file);\n\t            ^^^^^^^\nResource leak: 'stream3' is never closed\n----------\n", null, true, options);
    }

    public void test061j() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.InputStream;\nimport java.io.BufferedInputStream;\nimport java.io.IOException;\npublic class X {\n    void foo(InputStream stream) throws IOException {\n        stream = new BufferedInputStream(stream);\n        System.out.println(stream.available());\n        stream.close();\n    }\n    void boo(InputStream stream2) throws IOException {\n        stream2 = new BufferedInputStream(stream2);\n        System.out.println(stream2.available());\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test061k() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.BufferedInputStream;\nimport java.io.IOException;\npublic class X {\n    BufferedInputStream getReader(File file) throws IOException {\n        FileInputStream stream = new FileInputStream(file);\n        return new BufferedInputStream(stream);\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test061l() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.BufferedInputStream;\nimport java.io.IOException;\npublic class X {\n    BufferedInputStream stream;\n    void foo(File file) throws IOException {\n        FileInputStream s = new FileInputStream(file);\n        stream = new BufferedInputStream(s);\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test061l2() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"xy/Leaks.java", "package xy;\n\nimport java.io.FileInputStream;\nimport java.io.IOException;\n\npublic class Leaks {\n    private FileInputStream fInput;\n\n    Leaks(String name) throws IOException {\n        FileInputStream fileInputStream= new FileInputStream(name);\n        fInput= fileInputStream;\n        Objects.hashCode(fInput);\n        \n        init(name);\n    }\n    \n    Leaks() throws IOException {\n        this(new FileInputStream(\"default\")); // potential problem\n    }\n    \n    Leaks(FileInputStream fis) throws IOException {\n        fInput= fis;\n    }\n    void init(String name) throws IOException {\n        FileInputStream fileInputStream= new FileInputStream(name);\n        fInput= fileInputStream;\n        Objects.hashCode(fInput);\n    }\n    \n    public void dispose() throws IOException {\n        fInput.close();\n    }\n}\nclass Objects {\n    static int hashCode(Object o) { return 13; }\n}\n"}, "----------\n1. ERROR in xy\\Leaks.java (at line 18)\n\tthis(new FileInputStream(\"default\")); // potential problem\n\t     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: '<unassigned Closeable value>' may not be closed\n----------\n", null, true, options);
    }

    public void test061l3() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"xy/Leaks.java", "package xy;\n\nimport java.io.FileInputStream;\nimport java.io.IOException;\n\npublic class Leaks {\n\n    Leaks(String name) throws IOException {\n        FileInputStream fileInputStream= new FileInputStream(name);\n        Objects.hashCode(fileInputStream);\n        \n        init(name);\n    }\n    void init(String name) throws IOException {\n        FileInputStream fileInputStream= new FileInputStream(name);\n        Objects.hashCode(fileInputStream);\n    }\n}\nclass Objects {\n    static int hashCode(Object o) { return 13; }\n}\n"}, "----------\n1. ERROR in xy\\Leaks.java (at line 9)\n\tFileInputStream fileInputStream= new FileInputStream(name);\n\t                ^^^^^^^^^^^^^^^\nPotential resource leak: 'fileInputStream' may not be closed\n----------\n2. ERROR in xy\\Leaks.java (at line 15)\n\tFileInputStream fileInputStream= new FileInputStream(name);\n\t                ^^^^^^^^^^^^^^^\nPotential resource leak: 'fileInputStream' may not be closed\n----------\n", null, true, options);
    }

    public void test061m() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.BufferedInputStream;\nimport java.io.InputStream;\nimport java.io.IOException;\npublic class X {\n    BufferedInputStream stream;\n    BufferedInputStream foo(File file) throws IOException {\n        FileInputStream s = new FileInputStream(file);\n        return check(new BufferedInputStream(s));\n    }\n    BufferedInputStream foo2(FileInputStream s, File file) throws IOException {\n        s = new FileInputStream(file);\n        return check(s);\n    }\n    BufferedInputStream foo3(InputStream s) throws IOException {\n        s = check(s);\n        return check(s);\n    }\n    BufferedInputStream check(InputStream s) { return null; }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\treturn check(new BufferedInputStream(s));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: '<unassigned Closeable value>' may not be closed at this location\n----------\n2. ERROR in X.java (at line 14)\n\treturn check(s);\n\t^^^^^^^^^^^^^^^^\nPotential resource leak: 's' may not be closed at this location\n----------\n3. ERROR in X.java (at line 18)\n\treturn check(s);\n\t^^^^^^^^^^^^^^^^\nPotential resource leak: 's' may not be closed at this location\n----------\n", null, true, options);
    }

    public void test061n() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.PrintWriter;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        PrintWriter writer = new PrintWriter(\"filename\");\n        writer.write(1);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tPrintWriter writer = new PrintWriter(\"filename\");\n\t            ^^^^^^\nResource leak: 'writer' is never closed\n----------\n", null, true, options);
    }

    public void test061o() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.BufferedInputStream;\nimport java.io.IOException;\npublic class X {\n    void foo(boolean bar) throws IOException {\n        File file = new File(\"somefil\");\n        FileInputStream fileStream  = new FileInputStream(file);\n        BufferedInputStream bis = new BufferedInputStream(fileStream);   \n        if (bar) {\n            BufferedInputStream doubleWrap = new BufferedInputStream(bis);\n            doubleWrap.close();\n        }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tBufferedInputStream bis = new BufferedInputStream(fileStream);   \n\t                    ^^^\nPotential resource leak: 'bis' may not be closed\n----------\n", null, true, options);
    }

    public void test061f4() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.FileNotFoundException;\nimport java.io.InputStream;\nimport java.io.BufferedInputStream;\npublic class X {\n    \tvoid foo(File location, String adviceFilePath) throws FileNotFoundException {\n\t\tInputStream stream = null;\n\t\tif (location.isDirectory()) {\n\t\t\tFile adviceFile = new File(location, adviceFilePath);\n\t\t\tstream = new BufferedInputStream(new FileInputStream(adviceFile));\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tstream = new BufferedInputStream(new FileInputStream(adviceFile));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'stream' may not be closed\n----------\n", null, true, options);
    }

    public void test061p() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.PrintWriter;\nimport java.io.BufferedWriter;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        PrintWriter writer = new PrintWriter(\"filename\");\n        try (BufferedWriter bw = new BufferedWriter(writer)) {\n            bw.write(1);\n        }\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void _test061q() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.PrintWriter;\nimport java.io.BufferedWriter;\nimport java.io.IOException;\npublic class X {\n    void foo(boolean b) throws IOException {\n        PrintWriter writer = new PrintWriter(\"filename\");\n        if (b)\n            try (BufferedWriter bw = new BufferedWriter(writer)) {\n                bw.write(1);\n            }\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tPrintWriter writer = new PrintWriter(\\\"filename\\\");\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'writer' may not be closed\n----------\n", null, true, options);
    }

    public void test061r() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.FileInputStream;\nimport java.io.File;\nimport java.io.BufferedInputStream;\nimport java.io.IOException;\npublic class X {\n    FileInputStream foo() throws IOException {\n        File file = new File(\"somefil\");\n        FileInputStream fileStream  = new FileInputStream(file);\n        BufferedInputStream bis = new BufferedInputStream(fileStream);   \n        return fileStream;\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test061s() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.FileInputStream;\nimport java.io.File;\nimport java.io.BufferedInputStream;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefil\");\n        FileInputStream fileStream  = new FileInputStream(file);\n        BufferedInputStream bis = new BufferedInputStream(fileStream);\n        bis = null;\n        fileStream.close();\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test062a() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileOutputStream;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        new FileOutputStream(new File(\"C:\\temp\\foo.txt\")).write(1);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tnew FileOutputStream(new File(\"C:\\temp\\foo.txt\")).write(1);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n", null, true, options);
    }

    public void test062b() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileOutputStream;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        new FileOutputStream(new File(\"C:\\temp\\foo.txt\")).close();\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test062c() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileOutputStream;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        writeIt(new FileOutputStream(new File(\"C:\\temp\\foo.txt\")));\n    }\n    void writeIt(FileOutputStream fos) throws IOException {\n        fos.write(1);\n        fos.close();\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\twriteIt(new FileOutputStream(new File(\"C:\\temp\\foo.txt\")));\n\t        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: '<unassigned Closeable value>' may not be closed\n----------\n", null, true, options);
    }

    public void test062d() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileOutputStream;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        new FileOutputStream(new File(\"C:\\temp\\foo.txt\"));\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tnew FileOutputStream(new File(\"C:\\temp\\foo.txt\"));\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n", null, true, options);
    }

    public void test063a() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.BufferedInputStream;\nimport java.io.IOException;\npublic class X {\n    void read(File file) throws IOException {\n        FileInputStream stream = new FileInputStream(file);\n        BufferedInputStream bis = new BufferedInputStream(stream); // never since reassigned\n        FileInputStream stream2 = new FileInputStream(file); // unsure since passed to method\n        bis = getReader(stream2); // unsure since obtained from method\n        bis.available();\n    }\n    BufferedInputStream getReader(FileInputStream stream) throws IOException {\n        return new BufferedInputStream(stream);\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 7)\n\tFileInputStream stream = new FileInputStream(file);\n\t                ^^^^^^\nResource leak: 'stream' is never closed\n----------\n2. ERROR in X.java (at line 9)\n\tFileInputStream stream2 = new FileInputStream(file); // unsure since passed to method\n\t                ^^^^^^^\nPotential resource leak: 'stream2' may not be closed\n----------\n3. ERROR in X.java (at line 10)\n\tbis = getReader(stream2); // unsure since obtained from method\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'bis' may not be closed\n----------\n", null, true, options);
    }

    public void test063b() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.FileInputStream;\nimport java.io.BufferedInputStream;\nimport java.io.IOException;\npublic class X {\n    FileInputStream stream;\n    void read() throws IOException {\n        FileInputStream s = this.stream;\n        BufferedInputStream bis = new BufferedInputStream(s); // don't complain since s is obtained from a field\n        bis.available();\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test063c() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.FileInputStream;\nimport java.io.BufferedInputStream;\nimport java.io.IOException;\npublic class X {\n    BufferedInputStream stream;\n    void read() throws IOException {\n        FileInputStream s = new FileInputStream(\"somefile\");\n        BufferedInputStream bis = new BufferedInputStream(s);\n        this.stream = bis;\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test063d() throws IOException {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.explicitlyClosedAutoCloseable", "error");
        this.runTestsExpectingErrorsOnlyIn17(new String[]{"X.java", "import java.io.FileInputStream;\nimport java.io.BufferedInputStream;\nimport java.io.InputStream;\nimport java.io.IOException;\npublic class X {\n    void foo( InputStream input) throws IOException {\n        FileInputStream input1  = (FileInputStream)input;\n        System.out.println(input1.read());\n        input.close();\n    }\n    void foo() throws IOException {\n        InputStream input = new FileInputStream(\"somefile\");\n        FileInputStream input1  = (FileInputStream)input;\n        System.out.println(input1.read());\n        input.close();\n    }\n    void foo3( InputStream input, InputStream input2) throws IOException {\n        FileInputStream input1  = (FileInputStream)input;\n        System.out.println(input1.read());\n        BufferedInputStream bis = new BufferedInputStream(input2);\n        System.out.println(bis.read());\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 12)\n\tInputStream input = new FileInputStream(\"somefile\");\n\t            ^^^^^\nResource 'input' should be managed by try-with-resource\n----------\n", options);
    }

    public void test063e() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.FileInputStream;\nimport java.io.IOException;\npublic class X {\n    FileInputStream input1;\n    public void foo() throws IOException {\n        FileInputStream input = input1;\n        input = new FileInputStream(\"adfafd\");\n        input.close();\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void testBug368709a() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\nimport java.util.zip.*;\npublic class X {\n  Object db, pack;\n  int objectOffset, headerLength, type, size;\n  public ObjectStream openStream() throws MissingObjectException, IOException {\n    WindowCursor wc = new WindowCursor(db);\n    InputStream in;\n    try\n      {\n        in = new PackInputStream(pack, (objectOffset + headerLength), wc);\n      }\n    catch (IOException packGone)\n      {\n        return wc.open(getObjectId(), type).openStream();\n      }\n    in = new BufferedInputStream(new InflaterInputStream(in, wc.inflater(), 8192), 8192);\n    return new ObjectStream.Filter(type, size, in);\n  }\n  String getObjectId() { return \"\"; }\n}\nclass WindowCursor {\n    WindowCursor(Object db) {}\n    ObjectStream open(String id, int type) { return null; }\n    Inflater inflater() { return null; }\n}\nclass MissingObjectException extends Exception {\n    public static final long serialVersionUID = 13L;\n    MissingObjectException() { super();}\n}\nclass PackInputStream extends InputStream {\n    PackInputStream(Object pack, int offset, WindowCursor wc) throws IOException {}\n    public int read() { return 0; }\n}\nclass ObjectStream extends InputStream {\n    static class Filter extends ObjectStream {\n        Filter(int type, int size, InputStream in) { }\n    }\n    ObjectStream openStream() { return this; }\n    public int read() { return 0; }\n}\n"}, "----------\n1. ERROR in X.java (at line 18)\n\treturn new ObjectStream.Filter(type, size, in);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'in' may not be closed at this location\n----------\n", null, true, options);
    }

    public void testBug368709b() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\nimport java.util.zip.*;\npublic class X {\n  void doit() throws IOException {\n    InputStream in = new FileInputStream(\"somefile\");\n    in = new BufferedInputStream(new InflaterInputStream(in, inflater(), 8192), 8192);\n    process(in);\n  }\n  Inflater inflater() { return null; }\n  void process(InputStream is) { }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tInputStream in = new FileInputStream(\"somefile\");\n\t            ^^\nPotential resource leak: 'in' may not be closed\n----------\n", null, true, options);
    }

    public void test064() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runNegativeTest(new String[]{"Test064.java", "import java.io.*;\npublic class Test064 {\n    void foo(File outfile) {\n        OutputStream out= System.out;\n        if (outfile != null) {\n            try {\n                out = new FileOutputStream(outfile);\n            } catch (java.io.IOException e) {\n                throw new RuntimeException(e);\n            }\n        }\n        setOutput(out);\n    }\n    private void setOutput(OutputStream out) { }\n}\n"}, "----------\n1. ERROR in Test064.java (at line 7)\n\tout = new FileOutputStream(outfile);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'out' may not be closed\n----------\n", null, true, options);
    }

    public void _test065() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTest(new String[]{"Test065.java", "import java.io.*;\nclass MyException extends Exception{}\npublic class Test065 {\n\tvoid foo(String fileName) throws IOException, MyException {\n\t\tFileReader       fileRead   = new FileReader(fileName);\n\t\tBufferedReader   bufRead    = new BufferedReader(fileRead);\n\t\tLineNumberReader lineReader = new LineNumberReader(bufRead);\n\t\ttry {\n\t\twhile (lineReader.readLine() != null) {\n\t\t\tbufRead.close();\n\t\t\tcallSome();  // only this can throw MyException\n\t\t}\n\t\t} catch (MyException e) {\n\t\t\tthrow e;  // Pot. leak reported here\n\t\t}\n\t\tbufRead.close(); \n\t}\n\tprivate void callSome() throws MyException\n\t{\n\t\t\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void test066() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTest(new String[]{"Test066.java", "import java.io.*;\nclass MyException extends Exception{}\npublic class Test066 {\n    void countFileLines(String fileName) throws IOException {\n\t\tFileReader       fileRead   = new FileReader(fileName);\n\t\tBufferedReader   bufRead    = new BufferedReader(fileRead);\n\t\tLineNumberReader lineReader = new LineNumberReader(bufRead);\n\t\twhile (lineReader.readLine() != null) {\n\t\t\tif (lineReader.markSupported())\n               throw new IOException();\n\t\t\tbufRead.close();\n\t\t}\n\t\tbufRead.close();\n\t}\n}\n"}, "----------\n1. ERROR in Test066.java (at line 10)\n\tthrow new IOException();\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'lineReader' may not be closed at this location\n----------\n", null, true, options);
    }

    public void test066b() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTest(new String[]{"Test066.java", "import java.io.*;\nclass MyException extends Exception{}\npublic class Test066 {\n    void countFileLines(String fileName) throws IOException {\n\t\tFileReader       fileRead   = new FileReader(fileName);\n\t\tBufferedReader   bufRead    = new BufferedReader(fileRead);\n\t\tLineNumberReader lineReader = new LineNumberReader(bufRead);\n\t\twhile (lineReader.readLine() != null) {\n\t\t\tif (lineReader.markSupported())\n               throw new IOException();\n\t\t\tlineReader.close();\n\t\t}\n\t\tlineReader.close();\n\t}\n}\n"}, "----------\n1. ERROR in Test066.java (at line 10)\n\tthrow new IOException();\n\t^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: 'lineReader' may not be closed at this location\n----------\n", null, true, options);
    }

    public void _test067() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTest(new String[]{"Test067.java", "import java.io.*;\npublic class Test067 {\n\tpublic void comment12() throws IOException {\n    \tLineNumberReader o = null;\n    \ttry {\n    \t\to = new LineNumberReader(null);    \t\t\n    \t} catch (NumberFormatException e) {    \t\t\n    \t}\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test067b() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTest(new String[]{"Test067.java", "import java.io.*;\npublic class Test067 {\n\tpublic void comment12b() throws IOException {\n\t\tLineNumberReader o = new LineNumberReader(null);\n    \ttry {\n    \t\to.close();\n    \t} catch (NumberFormatException e) {\n    \t}\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void test068() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTest(new String[]{"Test068.java", "import java.io.*;\npublic class Test068 {\n\tclass ProcessingStep extends OutputStream {\n\t\tpublic void write(int b) throws IOException {}\n\t\tpublic OutputStream getDestination() { return null; }\n\t}\n\tclass ArtifactOutputStream  extends OutputStream {\n\t\tpublic void write(int b) throws IOException {}\n\t}\tArtifactOutputStream comment13(OutputStream stream) {\n\t\tOutputStream current = stream;\n\t\twhile (current instanceof ProcessingStep)\n\t\t\tcurrent = ((ProcessingStep) current).getDestination();\n\t\tif (current instanceof ArtifactOutputStream)\n\t\t\treturn (ArtifactOutputStream) current;\n\t\treturn null;\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void test069() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTest(new String[]{"Test069.java", "import java.io.*;\nimport java.util.Collection;\npublic class Test069 {\n\tclass Profile {}\n\tclass CoreException extends Exception {}\n\tvoid writeProfilesToStream(Collection<Profile> p, OutputStream s, String enc) {}\n\tCoreException createException(IOException ioex, String message) { return new CoreException(); }\n\tpublic void comment16(Collection<Profile> profiles, File file, String encoding) throws CoreException {\n\t\tfinal OutputStream stream;\n\t\ttry {\n\t\t\tstream= new FileOutputStream(file);\n\t\t\ttry {\n\t\t\t\twriteProfilesToStream(profiles, stream, encoding);\n\t\t\t} finally {\n\t\t\t\ttry { stream.close(); } catch (IOException e) { /* ignore */ }\n\t\t\t}\n\t\t} catch (IOException e) {\n\t\t\tthrow createException(e, \"message\"); // should not shout here\n\t\t}\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void test070() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTest(new String[]{"Test070.java", "import java.io.*;\npublic class Test070 {\n    void storeInArray(String fileName) throws IOException {\n\t\tFileReader       fileRead   = new FileReader(fileName);\n\t\tcloseThemAll(new FileReader[] { fileRead });\n\t}\n   void closeThemAll(FileReader[] readers) { }\n}\n"}, "----------\n1. ERROR in Test070.java (at line 4)\n\tFileReader       fileRead   = new FileReader(fileName);\n\t                 ^^^^^^^^\nPotential resource leak: 'fileRead' may not be closed\n----------\n", null, true, options);
    }

    public void test071() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTest(new String[]{"Test071.java", "import java.io.*;\npublic class Test071 {\n    class ReaderHolder {\n\t\tFileReader reader;\n\t}\n\tprivate FileReader getReader() {\n\t\treturn null;\n\t}\n\tvoid invokeCompiler(ReaderHolder readerHolder, boolean flag) throws FileNotFoundException {\n\t\tFileReader reader = readerHolder.reader;\n\t\tif (reader == null)\n\t\t\treader = getReader();\n\t\ttry {\n\t\t\treturn;\n\t\t} finally {\n\t\t\ttry {\n\t\t\t\tif (flag)\n\t\t\t\t\treader.close();\n\t\t\t} catch (IOException e) {\n\t\t\t\t// nop\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Test071.java (at line 14)\n\treturn;\n\t^^^^^^^\nPotential resource leak: 'reader' may not be closed at this location\n----------\n", null, true, options);
    }

    public void _test071b() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTest(new String[]{"Test071b.java", "import java.io.*;\npublic class Test071b {\n   private FileReader getReader() {\n\t\treturn null;\n\t}\n\tvoid invokeCompiler(boolean flag) throws FileNotFoundException {\n\t\tFileReader reader = null;\n\t\tif (flag)\n\t\t\treader = new FileReader(\"file\");\n\t\tif (reader == null)\n\t\t\treader = getReader();\n\t\ttry {\n\t\t\treturn;\n\t\t} finally {\n\t\t\ttry {\n\t\t\t\tif (flag)\n\t\t\t\t\treader.close();\n\t\t\t} catch (IOException e) {\n\t\t\t\t// nop\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Test071b.java (at line 13)\n\treturn;\n\t^^^^^^^\nPotential resource leak: 'reader' may not be closed at this location\n----------\n", null, true, options);
    }

    public void test072() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTest(new String[]{"Test072.java", "import java.io.*;\npublic class Test072 {\n   void readState(File file) {\n\t\tDataInputStream in = null;\n\t\ttry {\n\t\t\tin= new DataInputStream(new BufferedInputStream(new FileInputStream(file)));\n\t\t\tint sizeOfFlags = in.readInt();\n\t\t\tfor (int i = 0; i < sizeOfFlags; ++i) {\n\t\t\t\tString childPath = in.readUTF();\n\t\t\t\tif (childPath.length() == 0)\n\t\t\t\t\tthrow new IOException();\n\t\t\t}\n\t\t}\n\t\tcatch (IOException ioe) { /* nop */ }\n\t\tfinally {\n\t\t\tif (in != null) {\n\t\t\t\ttry {in.close();} catch (IOException ioe) {}\n\t\t\t}\n\t\t}\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void test073() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runConformTest(new String[]{"Test073.java", "import java.io.*;\npublic class Test073 {\n   String getEncoding(Object reader) {\n\t\tif (reader instanceof FileReader) {\n\t\t\tfinal FileReader fr = (FileReader) reader;\n\t\t\treturn fr.getEncoding();\n\t\t}\n\t\treturn null;\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void test074() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.runNegativeTest(new String[]{"Test074.java", "import java.io.*;\npublic class Test074 {\n   void foo() throws FileNotFoundException {\n\t\tFileOutputStream out = null;\n\t\ttry {\n\t\t\tout = new FileOutputStream(\"outfile\");\n\t\t} finally {\n\t\t\ttry {\n\t\t\t\tout.flush();\n\t\t\t\tout.close();\n\t\t\t} catch (IOException e) {\n\t\t\t\te.printStackTrace();\n\t\t\t}\n\t\t\tout = null;\n\t\t}\n\t}\n}\n"}, "----------\n1. ERROR in Test074.java (at line 14)\n\tout = null;\n\t^^^^^^^^^^\nPotential resource leak: 'out' may not be closed at this location\n----------\n", null, true, options);
    }

    public void test075() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.File;\nimport java.io.FileReader;\nimport java.io.IOException;\npublic class X {\n    void foo() throws IOException {\n        File file = new File(\"somefile\");\n        FileReader fileReader = new FileReader(file);\n    }\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tFileReader fileReader = new FileReader(file);\n\t           ^^^^^^^^^^\nResource leak: 'fileReader' is never closed\n----------\n");
    }

    public void testBug385415() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n    void foo() throws FileNotFoundException {\n        FileReader fileReader = new FileReader(\"somefile\");\n        try {\n            fileReader.close();\n        } catch (Exception e) {\n            e.printStackTrace();\n            return;\n        }\n    }\n}\n"}, "", null, true, null, options, null);
    }

    public void testBug361073c7() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n  public void test() {\n    BufferedReader br = null;\n    try {\n        br = new BufferedReader(new FileReader(\"blah\"));\n        String line = null;\n        while ( (line = br.readLine()) != null ) {\n            if ( line.startsWith(\"error\") )\n                throw new Exception(\"error\"); //Resource leak: 'br' is not closed at this location\n        }\n    } catch (Throwable t) {\n        t.printStackTrace();\n    } finally {\n        if ( br != null ) {\n            try { br.close(); }\n            catch (Throwable e) { br = null; }\n        }\n    }\n  }\n}"}, "", null, true, null, options, null);
    }

    public void _testBug386534() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"Bug.java", "import java.io.FileNotFoundException;\nimport java.io.IOException;\nimport java.io.OutputStream;\n\npublic class Bug {\n\tprivate static final String DETAILS_FILE_NAME = null;\n\tprivate static final String LOG_TAG = null;\n\tprivate static Context sContext;\n\tstatic void saveDetails(byte[] detailsData) {\n\t\tOutputStream os = null;\n\t\ttry {\n\t\t\tos = sContext.openFileOutput(DETAILS_FILE_NAME,\n\t\t\t\t\tContext.MODE_PRIVATE);\n\t\t\tos.write(detailsData);\n\t\t} catch (IOException e) {\n\t\t\tLog.w(LOG_TAG, \"Unable to save details\", e);\n\t\t} finally {\n\t\t\tif (os != null) {\n\t\t\t\ttry {\n\t\t\t\t\tos.close();\n\t\t\t\t} catch (IOException ignored) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tstatic class Context {\n\t\tpublic static final String MODE_PRIVATE = null;\n\t\tpublic OutputStream openFileOutput(String detailsFileName,\n\t\t\t\tString modePrivate) throws FileNotFoundException{\n\t\t\treturn null;\n\t\t}\n\t}\n\tstatic class Log {\n\t\tpublic static void w(String logTag, String string, IOException e) {\n\t\t}\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void testBug388996() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"Bug.java", "import java.io.*;\npublic class Bug {\n\tpublic void processRequest(ResponseContext responseContext) throws IOException {\n\t\tOutputStream bao = null;\n\n\t\ttry {\n\t\t\tHttpServletResponse response = responseContext.getResponse();\n\n\t\t\tbao = response.getOutputStream(); // <<<<\n\t\t} finally {\n\t\t\tif(bao != null) {\n\t\t\t\tbao.close();\n\t\t\t}\n\t\t}\n\t}}\nclass ResponseContext {\n\tpublic HttpServletResponse getResponse() {\n\t\treturn null;\n\t}\n}\nclass HttpServletResponse {\n\tpublic OutputStream getOutputStream() {\n\t\treturn null;\n\t}\n}"}, "", null, true, null, options, null);
    }

    public void testBug386534() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        this.runConformTest(new String[]{"Bug386534.java", "import java.io.FileNotFoundException;\nimport java.io.IOException;\nimport java.io.OutputStream;\n\npublic class Bug386534 {\n\tprivate static final String DETAILS_FILE_NAME = null;\n\tprivate static final String LOG_TAG = null;\n\tprivate static Context sContext;\n\tstatic void saveDetails(byte[] detailsData) {\n\t\tOutputStream os = null;\n\t\ttry {\n\t\t\tos = sContext.openFileOutput(DETAILS_FILE_NAME,\n\t\t\t\t\tContext.MODE_PRIVATE);\n\t\t\tos.write(detailsData);\n\t\t} catch (IOException e) {\n\t\t\tLog.w(LOG_TAG, \"Unable to save details\", e);\n\t\t} finally {\n\t\t\tif (os != null) {\n\t\t\t\ttry {\n\t\t\t\t\tos.close();\n\t\t\t\t} catch (IOException ignored) {\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tstatic class Context {\n\t\tpublic static final String MODE_PRIVATE = null;\n\t\tpublic OutputStream openFileOutput(String detailsFileName,\n\t\t\t\tString modePrivate) throws FileNotFoundException{\n\t\t\treturn null;\n\t\t}\n\t}\n\tstatic class Log {\n\t\tpublic static void w(String logTag, String string, IOException e) {\n\t\t}\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void testBug394768() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"Bug394768.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.InputStream;\n\npublic class Bug394768 {\n\tpublic void readFile(String path) throws Exception {\n\t\tInputStream stream = null;\n\t\tFile file = new File(path);\n\n\t\tif (file.exists())\n\t\t\tstream = new FileInputStream(path);\n\t\telse\n\t\t\tstream = getClass().getClassLoader().getResourceAsStream(path);\n\n\t\tif (stream == null)\n\t\t\treturn;\n\n\t\ttry {\n\t\t\t// Use the opened stream here\n\t\t\tstream.read();\n\t\t} finally {\n\t\t\tstream.close();\n\t\t}\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void testBug394768_1() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"Bug394768.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.InputStream;\n\npublic class Bug394768 {\n\tpublic void readFile(String path) throws Exception {\n\t\tInputStream stream = null;\n\t\tFile file = new File(path);\n\n\t\tif (file.exists()) {\n\t\t\tstream = new FileInputStream(path);\n\t\t} else {\n\t\t\tstream = getClass().getClassLoader().getResourceAsStream(path);           stream.close();\n           stream = null;\n       }\n\n\t\tif (stream == null)\n\t\t\treturn;\n\n\t\ttry {\n\t\t\t// Use the opened stream here\n\t\t\tstream.read();\n\t\t} finally {\n\t\t\tstream.close();\n\t\t}\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void testBug381445_1() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{GUAVA_CLOSEABLES_JAVA, GUAVA_CLOSEABLES_CONTENT, "org/apache/commons/io/IOUtils.java", "package org.apache.commons.io;\npublic class IOUtils {\n    public static void closeQuietly(java.io.Closeable closeable) {}\n}\n", "Bug381445.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.InputStream;\n\npublic class Bug381445 {\n\tpublic void readFile(String path) throws Exception {\n\t\tFile file = new File(path);\n\t\tInputStream stream1 = new FileInputStream(path);\n\t\tInputStream stream2 = new FileInputStream(path);\n\t\tInputStream stream3 = new FileInputStream(path);\n\t\tInputStream stream4 = new FileInputStream(path);\n\t\ttry {\n\t\t\t// Use the opened streams here\n\t\t\tstream1.read();\n\t\t\tstream2.read();\n\t\t\tstream3.read();\n\t\t\tstream4.read();\n\t\t} finally {\n\t\t\tcom.google.common.io.Closeables.closeQuietly(stream1);\n\t\t\tcom.google.common.io.Closeables.close(stream2, false);\n\t\t\torg.apache.commons.io.IOUtils.closeQuietly(stream3);\n\t\t\tCloseables.closeQuietly(stream4);\n\t\t}\n\t}\n}\nclass Closeables {\n\tpublic static void closeQuietly(java.io.Closeable closeable) {}\n}\n"}, "----------\n1. ERROR in Bug381445.java (at line 11)\n\tInputStream stream4 = new FileInputStream(path);\n\t            ^^^^^^^\nPotential resource leak: 'stream4' may not be closed\n----------\n", null, true, options, null);
    }

    public void testBug381445_1b() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{APACHE_DBUTILS_JAVA, APACHE_DBUTILS_CONTENT, "Bug381445.java", "import java.sql.*;\n\npublic class Bug381445 {\n\tpublic void performQuery1(String url, String q1, String q2) throws Exception {\n\t\tConnection conn = DriverManager.getConnection(url);\n\t\tStatement stat = conn.createStatement();\n\t\tResultSet rset = stat.executeQuery(q1);\n\t\tResultSet rset2 = stat.executeQuery(q2);\n\t\ttry {\n\t\t\t// empty\n\t\t} finally {\n\t\t\torg.apache.commons.dbutils.DbUtils.closeQuietly(conn);\n\t\t\torg.apache.commons.dbutils.DbUtils.close(stat);\n\t\t\torg.apache.commons.dbutils.DbUtils.closeQuietly(rset);\n\t\t\tCloseables.closeQuietly(rset2);\n\t\t}\n\t}\n\tpublic void performQuery2(String url, String q1, String q2) throws Exception {\n\t\tConnection conn = DriverManager.getConnection(url);\n\t\tStatement stat = conn.createStatement();\n\t\tResultSet rset = stat.executeQuery(q1);\n\t\ttry {\n\t\t\t// empty\n\t\t} finally {\n\t\t\torg.apache.commons.dbutils.DbUtils.closeQuietly(conn, stat, rset);\n\t\t}\n\t}\n}\nclass Closeables {\n\tpublic static void closeQuietly(java.lang.AutoCloseable closeable) {}\n}\n"}, "----------\n1. ERROR in Bug381445.java (at line 8)\n\tResultSet rset2 = stat.executeQuery(q2);\n\t          ^^^^^\nPotential resource leak: 'rset2' may not be closed\n----------\n", null, true, options, null);
    }

    public void testBug381445_2() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{GUAVA_CLOSEABLES_JAVA, GUAVA_CLOSEABLES_CONTENT, "Bug381445.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.InputStream;\nimport com.google.common.io.Closeables;\n\npublic class Bug381445 {\n\tpublic void readFile(String path) throws Exception {\n\t\tFile file = new File(path);\n\t\tInputStream stream1 = new FileInputStream(path);\n\t\tInputStream stream2 = new FileInputStream(path);\n\t\tInputStream stream3 = new FileInputStream(path);\n\t\ttry {\n\t\t\t// Use the opened streams here\n\t\t\tstream1.read();\n\t\t\tCloseables.closeQuietly(stream1);\n\t\t\tstream2.read();\n\t\t\tif (path.length() > 2)\n\t\t\t\tCloseables.closeQuietly(stream2);\n\t\t\tstream3.read();\n\t\t} finally {\n\t\t}\n\t\tCloseables.closeQuietly(stream3);\n\t}\n}\n"}, "----------\n1. ERROR in Bug381445.java (at line 10)\n\tInputStream stream2 = new FileInputStream(path);\n\t            ^^^^^^^\nPotential resource leak: 'stream2' may not be closed\n----------\n", null, true, options, null);
    }

    public void testBug381445_3() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{GUAVA_CLOSEABLES_JAVA, GUAVA_CLOSEABLES_CONTENT, "Bug381445a.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.InputStream;\nimport static com.google.common.io.Closeables.closeQuietly;\n\npublic class Bug381445a {\n\tpublic void readFile(String path) throws Exception {\n\t\tFile file = new File(path);\n\t\tInputStream stream = new FileInputStream(path);\n\t\ttry {\n\t\t\t// Use the opened stream here\n\t\t\tstream.read();\n\t\t} finally {\n\t\t\tcloseQuietly(stream);\n\t\t}\n\t}\n}\n", "Bug381445b.java", "import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.InputStream;\nimport com.google.common.io.Closeables;\n\npublic class Bug381445b extends Closeables {\n\tpublic void readFile(String path) throws Exception {\n\t\tFile file = new File(path);\n\t\tInputStream stream = new FileInputStream(path);\n\t\ttry {\n\t\t\t// Use the opened streams here\n\t\t\tstream.read();\n\t\t} finally {\n\t\t\tcloseQuietly(stream);\n\t\t}\n\t}\n}\n"}, "", null, true, null, options, null);
    }

    public void testBug395977() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"WriterTest.java", "import java.io.*;\n\npublic class WriterTest implements Runnable\n{\n   private BufferedWriter m_Writer;\n   \n   public void run()\n   {\n      try\n      {\n         initializeWriter();\n         \n         m_Writer.write(\"string\");\n         m_Writer.newLine();\n         \n         closeWriter();\n      }\n      catch (IOException ioe)\n      {\n         ioe.printStackTrace();\n      }\n   }\n   \n   private void initializeWriter()\n      throws UnsupportedEncodingException, FileNotFoundException\n   {\n      m_Writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(\"file\"), \"UTF-8\"))\n      {\n         /**\n          * Writes an LF character on all platforms, to avoid constantly flipping the line terminator style.\n          */\n         public void newLine() throws IOException\n         {\n            write('\\n');\n         }\n      };\n   }\n   \n   private void closeWriter()\n      throws IOException\n   {\n      m_Writer.close();\n   }\n}"}, "", null, true, null, options, null);
    }

    public void testBug395977_1() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"WriterTest.java", "import java.io.*;\n\npublic class WriterTest implements Runnable\n{\n   private BufferedWriter m_Writer;\n   \n   public void run()\n   {\n      try\n      {\n         initializeWriter();\n         \n         m_Writer.write(\"string\");\n         m_Writer.newLine();\n         \n         closeWriter();\n      }\n      catch (IOException ioe)\n      {\n         ioe.printStackTrace();\n      }\n   }\n   \n   private void initializeWriter()\n      throws UnsupportedEncodingException, FileNotFoundException\n   {\n      class MyBufferedWriter extends BufferedWriter\n      {\n         MyBufferedWriter(OutputStreamWriter writer) { super(writer); }\n         /**\n          * Writes an LF character on all platforms, to avoid constantly flipping the line terminator style.\n          */\n         public void newLine() throws IOException\n         {\n            write('\\n');\n         }\n      };      m_Writer = new MyBufferedWriter(new OutputStreamWriter(new FileOutputStream(\"file\"), \"UTF-8\"));\n   }\n   \n   private void closeWriter()\n      throws IOException\n   {\n      m_Writer.close();\n   }\n}"}, "----------\n1. ERROR in WriterTest.java (at line 37)\n\t};      m_Writer = new MyBufferedWriter(new OutputStreamWriter(new FileOutputStream(\"file\"), \"UTF-8\"));\n\t                                        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: '<unassigned Closeable value>' may not be closed\n----------\n", null, true, options);
    }

    public void testBug395977_2() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"WriterTest.java", "import java.io.*;\n\npublic class WriterTest implements Runnable\n{\n   private BufferedWriter m_Writer;\n   \n   public void run()\n   {\n      try\n      {\n         initializeWriter();\n         \n         m_Writer.write(\"string\");\n         m_Writer.newLine();\n         \n         closeWriter();\n      }\n      catch (IOException ioe)\n      {\n         ioe.printStackTrace();\n      }\n   }\n   \n   private void initializeWriter()\n      throws UnsupportedEncodingException, FileNotFoundException\n   {\n      m_Writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(\"file\"), \"UTF-8\"))\n      {\n         public void close() { /* nop */}\n      };\n   }\n   \n   private void closeWriter()\n      throws IOException\n   {\n      m_Writer.close();\n   }\n}"}, "----------\n1. ERROR in WriterTest.java (at line 27)\n\tm_Writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(\"file\"), \"UTF-8\"))\n\t                              ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: '<unassigned Closeable value>' may not be closed\n----------\n", null, true, options);
    }

    public void testBug376053() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"Try.java", "package xy;\n\nimport java.io.FileNotFoundException;\nimport java.io.PrintStream;\n\npublic class Try {\n    public static void main(String[] args) throws FileNotFoundException {\n        System.setOut(new PrintStream(\"log.txt\"));\n        \n        if (Math.random() > .5) {\n            return;\n        }\n        System.out.println(\"Hello World\");\n        return;\n    }\n}"}, "----------\n1. ERROR in Try.java (at line 11)\n\treturn;\n\t^^^^^^^\nPotential resource leak: '<unassigned Closeable value from line 8>' may not be closed at this location\n----------\n2. ERROR in Try.java (at line 14)\n\treturn;\n\t^^^^^^^\nPotential resource leak: '<unassigned Closeable value from line 8>' may not be closed at this location\n----------\n", null, true, options);
    }

    public void testBug411098_test1() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"A.java", "import java.io.*;\n\nclass A {\n  void a(boolean b) throws Exception {\n    try(FileInputStream in = b ? new FileInputStream(\"a\") : null){}\n  }\n}"}, options);
    }

    public void testBug411098_test2() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"A.java", "import java.io.*;\nclass A {\n  void a(boolean b) throws Exception {\n    try(FileInputStream in = create(new FileInputStream(\"a\"))){}\n  }\n  FileInputStream create(FileInputStream ignored) throws IOException {\n    return new FileInputStream(\"b\"); \n  }\n}"}, "----------\n1. ERROR in A.java (at line 4)\n\ttry(FileInputStream in = create(new FileInputStream(\"a\"))){}\n\t                                ^^^^^^^^^^^^^^^^^^^^^^^^\nPotential resource leak: '<unassigned Closeable value>' may not be closed\n----------\n", null, true, options);
    }

    public void testBug411098_test3() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"A.java", "import java.io.*;\nclass A {\n\tvoid m() throws IOException {\n\t\ttry (FileInputStream a = new FileInputStream(\"A\") {{\n\t\t\t\tFileInputStream b = new FileInputStream(\"B\");\n\t\t\t\tb.hashCode();\n\t\t\t}}){\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in A.java (at line 5)\n\tFileInputStream b = new FileInputStream(\"B\");\n\t                ^\nResource leak: 'b' is never closed\n----------\n", null, true, options);
    }

    public void testBug411098_test4() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"A.java", "import java.io.FileInputStream;\nclass A {\n\tvoid testB(boolean b) throws Exception {\n\t\tFileInputStream in = null;\n\t\ttry {\n\t\t\tin = b ? new FileInputStream(\"a\") : null;\n\t\t} finally {\n\t\tin.close();\n\t\t}\n\t}\n}"}, options);
    }

    public void testBug411098_test5() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"A.java", "import java.io.FileInputStream;\nclass A {\n  void testA(boolean b) throws Exception {\n    FileInputStream in = b ? new FileInputStream(\"a\") : null;\n    in.close();\n  }\n}"}, options);
    }

    public void testBug411098_test6() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"A.java", "import java.io.FileInputStream;\nclass A {\n  void testA(boolean b) throws Exception {\n    FileInputStream in = b ? new FileInputStream(\"a\") : new FileInputStream(\"b\");\n    in.close();\n  }\n}"}, options);
    }

    public void testBug411098_test7() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"A.java", "import java.io.*;\nclass A {\n  void testA(boolean b) throws Exception {\n    BufferedReader in = b ? new BufferedReader(new FileReader(\"a\")) : new BufferedReader(new FileReader(\"b\"));\n    in.close();\n  }\n}"}, options);
    }

    public void testBug411098_comment19() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"A.java", "import java.io.PrintWriter;\npublic class A {\n\tPrintWriter fWriter;\n\tvoid bug(boolean useField) {\n\t\tPrintWriter bug= useField ? fWriter : null;\n\t\tSystem.out.println(bug);\n\t}\n}"}, "----------\n1. ERROR in A.java (at line 5)\n\tPrintWriter bug= useField ? fWriter : null;\n\t            ^^^\nPotential resource leak: 'bug' may not be closed\n----------\n", null, true, options);
    }

    public void testStream1() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"A.java", "import java.util.*;\nimport java.util.stream.Stream;\nclass A {\n  long test(List<String> ss) {\n    Stream<String> stream = ss.stream();\n    return stream.count();\n  }\n}"}, options);
    }

    public void testStream2() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"A.java", "import java.util.stream.Stream;\nimport java.nio.file.*;\nclass A {\n  long test(Path start, FileVisitOption... options) throws java.io.IOException {\n    Stream<Path> stream = Files.walk(start, options);\n    return stream.count();\n  }\n}"}, "----------\n1. ERROR in A.java (at line 5)\n\tStream<Path> stream = Files.walk(start, options);\n\t             ^^^^^^\nResource leak: 'stream' is never closed\n----------\n", null, true, options);
    }

    public void testStream3() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"A.java", "import java.util.stream.Stream;\nimport java.nio.file.*;\nclass A {\n  void test(Path file) throws java.io.IOException {\n    Stream<String> lines = Files.lines(file);\n    if (lines.count() > 0)    \tlines.close();\n  }\n}"}, "----------\n1. ERROR in A.java (at line 5)\n\tStream<String> lines = Files.lines(file);\n\t               ^^^^^\nPotential resource leak: 'lines' may not be closed\n----------\n", null, true, options);
    }

    public void testStream4() {
        if (this.complianceLevel < 0x340000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"A.java", "import java.util.stream.Stream;\nimport java.nio.file.*;\nclass A {\n  void test(Path dir) throws java.io.IOException {\n    try (Stream<Path> list = Files.list(dir)) {\n    \tlist.forEach(child -> System.out.println(child));\n    }\n  }\n}"}, options);
    }

    public void testBug415790_ex2() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n    public void example2() throws IOException {\n        for (final File file : new File[] { new File(\"/\") }) {\n            BufferedReader reader = null;\n            try {\n                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));\n            }\n            finally {\n                try {\n                    reader.close();\n                }\n                catch (IOException e) {\n                }\n            }\n        }\n    }\n}\n"}, options);
    }

    public void testBug415790_ex4() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n    public void example2(File[] files) throws IOException {\n        for (int i = 0; i < files.length; i++) {\n            File file = files[i];\n            BufferedReader reader = null;\n            try {\n                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));\n            }\n            finally {\n                try {\n                    reader.close();\n                }\n                catch (IOException e) {\n                }\n            }\n        }\n    }\n}\n"}, options);
    }

    public void testBug371614_comment0() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"C.java", "import java.io.FileInputStream;\nimport java.io.IOException;\nimport java.io.InputStream;\n\npublic class C {\n\tpublic static void main(String[] args) {\n\t\tFileInputStream fileInputStream= null;\n\t\ttry {\n\t\t\tfileInputStream = new FileInputStream(args[0]);\n\t\t\twhile (true) {\n\t\t\t\tif (fileInputStream.read() == -1) {\n\t\t\t\t\tSystem.out.println(\"done\");\n// Resource leak: 'fileInputStream' is not closed at this location\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t}\n\t\t} catch (IOException e) {\n\t\t\te.printStackTrace();\n\t\t\treturn;\n\t\t} finally {\n\t\t\tcloseStream(fileInputStream);\n\t\t}\n\t}\n\t\n\tprivate static void closeStream(InputStream stream) {\n\t\tif (stream != null) {\n\t\t\ttry {\n\t\t\t\tstream.close();\n\t\t\t} catch (IOException e) {\n\t\t\t\te.printStackTrace();\n\t\t\t}\n\t\t}\n\t}\n}\n\n"}, "----------\n1. ERROR in C.java (at line 14)\n\treturn;\n\t^^^^^^^\nPotential resource leak: 'fileInputStream' may not be closed at this location\n----------\n", null, true, options);
    }

    public void testBug371614_comment2() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"ResourceLeak.java", "import java.io.FileInputStream;\nimport java.io.IOException;\nimport java.io.InputStreamReader;\nimport java.io.Reader;\n\npublic class ResourceLeak {\n\n  boolean check(final Reader r) throws IOException {\n    final int i = r.read();\n    return (i != -1);\n  }\n\n  public void test1() throws IOException {\n    try (Reader r = new InputStreamReader(System.in);) {\n      while (check(r)) {\n        if (check(r))\n          throw new IOException(\"fail\");\n        if (!check(r))\n          throw new IOException(\"fail\");\n      }\n    }\n  }\n\n  public void test2() throws IOException {\n    try (Reader r = new InputStreamReader(new FileInputStream(\"test.txt\"));) {\n      while (check(r)) {\n        if (check(r))\n          throw new IOException(\"fail\");\n        if (!check(r))\n          throw new IOException(\"fail\");\n      }\n    }\n  }\n}\n"}, options);
    }

    public void testBug371614_comment8() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.*;\nimport java.net.*;\npublic class X {\n\tSocket fSocket;\n\tvoid test() {\n    try (InputStreamReader socketIn = new InputStreamReader(fSocket.getInputStream())) {\n         while (true) {\n             if (socketIn.read(new char[1024]) < 0)\n                 throw new IOException(\"Error\");\n         }           \n     } catch (IOException e) {\n     }\t}\n}\n"}, options);
    }

    public void testBug462371_orig() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"X.java", "import java.io.*;\ninterface IFile {\n\tInputStream getContents();\n\tboolean exists();\n}\npublic class X {\n\tpublic static String getAnnotatedSignature(String typeName, IFile file, String selector, String originalSignature) {\n\t\tif (file.exists()) {\n\t\t\ttry (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()))) {\n\t\t\t\treader.readLine();\n\t\t\t\twhile (true) {\n\t\t\t\t\tString line = reader.readLine(); \n\t\t\t\t\t// selector:\n\t\t\t\t\tif (selector.equals(line)) {\n\t\t\t\t\t\t// original signature:\n\t\t\t\t\t\tline = reader.readLine();\n\t\t\t\t\t\tif (originalSignature.equals(\"\")) {\n\t\t\t\t\t\t\t// annotated signature:\n\t\t\t\t\t\t\treturn reader.readLine();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif (line == null)\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t} catch (IOException e) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t}\n\t\treturn null;\n\t}\n}\n"}, options);
    }

    public void _testBug462371_shouldWarn() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"X.java", "import java.io.*;\ninterface IFile {\n\tInputStream getContents();\n\tboolean exists();\n}\npublic class X {\n\tpublic static String getAnnotatedSignature(String typeName, IFile file, String selector, String originalSignature) {\n\t\tif (file.exists()) {\n\t\t\ttry  {\n\t\t\t\tBufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents())); \n\t\t\t\treader.readLine();\n\t\t\t\twhile (true) {\n\t\t\t\t\tString line = reader.readLine(); \n\t\t\t\t\t// selector:\n\t\t\t\t\tif (selector.equals(line)) {\n\t\t\t\t\t\t// original signature:\n\t\t\t\t\t\tline = reader.readLine();\n\t\t\t\t\t\tif (originalSignature.equals(\"\")) {\n\t\t\t\t\t\t\t// annotated signature:\n\t\t\t\t\t\t\treturn reader.readLine();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif (line == null)\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t} catch (IOException e) {\n\t\t\t\treturn null;\n\t\t\t}\n\t\t}\n\t\treturn null;\n\t}\n}\n"}, "----------\n1. ERROR in C.java (at line 14)\n\treturn;\n\t^^^^^^^\nPotential resource leak: 'fileInputStream' may not be closed at this location\n----------\n", null, true, options);
    }

    public void testBug421035() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"Test.java", "import java.io.BufferedReader;\nimport java.io.FileNotFoundException;\nimport java.io.FileReader;\nimport java.io.IOException;\nimport java.io.Reader;\n\npublic class Test {\n  void test() throws FileNotFoundException {\n    Reader a = (Reader)new BufferedReader(new FileReader(\"a\"));\n    try {\n\t\ta.close();\n\t} catch (IOException e) {\n\t\te.printStackTrace();\n\t}\n  }\n}\n"}, options);
    }

    public void testBug444964() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"Bug444964.java", "import java.io.*;\n\npublic class Bug444964 {\n  void wrong() {\n    try (ByteArrayOutputStream baos = new ByteArrayOutputStream()) {\n      for (;;) {\n        return;\n      }\n    } catch (Exception e) {\n    }\n  }\n  void right() {\n    try (ByteArrayOutputStream baos = new ByteArrayOutputStream()) {\n      while (true) {\n        return;\n      }\n    } catch (Exception e) {\n    }\n  }\n\n}\n"}, options);
    }

    public void testBug397204() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"HostIdTest.java", "import java.io.*;\nimport java.net.InetAddress;\nimport java.net.NetworkInterface;\nimport java.util.Enumeration;\nimport java.util.Formatter;\nimport java.util.Locale;\n\n\npublic class HostIdTest {\n\n    public final void primaryNetworkInterface() throws IOException {\n        System.out.println(InetAddress.getLocalHost());\n        System.out.println(InetAddress.getLocalHost().getHostName());\n        System.out.println(hostId());\n    }\n\n    String hostId() throws IOException {\n        try (StringWriter s = new StringWriter(); PrintWriter p = new PrintWriter(s)) {\n            p.print(InetAddress.getLocalHost().getHostName());\n            p.print('/');\n            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();\n            while (e.hasMoreElements()) {\n                NetworkInterface i = e.nextElement();\n                System.out.println(i);\n                if (i.getHardwareAddress() == null || i.getHardwareAddress().length == 0)\n                    continue;\n                for (byte b : i.getHardwareAddress())\n                    p.printf(\"%02x\", b);\n                return s.toString();\n            }\n            throw new RuntimeException(\"Unable to determine Host ID\");\n        }\n    }\n\n    public void otherHostId() throws Exception {\n        InetAddress addr = InetAddress.getLocalHost();\n        byte[] ipaddr = addr.getAddress();\n        if (ipaddr.length == 4) {\n            int hostid = ipaddr[1] << 24 | ipaddr[0] << 16 | ipaddr[3] << 8 | ipaddr[2];\n            StringBuilder sb = new StringBuilder();\n            try (Formatter formatter = new Formatter(sb, Locale.US)) {\n                formatter.format(\"%08x\", hostid);\n                System.out.println(sb.toString());\n            }\n        } else {\n            throw new Exception(\"hostid for IPv6 addresses not implemented yet\");\n        }\n    }\n    \n}\n"}, options);
    }

    public void testBug397204_comment4() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"HostIdTest.java", "import java.io.*;\n\npublic class HostIdTest {\n\n  void simple() throws Exception {\n    try (InputStream x = new ByteArrayInputStream(null)) {\n      while (Math.abs(1) == 1)\n        if (Math.abs(1) == 1)\n            return;\n    }\n  }\n}\n"}, options);
    }

    public void testBug433510() {
        if (this.complianceLevel < 0x330000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runConformTest(new String[]{"Bug433510.java", "import java.io.*;\n\npublic class Bug433510 {\n\n\tvoid test() throws Exception {\n\t\ttry (Reader r = new StringReader(\"Hello World!\")) {\n\t\t\tint c;\n\t\t\twhile ((c = r.read()) != -1) {\n\t\t\t\tif (c == ' ')\n\t\t\t\t\tthrow new IOException(\"Unexpected space\");\n\t\t\t}\n\t\t}\n\t}\n}\n"}, options);
    }

    public void testBug440282() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        this.runNegativeTest(new String[]{"ResourceLeakFalseNegative.java", "import java.io.FileInputStream;\nimport java.io.IOException;\nimport java.io.InputStreamReader;\n\npublic final class ResourceLeakFalseNegative {\n\n  private static final class Foo implements AutoCloseable {\n    final InputStreamReader reader;\n\n    Foo(final InputStreamReader reader) {\n      this.reader = reader;\n    }\n    \n    public int read() throws IOException {\n      return reader.read();\n    }\n\n    public void close() throws IOException {\n      reader.close();\n    }\n  }\n\n  private static final class Bar {\n    final int read;\n\n    Bar(final InputStreamReader reader) throws IOException {\n      read = reader.read();\n    }\n    \n    public int read() {\n      return read;\n    }\n  }\n\n  public final static int foo() throws IOException {\n    final FileInputStream in = new FileInputStream(\"/dev/null\");\n    final InputStreamReader reader = new InputStreamReader(in);\n    try {\n      return new Foo(reader).read();\n    } finally {\n      // even though Foo is not closed, no potential resource leak is reported.\n    }\n  }\n\n  public final static int bar() throws IOException {\n    final FileInputStream in = new FileInputStream(\"/dev/null\");\n    final InputStreamReader reader = new InputStreamReader(in);\n    try {\n      final Bar bar = new Bar(reader);\n      return bar.read();\n    } finally {\n      // Removing the close correctly reports potential resource leak as a warning,\n      // because Bar does not implement AutoCloseable.\n      reader.close();\n    }\n  }\n\n  public static void main(String[] args) throws IOException {\n    for (;;) {\n      foo();\n      bar();\n    }\n  }\n}\n"}, "----------\n1. ERROR in ResourceLeakFalseNegative.java (at line 39)\n\treturn new Foo(reader).read();\n\t       ^^^^^^^^^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n", null, true, options);
    }

    public void testBug390064() {
        if (this.complianceLevel < 0x310000L) {
            return;
        }
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"Redundant.java", "public class Redundant\n{\n   private static class A<T> implements AutoCloseable\n   {\n      public void close()\n      {\n      }\n   }\n\n   private static class B extends A<Object>\n   {\n      \n   }\n   \n   private static class C implements AutoCloseable\n   {\n      public void close()\n      {\n      }\n   }\n   \n   private static class D extends C\n   {\n      \n   }\n   \n   public static void main(String[] args)\n   {\n      new B();\n      \n      new D();\n   }\n}\n"}, "----------\n1. ERROR in Redundant.java (at line 29)\n\tnew B();\n\t^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n2. ERROR in Redundant.java (at line 31)\n\tnew D();\n\t^^^^^^^\nResource leak: '<unassigned Closeable value>' is never closed\n----------\n", null, true, options);
    }

    public void testBug396575() {
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.potentiallyUnclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unclosedCloseable", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        this.runNegativeTest(new String[]{"Bug396575.java", "import java.io.*;\n\npublic class Bug396575 {\n  void test1(File myFile) {\n   OutputStream out = null;\n   BufferedWriter bw = null;\n   try {\n       // code...\n       out = new FileOutputStream(myFile);\n       OutputStreamWriter writer = new OutputStreamWriter(out);\n       bw = new BufferedWriter(writer);\n       // more code...\n   } catch (Exception e) {\n       try {\n           bw.close(); // WARN: potential null pointer access\n       } catch (Exception ignored) {}\n       return;  // WARN: resource leak - bw may not be closed\n   }\n  }\n  \n  void test2(File myFile) {\n       BufferedWriter bw = null;\n   try {\n       // code...\n                                                       // declare \"out\" here inside try-catch as a temp variable\n       OutputStream out = new FileOutputStream(myFile); // WARN: out is never closed.\n       OutputStreamWriter writer = new OutputStreamWriter(out);\n       bw = new BufferedWriter(writer);\n       // more code...\n   } catch (Exception e) {\n       try {\n           bw.close(); // WARN: potential null pointer access\n       } catch (Exception ignored) {}\n       return;  // WARN: resource leak - bw may not be closed\n   }\n  }\n}\n"}, "----------\n1. ERROR in Bug396575.java (at line 11)\n\tbw = new BufferedWriter(writer);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: 'bw' is never closed\n----------\n2. ERROR in Bug396575.java (at line 28)\n\tbw = new BufferedWriter(writer);\n\t^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nResource leak: 'bw' is never closed\n----------\n", null, true, options);
    }
}

