/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.io.File;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.core.tests.compiler.regression.Requestor;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class TypeAnnotationTest
extends AbstractRegressionTest {
    private static final String HELPER_CLASS = "import java.lang.annotation.*;\nimport java.lang.reflect.*;\nclass Helper {\n\n  public static void printTypeAnnotations(Class<?> clazz) {\n    System.out.print(\"Annotations on superclass of \"+clazz.getName() +\"\\n\");\n    AnnotatedType superat = clazz.getAnnotatedSuperclass();\n    Helper.printAnnos(\"  \", superat.getType(),superat.getAnnotations());\n    AnnotatedType[] superinterfaces = clazz.getAnnotatedInterfaces();\n    if (superinterfaces.length!=0) {\n      System.out.print(\"Annotations on superinterfaces of \"+clazz.getName() +\"\\n\");\n      for (int j=0;j<superinterfaces.length;j++) {\n        Helper.printAnnos(\"  \", superinterfaces[j].getType(),superinterfaces[j].getAnnotations());\n      }\n    }\n  }\n  public static void printTypeAnnotations2(Class<?> clazz) {\n    System.out.print(clazz.getName()+\"<\");\n    TypeVariable<?>[] tvs = clazz.getTypeParameters();\n    for (int t=0;t<tvs.length;t++) {\n      TypeVariable<?> tv = tvs[t];\n      Annotation[] annos = tv.getAnnotations();\n      for (int a=0;a<annos.length;a++) {\n        System.out.print(toStringAnno(annos[a])+\" \");\n      }\n      System.out.print(tv.getName());\n      if ((t+1)<tvs.length) System.out.print(\",\");\n    }\n    System.out.print(\">\\n\");\n  }\n  public static String toStringAnno(Annotation anno) {\n    String s = anno.toString();\n\t s = s.replace(\"\\\"\", \"\");\n\t s = s.replace(\"'\", \"\");\n    if (s.endsWith(\"()\")) return s.substring(0,s.length()-2); else return s;\n  }\n  \n  public static void printAnnos(String header, Type t, Annotation[] annos) {\n    if (annos.length==0) { System.out.print(header+t+\":no annotations\\n\"); return;} \n    System.out.print(header+t+\":\");\n    for (int i=0;i<annos.length;i++) {\n      System.out.print(toStringAnno(annos[i])+\" \");\n    }\n    System.out.print(\"\\n\");\n  }\n}\n";

    public static Class testClass() {
        return TypeAnnotationTest.class;
    }

    public static Test suite() {
        return TypeAnnotationTest.buildMinimalComplianceTestSuite(TypeAnnotationTest.testClass(), 32);
    }

    public TypeAnnotationTest(String testName) {
        super(testName);
    }

    @Override
    protected Map getCompilerOptions() {
        Map<String, String> defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "1.8");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        return defaultOptions;
    }

    public void test001_classTypeParameter() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<@Marker T> {}", "Marker.java", "import java.lang.annotation.*;\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.TYPE_PARAMETER)\n@interface Marker {}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #21 @Marker(\n      target type = 0x0 CLASS_TYPE_PARAMETER\n      type parameter index = 0\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test002_classTypeParameter_reflection() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<@Marker T> {\n  public static void main(String[] argv) { Helper.printTypeAnnotations2(X.class);}\n}", "Helper.java", HELPER_CLASS, "Marker.java", "import java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Retention(RetentionPolicy.RUNTIME)\n@Target(TYPE_PARAMETER)\n@interface Marker {}"}, "X<@Marker T>");
    }

    public void test003_classTypeParameter() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<@A1 T1,@A2 @A3 T2> {}", "A1.java", "import java.lang.annotation.*;\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.TYPE_PARAMETER)\n@interface A1 {}", "A2.java", "import java.lang.annotation.*;\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.TYPE_PARAMETER)\n@interface A2 {}", "A3.java", "import java.lang.annotation.*;\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.TYPE_PARAMETER)\n@interface A3 {}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #21 @A1(\n      target type = 0x0 CLASS_TYPE_PARAMETER\n      type parameter index = 0\n    )\n    #22 @A2(\n      target type = 0x0 CLASS_TYPE_PARAMETER\n      type parameter index = 1\n    )\n    #23 @A3(\n      target type = 0x0 CLASS_TYPE_PARAMETER\n      type parameter index = 1\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test004_classTypeParameter_reflection() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<@A1 T1,@A2 @A3 T2> {\n    public static void main(String[] argv) { Helper.printTypeAnnotations2(X.class); }\n}", "Helper.java", HELPER_CLASS, "A1.java", "import java.lang.annotation.*;\n@Retention(RetentionPolicy.RUNTIME)\n@Target(ElementType.TYPE_PARAMETER)\n@interface A1 {}", "A2.java", "import java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Retention(RetentionPolicy.RUNTIME)\n@Target(TYPE_PARAMETER)\n@interface A2 {}", "A3.java", "import java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Retention(RetentionPolicy.RUNTIME)\n@Target(TYPE_PARAMETER)\n@interface A3 {}"}, "X<@A1 T1,@A2 @A3 T2>");
    }

    public void test005_classTypeParameter() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_PARAMETER)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_PARAMETER)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X<@A @B(3) T> {}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #25 @A(\n      target type = 0x0 CLASS_TYPE_PARAMETER\n      type parameter index = 0\n    )\n  RuntimeInvisibleTypeAnnotations: \n    #21 @B(\n      #22 value=(int) 3 (constant type)\n      target type = 0x0 CLASS_TYPE_PARAMETER\n      type parameter index = 0\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test006_classTypeParameter() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_PARAMETER)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_PARAMETER)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X<T1,T2,@A @B(3) T3> {}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #25 @A(\n      target type = 0x0 CLASS_TYPE_PARAMETER\n      type parameter index = 2\n    )\n  RuntimeInvisibleTypeAnnotations: \n    #21 @B(\n      #22 value=(int) 3 (constant type)\n      target type = 0x0 CLASS_TYPE_PARAMETER\n      type parameter index = 2\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test007_methodTypeParameter() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_PARAMETER)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_PARAMETER)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X {\n\t<@A @B(3) T> void foo(T t) {}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #27 @A(\n        target type = 0x1 METHOD_TYPE_PARAMETER\n        type parameter index = 0\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #23 @B(\n        #24 value=(int) 3 (constant type)\n        target type = 0x1 METHOD_TYPE_PARAMETER\n        type parameter index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test008_methodTypeParameter() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_PARAMETER)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_PARAMETER)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X {\n\t<T1, @A @B(3) T2> void foo(T1 t1,T2 t2) {}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #29 @A(\n        target type = 0x1 METHOD_TYPE_PARAMETER\n        type parameter index = 1\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #25 @B(\n        #26 value=(int) 3 (constant type)\n        target type = 0x1 METHOD_TYPE_PARAMETER\n        type parameter index = 1\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test009_classExtends() throws Exception {
        this.runConformTest(new String[]{"Marker.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n@Target(TYPE_USE)\n@interface Marker {}", "X.java", "public class X extends @Marker Object {}"}, "");
        String expectedOutput = "  RuntimeInvisibleTypeAnnotations: \n    #17 @Marker(\n      target type = 0x10 CLASS_EXTENDS\n      type index = -1\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test010_classExtends() throws Exception {
        this.runConformTest(new String[]{"Marker.java", "import java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Retention(RetentionPolicy.RUNTIME)\n@Target(TYPE_USE)\n@interface Marker {}", "X.java", "public class X extends @Marker Object {}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #17 @Marker(\n      target type = 0x10 CLASS_EXTENDS\n      type index = -1\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test011_classExtends_reflection() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X extends @Marker Object {public static void main(String[] argv) {Helper.printTypeAnnotations(X.class);}}", "Helper.java", HELPER_CLASS, "Marker.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\n@Target(TYPE_USE)\n@interface Marker {}"}, "Annotations on superclass of X\n  class java.lang.Object:no annotations");
    }

    public void test012_classExtends_reflection() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X extends @Marker Object {public static void main(String[] argv) {Helper.printTypeAnnotations(X.class);}}", "Helper.java", HELPER_CLASS, "Marker.java", "import java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Target(TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface Marker {}"}, "Annotations on superclass of X\n  class java.lang.Object:@Marker");
    }

    public void test013_classExtends_interfaces() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString id() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "I.java", "interface I {}\n", "J.java", "interface J {}\n", "X.java", "public class X implements @A(id=\"Hello, World!\") I, @B @C('(') J {}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #23 @A(\n      #24 id=\"Hello, World!\" (constant type)\n      target type = 0x10 CLASS_EXTENDS\n      type index = 0\n    )\n    #26 @C(\n      #27 value='(' (constant type)\n      target type = 0x10 CLASS_EXTENDS\n      type index = 1\n    )\n  RuntimeInvisibleTypeAnnotations: \n    #21 @B(\n      target type = 0x10 CLASS_EXTENDS\n      type index = 1\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test014_classExtends_interfaces_reflection() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X implements @A I {public static void main(String[]argv) {Helper.printTypeAnnotations(X.class);}}", "Helper.java", HELPER_CLASS, "A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n}\n", "I.java", "interface I {}\n"}, "Annotations on superclass of X\n  class java.lang.Object:no annotations\nAnnotations on superinterfaces of X\n  interface I:@A");
    }

    public void test015_classExtends_interfaces_reflection() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X implements @A(id=\"Hello, World!\") I, @B @C('i') J {public static void main(String[] argv) { Helper.printTypeAnnotations(X.class);}}", "Helper.java", HELPER_CLASS, "A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString id() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "I.java", "interface I {}\n", "J.java", "interface J {}\n"}, "Annotations on superclass of X\n  class java.lang.Object:no annotations\nAnnotations on superinterfaces of X\n  interface I:@A(id=Hello, World!) \n  interface J:@C(value=i)");
    }

    public void test016_classExtends() throws Exception {
        this.runConformTest(new String[]{"B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface B {\n\tint value() default -1;\n}", "Y.java", "class Y<T> {}\n", "X.java", "public class X extends Y<@B String> {\n}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #19 @B(\n      target type = 0x10 CLASS_EXTENDS\n      type index = -1\n      location = [TYPE_ARGUMENT(0)]\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test017_classExtends() throws Exception {
        this.runConformTest(new String[]{"Marker.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface Marker { }\n", "I.java", "interface I<T> {}\n", "X.java", "public class X implements I<@Marker String> {\n}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #21 @Marker(\n      target type = 0x10 CLASS_EXTENDS\n      type index = 0\n      location = [TYPE_ARGUMENT(0)]\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test018_classExtends() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A { }\n", "I.java", "interface I<T1,T2> {}\n", "X.java", "public class X implements I<Integer, @A String> {}\n"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #21 @A(\n      target type = 0x10 CLASS_EXTENDS\n      type index = 0\n      location = [TYPE_ARGUMENT(1)]\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test019_classExtends() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A { }\n", "J.java", "interface J<T> {}\n", "I.java", "interface I<T> {}\n", "X.java", "public class X implements I<J<@A String>> {}\n"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #21 @A(\n      target type = 0x10 CLASS_EXTENDS\n      type index = 0\n      location = [TYPE_ARGUMENT(0), TYPE_ARGUMENT(0)]\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test020_classExtends() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A { }\n", "I.java", "interface I<T> {}\n", "X.java", "public class X implements I<@A String[]> {}\n"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #21 @A(\n      target type = 0x10 CLASS_EXTENDS\n      type index = 0\n      location = [TYPE_ARGUMENT(0), ARRAY]\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test021_classExtends() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A { }\n", "I.java", "interface I<T> {}\n", "X.java", "public class X implements I<String @A[]> {}\n"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #21 @A(\n      target type = 0x10 CLASS_EXTENDS\n      type index = 0\n      location = [TYPE_ARGUMENT(0)]\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test022_classExtends() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A { }\n", "I.java", "interface I<T> {}\n", "X.java", "public class X implements I<String []@A[]> {}\n"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #21 @A(\n      target type = 0x10 CLASS_EXTENDS\n      type index = 0\n      location = [TYPE_ARGUMENT(0), ARRAY]\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test023_classExtends() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A { }\n", "I.java", "interface I<T> {}\n", "X.java", "public class X implements I<@A String [][][]> {}\n"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #21 @A(\n      target type = 0x10 CLASS_EXTENDS\n      type index = 0\n      location = [TYPE_ARGUMENT(0), ARRAY, ARRAY, ARRAY]\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test024_classExtends() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "I.java", "interface I<T> {}\n", "J.java", "interface J<U,T> {}\n", "X.java", "public class X implements I<@A(\"Hello, World!\") String>, @B J<String, @C('(') Integer> {}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #25 @A(\n      #26 value=\"Hello, World!\" (constant type)\n      target type = 0x10 CLASS_EXTENDS\n      type index = 0\n      location = [TYPE_ARGUMENT(0)]\n    )\n    #28 @C(\n      #26 value='(' (constant type)\n      target type = 0x10 CLASS_EXTENDS\n      type index = 1\n      location = [TYPE_ARGUMENT(1)]\n    )\n  RuntimeInvisibleTypeAnnotations: \n    #23 @B(\n      target type = 0x10 CLASS_EXTENDS\n      type index = 1\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test025_classTypeParameterBound() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<T extends @A String> {}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {}\n"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #21 @A(\n      target type = 0x11 CLASS_TYPE_PARAMETER_BOUND\n      type parameter index = 0 type parameter bound index = 0\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test026_classTypeParameterBound() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X<T extends @A String & @B(3) Cloneable> {}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #25 @A(\n      target type = 0x11 CLASS_TYPE_PARAMETER_BOUND\n      type parameter index = 0 type parameter bound index = 0\n    )\n  RuntimeInvisibleTypeAnnotations: \n    #21 @B(\n      #22 value=(int) 3 (constant type)\n      target type = 0x11 CLASS_TYPE_PARAMETER_BOUND\n      type parameter index = 0 type parameter bound index = 1\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test027_classTypeParameterBound_complex() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "Y.java", "public class Y<T> {}", "X.java", "public class X<U, T extends Y<@A String @C[][]@B[]> & @B(3) Cloneable> {}"}, "");
        String expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #25 @A(\n      target type = 0x11 CLASS_TYPE_PARAMETER_BOUND\n      type parameter index = 1 type parameter bound index = 0\n      location = [TYPE_ARGUMENT(0), ARRAY, ARRAY, ARRAY]\n    )\n    #26 @C(\n      target type = 0x11 CLASS_TYPE_PARAMETER_BOUND\n      type parameter index = 1 type parameter bound index = 0\n      location = [TYPE_ARGUMENT(0)]\n    )\n  RuntimeInvisibleTypeAnnotations: \n    #21 @B(\n      target type = 0x11 CLASS_TYPE_PARAMETER_BOUND\n      type parameter index = 1 type parameter bound index = 0\n      location = [TYPE_ARGUMENT(0), ARRAY, ARRAY]\n    )\n    #21 @B(\n      #22 value=(int) 3 (constant type)\n      target type = 0x11 CLASS_TYPE_PARAMETER_BOUND\n      type parameter index = 1 type parameter bound index = 1\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test028_methodTypeParameterBound() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "Z.java", "public class Z {}", "X.java", "public class X {\n\t<T extends @A Z> void foo(T t) {}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #23 @A(\n        target type = 0x12 METHOD_TYPE_PARAMETER_BOUND\n        type parameter index = 0 type parameter bound index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test029_methodTypeParameterBound() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "Z.java", "public class Z {}", "X.java", "public class X {\n\t<T extends @A Z & @B(3) Cloneable> void foo(T t) {}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #27 @A(\n        target type = 0x12 METHOD_TYPE_PARAMETER_BOUND\n        type parameter index = 0 type parameter bound index = 0\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #23 @B(\n        #24 value=(int) 3 (constant type)\n        target type = 0x12 METHOD_TYPE_PARAMETER_BOUND\n        type parameter index = 0 type parameter bound index = 1\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test030_methodTypeParameterBound() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "Z.java", "public class Z {}", "Y.java", "public class Y<T> {}", "X.java", "public class X {\n\t<T extends Y<Z [][]@B[]> & Cloneable> void foo(T t) {}\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #23 @B(\n        target type = 0x12 METHOD_TYPE_PARAMETER_BOUND\n        type parameter index = 0 type parameter bound index = 0\n        location = [TYPE_ARGUMENT(0), ARRAY, ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test031_methodTypeParameterBound_complex() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "Z.java", "public class Z {}", "Y.java", "public class Y<T> {}", "X.java", "public class X {\n\t<T extends Y<@A Z @C[][]@B[]> & @B(3) Cloneable> void foo(T t) {}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #27 @A(\n        target type = 0x12 METHOD_TYPE_PARAMETER_BOUND\n        type parameter index = 0 type parameter bound index = 0\n        location = [TYPE_ARGUMENT(0), ARRAY, ARRAY, ARRAY]\n      )\n      #28 @C(\n        target type = 0x12 METHOD_TYPE_PARAMETER_BOUND\n        type parameter index = 0 type parameter bound index = 0\n        location = [TYPE_ARGUMENT(0)]\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #23 @B(\n        target type = 0x12 METHOD_TYPE_PARAMETER_BOUND\n        type parameter index = 0 type parameter bound index = 0\n        location = [TYPE_ARGUMENT(0), ARRAY, ARRAY]\n      )\n      #23 @B(\n        #24 value=(int) 3 (constant type)\n        target type = 0x12 METHOD_TYPE_PARAMETER_BOUND\n        type parameter index = 0 type parameter bound index = 1\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test032_field() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {}\n", "X.java", "public class X {\n\t@A int field;\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @A(\n        target type = 0x13 FIELD\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test033_field() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {}\n", "X.java", "public class X {\n\tjava.util.List<@A String> field;\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @A(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test034_field() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X {\n\t@B(3) @A int field;\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #12 @A(\n        target type = 0x13 FIELD\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test035_field() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {}\n", "X.java", "public class X {\n\tjava.util.Map<String, @A String> field;\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @A(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(1)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test036_field() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {}\n", "X.java", "public class X {\n\tjava.util.List<String[][]@A[][]> field;\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @A(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(0), ARRAY, ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test037_field() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tjava.util.List<? extends @A Number> field;\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @A(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(0), WILDCARD]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test038_field() throws Exception {
        this.runConformTest(new String[]{"X.java", "class AA { class BB<T> {}}class X {\n  AA.@A BB field;\n}\n", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A { }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @A(\n        target type = 0x13 FIELD\n        location = [INNER_TYPE]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test038a_field() throws Exception {
        this.runConformTest(new String[]{"X.java", "class AA { class BB<T> {}}class X {\n  @B AA.@A BB[] @C[] field;\n}\n", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A { }\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { }\n", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C { }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @B(\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n      #9 @A(\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE]\n      )\n      #10 @C(\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test039_field() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X {\n\t@A int [] @B(3) [] field;\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #12 @A(\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test040_field_complex() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.Map;\nimport java.util.List;\npublic class X {\n\t@H String @E[] @F[] @G[] field;\n\t@A Map<@B String, @C List<@D Object>> field2;\n\t@A Map<@B String, @H String @E[] @F[] @G[]> field3;\n}", "A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "D.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface D {\n\tString value() default \"default\";\n}\n", "E.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface E {\n\tint value() default -1;\n}", "F.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface F {\n\tchar value() default '-';\n}\n", "G.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface G {\n\tint value() default -1;\n}", "H.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface H {\n\tchar value() default '-';\n}\n"}, "");
        String expectedOutput = "  // Field descriptor #6 [[[Ljava/lang/String;\n  java.lang.String[][][] field;\n    RuntimeVisibleTypeAnnotations: \n      #11 @H(\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, ARRAY]\n      )\n      #12 @F(\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #8 @E(\n        target type = 0x13 FIELD\n      )\n      #9 @G(\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n  \n  // Field descriptor #14 Ljava/util/Map;\n  // Signature: Ljava/util/Map<Ljava/lang/String;Ljava/util/List<Ljava/lang/Object;>;>;\n  java.util.Map field2;\n    RuntimeVisibleTypeAnnotations: \n      #18 @A(\n        target type = 0x13 FIELD\n      )\n      #19 @C(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(1)]\n      )\n      #20 @D(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(1), TYPE_ARGUMENT(0)]\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #17 @B(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(0)]\n      )\n  \n  // Field descriptor #14 Ljava/util/Map;\n  // Signature: Ljava/util/Map<Ljava/lang/String;[[[Ljava/lang/String;>;\n  java.util.Map field3;\n    RuntimeVisibleTypeAnnotations: \n      #18 @A(\n        target type = 0x13 FIELD\n      )\n      #11 @H(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(1), ARRAY, ARRAY, ARRAY]\n      )\n      #12 @F(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(1), ARRAY]\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #17 @B(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(0)]\n      )\n      #8 @E(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(1)]\n      )\n      #9 @G(\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(1), ARRAY, ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test041_field() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tjava.lang.@H String @E[] @F[] @G[] field;\n}", "E.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface E {\n\tint value() default -1;\n}", "F.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface F {\n\tchar value() default '-';\n}\n", "G.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface G {\n\tint value() default -1;\n}", "H.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface H {\n\tchar value() default '-';\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #11 @H(\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, ARRAY]\n      )\n      #12 @F(\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #8 @E(\n        target type = 0x13 FIELD\n      )\n      #9 @G(\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test042_methodReturnType() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X {\n\t@B(3) @A(value=\"test\") int foo() {\n\t\treturn 1;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #21 @A(\n        #18 value=\"test\" (constant type)\n        target type = 0x14 METHOD_RETURN\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #17 @B(\n        #18 value=(int) 3 (constant type)\n        target type = 0x14 METHOD_RETURN\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test043_methodReceiver() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X {\n\tvoid foo(@B(3) X this) {}\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #16 @B(\n        #17 value=(int) 3 (constant type)\n        target type = 0x15 METHOD_RECEIVER\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test044_methodReceiver() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tvoid foo(X<@B(3) T> this) {}\n}", "A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #18 @B(\n        #19 value=(int) 3 (constant type)\n        target type = 0x15 METHOD_RECEIVER\n        location = [TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test045_methodParameter() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint foo(@B(3) String s) {\n\t\treturn s.length();\n\t}\n}", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #25 @B(\n        #26 value=(int) 3 (constant type)\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test046_methodParameter() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tint foo(int i, double d, @B(3) String s) {\n\t\treturn s.length();\n\t}\n}", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #29 @B(\n        #30 value=(int) 3 (constant type)\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 2\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test047_methodParameterArray() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X {\n\tint foo(String @A [] @B(3) [] s) {\n\t\treturn s.length;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #23 @A(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #19 @B(\n        #20 value=(int) 3 (constant type)\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test048_throws() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "E.java", "class E extends RuntimeException {\n\tprivate static final long serialVersionUID = 1L;\n}\n", "E1.java", "class E1 extends RuntimeException {\n\tprivate static final long serialVersionUID = 1L;\n}\n", "E2.java", "class E2 extends RuntimeException {\n\tprivate static final long serialVersionUID = 1L;\n}\n", "X.java", "public class X {\n\tvoid foo() throws @A(\"Hello, World!\") E, E1, @B @C('(') E2 {}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #25 @A(\n        #26 value=\"Hello, World!\" (constant type)\n        target type = 0x17 THROWS\n        throws index = 0\n      )\n      #28 @C(\n        #26 value='(' (constant type)\n        target type = 0x17 THROWS\n        throws index = 2\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #23 @B(\n        target type = 0x17 THROWS\n        throws index = 2\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test049_codeblocks_localVariable() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t@B int j = 9;\n\t\ttry {\n\t\t\tSystem.out.print(\"SUCCESS\" + j);\n\t\t} catch(@A Exception e) {\n\t\t}\n\t\t@B int k = 3;\n\t\tSystem.out.println(k);\n\t}\n}", "A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tString value() default \"default\";\n}\n"}, "SUCCESS93");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #56 @B(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 3, pc: 39] index: 1\n      )\n      #56 @B(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 31, pc: 39] index: 2\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test050_codeblocks_localVariable() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "X.java", "public class X {\n\tString[][] bar() {\n\t\treturn new String[][] {};\t}\n\tvoid foo(String s) {\n\t\t@C int i;\n\t\t@A String [] @B(3)[] tab = bar();\n\t\tif (tab != null) {\n\t\t\ti = 0;\n\t\t\tSystem.out.println(i + tab.length);\n\t\t} else {\n\t\t\tSystem.out.println(tab.length);\n\t\t}\n\t\ti = 4;\n\t\tSystem.out.println(-i + tab.length);\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #45 @B(\n        #46 value=(int) 3 (constant type)\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 5, pc: 46] index: 3\n        location = [ARRAY]\n      )\n    RuntimeVisibleTypeAnnotations: \n      #49 @C(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 11, pc: 24] index: 2\n          [pc: 34, pc: 46] index: 2\n      )\n      #50 @A(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 5, pc: 46] index: 3\n        location = [ARRAY, ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test051_codeblocks_resourceVariable() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "import java.io.*;\npublic class X {\n   public static void main(String[] argv) throws Exception {\n     try (@A BufferedReader br1 = new BufferedReader(new FileReader(\"a\"));\n          @B(99) BufferedReader br2 = new BufferedReader(new FileReader(\"b\"))) {\n       System.out.println(br1.readLine()+br2.readLine());\n     }\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #81 @B(\n        #82 value=(int) 99 (constant type)\n        target type = 0x41 RESOURCE_VARIABLE\n        local variable entries:\n          [pc: 39, pc: 94] index: 4\n      )\n    RuntimeVisibleTypeAnnotations: \n      #85 @A(\n        target type = 0x41 RESOURCE_VARIABLE\n        local variable entries:\n          [pc: 21, pc: 135] index: 3\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test052_codeblocks_exceptionParameter() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tException test = new Exception() {\n\t\t\tprivate static final long serialVersionUID = 1L;\n\t\t\t@Override\n\t\t\tpublic String toString() {\n\t\t\t\treturn \"SUCCESS\";\n\t\t\t}\n\t\t};\n\t\ttry {\n\t\t\tSystem.out.println(test);\n\t\t} catch(@A Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}", "A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "SUCCESS");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #44 @A(\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test053_codeblocks_exceptionParameter() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\t@A Exception test = new Exception() {\n\t\t\tprivate static final long serialVersionUID = 1L;\n\t\t\t@Override\n\t\t\tpublic String toString() {\n\t\t\t\treturn \"SUCCESS\";\n\t\t\t}\n\t\t};\n\t\ttry {\n\t\t\tSystem.out.println(test);\n\t\t} catch(@A Exception e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n}", "A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "SUCCESS");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #44 @A(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 8, pc: 24] index: 1\n      )\n      #44 @A(\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test054_codeblocks_exceptionParameter() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println(42);\n\t\t} catch(@B(1) RuntimeException e) {\n\t\t\te.printStackTrace();\n\t\t} catch(@B(2) Throwable t) {\n\t\t\tt.printStackTrace();\n\t\t}\n\t}\n}", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface B {\n\tint value() default 99;\n}\n"}, "42");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #44 @B(\n        #45 value=(int) 1 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n      #44 @B(\n        #45 value=(int) 2 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 1\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test055_codeblocks_exceptionParameterMultiCatch() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\nclass Exc1 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\nclass Exc2 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\nclass Exc3 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println(42);\n\t\t} catch(@B(1) Exc1 | Exc2 | @B(2) Exc3 t) {\n\t\t\tt.printStackTrace();\n\t\t}\n\t}\n}", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface B {\n\tint value() default 99;\n}\n"}, "42");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #45 @B(\n        #46 value=(int) 1 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n      #45 @B(\n        #46 value=(int) 2 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 2\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test056_codeblocks_instanceof() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object o) {\n\t\tif (o instanceof @A String) {\n\t\t\tString tab = (String) o;\n\t\t\tSystem.out.println(tab);\n\t\t}\n\t\tSystem.out.println(o);\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #38 @A(\n        target type = 0x43 INSTANCEOF\n        offset = 1\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
        expectedOutput = "     1  instanceof java.lang.String [16]\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test057_codeblocks_new() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "I.java", "interface I {}\n", "J.java", "interface J {}\n", "X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tObject o = new @B(3) Object();\n\t\treturn true;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #35 @B(\n        #36 value=(int) 3 (constant type)\n        target type = 0x44 NEW\n        offset = 8\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test058_codeblocks_new2() throws Exception {
        this.runConformTest(new String[]{"B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X {\n\tpublic void foo() {\n       Outer o = new Outer();\n       o.new @B(1) Inner();\n\t}\n}\nclass Outer { class Inner {}}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #30 @B(\n        #31 value=(int) 1 (constant type)\n        target type = 0x44 NEW\n        offset = 8\n        location = [INNER_TYPE]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test057_codeblocks_new3_415821() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface X { }\n\nclass Foo {}\n", "C.java", "class C { void m() { new @X Foo() {}; } }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #21 @X(\n        target type = 0x44 NEW\n        offset = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "C.class", "C", expectedOutput, 4);
        expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #28 @X(\n      target type = 0x10 CLASS_EXTENDS\n      type index = -1\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "C$1.class", "C$1", expectedOutput, 4);
    }

    public void test057_codeblocks_new4_415821() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface X { }\n\n", "C.java", "class C { void m() { new @X Runnable() { public void run() {}}; } }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #21 @X(\n        target type = 0x44 NEW\n        offset = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "C.class", "C", expectedOutput, 4);
        expectedOutput = "  RuntimeVisibleTypeAnnotations: \n    #31 @X(\n      target type = 0x10 CLASS_EXTENDS\n      type index = 0\n    )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "C$1.class", "C$1", expectedOutput, 4);
    }

    public void test059_codeblocks_new_newArray() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "I.java", "interface I {}\n", "J.java", "interface J {}\n", "X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tObject o = new @A String [1];\n\t\treturn true;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #37 @A(\n        target type = 0x44 NEW\n        offset = 9\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test060_codeblocks_new_multiNewArray() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tObject o = new @A String [2][3];\n\t\treturn true;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #37 @A(\n        target type = 0x44 NEW\n        offset = 10\n        location = [ARRAY, ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test060a_codeblocks_new_newArrayWithInitializer() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tX[][] x = new @A X @B [] @C[]{ { null }, { null } };\n\t\treturn true;\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tString value() default \"default\";\n}\n", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface C {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #37 @A(\n        target type = 0x44 NEW\n        offset = 9\n        location = [ARRAY, ARRAY]\n      )\n      #38 @B(\n        target type = 0x44 NEW\n        offset = 9\n      )\n      #39 @C(\n        target type = 0x44 NEW\n        offset = 9\n        location = [ARRAY]\n      )\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test060b_codeblocks_new_multiNewArray() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tX[][] x = new @A X @B [1] @C[2];\n\t\treturn true;\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tString value() default \"default\";\n}\n", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface C {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #36 @A(\n        target type = 0x44 NEW\n        offset = 10\n        location = [ARRAY, ARRAY]\n      )\n      #37 @B(\n        target type = 0x44 NEW\n        offset = 10\n      )\n      #38 @C(\n        target type = 0x44 NEW\n        offset = 10\n        location = [ARRAY]\n      )\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test060c_codeblocks_new_multiNewArray() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tX [][][] x = new @A X @B[10] @C[10] @D[];\n\t\treturn true;\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tString value() default \"default\";\n}\n", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface C {\n\tString value() default \"default\";\n}\n", "D.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface D {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #36 @A(\n        target type = 0x44 NEW\n        offset = 12\n        location = [ARRAY, ARRAY, ARRAY]\n      )\n      #37 @B(\n        target type = 0x44 NEW\n        offset = 12\n      )\n      #38 @C(\n        target type = 0x44 NEW\n        offset = 12\n        location = [ARRAY]\n      )\n      #39 @D(\n        target type = 0x44 NEW\n        offset = 12\n        location = [ARRAY, ARRAY]\n      )\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test060d_codeblocks_new_arraysWithNestedTypes() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tObject o = new @B(1) Outer.@B(2) Inner @B(3) [2];\n\t\treturn true;\n\t}\n}\nclass Outer { class Inner {}}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default 99;\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #37 @B(\n        #38 value=(int) 1 (constant type)\n        target type = 0x44 NEW\n        offset = 9\n        location = [ARRAY]\n      )\n      #37 @B(\n        #38 value=(int) 2 (constant type)\n        target type = 0x44 NEW\n        offset = 9\n        location = [ARRAY, INNER_TYPE]\n      )\n      #37 @B(\n        #38 value=(int) 3 (constant type)\n        target type = 0x44 NEW\n        offset = 9\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test060e_codeblocks_new_arraysWithNestedTypes() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tObject o = new @B(1) Outer.@B(2) Inner @B(3) [2] @B(4)[4];\n\t\treturn true;\n\t}\n}\nclass Outer { class Inner {}}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default 99;\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #37 @B(\n        #38 value=(int) 1 (constant type)\n        target type = 0x44 NEW\n        offset = 10\n        location = [ARRAY, ARRAY]\n      )\n      #37 @B(\n        #38 value=(int) 2 (constant type)\n        target type = 0x44 NEW\n        offset = 10\n        location = [ARRAY, ARRAY, INNER_TYPE]\n      )\n      #37 @B(\n        #38 value=(int) 3 (constant type)\n        target type = 0x44 NEW\n        offset = 10\n      )\n      #37 @B(\n        #38 value=(int) 4 (constant type)\n        target type = 0x44 NEW\n        offset = 10\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test060f_codeblocks_new_arraysWithQualifiedNestedTypes() throws Exception {
        this.runConformTest(new String[]{"Z.java", "public class Z {}", "X.java", "package org.foo.bar;\npublic class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tObject o = new org.foo.bar.@B(1) Outer.@B(2) Inner @B(3) [2] @B(4)[4];\n\t\treturn true;\n\t}\n}\nclass Outer { class Inner {}}\n", "B.java", "package org.foo.bar;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default 99;\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #37 @org.foo.bar.B(\n        #38 value=(int) 1 (constant type)\n        target type = 0x44 NEW\n        offset = 10\n        location = [ARRAY, ARRAY]\n      )\n      #37 @org.foo.bar.B(\n        #38 value=(int) 2 (constant type)\n        target type = 0x44 NEW\n        offset = 10\n        location = [ARRAY, ARRAY, INNER_TYPE]\n      )\n      #37 @org.foo.bar.B(\n        #38 value=(int) 3 (constant type)\n        target type = 0x44 NEW\n        offset = 10\n      )\n      #37 @org.foo.bar.B(\n        #38 value=(int) 4 (constant type)\n        target type = 0x44 NEW\n        offset = 10\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "org" + File.separator + "foo" + File.separator + "bar" + File.separator + "X.class", "org.foo.bar.X", expectedOutput, 4);
    }

    public void test061_codeblocks_new_newArrayWithInitializer() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "I.java", "interface I {}\n", "J.java", "interface J {}\n", "X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tObject o = new @A String []{\"xyz\"};\n\t\treturn true;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #37 @A(\n        target type = 0x44 NEW\n        offset = 9\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test062_codeblocks_newArray() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "I.java", "interface I {}\n", "J.java", "interface J {}\n", "X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tObject o = new String @A[1];\n\t\treturn true;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #37 @A(\n        target type = 0x44 NEW\n        offset = 9\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test062_codeblocks_newArrayWithInitializer() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "I.java", "interface I {}\n", "J.java", "interface J {}\n", "X.java", "public class X {\n\tpublic boolean foo(String s) {\n\t\tSystem.out.println(\"xyz\");\n\t\tObject o = new String @A[] { \"Hello\" };\n\t\treturn true;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #39 @A(\n        target type = 0x44 NEW\n        offset = 9\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test063_codeblocks_new_instanceof() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "I.java", "interface I {}\n", "J.java", "interface J {}\n", "X.java", "public class X {\n\tpublic boolean foo(Object o) {\n\t\tboolean b = (o instanceof @C('_') Object[]);\n\t\tObject o1 = new @B(3) @A(\"new Object\") Object[] {};\n\t\treturn b;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #24 @B(\n        #25 value=(int) 3 (constant type)\n        target type = 0x44 NEW\n        offset = 6\n        location = [ARRAY]\n      )\n    RuntimeVisibleTypeAnnotations: \n      #28 @C(\n        #25 value='_' (constant type)\n        target type = 0x43 INSTANCEOF\n        offset = 1\n        location = [ARRAY]\n      )\n      #30 @A(\n        #25 value=\"new Object\" (constant type)\n        target type = 0x44 NEW\n        offset = 6\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test064_codeblocks_constructorReference() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\ninterface MR { X process(String input); }\npublic class X<T> {\n   public X(T t) {}\n   public static <T> String foo(String bar) { return bar; }\n\tpublic void bar() {\n       System.out.println(\"abc\");\n       MR ref = @A X::new;\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #48 @A(\n        target type = 0x45 CONSTRUCTOR_REFERENCE\n        offset = 8\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test065_codeblocks_methodReference() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\ninterface MR { String process(String input); }\npublic class X<T> {\n   public static <T> String foo(String bar) { return bar; }\n\tpublic void bar() {\n       System.out.println(\"abc\");\n       MR ref = @A X::foo;\n       ref.process(\"abc\");\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #47 @A(\n        target type = 0x46 METHOD_REFERENCE\n        offset = 8\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test066_codeblocks_methodReference() throws Exception {
        this.runConformTest(new String[]{"X.java", "interface I {\n    Object copy(int [] ia);\n}\npublic class X  {\n    public static void main(String [] args) {\n        I i = @B(1) int @B(2)[]::<String>clone;\n        i.copy(new int[10]); \n    }\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default -1;\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #30 @B(\n        #31 value=(int) 1 (constant type)\n        target type = 0x46 METHOD_REFERENCE\n        offset = 0\n        location = [ARRAY]\n      )\n      #30 @B(\n        #31 value=(int) 2 (constant type)\n        target type = 0x46 METHOD_REFERENCE\n        offset = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test067_codeblocks_constructorReferenceTypeArgument() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\ninterface MR { X process(String input); }\npublic class X<T> {\n   public X(T s) {};\n   public static <T> String foo(String bar) { return bar; }\n\tpublic void bar() {\n       System.out.println(\"abc\");\n       MR ref = X<String>::<@A String>new;\n       ref.process(\"abc\");\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #53 @A(\n        target type = 0x4a CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT\n        offset = 8\n        type argument index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test068_codeblocks_methodReferenceTypeArgument() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\ninterface MR { String process(String input); }\npublic class X<T> {\n   public static <T> String foo(String bar) { return bar; }\n\tpublic void bar() {\n       System.out.println(\"abc\");\n       MR ref = X::<@A String>foo;\n       ref.process(\"abc\");\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #47 @A(\n        target type = 0x4b METHOD_REFERENCE_TYPE_ARGUMENT\n        offset = 8\n        type argument index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test069_codeblocks_cast() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic void foo(Object o) {\n\t\tif (o instanceof String) {\n\t\t\tString tab = (@A String) o;\n\t\t\tSystem.out.println(tab);\n\t\t}\n\t\tSystem.out.println(o);\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #38 @A(\n        target type = 0x47 CAST\n        offset = 8\n        type argument index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test070_codeblocks_cast_complex() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "I.java", "interface I {}\n", "J.java", "interface J {}\n", "X.java", "public class X {\n\tpublic void foo(Object o) {\n\t\tif (o instanceof String[][]) {\n\t\t\tString[][] tab = (@C('_') @B(3) String[] @A[]) o;\n\t\t\tSystem.out.println(tab.length);\n\t\t}\n\t\tSystem.out.println(o);\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #37 @B(\n        #38 value=(int) 3 (constant type)\n        target type = 0x47 CAST\n        offset = 8\n        type argument index = 0\n        location = [ARRAY, ARRAY]\n      )\n    RuntimeVisibleTypeAnnotations: \n      #41 @C(\n        #38 value='_' (constant type)\n        target type = 0x47 CAST\n        offset = 8\n        type argument index = 0\n        location = [ARRAY, ARRAY]\n      )\n      #43 @A(\n        target type = 0x47 CAST\n        offset = 8\n        type argument index = 0\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test070a_codeblocks_castWithIntersectionCast() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n   public void foo(Object o) {\n\t  I i = (@B(1) I & J) o;\n\t  J j = (I & @B(2) J) o;\n   }\n}\ninterface I {}\ninterface J {}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default 1;\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #15 (Ljava/lang/Object;)V\n  // Stack: 1, Locals: 4\n  public void foo(java.lang.Object o);\n     0  aload_1 [o]\n     1  checkcast J [16]\n     4  checkcast I [18]\n     7  astore_2 [i]\n     8  aload_1 [o]\n     9  checkcast J [16]\n    12  checkcast I [18]\n    15  astore_3 [j]\n    16  return\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 8, line: 5]\n        [pc: 16, line: 6]\n      Local variable table:\n        [pc: 0, pc: 17] local: this index: 0 type: X\n        [pc: 0, pc: 17] local: o index: 1 type: java.lang.Object\n        [pc: 8, pc: 17] local: i index: 2 type: I\n        [pc: 16, pc: 17] local: j index: 3 type: J\n    RuntimeVisibleTypeAnnotations: \n      #27 @B(\n        #28 value=(int) 1 (constant type)\n        target type = 0x47 CAST\n        offset = 4\n        type argument index = 0\n      )\n      #27 @B(\n        #28 value=(int) 2 (constant type)\n        target type = 0x47 CAST\n        offset = 9\n        type argument index = 1\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test070b_codeblocks_castWithIntersectionCast() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n   public void foo(Object o) {\n     System.out.println(123);\n\t  I<String> i = (I<@B(1) String> & @B(2) J<String>) o;\n   }\n}\ninterface I<T> {}\ninterface J<T> {}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default 1;\n}\n"}, "");
        String expectedOutput = "  public void foo(java.lang.Object o);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  bipush 123\n     5  invokevirtual java.io.PrintStream.println(int) : void [22]\n     8  aload_1 [o]\n     9  checkcast J [28]\n    12  checkcast I [30]\n    15  astore_2 [i]\n    16  return\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 8, line: 5]\n        [pc: 16, line: 6]\n      Local variable table:\n        [pc: 0, pc: 17] local: this index: 0 type: X\n        [pc: 0, pc: 17] local: o index: 1 type: java.lang.Object\n        [pc: 16, pc: 17] local: i index: 2 type: I\n      Local variable type table:\n        [pc: 16, pc: 17] local: i index: 2 type: I<java.lang.String>\n    RuntimeVisibleTypeAnnotations: \n      #39 @B(\n        #40 value=(int) 2 (constant type)\n        target type = 0x47 CAST\n        offset = 9\n        type argument index = 1\n      )\n      #39 @B(\n        #40 value=(int) 1 (constant type)\n        target type = 0x47 CAST\n        offset = 12\n        type argument index = 0\n        location = [TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test070c_codeblocks_castTwiceInExpression() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n   public void foo(Object o) {\n     System.out.println(123);\n\t  I i = (@B(1) I)(@B(2) J) o;\n   }\n}\ninterface I {}\ninterface J {}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default 1;\n}\n"}, "");
        String expectedOutput = "     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  bipush 123\n     5  invokevirtual java.io.PrintStream.println(int) : void [22]\n     8  aload_1 [o]\n     9  checkcast J [28]\n    12  checkcast I [30]\n    15  astore_2 [i]\n    16  return\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 8, line: 5]\n        [pc: 16, line: 6]\n      Local variable table:\n        [pc: 0, pc: 17] local: this index: 0 type: X\n        [pc: 0, pc: 17] local: o index: 1 type: java.lang.Object\n        [pc: 16, pc: 17] local: i index: 2 type: I\n    RuntimeVisibleTypeAnnotations: \n      #37 @B(\n        #38 value=(int) 2 (constant type)\n        target type = 0x47 CAST\n        offset = 9\n        type argument index = 0\n      )\n      #37 @B(\n        #38 value=(int) 1 (constant type)\n        target type = 0x47 CAST\n        offset = 12\n        type argument index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test070d_codeblocks_castDoubleIntersectionCastInExpression() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.io.*;\npublic class X {\n   public void foo(Object o) {\n     System.out.println(123);\n\t  I i = (@B(1) I & J)(K & @B(2) L) o;\n   }\n}\ninterface I {}\ninterface J {}\ninterface K {}\ninterface L {}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default 1;\n}\n"}, "");
        String expectedOutput = "  public void foo(java.lang.Object o);\n     0  getstatic java.lang.System.out : java.io.PrintStream [16]\n     3  bipush 123\n     5  invokevirtual java.io.PrintStream.println(int) : void [22]\n     8  aload_1 [o]\n     9  checkcast L [28]\n    12  checkcast K [30]\n    15  checkcast J [32]\n    18  checkcast I [34]\n    21  astore_2 [i]\n    22  return\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 8, line: 5]\n        [pc: 22, line: 6]\n      Local variable table:\n        [pc: 0, pc: 23] local: this index: 0 type: X\n        [pc: 0, pc: 23] local: o index: 1 type: java.lang.Object\n        [pc: 22, pc: 23] local: i index: 2 type: I\n    RuntimeVisibleTypeAnnotations: \n      #41 @B(\n        #42 value=(int) 2 (constant type)\n        target type = 0x47 CAST\n        offset = 9\n        type argument index = 1\n      )\n      #41 @B(\n        #42 value=(int) 1 (constant type)\n        target type = 0x47 CAST\n        offset = 18\n        type argument index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test071_codeblocks_constructorInvocationTypeArgument() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "X.java", "public class X {\n\t<T> X(T t) {\n\t}\n\tpublic Object foo() {\n\t\tX x = new <@A @B(1) String>X(null);\n\t\treturn x;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #27 @B(\n        #28 value=(int) 1 (constant type)\n        target type = 0x48 CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT\n        offset = 5\n        type argument index = 0\n      )\n    RuntimeVisibleTypeAnnotations: \n      #31 @A(\n        target type = 0x48 CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT\n        offset = 5\n        type argument index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test072_codeblocks_constructorInvocationTypeArgument() throws Exception {
        this.runConformTest(new String[]{"A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n", "X.java", "public class X {\n\t<T, U> X(T t, U u) {\n\t}\n\tpublic Object foo() {\n\t\tX x = new <@A Integer, @A String @C [] @B(1)[]>X(null, null);\n\t\treturn x;\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #29 @B(\n        #30 value=(int) 1 (constant type)\n        target type = 0x48 CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT\n        offset = 6\n        type argument index = 1\n        location = [ARRAY]\n      )\n    RuntimeVisibleTypeAnnotations: \n      #33 @A(\n        target type = 0x48 CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT\n        offset = 6\n        type argument index = 0\n      )\n      #33 @A(\n        target type = 0x48 CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT\n        offset = 6\n        type argument index = 1\n        location = [ARRAY, ARRAY]\n      )\n      #34 @C(\n        target type = 0x48 CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT\n        offset = 6\n        type argument index = 1\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test073_codeblocks_constructorInvocationTypeArgument() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<T1, T2> {\n\tpublic void bar() {\n       new <String, @A T2>X();\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #19 @A(\n        target type = 0x48 CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT\n        offset = 3\n        type argument index = 1\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test074_codeblocks_constructorInvocationTypeArgument() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<T1,T2> {\n   public static void foo(int i) {}\n\tpublic void bar() {\n       new <java.util.List<@A String>, T2>X();\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #23 @A(\n        target type = 0x48 CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT\n        offset = 3\n        type argument index = 0\n        location = [TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test075_codeblocks_constructorInvocationTypeArgument() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n\tpublic void bar() {\n       new <@A T>X();\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #19 @A(\n        target type = 0x48 CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT\n        offset = 3\n        type argument index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test076_codeblocks_methodInvocationTypeArgument() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\n\tstatic <T, U> T foo(T t, U u) {\n\t\treturn t;\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(X.<@A @B(1) String[], @C('-') X>foo(new String[]{\"SUCCESS\"}, null)[0]);\n\t}\n}\n", "A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(CLASS)\n@interface B {\n\tint value() default -1;\n}", "C.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface C {\n\tchar value() default '-';\n}\n"}, "SUCCESS");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #48 @B(\n        #49 value=(int) 1 (constant type)\n        target type = 0x49 METHOD_INVOCATION_TYPE_ARGUMENT\n        offset = 13\n        type argument index = 0\n        location = [ARRAY]\n      )\n    RuntimeVisibleTypeAnnotations: \n      #52 @A(\n        target type = 0x49 METHOD_INVOCATION_TYPE_ARGUMENT\n        offset = 13\n        type argument index = 0\n        location = [ARRAY]\n      )\n      #53 @C(\n        #49 value='-' (constant type)\n        target type = 0x49 METHOD_INVOCATION_TYPE_ARGUMENT\n        offset = 13\n        type argument index = 1\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test077_codeblocks_methodInvocationTypeArgument() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<T1,T2> {\n   public static void foo(int i) {}\n\tpublic void bar() {\n       X.<String, @A T2>foo(42);\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #24 @A(\n        target type = 0x49 METHOD_INVOCATION_TYPE_ARGUMENT\n        offset = 2\n        type argument index = 1\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test078_codeblocks_methodInvocationTypeArgument() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<T1,T2> {\n   public static void foo(int i) {}\n\tpublic void bar() {\n       X.<java.util.List<@A String>, T2>foo(42);\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #24 @A(\n        target type = 0x49 METHOD_INVOCATION_TYPE_ARGUMENT\n        offset = 2\n        type argument index = 0\n        location = [TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test079_codeblocks_methodInvocationTypeArgument() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X<T> {\n   public static void foo(int i) {}\n\tpublic void bar() {\n       X.<@A T>foo(42);\n\t}\n}", "A.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface A {\n\tString value() default \"default\";\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #24 @A(\n        target type = 0x49 METHOD_INVOCATION_TYPE_ARGUMENT\n        offset = 2\n        type argument index = 0\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test080_multiuseAnnotations() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t @B(1) int foo() { return 0; }\n}", "B.java", "import java.lang.annotation.*;\n@Target({ElementType.METHOD, ElementType.TYPE_USE})\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default 99;\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleAnnotations: \n      #17 @B(\n        #18 value=(int) 1 (constant type)\n      )\n    RuntimeVisibleTypeAnnotations: \n      #17 @B(\n        #18 value=(int) 1 (constant type)\n        target type = 0x14 METHOD_RETURN\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test081_multiuseAnnotations() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\n@Target({ElementType.METHOD, ElementType.TYPE_USE})\n@interface Annot {\n\tint value() default 0;\n}\npublic class X {\n\t@Annot(4) public String foo() { return \"hello\"; }}"}, "");
        String expectedOutput = "    RuntimeInvisibleAnnotations: \n      #17 @Annot(\n        #18 value=(int) 4 (constant type)\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #17 @Annot(\n        #18 value=(int) 4 (constant type)\n        target type = 0x14 METHOD_RETURN\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test082_multiuseAnnotations() throws Exception {
        this.runConformTest(new String[]{"X.java", "@interface Annot {\r\n\tint value() default 0;\r\n}\r\npublic class X {\r\n\t@Annot(4)\r\n\tpublic void foo() {\r\n\t}\r\n}"}, "");
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 0, Locals: 1\n  public void foo();\n    0  return\n      Line numbers:\n        [pc: 0, line: 7]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n    RuntimeInvisibleAnnotations: \n      #16 @Annot(\n        #17 value=(int) 4 (constant type)\n      )\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test100_pqtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  java.util.@B(2) List<String> field2;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test100a_pqtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  java.util.@B(2) List<String>[] field3;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test100b_pqtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  java.util.List<@B(3) String>[] field3;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test100c_pqtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  java.util.List<String> @B(3)[] field3;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test100d_pqtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  java.util.@B(2) List<@B(5) String> @B(3)[]@B(4)[] field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n      #10 @B(\n        #11 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n      )\n      #10 @B(\n        #11 value=(int) 4 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n      #10 @B(\n        #11 value=(int) 5 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test100e_pqtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  java.util.Map.@B(2) Entry<String,String> field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test100f_pqtr() throws Exception {
        this.runConformTest(new String[]{"Foo.java", "class Foo {}\n", "Levels.java", "package one.two.three;\nclass Level1 { static class Level2 { class Level3 { class Level4 { class Level5<T> { } } } } }\n", "X.java", "package one.two.three;\nclass X {\n  one.two.three.Level1.Level2.@B(2) Level3.Level4.@B(3) Level5<String> instance;\n}\n", "B.java", "package one.two.three;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @one.two.three.B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [INNER_TYPE]\n      )\n      #10 @one.two.three.B(\n        #11 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [INNER_TYPE, INNER_TYPE, INNER_TYPE]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "one" + File.separator + "two" + File.separator + "three" + File.separator + "X.class", "one.two.three.X", expectedOutput, 4);
    }

    public void test100g_pqtr() throws Exception {
        this.runConformTest(new String[]{"Foo.java", "class Foo {}\n", "Levels.java", "package one.two.three;\nclass Level1 { static class Level2 { class Level3 { class Level4 { class Level5<T> { } } } } }\n", "X.java", "package one.two.three;\nclass X {\n  one.two.three.Level1.Level2.@B(2) Level3.Level4.@B(3) Level5<String>[][] instance;\n}\n", "B.java", "package one.two.three;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @one.two.three.B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE]\n      )\n      #10 @one.two.three.B(\n        #11 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, INNER_TYPE, INNER_TYPE]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "one" + File.separator + "two" + File.separator + "three" + File.separator + "X.class", "one.two.three.X", expectedOutput, 4);
    }

    public void test100h_pqtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  Level1.Level2.@B(2) Level3.Level4.@B(3) Level5<String>[][] instance;\n}\n", "Levels.java", "class Level1 { static class Level2 { class Level3 { class Level4 { class Level5<T> { } } } } }\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE]\n      )\n      #10 @B(\n        #11 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, INNER_TYPE, INNER_TYPE]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test100i_pqtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  Level1.Level2.Level3.Level4.Level5<@B(1) String>[][] instance;\n}\n", "Levels.java", "class Level1 { static class Level2 { class Level3 { class Level4 { class Level5<T> { } } } } }\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, INNER_TYPE, INNER_TYPE, TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test100j_pqtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  Level1.Level2.Level3<@B(1) String>.Level4.Level5<@B(2) String>[][] instance;\n}\n", "Levels.java", "class Level1 { static class Level2 { class Level3<Q> { class Level4 { class Level5<T> { } } } } }\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, TYPE_ARGUMENT(0)]\n      )\n      #10 @B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, INNER_TYPE, INNER_TYPE, TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test100k_pqtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  Level1.@B(5) Level2.Level3<@B(1) String>.Level4.Level5<@B(2) String>[][] instance;\n}\n", "Levels.java", "class Level1 { static class Level2 { class Level3<Q> { class Level4 { class Level5<T> { } } } } }\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 5 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n      #10 @B(\n        #11 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, TYPE_ARGUMENT(0)]\n      )\n      #10 @B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, INNER_TYPE, INNER_TYPE, TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test101a_qtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n    com.foo.@B(2) List field2;\n}\n", "List.java", "package com.foo;\npublic class List {}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test101b_qtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n  java.util.Map.@B(2) Entry field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test101c_qtr() throws Exception {
        this.runConformTest(new String[]{"Runner.java", "public class Runner {}\n", "B.java", "package one.two.three;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n", "X.java", "package one.two.three;\nclass X {\n    one.two.three.Level1.Level2.@B(2) Level3.Level4.@B(3) Level5 instance;\n}\n", "Level1.java", "package one.two.three;\npublic class Level1 { static class Level2 { class Level3 { class Level4 { class Level5 { } } } } }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @one.two.three.B(\n        #9 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [INNER_TYPE]\n      )\n      #8 @one.two.three.B(\n        #9 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [INNER_TYPE, INNER_TYPE, INNER_TYPE]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "one" + File.separator + "two" + File.separator + "three" + File.separator + "X.class", "one.two.three.X", expectedOutput, 4);
    }

    public void test102a_str() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n    @B(1) X field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test102b_str() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n    @B(1) int field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test103a_atr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n    @B(1) X[] field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test103b_atr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n    X @B(2)[] field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test103c_atr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n    X []@B(3)[] field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test103d_atr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n    X []@B(3)[][] field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test103e_atr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n    @B(1) int []@B(3)[][] field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @B(\n        #9 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, ARRAY]\n      )\n      #8 @B(\n        #9 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test104a_pstr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X<T1,T2,T3> {\n    @B(1) X<@B(2) String, @B(3) Integer, @B(4) Boolean> field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n      )\n      #10 @B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(0)]\n      )\n      #10 @B(\n        #11 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(1)]\n      )\n      #10 @B(\n        #11 value=(int) 4 (constant type)\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(2)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test104b_pstr() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X<T1> {\n    @B(1) X<@B(2) String> @B(3)[] field;\n}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n      #10 @B(\n        #11 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n      )\n      #10 @B(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test105a_aqtr() throws Exception {
        this.runConformTest(new String[]{"Y.java", "class Y {}", "X.java", "package one.two.three;\nclass X<T1> {\n    one.two.three.@B(1) List[] field;\n}\n", "List.java", "package one.two.three;\nclass List {}\n", "B.java", "package one.two.three;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @one.two.three.B(\n        #9 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "one" + File.separator + "two" + File.separator + "three" + File.separator + "X.class", "one.two.three.X", expectedOutput, 4);
    }

    public void test105b_aqtr() throws Exception {
        this.runConformTest(new String[]{"Y.java", "class Y {}", "X.java", "package one.two.three;\nclass X<T1> {\n    one.two.three.@B(2) List @B(3)[]@B(4)[] field;\n}\n", "List.java", "package one.two.three;\nclass List {}\n", "B.java", "package one.two.three;\nimport java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #8 @one.two.three.B(\n        #9 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n      #8 @one.two.three.B(\n        #9 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n      )\n      #8 @one.two.three.B(\n        #9 value=(int) 4 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "one" + File.separator + "two" + File.separator + "three" + File.separator + "X.class", "one.two.three.X", expectedOutput, 4);
    }

    public void test106a_wtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nclass X<T1> {\n\t List<? extends @B(1) Number> field;\n}\n", "List.java", "class List {}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(0), WILDCARD]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test106b_wtr() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\nclass X<T1> {\n\t List<? extends @B(1) Number[]> field;\n}\n", "List.java", "class List {}\n", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B { int value() default -1; }\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #10 @B(\n        #11 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [TYPE_ARGUMENT(0), WILDCARD, ARRAY]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void testAnnotatedRedundantCast() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n\t String s = (@NonNull String) \"Hello\";\n}\n", "NonNull.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface NonNull {}\n"}, "");
        String expectedOutput = "  // Method descriptor #8 ()V\n  // Stack: 2, Locals: 1\n  X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [10]\n     4  aload_0 [this]\n     5  ldc <String \"Hello\"> [12]\n     7  checkcast java.lang.String [14]\n    10  putfield X.s : java.lang.String [16]\n    13  return\n      Line numbers:\n        [pc: 0, line: 1]\n        [pc: 4, line: 2]\n        [pc: 13, line: 1]\n      Local variable table:\n        [pc: 0, pc: 14] local: this index: 0 type: X\n    RuntimeVisibleTypeAnnotations: \n      #23 @NonNull(\n        target type = 0x47 CAST\n        offset = 7\n        type argument index = 0\n      )\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void testAnnotatedRedundantCast2() throws Exception {
        this.runConformTest(new String[]{"X.java", "class X {\n\t String s = (String) \"Hello\";\n}\n", "NonNull.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface NonNull {}\n"}, "");
        String expectedOutput = "  // Method descriptor #8 ()V\n  // Stack: 2, Locals: 1\n  X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [10]\n     4  aload_0 [this]\n     5  ldc <String \"Hello\"> [12]\n     7  putfield X.s : java.lang.String [14]\n    10  return\n      Line numbers:\n        [pc: 0, line: 1]\n        [pc: 4, line: 2]\n        [pc: 10, line: 1]\n      Local variable table:\n        [pc: 0, pc: 11] local: this index: 0 type: X\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test055a_codeblocks_exceptionParameterNestedType() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n         foo();\n\t\t} catch(@B(1) Outer.@B(2) MyException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n   static void foo() throws Outer.MyException {}\n}\nclass Outer {\n\tclass MyException extends Exception {\n\t\tprivate static final long serialVersionUID = 1L;\n\t}\n}", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default 0;\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #30 @B(\n        #31 value=(int) 1 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n      #30 @B(\n        #31 value=(int) 2 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n        location = [INNER_TYPE]\n      )\n  \n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test055b_codeblocks_exceptionParameterMultiCatchNestedType() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n         foo();\n\t\t} catch(@B(1) Outer.@B(2) MyException | @B(3) Outer2.@B(4) MyException2 e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n   static void foo() throws Outer.MyException, Outer2.MyException2 {}\n}\nclass Outer {\n\tclass MyException extends Exception {\n\t\tprivate static final long serialVersionUID = 1L;\n\t}\n}\nclass Outer2 {\n\tclass MyException2 extends Exception {\n\t\tprivate static final long serialVersionUID = 1L;\n\t}\n}", "B.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface B {\n\tint value() default 0;\n}\n"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #34 @B(\n        #35 value=(int) 1 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n      #34 @B(\n        #35 value=(int) 2 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n        location = [INNER_TYPE]\n      )\n      #34 @B(\n        #35 value=(int) 3 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 1\n      )\n      #34 @B(\n        #35 value=(int) 4 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 1\n        location = [INNER_TYPE]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test055c_codeblocks_exceptionParameterMultiCatch() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\nclass Exc1 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\nclass Exc2 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\nclass Exc3 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println(42);\n\t\t} catch(Exc1 | @B(1) Exc2 | @B(2) Exc3 t) {\n\t\t\tt.printStackTrace();\n\t\t}\n\t}\n}", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface B {\n\tint value() default 99;\n}\n"}, "42");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #45 @B(\n        #46 value=(int) 1 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 1\n      )\n      #45 @B(\n        #46 value=(int) 2 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 2\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test055d_codeblocks_exceptionParameterMultiCatch() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\nclass Exc1 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\nclass Exc2 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\nclass Exc3 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println(42);\n\t\t} catch(@A(1) @B(2) Exc1 | Exc2 | @A(3) @B(4) Exc3 t) {\n\t\t\tt.printStackTrace();\n\t\t}\n\t}\n}", "A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tint value() default 99;\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface B {\n\tint value() default 99;\n}\n"}, "42");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #45 @A(\n        #46 value=(int) 1 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n      #48 @B(\n        #46 value=(int) 2 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n      #45 @A(\n        #46 value=(int) 3 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 2\n      )\n      #48 @B(\n        #46 value=(int) 4 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 2\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test055e_codeblocks_exceptionParameterMultiCatch() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\nclass Exc1 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\nclass Exc2 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\nclass Exc3 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println(42);\n\t\t} catch(@A(1) @B(2) Exc1 | Exc2 | @A(3) @B(4) Exc3 t) {\n\t\t\tt.printStackTrace();\n\t\t}\n\t}\n}", "A.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface A {\n\tint value() default 99;\n}\n", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface B {\n\tint value() default 99;\n}\n"}, "42");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #45 @A(\n        #46 value=(int) 1 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n      #48 @B(\n        #46 value=(int) 2 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n      #45 @A(\n        #46 value=(int) 3 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 2\n      )\n      #48 @B(\n        #46 value=(int) 4 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 2\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test055f_codeblocks_exceptionParameterComplex() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\nclass Exc1 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\nclass Exc2 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\nclass Exc3 extends RuntimeException {    private static final long serialVersionUID = 1L;\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tSystem.out.println(42);\n\t\t} catch(@B(1) Exc1 | Exc2 | @B(2) Exc3 t) {\n\t\t\tt.printStackTrace();\n\t\t}\n\t\ttry {\n\t\t\tSystem.out.println(43);\n\t\t} catch(@B(1) Exc1 t) {\n\t\t\tt.printStackTrace();\n\t\t}\n\t\ttry {\n\t\t\tSystem.out.println(44);\n\t\t} catch(@B(1) Exc1 | @B(2) Exc2 t) {\n\t\t\tt.printStackTrace();\n\t\t}\n\t}\n}", "B.java", "import java.lang.annotation.Target;\nimport static java.lang.annotation.ElementType.*;\nimport java.lang.annotation.Retention;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface B {\n\tint value() default 99;\n}\n"}, "42\n43\n44");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #47 @B(\n        #48 value=(int) 1 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 0\n      )\n      #47 @B(\n        #48 value=(int) 2 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 2\n      )\n      #47 @B(\n        #48 value=(int) 1 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 3\n      )\n      #47 @B(\n        #48 value=(int) 1 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 4\n      )\n      #47 @B(\n        #48 value=(int) 2 (constant type)\n        target type = 0x42 EXCEPTION_PARAMETER\n        exception table index = 5\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void testBug415911() {
        this.runNegativeTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE)\n@interface Marker {\n}\n\npublic class X {\n    @Marker\n    foo(String s) {\n\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tfoo(String s) {\n\t^^^^^^^^^^^^^\nReturn type for the method is missing\n----------\n");
    }

    public void testBug426616() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Retention(RUNTIME)\n@Target(TYPE_USE)\n@interface SizeHolder { Size[] value();}\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@Repeatable(SizeHolder.class)\n@interface Size { int max(); }\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface Nonnull {}\n\npublic class X {\n   public static void main(String[]argv) {}\n\tpublic static String testArrays() {\n\t\tList<@Size(max = 41) CharSequence>[] @Size(max = 42) [] @Nonnull @Size(max = 43) [][] test = new @Size(max = 44) ArrayList @Size(max = 45) [10][][] @Size(max = 47) @Size(max = 48) [];\n\t\treturn (@Size(max = 49) String) test[0][1][2][3].get(0);\n\t}\n}"}, "");
        String expectedOutput = "    RuntimeVisibleTypeAnnotations: \n      #33 @Size(\n        #34 max=(int) 44 (constant type)\n        target type = 0x44 NEW\n        offset = 2\n        location = [ARRAY, ARRAY, ARRAY, ARRAY]\n      )\n      #33 @Size(\n        #34 max=(int) 45 (constant type)\n        target type = 0x44 NEW\n        offset = 2\n      )\n      #37 @SizeHolder(\n        #38 value=[\n          annotation value =\n              #33 @Size(\n                #34 max=(int) 47 (constant type)\n              )\n          annotation value =\n              #33 @Size(\n                #34 max=(int) 48 (constant type)\n              )\n          ]\n        target type = 0x44 NEW\n        offset = 2\n        location = [ARRAY, ARRAY, ARRAY]\n      )\n      #33 @Size(\n        #34 max=(int) 49 (constant type)\n        target type = 0x47 CAST\n        offset = 24\n        type argument index = 0\n      )\n      #33 @Size(\n        #34 max=(int) 42 (constant type)\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 6, pc: 28] index: 0\n        location = [ARRAY]\n      )\n      #43 @Nonnull(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 6, pc: 28] index: 0\n        location = [ARRAY, ARRAY]\n      )\n      #33 @Size(\n        #34 max=(int) 43 (constant type)\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 6, pc: 28] index: 0\n        location = [ARRAY, ARRAY]\n      )\n      #33 @Size(\n        #34 max=(int) 41 (constant type)\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 6, pc: 28] index: 0\n        location = [ARRAY, ARRAY, ARRAY, ARRAY, TYPE_ARGUMENT(0)]\n      )\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void testBug426616a() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.util.*;\nimport java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\nimport static java.lang.annotation.RetentionPolicy.*;\n@Retention(RUNTIME)\n@Target(TYPE_USE)\n@interface SizeHolder { Size[] value();}\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@Repeatable(SizeHolder.class)\n@interface Size { int max(); }\n@Target(TYPE_USE)\n@Retention(RUNTIME)\n@interface Nonnull {}\n\npublic class X {\n   List<@Size(max = 41) CharSequence>[] @Size(max = 42) [] @Nonnull @Size(max = 43) [][] test = new @Size(max = 44) ArrayList @Size(max = 45) [10][][] @Size(max = 47) @Size(max = 48) [];\n   public static void main(String[]argv) {}\n}"}, "");
        String expectedOutput = "  // Field descriptor #6 [[[[Ljava/util/List;\n  // Signature: [[[[Ljava/util/List<Ljava/lang/CharSequence;>;\n  java.util.List[][][][] test;\n    RuntimeVisibleTypeAnnotations: \n      #10 @Size(\n        #11 max=(int) 42 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n      #13 @Nonnull(\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n      #10 @Size(\n        #11 max=(int) 43 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n      #10 @Size(\n        #11 max=(int) 41 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, ARRAY, ARRAY, TYPE_ARGUMENT(0)]\n      )\n  \n  // Method descriptor #17 ()V\n  // Stack: 2, Locals: 1\n  public X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [19]\n     4  aload_0 [this]\n     5  bipush 10\n     7  anewarray java.util.ArrayList[][][] [21]\n    10  putfield X.test : java.util.List[][][][] [23]\n    13  return\n      Line numbers:\n        [pc: 0, line: 16]\n        [pc: 4, line: 17]\n        [pc: 13, line: 16]\n      Local variable table:\n        [pc: 0, pc: 14] local: this index: 0 type: X\n    RuntimeVisibleTypeAnnotations: \n      #10 @Size(\n        #11 max=(int) 44 (constant type)\n        target type = 0x44 NEW\n        offset = 7\n        location = [ARRAY, ARRAY, ARRAY, ARRAY]\n      )\n      #10 @Size(\n        #11 max=(int) 45 (constant type)\n        target type = 0x44 NEW\n        offset = 7\n      )\n      #31 @SizeHolder(\n        #32 value=[\n          annotation value =\n              #10 @Size(\n                #11 max=(int) 47 (constant type)\n              )\n          annotation value =\n              #10 @Size(\n                #11 max=(int) 48 (constant type)\n              )\n          ]\n        target type = 0x44 NEW\n        offset = 7\n        location = [ARRAY, ARRAY, ARRAY]\n      )\n  \n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void testTypeVariable() {
        this.runNegativeTest(new String[]{"X.java", "public class X<@Missing T> {\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X<@Missing T> {\n\t                ^^^^^^^\nMissing cannot be resolved to a type\n----------\n");
    }

    public void test417660() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Documented;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\npublic class X {\n  int bar(int [] @TakeType(int[].class)[] x) { \n\t  return x[0][0]; \n  } \n  public static void main(String[] args) {\n\tSystem.out.println(new X().bar(new int [][] { { 1234 }}));\n  }\n}\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@Documented\n@interface TakeType {\n\tClass value() default int[].class;\n}\n"}, "1234");
    }

    public void test417660b() {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Documented;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.RetentionPolicy;\nimport java.lang.annotation.Target;\npublic class X {\n  int bar(int [][] @TakeType(int[].class)[][] x @TakeType(int[].class)[]) { \n\t  return x[0][0][0][0][0]; \n  } \n  public static void main(String[] args) {\n\tSystem.out.println(new X().bar(new int [][][][][] { { { { { 1234 } } } } }));\n  }\n}\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@Documented\n@interface TakeType {\n\tClass value() default int[].class;\n}\n"}, "1234");
    }

    public void testAnnotatedExtendedDimensions() throws Exception {
        this.runConformTest(new String[]{"X.java", "public class X {\n\t@NonNull String @Nullable [] f @NonNull [] = null;\n\tstatic @NonNull String @Nullable [] foo(@NonNull String @Nullable [] p @NonNull []) @NonNull [] {\n\t\tp = null;\n\t\t@NonNull String @Nullable [] l @NonNull [] = null;\n       return p;\n\t}\n}\n", "NonNull.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface NonNull {}\n", "Nullable.java", "import java.lang.annotation.*;\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@interface Nullable {}\n"}, "");
        String expectedOutput = "  // Field descriptor #6 [[Ljava/lang/String;\n  java.lang.String[][] f;\n    RuntimeVisibleTypeAnnotations: \n      #8 @NonNull(\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n      #9 @Nullable(\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n      #8 @NonNull(\n        target type = 0x13 FIELD\n      )\n  \n  // Method descriptor #11 ()V\n  // Stack: 2, Locals: 1\n  public X();\n     0  aload_0 [this]\n     1  invokespecial java.lang.Object() [13]\n     4  aload_0 [this]\n     5  aconst_null\n     6  putfield X.f : java.lang.String[][] [15]\n     9  return\n      Line numbers:\n        [pc: 0, line: 1]\n        [pc: 4, line: 2]\n        [pc: 9, line: 1]\n      Local variable table:\n        [pc: 0, pc: 10] local: this index: 0 type: X\n  \n  // Method descriptor #22 ([[Ljava/lang/String;)[[Ljava/lang/String;\n  // Stack: 1, Locals: 2\n  static java.lang.String[][] foo(java.lang.String[][] p);\n    0  aconst_null\n    1  astore_0 [p]\n    2  aconst_null\n    3  astore_1 [l]\n    4  aload_0 [p]\n    5  areturn\n      Line numbers:\n        [pc: 0, line: 4]\n        [pc: 2, line: 5]\n        [pc: 4, line: 6]\n      Local variable table:\n        [pc: 0, pc: 6] local: p index: 0 type: java.lang.String[][]\n        [pc: 4, pc: 6] local: l index: 1 type: java.lang.String[][]\n    RuntimeVisibleTypeAnnotations: \n      #8 @NonNull(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 4, pc: 6] index: 1\n        location = [ARRAY, ARRAY]\n      )\n      #9 @Nullable(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 4, pc: 6] index: 1\n        location = [ARRAY]\n      )\n      #8 @NonNull(\n        target type = 0x40 LOCAL_VARIABLE\n        local variable entries:\n          [pc: 4, pc: 6] index: 1\n      )\n    RuntimeVisibleTypeAnnotations: \n      #8 @NonNull(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n        location = [ARRAY, ARRAY]\n      )\n      #9 @Nullable(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n        location = [ARRAY]\n      )\n      #8 @NonNull(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n      #8 @NonNull(\n        target type = 0x14 METHOD_RETURN\n        location = [ARRAY, ARRAY]\n      )\n      #9 @Nullable(\n        target type = 0x14 METHOD_RETURN\n        location = [ARRAY]\n      )\n      #8 @NonNull(\n        target type = 0x14 METHOD_RETURN\n      )\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void testPQTRArray() throws Exception {
        this.runConformTest(new String[]{"Outer.java", "public class Outer<K>  {\n\tclass Inner<P> {\n\t}\n\tpublic @T(1) Outer<@T(2) String>.@T(3) Inner<@T(4) Integer> @T(5) [] omi @T(6) [];\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface T {\n\tint value();\n}\n"}, "");
        String expectedOutput = "  public Outer$Inner[][] omi;\n    RuntimeInvisibleTypeAnnotations: \n      #10 @T(\n        #11 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n      #10 @T(\n        #11 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE]\n      )\n      #10 @T(\n        #11 value=(int) 5 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n      #10 @T(\n        #11 value=(int) 6 (constant type)\n        target type = 0x13 FIELD\n      )\n      #10 @T(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, TYPE_ARGUMENT(0)]\n      )\n      #10 @T(\n        #11 value=(int) 4 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, TYPE_ARGUMENT(0)]\n      )\n  \n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "Outer.class", "Outer", expectedOutput, 4);
    }

    public void testPQTRArray2() throws Exception {
        this.runConformTest(new String[]{"Outer.java", "public class Outer<K1, K2>  {\n\tclass Inner<P1, P2> {\n\t}\n\tpublic @T(1) Outer<@T(2) String, @T(3) Inner>.@T(4) Inner<@T(5) Integer, @T(6) Outer.@T(7) Inner> @T(7) [] omi @T(8) [];\n}\n@java.lang.annotation.Target (java.lang.annotation.ElementType.TYPE_USE)\n@interface T {\n\tint value();\n}\n"}, "");
        String expectedOutput = "  // Field descriptor #6 [[LOuter$Inner;\n  // Signature: [[LOuter<Ljava/lang/String;LOuter$Inner;>.Inner<Ljava/lang/Integer;LOuter$Inner;>;\n  public Outer$Inner[][] omi;\n    RuntimeInvisibleTypeAnnotations: \n      #10 @T(\n        #11 value=(int) 1 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY]\n      )\n      #10 @T(\n        #11 value=(int) 4 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE]\n      )\n      #10 @T(\n        #11 value=(int) 7 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY]\n      )\n      #10 @T(\n        #11 value=(int) 8 (constant type)\n        target type = 0x13 FIELD\n      )\n      #10 @T(\n        #11 value=(int) 2 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, TYPE_ARGUMENT(0)]\n      )\n      #10 @T(\n        #11 value=(int) 3 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, TYPE_ARGUMENT(1), INNER_TYPE]\n      )\n      #10 @T(\n        #11 value=(int) 5 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, TYPE_ARGUMENT(0)]\n      )\n      #10 @T(\n        #11 value=(int) 6 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, TYPE_ARGUMENT(1)]\n      )\n      #10 @T(\n        #11 value=(int) 7 (constant type)\n        target type = 0x13 FIELD\n        location = [ARRAY, ARRAY, INNER_TYPE, TYPE_ARGUMENT(1), INNER_TYPE]\n      )\n  \n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "Outer.class", "Outer", expectedOutput, 4);
    }

    public void testConstructorResult() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\n@interface T {\n}\npublic class X {\n\t@T X() {}\n\tclass Y {\n\t @T Y () {\n\t}\n\t}\n}\n"}, "");
        String expectedOutput = "  // Method descriptor #6 ()V\n  // Stack: 1, Locals: 1\n  X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [8]\n    4  return\n      Line numbers:\n        [pc: 0, line: 7]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n    RuntimeInvisibleTypeAnnotations: \n      #15 @T(\n        target type = 0x14 METHOD_RETURN\n      )\n\n";
        String expectedOutForY = "  // Method descriptor #8 (LX;)V\n  // Stack: 2, Locals: 2\n  X$Y(X arg0);\n     0  aload_0 [this]\n     1  aload_1 [arg0]\n     2  putfield X$Y.this$0 : X [10]\n     5  aload_0 [this]\n     6  invokespecial java.lang.Object() [12]\n     9  return\n      Line numbers:\n        [pc: 0, line: 9]\n        [pc: 9, line: 10]\n      Local variable table:\n        [pc: 0, pc: 10] local: this index: 0 type: X.Y\n    RuntimeInvisibleTypeAnnotations: \n      #20 @T(\n        target type = 0x14 METHOD_RETURN\n        location = [INNER_TYPE]\n      )\n\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X$Y.class", "Y", expectedOutForY, 4);
    }

    public void test418347() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Target({TYPE_USE}) @interface P { }\n@Target({TYPE_USE}) @interface O { }\n@Target({TYPE_USE}) @interface I { }\npublic abstract class X<T> {\n\tclass Y<Q> {\n\t}\n\tvoid foo(@P Y<P> p) {}\n}\n"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #24 @P(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n        location = [INNER_TYPE]\n      )\n\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test418347a() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.*;\nimport static java.lang.annotation.ElementType.*;\n@Target({TYPE_USE}) @interface P { }\n@Target({TYPE_USE}) @interface O { }\n@Target({TYPE_USE}) @interface I { }\npublic abstract class X {\n\tclass Y {\n\t\tclass Z {}\n\t}\n\tvoid foo(@P X.@O Y.@I Z[] p) {}\n}\n"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #19 @P(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n        location = [ARRAY]\n      )\n      #20 @O(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n        location = [ARRAY, INNER_TYPE]\n      )\n      #21 @I(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n        location = [ARRAY, INNER_TYPE, INNER_TYPE]\n      )\n\n";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test418347b() throws Exception {
        this.runConformTest(new String[]{"X.java", "public abstract class X {\n\tjava.util.List [][] l = new java.util.ArrayList @pkg.NonNull [0] @pkg.NonNull[];     \n}\n", "pkg/NonNull.java", "package pkg;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE)\npublic @interface NonNull {\n}\n"}, "");
        String expectedOutput = "    RuntimeInvisibleTypeAnnotations: \n      #21 @pkg.NonNull(\n        target type = 0x44 NEW\n        offset = 6\n      )\n      #21 @pkg.NonNull(\n        target type = 0x44 NEW\n        offset = 6\n        location = [ARRAY]\n      )\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void testForwardReference() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.JavacHasWarningsEclipseNotConfigured, new String[]{"T.java", "import java.lang.annotation.Annotation;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@R(TC.class)\n@Target(ElementType.TYPE_PARAMETER)\n@interface T {\n}\n\ninterface I<@T K> {\n}\n\n@Deprecated\n@interface TC {\n\n}\n\n@Target(ElementType.ANNOTATION_TYPE)\n@interface R {\n    Class<? extends Annotation> value();\n}\n"}, "");
    }

    public void testHybridTargets() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target({ElementType.TYPE_USE, ElementType.PACKAGE})\n@interface T {\n}\n@T\npublic class X {\n    @T\n    X() {}\n    @T String x;\n    @T \n\tint foo(@T int p) { \n      @T int l;\n\t   return 0;\n   }\n}\n"}, "");
        String expectedOutput = "  // Field descriptor #6 Ljava/lang/String;\n  java.lang.String x;\n    RuntimeInvisibleTypeAnnotations: \n      #8 @T(\n        target type = 0x13 FIELD\n      )\n  \n  // Method descriptor #10 ()V\n  // Stack: 1, Locals: 1\n  X();\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [12]\n    4  return\n      Line numbers:\n        [pc: 0, line: 9]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n    RuntimeInvisibleTypeAnnotations: \n      #8 @T(\n        target type = 0x14 METHOD_RETURN\n      )\n  \n  // Method descriptor #19 (I)I\n  // Stack: 1, Locals: 2\n  int foo(int p);\n    0  iconst_0\n    1  ireturn\n      Line numbers:\n        [pc: 0, line: 14]\n      Local variable table:\n        [pc: 0, pc: 2] local: this index: 0 type: X\n        [pc: 0, pc: 2] local: p index: 1 type: int\n    RuntimeInvisibleTypeAnnotations: \n      #8 @T(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n      #8 @T(\n        target type = 0x14 METHOD_RETURN\n      )\n\n  RuntimeInvisibleAnnotations: \n    #8 @T(\n    )\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void testHybridTargets2() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\n@Target({ ElementType.TYPE_USE, ElementType.METHOD })\n@interface SillyAnnotation {  }\npublic class X {\n   @SillyAnnotation\n   X(@SillyAnnotation int x) {\n   }\n\t@SillyAnnotation\n\tvoid foo(@SillyAnnotation int x) {\n\t}\n\t@SillyAnnotation\n\tString goo(@SillyAnnotation int x) {\n\t\treturn null;\n\t}\n\t@SillyAnnotation\n\tX field;\n}\n"}, "");
        String expectedOutput = "  // Field descriptor #6 LX;\n  X field;\n    RuntimeInvisibleTypeAnnotations: \n      #8 @SillyAnnotation(\n        target type = 0x13 FIELD\n      )\n  \n  // Method descriptor #10 (I)V\n  // Stack: 1, Locals: 2\n  X(int x);\n    0  aload_0 [this]\n    1  invokespecial java.lang.Object() [12]\n    4  return\n      Line numbers:\n        [pc: 0, line: 7]\n        [pc: 4, line: 8]\n      Local variable table:\n        [pc: 0, pc: 5] local: this index: 0 type: X\n        [pc: 0, pc: 5] local: x index: 1 type: int\n    RuntimeInvisibleTypeAnnotations: \n      #8 @SillyAnnotation(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n      #8 @SillyAnnotation(\n        target type = 0x14 METHOD_RETURN\n      )\n  \n  // Method descriptor #10 (I)V\n  // Stack: 0, Locals: 2\n  void foo(int x);\n    0  return\n      Line numbers:\n        [pc: 0, line: 11]\n      Local variable table:\n        [pc: 0, pc: 1] local: this index: 0 type: X\n        [pc: 0, pc: 1] local: x index: 1 type: int\n    RuntimeInvisibleAnnotations: \n      #8 @SillyAnnotation(\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #8 @SillyAnnotation(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n  \n  // Method descriptor #23 (I)Ljava/lang/String;\n  // Stack: 1, Locals: 2\n  java.lang.String goo(int x);\n    0  aconst_null\n    1  areturn\n      Line numbers:\n        [pc: 0, line: 14]\n      Local variable table:\n        [pc: 0, pc: 2] local: this index: 0 type: X\n        [pc: 0, pc: 2] local: x index: 1 type: int\n    RuntimeInvisibleAnnotations: \n      #8 @SillyAnnotation(\n      )\n    RuntimeInvisibleTypeAnnotations: \n      #8 @SillyAnnotation(\n        target type = 0x16 METHOD_FORMAL_PARAMETER\n        method parameter index = 0\n      )\n      #8 @SillyAnnotation(\n        target type = 0x14 METHOD_RETURN\n      )\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void testDeprecated() throws Exception {
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Deprecated\n@Target(ElementType.TYPE_USE)\n@interface X {\n\tint value() default 0;\n}\n"}, "");
        String expectedOutput = "// Compiled from X.java (version 1.8 : 52.0, no super bit, deprecated)\nabstract @interface X extends java.lang.annotation.Annotation {\n  Constant pool:\n    constant #1 class: #2 X\n    constant #2 utf8: \"X\"\n    constant #3 class: #4 java/lang/Object\n    constant #4 utf8: \"java/lang/Object\"\n    constant #5 class: #6 java/lang/annotation/Annotation\n    constant #6 utf8: \"java/lang/annotation/Annotation\"\n    constant #7 utf8: \"value\"\n    constant #8 utf8: \"()I\"\n    constant #9 utf8: \"AnnotationDefault\"\n    constant #10 integer: 0\n    constant #11 utf8: \"SourceFile\"\n    constant #12 utf8: \"X.java\"\n    constant #13 utf8: \"Deprecated\"\n    constant #14 utf8: \"RuntimeVisibleAnnotations\"\n    constant #15 utf8: \"Ljava/lang/Deprecated;\"\n    constant #16 utf8: \"Ljava/lang/annotation/Target;\"\n    constant #17 utf8: \"Ljava/lang/annotation/ElementType;\"\n    constant #18 utf8: \"TYPE_USE\"\n  \n  // Method descriptor #8 ()I\n  public abstract int value();\n    Annotation Default: \n      (int) 0 (constant type)\n\n  RuntimeVisibleAnnotations: \n    #15 @java.lang.Deprecated(\n    )\n    #16 @java.lang.annotation.Target(\n      #7 value=[\n        java.lang.annotation.ElementType.TYPE_USE(enum type #17.#18)\n        ]\n    )\n}";
        this.checkDisassembledClassFile(String.valueOf(OUTPUT_DIR) + File.separator + "X.class", "X", expectedOutput, 4);
    }

    public void test421148() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n@Target(ElementType.TYPE_USE) @interface T {}\npublic class X {\n\tpublic static void main(String argv[]) {\n\t\tObject o = (@T Object) new Object();    \n       System.out.println(\"OK\");\n\t}\n}\n"}, "OK", customOptions);
    }

    public void test421620() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.Documented;\nimport java.lang.annotation.Retention;\nimport java.lang.annotation.Target;\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.RetentionPolicy;\nclass E1 extends Exception {\n    private static final long serialVersionUID = 1L;\n}\n\n@Target(ElementType.TYPE_USE)\n@Retention(RetentionPolicy.RUNTIME)\n@Documented\n@interface NonCritical { }\npublic class X {\n    @NonCritical E1 e1; // looks like this field's type binding is reused\n//wrong error:\n//Cannot use the parameterized type E1 either in catch block or throws clause\n    void f1 (int a) throws /*@NonCritical*/ E1 {\n        throw new E1();\n    }\n    void foo() {\n        try {\n            f1(0);\n//wrong error: Unreachable catch block for E1.\n//             This exception is never thrown from the try statement body\n        } catch (@NonCritical final RuntimeException | @NonCritical E1 ex) {\n            System.out.println(ex);\n        }\n    }\n    public static void main(String[] args) {\n\t\tSystem.out.println(\"OK\");\n\t}\n}\n"}, "OK", customOptions);
    }

    public void _test425599() {
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        this.runConformTest(new String[]{"X.java", "import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\npublic class X {\n    Object ax = new @A Outer().new Middle<String>();\n    public static void main(String args[]) {\n        System.out.println(\"OK\");\n    }\n}\n@Target(ElementType.TYPE_USE) @interface A {}\nclass Outer {\n    class Middle<E> {\n    \tclass Inner<I> {}\n    \t@A Middle<Object>.@A Inner<Character> ax = new pack.@A Outer().new @A Middle<@A Object>().new @A Inner<@A Character>(null);\n    }\n}\n"}, "OK", customOptions);
    }

    public void testBug485386() {
        this.runConformTest(new String[]{"Test.java", "import java.lang.annotation.*;\nimport java.lang.reflect.*;\n\n@Retention(value = RetentionPolicy.RUNTIME)\n@java.lang.annotation.Target(ElementType.TYPE_USE)\n@interface TestAnn1 {\n  String value() default \"1\";\n}\n\npublic class Test {\n\n  class Inner {\n    public @TestAnn1() Inner() {\n      System.out.println(\"New\");\n    }\n  }\n\n  public void test() throws SecurityException, NoSuchMethodException {\n    Executable f = Test.Inner.class.getDeclaredConstructor(Test.class);\n    AnnotatedType ae = f.getAnnotatedReturnType();\n    Object o = ae.getAnnotation(TestAnn1.class);\n    System.out.println(o);\n  }\n  \n  public static void main(String... args) throws Exception {\n    new Test().test();\n  }\n}\n"}, "@TestAnn1(value=" + this.decorateAnnotationValueLiteral("1") + ")");
    }

    public void testBug492322readFromClass() {
        this.runConformTest(new String[]{"test1/Base.java", "package test1;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE) @interface A2 {}\n@Target(ElementType.TYPE_USE) @interface A3 {}\n@Target(ElementType.TYPE_USE) @interface A4 {}\n@Target(ElementType.TYPE_USE) @interface A5 {}\n@Target(ElementType.TYPE_USE) @interface A6 {}\n@Target(ElementType.TYPE_USE) @interface A7 {}\n@Target(ElementType.TYPE_USE) @interface A8 {}\n@Target(ElementType.TYPE_USE) @interface B1 {}\n@Target(ElementType.TYPE_USE) @interface B2 {}\n@Target(ElementType.TYPE_USE) @interface B3 {}\n@Target(ElementType.TYPE_USE) @interface C1 {}\n@Target(ElementType.TYPE_USE) @interface C2 {}\n\npublic abstract class Base {\n  static public class Static {\n   public class Middle1 {\n     public class Middle2<M> {\n       public class Middle3 {\n        public class GenericInner<T> {\n        }\n       }\n     }\n   }\n  }\n\n  public Object method1(Base.@A2 Static.@A3 Middle1.@A4 Middle2<Object>.@A5 Middle3.@A6 GenericInner<String> nullable) {\n    return new Object();\n  }\n  public Object method2(Base.@A2 Static.@A3 Middle1.@A4 Middle2<@B1 Object>.@A5 Middle3.@A6 GenericInner<@B2 String> @A7 [] @A8 [] nullable) {\n    return new Object();\n  }\n  public Object method3(Base.@A2 Static.@A3 Middle1.@A4 Middle2<@B1 Class<@C1 Object @C2 []> @B2 []>.@A5 Middle3.@A6 GenericInner<@B3 String> @A7 [] @A8 [] nullable) {\n    return new Object();\n  }\n}\n"});
        Requestor requestor = new Requestor(false, null, false, false);
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        Compiler compiler = new Compiler(this.getNameEnvironment(new String[0], null), this.getErrorHandlingPolicy(), new CompilerOptions(customOptions), (ICompilerRequestor)requestor, this.getProblemFactory());
        char[][] compoundName = new char[][]{"test1".toCharArray(), "Base".toCharArray()};
        ReferenceBinding type = compiler.lookupEnvironment.askForType((char[][])compoundName, compiler.lookupEnvironment.UnNamedModule);
        TypeAnnotationTest.assertNotNull((Object)type);
        MethodBinding[] methods1 = type.getMethods("method1".toCharArray());
        TypeAnnotationTest.assertEquals("Base.@A2 Static.@A3 Middle1.@A4 Middle2<Object>.@A5 Middle3.@A6 GenericInner<String>", new String(methods1[0].parameters[0].annotatedDebugName()));
        MethodBinding[] methods2 = type.getMethods("method2".toCharArray());
        TypeAnnotationTest.assertEquals("Base.@A2 Static.@A3 Middle1.@A4 Middle2<@B1 Object>.@A5 Middle3.@A6 GenericInner<@B2 String> @A7 [] @A8 []", new String(methods2[0].parameters[0].annotatedDebugName()));
        MethodBinding[] methods3 = type.getMethods("method3".toCharArray());
        TypeAnnotationTest.assertEquals("Base.@A2 Static.@A3 Middle1.@A4 Middle2<@B1 Class<@C1 Object @C2 []> @B2 []>.@A5 Middle3.@A6 GenericInner<@B3 String> @A7 [] @A8 []", new String(methods3[0].parameters[0].annotatedDebugName()));
    }

    public void testBug492322readFromClassWithGenericBase() {
        this.runConformTest(new String[]{"test1/Base.java", "package test1;\n\nimport java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\n@Target(ElementType.TYPE_USE) @interface A2 {}\n@Target(ElementType.TYPE_USE) @interface A3 {}\n@Target(ElementType.TYPE_USE) @interface A4 {}\n@Target(ElementType.TYPE_USE) @interface A5 {}\n@Target(ElementType.TYPE_USE) @interface A6 {}\n@Target(ElementType.TYPE_USE) @interface A7 {}\n@Target(ElementType.TYPE_USE) @interface A8 {}\n@Target(ElementType.TYPE_USE) @interface B1 {}\n@Target(ElementType.TYPE_USE) @interface B2 {}\n@Target(ElementType.TYPE_USE) @interface B3 {}\n@Target(ElementType.TYPE_USE) @interface C1 {}\n@Target(ElementType.TYPE_USE) @interface C2 {}\n\npublic abstract class Base<B> {\n  static public class Static {\n   public class Middle1 {\n     public class Middle2<M> {\n       public class Middle3 {\n        public class GenericInner<T> {\n        }\n       }\n     }\n   }\n  }\n\n  public Object method1(Base.@A2 Static.@A3 Middle1.@A4 Middle2<Object>.@A5 Middle3.@A6 GenericInner<String> nullable) {\n    return new Object();\n  }\n  public Object method2(Base.@A2 Static.@A3 Middle1.@A4 Middle2<@B1 Object>.@A5 Middle3.@A6 GenericInner<@B2 String> @A7 [] @A8 [] nullable) {\n    return new Object();\n  }\n  public Object method3(Base.@A2 Static.@A3 Middle1.@A4 Middle2<@B1 Class<@C1 Object @C2 []> @B2 []>.@A5 Middle3.@A6 GenericInner<@B3 String> @A7 [] @A8 [] nullable) {\n    return new Object();\n  }\n}\n"});
        Requestor requestor = new Requestor(false, null, false, false);
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        Compiler compiler = new Compiler(this.getNameEnvironment(new String[0], null), this.getErrorHandlingPolicy(), new CompilerOptions(customOptions), (ICompilerRequestor)requestor, this.getProblemFactory());
        char[][] compoundName = new char[][]{"test1".toCharArray(), "Base".toCharArray()};
        ReferenceBinding type = compiler.lookupEnvironment.askForType((char[][])compoundName, compiler.lookupEnvironment.UnNamedModule);
        TypeAnnotationTest.assertNotNull((Object)type);
        MethodBinding[] methods1 = type.getMethods("method1".toCharArray());
        TypeAnnotationTest.assertEquals("Base.@A2 Static.@A3 Middle1.@A4 Middle2<Object>.@A5 Middle3.@A6 GenericInner<String>", new String(methods1[0].parameters[0].annotatedDebugName()));
        MethodBinding[] methods2 = type.getMethods("method2".toCharArray());
        TypeAnnotationTest.assertEquals("Base.@A2 Static.@A3 Middle1.@A4 Middle2<@B1 Object>.@A5 Middle3.@A6 GenericInner<@B2 String> @A7 [] @A8 []", new String(methods2[0].parameters[0].annotatedDebugName()));
        MethodBinding[] methods3 = type.getMethods("method3".toCharArray());
        TypeAnnotationTest.assertEquals("Base.@A2 Static.@A3 Middle1.@A4 Middle2<@B1 Class<@C1 Object @C2 []> @B2 []>.@A5 Middle3.@A6 GenericInner<@B3 String> @A7 [] @A8 []", new String(methods3[0].parameters[0].annotatedDebugName()));
    }

    public void testBug492322WithOldBinary() {
        Requestor requestor = new Requestor(false, null, false, false);
        Map customOptions = this.getCompilerOptions();
        customOptions.put("org.eclipse.jdt.core.compiler.storeAnnotations", "enabled");
        String[] defaultClassPaths = this.getDefaultClassPaths();
        String jarpath = String.valueOf(this.getCompilerTestsPluginDirectoryPath()) + File.separator + "workspace" + File.separator + "bug492322-compiled-with-4.6.jar";
        String[] paths = new String[defaultClassPaths.length + 1];
        System.arraycopy(defaultClassPaths, 0, paths, 0, defaultClassPaths.length);
        paths[defaultClassPaths.length] = jarpath;
        Compiler compiler = new Compiler(this.getNameEnvironment(new String[0], paths), this.getErrorHandlingPolicy(), new CompilerOptions(customOptions), (ICompilerRequestor)requestor, this.getProblemFactory());
        char[][] compoundName = new char[][]{"test1".toCharArray(), "Base".toCharArray()};
        ReferenceBinding type = compiler.lookupEnvironment.askForType((char[][])compoundName, compiler.lookupEnvironment.UnNamedModule);
        TypeAnnotationTest.assertNotNull((Object)type);
        MethodBinding[] methods1 = type.getMethods("method1".toCharArray());
        TypeAnnotationTest.assertEquals("Base.Static.@A2 Static2<Exception>.@A3 Middle1.@A4 Middle2<Object>.@A5 Middle3.@A6 GenericInner<String>", new String(methods1[0].parameters[0].annotatedDebugName()));
        MethodBinding[] methods2 = type.getMethods("method2".toCharArray());
        TypeAnnotationTest.assertEquals("Base.Static.@A2 Static2<@B1 Exception>.@A3 Middle1.@A4 Middle2<@B2 Object>.@A5 Middle3.@A6 GenericInner<@B3 String> @A7 [] @A8 []", new String(methods2[0].parameters[0].annotatedDebugName()));
        MethodBinding[] methods3 = type.getMethods("method3".toCharArray());
        TypeAnnotationTest.assertEquals("Base.Static.@A2 Static2<@B1 Exception>.@A3 Middle1.@A4 Middle2<@B2 Class<@C1 Object @C2 []> @B3 []>.@A5 Middle3.@A6 GenericInner<@B4 String> @A7 [] @A8 []", new String(methods3[0].parameters[0].annotatedDebugName()));
    }
}

