/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import junit.framework.Test;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.tests.eval.EvaluationTest;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.eval.GlobalVariable;

public class NegativeVariableTest
extends EvaluationTest
implements ProblemSeverities,
ProblemReasons {
    public NegativeVariableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return NegativeVariableTest.setupSuite(NegativeVariableTest.testClass());
    }

    public static Class testClass() {
        return NegativeVariableTest.class;
    }

    public void testInitializerProblem() {
        GlobalVariable var = null;
        try {
            var = this.context.newVariable("int".toCharArray(), "i".toCharArray(), this.buildCharArray(new String[]{"(1 + 1) *", "(j + 2)"}));
            this.evaluateWithExpectedProblem(var, (CategorizedProblem)this.newProblem(33554515, 1, 11, 11, 2));
        }
        catch (Throwable throwable) {
            if (var != null) {
                this.context.deleteVariable(var);
            }
            throw throwable;
        }
        if (var != null) {
            this.context.deleteVariable(var);
        }
        GlobalVariable var1 = null;
        GlobalVariable var2 = null;
        try {
            var1 = this.context.newVariable("Object".toCharArray(), "o".toCharArray(), "new Object()".toCharArray());
            var2 = this.context.newVariable("int".toCharArray(), "i".toCharArray(), this.buildCharArray(new String[]{"(1 + 1) *", "(1 ++ 2)"}));
            this.evaluateWithExpectedProblem(var2, (CategorizedProblem)this.newProblem(1610612942, 1, 11, 11, 2));
        }
        catch (Throwable throwable) {
            if (var1 != null) {
                this.context.deleteVariable(var1);
            }
            if (var2 != null) {
                this.context.deleteVariable(var2);
            }
            throw throwable;
        }
        if (var1 != null) {
            this.context.deleteVariable(var1);
        }
        if (var2 != null) {
            this.context.deleteVariable(var2);
        }
    }

    public void _testInvalidName() {
        GlobalVariable var = null;
        try {
            var = this.context.newVariable("int".toCharArray(), "!@#$%^&*()_".toCharArray(), "1".toCharArray());
            this.evaluateWithExpectedProblem(var, (CategorizedProblem)this.newProblem(1610612969, 1, 0, 9, 0));
        }
        catch (Throwable throwable) {
            if (var != null) {
                this.context.deleteVariable(var);
            }
            throw throwable;
        }
        if (var != null) {
            this.context.deleteVariable(var);
        }
        GlobalVariable var1 = null;
        GlobalVariable var2 = null;
        try {
            var1 = this.context.newVariable("String".toCharArray(), "foo".toCharArray(), "\"bar\"".toCharArray());
            var2 = this.context.newVariable("int".toCharArray(), "!@#$%^&*()_".toCharArray(), "1".toCharArray());
            this.evaluateWithExpectedProblem(var2, (CategorizedProblem)this.newProblem(1610612969, 1, 0, 9, 0));
        }
        catch (Throwable throwable) {
            if (var1 != null) {
                this.context.deleteVariable(var1);
            }
            if (var2 != null) {
                this.context.deleteVariable(var2);
            }
            throw throwable;
        }
        if (var1 != null) {
            this.context.deleteVariable(var1);
        }
        if (var2 != null) {
            this.context.deleteVariable(var2);
        }
    }

    public void testUnknownType() {
        GlobalVariable var = null;
        try {
            var = this.context.newVariable("foo.Bar".toCharArray(), "var".toCharArray(), null);
            this.evaluateWithExpectedProblem(var, (CategorizedProblem)this.newProblem(0x1000002, 1, 0, 2, -1));
        }
        catch (Throwable throwable) {
            if (var != null) {
                this.context.deleteVariable(var);
            }
            throw throwable;
        }
        if (var != null) {
            this.context.deleteVariable(var);
        }
        GlobalVariable var1 = null;
        GlobalVariable var2 = null;
        try {
            var1 = this.context.newVariable("int".toCharArray(), "x".toCharArray(), null);
            var2 = this.context.newVariable("foo.Bar".toCharArray(), "var".toCharArray(), null);
            this.evaluateWithExpectedProblem(var2, (CategorizedProblem)this.newProblem(0x1000002, 1, 0, 2, -1));
        }
        catch (Throwable throwable) {
            if (var1 != null) {
                this.context.deleteVariable(var1);
            }
            if (var2 != null) {
                this.context.deleteVariable(var2);
            }
            throw throwable;
        }
        if (var1 != null) {
            this.context.deleteVariable(var1);
        }
        if (var2 != null) {
            this.context.deleteVariable(var2);
        }
    }
}

