/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.eval.EvaluationTest;
import org.eclipse.jdt.internal.eval.EvaluationResult;
import org.eclipse.jdt.internal.eval.GlobalVariable;
import org.eclipse.jdt.internal.eval.IRequestor;
import org.eclipse.jdt.internal.eval.InstallException;

public class SanityTestEvaluationContext
extends EvaluationTest {
    public SanityTestEvaluationContext(String name) {
        super(name);
    }

    public static Test suite() {
        return SanityTestEvaluationContext.setupSuite(SanityTestEvaluationContext.testClass());
    }

    public void testAllVariables() {
        GlobalVariable[] vars = this.context.allVariables();
        SanityTestEvaluationContext.assertEquals((String)"No variables should be defined", (int)0, (int)vars.length);
        this.context.newVariable("int".toCharArray(), "foo".toCharArray(), "1".toCharArray());
        this.context.newVariable("Object".toCharArray(), "bar".toCharArray(), null);
        this.context.newVariable("String".toCharArray(), "zip".toCharArray(), "\"abcdefg\"".toCharArray());
        vars = this.context.allVariables();
        SanityTestEvaluationContext.assertEquals((String)"3 variables should be defined", (int)3, (int)vars.length);
        this.assertEquals("1st variable", "foo".toCharArray(), vars[0].getName());
        this.assertEquals("2nd variable", "bar".toCharArray(), vars[1].getName());
        this.assertEquals("3rd variable", "zip".toCharArray(), vars[2].getName());
        this.context.deleteVariable(vars[1]);
        vars = this.context.allVariables();
        SanityTestEvaluationContext.assertEquals((String)"2 variables should be defined", (int)2, (int)vars.length);
        this.assertEquals("1st variable", "foo".toCharArray(), vars[0].getName());
        this.assertEquals("2nd variable", "zip".toCharArray(), vars[1].getName());
        this.context.deleteVariable(vars[1]);
        vars = this.context.allVariables();
        SanityTestEvaluationContext.assertEquals((String)"1 variable should be defined", (int)1, (int)vars.length);
        this.assertEquals("1st variable", "foo".toCharArray(), vars[0].getName());
        this.context.deleteVariable(vars[0]);
        vars = this.context.allVariables();
        SanityTestEvaluationContext.assertEquals((String)"No variables should be defined", (int)0, (int)vars.length);
    }

    public static Class testClass() {
        return SanityTestEvaluationContext.class;
    }

    public void testEvaluate() {
        EvaluationTest.Requestor requestor = new EvaluationTest.Requestor();
        char[] snippet = "return 1;".toCharArray();
        try {
            this.context.evaluate(snippet, this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
        }
        catch (InstallException e) {
            SanityTestEvaluationContext.assertTrue((String)("No targetException " + e.getMessage()), (boolean)false);
        }
        SanityTestEvaluationContext.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
        EvaluationResult result = requestor.results[0];
        SanityTestEvaluationContext.assertTrue((String)"No problems with the code snippet", (!result.hasProblems() ? 1 : 0) != 0);
        SanityTestEvaluationContext.assertTrue((String)"Result has a value", (boolean)result.hasValue());
        this.assertEquals("Value", "1".toCharArray(), result.getValueDisplayString());
        this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
    }

    public void testEvaluateImports() {
        try {
            this.context.setImports((char[][])new char[][]{"java.util.*".toCharArray(), "java.lang.reflect.Method".toCharArray()});
            EvaluationTest.Requestor requestor = new EvaluationTest.Requestor(this){

                @Override
                public void acceptResult(EvaluationResult result) {
                    SanityTestEvaluationContext.assertTrue((String)"No problems with the imports", (!result.hasProblems() ? 1 : 0) != 0);
                }
            };
            this.context.evaluateImports(this.getEnv(), (IRequestor)requestor, this.getProblemFactory());
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testEvaluateVariable() {
        GlobalVariable var = null;
        try {
            var = this.context.newVariable("int".toCharArray(), "foo".toCharArray(), "1".toCharArray());
            try {
                class NoPbRequestor
                extends EvaluationTest.Requestor {
                    NoPbRequestor() {
                    }

                    @Override
                    public void acceptResult(EvaluationResult result) {
                        SanityTestEvaluationContext.assertTrue((String)"No problems with the variable", (!result.hasProblems() ? 1 : 0) != 0);
                    }
                }
                this.context.evaluateVariables(this.getEnv(), this.getCompilerOptions(), (IRequestor)new NoPbRequestor(), this.getProblemFactory());
            }
            catch (InstallException e) {
                SanityTestEvaluationContext.assertTrue((String)("No targetException " + e.getMessage()), (boolean)false);
            }
            EvaluationTest.Requestor requestor = new EvaluationTest.Requestor();
            try {
                this.context.evaluateVariable(var, this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            }
            catch (InstallException e) {
                SanityTestEvaluationContext.assertTrue((String)("No targetException " + e.getMessage()), (boolean)false);
            }
            SanityTestEvaluationContext.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            SanityTestEvaluationContext.assertTrue((String)"Result has value", (boolean)result.hasValue());
            this.assertEquals("Value", "1".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        catch (Throwable throwable) {
            if (var != null) {
                this.context.deleteVariable(var);
            }
            throw throwable;
        }
        if (var != null) {
            this.context.deleteVariable(var);
        }
    }

    public void testEvaluateVariables() {
        GlobalVariable var = null;
        try {
            var = this.context.newVariable("int".toCharArray(), "foo".toCharArray(), "1".toCharArray());
            EvaluationTest.Requestor requestor = new EvaluationTest.Requestor();
            try {
                this.context.evaluateVariables(this.getEnv(), this.getCompilerOptions(), (IRequestor)requestor, this.getProblemFactory());
            }
            catch (InstallException e) {
                SanityTestEvaluationContext.assertTrue((String)("No targetException " + e.getMessage()), (boolean)false);
            }
            SanityTestEvaluationContext.assertTrue((String)"Got one result", (requestor.resultIndex == 0 ? 1 : 0) != 0);
            EvaluationResult result = requestor.results[0];
            SanityTestEvaluationContext.assertTrue((String)"No problems with the variable", (!result.hasProblems() ? 1 : 0) != 0);
            SanityTestEvaluationContext.assertTrue((String)"Result has value", (boolean)result.hasValue());
            this.assertEquals("Value", "1".toCharArray(), result.getValueDisplayString());
            this.assertEquals("Type", "int".toCharArray(), result.getValueTypeName());
        }
        catch (Throwable throwable) {
            if (var != null) {
                this.context.deleteVariable(var);
            }
            throw throwable;
        }
        if (var != null) {
            this.context.deleteVariable(var);
        }
    }

    public void testGetSetImports() {
        try {
            SanityTestEvaluationContext.assertTrue((String)"No imports defined", (this.context.getImports().length == 0 ? 1 : 0) != 0);
            char[][] imports = new char[][]{"java.util".toCharArray(), "java.lang.reflect.Method".toCharArray()};
            this.context.setImports((char[][])imports);
            char[][] storedImports = this.context.getImports();
            SanityTestEvaluationContext.assertEquals((String)"Same length", (int)imports.length, (int)storedImports.length);
            int i = 0;
            while (i < imports.length) {
                this.assertEquals("Import #" + i, imports[i], storedImports[i]);
                ++i;
            }
        }
        finally {
            this.context.setImports((char[][])new char[0][]);
        }
    }

    public void testGetSetPackageName() {
        try {
            SanityTestEvaluationContext.assertTrue((String)"Default package", (this.context.getPackageName().length == 0 ? 1 : 0) != 0);
            char[] packageName = "x.y.z".toCharArray();
            this.context.setPackageName(packageName);
            char[] storedPackageName = this.context.getPackageName();
            this.assertEquals("Same package name", packageName, storedPackageName);
        }
        finally {
            this.context.setPackageName(new char[0]);
        }
    }

    public void testNewDeleteVariable() {
        GlobalVariable var = this.context.newVariable("int".toCharArray(), "deleted".toCharArray(), null);
        this.context.deleteVariable(var);
        GlobalVariable[] vars = this.context.allVariables();
        int i = 0;
        while (i < vars.length) {
            SanityTestEvaluationContext.assertTrue((String)"Variable should not exist", (!var.getName().equals(vars[i].getName()) ? 1 : 0) != 0);
            ++i;
        }
    }
}

