/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jdt.core.tests.runtime.AbstractReader;

class ProxyConsoleReader
extends AbstractReader {
    private InputStream input;
    private OutputStream output;

    public ProxyConsoleReader(String name, InputStream input, String fileName) {
        super(name);
        this.input = input;
        if (fileName.equals("con")) {
            this.output = System.out;
        } else {
            try {
                this.output = new FileOutputStream(fileName);
            }
            catch (IOException iOException) {
                System.out.println("Could not create file " + fileName + ". Redirecting to stdout");
                this.output = System.out;
            }
        }
    }

    @Override
    protected void readerLoop() {
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            while (!this.isStopping && read != -1) {
                read = this.input.read(buffer);
                if (read == -1) continue;
                this.output.write(buffer, 0, read);
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public void stop() {
        super.stop();
        try {
            if (this.output != System.out) {
                this.output.close();
            }
        }
        catch (IOException iOException) {}
    }
}

