/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.jdt.core.tests.util.Util;

public class StandardVMLauncher
extends LocalVMLauncher {
    String batchFileName;
    private boolean isJrtBasedVM;

    public StandardVMLauncher(boolean isJrtBasedVM) {
        this.isJrtBasedVM = isJrtBasedVM;
    }

    public StandardVMLauncher() {
    }

    protected String buildBootClassPath() {
        StringBuffer bootPathString = new StringBuffer();
        char pathSeparator = File.pathSeparatorChar;
        if (this.bootPath != null) {
            int length = this.bootPath.length;
            int i = 0;
            while (i < length) {
                bootPathString.append(this.bootPath[i]);
                bootPathString.append(pathSeparator);
                ++i;
            }
        } else if (!this.isJrtBasedVM) {
            bootPathString.append(this.vmPath);
            bootPathString.append(File.separator);
            if (!this.vmPath.toLowerCase().endsWith("jre") && !this.vmPath.toLowerCase().endsWith("jre" + File.separator)) {
                bootPathString.append("jre");
                bootPathString.append(File.separator);
            }
            bootPathString.append("lib");
            bootPathString.append(File.separator);
            bootPathString.append("rt.jar");
            bootPathString.append(pathSeparator);
        }
        if (this.evalTargetPath != null) {
            bootPathString.append(this.evalTargetPath);
            bootPathString.append(File.separatorChar);
            bootPathString.append("bootPath");
        }
        return bootPathString.toString();
    }

    public String getBatchFileName() {
        return this.batchFileName;
    }

    @Override
    public String[] getCommandLine() {
        Object[] result;
        long vmVersion;
        Vector<String> commandLine = new Vector<String>();
        StringBuffer vmLocation = new StringBuffer(this.vmPath);
        vmLocation.append(this.vmPath.endsWith(File.separator) ? "" : File.separator).append("bin").append(File.separator).append("java");
        commandLine.addElement(String.valueOf(vmLocation));
        if (this.vmArguments != null) {
            int i = 0;
            while (i < this.vmArguments.length) {
                commandLine.addElement(this.vmArguments[i]);
                ++i;
            }
        }
        if ((vmVersion = Util.getMajorMinorVMVersion()) != -1L) {
            if (vmVersion >= 0x320000L) {
                commandLine.addElement("-XX:-FailOverToOldVerifier");
                commandLine.addElement("-Xverify:all");
            }
            if (vmVersion >= 0x330000L) {
                commandLine.addElement("-XX:+UnlockExperimentalVMOptions");
            }
        }
        if (this.debugPort != -1) {
            commandLine.addElement("-Xdebug");
            commandLine.addElement("-Xnoagent");
            commandLine.addElement("-Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=n");
        }
        commandLine.addElement("-Xbootclasspath/a:" + this.buildBootClassPath());
        commandLine.addElement("-classpath");
        commandLine.addElement(this.buildClassPath());
        if (this.evalPort != -1) {
            commandLine.addElement("org.eclipse.jdt.core.tests.eval.target.CodeSnippetRunner");
        }
        if (this.evalPort != -1) {
            commandLine.addElement("-evalport");
            commandLine.addElement(Integer.toString(this.evalPort));
            commandLine.addElement("-cscp");
            commandLine.addElement(String.valueOf(this.evalTargetPath) + File.separator + "regularPath");
            commandLine.addElement("-csbp");
            commandLine.addElement(String.valueOf(this.evalTargetPath) + File.separator + "bootPath");
        }
        if (this.programClass != null) {
            commandLine.addElement(this.programClass);
        }
        if (this.programArguments != null) {
            int i = 0;
            while (i < this.programArguments.length) {
                commandLine.addElement(this.programArguments[i]);
                ++i;
            }
        }
        if (this.batchFileName != null) {
            this.writeBatchFile(this.batchFileName, commandLine);
            result = new String[]{this.batchFileName};
        } else {
            result = new String[commandLine.size()];
            commandLine.copyInto(result);
        }
        int i = 0;
        while (i < result.length) {
            Object argument = result[i];
            if (((String)argument).indexOf(32) != -1) {
                result[i] = "\"" + (String)argument + "\"";
            }
            ++i;
        }
        return result;
    }

    public void setBatchFileName(String batchFileName) {
        this.batchFileName = batchFileName;
    }

    protected void writeBatchFile(String fileName, Vector commandLine) {
        block15: {
            FileOutputStream output = null;
            try {
                try {
                    output = new FileOutputStream(fileName);
                    PrintWriter out = new PrintWriter(output);
                    Enumeration e = commandLine.elements();
                    while (e.hasMoreElements()) {
                        out.print((String)e.nextElement());
                        out.print(" ");
                    }
                    out.println("pause");
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

