/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.tests.compiler.regression.RegressionTestSetup;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.core.tests.util.CompilerTestSetup;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class AbstractCompilerTest
extends TestCase {
    public static final int F_1_3 = 1;
    public static final int F_1_4 = 2;
    public static final int F_1_5 = 4;
    public static final int F_1_6 = 8;
    public static final int F_1_7 = 16;
    public static final int F_1_8 = 32;
    public static final int F_9 = 64;
    public static final boolean RUN_JAVAC = "enabled".equals(System.getProperty("run.javac"));
    private static final int UNINITIALIZED = -1;
    private static final int NONE = 0;
    private static int possibleComplianceLevels = -1;
    protected long complianceLevel;
    protected boolean enableAPT = false;
    protected static boolean isJRE9 = false;
    protected IPath outputRootDirectoryPath = new Path(Util.getOutputDirectory());
    protected File outputTestDirectory;
    protected static Map TESTS_COUNTERS = new HashMap();

    public static Test buildAllCompliancesTestSuite(Class evaluationTestClass) {
        TestSuite suite = new TestSuite(evaluationTestClass.getName());
        AbstractCompilerTest.buildAllCompliancesTestSuite(suite, evaluationTestClass);
        return suite;
    }

    public static void buildAllCompliancesTestSuite(TestSuite suite, Class evaluationTestClass) {
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        if ((complianceLevels & 1) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x2F0000L));
        }
        if ((complianceLevels & 2) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x300000L));
        }
        if ((complianceLevels & 4) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x310000L));
        }
        if ((complianceLevels & 8) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x320000L));
        }
        if ((complianceLevels & 0x10) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x330000L));
        }
        if ((complianceLevels & 0x20) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x340000L));
        }
        if ((complianceLevels & 0x40) != 0) {
            suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x350000L));
        }
    }

    public static Test buildAllCompliancesTestSuite(Class testSuiteClass, Class setupClass, List testClasses) {
        TestSuite suite = new TestSuite(testSuiteClass.getName());
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        if ((complianceLevels & 1) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, 0x2F0000L));
        }
        if ((complianceLevels & 2) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, 0x300000L));
        }
        if ((complianceLevels & 4) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, 0x310000L));
        }
        if ((complianceLevels & 8) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, 0x320000L));
        }
        if ((complianceLevels & 0x10) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, 0x330000L));
        }
        if ((complianceLevels & 0x20) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, 0x340000L));
        }
        if ((complianceLevels & 0x40) != 0) {
            suite.addTest(AbstractCompilerTest.buildComplianceTestSuite(testClasses, setupClass, 0x350000L));
        }
        return suite;
    }

    public static void setpossibleComplianceLevels(int complianceLevel) {
        possibleComplianceLevels = complianceLevel;
    }

    public static Test buildComplianceTestSuite(long complianceLevel, List testClasses) {
        return AbstractCompilerTest.buildComplianceTestSuite(testClasses, RegressionTestSetup.class, complianceLevel);
    }

    private static Test buildComplianceTestSuite(List testClasses, Class setupClass, long complianceLevel) {
        TestSuite complianceSuite = null;
        try {
            Constructor constructor = setupClass.getConstructor(Long.TYPE);
            complianceSuite = (TestSuite)constructor.newInstance(new Long(complianceLevel));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (complianceSuite == null) {
            return null;
        }
        int i = 0;
        int m = testClasses.size();
        while (i < m) {
            Class testClass = (Class)testClasses.get(i);
            TestSuite suite = new TestSuite(testClass.getName());
            List tests = AbstractCompilerTest.buildTestsList(testClass);
            int index = 0;
            int size = tests.size();
            while (index < size) {
                suite.addTest((Test)tests.get(index));
                ++index;
            }
            complianceSuite.addTest((Test)suite);
            ++i;
        }
        return complianceSuite;
    }

    public static Test buildMinimalComplianceTestSuite(Class evaluationTestClass, int minimalCompliance) {
        int level19;
        int level18;
        int level17;
        int level16;
        int level15;
        int level14;
        TestSuite suite = new TestSuite(evaluationTestClass.getName());
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        int level13 = complianceLevels & 1;
        if (level13 != 0) {
            if (level13 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + CompilerOptions.versionFromJdkLevel((long)0x2F0000L) + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x2F0000L));
            }
        }
        if ((level14 = complianceLevels & 2) != 0) {
            if (level14 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + CompilerOptions.versionFromJdkLevel((long)0x300000L) + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x300000L));
            }
        }
        if ((level15 = complianceLevels & 4) != 0) {
            if (level15 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + CompilerOptions.versionFromJdkLevel((long)0x310000L) + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x310000L));
            }
        }
        if ((level16 = complianceLevels & 8) != 0) {
            if (level16 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + CompilerOptions.versionFromJdkLevel((long)0x320000L) + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x320000L));
            }
        }
        if ((level17 = complianceLevels & 0x10) != 0) {
            if (level17 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + CompilerOptions.versionFromJdkLevel((long)0x330000L) + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x330000L));
            }
        }
        if ((level18 = complianceLevels & 0x20) != 0) {
            if (level18 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + CompilerOptions.versionFromJdkLevel((long)0x340000L) + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x340000L));
            }
        }
        if ((level19 = complianceLevels & 0x40) != 0) {
            if (level19 < minimalCompliance) {
                System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + CompilerOptions.versionFromJdkLevel((long)0x350000L) + "!");
            } else {
                suite.addTest(AbstractCompilerTest.buildUniqueComplianceTestSuite(evaluationTestClass, 0x350000L));
            }
        }
        return suite;
    }

    public static Test buildUniqueComplianceTestSuite(Class evaluationTestClass, long uniqueCompliance) {
        long highestLevel = AbstractCompilerTest.highestComplianceLevels();
        if (highestLevel < uniqueCompliance) {
            String complianceString = highestLevel == 0x350000L ? "9" : (highestLevel == 0x340000L ? "1.8" : (highestLevel == 0x330000L ? "1.7" : (highestLevel == 0x320000L ? "1.6" : (highestLevel == 0x310000L ? "1.5" : (highestLevel == 0x300000L ? "1.4" : (highestLevel == 0x2F0000L ? "1.3" : "unknown"))))));
            System.err.println("Cannot run " + evaluationTestClass.getName() + " at compliance " + complianceString + "!");
            return new TestSuite();
        }
        RegressionTestSetup complianceSuite = new RegressionTestSetup(uniqueCompliance);
        List tests = AbstractCompilerTest.buildTestsList(evaluationTestClass);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            complianceSuite.addTest((Test)tests.get(index));
            ++index;
        }
        return complianceSuite;
    }

    public static long highestComplianceLevels() {
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        if ((complianceLevels & 0x40) != 0) {
            return 0x350000L;
        }
        if ((complianceLevels & 0x20) != 0) {
            return 0x340000L;
        }
        if ((complianceLevels & 0x10) != 0) {
            return 0x330000L;
        }
        if ((complianceLevels & 8) != 0) {
            return 0x320000L;
        }
        if ((complianceLevels & 4) != 0) {
            return 0x310000L;
        }
        if ((complianceLevels & 2) != 0) {
            return 0x300000L;
        }
        return 0x2F0000L;
    }

    public static int getPossibleComplianceLevels() {
        if (possibleComplianceLevels == -1) {
            String specVersion = System.getProperty("java.specification.version");
            isJRE9 = "9".equals(specVersion);
            String compliance = System.getProperty("compliance");
            if (compliance != null) {
                if ("1.3".equals(compliance)) {
                    possibleComplianceLevels = RUN_JAVAC ? 0 : 1;
                } else if ("1.4".equals(compliance)) {
                    possibleComplianceLevels = RUN_JAVAC ? 0 : 2;
                } else if ("1.5".equals(compliance)) {
                    possibleComplianceLevels = 4;
                } else if ("1.6".equals(compliance)) {
                    possibleComplianceLevels = 8;
                } else if ("1.7".equals(compliance)) {
                    possibleComplianceLevels = 16;
                } else if ("1.8".equals(compliance)) {
                    possibleComplianceLevels = 32;
                } else if ("9".equals(compliance)) {
                    possibleComplianceLevels = 64;
                } else {
                    System.out.println("Invalid compliance specified (" + compliance + ")");
                    System.out.print("Use one of ");
                    System.out.print("1.3, ");
                    System.out.print("1.4, ");
                    System.out.print("1.5, ");
                    System.out.print("1.6, ");
                    System.out.print("1.7, ");
                    System.out.print("1.8, ");
                    System.out.println("9");
                    System.out.println("Defaulting to all possible compliances");
                }
            }
            if (possibleComplianceLevels == -1) {
                if (!RUN_JAVAC) {
                    boolean canRun9;
                    boolean canRun1_8;
                    boolean canRun1_7;
                    boolean canRun1_6;
                    boolean canRun1_5;
                    boolean canRun1_4;
                    possibleComplianceLevels = 1;
                    boolean bl = canRun1_4 = !"1.0".equals(specVersion) && !"1.1".equals(specVersion) && !"1.2".equals(specVersion) && !"1.3".equals(specVersion);
                    if (canRun1_4) {
                        possibleComplianceLevels |= 2;
                    }
                    boolean bl2 = canRun1_5 = canRun1_4 && !"1.4".equals(specVersion);
                    if (canRun1_5) {
                        possibleComplianceLevels |= 4;
                    }
                    boolean bl3 = canRun1_6 = canRun1_5 && !"1.5".equals(specVersion);
                    if (canRun1_6) {
                        possibleComplianceLevels |= 8;
                    }
                    boolean bl4 = canRun1_7 = canRun1_6 && !"1.6".equals(specVersion);
                    if (canRun1_7) {
                        possibleComplianceLevels |= 0x10;
                    }
                    boolean bl5 = canRun1_8 = canRun1_7 && !"1.7".equals(specVersion);
                    if (canRun1_8) {
                        possibleComplianceLevels |= 0x20;
                    }
                    boolean bl6 = canRun9 = canRun1_8 && !"1.8".equals(specVersion);
                    if (canRun9) {
                        possibleComplianceLevels |= 0x40;
                    }
                } else if ("1.0".equals(specVersion) || "1.1".equals(specVersion) || "1.2".equals(specVersion) || "1.3".equals(specVersion) || "1.4".equals(specVersion)) {
                    possibleComplianceLevels = 0;
                } else {
                    possibleComplianceLevels = 4;
                    if (!"1.5".equals(specVersion)) {
                        possibleComplianceLevels |= 8;
                        if (!"1.6".equals(specVersion)) {
                            possibleComplianceLevels |= 0x10;
                            if (!"1.7".equals(specVersion)) {
                                possibleComplianceLevels |= 0x20;
                                if (!"1.8".equals(specVersion)) {
                                    possibleComplianceLevels |= 0x40;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (possibleComplianceLevels == 0) {
            System.out.println("Skipping all compliances (found none compatible with run.javac=enabled).");
        }
        return possibleComplianceLevels;
    }

    public static Test suite(String suiteName, Class setupClass, ArrayList testClasses) {
        TestSuite all = new TestSuite(suiteName);
        int complianceLevels = AbstractCompilerTest.getPossibleComplianceLevels();
        if ((complianceLevels & 1) != 0) {
            all.addTest(AbstractCompilerTest.suiteForComplianceLevel(0x2F0000L, setupClass, testClasses));
        }
        if ((complianceLevels & 2) != 0) {
            all.addTest(AbstractCompilerTest.suiteForComplianceLevel(0x300000L, setupClass, testClasses));
        }
        if ((complianceLevels & 4) != 0) {
            all.addTest(AbstractCompilerTest.suiteForComplianceLevel(0x310000L, setupClass, testClasses));
        }
        return all;
    }

    public static Test suiteForComplianceLevel(long complianceLevel, Class setupClass, ArrayList testClasses) {
        Class testClass;
        TestSuite suite = null;
        try {
            Constructor constructor = setupClass.getConstructor(String.class);
            suite = (TestSuite)constructor.newInstance(CompilerOptions.versionFromJdkLevel((long)complianceLevel));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (suite == null) {
            return null;
        }
        if (testClasses.size() == 1) {
            testClass = (Class)testClasses.get(0);
            suite = new TestSuite(testClass, CompilerOptions.versionFromJdkLevel((long)complianceLevel));
            TESTS_COUNTERS.put(testClass.getName(), suite.countTestCases());
        } else {
            suite = new TestSuite(CompilerOptions.versionFromJdkLevel((long)complianceLevel));
            int i = 0;
            int length = testClasses.size();
            while (i < length) {
                testClass = (Class)testClasses.get(i);
                TestSuite innerSuite = new TestSuite(testClass);
                TESTS_COUNTERS.put(testClass.getName(), innerSuite.countTestCases());
                suite.addTest((Test)innerSuite);
                ++i;
            }
        }
        return suite;
    }

    public static Test setupSuite(Class clazz) {
        ArrayList<Class> testClasses = new ArrayList<Class>();
        testClasses.add(clazz);
        return AbstractCompilerTest.suite(clazz.getName(), RegressionTestSetup.class, testClasses);
    }

    public static Test buildTestSuite(Class evaluationTestClass) {
        if (TESTS_PREFIX != null || TESTS_NAMES != null || TESTS_NUMBERS != null || TESTS_RANGE != null) {
            return AbstractCompilerTest.buildTestSuite(evaluationTestClass, AbstractCompilerTest.highestComplianceLevels());
        }
        return AbstractCompilerTest.setupSuite(evaluationTestClass);
    }

    public static Test buildTestSuite(Class evaluationTestClass, long complianceLevel) {
        RegressionTestSetup suite = new RegressionTestSetup(complianceLevel);
        List tests = AbstractCompilerTest.buildTestsList(evaluationTestClass);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            suite.addTest((Test)tests.get(index));
            ++index;
        }
        String className = evaluationTestClass.getName();
        int newTestsNb = suite.countTestCases();
        Integer testsNb = (Integer)TESTS_COUNTERS.get(className);
        if (testsNb != null) {
            newTestsNb += testsNb.intValue();
        }
        TESTS_COUNTERS.put(className, newTestsNb);
        return suite;
    }

    public static boolean isJRELevel(int compliance) {
        return (AbstractCompilerTest.getPossibleComplianceLevels() & compliance) != 0;
    }

    public String decorateAnnotationValueLiteral(String val) {
        if (!isJRE9) {
            return val;
        }
        StringBuilder builder = new StringBuilder(val);
        builder.insert(0, "\"");
        builder.append("\"");
        return builder.toString();
    }

    public AbstractCompilerTest(String name) {
        super(name);
    }

    protected Map getCompilerOptions() {
        Map options = new CompilerOptions().getMap();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        if (this.complianceLevel == 0x2F0000L) {
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
            options.put("org.eclipse.jdt.core.compiler.source", "1.3");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
        } else if (this.complianceLevel == 0x300000L) {
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            options.put("org.eclipse.jdt.core.compiler.source", "1.4");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        } else if (this.complianceLevel == 0x310000L) {
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            options.put("org.eclipse.jdt.core.compiler.source", "1.5");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        } else if (this.complianceLevel == 0x320000L) {
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
            options.put("org.eclipse.jdt.core.compiler.source", "1.6");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
        } else if (this.complianceLevel == 0x330000L) {
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
            options.put("org.eclipse.jdt.core.compiler.source", "1.7");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
        } else if (this.complianceLevel == 0x340000L) {
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
            options.put("org.eclipse.jdt.core.compiler.source", "1.8");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        } else if (this.complianceLevel == 0x350000L) {
            options.put("org.eclipse.jdt.core.compiler.compliance", "9");
            options.put("org.eclipse.jdt.core.compiler.source", "9");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "9");
        }
        return options;
    }

    public String getName() {
        String name = super.getName();
        if (this.complianceLevel != 0L) {
            name = String.valueOf(name) + " - " + CompilerOptions.versionFromJdkLevel((long)this.complianceLevel);
        }
        return name;
    }

    public void initialize(CompilerTestSetup setUp) {
        this.complianceLevel = setUp.complianceLevel;
        this.enableAPT = System.getProperty("enableAPT") != null;
    }

    protected String testName() {
        return super.getName();
    }

    protected void createOutputTestDirectory(String suffixPath) {
        this.outputTestDirectory = new File(this.outputRootDirectoryPath.toFile(), suffixPath);
        if (!this.outputTestDirectory.exists()) {
            this.outputTestDirectory.mkdirs();
        }
    }

    protected void writeFiles(String[] testFiles) {
        this.createOutputTestDirectory(this.testName());
        int i = 0;
        int length = testFiles.length;
        while (i < length) {
            File dir;
            String fileName = testFiles[i++];
            String contents = testFiles[i++];
            File file = new File(this.outputTestDirectory, fileName);
            if (fileName.lastIndexOf(47) >= 0 && !(dir = file.getParentFile()).exists()) {
                dir.mkdirs();
            }
            Util.writeToFile(contents, file.getPath());
        }
    }
}

