/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractCompletionTest;

public class CompletionParserTest18
extends AbstractCompletionTest {
    public CompletionParserTest18(String testName) {
        super(testName);
    }

    public static Test suite() {
        return CompletionParserTest18.buildMinimalComplianceTestSuite(CompletionParserTest18.class, 32);
    }

    public void test0001() {
        String string = "interface I { \n\tJ foo(String x, String y);\n}\ninterface J {\n\tK foo(String x, String y);\n}\ninterface K {\n\tint foo(String x, int y);\n}\npublic class X {\n\tstatic void goo(J i) {}\n\tpublic static void main(String[] args) {\n\t\tgoo ((first, second) -> {\n\t\t\treturn (xyz, pqr) -> first.\n\t\t});\n\t}\n}\n";
        String completeBehind = "first.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:first.>";
        String expectedParentNodeToString = "(<no type> xyz, <no type> pqr) -> <CompleteOnName:first.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "first.";
        String expectedUnitDisplayString = "interface I {\n  J foo(String x, String y);\n}\ninterface J {\n  K foo(String x, String y);\n}\ninterface K {\n  int foo(String x, int y);\n}\npublic class X {\n  public X() {\n  }\n  static void goo(J i) {\n  }\n  public static void main(String[] args) {\n    goo((<no type> first, <no type> second) -> {\n  return (<no type> xyz, <no type> pqr) -> <CompleteOnName:first.>;\n});\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0002() {
        String string = "interface Foo { \n\tvoid run1(int s1, int s2);\n}\ninterface X extends Foo{\n  static Foo f = (first, second) -> System.out.print(fi);\n}\n";
        String completeBehind = "fi";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:fi>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "fi";
        String expectedReplacedSource = "fi";
        String expectedUnitDisplayString = "interface Foo {\n  void run1(int s1, int s2);\n}\ninterface X extends Foo {\n  static Foo f = (<no type> first, <no type> second) -> System.out.print(<CompleteOnName:fi>);\n  <clinit>() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0003() {
        String string = "interface Foo { \n\tvoid run1(int s1, int s2);\n}\ninterface X extends Foo {\n  public static void main(String [] args) {\n      Foo f = (first, second) -> System.out.print(fi);\n  }\n}\n";
        String completeBehind = "fi";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:fi>";
        String expectedParentNodeToString = "System.out.print(<CompleteOnName:fi>)";
        String completionIdentifier = "fi";
        String expectedReplacedSource = "fi";
        String expectedUnitDisplayString = "interface Foo {\n  void run1(int s1, int s2);\n}\ninterface X extends Foo {\n  public static void main(String[] args) {\n    Foo f = (<no type> first, <no type> second) -> System.out.print(<CompleteOnName:fi>);\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0004() {
        String string = "interface Foo {\n\tint run1(int s1, int s2);\n}\ninterface X extends Foo{\n    static Foo f = (x5, x6) -> {x\n}\n";
        String completeBehind = "x";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:x>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "x";
        String expectedReplacedSource = "x";
        String expectedUnitDisplayString = "interface Foo {\n  int run1(int s1, int s2);\n}\ninterface X extends Foo {\n  static Foo f = (<no type> x5, <no type> x6) ->   {\n    <CompleteOnName:x>;\n  };\n  <clinit>() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0005() {
        String string = "interface I {\n\tint foo(int x);\n}\npublic class X {\n\tvoid go() {\n\t\tI i = (argument) -> {\n\t\t\tif (true) {\n\t\t\t\treturn arg\n\t\t\t}\n\t\t}\n\t}\n}\n";
        String completeBehind = "arg";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:arg>";
        String expectedParentNodeToString = "return <CompleteOnName:arg>;";
        String completionIdentifier = "arg";
        String expectedReplacedSource = "arg";
        String expectedUnitDisplayString = "interface I {\n  int foo(int x);\n}\npublic class X {\n  public X() {\n  }\n  void go() {\n    I i = (<no type> argument) ->     {\n      if (true)\n          {\n            return <CompleteOnName:arg>;\n          }\n    };\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0006() {
        String string = "interface I {\n\tint foo(int x);\n}\npublic class X {\n\tvoid go() {\n\t\tI i = (argument) -> {\n\t\t\targument == 0 ? arg\n\t\t}\n\t}\n}\n";
        String completeBehind = "arg";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:arg>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "arg";
        String expectedReplacedSource = "arg";
        String expectedUnitDisplayString = "interface I {\n  int foo(int x);\n}\npublic class X {\n  public X() {\n  }\n  void go() {\n    I i = (<no type> argument) ->     {\n      <CompleteOnName:arg>;\n    };\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0007() {
        String string = "public interface Foo { \n\tint run(int s1, int s2); \n}\ninterface X {\n    static Foo f = (int x5, int x11) -> x;\n    static int x1 = 2;\n}\nclass C {\n\tvoid method1(){\n\t\tint p = X.\n\t}\n}\n";
        String completeBehind = "X.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:X.>";
        String expectedParentNodeToString = "int p = <CompleteOnName:X.>;";
        String completionIdentifier = "";
        String expectedReplacedSource = "X.";
        String expectedUnitDisplayString = "public interface Foo {\n  int run(int s1, int s2);\n}\ninterface X {\n  static Foo f;\n  static int x1;\n  <clinit>() {\n  }\n}\nclass C {\n  C() {\n  }\n  void method1() {\n    int p = <CompleteOnName:X.>;\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test0010() {
        String string = "interface I {\n\tvoid foo(String x);\n}\npublic class X {\n\tString xField;\n\tstatic void goo(String s) {\n\t}\n\tstatic void goo(I i) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo((xyz) -> {\n\t\t\tSystem.out.println(xyz.);\n\t\t});\n\t}\n}\n";
        String completeBehind = "xyz.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:xyz.>";
        String expectedParentNodeToString = "System.out.println(<CompleteOnName:xyz.>)";
        String completionIdentifier = "";
        String expectedReplacedSource = "xyz.";
        String expectedUnitDisplayString = "interface I {\n  void foo(String x);\n}\npublic class X {\n  String xField;\n  public X() {\n  }\n  static void goo(String s) {\n  }\n  static void goo(I i) {\n  }\n  public static void main(String[] args) {\n    goo((<no type> xyz) -> {\n  System.out.println(<CompleteOnName:xyz.>);\n});\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test417935() {
        String string = "import java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.Collections;\nimport java.util.Comparator;\npublic class X {\n   int compareTo(X x) { return 0; }\n\tvoid foo() {\n\t\tCollections.sort(new ArrayList<X>(Arrays.asList(new X(), new X(), new X())),\n\t\t\t\t(X o1, X o2) -> o1.compa); //[2]\n\t}\n}\n";
        String completeBehind = "compa";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:o1.compa>";
        String expectedParentNodeToString = "(X o1, X o2) -> <CompleteOnName:o1.compa>";
        String completionIdentifier = "compa";
        String expectedReplacedSource = "o1.compa";
        String expectedUnitDisplayString = "import java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.Collections;\nimport java.util.Comparator;\npublic class X {\n  public X() {\n  }\n  int compareTo(X x) {\n  }\n  void foo() {\n    Collections.sort(new ArrayList<X>(Arrays.asList(new X(), new X(), new X())), (X o1, X o2) -> <CompleteOnName:o1.compa>);\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test405126() {
        String string = "public interface Foo { \n\tint run(int s1, int s2); \n}\ninterface X {\n    static Foo f = (int x5, int x11) -> x\n    static int x1 = 2;\n}\nclass C {\n\tvoid method1(){\n\t\tint p = X.\n\t}\n}\n";
        String completeBehind = "X.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:X.>";
        String expectedParentNodeToString = "int p = <CompleteOnName:X.>;";
        String completionIdentifier = "";
        String expectedReplacedSource = "X.";
        String expectedUnitDisplayString = "public interface Foo {\n  int run(int s1, int s2);\n}\ninterface X {\n  static Foo f;\n  static int x1;\n  <clinit>() {\n  }\n}\nclass C {\n  C() {\n  }\n  void method1() {\n    int p = <CompleteOnName:X.>;\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void testLocalsPromotion() {
        String string = "interface I {\n\tvoid foo(int x);\n}\npublic class X {\n\tstatic void goo(I i) {}\n\tpublic static void main(String[] args) {\n       int outerLocal;\n\t\tgoo ((x) -> {\n\t\t\tint lambdaLocal = 10;\n\t\t\tSystem.out.println(\"Statement inside lambda\");\n\t\t\tlam\n\t\t});\n\t}\n}\n";
        String completeBehind = "lam";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:lam>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "lam";
        String expectedReplacedSource = "lam";
        String expectedUnitDisplayString = "interface I {\n  void foo(int x);\n}\npublic class X {\n  public X() {\n  }\n  static void goo(I i) {\n  }\n  public static void main(String[] args) {\n    int outerLocal;\n    goo((<no type> x) -> {\n  int lambdaLocal;\n  System.out.println(\"Statement inside lambda\");\n  <CompleteOnName:lam>;\n});\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void testCompletionLocation() {
        String string = "interface I {\n    void doit();\n}\ninterface J {\n}\npublic class X { \n\tObject o = (I & J) () -> {};\n\t/* AFTER */\n}\n";
        String completeBehind = "/* AFTER */";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnType:>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        String expectedUnitDisplayString = "interface I {\n  void doit();\n}\ninterface J {\n}\npublic class X {\n  Object o;\n  <CompleteOnType:>;\n  public X() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void testElidedCompletion() {
        String string = "class Collections {\n\tpublic static void sort(ArrayList list, Comparator c) {\n\t}\n}\ninterface Comparator {\n\tint compareTo(X t, X s);\n}\nclass ArrayList {\n}\npublic class X {\n\tint compareTo(X x) { return 0; }\n\tvoid foo() {\n\t\tCollections.sort(new ArrayList(), (X o1, X o2) -> o1.compa);\n\t}\n}\n";
        String completeBehind = "compa";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:o1.compa>";
        String expectedParentNodeToString = "(X o1, X o2) -> <CompleteOnName:o1.compa>";
        String completionIdentifier = "compa";
        String expectedReplacedSource = "o1.compa";
        String expectedUnitDisplayString = "class Collections {\n  Collections() {\n  }\n  public static void sort(ArrayList list, Comparator c) {\n  }\n}\ninterface Comparator {\n  int compareTo(X t, X s);\n}\nclass ArrayList {\n  ArrayList() {\n  }\n}\npublic class X {\n  public X() {\n  }\n  int compareTo(X x) {\n  }\n  void foo() {\n    Collections.sort(new ArrayList(), (X o1, X o2) -> <CompleteOnName:o1.compa>);\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void testElidedCompletion2() {
        String string = "class Collections {\n\tpublic static void sort(ArrayList list, Comparator c) {\n\t}\n}\ninterface Comparator {\n\tint compareTo(X t, X s);\n}\nclass ArrayList {\n}\npublic class X {\n\tint compareTo(X x) { return 0; }\n\tvoid foo() {\n\t\tCollections.sort(new ArrayList(), (o1, o2) -> o1.compa);\n\t}\n}\n";
        String completeBehind = "compa";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:o1.compa>";
        String expectedParentNodeToString = "(<no type> o1, <no type> o2) -> <CompleteOnName:o1.compa>";
        String completionIdentifier = "compa";
        String expectedReplacedSource = "o1.compa";
        String expectedUnitDisplayString = "class Collections {\n  Collections() {\n  }\n  public static void sort(ArrayList list, Comparator c) {\n  }\n}\ninterface Comparator {\n  int compareTo(X t, X s);\n}\nclass ArrayList {\n  ArrayList() {\n  }\n}\npublic class X {\n  public X() {\n  }\n  int compareTo(X x) {\n  }\n  void foo() {\n    Collections.sort(new ArrayList(), (<no type> o1, <no type> o2) -> <CompleteOnName:o1.compa>);\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void testUnspecifiedReference() {
        String string = "interface I {\n    void doit(X x);\n}\nclass String {\n}\npublic class X { \n\tstatic void goo(I i) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo((StringParameter) -> {\n\t\t\tStr\n\t\t});\n\t} \n}\n";
        String completeBehind = "Str";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:Str>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "Str";
        String expectedReplacedSource = "Str";
        String expectedUnitDisplayString = "interface I {\n  void doit(X x);\n}\nclass String {\n  String() {\n  }\n}\npublic class X {\n  public X() {\n  }\n  static void goo(I i) {\n  }\n  public static void main(String[] args) {\n    goo((<no type> StringParameter) -> {\n  <CompleteOnName:Str>;\n});\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void testBrokenMethodCall() {
        String string = "interface I {\n    void doit(X x);\n}\npublic class X { \n\tstatic void goo(I i) {\n\t}\n\tpublic static void main(String[] args) {\n\t\tgoo((StringParameter) -> {\n\t\t\tStr\n\t\t})\n\t} \n}\n";
        String completeBehind = "Str";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:Str>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "Str";
        String expectedReplacedSource = "Str";
        String expectedUnitDisplayString = "interface I {\n  void doit(X x);\n}\npublic class X {\n  public X() {\n  }\n  static void goo(I i) {\n  }\n  public static void main(String[] args) {\n    goo((<no type> StringParameter) -> {\n  <CompleteOnName:Str>;\n});\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test424080() {
        String string = "interface FI {\n\tpublic static int val = 5;\n\tdefault int run (String x) { return 1;};\n\tpublic int run (int x);\n}\npublic class X {\n\tFI fi = x -> (new FI() { public int run (int x) {return 2;}}).run(\"\")val;\n}\n";
        String completeBehind = "val";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<NONE>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "val";
        String expectedReplacedSource = "val";
        String expectedUnitDisplayString = "interface FI {\n  public static int val;\n  <clinit>() {\n  }\n  default int run(String x) {\n  }\n  public int run(int x);\n}\npublic class X {\n  FI fi;\n  public X() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test425084() {
        String string = "interface I {\n\tvoid foo();\n}\npublic class X {\n\tI goo() {\n\t\t\ttry\n\t}\n}\n";
        String completeBehind = "try";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:try>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "try";
        String expectedReplacedSource = "try";
        String expectedUnitDisplayString = "interface I {\n  void foo();\n}\npublic class X {\n  public X() {\n  }\n  I goo() {\n    <CompleteOnName:try>;\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test425084b() {
        String string = "interface I {\n\tvoid foo();\n}\npublic class X {\n\tI goo() {\n\t\treturn () -> {\n\t\t\ttry\n\t\t};\n\t}\n}\n";
        String completeBehind = "try";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:try>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "try";
        String expectedReplacedSource = "try";
        String expectedUnitDisplayString = "interface I {\n  void foo();\n}\npublic class X {\n  public X() {\n  }\n  I goo() {\n    return () -> {\n  <CompleteOnName:try>;\n};\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test427255() {
        String string = "public class X {\n  public final String targetApplication;\n  public final String arguments;\n  public final String appUserModelID;\n  public X() {}\n}\n";
        String completeBehind = "X";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnType:X>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "X";
        String expectedReplacedSource = "X";
        String expectedUnitDisplayString = "public class X {\n  public final String targetApplication;\n  public final String arguments;\n  public final String appUserModelID;\n  <CompleteOnType:X>;\n  {\n  }\n  public X() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test427322() {
        String string = "public class X {\n\tinterface I {\n\t\tint foo();\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = () -> 1, i.;\n\t}\n}\n";
        String completeBehind = "i.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        String expectedUnitDisplayString = "public class X {\n  interface I {\n    int foo();\n  }\n  public X() {\n  }\n  public static void main(String[] args) {\n    I i;\n    I i;\n    <CompleteOnName:>;\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test427322a() {
        String string = "public class X {\n\tinterface I {\n\t\tint foo();\n\t}\n\tpublic static void main(String[] args) {\n\t\tI i = 1, i.;\n\t}\n}\n";
        String completeBehind = "i.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        String expectedUnitDisplayString = "public class X {\n  interface I {\n    int foo();\n  }\n  public X() {\n  }\n  public static void main(String[] args) {\n    I i;\n    I i;\n    <CompleteOnName:>;\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test427463() {
        String string = "interface FI1 {\n\tint foo(int x) throws Exception;\n}\nclass Test {\n\tFI1 fi1= (int x) -> {\n\t\tthrow new Ex\n\t};\n\tprivate void test() throws Exception {\n\t\tthrow new Ex\n\t}\n}\n";
        String completeBehind = "new Ex";
        int cursorLocation = string.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnException:Ex>";
        String expectedParentNodeToString = "throw new <CompleteOnException:Ex>();";
        String completionIdentifier = "Ex";
        String expectedReplacedSource = "Ex";
        String expectedUnitDisplayString = "interface FI1 {\n  int foo(int x) throws Exception;\n}\nclass Test {\n  FI1 fi1 = (int x) ->   {\n    <CompleteOnException:Ex>;\n  };\n  Test() {\n  }\n  private void test() throws Exception {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test427117() {
        String string = "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tbar();\n\t}\n\tpublic static void bar() {\n\t\tList<Integer> list = new ArrayList<Integer>();\n\t\tlist.forEach(s -> System.out.println(s));\n\t\tlist.\n\t}\n}\n";
        String completeBehind = "list.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:list.>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "list.";
        String expectedUnitDisplayString = "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\n  public X() {\n  }\n  public static void main(String[] args) {\n  }\n  public static void bar() {\n    List<Integer> list;\n    <CompleteOnName:list.>;\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test427532() {
        String string = "import java.io.Serializable;\ninterface I {\n\tvoid foo();\n}\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tI i = (I & Serializable) () -> {};\n\t\tsyso\n\t}\n}\n";
        String completeBehind = "syso";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:syso>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "syso";
        String expectedReplacedSource = "syso";
        String expectedUnitDisplayString = "import java.io.Serializable;\ninterface I {\n  void foo();\n}\npublic class X {\n  public X() {\n  }\n  public static void main(String[] args) {\n    I i;\n    <CompleteOnName:syso>;\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test428735() {
        String string = "import java.util.List;\nclass Person {\n   String getLastName() { return null; }\n}\npublic class X {\n\tvoid test1 (List<Person> people) {\n\t\tpeople.stream().forEach(p -> System.out.println(p.)); // NOK\n\t}\n}\n";
        String completeBehind = "p.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:p.>";
        String expectedParentNodeToString = "System.out.println(<CompleteOnName:p.>)";
        String completionIdentifier = "";
        String expectedReplacedSource = "p.";
        String expectedUnitDisplayString = "import java.util.List;\nclass Person {\n  Person() {\n  }\n  String getLastName() {\n  }\n}\npublic class X {\n  public X() {\n  }\n  void test1(List<Person> people) {\n    people.stream().forEach((<no type> p) -> System.out.println(<CompleteOnName:p.>));\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test428735a() {
        String string = "import java.util.List;\nclass Person {\n   String getLastName() { return null; }\n}\npublic class X {\n\tvoid test1 (List<Person> people) {\n\t\tpeople.stream().forEach(p -> System.out.println(p.)); // NOK\n\t}\n   void test2(List<Person> people) {\n       people.sort((x,y) -> x.|);  // OK\n   }\n}\n";
        String completeBehind = "x.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:x.>";
        String expectedParentNodeToString = "(<no type> x, <no type> y) -> <CompleteOnName:x.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "x.";
        String expectedUnitDisplayString = "import java.util.List;\nclass Person {\n  Person() {\n  }\n  String getLastName() {\n  }\n}\npublic class X {\n  public X() {\n  }\n  void test1(List<Person> people) {\n  }\n  void test2(List<Person> people) {\n    people.sort((<no type> x, <no type> y) -> <CompleteOnName:x.>);\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test428735b() {
        String string = "import java.util.List;\nclass Person {\n   String getLastName() { return null; }\n}\npublic class X {\n\tvoid test1 (List<Person> people) {\n\t\tpeople.stream().forEach(p -> System.out.println(p.)); // NOK\n\t}\n   void test2(List<Person> people) {\n       people.sort((x,y) -> x.getLastName().compareTo(y.));\n   }\n}\n";
        String completeBehind = "y.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:y.>";
        String expectedParentNodeToString = "x.getLastName().compareTo(<CompleteOnName:y.>)";
        String completionIdentifier = "";
        String expectedReplacedSource = "y.";
        String expectedUnitDisplayString = "import java.util.List;\nclass Person {\n  Person() {\n  }\n  String getLastName() {\n  }\n}\npublic class X {\n  public X() {\n  }\n  void test1(List<Person> people) {\n  }\n  void test2(List<Person> people) {\n    people.sort((<no type> x, <no type> y) -> x.getLastName().compareTo(<CompleteOnName:y.>));\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test428735c() {
        String string = "import java.util.List;\nclass Person {\n   String getLastName() { return null; }\n}\npublic class X {\n\tvoid test1 (List<Person> people) {\n\t\tpeople.stream().forEach(p -> System.out.println(p.)); // NOK\n\t}\n   void test2(List<Person> people) {\n       people.sort((x,y) -> x.getLastName() + y.);\n   }\n}\n";
        String completeBehind = "y.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:y.>";
        String expectedParentNodeToString = "(x.getLastName() + <CompleteOnName:y.>)";
        String completionIdentifier = "";
        String expectedReplacedSource = "y.";
        String expectedUnitDisplayString = "import java.util.List;\nclass Person {\n  Person() {\n  }\n  String getLastName() {\n  }\n}\npublic class X {\n  public X() {\n  }\n  void test1(List<Person> people) {\n  }\n  void test2(List<Person> people) {\n    people.sort((<no type> x, <no type> y) -> (x.getLastName() + <CompleteOnName:y.>));\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test428735d() {
        String string = "import java.util.List;\nclass Person {\n   String getLastName() { return null; }\n}\npublic class X {\n\tvoid test1 (List<Person> people) {\n\t\tpeople.stream().forEach(p -> System.out.println(p.)); // NOK\n\t}\n   void test2(List<Person> people) {\n       people.sort((x,y) -> \"\" + x.); \n   }\n}\n";
        String completeBehind = "x.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:x.>";
        String expectedParentNodeToString = "(\"\" + <CompleteOnName:x.>)";
        String completionIdentifier = "";
        String expectedReplacedSource = "x.";
        String expectedUnitDisplayString = "import java.util.List;\nclass Person {\n  Person() {\n  }\n  String getLastName() {\n  }\n}\npublic class X {\n  public X() {\n  }\n  void test1(List<Person> people) {\n  }\n  void test2(List<Person> people) {\n    people.sort((<no type> x, <no type> y) -> (\"\" + <CompleteOnName:x.>));\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test428735e() {
        String string = "class Person {\n   String getLastName() { return null; }\n}\ninterface I {\n\tint foo(Person p, Person q);\n}\npublic class X {\n\tI i =  (x, y) -> 10 + x.getLastName().compareTo(y.get);\n}\n";
        String completeBehind = "y.get";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:y.get>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "get";
        String expectedReplacedSource = "y.get";
        String expectedUnitDisplayString = "class Person {\n  Person() {\n  }\n  String getLastName() {\n  }\n}\ninterface I {\n  int foo(Person p, Person q);\n}\npublic class X {\n  I i = (<no type> x, <no type> y) -> (10 + x.getLastName().compareTo(<CompleteOnName:y.get>));\n  public X() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test428735f() {
        String string = "class Person {\n   String getLastName() { return null; }\n}\ninterface I {\n\tint foo(Person p, Person q);\n}\npublic class X {\n   void foo() {\n\t    I i =  (x, y) -> 10 + x.getLastName().compareTo(y.get);\n   }\n}\n";
        String completeBehind = "y.get";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:y.get>";
        String expectedParentNodeToString = "x.getLastName().compareTo(<CompleteOnName:y.get>)";
        String completionIdentifier = "get";
        String expectedReplacedSource = "y.get";
        String expectedUnitDisplayString = "class Person {\n  Person() {\n  }\n  String getLastName() {\n  }\n}\ninterface I {\n  int foo(Person p, Person q);\n}\npublic class X {\n  public X() {\n  }\n  void foo() {\n    I i = (<no type> x, <no type> y) -> (10 + x.getLastName().compareTo(<CompleteOnName:y.get>));\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test428735g() {
        String string = "import java.util.List;\nclass Person {\n   String getLastName() { return null; }\n}\ninterface I {\n\tint foo(Person p, Person q);\n}\npublic class X {\n   List<Person> people;\n   {\n       people.sort((x,y) -> \"\" + x.); \n   }\n}\n";
        String completeBehind = "x.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:x.>";
        String expectedParentNodeToString = "(\"\" + <CompleteOnName:x.>)";
        String completionIdentifier = "";
        String expectedReplacedSource = "x.";
        String expectedUnitDisplayString = "import java.util.List;\nclass Person {\n  Person() {\n  }\n  String getLastName() {\n  }\n}\ninterface I {\n  int foo(Person p, Person q);\n}\npublic class X {\n  List<Person> people;\n  {\n    people.sort((<no type> x, <no type> y) -> (\"\" + <CompleteOnName:x.>));\n  }\n  public X() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test402081() {
        String string = "interface I {\n    String foo(String x);\n}\npublic class X {\n    public  String longMethodName(String x) {\n        return null;\n    }\n    void foo() {\n    \tX x = new X();\n    \tI i = x::long\n       System.out.println();\n    }\n}\n";
        String completeBehind = "long";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompletionOnReferenceExpressionName:x::long>";
        String expectedParentNodeToString = "I i = <CompletionOnReferenceExpressionName:x::long>;";
        String completionIdentifier = "long";
        String expectedReplacedSource = "x::long";
        String expectedUnitDisplayString = "interface I {\n  String foo(String x);\n}\npublic class X {\n  public X() {\n  }\n  public String longMethodName(String x) {\n  }\n  void foo() {\n    X x;\n    I i = <CompletionOnReferenceExpressionName:x::long>;\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test430656() {
        String string = "import java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\nimport java.util.List;\npublic class X {\n\tpublic void bar() {\n\t\tList<Person> people = new ArrayList<>();\n\t\tCollections.sort(people, Comparator.comparing(Person::get)); \n\t}\n}\nclass Person {\n\tString getLastName() {\n\t\treturn null;\n\t}\n}\n";
        String completeBehind = "get";
        int cursorLocation = string.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompletionOnReferenceExpressionName:Person::get>";
        String expectedParentNodeToString = "Comparator.comparing(<CompletionOnReferenceExpressionName:Person::get>)";
        String completionIdentifier = "get";
        String expectedReplacedSource = "Person::get";
        String expectedUnitDisplayString = "import java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.Comparator;\nimport java.util.List;\npublic class X {\n  public X() {\n  }\n  public void bar() {\n    List<Person> people;\n    Comparator.comparing(<CompletionOnReferenceExpressionName:Person::get>);\n  }\n}\nclass Person {\n  Person() {\n  }\n  String getLastName() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test438952() {
        String string = "import java.util.function.Supplier;\nclass SO {\n\t{\n\t\tint\n\t\tSupplier<SO> m6 = SO::new;\n\t\tm6 = () -> new SO() {\n\t\t\tvoid test() {\n\t\t\t\t/* here */                            \n\t\t\t}\n\t\t};\n\t}\n}\n";
        String completeBehind = "/* here */";
        int cursorLocation = string.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        String expectedUnitDisplayString = "import java.util.function.Supplier;\nclass SO {\n  {\n    int Supplier;\n    m6 = () -> new SO() {\n  void test() {\n    <CompleteOnName:>;\n  }\n};\n  }\n  SO() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test435219() {
        String string = "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<Integer> costBeforeTax = Arrays.asList(100, 200, 300);\n\t\t   double bill = costBeforeTax.stream().map((cost) -> cost + 0.19 * cost)\n\t\t        //                        .y                   .n             .y\n\t\t      .reduce((sum, cost) -> sum.doubleValue() + cost.dou\n\t}\n}\n";
        String completeBehind = "dou";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:cost.dou>";
        String expectedParentNodeToString = "(sum.doubleValue() + <CompleteOnName:cost.dou>)";
        String completionIdentifier = "dou";
        String expectedReplacedSource = "cost.dou";
        String expectedUnitDisplayString = "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n  public X() {\n  }\n  public static void main(String[] args) {\n    List<Integer> costBeforeTax;\n    double bill = costBeforeTax.stream().map((<no type> cost) -> (cost + (0.19 * cost))).reduce((<no type> sum, <no type> cost) -> (sum.doubleValue() + <CompleteOnName:cost.dou>));\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test435682() {
        String string = "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tList<String> words = Arrays.asList(\"hi\", \"hello\", \"hola\", \"bye\", \"goodbye\");\n\t\tList<String> list1 = words.stream().map(so -> so.).collect(Collectors.toList());\n\t}\n}\n";
        String completeBehind = "so.";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:so.>";
        String expectedParentNodeToString = "(<no type> so) -> <CompleteOnName:so.>";
        String completionIdentifier = "";
        String expectedReplacedSource = "so.";
        String expectedUnitDisplayString = "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n  public X() {\n  }\n  public static void main(String[] args) {\n    List<String> words;\n    List<String> list1 = words.stream().map((<no type> so) -> <CompleteOnName:so.>).collect(Collectors.toList());\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test430667() {
        String string = "interface D_FI {\n\tvoid print(String value, int n);\n}\nclass D_DemoRefactorings {\n\t\n\tD_FI fi1= (String value, int n) -> {\n\t\tfor (int j = 0; j < n; j++) {\n\t\t\tSystem.out.println(value); \t\t\t\n\t\t}\n\t};\n\tD_F\n}\n";
        String completeBehind = "D_F";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnType:D_F>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "D_F";
        String expectedReplacedSource = "D_F";
        String expectedUnitDisplayString = "interface D_FI {\n  void print(String value, int n);\n}\nclass D_DemoRefactorings {\n  D_FI fi1;\n  <CompleteOnType:D_F>;\n  D_DemoRefactorings() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test430667a() {
        String string = "class D_DemoRefactorings {\n\t\n\tD_FI fi1= (String value, int n) -> {\n\t\tfor (int j = 0; j < n; j++) {\n\t\t\tSystem.out.println(value); \t\t\t\n\t\t}\n\t};\n\t/*HERE*/D_F\n}\ninterface D_FI {\n\tvoid print(String value, int n);\n}\n";
        String completeBehind = "/*HERE*/D_F";
        int cursorLocation = string.lastIndexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnType:D_F>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "D_F";
        String expectedReplacedSource = "D_F";
        String expectedUnitDisplayString = "class D_DemoRefactorings {\n  D_FI fi1;\n  <CompleteOnType:D_F>;\n  D_DemoRefactorings() {\n  }\n}\ninterface D_FI {\n  void print(String value, int n);\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test430667b() {
        String string = "public class D_DemoRefactorings {\n   D_F\n\tD_FI fi1= (String value, int n) -> {\n\t\tfor (int j = 0; j < n; j++) {\n\t\t\tSystem.out.println(value); \t\t\t\n\t\t}\n\t};\n}\ninterface D_FI {\n\tvoid print(String value, int n);\n}\n";
        String completeBehind = "D_F";
        int cursorLocation = string.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnType:D_F>;";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "D_F";
        String expectedReplacedSource = "D_F";
        String expectedUnitDisplayString = "public class D_DemoRefactorings {\n  <CompleteOnType:D_F>;\n  D_FI fi1;\n  public D_DemoRefactorings() {\n  }\n}\ninterface D_FI {\n  void print(String value, int n);\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test430667c() {
        String string = "public interface Foo {\n\tint run(int s1, int s2);\n}\ninterface B {\n\tstatic Foo f = (int x5, int x2) -> anot\n\tstatic int another = 3;\n  \tstatic int two () { return 2; }\n}";
        String completeBehind = "(int x5, int x2) -> anot";
        int cursorLocation = string.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:anot>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "anot";
        String expectedReplacedSource = "anot";
        String expectedUnitDisplayString = "public interface Foo {\n  int run(int s1, int s2);\n}\ninterface B {\n  static Foo f = (int x5, int x2) -> <CompleteOnName:anot>;\n  static int another;\n  <clinit>() {\n  }\n  static int two() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test430667d() {
        String string = "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n\t\tList<Integer> list = Arrays.asList(1, 2, 3);\n\t\tObject o = list.stream().map((x) -> x * x.hashCode()).forEach(System.out::pri);\n}\n";
        String completeBehind = "pri";
        int cursorLocation = string.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompletionOnReferenceExpressionName:System.out::pri>";
        String expectedParentNodeToString = "list.stream().map((<no type> x) -> (x * x.hashCode())).forEach(<CompletionOnReferenceExpressionName:System.out::pri>)";
        String completionIdentifier = "pri";
        String expectedReplacedSource = "System.out::pri";
        String expectedUnitDisplayString = "import java.util.Arrays;\nimport java.util.List;\npublic class X {\n  List<Integer> list;\n  Object o = list.stream().map((<no type> x) -> (x * x.hashCode())).forEach(<CompletionOnReferenceExpressionName:System.out::pri>);\n  public X() {\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test446765() {
        String string = "class Stepper<T> {\n    public interface Step<T> {\n        void run();\n    }\n    public Stepper(Handler<AsyncResult<T>> handler) {}\n\n    @SafeVarargs\n    public final void run(Step<T> ... steps) {}\n}\ninterface AsyncResult<T> {}\ninterface Handler<E> {\n    void handle(E event);\n}\nclass Z {\n    void foo() {}\n}\ninterface I {\n    void foo(Z z);\n}\nclass Y {\n    void request(I i) {}\n}\npublic class X {\n    void test() {\n        new Stepper<Void>(r -> {}) {\n            private void step1() {\n                Y y = new Y();\n                y.request(response -> {\n                    if (response.)\n                });\n            }\n        }.run();        \n    }    \n}\n";
        String completeBehind = "response.";
        int cursorLocation = string.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:response.>";
        String expectedParentNodeToString = "if (<CompleteOnName:response.>)\n    ;";
        String completionIdentifier = "";
        String expectedReplacedSource = "response.";
        String expectedUnitDisplayString = "class Stepper<T> {\n  public interface Step<T> {\n    void run();\n  }\n  public Stepper(Handler<AsyncResult<T>> handler) {\n  }\n  public final @SafeVarargs void run(Step<T>... steps) {\n  }\n}\ninterface AsyncResult<T> {\n}\ninterface Handler<E> {\n  void handle(E event);\n}\nclass Z {\n  Z() {\n  }\n  void foo() {\n  }\n}\ninterface I {\n  void foo(Z z);\n}\nclass Y {\n  Y() {\n  }\n  void request(I i) {\n  }\n}\npublic class X {\n  public X() {\n  }\n  void test() {\n    new Stepper<Void>((<no type> r) -> {\n}) {\n      private void step1() {\n        Y y;\n        y.request((<no type> response) -> {\n  <CompleteOnName:response.>;\n});\n      }\n    };\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test428735h() {
        String string = "import java.util.List;\nclass Person {\n   String getLastName() { return null; }\n}\npublic class X {\n   void test2(List<Person> people) {\n       people.sort((x,y) -> {\n              if (true) return \"\" + x.get); \n              else return \"\";\n   }\n}\n";
        String completeBehind = "x.get";
        int cursorLocation = string.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:x.get>";
        String expectedParentNodeToString = "(\"\" + <CompleteOnName:x.get>)";
        String completionIdentifier = "get";
        String expectedReplacedSource = "x.get";
        String expectedUnitDisplayString = "import java.util.List;\nclass Person {\n  Person() {\n  }\n  String getLastName() {\n  }\n}\npublic class X {\n  public X() {\n  }\n  void test2(List<Person> people) {\n    people.sort((<no type> x, <no type> y) -> {\n  if (true)\n      return (\"\" + <CompleteOnName:x.get>);\n  ;\n  return \"\";\n});\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test422468() {
        String string = "interface I {\n\tvoid foo(X x);\n}\npublic class X {\n\tstatic X xField;\n\tstatic X goo(String s) {\n       return null;\n\t}\n\tstatic void goo(I i) {\n\t}\n\tpublic static void main(String[] args) {\n       X xLocal = null;\n       args = null;\n       if (args != null) {\n           xField = null;\n       else \n           xField = null;\n       while (true);\n\t\tgoo((xyz) -> {\n           X xLambdaLocal = null;\n\t\t\tSystem.out.println(xyz.)\n\t\t});\n\t}\n}\n";
        String completeBehind = "xyz.";
        int cursorLocation = string.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnName:xyz.>";
        String expectedParentNodeToString = "System.out.println(<CompleteOnName:xyz.>)";
        String completionIdentifier = "";
        String expectedReplacedSource = "xyz.";
        String expectedUnitDisplayString = "interface I {\n  void foo(X x);\n}\npublic class X {\n  static X xField;\n  public X() {\n  }\n  <clinit>() {\n  }\n  static X goo(String s) {\n  }\n  static void goo(I i) {\n  }\n  public static void main(String[] args) {\n    X xLocal;\n    {\n      {\n        goo((<no type> xyz) -> {\n  X xLambdaLocal;\n  System.out.println(<CompleteOnName:xyz.>);\n});\n      }\n    }\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }

    public void test473008() {
        String string = "interface FooFunctional {\n   void function();\n}\npublic class Foo {\n    public void bar() {\n      private FooFunctional lambda = this::bar;\n      new StringBuffer(    }\n}\n";
        String completeBehind = "StringBuffer(";
        int cursorLocation = string.indexOf(completeBehind) + completeBehind.length() - 1;
        String expectedCompletionNodeToString = "<CompleteOnAllocationExpression:new StringBuffer()>";
        String expectedParentNodeToString = "<NONE>";
        String completionIdentifier = "";
        String expectedReplacedSource = "";
        String expectedUnitDisplayString = "interface FooFunctional {\n  void function();\n}\npublic class Foo {\n  public Foo() {\n  }\n  public void bar() {\n    private FooFunctional lambda;\n    <CompleteOnAllocationExpression:new StringBuffer()>;\n  }\n}\n";
        this.checkMethodParse(string.toCharArray(), cursorLocation, expectedCompletionNodeToString, expectedParentNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, "diet ast");
    }
}

