/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class LambdaRegressionTest
extends AbstractRegressionTest {
    public LambdaRegressionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return LambdaRegressionTest.buildMinimalComplianceTestSuite(LambdaRegressionTest.testClass(), 32);
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "import java.util.HashMap;\nimport java.util.Map;\nimport java.util.function.Function;\npublic class X {\n  public static void main(String[] args) {\n    new X().run();\n  }\n  public void run() {\n    class Inner {\n      public Inner() {\n        System.out.println(\"miep\");\n      }\n    }\n    Map<String, Inner> map = new HashMap<>();\n    Function<String, Inner> function = (name) -> {\n      Inner i = map.get(name);\n      if (i == null) {\n        i = new Inner();\n        map.put(name, i);\n      }\n      return i;\n\n    };\n    function.apply(\"test\");\n  }\n}\n"}, "miep");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.Consumer;\n@SuppressWarnings(\"all\")\npublic class X {\n  private final String text = \"Bug?\";\n  public static void main(String[] args) {\n    new X().doIt();\n  }\n  private void doIt() {\n    new Sub();\n  }\n  private class Super<T> {\n    public Super(Consumer<T> consumer) {\n    }\n  }\n  private class Sub extends Super<String> {\n    public Sub() {\n      super(s -> System.out.println(text));\n      // super(s -> System.out.println(\"miep\"));\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 17)\n\tsuper(s -> System.out.println(text));\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nCannot refer to 'this' nor 'super' while explicitly invoking a constructor\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.function.Consumer;\n@SuppressWarnings(\"all\")\npublic class X {\n  private final String text = \"Bug?\";\n  public static void main(String[] args) {\n    new X().doIt();\n  }\n  private void doIt() {\n    new Sub();\n  }\n  private class Super<T> {\n    public Super(Consumer<T> consumer) {\n    }\n  }\n  private class Sub extends Super<String> {\n    public Sub() {\n       super(s -> System.out.println(\"miep\"));\n    }\n  }\n}\n"}, "");
    }

    public void test004() {
        this.runConformTest(new String[]{"Y.java", "import java.util.function.Supplier;\nclass E {\n\tE(Supplier<Object> factory) { }\n}\npublic class Y extends E {\n\tY() {\n\t\tsuper( () -> {\n\t\t\tclass Z extends E {\n\t\t\t\tZ() {\n\t\t\t\t\tsuper(() -> new Object());\n\t\t\t\t}\n\t\t\t}\n\t\t\treturn null;\n\t\t\t});\n\t}\n\tpublic static void main(String[] args) {\n\t\tnew Y();\n\t}\n}"});
    }

    public void test448724() {
        this.runConformTest(new String[]{"X.java", "import java.util.concurrent.Callable;\npublic class X {\n\tpublic void mismatchRunnableCallable() throws Exception {\n\t\t//Resolves to case1(Runnable) method invocation; lambda with block\n\t\tcase1(() -> {\"abc\".length();});\n\t\t//Resolves to case1(Callable) method invocation, resulting in type mismatch; block removed - lambda with expression\n                case1(() -> \"abc\".length());\n\t}\n\tpublic void noSuchMismatch() throws Exception {\n\t\t//no difference to case1 \n\t\tcase2(() -> {\"abc\".length();});\n\t\t//the only difference to case 1 is the missing irrelevant <T> type parameter. Properly resolves to case2(Runnable) here\n\t\tcase2(() -> \"abc\".length());\n\t}\n\tpublic void case1(final Runnable r) {\n\t\tSystem.out.println(\"case1: Runnable\");\n\t}\n\tpublic <T> void case1(Callable<Boolean> c) {\n\t\tSystem.out.println(\"case1: Callable\");\n\t}\n\tpublic void case2(final Runnable supplier) {\n\t\tSystem.out.println(\"case2: Runnable\");\n\t}\n\tpublic void case2(Callable<Boolean> conditionEvaluator) {\n\t\tSystem.out.println(\"case2: Callable\");\n\t}\n\tpublic static void main(String[] args) throws Exception {\n\t\tnew X().mismatchRunnableCallable();\n\t\tnew X().noSuchMismatch();\n\t}\n}\n"}, "case1: Runnable\ncase1: Runnable\ncase2: Runnable\ncase2: Runnable");
    }

    public void test447767() {
        this.runConformTest(new String[]{"X.java", "interface I<T, U, V> {\n\tT goo(U u, V v);\n}\npublic class X {\n\tstatic <T, U, V> T foo(T t, U u, V v) {\n       System.out.println(\"Wrong!\");\n       return null;\n   }\n\tstatic <T, U, V> V foo(T t, U u, I<T, U, V> i) {\n\t\tSystem.out.println(\"Right!\");\n       return null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tString s = goo(foo(\"String\", \"String\", (u, v) -> v));\n\t}\n\tstatic <T> T goo(T t) {\n\t    return t;\t\n\t}\n}\n"}, "Right!");
    }

    public void test447767a() {
        this.runNegativeTest(new String[]{"X.java", "interface I<T, U, V> {\n\tT goo(U u, V v);\n}\npublic class X {\n\tstatic <T, U, V> T foo(T t, U u, I<T, U, V> i) {\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tString s = goo(foo(\"String\", \"String\", (u, v) -> v));\n\t}\n\tstatic <T> T goo(T t) {\n\t    return t;\t\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tString s = goo(foo(\"String\", \"String\", (u, v) -> v));\n\t                                                 ^\nType mismatch: cannot convert from Object to String\n----------\n");
    }

    public void test447767b() {
        this.runConformTest(new String[]{"X.java", "interface I<T, U, V> {\n\tT goo(U u, V v);\n}\npublic class X {\n\tstatic String goo(String s, String s2) {\n\t\treturn null;\n\t}\n\tstatic <T, U, V> V foo(T t, U u, I<T, U, V> i) {\n\t\tSystem.out.println(\"Right!\");\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tString s = goo(foo(\"String\", \"String\", X::goo));\n\t}\n\tstatic <T> T goo(T t) {\n\t    return t;\t\n\t}\n}\n"}, "Right!");
    }

    public void test447767c() {
        this.runConformTest(new String[]{"X.java", "interface I<T, U, V> {\n\tT goo(U u, V v);\n}\npublic class X {\n\tstatic String goo(String s, String s2) {\n\t\treturn null;\n\t}\n\tstatic <T, U, V> T foo(T t, U u, V v) {\n       System.out.println(\"Wrong!\");\n       return null;\n   }\n\tstatic <T, U, V> V foo(T t, U u, I<T, U, V> i) {\n\t\tSystem.out.println(\"Right!\");\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tString s = goo(foo(\"String\", \"String\", X::goo));\n\t}\n\tstatic <T> T goo(T t) {\n\t    return t;\t\n\t}\n}\n"}, "Right!");
    }

    public void test447767d() {
        this.runConformTest(new String[]{"X.java", "interface I<T, U, V> {\n\tT goo(U u, V v);\n}\npublic class X {\n\tstatic String goo(String s, String s2) {\n\t\treturn null;\n\t}\n\tstatic <T, U, V> T foo(T t, U u, V v) {\n        System.out.println(\"Wrong!\");\n        return null;\n   }\n\tstatic <T, U, V> V foo(T t, U u, I<T, U, V> i) {\n\t\tSystem.out.println(\"Right!\");\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tString s = goo(foo(\"String\", \"String\", X::goo));\n\t}\n\tstatic <T> T goo(T t) {\n\t    return t;\t\n\t}\n}\n"}, "Right!");
    }

    public void test449410() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Collections;\npublic class X {\n  public static void main(String[] args) {\n    Collections.emptyMap()\n        .entrySet()\n        .forEach(entry -> test() ? bad() : returnType());\n  }\n  private static boolean test() {\n    return (System.currentTimeMillis() & 0x1) == 0;\n  }\n  private static void returnType() {\n  }\n  private static void bad() {\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\t.forEach(entry -> test() ? bad() : returnType());\n\t ^^^^^^^\nThe method forEach(Consumer<? super Map.Entry<Object,Object>>) in the type Iterable<Map.Entry<Object,Object>> is not applicable for the arguments ((<no type> entry) -> {})\n----------\n2. ERROR in X.java (at line 6)\n\t.forEach(entry -> test() ? bad() : returnType());\n\t                  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nInvalid expression as statement\n----------\n");
    }

    public void test449824() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public static void main(String[] args) {\n    Concrete<Target> fl = new Concrete<Target>();\n    fl.call(each -> each.doSomething()); // fails\n    fl.call((Target each) -> each.doSomething()); // fails\n    fl.call(Target::doSomething); // succeeds in Eclipse 4.5M3 and 4.4.1\n    // but fails in Java 8 1.8.0_11\n  }\n  public static class Target {\n    public void doSomething() {\n    }\n  }\n  public static class Concrete<T> implements Left<T>, Right<T> {\n    public void call(RightHand<? super T> p) {\n    }\n  }\n  public interface Left<T> {\n    default void call(LeftHand<? super T> p) {\n    }\n  }\n  public interface LeftHand<T> {\n    public void left(T t);\n  }\n  public interface Right<T> {\n    public void call(RightHand<? super T> p);\n  }\n  public interface RightHand<T> {\n    public void right(T t);\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 4)\n\tfl.call(each -> each.doSomething()); // fails\n\t   ^^^^\nThe method call(X.RightHand<? super X.Target>) is ambiguous for the type X.Concrete<X.Target>\n----------\n2. ERROR in X.java (at line 6)\n\tfl.call(Target::doSomething); // succeeds in Eclipse 4.5M3 and 4.4.1\n\t   ^^^^\nThe method call(X.RightHand<? super X.Target>) is ambiguous for the type X.Concrete<X.Target>\n----------\n");
    }

    public void test448954() {
        this.runConformTest(new String[]{"X.java", "interface I<T, U, V> {\n\tT goo(U u, V v);\n}\ninterface J {\n\tvoid foo();\n}\npublic class X {\n\tstatic String goo(String s, String s2) {\n\t\treturn null;\n\t}\n\tstatic <T, U, V> T foo(T t, U u, J j) {\n\t\tSystem.out.println(\"Wrong!\");\n\t\treturn null;\n\t}\n\tstatic <T, U, V> V foo(T t, U u, I<T, U, V> i) {\n\t\tSystem.out.println(\"Right!\");\n\t\treturn null;\n\t}\n\tpublic static void main(String[] args) {\n\t\tString s = goo(foo(\"String\", \"String\", X::goo));\n\t}\n\tstatic <T> T goo(T t) {\n\t\treturn t;\n\t}\n}\n"}, "Right!");
    }

    public void test450380() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.function.IntFunction;\npublic class X {\n    IntFunction<ArrayList<String>> noo() {\n        return System::new;\n    }\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\treturn System::new;\n\t       ^^^^^^^^^^^\nThe type System does not define System(int) that is applicable here\n----------\n");
    }

    public void test450604() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.IOException;\nimport java.util.List;\nimport java.util.function.Function;\npublic class X<T, E extends Exception> {\n\tpublic static <T> List<T> of(T one) { return null; }\n\tpublic @SafeVarargs static <T> List<T> of(T... items) { return null; }\n\tpublic static void printDependencyLoops() throws IOException {\n\t\tFunction<? super String, ? extends List<String>> mapping = X::of;\n\t}\n}\n"}, "");
    }

    public void test450604a() {
        this.runConformTest(new String[]{"X.java", "import java.util.List;\npublic class X {\n\tpublic static <T> List<T> of() { return null; }\n\tpublic static @SafeVarargs <T> List<T> of(T... values) { return null; }\n\tstatic void walkAll() {\n\t\tX.<String> of();\n\t}\n}\n"});
    }

    public void _test451677() {
        this.runConformTest(new String[]{"X.java", "import java.util.ArrayList;\nimport java.util.function.Function;\npublic class X {\n\tpublic static void test() {\n\t\toperationOnCreated(create(123, size -> new ArrayList<Integer>(size)), l -> l.size()); // works with: (ArrayList<Integer> l) -> l.size()\n\t}\n\tpublic static <R, A> R create(A arg, Function<A, R> factory) {\n\t\treturn factory.apply(arg);\n\t}\n\tpublic static <R, A> R operationOnCreated(A created, Function<A, R> function) {\n\t\treturn function.apply(created);\n\t}\n}\n"});
    }

    public void testBug451840() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public static void main(String[] args) {\n    \tX test = new X();\n    \tMySupplier<X> s = test::new; // incorrect\n    }\n    public interface MySupplier<T> {\n        T create();\n    }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tMySupplier<X> s = test::new; // incorrect\n\t                  ^^^^\ntest cannot be resolved to a type\n----------\n");
    }

    public void testBug4448556() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\nimport java.util.List;\npublic class X {\n    private static final List<Integer> INTEGERS = Arrays.asList(1, 2, 3, 4);\n    public static void main(String[] args) {\n        for (int i = 0; i < INTEGERS.size(); i++) {\n            MyPredicate<Integer> predicate = INTEGERS.get(i)::equals;\n        }\n    }  \n    public interface MyPredicate<T> extends Serializable {\n        boolean accept(T each);\n    }\n}"}, "");
    }

    public void testBug4448556a() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.Arrays;\nimport java.util.List;\npublic class X {\n\tint value = 0; \n    private static final List<Integer> INTEGERS = Arrays.asList(1, 2, 3, 4);\n    public Integer next() {\n    \treturn new Integer(++value);\n    }\n    public static void main(String[] args) {\n    \tX t = new X();\n        MyPredicate<Integer> predicate = t.next()::equals;\n        System.out.println(\"Value \" + t.value + \" accept \" + predicate.accept(t.value));\n    }\n    public interface MyPredicate<T> extends Serializable {\n        boolean accept(T each);\n    }\n}"}, "Value 1 accept true");
    }

    public void testBug453687() {
        this.runConformTest(new String[]{"X.java", "import static java.util.stream.Collectors.groupingBy;\nimport static java.util.stream.Collectors.mapping;\nimport static java.util.stream.Collectors.toSet;\nimport java.util.Locale;\nimport java.util.Map;\nimport java.util.Set;\nimport java.util.stream.Stream;\npublic class X {\n\tpublic static void main(String[] args) {\n\t\tMap<String, Set<String>> countryLanguagesMap = Stream.of(Locale.getAvailableLocales()).collect(\n\t\t\t\tgroupingBy(Locale::getDisplayCountry, mapping(Locale::getDisplayLanguage, toSet())));\n\t}\n} "}, "");
    }

    public void testBug456481() {
        this.runConformTest(new String[]{"Test.java", "public class Test  {\n    interface Constructor {\n        MyTest execute();\n    }\n    interface ArrayConstructor {\n    \tMyTest[] execute(int no);\n    }\n    interface ParameterizedConstructor {\n    \tMyParameterizedTest<String> execute();\n    }\n    class MyTest {\n        MyTest() { System.out.println(\"Constructor executed\"); }\n    }\n    class MyParameterizedTest<T> {\n    \tMyParameterizedTest() {\n    \t\tSystem.out.println(\"Parameterized Constructor executed\");\n    \t}\n    }\n    public Constructor getConstructor() {\n        return getConstructor(() -> { return MyTest::new; });\n    }\n    public MyTest[] getArray(int no) {\n    \treturn new MyTest[no];\n    }\n    ArrayConstructor getArrayConstructor() {\n    \treturn getArrayConstructor(() -> {return MyTest[]::new;});\n    }\n    ParameterizedConstructor getParameterizedConstructor() {\n    \treturn getParameterizedConstructor(() -> {return MyParameterizedTest<String>::new;});\n    }\n    ArrayConstructor getArrayConstructor(ArrayWrapper w) {\n    \treturn w.unwrap();\n    }\n    public static void main(String argv[]) {\n        Test t = new Test();\n        MyTest mytest = t.getConstructor().execute();\n        MyTest[] array = t.getArrayConstructor().execute(2);\n        MyParameterizedTest<String> pt = t.getParameterizedConstructor().execute();\n    }\n    ParameterizedConstructor getParameterizedConstructor(PTWrapper ptw) {\n    \treturn ptw.unwrap();\n    }\n    Constructor getConstructor(Wrapper arg) {\n        return arg.unwrap();\n    }\n    interface PTWrapper {\n    \tParameterizedConstructor unwrap();\n    }\n    interface ArrayWrapper {\n    \tArrayConstructor unwrap();\n    }\n    interface Wrapper {\n        Constructor unwrap();\n    }\n}"}, "Constructor executed\nParameterized Constructor executed");
    }

    public void testBug457007() {
        this.runConformTest(new String[]{"Test.java", "public class Test {\n\tvoid method() {\n  \t\tclass Bar {}\n  \t\tjava.util.function.Function<String, Bar> f = str -> new Bar();\n\t}\n\tpublic static void main(String[] args) {\n\t\tSystem.out.println(\"done\");\n\t}\n}"}, "done");
    }

    public void testBug446691_comment5() {
        this.runConformTest(new String[]{"Test.java", "import java.util.*;\n\npublic class Test {\n  protected final Integer myInt;\n\n  public Test() {\n    myInt = Integer.valueOf(0);\n    try {\n      Optional.empty().orElseThrow(() -> new IllegalArgumentException(myInt.toString()));\n    } catch (IllegalArgumentException e) {\n      throw new RuntimeException();\n    }\n    return;\n  }\n}\n"});
    }

    public void testBug446691_comment8() {
        this.runConformTest(new String[]{"Boom.java", "public class Boom {\n  private final String field;\n  public Boom(String arg) {\n    this.field = arg;\n    try {\n      java.util.function.Supplier<String> supplier = () -> field;\n    } catch (Exception e) {\n      \n    }\n  }\n}\n"});
    }

    public void testBug446691_comment14() {
        this.runNegativeTest(new String[]{"test/Main.java", "package test;\n\nimport java.util.logging.Logger;\n\npublic class Main {\n\n\tprivate static final Logger LOG = Logger.getLogger(\"test\");\n\tprivate final static String value;\n\n\tstatic {\n\t\ttry {\n\t\t\tLOG.info(() -> String.format(\"Value is: %s\", value));\n\t\t} catch (final Exception ex) {\n\t\t\tthrow new ExceptionInInitializerError(ex);\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in test\\Main.java (at line 8)\n\tprivate final static String value;\n\t                            ^^^^^\nThe blank final field value may not have been initialized\n----------\n2. ERROR in test\\Main.java (at line 12)\n\tLOG.info(() -> String.format(\"Value is: %s\", value));\n\t                                             ^^^^^\nThe blank final field value may not have been initialized\n----------\n");
    }

    public void testBug446691_comment14b() {
        this.runNegativeTest(new String[]{"test/Main.java", "package test;\n\nimport java.util.logging.Logger;\n\npublic class Main {\n\n\tprivate static final Logger LOG = Logger.getLogger(\"test\");\n\tprivate final static String value;\n\n\tstatic {\n\t\ttry {\n\t\t\tLOG.info(() -> String.format(\"Value is: %s\", value));\n\t\t} catch (final Exception ex) {\n\t\t\tthrow new ExceptionInInitializerError(ex);\n\t\t}\n\t\tvalue = \"\";\t}\n}"}, "----------\n1. ERROR in test\\Main.java (at line 12)\n\tLOG.info(() -> String.format(\"Value is: %s\", value));\n\t                                             ^^^^^\nThe blank final field value may not have been initialized\n----------\n");
    }

    public void testBug463526() {
        this.runNegativeTest(new String[]{"Test.java", "public class Test {\n    public static void main(String[] args) {\n        Receiver r = new Receiver();\n        r.accept((l) -> (doItOnTheClass(new Object())));\n    }\n    public static void doItOnTheClass(Object o) {\n        System.out.println(\"done it\");\n    }\n    public static class Receiver {\n        public void accept(Listener l) {\n            l.doIt(new Object());\n        }\n    }\n    public static interface Listener {\n        public void doIt(Object o);\n    }\n}"}, "----------\n1. ERROR in Test.java (at line 4)\n\tr.accept((l) -> (doItOnTheClass(new Object())));\n\t  ^^^^^^\nThe method accept(Test.Listener) in the type Test.Receiver is not applicable for the arguments ((<no type> l) -> {})\n----------\n2. ERROR in Test.java (at line 4)\n\tr.accept((l) -> (doItOnTheClass(new Object())));\n\t                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nInvalid expression as statement\n----------\n");
    }

    public void testBug463526b() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.function.Consumer;\npublic class Test {\n    public static void main(String[] args) {\n        Receiver r = new Receiver();\n        r.process((o) -> (new Object()));\n    }\n    public static class Receiver {\n        public void process(Consumer<Object> p) {\n        }\n    }\n}"}, "----------\n1. ERROR in Test.java (at line 5)\n\tr.process((o) -> (new Object()));\n\t  ^^^^^^^\nThe method process(Consumer<Object>) in the type Test.Receiver is not applicable for the arguments ((<no type> o) -> {})\n----------\n2. ERROR in Test.java (at line 5)\n\tr.process((o) -> (new Object()));\n\t                 ^^^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void testBug463526c() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.function.Consumer;\npublic class Test {\n    public static void main(String[] args) {\n        Receiver r = new Receiver();\n        r.assign((o) -> (o = new Object()));\n    }\n    public static class Receiver {\n        public void assign(Consumer<Object> a) {\n        }\n    }\n}"}, "----------\n1. ERROR in Test.java (at line 5)\n\tr.assign((o) -> (o = new Object()));\n\t  ^^^^^^\nThe method assign(Consumer<Object>) in the type Test.Receiver is not applicable for the arguments ((<no type> o) -> {})\n----------\n2. ERROR in Test.java (at line 5)\n\tr.assign((o) -> (o = new Object()));\n\t                ^^^^^^^^^^^^^^^^^^\nVoid methods cannot return a value\n----------\n");
    }

    public void testBug464408() {
        this.runNegativeTest(new String[]{"test/X.java", "import java.util.ArrayList;\nimport java.util.List;\npublic class X {\n   void x() {\n       List<List<String>> list = new ArrayList<>();\n       list.stream().toArray(List<String>[]::new);\n   }}"}, "----------\n1. ERROR in test\\X.java (at line 6)\n\tlist.stream().toArray(List<String>[]::new);\n\t                      ^^^^^^^^^^^^^^^^^^^\nCannot create a generic array of List<String>\n----------\n");
    }

    public void testBug465900() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\nimport java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Supplier;\npublic class X {\n\tprivate static final long serialVersionUID = 1L;\n\tprotected void x() {\n\t\tString str = \"groep.koppeling.\" + (\"\".isEmpty() ? \"toevoegen\" : \"bewerken\");\n\t\tList<String> bean = new ArrayList<>();\n\t\ttest(bean.get(0)::isEmpty);\n\t}\n\tprivate void test(SerializableSupplier<Boolean> test) {}\n}\n@FunctionalInterface\ninterface SerializableSupplier<T> extends Supplier<T>, Serializable {}\n"}, "");
    }

    public void testBug477888() {
        this.runNegativeTest(new String[]{"Test.java", "import java.io.IOException;\nimport java.nio.file.Files;\nimport java.nio.file.Paths;\nimport java.util.function.Consumer;\npublic class Test {\n\tpublic static void main(String[] args) throws IOException {\n\t\tFiles.lines(Paths.get(args[0])).filter(x -> {return !x.startsWith(\".\");}).forEach(printMe());\n\t}\n\tprivate static Consumer<String> printMe() {\n\t\treturn x -> x.isEmpty() ? System.out.println() : System.out.println(getIndex() + \" \" + x); // error must be reported here!\n\t}\n\tstatic int idx;\n\n\tprivate static int getIndex() {\n\t\treturn ++idx;\n\t}\n}\n"}, "----------\n1. ERROR in Test.java (at line 10)\n\treturn x -> x.isEmpty() ? System.out.println() : System.out.println(getIndex() + \" \" + x); // error must be reported here!\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nInvalid expression as statement\n----------\n");
    }

    public void testBug472648() {
        this.runNegativeTest(new String[]{"Test.java", "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Consumer;\npublic class Test {\n\tpublic static void main(String argv[]) {\n\t\tnew Test();\n\t}\n\tpublic Test() {\n\t\tList<Number> numList = new ArrayList<>();\n\t\tnumList.add(1);\n\t\tnumList.add(1.5);\n\t\tnumList.add(2);\n\t\tnumList.add(2.5);\n\t\tforEachValueOfType(numList, Integer.class, (Integer i) -> (System.out.println(Integer.toString(i))));\n\t}\n\tprivate <T> void forEachValueOfType(List<?> list, Class<T> type, Consumer<T> action) {\n\t\t\n\t\tfor (Object o : list) {\n\t\t\tif (type.isAssignableFrom(o.getClass())) {\n\t\t\t\t@SuppressWarnings(\"unchecked\")\n\t\t\t\tT convertedObject = (T) o;\n\t\t\t\taction.accept(convertedObject);\n\t\t\t}\n\t\t}\n\t}\n}"}, "----------\n1. ERROR in Test.java (at line 14)\n\tforEachValueOfType(numList, Integer.class, (Integer i) -> (System.out.println(Integer.toString(i))));\n\t^^^^^^^^^^^^^^^^^^\nThe method forEachValueOfType(List<?>, Class<T>, Consumer<T>) in the type Test is not applicable for the arguments (List<Number>, Class<Integer>, (Integer i) -> {})\n----------\n2. ERROR in Test.java (at line 14)\n\tforEachValueOfType(numList, Integer.class, (Integer i) -> (System.out.println(Integer.toString(i))));\n\t                                            ^^^^^^^\nIncompatible type specified for lambda expression's parameter i\n----------\n3. ERROR in Test.java (at line 14)\n\tforEachValueOfType(numList, Integer.class, (Integer i) -> (System.out.println(Integer.toString(i))));\n\t                                                          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nInvalid expression as statement\n----------\n");
    }

    public void testBug473432() {
        this.runConformTest(new String[]{"Tester.java", "import java.util.function.Function;\npublic class Tester {\n\tprivate static class ValueWrapper<O> {\n\t\tprivate O val_;\n\t\tpublic ValueWrapper(O val) {\n\t\t\tval_ = val;\n\t\t}\n\t\tpublic <R> R mapOrElse(Function<O, R> func, R defaultValue) {\n\t\t\tif(val_ != null) {\n\t\t\t\treturn func.apply(val_);\n\t\t\t}\n\t\t\treturn defaultValue;\n\t\t}\n\t}\n\tprivate static void handleObject(Object object) {\n\t\tSystem.out.println(\"Handled: \" + object);\n\t}\n\tpublic static void main(String[] args) {\n\t\tValueWrapper<String> wrapper = new ValueWrapper<>(\"value\");\n\t\tboolean skipMethod = false;\n\t\t// works on both JDT 3.9.2 and 3.11.0\n\t\tBoolean result = skipMethod ? true : wrapper.mapOrElse(v -> false, null);\n\t\tSystem.out.println(result);\n\t\twrapper = new ValueWrapper<>(null);\n\t\t// works on JDT 3.9.2\n\t\thandleObject(skipMethod ?\n\t\t\t\ttrue :\n\t\t\t\twrapper.mapOrElse(v -> false, null));\n\t\twrapper = new ValueWrapper<>(null);\n\t\t// works on neither version\n\t\tresult = skipMethod ?\n\t\t\t\ttrue :\n\t\t\t\twrapper.mapOrElse(v -> false, null);\n\t\tSystem.out.println(result);\n\t}\n}\n"}, "false\nHandled: null\nnull");
    }

    public void testBug511676() {
        this.runConformTest(new String[]{"A.java", "import java.util.function.Function;\npublic class A {\n    interface C<T> { }\n    interface O<T> {\n        Object r(C<T> s);\n    }\n    static <T, R> O<R> m(O<T> source, Function<T, O<R>> mapper) {\n        return o -> {\n            class D {\n            \tclass E {\n                }\n                E e = new E();\n            }\n            D d = new D();\n            return d.e;\n        };\n    }\n    public static void main(String[] args) {\n        m(null, null);\n        System.out.println(\" Done\");\n    }\n}\n"}, "Done");
    }

    public void testBug511676a() {
        this.runConformTest(new String[]{"A.java", "public class A {\n    interface C<T> { }\n    interface O<T> {\n        Object r(C<T> s);\n    }\n    static O<Object> def = o -> {\n        class D {\n        \tclass E {\n            }\n            E e = new E();\n        }\n        D d = new D();\n        return d.e;\n    };\n    public static void main(String[] args) {\n        O<Object> o = A.def;\n        System.out.println(\" Done\");\n    }\n}\n"}, "Done");
    }

    public static Class testClass() {
        return LambdaRegressionTest.class;
    }
}

