/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractNullAnnotationTest;

public class NullChecksTests
extends AbstractNullAnnotationTest {
    public NullChecksTests(String name) {
        super(name);
    }

    public static Test suite() {
        return NullChecksTests.buildMinimalComplianceTestSuite(NullChecksTests.testClass(), 32);
    }

    public static Class<NullChecksTests> testClass() {
        return NullChecksTests.class;
    }

    public void testAssertNonNull1() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport static org.eclipse.jdt.annotation.Checks.*;\npublic class X {\n\t@SuppressWarnings(\"null\")\n\tstatic @NonNull String hide(String some) {\n\t\treturn some;\n\t}\n\tpublic static void main(String... args) {\n\t\t@NonNull String myHiddenNull = hide(null);\n\t\ttry {\n\t\t\tassertNonNull(\"foo\", myHiddenNull);\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(npe.getMessage());\n\t\t}\n\t\ttry {\n\t\t\tassertNonNullWithMessage(\"Shouldn't!\", \"foo\", myHiddenNull);\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(npe.getMessage());\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "", "Value in position 1 must not be null\nShouldn't!");
    }

    public void testAssertNonNullElements() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport static org.eclipse.jdt.annotation.Checks.*;\nimport java.util.*;\npublic class X {\n\t@SuppressWarnings(\"null\")\n\tstatic @NonNull String hide(String some) {\n\t\treturn some;\n\t}\n\tpublic static void main(String... args) {\n\t\t@NonNull List<String> myList = new ArrayList<>();\n\t\tmyList.add(\"foo\");\n\t\tmyList.add(null);\n\t\ttry {\n\t\t\tassertNonNullElements(myList);\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(npe.getMessage());\n\t\t}\n\t\t@NonNull List<@NonNull String> myList2 = new ArrayList<>();\n\t\tmyList2.add(\"foo\");\n\t\tmyList2.add(hide(null));\n\t\ttry {\n\t\t\tassertNonNullElements(myList2, \"Shouldn't!\");\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(npe.getMessage());\n\t\t}\n\t}\n}\n"}, this.getCompilerOptions(), "", "Value in position 1 must not be null\nShouldn't!");
    }

    public void testRequireNonNull() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport static org.eclipse.jdt.annotation.Checks.*;\npublic class X {\n\t@SuppressWarnings(\"null\")\n\tstatic @NonNull String hide(String some) {\n\t\treturn some;\n\t}\n\tstatic void test(@Nullable String str, @Nullable X x) {\n\t\t@NonNull String nnStr;\n\t\t@NonNull X nnX;\n\t\ttry {\n\t\t\tnnStr = requireNonNull(str);\n\t\t\tnnX = requireNonNull(null, \"Shouldn't!\");\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(npe.getMessage());\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\ttest(\"foo\", null);\n\t}\n}\n"}, this.getCompilerOptions(), "", "Shouldn't!");
    }

    public void testRequireNonEmptyString() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport static org.eclipse.jdt.annotation.Checks.*;\npublic class X {\n\t@SuppressWarnings(\"null\")\n\tstatic @NonNull String hide(String some) {\n\t\treturn some;\n\t}\n\tstatic void test(@Nullable String str1, @Nullable String str2) {\n\t\t@NonNull String nnStr;\n\t\ttry {\n\t\t\tnnStr = requireNonEmpty(str1);\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(\"npe:\"+npe.getMessage());\n\t\t}\n\t\ttry {\n\t\t\tnnStr = requireNonEmpty(str2, \"Shouldn't!\");\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(\"npe\"+npe.getMessage());\n\t\t} catch (IllegalArgumentException iae) {\n\t\t\tSystem.out.println(iae.getMessage());\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\ttest(null, \"\");\n\t}\n}\n"}, this.getCompilerOptions(), "", "npe:null\nShouldn't!");
    }

    public void testRequireNonEmptyCollection() {
        this.runConformTestWithLibs(new String[]{"X.java", "import java.util.*;\nimport org.eclipse.jdt.annotation.*;\nimport static org.eclipse.jdt.annotation.Checks.*;\npublic class X {\n\tstatic void test(@Nullable Collection<String> strs, @Nullable Collection<String> strs1, Collection<String> strs2) {\n\t\t@NonNull Collection<String> nnStrs;\n\t\ttry {\n\t\t\tnnStrs = requireNonEmpty(strs);\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(\"NPE:\"+npe.getMessage());\n\t\t}\n\t\ttry {\n\t\t\tnnStrs = requireNonEmpty(strs1);\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(\"npe:\"+npe.getMessage());\n\t\t}\n\t\ttry {\n\t\t\tnnStrs = requireNonEmpty(strs2, \"Shouldn't!\");\n\t\t} catch (NullPointerException npe) {\n\t\t\tSystem.out.println(\"npe\"+npe.getMessage());\n\t\t} catch (IllegalArgumentException iae) {\n\t\t\tSystem.out.println(iae.getMessage());\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\ttest(Collections.singletonList(\"good\"), null, Collections.emptyList());\n\t}\n}\n"}, this.getCompilerOptions(), "", "npe:null\nShouldn't!");
    }

    public void testIsNull() {
        Map compilerOptions = this.getCompilerOptions();
        compilerOptions.put("org.eclipse.jdt.core.compiler.problem.suppressOptionalErrors", "enabled");
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport static org.eclipse.jdt.annotation.Checks.*;\npublic class X {\n\t@SuppressWarnings(\"null\")\n\tstatic <T> @NonNull T hide(T some) {\n\t\treturn some;\n\t}\n\tstatic void test(@NonNull X x1, @NonNull X x2, @NonNull X x3) {\n\t\tif (isNull(x1))\n\t\t\tSystem.out.println(\"IS NULL\");\n\t\tif (isAnyNull(x2, x1))\n\t\t\tSystem.out.println(\"IS ANY NULL 1\");\n\t\tif (isAnyNull(x2, x3))\n\t\t\tSystem.out.println(\"IS ANY NULL 2\");\n\t}\n\tpublic static void main(String... args) {\n\t\ttest(hide(null), new X(), new X());\n\t}\n}\n"}, compilerOptions, "", "IS NULL\nIS ANY NULL 1");
    }

    public void testAsNullable() {
        this.runConformTestWithLibs(new String[]{"X.java", "import java.util.*;\nimport static org.eclipse.jdt.annotation.Checks.*;\npublic class X {\n\tstatic void test(Optional<X> xopt) {\n\t\tif (xopt != null) {\n\t\t\tX x = asNullable(xopt);\n\t\t\tif (x == null)\n\t\t\t\tSystem.out.println(\"NULL\");\n\t\t}\n\t}\n\tpublic static void main(String... args) {\n\t\ttest(Optional.ofNullable(null));\n\t}\n}\n"}, this.getCompilerOptions(), "", "NULL");
    }

    public void testNonNullElse() {
        this.runConformTestWithLibs(new String[]{"X.java", "import java.util.function.*;\nimport org.eclipse.jdt.annotation.*;\nimport static org.eclipse.jdt.annotation.Checks.*;\npublic class X {\n\tstatic void test(String str, String noStr, @NonNull Supplier<@NonNull String> prov) {\n\t\tSystem.out.println(nonNullElse(str, \"ELSE1\"));\n\t\tSystem.out.println(nonNullElse(noStr, \"ELSE2\"));\n\t\tSystem.out.println(nonNullElseGet(str, () -> \"ELSE3\"));\n\t\tSystem.out.println(nonNullElseGet(noStr, prov));\n\t}\n\tpublic static void main(String... args) {\n\t\ttest(\"good\", null, () -> \"ELSE4\");\n\t}\n}\n"}, this.getCompilerOptions(), "", "good\nELSE2\ngood\nELSE4");
    }

    public void _testIfNonNull() {
        this.runConformTestWithLibs(new String[]{"X.java", "import org.eclipse.jdt.annotation.*;\nimport static org.eclipse.jdt.annotation.Checks.*;\npublic class X {\n\tstatic void test(@Nullable String str) {\n\t\tifNonNull(str, s -> print(s));\n\t}\n\tstatic void print(@NonNull String s) {\n\t\tSystem.out.print(s);\n\t}\n\tpublic static void main(String... args) {\n\t\ttest(\"good\");\n\t}\n}\n"}, this.getCompilerOptions(), "", "good");
    }
}

