/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.dom;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;

public class StandAloneASTParserTest
extends AbstractRegressionTest {
    private static final int AST_JLS_LATEST = 10;

    public StandAloneASTParserTest(String name) {
        super(name);
    }

    public ASTNode runConversion(int astLevel, String source, boolean resolveBindings, boolean statementsRecovery, boolean bindingsRecovery, String unitName) {
        ASTParser parser = ASTParser.newParser((int)astLevel);
        parser.setSource(source.toCharArray());
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(resolveBindings);
        parser.setStatementsRecovery(statementsRecovery);
        parser.setBindingsRecovery(bindingsRecovery);
        parser.setCompilerOptions(this.getCompilerOptions());
        parser.setUnitName(unitName);
        return parser.createAST(null);
    }

    public void testBug529654_001() {
        String contents = "module m {\n}";
        ASTParser parser = ASTParser.newParser((int)10);
        parser.setSource(contents.toCharArray());
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setUnitName("module-info.java");
        Map<String, String> options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.compliance", "9");
        options.put("org.eclipse.jdt.core.compiler.source", "9");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "9");
        parser.setCompilerOptions(options);
        ASTNode node = parser.createAST(null);
        StandAloneASTParserTest.assertTrue((String)"Should be a compilation unit", (boolean)(node instanceof CompilationUnit));
        CompilationUnit unit = (CompilationUnit)node;
        ModuleDeclaration module = unit.getModule();
        StandAloneASTParserTest.assertTrue((String)"Incorrect Module Name", (boolean)module.getName().getFullyQualifiedName().equals("m"));
    }

    public void test1() {
        String contents = "package p;\npublic class X {\n\tpublic int i;\n\tpublic static void main(String[] args) {\n\t\tint length = args.length;\n\t\tSystem.out.println(length);\n\t}\n}";
        ASTNode node = this.runConversion(10, contents, true, true, true, "p/X.java");
        StandAloneASTParserTest.assertTrue((String)"Should be a compilation unit", (boolean)(node instanceof CompilationUnit));
        CompilationUnit unit = (CompilationUnit)node;
        List types = unit.types();
        TypeDeclaration typeDeclaration = (TypeDeclaration)types.get(0);
        ITypeBinding binding = typeDeclaration.resolveBinding();
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)binding);
        StandAloneASTParserTest.assertNull((String)"Got a java element", (Object)binding.getJavaElement());
        StandAloneASTParserTest.assertEquals("Wrong name", "p.X", binding.getQualifiedName());
        MethodDeclaration methodDeclaration = (MethodDeclaration)typeDeclaration.bodyDeclarations().get(1);
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)methodBinding);
        StandAloneASTParserTest.assertNull((String)"Got a java element", (Object)methodBinding.getJavaElement());
        Block body = methodDeclaration.getBody();
        VariableDeclarationStatement statement = (VariableDeclarationStatement)body.statements().get(0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)statement.fragments().get(0);
        IVariableBinding variableBinding = fragment.resolveBinding();
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)variableBinding);
        StandAloneASTParserTest.assertNull((String)"Got a java element", (Object)variableBinding.getJavaElement());
        ExpressionStatement statement2 = (ExpressionStatement)body.statements().get(1);
        Expression expression = statement2.getExpression();
        MethodInvocation invocation = (MethodInvocation)expression;
        Expression expression2 = invocation.getExpression();
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)expression2.resolveTypeBinding());
        FieldDeclaration fieldDeclaration = (FieldDeclaration)typeDeclaration.bodyDeclarations().get(0);
        VariableDeclarationFragment fragment2 = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
        IVariableBinding variableBinding2 = fragment2.resolveBinding();
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)variableBinding2);
        StandAloneASTParserTest.assertNull((String)"Got a java element", (Object)variableBinding2.getJavaElement());
    }

    public void test2() {
        ASTParser parser = ASTParser.newParser((int)10);
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setCompilerOptions(this.getCompilerOptions());
        final IBinding[] bindings = new IBinding[1];
        FileASTRequestor requestor = new FileASTRequestor(){

            public void acceptBinding(String bindingKey, IBinding binding) {
                if ("Ljava/lang/String;".equals(bindingKey)) {
                    bindings[0] = binding;
                }
            }
        };
        parser.createASTs(new String[0], null, new String[]{"Ljava/lang/String;"}, requestor, null);
        StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)bindings[0]);
        StandAloneASTParserTest.assertEquals((String)"Wrong type of binding", (int)2, (int)bindings[0].getKind());
        ITypeBinding typeBinding = (ITypeBinding)bindings[0];
        StandAloneASTParserTest.assertEquals("Wrong binding", "java.lang.String", typeBinding.getQualifiedName());
        StandAloneASTParserTest.assertNull((String)"No java element", (Object)typeBinding.getJavaElement());
    }

    public void test3() throws IOException {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        ASTParser parser = ASTParser.newParser((int)10);
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setCompilerOptions(this.getCompilerOptions());
        final IBinding[] bindings = new IBinding[1];
        String contents = "package p;\npublic class X extends Y {\n\tpublic int i;\n\tpublic static void main(String[] args) {\n\t\tint length = args.length;\n\t\tSystem.out.println(length);\n\t}\n}";
        File packageDir = new File(rootDir, "p");
        packageDir.mkdir();
        File file = new File(packageDir, "X.java");
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        String contents2 = "package p;\npublic class Y {}";
        File fileY = new File(packageDir, "Y.java");
        Writer writer2 = null;
        try {
            writer2 = new BufferedWriter(new FileWriter(fileY));
            writer2.write(contents2);
        }
        catch (Throwable throwable) {
            if (writer2 != null) {
                try {
                    writer2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer2 != null) {
            try {
                writer2.close();
            }
            catch (IOException iOException) {}
        }
        try {
            final String canonicalPath = file.getCanonicalPath();
            final CompilationUnit[] units = new CompilationUnit[1];
            FileASTRequestor requestor = new FileASTRequestor(){

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if ("Lp/X;".equals(bindingKey)) {
                        bindings[0] = binding;
                    }
                }

                public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                    if (canonicalPath.equals(sourceFilePath)) {
                        units[0] = ast;
                    }
                }
            };
            parser.setEnvironment(null, new String[]{rootDir.getCanonicalPath()}, null, true);
            parser.createASTs(new String[]{canonicalPath}, null, new String[]{"Lp/X;"}, requestor, null);
            StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)bindings[0]);
            StandAloneASTParserTest.assertEquals((String)"Wrong type of binding", (int)2, (int)bindings[0].getKind());
            ITypeBinding typeBinding = (ITypeBinding)bindings[0];
            StandAloneASTParserTest.assertEquals("Wrong binding", "p.X", typeBinding.getQualifiedName());
            StandAloneASTParserTest.assertNull((String)"No java element", (Object)typeBinding.getJavaElement());
            StandAloneASTParserTest.assertNotNull((String)"No ast", (Object)units[0]);
            StandAloneASTParserTest.assertEquals((String)"No problem", (int)0, (int)units[0].getProblems().length);
        }
        finally {
            file.delete();
            fileY.delete();
        }
    }

    public void test4() {
        ASTParser parser = ASTParser.newParser((int)10);
        try {
            parser.setEnvironment(null, null, new String[]{"UTF-8"}, true);
            StandAloneASTParserTest.assertTrue((String)"Should have failed", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void test5() {
        ASTParser parser = ASTParser.newParser((int)10);
        try {
            parser.setEnvironment(null, new String[0], new String[]{"UTF-8"}, true);
            StandAloneASTParserTest.assertTrue((String)"Should have failed", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void test6() throws IOException {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        ASTParser parser = ASTParser.newParser((int)10);
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setCompilerOptions(this.getCompilerOptions());
        final IBinding[] bindings = new IBinding[2];
        String contents = "package p;\npublic class X extends Y {\n\tpublic int i;\n\tpublic static void main(String[] args) {\n\t\tint length = args.length;\n\t\tSystem.out.println(length);\n\t}\n}";
        File packageDir = new File(rootDir, "p");
        packageDir.mkdir();
        File file = new File(packageDir, "X.java");
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        String contents2 = "package p;\npublic class Y {}";
        File fileY = new File(packageDir, "Y.java");
        Writer writer2 = null;
        try {
            writer2 = new BufferedWriter(new FileWriter(fileY));
            writer2.write(contents2);
        }
        catch (Throwable throwable) {
            if (writer2 != null) {
                try {
                    writer2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer2 != null) {
            try {
                writer2.close();
            }
            catch (IOException iOException) {}
        }
        try {
            final String canonicalPath = file.getCanonicalPath();
            final CompilationUnit[] units = new CompilationUnit[1];
            FileASTRequestor requestor = new FileASTRequestor(){

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if ("Lp/X;".equals(bindingKey)) {
                        bindings[0] = binding;
                        IBinding[] temp = this.createBindings(new String[]{"Ljava/lang/Object;"});
                        int i = 0;
                        while (i < temp.length) {
                            bindings[i + 1] = temp[i];
                            ++i;
                        }
                    }
                }

                public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                    if (canonicalPath.equals(sourceFilePath)) {
                        units[0] = ast;
                    }
                }
            };
            parser.setEnvironment(null, new String[]{rootDir.getCanonicalPath()}, null, true);
            parser.createASTs(new String[]{canonicalPath}, null, new String[]{"Lp/X;"}, requestor, null);
            StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)bindings[0]);
            StandAloneASTParserTest.assertEquals((String)"Wrong type of binding", (int)2, (int)bindings[0].getKind());
            ITypeBinding typeBinding = (ITypeBinding)bindings[0];
            StandAloneASTParserTest.assertEquals("Wrong binding", "p.X", typeBinding.getQualifiedName());
            StandAloneASTParserTest.assertNull((String)"No java element", (Object)typeBinding.getJavaElement());
            IPackageBinding packageBinding = typeBinding.getPackage();
            StandAloneASTParserTest.assertNull((String)"No java element", (Object)packageBinding.getJavaElement());
            StandAloneASTParserTest.assertNotNull((String)"No ast", (Object)units[0]);
            StandAloneASTParserTest.assertEquals((String)"No problem", (int)0, (int)units[0].getProblems().length);
            StandAloneASTParserTest.assertNotNull((String)"No binding", (Object)bindings[1]);
            StandAloneASTParserTest.assertEquals((String)"Wrong type of binding", (int)2, (int)bindings[1].getKind());
            typeBinding = (ITypeBinding)bindings[1];
            StandAloneASTParserTest.assertEquals("Wrong binding", "java.lang.Object", typeBinding.getQualifiedName());
        }
        finally {
            file.delete();
            fileY.delete();
        }
    }

    public void testBug415066_001() throws IOException {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setCompilerOptions(this.getCompilerOptions());
        final IBinding[] bindings = new IBinding[2];
        String contents = "package p;\npublic class A{}\nclass B{}";
        File packageDir = new File(rootDir, "p");
        packageDir.mkdir();
        File file = new File(packageDir, "A.java");
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        String contents2 = "package p;\npublic class C extends B {}";
        File fileY = new File(packageDir, "C.java");
        Writer writer2 = null;
        try {
            writer2 = new BufferedWriter(new FileWriter(fileY));
            writer2.write(contents2);
        }
        catch (Throwable throwable) {
            if (writer2 != null) {
                try {
                    writer2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer2 != null) {
            try {
                writer2.close();
            }
            catch (IOException iOException) {}
        }
        try {
            final String canonicalPath = fileY.getCanonicalPath();
            final CompilationUnit[] units = new CompilationUnit[1];
            FileASTRequestor requestor = new FileASTRequestor(){

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if ("Lp/C;".equals(bindingKey)) {
                        bindings[0] = binding;
                        IBinding[] temp = this.createBindings(new String[]{"Lp/C;"});
                        int i = 0;
                        while (i < temp.length) {
                            bindings[i + 1] = temp[i];
                            ++i;
                        }
                    }
                }

                public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                    if (canonicalPath.equals(sourceFilePath)) {
                        units[0] = ast;
                    }
                }
            };
            parser.setEnvironment(null, new String[]{rootDir.getCanonicalPath()}, null, true);
            AbstractImageBuilder.MAX_AT_ONCE = 0;
            parser.createASTs(new String[]{canonicalPath}, null, new String[]{"Lp/C;"}, requestor, null);
            StandAloneASTParserTest.assertNotNull((String)"No ast", (Object)units[0]);
            StandAloneASTParserTest.assertEquals((String)"No problem", (int)0, (int)units[0].getProblems().length);
        }
        finally {
            file.delete();
            fileY.delete();
        }
    }

    public void testBug415066_002() throws IOException {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setEnvironment(null, null, null, true);
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setCompilerOptions(this.getCompilerOptions());
        final IBinding[] bindings = new IBinding[2];
        String contents = "package p;\npublic class A{}\nclass B{}";
        File packageDir = new File(rootDir, "p");
        packageDir.mkdir();
        File file = new File(packageDir, "A.java");
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        String contents2 = "package q;\nimport p.*;\npublic class C extends B {}";
        File fileY = new File(packageDir, "C.java");
        Writer writer2 = null;
        try {
            writer2 = new BufferedWriter(new FileWriter(fileY));
            writer2.write(contents2);
        }
        catch (Throwable throwable) {
            if (writer2 != null) {
                try {
                    writer2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer2 != null) {
            try {
                writer2.close();
            }
            catch (IOException iOException) {}
        }
        try {
            final String canonicalPath = fileY.getCanonicalPath();
            final CompilationUnit[] units = new CompilationUnit[1];
            FileASTRequestor requestor = new FileASTRequestor(){

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if ("Lp/C;".equals(bindingKey)) {
                        bindings[0] = binding;
                        IBinding[] temp = this.createBindings(new String[]{"Lq/C;"});
                        int i = 0;
                        while (i < temp.length) {
                            bindings[i + 1] = temp[i];
                            ++i;
                        }
                    }
                }

                public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                    if (canonicalPath.equals(sourceFilePath)) {
                        units[0] = ast;
                    }
                }
            };
            parser.setEnvironment(null, new String[]{rootDir.getCanonicalPath()}, null, true);
            parser.createASTs(new String[]{canonicalPath}, null, new String[]{"Lp/C;"}, requestor, null);
            StandAloneASTParserTest.assertNotNull((String)"No ast", (Object)units[0]);
            IProblem[] problems = units[0].getProblems();
            StandAloneASTParserTest.assertEquals((String)"No problem", (int)1, (int)problems.length);
            StandAloneASTParserTest.assertEquals("Pb(3) The type B is not visible", problems[0].toString());
        }
        finally {
            file.delete();
            fileY.delete();
        }
    }

    public void test7() throws IOException {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        String contents = "enum X {\n              /** */\n    FOO\n}";
        File file = new File(rootDir, "X.java");
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        String contents2 = "package p;\nclass Y {}";
        File packageDir = new File(rootDir, "p");
        packageDir.mkdir();
        File fileY = new File(packageDir, "Y.java");
        Writer writer2 = null;
        try {
            writer2 = new BufferedWriter(new FileWriter(fileY));
            writer2.write(contents2);
        }
        catch (Throwable throwable) {
            if (writer2 != null) {
                try {
                    writer2.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer2 != null) {
            try {
                writer2.close();
            }
            catch (IOException iOException) {}
        }
        try {
            ASTParser parser = ASTParser.newParser((int)10);
            parser.setKind(8);
            parser.setCompilerOptions((Map)JavaCore.getOptions());
            parser.createASTs(new String[]{file.getCanonicalPath(), fileY.getCanonicalPath()}, null, new String[0], new FileASTRequestor(){}, null);
        }
        finally {
            file.delete();
            fileY.delete();
        }
    }

    public void testBug461250() {
        String source = "class QH<T> implements QR.Q {\n  QR.Q q;\n  @V(v = A, d = \"\") Map p;\n}\n";
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.7", (Map)options);
        ASTParser parser = ASTParser.newParser((int)10);
        parser.setCompilerOptions((Map)options);
        parser.setKind(8);
        parser.setSource(source.toCharArray());
        parser.setResolveBindings(true);
        String[] emptyStringArray = new String[]{};
        parser.setEnvironment(emptyStringArray, emptyStringArray, emptyStringArray, true);
        parser.setUnitName("dontCare");
        ASTNode ast = parser.createAST(null);
        StandAloneASTParserTest.assertTrue((String)"should have parsed a CUD", (boolean)(ast instanceof CompilationUnit));
    }

    @Deprecated
    public void testBug465048() {
        String source = "class A {\n  void f(OtherClass otherClass) {\n    synchronized (otherClass) {\n      Class c = InnerClass.class;\n    }\n  }\n  class InnerClass { }\n}\n";
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.7", (Map)options);
        ASTParser parser = ASTParser.newParser((int)9);
        parser.setCompilerOptions((Map)options);
        parser.setKind(8);
        parser.setSource(source.toCharArray());
        parser.setResolveBindings(true);
        String[] emptyStringArray = new String[]{};
        parser.setEnvironment(emptyStringArray, emptyStringArray, emptyStringArray, true);
        parser.setUnitName("dontCare");
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        SimpleName innerClassLiteral = (SimpleName)NodeFinder.perform((ASTNode)cu, (int)cu.getPosition(4, 16), (int)1);
        ITypeBinding innerClassBinding = (ITypeBinding)innerClassLiteral.resolveBinding();
        StandAloneASTParserTest.assertEquals("InnerClass", innerClassBinding.getName());
    }

    public void testBug480545() {
        String input = "class Test2 { void f(Test2... xs) {} }";
        ASTParser parser = ASTParser.newParser((int)9);
        parser.setSource(input.toCharArray());
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.8", (Map)options);
        parser.setCompilerOptions((Map)options);
        StandAloneASTParserTest.assertNotNull((Object)parser.createAST(null));
    }

    @Deprecated
    public void testBug493336_001() {
        String input = "public class X implements \u00e1\u00bc\u00b3 {\n  public static final class if {\n    public static final if \u00cb\u0160 = new if(null, null, null, null);\n  }\n}";
        ASTParser parser = ASTParser.newParser((int)9);
        parser.setSource(input.toCharArray());
        parser.setResolveBindings(true);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setKind(8);
        parser.setEnvironment(null, new String[1], null, true);
        Hashtable options1 = JavaCore.getDefaultOptions();
        options1.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
        options1.put("org.eclipse.jdt.core.compiler.source", "1.8");
        options1.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        parser.setCompilerOptions((Map)options1);
        StandAloneASTParserTest.assertNotNull((Object)parser.createAST(null));
    }

    @Deprecated
    public void testBug526996_001() {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        String contents = "public class X {\n    public X() {\n        this.f16132b =\n/*\n        at jadx.api.JavaClass.decompile(JavaClass.java:62)\n*/\n\n            /* JADX WARNING: inconsistent code. */\n            /* Code decompiled incorrectly, please refer to instructions dump. */\n            public final C1984r m22030a() {\n            }\n        }\n\n";
        File file = new File(rootDir, "X.java");
        Writer writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(contents);
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        String contents2 = "public class Y {\n\n    /* JADX WARNING: inconsistent code. */\n    protected void finalize() {\n        for (i =\n/*\n        at jadx.core.codegen.InsnGen.makeInsn(InsnGen.java:220)\n*/\n        public void close() { }\n    }\n";
        File fileY = new File(rootDir, "Y.java");
        Writer writer2 = null;
        try {
            try {
                writer2 = new BufferedWriter(new FileWriter(fileY));
                writer2.write(contents2);
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            try {
                if (writer2 != null) {
                    writer2.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (writer2 != null) {
                writer2.close();
            }
        }
        catch (IOException iOException) {}
        try {
            FileASTRequestor astRequestor = new FileASTRequestor(){

                public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                    super.acceptAST(sourceFilePath, ast);
                    System.out.println(sourceFilePath);
                }
            };
            ASTParser parser = ASTParser.newParser((int)9);
            parser.setResolveBindings(true);
            parser.setStatementsRecovery(true);
            parser.setBindingsRecovery(true);
            parser.setKind(8);
            parser.setEnvironment(new String[0], new String[]{rootDir.getAbsolutePath()}, null, true);
            String[] files = null;
            try {
                files = new String[]{file.getCanonicalPath(), fileY.getCanonicalPath()};
                System.out.println("Building...");
                parser.createASTs(files, null, new String[0], astRequestor, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            file.delete();
            fileY.delete();
        }
    }

    public void testBug530299_001() {
        String contents = "public class X {\n\tpublic static void main(String[] args) {\n\t\tvar x = new X();\n       for (var i = 0; i < 10; ++i) {}\n\t}\n}";
        ASTParser parser = ASTParser.newParser((int)10);
        parser.setSource(contents.toCharArray());
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setKind(8);
        parser.setEnvironment(null, new String[1], null, true);
        parser.setResolveBindings(true);
        ASTNode node = parser.createAST(null);
        StandAloneASTParserTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        CompilationUnit cu = (CompilationUnit)node;
        StandAloneASTParserTest.assertTrue((String)"Problems in compilation", (cu.getProblems().length == 0 ? 1 : 0) != 0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)cu.types().get(0);
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        MethodDeclaration methodDeclaration = methods[0];
        VariableDeclarationStatement vStmt = (VariableDeclarationStatement)methodDeclaration.getBody().statements().get(0);
        Type type = vStmt.getType();
        StandAloneASTParserTest.assertNotNull((Object)type);
        StandAloneASTParserTest.assertTrue((String)"not a var", (boolean)type.isVar());
    }
}

