/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.eval;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.util.Locale;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.runtime.LocalVMLauncher;
import org.eclipse.jdt.core.tests.runtime.LocalVirtualMachine;
import org.eclipse.jdt.core.tests.runtime.TargetException;
import org.eclipse.jdt.core.tests.runtime.TargetInterface;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.eval.EvaluationContext;
import org.eclipse.jdt.internal.eval.GlobalVariable;
import org.eclipse.jdt.internal.eval.IRequestor;

public class SimpleTest {
    static final String JRE_PATH = Util.getJREDirectory();
    static final String[] COMPILATION_CLASSPATH = Util.concatWithClassLibs(Util.getOutputDirectory(), false);
    static final String[] RUNTIME_CLASSPATH = new String[]{Util.getOutputDirectory()};
    static final String TARGET_PATH = String.valueOf(Util.getOutputDirectory()) + File.separator + "evaluation";
    protected EvaluationContext context;
    protected LocalVirtualMachine launchedVM;
    protected TargetInterface target;
    protected Requestor requestor;

    protected char[] buildCharArray(String[] lines) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            buffer.append(lines[i]);
            if (i < lines.length - 1) {
                buffer.append("\n");
            }
            ++i;
        }
        int length = buffer.length();
        char[] result = new char[length];
        buffer.getChars(0, length, result, 0);
        return result;
    }

    protected String errorReportSource(DefaultProblem problem, char[] source) {
        char c;
        if (problem.getSourceStart() > problem.getSourceEnd() || problem.getSourceStart() < 0 && problem.getSourceEnd() < 0) {
            return "\n!! no source information available !!";
        }
        int begin = problem.getSourceStart() >= source.length ? source.length - 1 : problem.getSourceStart();
        int relativeStart = 0;
        int end = problem.getSourceEnd() >= source.length ? source.length - 1 : problem.getSourceEnd();
        relativeStart = 0;
        while (begin != 0 && source[begin - 1] != '\n' && source[begin - 1] != '\r') {
            --begin;
            ++relativeStart;
        }
        while (end + 1 < source.length && source[end + 1] != '\r' && source[end + 1] != '\n') {
            ++end;
        }
        char[] extract = new char[end - begin + 1];
        System.arraycopy(source, begin, extract, 0, extract.length);
        int trimLeftIndex = 0;
        while ((c = extract[trimLeftIndex++]) == '\t' || c == ' ') {
        }
        char[] cArray = extract;
        extract = new char[extract.length - trimLeftIndex + 1];
        System.arraycopy(cArray, trimLeftIndex - 1, extract, 0, extract.length);
        relativeStart -= trimLeftIndex;
        int pos = 0;
        char[] underneath = new char[extract.length];
        int i = 0;
        while (i <= relativeStart) {
            underneath[pos++] = extract[i] == '\t' ? 9 : 32;
            ++i;
        }
        i = problem.getSourceStart();
        while (i <= (problem.getSourceEnd() >= source.length ? source.length - 1 : problem.getSourceEnd())) {
            underneath[pos++] = 94;
            ++i;
        }
        char[] cArray2 = underneath;
        underneath = new char[pos];
        System.arraycopy(cArray2, 0, underneath, 0, pos);
        return String.valueOf(problem.getSourceLineNumber() > 0 ? " (at line " + String.valueOf(problem.getSourceLineNumber()) + ")" : "") + "\n\t" + new String(extract) + "\n\t" + new String(underneath);
    }

    protected GlobalVariable findVar(char[] varName) {
        GlobalVariable[] vars = this.context.allVariables();
        int i = 0;
        while (i < vars.length) {
            GlobalVariable var = vars[i];
            if (CharOperation.equals((char[])var.getName(), (char[])varName)) {
                return var;
            }
            ++i;
        }
        return null;
    }

    protected INameEnvironment getEnv() {
        return new FileSystem(COMPILATION_CLASSPATH, new String[0], null);
    }

    protected IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    protected void startEvaluationContext() throws TargetException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ServerSocket server = new ServerSocket(0);){
                LocalVMLauncher launcher = LocalVMLauncher.getLauncher();
                launcher.setVMPath(JRE_PATH);
                launcher.setClassPath(RUNTIME_CLASSPATH);
                int evalPort = server.getLocalPort();
                launcher.setEvalPort(evalPort);
                launcher.setEvalTargetPath(TARGET_PATH);
                this.launchedVM = launcher.launch();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            InputStream in = SimpleTest.this.launchedVM.getInputStream();
                            int read = 0;
                            while (read != -1) {
                                try {
                                    read = in.read();
                                }
                                catch (IOException iOException) {
                                    read = -1;
                                }
                                if (read == -1) continue;
                                System.out.print((char)read);
                            }
                        }
                        catch (TargetException targetException) {}
                    }
                }.start();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            InputStream in = SimpleTest.this.launchedVM.getErrorStream();
                            int read = 0;
                            while (read != -1) {
                                try {
                                    read = in.read();
                                }
                                catch (IOException iOException) {
                                    read = -1;
                                }
                                if (read == -1) continue;
                                System.out.print((char)read);
                            }
                        }
                        catch (TargetException targetException) {}
                    }
                }.start();
                this.requestor = new Requestor();
                this.target = new TargetInterface();
                this.target.connect(server, 30000);
                this.context = new EvaluationContext();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new Error("Failed to open socket", e);
        }
    }

    protected void stopEvaluationContext() {
        try {
            this.target.disconnect();
            int retry = 0;
            while (this.launchedVM.isRunning() && ++retry < 20) {
                try {
                    Thread.sleep(retry * 100);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.launchedVM.isRunning()) {
                this.launchedVM.shutDown();
            }
            this.context = null;
        }
        catch (TargetException e) {
            throw new Error(e.getMessage());
        }
    }

    class Requestor
    implements IRequestor {
        int globalProblemCount = 0;

        Requestor() {
        }

        public boolean acceptClassFiles(ClassFile[] classFiles, char[] codeSnippetClassName) {
            try {
                SimpleTest.this.target.sendClasses(codeSnippetClassName != null, classFiles);
            }
            catch (TargetException targetException) {
                return false;
            }
            if (codeSnippetClassName != null) {
                TargetInterface.Result result = SimpleTest.this.target.getResult();
                if (result.displayString == null) {
                    System.out.println("(No explicit return value)");
                } else {
                    System.out.print("(");
                    System.out.print(result.typeName);
                    System.out.print(") ");
                    System.out.println(result.displayString);
                }
            } else {
                int i = 0;
                int length = classFiles.length;
                while (i < length) {
                    char[][] compoundName = classFiles[i].getCompoundName();
                    if (new String(compoundName[compoundName.length - 1]).startsWith("GlobalVariable")) {
                        try {
                            IBinaryField[] fields = new ClassFileReader(classFiles[i].getBytes(), null).getFields();
                            if (fields != null) {
                                int j = 0;
                                while (j < fields.length) {
                                    TargetInterface.Result result = SimpleTest.this.target.getResult();
                                    if (result.displayString == null) {
                                        System.out.println("(No explicit return value)");
                                    } else {
                                        System.out.print("(");
                                        System.out.print(result.typeName);
                                        System.out.print(") ");
                                        System.out.println(result.displayString);
                                    }
                                    ++j;
                                }
                            }
                        }
                        catch (ClassFormatException e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
            return true;
        }

        public void acceptProblem(CategorizedProblem problem, char[] fragmentSource, int fragmentKind) {
            int localErrorCount = 0;
            ++this.globalProblemCount;
            char[] source = fragmentSource;
            if (localErrorCount == 0) {
                System.out.println("----------");
            }
            if (fragmentKind == 5) {
                System.out.print(String.valueOf(this.globalProblemCount) + (problem.isError() ? ". INTERNAL ERROR" : ". INTERNAL WARNING"));
                System.out.print(" in generated compilation unit");
            } else {
                System.out.print(String.valueOf(this.globalProblemCount) + (problem.isError() ? ". ERROR" : ". WARNING"));
                System.out.print(" in ");
                switch (fragmentKind) {
                    case 4: {
                        System.out.print("package");
                        break;
                    }
                    case 3: {
                        System.out.print("import");
                        break;
                    }
                    case 2: {
                        System.out.print("code snippet");
                        break;
                    }
                    case 1: {
                        int line = problem.getSourceLineNumber();
                        if (line == -1) {
                            System.out.print("variable type");
                            source = SimpleTest.this.findVar(fragmentSource).getTypeName();
                            break;
                        }
                        if (line == 0) {
                            System.out.print("variable name");
                            source = SimpleTest.this.findVar(fragmentSource).getName();
                            break;
                        }
                        System.out.print("variable initializer");
                        source = SimpleTest.this.findVar(fragmentSource).getInitializer();
                    }
                }
            }
            System.out.println(SimpleTest.this.errorReportSource((DefaultProblem)problem, source));
            System.out.println(problem.getMessage());
            System.out.println("----------");
            if (problem.isError()) {
                ++localErrorCount;
            }
        }
    }
}

