/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.junit.extension;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.core.nd.indexer.Indexer;
import org.eclipse.test.OrderedTestSuite;
import org.eclipse.test.internal.performance.PerformanceMeterFactory;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceTestCase;

public class TestCase
extends PerformanceTestCase {
    public static final String METHOD_PREFIX = "test";
    public static String RUN_ONLY_ID;
    public static final int NO_ORDER = 0;
    public static final int ALPHABETICAL_SORT = 1;
    public static final int ALPHA_REVERSE_SORT = 2;
    public static final int RANDOM_ORDER_JDT = 3;
    public static final int RANDOM_ORDER_TIME = 4;
    public static final int BYTECODE_DECLARATION_ORDER = 5;
    public static final long ORDERING;
    static final int MAX_GC = 5;
    static final int TIME_GC = 200;
    static final int DELTA_GC = 1000;
    public static final File MEM_LOG_FILE;
    public static final File MEM_LOG_DIR;
    public static Class CURRENT_CLASS;
    public static String CURRENT_CLASS_NAME;
    public static final String STORE_MEMORY;
    public static final boolean ALL_TESTS_LOG;
    public static final boolean RUN_GC;
    private static final NumberFormat DIGIT_FORMAT;
    private boolean first;
    protected boolean abortOnFailure = true;
    public static String TESTS_PREFIX;
    public static String[] TESTS_NAMES;
    public static int[] TESTS_NUMBERS;
    public static int[] TESTS_RANGE;

    static {
        int index;
        RUN_ONLY_ID = "ONLY_";
        long ordering = 0L;
        try {
            long seed = Long.parseLong(System.getProperty("ordering", "0"));
            try {
                int kind = Integer.parseInt(System.getProperty("ordering", "0"));
                switch (kind) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ordering = kind;
                        System.err.println("Note that tests will be run sorted using alphabetical order...");
                        break;
                    }
                    case 2: {
                        ordering = kind;
                        System.err.println("Note that tests will be run sorted using alphabetical reverse order...");
                        break;
                    }
                    case 3: {
                        String version = new Main(null, null, false, null, null).bind("compiler.version");
                        version = version.substring(0, version.indexOf(44));
                        try {
                            StringBuffer buffer = new StringBuffer();
                            int i = 0;
                            while (i < version.length()) {
                                if (Character.isDigit(version.charAt(i))) {
                                    buffer.append(version.charAt(i));
                                }
                                ++i;
                            }
                            ordering = Long.parseLong(buffer.toString());
                            System.err.println("Note that tests will be run in random order using seed=" + ordering + " (ie. JDT/Core version)");
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println("Cannot extract valid JDT/Core version number from 'compiler.version': " + version + " => no order will be finally used...");
                            ordering = 0L;
                        }
                        break;
                    }
                    case 4: {
                        ordering = System.currentTimeMillis();
                        System.err.println("Note that tests will be run in random order using seed=" + ordering + " (ie. current time)");
                        break;
                    }
                    case 5: {
                        ordering = kind;
                        System.err.println("Note that tests will be run in bytecode declaration order...");
                        break;
                    }
                    default: {
                        ordering = seed;
                        System.err.println("Note that tests will be run in random order using seed=" + seed + " (ie. given value)");
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                ordering = seed;
                System.err.println("Note that tests will be run in random order using seed=" + seed + " (ie. given value)");
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Only integer or long values are allowed for 'ordering' system property: " + System.getProperty("ordering", "0") + " is not valid ! => no order will be finally used...");
            ordering = 0L;
        }
        ORDERING = ordering;
        DIGIT_FORMAT = NumberFormat.getNumberInstance();
        String storeMemory = System.getProperty("storeMemory");
        boolean allTestsLog = false;
        boolean runGc = false;
        File memLogDir = new File(System.getProperty("user.home"));
        if (storeMemory != null && (index = storeMemory.indexOf(44)) > 0) {
            StringTokenizer parameters = new StringTokenizer(storeMemory.substring(storeMemory.indexOf(44) + 1), ",");
            while (parameters.hasMoreTokens()) {
                String param = parameters.nextToken();
                if ("all".equals(param)) {
                    allTestsLog = true;
                    continue;
                }
                if ("gc".equals(param)) {
                    runGc = true;
                    continue;
                }
                if (!param.startsWith("dir=")) continue;
                memLogDir = new File(param.substring(4));
            }
            storeMemory = storeMemory.substring(0, index);
        }
        STORE_MEMORY = storeMemory;
        ALL_TESTS_LOG = allTestsLog;
        RUN_GC = runGc;
        if (!TestCase.verifyLogDir(memLogDir)) {
            memLogDir = null;
        }
        MEM_LOG_DIR = memLogDir;
        MEM_LOG_FILE = TestCase.createMemLogFile();
        if (STORE_MEMORY != null && MEM_LOG_FILE != null) {
            System.out.println("Memory storage activated:");
            System.out.println("\tdata stored in file " + MEM_LOG_FILE);
            System.out.println("\tall tests log: " + ALL_TESTS_LOG);
            System.out.println("\tgc activated: " + RUN_GC);
        }
        DIGIT_FORMAT.setMinimumIntegerDigits(3);
        TESTS_PREFIX = null;
        TESTS_NAMES = null;
        TESTS_NUMBERS = null;
        TESTS_RANGE = null;
    }

    public TestCase(String name) {
        this.setName(name);
    }

    public static void assertEquals(String expected, String actual) {
        TestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, String expected, String actual) {
        TestCase.assertStringEquals(message, expected, actual, true);
    }

    public static void assertStringEquals(String expected, String actual, boolean showLineSeparators) {
        TestCase.assertStringEquals(null, expected, actual, showLineSeparators);
    }

    public static void assertStringEquals(String message, String expected, String actual, boolean showLineSeparators) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        StringBuffer formatted = message != null ? new StringBuffer(message).append('.') : new StringBuffer();
        if (showLineSeparators) {
            String expectedWithLineSeparators = TestCase.showLineSeparators(expected);
            String actualWithLineSeparators = TestCase.showLineSeparators(actual);
            formatted.append("\n----------- Expected ------------\n");
            formatted.append(expectedWithLineSeparators);
            formatted.append("\n------------ but was ------------\n");
            formatted.append(actualWithLineSeparators);
            formatted.append("\n--------- Difference is ----------\n");
            throw new ComparisonFailure(formatted.toString(), expectedWithLineSeparators, actualWithLineSeparators);
        }
        formatted.append("\n----------- Expected ------------\n");
        formatted.append(expected);
        formatted.append("\n------------ but was ------------\n");
        formatted.append(actual);
        formatted.append("\n--------- Difference is ----------\n");
        throw new ComparisonFailure(formatted.toString(), expected, actual);
    }

    protected void assumeEquals(String expected, String actual) {
        this.assumeEquals(null, expected, actual);
    }

    protected void assumeEquals(String msg, String expected, String actual) {
        try {
            TestCase.assertStringEquals(msg, expected, actual, false);
        }
        catch (ComparisonFailure cf) {
            System.out.println("Failure while running test " + Performance.getDefault().getDefaultScenarioId((junit.framework.TestCase)this) + "!!!");
            System.out.println("Actual output is:");
            System.out.println(Util.displayString(cf.getActual(), 2));
            System.out.println();
            System.out.println("Expected output is:");
            System.out.println(Util.displayString(cf.getExpected(), 2));
            System.out.println();
            if (this.abortOnFailure) {
                throw cf;
            }
        }
        catch (AssertionFailedError afe) {
            if (this.abortOnFailure) {
                throw afe;
            }
            this.printAssertionFailure(afe);
        }
    }

    protected void assumeEquals(String msg, int expected, int actual) {
        try {
            TestCase.assertEquals((String)msg, (int)expected, (int)actual);
        }
        catch (AssertionFailedError afe) {
            if (this.abortOnFailure) {
                throw afe;
            }
            this.printAssertionFailure(afe);
        }
    }

    protected void assumeEquals(String msg, long expected, long actual) {
        try {
            TestCase.assertEquals((String)msg, (long)expected, (long)actual);
        }
        catch (AssertionFailedError afe) {
            if (this.abortOnFailure) {
                throw afe;
            }
            this.printAssertionFailure(afe);
        }
    }

    protected void assumeTrue(String msg, boolean cond) {
        try {
            TestCase.assertTrue((String)msg, (boolean)cond);
        }
        catch (AssertionFailedError afe) {
            if (this.abortOnFailure) {
                throw afe;
            }
            this.printAssertionFailure(afe);
        }
    }

    private void printAssertionFailure(AssertionFailedError afe) {
        System.out.println("\n!---!!---!!---!!---!!---!!---!!---!!---!!---!!---!!---!!---!!---!!---!!---!!---!");
        System.out.println("Caught assertion failure while running test " + this.getName() + ":");
        System.out.println("\t" + afe.getMessage());
        System.out.println("--------------------------------------------------------------------------------\n");
    }

    public static List buildTestsList(Class evaluationTestClass) {
        return TestCase.buildTestsList(evaluationTestClass, 0, ORDERING);
    }

    public static List buildTestsList(Class evaluationTestClass, int inheritedDepth) {
        return TestCase.buildTestsList(evaluationTestClass, inheritedDepth, ORDERING);
    }

    public static List buildTestsList(Class evaluationTestClass, int inheritedDepth, long ordering) {
        List<String> names;
        ArrayList tests = new ArrayList();
        ArrayList<String> testNames = new ArrayList<String>();
        ArrayList<String> onlyNames = new ArrayList<String>();
        Constructor constructor = null;
        try {
            Class[] paramTypes = new Class[]{String.class};
            constructor = evaluationTestClass.getConstructor(paramTypes);
        }
        catch (Exception exception) {
            return tests;
        }
        Method[] methods = evaluationTestClass.getDeclaredMethods();
        Class evaluationTestSuperclass = evaluationTestClass.getSuperclass();
        int i = 0;
        while (i < inheritedDepth && !Flags.isAbstract((int)evaluationTestSuperclass.getModifiers())) {
            Method[] superMethods = evaluationTestSuperclass.getDeclaredMethods();
            Method[] mergedMethods = new Method[methods.length + superMethods.length];
            System.arraycopy(superMethods, 0, mergedMethods, 0, superMethods.length);
            System.arraycopy(methods, 0, mergedMethods, superMethods.length, methods.length);
            methods = mergedMethods;
            evaluationTestSuperclass = evaluationTestSuperclass.getSuperclass();
            ++i;
        }
        int methodPrefixLength = METHOD_PREFIX.length();
        int m = 0;
        int max = methods.length;
        while (m < max) {
            block40: {
                String methName;
                int modifiers = methods[m].getModifiers();
                if (Flags.isPublic((int)modifiers) && !Flags.isStatic((int)modifiers) && (methName = methods[m].getName()).startsWith(METHOD_PREFIX)) {
                    boolean isOnly;
                    boolean bl = isOnly = RUN_ONLY_ID != null && methName.substring(methodPrefixLength).startsWith(RUN_ONLY_ID);
                    if (isOnly) {
                        if (!onlyNames.contains(methName)) {
                            onlyNames.add(methName);
                        }
                    } else if (TESTS_PREFIX == null && TESTS_NAMES == null && TESTS_NUMBERS == null && TESTS_RANGE == null) {
                        if (!testNames.contains(methName)) {
                            testNames.add(methName);
                        }
                    } else if (TESTS_PREFIX == null || methName.startsWith(TESTS_PREFIX)) {
                        block41: {
                            int length;
                            int numStart;
                            int n = numStart = TESTS_PREFIX == null ? methodPrefixLength : TESTS_PREFIX.length();
                            if (TESTS_NAMES != null) {
                                int i2 = 0;
                                int imax = TESTS_NAMES.length;
                                while (i2 < imax) {
                                    if (methName.indexOf(TESTS_NAMES[i2]) >= 0) {
                                        if (!testNames.contains(methName)) {
                                            testNames.add(methName);
                                        }
                                        break block40;
                                    }
                                    ++i2;
                                }
                            }
                            if (numStart < (length = methName.length())) {
                                while (numStart < length && !Character.isDigit(methName.charAt(numStart))) {
                                    ++numStart;
                                }
                                while (numStart < length && methName.charAt(numStart) == '0') {
                                    ++numStart;
                                }
                                int n2 = numStart;
                                while (n2 < length && Character.isDigit(methName.charAt(n2))) {
                                    ++n2;
                                }
                                if (n2 > numStart && n2 <= length) {
                                    try {
                                        int num = Integer.parseInt(methName.substring(numStart, n2));
                                        if (TESTS_NUMBERS != null && !testNames.contains(methName)) {
                                            int i3 = 0;
                                            while (i3 < TESTS_NUMBERS.length) {
                                                if (TESTS_NUMBERS[i3] == num) {
                                                    testNames.add(methName);
                                                    break block40;
                                                }
                                                ++i3;
                                            }
                                        }
                                        if (TESTS_RANGE == null || TESTS_RANGE.length != 2 || testNames.contains(methName) || TESTS_RANGE[0] != -1 && num < TESTS_RANGE[0] || TESTS_RANGE[1] != -1 && num > TESTS_RANGE[1]) break block41;
                                        testNames.add(methName);
                                        break block40;
                                    }
                                    catch (NumberFormatException e) {
                                        System.out.println("Method " + methods[m] + " has an invalid number format: " + e.getMessage());
                                    }
                                }
                            }
                        }
                        if (TESTS_NAMES == null && TESTS_NUMBERS == null && TESTS_RANGE == null && !testNames.contains(methName)) {
                            testNames.add(methName);
                        }
                    }
                }
            }
            ++m;
        }
        ArrayList<String> arrayList = names = onlyNames.size() > 0 ? onlyNames : testNames;
        if (ordering == 2L) {
            Collections.sort(names, Collections.reverseOrder());
        } else if (ordering == 1L) {
            Collections.sort(names);
        } else if (ordering == 5L) {
            try {
                List bytecodeOrderedTestNames = OrderedTestSuite.getBytecodeOrderedTestNames((Class)evaluationTestClass);
                bytecodeOrderedTestNames.retainAll(names);
                if (bytecodeOrderedTestNames.size() != names.size()) {
                    System.err.println("not all test names found in bytecode: " + evaluationTestClass.getName());
                }
                names = bytecodeOrderedTestNames;
            }
            catch (IOException iOException) {
                System.err.println("suite failed to detect test order: " + evaluationTestClass.getName());
            }
        } else if (ordering != 0L) {
            Collections.shuffle(names, new Random(ordering));
        }
        for (String testName : names) {
            try {
                tests.add(constructor.newInstance(testName));
            }
            catch (Exception e) {
                System.err.println("Method " + testName + " removed from suite due to exception: " + e.getMessage());
            }
        }
        return tests;
    }

    public static Test buildTestSuite(Class evaluationTestClass) {
        return TestCase.buildTestSuite(evaluationTestClass, null);
    }

    public static Test buildTestSuite(Class evaluationTestClass, String suiteName) {
        TestSuite suite = new TestSuite(suiteName == null ? evaluationTestClass.getName() : suiteName);
        List tests = TestCase.buildTestsList(evaluationTestClass);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            suite.addTest((Test)tests.get(index));
            ++index;
        }
        return suite;
    }

    private static File createMemLogFile() {
        if (STORE_MEMORY == null || MEM_LOG_DIR == null) {
            return null;
        }
        File logFile = new File(MEM_LOG_DIR, String.valueOf(STORE_MEMORY) + ".log");
        try (PrintStream stream = null;){
            boolean fileExist = logFile.exists();
            stream = new PrintStream(new FileOutputStream(logFile, true));
            if (fileExist) {
                stream.println();
            }
            Date date = new Date(System.currentTimeMillis());
            stream.println("Tests:\t" + STORE_MEMORY);
            stream.println("Date:\t" + DateFormat.getDateInstance(3).format(date));
            stream.println("Time:\t" + DateFormat.getTimeInstance(3).format(date));
            stream.print("Class");
            if (ALL_TESTS_LOG) {
                stream.print("\tTest");
            }
            stream.print("\tUsed\tTotal\tMax");
            stream.println();
            System.out.println("Log file " + logFile.getPath() + " opened.");
            File file = logFile;
            return file;
        }
        return null;
    }

    protected static String showLineSeparators(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int length = string.length();
        int i = 0;
        while (i < length) {
            char car = string.charAt(i);
            switch (car) {
                case '\n': {
                    buffer.append("\\n\n");
                    break;
                }
                case '\r': {
                    if (i < length - 1 && string.charAt(i + 1) == '\n') {
                        buffer.append("\\r\\n\n");
                        ++i;
                        break;
                    }
                    buffer.append("\\r\n");
                    break;
                }
                default: {
                    buffer.append(car);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static boolean verifyLogDir(File logDir) {
        if (logDir.exists()) {
            if (logDir.isDirectory()) {
                return true;
            }
            System.err.println(logDir + " is not a valid directory. Log files will NOT be written!");
        } else {
            if (logDir.mkdir()) {
                return true;
            }
            System.err.println("Cannot create " + logDir + " as its parent does not exist. Log files will NOT be written!");
        }
        return false;
    }

    public void assertPerformance() {
        super.assertPerformance();
    }

    protected void clean() {
        int iterations = 0;
        long delta = 0L;
        long free = 0L;
        int i = 0;
        while (i < 5) {
            free = Runtime.getRuntime().freeMemory();
            System.gc();
            delta = Runtime.getRuntime().freeMemory() - free;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (iterations == 5 && delta > 1000L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void commitMeasurements() {
        super.commitMeasurements();
    }

    protected boolean isFirst() {
        return this.first;
    }

    protected void setUp() throws Exception {
        boolean isFirstTestRun;
        if (JavaCore.getPlugin() != null) {
            Indexer.getInstance().enableAutomaticIndexing(false);
        }
        super.setUp();
        this.first = false;
        boolean bl = isFirstTestRun = CURRENT_CLASS == null;
        if (isFirstTestRun || CURRENT_CLASS != ((Object)((Object)this)).getClass()) {
            if (CURRENT_CLASS != null && RUN_GC) {
                this.clean();
            }
            CURRENT_CLASS = ((Object)((Object)this)).getClass();
            this.first = true;
            CURRENT_CLASS_NAME = ((Object)((Object)this)).getClass().getName();
            CURRENT_CLASS_NAME = CURRENT_CLASS_NAME.substring(CURRENT_CLASS_NAME.indexOf(".tests.") + 7, CURRENT_CLASS_NAME.length());
        }
        if (STORE_MEMORY != null && MEM_LOG_FILE != null) {
            if (isFirstTestRun) {
                this.clean();
            }
            if (ALL_TESTS_LOG && MEM_LOG_FILE.exists()) {
                PrintStream stream = new PrintStream(new FileOutputStream(MEM_LOG_FILE, true));
                stream.print(CURRENT_CLASS_NAME);
                stream.print('\t');
                String testName = this.getName();
                stream.print(testName);
                stream.print('\t');
                long total = Runtime.getRuntime().totalMemory();
                long used = total - Runtime.getRuntime().freeMemory();
                stream.print(this.format(used));
                stream.print('\t');
                stream.print(this.format(total));
                stream.print('\t');
                stream.print(this.format(Runtime.getRuntime().maxMemory()));
                stream.println();
                stream.close();
                if (isFirstTestRun) {
                    System.out.println("\t" + this.format(used));
                }
            } else if (isFirstTestRun) {
                long total = Runtime.getRuntime().totalMemory();
                long used = total - Runtime.getRuntime().freeMemory();
                System.out.println("\talready used while starting: " + this.format(used));
            }
        }
    }

    private String format(long number) {
        long n;
        long q = n = number;
        int[] values = new int[10];
        int m = -1;
        while ((n = q) > 0L) {
            q = n / 1000L;
            values[++m] = (int)(n - q * 1000L);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(values[m]);
        int i = m - 1;
        while (i >= 0) {
            buffer.append(',').append(DIGIT_FORMAT.format(values[i]));
            --i;
        }
        return buffer.toString();
    }

    public static Test setUpTest(Test test) throws Exception {
        Field field = PerformanceMeterFactory.class.getDeclaredField("fScenarios");
        field.setAccessible(true);
        Set set = (Set)field.get(null);
        set.clear();
        return test;
    }

    public void startMeasuring() {
        super.startMeasuring();
    }

    public void stopMeasuring() {
        super.stopMeasuring();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (JavaCore.getPlugin() != null) {
            Indexer.getInstance().enableAutomaticIndexing(true);
        }
        if (STORE_MEMORY != null && MEM_LOG_FILE != null && (this.first || ALL_TESTS_LOG) && MEM_LOG_FILE.exists()) {
            PrintStream stream = new PrintStream(new FileOutputStream(MEM_LOG_FILE, true));
            stream.print(CURRENT_CLASS_NAME);
            stream.print('\t');
            if (ALL_TESTS_LOG) {
                String testName = this.getName();
                String str = "";
                int length = testName.length() - 4;
                int i = 0;
                while (i < length) {
                    str = String.valueOf(str) + '.';
                    ++i;
                }
                stream.print(str);
                stream.print("end:");
                stream.print('\t');
            }
            long total = Runtime.getRuntime().totalMemory();
            long used = total - Runtime.getRuntime().freeMemory();
            stream.print(this.format(used));
            stream.print('\t');
            stream.print(this.format(total));
            stream.print('\t');
            stream.print(this.format(Runtime.getRuntime().maxMemory()));
            stream.println();
            stream.close();
        }
    }

    public static void assertSame(int expected, int actual) {
        TestCase.assertSame(null, expected, actual);
    }

    public static void assertSame(String message, int expected, int actual) {
        if (expected == actual) {
            return;
        }
        TestCase.failNotSame(message, expected, actual);
    }

    public static void failNotSame(String message, int expected, int actual) {
        StringBuffer formatted = new StringBuffer();
        if (message != null) {
            formatted.append(message).append(' ');
        }
        formatted.append("expected same:<").append(expected).append("> was not:<").append(actual).append(">");
        TestCase.fail((String)String.valueOf(formatted));
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        finally {
            Thread.interrupted();
        }
    }

    public static void resetForgottenFilters(List<Class<?>> testClasses) {
        for (Class<?> clazz : testClasses) {
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        TESTS_PREFIX = null;
        TESTS_NAMES = null;
        TESTS_NUMBERS = null;
        TESTS_RANGE = null;
        RUN_ONLY_ID = null;
    }
}

